package provide app-command 1.0

# defind procs isalive and kill for back compatibility with CompassFEM bat that use them (were commands defined in C inside the old command.exe of mktclapp)
proc isalive { pid } {
  package require gid_cross_platform
  return [gid_cross_platform::process_exists $pid]
}

proc kill { pid } {
  package require gid_cross_platform
  return [gid_cross_platform::end_process $pid]
}


proc Cmdputsd { text } {
    global DEBUG
    if { !$DEBUG } { return }
    # puts $text\n
    set DEBUGFOUT [open [file join $::env(TMP) gid_command.log] a]
    fconfigure $DEBUGFOUT -encoding utf-8
    puts $DEBUGFOUT $text\n
    close $DEBUGFOUT
}

proc CmdErrorAndQuit { text } {
    CmdErrorNoQuit $text
    exit 2
}

proc OutputInProgramErrorFile { txt } {
    global ProgramErrorFile
    if { $ProgramErrorFile != "" } {
        catch {
            set fout [open $ProgramErrorFile a]
            fconfigure $fout -encoding utf-8
            puts $fout $txt
            close $fout
            Cmdputsd "filled $ProgramErrorFile"
        }
    }
}

proc CmdErrorNoQuit { text } {
    global NumLine DEBUG ProgramErrorFile
	Cmdputsd "error: $text"

    if { $DEBUG } {
        set DEBUGFOUT [open  [file join $::env(TMP) gid_command.err] a]
        fconfigure $DEBUGFOUT -encoding utf-8
    }    
    catch { package require Tk } ;#to show a tk_messageBox with the error
    if { !$NumLine } {        
        if { [info commands wm] != "" } {
            wm withdraw .
            tk_messageBox -icon error -title [_ "error in .bat file"] -type ok \
                    -message "$text"
        } elseif { $DEBUG } {
            puts $text\n
            puts $DEBUGFOUT $text\n
        } else {
            puts $text\n
        }
        OutputInProgramErrorFile "error in .bat file: \n$text\n"
    } else {
        if { [info commands wm] != "" } {
            wm withdraw .
            tk_messageBox -icon error -title [_ "error in .bat file"] -type ok \
                    -message "line: $NumLine.- $text"
        } elseif { $DEBUG } {
            puts "line: $NumLine.- $text\n"
            puts $DEBUGFOUT "line: $NumLine.- $text\n"
        } else {
            puts "line: $NumLine.- $text\n"
        }
        OutputInProgramErrorFile "error in .bat file: \nline: $NumLine.- $text\n"
    }
    if { $DEBUG } {
        close $DEBUGFOUT
    }
}

proc CmdWarnWin {text} {
    global NumLine
    tk_messageBox -icon error -title [_ "error in .bat file"] -type ok \
            -message "line: $NumLine.- $text"
}

proc CmdEraseElement { inum } {
    global line linelen

   for { set i [expr $inum+1] } { $i < $linelen } { incr i } {
        set iprev [expr $i-1]
        set line($iprev) $line($i)
    }
    incr linelen -1
}

proc CmdCommandExecuter { inum fbat } {
    global errorCode arv0 env
    global line linelen ProgramErrorFile
    global param

    set retval ""
    set cmdinum $line($inum)
    switch -- [string tolower $line($inum)] {
        rem {
            if { [info exists line([expr $inum+1])] && [info exists line([expr $inum+2])] && \
                    [string tolower $line([expr $inum+1])] == "errorfile:" } {
                set ProgramErrorFile [file join $line([expr $inum+2])]
                Cmdputsd ProgramErrorFile=$ProgramErrorFile
            }
            # nothing
        }
        cd - chdir {
            set dir ""
            incr inum
            if { $inum < $linelen } {
                set dir $line($inum)
            }
            if { [catch {
                regsub -all {\\} $dir {/} dir
                set dir [lindex $dir 0]
                cd $dir
            } ] } {
                CmdErrorAndQuit "error: trying to change directory to '$dir'"
            }
        }
        del - delete - erase {
            incr inum
            for { set i $inum } { $i < $linelen } { incr i } {
                set filename $line($i)
                if { [string match /* $filename] } { continue }
                catch {
                    regsub -all {\\} $filename {/} filename
                    set filename [lindex $filename 0]
                    file delete -force $filename
                }
            }
        }
        copy {
            incr inum
            set filename1 ""
            set filename2 ""
            set filestoadd ""
            set addnextfile 0
            for { set i $inum } { $i < $linelen } { incr i } {
                set filename $line($i)
                if { [string match /* $filename] } { continue }
                regsub -all {\\} $filename {/} filename
                set filename [lindex $filename 0]
                if { $filename == "+" } {
                    set addnextfile 1
                } elseif { $addnextfile } {
                    lappend filestoadd $filename
                    set addnextfile 0
                } elseif { $filename1 == "" } {
                    set filename1 $filename
                } elseif { $filename2 == "" }  {
                    set filename2 $filename
                } else {
                    CmdErrorAndQuit "error in copy func"
                }
            }
            if { $filename2 == "" } {
                CmdErrorAndQuit "error in copy func (2)"
            }
            catch {
                #file copy -force $filename1 $filename2
                if {  [file tail $filename1] == "*.*" } {
                    #change "c:/a/b/*.*" by "c:/a/b/*" (wild card MSDos style)
                    set filename1 [file rootname $filename1]
                }
                file copy -force {*}[glob $filename1] $filename2
                if { $filestoadd != "" } {
                    set fout [open $filename2 ab]
                    foreach i $filestoadd {
                        set fin [open $i rb]
                        puts -nonewline $fout [read $fin]
                        close $fin
                    }
                    close $fout
                }
            }
        }
        ren - rename - move {
            if { [expr $linelen-$inum] != 3 } {
                CmdErrorAndQuit "error: $line($inum) needs two arguments"
            }
            incr inum
            set filename1 ""
            set filename2 ""
            for { set i $inum } { $i < $linelen } { incr i } {
                set filename $line($i)
                if { [string match /* $filename] } { continue }
                regsub -all {\\} $filename {/} filename
                set filename [lindex $filename 0]
                if { $filename1 == "" } {
                    set filename1 $filename
                } else {
                    set filename2 $filename
                    break
                }
            }
            catch {
                file rename -force $filename1 $filename2
            }
        }
        md - mkdir {
            incr inum
            for { set i $inum } { $i < $linelen } { incr i } {
                set filename $line($i)
                if { [string match /* $filename] } { continue }
                regsub -all {\\} $filename {/} filename
                set filename [lindex $filename 0]
                catch {
                    file mkdir $line($i)
                }
            }
        }
        set {
            incr inum
            set execline ""
            for { set i $inum } { $i < $linelen } { incr i } {
                append execline $line($i)
                if { $inum < [expr $linelen-1] } {
                    append execline " "
                }
            }
            if { [regexp {^[ ]*$} $execline] } { break }
            set var ""
            set value ""
            if { [regexp {([^=]*)=(.*)} $execline {} var value] } {
                if { $var != "" } {
                    set var [string trim $var " \""]
                    set value [string trim $value " \""]
                    set env($var) $value
                }
            }

        }
        echo {
            incr inum
            if { [expr $linelen-$inum] == 1 && ( [string tolower $line($inum)] == "on" || \
                    [string tolower $line($inum)] == "off") } {
            } else {
                set type ""
                for { set i [expr $linelen-1] } { $i >= $inum } { incr i -1} {
                    set item $line($i)
                    if { ![regexp {^[\"]} $item] } {
                        if { [string match *>* $item] } {
                            regexp {^([^>]*)(>>?)(.*)} $item {} before sign after
                            set ifile [expr $i+1]
                            if { $before == "" } {
                                CmdEraseElement $i
                                incr ifile -1
                            } else {
                                set line($i) $before
                            }
                            if { $after == "" } {
                                if { $ifile == $linelen } {
                                    CmdErrorAndQuit [_ "error: in echo command after > or >> need filename"]
                                }
                                set after $line($ifile)
                                CmdEraseElement $ifile
                            }
                            if { $type == "" } {
                                if { $sign == ">" } {
                                    set type w
                                } else {
                                    set type a
                                }
                                set filename $after
                            }
                        }
                    }
                }
                if { $type == "" } {
                    for { set i $inum } { $i < $linelen } { incr i } {
                        puts -nonewline $line($i)
                        if { $i < [expr $linelen-1] } {
                            puts -nonewline " "
                        } else { puts "" }
                    }
                } else {
                    regsub -all {\\} $filename {/} filename
                    set filename [lindex $filename 0]
                    if { [catch { set fout [open $filename $type] } err] } {
                        CmdErrorAndQuit "error ($err): trying to echo to file '$filename'"
                    }
                    fconfigure $fout -encoding utf-8
                    for { set i $inum } { $i < $linelen } { incr i } {
                        puts -nonewline $fout $line($i)
                        if { $i < [expr $linelen-1] } {
                            puts -nonewline $fout " "
                        } else { 
                            puts $fout "" 
                        }
                    }
                    close $fout
                }
            }
        }
        "if" {
            incr inum
            set negate 0
            if { [string tolower $line($inum)] == "not" } {
                set negate 1
                incr inum
            }
            set val 0
            set ifpos [string tolower $line($inum)]
            if { [regexp {^([^ ]+)[ ]*==[ ]*([^ ]+)} $ifpos {} caden1 caden2] } {
                set val [expr [string compare $caden1 $caden2] == 0]
                incr inum
            } elseif { $line([expr $inum+1]) == "=="  } {
                set caden1 $ifpos
                if { [expr $inum+1] >= $linelen } {
                    CmdErrorAndQuit "error: expression 'if c1 == c2' not correct"
                }
                set caden2 [string tolower $line([expr $inum+2])]
                set val [expr [string compare $caden1 $caden2] == 0]
                set inum [expr $inum+3]
            } elseif { $ifpos == "errorlevel" } {
                incr inum
                set number $line($inum)
                if { [catch { expr int($number) }] } {
                    CmdErrorAndQuit "error: after 'if errorlevel' one number is needed"
                }
                set errorlevel 0
                if { [lindex $errorCode 0] == "CHILDSTATUS" } {
                    set errorlevel [lindex $errorCode 2]
                }
                set val [expr $errorlevel>=$number]
                incr inum
            } elseif { $ifpos == "exist" } {
                incr inum
                set filename $line($inum)
                regsub -all {\\} $filename {/} filename
                set filename [lindex $filename 0]
                set val [file exists $filename]
                incr inum
            } else {
                CmdErrorAndQuit "Unknown condition for 'if' command: '$ifpos'"
            }
            if { $negate } { set val [expr !$val] }
            if { $val } {
                set retval [CmdCommandExecuter $inum $fbat]
            }
        }
        call {
            incr inum
            set errorCode NONE
            set execline ""
            for { set i $inum } { $i < $linelen } { incr i } {
                append execline $line($i)
                if { $inum < [expr $linelen-1] } {
                    append execline " "
                }
            }
            regsub -all {\\} $execline {\\\\} execline
            global RunningProcess
            set RunningProcess running
            if { [catch { set pid [eval exec $execline &] } errorchar] } {
                  if { [lindex $errorCode 0] != "CHILDSTATUS" } {
                      CmdErrorAndQuit "error: $errorchar "
                  }
            }
            while 1 {
                if { $RunningProcess == "" } {
                    #taskkill kill all childs (e.g killing a batch kill also its invoked processes)
                    #available for Microsoft Windows XP professional or Windows 2003, Vista and 7 
                    #non available for Windows XP home edition (will need tskill. tskill kill also childs??)
                    # tskill $pid
                    if { [file exists [file join $::env(WINDIR) SYSTEM32 taskkill.exe]] } {
                        exec taskkill /t /f /pid $pid
                    } else {
                        gid_cross_platform::end_process $pid
                    }                   
                    vwait forever
                }
                if { ![gid_cross_platform::process_exists $pid] } { break }
                after 200
                update
            }
            unset RunningProcess
        }
        goto {
            incr inum
            return $line($inum)
        }

        type {
            incr inum
            set filename ""
            set type ""
            for { set i [expr $linelen-1] } { $i >= $inum } { incr i -1} {
                set item $line($i)
                if { ![regexp {^[\"]} $item] } {
                    if { [string match *>* $item] } {
                        regexp {^([^>]*)(>>?)(.*)} $item {} before sign after
                        set ifile [expr $i+1]
                        if { $before == "" } {
                            CmdEraseElement $i
                            incr ifile -1
                        } else {
                            set line($i) $before
                        }
                        if { $after == "" } {
                            if { $ifile == $linelen } {
                                CmdErrorAndQuit [_ "error: in %s command after > or >> need filename" $cmdinum]
                            }
                            set after $line($ifile)
                            CmdEraseElement $ifile
                        }
                        if { $type == "" } {
                            if { $sign == ">" } {
                                set type w
                            } else {
                                set type a
                            }
                            set filename $after
                        }
                    }
                }
            }
            if { $type != "" } {
               if { $filename != "" } {
                   regsub -all {\\} $filename {/} filename
                   set filename [lindex $filename 0]
                   set filesource $line($inum)
                   regsub -all {\\} $filesource {/} filesource
                   set filesource [lindex $filesource 0]
                   if { ![file exists $filesource]  } {
                       CmdErrorAndQuit [_ "Error: in %1\$s command, source file %2\$s not exist" $cmdinum $filesource]
                   } else {
                       if { $type == "w" || ![file exists $filename] } {
                           file copy -force $filesource $filename
                       } elseif {  $type == "a" } {
                           set fout [open $filename ab]
                           set fin [open $filesource rb]
                           puts -nonewline $fout [read $fin]
                           close $fin
                           close $fout
                       }
                   }
               } else {
                   CmdErrorAndQuit [_ "error: in %s command after > or >> need filename" $cmdinum]
               }
            }
        }
        
        shift {
            incr inum
            set i 1
            while { [info exists param($i)] } {
                set param([expr $i-1]) $param($i)
                incr i
            }
            unset param([expr $i-1])
        }
        tcl {
            set script ""
            incr inum
            for {} { $inum < $linelen } { incr inum } {
                append script " $line($inum)"
            }
            append script \n[read $fbat]
            set err [catch { uplevel \#0 $script } errstring]
            if { $err } {
                OutputInProgramErrorFile "error in .bat file: \n$errstring\n"
            }
            return ""
        }
        default {
            set errorCode NONE
            set execline ""
            for { set i $inum } { $i < $linelen } { incr i } {
                append execline $line($i)
                if { $inum < [expr $linelen-1] } {
                    append execline " "
                }
            }
            regsub -all {\\} $execline {\\\\} execline
            global RunningProcess
            set RunningProcess running
        
            Cmdputsd execline=--$execline--
        
            if { [catch { set pid [eval exec $execline &] } errorchar] } {
                  if { [lindex $errorCode 0] != "CHILDSTATUS" } {
                      CmdErrorAndQuit "error: $errorchar "
                  }
            }
            while 1 {
                if { $RunningProcess == "" } {
                    Cmdputsd "Before killing..."
                    #taskkill kill all childs (e.g killing a batch kill also its invoked processes)
                    #available for Microsoft Windows XP professional or Windows 2003, Vista and 7 
                    #non available for Windows XP home edition (will need tskill. tskill kill also childs??)
                    # tskill $pid                   
                    if { [file exists [file join $::env(WINDIR) SYSTEM32 taskkill.exe]] } {
                        exec taskkill /t /f /pid $pid
                    } else {
                        gid_cross_platform::end_process $pid
                    }
                    Cmdputsd "after killing"
                    vwait forever
                }
                if { ![gid_cross_platform::process_exists $pid] } { break }
                after 100
                update
            }
            Cmdputsd "after finishing"
            unset RunningProcess
        }
    }
    return $retval
}

proc isDynamicVariable { varname} {
    # ERRORLEVEL should be there too, but don't know how to get status of last executed command
    # from https://ss64.com/nt/syntax-variables.html
    # missing are also HighestNumaNodeNumber and CMDEXTVERSION
    set lst_vars [ list CD CMDCMDLINE DATE RANDOM TIME]
    set found 0
    if { [ lsearch $lst_vars $varname] != -1} {
        set found 1
    }
    return $found
}

proc getDynamicVariable { varname} {
    # ERRORLEVEL should be there too, but don't know how to get status of last executed command
    # from https://ss64.com/nt/syntax-variables.html
    # missing are also HighestNumaNodeNumber and CMDEXTVERSION
    set lst_vars [ list CD CMDCMDLINE DATE RANDOM TIME]
    set value ""
    switch [ string toupper $varname] {
        CD {
            set value [file nativename [pwd]]
        }
        CMDCMDLINE {
            set value "$::argv0 $::argv"
        }
        DATE {
            # spanish: 22/10/2021
            # us : 2021-10-22
            set value [ clock format [ clock seconds] -format "%Y-%m-%d"]
        }
        RANDOM {
            # 0 <= %RANDOM% <= 32767
            set value [ expr int( 32768 * rand())]
        }
        TIME {
            # spanish: 10:00:44,24
            # us : 10:00:44.24
            set current_time [ clock milliseconds]
            set seconds [ expr int( $current_time / 1000)]
            set cents_seconds [ expr int( ( $current_time % 1000) / 100)]
            set value [ clock format $seconds -format "%H:%M:%S"].[ format %02d $cents_seconds]
        }
    }
    return $value
}

proc CmdReadAndExecute { fbat } {
    global NumLine rargc rargv
    global line linelen
    global env
    global param

    for { set i 0 } { $i < $rargc } { incr i } {
        set param($i) [lindex $rargv $i]
        catch { set param($i) [file native [file attributes $param($i) -shortname]] } aa
    }
    catch { unset labels }
    while { ![eof $fbat] } {
        gets $fbat aa
        Cmdputsd "executing:   $aa"
        incr NumLine
        if { [regexp {^[ ]*$} $aa] } { continue }
        if { [regexp {^[ ]*:[ ]*([^ ]+)} $aa {} label] } {
            set label [string tolower $label]
            set labels($label) [tell $fbat]
            continue
        }

    # if the line starts with '@' get rid of it
    # by default cmd always echoes the command to be executed in the bat file
    # '@' is used to not print the command to be executed
    # this command.tcl does not print the command to be executed
    # so the '@' prefix is superfuous
    if { [ regexp {^[ ]*@(.*)$} $aa dummy valid_line] == 1} {
        set aa $valid_line
    }

        set word ""
        set linelen 0
        catch { unset line }
        set thereisspace 0
        set openpar 0
        for { set i 0 } { $i < [string length $aa] } { incr i } {
            set l [string index $aa $i]
            if { $l == "\"" } {
                if { $openpar } {
                    append word "\""
                    set line($linelen) $word
                    incr linelen
                    set word ""
                    set thereisspace 0
                    set openpar 0
                } elseif { $word == "" } {
                    set openpar 1
                    set word "\""
                } else {
                    append word "\""
                }
            } elseif { !$openpar && ($l == " " || $l == "\t" || \
                    ($l == "+" && [regexp -nocase {copy} $aa] ) \
                    ) } {
                if { $word != "" } {
                    if { $thereisspace && [string index $word 0] != "\"" } {
                        set word "\"$word"
                    }
                    set last [expr [string length $word]-1]
                    if { $thereisspace && [string index $word $last] != "\"" } {
                        append word "\""
                    }
                    set line($linelen) $word
                    incr linelen
                    set word ""
                    set thereisspace 0
                }
                if { $l == "+" } {
                    set line($linelen) +
                    incr linelen
                }
            } else {
                if { $l == "%" } {
                    incr i
                    set l [string index $aa $i]
                    switch -- $l {
                        0 - 1 - 2 - 3 - 4 - 5 - 6 - 7 - 8 - 9 {
                            if { [info exists param($l)] } {
                                if { [llength $param($l)] > 1 } { set thereisspace 1 }
                                append word $param($l)
                            }
                        }
                        default {
                            if { [regexp {^([a-zA-Z_0-9]+)%} [string range $aa $i end] {} varname] } {
                                if { [info exists env($varname)] } {
                                    if { [llength $env($varname)] > 1 } { set thereisspace 1 }
                                    append word $env($varname)
                                    incr i [string length $varname]
                                } elseif { [ isDynamicVariable $varname]} {
                            set varvalue [ getDynamicVariable $varname]
                                    if { [ llength $varvalue] > 1 } { set thereisspace 1 }
                                    append word $varvalue
                                    incr i [string length $varname]
                        } else {
                                    if { [string tolower $line(0)] == "rem" } {
                                      incr i -1
                                      set comment [string range $aa $i end]
                                      append word $comment
                                      incr i [string length $comment]
                                    } else {
                                        CmdErrorAndQuit "Error: variable '$varname' not known"
                                    }
                                }
                            } else {
                                incr i -1
                            }
                        }
                    }
                } else {
                    append word $l
                }
            }
        }
        if { $word != "" } {
            if { $thereisspace && [string index $word 0] != "\"" } {
                set word "\"$word"
            }
            set last [expr [string length $word]-1]
            if { $thereisspace && [string index $word $last] != "\"" } {
                append word "\""
            }
            set line($linelen) $word
            incr linelen
        }
        set retval [CmdCommandExecuter 0 $fbat]
        if { $retval != "" } {
            set retval [string tolower $retval]
            if { $retval == ":eof" } { break }
            if { [info exists labels($retval)] } {
                fseek $fbat $labels($retval)
            } else {
                while { ![eof $fbat] } {
                    gets $fbat aa
                    incr NumLine
                    set label ""
                    if { [regexp {^[ ]*:[ ]*([^ ]+)} $aa {} label] } {
                        set label [string tolower $label]
                        set labels($label) [tell $fbat]
                    }
                    if { $retval == $label } { break }
                }
                if { $retval != $label } {
                    CmdErrorAndQuit "error: label for goto not found '$retval'"
                }
            }
        }
    }
}


proc CmdExitReal {} {
    Cmdputsd "exit real"
    exit
}

proc Exit { args } {
    global RunningProcess

    Cmdputsd "exiting..."
    if { [info exists RunningProcess] } {
        set RunningProcess {}
    }
    after 400 CmdExitReal
    return "goodbye"
}

############## End of Procedure definitions

if { [info commands _] eq "" } {
    package require msgcat
    proc _ { args } { return [eval msgcat::mc $args] }
}

if { [info commands bgerror] == "" } {
    proc bgerror { text } {
        CmdErrorAndQuit $text
    }
}


if { [lindex $argv 0] eq "-tcltk" } {
    source [lindex $argv 1]
    exit
} elseif { [lindex $argv 0] eq "-tcl_eval" } {
    eval [lindex $argv 1]
    exit
}

if { [info commands wm] != "" } {
    wm withdraw .
}

set NumLine 0
set errorCode NONE
set DEBUG 0
set ProgramErrorFile ""

#argv0 in command.tcl of tclkit is something like "C:/gid project/command.exe/main.tcl" , remove the last "/main.tcl" to be "C:/gid project/command.exe"
set argv0 [file dirname $argv0]
Cmdputsd encoding=[encoding system]
Cmdputsd argv0=$argv0
set i 1
foreach j $argv {
    Cmdputsd "argv $i=$j"
    incr i
}


if { $argc < 4 } {
    CmdErrorAndQuit [_ "error; usage: %s file.bat basename projectdirectory problemtypedirectory " $argv0]
}

#load tcldde12.dll dde
if { [catch { package require dde } msg] } {
    CmdErrorAndQuit "error: $msg"
} else {
    dde servername [pid]
}

package require gid_cross_platform

#trick to avoid the first /c argument provided by GiD to be like the cmd.exe case
set rargc 0
set rargv ""
foreach item $argv {
    if { ![regexp {^/[a-zA-Z]$} $item] } {
        incr rargc
        lappend rargv $item
    }
}

set i 1
foreach j $rargv {
    Cmdputsd "rargv $i=$j"
    incr i
}


set filename [lindex $rargv 0]
if { [catch {
    set fbat [open $filename r]
    fconfigure $fbat -encoding utf-8
}] }  {
    CmdErrorAndQuit "error: filename '$filename' does not exist"
}

#set rargv [lrange $argv 1 end]

CmdReadAndExecute $fbat
CmdExitReal

