set ::PCResultsPriv(HorizontalLayout) 1
set ::PCGraphsPriv(HorizontalLayout) 1

#trick: GiD post use this special value when result is not defined
proc GetResultNotDefined { } {
    return -3.40282346638528860e+38
}

proc IsResultNotDefined { value } {
    if { $value==-3.40282346638528860e+38 } {
        return 1
    } else {
        return 0
    }
}

proc do_LogAbs { val} {
    if { [ catch  {
        set res [ expr log( abs( $val))]
    }]} {
        set res 1e30
    } else {
        if { ( $res == "Inf")|| ( $res == "1.#INF")} {
            set res 1e30
        }
        if { ( $res == "-Inf") || ( $res == "-1.#INF")} {
            set res -1e30
        }
    }
    return $res
}

proc do_Exp { val} {
    if { [ catch  {
        set res [ expr exp( $val)]
    }]} {
        set res -1e30
    } else {
        if { ( $res == "Inf")|| ( $res == "1.#INF")} {
            set res 1e30
        }
        if { ( $res == "-Inf") || ( $res == "-1.#INF")} {
            set res -1e30
        }
    }
    return $res
}

proc do_Log10Abs { val} {
    if { [ catch  {
        set res [ expr log10( abs( $val))]
    }]} {
        set res 1e30
    } else {
        if { ( $res == "Inf")|| ( $res == "1.#INF")} {
            set res 1e30
        }
        if { ( $res == "-Inf") || ( $res == "-1.#INF")} {
            set res -1e30
        }
    }
    return $res
}

proc do_Pow10 { val} {
    if { [ catch  {
        set res [ expr pow( 10, $val)]
    }]} {
        set res -1e30
    } else {
        if { ( $res == "Inf")|| ( $res == "1.#INF")} {
            set res 1e30
        }
        if { ( $res == "-Inf") || ( $res == "-1.#INF")} {
            set res -1e30
        }
    }
    return $res
}

proc do_Inverse { val} {
    # near 0 values would be inf, so make them 0
    if { [ expr abs($val)] <= 1e-38 } {
        set res 1e+38
        if { $val < 0} {
            set res -1e+38
        }
    } else {
        if { [ catch  {
            set res [ expr 1.0 / $val]
        }]} {
            set res -1e30
        } else {
            if { ( $res == "Inf")|| ( $res == "1.#INF")} {
                set res 1e30
            }
            if { ( $res == "-Inf") || ( $res == "-1.#INF")} {
                set res -1e30
            }
        }
    }
    return $res
}

proc filter_float { val} {
    set ret $val
    if { [ expr abs( $val)] < 1e-38} {
        set ret 0.0
    } elseif { $val < -1e38} {
        set ret -1e38
    } elseif { $val > 1e38} {
        set ret 1e38
    }
    return $ret
}

proc CreateMenuAnalyisStep { w cmd_in } {
    global GidPriv RMenuRPriv
    rmenuinit
    set all_analysis [ lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    $w delete 0 end
    set cur_step [ GiD_Info postprocess get cur_step $cur_analysis]
    if { $all_analysis == ""} {
        $w add command -label [_ "Please load a MODEL first"] -state disabled 
        return
    }
    foreach analysis $all_analysis {
        set menu_txt [ TranslateResultName $analysis]
        set menu_name [GetValidMenuNameFromName  $analysis]
        $w add cascade -label $menu_txt -menu $w.m$menu_name -compound left 
        set all_steps [ GiD_Info postprocess get all_steps $analysis]
        set current_step [ GiD_Info postprocess get cur_step $analysis]
        if { [ winfo exists $w.m$menu_name ]} {
            $w.m$menu_name delete 0 end
        } else {
            menu $w.m$menu_name
        }
        set add_more 0
        set words ""        
        set i 1
        foreach time_step $all_steps {
            if { $::RMenuRPriv(MaxAbsolute)!= 0 && $i > $::RMenuRPriv(MaxAbsolute) } {
                set add_more 1
                break
            }
            if { $cur_analysis != $analysis || $current_step != $time_step } {
                lappend words [list $time_step [list {*}$cmd_in $analysis $time_step]]
            } else {
                lappend words [list $time_step [list {*}$cmd_in $analysis $time_step] check]
            }
            incr i
        }
        rmenuconf $w.m$menu_name $words
        if { $add_more} {
            $w.m$menu_name add separator
            $w.m$menu_name add command -label ...[_ "More"]... -command [list PCRSelectTimeStepMore $cmd_in $analysis $all_steps]
        }
    }
}

proc PCRSelectTimeStepMore { cmd_in analysis all_step } {
    set time_step [MessageBoxCombobox [_ "Create result"] [_ "Select time step"] $all_step readonly question]
    if { $time_step != "" } {
        set cmd $cmd_in 
        lappend cmd $analysis $time_step
        {*}$cmd
    }    
}

proc PCRUpdateAnalysisText { number w analysis time_step } {
    global PCResultsPriv
    set PCResultsPriv(analysis$number) $analysis
    set PCResultsPriv(step$number) $time_step  
    set txt_a [ TranslateResultName $PCResultsPriv(analysis$number)]
    $w configure -text "$txt_a / $PCResultsPriv(step$number)"
}

proc PCRSelectAnalStep { number w text_id} {
    global PCResultsPriv

    if { ![ winfo exists $w.m]} {
        menu $w.m
    }
    set cmd_in [list PCRUpdateAnalysisText $number $text_id]
    #this cmd_in will have appended two arguments more: analysis and time_step
    CreateMenuAnalyisStep $w.m $cmd_in
    $w.m post [ winfo pointerx $w] [ winfo pointery $w]
}

proc CreateMenuNodalResults { w cmd_in} {
    global GidPriv RMenuRPriv
    # without components
    # Result_Surface are nodal results
    # set wich_res "Result_Surface"
    # in nodos and in gauss points
    set wich_res "Contour_Fill"
    rmenuinit
    set all_anal [ lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    if { $all_anal == ""} {
        set msg [_ "Please load a MODEL first"]
    } else {
        set msg [_ "Please select a STEP first"]
    }
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    if { $cur_analysis == ""} {
        $w delete 0 end
        $w add command -label $msg -state disabled 
        return
    }
    set cur_step [ GiD_Info postprocess get cur_step $cur_analysis]
    if { $cur_step == ""} {
        $w add command -label [_ "Please select a STEP first"] -state disabled 
        $w delete 0 end
        return
    }
    if { $wich_res != "Deformation" } {
        set all_res [ GiD_Info postprocess get cur_results_list $wich_res ]
    } else {
        set all_res [ GiD_Info postprocess get show_geom_all_deform $cur_analysis \
            $cur_step ]
    }
    if { $all_res == ""} {
        $w delete 0 end
        $w add command -label [_ "No useful results found"] -state disabled 
        return
    }
    $w delete 0 end
    if { $wich_res != "Deformation" } {
        set cur_res [ GiD_Info postprocess get cur_result]
        set cur_comp [ GiD_Info postprocess get cur_component]
    } else {
        set cur_res [ GiD_Info postprocess get main_geom_cur_deform]
        set cur_comp ""
    }
    set wm $w
    set words ""
    foreach i $all_res {
        #kike: we are using outside the loop the last created wm menu??
        set wm [GetMenuCreatingCascadeMenuFromResultName $w $i ""]
        set txt [TranslateResultName $i]
        lappend words [list $txt [list {*}$cmd_in $i]]
    } 
    if { $wm == "" } {
        set wm $w
    }   
    rmenuconf $wm $words
}

proc PCRUpdateResultText { number w args} {
    global PCResultsPriv
    set PCResultsPriv(result$number) [ lindex $args 0]
    set txt $PCResultsPriv(result$number)    
    set txt [ TranslateResultName $txt]
    $w configure -text $txt
}

proc PCRSelectResult { number w text_id} {
    global PCResultsPriv

    if { ![ info exists PCResultsPriv(analysis$number)] || ![ info exists PCResultsPriv(step$number)]} {
        WarnWin [_ "Please, select an analysis and a step first."]
        return
    }

    GiD_Process Mescape Results AnalysisSel $PCResultsPriv(analysis$number) $PCResultsPriv(step$number)

    # Result_Surface are nodal results
    if { ![ winfo exists $w.m]} {
        menu $w.m
    }
    CreateMenuNodalResults $w.m [ list PCRUpdateResultText $number $text_id]
    $w.m post [ winfo pointerx $w] [ winfo pointery $w]
}

proc PCRDefineOperators {} {
    #set all_operadores "+ - * / y1x2z1" ;#"y1x2z1" is an example selecting mixed components of both
    set ::PCResultsPriv(ListOperators)  [ list + - * / SqrtAbs Abs LogAbs Log10Abs db10 db20 Exp Pow10 1/]
    set ::PCResultsPriv(ListParameters) [ list 2 2 2 2 1 1 1 1 1 1 1 1 1]
    if { [ llength $::PCResultsPriv(ListOperators)] != [ llength $::PCResultsPriv(ListParameters)] } {
        WarnWin [_ "Operator list not well defined. Shortening it."]
        if { [ llength $::PCResultsPriv(ListOperators)] > [ llength $::PCResultsPriv(ListParameters)]} {
            set ::PCResultsPriv(ListOperators) [ lrange $::PCResultsPriv(ListOperators) 0 [ llength ::PCResultsPriv(ListParameters)]]
        } elseif { [ llength $::PCResultsPriv(ListOperators)] < [ llength $::PCResultsPriv(ListParameters)]} {
            set ::PCResultsPriv(ListParameters) [ lrange $::PCResultsPriv(ListParameters) 0 [ llength ::PCResultsPriv(ListOperators)]]
        }
    }
}

proc PCRCreateMenuOperators { w cmd_in} {
    global GidPriv RMenuRPriv

    rmenuinit
    PCRDefineOperators
    set all_operadores $::PCResultsPriv(ListOperators)

    $w delete 0 end
    foreach i $all_operadores {        
        $w add command -label $i -command [list {*}$cmd_in $i] -compound left  
    }
}

proc PCRUpdateOperationText { w args} {
    global PCResultsPriv
    set ::PCResultsPriv(operador) [ lindex $args 0]
    set idx [ lsearch $::PCResultsPriv(ListOperators) $::PCResultsPriv(operador)]
    set ::PCResultsPriv(parametros) [ lindex $::PCResultsPriv(ListParameters) $idx]
    $w configure -text "   $PCResultsPriv(operador)   "
    
    if { $::PCResultsPriv(parametros) == 1} {
        #disable first parameter
        PCRSetResultFrameState 1 disabled
        #select result and disable escalar and vector
        $::PCResultsPriv(resbutton) invoke
        $::PCResultsPriv(escbutton) configure -state disabled
        $::PCResultsPriv(vecbutton) configure -state disabled
    } else {
        #enable first parameter
        PCRSetResultFrameState 1 normal
        #enable escalar and vector
        $::PCResultsPriv(escbutton) configure -state normal
        $::PCResultsPriv(vecbutton) configure -state normal  
    }
    $w configure -text "   $PCResultsPriv(operador)   "
}

proc PCRSelectOperacion { w text_id} {
    global PCResultsPriv

    if { ![ winfo exists $w.m]} {
        menu $w.m
    }
    PCRDefineOperators
    PCRCreateMenuOperators $w.m [list PCRUpdateOperationText {*}$text_id]
    $w.m post [ winfo pointerx $w] [ winfo pointery $w]
}

proc PCRApply { } {
    global PCResultsPriv

    # just to not make code more complicated...
    if { $::PCResultsPriv(parametros) == 1} {
        if { ![info exists PCResultsPriv(analysis2)] || ![info exists PCResultsPriv(step2)] } {           
            WarnWin [concat [_ "With a single operator the result used is the second!!."]\n [_ "Please, select the analysis and step."]]
            return 1
        }
        set analysis_dest $PCResultsPriv(analysis2)
        set step_dest $PCResultsPriv(step2)
        set PCResultsPriv(analysis1) $PCResultsPriv(analysis2)
        set PCResultsPriv(step1) $PCResultsPriv(step2)
        set PCResultsPriv(result1) $PCResultsPriv(result2)
        
        if { ( $::PCResultsPriv(parametros) == 1) && ( $::PCResultsPriv(Op2Typ) != "result")} {
            WarnWin [_ "The selected operation needs a result as operand."]
            return 1
        }
    } elseif { ( $::PCResultsPriv(Op2Typ) != "result")} {
        if { ![info exists PCResultsPriv(result1)] } {
            WarnWin [_ "Please, choose a correct '%s'" [_ "First Result"]]
            return 1            
        }
        set analysis_dest $PCResultsPriv(analysis1)
        set step_dest $PCResultsPriv(step1)
        set PCResultsPriv(analysis2) $PCResultsPriv(analysis1)
        set PCResultsPriv(step2) $PCResultsPriv(step1)
        set PCResultsPriv(result2) $PCResultsPriv(result1)
    }

    foreach d {analysis1 step1 result1 operador analysis2 step2 result2 resultdest} \
        txt {{First Analysis} {First Step} {First Result} Operator {Second Analysis} {Second Step} {Second Result} {Result destination name}} \
        txt_trad [list [_ "First Analysis"] [_ "First Step"] [_ "First Result"] [_ "Operator"] [_ "Second Analysis"] [_ "Second Step"] [_ "Second Result"] [_ "Result destination name"]] {
        if { ![ info exists PCResultsPriv($d)]} {
            set txt1 [_ "Please, choose a correct '%s'" $txt_trad]
            WarnWin $txt1
            return 1
        }
    }
    
    if { $PCResultsPriv(analysis1) == $PCResultsPriv(analysis2) } {
        set analysis_dest $PCResultsPriv(analysis1)                
    } else {
        set analysis_dest [ GiD_Info postprocess get cur_analysis]      
    }
    if { $PCResultsPriv(step1) == $PCResultsPriv(step2) } {
        set step_dest $PCResultsPriv(step1)
    } else {
        set step_dest [ GiD_Info postprocess get cur_step [ GiD_Info postprocess get cur_analysis]]
    }

    if { $::PCResultsPriv(AllSteps)} {
        if { $PCResultsPriv(analysis1) != $PCResultsPriv(analysis2) } {
            set all_steps1 [ GiD_Info postprocess get all_steps $PCResultsPriv(analysis1)]
            set all_steps2 [ GiD_Info postprocess get all_steps $PCResultsPriv(analysis2)]
            if { $all_steps1 != $all_steps2 } {
                WarnWin [_ "the steps of both analysis must be equal to set all steps"]
                return 1
            } else {
                set all_steps $all_steps1
            }                    
        } else {
            set all_steps [ GiD_Info postprocess get all_steps $PCResultsPriv(analysis1)]            
        }
        foreach number {1 2} {
            set ipos($number) [ lsearch -sorted -real $all_steps $::PCResultsPriv(step$number)]
            if { $ipos($number) == -1 } {
                WarnWin [_ "step %s not found in steps list" $::PCResultsPriv(step$number)]
                return 1
            }
        }
        #calculate relative position
        set imin [ ::tcl::mathfunc::min $ipos(1) $ipos(2)]
        set i_step_incre1 [ expr {$ipos(1)-$imin}]
        set i_step_incre2 [ expr {$ipos(2)-$imin}]
    } else {
        set all_steps $step_dest
    }
    set n_steps [ llength $all_steps]
    set i_step 0
    foreach step_dest $all_steps {
        if { $::PCResultsPriv(AllSteps)} {
            set i_step1 [ expr {$i_step+$i_step_incre1}]
            set i_step2 [ expr {$i_step+$i_step_incre2}]
            if { $i_step1 >= $n_steps || $i_step2 >= $n_steps } {
                break
            }
            set step1 [ lindex $all_steps $i_step1]
            set step2 [ lindex $all_steps $i_step2]
        } else {
            set step1 $::PCResultsPriv(step1)            
            set step2 $::PCResultsPriv(step2)
        }
        set result_dest_id [list $PCResultsPriv(resultdest) $analysis_dest $step_dest]
        if { [GiD_Result exists $result_dest_id] } {
            GiD_Result delete $result_dest_id
            GidUtils::SetWarnLine [_ "Result '%s' for step %s deleted" $PCResultsPriv(resultdest) $step_dest]
        }                
        
        if { $::PCResultsPriv(parametros) == 2} {
            set result_1_id [list $PCResultsPriv(result1) $PCResultsPriv(analysis1) $step1]
            if { ![GiD_Result exists $result_1_id] } {
                WarnWin [_ "Result '%s' does not exist: %s" $PCResultsPriv(result1) $errtxt]
                return 1
            }
            set res_info1 [GiD_ResultGetArrayOnlyStrictComponents $result_1_id]
            lassign [lindex $res_info1 3] ids_1 values_1
            set num_components_1 [llength $values_1]
        }
        set result_2_id [list $PCResultsPriv(result2) $PCResultsPriv(analysis2) $step2]
        if { ![GiD_Result exists $result_2_id] } {
            WarnWin [_ "Result '%s' does not exist: %s" $PCResultsPriv(result2) $errtxt]
            return 1
        }
        set res_info2 [GiD_ResultGetArrayOnlyStrictComponents $result_2_id]
        lassign [lindex $res_info2 3] ids_2 values_2
        set num_components_2 [llength $values_2]        
                
        set header_dst [list Result $PCResultsPriv(resultdest) $analysis_dest $step_dest {*}[lrange [lindex $res_info2 0] 4 end]]
        #allocate the objarrays of the new result
        set values_dst [list]
        foreach component_values_2 $values_2 {
            lappend values_dst [objarray new doublearray [objarray length $component_values_2]]
        }
        set res_dst [list $header_dst {} {} [list $ids_2 $values_dst]]
        
        if { $::PCResultsPriv(Op2Typ) == "result"} {
            
        } elseif { $::PCResultsPriv(Op2Typ) == "scalar"} {
            #replace all values_2 by the provided scalar            
            #really [llength $values_2] must be 1
            if { !$::PCResultsPriv(Op2Typ,complex,scalar)} {
                if { ![info exists ::PCResultsPriv(Op2Typ,a)] } {
                    WarnWin [_ "Please, choose a correct scalar operator value"]
                    return 1
                }
                set v $::PCResultsPriv(Op2Typ,a)
                foreach component_values_2 $values_2 {
                    set num_values_2 [objarray length $component_values_2]
                    for { set j 0} {$j<$num_values_2} {incr j} {
                        objarray set $component_values_2 $j $v
                    }
                }                
            } else {
                if { ![info exists ::PCResultsPriv(Op2Typ,a)] || ![info exists ::PCResultsPriv(Op2Typ,b)] } {
                    WarnWin [_ "Please, choose a correct scalar operator complex value"]
                    return 1
                }
                set v [list $::PCResultsPriv(Op2Typ,a) $::PCResultsPriv(Op2Typ,b)]
                lassign $v v_a v_b
                foreach component_values_2 $values_2 {                    
                    set num_values_2 [objarray length $component_values_2]
                    for { set j 0} {$j<$num_values_2} {incr j} {
                        if { [expr $j%2] } {
                            objarray set $component_values_2 $j $v_a
                        } else {
                            objarray set $component_values_2 $j $v_b
                        }
                    }
                }
            }           
        } elseif { $::PCResultsPriv(Op2Typ) == "vector"} {
            #replace all values_2 by the provided vector
            #really [llength $values_2] must be 3
            if { !$::PCResultsPriv(Op2Typ,complex,vector)} {
                set user_values [list $::PCResultsPriv(Op2Typ,x) $::PCResultsPriv(Op2Typ,y) $::PCResultsPriv(Op2Typ,z)]
                foreach component_values_2 $values_2 v $user_values  {
                    set num_values_2 [objarray length $component_values_2]
                    for { set j 0} {$j<$num_values_2} {incr j} {
                        objarray set $component_values_2 $j $v
                    }
                }
            } else {
                set user_values [list [list $::PCResultsPriv(Op2Typ,x) $::PCResultsPriv(Op2Typ,xi)] [list $::PCResultsPriv(Op2Typ,y) $::PCResultsPriv(Op2Typ,yi)] [list $::PCResultsPriv(Op2Typ,z) $::PCResultsPriv(Op2Typ,zi)]]
                foreach component_values_2 $values_2 v $user_values {
                    lassign $v v_a v_b
                    set num_values_2 [objarray length $component_values_2]
                    for { set j 0} {$j<$num_values_2} {incr j} {
                        if { [expr $j%2] } {
                            objarray set $component_values_2 $j $v_a
                        } else {
                            objarray set $component_values_2 $j $v_b
                        }
                    }
                }                                
            }
        }

        if { $::PCResultsPriv(parametros) == 2} {
            if { $num_components_1 != $num_components_2} {
                WarnWin [_ "Different number of components ( %d != %d), please check the results selected" $num_components_1 $num_components_2]
                return 1
            }
        }

        set n_chivato 0
               
        if { $::PCResultsPriv(parametros) == 2} {
            set num_ids_1 [objarray length $ids_1]
            set num_ids_2 [objarray length $ids_2]            
            set ids [objarray intersection -sorted $ids_1 $ids_2]
            set num_ids [objarray length $ids]
            if { $num_ids != $num_ids_1 || $num_ids != $num_ids_2 } {
                WarnWin [_ "both results must be defined on the same entities"] $PCResultsPriv(wid)
                return 1
            }
        } else {
            set ids $ids_2
            set num_ids [objarray length $ids]
        }
        
        
        if { $::PCResultsPriv(parametros) == 2} {
            if { $PCResultsPriv(operador) == "y1x2z1"} {
                # swap de x e y
                if { $num_components_1 >= 3} {
                    lappend dstres $result1($i,1)
                    lappend dstres $result2($i,0)
                    lappend dstres $result1($i,2)
                    for { set ic 3 } { $ic < $num_components_1} { incr ic} {
                        lappend dstres $result1($i,3)
                    }
                }
            } else { 
                foreach component_values_1 $values_1 component_values_2 $values_2 component_values_dst $values_dst {
                    set num_values_1 [objarray length $component_values_1]
                    set num_values_2 [objarray length $component_values_2]
                    for { set j 0} {$j<$num_values_2} {incr j} {
                        set v_1 [objarray get $component_values_1 $j]
                        set v_2 [objarray get $component_values_2 $j]
                        if { [IsResultNotDefined $v_1] || [IsResultNotDefined $v_2] } {
                            objarray set $component_values_dst $j [GetResultNotDefined]
                        } else {
                            objarray set $component_values_dst $j [expr $v_1 $PCResultsPriv(operador) $v_2]
                        }
                    }
                } 
            }
        } elseif { $::PCResultsPriv(parametros) == 1} {
            # SqrtAbs Abs Log10Abs db10 db20 Exp 1/
            switch $::PCResultsPriv(operador) {
                SqrtAbs {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [expr sqrt(abs($v2))]
                            }
                        }
                        lappend dstres $dstres_ic
                    }
                }
                Abs {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {                            
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [expr abs($v2)]
                            }
                        }
                        lappend dstres $dstres_ic
                    }
                }
                LogAbs {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [do_LogAbs $v2]
                            }
                        }
                        lappend dstres $dstres_ic
                    }
                }
                Log10Abs {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [do_Log10Abs $v2]
                            }
                        }
                        lappend dstres $dstres_ic
                    }
                }
                db10 {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            lappend dstres_ic [expr 10.0*[do_Log10Abs $v2]]
                        }
                        lappend dstres $dstres_ic                            
                    }
                }
                db20 {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [expr 20.0*[do_Log10Abs $v2]]
                            }
                        }
                        lappend dstres $dstres_ic
                    }
                }
                Exp {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [do_Exp $v2]
                            }
                        }
                        lappend dstres $dstres_ic         
                    }
                }
                Pow10 {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [do_Pow10 $v2]
                            }
                        }
                        lappend dstres $dstres_ic                           
                    }
                }
                1/ {
                    for { set ic 0 } { $ic < $num_components_2} { incr ic} {
                        set dstres_ic [list]
                        #in case of result OnGaussPoints could be nj>1
                        foreach v2 $result2($i,$ic) {
                            if { [IsResultNotDefined $v2]] } {
                                lappend dstres_ic [GetResultNotDefined]
                            } else {
                                lappend dstres_ic [do_Inverse $v2]
                            }
                        }
                        lappend dstres $dstres_ic                    
                    }
                }
            }                       

            incr n_chivato
            if { $n_chivato == 1000} {
                set ::PCResultsPriv(var) [ expr int( ( ( ( 100.0 * $index) / $num_ids) * $i_step / $n_steps))]
                update
            }
        }
       
        if { $num_ids } {

            GiD_Result create -array {*}$res_dst
            GidUtils::SetWarnLine [_ "Result '%s' for %s step %s created" $PCResultsPriv(resultdest) $analysis_dest $step_dest].
        } else {
            GidUtils::SetWarnLine [_ "Result '%s' for %s step %s not created because any entity has values" $PCResultsPriv(resultdest) $analysis_dest $step_dest].
        }       
        set ::PCResultsPriv(var) [ expr int( 100.0 * $i_step / $n_steps)]
        update
        incr i_step
    }

    set ::PCResultsPriv(var) 100
    after 3000 set ::PCResultsPriv(var) 0

    if { [ regexp {([ ^0-9]*)([ 0-9]+)$} $PCResultsPriv(resultdest) dum raiz num]} {
        set new_name "$raiz[ expr $num + 1]"
    } else {
        set new_name "$PCResultsPriv(resultdest) 2"
    }
    set PCResultsPriv(resultdest) $new_name
}

proc PCRClose { } {
    global PCResultsPriv
    destroy $PCResultsPriv(wid)
}

proc PCRIniVariables { } {
    global PCResultsPriv
    foreach d "analysis1 step1 result1 operador analysis2 step2 result2 resultdest" {
        if { [ info exists PCResultsPriv($d)]} {
            unset PCResultsPriv($d)
        }
    }
}

proc PCRDeleteResult { } {
    global PCResultsPriv
    foreach number {1 2} {
        if { ![ info exists PCResultsPriv(analysis$number)] || ![ info exists PCResultsPriv(step$number)]} {
            WarnWin [_ "Please, select an analysis and a step first."]
            return
        }
    }
    if { $PCResultsPriv(analysis1) == $PCResultsPriv(analysis2) } {
        set analysis_dest $PCResultsPriv(analysis1)                
    } else {
        set analysis_dest [GiD_Info postprocess get cur_analysis]
    }
    if { $PCResultsPriv(step1) == $PCResultsPriv(step2) } {
        set step_dest $PCResultsPriv(step1)
    } else {
        set step_dest [GiD_Info postprocess get cur_step [GiD_Info postprocess get cur_analysis]]
    }
    set result_delete_id [list $PCResultsPriv(resultdest) $analysis_dest $step_dest]
    if { ![GiD_Result exists $result_delete_id] } {
        WarnWin [_ "Result '%s' does not exist" $PCResultsPriv(resultdest)]
        return
    } else {
        set resp [MessageBoxOptionsButtons [_ "Warning"] \
                [_ "Do you really want to delete the Result '%s'?" $PCResultsPriv(resultdest)] \
                {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
        if { $resp == 0 } {
            if { $::PCResultsPriv(AllSteps)} {
                set all_steps [ GiD_Info postprocess get all_steps $analysis_dest]
            } else {
                set all_steps $step_dest
            }
            foreach step_dest $all_steps {
                set result_delete_id [list $PCResultsPriv(resultdest) $analysis_dest $step_dest]
                if { [GiD_Result exists $result_delete_id] } {
                    GiD_Result delete $result_delete_id
                    GidUtils::SetWarnLine [_ "Result '%s' for step %s deleted" $PCResultsPriv(resultdest) $step_dest]
                }
            }
        }
    }
    return 0
}

proc PCRSetResultFrameState { which st} {
    set fr $::PCResultsPriv(result,$which,frame)
    if { "$st" == "normal"} {
        $fr.l0 configure -foreground black
        $fr.b0 configure -state normal
        $fr.l1 configure -foreground black
        $fr.b1 configure -state normal
    } elseif { "$st" == "disabled"} {
        $fr.l0 configure -foreground $::GidPriv(Color,DisabledForegroundMenu)
        $fr.b0 configure -state disabled
        $fr.l1 configure -foreground $::GidPriv(Color,DisabledForegroundMenu)
        $fr.b1 configure -state disabled
    }
}

proc PCR_EnableDisableComplexPart { w varname} {
    set val [ subst $$varname]
    if { $val} {
        $w configure -state normal
    } else {
        $w configure -state disabled
    }
}

proc PCR_EnableDisable2Operand { f_op2 varname} {
    set val [ subst $$varname]
    set state_esc disabled
    set state_vec disabled
    set state_res normal
    switch $val {
        scalar {
            set state_esc normal
            set state_vec disabled
            set state_res disabled
        }
        vector {
            set state_esc disabled
            set state_vec normal
            set state_res disabled
        }
        result {
            set state_esc disabled
            set state_vec disabled
            set state_res normal
        }
    }

    # scalar operand
    set f3_esc $f_op2.fe
    # $f3_esc.resc should remain enabled
    foreach w [ list  $f3_esc.resc_comp $f3_esc.resc_a $f3_esc.resc_b] {
        $w configure -state $state_esc
    }

    # vector operand
    set f3_vec $f_op2.fv
    # $f3_esc.rvec should remain enabled
    foreach w [ list $f3_vec.rvec_comp $f3_vec.rvec_x $f3_vec.rvec_xi \
                    $f3_vec.rvec_y $f3_vec.rvec_yi $f3_vec.rvec_z $f3_vec.rvec_zi] {
        $w configure -state $state_vec
    }

    # result operand
    set f3 $f_op2.f3
    # $f3.rres should remain enabled
    foreach w [ list $f3.l0 $f3.b0 $f3.l1 $f3.b1] {
        $w configure -state $state_res
    }

    # actualize complex part

    PCR_EnableDisableComplexPart $f3_esc.resc_b ::PCResultsPriv(Op2Typ,complex,scalar)
    PCR_EnableDisableComplexPart $f3_vec.rvec_xi ::PCResultsPriv(Op2Typ,complex,vector)
    PCR_EnableDisableComplexPart $f3_vec.rvec_yi ::PCResultsPriv(Op2Typ,complex,vector)
    PCR_EnableDisableComplexPart $f3_vec.rvec_zi ::PCResultsPriv(Op2Typ,complex,vector)
}

proc PostCreateResult { { w .gid.wCreateResult}} {
    global PCResultsPriv GidPriv GIDDEFAULT

    PCRIniVariables

    InitWindow2 $w -title [_ "Create result"] \
        -geometryvariable PostCreateResultWindowGeom \
        -initcommand PostCreateResult
    if { ![ winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set PCResultsPriv(wid) $w
    set f [ ttk::frame $w.f]
    set f0 [ ttk::frame $f.f0 -style groove.TFrame]
    ttk::label $f0.l0 -text [ concat [_ "Analysis & step"] " 1"] 
    ttk::button $f0.b0 -text [ concat [_ "Select analysis & step"] " 1"] -command [ list PCRSelectAnalStep 1 $w $f0.b0]
    ttk::label $f0.l1 -text [ concat [_ "Result"] " 1:"] 
    ttk::button $f0.b1 -text [_ "Select result"] -command [list PCRSelectResult 1 $w $f0.b1]
    if { $::PCResultsPriv(HorizontalLayout)} {
        grid $f0.l0 -sticky w -padx 4 -pady 2
        grid $f0.b0 -sticky ew -padx 4 -pady 2
        grid $f0.l1 -sticky w -padx 4 -pady 2
        grid $f0.b1 -sticky ew -padx 4 -pady 2
        grid columnconfigure $f0 0 -weight 1
    } else {
        grid $f0.l0 $f0.b0 -sticky ew -padx 4 -pady 2
        grid $f0.l1 $f0.b1 -sticky ew -padx 4 -pady 2
        grid columnconfigure $f0 "0 1" -weight 1
    }
    set ::PCResultsPriv(result,1,frame) $f0
    setTooltip $f0 -text [_ "Select a result as first operand for operators with two operands."] 

    set f2 [ ttk::frame $f.f2]
    ttk::label $f2.l -text [_ "Operator"]: 
    ttk::button $f2.b -text [_ "Select operator"] -command [list PCRSelectOperacion $w $f2.b]
    if { $::PCResultsPriv(HorizontalLayout)} {
        grid $f2.l -sticky e -padx 4 -pady 2
        grid $f2.b -sticky ew -padx 4 -pady 2
        grid columnconfigure $f2 0 -weight 1
    } else {
        grid $f2.l $f2.b -sticky ew -padx 4 -pady 2
        grid configure $f2.b -sticky w -padx 4 -pady 2
        grid columnconfigure $f2 "1" -weight 1
    }
    setTooltip $f2 -text [_ "Select operator or the function to operate on results.\nOperators like +, -, *, / require two operators, allowing a constant scalar or vector as second operator.\nFunctions requires a result as argument."]

    set f3_op2 [ ttk::frame $f.f3_op2 -style groove.TFrame]

    # scalar frame
    set f3_esc [ ttk::frame $f3_op2.fe -border 0]
    ttk::radiobutton $f3_esc.resc -text [_ "scalar"] -variable ::PCResultsPriv(Op2Typ) -value scalar \
        -command "PCR_EnableDisable2Operand $f3_op2 ::PCResultsPriv(Op2Typ)"
    set ::PCResultsPriv(escbutton) $f3_esc.resc
    if { ![info exists ::PCResultsPriv(Op2Typ,complex,scalar)] } { set ::PCResultsPriv(Op2Typ,complex,scalar) 0 }
    ttk::checkbutton $f3_esc.resc_comp -text [_ "complex"] \
        -variable ::PCResultsPriv(Op2Typ,complex,scalar) -onvalue 1 -offvalue 0 \
        -command "PCR_EnableDisableComplexPart $f3_esc.resc_b ::PCResultsPriv(Op2Typ,complex,scalar)"
    ttk::entry $f3_esc.resc_a -textvariable ::PCResultsPriv(Op2Typ,a) -width 8
    ttk::entry $f3_esc.resc_b -textvariable ::PCResultsPriv(Op2Typ,b) -width 8
    grid $f3_esc.resc $f3_esc.resc_comp $f3_esc.resc_a $f3_esc.resc_b -sticky ew -padx 4 -pady 2
    grid configure $f3_esc.resc -sticky w
    grid configure $f3_esc.resc_comp -sticky w
    grid columnconfigure $f3_esc 2 -weight 1
    grid columnconfigure $f3_esc 3 -weight 1

    # vector frame
    set f3_vec [ ttk::frame $f3_op2.fv -border 0]
    ttk::radiobutton $f3_vec.rvec -text [_ "vector"] -variable ::PCResultsPriv(Op2Typ) -value vector \
        -command "PCR_EnableDisable2Operand $f3_op2 ::PCResultsPriv(Op2Typ)"
    set ::PCResultsPriv(vecbutton) $f3_vec.rvec
    if { ![info exists ::PCResultsPriv(Op2Typ,complex,vector)] } { set ::PCResultsPriv(Op2Typ,complex,vector) 0 }
    ttk::checkbutton $f3_vec.rvec_comp -text [_ "complex"] \
        -variable ::PCResultsPriv(Op2Typ,complex,vector) -onvalue 1 -offvalue 0 \
        -command "PCR_EnableDisableComplexPart $f3_vec.rvec_xi ::PCResultsPriv(Op2Typ,complex,vector) ; \
        PCR_EnableDisableComplexPart $f3_vec.rvec_yi ::PCResultsPriv(Op2Typ,complex,vector) ; \
        PCR_EnableDisableComplexPart $f3_vec.rvec_zi ::PCResultsPriv(Op2Typ,complex,vector) ;"
    ttk::entry $f3_vec.rvec_x -textvariable ::PCResultsPriv(Op2Typ,x) -width 8
    ttk::entry $f3_vec.rvec_xi -textvariable ::PCResultsPriv(Op2Typ,xi) -width 8
    ttk::entry $f3_vec.rvec_y -textvariable ::PCResultsPriv(Op2Typ,y) -width 8
    ttk::entry $f3_vec.rvec_yi -textvariable ::PCResultsPriv(Op2Typ,yi) -width 8
    ttk::entry $f3_vec.rvec_z -textvariable ::PCResultsPriv(Op2Typ,z) -width 8
    ttk::entry $f3_vec.rvec_zi -textvariable ::PCResultsPriv(Op2Typ,zi) -width 8
    grid $f3_vec.rvec $f3_vec.rvec_comp $f3_vec.rvec_x $f3_vec.rvec_xi -sticky w -padx 4 -pady 2
    grid configure $f3_vec.rvec_x -sticky ew -padx 4 -pady 2
    grid configure $f3_vec.rvec_xi -sticky ew -padx 4 -pady 2
    grid $f3_vec.rvec_y -row 1 -column 2 -sticky ew -padx 4 -pady 2
    grid $f3_vec.rvec_yi -row 1 -column 3 -sticky ew -padx 4 -pady 2
    grid $f3_vec.rvec_z -row 2 -column 2 -sticky ew -padx 4 -pady 2
    grid $f3_vec.rvec_zi -row 2 -column 3 -sticky ew -padx 4 -pady 2
    grid columnconfigure $f3_vec 2 -weight 1
    grid columnconfigure $f3_vec 3 -weight 1

    # result frame
    set f3 [ ttk::frame $f3_op2.f3 -border 0]
    ttk::radiobutton $f3.rres -text [_ "result"] -variable ::PCResultsPriv(Op2Typ) -value result \
        -command "PCR_EnableDisable2Operand $f3_op2 ::PCResultsPriv(Op2Typ)"
    set ::PCResultsPriv(resbutton) $f3.rres
    ttk::label $f3.l0 -text [ concat [_ "Analysis & step"] " 2"] 
    ttk::button $f3.b0 -text [ concat [_ "Select analysis & step"] " 2"] -command [ list PCRSelectAnalStep 2 $w $f3.b0]    
    ttk::label $f3.l1 -text [ concat [_ "Result"] " 2:"] 
    ttk::button $f3.b1 -text [_ "Select result"] -command [ list PCRSelectResult 2 $w $f3.b1]
    grid $f3.rres -columnspan 2 -sticky w -padx 4 -pady 2
    grid $f3.l0 $f3.b0 -sticky ew -padx 4 -pady 2
    grid $f3.l1 $f3.b1 -sticky ew -padx 4 -pady 2
    grid configure $f3.l0 -sticky e
    grid configure $f3.l1 -sticky e
    grid columnconfigure $f3 "0 1" -weight 1
    set ::PCResultsPriv(result,2,frame) $f3

    # grid 2 operand frame
    grid $f3_esc -sticky ew
    grid $f3_vec -sticky ew
    grid $f3 -sticky ew
    grid columnconfigure $f3_op2 0 -weight 1
    grid rowconfigure $f3_op2 0 -weight 1
    grid rowconfigure $f3_op2 1 -weight 1
    grid rowconfigure $f3_op2 2 -weight 1
    setTooltip $f3_op2 -text [_ "Select the second operand of the operators or the argument of the functions.\nSome operators allow to use a constant scalar or vector as second operator for the real or imaginary part."] 

    set fr [ ttk::frame $f.fr]
    ttk::label $fr.l -text [_ "Destination result name"]: 
    ttk::entry $fr.e -textvariable PCResultsPriv(resultdest) -width 20
    
    ttk::button $fr.b -image [ gid_themes::GetImage "delete.png" small_icons] -command PCRDeleteResult
    if { ![info exists ::PCResultsPriv(AllSteps)] } { set ::PCResultsPriv(AllSteps) 0 }
    ttk::checkbutton $fr.cbAll -text [_ "All steps"] -variable ::PCResultsPriv(AllSteps)
    set ::PCResultsPriv(AllSteps) 1
   
    ttk::progressbar $fr.l2 -variable ::PCResultsPriv(var) -length 200
    set ::PCResultsPriv(var) 0

    grid $fr.l $fr.e $fr.b -sticky news -padx 4 -pady 2
    grid $fr.cbAll -sticky news -columnspan 3
    grid $fr.l2 -sticky news -columnspan 3
    grid columnconfigure $fr 1 -weight 1
    set PCResultsPriv(resultdest) [_ "New result name"]

    setTooltip $fr -text [_ "Select the name of the destionation result. Or enter a result name to delete it with the cross button."] 
    if { $::PCResultsPriv(HorizontalLayout)} {
        grid $f0 $f2 $f3_op2 -sticky news -padx 2 -pady 2
        grid $fr -sticky news -padx 2 -pady 2 -columnspan 3
        grid columnconfigure $f 0 -weight 1
    } else {
        grid $f0 -sticky news -padx 2 -pady 2
        grid $f2 -sticky news -padx 2 -pady 2
        grid $f3_op2 -sticky news -padx 2 -pady 2
        grid $fr -sticky news -padx 2 -pady 2

        grid columnconfigure $f 0 -weight 1
        grid rowconfigure $f 4 -weight 1
    }

    # marco de los botones
    ttk::frame $w.but -style BottomFrame.TFrame
  
    ttk::button $w.but.apply -text [_ "Apply"] -command PCRApply -takefocus 1 -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -takefocus 1 -style BottomFrame.TButton

    grid $w.but.apply -sticky ews -padx 6 -pady 12
    grid $w.but.close -sticky ews -padx 6 -pady 12 -row 0 -column 1

    #enpaquetamos marcos
    grid $w.f -sticky news -padx 2 -pady 2
    grid $w.but -sticky wes
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    focus $w.but.apply
    bind $w <Return> "$w.but.apply invoke"
    bind $w <Destroy> [list +PCRClose] ;# + to add to previous script   

    # default values:
    set ::PCResultsPriv(Op2Typ) result
    set ::PCResultsPriv(Op2Typ,complex,scalar) 0
    set ::PCResultsPriv(Op2Typ,complex,vector) 0
    PCR_EnableDisable2Operand $f3_op2 ::PCResultsPriv(Op2Typ)
    PCR_EnableDisableComplexPart $f3_esc.resc_b ::PCResultsPriv(Op2Typ,complex,scalar)
    PCR_EnableDisableComplexPart $f3_vec.rvec_xi ::PCResultsPriv(Op2Typ,complex,vector)
    PCR_EnableDisableComplexPart $f3_vec.rvec_yi ::PCResultsPriv(Op2Typ,complex,vector)
    PCR_EnableDisableComplexPart $f3_vec.rvec_zi ::PCResultsPriv(Op2Typ,complex,vector)
    PCR_EnableDisable2Operand $f3_op2 ::PCResultsPriv(Op2Typ)    
}

########################################################################
##################################### PostCreateGraphs #################
########################################################################

proc CreateMenuGraphs { w cmd_in} {
    global GidPriv RMenuRPriv

    rmenuinit
    set all_graphs [ lsort -dictionary [ GiD_Graph list]]

    $w delete 0 end

    if { $all_graphs == ""} {
        $w add command -label [_ "Please load a GRAPH first"] -state disabled 
        return
    }

    foreach i $all_graphs {
        set menu_txt $i 
        $w add command -label $menu_txt -command [list {*}$cmd_in $i] -compound left 
    }
}

proc PCGraphsUpdateGraphsText { number w args } {
    set ::PCGraphsPriv(graph$number) [ lindex $args 0]  
    set txt_g $::PCGraphsPriv(graph$number)
    $w configure -text $txt_g
}

proc PCGraphsSelectGraph { number w text_id} {
    global PCGraphsPriv

    if { ![ winfo exists $w.m]} {
        menu $w.m
    }
    CreateMenuGraphs $w.m "PCGraphsUpdateGraphsText $number [ list $text_id]"
    $w.m post [ winfo pointerx $w] [ winfo pointery $w]
}

proc PCGraphsOptionsCubicSpline { } {    
    set new_precision [MessageBoxEntry [_ "Enter precision of Cubic spline"] [_ "Enter precision of Cubic spline \n( number of steps between points)"] int+ $::PCGraphsPriv(CubicSpline,Precision) 0 question.png]
    if { $new_precision != ""} {
        set ::PCGraphsPriv(CubicSpline,Precision) $new_precision
    }
}

proc PCGraphsOptionsCatmullRomSpline { } {
    set new_precision [MessageBoxEntry [_ "Enter precision of Catmull-Rom spline"] [_ "Enter precision of Catmull-Rom spline \n( number of global points > 1)"] int+ $::PCGraphsPriv(CatmullRomSpline,NumPoints) 0 question.png]
    if { $new_precision != ""} {
        while { $new_precision < 2} {
            WarnWin [_ "Number of points must be >= 2"]
            set new_precision [MessageBoxEntry [_ "Enter precision of Catmull-Rom spline"] [_ "Enter precision of Catmull-Rom spline \n( number of global points > 1)"] int+ $::PCGraphsPriv(CatmullRomSpline,NumPoints) 0 question.png]            
            if { $new_precision == ""} {
                break
            }
        }
        if { $new_precision != ""} {
          set ::PCGraphsPriv(CatmullRomSpline,NumPoints) $new_precision
        }
    }
}

proc PCGraphsOptionsDerivate {} {
    set new_offset [MessageBoxEntry [_ "Enter offset of derivate values"] [_ "Enter offset of derivate values in segment \[ 0.0...1.0\]"]  real $::PCGraphsPriv(Derivate,Offset) 0 question.png]
    if { $new_offset != ""} {
        while { ( $new_offset < 0.0) || ( $new_offset > 1.0)} {
            WarnWin [_ "Offset must be inside the segment \[ 0.0...1.0\]"]
            set new_offset [MessageBoxEntry [_ "Enter offset of derivate values"] [_ "Enter offset of derivate values in segment \[ 0.0...1.0\]"]  real $::PCGraphsPriv(Derivate,Offset) 0 question.png]
            if { $new_offset == ""} {
                break
            }
        }
        if { $new_offset != ""} {
          set ::PCGraphsPriv(Derivate,Offset) $new_offset 
        }
    }    
}

proc PCGraphsOptionsdFTWinApply { w} {
    set ::PCGraphsPriv(dFT,Polar) $::OptDft(Polar)
    set ::PCGraphsPriv(dFT,ComplexPart) $::OptDft(ComplexPart)
    set ::PCGraphsPriv(dFT,ScaleY) $::OptDft(ScaleY)
    set ::PCGraphsPriv(dFT,ScaleX) $::OptDft(ScaleX)
    set ::PCGraphsPriv(dFT,GetXFreq) $::OptDft(GetXFreq)
    set ::PCGraphsPriv(dFT,HalfResults) $::OptDft(HalfResults)
    PCGraphsOptionsdFTWinClose $w
}

proc PCGraphsOptionsdFTWinClose { w} {
    destroy $w
    unset ::OptDft
}

proc PCGraphsOptionsdFT_EnableDisableYselection { f varname} {
    set val [ subst $$varname]
    set state normal
    if { $val} {
        set state disabled
    }
    foreach widget [ list $f.l $f.rb_r $f.rb_i $f.rb_m $f.rb_f $f.cb_fx $f.cb_sx $f.cb_sy] {
        $widget configure -state $state
    }
}

proc PCGraphsOptionsdFT { { w .gid.wPostCreateGraphs.optdFT}} {

    InitWindow2 $w -title [_ "dFT options"] \
        -geometryvariable PostGraphsOptionsdFTWindowGeom \
        -initcommand PCGraphsOptionsdFT -ontop
    if { ![ winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
       
    #default values
    set ::OptDft(Polar) $::PCGraphsPriv(dFT,Polar)
    set ::OptDft(ComplexPart) $::PCGraphsPriv(dFT,ComplexPart)
    set ::OptDft(ScaleY) $::PCGraphsPriv(dFT,ScaleY)
    set ::OptDft(ScaleX) $::PCGraphsPriv(dFT,ScaleX)
    set ::OptDft(GetXFreq) $::PCGraphsPriv(dFT,GetXFreq)
    set ::OptDft(HalfResults) $::PCGraphsPriv(dFT,HalfResults)

    set f [ ttk::frame $w.f]
    if { ![info exists ::OptDft(Polar)] } { set ::OptDft(Polar) 0 }
    ttk::checkbutton $f.cb_polar -text [_ "Create polar graph"] \
        -variable ::OptDft(Polar) -onvalue 1 -offvalue 0 -command "PCGraphsOptionsdFT_EnableDisableYselection $f ::OptDft(Polar)"
    ttk::label $f.l -text [_ "Select value to be used as y axis"]: 
    ttk::radiobutton $f.rb_r -text [_ "real part"] -variable ::OptDft(ComplexPart) -value real
    ttk::radiobutton $f.rb_i -text [_ "imaginary part"] -variable ::OptDft(ComplexPart) -value imaginary
    ttk::radiobutton $f.rb_m -text [_ "modulus"] -variable ::OptDft(ComplexPart) -value modulus
    ttk::radiobutton $f.rb_f -text [_ "phase"] -variable ::OptDft(ComplexPart) -value phase
    if { ![info exists ::OptDft(GetXFreq)] } { set ::OptDft(GetXFreq) 0 }
    ttk::checkbutton $f.cb_fx -text [_ "Get frequencies as X values"] \
        -variable ::OptDft(GetXFreq) -onvalue 1 -offvalue 0
    if { ![info exists ::OptDft(ScaleX)] } { set ::OptDft(ScaleX) 0 }
    ttk::checkbutton $f.cb_sx -text [_ "Scale X values with number of samples"] \
        -variable ::OptDft(ScaleX) -onvalue 1 -offvalue 0
    if { ![info exists ::OptDft(ScaleY)] } { set ::OptDft(ScaleY) 0 }
    ttk::checkbutton $f.cb_sy -text [_ "Scale Y values with number of samples"] \
        -variable ::OptDft(ScaleY) -onvalue 1 -offvalue 0
    if { ![info exists ::OptDft(HalfResults)] } { set ::OptDft(HalfResults) 0 }
    ttk::checkbutton $f.cb_hr -text [_ "Get only the half of the results"] \
        -variable ::OptDft(HalfResults) -onvalue 1 -offvalue 0

    grid $f.cb_polar -columnspan 2 -sticky w -padx 4 -pady 2
    grid $f.l -columnspan 2 -sticky w -padx 4 -pady 2
    grid $f.rb_r $f.rb_i  -sticky ew -padx 4 -pady 2
    grid $f.rb_m $f.rb_f  -sticky ew -padx 4 -pady 2
    grid $f.cb_fx -columnspan 2 -sticky w -padx 4 -pady 2
    grid $f.cb_sx -columnspan 2 -sticky w -padx 4 -pady 2
    grid $f.cb_sy -columnspan 2 -sticky w -padx 4 -pady 2
    grid $f.cb_hr -columnspan 2 -sticky w -padx 4 -pady 2

    grid columnconfigure $f 0 -weight 1
    grid columnconfigure $f 1 -weight 1

    ttk::frame $w.but -style BottomFrame.TFrame

    ttk::button $w.but.apply -text [_ "Apply"] -command "PCGraphsOptionsdFTWinApply $w" -takefocus 1 -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command "PCGraphsOptionsdFTWinClose $w" -takefocus 1 -style BottomFrame.TButton
    
    grid $w.but.apply -sticky ews -padx 6 -pady 12
    grid $w.but.close -sticky ews -padx 6 -pady 12 -row 0 -column 1

    #enpaquetamos marcos
    grid $w.f -sticky news -padx 2 -pady 2
    grid $w.but -sticky wes
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    focus $w.but.apply
    bind $w <Return> "$w.but.apply invoke"
    bind $w <Alt-c> "$w.but.close invoke"
    bind $w <Escape> "$w.but.close invoke"
    
    tkwait window $w
}

proc PCGraphsDefineOperators {} {
    #set all_operadores "+ - * / y1x2z1" ;#"y1x2z1" is an example selecting mixed components of both
    set ::PCGraphsPriv(ListOperators)  [ list \
                                             + - * / \
                                             SqrtAbs Abs LogAbs Log10Abs \
                                             db10 db20 Exp Pow10 \
                                             1/ derivate integral fit \
                                             dFT inv-dFT \
                                             CubicSpline CatmullRomSpline ]
    # LogCubicSpline LogCatmullRomSpline
    # list of operators which operate over the whole graph
    set ::PCGraphsPriv(GlobalOperators) [ list derivate integral dFT inv-dFT fit \
                                              CubicSpline CatmullRomSpline ]
    #LogCubicSpline LogCatmullRomSpline
    set ::PCGraphsPriv(ListParameters) [ list \
                                             2 2 2 2 \
                                             1 1 1 1 \
                                             1 1 1 1 \
                                             1 1 1 2 \
                                             1 1 \
                                             1 1]
    # 1 1
    set ::PCGraphsPriv(ListProcessXY)  [ list \
                                             1 1 1 1 \
                                             1 1 1 1 \
                                             1 1 1 1 \
                                             1 0 0 1 \
                                             0 0 \
                                             0 0]
    # 0 0
    set ::PCGraphsPriv(ListOptionsCmd)  [ list \
                                              "" "" "" "" \
                                              "" "" "" "" \
                                              "" "" "" "" \
                                              "" PCGraphsOptionsDerivate "" ""\
                                              PCGraphsOptionsdFT "" \
                                              PCGraphsOptionsCubicSpline PCGraphsOptionsCatmullRomSpline]
    if { [ llength $::PCGraphsPriv(ListOperators)] != [ llength $::PCGraphsPriv(ListParameters)] } {
        WarnWin "Operator list not well defined. Shortening it."
        if { [ llength $::PCGraphsPriv(ListOperators)] > [ llength $::PCGraphsPriv(ListParameters)]} {
            set ::PCGraphsPriv(ListOperators) [ lrange $::PCGraphsPriv(ListOperators) 0 [ llength ::PCGraphsPriv(ListParameters)]]
        } elseif { [ llength $::PCGraphsPriv(ListOperators)] < [ llength $::PCGraphsPriv(ListParameters)]} {
            set ::PCGraphsPriv(ListParameters) [ lrange $::PCGraphsPriv(ListParameters) 0 [ llength ::PCGraphsPriv(ListOperators)]]
        }
    }
}

proc PCGraphsGetOperatorProcessXYFlag {} {
    set ret 1
    if { [ info exists ::PCGraphsPriv(operador)]} {
        set idx [ lsearch $::PCGraphsPriv(ListOperators) $::PCGraphsPriv(operador)]
        if { $idx != -1} {
            set ret [ lindex $::PCGraphsPriv(ListProcessXY) $idx]
        }
    }
    return $ret
}

proc PCGraphsGetOperatorParameters {} {
    set ret 2
    if { [ info exists ::PCGraphsPriv(operador)]} {
        set idx [ lsearch $::PCGraphsPriv(ListOperators) $::PCGraphsPriv(operador)]
        if { $idx != -1} {
            set ret [ lindex $::PCGraphsPriv(ListParameters) $idx]
        }
    }
    return $ret
}

proc PCGraphsGetOperatorOptionCmd {} {
    set ret ""
    if { [ info exists ::PCGraphsPriv(operador)]} {
        set idx [ lsearch $::PCGraphsPriv(ListOperators) $::PCGraphsPriv(operador)]
        if { $idx != -1} {
            set ret [ lindex $::PCGraphsPriv(ListOptionsCmd) $idx]
        }
    }
    return $ret
}

proc PCGraphsCreateMenuOperators { w cmd_in} {
    global GidPriv RMenuRPriv

    rmenuinit
    PCGraphsDefineOperators
    set all_operadores $::PCGraphsPriv(ListOperators)

    $w delete 0 end
    foreach i $all_operadores {       
        $w add command -label $i -command [list {*}$cmd_in $i] -compound left 
    }
}

proc PCGraphsUpdateOperationText { w args} {
    global PCGraphsPriv
    set ::PCGraphsPriv(operador) [ lindex $args 0]
    set ::PCGraphsPriv(parametros) [ PCGraphsGetOperatorParameters]
    if { ( $::PCGraphsPriv(parametros) == 1) && ( $::PCGraphsPriv(Op2Typ) != "graph")} {
        WarnWin [_ "The selected operation needs a graph as operand."]
    }
    $w configure -text "   $PCGraphsPriv(operador)   "

    # enable / disable first parameter
    if { $::PCGraphsPriv(parametros) == 1} {
        PCGraphsSetGraphFrameState 1 disabled
    } else {
        PCGraphsSetGraphFrameState 1 normal
    }

    # enable / disable process checkboxes
    if { [ PCGraphsGetOperatorProcessXYFlag]} {
        PCGraphs_EnableDisableProcessXY normal
    } else {
        PCGraphs_EnableDisableProcessXY disabled
    }

    # enable / disable options button
    PCGraphs_EnableDisableOptionsButton
}

proc PCGraphsSelectOperacion { w text_id} {
    global PCGraphsPriv

    if { ![ winfo exists $w.m]} {
        menu $w.m
    }
    PCGraphsDefineOperators
    PCGraphsCreateMenuOperators $w.m "PCGraphsUpdateOperationText $text_id"
    $w.m post [ winfo pointerx $w] [ winfo pointery $w]
}

proc PCGraphsApply { } {
    global PCGraphsPriv

    if { ![ info exists ::PCGraphsPriv(parametros)] || ![ info exists ::PCGraphsPriv(operador)]} {
        WarnWin [_ "Please, choose a correct operator"]
        return
    }

    if { $::PCGraphsPriv(parametros) == 1} {
        if { ![ info exists ::PCGraphsPriv(graph2)]} {
            WarnWin [_ "Please, choose a correct graph"]
            return
        }
        set ::PCGraphsPriv(graph1) $::PCGraphsPriv(graph2)
            if { ( $::PCGraphsPriv(parametros) == 1) && ( $::PCGraphsPriv(Op2Typ) != "graph")} {
                WarnWin [_ "The selected operation needs a graph as operand."]
                return
            }
    } elseif { ( $::PCGraphsPriv(Op2Typ) != "graph")} {
            set PCGraphsPriv(graph2) $::PCGraphsPriv(graph1)
    }

    foreach d {graph1 operador graph2 graphdest} \
            txt {{First graph} Operator {Second graph} {Graph destination name}} \
            txt_trad [list [_ "First graph"] [_ "Operator"] [_ "Second graph"] [_ "Graph destination name"]] {
            if { ![ info exists ::PCGraphsPriv($d)]} {
                set txt1 [_ "Please, choose a correct '%s'" $txt_trad]
                WarnWin $txt1
                return
            }
    }

    # check length and values
    set graph_label_x1 ""
    set graph_label_y1 ""
    set graph_label_x2 ""
    set graph_label_y2 ""
    if { $::PCGraphsPriv(parametros) == 2} {
        set err [ catch {
            set graph_info1 [ GiD_Graph get $::PCGraphsPriv(graph1)]
            set graph_label_x1 [lindex $graph_info1 0]
            set graph_label_y1 [lindex $graph_info1 1]              
        } errtxt ]
        if { !$err} {
            if { [ llength [ lindex $graph_info1 2]] == 0} {
                WarnWin [_ "Graph1 '%s' does not exist." $PCGraphsPriv(graph1)]
                return
            }
        }
        if { $err} {
            WarnWin [_ "Graph1 '%s' does not exist: %s" $PCGraphsPriv(graph1) $errtxt]
            return
        }
    }    
    set err [ catch {
        set graph_info2 [ GiD_Graph get $::PCGraphsPriv(graph2)]
        set graph_label_x2 [lindex $graph_info2 0]
        set graph_label_y2 [lindex $graph_info2 1]
    } errtxt ]
    if { !$err} {
        if { [ llength [ lindex $graph_info2 2]] == 0} {
            WarnWin [_ "Graph2 '%s' does not exist." $PCGraphsPriv(graph2)]
                return
        }
    }
    if { $err} {
        WarnWin [_ "Graph2 '%s' does not exist: %s" $PCGraphsPriv(graph2) $errtxt]
        return
    }

    #both graphs must be defined on the same base points
    if { !$::PCGraphsPriv(operate,x)} {
        #normal case y=f(x)
        set index_x 2
        set index_y 3
        set index_unit_x 4
        set index_unit_y 5
    } else {
        #swapped case x=f(y)
        set index_x 3
        set index_y 2
        set index_unit_x 5
        set index_unit_y 4
    }
    
    set unit_x2 [lindex $graph_info2 $index_unit_x]
    set unit_y2 [lindex $graph_info2 $index_unit_y]
    if { $::PCGraphsPriv(parametros) == 2} {
        set unit_x1 [lindex $graph_info1 $index_unit_x]
        set unit_y1 [lindex $graph_info1 $index_unit_y]
        set xs1 [lindex $graph_info1 $index_x]
        set xs2 [lindex $graph_info2 $index_x]
        if { $xs1 != $xs2 } {    
            #force graphs to be defined on the same base points
            set ys1 [lindex $graph_info1 $index_y]            
            set ys2 [lindex $graph_info2 $index_y]
            set points [list ]
            foreach x $xs1 y $ys1 {
                lappend points [list $x $y ""]
            }     
            foreach x $xs2 y $ys2 {
                lappend points [list $x "" $y]
            }    
            set points [lsort -real -index 0 $points]       
            set newpoints [list ]
            set n [llength $points]            
            for {set i 0} {$i<$n} {incr i} {
                lassign [lindex $points $i] x f g
                if {$f == ""} {
                    set index 1
                } elseif {$g == ""} {
                    set index 2
                }
                if {$f == "" || $g == ""} {                    
                    set f_prev ""
                    set i_prev [expr $i-1]                    
                    while { $i_prev >= 0 } {
                        lassign [lindex $points $i_prev] x_prev v(1) v(2)
                        if { $v($index) != "" } {
                            set f_prev $v($index)
                            break
                        }                        
                        incr i_prev -1
                    }
                    set f_next ""
                    set i_next [expr $i+1]                    
                    while { $i_next < $n } {
                        lassign [lindex $points $i_next] x_next v(1) v(2)
                        if { $v($index) != "" } {
                            set f_next $v($index)
                            break
                        }                        
                        incr i_next
                    }
                    if { $f_prev != "" && $f_next != "" } {
                        set alpha [expr ($x-$x_prev)/($x_next-$x_prev)] 
                        if { $alpha < 1e-15 } {
                            continue
                        }
                        set y [expr {(1.0-$alpha)*$f_prev+$alpha*$f_next}]
                        if {$f == ""} {
                            set f $y
                        } elseif {$g == ""} {
                            set g $y
                        }
                    } else {
                        continue
                    }
                }
                lappend newpoints [list $x $f $g]                
            }
            set newx [list ]
            set newf1 [list ]
            set newf2 [list ]
            foreach point $newpoints {
                lassign $point x f1 f2
                if { $f1 != "" && $f2 != "" } {
                    lappend newx $x
                    lappend newf1 $f1
                    lappend newf2 $f2
                } else {
                    incr not_interpolated
                }
            }
            lset graph_info1 $index_x $newx
            lset graph_info1 $index_y $newf1
            lset graph_info2 $index_x $newx
            lset graph_info2 $index_y $newf2                        
        }
    }
    set new_unit_x ""
    set new_unit_y ""        
    set units_error ""
    if { $::PCGraphsPriv(parametros) == 2} {
        if { $unit_x1 != $unit_x2 } {
            set units_error [_ "Graphs have incompatible units: %s %s" $unit_x1 $unit_x2]
        }
        set new_unit_x $unit_x1
        if { $::PCGraphsPriv(operador) == "+" || $::PCGraphsPriv(operador) == "-" } {
            if { $unit_y1 != $unit_y2 } {
                set units_error [_ "Graphs have incompatible units: %s %s" $unit_y1 $unit_y2]
            }
            set new_unit_y $unit_y1
        } elseif { $::PCGraphsPriv(operador) == "*" || $::PCGraphsPriv(operador) == "/" } {
            set new_unit_y ${unit_y1}${::PCGraphsPriv(operador)}${unit_y2}
        } else {
            #unexpected case
        }
    } else {
        set new_unit_x $unit_x2
        set new_unit_y $unit_y2
    }    
    if { $units_error != "" } {
        WarnWin $units_error
        return 1
    }
    

    if { $::PCGraphsPriv(Op2Typ) == "constant"} {
        if { $::PCGraphsPriv(operate,x)} {
            set graph_label_x2 $::PCGraphsPriv(Op2Typ,a)
        } else {
            set graph_label_x2 $graph_label_x1
        }
        if { $::PCGraphsPriv(operate,y)} {
            set graph_label_y2 $::PCGraphsPriv(Op2Typ,b)
        } else {
            set graph_label_y2 $graph_label_y1
        }
    }    

    # set header
    set new_title $::PCGraphsPriv(graphdest)
    set new_label_x "$graph_label_x1 $::PCGraphsPriv(operador) $graph_label_x2"
    set new_label_y "$graph_label_y1 $::PCGraphsPriv(operador) $graph_label_y2"

    # get first graph operand
    set graph1(n_comp) 0
    if { $::PCGraphsPriv(parametros) == 2} {
        # create array first graph
        set idx 0
        foreach x [ lindex $graph_info1 2] y [ lindex $graph_info1 3]  {
            set graph1($idx,0) $x
            set graph1($idx,1) $y
            incr idx
        }
        set graph1(n_comp) $idx
        set num_items $graph1(n_comp)
    }
 
    # get second graph operand    
    set graph2(n_comp) 0
    if { $::PCGraphsPriv(Op2Typ) == "graph"} {
        # create array second graph
        set idx 0
        foreach x [ lindex $graph_info2 2] y [ lindex $graph_info2 3]  {
            set graph2($idx,0) $x
            set graph2($idx,1) $y
            incr idx
        }
        set graph2(n_comp) $idx
        set num_items $graph2(n_comp)

    } elseif { $::PCGraphsPriv(Op2Typ) == "constant"} {        
        for { set idx 0} { $idx < $graph1(n_comp)} { incr idx} {
            if { $::PCGraphsPriv(operate,x)} {
                set graph2($idx,0) $::PCGraphsPriv(Op2Typ,a)
            } else {
                set graph2($idx,0) $graph1($idx,0) 
            }
            if { $::PCGraphsPriv(operate,y)} {
                set graph2($idx,1) $::PCGraphsPriv(Op2Typ,b)
            } else {
                set graph2($idx,1) $graph1($idx,1) 
            }
        }
        set graph2(n_comp) $graph1(n_comp)
        set num_items $graph2(n_comp)
    }

     
    if { $::PCGraphsPriv(parametros) == 2} {
        unset graph_info1
    }
    unset graph_info2

    # "fit" operator allows different number of items, it only adjusts the bounding boxes
    if { $::PCGraphsPriv(operador) != "fit"} {
        if { ( $::PCGraphsPriv(parametros) == 2)} {
            if { $graph1(n_comp) != $graph2(n_comp)} {
                WarnWin [_ "Different number of values ( %d != %d), please check the graphs selected" $graph1(n_comp) $graph2(n_comp)]                
                return
            }
        }
    }

    set n_chivato 0

    set new_lst_x {}
    set new_lst_y {}
    
    # "fit" operator allows different number of items, it only adjusts the bounding boxes
    if { $::PCGraphsPriv(operador) != "fit"} {
        # check x values if boths graphs match
        if { !$::PCGraphsPriv(operate,x) && ( $::PCGraphsPriv(parametros) == 2) && ( $::PCGraphsPriv(Op2Typ) == "graph")} {
            for { set i 0} { $i < $num_items} { incr i} {
                if { $graph1($i,0) != $graph2($i,0)} {
                    WarnWin [_ "X values do not match between '%s' and '%s'." $::PCGraphsPriv(graph1) $::PCGraphsPriv(graph2)]
                    return
                }
            }
        }
        
        # check y values if boths graphs match
        if { !$::PCGraphsPriv(operate,y) && ( $::PCGraphsPriv(parametros) == 2) && ( $::PCGraphsPriv(Op2Typ) == "graph")} {
            for { set i 0} { $i < $num_items} { incr i} {
                if { $graph1($i,1) != $graph2($i,1)} {
                    WarnWin [_ "Y values do not match between '%s' and '%s'." $::PCGraphsPriv(graph1) $::PCGraphsPriv(graph2)]
                    return
                }
            }
        }
    }

    set global_operators $::PCGraphsPriv(GlobalOperators)
    # * and + are a regexp wildcards
    if { [ lsearch -exact $global_operators $::PCGraphsPriv(operador)] == -1} {
        for { set i 0} { $i < $num_items} { incr i} {
            if { $::PCGraphsPriv(parametros) == 2} {
                if { $::PCGraphsPriv(operate,x)} {
                    set new_x [ expr $graph1($i,0) $::PCGraphsPriv(operador) $graph2($i,0)]
                } else {
                    set new_x $graph1($i,0)
                }
                if { $::PCGraphsPriv(operate,y)} {
                    set new_y [ expr $graph1($i,1) $::PCGraphsPriv(operador) $graph2($i,1)]
                } else {
                    set new_y $graph1($i,1)
                }
            } elseif  { $::PCGraphsPriv(parametros) == 1} {
                # SqrtAbs Abs Log10Abs db10 db20 Exp 1/
                switch $::PCGraphsPriv(operador) {
                    SqrtAbs {
                        set new_x [ expr sqrt( abs( $graph2($i,0)))]
                        set new_y [ expr sqrt( abs( $graph2($i,1)))]
                    }
                    Abs {
                        set new_x [ expr abs( $graph2($i,0))]
                        set new_y [ expr abs( $graph2($i,1))]
                    }
                    LogAbs {
                        set new_x [ do_LogAbs $graph2($i,0)]
                        set new_y [ do_LogAbs $graph2($i,1)]
                    }
                    Log10Abs {
                        set new_x [ do_Log10Abs $graph2($i,0)]
                        set new_y [ do_Log10Abs $graph2($i,1)]
                    }
                    db10 {
                        set new_x [ expr 10.0 * [ do_Log10Abs $graph2($i,0)]]
                        set new_y [ expr 10.0 * [ do_Log10Abs $graph2($i,1)]]
                    }
                    db20 {
                        set new_x [ expr 20.0 * [ do_Log10Abs $graph2($i,0)]]
                        set new_y [ expr 20.0 * [ do_Log10Abs $graph2($i,1)]]
                    }
                    Exp {
                        set new_x [ do_Exp $graph2($i,0)]
                        set new_y [ do_Exp $graph2($i,1)]
                    }
                    Pow10 {
                        set new_x [ do_Pow10 $graph2($i,0)]
                        set new_y [ do_Pow10 $graph2($i,1)]
                    }
                    1/ {
                        set new_x [ do_Inverse $graph2($i,0)]
                        set new_y [ do_Inverse $graph2($i,1)]
                    }
                } 
                if { !$::PCGraphsPriv(operate,x)} {
                    set new_x $graph2($i,0)
                } 
                if { !$::PCGraphsPriv(operate,y)} {
                    set new_x $graph2($i,1)
                }
                # end switch
            }
            lappend new_lst_x $new_x
            lappend new_lst_y $new_y
            
            incr n_chivato
            if { $n_chivato == 1000} {
                set ::PCGraphsPriv(var) [ expr int( ( ( ( 100.0 * $i) / $graph1(n_comp))))]
                update idletasks
                update
            }
        }
        # end for
    } else {
        # the operator is global, like: derivate, integral, dft, inv-dft, spline...
        # set global_operators [ list dFT inv-dFT]
        package require math::fourier
        package require math::complexnumbers
        package require math
        package require spline

        set new_lst_x {}
        set new_lst_y {}
        switch $::PCGraphsPriv(operador) {
            derivate {
                set offset $::PCGraphsPriv(Derivate,Offset)
                if { $::PCGraphsPriv(operate,x) && $::PCGraphsPriv(operate,y)} {
                    set new_lst_x {}
                    set new_lst_y {}
                    set last_x $graph2(0,0)
                    set last_y $graph2(0,1)
                    for { set i 1} { $i < $num_items} { incr i} {
                        set dif_x [ expr $graph2($i,0) - $last_x]
                        set dif_y [ expr $graph2($i,1) - $last_y]
                        set deriv_x [ filter_float $dif_x]
                        set deriv_y [ filter_float $dif_y]
                        lappend new_lst_x $deriv_x
                        lappend new_lst_y $deriv_y
                        set last_x $graph2($i,0)
                        set last_y $graph2($i,1)
                    }
                    set new_title "deltas( $::PCGraphsPriv(graph2))"
                    set new_label_x "delta( $graph_label_x2)"
                    set new_label_y "delta( $graph_label_y2)"
                } elseif { $::PCGraphsPriv(operate,x)} {
                    set new_lst_x {}
                    set new_lst_y {}
                    set last_x $graph2(0,0)
                    set last_y $graph2(0,1)
                    for { set i 1} { $i < $num_items} { incr i} {
                        set dif_x [ expr $graph2($i,0) - $last_x]
                        set dif_y [ expr $graph2($i,1) - $last_y]
                        set deriv_x [ filter_float [ expr $dif_x / $dif_y]]
                        set deriv_y [ expr $last_y + $offset * $dif_y]
                        lappend new_lst_x $deriv_x
                        lappend new_lst_y $deriv_y
                        set last_x $graph2($i,0)
                        set last_y $graph2($i,1)
                    }
                    set new_title "derivate( $::PCGraphsPriv(graph2))"
                    set new_label_x "derivate( $graph_label_x2)"
                    set new_label_y $graph_label_y2
                } elseif { $::PCGraphsPriv(operate,y)} {
                    # typical use
                    set new_lst_x {}
                    set new_lst_y {}
                    set last_x $graph2(0,0)
                    set last_y $graph2(0,1)
                    for { set i 1} { $i < $num_items} { incr i} {
                        set dif_x [ expr $graph2($i,0) - $last_x]
                        set dif_y [ expr $graph2($i,1) - $last_y]
                        set deriv_x [ expr $last_x + $offset * $dif_x]
                        set deriv_y [ filter_float [ expr $dif_y / $dif_x]]
                        lappend new_lst_x $deriv_x
                        lappend new_lst_y $deriv_y
                        set last_x $graph2($i,0)
                        set last_y $graph2($i,1)
                    }
                    set new_title "derivate( $::PCGraphsPriv(graph2))"
                    set new_label_x $graph_label_x2
                    set new_label_y "derivate( $graph_label_y2)"
                }
            }
            integral {
                if { $::PCGraphsPriv(operate,x) && $::PCGraphsPriv(operate,y)} {
                    set new_lst_x {}
                    set new_lst_y {}
                    set last_x $graph2(0,0)
                    set last_y $graph2(0,1)
                    set accum_x 0.0
                    set accum_y 0.0
                    lappend new_lst_x 0.0
                    lappend new_lst_y 0.0
                    for { set i 1} { $i < $num_items} { incr i} {
                        set dif_x [ expr $graph2($i,0) - $last_x]
                        set dif_y [ expr $graph2($i,1) - $last_y]
                        set area_x [ expr double( $graph2($i,0) + $last_x) * $dif_y * 0.5]
                        set accum_x [ expr $accum_x + $area_x]
                        set area_y [ expr double( $graph2($i,1) + $last_y) * $dif_x * 0.5]
                        set accum_y [ expr $accum_y + $area_y]
                        lappend new_lst_x $accum_x
                        lappend new_lst_y $accum_y
                        set last_x $graph2($i,0)
                        set last_y $graph2($i,1)
                    }
                    set new_title "integral( $::PCGraphsPriv(graph2))"
                    set new_label_x "accumulated( $graph_label_x2)"
                    set new_label_y "accumulated( $graph_label_y2)"
                } elseif { $::PCGraphsPriv(operate,x)} {
                    set new_lst_x {}
                    set new_lst_y {}
                    set last_x $graph2(0,0)
                    set last_y $graph2(0,1)
                    set accum 0.0
                    lappend new_lst_x 0.0
                    lappend new_lst_y $graph2(0,1)
                    for { set i 1} { $i < $num_items} { incr i} {
                        set dif_x [ expr $graph2($i,0) - $last_x]
                        set dif_y [ expr $graph2($i,1) - $last_y]
                        set area [ expr double( $graph2($i,0) + $last_x) * $dif_y * 0.5]
                        set accum [ expr $accum + $area]
                        lappend new_lst_x $accum
                        lappend new_lst_y $graph2($i,1)
                        set last_x $graph2($i,0)
                        set last_y $graph2($i,1)
                    }
                    set new_title "integral( $::PCGraphsPriv(graph2))"
                    set new_label_x "accumulated( $graph_label_x2)"
                    set new_label_y $graph_label_y2
                } elseif { $::PCGraphsPriv(operate,y)} {
                    # typical use
                    set new_lst_x {}
                    set new_lst_y {}
                    set last_x $graph2(0,0)
                    set last_y $graph2(0,1)
                    set accum 0.0
                    lappend new_lst_x $graph2(0,0)
                    lappend new_lst_y 0.0
                    for { set i 1} { $i < $num_items} { incr i} {
                        set dif_x [ expr $graph2($i,0) - $last_x]
                        set dif_y [ expr $graph2($i,1) - $last_y]
                        set area [ expr double( $graph2($i,1) + $last_y) * $dif_x * 0.5]
                        set accum [ expr $accum + $area]
                        lappend new_lst_x $graph2($i,0)
                        lappend new_lst_y $accum
                        set last_x $graph2($i,0)
                        set last_y $graph2($i,1)
                    }
                    set new_title "integral( $::PCGraphsPriv(graph2))"
                    set new_label_x $graph_label_x2
                    set new_label_y "accumulated( $graph_label_y2)"
                }
            }
            dFT {
                # dft( real) --> complex( r, i)
                # input lists
                set lst_x_values {}
                set lst_y_values {}
                set accum_x 0.0
                set last_x 0.0
                for { set i 0} { $i < $num_items} { incr i} {
                    lappend lst_x_values $graph2($i,0)
                    lappend lst_y_values $graph2($i,1)
                    if { $i} {
                        set accum_x [ expr $accum_x + ( $graph2($i,0) - $last_x)]
                    }
                    set last_x $graph2($i,0)
                }
                # media del time step...
                set dt [ expr $accum_x / ( $num_items - 1)]
                set df [ expr 1.0 / $dt]
                # do it
                set dft_complex_values [ math::fourier::dft $lst_y_values]
                # output lists
                set new_lst_x {}
                set new_lst_y {}
                set x_idx 1
                set inv_num [ expr 1.0 / $num_items]
                set inv_num_x [ expr 1.0 / $num_items]
                set inv_num_y [ expr 1.0 / ( 0.5 * $num_items)]
                set fin [ llength $dft_complex_values]
                if { $::PCGraphsPriv(dFT,HalfResults)} {
                    set fin [ expr int( 0.5 + double( $fin) / 2.0)]
                }
                foreach complex $dft_complex_values {
                    set dft_a [ math::complexnumbers::real $complex]
                    set dft_b [ math::complexnumbers::imag $complex]
                    if { $::PCGraphsPriv(dFT,Polar)} {
                        set dft_a [ expr $dft_a * $inv_num_y]
                        set dft_b [ expr $dft_b * $inv_num_y]
                        set mod [ expr sqrt( $dft_a * $dft_a + $dft_b * $dft_b)]
                        set phase [ expr atan2( $dft_b, $dft_a)]
                        set x_val $phase
                        set y_val $mod
                    } else {
                        if { $::PCGraphsPriv(dFT,ScaleY)} {
                            set dft_a [ expr $dft_a * $inv_num_y]
                            set dft_b [ expr $dft_b * $inv_num_y]
                        }
                        switch $::PCGraphsPriv(dFT,ComplexPart) {
                            real {
                                set y_val $dft_a
                            }
                            imaginary {
                                set y_val $dft_b
                            }
                            modulus {
                                set y_val [ expr sqrt( $dft_a * $dft_a + $dft_b * $dft_b)]
                            }
                            phase {
                                set y_val [ expr atan2( $dft_b, $dft_a)]
                            }
                        }
                        set x_val $x_idx
                        if { $::PCGraphsPriv(dFT,GetXFreq)} {
                            set x_val [ expr $df * ( $x_idx - 1)]
                        }
                        if { $::PCGraphsPriv(dFT,ScaleX)} {
                            set x_val [ expr $x_val * $inv_num_x]
                        }
                    }
                    lappend new_lst_x $x_val
                    lappend new_lst_y $y_val
                    incr x_idx
                    if { $x_idx > $fin} {
                        break
                    }
                }
                if { $::PCGraphsPriv(dFT,Polar)} {
                    set new_title "dFT( $::PCGraphsPriv(graph2))"
                    set new_label_x "phase"
                    set new_label_y "mod"
                } else {
                    set new_title "dFT( $::PCGraphsPriv(graph2))"
                    if { $::PCGraphsPriv(dFT,GetXFreq)} {
                        set new_label_x "freq"
                    } else {
                        set new_label_x "idx"
                    }
                    set new_label_y "dFT.$::PCGraphsPriv(dFT,ComplexPart)"
                }
            }
            inv-dFT {
                # inv-dFT( r, i) --> ( idx, r)
                # incput lists
                set lst_complex_values {}
                for { set i 0} { $i < $num_items} { incr i} {
                    lappend lst_complex_values [ math::complexnumbers::complex $graph2($i,0) $graph2($i,1)]
                }
                # do it
                set dft_complex_values [ math::fourier::inverse_dft $lst_complex_values]
                # output lists
                set new_lst_x {}
                set new_lst_y {}
                set x_idx 1
                foreach complex $dft_complex_values {
                    lappend new_lst_x $x_idx
                    lappend new_lst_y [ math::complexnumbers::real $complex]
                    incr x_idx
                }
                set new_title "idFT( $::PCGraphsPriv(graph2))"
                set new_label_x "index"
                set new_label_y "idFT"
            }
            fit {
                #get min max of both graphs
                set g1_lst_x {}
                set g1_lst_y {}
                set g2_lst_x {}
                set g2_lst_y {}
                for { set i 0} { $i < $graph1(n_comp)} { incr i} {
                    lappend g1_lst_x $graph1($i,0)
                    lappend g1_lst_y $graph1($i,1)
                }
                for { set i 0} { $i < $graph2(n_comp)} { incr i} {
                    lappend g2_lst_x $graph2($i,0)
                    lappend g2_lst_y $graph2($i,1)
                }
                set g1_min_x [ math::min {*}$g1_lst_x]
                set g1_max_x [ math::max {*}$g1_lst_x]
                set g1_min_y [ math::min {*}$g1_lst_y]
                set g1_max_y [ math::max {*}$g1_lst_y]
                set g2_min_x [ math::min {*}$g2_lst_x]
                set g2_max_x [ math::max {*}$g2_lst_x]
                set g2_min_y [ math::min {*}$g2_lst_y]
                set g2_max_y [ math::max {*}$g2_lst_y]
                set new_lst_x {}
                set new_lst_y {}
                # fit x values
                if { $::PCGraphsPriv(operate,x)} {
                    set g1_dif_x [ expr $g1_max_x - $g1_min_x]
                    set g2_dif_x [ expr $g2_max_x - $g2_min_x]
                    if { $g2_dif_x != 0.0} {
                        set fact_x [ expr $g1_dif_x / $g2_dif_x]
                    } else {
                        set fact_x 0.0
                    }
                    for { set i 0} { $i < $graph2(n_comp)} { incr i} {
                        set new_x [ expr $g1_min_x + ( $graph2($i,0) - $g2_min_x) * $fact_x]
                        lappend new_lst_x $new_x
                    }
                    set new_label_x "fit( $graph_label_x2)"
                } else {
                    set new_lst_x $g2_lst_x
                    set new_label_x $graph_label_x2
                }
                # fit y values
                if { $::PCGraphsPriv(operate,y)} {
                    set g1_dif_y [ expr $g1_max_y - $g1_min_y]
                    set g2_dif_y [ expr $g2_max_y - $g2_min_y]
                    if { $g2_dif_y != 0.0} {
                        set fact_y [ expr $g1_dif_y / $g2_dif_y]
                    } else {
                        set fact_y 0.0
                    }
                    for { set i 0} { $i < $graph2(n_comp)} { incr i} {
                        set new_y [ expr $g1_min_y + ( $graph2($i,1) - $g2_min_y) * $fact_y]
                        lappend new_lst_y $new_y
                    }
                    set new_label_y "fit( $graph_label_y2)"
                } else {
                    set new_lst_y $g2_lst_y
                    set new_label_y $graph_label_y2
                }
                set new_title "fit $::PCGraphsPriv(graph2) as $::PCGraphsPriv(graph1)"
            }
            CubicSpline {
                # There are interpolation problems when near to '0' or when dy >> dx
                # https://en.wikipedia.org/wiki/Spline_interpolation
                # https://en.wikipedia.org/wiki/Lagrange_polynomial
                # get dy
                set min_y $graph2(0,1)
                set max_y $graph2(0,1)
                for { set i 0} { $i < $num_items} { incr i} {
                    set y $graph2($i,1)
                    if { $y < $min_y} { set min_y $y}
                    if { $y > $max_y} { set max_y $y}
                }
                set dy [ expr $max_y - $min_y]
                set factor_x [ expr $dy * 10.0]
                # input lists
                set lst_vertices {}
                for { set i 0} { $i < $num_items} { incr i} {
                    lappend lst_vertices [ expr $graph2($i,0) * $factor_x] $graph2($i,1)
                }
                set Precision $::PCGraphsPriv(CubicSpline,Precision)
                set aprox [ spline::Cubic $lst_vertices $Precision]
                set new_lst_x {}
                set new_lst_y {}
                foreach {x y} $aprox {
                    lappend new_lst_x [ expr $x / $factor_x]
                    lappend new_lst_y $y
                }
                set new_title "CubicSpline( $::PCGraphsPriv(graph2))"
                set new_label_x $graph_label_x2
                set new_label_y $graph_label_y2
            }
            CatmullRomSpline {           
                set NumPoints $::PCGraphsPriv(CatmullRomSpline,NumPoints)
                set length 0.0
                set last_x $graph2(0,0)
                set last_y $graph2(0,1)
                set lst_vertices [ list $graph2(0,0) $graph2(0,1)]
                for { set i 1} { $i < $num_items} { incr i} {
                    lappend lst_vertices $graph2($i,0) $graph2($i,1)
                    set dif_x [ expr $graph2($i,0) - $last_x]
                    set dif_y [ expr $graph2($i,1) - $last_y]
                    set last_x $graph2($i,0)
                    set last_y $graph2($i,1)
                    set length [ expr $length + sqrt( $dif_x * $dif_x + $dif_y * $dif_y)]
                }
                # 0.9999 : to adjust some floating precision issues
                set StepWidth [ expr double( 0.9999 * $length) / double( $NumPoints - 1)]
                if { $StepWidth <= 0.0} {
                    set StepWidth 1.0
                }
                set aprox [ spline::getSpline $lst_vertices $StepWidth]
                set new_lst_x {}
                set new_lst_y {}
                foreach {x y} $aprox {
                    lappend new_lst_x $x
                    lappend new_lst_y $y
                }
                set new_title "CubicSpline( $::PCGraphsPriv(graph2))"
                set new_label_x $graph_label_x2
                set new_label_y $graph_label_y2
            }
            ### LogCubicSpline {
            ###         # input lists
            ###         set lst_vertices {}
            ###         for { set i 0} { $i < $num_items} { incr i} {
            ###             lappend lst_vertices [ do_Exp $graph2($i,0)] [ do_Exp $graph2($i,1)]
            ###         }
            ###         # WarnWinText "$lst_vertices"
            ###         set Precision $::PCGraphsPriv(CubicSpline,Precision)
            ###         # WarnWin "precision = $::PCGraphsPriv(CubicSpline,Precision)"
            ###         set aprox [ spline::Cubic $lst_vertices $Precision]
            ###         set new_lst_x {}
            ###         set new_lst_y {}
            ###         foreach {x y} $aprox {
            ###             lappend new_lst_x [ do_LogAbs $x]
            ###             lappend new_lst_y [ do_LogAbs $y]
            ###         }
            ###         set new_title "LogCubicSpline( $::PCGraphsPriv(graph2))"
            ###         set new_label_x $graph_label_x2
            ###         set new_label_y $graph_label_y2
            ###         # WarnWinText $new_lst_x
            ###         # WarnWinText $new_lst_y
            ### }
            ### LogCatmullRomSpline {
            ###         # input lists
            ###         # set lst_vertices {}
            ###         # for { set i 0} { $i < $num_items} { incr i} {
            ###         #     lappend lst_vertices $graph2($i,0) $graph2($i,1)
            ###         # }
            ###         set NumPoints $::PCGraphsPriv(CatmullRomSpline,NumPoints)
            ###         set length 0.0
            ###         set val_x [ do_Exp $graph2(0,0)]
            ###         set val_y [ do_Exp $graph2(0,1)]
            ###         set last_x $val_x
            ###         set last_y $val_y
            ###         set lst_vertices [ list $graph2(0,0) $graph2(0,1)]
            ###         for { set i 1} { $i < $num_items} { incr i} {
            ###             set val_x [ do_Exp $graph2($i,0)]
            ###             set val_y [ do_Exp $graph2($i,1)]
            ###             lappend lst_vertices $val_x $val_y
            ###             set dif_x [ expr $val_x - $last_x]
            ###             set dif_y [ expr $val_y - $last_y]
            ###             set last_x $val_x
            ###             set last_y $val_y
            ###             set length [ expr $length + sqrt( $dif_x * $dif_x + $dif_y * $dif_y)]
            ###         }
            ###         # 0.9999 : to adjust some floating precision issues
            ###         set StepWidth [ expr double( 0.9999 * $length) / double( $NumPoints - 1)]
            ###         # WarnWin "$XstepWidth = double( $length) / double( $NumPoints - 1)"
            ###         if { $StepWidth <= 0.0} {
            ###             set StepWidth 1.0
            ###         }
            ###         set aprox [ spline::getSpline $lst_vertices $StepWidth]
            ###         set new_lst_x {}
            ###         set new_lst_y {}
            ###         foreach {x y} $aprox {
            ###             lappend new_lst_x [ do_LogAbs $x]
            ###             lappend new_lst_y [ do_LogAbs $y]
            ###         }
            ###         set new_title "LogCubicSpline( $::PCGraphsPriv(graph2))"
            ###         set new_label_x $graph_label_x2
            ###         set new_label_y $graph_label_y2
            ### }
        }
    }

    set new_title $::PCGraphsPriv(graphdest)
    if { [lsearch [GiD_Graph list] $new_title] == -1 } {
        GiD_Graph create $new_title $new_label_x $new_label_y $new_lst_x $new_lst_y $new_unit_x $new_unit_y
                PostGraphs::Create
    } else {
        WarnWin [_ "Graph '%s' already exists, select other name" $new_title]
    }
}

proc PCGraphsClose { } {
    global PCGraphsPriv
    destroy $PCGraphsPriv(wid)
}

proc PCGraphsIniVariables { } {
    global PCGraphsPriv
    foreach d "graph1 operador graph2 graphdest" {
        if { [ info exists PCGraphsPriv($d)]} {
            unset PCGraphsPriv($d)
        }
    }
}

proc PCGraphsDeleteGraph { } {
    global PCGraphsPriv

    set err [ catch {
        set graph_info1 [ GiD_Graph get $::PCGraphsPriv(graphdest)]
    } errtxt ]
    if { $err} {
        WarnWin [_ "Graph '%s' does not exist: %s" $::PCGraphsPriv(graphdest) $errtxt]
        return
    }

    if { [ llength $graph_info1]} {
        set resp [MessageBoxOptionsButtons [_ "Warning"] \
                [_ "Do you really want to delete the Graph '%s'?" $::PCGraphsPriv(graphdest)] \
                {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
        switch $resp {
            0 {
                catch {
                    GiD_Graph delete $::PCGraphsPriv(graphdest)
                    GiD_Graph show
                }
                GidUtils::SetWarnLine [_ "Graph '%s' deleted" $::PCGraphsPriv(graphdest)]
            }
            1 {
                return
            }
        }
    }
}

proc PCGraphsSetGraphFrameState { which st} {
    set fr $::PCGraphsPriv(graph,$which,frame)
    if { "$st" == "normal"} {
        $fr.l0 configure -foreground black
        $fr.b0 configure -state normal
    } elseif { "$st" == "disabled"} {
        $fr.l0 configure -foreground $::GidPriv(Color,DisabledForegroundMenu)
        $fr.b0 configure -state disabled
    }
}

proc PCGraphs_EnableDisable2Operand { f_op2 varname} {
    set val [ subst $$varname]
    set state_esc disabled
    set state_res normal
    switch $val {
        constant {
            set state_esc normal
            set state_res disabled
        }
        graph {
            set state_esc disabled
            set state_res normal
        }
    }

    # constant operand
    set f3_esc $f_op2.fe
    # $f3_esc.resc should remain enabled
    foreach w [ list $f3_esc.resc_a $f3_esc.resc_b] {
        $w configure -state $state_esc
    }

    # graph operand
    set f3 $f_op2.f3
    # $f3.rgraph should remain enabled
    foreach w [ list $f3.l0 $f3.b0 ] {
        $w configure -state $state_res
    }

    #actualize state in constant
    if { $state_esc == "normal"} {
        PCGraphs_EnableDisableConstantPart $f3_esc.resc_a ::PCGraphsPriv(operate,x)
        PCGraphs_EnableDisableConstantPart $f3_esc.resc_b ::PCGraphsPriv(operate,y)
    }
}

proc PCGraphs_EnableDisableConstantPart { w varname} {
    if { $::PCGraphsPriv(Op2Typ) == "constant"} {
        set val [ subst $$varname]
        if { $val} {
            $w configure -state normal
        } else {
            $w configure -state disabled
        }
    }
}

proc PCGraphs_EnableDisableProcessXY { state} {
    set f2 $::PCGraphsPriv(process_xy,w)

    $f2.l2 configure -state $state
    $f2.pf.cb_x configure -state $state
    $f2.pf.cb_y configure -state $state
    
}

proc PCGraphs_EnableDisableOptionsButton { } {
    set b $::PCGraphsPriv(OperatorOptions,w)
    set cmd [ PCGraphsGetOperatorOptionCmd]
    if { $cmd != ""} {
        $b configure -command $cmd -state normal
    } else {
        $b configure -command $cmd -state disabled
    }
}

proc PostCreateGraphs { { w .gid.wPostCreateGraphs}} {
    global PCGraphsPriv GidPriv GIDDEFAULT
    
    PCGraphsIniVariables

    InitWindow2 $w -title [_ "Create graph"] \
        -geometryvariable PostCreateGraphsWindowGeom \
        -initcommand PostCreateGraphs
    if { ![ winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set ::PCGraphsPriv(wid) $w
     
    set f [ ttk::frame $w.f]

    set f0 [ ttk::frame $f.f0 -style groove.TFrame]
    ttk::label $f0.l0 -text [ concat [_ "Graph"] " 1"] 
    ttk::button $f0.b0 -text [ concat [_ "Select graph"] " 1"] -command [ list PCGraphsSelectGraph 1 $w $f0.b0]
    if { $::PCGraphsPriv(HorizontalLayout)} {
        grid $f0.l0 -sticky w -padx 4 -pady 2
        grid $f0.b0 -sticky ew -padx 4 -pady 2
        grid columnconfigure $f0 0 -weight 1
    } else {
        grid $f0.l0 $f0.b0 -sticky ew -padx 4 -pady 2
        grid columnconfigure $f0 "0 1" -weight 1
    }
    set ::PCGraphsPriv(graph,1,frame) $f0
    setTooltip $f0 -text [_ "Select a graph as first operand for operators with two operands."] 

    set f2 [ ttk::frame $f.f2]
    ttk::label $f2.l -text [_ "Operator"]: 
    ttk::button $f2.b -text [_ "Select operator"] -command [ list PCGraphsSelectOperacion $w $f2.b]
    ttk::button $f2.bopt -text [_ "Options"]
    set ::PCGraphsPriv(OperatorOptions,w) $f2.bopt
    
    ttk::label $f2.l2 -text [_ "Process"]: 
    ttk::frame $f2.pf -borderwidth 0
    if { ![info exists ::PCGraphsPriv(operate,x)] } { set ::PCGraphsPriv(operate,x) 0 }
    ttk::checkbutton $f2.pf.cb_x -text [_ "x axis"] \
        -variable ::PCGraphsPriv(operate,x) -onvalue 1 -offvalue 0
    if { ![info exists ::PCGraphsPriv(operate,y)] } { set ::PCGraphsPriv(operate,y) 0 }
    ttk::checkbutton $f2.pf.cb_y -text [_ "y axis"] \
        -variable ::PCGraphsPriv(operate,y) -onvalue 1 -offvalue 0
    grid $f2.pf.cb_x $f2.pf.cb_y
    set ::PCGraphsPriv(process_xy,w) $f2

    if { $::PCGraphsPriv(HorizontalLayout)} {
        grid $f2.l $f2.b -sticky ew -padx 4 -pady 2
        grid configure $f2.l -sticky e -padx 4 -pady 2
        grid $f2.l2 $f2.pf -sticky e -padx 4 -pady 2
        grid configure $f2.pf -sticky w -columnspan 2
        grid $f2.bopt -sticky e -column 1 -padx 4 -pady 2
        grid columnconfigure $f2 1 -weight 1
    } else {
        grid $f2.l $f2.b $f2.bopt -sticky ew -padx 4 -pady 2
        grid configure $f2.b -sticky w
        grid configure $f2.bopt -sticky e
        grid $f2.l2 $f2.pf -sticky e -padx 4 -pady 2
        grid configure $f2.pf -sticky w -columnspan 2
        grid columnconfigure $f2 1 -weight 1
    }
    setTooltip $f2 -text [_ "Select operator or the function to operate on graphs.\nOperators like +, -, *, / require two operators, allowing a constant as second operator.\ng1 fit g2 operator fits the bounding box of the second graph g2 to the bounding box of the graph g1. The other functions requires a graph as argument. CubicSpline and Catmull-Rom Spline interpolate a graph. Some operators or functions can be applied on only the x values, only the y values or on both values.\nSome operators have more configurable options."]

    set f3_op2 [ ttk::frame $f.f3_op2 -style groove.TFrame -borderwidth 2]

    # constant frame
    set f3_esc [ ttk::frame $f3_op2.fe -border 0]
    ttk::radiobutton $f3_esc.resc -text [_ "constant"] -variable ::PCGraphsPriv(Op2Typ) -value constant \
        -command "PCGraphs_EnableDisable2Operand $f3_op2 ::PCGraphsPriv(Op2Typ)"
    ttk::entry $f3_esc.resc_a -textvariable ::PCGraphsPriv(Op2Typ,a) -width 8
    ttk::entry $f3_esc.resc_b -textvariable ::PCGraphsPriv(Op2Typ,b) -width 8
    grid $f3_esc.resc $f3_esc.resc_a $f3_esc.resc_b -sticky ew -padx 4 -pady 2
    grid configure $f3_esc.resc -sticky w
    grid configure $f3_esc.resc_a -padx 8
    grid columnconfigure $f3_esc 1 -weight 1
    grid columnconfigure $f3_esc 2 -weight 1

    # state procedures
    $f2.pf.cb_x configure -command "PCGraphs_EnableDisableConstantPart $f3_esc.resc_a ::PCGraphsPriv(operate,x)"
    $f2.pf.cb_y configure -command "PCGraphs_EnableDisableConstantPart $f3_esc.resc_b ::PCGraphsPriv(operate,y)"

    # graph frame
    set f3 [ ttk::frame $f3_op2.f3 ]
    ttk::radiobutton $f3.rgraph -text [_ "graph"] -variable ::PCGraphsPriv(Op2Typ) -value graph \
        -command "PCGraphs_EnableDisable2Operand $f3_op2 ::PCGraphsPriv(Op2Typ)"
    ttk::label $f3.l0 -text [ concat [_ "Graph"] " 2"] 
    ttk::button $f3.b0 -text [ concat [_ "Select graph"] " 2"] -command [ list PCGraphsSelectGraph 2 $w $f3.b0]
    grid $f3.rgraph $f3.l0 $f3.b0 -sticky ew -padx 4 -pady 2
    grid configure $f3.rgraph -sticky w
    grid configure $f3.l0 -sticky e -padx 8
    grid columnconfigure $f3 2 -weight 1
    set ::PCGraphsPriv(graph,2,frame) $f3

    # grid 2 operand frame
    grid $f3_esc -sticky ew
    grid $f3 -sticky ew
    grid columnconfigure $f3_op2 0 -weight 1
    grid rowconfigure $f3_op2 0 -weight 1
    grid rowconfigure $f3_op2 1 -weight 1
    grid rowconfigure $f3_op2 2 -weight 1
    setTooltip $f3_op2 -text [_ "Select the second operand of the operators or the argument of the functions. Some operators allow to use a constant as second operator for the real or imaginary part."] 

    set fr [ ttk::frame $f.fr]
    ttk::label $fr.l -text [_ "Destination graph name"]: 
    ttk::entry $fr.e -textvariable PCGraphsPriv(graphdest) -width 20
    
    ttk::button $fr.b -image [ gid_themes::GetImage "delete.png" small_icons] -command PCGraphsDeleteGraph
    
    ttk::progressbar $fr.l2 -variable ::PCGraphsPriv(var) -length 200
    set ::PCGraphsPriv(var) 0

    grid $fr.l $fr.e $fr.b -sticky news -padx 4 -pady 2
    grid $fr.l2 -sticky ews -columnspan 3
    grid columnconfigure $fr 1 -weight 1
    set PCGraphsPriv(graphdest) [_ "New graph name"]

    setTooltip $fr -text [_ "Select the name of the destionation graph. Or enter a graph name to delete it with the cross button."] 

    if { $::PCGraphsPriv(HorizontalLayout)} {
        grid $f0 $f2 $f3_op2 -sticky news -padx 2 -pady 2
        grid $fr -sticky news -padx 2 -pady 2 -columnspan 3
        grid columnconfigure $f 0 -weight 1
    } else {
        grid $f0 -sticky news -padx 2 -pady 2
        grid $f2 -sticky news -padx 2 -pady 2
        grid $f3_op2 -sticky news -padx 2 -pady 2
        grid $fr -sticky news -padx 2 -pady 2        
        grid columnconfigure $f 0 -weight 1
        grid rowconfigure $f 4 -weight 1
    }


    # marco de los botones
    ttk::frame $w.but -style BottomFrame.TFrame   

    ttk::button $w.but.apply -text [_ "Apply"] -command PCGraphsApply -takefocus 1 -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -takefocus 1 -style BottomFrame.TButton

    grid $w.but.apply -sticky ews -padx 4 -pady 10
    grid $w.but.close -sticky ews -padx 4 -pady 10 -row 0 -column 1

    #enpaquetamos marcos
    grid $w.f -sticky news -padx 2 -pady 2
    grid $w.but -sticky wes
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    focus $w.but.apply
    bind $w <Return> "$w.but.apply invoke"
    bind $w <Destroy> +PCGraphsClose ;# + to add to previous script   

    # default values:
    set ::PCGraphsPriv(Op2Typ) graph
    set ::PCGraphsPriv(operate,x) 0
    set ::PCGraphsPriv(operate,y) 1
    PCGraphs_EnableDisable2Operand $f3_op2 ::PCGraphsPriv(Op2Typ)
    PCGraphs_EnableDisable2Operand $f3_op2 ::PCGraphsPriv(Op2Typ)
    PCGraphs_EnableDisableOptionsButton

    # operator options
    set ::PCGraphsPriv(CubicSpline,Precision) 20
    set ::PCGraphsPriv(CatmullRomSpline,NumPoints) 20
    set ::PCGraphsPriv(Derivate,Offset) 0.0
    set ::PCGraphsPriv(dFT,Polar) 0
    set ::PCGraphsPriv(dFT,ComplexPart) real
    set ::PCGraphsPriv(dFT,ScaleY) 1
    set ::PCGraphsPriv(dFT,ScaleX) 1
    set ::PCGraphsPriv(dFT,GetXFreq) 1
    set ::PCGraphsPriv(dFT,HalfResults) 1    
}

########################################################################

namespace eval PCreateResult {
    variable _wid
    variable _lst_variables   {}
    variable _widget_variables
    variable _txt_analysis
    variable _analysis
    variable _step
    variable _txt_result
    variable _result
    variable _txt_componente
    variable _componente
    variable _txt_variable
    variable _lst_variables
}

proc PCreateResult::IsList { var} {
    set idx [ string first \{ $var]
    set is_list 0
    # find if something open it:
    if { $idx != -1 } {
        if { $idx == 0} {
            set is_list 1
        } elseif { [ string index $var [ expr $idx - 1]] != "\\"} {
            set is_list 1
        }
    }
    if { $is_list} {
        # find if something close it:
        set idx [ string first \} $var $idx]
        if { $idx == -1} {
            set is_list 0
        }
    }
    return $is_list
}

proc PCreateResult::Apply { } { 
}

proc PCreateResult::Close { } {
    variable _wid
    destroy $_wid
}

proc PCreateResult::UpdateAnalysisList { w} {
    variable _txt_analysis
    variable _analysis
    $w configure -values [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
}

proc PCreateResult::UpdateListSteps { w} {
    variable _txt_analysis
    variable _analysis
    variable _step

    if { $_txt_analysis == "" } { return}
    set _analysis $_txt_analysis

    if { $_analysis != ""} {
        set all_steps [ GiD_Info postprocess get all_steps $_analysis]
        $w configure -values $all_steps
        set current_analysis [ GiD_Info postprocess get cur_analysis]
        if { $current_analysis == $_analysis} {
            set current_step [ GiD_Info postprocess get cur_step $current_analysis]
        } else {
            set current_step [ lindex $all_steps 0]
        }
        set _step $current_step
    }
}

proc PCreateResult::Get_Results {} {
    set ret {}
    set all [ GiD_Info postprocess get cur_results_list "Result_Surface" ]
    foreach res $all {
        lappend ret $res
    }
    return $ret
}

proc PCreateResult::UpdateResultsList { w wc} {
    variable _analysis
    variable _step
    variable _txt_result
    variable _result

    if { $_analysis == ""} { return }
    if { $_step == ""} { return}

    set ret [ GiD_Info postprocess get results_list "Result_Surface"  $_analysis $_step]
    $w configure -values $ret
    if { [ lsearch $ret $_txt_result] == -1} {
        if { [ llength $ret] != 0} {
            set _result [ lindex $ret 0]
        } else {
            set _result ""
        }
        set _txt_result $_result
        UpdateComponentsList $wc
    }
}

proc PCreateResult::UpdateComponentsList { w} {
    variable _txt_result
    variable _analysis
    variable _step
    variable _result
    variable _txt_componente

    if { $_analysis == ""} { return }
    if { $_step == ""} { return}

    if { $_txt_result == ""} { return }
    set _result $_txt_result

    set ret [ GiD_Info postprocess get components_list "Result_Surface" $_result $_analysis $_step]
    $w configure -values $ret
    if { [ lsearch $ret $_txt_componente] == -1} {
        if { [ llength $ret] != 0} {
            set _txt_componente [ lindex $ret 0]
        } else {
            set _txt_componente ""
        }
        UpdateComponentName
    }
}

proc PCreateResult::UpdateComponentName { } {
    variable _txt_componente
    variable _componente

    if { $_txt_componente == ""} { return}
    set _componente $_txt_componente

}

proc PCreateResult::ValidateName { name_var} {
    upvar $name_var var
    # valid variable names start by letter and follos letters, 
    # numbers and some of this characters    
    # _ # ! + - * / % & '
    # \#!+-*/%&'
    set valid 0
    if { [ regexp {^([ [ :alpha:]][ \w\#!+\-*/%&\']+)$} $var dum pepe]} {
        set valid 1
    }
    return $valid
}

proc PCreateResult::ValidateVariableAndClose { w old_name} {
    variable _txt_variable

    if { ![ ValidateName PCreateResult::_txt_variable]} {
        WarnWin [ concat [_ "Invalid variable name. \
            \nShould begin with a letter and followed\
            \nby a digit, letter or"] " \# ! + - * / % & '"]
        return
    } else {
        
    }

    if { $old_name != ""} {
        # quitamos $old_name
    }

    # add new variable to list
    destroy $w
}

proc PCreateResult::EditVariableWindow { { w .gid.wPCreateResultEditVariable} { name ""}} {
    package require BWidget
    
    variable _txt_analysis
    variable _analysis
    variable _step
    variable _txt_result
    variable _result
    variable _txt_componente
    variable _componente
    variable _txt_variable
    variable _lst_variables

    if { [ winfo exists $w]} {
        raise $w
        return
    }

    InitWindow2 $w -title [_ "Add variable"] \
        -geometryvariable PostEditVariableWindowGeom \
        -initcommand PCreateResult::EditVariableWindow \
        -ontop
    if { ![ winfo exists $w]} return

    ttk::frame $w.f

    if { $name == ""} {
        set _txt_variable [_ "No_Name"]_[ llength _lst_variables]
    } else {
        set _txt_variable $name
    }

    ttk::label $w.f.lv -text [_ "Variable name"]: 
    ttk::entry $w.f.ev -textvariable PCreateResult::_txt_variable -width 30

    ttk::label $w.f.la -text [_ "Analysis"]: 
    if { ![info exists PCreateResult::_txt_analysis] } {
        set  PCreateResult::_txt_analysis ""
    }
    ComboBox $w.f.ma -textvariable PCreateResult::_txt_analysis -editable 0 -width 30 -borderwidth 1 \
        -modifycmd [ list PCreateResult::UpdateListSteps $w.f.fp.mp]

    ttk::label $w.f.lp -text [_ "Step"]: 
    if { ![info exists PCreateResult::_step] } {
        set  PCreateResult::_step ""
    }
    ComboBox $w.f.mp -textvariable PCreateResult::_step -editable 0 -width 8 -borderwidth 1 \
        -modifycmd [ list PCreateResult::UpdateResultsList $w.f.m1 $w.f.m2]

    ttk::label $w.f.l1 -text [_ "Result"]: 
    if { ![info exists PCreateResult::_txt_result] } {
        set  PCreateResult::_txt_result ""
    }
    ComboBox $w.f.m1 -textvariable PCreateResult::_txt_result -editable 0 -width 30 -borderwidth 1 \
        -modifycmd [ list PCreateResult::UpdateComponentsList $w.f.m2]

    ttk::label $w.f.l2 -text [_ "Component"]: 
    if { ![info exists PCreateResult::_txt_componente] } {
        set  PCreateResult::_txt_componente ""
    }
    ComboBox $w.f.m2 -textvariable PCreateResult::_txt_componente -editable 0 -width 30 -borderwidth 1 \
        -modifycmd PCreateResult::UpdateComponentName

    # rellenamos los widget con valores
    UpdateAnalysisList $w.f.ma

    set _analysis [ GiD_Info postprocess get cur_analysis]
    set _txt_analysis $_analysis
        
    UpdateListSteps $w.f.mp
    $w.f.m1 configure -values [ PCreateResult::Get_Results]
    UpdateResultsList $w.f.m1 $w.f.m2

    # name variable
    grid $w.f.lv $w.f.ev -sticky e -padx 2 -pady 1
    grid configure $w.f.ev -sticky ew
    # analysis
    grid $w.f.la $w.f.ma -sticky e -padx 2 -pady 1
    grid configure $w.f.ma -sticky ew
    # step
    grid $w.f.lp $w.f.mp -sticky e -padx 2 -pady 1
    grid configure $w.f.mp -sticky w
    # result
    grid $w.f.l1 $w.f.m1 -sticky e -padx 2 -pady 1
    grid configure $w.f.m1 -sticky ew
    # componente
    grid $w.f.l2 $w.f.m2 -sticky e -padx 2 -pady 1
    grid configure $w.f.m2 -sticky ew

    grid rowconfigure $w.f 0 -weight 1
    grid rowconfigure $w.f 1 -weight 1
    grid rowconfigure $w.f 2 -weight 1
    grid rowconfigure $w.f 3 -weight 1
    grid rowconfigure $w.f 4 -weight 1
    grid columnconfigure $w.f 0 -weight 1
    grid columnconfigure $w.f 1 -weight 1

    set def_back [ $w cget -background]
    ttk::frame $w.buts -style BottomFrame.TFrame   

    ttk::button $w.buts.apply -text [_ "Create"] -style BottomFrame.TButton \
      -command [ list PCreateResult::ValidateVariableAndClose $w $name]
    ttk::button $w.buts.close -text [_ "Cancel"] -style BottomFrame.TButton \
      -command [ list destroy $w]
    grid $w.buts.apply $w.buts.close -sticky ew -padx 5 -pady 6

    # parte superior
    grid $w.f -sticky nsew
    # parte inferior
    grid $w.buts -sticky sew
    grid anchor $w.buts center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1    

    tkwait window $w

    set ret_val ""
    if { ( $_txt_analysis != "") && ( $_step != "") && \
             ( $_txt_result != "") && ( $_txt_componente != "")} {
        set ret_val [ list $_txt_variable Scalar Result \
                          $_txt_analysis $_step $_txt_result $_txt_componente]
    }
    return $ret_val
}

proc PCreateResult::AnyadeVariable { lista} {
    set w $lista.def

    set info_var [ EditVariableWindow $w]
    if { [ winfo exists $lista]} {
        if { $info_var != ""} {
            $lista insert end $info_var
        }
    }
}

proc PCreateResult::QuitaVariable { lista} {
    WarnWin "Quita variable"
}

proc PCreateResult::CreaListaVariables { f} {
    variable _widget_variables

    set _widget_variables $f.list

    ttk::frame $f
    ttk::scrollbar $f.xscroll -orient horizontal -command [ list $f.list xview]
    ttk::scrollbar $f.yscroll -orient vertical -command [ list $f.list yview]
    #pseudottk::
    tk::listbox $f.list -height 5 -width 20 \
        -xscroll [ list $f.xscroll set] \
        -yscroll [ list $f.yscroll set] \
        -selectmode browse -relief sunken -borderwidth 1
        
    grid $f.list -sticky ewns
    grid $f.xscroll -sticky ew
    grid $f.yscroll -sticky ns -rowspan 2 -row 0 -column 1
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1
    return $f
}

proc PCreateResult::EventosWidgetVariables { f add_cmd del_cmd edit_cmd} {
    variable _widget_variables

    bind $_widget_variables <Double-Button-1> $edit_cmd
    bind $_widget_variables <Return> $edit_cmd
    bind $_widget_variables <Delete> $del_cmd
    bind $_widget_variables <Insert> $add_cmd
    bind $_widget_variables <plus> $add_cmd
    bind $_widget_variables <minus> $del_cmd
    #bind $_widget <KeyPress> "WarnWin %K"
}

proc PCreateResult::CreaTablaVariables { f} {
    global GidPriv
    variable _widget_variables

    package require tablelist_tile

    ttk::frame $f

    #  table name
    set tbl $f.tbl
    set _widget_variables $f.tbl

    ttk::scrollbar $f.xscroll -orient horizontal -command [ list $tbl xview]
    ttk::scrollbar $f.yscroll -orient vertical -command [ list $tbl yview]
    tablelist::tablelist $tbl -exportselection 0 \
        -columns [ list \
                       10 [_ "Name"] left \
                       5 [_ "Type"] left \
                       5 [_ "Class"] left \
                       15 [_ "Analysis"] left \
                       4 [_ "Step"] left \
                       15 [_ "Result"] left \
                       15 [_ "Component"] left \
                       ] \
        -stretch all \
        -selectmode single \
        -labelborderwidth 1 \
        -labelcommand tablelist::sortByColumn \
        -showarrow 1 \
        -showseparators 0 \
        -xscrollcommand [ list $f.xscroll set] \
        -yscrollcommand [ list $f.yscroll set] \
        -resizablecolumns 1 \
        -stripebackground [ CCColorSombra $GidPriv(Color,BackgroundListbox)] \
        -activestyle frame \
        -selecttype row       

    grid $f.tbl -sticky ewns
    grid $f.xscroll -sticky ew
    grid $f.yscroll -sticky ns -rowspan 2 -row 0 -column 1
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1
    return $f
}

proc PCreateResult::Create { { w .gid.wCreateResult2}} {
    variable _wid
    variable _widget_variables

    PCRIniVariables

    InitWindow2 $w -title [_ "Create result"] \
        -geometryvariable PostCreateResultWindowGeom \
        -initcommand PCreateResult::Create
    if { ![ winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set _wid $w  
    ttk::frame $w.ventana   

    # lista de variables  
    set f [ ttk::labelframe $w.ventana.lv -text [_ "Variable list"]]

    #CreaListaVariables $f.lb
    CreaTablaVariables $f.lb

    # control de lista de variables: mas menos y edit
    ttk::frame $f.bot
    ttk::button $f.bot.mas -image [ gid_themes::GetImage Mas.png small_icons] \
        -command [ list PCreateResult::AnyadeVariable $_widget_variables]
    ttk::button $f.bot.edit -text [_ "Edit"] \
        -command [ list WarnWin "edita variable"]
    ttk::button $f.bot.menos -image [ gid_themes::GetImage Menos.png small_icons] \
        -command [ list PCreateResult::QuitaVariable $_widget_variables]

    grid $f.bot.mas $f.bot.edit $f.bot.menos -sticky w -padx 4 -pady 2
    grid rowconfigure $f.bot 0 -weight 1

    EventosWidgetVariables $f.lb \
        [ $f.bot.mas cget -command] [ $f.bot.menos cget -command] [ $f.bot.edit cget -command]

    grid $f.lb -sticky nsew -padx 4 -pady 2
    grid $f.bot -sticky ew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1

    # text with formulae  
    set f [ ttk::labelframe $w.ventana.tf -text [_ "Formula"]]

    ttk::frame $f.tt
    ttk::scrollbar $f.tt.xscroll -orient horizontal -command "$f.tt.text xview"
    ttk::scrollbar $f.tt.yscroll -orient vertical -command "$f.tt.text yview"
    text $f.tt.text -width 20 -height 5 \
        -xscroll "$f.tt.xscroll set" \
        -yscroll "$f.tt.yscroll set" \
        -relief sunken -borderwidth 1

    grid $f.tt.text -sticky ewns
    grid $f.tt.xscroll -sticky ew
    grid $f.tt.yscroll -sticky ns -rowspan 2 -row 0 -column 1
    grid rowconfigure $f.tt 0 -weight 1
    grid columnconfigure $f.tt 0 -weight 1

    grid $f.tt -sticky news -padx 4 -pady 2
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1


    grid $w.ventana.lv -sticky news -padx 2
    grid $w.ventana.tf -sticky news -padx 2
    grid rowconfigure $w.ventana 0 -weight 1
    grid rowconfigure $w.ventana 1 -weight 1
    grid columnconfigure $w.ventana 0 -weight 1

    # apply y close
    # marco de los botones
    ttk::frame $w.but -style BottomFrame.TFrame  

    ttk::button $w.but.apply -text [_ "Apply"] -command PCreateResult::Apply \
        -takefocus 1 -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command PCreateResult::Close \
        -takefocus 1 -style BottomFrame.TButton

    grid $w.but.apply -sticky ews -padx 4 -pady 10
    grid $w.but.close -sticky ews -padx 4 -pady 10 -row 0 -column 1

    #enpaquetamos marcos
    grid $w.ventana -sticky news
    ttk::frame $w.sep -height 4

    grid $w.sep -sticky we
    grid $w.but -sticky wes
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    bind $w <Return> "+$w.but.apply invoke"
    bind $w <Escape> "focus $w.but.close; $w.but.close invoke"

    update idletasks
}

namespace eval ::PostOperate2Scalars {
}

#Fills the values of the scalars list
proc ::PostOperate2Scalars::Get_Results_Nodales_Escalares { } {
    set ret {}
    set all [ GiD_Info postprocess get cur_results_list "Result_Surface" ]
    foreach res $all {
        if { [ llength [ GiD_Info postprocess get cur_components_list $res ]] == 1} {
            lappend ret $res
        }
    }
    return $ret
}

#Vector's creation code
proc ::PostOperate2Scalars::ConvertOperationToScalars { w} {
    ::PostOperate2Scalars::UpdateScalarsList $w all
    set i 1
    while { $i <= $::PostOperate2Scalars::Number_vectors } {
        set scalar_name "::PostOperate2Scalars::ScalarToConvert$i"
        if { [ subst $$scalar_name] == ""} {
            WarnWin [_ "Please, select a valid scalar result for Scalar result $i"]
            return
        }
        incr i
    }
    set ::PostOperate2Scalars::VectorName $::PostOperate2Scalars::TxtVectorName
    if { $::PostOperate2Scalars::VectorName == ""} {
        WarnWin [_ "Please, enter a name for the vector result"]
        return
    }
    set current_analysis $::PostOperate2Scalars::Analysis
    set all_steps $::PostOperate2Scalars::Step
    if { $::PostOperate2Scalars::AllSteps} {
        set all_steps [ GiD_Info postprocess get all_steps $::PostOperate2Scalars::Analysis]
    }
    set texto_output ""
    foreach current_step $all_steps {
        set header [ list Result $::PostOperate2Scalars::VectorName $current_analysis $current_step "Vector" "OnNodes"]
        set res_output {}
        lappend res_output $header
        
        set dict_values ""
        set all_exist 1
        #We fill a dictionary with the values of all the vectors for this step
        foreach i [ list 1 2 3] {
            if {$i > $::PostOperate2Scalars::Number_vectors} break
            set scalar_name "::PostOperate2Scalars::ScalarToConvert$i"
            set res_info ""
            set result_id [ list [ subst $$scalar_name] $current_analysis $current_step]
            set err [ catch {
                set res_info [GiD_Result get $result_id]
            } ]
            if { $err} {
                set all_exist 0
                break
            }
            foreach input [ lrange $res_info 3 end] {
                if { ( [ llength $input] == 2) && ( [ scan $input "%d %g" idx_nodo scalar] == 2) } {
                    foreach coordinate [ list x y z] {
                        set vector_name "::PostOperate2Scalars::VectorToUse$i\($coordinate\)"
                        if {[ dict exists $dict_values $idx_nodo $coordinate] == "0"} {
                            set old_value 0
                        } else {
                            set old_value [ dict get $dict_values $idx_nodo $coordinate]
                        }
                        set new_value [ expr ($scalar * [ subst $$vector_name])]
                        dict set dict_values $idx_nodo $coordinate [ expr ($old_value + $new_value)]
                    }
                }
            }
        }
        
        #If some vector is missing for this step, we evaluate the next one
        if {$all_exist == "1"} {
            #We convert our dictionary to the proper GiD format
            foreach nodeid [ dict keys $dict_values] {
                set input_list [ list $nodeid]
                foreach position [ list x y z] {
                    lappend input_list [ dict get $dict_values $nodeid $position]
                }
                lappend res_output $input_list
            }
            
            eval GiD_Result create $res_output
            
            #We update the output text and we delete the ancient value if needed
            append texto_output [_ "\nVector result '%s'  ( '%s', step '%g') created   \n from" \
                                      $::PostOperate2Scalars::TxtVectorName $current_analysis $current_step]
            set i 1
            while { $i <= $::PostOperate2Scalars::Number_vectors } {
                set scalar_name "::PostOperate2Scalars::TxtScalarToConvert$i"
                
                if {$::PostOperate2Scalars::Delete_scalars == "1"} {
                    set analysis_name $current_analysis
                    GiD_Result delete [ list [ subst $$scalar_name] $analysis_name $current_step]
                }
                set vector_x "::PostOperate2Scalars::VectorToUse$i\(x\)"
                set vector_y "::PostOperate2Scalars::VectorToUse$i\(y\)"
                set vector_z "::PostOperate2Scalars::VectorToUse$i\(z\)"
                if {$::PostOperate2Scalars::Number_vectors != "1" && $i == $::PostOperate2Scalars::Number_vectors} {
                    append texto_output [_ " and"]
                }
                append texto_output [_ " scalar '%s' using vector \( %s, %s, %s\)" \
                                          [ subst $$scalar_name] [ subst $$vector_x] [ subst $$vector_y] [ subst $$vector_z]]
                incr i
            }
        }
    }
    if {$::PostOperate2Scalars::Delete_scalars == "1"} {
        append texto_output [_ "\n\nOriginal scalar results have been deleted"]
    }
    WarnWinText $texto_output
}
#Fills the list of analysis
proc ::PostOperate2Scalars::ActualizaListaAnalysis { w} {
    $w configure -values [ lsort -dictionary [ GiD_Info postprocess get all_analysis]]
}
#Dependencies of the analysis selection
proc ::PostOperate2Scalars::UpdateListSteps { w w_local} {
    if { "$::PostOperate2Scalars::TxtAnalysis" == "" } { return }
    set ::PostOperate2Scalars::Analysis $::PostOperate2Scalars::TxtAnalysis
    if { "$::PostOperate2Scalars::Analysis" != ""} {
        set all_steps [ GiD_Info postprocess get all_steps $::PostOperate2Scalars::Analysis]
        $w_local configure -values $all_steps
        set current_analysis [ GiD_Info postprocess get cur_analysis]
        if { $current_analysis == $::PostOperate2Scalars::Analysis} {
            set current_step [ GiD_Info postprocess get cur_step $current_analysis]
        } else {
            set current_step [ lindex $all_steps 0]
        }
        set ::PostOperate2Scalars::Step $current_step
        
        if {$::PostOperate2Scalars::Scalars_initialized == "1" } {
            ::PostOperate2Scalars::UpdateScalarsList $w all
        }
    }
}
#Update the values of the scalar lists
proc ::PostOperate2Scalars::UpdateScalarsList { w index} {
    if {$index == "all"} {
        set index_list [ list 1 2 3]
        set windows_list [ list $w.f.m11 $w.f.m12 $w.f.m13]
    } else {
        set index_list [ list $index]
        set windows_list [ list $w]
    }
    
    if { $::PostOperate2Scalars::Analysis != ""} {
        if { $::PostOperate2Scalars::Step != ""} {
            set ret {}
            set all [ GiD_Info postprocess get results_list "Result_Surface"  $::PostOperate2Scalars::Analysis $::PostOperate2Scalars::Step]
            foreach res $all {
                if { [ llength [ GiD_Info postprocess get components_list "Result_Surface"  $res $::PostOperate2Scalars::Analysis $::PostOperate2Scalars::Step]] == 1} {
                    lappend ret $res
                }
            }
            foreach window $windows_list {
                $window configure -values $ret
            }
            foreach position $index_list {
                set var_name "::PostOperate2Scalars::ScalarToConvert$position"
                set var_txt_name "::PostOperate2Scalars::TxtScalarToConvert$position"
                if { [ lsearch $ret [ subst $$var_name]] == -1} {
                    if { [ llength $ret] != 0} {
                        set $var_name [ lindex $ret 0]
                    } else {
                        set $var_name ""
                    }
                    set $var_name [set $var_txt_name]
                    
                    if {$position == "1"} {
                        ::PostOperate2Scalars::UpdateVectorName
                    }
                }
            }
        }
    }
}
#Dependencies of the all steps check button
proc ::PostOperate2Scalars::EnableDisableLista { w} {
    if { $::PostOperate2Scalars::AllSteps} {
        $w configure -state disabled
    } else {
        $w configure -state normal
    }
}

#Define the dependencies of the dimension selector
proc ::PostOperate2Scalars::Updatedimension { w } {
    foreach i [ list 3 2] {
        if { "$::PostOperate2Scalars::Number_vectors" >= "$i"} {
            $w.f.m1$i configure -state normal
            if {"$::PostOperate2Scalars::Conversion_mode" == [_ "User_defined"]} {
                foreach j [ list x y z] { $w.f.fv$i.e$j configure -state normal }
            }
        } else {
            $w.f.m1$i configure -state disabled
            foreach j [ list x y z] { $w.f.fv$i.e$j configure -state disable }
        }
    }
    ::PostOperate2Scalars::UpdateVectorName
}

#Define the dependencies of the Conversion mode selector
proc ::PostOperate2Scalars::Updatestatevectors { w } {
    if { "$::PostOperate2Scalars::Conversion_mode" == [_ "User_defined"] } {
        foreach i [ list 1 2 3] {
            if {"$::PostOperate2Scalars::Number_vectors" >= "$i"} {
                foreach j [ list x y z] {
                    $w.f.fv$i.e$j configure -state normal
                }
            }
        }
    } else {
        ::PostOperate2Scalars::Initializevectors
        foreach i [ list 1 2 3] {
            foreach j [ list x y z] {
                $w.f.fv$i.e$j configure -state disabled
            }
        }
    }
}

#Gives to the three vectors the main axes values
proc ::PostOperate2Scalars::Initializevectors {} {
    set ::PostOperate2Scalars::VectorToUse1(x) 1.0
    set ::PostOperate2Scalars::VectorToUse1(y) 0.0
    set ::PostOperate2Scalars::VectorToUse1(z) 0.0
    set ::PostOperate2Scalars::VectorToUse2(x) 0.0
    set ::PostOperate2Scalars::VectorToUse2(y) 1.0
    set ::PostOperate2Scalars::VectorToUse2(z) 0.0
    set ::PostOperate2Scalars::VectorToUse3(x) 0.0
    set ::PostOperate2Scalars::VectorToUse3(y) 0.0
    set ::PostOperate2Scalars::VectorToUse3(z) 1.0
}

#Initialize the values related with the three scalars
proc ::PostOperate2Scalars::Initializscalars {} {
    set ::PostOperate2Scalars::ScalarToConvert1 ""
    set ::PostOperate2Scalars::ScalarToConvert2 ""
    set ::PostOperate2Scalars::ScalarToConvert3 ""
}

#We suggest a name while dealing with a single vector
proc ::PostOperate2Scalars::UpdateVectorName {} {
    if {$::PostOperate2Scalars::Number_vectors == "1"} {
        if { "$::PostOperate2Scalars::TxtScalarToConvert1" == "" } {
            set ::PostOperate2Scalars::ScalarToConvert1 ""
            set ::PostOperate2Scalars::VectorName ""
            set ::PostOperate2Scalars::TxtVectorName ""
            return
        }
        set ::PostOperate2Scalars::ScalarToConvert1 $::PostOperate2Scalars::TxtScalarToConvert1
        if { "$::PostOperate2Scalars::ScalarToConvert1" != ""} {
            set ::PostOperate2Scalars::VectorName "$::PostOperate2Scalars::ScalarToConvert1 vector"
        } else {
            set ::PostOperate2Scalars::VectorName ""
        }
        set ::PostOperate2Scalars::TxtVectorName $::PostOperate2Scalars::VectorName
    }
}

#Build the window of the macro
proc ::PostOperate2Scalars::Opera2Escalares {  { w .gid.wOpera2Escalares}} {
    package require BWidget
    set ::PostOperate2Scalars::Analysis ""
    set ::PostOperate2Scalars::Step ""
    set ::PostOperate2Scalars::AllSteps 0
    set ::PostOperate2Scalars::TxtVectorName [_ "Vector1"]
    set ::PostOperate2Scalars::Number_vectors "3"
    ::PostOperate2Scalars::Initializscalars
    ::PostOperate2Scalars::Initializevectors
    set ::PostOperate2Scalars::Scalars_initialized 0
    set ::PostOperate2Scalars::Conversion_mode [_ "Main_axes"]
    set ::PostOperate2Scalars::Delete_scalars 0
    InitWindow2 $w -title [_ "Nodal scalars 2 vector"] \
        -geometryvariable PostOpera2EscalaresWindowGeom \
        -initcommand ::PostOperate2Scalars::Opera2Escalares \
        -ontop
    ttk::frame $w.f -borderwidth 0
    #Analysis
    ttk::label $w.f.la -text [_ "Analysis"]: 
    if { ![info exists ::PostOperate2Scalars::TxtAnalysis] } {
        set ::PostOperate2Scalars::TxtAnalysis ""
    }
    ComboBox $w.f.ma -textvariable ::PostOperate2Scalars::TxtAnalysis -editable 0 -width 30 -borderwidth 1  -modifycmd "::PostOperate2Scalars::UpdateListSteps $w $w.f.fp.mp"
    ::PostOperate2Scalars::ActualizaListaAnalysis $w.f.ma
    #Step
    ttk::label $w.f.lp -text [_ "Step"]: 
    ttk::frame $w.f.fp -borderwidth 0
    if { ![info exists ::PostOperate2Scalars::Step] } {
        set ::PostOperate2Scalars::Step ""
    }
    ComboBox $w.f.fp.mp -textvariable ::PostOperate2Scalars::Step -editable 0 -width 8 -borderwidth 1  -modifycmd "::PostOperate2Scalars::UpdateScalarsList $w all"
    if { ![info exists ::PostOperate2Scalars::AllSteps] } { set ::PostOperate2Scalars::AllSteps 0 }
    ttk::checkbutton $w.f.fp.cb -text [_ "all steps"] -variable ::PostOperate2Scalars::AllSteps  -command "::PostOperate2Scalars::EnableDisableLista $w.f.fp.mp"
    grid $w.f.fp.mp $w.f.fp.cb -sticky w
    grid rowconfigure $w.f.fp 0 -weight 1
    grid columnconfigure $w.f.fp 0 -weight 1
    grid columnconfigure $w.f.fp 1 -weight 1
    #Vector Name selection
    ::PostOperate2Scalars::UpdateVectorName
    ttk::label $w.f.l2 -text [_ "To vector result"]: 
    entry $w.f.e2 -textvariable ::PostOperate2Scalars::TxtVectorName -width 30
    #Conversion mode
    ttk::label $w.f.lc1 -text [_ "Conversion mode"]: 
    ttk::frame $w.f.fc -borderwidth 0
    ttk::label $w.f.fc.lc2 -text [_ "Number of vectors"]: 
    if { ![info exists ::PostOperate2Scalars::Conversion_mode] } {
        set ::PostOperate2Scalars::Conversion_mode ""
    }
    ComboBox $w.f.fc.mc1 -textvariable ::PostOperate2Scalars::Conversion_mode -editable 0 -width 12 -borderwidth 1 -values [ list [_ "Main_axes"] [_ "User_defined"]] -modifycmd "::PostOperate2Scalars::Updatestatevectors $w"
    if { ![info exists ::PostOperate2Scalars::Number_vectors] } {
        set ::PostOperate2Scalars::Number_vectors ""
    }
    ComboBox $w.f.fc.mc2 -textvariable ::PostOperate2Scalars::Number_vectors -editable 0 -width 4 -borderwidth 1 -values [ list 1 2 3] -modifycmd "::PostOperate2Scalars::Updatedimension $w"
    grid $w.f.fc.mc1 $w.f.fc.lc2 $w.f.fc.mc2 -sticky e
    grid rowconfigure $w.f.fc 0 -weight 1
    grid columnconfigure $w.f.fc 0 -weight 1
    grid columnconfigure $w.f.fc 1 -weight 1
    grid columnconfigure $w.f.fc 2 -weight 1

    set ::PostOperate2Scalars::Analysis [ GiD_Info postprocess get cur_analysis]
    set ::PostOperate2Scalars::TxtAnalysis $::PostOperate2Scalars::Analysis
    ::PostOperate2Scalars::UpdateListSteps $w $w.f.fp.mp
    
    #We define the graphical environment for the three scalars
    foreach index [ list 1 2 3] {
        ttk::label [ subst $w.f.l1$index] -text [_ "Scalar result $index"]: 
        if { ![info exists ::PostOperate2Scalars::TxtScalarToConvert$index] } {
            set ::PostOperate2Scalars::TxtScalarToConvert$index ""
        }
        if {$index == "1"} {
            ComboBox [ subst $w.f.m1$index] -textvariable ::PostOperate2Scalars::TxtScalarToConvert$index -editable 0 -width 30 -borderwidth 1 -modifycmd ::PostOperate2Scalars::UpdateVectorName
        } else {
            ComboBox [ subst $w.f.m1$index] -textvariable ::PostOperate2Scalars::TxtScalarToConvert$index -editable 0 -width 30 -borderwidth 1
        }
        [ subst $w.f.m1$index] configure -values [ ::PostOperate2Scalars::Get_Results_Nodales_Escalares]

        ::PostOperate2Scalars::UpdateScalarsList [ subst $w.f.m1$index] $index
        
        ttk::label [ subst $w.f.l3$index] -text [_ "Using Vector $index"]: 
        ttk::frame [ subst $w.f.fv$index] -borderwidth 0
        ttk::label [ subst $w.f.fv$index.lx] -text "x:" 
        ttk::entry [ subst $w.f.fv$index.ex] -textvariable "::PostOperate2Scalars::VectorToUse$index\(x\)" -width 5 -state disabled
        ttk::label [ subst $w.f.fv$index.ly] -text "y:" 
        ttk::entry [ subst $w.f.fv$index.ey] -textvariable "::PostOperate2Scalars::VectorToUse$index\(y\)" -width 5 -state disabled
        ttk::label [ subst $w.f.fv$index.lz] -text "z:" 
        ttk::entry [ subst $w.f.fv$index.ez] -textvariable "::PostOperate2Scalars::VectorToUse$index\(z\)" -width 5 -state disabled
        
        grid [ subst $w.f.fv$index.lx] [ subst $w.f.fv$index.ex] [ subst $w.f.fv$index.ly] [ subst $w.f.fv$index.ey] [ subst $w.f.fv$index.lz] \
            [ subst $w.f.fv$index.ez] -sticky e -padx 2 -pady 1
        grid configure [ subst $w.f.fv$index.ex] -sticky w
        grid configure [ subst $w.f.fv$index.ey] -sticky w
        grid configure [ subst $w.f.fv$index.ez] -sticky w
        grid rowconfigure [ subst $w.f.fv$index] 0 -weight 1
        grid columnconfigure [ subst $w.f.fv$index] 1 -weight 1
        grid columnconfigure [ subst $w.f.fv$index] 3 -weight 1
        grid columnconfigure [ subst $w.f.fv$index] 5 -weight 1
    }
    
    # Scalars deletion option
    ttk::label $w.f.ldel -text [_ "Delete original results"]: 
    if { ![info exists ::PostOperate2Scalars::Delete_scalars] } { set ::PostOperate2Scalars::Delete_scalars 0 }
    ttk::checkbutton $w.f.cbdel -variable ::PostOperate2Scalars::Delete_scalars

    set ::PostOperate2Scalars::Scalars_initialized 1
    ::PostOperate2Scalars::UpdateScalarsList $w all

    # analysis
    grid $w.f.la $w.f.ma -sticky e -padx 2 -pady 1
    grid configure $w.f.ma -sticky ew
    # step
    grid $w.f.lp $w.f.fp -sticky e -padx 2 -pady 1
    grid configure $w.f.fp -sticky w
    # vector's name
    grid $w.f.l2 $w.f.e2 -sticky e -padx 2 -pady 1
    grid configure $w.f.e2 -sticky ew
    # conversion
    grid $w.f.lc1 $w.f.fc -sticky e -padx 2 -pady 1
    grid configure $w.f.fc -sticky w
    #We display all the vectors
    foreach index [ list 1 2 3] {
        # Scalar result
        grid [ subst $w.f.l1$index] [ subst $w.f.m1$index] -sticky e -padx 2 -pady 1
        grid configure [ subst $w.f.m1$index] -sticky ew
        # Vector
        grid [ subst $w.f.l3$index] [ subst $w.f.fv$index] -sticky e -padx 2 -pady 1
        grid configure [ subst $w.f.fv$index] -sticky w
    }
    # Scalars deletion
    grid $w.f.ldel $w.f.cbdel -sticky e -padx 2 -pady 1
    grid configure $w.f.cbdel -sticky w
    
    # General displaying
    grid rowconfigure $w.f 0 -weight 2
    grid rowconfigure $w.f 1 -weight 2
    grid rowconfigure $w.f 2 -weight 2
    grid rowconfigure $w.f 2 -weight 2
    grid rowconfigure $w.f 2 -weight 2
    grid rowconfigure $w.f 3 -weight 2
    grid rowconfigure $w.f 3 -weight 2
    grid rowconfigure $w.f 3 -weight 2
    
    grid columnconfigure $w.f 0 -weight 1
    grid columnconfigure $w.f 1 -weight 1
    
    set def_back [ $w cget -background]
    ttk::frame $w.buts -style BottomFrame.TFrame    
    ttk::button $w.buts.apply -text [_ "Create"] -style BottomFrame.TButton \
      -command "::PostOperate2Scalars::ConvertOperationToScalars $w"
    ttk::button $w.buts.close -text [_ "Close"] -style BottomFrame.TButton \
      -command "destroy $w"
        
    grid $w.buts.apply $w.buts.close -sticky ew -padx 5 -pady 6
    # Upper part
    grid $w.f -sticky nsew
    # Lower part
    grid $w.buts -sticky sew
    grid anchor $w.buts center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    
    bind $w <Escape> "$w.buts.close invoke"
}

########################################################################
### create statistical result and options
########################################################################

namespace eval StatisticalOptions {
    variable _wid
    variable _fromstep0
    variable _step0value
}

proc ::StatisticalOptions::Close { } {
    variable _wid

    if { ![info exists _wid] || ![ winfo exists $_wid] } { return}
    destroy $_wid
}

proc ::StatisticalOptions::Accept { } {
    variable _fromstep0
    variable _step0value
    
    set op_idx [ lsearch $::PostStatisticalResult::ListOperators $::PostStatisticalResult::TxtOperator]
    
    switch -- $op_idx { 
        5 { 
            if { $_fromstep0 } {
                set ::PostStatisticalResult::FromStep0 1
                set ::PostStatisticalResult::Step0Value $_step0value
            } else {
                set ::PostStatisticalResult::FromStep0 0
            }
        }
    }
    
    ::StatisticalOptions::Close
}

proc ::StatisticalOptions::EnableDisableIntegral { } {
    
    if { $::StatisticalOptions::_fromstep0} {
        $::StatisticalOptions::IntegralEntry configure -state normal
    } else {
        $::StatisticalOptions::IntegralEntry configure -state disabled
    }
}

proc ::StatisticalOptions::Create { parent_w operator} {
    variable _wid

    if { $parent_w == "."} {
        set _wid .__w_Options
    } else {
        set _wid $parent_w.__w_Options
    }

    toplevel $_wid
    set w $_wid
    if { $::tcl_platform(platform) == "windows" } {        
        wm attributes $w -toolwindow 1
    }

    wm title $_wid [_ "Options"]
    
    set op_idx [ lsearch $::PostStatisticalResult::ListOperators $::PostStatisticalResult::TxtOperator]
    
    switch -- $op_idx { 
        5 {
            ttk::frame $_wid.f
    
            ttk::checkbutton $_wid.f.ch -variable ::StatisticalOptions::_fromstep0 -command ::StatisticalOptions::EnableDisableIntegral 
            
            if { ![info exists ::PostStatisticalResult::FromStep0] } { 
                set ::StatisticalOptions::_fromstep0 0 
                set ::PostStatisticalResult::FromStep0 0
            } else {
                set ::StatisticalOptions::_fromstep0 $::PostStatisticalResult::FromStep0
            }
            
            ttk::label $_wid.f.l -text [_ "Start integral at 0.0 step withvalue"]: 
            ttk::entry $_wid.f.e -width 5 -textvariable ::StatisticalOptions::_step0value
            
            if { ![info exists ::PostStatisticalResult::Step0Value] } { 
                set ::StatisticalOptions::_step0value 0 
                set ::PostStatisticalResult::Step0Value 0
            } else {
                set ::StatisticalOptions::_step0value $::PostStatisticalResult::Step0Value
            }
            
            if { !$::StatisticalOptions::_fromstep0 } { $_wid.f.e configure -state disabled }
            
            set ::StatisticalOptions::IntegralEntry $_wid.f.e

            grid $_wid.f.ch $_wid.f.l $_wid.f.e -sticky w
        }
    }

    # marco de los botones
    ttk::frame $_wid.but -style BottomFrame.TFrame
    
    ttk::button $_wid.but.apply -text [_ "Apply"] -command "::StatisticalOptions::Accept" -style BottomFrame.TButton -takefocus 0
    ttk::button $_wid.but.close -text [_ "Close"] -command "::StatisticalOptions::Close" -style BottomFrame.TButton -takefocus 0

    grid $_wid.but.apply -sticky ews -padx 4 -pady 10
    grid $_wid.but.close -sticky ews -padx 4 -pady 10 -row 0 -column 1

    #enpaquetamos marcos
    grid $_wid.f -sticky news -padx 0 -pady 0
    grid $_wid.but -sticky wes
    grid anchor $_wid.but center

    grid columnconfigure $_wid 0 -weight 1
    grid rowconfigure $_wid 0 -weight 1

    AdjustPosition $_wid $parent_w

    focus $_wid.but.apply
    bind $_wid <Escape> "$_wid.but.close invoke"
    return $_wid
}

namespace eval ::PostStatisticalResult {
}

proc print_variables { pref} {
    foreach v [ list TxtAnalisis TxtNameResultToSearch Analisis Step NameResultToSearch] {
        set varname ::PostStatisticalResult::$v
        if { [ info exists $varname]} {
            WarnWinText "$pref ::PostStatisticalResult::$v = [ subst $$varname]"
        } else {
            WarnWinText "$pref ::PostStatisticalResult::$v = Does not exists !"
        }
    }
}

#Fills the values of the scalars list
proc ::PostStatisticalResult::GetResultsList { } {
    set ret {}
    set all [ GiD_Info postprocess get cur_results_list "Contour_Fill" ]
    foreach res $all {
        lappend ret $res
    }
    return $ret
}

proc ::PostStatisticalResult::GetResultComponentsList { } {
    return {}
}

proc ::PostStatisticalResult::get_idx_val_from_entry { entrada idx_comp} {
    set ret {}
    if { [ llength $entrada] == 2} {
        set idx [ lindex $entrada 0]
        set val [ lindex $entrada 1]
        if { [ llength $val] > 1} {
            set val [ lindex $val $idx_comp]
        }
        if { ( [ scan $idx "%d" idx_nodo] == 1) && ( [ scan $val "%g" escalar] == 1)} {
            set ret [ list $idx_nodo $escalar]
        }
    }
    return $ret
}

proc ::PostStatisticalResult::CalculateAverageValues { all_steps idx_comp endBar} {
    set num_steps [ llength $all_steps]
    set analisis_actual $::PostStatisticalResult::Analisis
    set there_is_error 0
    foreach current_step $all_steps {
        # user feedback
        set ::PostStatisticalResult::OutputLabel [_ "Processing step %g" $current_step]
        update
        set all_exist 1
        #We fill a table with the maximum values of the scalars
        set res_info ""
        set err [ catch {
            set res_info [GiD_Result get [ list $::PostStatisticalResult::NameResultToSearch $analisis_actual $current_step]]
        } errTxt ]
        if { $err} {
            WarnWin $errTxt
            set all_exist 0
            set there_is_error 1
            GidUtils::EndWaitState $w
            break
        }
        
        # average
        set num 0
        foreach entrada [ lrange $res_info 3 end] {
            set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
            if { $lst != {}} {
                set idx_nodo [ lindex $lst 0]
                set escalar [ lindex $lst 1]
                set val [ expr $escalar / $num_steps]
                if { [ info exists ::PostStatisticalResult::tbl_values_med($idx_nodo)]} {
                    set ::PostStatisticalResult::tbl_values_med($idx_nodo) [ expr $::PostStatisticalResult::tbl_values_med($idx_nodo) + $val]
                } else {
                    set ::PostStatisticalResult::tbl_values_med($idx_nodo) $val
                }
                incr num
            }
        }
        # user feedback
        incr idxBar
        set ::PostStatisticalResult::progress_value [ expr int( ( 100.0 * $idxBar) / $endBar)]
        update
    }
    return $there_is_error
}

proc ::PostStatisticalResult::EnableDisableOptionsButton {} {
    
    set op_idx [ lsearch $::PostStatisticalResult::ListOperators $::PostStatisticalResult::TxtOperator]
    switch -- $op_idx {
        5 {
            $::PostStatisticalResult::OptionsButton configure -state normal
            return
        }
    }
    $::PostStatisticalResult::OptionsButton configure -state disabled
}

proc ::PostStatisticalResult::Options { w } {
    variable _wid
    
    set op_idx [ lsearch $::PostStatisticalResult::ListOperators $::PostStatisticalResult::TxtOperator]
    if { ![info exists _wid] || ![ winfo exists $_wid] } {
        ::StatisticalOptions::Close
        set win [ ::StatisticalOptions::Create $w $op_idx]
        tkwait window $win
    } else {
        set win [ ::StatisticalOptions::Create $w $op_idx]
        tkwait window $win
    }
}

#Vector's creation code
proc ::PostStatisticalResult::CreateStatisticalResult { w} {
    
    ::PostStatisticalResult::ActualizeResultList $w
    if { "$::PostStatisticalResult::NameResultToSearch" == ""} {
        WarnWin [_ "Please, select a valid scalar result"]
        return
    }

    set ::PostStatisticalResult::NameStatisticalScalar $::PostStatisticalResult::TxtStatisticalScalarName
    if { "$::PostStatisticalResult::NameStatisticalScalar" == ""} {
        WarnWin [_ "Please, enter a name for the maximum scalar result"]
        return
    }

    set analisis_actual $::PostStatisticalResult::Analisis
    set all_steps $::PostStatisticalResult::Step
    if { $::PostStatisticalResult::AllSteps} {
        set all_steps [ GiD_Info postprocess get all_steps $::PostStatisticalResult::Analisis]
    }
    set first_step [ lindex $all_steps 0]
    set last_step [ lindex $all_steps end]
    set current_step [ GiD_Info postprocess get cur_step $::PostStatisticalResult::Analisis]
    set all_steps {}
    foreach idx [ $::PostStatisticalResult::StepsListBox curselection] {
        lappend all_steps [ lindex $::PostStatisticalResult::StepsListBoxVariable $idx]
    }
    if { [ llength $all_steps] < 2} {
        WarnWin [_ "At least two steps must be selected"]
        return
    }

    set texto_salida ""

    # try $::PostStatisticalResult::Step, current_step, last_step or first_step
    set err [ catch {
        set header [lindex [GiD_Result get -info \
                                [list $::PostStatisticalResult::NameResultToSearch $analisis_actual $::PostStatisticalResult::Step]] 0]
    }]
    if { $err} {
        set err [ catch {
            set header [lindex [GiD_Result get -info \
                                    [list $::PostStatisticalResult::NameResultToSearch $analisis_actual $current_step]] 0]
           }]
    }
    if { $err} {
        set err [ catch {
            set header [lindex [GiD_Result get -info \
                                    [list $::PostStatisticalResult::NameResultToSearch $analisis_actual $last_step]] 0]
           }]
    }
    if { $err} {
        set err [ catch {
            set header [lindex [GiD_Result get -info \
                                    [list $::PostStatisticalResult::NameResultToSearch $analisis_actual $first_step]] 0]
           }]
    }
    if { [lindex $header 5] == "OnNodes" } {
        set header [list Result $::PostStatisticalResult::NameStatisticalScalar $analisis_actual $last_step Scalar [lindex $header 5]]
    } else {
        set header [list Result $::PostStatisticalResult::NameStatisticalScalar $analisis_actual $last_step Scalar [lindex $header 5] [lindex $header 6]]  
    }
    if { $err} {
        WarnWin [_ "could not find component '%s' in '%s'" $::PostStatisticalResult::NameResultToSearch \
                     [ list $::PostStatisticalResult::Step $current_step $last_step $first_step ] ]
    }
    
    set res_salida {}
    lappend res_salida $header

    # count components
    set all_comp [ GiD_Info postprocess get components_list "Contou_Fill"  \
                       $::PostStatisticalResult::NameResultToSearch \
                       $::PostStatisticalResult::Analisis $::PostStatisticalResult::Step]
    set nc [ llength $all_comp]
    set idx_comp [ lsearch $all_comp $::PostStatisticalResult::NameComponentToSearch]
    if  { ( $idx_comp < 0) || ( $idx_comp >= $nc)} {
        WarnWin [_ "could not find component '%s' in '%s'" $::PostStatisticalResult::NameComponentToSearch $all_comp]
        return
    }

    catch {
        array unset ::PostStatisticalResult::tbl_values
        array unset ::PostStatisticalResult::tbl_values_med
    }
    # initialize the progress bar
    set ::PostStatisticalResult::progress_value 0
    set endBar [ llength $all_steps]

    # for the creation step
    incr end 
    set idxBar 0
    GidUtils::WaitState $w

    set num_steps [ llength $all_steps]
    set there_is_error 0
    set op_idx [ lsearch $::PostStatisticalResult::ListOperators $::PostStatisticalResult::TxtOperator]
    if { $op_idx == 4} {
        # standard deviation
        set idxBar $endBar
        set endBar [ expr 2 * $endBar]
        set there_is_error [ ::PostStatisticalResult::CalculateAverageValues $all_steps $idx_comp $endBar]
    }
    if { !$there_is_error} {
        set previouos_step ""
        foreach current_step $all_steps {
            # user feedback
            set ::PostStatisticalResult::OutputLabel [_ "Processing step %g" $current_step]
            update
            set all_exist 1
            #We fill a table with the maximum values of the scalars
            set res_info ""
            set err [ catch {
                set res_info [GiD_Result get [list $::PostStatisticalResult::NameResultToSearch $analisis_actual $current_step]]
            } errTxt ]
            if { $err} {
                WarnWin $errTxt
                set all_exist 0
                set there_is_error 1
                GidUtils::EndWaitState $w
                break
            }

            # set ::PostStatisticalResult::ListOperators [ list [_ "minimum"] [_ "maximum"] [_ "average"] [_ "accumulated"] [_ "standard deviation"] [_ "integral value"] [_ "root mean square"]]
            switch -- $op_idx {
                0 { # minimum
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [ lindex $lst 1]
                            if { ![IsResultNotDefined $escalar]} {
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    if { $escalar < $::PostStatisticalResult::tbl_values($idx_nodo)} {
                                        set ::PostStatisticalResult::tbl_values($idx_nodo) $escalar
                                    }
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $escalar
                                }
                            }
                        }
                    }
                }
                1 { # maximum
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [ lindex $lst 1]
                            if { ![IsResultNotDefined $escalar]} {
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    if { $escalar > $::PostStatisticalResult::tbl_values($idx_nodo)} {
                                        set ::PostStatisticalResult::tbl_values($idx_nodo) $escalar
                                    }
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $escalar
                                }
                            }
                        }
                    }
                }
                2 { # average
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [ lindex $lst 1]
                            if { ![IsResultNotDefined $escalar]} {
                                set val [ expr $escalar / $num_steps]
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) [ expr $::PostStatisticalResult::tbl_values($idx_nodo) + $val]
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $val
                                }
                            }
                        }
                    }
                }
                3 { # accumulated
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [ lindex $lst 1]
                            if { ![IsResultNotDefined $escalar]} {
                                set val $escalar
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) [ expr $::PostStatisticalResult::tbl_values($idx_nodo) + $val]
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $val
                                }
                            }
                        }
                    }
                }
                4 { # standard deviation
                    # Sn = sqrt( 1/NumSamples * sum( i = 1..NumSamples, ( Si - Smed) ^ 2))
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [ lindex $lst 1]
                            if { ![IsResultNotDefined $escalar]} {
                                set escalar [ expr $escalar - $::PostStatisticalResult::tbl_values_med($idx_nodo)]
                                set escalar [ expr $escalar * $escalar]
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) \
                                        [ expr $::PostStatisticalResult::tbl_values($idx_nodo) + $escalar]
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $escalar
                                }
                            }
                        }
                    }
                }
                5 { # integral value                    
                    if { $previouos_step != "" } {
                        set time [ expr $current_step - $previouos_step]
                    } else {
                        if { $::PostStatisticalResult::FromStep0 } {
                            set time $current_step
                        } else {
                            set time 0
                        }
                    }
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [ lindex $lst 1]
                            
                            if { ![IsResultNotDefined $escalar]} {
                                if { $previouos_step == "" } {
                                    if { $::PostStatisticalResult::FromStep0 } {
                                        set escalar_anterior $::PostStatisticalResult::Step0Value
                                    }
                                }
                                if { $time == 0} { 
                                    set val 0 
                                } else { 
                                    set val [ expr [ expr $time / 2] * [ expr $escalar + $escalar_anterior]]
                                }
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) [ expr $::PostStatisticalResult::tbl_values($idx_nodo) + $val]
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $val
                                }
                            }
                        }
                    }
                    set previouos_step $current_step
                    set escalar_anterior $escalar
                }    
                6 { #root mean square
                    foreach entrada [ lrange $res_info 3 end] {
                        set lst [ ::PostStatisticalResult::get_idx_val_from_entry $entrada $idx_comp]
                        if { $lst != {}} {
                            set idx_nodo [ lindex $lst 0]
                            set escalar [lindex $lst 1]
                            if { ![IsResultNotDefined $escalar]} {
                                set escalar_2 [expr $escalar*$escalar]
                                if { [ info exists ::PostStatisticalResult::tbl_values($idx_nodo)]} {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) [expr {$::PostStatisticalResult::tbl_values($idx_nodo)+$escalar_2}]
                                } else {
                                    set ::PostStatisticalResult::tbl_values($idx_nodo) $escalar_2
                                }
                            }
                        }
                    }                   
                }            
            }
            # user feedback
            incr idxBar
            set ::PostStatisticalResult::progress_value [ expr int( ( 100.0 * $idxBar) / $endBar)]
            update
        } ;# foreach steps
    } ;# !there_is_error

    if { [ llength [array get ::PostStatisticalResult::tbl_values] ] == 0} {
        set there_is_error 1
        WarnWin [_ "Can not create '%s' with no results." $res_salida]
    }

    if { !$there_is_error} {
        set ::PostStatisticalResult::OutputLabel [_ "Creating result"]
        if { $op_idx == 4} {
            # standard deviation
            set inv_n [expr 1.0 /double($num_steps)]
            foreach {idx_nodo escalar} [array get ::PostStatisticalResult::tbl_values] {
                lappend res_salida [list $idx_nodo [expr {sqrt($escalar*$inv_n)}]]
            }
        } elseif { $op_idx == 6} {
            #root mean square
            set inv_n [expr 1.0 /double($num_steps)]
            foreach {idx_nodo escalar} [array get ::PostStatisticalResult::tbl_values] {
                lappend res_salida [list $idx_nodo [expr {sqrt($escalar*$inv_n)}]]
            } 
        } else {
            foreach {idx_nodo escalar} [ array get ::PostStatisticalResult::tbl_values] {
                lappend res_salida [list $idx_nodo $escalar]
            }       
        }
        eval GiD_Result create $res_salida
    
        GidUtils::EndWaitState $w
        set ::PostStatisticalResult::progress_value 100
        after 2000 { set ::PostStatisticalResult::OutputLabel ""; set ::PostStatisticalResult::progress_value 0}
        
        set texto_salida ""
        append texto_salida  [_ "Scalar result '%s' ('%s', step '%s') created from '%s'" \
                                  $::PostStatisticalResult::TxtStatisticalScalarName $analisis_actual \
                                  $last_step $::PostStatisticalResult::NameResultToSearch]
        WarnWin $texto_salida
    }
}

#Fills the list of analysis
proc ::PostStatisticalResult::ActualizeAnalysisList { w w_ana} {
    $w_ana configure -values [ lsort -dictionary [GiD_Info postprocess get all_analysis]]
    ::PostStatisticalResult::ActualizeResultList $w
    ::PostStatisticalResult::ActualizeComponentList $w
}

#Dependencies of the analysis selection
proc ::PostStatisticalResult::ActualizeStepList { w w_local} {
    if { $::PostStatisticalResult::TxtAnalisis == "" } { 
        return 
    }
    set ::PostStatisticalResult::Analisis $::PostStatisticalResult::TxtAnalisis

    if { $::PostStatisticalResult::Analisis != ""} {
        set all_steps [ GiD_Info postprocess get all_steps $::PostStatisticalResult::Analisis]
        set analisis_actual [ GiD_Info postprocess get cur_analysis]
        if { "$analisis_actual" == "$::PostStatisticalResult::Analisis"} {
            set current_step [ GiD_Info postprocess get cur_step $analisis_actual]
        } else {
            set current_step [ lindex $all_steps 0]
        }
        set ::PostStatisticalResult::Step $current_step
        if {$::PostStatisticalResult::Scalar_initialized == "1" } {
            ::PostStatisticalResult::ActualizeResultList $w
        }
        if { $::PostStatisticalResult::StepsListBoxVariable != $all_steps} {
            set ::PostStatisticalResult::StepsListBoxVariable $all_steps
        }
    }
    # print_variables "ASL end"
    ::PostStatisticalResult::ActualizeResultList $w
    ::PostStatisticalResult::ActualizeComponentList $w
}

#Update the values of the scalar lists
proc ::PostStatisticalResult::ActualizeResultList { w} {
    set menu $w.f.m1

    # print_variables "ARL ini"
    if { $::PostStatisticalResult::Analisis != ""} {
        if { $::PostStatisticalResult::Step != ""} {
            set ret {}
            set all [ GiD_Info postprocess get results_list "Contour_Fill"  \
                          $::PostStatisticalResult::Analisis $::PostStatisticalResult::Step]
            foreach res $all {
                lappend ret $res
            }
            $menu configure -values $ret
            
            if { [ lsearch $ret $::PostStatisticalResult::NameResultToSearch] == -1} {
                if { [ llength $ret] != 0} {
                    set ::PostStatisticalResult::NameResultToSearch [lindex $ret 0]
                } else {
                    set ::PostStatisticalResult::NameResultToSearch ""
                }
                set ::PostStatisticalResult::TxtNameResultToSearch $::PostStatisticalResult::NameResultToSearch
                ::PostStatisticalResult::ActualizeStatisticalScalarName
            }
        }
    }
}

proc ::PostStatisticalResult::ActualizeComponentList { w} {
    set menu $w.f.m1c

    set ::PostStatisticalResult::NameResultToSearch $::PostStatisticalResult::TxtNameResultToSearch

    # print_variables "ACL ini"
    if { $::PostStatisticalResult::Analisis != ""} {
        if { $::PostStatisticalResult::Step != ""} {
            if { $::PostStatisticalResult::NameResultToSearch != ""} {
                set ret {}
                set all [ GiD_Info postprocess get components_list "Contou_Fill"  \
                              $::PostStatisticalResult::NameResultToSearch \
                              $::PostStatisticalResult::Analisis $::PostStatisticalResult::Step]
                set ret $all
                $menu configure -values $ret
            
                if { [ lsearch $ret $::PostStatisticalResult::NameComponentToSearch] == -1} {
                    if { [ llength $ret] != 0} {
                        set ::PostStatisticalResult::NameComponentToSearch [lindex $ret 0]
                    } else {
                        set ::PostStatisticalResult::NameComponentToSearch ""
                    }
                    set ::PostStatisticalResult::TxtNameComponentToSearch $::PostStatisticalResult::NameComponentToSearch
                    ::PostStatisticalResult::ActualizeStatisticalScalarName
                }
            }
        }
    }
}

proc ::PostStatisticalResult::ActualizeOptions {} {
    if { ![info exists ::PostStatisticalResult::FromStep0] } { 
        set ::PostStatisticalResult::FromStep0 0
    } 
            
    if { ![info exists ::PostStatisticalResult::Step0Value] } { 
        set ::PostStatisticalResult::Step0Value 0
    }
}

#Dependencies of the all steps check button
proc ::PostStatisticalResult::EnableDisableList { w} {
    if { $::PostStatisticalResult::AllSteps} {
        $w configure -state disabled
    } else {
        $w configure -state normal
    }
}

#We suggest a name while dealing with a single vector
proc ::PostStatisticalResult::ActualizeStatisticalScalarName {} {
    if { "$::PostStatisticalResult::TxtNameResultToSearch" == "" } {
        set ::PostStatisticalResult::NameResultToSearch ""
        set ::PostStatisticalResult::NameStatisticalScalar ""
        set ::PostStatisticalResult::TxtStatisticalScalarName ""
        ::PostStatisticalResult::EnableDisableOptionsButton 
        return
    }
    set ::PostStatisticalResult::NameResultToSearch $::PostStatisticalResult::TxtNameResultToSearch
    set ::PostStatisticalResult::NameComponentToSearch $::PostStatisticalResult::TxtNameComponentToSearch
    if { $::PostStatisticalResult::NameResultToSearch != ""} {
        # new name under results name
        set ::PostStatisticalResult::NameStatisticalScalar \
            "$::PostStatisticalResult::NameResultToSearch//$::PostStatisticalResult::NameComponentToSearch $::PostStatisticalResult::TxtOperator"
    } else {
        set ::PostStatisticalResult::NameStatisticalScalar ""
    }
    set ::PostStatisticalResult::TxtStatisticalScalarName $::PostStatisticalResult::NameStatisticalScalar
    
    ::PostStatisticalResult::EnableDisableOptionsButton 

}

#Initialize the values related with the three scalars
proc ::PostStatisticalResult::InitializeResults {} {
    set ::PostStatisticalResult::Analisis ""
    set ::PostStatisticalResult::TxtAnalisis ""
    set ::PostStatisticalResult::Step ""
    set ::PostStatisticalResult::NameResultToSearch ""
    set ::PostStatisticalResult::TxtNameResultToSearch ""
    set ::PostStatisticalResult::NameComponentToSearch ""
    set ::PostStatisticalResult::TxtNameComponentToSearch ""
}

proc ::PostStatisticalResult::CreateStepsListBox { f } {
    set ::PostStatisticalResult::StepsListBox $f.list
    ttk::frame $f
    ttk::scrollbar $f.xscroll -orient horizontal -command [ list $f.list xview]
    ttk::scrollbar $f.yscroll -orient vertical -command [ list $f.list yview]
    #pseudottk::
    tk::listbox $f.list -height 5 -width 20 \
        -xscroll [ list $f.xscroll set] \
        -yscroll [ list $f.yscroll set] \
        -selectmode extended -relief sunken -borderwidth 1 \
        -listvariable ::PostStatisticalResult::StepsListBoxVariable
        
    grid $f.list -sticky ewns
    grid $f.xscroll -sticky ew
    grid $f.yscroll -sticky ns -rowspan 2 -row 0 -column 1
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1
    return $f
}

#Build the window of the macro
proc ::PostStatisticalResult::StatisticalScalarResult {  { w .gid.wStatisticalScalarResult}} {    
    package require BWidget
    set ::PostStatisticalResult::TxtStatisticalScalarName [_ "Maximum"]
    ::PostStatisticalResult::InitializeResults
    set ::PostStatisticalResult::Scalar_initialized 0
    set ::PostStatisticalResult::Delete_scalars 0
    set ::PostStatisticalResult::AllSteps 1
    set ::PostStatisticalResult::OutputLabel ""
    set ::PostStatisticalResult::ListOperators [ list [_ "minimum"] [_ "maximum"] [_ "average"] [_ "accumulated"] [_ "standard deviation"] [_ "integral value"] [_ "root mean square"]]

    InitWindow2 $w -title [_ "Create statistical scalar result"] \
        -geometryvariable PostStatisticalScalarResultWindowGeom \
        -initcommand ::PostStatisticalResult::StatisticalScalarResult

    ttk::frame $w.f  

    #Analysis
    label $w.f.la -text [_ "Analysis"]:
    if { ![info exists ::PostStatisticalResult::TxtAnalisis] } {
        set ::PostStatisticalResult::TxtAnalisis ""
    }
    ComboBox $w.f.ma -textvariable ::PostStatisticalResult::TxtAnalisis -editable 0 -width 30 -borderwidth 1 \
        -modifycmd "::PostStatisticalResult::ActualizeStepList $w $w.f.fp.mp"
    ::PostStatisticalResult::ActualizeAnalysisList $w $w.f.ma

    #Step
    label $w.f.lp -text [_ "Step"]:
    # ttk::frame $w.f.fp   
    #if { ![info exists ::PostStatisticalResult::Step] } {
        #set ::PostStatisticalResult::Step ""
    #}
    # ComboBox $w.f.fp.mp -textvariable ::PostStatisticalResult::Step \
    #         -editable 0 -width 8 -borderwidth 1 \
    #         -modifycmd "::PostStatisticalResult::ActualizeResultList $w"
    # if { ![ info exists ::PostStatisticalResult::AllSteps] } { 
    #         set ::PostStatisticalResult::AllSteps 0 
    # }
    # ttk::checkbutton $w.f.fp.cb -text [_ "all steps"] \
    #         -variable ::PostStatisticalResult::AllSteps \
    #         -command "::PostStatisticalResult::EnableDisableList $w.f.fp.mp" \
    #         -state disabled
    # grid $w.f.fp.mp $w.f.fp.cb -sticky w

    ::PostStatisticalResult::CreateStepsListBox $w.f.lbsteps

    # from result:    
    label $w.f.l1 -text [_ "From result"]:
    if { ![info exists ::PostStatisticalResult::TxtNameResultToSearch] } {
        set ::PostStatisticalResult::TxtNameResultToSearch ""
    }
    ComboBox [subst $w.f.m1] -textvariable ::PostStatisticalResult::TxtNameResultToSearch \
        -editable 0 -width 30 -borderwidth 1 \
        -modifycmd "::PostStatisticalResult::ActualizeComponentList $w"
        # -modifycmd ::PostStatisticalResult::ActualizeStatisticalScalarName
    $w.f.m1 configure -values [ ::PostStatisticalResult::GetResultsList]
    ::PostStatisticalResult::ActualizeResultList $w
    
    label $w.f.l1c -text [_ "component"]:
    if { ![info exists ::PostStatisticalResult::TxtNameComponentToSearch] } {
        set ::PostStatisticalResult::TxtNameComponentToSearch ""
    }
    ComboBox [subst $w.f.m1c] -textvariable ::PostStatisticalResult::TxtNameComponentToSearch \
        -editable 0 -width 30 -borderwidth 1 \
        -modifycmd ::PostStatisticalResult::ActualizeStatisticalScalarName
    $w.f.m1c configure -values [ ::PostStatisticalResult::GetResultComponentsList]
    ::PostStatisticalResult::ActualizeComponentList $w

    # statistic operator: minimum maximum average accumulated deviation integral
    label $w.f.l_op -text [_ "statistics operator"]:
    
    ttk::button $w.f.b_op -text [_ "options"] -command "::PostStatisticalResult::Options $w"
    set ::PostStatisticalResult::OptionsButton $w.f.b_op
    if { ![info exists ::PostStatisticalResult::TxtOperator] } {
        set ::PostStatisticalResult::TxtOperator ""
    }
    ComboBox [subst $w.f.m_op] -textvariable ::PostStatisticalResult::TxtOperator \
        -editable 0 -width 30 -borderwidth 1 \
        -modifycmd ::PostStatisticalResult::ActualizeStatisticalScalarName
    #-modifycmd ::PostStatisticalResult::ActualizeOperator
    $w.f.m_op configure -values $::PostStatisticalResult::ListOperators
    
    set ::PostStatisticalResult::TxtOperator [ lindex $::PostStatisticalResult::ListOperators 0] 
       
    # to result: Maximum scalar Name selection
    ::PostStatisticalResult::ActualizeStatisticalScalarName
    label $w.f.l2 -text [_ "To scalar result"]:
    ttk::entry $w.f.e2 -textvariable ::PostStatisticalResult::TxtStatisticalScalarName -width 30
    label $w.f.l2h -text [_ "( will be created in last step)"] -font SmallFont
    
    set ::PostStatisticalResult::Analisis [ GiD_Info postprocess get cur_analysis]
    set ::PostStatisticalResult::TxtAnalisis $::PostStatisticalResult::Analisis
    ::PostStatisticalResult::ActualizeStepList $w $w.f.fp.mp
    
    label $w.f.lpb -textvariable ::PostStatisticalResult::OutputLabel
    ttk::progressbar $w.f.pb -variable ::PostStatisticalResult::progress_value -length 200
    
    set ::PostStatisticalResult::progress_value 0
    
    set ::PostStatisticalResult::Scalar_initialized 1
    ::PostStatisticalResult::ActualizeAnalysisList $w $w.f.ma
    ::PostStatisticalResult::ActualizeStepList $w $w.f.fp.mp
    ::PostStatisticalResult::ActualizeResultList $w
    ::PostStatisticalResult::ActualizeComponentList $w
    ::PostStatisticalResult::ActualizeOptions
    
    # analysis
    grid $w.f.la $w.f.ma -sticky e -padx 2 -pady 1
    grid configure $w.f.ma -sticky ew -columnspan 2
    # step
    grid $w.f.lp $w.f.lbsteps -sticky en -padx 2 -pady 1
    grid configure $w.f.lbsteps -sticky news -columnspan 2

    # Scalar result
    grid $w.f.l1 $w.f.m1 -sticky e -padx 2 -pady 1
    grid configure $w.f.m1 -sticky ew -columnspan 2
    grid $w.f.l1c $w.f.m1c -sticky e -padx 2 -pady 1
    grid configure $w.f.m1c -sticky ew -columnspan 2
    
    #operator
    grid $w.f.l_op $w.f.m_op $w.f.b_op -sticky w -padx 2 -pady 1
    grid configure $w.f.m_op -sticky ew
   
    # vector's name
    grid $w.f.l2 $w.f.e2 -sticky e -padx 2 -pady 1
    grid configure $w.f.e2 -sticky ew -columnspan 2
    grid $w.f.l2h -column 1 -sticky w -padx 2 -pady 1
    grid $w.f.lpb $w.f.pb -sticky e -padx 2 -pady 1
    grid configure $w.f.pb -sticky ew -columnspan 2
    # # Scalars deletion    

    # General displaying
    grid rowconfigure $w.f 0 -weight 0
    grid rowconfigure $w.f 1 -weight 1
    grid rowconfigure $w.f 2 -weight 0
    grid rowconfigure $w.f 3 -weight 0
    grid rowconfigure $w.f 4 -weight 0
    grid rowconfigure $w.f 5 -weight 0
    grid rowconfigure $w.f 6 -weight 0
    
    grid columnconfigure $w.f 1 -weight 1
    
    ttk::frame $w.buts -style BottomFrame.TFrame
    ttk::button $w.buts.apply -text [_ "Create"] -command [list ::PostStatisticalResult::CreateStatisticalResult $w] -style BottomFrame.TButton
    ttk::button $w.buts.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton    
    
    grid $w.buts.apply $w.buts.close -sticky ew -padx 5 -pady 6
    # Upper part
    grid $w.f -sticky nsew
    # Lower part
    grid $w.buts -sticky sew
    grid anchor $w.buts center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1    
}

## ::PostStatisticalResult::StatisticalScalarResult
