
set ::_Debug_PostAnim 0
set ::DO_HARMONIC_ANIMATION_IN_TCL 0 ;#now it is done at C++ level

proc PostAnimateDisableGUIUpdates { } {
    GiD_Project set disable_windows 1
    GiD_Project set disable_warnline 1
    set ::GidPriv(PostAnimateOldAutomaticRotationCenter) [ GiD_Set AutomaticRotationCenter]
    GiD_Set AutomaticRotationCenter 0
}

proc PostAnimateEnableGUIUpdates { } {
    GiD_Project set disable_windows 0
    GiD_Project set disable_warnline 0
    if { [ info exist ::GidPriv(PostAnimateOldAutomaticRotationCenter)]} {
        GiD_Set AutomaticRotationCenter $::GidPriv(PostAnimateOldAutomaticRotationCenter)
    }
    # update menus and windows ....
    set cur_analysis [GiD_Info postprocess get cur_analysis]
    ::GiDPostprocessUpdate LoadSelectionEvent $cur_analysis [GiD_Info postprocess get cur_step $cur_analysis] 
}

proc PostAnimateDefineSupportedVideoFormats {} {

    set lst_keys [ list MPEG AVIMJPG AVIMSVC AVI AVI15 AVI16 GIF/None GIF/Dither595 GIF/Dither666 FLV \
                      mp4_h264 avi_h264 avi_mp4v3 avi_mpeg4 avi_mjpeg gif_gif flv_flashsv webm_vp9 webm_vp9_alpha]
    set lst_labels [ list [_ "MPEG"] [_ "AVI/mjpeg"] [_ "AVI/MS Video 1"] [_ "AVI/raw True Color"] \
                         [_ "AVI/raw 15 bpp (VD)"] [_ "AVI/raw 16 bpp (MS)"] \
                         [_ "GIF/no dithering"] [_ "GIF/dithering595"] [_ "GIF/dithering666"] \
                         [_ "Macromedia Flash Video (flv)"] \
                         "MP4 (openh264 ffmpeg)" "AVI (openh264 ffmpeg)" "AVI (microsoft mpeg4 v3 ffmpeg)" \
                         "AVI (mpeg4 ffmpeg)" "AVI (mjpeg ffmpeg)" "gif (animated ffmpeg)" \
                         "FLV flash video (ffmpeg)" "WEBM (vp9 web video ffmpeg)" "WEBM (vp9 with transparency ffmpeg)" \
                        ]
    set lst_extensions [ list mpg avi avi avi avi avi gif gif gif flv \
                            mp4 avi avi avi avi gif flv webm webm]
    set lst_fps_max [ list 25 120 120 120 120 120 25 25 25 120 \
                          200 200 200 200 200 25 200 200 200]
    # they accept 600 fps, but are unusable ?                      600 600 600 600 600 25 600 600 600
    set n_lst_keys [ llength $lst_keys]
    set n_lst_labels [ llength $lst_labels]
    set n_lst_extensions [ llength $lst_extensions]
    if { ( $n_lst_labels != $n_lst_keys) || ( $n_lst_keys != $n_lst_extensions)} {
        error "PostAnimateDefineSupportedFormats definitions are not correct"
    }
    set ::GidPriv(PostAnimateVideoFormats) $lst_keys
    set ::GidPriv(PostAnimateVideoFormatLabels) $lst_labels
    set ::GidPriv(PostAnimateVideoFormatExtensions) $lst_extensions
    foreach k $lst_keys l $lst_labels e $lst_extensions f $lst_fps_max {
        set ::GidPriv(PostAnimateVideoFormat,${k},Label) $l
        set ::GidPriv(PostAnimateVideoFormat,${k},Extension) $e
        set ::GidPriv(PostAnimateVideoFormat,${k},MaxFps) $f
    }

    # to maintain backward compatibility, define above all supported codecs
    # and below only the ones to show to the user.
    set lst_keys2show $lst_keys
    # set lst_keys2show [ list mp4_h264 avi_h264 avi_mjpeg flv_flashsv \
    #                         webm_vp9 webm_vp9_alpha gif_gif GIF/None GIF/Dither595 GIF/Dither666]
    set ::GidPriv(PostAnimateShowVideoFormats) $lst_keys2show
    set ::GidPriv(PostAnimateShowVideoFormatLabels) {}
    set ::GidPriv(PostAnimateShowVideoFormatExtensions) {}
    foreach k $lst_keys2show {
        lappend ::GidPriv(PostAnimateShowVideoFormatLabels) $::GidPriv(PostAnimateVideoFormat,$k,Label)
        lappend ::GidPriv(PostAnimateShowVideoFormatExtensions) $::GidPriv(PostAnimateVideoFormat,$k,Extension)
    }
}

proc PostAnimateGetDefaultVideoFormat { } {
    if { ![ info exists ::GidPriv(PostAnimateVideoFormats)]} {
        PostAnimateDefineSupportedVideoFormats
    }
    # return AVIMSVC
    # return AVIMJPG
    return mp4_h264
}

proc PostAnimateVerifyPermissions { w filename} {
    # verify if exists
    if { ![ catch {
        set fi [ open $filename]
        close $fi}]} {
        set resp [GID_tk_messageBox -parent $w -default no -title [_ "Confirm"] -type yesno \
                       -icon warning \
                       -message [_ "The file %s already exists.\nOverwrite it?" $filename]]
        if { $resp == "no"} {
            return 0
        }
    }
    # verify if filename could be written
    if { [ catch {
        set fo [ open $filename w]
        puts $fo "hola"
        close $fo
        file delete -force $filename
    } err_msg ]} {
        WarnWin "$err_msg\nPlease check permisions, quotas and \nthat no application is using the file." $w
        return 0
    }
    return 1
}

proc PostAnimateInitValues {} {
    global GidPriv SingleStepAnimation

    PostAnimateDefineSupportedVideoFormats
    
    set ::GidPriv(PostAnimateControlsDelay) 0
    
    set ::GidPriv(PostAnimateDoing) Nothing
    set ::GidPriv(PostAnimateDeform) 0
    set ::GidPriv(PostAnimateIsoSurfaces) ""
    set ::GidPriv(PostAnimateRsultView) ""
    set ::GidPriv(PostAnimateCurrentButton) ""
    set ::GidPriv(PostAnimateDefaultDurationType) Delay
    if { ![ info exists GidPriv(PostAnimateDurationType)]} {
        set ::GidPriv(PostAnimateDurationType) $::GidPriv(PostAnimateDefaultDurationType)
    }
    # in miliseconds
    set ::GidPriv(PostAnimateMinimumDelayTime) 5
    set ::GidPriv(PostAnimateDefaultDelayTime) 40
    set ::GidPriv(PostAnimateDefaultFPS) 25
    if { ![ info exists GidPriv(PostAnimateDelayTime)] } {
        set ::GidPriv(PostAnimateDelayTime) $::GidPriv(PostAnimateDefaultDelayTime)
    }
    # in seconds
    set ::GidPriv(PostAnimateFixedDelay) 1
    set ::GidPriv(PostAnimateDefaultDurationTime) 5
    if { ![ info exists GidPriv(PostAnimateDurationTime)]} {
        set ::GidPriv(PostAnimateDurationTime) $::GidPriv(PostAnimateDefaultDurationTime)
    }
    if { ![ info exists GidPriv(PostAnimateDurationTimeDelay)]} {
        set ::GidPriv(PostAnimateDurationTimeDelay) $::GidPriv(PostAnimateDefaultDurationTime)
    }
    set ::GidPriv(PostAnimateFixedTotalTime) 0
    set ::GidPriv(PostAnimateUseScaledStepvalues) 0
    set ::GidPriv(PostAnimateDurationOld) 0
    set ::GidPriv(PostAnimateUseStepvalues) 0
    set ::GidPriv(PostAnimateStepvaluesDelay) $::GidPriv(PostAnimateDefaultDelayTime)
    set ::GidPriv(PostAnimateIstepold) 0
    set ::GidPriv(PostAnimateDefaultRangeFrameFrom) 1
    set ::GidPriv(PostAnimateDefaultRangeFrameTo) 999999999
    
    if { ![ info exists GidPriv(PostAnimateRangeFrameFrom)]} {
        set ::GidPriv(PostAnimateRangeFrameFrom) $::GidPriv(PostAnimateDefaultRangeFrameFrom)
    }
    if { ![ info exists GidPriv(PostAnimateRangeFrameTo)]} {
        set ::GidPriv(PostAnimateRangeFrameTo) $::GidPriv(PostAnimateDefaultRangeFrameTo)
    }
    set ::GidPriv(PostAnimateRangeFrames) 0
    set ::GidPriv(PostAnimateOldAutoRedraw) 1
    set ::GidPriv(PostAnimateSaveFrame) 0
    set ::GidPriv(PostAnimateSaveAnimation) 0
    set ::GidPriv(PostAnimateSavingAnimation) 0
    set ::GidPriv(PostAnimateSavingRepetitions) 1
    set ::GidPriv(PostAnimateSlideDelay) 10
    set ::GidPriv(PostAnimateSliding) 0
    set ::GidPriv(PostAnimateAnalysisLimitsCb) 0
    if { ![ info exists ::GidPriv(PostAnimateSaveFrameFormat)]} {
        set ::GidPriv(PostAnimateSaveFrameFormat) "PNG"
    }
    if { ![ info exists ::GidPriv(PostAnimateSaveAnimationFormat)]} {
        # set ::GidPriv(PostAnimateSaveAnimationFormat) [GiD_Info postprocess get animationformat]
        set ::GidPriv(PostAnimateSaveAnimationFormat) [ PostAnimateGetDefaultVideoFormat]
    }

    set ::GidPriv(PostAnimateAnimationFileQuality) [ GiD_Set AnimationFileQuality]

    lassign [ GidUtils::GetMainDrawAreaSize ] act_width act_height
    set current [format "%dx%d" $act_width $act_height]
    set ::GidPriv(PostAnimateResizeDefault) $current
    set ::GidPriv(PostAnimateResize) Default
    set ::GidPriv(PostAnimateTime) 0
    # for animations a single time step
    set ::SingleStepAnimation(profile) Lineal
    set ::SingleStepAnimation(num_steps) 10
    set ::SingleStepAnimation(in_use) 0
    set ::GidPriv(PostDoStereoAnimation) [GiD_Set PostDoStereoAnimation]    
    set ::GidPriv(PostAnimateStopAndEnableGUIUpdates) 1
}

proc PostAnimateThereAreResultsInModel { { complain "no_complain"}} {
    set ret 0
    # at least, if there are some results in the model, an analysis has been selected
    if { [info exists ::GidPriv(PostAnimate_cur_analysis)] && $::GidPriv(PostAnimate_cur_analysis) != "" } {
        set ret 1
    }
    if { !$ret && $complain != "no_complain" } {
        set w .gid
        if { [winfo exists $::GidPriv(PostAnimateWindow)] } {
            set w $::GidPriv(PostAnimateWindow)
        }
        ErrorWin [_ "No results could be found in model."] $w
    }
    return $ret
}

proc PostAnimateSingleStepAnimationCreateFactors { factor_base } {
    global SingleStepAnimation
    if { ![string is double -strict $factor_base] } {
        return 1
    }
    if { ![string is integer -strict $::SingleStepAnimation(num_steps)] } {
        return 1
    }
    if { $::SingleStepAnimation(num_steps) < 2 } {
        set ::SingleStepAnimation(num_steps) 10
        GidUtils::SetWarnLine [_ "Wrong number of steps for the animation. Set to %s" $::SingleStepAnimation(num_steps)]
    } elseif { $::SingleStepAnimation(num_steps) > 1000 } {
        set ::SingleStepAnimation(num_steps) 1000
        GidUtils::SetWarnLine [_ "Wrong number of steps for the animation. Set to %s" $::SingleStepAnimation(num_steps)]
    }
    switch $::SingleStepAnimation(profile) {
        "Lineal" {
            set f [expr 1.0/double($::SingleStepAnimation(num_steps)-1)]
            set ::SingleStepAnimation(factors) ""
            for { set i 0} { $i < $::SingleStepAnimation(num_steps)} { incr i} {
                lappend ::SingleStepAnimation(factors) [expr $factor_base*$i*$f]
            }
        }
        "Sinus" {
            set f [expr 2.0*asin(1.0)/double($::SingleStepAnimation(num_steps)-1)]
            set ::SingleStepAnimation(factors) ""
            for { set i 0} { $i < $::SingleStepAnimation(num_steps)} { incr i} {
                lappend ::SingleStepAnimation(factors) [ expr $factor_base*(sin($f*$i))]
            }
        }        
        "Triangular" {
            set ::SingleStepAnimation(factors) ""
            if { $::SingleStepAnimation(num_steps) == 2} {                
                lappend ::SingleStepAnimation(factors) $factor_base
                lappend ::SingleStepAnimation(factors) $factor_base
            } else {
                set p2 [expr ($::SingleStepAnimation(num_steps))/2]
                set f [expr 1.0/double($p2)]
                for { set i 0} { $i < $p2} { incr i} {
                    lappend ::SingleStepAnimation(factors) [expr $factor_base*$i*$f]
                }
                # si es impar repetimos $factor_base, p.ej.
                # 3 steps -> 1.0 1.0 0.0
                # 4 steps -> 0.5 1.0 0.5 0.0
                # 5 steps -> 0.5 1.0 1.0 0.5 0.0
                if { [ expr $::SingleStepAnimation(num_steps)%2]} {
                    lappend ::SingleStepAnimation(factors) $factor_base
                }
                for { set i 1} { $i <= $p2} { incr i} {
                    lappend ::SingleStepAnimation(factors) [expr $factor_base*($p2-$i)*$f]
                }
            }
        }
        "Sinusoidal" {
            if { $::SingleStepAnimation(num_steps) == 2} {
                set ::SingleStepAnimation(factors) ""
                lappend ::SingleStepAnimation(factors) $factor_base
                lappend ::SingleStepAnimation(factors) $factor_base
            } else {
                set f [expr 4.0*asin(1.0)/double($::SingleStepAnimation(num_steps)-1)]
                set ::SingleStepAnimation(factors) ""
                for { set i 0} { $i<$::SingleStepAnimation(num_steps)} { incr i} {
                    lappend ::SingleStepAnimation(factors) [expr $factor_base*(sin($f*$i))]
                }
            }
        }        
    }
    return 0
}

proc PostAnimateSelectSingleStepAnimation {} {
    if { [GiD_Info postprocess get main_geom_state] == "Deformed" } {        
        if { $::DO_HARMONIC_ANIMATION_IN_TCL } {
            set doHarmonicAnimation [PostAnimateHarmonicCheckForAnimation $::GidPriv(PostAnimateWindow)]
        } else {
            set doHarmonicAnimation 0
        }
        if { $doHarmonicAnimation } {
            PostAnimateHarmonic_PostAnimateSelectSingleStepAnimation
        } else {
            # Do a normal static animation...            
            $::SingleStepAnimation(ProfileMenuButton) configure -state normal
            $::SingleStepAnimation(StepCombox) configure -state readonly
            $::SingleStepAnimation(NumStepsEntry) configure -state normal
            $::SingleStepAnimation(FactorEntry) configure -state normal
            set ::SingleStepAnimation(in_use) 1
            set ::GidPriv(PostAnimateProfileType) SingleStep
            set ::SingleStepAnimation(deformation_factor) $::GidPriv(PostAnimate_cur_d_factor)            
            set ::SingleStepAnimation(step_selected) $::GidPriv(PostAnimate_cur_d_step)
            PostAnimateSingleStepAnimationCreateFactors $::SingleStepAnimation(deformation_factor)
            PostAnimateCreateStaticAnimationProfile
            PostAnimateConfigureSlide
        }
    } else {
        # let's make it more intelligent, if there is only one result, select it to do the deformation
        set cur_analysis [GiD_Info postprocess get cur_analysis]
        set cur_step [GiD_Info postprocess get cur_step $cur_analysis] 
        set lst_deformators [lsort -dictionary [GiD_Info postprocess get show_geom_all_deform $cur_analysis $cur_step]]
        set warn_text [_ "In order for the 'Single step' deformation animation to work\n a deformation vector should be selected."]
        set num_deformators [llength $lst_deformators]
        if { $num_deformators == 0 } {
            return
        }
        set selected_deformator ""
        if { $num_deformators == 1 } {
            append warn_text "\n " [_ "The model will be deformed using the '%s' result." $lst_deformators]
            WarnWin $warn_text
            set selected_deformator [lindex $lst_deformators 0]
        } else {
            append warn_text [_ "Please, select a deformation vector"]
            set selected_deformator [MessageBoxCombobox [_ "Select a deformation vector"] $warn_text $lst_deformators readonly question.png]                        
        }
        if { $selected_deformator != ""} {
            GiD_Process Mescape Results Geometry Deformation $selected_deformator escape escape escape escape escape
            # update deformation factor
            set ::GidPriv(PostAnimate_cur_d_factor) [GiD_Info postprocess get main_geom_cur_factor]
            $::SingleStepAnimation(ProfileMenuButton) configure -state normal
            $::SingleStepAnimation(StepCombox) configure -state readonly -values [GiD_Info postprocess get all_steps $cur_analysis]
            $::SingleStepAnimation(NumStepsEntry) configure -state normal
            $::SingleStepAnimation(FactorEntry) configure -state normal
            set ::SingleStepAnimation(in_use) 1
            set ::GidPriv(PostAnimateProfileType) SingleStep
            set ::SingleStepAnimation(deformation_factor) $::GidPriv(PostAnimate_cur_d_factor)        
            set ::SingleStepAnimation(step_selected) $::GidPriv(PostAnimate_cur_d_step)
            PostAnimateSingleStepAnimationCreateFactors $::SingleStepAnimation(deformation_factor)
            PostAnimateCreateStaticAnimationProfile
            PostAnimateConfigureSlide
        }
    }
}

proc PostAnimateSelectAllStepAnimation {} {
    $::SingleStepAnimation(ProfileMenuButton) configure -state disable
    $::SingleStepAnimation(StepCombox) configure -state disable
    $::SingleStepAnimation(NumStepsEntry) configure -state disable
    $::SingleStepAnimation(FactorEntry) configure -state disable
    set ::SingleStepAnimation(in_use) 0
    set ::GidPriv(PostAnimateProfileType) AllSteps
    PostAnimateConfigureSlide
}

proc PostAnimateSelectSingleOrAllStepAnimation { } {
    global GidPriv SingleStepAnimation
    
    if { ![ info exists GidPriv(PostAnimateWindow)] || ![ winfo exists $::GidPriv(PostAnimateWindow)] } {
        return
    }
    if { [GiD_Info postprocess get main_geom_state] == "Deformed" } {
        if { [ llength $::GidPriv(PostAnimate_all_step)] != 1} {
            PostAnimateSelectAllStepAnimation
        } else {
            PostAnimateSelectSingleStepAnimation
        }
        if { ![info exists ::SingleStepAnimation(deformation_factor)]} {
            set ::SingleStepAnimation(deformation_factor) $::GidPriv(PostAnimate_cur_d_factor)
        }
        PostAnimateSingleStepAnimationCreateFactors $::SingleStepAnimation(deformation_factor)
    } else {
        PostAnimateSelectAllStepAnimation
    }
}

proc PostAnimateUpdateStepValEntry { val} {
    $::GidPriv(PostAnimateStepValueEntry) configure -state normal
    $::GidPriv(PostAnimateStepValueEntry) delete 0 end
    if { $val != ""} {
        $::GidPriv(PostAnimateStepValueEntry) insert 0 $val
    }
    $::GidPriv(PostAnimateStepValueEntry) configure -state readonly
}

proc PostAnimateUpdateStepNumEntry { val} {
    if { ![winfo exists $::GidPriv(PostAnimateStepNumberEntry)] } {
        # to avoid tcl errors calling PostAnimateFrame from after
        return
    }
    $::GidPriv(PostAnimateStepNumberEntry) configure -state normal
    $::GidPriv(PostAnimateStepNumberEntry) delete 0 end
    if { $val != ""} {
        $::GidPriv(PostAnimateStepNumberEntry) insert 0 $val
    }
    $::GidPriv(PostAnimateStepNumberEntry) configure -state readonly
}

proc PostAnimateGetNumberOfSteps {} {
    # somewhat dirty....
    if { ![ winfo exists $::GidPriv(PostAnimateSlide)] } {
        return 0
    }
    set from [ $::GidPriv(PostAnimateSlide) cget -from]
    set to [ $::GidPriv(PostAnimateSlide) cget -to]
    if { $::GidPriv(PostAnimateRangeFrames)} {
        PostAnimateCheckRangeFrame
        set from $::GidPriv(PostAnimateRangeFramesFrom)
        set to $::GidPriv(PostAnimateRangeFramesTo)
    }
    return [ expr $to - $from + 1]
}

proc PostAnimateConfigureSlide {} {
    global GidPriv SingleStepAnimation
    if { ![info exists ::GidPriv(PostAnimateSlide) ] || ![winfo exists $::GidPriv(PostAnimateSlide)] } {
        return
    }
    if { $::GidPriv(PostAnimateDeform) } {
        if { $::SingleStepAnimation(in_use)} {
            if { ![info exists ::SingleStepAnimation(factors)] } {
                set ::SingleStepAnimation(factors) ""
            }
            $::GidPriv(PostAnimateSlide) configure -from 0 -to [llength $::SingleStepAnimation(factors)]
        } else {
            $::GidPriv(PostAnimateSlide) configure -from 0 -to [llength $::GidPriv(PostAnimate_all_step)]
        }
        if { $::SingleStepAnimation(in_use)} {
            set res [ lsearch $::SingleStepAnimation(factors) $::GidPriv(PostAnimate_cur_d_factor)]
        } else {
            set res [ lsearch $::GidPriv(PostAnimate_all_step) $::GidPriv(PostAnimate_cur_d_step)]
        }
        set frame $res
        
        if { $::SingleStepAnimation(in_use)} {
            set time_step [lindex $::SingleStepAnimation(factors) $frame]
        } else {
            set time_step [lindex $::GidPriv(PostAnimate_all_step) $frame]
        }
        if { $time_step == ""} {
            set frame -1
            PostAnimateUpdateStepValEntry Orig
        } else {
            PostAnimateUpdateStepValEntry $time_step
        }
        $::GidPriv(PostAnimateSlide) set [ expr $frame+1]
        PostAnimateUpdateStepNumEntry [expr $frame+1]
        set frame [ expr $res+1]
        if { $::SingleStepAnimation(in_use)} {
            set time_step [lindex $::SingleStepAnimation(factors) $frame]
        } else {
            set time_step [lindex $::GidPriv(PostAnimate_all_step) $frame]
        }
        if { $time_step == ""} {
            set frame -1
        } else {
            set frame $res
        }
        set ::GidPriv(PostAnimateCurrentFrame) $frame
    } else {
        set nsteps [ llength $::GidPriv(PostAnimate_all_step)]
        if { $nsteps != 0} {
            $::GidPriv(PostAnimateSlide) configure -from 1 -to $nsteps
            set res [lsearch $::GidPriv(PostAnimate_all_step) $::GidPriv(PostAnimate_cur_step)]
            set frame $res        
            set time_step [lindex $::GidPriv(PostAnimate_all_step) $frame]
            PostAnimateUpdateStepValEntry $time_step
            $::GidPriv(PostAnimateSlide) set [expr $frame+1]
            PostAnimateUpdateStepNumEntry [expr $frame+1]
            
            set frame [expr $res+1]
            set time_step [lindex $::GidPriv(PostAnimate_all_step) $frame]
            if { $time_step == ""} {
                set frame 0
            } else {
                set frame $res
            }        
            set ::GidPriv(PostAnimateCurrentFrame) $frame        
        } else {
            $::GidPriv(PostAnimateSlide) configure -from 0 -to 0
            PostAnimateUpdateStepValEntry ""
            PostAnimateUpdateStepNumEntry ""        
            set ::GidPriv(PostAnimateCurrentFrame) 0
        }
    }
    set ::GidPriv(PostAnimateSlideDelay) 10
    set ::GidPriv(PostAnimateSliding) 0
    update
}

#check if analysis and step of deformation and contour fill are equal
proc PostAnimateCheckVisualizationCoherency { } {
    global GidPriv
    if { [info exists GidPriv(PostAnimateWindow)] && [winfo exists $::GidPriv(PostAnimateWindow)] } {
        if { ( $::GidPriv(PostAnimateResultView) != "") && $::GidPriv(PostAnimateDeform) } {
            if { $::GidPriv(PostAnimate_cur_d_anal) != $::GidPriv(PostAnimate_cur_analysis) } {
                # check if both analysis have same number o steps and with same values
                set ::GidPriv(PostAnimate_all_d_step) [GiD_Info postprocess get all_steps $::GidPriv(PostAnimate_cur_d_anal)]
                set are_equal 1
                if { $::GidPriv(PostAnimateRangeFrames) } {
                    set from [expr $::GidPriv(PostAnimateRangeFrameFrom) - 1]
                    set to [expr $::GidPriv(PostAnimateRangeFrameTo) - 1]
                    set res_view_steps [lrange $::GidPriv(PostAnimate_all_step) $from $to]
                    set res_def_steps [lrange $::GidPriv(PostAnimate_all_d_step) $from $to]
                } else {
                    set res_view_steps $::GidPriv(PostAnimate_all_step)
                    set res_def_steps $::GidPriv(PostAnimate_all_d_step)
                }
                if { ( [llength $res_view_steps] <= 0) || ( [llength $res_def_steps] <= 0)} {
                    set are_equal 0
                    WarnWin [_ "Empty step list in one of the analysis"]
                } elseif { ( [llength $res_view_steps] != [ llength $res_def_steps]) } {
                    set are_equal 0
                } else {
                    set l [llength $::GidPriv(PostAnimate_all_step)]
                    for { set idx 0} { $idx < $l} { incr idx} {
                        if { "[ lindex $res_view_steps $idx]" != "[ lindex $res_def_steps $idx]"} {
                            set are_equal 0
                            break
                        }
                    }
                }
                if { $are_equal} {
                    #check if step of deformation and result are equal
                    if { $::GidPriv(PostAnimate_cur_step) != $::GidPriv(PostAnimate_cur_d_step)} {
                        WarnWin "Current Deformation step differs from the current Result View's step. The animation will display the view and deformation on of the same step." $::GidPriv(PostAnimateWindow)
                    }
                } else {
                    set resp [tk_dialog  $::GidPriv(PostAnimateWindow).___pa_ww [_ "Warning"] \
                                  [_ "Current Deformation analysis differs from current Result View's analysis. \
                                Choose which one should be valid for the animation"] \
                                  info 2 [_ "ResultView"] [_ "Deformation"] [_ "Cancel"]]
                    switch $resp {
                        0 {
                            set ::GidPriv(PostAnimateDeform) 0
                        }
                        1 {
                            set ::GidPriv(PostAnimateResultView) ""
                        }
                        2 {
                            set ::GidPriv(PostAnimateResultView) ""
                            set ::GidPriv(PostAnimateDeform) 0
                        }
                    }
                }
            }
        }
    }
}

proc PostAnimateGetResultVisualizationState { } {
    global GidPriv
    if { [info exists GidPriv(PostAnimateInitializing)] && $::GidPriv(PostAnimateInitializing)} {
        return
    }
    if { ![info exists GidPriv(PostAnimateDoing)] } {
        set ::GidPriv(PostAnimateDoing) "Nothing"
    }
    if { $::GidPriv(PostAnimateDoing) != "Nothing" } {
        return
    }
    set ::GidPriv(PostAnimateInitializing) 1
    set ::GidPriv(PostAnimate_cur_analysis) [GiD_Info postprocess get cur_analysis]
    set cur_analysis $::GidPriv(PostAnimate_cur_analysis)
    set ::GidPriv(PostAnimate_cur_step) [GiD_Info postprocess get cur_step $cur_analysis]
    set ::GidPriv(PostAnimate_all_step) [GiD_Info postprocess get all_steps $cur_analysis]
    set ::GidPriv(PostAnimate_cur_result_view) [GiD_Info postprocess get cur_results_view]
    set ::GidPriv(PostAnimate_cur_res)  [GiD_Info postprocess get cur_result]
    set ::GidPriv(PostAnimate_cur_comp) [GiD_Info postprocess get cur_component]
    set ::GidPriv(PostAnimateVariosResultados) [string tolower [GiD_Set PostResOverRes]]
    set ::GidPriv(PostAnimateListaResultados) [GiD_Info postprocess get results_view_list]
    set ::GidPriv(PostAnimate_cur_d_defor) [GiD_Info postprocess get main_geom_cur_deform]
    set ::GidPriv(PostAnimate_cur_d_anal) [GiD_Info postprocess get main_geom_cur_analysis]
    set ::GidPriv(PostAnimate_cur_d_step) [GiD_Info postprocess get main_geom_cur_step]
    set ::GidPriv(PostAnimate_cur_d_factor) [GiD_Info postprocess get main_geom_cur_factor]
    set ::GidPriv(PostAnimate_cur_defor_type) [GiD_Info postprocess get main_geom_deformation_type]
    # do not change user set values, only if they are not valid
    set max_num_steps [llength $::GidPriv(PostAnimate_all_step)]
    if { ![info exist ::GidPriv(PostAnimateDefaultRangeFrameFrom)] || $::GidPriv(PostAnimateDefaultRangeFrameFrom) > $max_num_steps || \
        $::GidPriv(PostAnimateDefaultRangeFrameFrom) == 0 } {
        set ::GidPriv(PostAnimateDefaultRangeFrameFrom) 1
    }
    if { ![info exists ::GidPriv(PostAnimateDefaultRangeFrameTo)] || $::GidPriv(PostAnimateDefaultRangeFrameTo) > $max_num_steps || \
            $::GidPriv(PostAnimateDefaultRangeFrameTo) == 0 } {
        set ::GidPriv(PostAnimateDefaultRangeFrameTo) $max_num_steps
    }
    # correct user set limits if we have to
    if { ![info exist ::GidPriv(PostAnimateRangeFrameFrom)] || $::GidPriv(PostAnimateRangeFrameFrom) > $max_num_steps || \
            $::GidPriv(PostAnimateRangeFrameFrom) == 0 } {
        set ::GidPriv(PostAnimateRangeFrameFrom) 1
    }
    if { ![info exists ::GidPriv(PostAnimateRangeFrameTo)] || $::GidPriv(PostAnimateRangeFrameTo) > $max_num_steps || \
           $::GidPriv(PostAnimateRangeFrameTo) == 0 } {
        set ::GidPriv(PostAnimateRangeFrameTo) $max_num_steps
    }
    
    regsub -all {_} $::GidPriv(PostAnimate_cur_result_view) {} pepe
    set ::GidPriv(PostAnimate_cur_result_view) $pepe
    set ::GidPriv(PostAnimateResultViewCb) 1    
    switch $::GidPriv(PostAnimate_cur_result_view) {
        "ShMinMax"           { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "ContourFill"        { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "VolumeRender"       { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "SmoothContourFill"  { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "ContourLines"       { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "SmoothContourLines" { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "IsoSurfaces"        { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view) }
        "DisplayVectors" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)          
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateDisplayVectors) [GiD_Info postprocess get cur_vector_factor \
                        Display_Vectors $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateDisplayVectors) 1.0                
            }
        }
        "ContourRanges" { set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)}
        "ScalarLineDiagram" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateScalarDiagram) [GiD_Info postprocess get cur_diagram_factor \
                        $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_comp) $::GidPriv(PostAnimate_cur_analysis) \
                        $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateScalarDiagram) 1.0
            }
        }
        "VectorLineDiagram" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateVectorDiagram) [GiD_Info postprocess get cur_diagram_factor \
                        $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) \
                        $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateVectorDiagram) 1.0
            }
        }
        "ResultSurface" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateResultSurface) [GiD_Info postprocess get cur_result_surface_factor \
                        Result_Surface $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_comp) $::GidPriv(PostAnimate_cur_analysis) \
                        $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateResultSurface) 1.0
            }
        }
        "SmoothResultSurface" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateResultSurface) [GiD_Info postprocess get cur_result_surface_factor \
                        Result_Surface $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_comp) $::GidPriv(PostAnimate_cur_analysis) \
                        $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateResultSurface) 1.0
            }
        }
        "LineThickness" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateResultSurface) [GiD_Info postprocess get cur_result_surface_factor \
                        Line_Thickness $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_comp) $::GidPriv(PostAnimate_cur_analysis) \
                        $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateResultSurface) 1.0
            }
        }
        "SmoothLineThickness" {
            set ::GidPriv(PostAnimateResultView) $::GidPriv(PostAnimate_cur_result_view)
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]] } {
                set ::GidPriv(PostAnimateResultSurface) [GiD_Info postprocess get cur_result_surface_factor \
                        Line_Thickness $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_comp) $::GidPriv(PostAnimate_cur_analysis) \
                        $::GidPriv(PostAnimate_cur_step)]
            } else {
                set ::GidPriv(PostAnimateResultSurface) 1.0
            }
        }
        default {
            set ::GidPriv(PostAnimateResultView) ""
            set ::GidPriv(PostAnimateResultViewCb) 0
        }
    }    
    set ::GidPriv(PostAnimateIsoSurfaces) [lindex [GiD_Info postprocess get iso_cur_result_values] 0]
    if { [info exists GidPriv(PostAnimateResButtons)] && [winfo exists $::GidPriv(PostAnimateResButtons)] } {
        if { $::GidPriv(PostAnimateResultViewCb) } {
            $::GidPriv(PostAnimateResButtons) configure -state normal
        } else {
            $::GidPriv(PostAnimateResButtons) configure -state disabled
        }
    }
    if { [GiD_Info postprocess get main_geom_state] == "Deformed" } {
        set ::GidPriv(PostAnimateDeform) 1
    } else {
        set ::GidPriv(PostAnimateDeform) 0
    }
    
    set ::GidPriv(PostAnimateInitializing) 0
    if { [ info exists GidPriv(PostAnimateAnalysisLimitsCb)] && $::GidPriv(PostAnimateAnalysisLimitsCb) } {
        PostAnimateGetAnalysisLimits "" "" ""
    }
    set ::GidPriv(PostDoStereoAnimation) [ GiD_Set PostDoStereoAnimation]
    set ::GidPriv(PostAnimateContourUsedLimits) [PostAnimateGetUsedLimits]
    
    # update the slide bar too:
    PostAnimateConfigureSlide
}

proc PostAnimateUpdateWidgetsWithResultState { } {
    # selects whether single step animation or all step animation
    PostAnimateSelectSingleOrAllStepAnimation
    if { [ info exists ::GidPriv(PostAnimateSlide)] } {
        PostAnimateConfigureSlide
    }
}

proc PostAnimateGetValidFrame { frame} {
    global GidPriv
    # corrige el maximo por si acaso
    PostAnimateCheckRangeFrame 0
    set from_f [expr $::GidPriv(PostAnimateRangeFrameFrom)-1]
    if { $frame < $from_f} {
        set frame $from_f
    }
    return $frame
}

proc PostAnimateGetValidDelayTime {} {
    set delay $::GidPriv(PostAnimateDelayTime)
    set color black
    set err_delay [ catch { set pp [ expr $delay + 1]} err_delay_txt]
    if { $err_delay} {
        append error_line [_ "Invalid delay time %s" $delay]. " " $err_delay_txt " " \
            [_ "Using default value"] " $::GidPriv(PostAnimateMinimumDelayTime)"
        GidUtils::SetWarnLine $error_line
        set delay $::GidPriv(PostAnimateMinimumDelayTime)
        set color red
    }
    if { ( $delay == "") || ( $delay <= 0)} {
        set delay $::GidPriv(PostAnimateMinimumDelayTime)
        set color red
    }
    # if { $delay != [expr int($delay)]} {
    #     # Delay time is an integer, representing miliseconds for the after xxx xxx command
    #     set delay [expr int($delay)]
    #     set color red
    # }
    if { [ info exists ::GidPriv(PostAnimateDelayTimeEntry)] && \
             [ winfo exists $::GidPriv(PostAnimateDelayTimeEntry)]} {
        $::GidPriv(PostAnimateDelayTimeEntry) configure -foreground $color
    }
    if { [ info exists ::GidPriv(PostAnimateFPSEntryWidget)] && \
             [ winfo exists $::GidPriv(PostAnimateFPSEntryWidget)]} {
        $::GidPriv(PostAnimateFPSEntryWidget) configure -foreground $color
    }
    return [expr int($delay)]
}

proc PostAnimateGetFilenameAutomatic { format save_prefix frame } {
    set next_frame [expr $frame+1]
    set filename ""
    if { $format == "PNG"} {
        set filename [format %s-%02d.png $save_prefix $next_frame]
    } elseif { $format == "GIF"} {
        set filename [format %s-%02d.gif $save_prefix $next_frame]
    } elseif { $format == "TIFF"} {
        set filename [format %s-%02d.tif $save_prefix $next_frame]
    } elseif { $format == "JPEG"} {
        set filename [format %s-%02d.jpg $save_prefix $next_frame]
    } elseif { $format == "PLY"} {
        set filename [format %s-%02d.ply $save_prefix $next_frame]
    } elseif { $format == "STL"} {
        set filename [format %s-%02d.stl $save_prefix $next_frame]
    } elseif { $format == "OBJ"} {
        set filename [format %s-%02d.obj $save_prefix $next_frame]
    } else {
        set filename [format %s-%02d.png $save_prefix $next_frame]
    }
    return $filename
}

namespace eval MovementRotation {
    variable _init              0
    variable _num_frames        1
    variable _num_loops         1
    variable _angle_increment   1
    variable _type              "ObjAxes"   ; # ObjAxes ScrAxes
    variable _axis              z           ; # selected axis used to rotate
    variable _original_view     ""

    # used in settings windows
    variable _w_num_loops
    variable _w_type
    variable _w_axis

    proc Init { num_frames initial_view} {
        variable _angle_increment
        variable _num_frames
        variable _num_loops
        variable _init
        variable _original_view

        set _angle_increment  1
        if { $num_frames != 0} {
            set _angle_increment [ expr double( $_num_loops) * 360.0 / double( $num_frames)]
        }
        set _num_frames $num_frames
        set _init 1
        set _original_view $initial_view
    }
    proc setType { strType} {
        variable _type
        if { [ lsearch [ list objaxes scraxes] [ string tolower $strType] ] != -1} {
            set _type $strType
        }
    }
    proc setAxis { xyz} {
        variable _axis
        if { [ lsearch [ list x y z] [ string tolower $xyz]] != -1} {
            set _axis $xyz
        }
    }
    proc setNumLoops { num_loops} {
        variable _num_loops
        if { $num_loops != 0} {
            set _num_loops $num_loops
        }
    }

    proc acceptParameters { w } {
        variable _w_num_loops
        variable _w_type
        variable _w_axis

        setType $_w_type
        setAxis $_w_axis
        setNumLoops $_w_num_loops
        destroy $w
    }

    proc setDefaultParameters { } {
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        
        set _w_num_loops         1
        set _w_type              "ObjAxes"   ; # ObjAxes ScrAxes
        set _w_axis              z           ; # selected axis used to rotate
    }

    proc setParametersWindow { parent} {
        variable _num_loops
        variable _type
        variable _axis
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        
        # using same name for all simple model animation parametes windows
        set w ${parent}.simpleAnimationParameters
        if { "$parent" == "." } {
            set w .simpleAnimationParameters
        }

        if { [ winfo exists $w] } {
            destroy $w
        }

        toplevel $w
        wm title $w [_ "Rotation settings"]
        if { [ winfo exists $parent]} {
            set rootx [ winfo rootx $parent]
            set rooty [ winfo rooty $parent]
            set width [ winfo width $parent]
            set height [ winfo height $parent]
            wm geometry $w +[ expr int( $rootx + $width * 0.5)]+[ expr int( $rooty + $height * 0.5)]
        }
        CreateApplyDefaultsCloseDecorationWindow $w $w.top $w.bot \
            [ list MovementRotation::acceptParameters $w] \
            MovementRotation::setDefaultParameters [ list destroy $w]

        ttk::label $w.top.loops_l -text [_ "Number of loops:"]
        ttk::spinbox $w.top.loops_sb -width 5 \
            -values [ list -10 -9 -8 -7 -6 -5 -4 -3 -2 -1 1 2 3 4 5 6 7 8 9 10] \
            -textvariable MovementRotation::_w_num_loops

        ttk::label $w.top.type_l -text [_ "Rotation type:"]
        TTKComboBox $w.top.type_cb -width 15 \
            -labels [list [_ "Screen axes"] [_ "Object axes"]] -values [ list ScrAxes ObjAxes] \
            -textvariable MovementRotation::_w_type
            
        ttk::label $w.top.axis_l -text [_ "Axis:"]
        ttk::combobox $w.top.axis_cb -width 4 \
            -values [ list x y z] -textvariable MovementRotation::_w_axis
        
        grid $w.top.loops_l $w.top.loops_sb -padx 2 -pady 1 -sticky w
        grid configure $w.top.loops_sb -sticky ew

        grid $w.top.type_l $w.top.type_cb -padx 2 -pady 1 -sticky w
        grid configure $w.top.type_cb -sticky ew

        grid $w.top.axis_l $w.top.axis_cb -padx 2 -pady 1 -sticky w
        grid configure $w.top.axis_cb -sticky ew
        
        grid columnconfigure $w.top 0 -weight 1
        grid columnconfigure $w.top 1 -weight 1
        grid rowconfigure  $w.top [ list 0 1 2 ] -weight 1

        set _w_num_loops $_num_loops
        set _w_type $_type
        set _w_axis $_axis

    }

    proc getIncrement { idx_frame} {
        variable _type
        variable _axis
        variable _angle_increment
        variable _original_view

        if { $idx_frame == 0} {
            return [ list GiD_Process Mescape view SetView $_original_view escape escape escape escape ]
        } else {
            return [ list GiD_Process rotate $_type $_axis $_angle_increment escape escape escape escape ]
        }
    }
}

proc GetGiDView {} {
    set full_data_view [ GiD_Info view]

    # we only want zoom, rotation, etc.... not modes (render mode, drawing type, etc...)
    set tmp {}
    set items_to_skip [ list nowuse drawingtype]
    foreach item $full_data_view {
        set key [ string tolower [ lindex $item 0]]
        if { [ lsearch $items_to_skip $key] == -1} {
            lappend tmp $item
        }
    }
    return $tmp
}

# two halves: first half zoom-in, second half rotation
namespace eval MovementZoomInRotation {
    variable _init              0
    variable _num_frames        1
    variable _num_loops         1
    variable _angle_increment   1
    variable _type              "ObjAxes"   ; # ObjAxes ScrAxes
    variable _axis              z           ; # selected axis used to rotate
    variable _idx_frame_change_to_rotation 1
    variable _original_view     ""
    variable _initial_view      ""
    variable _current_view      ""
    variable _left_right_increment  0.0
    variable _bottom_top_increment  0.0
    variable _zoom_out_factor       3.0
    variable _zoom_rotation_relation    0.3 ; # of total of 1.0, which part is zoom and the rest will be rotation

    # used in settings windows
    variable _w_num_loops
    variable _w_type
    variable _w_axis
    variable _w_zoom_out_factor
    variable _w_zoom_rotation_relation

    proc CalculateZoomInParameters { num_frames } {
        variable _original_view
        variable _initial_view
        variable _idx_frame_change_to_rotation
        variable _left_right_increment
        variable _bottom_top_increment
        variable _zoom_out_factor

        set num_frames [ expr $num_frames - 1]
        if { $num_frames < 1} {
            set num_frames 1
        }
        # if current view is DX x DY then
        # zoom_out view is zoom_out_factor * DX x zoom_out_factor * DX
        # set zoom_out_factor 3.0
        set _initial_view [ list]
        for { set i 0} { $i < [ llength $_original_view]} { incr i} {
            set oldcomp [ lindex $_original_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set left [ lindex $oldcomp 1]
                set right [ lindex $oldcomp 2]
                set dx [ expr $right - $left]
                set center_x [ expr 0.5 * ( $right + $left)]
                set new_dx [ expr $_zoom_out_factor * $dx]
                set new_left [ expr $center_x - 0.5 * $new_dx]
                set new_right [ expr $center_x + 0.5 * $new_dx]
                # _left_right_increment will be added to left and right at each frame
                set _left_right_increment [ expr 0.5 * ( $new_dx - $dx) / double( $num_frames)]

                set oldcomp [ list x $new_left $new_right]
            } elseif { "$key" == "y"} {
                set bottom [ lindex $oldcomp 1]
                set top [ lindex $oldcomp 2]
                set dy [ expr $top - $bottom]
                set center_y [ expr 0.5 * ( $top + $bottom)]
                set new_dy [ expr $_zoom_out_factor * $dy]
                set new_bottom [ expr $center_y - 0.5 * $new_dy]
                set new_top [ expr $center_y + 0.5 * $new_dy]
                # _bottom_top_increment will be added to bottom and top at each frame
                set _bottom_top_increment [ expr 0.5 * ( $new_dy - $dy) / double( $num_frames)]

                set old_comp [ list y $new_bottom $new_top]
            }
            lappend _initial_view $oldcomp
        }
    }

    proc IncreaseZoomStepInCurrentView { } {
        variable _current_view
        variable _left_right_increment
        variable _bottom_top_increment

        set new_view [ list]
        for { set i 0} { $i < [ llength $_current_view]} { incr i} {
            set oldcomp [ lindex $_current_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set left [ lindex $oldcomp 1]
                set right [ lindex $oldcomp 2]
                set new_left [ expr $left + $_left_right_increment]
                set new_right [ expr $right - $_left_right_increment]

                set oldcomp [ list x $new_left $new_right]
            } elseif { "$key" == "y"} {
                set bottom [ lindex $oldcomp 1]
                set top [ lindex $oldcomp 2]
                set new_bottom [ expr $bottom + $_bottom_top_increment]
                set new_top [ expr $bottom - $_bottom_top_increment]

                set old_comp [ list y $new_bottom $new_top]
            }
            lappend new_view $oldcomp
        }

        set _current_view $new_view
    }

    proc Init { num_frames initial_view} {
        variable _angle_increment
        variable _num_frames
        variable _num_loops
        variable _init
        variable _original_view
        variable _idx_frame_change_to_rotation
        variable _zoom_rotation_relation

        set _angle_increment  1
        set _idx_frame_change_to_rotation [ expr int( 0.5 + $num_frames * $_zoom_rotation_relation)]
        set num_frames_rotation [ expr $num_frames - $_idx_frame_change_to_rotation]
        if { $num_frames_rotation != 0} {
            set _angle_increment [ expr double( $_num_loops) * 360.0 / double( $num_frames_rotation)]
        }
        set _num_frames $num_frames
        set _init 1
        set _original_view [ GetGiDView]
        CalculateZoomInParameters [ expr $num_frames - $num_frames_rotation]
    }
    proc setType { strType} {
        variable _type
        if { [ lsearch [ list objaxes scraxes] [ string tolower $strType] ] != -1} {
            set _type $strType
        }
    }
    proc setAxis { xyz} {
        variable _axis
        if { [ lsearch [ list x y z] [ string tolower $xyz]] != -1} {
            set _axis $xyz
        }
    }
    proc setNumLoops { num_loops} {
        variable _num_loops
        if { $num_loops != 0} {
            set _num_loops $num_loops
        }
    }

    proc setZoomOutFactor { zoom_out} {
        variable _zoom_out_factor
        if { $zoom_out != 0.0} {
            set _zoom_out_factor $zoom_out
        }
    }

    proc setZoomRotationRelation { zoom_rotation} {
        variable _zoom_rotation_relation
        if { ( $zoom_rotation >= 0.1) && ( $zoom_rotation <= 0.9)} {
            set _zoom_rotation_relation $zoom_rotation
        }
    }

    proc acceptParameters { w } {
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        variable _w_zoom_out_factor
        variable _w_zoom_rotation_relation

        setType $_w_type
        setAxis $_w_axis
        setNumLoops $_w_num_loops
        setZoomOutFactor $_w_zoom_out_factor
        setZoomRotationRelation $_w_zoom_rotation_relation
        destroy $w
    }

    proc setDefaultParameters { } {
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        variable _w_zoom_out_factor
        variable _w_zoom_rotation_relation

        set _w_num_loops         1
        set _w_type              "ObjAxes"   ; # ObjAxes ScrAxes
        set _w_axis              z           ; # selected axis used to rotate
        set _w_zoom_out_factor       3.0
        set _w_zoom_rotation_relation    0.3 ; # of total of 1.0, which part is zoom and the rest will be rotation
    }

    proc setParametersWindow { parent} {
        variable _num_loops
        variable _type
        variable _axis
        variable _zoom_out_factor
        variable _zoom_rotation_relation
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        variable _w_zoom_out_factor
        variable _w_zoom_rotation_relation
        
        # using same name for all simple model animation parametes windows
        set w ${parent}.simpleAnimationParameters
        if { "$parent" == "." } {
            set w .simpleAnimationParameters
        }

        if { [ winfo exists $w] } {
            destroy $w
        }

        toplevel $w
        wm title $w [_ "Zoom in & rotation settings"]
        if { [ winfo exists $parent]} {
            set rootx [ winfo rootx $parent]
            set rooty [ winfo rooty $parent]
            set width [ winfo width $parent]
            set height [ winfo height $parent]
            wm geometry $w +[ expr int( $rootx + $width * 0.5)]+[ expr int( $rooty + $height * 0.5)]
        }
        CreateApplyDefaultsCloseDecorationWindow $w $w.top $w.bot \
            [ list MovementZoomInRotation::acceptParameters $w] \
            MovementZoomInRotation::setDefaultParameters [ list destroy $w]

        ttk::label $w.top.zoom_fact_l -text [_ "Zoom out factor:"]
        # need label to show the value as the value shown with scale is somewhat ugly
        ttk::label $w.top.zoom_fact_l2 -textvariable MovementZoomInRotation::_w_zoom_out_factor
        gidscale $w.top.zoom_fact_sc -from 0.5 -to 10.0 \
            -orient horizontal -resolution 0.1 \
            -showvalue 0 -showbuttons 0 \
            -variable MovementZoomInRotation::_w_zoom_out_factor

        # ttk::label $w.top.zoom_rel_l -text [_ "Relation between zoom and rotation part (0.0-1.0):"]
        ttk::label $w.top.zoom_rel_l -text [_ "Zoom - rotation relation:"]
        # need label to show the value as the value shown with scale is somewhat ugly
        ttk::label $w.top.zoom_rel_l2 -textvariable MovementZoomInRotation::_w_zoom_rotation_relation
        gidscale $w.top.zoom_rel_sc -from 0.1 -to 0.9 \
            -orient horizontal -resolution 0.01 \
            -showvalue 0 -showbuttons 0 \
            -variable MovementZoomInRotation::_w_zoom_rotation_relation

        ttk::label $w.top.loops_l -text [_ "Number of loops:"]
        ttk::spinbox $w.top.loops_sb -width 5 \
            -values [ list -10 -9 -8 -7 -6 -5 -4 -3 -2 -1 1 2 3 4 5 6 7 8 9 10] \
            -textvariable MovementZoomInRotation::_w_num_loops

        ttk::label $w.top.type_l -text [_ "Rotation type:"]
        TTKComboBox $w.top.type_cb -width 15 \
            -labels [list [_ "Screen axes"] [_ "Object axes"]] -values [ list ScrAxes ObjAxes] \
            -textvariable MovementZoomInRotation::_w_type
            
        ttk::label $w.top.axis_l -text [_ "Axis:"]
        ttk::combobox $w.top.axis_cb -width 4 \
            -values [ list x y z] -textvariable MovementZoomInRotation::_w_axis

        grid $w.top.zoom_fact_l $w.top.zoom_fact_l2 -padx 2 -pady 1 -sticky w
        grid $w.top.zoom_fact_sc -padx 2 -pady 1 -sticky we
        grid configure $w.top.zoom_fact_sc -columnspan 2

        grid $w.top.zoom_rel_l $w.top.zoom_rel_l2 -padx 2 -pady 1 -sticky w
        grid $w.top.zoom_rel_sc -padx 2 -pady 1 -sticky we
        grid configure $w.top.zoom_rel_sc -columnspan 2

        grid $w.top.loops_l $w.top.loops_sb -padx 2 -pady 1 -sticky w
        grid configure $w.top.loops_sb -sticky ew

        grid $w.top.type_l $w.top.type_cb -padx 2 -pady 1 -sticky w
        grid configure $w.top.type_cb -sticky ew

        grid $w.top.axis_l $w.top.axis_cb -padx 2 -pady 1 -sticky w
        grid configure $w.top.axis_cb -sticky ew
        
        grid columnconfigure $w.top 0 -weight 1
        grid columnconfigure $w.top 1 -weight 1
        grid rowconfigure  $w.top [ list 0 1 2 3 4 5] -weight 1

        set _w_num_loops $_num_loops
        set _w_type $_type
        set _w_axis $_axis
        set _w_zoom_out_factor $_zoom_out_factor
        set _w_zoom_rotation_relation $_zoom_rotation_relation
    }

    proc getIncrement { idx_frame} {
        variable _type
        variable _axis
        variable _angle_increment
        variable _idx_frame_change_to_rotation
        variable _original_view
        variable _initial_view
        variable _current_view
        variable _left_right_increment
        variable _bottom_top_increment

        if { $idx_frame == 0} {
            set _current_view $_initial_view
            return [ list GiD_Process Mescape view SetView $_current_view escape escape escape escape ]
        } elseif { $idx_frame < $_idx_frame_change_to_rotation} {
            # add increment to current_view
            IncreaseZoomStepInCurrentView
            return [ list GiD_Process Mescape view SetView $_current_view escape escape escape escape ]
        } else { ;# $idx_frame >= $_idx_frame_change_to_rotation
            return [ list GiD_Process rotate $_type $_axis $_angle_increment escape escape escape escape ]
        }
    }
}

# Zoom-in-stay-zoom-out & rotate
namespace eval MovementZoomInZoomOutWhileRotate {
    variable _init              0
    variable _num_frames        1
    variable _num_loops         1
    variable _angle_increment   1
    variable _type              "ObjAxes"   ; # ObjAxes ScrAxes
    variable _axis              z           ; # selected axis used to rotate
    variable _idx_frame_change_to_stay     1
    variable _idx_frame_change_to_zoom_out 1
    variable _original_view     ""
    variable _initial_view      ""
    variable _current_view      ""
    variable _left_right_increment  0.0
    variable _bottom_top_increment  0.0
    variable _zoom_out_factor       3.0
    variable _zoom_in_stay_relation    0.3 ; # of total of 1.0, which part is zoom and the rest will be rotation
    variable _stay_zoom_out_relation   0.7 ; # of total of 1.0, which part is zoom and the rest will be rotation

    # used in settings windows
    variable _w_num_loops
    variable _w_type
    variable _w_axis
    variable _w_zoom_out_factor
    variable _w_zoom_in_stay_relation
    variable _w_stay_zoom_out_relation

    proc CalculateZoomInParameters { num_frames } {
        variable _original_view
        variable _initial_view
        variable _left_right_increment_zoom_in
        variable _bottom_top_increment_zoom_in
        variable _zoom_out_factor

        set num_frames [ expr $num_frames - 1]
        if { $num_frames < 1} {
            set num_frames 1
        }
        # if current view is DX x DY then
        # zoom_out view is zoom_out_factor * DX x zoom_out_factor * DX
        # set zoom_out_factor 3.0
        set _initial_view [ list]
        for { set i 0} { $i < [ llength $_original_view]} { incr i} {
            set oldcomp [ lindex $_original_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set left [ lindex $oldcomp 1]
                set right [ lindex $oldcomp 2]
                set dx [ expr $right - $left]
                set center_x [ expr 0.5 * ( $right + $left)]
                set new_dx [ expr $_zoom_out_factor * $dx]
                set new_left [ expr $center_x - 0.5 * $new_dx]
                set new_right [ expr $center_x + 0.5 * $new_dx]
                # _left_right_increment_zoom_in will be added to left and right at each frame
                set _left_right_increment_zoom_in [ expr 0.5 * ( $new_dx - $dx) / double( $num_frames)]

                set oldcomp [ list x $new_left $new_right]
                lappend _initial_view $oldcomp
            } elseif { "$key" == "y"} {
                set bottom [ lindex $oldcomp 1]
                set top [ lindex $oldcomp 2]
                set dy [ expr $top - $bottom]
                set center_y [ expr 0.5 * ( $top + $bottom)]
                set new_dy [ expr $_zoom_out_factor * $dy]
                set new_bottom [ expr $center_y - 0.5 * $new_dy]
                set new_top [ expr $center_y + 0.5 * $new_dy]
                # _bottom_top_increment_zoom_in will be added to bottom and top at each frame
                set _bottom_top_increment_zoom_in [ expr 0.5 * ( $new_dy - $dy) / double( $num_frames)]

                set old_comp [ list y $new_bottom $new_top]
                lappend _initial_view $oldcomp
            }
        }
    }

    proc CalculateZoomOutParameters { num_frames } {
        variable _original_view
        variable _left_right_increment_zoom_out
        variable _bottom_top_increment_zoom_out
        variable _zoom_out_factor

        set num_frames [ expr $num_frames - 1]
        if { $num_frames < 1} {
            set num_frames 1
        }
        # if current view is DX x DY then
        # zoom_out view is zoom_out_factor * DX x zoom_out_factor * DX
        # set zoom_out_factor 3.0
        for { set i 0} { $i < [ llength $_original_view]} { incr i} {
            set oldcomp [ lindex $_original_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set left [ lindex $oldcomp 1]
                set right [ lindex $oldcomp 2]
                set dx [ expr $right - $left]
                set center_x [ expr 0.5 * ( $right + $left)]
                set new_dx [ expr $_zoom_out_factor * $dx]
                set new_left [ expr $center_x - 0.5 * $new_dx]
                set new_right [ expr $center_x + 0.5 * $new_dx]
                # _left_right_increment_zoom_out will be added to left and right at each frame
                set _left_right_increment_zoom_out -[ expr 0.5 * ( $new_dx - $dx) / double( $num_frames)]

                set oldcomp [ list x $new_left $new_right]
            } elseif { "$key" == "y"} {
                set bottom [ lindex $oldcomp 1]
                set top [ lindex $oldcomp 2]
                set dy [ expr $top - $bottom]
                set center_y [ expr 0.5 * ( $top + $bottom)]
                set new_dy [ expr $_zoom_out_factor * $dy]
                set new_bottom [ expr $center_y - 0.5 * $new_dy]
                set new_top [ expr $center_y + 0.5 * $new_dy]
                # _bottom_top_increment_zoom_out will be added to bottom and top at each frame
                set _bottom_top_increment_zoom_out -[ expr 0.5 * ( $new_dy - $dy) / double( $num_frames)]

                set old_comp [ list y $new_bottom $new_top]
            }
        }
    }

    proc IncreaseZoomStepInCurrentView { } {
        variable _current_view
        variable _left_right_increment_zoom_in
        variable _bottom_top_increment_zoom_in

        set new_view [ list]
        for { set i 0} { $i < [ llength $_current_view]} { incr i} {
            set oldcomp [ lindex $_current_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set left [ lindex $oldcomp 1]
                set right [ lindex $oldcomp 2]
                set new_left [ expr $left + $_left_right_increment_zoom_in]
                set new_right [ expr $right - $_left_right_increment_zoom_in]

                set oldcomp [ list x $new_left $new_right]
            } elseif { "$key" == "y"} {
                set bottom [ lindex $oldcomp 1]
                set top [ lindex $oldcomp 2]
                set new_bottom [ expr $bottom + $_bottom_top_increment_zoom_in]
                set new_top [ expr $bottom - $_bottom_top_increment_zoom_in]

                set old_comp [ list y $new_bottom $new_top]
            }
            lappend new_view $oldcomp
        }

        set _current_view $new_view
    }

    proc IncreaseZoomStepOutCurrentView { } {
        variable _current_view
        variable _left_right_increment_zoom_out
        variable _bottom_top_increment_zoom_out

        set new_view [ list]
        for { set i 0} { $i < [ llength $_current_view]} { incr i} {
            set oldcomp [ lindex $_current_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set left [ lindex $oldcomp 1]
                set right [ lindex $oldcomp 2]
                set new_left [ expr $left + $_left_right_increment_zoom_out]
                set new_right [ expr $right - $_left_right_increment_zoom_out]

                set oldcomp [ list x $new_left $new_right]
            } elseif { "$key" == "y"} {
                set bottom [ lindex $oldcomp 1]
                set top [ lindex $oldcomp 2]
                set new_bottom [ expr $bottom + $_bottom_top_increment_zoom_out]
                set new_top [ expr $bottom - $_bottom_top_increment_zoom_out]

                set old_comp [ list y $new_bottom $new_top]
            }
            lappend new_view $oldcomp
        }

        set _current_view $new_view
    }

    proc Init { num_frames initial_view} {
        variable _angle_increment
        variable _num_frames
        variable _num_loops
        variable _init
        variable _original_view
        variable _idx_frame_change_to_stay
        variable _idx_frame_change_to_zoom_out
        variable _zoom_in_stay_relation
        variable _stay_zoom_out_relation

        set _angle_increment  1
        set _idx_frame_change_to_stay [ expr int( 0.5 + $num_frames * $_zoom_in_stay_relation)]
        set _idx_frame_change_to_zoom_out [ expr int( 0.5 + $num_frames * $_stay_zoom_out_relation)]
        # rotation will be done along all the animation
        set num_frames_rotation $num_frames
        if { $num_frames_rotation != 0} {
            set _angle_increment [ expr double( $_num_loops) * 360.0 / double( $num_frames_rotation)]
        }
        set _num_frames $num_frames
        set _init 1
        set _original_view $initial_view

        set num_frames_zoom_in $_idx_frame_change_to_stay
        set num_frames_stay [ expr $_idx_frame_change_to_zoom_out - $_idx_frame_change_to_stay]
        set num_frames_zoom_out [ expr $num_frames - $num_frames_stay - $num_frames_zoom_in]
        CalculateZoomInParameters $num_frames_zoom_in
        CalculateZoomOutParameters $num_frames_zoom_out
    }
    proc setType { strType} {
        variable _type
        if { [ lsearch [ list objaxes scraxes] [ string tolower $strType] ] != -1} {
            set _type $strType
        }
    }
    proc setAxis { xyz} {
        variable _axis
        if { [ lsearch [ list x y z] [ string tolower $xyz]] != -1} {
            set _axis $xyz
        }
    }
    proc setNumLoops { num_loops} {
        variable _num_loops
        if { $num_loops != 0} {
            set _num_loops $num_loops
        }
    }

    proc setZoomOutFactor { zoom_out} {
        variable _zoom_out_factor
        if { $zoom_out != 0.0} {
            set _zoom_out_factor $zoom_out
        }
    }

    proc setZoomInStayRelation { zoom_rotation} {
        variable _zoom_in_stay_relation
        if { ( $zoom_rotation >= 0.1) && ( $zoom_rotation <= 0.5)} {
            set _zoom_in_stay_relation $zoom_rotation
        }
    }

    proc setStayZoomOutRelation { zoom_rotation} {
        variable _stay_zoom_out_relation
        if { ( $zoom_rotation >= 0.5) && ( $zoom_rotation <= 0.9)} {
            set _stay_zoom_out_relation $zoom_rotation
        }
    }


    proc acceptParameters { w } {
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        variable _w_zoom_out_factor
        variable _w_zoom_in_stay_relation
        variable _w_stay_zoom_out_relation

        setType $_w_type
        setAxis $_w_axis
        setNumLoops $_w_num_loops
        setZoomOutFactor $_w_zoom_out_factor
        setZoomInStayRelation $_w_zoom_in_stay_relation
        setStayZoomOutRelation $_w_stay_zoom_out_relation
        destroy $w
    }

    proc setDefaultParameters { } {
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        variable _w_zoom_out_factor
        variable _w_zoom_in_stay_relation
        variable _w_stay_zoom_out_relation

        set _w_num_loops         1
        set _w_type              "ObjAxes"   ; # ObjAxes ScrAxes
        set _w_axis              z           ; # selected axis used to rotate
        set _w_zoom_out_factor       3.0
        set _w_zoom_in_stay_relation    0.3 ; # of total of 1.0, which part is zoom and the rest will be rotation
        set _w_stay_zoom_out_relation   0.7 ; # of total of 1.0, which part is zoom and the rest will be rotation
    }

    proc setParametersWindow { parent} {
        variable _num_loops
        variable _type
        variable _axis
        variable _zoom_out_factor
        variable _zoom_in_stay_relation
        variable _stay_zoom_out_relation
        variable _w_num_loops
        variable _w_type
        variable _w_axis
        variable _w_zoom_out_factor
        variable _w_zoom_in_stay_relation
        variable _w_stay_zoom_out_relation
        
        # using same name for all simple model animation parametes windows
        set w ${parent}.simpleAnimationParameters
        if { "$parent" == "." } {
            set w .simpleAnimationParameters
        }

        if { [ winfo exists $w] } {
            destroy $w
        }

        toplevel $w
        wm title $w [_ "Zoom in & rotation settings"]
        if { [ winfo exists $parent]} {
            set rootx [ winfo rootx $parent]
            set rooty [ winfo rooty $parent]
            set width [ winfo width $parent]
            set height [ winfo height $parent]
            wm geometry $w +[ expr int( $rootx + $width * 0.5)]+[ expr int( $rooty + $height * 0.5)]
        }
        CreateApplyDefaultsCloseDecorationWindow $w $w.top $w.bot \
            [ list MovementZoomInZoomOutWhileRotate::acceptParameters $w] \
            MovementZoomInZoomOutWhileRotate::setDefaultParameters [ list destroy $w]

        ttk::label $w.top.zoom_fact_l -text [_ "Zoom out factor:"]
        # need label to show the value as the value shown with scale is somewhat ugly
        ttk::label $w.top.zoom_fact_l2 -textvariable MovementZoomInZoomOutWhileRotate::_w_zoom_out_factor
        gidscale $w.top.zoom_fact_sc -from 0.5 -to 10.0 \
            -orient horizontal -resolution 0.1 \
            -showvalue 0 -showbuttons 0 \
            -variable MovementZoomInZoomOutWhileRotate::_w_zoom_out_factor

        ttk::label $w.top.zoom_rel_l -text [_ "Zoom in - stay - zoom out relation:"]
        # need label to show the value as the value shown with scale is somewhat ugly
        ttk::label $w.top.zoom_rel_l2 -textvariable MovementZoomInZoomOutWhileRotate::_w_zoom_in_stay_relation
        ttk::label $w.top.zoom_rel_l3 -textvariable MovementZoomInZoomOutWhileRotate::_w_stay_zoom_out_relation
        gidscale $w.top.zoom_rel_sc1 -from 0.1 -to 0.5 \
            -orient horizontal -resolution 0.01 \
            -showvalue 0 -showbuttons 0 \
            -variable MovementZoomInZoomOutWhileRotate::_w_zoom_in_stay_relation
        gidscale $w.top.zoom_rel_sc2 -from 0.5 -to 0.9 \
            -orient horizontal -resolution 0.01 \
            -showvalue 0 -showbuttons 0 \
            -variable MovementZoomInZoomOutWhileRotate::_w_stay_zoom_out_relation

        ttk::label $w.top.loops_l -text [_ "Number of loops:"]
        ttk::spinbox $w.top.loops_sb -width 5 \
            -values [ list -10 -9 -8 -7 -6 -5 -4 -3 -2 -1 1 2 3 4 5 6 7 8 9 10] \
            -textvariable MovementZoomInZoomOutWhileRotate::_w_num_loops

        ttk::label $w.top.type_l -text [_ "Rotation type:"]
        TTKComboBox $w.top.type_cb -width 15 \
            -labels [list [_ "Screen axes"] [_ "Object axes"]] -values [ list ScrAxes ObjAxes] \
            -textvariable MovementZoomInZoomOutWhileRotate::_w_type
            
        ttk::label $w.top.axis_l -text [_ "Axis:"]
        ttk::combobox $w.top.axis_cb -width 4 \
            -values [ list x y z] -textvariable MovementZoomInZoomOutWhileRotate::_w_axis

        grid $w.top.zoom_fact_l $w.top.zoom_fact_l2 -padx 2 -pady 1 -sticky w
        grid $w.top.zoom_fact_sc -padx 2 -pady 1 -sticky we
        grid configure $w.top.zoom_fact_sc -columnspan 2

        grid $w.top.zoom_rel_l -padx 2 -pady 1 -sticky w
        grid $w.top.zoom_rel_l2 $w.top.zoom_rel_l3 -padx 2 -pady 1 -sticky w
        grid $w.top.zoom_rel_sc1 $w.top.zoom_rel_sc2 -padx 2 -pady 1 -sticky we
        grid configure $w.top.zoom_rel_l -columnspan 2

        grid $w.top.loops_l $w.top.loops_sb -padx 2 -pady 1 -sticky w
        grid configure $w.top.loops_sb -sticky ew

        grid $w.top.type_l $w.top.type_cb -padx 2 -pady 1 -sticky w
        grid configure $w.top.type_cb -sticky ew

        grid $w.top.axis_l $w.top.axis_cb -padx 2 -pady 1 -sticky w
        grid configure $w.top.axis_cb -sticky ew
        
        grid columnconfigure $w.top 0 -weight 1
        grid columnconfigure $w.top 1 -weight 1
        grid rowconfigure  $w.top [ list 0 1 2 3 4 5] -weight 1

        set _w_num_loops $_num_loops
        set _w_type $_type
        set _w_axis $_axis
        set _w_zoom_out_factor $_zoom_out_factor
        set _w_zoom_in_stay_relation $_zoom_in_stay_relation
    }

    proc getIncrement { idx_frame} {
        variable _type
        variable _axis
        variable _angle_increment
        variable _idx_frame_change_to_stay
        variable _idx_frame_change_to_zoom_out
        variable _original_view
        variable _initial_view
        variable _current_view

        if { $idx_frame == 0} {
            set _current_view $_initial_view
            return [ list GiD_Process Mescape view SetViewParameter $_current_view escape escape escape escape ]
        } elseif { $idx_frame < $_idx_frame_change_to_stay} {
            # add increment to current_view
            IncreaseZoomStepInCurrentView
            set lst_cmd [ list]
            lappend lst_cmd GiD_Process Mescape view SetViewParameter $_current_view escape escape escape escape \;
            lappend lst_cmd GiD_Process rotate $_type $_axis $_angle_increment escape escape escape escape
            return $lst_cmd
            # return [ list GiD_Process Mescape view SetView [ list $_current_view] escape escape escape escape]
        } elseif { $idx_frame < $_idx_frame_change_to_zoom_out} {
            return [ list GiD_Process rotate $_type $_axis $_angle_increment escape escape escape escape ]
        } else { ;# $idx_frame >= $_idx_frame_change_to_stay
            # add increment to current_view
            IncreaseZoomStepOutCurrentView
            lappend lst_cmd GiD_Process Mescape view SetViewParameter $_current_view escape escape escape escape \;
            lappend lst_cmd GiD_Process rotate $_type $_axis $_angle_increment escape escape escape escape
            return $lst_cmd
        }
    }
}

namespace eval ModelSimpleAnimations {
    variable _enabled        0
    variable _selected       MovementRotation
    variable _initial_view   ""
    variable _lst_w_options  [ list ]
    variable _w_frame        ""
}

proc ModelSimpleAnimations::EnableDisableOptions { } {
    variable _enabled
    variable _initial_view
    variable _lst_w_options

    set state normal
    set color black
    if { !$_enabled} {
        set state disabled
        set color grey
    } else {
        # if not defined set initial view
        if { "$_initial_view" == ""} {
            SetInitialView
        }
    }
    foreach w $_lst_w_options {
        if { [ winfo exists $w] } {
            $w configure -state $state
        }
    }
    if { $state == "normal"} {
        ModelSimpleAnimations::EnableDisableConfigurationButtons
    }
}

proc ModelSimpleAnimations::SetInitialView { } {
    variable _initial_view
    set _initial_view [ GetGiDView]
}

proc ModelSimpleAnimations::EnableDisableConfigurationButtons { } {
    variable _selected
    variable _w_frame
    set f $_w_frame
    if { ![ winfo exists $f]} {
        return
    }
    switch $_selected {
        "MovementRotation" {
            $f.rd1_conf configure -state active
            $f.rd2_conf configure -state disabled
            $f.rd3_conf configure -state disabled
        }
        "MovementZoomInRotation" {
            $f.rd1_conf configure -state disabled
            $f.rd2_conf configure -state active
            $f.rd3_conf configure -state disabled
        }
        "MovementZoomInZoomOutWhileRotate" {
            $f.rd1_conf configure -state disabled
            $f.rd2_conf configure -state disabled
            $f.rd3_conf configure -state active
        }
    }

    set parent [ winfo parent $_w_frame]
    # using same name for all simple model animation parametes windows
    set w ${parent}.simpleAnimationParameters
    if { [ winfo exists $w]} {
        destroy $w
    }
}


proc ModelSimpleAnimations::Disable { } {
    variable _enabled
    set _enabled 0
    ModelSimpleAnimations::EnableDisableOptions
}

proc ModelSimpleAnimations::Create { parent} {
    variable _enabled
    variable _selected
    variable _lst_w_options
    variable _w_frame

    set w $parent
    set f [ ttk::frame $w.f_mov -borderwidth 0]
    set _w_frame $f
    ttk::checkbutton $f.cb -text [_ "Simple model animation:"] \
        -variable ModelSimpleAnimations::_enabled \
        -command ModelSimpleAnimations::EnableDisableOptions

    ttk::button $f.fix_view_b -text [_ "Fix initial view"] \
        -command ModelSimpleAnimations::SetInitialView

    ttk::radiobutton $f.rd1 -text [_ "Rotate"] \
        -variable ModelSimpleAnimations::_selected \
        -value MovementRotation \
        -command ModelSimpleAnimations::EnableDisableConfigurationButtons
    ttk::button $f.rd1_conf -image [ gid_themes::GetImage configuration.png medium_icons] \
        -command [ list MovementRotation::setParametersWindow $parent]

    ttk::radiobutton $f.rd2 -text [_ "ZoomIn then rotate"] \
        -variable ModelSimpleAnimations::_selected \
        -value MovementZoomInRotation \
        -command ModelSimpleAnimations::EnableDisableConfigurationButtons
    ttk::button $f.rd2_conf -image [ gid_themes::GetImage configuration.png medium_icons] \
        -command [ list MovementZoomInRotation::setParametersWindow $parent]

    ttk::radiobutton $f.rd3 -text [_ "Zoom & Rotate"] \
        -variable ModelSimpleAnimations::_selected \
        -value MovementZoomInZoomOutWhileRotate \
        -command ModelSimpleAnimations::EnableDisableConfigurationButtons
    ttk::button $f.rd3_conf -image [ gid_themes::GetImage configuration.png medium_icons] \
        -command [ list MovementZoomInZoomOutWhileRotate::setParametersWindow $parent]



    set _lst_w_options [ list $f.fix_view_b $f.rd1 $f.rd1_conf $f.rd2 $f.rd2_conf $f.rd3 $f.rd3_conf ]
    grid $f.cb $f.fix_view_b -padx 2 -pady 1 -sticky ew
    grid  $f.cb -columnspan 3
    grid  $f.fix_view_b -columnspan 2 -sticky ew -row 0 -column 3
    grid $f.rd1 $f.rd1_conf $f.rd2 $f.rd2_conf $f.rd3 $f.rd3_conf -padx 2 -pady 1 -sticky e
    grid  $f.rd1_conf -sticky w
    grid  $f.rd2_conf -sticky w
    grid  $f.rd3_conf -sticky w
    grid rowconfigure $f 1 -weight 1
    grid columnconfigure $f {0 1 2 3 4 5} -weight 1        
    # FillValuesFromGiD
    EnableDisableOptions
    return $f
}

proc ModelSimpleAnimations::Init { num_frames} {
    variable _enabled
    variable _selected
    variable _initial_view

    if { $_enabled} {
        ${_selected}::Init $num_frames $_initial_view
    }
}

proc ModelSimpleAnimations::getIncrement { idx_frame } {
    variable _enabled
    variable _selected
    if { $_enabled} {
        ${_selected}::getIncrement $idx_frame
    }
}

proc PostAnimateMovementGetStep { idx_frame idx_step} {
    return [ ModelSimpleAnimations::getIncrement $idx_frame]
    
    set movement_step ""
    # WV idx_frame
    # WV idx_step
    # number of total idx_frames = 
    
    if { $::GidPriv(PostAnimateFixedTotalTime)} {
        set num_frames [ llength $::GidPriv(PostAnimateDurationStepsList)]
        if { $num_frames > 0} {
            set num_frames [ expr $num_frames - 2]
        }
    } else {
        set all_steps $::GidPriv(PostAnimate_all_step)
        set num_frames [ llength $all_steps]
        # if deformed
        if { $::GidPriv(PostAnimateDeform)} {
            incr num_frames
        }
    }

    W "frame $idx_frame / $num_frames"
    
    if { [ info exists ::GidPriv(PostAnimateMovementStepScript)] && ( "$::GidPriv(PostAnimateMovementStepScript)" != "")} {
        set movement_step $::GidPriv(PostAnimateMovementStepScript)
    }
    return $movement_step
}

proc PostAnimateMovementInit { } {
    if { $::GidPriv(PostAnimateFixedTotalTime)} {
        set num_frames [ llength $::GidPriv(PostAnimateDurationStepsList)]
        if { $num_frames > 0} {
            set num_frames [ expr $num_frames - 2]
        }
    } else {
        set all_steps $::GidPriv(PostAnimate_all_step)
        set num_frames [ llength $all_steps]
        # if deformed
        if { $::GidPriv(PostAnimateDeform)} {
            incr num_frames
        }
    }
    ModelSimpleAnimations::Init $num_frames
}

proc PostAnimateFrame { frame_original } {
    global PostAnimatePriv
    set frame $frame_original
    global GidPriv SingleStepAnimation   
    if { $::GidPriv(PostAnimateRangeFrames) && $::GidPriv(PostAnimateDoing) == "Animate"} {       
        set frame [PostAnimateGetValidFrame $frame]
    }
    switch $::GidPriv(PostAnimateDoing) {
        "Nothing" { 
            return
        }
        "Stop" {
            # if it was enabled, then it's disabled now
            ViewFollowsNode::Disable            
            if { $::GidPriv(PostAnimateStopAndEnableGUIUpdates)} {
                PostAnimateEnableGUIUpdates
            }
            if { $::GidPriv(PostAnimateSavingAnimation) } {
                GiD_Process 'AnimationFile End
                # let gif option to be no dithering
                set fmt [ PostAnimateProcessGIFOption $::GidPriv(PostAnimateSaveAnimationFormat)]
                if { $fmt == "GIF"} {
                    PostAnimateProcessGIFOption GIF/None
                }
                set ::GidPriv(PostAnimateSavingAnimation) 0
            }            
            if { $::GidPriv(PostAnimateDeform)} {
                # reactivate redraw              
                GiD_Set AutomaticRedraw $::GidPriv(PostAnimateOldAutoRedraw)               
                GiD_Redraw
            }           
            set ::GidPriv(PostAnimateCurrentFrame) $frame            
            update
            set ::GidPriv(PostAnimateDoing) Nothing            
            return
        }
        "Rewind" {
            if { $::GidPriv(PostAnimateDeform)} {
                set ::GidPriv(PostAnimateCurrentFrame) -1
            } else {
                set ::GidPriv(PostAnimateCurrentFrame) 0
                set ::GidPriv(PostAnimateCurrentFrame) [ PostAnimateGetValidFrame $::GidPriv(PostAnimateCurrentFrame)]
            }        
            set frame $::GidPriv(PostAnimateCurrentFrame)
            if { $frame == -1} {
                PostAnimateUpdateStepValEntry Orig
            } else {
                set all_step $::GidPriv(PostAnimate_all_step)
                set time_step [lindex $all_step $frame]
                PostAnimateUpdateStepValEntry $time_step
            }
            if { [winfo exists $::GidPriv(PostAnimateSlide)] } {
                $::GidPriv(PostAnimateSlide) set [expr $frame+1]
            }            
            PostAnimateUpdateStepNumEntry [expr $frame+1]
        }
    }
    set cur_analysis $::GidPriv(PostAnimate_cur_analysis)
    set cur_d_anal $::GidPriv(PostAnimate_cur_d_anal)
    set all_step $::GidPriv(PostAnimate_all_step)
    set cur_resv $::GidPriv(PostAnimate_cur_result_view)
    set cur_res $::GidPriv(PostAnimate_cur_res)
    set cur_comp $::GidPriv(PostAnimate_cur_comp)
    set cur_defor $::GidPriv(PostAnimate_cur_d_defor)
    set cur_factor $::GidPriv(PostAnimate_cur_d_factor)
    set cur_defor_type $::GidPriv(PostAnimate_cur_defor_type)
    if { $::GidPriv(PostAnimateSaveFrame)} {
        set ::GidPriv(PostAnimateSaveFilename) [ PostAnimateGetFilenameAutomatic \
                                                   $::GidPriv(PostAnimateSaveFrameFormat) \
                                                   $::GidPriv(PostAnimateSavePrefix) $frame]
    } else {
        set ::GidPriv(PostAnimateSaveFilename) ""
    }
    if { $::GidPriv(PostAnimateDeform) && $frame == -1} {
        # deactivate redraw
        set ::GidPriv(PostAnimateOldAutoRedraw) [GiD_Set AutomaticRedraw]
        GiD_Set AutomaticRedraw -1
        # to ensure that it's the first step when loading multiple files
        if { $::SingleStepAnimation(in_use)} {
            set all_step $::SingleStepAnimation(step_selected)
            set time_step $::SingleStepAnimation(step_selected)
        } else {
            set all_step $::GidPriv(PostAnimate_all_step)
            set time_step [lindex $all_step 0]
        }
        GiD_Process Mescape Results AnalysisSel $cur_d_anal $time_step
        # la original
        GiD_Process Mescape Results Geometry Original
        # Also if there are some result visualization, remove it !!!
        # May be only if it's contour fill & co...
        if { $::GidPriv(PostAnimateResultViewCb) } {
            GiD_Process Mescape Results Geometry NoResults escape escape escape escape
        }
        GiD_Set AutomaticRedraw $::GidPriv(PostAnimateOldAutoRedraw)       
        GiD_Redraw       
        if { $::GidPriv(PostAnimateSavingAnimation) } {         
            GiD_Process 'AnimationFile AddStep
        }
        if { $::GidPriv(PostAnimateSaveFrame)} {
            GiD_Process 'Hardcopy $::GidPriv(PostAnimateSaveFrameFormat) $::GidPriv(PostAnimateSaveFilename)
        }                
        GiD_Set AutomaticRedraw -1
        #actualizamos la slide
        if { [winfo exists $::GidPriv(PostAnimateSlide)] } {
            $::GidPriv(PostAnimateSlide) set [expr $frame+1]
        }
        PostAnimateUpdateStepNumEntry [expr $frame+1]
        PostAnimateUpdateStepValEntry Orig
        if { $::GidPriv(PostAnimateDoing) == "Rewind"} {
            set ::GidPriv(PostAnimateDoing) Stop
            PostAnimateFrame $frame
            return
        }
        update idletasks
        set delay [PostAnimateGetValidDelayTime]
        after $delay [list PostAnimateFrame 0]
        return        
    }
    set is_current_main_deformator_complex 0
    set theta 0.0
    set factor 0.0
    set idx_step $frame
    if { $::GidPriv(PostAnimateFixedTotalTime)} {
        if { ![ info exists ::GidPriv(PostAnimateDurationStepsList)]} {
            PostAnimateCreateStepListForFixedTimeAnimation
        }
        #  $::GidPriv(PostAnimateRangeFrames)
        set idx_step [lindex $::GidPriv(PostAnimateDurationStepsList) [ expr $frame - $::GidPriv(PostAnimateRangeFrameFrom) + 1]];
    }    
    if { !$::GidPriv(PostAnimateDeform) || !$::SingleStepAnimation(in_use)} {
        set time_step [lindex $all_step $idx_step]
    } else {
        set time_step $::SingleStepAnimation(step_selected)
        set is_current_main_deformator_complex [IsCurrentMainDeformatorComplex]
        if { $is_current_main_deformator_complex } {            
            set theta [expr (360.0/$::SingleStepAnimation(num_steps))*($idx_step-1)]                        
            if { $idx_step >= $::SingleStepAnimation(num_steps) } {
                #to finish
                set time_step ""
            }
        } else {
            set factor [lindex $::SingleStepAnimation(factors) $idx_step]
            if { $factor == "" } {
                #to finish
                set time_step ""
            }            
        }
    }
    if { $::GidPriv(PostAnimateRangeFrames)} {
        set to_f $::GidPriv(PostAnimateRangeFrameTo)
        if { ( $frame >= $to_f)} {
            set time_step ""
        }
    }
    if { $time_step == ""} {
        #finish the animation not invoking more themselve
        if { $::GidPriv(PostAnimateDeform)} {
            set frame -1
        } else {
            set frame 0
        }
        if { $frame == $frame_original } {
            #avoid call PostAnimateFrame $frame (infinite loop)
            return
        }
        if { $::GidPriv(PostAnimateEndless)} {
            PostAnimateFrame $frame
        } else {
            set ::GidPriv(PostAnimateDoing) Stop
            PostAnimateFrame $frame
            PostAnimateTogglePlayPause $::PostAnimatePriv(TogglePlayPauseWindowButton) PostAnimatePlay PostAnimateStop
        }
        return
    }        
    #actualizamos la slide
    if { [winfo exists $::GidPriv(PostAnimateSlide)] } {
        $::GidPriv(PostAnimateSlide) set [expr $idx_step+1]    
        PostAnimateUpdateStepNumEntry [expr $idx_step+1]
        PostAnimateUpdateStepValEntry $time_step
    }
    #actualizamos la representacion delete resultado
    GiD_Set AutomaticRedraw -1
    # no parece que haga falta... lo comentamos para evitar un redraw
    if { $::GidPriv(PostAnimateVariosResultados) == "yes"} {
        GiD_Process Mescape Results Geometry NoResults escape escape escape escape
    }

    # if movement defined, use it
    set movement_step [ ::PostAnimateMovementGetStep $frame $idx_step]
    if { "$movement_step" != "" } {
        eval {*}$movement_step
    }

    set already_set 0
    if { $::GidPriv(PostAnimateDeform)} {
        # puede que cur_analysis != cur_d_anal
        GiD_Process Mescape Results AnalysisSel $cur_d_anal $time_step
        if { $cur_d_anal == $cur_analysis} {
            set already_set 1
        }
        GiD_Process Mescape Results Options DeformationType $cur_defor_type
        if { $::SingleStepAnimation(in_use)} {            
            if { $is_current_main_deformator_complex } {
                GiD_Process Mescape Results Geometry Original Geometry Deformation $cur_defor $::SingleStepAnimation(deformation_factor) theta $theta escape
            } else {
                GiD_Process Mescape Results Geometry Original Geometry Deformation $cur_defor $factor escape
            }
        } else {
            GiD_Process Mescape Results Geometry Original Geometry Deformation $cur_defor $cur_factor escape
        }
        if { $cur_defor_type != "relative"} {
            GiD_Process Mescape Results Options DeformationType Relative
        }
    }
    if { !$already_set} {
        GiD_Process Mescape Results AnalysisSel $cur_analysis $time_step Mescape
    }
    
    if { $::GidPriv(PostAnimateResultViewCb) && $::GidPriv(PostAnimateAnalysisLimitsCb)} {
        PostAnimatePushLimits
        PostAnimateSetAnalysisLimits
    }
    # if there is iso-surface update it
    set draw_isosurface 0
    if { ( $::GidPriv(PostAnimate_cur_result_view) == "IsoSurfaces") && ( [llength $::GidPriv(PostAnimateIsoSurfaces)] != 0)} {
        set draw_isosurface 1
    }
    if { ( $::GidPriv(PostAnimateVariosResultados) == "no") &&  ( [llength $::GidPriv(PostAnimateIsoSurfaces)] != 0)} {
        # pues puede ser que hagan isosuperficies con color del contour fill y hagan despues el contour fill
        set draw_isosurface 1
    }
    if { $draw_isosurface} {
        set iso_res [lindex $::GidPriv(PostAnimateIsoSurfaces) 2]
        set iso_anal [lindex $iso_res 2]
        if { $cur_analysis != $iso_anal} {
            GiD_Process Mescape Results AnalysisSel $iso_anal $time_step Mescape
        }
        set lst_valores [ lindex $::GidPriv(PostAnimateIsoSurfaces) 1]
        GiD_Process Mescape Results IsoSurfaces Exact [ lindex $iso_res 0] [ lindex $iso_res 1] \
            [ lindex $::GidPriv(PostAnimateIsoSurfaces) 0] {*}$lst_valores
        if { $cur_analysis != $iso_anal} {
            GiD_Process Mescape Results AnalysisSel $cur_analysis $time_step Mescape
        }
    }
    if { $::GidPriv(PostAnimateResultViewCb) && $::GidPriv(PostAnimateResultView) != ""} {
        if { $::GidPriv(PostAnimateVariosResultados) == "no"} {
            switch $::GidPriv(PostAnimate_cur_result_view) {
                "ShMinMax" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "ContourFill" {
                    # set used c.fill limits if automatic limits is not enabled
                    if { !$::GidPriv(PostAnimateAnalysisLimitsCb)} {
                        if { [info exists ::GidPriv(PostAnimateContourUsedLimits)] } {
                            PostAnimateSetUsedLimits $::GidPriv(PostAnimateContourUsedLimits)
                        }
                    }
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "VolumeRender" {
                    # set used c.fill limits if automatic limits is not enabled
                    if { !$::GidPriv(PostAnimateAnalysisLimitsCb)} {
                        if { [info exists ::GidPriv(PostAnimateContourUsedLimits)] } {
                            PostAnimateSetUsedLimits $::GidPriv(PostAnimateContourUsedLimits)
                        }
                    }
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "SmoothContourFill" {
                    # set used c.fill limits if automatic limits is not enabled
                    if { !$::GidPriv(PostAnimateAnalysisLimitsCb)} {
                        if { [info exists ::GidPriv(PostAnimateContourUsedLimits)] } {
                            PostAnimateSetUsedLimits $::GidPriv(PostAnimateContourUsedLimits)
                        }
                    }
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "ContourLines" {
                    # set used c.fill limits if automatic limits is not enabled
                    if { !$::GidPriv(PostAnimateAnalysisLimitsCb)} {
                        if { [info exists ::GidPriv(PostAnimateContourUsedLimits)] } {
                            PostAnimateSetUsedLimits $::GidPriv(PostAnimateContourUsedLimits)
                        }
                    }
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "SmoothContourLines" {
                    # set used c.fill limits if automatic limits is not enabled
                    if { !$::GidPriv(PostAnimateAnalysisLimitsCb)} {
                        if { [info exists ::GidPriv(PostAnimateContourUsedLimits)] } {
                            PostAnimateSetUsedLimits $::GidPriv(PostAnimateContourUsedLimits)
                        }
                    }
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "IsoSurfaces" {
                    ### set lst_valores [ lindex $::GidPriv(PostAnimateIsoSurfaces) 1]
                    ### GiD_Process Mescape Results $cur_resv Exact $cur_res $cur_comp \
                        ###     [ lindex $::GidPriv(PostAnimateIsoSurfaces) 0] {*}$lst_valores                   
                    # foreach val $lst_valores {
                        #         GiD_Process $val
                        # }
                }
                "DisplayVectors" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp $::GidPriv(PostAnimateDisplayVectors) escape
                }
                "ContourRanges" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp escape
                }
                "ScalarLineDiagram" {
                    GiD_Process Mescape Results LineDiagram ScalarDiagram $cur_res $cur_comp $::GidPriv(PostAnimateScalarDiagram) escape
                }
                "VectorLineDiagram" {
                    GiD_Process Mescape Results LineDiagram VectorDiagram $cur_res $::GidPriv(PostAnimateVectorDiagram) escape
                }
                "ResultSurface" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp $::GidPriv(PostAnimateResultSurface) escape
                }
                "SmoothResultSurface" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp $::GidPriv(PostAnimateResultSurface) escape
                }
                "LineThickness" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp $::GidPriv(PostAnimateResultSurface) escape
                }
                "SmoothLineThickness" {
                    GiD_Process Mescape Results $cur_resv $cur_res $cur_comp $::GidPriv(PostAnimateResultSurface) escape
                }
                default {
                    #nothing
                }
            }
        } else {
            # varios resultados        
            set lst_limits_resv [ list contourfill smoothcontourfill contourlines smoothcontourlines]
            foreach state_res $::GidPriv(PostAnimateListaResultados) {
                set resv [ string tolower [ lindex $state_res 1]]
                set res_name [ lindex $state_res 4]
                set res_comp [ lindex $state_res 5]
                set res_factor [ lindex $state_res 6]
                regsub -all { } $resv {} resv
                if { ( [ lsearch $lst_limits_resv $resv] != -1) && !$::GidPriv(PostAnimateAnalysisLimitsCb)} {
                    # set used c.fill limits if automatic limits is not enabled
                    if { [info exists ::GidPriv(PostAnimateContourUsedLimits)] } {
                        PostAnimateSetUsedLimits $::GidPriv(PostAnimateContourUsedLimits)
                    }
                }
                if { $resv == "displayvectors"} {
                    GiD_Process Mescape Results $resv $res_name $res_comp $res_factor escape
                } elseif { $resv == "scalarlinediagram"} {
                    GiD_Process Mescape Results LineDiagram ScalarDiagram $res_name $res_comp $res_factor escape
                } elseif { $resv == "vectorlinediagram"} {
                    GiD_Process Mescape Results LineDiagram VectorDiagram $res_name $res_factor escape
                } elseif { $resv == "isosurfaces"} {
                    set lst_valores [lindex $res_factor 1]
                    GiD_Process Mescape Results $resv Exact $res_name $res_comp [lindex $res_factor 0] {*}$lst_valores escape
                } else {
                    GiD_Process Mescape Results $resv $res_name $res_comp escape
                }
            }
        }
    }
    GiD_Set AutomaticRedraw $::GidPriv(PostAnimateOldAutoRedraw)       
    GiD_Redraw
    if { $::GidPriv(PostAnimateSavingAnimation) } {
        GiD_Process 'AnimationFile AddStep
    } else {
        PostAnimateShowTime
    }
    if { $::GidPriv(PostAnimateSaveFrame)} {       
        GiD_Process 'Hardcopy $::GidPriv(PostAnimateSaveFrameFormat) $::GidPriv(PostAnimateSaveFilename) escape
    }
    if { $::GidPriv(PostAnimateResultViewCb) && $::GidPriv(PostAnimateAnalysisLimitsCb)} {
        PostAnimatePopLimits
    }
    if { $::GidPriv(PostAnimateDoing) == "Rewind"} {
        set ::GidPriv(PostAnimateDoing) Stop
        PostAnimateFrame $frame
        return
    }
    update idletasks
    if { $::GidPriv(PostAnimateFixedDelay) } {
        set delay [PostAnimateGetValidDelayTime]
        set next_frame [expr $frame + 1]
        after $delay [list PostAnimateFrame $next_frame]
    } else {
        if { $::GidPriv(PostAnimateFixedTotalTime)} {
            if { $::GidPriv(PostAnimateUseScaledStepvalues)} {
                set ::GidPriv(PostAnimateUseStepvalues) 1
            } else {
                set ::GidPriv(PostAnimateUseStepvalues) 0
            }
        }
        if { $::GidPriv(PostAnimateUseStepvalues)} {
            if {$::GidPriv(PostAnimateFixedTotalTime)} {

                set to_f $::GidPriv(PostAnimateDefaultRangeFrameTo)
                if { $::GidPriv(PostAnimateRangeFrames)} {
                    set to_f $::GidPriv(PostAnimateRangeFrameTo)
                }

                set npas [ expr $to_f  - 1]
                set pas_final [lindex $::GidPriv(PostAnimate_all_step) $npas]
                set dur [ expr double($::GidPriv(PostAnimateDurationTime))/$pas_final]
            } else {
                set dur 1
            }
            set frame1 [expr $time_step-$::GidPriv(PostAnimateIstepold)]
            set ::GidPriv(PostAnimateIstepold) $time_step
            set val [expr int([expr $frame1*1000*$dur])]
            if { $val <= 0} {
                set val 5
            }
            set ::GidPriv(PostAnimateStepvaluesDelay) $val
            set next_frame [expr $frame + 1]
            after [expr $::GidPriv(PostAnimateStepvaluesDelay)] [list PostAnimateFrame $next_frame]
        } else {
            if { $::GidPriv(PostAnimateFixedTotalTime) } {
                set num_frames [ llength $::GidPriv(PostAnimateDurationStepsList)]
                set ::GidPriv(PostAnimateDurationTimeDelay) \
                    [ expr $::GidPriv(PostAnimateDurationTime) * 1000 / $num_frames]
                if { $::GidPriv(PostAnimateDurationTimeDelay) <= 0} {
                    set ::GidPriv(PostAnimateDurationTimeDelay) 5
                }
                set delay $::GidPriv(PostAnimateDurationTimeDelay)
            } else {
                set delay [PostAnimateGetValidDelayTime]
            }
            set next_frame [expr $frame + 1]
            after [expr int($delay)] [list PostAnimateFrame $next_frame]
        }
    }
    return
}

proc PostAnimateProcessGIFOption { format } {
    set ret $format
    if { [ regexp {^GIF/(.+)$} $format dum opt] != 0} {
        set ret GIF
        GiD_Process 'Hardcopy Options GIFDithering $opt
    }
    return $ret
}

proc PostAnimateWriteGIFOption { fo format } {
    set ret $format
    # handles [_ "GIF/no dithering"] [_ "GIF/dithering595"] [_ "GIF/dithering666"]
    if { [ regexp {^GIF/(.+)$} $format dum opt] != 0} {
        set ret GIF
        puts $fo "'Hardcopy Options GIFDithering $opt"
    }
    return $ret
}

# fills variable ::GidPriv(PostAnimateDurationStepsList) used to select the next step to animate
proc PostAnimateCreateStepListForFixedTimeAnimation { { w ""} } {
    if { $w == ""} {
        set w .gid
    }

    set cur_format $::GidPriv(PostAnimateSaveAnimationFormat)
    set cur_format_label ::GidPriv(PostAnimateVideoFormat,${cur_format},Label)
    # if not saving animation, ?desired target = 1000 fps? or 60 fps (screen refresh)
    set max_fps 60
    if { $::GidPriv(PostAnimateSaveAnimation)} {
        set max_fps $::GidPriv(PostAnimateVideoFormat,${cur_format},MaxFps)
        # eventually if animation es scaled to TotalTime or using step values as seconds or scaled
        # set at the end and not here
    }
    set delay_ms [ expr 1000.0 / double( $max_fps)]
    set ::GidPriv(PostAnimateAnimationFileFPS) $max_fps
    set ::GidPriv(PostAnimateDelayTime) $delay_ms

    set number_of_repeated_frames 1
    if { $::GidPriv(PostAnimateFixedTotalTime)} {
        # time length set by the user
        # as From = 1, instead of 0
        set all_step $::GidPriv(PostAnimate_all_step)
        if { $::SingleStepAnimation(in_use)} {
            set all_step $::SingleStepAnimation(factors)
        }
        set frame_from 1
        set frame_to [ llength $all_step]
        if { $::GidPriv(PostAnimateRangeFrames)} {
            set frame_from $::GidPriv(PostAnimateRangeFrameFrom)
            set frame_to $::GidPriv(PostAnimateRangeFrameTo)
        }
        set num_steps_to_reproduce [ expr $frame_to - $frame_from + 1]
        set delay_between_frames [ expr ( 1000.0 * $::GidPriv(PostAnimateDurationTime)) / ( $num_steps_to_reproduce + 1)]
        
        # if { $delay_between_frames < 40.0}
        if { $delay_between_frames < $delay_ms} {
            # frame rate is 20 fps = 40.0ms per frame
            set number_of_repeated_frames 1
            if { ![ info exists ::GidPriv(PostAnimateIssuedWarningSkippingSteps)] || !$::GidPriv(PostAnimateIssuedWarningSkippingSteps)} {
                package require cksum
                set txt [_ "Animation is done at %s fps.\nTotal time length is too short. \nSome steps will be skipped." $max_fps]
                set ww_id [ ::crc::cksum $txt]
                WarnWin $txt $w $ww_id
                set ::GidPriv(PostAnimateIssuedWarningSkippingSteps) 1
            } else {
            }
        } else {
            # set number_of_repeated_frames [expr int(0.5 + $delay_between_frames / $delay_ms)]
            # adjust fps to match delay_between_frames
            set new_fps [ expr int( 0.5 + 1000.0 / $delay_between_frames)]
            set delay_ms $delay_between_frames
            set max_fps $new_fps
            set ::GidPriv(PostAnimateAnimationFileFPS) $new_fps
            set ::GidPriv(PostAnimateDelayTime) $delay_ms
        }
        # build the list of steps to reproduce:
        set ::GidPriv(PostAnimateDurationStepsList) [ list]
        # number of actual steps @ 25fps, 40.0 ms.
        set total_steps_max_fps [ expr ( 1000.0 * $::GidPriv(PostAnimateDurationTime)) / $delay_ms]
        set steps_to_skip [ expr double( $num_steps_to_reproduce + 1) / $total_steps_max_fps]
        for { set step_to_add 0} { $step_to_add <= $num_steps_to_reproduce} { set step_to_add [ expr $step_to_add + $steps_to_skip]} {
            set i_step_to_add [ expr $frame_from + int( 0.5 + $step_to_add)]
            lappend ::GidPriv(PostAnimateDurationStepsList) $i_step_to_add
        }
        # add the last one:
        lappend ::GidPriv(PostAnimateDurationStepsList) $frame_to
    }
    # return $number_of_repeated_frames
    return 1
}

proc PostAnimateEventFinish {} {
    PostAnimateStop $::GidPriv(GiD_Event_BeforeEndGIDPostProcess,w) \
        $::GidPriv(GiD_Event_BeforeEndGIDPostProcess,enable_gui_updates)
}

proc PostAnimatePlay { w { disable_gui_updates 1}} {
    global GidPriv 
    # send MEscape to finish some functions in course, e.g. dynamic pan, to avoid that pushcursor with windows enabled and then popcursor with windows disabled remain the pan cursor!!
    GiD_Process MEscape

    # check animation filename extension
    # ::GidPriv(PostAnimateShowVideoFormatExtensions)
    if { $::GidPriv(PostAnimateSaveAnimation)} {
        set new_ext $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateSaveAnimationFormat),Extension)
        if { [ string first .$new_ext $::GidPriv(PostAnimateSaveAnimationFile)] == -1} {
            set ::GidPriv(PostAnimateSaveAnimationFile) $::GidPriv(PostAnimateSaveAnimationFile).$new_ext
        }
    }
   
    if { $::GidPriv(PostAnimateDoing) != "Nothing"} {
        return
    }   
    if { $::GidPriv(PostAnimateRangeFrames) && ![PostAnimateCheckRangeFrame]} {
        return
    }
    if { ![PostAnimateCheckWhichAnimation]} { 
        return
    }    
    if { [GiD_Info postprocess get cur_analysis] == "" } {
        #there is no results to animate
        return
    }

    # if we are doing an animation from $step to $step, check if we start from outside this range, if so, do a rewind
    if { $::GidPriv(PostAnimateRangeFrames)} {
        if { ( $::GidPriv(PostAnimateCurrentFrame) < $::GidPriv(PostAnimateRangeFrameFrom)) || \
                 ( [ expr $::GidPriv(PostAnimateCurrentFrame) + 1] >= $::GidPriv(PostAnimateRangeFrameTo))} {
            # PostAnimateRewind
            # set ::GidPriv(PostAnimateCurrentFrame) $::GidPriv(PostAnimateRangeFrameFrom)
            set ::GidPriv(PostAnimateDoing) Rewind
            PostAnimateFrame $::GidPriv(PostAnimateCurrentFrame)
        }
    }

    # register event so that the animation stops when quitting postprocess
    set ::GidPriv(GiD_Event_BeforeEndGIDPostProcess,w) $w
    set ::GidPriv(GiD_Event_BeforeEndGIDPostProcess,enable_gui_updates) $disable_gui_updates
    GiD_RegisterEvent GiD_Event_BeforeEndGIDPostProcess PostAnimateEventFinish

    PostAnimateCheckVisualizationCoherency
    if { $::GidPriv(PostAnimateFixedDelay)} {
        if { [ catch { set pp [ expr $::GidPriv(PostAnimateDelayTime)]}] } {
            WarnWin [_ "Delay '%s' not correct." $::GidPriv(PostAnimateDelayTime)] $::GidPriv(PostAnimateWindow)
            return
        }
        if { $::GidPriv(PostAnimateDelayTime) < 0} {
            WarnWin [_ "Delay '%s' not correct." $::GidPriv(PostAnimateDelayTime)] $::GidPriv(PostAnimateWindow)
            return
        }
        if { $::GidPriv(PostAnimateDelayTime) > 15000} {
            set resp [GID_tk_messageBox -parent $::GidPriv(PostAnimateWindow) -default no -title [_ "Confirm"] -type yesno \
                           -message [_ "Are you sure you want to use %s ms as delay?" $::GidPriv(PostAnimateDelayTime)]]
            if { $resp == "no" } {
                return
            }
        }
    }
    if { $::GidPriv(PostAnimateFixedTotalTime)} {
        if { [ catch { set pp [ expr $::GidPriv(PostAnimateDurationTime)]}] } {
            WarnWin [_ "Duration '%s' not correct." $::GidPriv(PostAnimateDurationTime)] $::GidPriv(PostAnimateWindow)
            return
        }
        if { $::GidPriv(PostAnimateDurationTime) < 0} {
            WarnWin [_ "Duration '%s' not correct." $::GidPriv(PostAnimateDurationTime)] $::GidPriv(PostAnimateWindow)
            return
        }
        if { $::GidPriv(PostAnimateDurationTime) > 200} {
            set resp [GID_tk_messageBox -parent $::GidPriv(PostAnimateWindow) -default no -title [_ "Confirm"] -type yesno \
                           -message [_ "Are you sure you want to use %s s as duration?" $::GidPriv(PostAnimateDurationTime)]]
            if { $resp == "no" } {
                return
            }
        }
    }
    if { $::GidPriv(PostAnimateEndless) && ( $::GidPriv(PostAnimateSaveAnimation) || $::GidPriv(PostAnimateSaveFrame))} {
        set what ""
        if { $::GidPriv(PostAnimateSaveFrame)} {
            set what "save $::GidPriv(PostAnimateSaveFrameFormat)'s"
        }
        if { $::GidPriv(PostAnimateSaveAnimation)} {
            if { $what == ""} {
                set what "save the $::GidPriv(PostAnimateSaveAnimationFormat)"
            } else {
                set what "$what & save the $::GidPriv(PostAnimateSaveAnimationFormat)"
            }
        }
        set resp [tk_dialog $::GidPriv(PostAnimateWindow).___pa_ww2 [_ "Warning"] \
                      [_ "Are you sure to do an ENDLESS animation AND %s, so that the disk will be filled?" $what]\
                      error 1 [_ "Yes, I know"] [_ "No, I wouldn't"]]
        switch $resp {
            0 {
                WarnWin [_ "Remember to push the STOP button to STOP the animation and so, not to fill the disk !!!"] $::GidPriv(PostAnimateWindow)
            }
            1 {
                return
            }
        }
    }
    if { $::GidPriv(PostAnimateFixedTotalTime)} { 
        # time length set by the user
        PostAnimateCreateStepListForFixedTimeAnimation $w
    }
    if { $::GidPriv(PostAnimateSaveAnimation) } {
        if { ![ PostAnimateVerifyPermissions $w $::GidPriv(PostAnimateSaveAnimationFile)]} {
            return
        }
        # para que no nos actualize el state de resultados:
        #puede que estemos haciendo una animacion de deformada y estemos en el state original
        set ::GidPriv(PostAnimateInitializing) 1
        GiD_Process 'AnimationFile Format [PostAnimateProcessGIFOption $::GidPriv(PostAnimateSaveAnimationFormat)]
        set ::GidPriv(PostAnimateInitializing) 0
        
        if { $::GidPriv(PostAnimateSaveAnimationFormat) == "AVIMJPG" || \
            $::GidPriv(PostAnimateSaveAnimationFormat) == "AVIMSVC" || \
                $::GidPriv(PostAnimateSaveAnimationFormat) == "AVI" || \
                $::GidPriv(PostAnimateSaveAnimationFormat) == "AVI15" || \
                $::GidPriv(PostAnimateSaveAnimationFormat) == "AVI16" || \
                $::GidPriv(PostAnimateSaveAnimationFormat) == "FLV"} {
            lassign [ GidUtils::GetMainDrawAreaSize ] width height
            set avisize [expr $width*$height*([llength $::GidPriv(PostAnimate_all_step)]+$::GidPriv(PostAnimateDeform))]
            if { $::GidPriv(PostAnimateSaveAnimationFormat) == "AVIMJPG" } {
                # estimacion aproximada
                set avisize [expr $avisize*3*0.1]
            } elseif { $::GidPriv(PostAnimateSaveAnimationFormat) == "AVIMSVC" } {
                # estimacion aproximada
                set avisize [expr $avisize*3*0.15]
            } elseif { $::GidPriv(PostAnimateSaveAnimationFormat) == "AVI" } {
                set avisize [expr $avisize*3]
            } elseif { $::GidPriv(PostAnimateSaveAnimationFormat) == "FLV" } {
                # estimacion aproximada
                set avisize [expr $avisize*3*0.1]
            } else {
                set avisize [expr $avisize*2]
            }
            set avisize [expr ($avisize/1024.0)/1024.0]
            if { $avisize > 200.00 } {
                set resp [GID_tk_messageBox -parent $::GidPriv(PostAnimateWindow) -icon warning -type yesno \
                        -default no -message \
                               [_ "Warning: the AVI/FLV file will be %s MB big !!!\n Are you sure you want continue?" [format %.3g $avisize]] ]
                if { $resp == "no"} {
                    return
                }
            }         
        }
        # Frame rate = 25 FPS == 40 ms.
        # set new_fps $::GidPriv(PostAnimateAnimationFileFPS) 
        # if not saving animation, ?desired target = 1000 fps? or 60 fps (screen refresh)
        set new_fps 60
        if { $::GidPriv(PostAnimateSaveAnimation)} {
            set cur_format $::GidPriv(PostAnimateSaveAnimationFormat)
            set new_fps $::GidPriv(PostAnimateVideoFormat,${cur_format},MaxFps)
            if { $::GidPriv(PostAnimateDurationType) == "Delay"} {
                set new_fps $::GidPriv(PostAnimateAnimationFileFPS)
            }
        }
        set delay_new_fps [ expr 1000.0 / double( $new_fps)]

        set how_many_repetitions 1
        if { $::GidPriv(PostAnimateFixedDelay) } {
            if { $::GidPriv(PostAnimateDelayTime) != ""} {
                set cur_fmt $::GidPriv(PostAnimateSaveAnimationFormat)
                set max_fps $::GidPriv(PostAnimateVideoFormat,${cur_fmt},MaxFps)
                # if { $::GidPriv(PostAnimateDelayTime) == 0 && $::GidPriv(PostAnimateSaveAnimationFormat) == "MPEG" }
                if { ( $::GidPriv(PostAnimateAnimationFileFPS) <= 0) || ( $::GidPriv(PostAnimateAnimationFileFPS) > $max_fps)} {
                    set description $::GidPriv(PostAnimateVideoFormat,${cur_fmt},Label)
                    set resp [GID_tk_messageBox -parent $::GidPriv(PostAnimateWindow) -icon warning -type yesno \
                                   -default no -message \
                                   [_ "Selected %s FPS is not recommended for this format %s.\nShould be between 0 and %s.\nAre you sure you want continue?"] \
                                   $::GidPriv(PostAnimateAnimationFileFPS) $description $max_fps ]
                    if { $resp == "no"} {
                        return
                    }
                }
            }
            set how_many_repetitions 1
            if { $::GidPriv(PostAnimateSaveAnimation)} {
                catch {
                    set how_many_repetitions [expr int(0.5+$::GidPriv(PostAnimateDelayTime)/$delay_new_fps)]
                }
            }
        } else {
            set how_many_repetitions 1
            if { $::GidPriv(PostAnimateFixedTotalTime)} {
                # time length set by the user
                # PostAnimateCreateStepListForFixedTimeAnimation always returns 1
                set how_many_repetitions [PostAnimateCreateStepListForFixedTimeAnimation $w]
            }
        }

        if { $how_many_repetitions == 0} { set how_many_repetitions 1}

        set animFPS $::GidPriv(PostAnimateAnimationFileFPS)
        # trick for open_h264 codec which needs a minimum FPS
        set lst_codecs_min_fps [ list mp4_h264 avi_h264]
        if { [ lsearch $lst_codecs_min_fps $::GidPriv(PostAnimateSaveAnimationFormat) ] != -1 } {
            if { $animFPS < 10} {
                set animFPS 10
                set how_many_repetitions [ expr int( 0.5 + 10.0 / double( $::GidPriv(PostAnimateAnimationFileFPS)))]
            }
        }

        set ::GidPriv(PostAnimateSavingRepetitions) $how_many_repetitions
        GiD_Process 'AnimationFile FramesPerStep $::GidPriv(PostAnimateSavingRepetitions) escape escape escape escape
        GiD_Process 'AnimationFile SetFPS $animFPS escape escape escape escape
        GiD_Set AnimationFileQuality $::GidPriv(PostAnimateAnimationFileQuality)
        GiD_Process 'AnimationFile SetQuality $::GidPriv(PostAnimateAnimationFileQuality) escape escape escape escape
        GiD_Process 'AnimationFile Start $::GidPriv(PostAnimateSaveAnimationFile) Yes escape escape escape escape
        set ::GidPriv(PostAnimateSavingAnimation) 1
        update
    }
    # para mostrar al usuario el tamanyo delete filename
    if { $::GidPriv(PostAnimateUseStepvalues) } {
        set temps [lindex $::GidPriv(PostAnimate_all_step) 0]
        set ::GidPriv(PostAnimateTime) [expr int([expr $temps*1000])]
    } else {
        set ::GidPriv(PostAnimateTime) 0
    }
    # if it's disabled, then it does nothing
    ViewFollowsNode::Enable

    PostAnimateMovementInit

    set ::GidPriv(PostAnimateDoing) Animate
    if { $disable_gui_updates} {
        PostAnimateDisableGUIUpdates
    }    
    set ::GidPriv(PostAnimateCurrentButton) $w
    set ::GidPriv(PostAnimateContourUsedLimits) [PostAnimateGetUsedLimits]

    PostAnimateFrame $::GidPriv(PostAnimateCurrentFrame)
}

proc PostAnimateStop { w { enable_gui_updates 1 } } {
    global GidPriv

    # unregister event so that the animation stops when quitting postprocess
    if { [ GiD_GetIsRegisteredEventProc GiD_Event_BeforeEndGIDPostProcess PostAnimateEventFinish]} {
        GiD_UnRegisterEvent GiD_Event_BeforeEndGIDPostProcess PostAnimateEventFinish
    }
 
    # if it was enabled, then it's disabled now
    ViewFollowsNode::Disable
    # patch: make sure we can still work with GiD
    set ::GidPriv(PostAnimateStopAndEnableGUIUpdates) $enable_gui_updates
    if { $enable_gui_updates} {
        PostAnimateEnableGUIUpdates
    }
    if { $::GidPriv(PostAnimateDoing) == "Nothing"} { 
        return
    }  
    set ::GidPriv(PostAnimateDoing) Stop   
    set ::GidPriv(PostAnimateCurrentButton) $w
}

proc PostAnimateRewind { { w ""} } {
    global GidPriv
    if { $::GidPriv(PostAnimateUseStepvalues) } { set ::GidPriv(PostAnimateTime) 0}
    if { $w != ""} {
        set ::GidPriv(PostAnimateCurrentButton) $w    
    }
    if { $::GidPriv(PostAnimateDoing) != "Animate"} {
        set ::GidPriv(PostAnimateDoing) Rewind
        set oldstepvalues $::GidPriv(PostAnimateUseStepvalues)
        set oldskipframes $::GidPriv(PostAnimateRangeFrames)
        set oldsave $::GidPriv(PostAnimateSaveFrame)
        set oldsaveanim $::GidPriv(PostAnimateSaveAnimation)
        set ::GidPriv(PostAnimateUseStepvalues) 0
        set ::GidPriv(PostAnimateRangeFrames) 0
        set ::GidPriv(PostAnimateSaveFrame) 0
        set ::GidPriv(PostAnimateSaveAnimation) 0
        PostAnimateFrame $::GidPriv(PostAnimateCurrentFrame)
        set ::GidPriv(PostAnimateSaveFrame) $oldsave
        set ::GidPriv(PostAnimateSaveAnimation) $oldsaveanim
        set ::GidPriv(PostAnimateRangeFrames) $oldskipframes
        set ::GidPriv(PostAnimateUseStepvalues) $oldstepvalues
    } else {
        set ::GidPriv(PostAnimateDoing) Rewind
    }
}

proc PostAnimateStep { w { disable_gui_updates 1 } { enable_gui_updates 1 } } {
    global GidPriv
    # to properly create list of steps and configure the slide bar
    if { $::GidPriv(PostAnimateFixedTotalTime)} { 
        # time length set by the user
        PostAnimateCreateStepListForFixedTimeAnimation $w
    }
    set oldskipframes $::GidPriv(PostAnimateRangeFrames)
    set old $::GidPriv(PostAnimateDefaultDelayTime)
    set old $::GidPriv(PostAnimateDefaultFPS)
    set oldduration $::GidPriv(PostAnimateFixedTotalTime)
    set olddurationtime $::GidPriv(PostAnimateDefaultDurationTime)
    set oldstepvalues $::GidPriv(PostAnimateUseStepvalues)
    set oldsave $::GidPriv(PostAnimateSaveFrame)
    set oldsaveanim $::GidPriv(PostAnimateSaveAnimation)
    set ::GidPriv(PostAnimateRangeFrames) 0
    set ::GidPriv(PostAnimateDefaultDelayTime) 5
    set ::GidPriv(PostAnimateDefaultFPS) 200
    set ::GidPriv(PostAnimateFixedTotalTime) 0
    set ::GidPriv(PostAnimateDefaultDurationTime) 0
    set ::GidPriv(PostAnimateUseStepvalues) 0
    set ::GidPriv(PostAnimateSaveFrame) 0
    set ::GidPriv(PostAnimateSaveAnimation) 0
    # para que tambien actualize las ventanas
    # PostAnimatePlay $w disable_gui_updates
    PostAnimatePlay $w $disable_gui_updates
    PostAnimateStop $w $enable_gui_updates
    set ::GidPriv(PostAnimateSaveAnimation) $oldsaveanim
    set ::GidPriv(PostAnimateSaveFrame) $oldsave
    set ::GidPriv(PostAnimateDefaultDelayTime) $old
    set ::GidPriv(PostAnimateDefaultFPS) $old
    set ::GidPriv(PostAnimateFixedTotalTime) $oldduration
    set ::GidPriv(PostAnimateDefaultDurationTime) $olddurationtime
    set ::GidPriv(PostAnimateUseStepvalues) $oldstepvalues
    set ::GidPriv(PostAnimateRangeFrames) $oldskipframes
}

proc PostAnimateMPEGLeds { state} {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    set led_libre $::GidPriv(PostAnimateMPEG_led_libre)  
    switch $state {
        DISABLED {
            $w.f_anim.f.cv itemconfigure $led_libre -fill grey60           
        }
        FREE {
            $w.f_anim.f.cv itemconfigure $led_libre -fill green          
        }
        BUSY {
            $w.f_anim.f.cv itemconfigure $led_libre -fill red          
        }
        default {
            WarnWin [_ "Unknown led state: %s" $state] $::GidPriv(PostAnimateWindow)
            $w.f_anim.f.cv itemconfigure $led_libre -fill grey60           
        }
    }
    
}

proc PostAnimateTogleDelayEntry { } {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    if { $::GidPriv(PostAnimateFixedDelay) } {
        $w.f_dur.f_del.e configure -state normal
        focus $w.f_dur.f_del.e
        $w.f_dur.f_del.efps configure -state normal
    } else {
        $w.f_dur.f_del.e configure -state disabled
        $w.f_dur.f_del.efps configure -state disabled
    }
}

proc PostAnimateTogleDurationEntry { } {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    if { $::GidPriv(PostAnimateFixedTotalTime) } {
        $w.f_dur.dur.e configure -state normal       
        focus $w.f_dur.dur.e      
        $w.f_dur.f_sca.cb configure -state normal        
    } else {
        $w.f_dur.dur.e configure -state disabled      
        $w.f_dur.f_sca.cb configure -state disabled       
    }
}

proc PostAnimateGetDurationType { name1 name2 op} {
    global GidPriv
    if { $::GidPriv(PostAnimateDurationType) == "TotalTime" } {
        set ::GidPriv(PostAnimateFixedTotalTime) 1
        # to show the warning about skipping steps again.
        set ::GidPriv(PostAnimateIssuedWarningSkippingSteps) 0
        set ::GidPriv(PostAnimateFixedDelay) 0
        if { $::GidPriv(PostAnimateUseScaledStepvalues) } {
            if { [ PostAnimateThereAreResultsInModel complain]} {
                set ::GidPriv(PostAnimateUseStepvalues) 1
            } else {
                set ::GidPriv(PostAnimateUseScaledStepvalues) 0
            }
        } else {
            set ::GidPriv(PostAnimateUseStepvalues) 0
        }
    }
    
    if { $::GidPriv(PostAnimateDurationType) == "Delay" } {
        set ::GidPriv(PostAnimateFixedTotalTime) 0
        set ::GidPriv(PostAnimateFixedDelay) 1
        set ::GidPriv(PostAnimateUseStepvalues) 0
    }
    
    if { $::GidPriv(PostAnimateDurationType) == "StepValue" } {
        if { [PostAnimateThereAreResultsInModel complain]} {
            set ::GidPriv(PostAnimateFixedTotalTime) 0
            set ::GidPriv(PostAnimateFixedDelay) 0
            set ::GidPriv(PostAnimateUseStepvalues) 1
        } else {
            set ::GidPriv(PostAnimateDurationType) $::GidPriv(PostAnimateDefaultDurationType)
        }
    }

    PostAnimateTogleDurationEntry
    PostAnimateTogleDelayEntry
}

proc CheckPostAnimateDurationWStep { } {
    if { $::GidPriv(PostAnimateUseScaledStepvalues) &&
        ![ PostAnimateThereAreResultsInModel complain]} {
        set ::GidPriv(PostAnimateUseScaledStepvalues) 0
    }
}

proc PostAnimateTogleRangeFramesEntry { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    if { $::GidPriv(PostAnimateRangeFrames) } {
        if { ![ PostAnimateThereAreResultsInModel complain]} {
            set ::GidPriv(PostAnimateRangeFrames) 0
            return
        }       
        $w.f_opt.f_rangefr.ef configure -state normal     
        focus $w.f_opt.f_rangefr.ef
        $w.f_opt.f_rangefr.et configure -state normal      
        if { $::GidPriv(PostAnimateRangeFrameFrom) == $::GidPriv(PostAnimateRangeFrameTo)} {
            set ::GidPriv(PostAnimateRangeFrameTo) [ llength $::GidPriv(PostAnimate_all_step)]
        }
    } else {
        $w.f_opt.f_rangefr.ef configure -state disabled       
        $w.f_opt.f_rangefr.et configure -state disabled 
    }
}

proc PostAnimateTogleSaveEntry { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    if { $::GidPriv(PostAnimateSaveFrame) } {
        $w.f_save.f.f.mb configure -state normal
        $w.f_save.f.b configure -state normal
        $w.f_save.e configure -state normal
        focus $w.f_save.e
    } else {
        $w.f_save.f.f.mb configure -state disabled
        $w.f_save.f.b configure -state disabled
        $w.f_save.e configure -state disabled       
    }
}

proc PostAnimateTogleMPEGLeds { name1 name2 op} {
    global GidPriv
    if { $::GidPriv(PostAnimateSavingAnimation) == 0} {
        PostAnimateMPEGLeds FREE
    }
    
    if { $::GidPriv(PostAnimateSavingAnimation) == 1} {
        PostAnimateMPEGLeds BUSY
    }
}

proc PostAnimateChangeExtension { } {
    global GidPriv
    set new_format $::GidPriv(PostAnimateSaveAnimationFormat)
    if { $::GidPriv(PostAnimateSaveAnimationFile) == "" } { return}
    
    set raiz [ file root $::GidPriv(PostAnimateSaveAnimationFile)]
    set ext [ string tolower [ file extension $::GidPriv(PostAnimateSaveAnimationFile)]]
    set new_ext $::GidPriv(PostAnimateVideoFormat,$new_format,Extension)
    if { $ext != $new_ext} {
        set ::GidPriv(PostAnimateSaveAnimationFile) ${raiz}.${new_ext}
    }
}

proc PostAnimateIfStereoDisableForceCb { w} {
    if { [GiD_Set Stereo(On)] } {
        $w configure -state disabled       
    } else {
        $w configure -state normal       
    }
}

proc PostAnimateTogleAnimEntry { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    if { $::GidPriv(PostAnimateSaveAnimation) } {
        if {  [ info exists GidPriv(PostAnimateControlsSavingAnimation) ] && \
            $::GidPriv(PostAnimateControlsSavingAnimation) } {
            WarnWin "Sorry, but couldn't save the animation while another one is active (Animation Controls Window)"
            set ::GidPriv(PostAnimateSaveAnimation) 0
            return
        }
        PostAnimateIfStereoDisableForceCb $w.f_anim.f.f.cb_stereo
        $w.f_anim.f.f.mb configure -state normal
        $w.f_anim.f.b configure -state normal
        $w.f_anim.f.bch configure -state normal
        if { [winfo exists $w.f_anim.f.f.fq.e_qual ] } {
            $w.f_anim.f.f.fq.e_qual configure -state normal
        }
        $w.f_anim.e configure -state normal
        focus $w.f_anim.e
        PostAnimateMPEGLeds FREE
        # remove any previous trace add we could have done...
        catch { 
            trace remove variable GidPriv(PostAnimateSavingAnimation) write PostAnimateTogleMPEGLeds
        }
        trace add variable GidPriv(PostAnimateSavingAnimation) write PostAnimateTogleMPEGLeds
    } else {
        $w.f_anim.f.f.cb_stereo configure -state disabled       
        $w.f_anim.f.f.mb configure -state disabled
        $w.f_anim.f.b configure -state disabled
        $w.f_anim.f.bch configure -state disabled
        if { [winfo exists $w.f_anim.f.f.fq.e_qual ] } {
            $w.f_anim.f.f.fq.e_qual configure -state disabled
        }
        $w.f_anim.e configure -state disabled       
        PostAnimateMPEGLeds DISABLED
        trace remove variable GidPriv(PostAnimateSavingAnimation) write PostAnimateTogleMPEGLeds
    }
}

proc PostAnimateColorizeDurationEntries {  } {
    # check if value in entry is a valid numeric value
    set lst_var [ list ::GidPriv(PostAnimateDelayTime) ::GidPriv(PostAnimateAnimationFileFPS)]
    set lst_w [ list $::GidPriv(PostAnimateDelayTimeEntry) $::GidPriv(PostAnimateFPSEntryWidget)]
    foreach v $lst_var w $lst_w {
        set color [ set ::ttk::theme::[gid_themes::GetTtkTheme]::colors(-colortext_fg)]
        set err [ catch {
            set i [ expr int( [ set $v] + 1.0)]
            if { [ set $v] <= 0} {
                set color red
            }
        } ]
        if { $err} {
            set color red
        }
        if { [ winfo exists $w]} {
            $w configure -foreground $color            
        }
    }
}

proc PostAnimateUpdateFPSLabel { new_delay_txt } {
    set fps 0
    set maxfps $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateSaveAnimationFormat),MaxFps)
    set err [ catch {
        scan $new_delay_txt "%g" new_delay
        if { $new_delay == 0} {
            set fps $maxfps
            after idle [ list PostAnimateUpdateDelayTimeLabel $maxfps]
        } else {
            set fps [ format %d [ expr int ( 0.5 + 1000.0 / $new_delay)]]
            if { $fps > $maxfps} {
                set fps $maxfps
                after idle [ list PostAnimateUpdateDelayTimeLabel $maxfps]
            }
        }
    }]
    if { $err || ( $fps < 0)} {
        set fps $::GidPriv(PostAnimateDefaultFPS)
        set ::GidPriv(PostAnimateAnimationFileFPS) ""
    } else {
        set ::GidPriv(PostAnimateAnimationFileFPS) $fps
    }
    PostAnimateColorizeDurationEntries
}

proc PostAnimateUpdateDelayTimeLabel { new_fps_txt } {
    set fps 0
    set err [ catch {
        scan $new_fps_txt "%d" new_fps
        set delay [ format %g [ expr 1000.0 / $new_fps]]
    } err_txt]
    if { $err || ( $delay < 0)} {
        set delay $::GidPriv(PostAnimateDefaultDelayTime)
        set ::GidPriv(PostAnimateDelayTime) ""
    } else {
        set ::GidPriv(PostAnimateDelayTime) $delay
    }
    PostAnimateColorizeDurationEntries
}

# name1 name2 op
proc PostAnimateCheckDelayTime { new_value_in } { 
    global GidPriv

    # set new_value $::GidPriv(PostAnimateDelayTime)
    set new_value $new_value_in

    if { $new_value == ""} {
        PostAnimateUpdateFPSLabel $new_value
        return 1
    }
    set len [string length $new_value]
    set cur_digit [ string index $new_value [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { 
        set maxfps $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateSaveAnimationFormat),MaxFps)
        if { $new_value < [expr 1000.0 / $maxfps] } {
            #do nothing, probably the edition is not completed 
            #e.g. writting 3 of 35 (otherwise the 3 will be changed by 5)
            #other option is replace -validate key by -validate focusout (to check it only when finish edit)
            return 1
        }
        PostAnimateUpdateFPSLabel $new_value
        return 1
    }
    if { ( $cur_digit == ".")} {
        PostAnimateUpdateFPSLabel $new_value
        return 1
    }
    # no need to validate e+123 e-123
    # if { ( $cur_digit == "e") || ( $cur_digit == "E") ||
    #     ( $cur_digit == "+") || ( $cur_digit == "-")} {
    #     PostAnimateUpdateFPSLabel $new_value
    #     return 1
    # }
    set val [string range $new_value 0 [expr $len-2]]
    set new_value $val
    PostAnimateUpdateFPSLabel $new_value
    return 0
}

proc PostAnimateCheckFPS { new_value_in } { 
    global GidPriv

    # set new_value $::GidPriv(PostAnimateAnimationFileFPS)
    set new_value $new_value_in
    if { $new_value == ""} {
        PostAnimateUpdateDelayTimeLabel $new_value
        return 1
    }
    set len [string length $new_value]
    if { $len > 0} {
        set maxfps $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateSaveAnimationFormat),MaxFps)
        if { $new_value > $maxfps} {
            set new_value $maxfps
            set ::GidPriv(PostAnimateAnimationFileFPS) $maxfps
        }
    }
    set cur_digit [ string index $new_value [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { 
        PostAnimateUpdateDelayTimeLabel $new_value
        return 1
    }
    # fps are integeres
    # if { ( $cur_digit == ".")} {
    #     PostAnimateUpdateDelayTimeLabel $new_value
    #     return 1
    # }
    # no need to validate e+123 e-123
    # if { ( $cur_digit == "e") || ( $cur_digit == "E") ||
    #     ( $cur_digit == "+") || ( $cur_digit == "-")} {
    #     PostAnimateUpdateDelayTimeLabel $new_value
    #     return 1
    # }
    set val [string range $new_value 0 [expr $len-2]]
    set new_value $val
    PostAnimateUpdateDelayTimeLabel $new_value
    return 0
}

proc PostAnimateCheckDurationTime { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PostAnimateWindow)
    set len [string length $::GidPriv(PostAnimateDurationTime)]
    set cur_digit [ string index $::GidPriv(PostAnimateDurationTime) [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { return}
    if { ( $cur_digit == "e") || ( $cur_digit == "E") ||
        ( $cur_digit == "+") || ( $cur_digit == "-") || ( $cur_digit == ".")} {
        return
    }
    set ::GidPriv(PostAnimateDurationTime) [ string range $::GidPriv(PostAnimateDurationTime) 0 [ expr $len-2]]
}

proc PostAnimateGetBitrateFromQuality { quality } {
    # quality should be between 0.0 and 100.0
    # as in ffmpeg-gid.cc
    lassign [ GidUtils::GetMainDrawAreaSize ] width height
    if { ( $width == 0) || ( $height == 0)} {
        set width 1280
        set height 720
    }

    # from quality we'll get the bitrate
    set min_bitrate_K 1000.0
    set max_bitrate_K_720p 20000.0   ; # for 1280 x 720
    # let's scale max_bitrate according to resolution:
    set max_bitrate_K [ expr  int( 0.5 + ( double($max_bitrate_K_720p) * double( $width * $height) / double( 1280.0 * 720.0)))]
    # use quadratic scale instead of linear:
    #  0 %   10 %   20 %   30 %   40 %    50 %    60 %    70 %    80 %    90 %   100 %
    # 1000   1190   1760   2710   4040    5750    7840   10310   13160   16390   20000 (1280x720)
    # 1000   1290   2160   3610   5640    8250   11440   15210   19560   24490   30000
    # 1000   1390   1560   4510   7240   10750   15040   20110   25960   32590   40000
    # 1000   1440   2760   4960   8040   12000   16840   22560   29160   36640   45000 (1920x1080)
    # quality is between 0...1000 and should be between 0% and 100%, i.e. between 0...1 
    set q2 [ expr $quality * $quality * 0.0001]
    set bitrate_K [ expr int( 0.5 + $q2 * double( $max_bitrate_K) + ( 1.0 - $q2) * double( $min_bitrate_K))]
    return $bitrate_K
}

proc PostAnimateUpdateBitrateLabel { quality} {
    set fps 0
    set bitrate ""
    set err [ catch {
        set bitrate [ PostAnimateGetBitrateFromQuality $quality]
    } err_txt]
    if { $err} {
        set bitrate --
    }
    set ::GidPriv(PostAnimateAnimationFileBitrate) "[ GidUtils::AddThousandsSeparator $bitrate] Kbps"
}

proc PostAnimateCheckQuality { new_value_in } { 
    global GidPriv

    set new_value $::GidPriv(PostAnimateAnimationFileQuality)
    set new_value $new_value_in

    if { $new_value == ""} {
        PostAnimateUpdateBitrateLabel $new_value
        return 1
    }
    set len [string length $new_value]
    set cur_digit [ string index $new_value [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { 
        PostAnimateUpdateBitrateLabel $new_value
        return 1
    }
    if { ( $cur_digit == ".")} {
        PostAnimateUpdateBitrateLabel $new_value
        return 1
    }
    set val [string range $new_value 0 [expr $len-2]]
    set new_value $val
    PostAnimateUpdateBitrateLabel $new_value
    return 0
}

proc PostAnimateCheckRangeFrame { { msg 1}} {
    global GidPriv
    set ok 0
    if { !$::GidPriv(PostAnimateRangeFrames)} { 
        return $ok
    }
    set w $::GidPriv(PostAnimateWindow)
    set end_step [ llength $::GidPriv(PostAnimate_all_step)]
    set ini_step 1
    if { $::GidPriv(PostAnimateDeform)} {
        set ini_step 0
    }
    # from
    if { [string is integer $::GidPriv(PostAnimateRangeFrameFrom)]} {
        if { ( $::GidPriv(PostAnimateRangeFrameFrom) >= $ini_step) && \
            ( $::GidPriv(PostAnimateRangeFrameFrom) <= $end_step)} {
            set ok 1
        }
    }
    if { !$ok} {
        set val_ant $::GidPriv(PostAnimateRangeFrameFrom)
        set ::GidPriv(PostAnimateRangeFrameFrom) $ini_step
        if { $msg} {
            WarnWin [ format [_ "Wrong initial step: '%s', should be between %d and %d."] \
                    $val_ant $ini_step $end_step]
        }
    }
    # to
    if { $ok} {
        set ok 0
        if { [string is integer $::GidPriv(PostAnimateRangeFrameTo)]} {
            if { ( $::GidPriv(PostAnimateRangeFrameTo) >= 0) && ( $::GidPriv(PostAnimateRangeFrameTo) <= $end_step)} {
                set ok 1
            }
        }
        if { !$ok} {
            set val_ant $::GidPriv(PostAnimateRangeFrameTo)
            set ::GidPriv(PostAnimateRangeFrameTo) $end_step
            if { $msg} {
                WarnWin [ format [_ "Wrong final step: '%s', should be between %d and %d."] \
                        $val_ant $ini_step $end_step]
            }
        }
    }
    # if from <= to
    if { $ok} {
        if { $::GidPriv(PostAnimateRangeFrameFrom) > $::GidPriv(PostAnimateRangeFrameTo)} {
            set ok 0
            set val_ant $::GidPriv(PostAnimateRangeFrameFrom)
            set ::GidPriv(PostAnimateRangeFrameFrom) $ini_step
            if { $msg} {
                WarnWin [ format [_ "Crosing steps %d > %d."] \
                        $::GidPriv(PostAnimateRangeFrameFrom) $::GidPriv(PostAnimateRangeFrameTo)]
            }
        }
    }
    update idletasks
    return $ok
}

proc PostAnimateDoingSlide { } {
    global GidPriv    
    if { $::GidPriv(PostAnimateSlideDelay)} {
        set ::GidPriv(PostAnimateSlideDelay) [ expr $::GidPriv(PostAnimateSlideDelay)-1]
        after 100 PostAnimateDoingSlide
    } else {
        set ::GidPriv(PostAnimateSlideDelay) 10
        if { $::GidPriv(PostAnimateDoing) == "Nothing"} {
            set oldskipframes $::GidPriv(PostAnimateRangeFrames)
            set old $::GidPriv(PostAnimateDefaultDelayTime)
            set old $::GidPriv(PostAnimateDefaultFPS)
            set old $::GidPriv(PostAnimateDefaultDurationTime)
            set oldsave $::GidPriv(PostAnimateSaveFrame)
            set oldsaveanim $::GidPriv(PostAnimateSaveAnimation)
            set ::GidPriv(PostAnimateRangeFrames) 0
            set ::GidPriv(PostAnimateDefaultDelayTime) 5
            set ::GidPriv(PostAnimateDefaultFPS) 200
            set ::GidPriv(PostAnimateDefaultDurationTime) 0
            set ::GidPriv(PostAnimateSaveFrame) 0
            set ::GidPriv(PostAnimateSaveAnimation) 0
            PostAnimatePlay "" 0
            PostAnimateStop ""
            set ::GidPriv(PostAnimateRangeFrames) $oldskipframes
            set ::GidPriv(PostAnimateSaveAnimation) $oldsaveanim
            set ::GidPriv(PostAnimateSaveFrame) $oldsave
            set ::GidPriv(PostAnimateDefaultDelayTime) $old
            set ::GidPriv(PostAnimateDefaultFPS) $old
            set ::GidPriv(PostAnimateDefaultDurationTime) $old
        }
        set ::GidPriv(PostAnimateSliding) 0
    }
}

proc PostAnimateChangeScale { frame} {
    global GidPriv
    if { $::GidPriv(PostAnimateInitializing)} { return}
    if { $::GidPriv(PostAnimateDoing) == "Nothing"} {
        set ::GidPriv(PostAnimateCurrentFrame) [ expr $frame-1]
        set ::GidPriv(PostAnimateSlideDelay) 10
        if { !$::GidPriv(PostAnimateSliding) } {
            after 100 PostAnimateDoingSlide
            set ::GidPriv(PostAnimateSliding) 1
        }
    }
}

proc PostAnimateCheckedDeform {} {
    global GidPriv    
    if { $::GidPriv(PostAnimateDeform) } {
        if { [GiD_Info postprocess get main_geom_state] != "Deformed" } {
            WarnWin [_ "Please choose a Main Deformation Visualization first."] $::GidPriv(PostAnimateWindow)
            set ::GidPriv(PostAnimateDeform) 0
            return
        }
    }
    PostAnimateConfigureSlide
}

proc PostAnimateCheckedContour {} {
    global GidPriv    
    regsub -all {_} $::GidPriv(PostAnimate_cur_result_view) {} pepe
    set ::GidPriv(PostAnimate_cur_result_view) $pepe
    if { $::GidPriv(PostAnimateResultView) == "" } {
        WarnWin [_ "Please choose a Results Visualization first."] $::GidPriv(PostAnimateWindow)
        set ::GidPriv(PostAnimateResultViewCb) 0
        return
    }    
    if { $::GidPriv(PostAnimateResultViewCb) } {        
        $::GidPriv(PostAnimateResButtons) configure -state normal        
    } else {
        $::GidPriv(PostAnimateResButtons) configure -state disabled
    }    
    PostAnimateConfigureSlide
}

proc PostAnimateCheckWhichAnimation {} {
    global GidPriv
    regsub -all {_} $::GidPriv(PostAnimate_cur_result_view) {} pepe
    set ::GidPriv(PostAnimate_cur_result_view) $pepe
    if { $::GidPriv(PostAnimateResultViewCb) && ( $::GidPriv(PostAnimateResultView) == "") } {
        WarnWin [_ "Please choose a Results Visualization first. Or check 'Results' out."] $::GidPriv(PostAnimateWindow)
        return 0
    }    
    return 1
}

proc PostAnimateChooseSavePrefix {} {
    global GidPriv
    set ::GidPriv(PostAnimateSaveFrame) 1
    if { $::GidPriv(PostAnimateSaveFrame) } {        
        if { $::GidPriv(PostAnimateSaveFrameFormat) == "PNG"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.png' files"]... {} {{{Png image} {.png}} {{All files} {.*}}} ".png" ]
            if { [ regexp -nocase {(.*).png$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } elseif { $::GidPriv(PostAnimateSaveFrameFormat) == "GIF"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.gif' files"]... {} {{{Gif image} {.gif}} {{All files} {.*}}} ".gif" ]
            if { [ regexp -nocase {(.*).gif$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } elseif { $::GidPriv(PostAnimateSaveFrameFormat) == "TIFF"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.tif' files"]... {} {{{Tif image} {.tif .tiff}} {{All files} {.*}}} ".tif" ]
            if { [ regexp -nocase {(.*).tif$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
            if { [ regexp -nocase {(.*).tiff$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } elseif { $::GidPriv(PostAnimateSaveFrameFormat) == "JPEG"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.jpg' files"]... {} {{{Jpg image} {.jpg .jpeg}} {{All files} {.*}}} ".jpg" ]
            if { [ regexp -nocase {(.*).jpg$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
            if { [ regexp -nocase {(.*).jpeg$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } elseif { $::GidPriv(PostAnimateSaveFrameFormat) == "PLY"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.ply' files"]... {} {{{PLY format} {.ply}} {{All files} {.*}}} ".ply" ]
            if { [ regexp -nocase {(.*).ply$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } elseif { $::GidPriv(PostAnimateSaveFrameFormat) == "STL"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.stl' files"]... {} {{{STL format} {.stl}} {{All files} {.*}}} ".stl" ]
            if { [ regexp -nocase {(.*).stl$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } elseif { $::GidPriv(PostAnimateSaveFrameFormat) == "OBJ"} {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.obj' files"]... {} {{{OBJ format} {.obj}} {{All files} {.*}}} ".obj" ]
            if { [ regexp -nocase {(.*).obj$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        } else {
            set ::GidPriv(PostAnimateSavePrefix) [MessageBoxGetFilename imagefile write [_ "Prefix for '*.png' files"]... {} {{{Png image} {.png}} {{All files} {.*}}} ".png" ]
            if { [ regexp -nocase {(.*).png$} $::GidPriv(PostAnimateSavePrefix) dum prefix]} {
                set ::GidPriv(PostAnimateSavePrefix) $prefix
            }
        }
    }
}

proc PostAnimateChooseAnimationFile {} {
    global GidPriv
    
    if { $::GidPriv(PostAnimateSaveAnimation) } {
        set new_ext $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateSaveAnimationFormat),Extension)
        set new_description $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateSaveAnimationFormat),Label)
        set ::GidPriv(PostAnimateSaveAnimationFile) \
            [ MessageBoxGetFilename imagefile write [_ "Save %s on" $new_description]... \
                  {} [ list [ list "$new_description animation" .$new_ext] {{All files} {.*}}] .$new_ext ]
        # switch [ PostAnimateProcessGIFOption $::GidPriv(PostAnimateSaveAnimationFormat)] {
        #     "MPEG" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save MPEG on"]... \
        #                 {} {{{Mpeg animation} {.mpg .mpeg}} {{All files} {.*}}} ".mpg" ]
        #     }
        #     "AVIMJPG" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" \
        #                 0 [ list {AVI/mjpg options} BrowserExtraCreateExportJPEG BrowserExtraGetExportJPEG]]
        #     }
        #     "AVIMSVC" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" \
        #                 0 [ list {AVI/msvc options} BrowserExtraCreateExportAviMSVC BrowserExtraGetExportAviMSVC]]
        #     }
        #     "AVI" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" ]
        #     }
        #     "AVI15" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" ]
        #     }
        #     "AVI16" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" ]
        #     }
        #     "GIF" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save GIF on"]... \
        #                 {} {{{GIF animation} {.gif}} {{All files} {.*}}} ".gif" \
        #                 0 [ list {GIF options} BrowserExtraCreateExportGIF BrowserExtraGetExportGIF] ]
        #     }
        #     "FLV" {
        #         set ::GidPriv(PostAnimateSaveAnimationFile) \
        #             [ MessageBoxGetFilename imagefile write [_ "Save Macromedia Flash Video on"]... \
        #                 {} {{{Macromedia Flash Video} {.flv}} {{All files} {.*}}} ".flv" \
        #                 0 {} ]
        #     }
        # }
    }
}

proc PostAnimateGetUsedLimits {} {
    return [ lindex [ GiD_Info postprocess get contour_limits] 0]
}

proc PostAnimateSetUsedLimits { limits } {
    if { [ lindex $limits 0] == "STD"} {
        GiD_Process Mescape Results ContOptions SetMinOptions ResetValue
    } else {
        GiD_Process Mescape Results ContOptions SetMinOptions SetValue [lindex $limits 1]
    }
    
    if { [ lindex $limits 2] == "STD"} {
        GiD_Process Mescape Results ContOptions SetMaxOptions ResetValue
    } else {
        GiD_Process Mescape Results ContOptions SetMaxOptions SetValue [lindex $limits 3]
    }
}

proc PostAnimatePushLimits {} {
    global GidPriv
    set ::GidPriv(PostAnimateSavedLimits) [lindex [GiD_Info postprocess get contour_limits] 0]
}

proc PostAnimatePopLimits {} {
    global GidPriv
    if { [ lindex $::GidPriv(PostAnimateSavedLimits) 0] == "STD"} {
        GiD_Process Mescape Results ContOptions SetMinOptions ResetValue
    } else {
        GiD_Process Mescape Results ContOptions SetMinOptions SetValue [lindex $::GidPriv(PostAnimateSavedLimits) 1]
    }
    
    if { [ lindex $::GidPriv(PostAnimateSavedLimits) 2] == "STD"} {
        GiD_Process Mescape Results ContOptions SetMaxOptions ResetValue
    } else {
        GiD_Process Mescape Results ContOptions SetMaxOptions SetValue [lindex $::GidPriv(PostAnimateSavedLimits) 3]
    }
}

proc PostAnimateGetAnalysisLimits { name1 name2 op} {
    global GidPriv    
    if { $::GidPriv(PostAnimateInitializing)} { return}
    if { $::GidPriv(PostAnimateResultViewCb) && $::GidPriv(PostAnimateAnalysisLimitsCb) } {
        PostAnimatePushLimits
        set ::GidPriv(PostAnimateInitializing) 1
        # if multiple results find limits of c.fill/lines/ranges
        if { $::GidPriv(PostAnimateVariosResultados)} {
            set ::GidPriv(PostAnimateOldAutoRedraw) [GiD_Set AutomaticRedraw]
            GiD_Set AutomaticRedraw -1
            GiD_Process Mescape Results Geometry NoResults Mescape
            # pintamos solo el c.fill para conseguir los limites
            foreach state_res $::GidPriv(PostAnimateListaResultados) {
                set resv [ string tolower [ lindex $state_res 1]]
                set res_name [ lindex $state_res 4]
                set res_comp [ lindex $state_res 5]
                set res_factor [ lindex $state_res 6]
                regsub -all { } $resv {} resv
                if { $resv == "contourfill" || $resv == "smoothcontourfill" || \
                    $resv == "contourlines" || $resv == "smoothcontourlines" || \
                        $resv == "contourranges" || $resv == "volumerender" } {
                    GiD_Process Mescape $resv $res_name $res_comp
                }
            }
        }
        GiD_Process Mescape Results ContOptions FixAnalysisLim
        set ::GidPriv(PostAnimateAnalysisLimits) [ lindex [ GiD_Info postprocess get contour_limits] 0]
        #devolvemos lo que estaba
        if { $::GidPriv(PostAnimateVariosResultados)} {
            GiD_Process Mescape Results Geometry NoResults Mescape
            if { $::GidPriv(PostAnimateResultViewCb) && $::GidPriv(PostAnimateResultView) != ""} {
                foreach state_res $::GidPriv(PostAnimateListaResultados) {
                    set resv [ string tolower [ lindex $state_res 1]]
                    set res_name [ lindex $state_res 4]
                    set res_comp [ lindex $state_res 5]
                    set res_factor [ lindex $state_res 6]
                    regsub -all { } $resv {} resv
                    if { $resv == "displayvectors"} {
                        GiD_Process Mescape Results $resv $res_name $res_comp $res_factor
                    } elseif { $resv == "scalarlinediagram"} {
                        GiD_Process Mescape Results LineDiagram ScalarDiagram $res_name $res_comp $res_factor
                    } elseif { $resv == "vectorlinediagram"} {
                        GiD_Process Mescape Results LineDiagram VectorDiagram $res_name $res_factor
                    } else {
                        GiD_Process Mescape Results $resv $res_name $res_comp
                    }
                }
            }
            GiD_Set AutomaticRedraw $::GidPriv(PostAnimateOldAutoRedraw)
        }
        PostAnimatePopLimits
        set ::GidPriv(PostAnimateInitializing) 0
    }
}

proc PostAnimateSetAnalysisLimits {} {
    global GidPriv
    GiD_Process Mescape Results ContOptions SetMinOptions SetValue [lindex $::GidPriv(PostAnimateAnalysisLimits) 1]
    GiD_Process Mescape Results ContOptions SetMaxOptions SetValue [lindex $::GidPriv(PostAnimateAnalysisLimits) 3]
}

# this func is necessary to avoid the warning when going from pre to post
proc PostAnimateWindowCheckingModel { { w .gid.wPostAnimate } { do_withdraw 0} } {
    set mm [GiD_Info postprocess get all_volumesets]
    set ss [GiD_Info postprocess get all_surfacesets]
    if { ( $mm == "") && ( $ss == "") } {
        set w .gid
        if { [info exists GidPriv(PostAnimateWindow)] && [winfo exists $::GidPriv(PostAnimateWindow)]} {
            set w $::GidPriv(PostAnimateWindow)
        }
        WarnWin [_ "Please load a model first."] $w
        return
    }
    PostAnimateWindow $w $do_withdraw
}

proc PostAnimateResize { } {
    global GidPriv
    set info [ wm geometry .gid]
    lassign [ GidUtils::GetMainDrawAreaSize ] act_width act_height
    if { ![ regexp {([0-9]*)x([0-9]*)} $info trozo top_width top_height] } {
        return
    }
    set width_offset [ expr $top_width - $act_width]
    set height_offset [ expr $top_height - $act_height]
    if { $::GidPriv(PostAnimateResize) == "Default"} {
        set ::GidPriv(PostAnimateResize) $::GidPriv(PostAnimateResizeDefault)
    }
    if { ![ regexp {([0-9]*)x([0-9]*)} $::GidPriv(PostAnimateResize) trozo new_width new_height] } {
        return
    }
    # 768x576 640x480 512x384 320x240
    wm geometry .gid [ expr $width_offset + $new_width]x[ expr $height_offset + $new_height]
}

proc PostAnimateCreateStaticAnimationProfile { } {
    global SingleStepAnimation
    if { $::GidPriv(PostAnimateDeform) } {
        if { ![info exists ::SingleStepAnimation(deformation_factor)]} {
            set ::SingleStepAnimation(deformation_factor) $::GidPriv(PostAnimate_cur_d_factor)
        }
        if { ![string is double -strict $::SingleStepAnimation(deformation_factor)] } {
            set ::SingleStepAnimation(deformation_factor) 1.0
        }
        PostAnimateSingleStepAnimationCreateFactors $::SingleStepAnimation(deformation_factor)
    }
}

proc PostAnimateOnChangeStaticProfile { } {
    PostAnimateCreateStaticAnimationProfile
    PostAnimateConfigureSlide
}

proc PostAnimateOnChangeStaticNumSteps { name1 name2 op } {
    if { ![string is integer -strict $::SingleStepAnimation(num_steps)] || $::SingleStepAnimation(num_steps)<2 } {
        return 1
    }
    PostAnimateCreateStaticAnimationProfile
    PostAnimateConfigureSlide
    return 0
}

proc PostAnimateOnChangeStaticFactor { name1 name2 op } {
    if { ![string is double -strict $::SingleStepAnimation(deformation_factor)] } {
        return 1
    }
    PostAnimateCreateStaticAnimationProfile
    PostAnimateConfigureSlide
    return 0
}

proc PostAnimateDoStep { { disable_gui_updates 1} { enable_gui_updates 1}} {
    # check if window is open
    if { [ winfo exists $::GidPriv(PostAnimateButtonFrame).step]} {
        PostAnimateStep $::GidPriv(PostAnimateButtonFrame).step $disable_gui_updates $enable_gui_updates
    }
}

proc CheckCreateStereoscopicAnimation {} {
    global GidPriv
    if { $::GidPriv(PostAnimateDoing) != "Animate" } {
        GiD_Set PostDoStereoAnimation $::GidPriv(PostDoStereoAnimation)
    }
}

proc PostAnimateFillComboWithCorrectWindowSizes { w} {
    set labels_all [ list [_ "Default"] \
            "1920x1200" "1920x1080 HD" "1680x1050" "1680x945" \
            "1440x900" "1440x810" "1366x768" \
            "1280x1024" "1280x800" "1280x768" "1280x720 HD" \
            "1024x768" "1024x640" "1024x600" "1024x576" \
            "800x600" "720x576" "640x480" "512x384" "352x288" "320x240"]
    set values_all [ list Default \
            1920x1200 1920x1080 1680x1050 1680x945 \
            1440x900 1440x810 1366x768 \
            1280x1024 1280x800 1280x768 1280x720 \
            1024x768 1024x640 1024x600 1024x576 \
            800x600 720x576 640x480 512x384 352x288 320x240]
    # experimental settings....
    set gui_margin_width 210
    set gui_margin_height 220
    set max_width [ expr [ winfo vrootwidth .] - $gui_margin_width]
    set max_height [ expr [ winfo vrootheight .] - $gui_margin_height]
    set combo_labels {}
    set combo_values {}
    foreach txt $labels_all resol $values_all {
        if { [ regexp {^([0-9]+)x([0-9]+)$} $resol dum width height] == 1} {
            # check if resolution fits in screen
            if { ( $width > $max_width) || ( $height > $max_height)} {
                # do not append resolution to list
                continue
            }
        }
        # append resolution
        lappend combo_labels $txt
        lappend combo_values $resol
    }
    $w configure -labels $combo_labels -values $combo_values
}

proc PostAnimateIconBarPlay { w_button } {
    PostAnimatePlay $w_button
    set ::GidPriv(PostAnimateEndless) 1
    set ::GidPriv(GiD_Event_BeforeEndGIDPostProcess,w_button) $w_button
}

proc PostAnimateIconBarPause { w_button } {
    global PostAnimatePriv
    PostAnimateStop $w_button
    set ::GidPriv(PostAnimateEndless) 0
    # not needed anymore if launched by us
    if { !$::PostAnimatePriv(UserWindowExists) } {
        set w .gid.wPostAnimate
        PostAnimateCloseWindow $w
    }
}

proc PostAnimateIconBarTogglePlayPause { w_button} {
    global PostAnimatePriv
    # initialize window 
    set w .gid.wPostAnimate
    if { ![ winfo exists $w]} {
        PostAnimateWindowCheckingModel $w 1
        # launched by us
        set ::PostAnimatePriv(UserWindowExists) 0
        if { ![winfo exists $w] } {
            return     
        }
    }
    # now do play/pause:
    PostAnimateTogglePlayPause $w_button PostAnimateIconBarPlay PostAnimateIconBarPause
}

proc PostAnimateTogglePlayPause { w_button cmd_play cmd_pause} {
    global PostAnimatePriv
    if { [GiD_Info postprocess get cur_analysis] == "" } {
        #there is no results to animate
        return
    }
    set actual_state pause
    if { [info exists ::PostAnimatePriv(PlayPauseButtonState)] && $::PostAnimatePriv(PlayPauseButtonState) == "play" } {
        set actual_state play
    }    
    set pause_image_file stop.png
    if { $::GidPriv(EnableAnimationInIconBar)} {
        # if enabled then there is the 'pause' icon file
        set pause_image_file pause.png
    }    
    if { $actual_state == "pause"} {
        # action = play = next state
        $w_button configure -image [ gid_themes::GetImage $pause_image_file medium_icons]
        set ::PostAnimatePriv(PlayPauseButtonState) play
        $cmd_play $w_button
    } else {
        # action = pause = next state
        $w_button configure -image [ gid_themes::GetImage play.png medium_icons]
        set ::PostAnimatePriv(PlayPauseButtonState) pause
        $cmd_pause $w_button
    }
}

proc PostAnimateCloseWindow { w } {
    global PostAnimatePriv
    # patch: make sure we can still work with GiD
    PostAnimateEnableGUIUpdates
    if { $::DO_HARMONIC_ANIMATION_IN_TCL } {        
        #delete temporary results created for the harmonic deformation of a complex vector
        PostAnimateHarmonicGoBack $w
    }
    set ::PostAnimatePriv(UserWindowExists) 0
    destroy $w
}

proc PostAnimateOnChangeSingleStepSelected { } {
    # look if deformation vector is in current step
    global SingleStepAnimation
    set new_step $::SingleStepAnimation(step_selected)
    set new_deformation_list [GiD_Info postprocess get show_geom_all_deform $::GidPriv(PostAnimate_cur_d_anal) $new_step]
    if { [lsearch $new_deformation_list $::GidPriv(PostAnimate_cur_d_defor)] != -1 } {
        GiD_Process Mescape Results AnalysisSel $::GidPriv(PostAnimate_cur_d_anal) $new_step escape
        # and redo deformation:
        if { [GiD_Info postprocess get main_geom_state] == "Deformed" } {
            set current_deformation_result [ GiD_Info postprocess get main_geom_cur_deform]
            set current_deformation_factor [GiD_Info postprocess get main_geom_cur_factor]
            GiD_Process Mescape Results Geometry Deformation $current_deformation_result $current_deformation_factor escape escape escape escape
        }
    } else {
        if { $::GidPriv(PostAnimate_cur_d_step) != "" } {
            set ::SingleStepAnimation(step_selected) $::GidPriv(PostAnimate_cur_d_step)
            WarnWin [_ "Current deformation vector ( %s ) \nis not present in new selected step: %s.\nUsing previous one ( %s )." \
                    $::GidPriv(PostAnimate_cur_d_defor) $new_step $::GidPriv(PostAnimate_cur_d_step)]
        }
    }
}

namespace eval ViewFollowsNode {
    variable _enabled        0
    variable _node2follow   -1
    variable _lst_w_options {}
}

proc ViewFollowsNode::EnableDisableOptions { } {
    variable _enabled
    variable _node2follow
    variable _lst_w_options
    set state normal
    set color black
    if { !$_enabled} {
        set state disabled
        set color grey
    }
    foreach w $_lst_w_options {
        $w configure -state $state
    }
}

proc ViewFollowsNode::FillValuesFromGiD { } {
    variable _enabled
    variable _node2follow
    array set tmp [ GiD_Info postprocess get view_follows_node_options]
    set _enabled $tmp(ViewFollowsNode)
    set _node2follow $tmp(ViewNodeToFollow)
    if { $_node2follow == -1} {
        set _node2follow ""
    }
}

proc ViewFollowsNode::PickNode2Follow { } {
    variable _node2follow
    set _node2follow [ GidUtils::PickEntities Nodes single [_ "Enter a node to be followed and centered."]]
}

proc ViewFollowsNode::Enable { } {
    variable _enabled
    variable _node2follow
    if { $_enabled} {
        GiD_Process Mescape View AnimationFile ViewFollowsNode yes escape escape escape escape
        GiD_Process Mescape View AnimationFile ViewNodeToFollow $_node2follow escape escape escape escape
    }
}

proc ViewFollowsNode::Disable { } {
    variable _enabled
    variable _node2follow
    
    if { $_enabled} {
        GiD_Process Mescape View AnimationFile ViewFollowsNode no escape escape escape escape
    }
}

proc ViewFollowsNode::Create { parent} {
    variable _enabled
    variable _node2follow
    variable _lst_w_options
    set w $parent
    set f [ ttk::frame $w.f -borderwidth 0]
    ttk::checkbutton $f.cb -text [_ "View centered and following node:"] \
        -variable ViewFollowsNode::_enabled \
        -command ViewFollowsNode::EnableDisableOptions
    ttk::entry $f.en -width 3 -textvariable ViewFollowsNode::_node2follow
    ttk::button $f.bt -text [_ "Pick node"] -command ViewFollowsNode::PickNode2Follow
    set _lst_w_options [ list $f.en $f.bt ]
    grid $f.cb $f.en $f.bt -sticky ew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f {0 1 2} -weight 1        
    FillValuesFromGiD
    EnableDisableOptions
    return $f
}

proc PostAnimateWindow { { w .gid.wPostAnimate } { do_withdraw 0} } {
    global GidPriv SingleStepAnimation
    global PostAnimatePriv
    if { [winfo exists $w]} {
        raise $w
        return
    }
    PostAnimateRemoveTraces
    set mm [GiD_Info postprocess get all_volumesets]
    set ss [GiD_Info postprocess get all_surfacesets]
    if { ( $mm == "") && ( $ss == "") } {
        return
    }
    set ::GidPriv(PostAnimateInitializing) 1
    PostAnimateInitValues
    InitWindow2 $w -title [_ "Animate"] \
        -geometryvariable PostAnimateWindowGeom -initcommand PostAnimateWindow
    if { ![winfo exists $w] } {
        return
    }
    set ::GidPriv(PostAnimateWindow) $w
    # when opened as hidden ... like from the IconBar
    if { $do_withdraw} {
        wm withdraw $w
    }
    ttk::labelframe $w.f_prof -text [_ "Deformation animation profile"]
    ttk::radiobutton $w.f_prof.rd_all_steps -text [_ "All steps"] \
        -value AllSteps -variable ::GidPriv(PostAnimateProfileType) \
        -command PostAnimateSelectAllStepAnimation
    ttk::radiobutton $w.f_prof.rd_single_step -text [_ "Single step"] \
        -value SingleStep -variable ::GidPriv(PostAnimateProfileType) \
        -command PostAnimateSelectSingleStepAnimation   
    setTooltip [list $w.f_prof.rd_all_steps $w.f_prof.rd_single_step] [_ "The animation of the deformation of the model should be done:\n\
            -through all steps\n
            -within a single step, the deformation will follow the selected profile varying the scale factor"]
    set current_deformation_analysis [GiD_Info postprocess get main_geom_cur_analysis]
    set all_deformation_steps ""
    if { $current_deformation_analysis != "" } {
        set all_deformation_steps [GiD_Info postprocess get all_steps $current_deformation_analysis]
    } else {
        set all_deformation_steps [list]
    }
    set ::SingleStepAnimation(StepCombox) [TTKComboBox $w.f_prof.mb_single_step \
            -textvariable ::SingleStepAnimation(step_selected) -values $all_deformation_steps \
            -width 10 -state readonly -modifycmd PostAnimateOnChangeSingleStepSelected]
    GidHelp $w.f_prof.mb_single_step [_ "Set the step to do pseudo-animaton (varying the scale along the animation)"]    
    set values [list Lineal Sinus Triangular Sinusoidal]
    #set labels [list [_ "Lineal"] [_ "Sinus"] [_ "Triangular"] [_ "Sinusoidal"]]
    set labels [list " " " " " " " "]
    set images [list]
    foreach value $values {
        lappend images [gid_themes::GetImage StaticAnim$value.png medium_icons]
    }
    set ::SingleStepAnimation(ProfileMenuButton) [TTKMenubutton $w.f_prof.static -labels $labels -values $values -images $images \
            -textvariable ::SingleStepAnimation(profile) -modifycmd PostAnimateOnChangeStaticProfile -compound none -width 0]
    setTooltip $w.f_prof.static [_ "Configures the behaviour of the pseudo-animation\n of the deformation for a single step."]    
    ttk::frame $w.f_prof.fParameters
    ttk::label $w.f_prof.fParameters.l1 -text [_ "Num steps"]:
    set ::SingleStepAnimation(NumStepsEntry) [ttk::entry $w.f_prof.fParameters.e1 -textvariable ::SingleStepAnimation(num_steps) -width 3]
    setTooltip [list $w.f_prof.fParameters.l1 $w.f_prof.fParameters.e1] [_ "Number of pseudo-steps for the static animation"]
    ttk::label $w.f_prof.fParameters.l2 -text [_ "Factor"]:
    set ::SingleStepAnimation(FactorEntry) [ttk::entry $w.f_prof.fParameters.e2 -textvariable ::SingleStepAnimation(deformation_factor) -width 10]
    setTooltip [list $w.f_prof.fParameters.l2 $w.f_prof.fParameters.e2] [_ "Maximum deformation factor"]    
    grid $w.f_prof.rd_all_steps -sticky w -columnspan 4    
    grid $w.f_prof.fParameters.l1 $w.f_prof.fParameters.e1 $w.f_prof.fParameters.l2 $w.f_prof.fParameters.e2 -sticky w
    grid configure $w.f_prof.fParameters.e1 $w.f_prof.fParameters.e2 -sticky ew
    grid columnconfigure $w.f_prof.fParameters {3} -weight 1
    grid $w.f_prof.rd_single_step $w.f_prof.mb_single_step $w.f_prof.static $w.f_prof.fParameters -sticky w 
    grid configure $w.f_prof.mb_single_step $w.f_prof.fParameters -sticky ew 
    grid rowconfigure $w.f_prof {0 1} -weight 1
    grid columnconfigure $w.f_prof {1 3} -weight 1       
    ttk::labelframe $w.f_opt -text [_ "Options"]    
    ttk::frame $w.f_opt.res -borderwidth 0
    if { ![info exists GidPriv(PostAnimateResultViewCb)] } { set ::GidPriv(PostAnimateResultViewCb) 0 }
    ttk::checkbutton $w.f_opt.res.cb1 -text [_ "Results View"] -variable GidPriv(PostAnimateResultViewCb) -command PostAnimateCheckedContour
    GidHelp $w.f_opt.res.cb1 [_ "The result view evolution is shown. \nNOTE: the results view should be selected previously."]    
    if { ![info exists GidPriv(PostAnimateAnalysisLimitsCb)] } { set ::GidPriv(PostAnimateAnalysisLimitsCb) 0 }
    ttk::checkbutton $w.f_opt.res.automatic_limits -text [_ "Automatic Limits"] -variable GidPriv(PostAnimateAnalysisLimitsCb)    
    GidHelp $w.f_opt.res.automatic_limits [_ "The limits of the results view will be the same for the whole animation."]    
    $w.f_opt.res.automatic_limits configure -state disabled
    set ::GidPriv(PostAnimateResButtons) $w.f_opt.res.automatic_limits        
    grid $w.f_opt.res.cb1 $w.f_opt.res.automatic_limits -sticky w
    grid columnconfigure $w.f_opt.res 1 -weight 1
    if { ![info exists GidPriv(PostAnimateDeform)] } { set ::GidPriv(PostAnimateDeform) 0 }
    ttk::checkbutton $w.f_opt.cb2 -text [_ "Deformation"] -variable GidPriv(PostAnimateDeform) -command PostAnimateCheckedDeform
    if { ![info exists GidPriv(PostAnimateEndless)] } { set ::GidPriv(PostAnimateEndless) 0 }
    ttk::checkbutton $w.f_opt.cb3 -text [_ "Endless"] -variable GidPriv(PostAnimateEndless)
    GidHelp $w.f_opt.cb2 [_ "The evolution of the deformation is shown. \n\
            NOTE: to use this option, the model should be deformed previously."]
    GidHelp $w.f_opt.cb3 [_ "After pressing the 'Play' button, the \
            animation will not stop. \nNOTE: if the animation is saved, the entire disk may be filled."]
    ttk::frame $w.f_opt.f_rangefr
    if { ![info exists GidPriv(PostAnimateRangeFrames)] } { set ::GidPriv(PostAnimateRangeFrames) 0 }
    ttk::checkbutton $w.f_opt.f_rangefr.cb -text [_ "From step"] -variable GidPriv(PostAnimateRangeFrames)
    ttk::entry $w.f_opt.f_rangefr.ef -width 5 -textvariable GidPriv(PostAnimateRangeFrameFrom) \
        -validate focus -validatecommand PostAnimateCheckRangeFrame    
    ttk::label $w.f_opt.f_rangefr.lt -text [_ "to step"]
    ttk::entry $w.f_opt.f_rangefr.et -width 5 -textvariable GidPriv(PostAnimateRangeFrameTo) \
        -validate focus -validatecommand PostAnimateCheckRangeFrame      
    $w.f_opt.f_rangefr.ef configure -state disabled   
    $w.f_opt.f_rangefr.et configure -state disabled  
    grid $w.f_opt.f_rangefr.cb $w.f_opt.f_rangefr.ef $w.f_opt.f_rangefr.lt $w.f_opt.f_rangefr.et -sticky w
    GidHelp $w.f_opt.f_rangefr [_ "With this option the first N steps will be skiped."]
    set f_follow_view [ ViewFollowsNode::Create $w.f_opt]
    grid $w.f_opt.res -sticky we
    grid $w.f_opt.cb2 -sticky w
    grid $w.f_opt.cb3 -sticky w
    grid $w.f_opt.f_rangefr -sticky w
    grid $f_follow_view -sticky we
    grid rowconfigure $w.f_opt {0 1 2 3 4} -weight 1
    grid columnconfigure $w.f_opt 0 -weight 1

    set f_movement [ ModelSimpleAnimations::Create $w.f_opt]
    grid $f_movement -sticky we
    grid rowconfigure $w.f_opt 5 -weight 1

    ttk::labelframe $w.f_dur -text [_ "Duration"]
    ttk::frame $w.f_dur.dur
    ttk::radiobutton $w.f_dur.dur.cb -text [_ "Total time"]: -value TotalTime -variable GidPriv(PostAnimateDurationType)
    ttk::entry $w.f_dur.dur.e -width 5 -textvariable GidPriv(PostAnimateDurationTime)    
    $w.f_dur.dur.e configure -state disabled  
    ttk::label $w.f_dur.dur.l -text [_ "s."]
    grid $w.f_dur.dur.cb $w.f_dur.dur.e $w.f_dur.dur.l -sticky w
    GidHelp $w.f_dur.dur [_ "With this option the duration of the animation will be set with the entered seconds."]
    ttk::frame $w.f_dur.f_sca
    if { ![info exists GidPriv(PostAnimateUseScaledStepvalues)] } { set ::GidPriv(PostAnimateUseScaledStepvalues) 0 }
    ttk::checkbutton $w.f_dur.f_sca.cb -text [_ "use step values as scaled delays"] \
        -variable GidPriv(PostAnimateUseScaledStepvalues) \
        -command CheckPostAnimateDurationWStep
    grid $w.f_dur.f_sca.cb -sticky we
    GidHelp $w.f_dur.f_sca [_ "With this option the duration of the animation will be scaled with the step values."]
    ttk::frame $w.f_dur.f_del
    ttk::radiobutton $w.f_dur.f_del.cb -text [_ "Delay between steps"]: -value Delay -variable GidPriv(PostAnimateDurationType)
    ttk::entry $w.f_dur.f_del.e -width 5 -textvariable ::GidPriv(PostAnimateDelayTime) \
        -validate key -validatecommand "PostAnimateCheckDelayTime %P"
    set ::GidPriv(PostAnimateDelayTimeEntry) $w.f_dur.f_del.e
    ttk::label $w.f_dur.f_del.l -text " ms."
    ttk::label $w.f_dur.f_del.lsep -text "/"
    ttk::label $w.f_dur.f_del.lfps -text "fps:"
    ttk::entry $w.f_dur.f_del.efps -width 5 -textvariable ::GidPriv(PostAnimateAnimationFileFPS) \
        -validate key -validatecommand "PostAnimateCheckFPS %P"
    set ::GidPriv(PostAnimateFPSEntryWidget) $w.f_dur.f_del.efps
    PostAnimateUpdateFPSLabel $::GidPriv(PostAnimateDelayTime)

    grid $w.f_dur.f_del.cb $w.f_dur.f_del.e $w.f_dur.f_del.l \
        $w.f_dur.f_del.lsep $w.f_dur.f_del.lfps $w.f_dur.f_del.efps \
        -ipadx 4 -sticky w 
    GidHelp $w.f_dur.f_del [_ "With this option a DelayTime of the entered milliseconds will be used between frames ( 40ms = @25 fps)."]
    ttk::radiobutton $w.f_dur.cb4 -text [_ "Use step values as seconds"]  -value StepValue -variable GidPriv(PostAnimateDurationType)   
    grid $w.f_dur.dur $w.f_dur.f_sca -sticky w
    grid $w.f_dur.f_del -sticky w -columnspan 2
    grid $w.f_dur.cb4 -sticky w -columnspan 2
    grid rowconfigure $w.f_dur {0 1 2} -weight 1    
    grid columnconfigure $w.f_dur {0 1} -weight 1    
    # los controles  
    ttk::labelframe $w.f_ctr -text [_ "Play"]
    # el chivato
    ttk::frame $w.f_ctr.f1
    ttk::label $w.f_ctr.f1.l -text [_ "Step number"]:
    set ::GidPriv(PostAnimateStepNumberEntry) [ttk::entry $w.f_ctr.f1.e -width 6 -state disabled]
    ttk::label $w.f_ctr.f1.lv -text [_ "Step value"]:
    set ::GidPriv(PostAnimateStepValueEntry) [ttk::entry $w.f_ctr.f1.ev -width 10 -state disabled]
    set ::GidPriv(PostAnimateFileSizeLabel) [ttk::label $w.f_ctr.f1.l2 -textvariable GidPriv(PostAnimateFileSize)]
    grid $w.f_ctr.f1.l $w.f_ctr.f1.e $w.f_ctr.f1.lv $w.f_ctr.f1.ev $w.f_ctr.f1.l2 -sticky w    
    grid configure $w.f_ctr.f1.l2 -sticky ew
    grid rowconfigure $w.f_ctr.f1 0 -weight 1
    grid columnconfigure $w.f_ctr.f1 {4} -weight 1
    set ::GidPriv(PostAnimateSlide) [gidscale $w.f_ctr.b -orient h -from 1 -to 2 -showbuttons 1 -symbolbuttons "< >" -command PostAnimateChangeScale]    
    set ::GidPriv(PostAnimateButtonFrame) [ttk::frame $w.f_ctr.f2]
    ttk::button $w.f_ctr.f2.rewind -image [gid_themes::GetImage rewind.png medium_icons] -command [list PostAnimateRewind $w.f_ctr.f2.rewind]
    ttk::button $w.f_ctr.f2.play -image [gid_themes::GetImage play.png medium_icons] -command [list PostAnimatePlay $w.f_ctr.f2.play]
    ttk::button $w.f_ctr.f2.stop -image [gid_themes::GetImage stop.png medium_icons] -command [list PostAnimateStop $w.f_ctr.f2.stop]
    set ::PostAnimatePriv(TogglePlayPauseWindowButton) [ttk::button $w.f_ctr.f2.play_pause -image [gid_themes::GetImage play.png medium_icons] \
        -command [list PostAnimateTogglePlayPause $w.f_ctr.f2.play_pause PostAnimatePlay PostAnimateStop]]    
    ttk::button $w.f_ctr.f2.step -image [gid_themes::GetImage skipforward.png medium_icons] -command [list PostAnimateDoStep 0 1]
    grid $w.f_ctr.f2.rewind $w.f_ctr.f2.play_pause $w.f_ctr.f2.step -padx 2 -pady 2 -sticky w
    grid $w.f_ctr.f1 -sticky we
    grid $w.f_ctr.b -sticky we    
    grid columnconfigure $w.f_ctr.f2 {0 1 2} -weight 1
    grid $w.f_ctr.f2
    grid rowconfigure $w.f_ctr {0 1 2} -weight 1    
    grid columnconfigure $w.f_ctr {0} -weight 1    
    ttk::labelframe $w.f_save -text [_ "Save image"]
    ttk::frame $w.f_save.f
    ttk::frame $w.f_save.f.f -borderwidth 0
    if { ![info exists GidPriv(PostAnimateSaveFrame)] } { set ::GidPriv(PostAnimateSaveFrame) 0 }
    ttk::checkbutton $w.f_save.f.f.cb -text [_ "Save"] -variable GidPriv(PostAnimateSaveFrame)
    TTKComboBox $w.f_save.f.f.mb -textvariable ::GidPriv(PostAnimateSaveFrameFormat) \
        -labels [list "PNG" "TIFF" "JPEG" "GIF" "PLY" "STL" "OBJ"] -values {PNG TIFF JPEG GIF PLY STL OBJ} \
        -width 10 -state readonly
    ttk::label $w.f_save.f.f.l -text [_ "on"]
    grid $w.f_save.f.f.cb $w.f_save.f.f.mb $w.f_save.f.f.l -padx 0 -ipadx 0 -pady 0 -ipady 0 -sticky nsew
    ttk::button $w.f_save.f.b  -image [gid_themes::GetImage "folder.png" small_icons] -command PostAnimateChooseSavePrefix    
    grid $w.f_save.f.f -sticky w
    grid $w.f_save.f.b -row 0 -column 1 -sticky ne
    ttk::entry $w.f_save.e -width 5 -state disabled -textvariable GidPriv(PostAnimateSavePrefix)
    grid $w.f_save.f -sticky w
    grid $w.f_save.e -sticky we
    grid rowconfigure $w.f_save {0 1} -weight 1
    grid columnconfigure $w.f_save 0 -weight 1        
    GidHelp $w.f_save.f.f.cb [_ "Check here to create an image sequence"]
    GidHelp $w.f_save.e [_ "To create a image sequence, the prefix of the images names must be entered here.\nImage names will be of the form Prefix-XX.ext"]
    GidHelp $w.f_save.f.f.mb [_ "Choose the file format of the image sequence."]
    GidHelp $w.f_save.f.b [_ "A file browser will be openned, so a file can be selected."]    
    ttk::labelframe $w.f_anim -text [_ "Save animation"]
    ttk::frame $w.f_anim.f    
    ttk::frame $w.f_anim.f.f -borderwidth 0
    if { ![info exists ::GidPriv(PostDoStereoAnimation)] } { set ::GidPriv(PostDoStereoAnimation) 0 }
    ttk::checkbutton $w.f_anim.f.f.cb_stereo -text [_ "Create a stereoscopic animation"] \
        -variable ::GidPriv(PostDoStereoAnimation) -command CheckCreateStereoscopicAnimation
    if { ![info exists GidPriv(PostAnimateSaveAnimation)] } { set ::GidPriv(PostAnimateSaveAnimation) 0 }
    ttk::checkbutton $w.f_anim.f.f.cb -text [_ "Save"] -variable GidPriv(PostAnimateSaveAnimation)
    TTKComboBox $w.f_anim.f.f.mb -textvariable ::GidPriv(PostAnimateSaveAnimationFormat) \
        -labels $::GidPriv(PostAnimateShowVideoFormatLabels) \
        -values $::GidPriv(PostAnimateShowVideoFormats) \
        -modifycmd PostAnimateChangeExtension \
        -width 26 -state readonly
    ttk::label $w.f_anim.f.f.l -text [_ "on"]


    ttk::frame $w.f_anim.f.f.fq -borderwidth 0
    ttk::label $w.f_anim.f.f.fq.l_qual -text [_ "Quality:"]
    ttk::entry $w.f_anim.f.f.fq.e_qual -width 5 -state disabled -textvariable ::GidPriv(PostAnimateAnimationFileQuality) \
        -validate key -validatecommand "PostAnimateCheckQuality %P"
    ttk::label $w.f_anim.f.f.fq.l_bitrate -textvariable ::GidPriv(PostAnimateAnimationFileBitrate)
    PostAnimateUpdateBitrateLabel $::GidPriv(PostAnimateAnimationFileQuality)

    grid $w.f_anim.f.f.fq.l_qual -row 0 -column 4 -sticky w -padx 2
    grid $w.f_anim.f.f.fq.e_qual -row 0 -column 5 -sticky w -padx 2
    grid $w.f_anim.f.f.fq.l_bitrate -row 0 -column 6 -sticky w -padx 2


    grid $w.f_anim.f.f.cb $w.f_anim.f.f.mb $w.f_anim.f.f.l -padx 0 -ipadx 0 -pady 0 -ipady 0 -sticky nsew

    grid $w.f_anim.f.f.fq -columnspan 3 -stick w -pady 0 -ipady 0

    grid $w.f_anim.f.f.cb_stereo -columnspan 3 -stick w -pady 0 -ipady 0
    PostAnimateIfStereoDisableForceCb $w.f_anim.f.f.cb_stereo
    # to actualize the checkbutton
    set ::GidPriv(PostDoStereoAnimation) $::GidPriv(PostDoStereoAnimation)
    ttk::button $w.f_anim.f.b -image [gid_themes::GetImage "folder.png" toolbar] -command PostAnimateChooseAnimationFile
    set img_size [ gid_themes::GetImageSize toolbar]
    # same borderwidth as buttons
    canvas $w.f_anim.f.cv -width $img_size -height $img_size -borderwidth 4 -relief flat
    set led_libre [ $w.f_anim.f.cv create oval 6 6 $img_size $img_size -fill grey60]   
    set ::GidPriv(PostAnimateMPEG_led_libre) $led_libre  
    PostAnimateMPEGLeds DISABLED
    GidHelp $w.f_anim.f.cv [_ "Animation status leds:\n\
            Green: no animation is being done, \n\
            the animation file is closed.\n\
            Red:   The program is storing frames ( added \n\
            by the user, or storing redraws)\n\
            in an opened animation file."]
    ttk::button $w.f_anim.f.bch -image [ gid_themes::GetImage "create_batch.png" toolbar] \
        -command [ list CreateAnimationBatch $w]      
    setTooltip $w.f_anim.f.bch -text [_ "Herewith a batch file can be saved \n\
            to create the animation int batch mode, \n\
            using %s in offscreen mode." $::GidPriv(ProgName,Default)]

    grid $w.f_anim.f.f -sticky w
    grid $w.f_anim.f.b -row 0 -column 1 -sticky en
    grid $w.f_anim.f.cv -row 0 -column 2 -sticky en -padx 2
    grid $w.f_anim.f.bch -row 0 -column 3 -sticky wn -padx 2

    if { ![info exists ::GidPriv(PostAnimateSaveAnimationFile)] } {
        set ::GidPriv(PostAnimateSaveAnimationFile) ""
    }
    ttk::entry $w.f_anim.e -width 5 -state disabled -textvariable ::GidPriv(PostAnimateSaveAnimationFile)
    grid $w.f_anim.f -sticky w
    grid $w.f_anim.e -sticky we
    grid rowconfigure $w.f_anim {0 1 2} -weight 1
    grid columnconfigure $w.f_anim 0 -weight 1        
    setTooltip $w.f_anim.f.f.cb -text [_ "Check here to create an animation file"]
    setTooltip $w.f_anim.e [_ "Here the name of the animation file must be entered."]
    setTooltip $w.f_anim.f.f.mb [_ "Choose the file format of the animation file."]
    setTooltip $w.f_anim.f.b [_ "A file browser will be openned, so a file can be selected."]
    # close
    ttk::frame $w.f_but -style BottomFrame.TFrame
    ttk::frame $w.f_but.siz -relief sunken -borderwidth 1
    TTKComboBox $w.f_but.siz.mb -textvariable ::GidPriv(PostAnimateResize) \
        -width 14 -state readonly
    PostAnimateFillComboWithCorrectWindowSizes $w.f_but.siz.mb
    #other sizes "352x288 (VCD-PAL)" "352x240 (VCD-NTSC)
    ttk::button $w.f_but.siz.resize -text [_ "Resize"] \
        -command "PostAnimateResize; update; after 200; PostAnimateResize"       
    grid $w.f_but.siz.mb $w.f_but.siz.resize
    set ::PostAnimatePriv(UserWindowExists) 1
    ttk::button $w.f_but.close -text [_ "Close"] -command [list PostAnimateCloseWindow $w] -style BottomFrame.TButton   
    grid $w.f_but.siz -sticky w -ipady 1 -pady 1 -ipadx 1 -padx 1
    grid $w.f_but.close -column 1 -row 0 -sticky e -padx 2 -pady 3
    grid rowconfigure $w.f_but {0} -weight 1    
    grid columnconfigure $w.f_but {0} -weight 1
    GidHelp $w.f_but.siz [_ "For MPEG files on windows its recommended \n\
            to choose a windows-standard frame size:\n \
            320x240 / 352x288 / 512x384 / 640x480 / 720x576 or 800x600"]
    GidHelp $w.f_but.siz.mb [_ "For MPEG files on windows its recommended \n\
            to choose a windows-standard frame size:\n \
            320x240 / 352x288 / 512x384 / 640x480 / 720x576 or 800x600"]
    GidHelp $w.f_but.siz.resize [_ "For MPEG files on windows its recommended \n\
            to choose a windows-standard frame size:\n \
            320x240 / 352x288 / 512x384 / 640x480 / 720x576 or 800x600"]
    grid $w.f_prof -sticky news
    grid $w.f_opt -sticky news
    grid $w.f_dur -sticky news
    grid $w.f_ctr -sticky news
    grid $w.f_save -sticky ew
    grid $w.f_anim -sticky ew
    grid $w.f_but -sticky sew
    grid anchor $w.f_but center
    grid rowconfigure $w {0 1 2 3 4 5} -weight 1    
    grid columnconfigure $w {0} -weight 1
    set ::GidPriv(PostAnimateInitializing) 0
    PostAnimateGetResultVisualizationState
    PostAnimateUpdateWidgetsWithResultState
    bind $w <Destroy> [list +PostAnimateOnDestroy %W $w]
    trace add variable ::SingleStepAnimation(num_steps) write PostAnimateOnChangeStaticNumSteps
    trace add variable ::SingleStepAnimation(deformation_factor) write PostAnimateOnChangeStaticFactor
    trace add variable GidPriv(PostAnimateDurationType) write PostAnimateGetDurationType
    # trace add variable GidPriv(PostAnimateDelay) write PostAnimateTogleDelayEntry
    # trace add variable GidPriv(PostAnimateDelayTime) write PostAnimateCheckDelayTime
    # trace add variable GidPriv(PostAnimateDuration) write PostAnimateTogleDurationEntry
    trace add variable GidPriv(PostAnimateDurationTime) write PostAnimateCheckDurationTime
    trace add variable GidPriv(PostAnimateRangeFrames) write PostAnimateTogleRangeFramesEntry
    trace add variable GidPriv(PostAnimateSaveFrame) write PostAnimateTogleSaveEntry
    trace add variable GidPriv(PostAnimateSaveAnimation) write PostAnimateTogleAnimEntry
    trace add variable GidPriv(PostAnimateAnalysisLimitsCb) write PostAnimateGetAnalysisLimits
    if { !$::GidPriv(PostAnimateSaveFrame) } {       
        $w.f_save.f.f.mb configure -state disabled      
        $w.f_save.f.b configure -state disabled
        $w.f_save.e configure -state disabled       
    }
    if { !$::GidPriv(PostAnimateSaveAnimation) } {      
        $w.f_anim.f.f.cb_stereo configure -state disabled       
        $w.f_anim.f.f.mb configure -state disabled       
        $w.f_anim.f.b configure -state disabled
        $w.f_anim.e configure -state disabled       
    }
    set ::GidPriv(PostAnimateAnalysisLimitsCb) 0
    # enable/disable corresponding widgets:
    set ::GidPriv(PostAnimateDurationType) $::GidPriv(PostAnimateDurationType)
}

proc PostAnimateRemoveTraces {} {
    global GidPriv
    trace remove variable ::SingleStepAnimation(num_steps) write PostAnimateOnChangeStaticNumSteps
    trace remove variable ::SingleStepAnimation(deformation_factor) write PostAnimateOnChangeStaticFactor
    # trace remove variable GidPriv(PostAnimateDelay) write PostAnimateTogleDelayEntry
    # trace remove variable GidPriv(PostAnimateDelayTime) write PostAnimateCheckDelayTime
    # trace remove variable GidPriv(PostAnimateDuration) write PostAnimateTogleDurationEntry
    trace remove variable GidPriv(PostAnimateDurationTime) write PostAnimateCheckDurationTime
    trace remove variable GidPriv(PostAnimateRangeFrames) write PostAnimateTogleRangeFramesEntry
    trace remove variable GidPriv(PostAnimateSaveFrame) write PostAnimateTogleSaveEntry
    trace remove variable GidPriv(PostAnimateSaveAnimation) write PostAnimateTogleAnimEntry
    trace remove variable GidPriv(PostAnimateAnalysisLimitsCb) write PostAnimateGetAnalysisLimits
    trace remove variable GidPriv(PostAnimateSavingAnimation) write PostAnimateTogleMPEGLeds
}

proc PostAnimateOnDestroy { W  w } {
    if { $W != $w } return
    global GidPriv
    set ::GidPriv(PostAnimateDoing) Stop
    PostAnimateRemoveTraces
}

proc PostAnimateShowTime { } {
    global GidPriv
    if { ( [info exists GidPriv(PrePostAnimateWindow)] && [ winfo exists $::GidPriv(PrePostAnimateWindow)]) || \
        ( [info exists GidPriv(PostAnimateWindow)] && [ winfo exists $::GidPriv(PostAnimateWindow)])} {        
        # may be some values are being edited...
        catch {
            if { $::GidPriv(PostAnimateFixedDelay)} {
                set delay [ PostAnimateGetValidDelayTime]
                set ::GidPriv(PostAnimateTime) [ expr $::GidPriv(PostAnimateTime) + $delay]
            }
            if { $::GidPriv(PostAnimateFixedTotalTime)} {
                set ::GidPriv(PostAnimateTime) [ expr $::GidPriv(PostAnimateTime) + $::GidPriv(PostAnimateDurationTimeDelay)]
            }
            if { $::GidPriv(PostAnimateUseStepvalues)} {
                set ::GidPriv(PostAnimateTime) [ expr $::GidPriv(PostAnimateTime) + $::GidPriv(PostAnimateStepvaluesDelay)]
            }
        }
        set time [ expr $::GidPriv(PostAnimateTime) / 1000]
        # may be $time is floating point
        set minutes [ expr int( $time / 60)]
        set seconds [ expr int( $time - 60 * $minutes)]
        set ::GidPriv(PostAnimateFileSize) [format "%02d:%02d" $minutes $seconds]
    }
}





######################################################################
##### Animation Controls Window #####
######################################################################

proc PostAnimateControlsResize { } {
    global GidPriv
    
    set info [ wm geometry .gid]
    lassign [ GidUtils::GetMainDrawAreaSize ] act_width act_height
    if { ![ regexp {([0-9]*)x([0-9]*)} $info trozo top_width top_height] } {
        return
    }
    set width_offset [ expr $top_width - $act_width]
    set height_offset [ expr $top_height - $act_height]
    
    if { $::GidPriv(PostAnimateControlsResize) == "Default"} {
        set ::GidPriv(PostAnimateControlsResize) $::GidPriv(PostAnimateControlsResizeDefault)
    }
    if { ![ regexp {([0-9]*)x([0-9]*)} $::GidPriv(PostAnimateControlsResize) trozo new_width new_height] } {
        return
    }
    # 768x576 640x480 512x384 320x240
    wm geometry .gid [ expr $width_offset + $new_width]x[ expr $height_offset + $new_height]
}

proc PostAnimateControlsInitValues {} {
    global GidPriv

    PostAnimateDefineSupportedVideoFormats

    set ::GidPriv(PostAnimateControlsDoing) Nothing
    set ::GidPriv(PostAnimateControlsDefaultDelayTime) 40
    set ::GidPriv(PostAnimateControlsDefaultFPS) 25
    if { ![ info exists GidPriv(PostAnimateControlsDelayTime)]} {
        set ::GidPriv(PostAnimateControlsDelayTime) $::GidPriv(PostAnimateControlsDefaultDelayTime)
    }
    set ::GidPriv(PostAnimateControlsDefaultDurationTime) 40
    if { ![ info exists GidPriv(PostAnimateControlsDurationTime)]} {
        set ::GidPriv(PostAnimateControlsDurationTime) $::GidPriv(PostAnimateControlsDefaultDurationTime)
    }
    set ::GidPriv(PostAnimateControlsDelay) 0
    set ::GidPriv(PostAnimateControlsDuration) 0
    set ::GidPriv(PostAnimateControlsSaveAnimation) 0
    set ::GidPriv(PostAnimateControlsSavingAnimation) 0
    set ::GidPriv(PostAnimateControlsSavingRepetitions) 1
    if { ![ info exists ::GidPriv(PostAnimateControlsSaveFrameFormat)]} {
        set ::GidPriv(PostAnimateControlsSaveFrameFormat) "PNG"
    }
    if { ![ info exists ::GidPriv(PostAnimateControlsSaveAnimationFormat)]} {
        # set ::GidPriv(PostAnimateControlsSaveAnimationFormat) [GiD_Info postprocess get animationformat]
        set ::GidPriv(PostAnimateControlsSaveAnimationFormat) [ PostAnimateGetDefaultVideoFormat]
    }
    lassign [ GidUtils::GetMainDrawAreaSize ] act_width act_height
    set current [format "%dx%d" $act_width $act_height]
    set ::GidPriv(PostAnimateControlsResizeDefault) $current
    set ::GidPriv(PostAnimateControlsResize) Default
    set ::GidPriv(PostAnimateControlsLastFile) ""
    if { ![ info exists GidPriv(PostAnimateControlsSaveRedraws)]} {
        set ::GidPriv(PostAnimateControlsSaveRedraws) 0
    }
    set ::GidPriv(PostAnimateControlsDisableList) ""
    set ::GidPriv(PostAnimateControlsFileSize) ""
    set ::GidPriv(PostAnimateControlsTime) 0
    set ::GidPriv(PostDoStereoAnimation) [ GiD_Set PostDoStereoAnimation]
    set ::GidPriv(PostAnimateControlsAnimationFileQuality) [ GiD_Set AnimationFileQuality]
}

proc PostAnimateControlsMPEGLeds { state } {
    global GidPriv
    set w $::GidPriv(PostAnimateControlsMPEGCanvas)
    if { ![winfo exists $w] } {
        return
    }
    set led_libre $::GidPriv(PostAnimateControlsMPEG_led_libre)
    switch $state {
        DISABLED {
            $w itemconfigure $led_libre -fill grey60
        }
        FREE {
            $w itemconfigure $led_libre -fill green
        }
        BUSY {
            $w itemconfigure $led_libre -fill red
        }
        default {
            WarnWin [_ "Unknown led state: %s" $state] $::GidPriv(PostAnimateControlsWindow)
            $w itemconfigure $led_libre -fill grey60
        }
    }
}

proc PostAnimateControlsTogleDelayEntry { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PrePostAnimateControlsWindow)
    if { [ winfo exists $::GidPriv(PostAnimateControlsDelayTimeEntry)]} {
        if { $::GidPriv(PostAnimateControlsDelay) } {
            $::GidPriv(PostAnimateControlsDelayTimeEntry) configure -state normal
            focus $::GidPriv(PostAnimateControlsDelayTimeEntry)
            $::GidPriv(PostAnimateControlsFPSEntryWidget) configure -state normal
        } else {
            $::GidPriv(PostAnimateControlsDelayTimeEntry) configure -state disabled
            $::GidPriv(PostAnimateControlsFPSEntryWidget) configure -state disabled
        }
    }
}

# Durations is not being used...
# proc PostAnimateControlsTogleDurationEntry { name1 name2 op} {
#     global GidPriv
#     set w $::GidPriv(PrePostAnimateControlsWindow)
#     if { $::GidPriv(PostAnimateControlsDuration) } {
#         $w.conf.f_dur.e configure -state normal
#         focus $w.conf.f_dur.e
#     } else {
#         $w.conf.f_dur.e configure -state disabled
#     }
# }


proc PostAnimateControlsTogleMPEGLeds { name1 name2 op} {
    global GidPriv
    if { $::GidPriv(PostAnimateControlsSavingAnimation) == 0} {
        PostAnimateControlsMPEGLeds FREE
        foreach i $::GidPriv(PostAnimateControlsDisableList) {
            $i state !disabled
        }
    }
    if { $::GidPriv(PostAnimateControlsSavingAnimation) == 1} {
        PostAnimateControlsMPEGLeds BUSY
        foreach i $::GidPriv(PostAnimateControlsDisableList) {
            $i state disabled
        }
    }
}

proc PostAnimateControlsTogleAnimEntry { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PrePostAnimateControlsWindow)
    if { $::GidPriv(PostAnimateControlsSaveAnimation) } {
        $w.file.name.filename configure -state normal
        focus $w.file.name.filename
        PostAnimateControlsMPEGLeds FREE
        trace add variable GidPriv(PostAnimateControlsSavingAnimation) write PostAnimateControlsTogleMPEGLeds
    } else {
        $w.file.name.filename configure -state disabled
        PostAnimateControlsMPEGLeds DISABLED
        trace remove variable GidPriv(PostAnimateControlsSavingAnimation) write PostAnimateControlsTogleMPEGLeds
    }
}

proc PostAnimateControlsCheckDelayTime { name1 name2 op} {
    global GidPriv
    set w $::GidPriv(PrePostAnimateControlsWindow)
    set len [string length $::GidPriv(PostAnimateControlsTime)]
    set cur_digit [ string index $::GidPriv(PostAnimateControlsDelayTime) [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { return}
    if { ( $cur_digit == "e") || ( $cur_digit == "E") ||
        ( $cur_digit == "+") || ( $cur_digit == "-") || ( $cur_digit == ".")} {
        return
    }
    set val [ string range $::GidPriv(PostAnimateControlsDelayTime) 0 [ expr $len-2]]
    if { $val <= 0} {
        set val 5
    }
    set ::GidPriv(PostAnimateControlsDelayTime) $val
}

proc PostAnimateControlsAddStep { w} {
    global GidPriv
    if { ( [ info exists GidPriv(PostAnimateSaveAnimation) ] && \
        $::GidPriv(PostAnimateSaveAnimation)) || \
            ( [ info exists GidPriv(PostAnimateSavingAnimation) ] && \
        $::GidPriv(PostAnimateSavingAnimation)) } {
        WarnWin "Sorry, but couldn't save the animation while another one is active (Post Animate Window)"       
        return
    }
    if { !$::GidPriv(PostAnimateControlsSavingAnimation)} {
        if { $::GidPriv(PostAnimateControlsSaveAnimationFile) == ""} {
            WarnWin [_ "Sorry but a file name is needed to save the animation."] $w            
            return
        } else {            
            if { !$::GidPriv(PostAnimateControlsDelay) } {
                WarnWin [_ "There is no delay selected, using default of 40 ms. \n If you want no delay, please check the delay time entry."] $w
            }
            if { ![ PostAnimateVerifyPermissions $w $::GidPriv(PostAnimateControlsSaveAnimationFile)]} {              
                return
            }     
            if { $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVIMJPG" || \
                $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVIMSVC" || \
                    $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVI" || \
                    $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVI15" || \
                    $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVI16" || \
                    $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "FLV"} {
                lassign [ GidUtils::GetMainDrawAreaSize ] width height
                set avisize [expr $width * $height * 1]
                if { $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVIMJPG" } {
                    # estimacion aproximada
                    set avisize [expr $avisize * 3 * 0.1]
                } elseif { $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVIMSVC" } {
                    # estimacion aproximada
                    set avisize [expr $avisize * 3 * 0.15]
                } elseif { $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "AVI" } {
                    set avisize [ expr $avisize * 3]
                } elseif { $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "FLV" } {
                    set avisize [expr $avisize * 3 * 0.1]
                } else {
                    set avisize [expr $avisize * 2]
                }
                set avisize [expr ( $avisize / 1024.0) / 1024.0]                
                if { $avisize > 200.00 } {
                    set resp [GID_tk_messageBox -parent $::GidPriv(PrePostAnimateControlsWindow) -icon warning -type yesno \
                            -default no -message \
                                  [_ "Warning: the AVI/FLV file will be %s MB big !!!\n Are you sure you want continue?" [format %.3g $avisize]] ]
                    if { $resp == "no"} {                       
                        return
                    }
                }               
            }       
            # Frame rate = 25 FPS == 40 ms.
            set repe 1
            # there is no Duration set, only FPS, so no need to repeat frames...
            # if { $::GidPriv(PostAnimateControlsDelay) } {
            #     if { $::GidPriv(PostAnimateControlsDelayTime) == 0 && $::GidPriv(PostAnimateControlsSaveAnimationFormat) == "MPEG" } {
            #         set resp [GID_tk_messageBox -parent $::GidPriv(PrePostAnimateControlsWindow) -icon warning -type yesno \
            #                 -default no -message \
            #                 "Saving a MPEG animation file without delay between Steps can cause some strange efects in Microsoft Windows 95/98/NT.\n Are you sure you want continue?" ]
            #         if { $resp == "no"} {                       
            #             return
            #         }
            #     }             
            #     set repe [expr int(0.5 + $::GidPriv(PostAnimateControlsDelayTime)/40.0)]
            #     if { $repe == 0} {
            #         set repe 1
            #     }
            # } else {
            #     # por defecto 40 ms # medio segundo
            #     set repe [expr int(0.5 + 40.0/40.0)]
            #     if { $repe == 0} {
            #         set repe 1
            #     }
            # }
            # controling FPS depending on the format
            set cur_format $::GidPriv(PostAnimateControlsSaveAnimationFormat)
            set max_fps $::GidPriv(PostAnimateVideoFormat,${cur_format},MaxFps)
            if { ( $::GidPriv(PostAnimateControlsAnimationFileFPS) <= 0) || ( $::GidPriv(PostAnimateControlsAnimationFileFPS) > $max_fps)} {
                set description $::GidPriv(PostAnimateVideoFormat,${cur_format},Label)
                set resp [GID_tk_messageBox -parent $::GidPriv(PrePostAnimateControlsWindow) -icon warning -type yesno \
                               -default no -message \
                               [_ "Selected %s FPS is not recommended for this format %s.\nShould be between 0 and %s.\nAre you sure you want continue?" \
                                    $::GidPriv(PostAnimateControlsAnimationFileFPS) $description $max_fps ]]
                if { $resp == "no"} {
                    return
                }
            }

            GiD_Process 'AnimationFile Format [PostAnimateProcessGIFOption $::GidPriv(PostAnimateControlsSaveAnimationFormat)]
            if { $::GidPriv(PostAnimateControlsSaveRedraws) } {
                GiD_Process 'AnimationFile SaveRedraws Yes
            }
            
            set ::GidPriv(PostAnimateControlsSavingRepetitions) $repe
            GiD_Process 'AnimationFile FramesPerStep $::GidPriv(PostAnimateControlsSavingRepetitions) escape escape escape
            GiD_Process 'AnimationFile SetFPS $::GidPriv(PostAnimateControlsAnimationFileFPS) escape escape escape escape
            GiD_Set AnimationFileQuality $::GidPriv(PostAnimateControlsAnimationFileQuality)
            GiD_Process 'AnimationFile SetQuality $::GidPriv(PostAnimateControlsAnimationFileQuality) escape escape escape escape
            GiD_Process 'AnimationFile Start $::GidPriv(PostAnimateControlsSaveAnimationFile) Yes escape escape escape
            set ::GidPriv(PostAnimateControlsSavingAnimation) 1
            update
            set ::GidPriv(PostAnimateControlsTime) 0
        }
    }
    if { $::GidPriv(PostAnimateControlsSavingAnimation)} {
        if { $::GidPriv(PostAnimateControlsSavingAnimation) } {
            GiD_Process 'AnimationFile AddStep
        }
    }
}
# -np- for { set i 0} { $i < 360} { incr i} { GiD_Process rotate objaxes z 1 escape escape escape escape}
proc PostAnimateControlsShowFileSize { } {
    global GidPriv
    if { ( [info exists GidPriv(PrePostAnimateControlsWindow)] && [ winfo exists $::GidPriv(PrePostAnimateControlsWindow)]) || \
        ( [info exists GidPriv(PostAnimateControlsWindow)] && [ winfo exists $::GidPriv(PostAnimateControlsWindow)])} {
        file stat $::GidPriv(PostAnimateControlsSaveAnimationFile) pp
        set ::GidPriv(PostAnimateControlsTime) [ expr $::GidPriv(PostAnimateControlsTime) + $::GidPriv(PostAnimateControlsDelayTime)]
        set time [ expr $::GidPriv(PostAnimateControlsTime) / 1000]
        set ::GidPriv(PostAnimateControlsFileSize) [format "%02d:%02d - %.3gMB" [ expr int( $time / 60)] [ expr int( $time % 60)] [ expr $pp(size)/(1024.0*1024.0)]]
    }
}

proc PostAnimateControlsShowTime { } {
    global GidPriv
    if { ( [info exists GidPriv(PrePostAnimateControlsWindow)] && [ winfo exists $::GidPriv(PrePostAnimateControlsWindow)]) || \
        ( [info exists GidPriv(PostAnimateControlsWindow)] && [ winfo exists $::GidPriv(PostAnimateControlsWindow)])} {
        set ::GidPriv(PostAnimateControlsTime) [ expr $::GidPriv(PostAnimateControlsTime) + $::GidPriv(PostAnimateControlsDelayTime)]
        set time [ expr $::GidPriv(PostAnimateControlsTime) / 1000]
        set ::GidPriv(PostAnimateControlsFileSize) [format "%02d:%02d" [ expr $time / 60] [ expr $time % 60]]
    }
}

proc PostAnimateControlsEndAnim { w} {
    global GidPriv
    if { $::GidPriv(PostAnimateControlsSavingAnimation) } {
        GiD_Process 'AnimationFile End
        # let gif option to be no dithering
        set fmt [ PostAnimateProcessGIFOption $::GidPriv(PostAnimateControlsSaveAnimationFormat)]
        if { $fmt == "GIF"} {
            #fo of animation file is not provided
            #PostAnimateWriteGIFOption $fo GIF/None
            PostAnimateProcessGIFOption GIF/None
        }
        set ::GidPriv(PostAnimateControlsSavingAnimation) 0
        set ::GidPriv(PostAnimateControlsLastFile) $::GidPriv(PostAnimateControlsSaveAnimationFile)
        if { $::GidPriv(PostAnimateControlsSaveRedraws) } {
            GiD_Process 'AnimationFile SaveRedraws No
        }        
    }
}

proc PostAnimateControlsChooseAnimationFile {} {
    global GidPriv

    if { $::GidPriv(PostAnimateControlsSaveAnimation) } {
        set new_ext $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateControlsSaveAnimationFormat),Extension)
        set new_description $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateControlsSaveAnimationFormat),Label)
        set ::GidPriv(PostAnimateControlsSaveAnimationFile) \
            [ MessageBoxGetFilename imagefile write [_ "Save %s on" $new_description]... \
                  {} [ list [ list "$new_description animation" .$new_ext] {{All files} {.*}}] .$new_ext ]

        # switch [ PostAnimateProcessGIFOption $::GidPriv(PostAnimateControlsSaveAnimationFormat)] {
        #     "MPEG" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save MPEG on"]... \
        #                 {} {{{Mpeg animation} {.mpg .mpeg}} {{All files} {.*}}} ".mpg" ]
        #     }
        #     "AVIMJPG" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" \
        #                 0 [ list {AVI/mjpg options} BrowserExtraCreateExportJPEG BrowserExtraGetExportJPEG]]
        #     }
        #     "AVIMSVC" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi"  \
        #                 0 [ list {AVI/msvc options} BrowserExtraCreateExportAviMSVC BrowserExtraGetExportAviMSVC]]
        #     }
        #     "AVI" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" ]
        #     }
        #     "AVI15" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" ]
        #     }
        #     "AVI16" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save AVI on"]... \
        #                 {} {{{AVI animation} {.avi}} {{All files} {.*}}} ".avi" ]
        #     }
        #     "GIF" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save GIF on"]... \
        #                 {} {{{GIF animation} {.gif}} {{All files} {.*}}} ".gif" \
        #                 0 [ list {GIF options} BrowserExtraCreateExportGIF BrowserExtraGetExportGIF] ]
        #     }
        #     "FLV" {
        #         set ::GidPriv(PostAnimateControlsSaveAnimationFile) [MessageBoxGetFilename imagefile write [_ "Save Macromedia Flash Video on"]... \
        #                 {} {{{Macromedia Flash Video} {.flv}} {{All files} {.*}}} ".flv"  \
        #                 0 {} ]
        #     }
        # }
    }
}

proc PostAnimateHimAndAllSlaves { w } {
    set a $w
    set count 0
    while {$count != [llength $a] } {
        lappend a {*}[grid slaves [lindex $a $count]]
        incr count        
    } 
    return $a
}

proc PostAnimateControlsChangeExtension { } {
    global GidPriv
    set new_format $::GidPriv(PostAnimateControlsSaveAnimationFormat)
    if { $::GidPriv(PostAnimateControlsSaveAnimationFile) == "" } { return}

    set raiz [ file root $::GidPriv(PostAnimateControlsSaveAnimationFile)]
    set ext [ string tolower [ file extension $::GidPriv(PostAnimateControlsSaveAnimationFile)]]
    set new_ext $::GidPriv(PostAnimateVideoFormat,$new_format,Extension)
    if { $ext != $new_ext} {
        set ::GidPriv(PostAnimateControlsSaveAnimationFile) ${raiz}.${new_ext}
    }
}

proc PostAnimateControlsUpdateBitrateLabel { quality} {
    set fps 0
    set bitrate ""
    set err [ catch {
        set bitrate [ PostAnimateGetBitrateFromQuality $quality]
    } err_txt]
    if { $err} {
        set bitrate --
    }
    set ::GidPriv(PostAnimateControlsAnimationFileBitrate) "[ GidUtils::AddThousandsSeparator $bitrate] Kbps"
}

proc PostAnimateControlsCheckQuality { new_value_in } { 
    global GidPriv

    set new_value $::GidPriv(PostAnimateControlsAnimationFileQuality)
    set new_value $new_value_in

    if { $new_value == ""} {
        PostAnimateControlsUpdateBitrateLabel $new_value
        return 1
    }
    set len [string length $new_value]
    set cur_digit [ string index $new_value [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { 
        PostAnimateControlsUpdateBitrateLabel $new_value
        return 1
    }
    if { ( $cur_digit == ".")} {
        PostAnimateControlsUpdateBitrateLabel $new_value
        return 1
    }
    set val [string range $new_value 0 [expr $len-2]]
    set new_value $val
    PostAnimateControlsUpdateBitrateLabel $new_value
    return 0
}

proc PostAnimateControlsColorizeDurationEntries {  } {
    # check if value in entry is a valid numeric value
    if { ![ info exists ::GidPriv(PostAnimateControlsDelayTimeEntry)] || ![ info exists ::GidPriv(PostAnimateControlsFPSEntryWidget)]} {
        # window not openned
        return
    }
    set lst_var [ list ::GidPriv(PostAnimateControlsDelayTime) ::GidPriv(PostAnimateControlsAnimationFileFPS)]
    set lst_w [ list $::GidPriv(PostAnimateControlsDelayTimeEntry) $::GidPriv(PostAnimateControlsFPSEntryWidget)]
    foreach v $lst_var w $lst_w {
        set color [ set ::ttk::theme::[gid_themes::GetTtkTheme]::colors(-colortext_fg)]
        set err [ catch {
            set i [ expr int( [ set $v] + 1.0)]
            if { [ set $v] <= 0} {
                set color red
            }
        } ]
        if { $err} {
            set color red
        }
        if { [ winfo exists $w]} {
            $w configure -foreground $color            
        }
    }
}

proc PostAnimateControlsUpdateFPSLabel { new_delay_txt } {
    set fps 0
    if { ![ info exists ::GidPriv(PostAnimateControlsSaveAnimationFormat)]} {
        # Window has not been initialized, i.e. openend
        return
    }
    set maxfps $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateControlsSaveAnimationFormat),MaxFps)
    set err [ catch {
        scan $new_delay_txt "%g" new_delay
        if { $new_delay == 0} {
            set new_delay [ format %g [ expr 1000.0 / $maxfps]]
            set fps $maxfps
            after idle [ PostAnimateControlsUpdateDelayTimeLabel $fps]
        } else {
            set fps [ format %d [ expr int ( 0.5 + 1000.0 / $new_delay)]]
            if { $fps > $maxfps} {
                set fps $maxfps
                after idle [ PostAnimateControlsUpdateDelayTimeLabel $fps]
            }
        }
    }]
    if { $err || ( $fps < 0)} {
        set fps $::GidPriv(PostAnimateControlsDefaultFPS)
        set ::GidPriv(PostAnimateControlsAnimationFileFPS) ""
    } else {
        set ::GidPriv(PostAnimateControlsAnimationFileFPS) $fps
    }
    PostAnimateControlsColorizeDurationEntries
}

proc PostAnimateControlsUpdateDelayTimeLabel { new_fps_txt } {
    set fps 0
    set err [ catch {
        scan $new_fps_txt "%d" new_fps
        set delay [ format %g [ expr 1000.0 / $new_fps]]
    } err_txt]
    if { $err || ( $delay < 0)} {
        set delay $::GidPriv(PostAnimateControlsDefaultDelayTime)
        set ::GidPriv(PostAnimateControlsDelayTime) ""
    } else {
        set ::GidPriv(PostAnimateControlsDelayTime) $delay
    }
    PostAnimateControlsColorizeDurationEntries
}

# name1 name2 op
proc PostAnimateControlsCheckDelayTime { new_value_in } { 
    global GidPriv

    # set new_value $::GidPriv(PostAnimateControlsDelayTime)
    set new_value $new_value_in

    if { $new_value == ""} {
        PostAnimateControlsUpdateFPSLabel $new_value
        return 1
    }
    set len [string length $new_value]
    set cur_digit [ string index $new_value [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { 
        PostAnimateControlsUpdateFPSLabel $new_value
        return 1
    }
    if { ( $cur_digit == ".")} {
        PostAnimateControlsUpdateFPSLabel $new_value
        return 1
    }
    # no need to validate e+123 e-123
    # if { ( $cur_digit == "e") || ( $cur_digit == "E") ||
    #     ( $cur_digit == "+") || ( $cur_digit == "-")} {
    #     PostAnimateControlsUpdateFPSLabel $new_value
    #     return 1
    # }
    set val [string range $new_value 0 [expr $len-2]]
    set new_value $val
    PostAnimateControlsUpdateFPSLabel $new_value
    return 0
}

proc PostAnimateControlsCheckFPS { new_value_in } { 
    global GidPriv

    set new_value $::GidPriv(PostAnimateControlsAnimationFileFPS)
    set new_value $new_value_in

    if { $new_value == ""} {
        PostAnimateControlsUpdateDelayTimeLabel $new_value
        return 1
    }
    set len [string length $new_value]
    if { $len > 0} {
        set maxfps $::GidPriv(PostAnimateVideoFormat,$::GidPriv(PostAnimateControlsSaveAnimationFormat),MaxFps)
        if { $new_value > $maxfps} {
            set new_value $maxfps
            set ::GidPriv(PostAnimateControlsAnimationFileFPS) $maxfps
        }
    }
    set cur_digit [ string index $new_value [ expr $len - 1]]
    if { ( $cur_digit >= 0) && ( $cur_digit <= 9)} { 
        PostAnimateControlsUpdateDelayTimeLabel $new_value
        return 1
    }
    # fps are integeres
    # if { ( $cur_digit == ".")} {
    #     PostAnimateControlsUpdateDelayTimeLabel $new_value
    #     return 1
    # }
    # no need to validate e+123 e-123
    # if { ( $cur_digit == "e") || ( $cur_digit == "E") ||
    #     ( $cur_digit == "+") || ( $cur_digit == "-")} {
    #     PostAnimateControlsUpdateDelayTimeLabel $new_value
    #     return 1
    # }
    set val [string range $new_value 0 [expr $len-2]]
    set new_value $val
    PostAnimateControlsUpdateDelayTimeLabel $new_value
    return 0
}

proc PostAnimateControlsWindow { { w .gid.wPostAnimateControls } } {
    global GidPriv
    if { [ winfo exists $w] } {return}
    set ::GidPriv(PostAnimateControlsInitializing) 1
    PostAnimateControlsInitValues
    InitWindow2 $w -title [_ "Animation Controls"] \
        -geometryvariable PrePostAnimateControlsWindowGeom \
        -initcommand PostAnimateControlsWindow -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    ttk::labelframe $w.file -text [_ "File"]
    GidHelp $w.file [_ "Here the name of the animation file must be entered."]    
    ttk::frame $w.file.name
    ttk::label $w.file.name.label -text [_ "Name"]:
    if { ![info exists GidPriv(PostAnimateControlsSaveAnimationFile)] } {
        set ::GidPriv(PostAnimateControlsSaveAnimationFile) ""
    }
    ttk::entry $w.file.name.filename -width 8 -state normal -textvariable GidPriv(PostAnimateControlsSaveAnimationFile)
    ttk::button $w.file.name.browse -image [gid_themes::GetImage "folder.png" small_icons] -command PostAnimateControlsChooseAnimationFile
    GidHelp $w.file.name.browse [_ "A file browser will be openned, so a file can be selected."]    
    grid $w.file.name.label $w.file.name.filename $w.file.name.browse -sticky news
    grid columnconfigure $w.file.name 1 -weight 1        
    ttk::frame $w.file.type
    ttk::label $w.file.type.label -text [_ "Type"]:
    TTKComboBox $w.file.type.cb -textvariable ::GidPriv(PostAnimateControlsSaveAnimationFormat) \
        -labels $::GidPriv(PostAnimateShowVideoFormatLabels) \
        -values $::GidPriv(PostAnimateShowVideoFormats) \
        -modifycmd PostAnimateControlsChangeExtension \
        -width 26 -state readonly
    GidHelp $w.file.type.cb [_ "Choose the file format of the animation file."]

    ttk::label $w.file.type.l_qual -text [_ "Quality:"]
    ttk::entry $w.file.type.e_qual -width 7 -textvariable ::GidPriv(PostAnimateControlsAnimationFileQuality) \
        -validate key -validatecommand "PostAnimateControlsCheckQuality %P"
    ttk::label $w.file.type.l_bitrate -textvariable ::GidPriv(PostAnimateControlsAnimationFileBitrate)
    PostAnimateControlsUpdateBitrateLabel $::GidPriv(PostAnimateControlsAnimationFileQuality)
    
    grid $w.file.type.label $w.file.type.cb -sticky nws
    grid configure $w.file.type.cb -columnspan 2
    grid $w.file.type.l_qual $w.file.type.e_qual $w.file.type.l_bitrate -sticky nws
    grid $w.file.name -sticky news
    grid $w.file.type -sticky news
    grid columnconfigure $w.file 0 -weight 1
    # configuration
    ttk::labelframe $w.conf -text [_ "Configuration"]
    ttk::frame $w.conf.f_siz
    GidHelp $w.conf.f_siz [_ "For MPEG files on windows its recommended \n\
            to choose a windows-standard frame size:\n \
            320x240 / 352x288 / 512x384 / 640x480 / 720x576 or 800x600"]
    TTKComboBox $w.conf.f_siz.cb -textvariable ::GidPriv(PostAnimateControlsResize) \
        -width 14 -state readonly
    PostAnimateFillComboWithCorrectWindowSizes $w.conf.f_siz.cb
    #other sizes "352x288 (VCD-PAL)" "352x240 (VCD-NTSC)
    ttk::button $w.conf.f_siz.resize -text [_ "Resize"] \
        -command "PostAnimateControlsResize; update; after 200 PostAnimateControlsResize"
    grid $w.conf.f_siz.cb $w.conf.f_siz.resize -sticky nw    

    ttk::frame $w.conf.f_del   
    GidHelp $w.conf.f_del [_ "With this option a DelayTime of the entered milliseconds will be used between frames."]
    if { ![info exists GidPriv(PostAnimateControlsDelay)] } { set ::GidPriv(PostAnimateControlsDelay) 0 }
#     ttk::checkbutton $w.conf.f_del.cb -text [_ "Delay"]: -variable GidPriv(PostAnimateControlsDelay)
    ttk::label $w.conf.f_del.cb -text [_ "Delay between steps"]:

    ttk::entry $w.conf.f_del.e -width 5 -textvariable ::GidPriv(PostAnimateControlsDelayTime) \
        -validate key -validatecommand "PostAnimateControlsCheckDelayTime %P"
    set ::GidPriv(PostAnimateControlsDelayTimeEntry) $w.conf.f_del.e

    $w.conf.f_del.e configure -state disabled

    ttk::label $w.conf.f_del.l -text [_ "ms."]    
    ttk::label $w.conf.f_del.lsep -text "/"
    ttk::label $w.conf.f_del.lfps -text "fps:"
    ttk::entry $w.conf.f_del.efps -width 5 -textvariable ::GidPriv(PostAnimateControlsAnimationFileFPS) \
        -validate key -validatecommand "PostAnimateControlsCheckFPS %P"
    set ::GidPriv(PostAnimateControlsFPSEntryWidget) $w.conf.f_del.efps


    grid $w.conf.f_del.cb $w.conf.f_del.e $w.conf.f_del.l $w.conf.f_del.lsep $w.conf.f_del.lfps $w.conf.f_del.efps -sticky new
    grid columnconfigure $w.conf.f_del 1 -weight 1
    grid columnconfigure $w.conf.f_del 5 -weight 1
    PostAnimateControlsUpdateFPSLabel $::GidPriv(PostAnimateControlsDelayTime)

    # Duration is not being used....
    # ttk::frame $w.conf.f_dur
    # if { ![info exists GidPriv(PostAnimateControlsDuration)] } { set ::GidPriv(PostAnimateControlsDuration) 0 }
    # ttk::checkbutton $w.conf.f_dur.cb -text [_ "Duration"]: -variable GidPriv(PostAnimateControlsDuration)
    # ttk::entry $w.conf.f_dur.e -width 5 -textvariable GidPriv(PostAnimateControlsDurationTime)
    # $w.conf.f_dur.e configure -state disabled    
    # ttk::label $w.conf.f_dur.l -text [_ "s."]
    # grid $w.conf.f_dur.cb $w.conf.f_dur.e $w.conf.f_dur.l -sticky new
    # grid columnconfigure $w.conf.f_dur 1 -weight 1    
    if { ![info exists ::GidPriv(PostDoStereoAnimation)] } { set ::GidPriv(PostDoStereoAnimation) 0 }
    ttk::checkbutton $w.conf.cb_stereo -text [_ "Create a stereoscopic animation"] \
        -variable ::GidPriv(PostDoStereoAnimation) \
        -command {GiD_Set PostDoStereoAnimation $::GidPriv(PostDoStereoAnimation)}    
    PostAnimateIfStereoDisableForceCb $w.conf.cb_stereo        
    grid $w.conf.f_siz -column 0 -row 0 -sticky news
    grid $w.conf.f_del -column 0 -row 1 -sticky news
    # grid $w.conf.f_dur -column 0 -row 2 -sticky news
    grid $w.conf.cb_stereo -column 0 -row 3 -sticky news   
    grid columnconfigure $w.conf 0 -weight 1
    #controls
    ttk::labelframe $w.controls -text [_ "Controls"]    
    if { ![info exists GidPriv(PostAnimateControlsSaveRedraws)] } { set ::GidPriv(PostAnimateControlsSaveRedraws) 0 }
    ttk::checkbutton $w.controls.cb_redraw -text [_ "Save redraws"] -variable GidPriv(PostAnimateControlsSaveRedraws)
    GidHelp $w.controls.cb_redraw [_ "Check this option if you want to save each redraw into the animation file.\n\
            The program will start saving redraws into the file after clicking the AddSet button in this windows."]
    ttk::frame $w.controls.f_buttons
    ttk::button $w.controls.f_buttons.add -image [gid_themes::GetImage AddStep.png medium_icons] \
        -command [list PostAnimateControlsAddStep $w.controls.f_buttons.add]
    GidHelp $w.controls.f_buttons.add \
        [_ "AddSet button: Adds a frame \n\
            into the animation file.\n\
            If the 'Save redraws' checkbox \n\
            is checked, pressing this button \n\
            starts saving redraws into the file."]
    ttk::button $w.controls.f_buttons.end -image [gid_themes::GetImage EndAnim.png medium_icons] \
        -command [list PostAnimateControlsEndAnim $w.controls.f_buttons.end]
    GidHelp $w.controls.f_buttons.end \
        [_ "EndAnimation button: Ends and \n\
            closes the animation file.\n"]    
    set ::GidPriv(PostAnimateControlsMPEGCanvas) $w.controls.f_buttons.indicator
    canvas $::GidPriv(PostAnimateControlsMPEGCanvas) -width 18 -height 18
    set led_libre [$::GidPriv(PostAnimateControlsMPEGCanvas) create oval 2 2 17 17 -fill grey60]
    set ::GidPriv(PostAnimateControlsMPEG_led_libre) $led_libre
    PostAnimateControlsMPEGLeds DISABLED    
    grid $w.controls.f_buttons.add -column 0 -row 0 -sticky nw
    grid $w.controls.f_buttons.end -column 1 -row 0 -sticky nw
    grid $::GidPriv(PostAnimateControlsMPEGCanvas) -column 2 -row 0 -sticky ne
    grid columnconfigure $w.controls.f_buttons 2 -weight 1
    grid $w.controls.cb_redraw -sticky news
    grid $w.controls.f_buttons -sticky news
    grid columnconfigure $w.controls 0 -weight 1
    ttk::frame $w.f_but -style BottomFrame.TFrame    
    ttk::button $w.f_but.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton
    lappend GidPriv(PostAnimateControlsDisableList) $w.f_but.close    
    grid $w.f_but.close -sticky {} -pady 5
    grid columnconfigure $w.f_but 0 -weight 1
    grid rowconfigure $w.f_but 0 -weight 1    
    #grid window (always display bottom buttons)
    grid $w.file -sticky news
    grid $w.conf -sticky news
    grid $w.controls -sticky news
    grid $w.f_but -sticky news
    grid rowconfigure $w {0 1 2} -weight 1   
    grid columnconfigure $w 0 -weight 1    
    lappend GidPriv(PostAnimateControlsDisableList) {*}[PostAnimateHimAndAllSlaves $w.file]
    lappend GidPriv(PostAnimateControlsDisableList) {*}[PostAnimateHimAndAllSlaves $w.conf]
    lappend GidPriv(PostAnimateControlsDisableList) $w.controls.cb_redraw    
    lappend GidPriv(PostAnimateControlsDisableList) $w.f_but.close    
    set ::GidPriv(PostAnimateControlsInitializing) 1
    update
    set ::GidPriv(PostAnimateControlsInitializing) 0
    bind $w <Escape> [list destroy $w]
    bind $w <Destroy> [list +PostAnimateControlsOnDestroy %W $w]
    trace add variable GidPriv(PostAnimateControlsDelay) write PostAnimateControlsTogleDelayEntry
    # trace add variable GidPriv(PostAnimateControlsDelayTime) write PostAnimateControlsCheckDelayTime
    trace add variable GidPriv(PostAnimateControlsSaveAnimation) write PostAnimateControlsTogleAnimEntry
    # trace add variable GidPriv(PostAnimateControlsDuration) write PostAnimateControlsTogleDurationEntry
    set ::GidPriv(PostAnimateControlsDelay) 1
    set ::GidPriv(PostAnimateControlsSaveRedraws) 1
    set ::GidPriv(PostDoStereoAnimation) $::GidPriv(PostDoStereoAnimation)
    set ::GidPriv(PostAnimateControlsSaveAnimation) 1
}

proc PostAnimateControlsOnDestroy { W w } {
    if { $W != $w } return
    global GidPriv    
    trace remove variable GidPriv(PostAnimateControlsDelay) write PostAnimateControlsTogleDelayEntry
    # trace remove variable GidPriv(PostAnimateControlsDelayTime) write PostAnimateControlsCheckDelayTime
    trace remove variable GidPriv(PostAnimateControlsSaveAnimation) write PostAnimateControlsTogleAnimEntry
    trace remove variable GidPriv(PostAnimateControlsSavingAnimation) write PostAnimateControlsTogleMPEGLeds
    # trace remove variable GidPriv(PostAnimateControlsDuration) write PostAnimateControlsTogleDurationEntry
    #do it after remove traces, else some callback will fail because widges were destroyed
    if { $::GidPriv(PostAnimateControlsSavingAnimation) } {
        GiD_Process 'AnimationFile End
        # let gif option to be no dithering
        set fmt [ PostAnimateProcessGIFOption $::GidPriv(PostAnimateControlsSaveAnimationFormat)]
        if { $fmt == "GIF"} {
            #fo of animation file is not provided
            #PostAnimateWriteGIFOption $fo GIF/None
            PostAnimateProcessGIFOption GIF/None
        }
        set ::GidPriv(PostAnimateControlsSavingAnimation) 0
    }
}

proc GetCurrentResultsViewCommands { time_step } {
    set cur_analysis $::GidPriv(PostAnimate_cur_analysis)
    set cur_resv $::GidPriv(PostAnimate_cur_result_view)
    set cur_res $::GidPriv(PostAnimate_cur_res)
    set cur_comp $::GidPriv(PostAnimate_cur_comp)
    set cur_defor $::GidPriv(PostAnimate_cur_d_defor)
    set cur_factor $::GidPriv(PostAnimate_cur_d_factor)
    set cur_defor_type $::GidPriv(PostAnimate_cur_defor_type)
    set cur_d_anal $::GidPriv(PostAnimate_cur_d_anal)
    set ret_line {}
    set already_set 0
    if { $::GidPriv(PostAnimateDeform)} {
        # puede que cur_analysis != cur_d_anal
        lappend ret_line [ list Mescape Results AnalysisSel $cur_d_anal $time_step]
        if { $cur_d_anal == $cur_analysis} {
            set already_set 1
        }
        lappend ret_line [ list Mescape Results Options DeformationType $cur_defor_type]
        if { $::SingleStepAnimation(in_use)} {
            lappend ret_line [ list Mescape Results Geometry Original Geometry Deformation $cur_defor $time_step escape]
        } else {
            lappend ret_line [ list Mescape Results Geometry Original Geometry Deformation $cur_defor $cur_factor escape]
        }
        if { $cur_defor_type != "relative"} {
            lappend ret_line [ list Mescape Results Options DeformationType relative]
        }
    }
    if { !$already_set} {
        lappend ret_line [ list Mescape Results AnalysisSel $cur_analysis $time_step Mescape]
    }  
    if { ( $::GidPriv(PostAnimate_cur_result_view) == "IsoSurfaces") && ( [ llength $::GidPriv(PostAnimateIsoSurfaces)] != 0)} {
        set iso_res [ lindex $::GidPriv(PostAnimateIsoSurfaces) 2]
        set iso_anal [ lindex $iso_res 2]       
        if { $cur_analysis != $iso_anal} {
            lappend ret_line [list Mescape Results AnalysisSel $iso_anal $time_step Mescape]
        }
        set lst_valores [ lindex $::GidPriv(PostAnimateIsoSurfaces) 1]
        lappend ret_line [ list \
                Mescape results IsoSurfaces Exact [ lindex $iso_res 0] [ lindex $iso_res 1] \
                [ lindex $::GidPriv(PostAnimateIsoSurfaces) 0] {*}$lst_valores escape \
                ]
        if { $cur_analysis != $iso_anal} {
            lappend ret_line [ list Mescape Results AnalysisSel $cur_analysis $time_step escape escape  escape ]
        }
    }
    
    if { $::GidPriv(PostAnimateResultViewCb) && $::GidPriv(PostAnimateResultView) != ""} {
        if { $::GidPriv(PostAnimateVariosResultados) == "no"} {
            switch $::GidPriv(PostAnimate_cur_result_view) {
                "ShMinMax" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "ContourFill" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "VolumeRender" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "SmoothContourFill" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "ContourLines" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "SmoothContourLines" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "IsoSurfaces" {
                    ### set lst_valores [ lindex $::GidPriv(PostAnimateIsoSurfaces) 1]
                    ### GiD_Process Mescape Results $cur_resv Exact $cur_res $cur_comp \
                        ###     [ lindex $::GidPriv(PostAnimateIsoSurfaces) 0] {*}$lst_valores
                    # foreach val $lst_valores {
                        #         GiD_Process $val
                        # }
                }
                "DisplayVectors" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp \
                            $::GidPriv(PostAnimateDisplayVectors)  escape ]
                }
                "ContourRanges" {
                    lappend ret_line [ list Mescape Results $cur_resv $cur_res $cur_comp escape ]
                }
                "ScalarLineDiagram" {
                    lappend ret_line [ list \
                            Mescape Results LineDiagram ScalarDiagram $cur_res $cur_comp \
                            $::GidPriv(PostAnimateScalarDiagram)  escape ]
                }
                "VectorLineDiagram" {
                    lappend ret_line [ list \
                            Mescape Results LineDiagram VectorDiagram $cur_res \
                            $::GidPriv(PostAnimateVectorDiagram)  escape ]
                }
                "ResultSurface" {
                    lappend ret_line [ list \
                            Mescape Results $cur_resv $cur_res $cur_comp \
                            $::GidPriv(PostAnimateResultSurface) escape ]
                }
                "SmoothResultSurface" {
                    lappend ret_line [ list \
                            Mescape Results $cur_resv $cur_res $cur_comp \
                            $::GidPriv(PostAnimateResultSurface) escape ]
                }
                "LineThickness" {
                    lappend ret_line [ list \
                            Mescape Results $cur_resv $cur_res $cur_comp \
                            $::GidPriv(PostAnimateResultSurface) escape ]
                }
                "SmoothLineThickness" {
                    lappend ret_line [ list \
                            Mescape Results $cur_resv $cur_res $cur_comp \
                            $::GidPriv(PostAnimateResultSurface) escape ]
                }
                default {
                    #nothing
                }
            }
        }
    }
    return $ret_line
}

proc GetPostprocessFileLoadCommands {} {
    set ret_lines {}
    set is_post_command 0
    set also_postprocess 1
    set blocks_commands [Undo::GetCommandsUndo [GiD_Project batchfile get name] $also_postprocess]
    foreach block_command $blocks_commands {
        set commands [$block_command GetCommands]
        foreach command $commands {
            set c0 [lindex $command 0]
            if { $is_post_command } {
                if { $c0 == "Preprocess" } {
                    set is_post_command 0
                } elseif { $c0 == "Files" } {
                    set c1 [lindex $command 1]
                    if { $c1 == "Read" } {
                        set ret_lines $command
                    } elseif { $c1 == "ReadMultiple" } {
                        set ret_lines $command
                    } elseif { $c1 == "Add" } {
                        set ret_lines $command
                    }
                }
            } else {
                if { $c0 == "Postprocess" } {
                    set is_post_command 1
                }
            }
        }
    }
    return $ret_lines
}

proc CreateAnimationBatch { w} {
    set batch_name [ MessageBoxGetFilename imagefile write [_ "Save GiD batch file on"]... \
            {} {{{GiD batch file} {.bch}} {{All files} {.*}}} ".bch" ]    
    if { $batch_name == ""} {
        return
    }
    # verify some variables
    if { $::GidPriv(PostAnimateSaveAnimationFile) == ""} {
        PostAnimateChooseAnimationFile
        if { $::GidPriv(PostAnimateSaveAnimationFile) == ""} {
            return
        }
    }
    set root_name [ file root $batch_name]
    set fo [ open $batch_name w]    
    # save current view:
    GiD_Process MEscape View SaveView ${root_name}.vv escape escape escape escape
    # create batch
    puts $fo postprocess
    foreach w [GetPostprocessFileLoadCommands] {
        puts $fo $w
    }
    puts $fo "escape escape escape escape escape"
    # read saved view
    puts $fo "escape escape escape escape escape"
    puts $fo "View ReadView ${root_name}.vv"
    puts $fo "escape escape escape escape escape"
    # switch on / off meshes
    foreach t [ list volume surface cut] {
        foreach v [ GiD_Info postprocess get all_${t}sets] {
            foreach p [ list Massive Transparent EdgeWidth Visibility] {
                set cur_state [ GiD_Info postprocess get property $p $v]
                puts $fo "Utilities ChangeProperty ${t}Sets $v $p $cur_state"
                puts $fo "escape escape escape escape escape"
            }
            set p DisplayStyle
            set cur_state [ GiD_Info postprocess get property $p $v]
            regsub -all {_} $cur_state {} cur_state
            puts $fo "Utilities ChangeProperty ${t}Sets $v $p $cur_state"
            puts $fo "escape escape escape escape escape"
        }
    }
    
    # animation parameters
    set fmt [ PostAnimateWriteGIFOption $fo $::GidPriv(PostAnimateSaveAnimationFormat)]
    puts $fo "'AnimationFile Format $fmt"
    puts $fo "escape escape escape escape escape"
    set delay 0.1
    if { $::GidPriv(PostAnimateFixedDelay) && ( $::GidPriv(PostAnimateDelayTime) != "")} {
        set delay [ expr $::GidPriv(PostAnimateDelayTime) * 0.001]
    }
    puts $fo "'AnimationFile StepDelay $delay escape escape escape escape escape"
    # start animation
    puts $fo "'AnimationFile SetQuality $::GidPriv(PostAnimateAnimationFileQuality) escape escape escape escape"
    puts $fo "'AnimationFile Start $::GidPriv(PostAnimateSaveAnimationFile) Yes"
    puts $fo "escape escape escape escape escape"
    
    set all_steps $::GidPriv(PostAnimate_all_step)
    for { set i [ expr $::GidPriv(PostAnimateRangeFrameFrom) - 1]} { $i < $::GidPriv(PostAnimateRangeFrameTo)} { incr i} {
        set cur_step [ lindex $all_steps $i]
        puts $fo "escape escape escape escape escape Results AnalysisSel $::GidPriv(PostAnimate_cur_analysis) $cur_step"
        puts $fo "escape escape escape escape escape"
        
        # write result view
        foreach ln [GetCurrentResultsViewCommands $cur_step] {
            puts $fo $ln
        }
        puts $fo "escape escape escape escape escape"
        
        puts $fo "'AnimationFile AddStep"
    }
    
    # close animation
    puts $fo "'AnimationFile End"
    # let gif option to be no dithering
    set fmt [ PostAnimateProcessGIFOption $::GidPriv(PostAnimateSaveAnimationFormat)]
    if { $fmt == "GIF"} {
        PostAnimateWriteGIFOption $fo GIF/None
    }
    puts $fo "escape escape escape escape escape"
    puts $fo "quit no"    
    close $fo
    lassign [ GidUtils::GetMainDrawAreaSize ] gid_width gid_height
    set gid_exec gid_offscreen
    if { [ info exists ::env(INI_ARG_0)]} {
        set gid_exec $::env(INI_ARG_0)
    } else {
        set gid_exec [ file rootname $::argv0]
    }
    if { [ string first off $gid_exec] == -1} {
        if { ![ regsub {.exe} $gid_exec {_offscreen.exe} gid_exec]} {
            set gid_exec ${gid_exec}_offscreen
        }
    }
    
    WarnWin [_ "Animation batch file '%s' and view file '%s' written. Remember to launch the batch like this:\n%s" \
            $batch_name ${root_name}.vv "${gid_exec} -offscreen ${gid_width}x${gid_height} -b+g $batch_name"]
}

proc GetPostprocessCurrentResultsView {} {
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    set cur_step [ GiD_Info postprocess get cur_step $cur_analysis]
    set cur_res [ GiD_Info postprocess get cur_result]
    set cur_res_view  [ GiD_Info postprocess get cur_results_view]
    set cur_comp [ GiD_Info postprocess get cur_component]
    
    regsub -all {_} $cur_res_view {} result_view
    set restcommand [list escape escape escape escape results $result_view $cur_res $cur_comp]
    set no_res_command [list escape escape escape escape results Geometry NoResults]
    set no_def_command [list Geometry NoResults Geometry Original escape escape escape escape View Label Off]
    set iso_hecho 0
    switch $cur_res_view {
        "Iso_Surfaces" {
            set values [GiD_Info postprocess get iso_cur_result_values]
            set values [lindex $values 0]
            set lstVal [lindex $values 1]
            set restcommand [list $result_view exact $cur_res $cur_comp [lindex $values 0] {*}$lstVal escape ]
            set iso_hecho 1
        }
        "Stream_Lines" {
            set restcommand ""
        }
        "No_Result" {
            set restcommand ""
        }
        "Display_Vectors" {
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $cur_res $cur_analysis $cur_step]] } {
                set value [GiD_Info postprocess get cur_vector_factor $cur_res_view $cur_res $cur_analysis $cur_step]
            } else {
                set value 1.0
            }
            set restcommand [list {*}$restcommand $value escape]
        }
        "Result_Surface" {
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $cur_res $cur_analysis $cur_step]] } {
                set value [GiD_Info postprocess get cur_result_surface_factor $cur_res_view $cur_res $cur_comp $cur_analysis $cur_step]
            } else {
                set value 1.0
            }
            set restcommand [list {*}$restcommand $value escape]
        }
        "Line_Thickness" {
            if { [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $cur_res $cur_analysis $cur_step]] } {
                set value [GiD_Info postprocess get cur_result_surface_factor $cur_res_view $cur_res $cur_comp $cur_analysis $cur_step]
            } else {
                set value 1.0
            }
            set restcommand [list {*}$restcommand $value escape]
        }
        "Contour_Fill" {
            if { [string tolower [GiD_Set PostResOverRes]] == "yes"} {
                set restcommand [list {*}$no_res_command {*}$restcommand  escape ]
            }
        }
        "Volume_Render" {
            if { [string tolower [GiD_Set PostResOverRes]] == "yes"} {
                set restcommand [list {*}$no_res_command {*}$restcommand  escape ]
            }
        }
        default {
        }
    }
    return $restcommand
}

proc GetPostprocessSecondaryIsosurface {} {
    set iso_cmd ""
    set iso_res ""
    set iso_values [ lindex [ GiD_Info postprocess get iso_cur_result_values] 0]
    set iso_values [ lindex $iso_values 0]
    if { [ llength $iso_values] != 0} {
        set iso_res [ lindex $::GidPriv(PostAnimateIsoSurfaces) 2]
        set lstVal [lindex $iso_values 1]
        set iso_cmd "escape escape escape escape results IsoSurfaces Exact [ lindex $iso_res 0] [ lindex $iso_res 1]"
        set iso_cmd "$iso_cmd [ lindex $iso_values 0] {*}$lstVal escape "
    }
    return [ list $iso_cmd $iso_res]
}

proc FilesReloadPostprocess {} {
    set lst_load_files {}
    foreach w [ GetPostprocessFileLoadCommands] {
        lappend lst_load_files $w
    }
    set len_files [ llength $lst_load_files]    
    # if == 0 then it's from pre to postprocess.
    set msg [_ "Reload following files?"]
    append msg "\n$lst_load_files"
    set do_pre_post 0
    if { $len_files == 0} {
        set msg [_ "Change to preprocess and back to reload the files?"]
        set do_pre_post 1
    }
    set resp [GID_tk_messageBox -parent .gid -default no -title [_ "Confirm"] -type yesno \
            -icon warning \
            -message $msg]
    if { $resp == "no"} {
        return 0
    } else {
        # save current view
        set tmp_dir [ lindex [ GiD_Info project] 9]
        set tmp_view_name [ file join $tmp_dir ___reload_view.vv]
        GiD_Process Mescape View Save $tmp_view_name
        # get actual results visualization
        set cur_analysis [ GiD_Info postprocess get cur_analysis]
        set cur_step [ GiD_Info postprocess get cur_step $cur_analysis]
        set cur_res [ GiD_Info postprocess get cur_result]
        set cur_res_view  [ GiD_Info postprocess get cur_results_view]
        set cur_comp [ GiD_Info postprocess get cur_component]
        # get commands for actual results visualization
        set res_view_cmds [ GetPostprocessCurrentResultsView]
        if { [ lsearch res_view_cmds "IsoSurfaces"] == -1} {
            # check for isosurface as secondary results view ( like in filling process: cfill+iso)
            set extra_iso [ GetPostprocessSecondaryIsosurface]
            set extra_iso_cmds [ lindex $extra_iso 0]
            set extra_iso_res  [ lindex $extra_iso 1]
        }
        
        # load model again
        # first delete current postprocess data
        DoFilesNew AUTO
        if { $do_pre_post} {
            DoPreprocess Yes
            DoPostprocess
        } else {
            GiD_Process Mescape {*}$lst_load_files
        }
        
        PostAnimateDisableGUIUpdates
        # restore results visualization but for last time-step
        GiD_Process Mescape View Read $tmp_view_name
        file delete $tmp_view_name
        if { ( $cur_analysis == "") || ( $cur_step == "") || ( $cur_res_view == "")} {
            PostAnimateEnableGUIUpdates
            return 0
        }
        set no_res_command [list Mescape results Geometry NoResults]
        set no_def_command [list Geometry NoResults Geometry Original Mescape View Label Off]
        set all_steps [GiD_Info postprocess get all_steps $cur_analysis]
        set last_step [lindex $all_steps end]
        if { $last_step == ""} {
            WarnWin [_ "No steps for analysis '%s'" $cur_analysis]
            GiD_Process {*}$no_res_command
            GiD_Process {*}$no_def_command
            PostAnimateEnableGUIUpdates
            return 0
        }
        GiD_Process Mescape Results AnalysisSel $cur_analysis $last_step        
        # check if result(s) is present in last step
        if { $cur_res_view != "No_Result"} {
            set all_res [GiD_Info postprocess get results_list $cur_res_view $cur_analysis $last_step]
            if { [ lsearch $all_res $cur_res] == -1} {
                WarnWin [_ "Result '%s' not present in step '%s' of analysis '%s'" $cur_res $last_step $cur_analysis]
                GiD_Process {*}$no_res_command
                GiD_Process {*}$no_def_command
                PostAnimateEnableGUIUpdates
                return 0
            }
        }
        if { ( $extra_iso_res != "") && ( [lsearch $all_res [ lindex $extra_iso_res 0]] != -1)} {
            GiD_Process {*}$extra_iso_cmds
        }
        if { [llength $res_view_cmds] != 0} {
            GiD_Process {*}$res_view_cmds
        }
        
        PostAnimateEnableGUIUpdates
    }
}
