proc ParametricLine { } {
    global ParametricPriv
    set w .gid.parametricline
    # Conic Hexlix, 3 vueltas completas, de radio 4 a 1, altura=5
    #set ParametricPriv(xt) "(4*(1-t)+1*t)*sin(3*6.2832*t)"
    #set ParametricPriv(yt) "(4*(1-t)+1*t)*cos(3*6.2832*t)"
    #set ParametricPriv(zt) "5*t"
    set ParametricPriv(xt) ""
    set ParametricPriv(yt) ""
    set ParametricPriv(zt) ""
    set ParametricPriv(NumberPointsT) 50
    set ParametricPriv(t0) 0.0
    set ParametricPriv(t1) 1.0
    set ParametricPriv(OnlyPoints) 0
    # main winow creation
    InitWindow2 $w -title [_ "Create Parametric Line"] \
        -geometryvariable PreParametricLineWindowGeom \
        -initcommand ParametricLine -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    # wigets creation
    ttk::frame $w.frmEquations
    ttk::label $w.frmEquations.lx -text X(t)
    ttk::entry $w.frmEquations.ex -width 15 -textvariable ParametricPriv(xt)
    ttk::label $w.frmEquations.ly -text Y(t)
    ttk::entry $w.frmEquations.ey -width 15 -textvariable ParametricPriv(yt)
    ttk::label $w.frmEquations.lz -text Z(t)
    ttk::entry $w.frmEquations.ez -width 15 -textvariable ParametricPriv(zt)
    GidHelp "$w.frmEquations " \
        [_ "Parametric equations, valid all tcl funcions:\
        + - * / %%\
        abs cosh log sqrt acos double log10 srand asin exp pow\
        tan atan floor rand tanh atan2 fmod round ceil hypot sin\
        cos int sinh."]
    ttk::frame $w.frmParams
    ttk::label $w.frmParams.lt0 -text t0
    ttk::entry $w.frmParams.et0 -width 6 -textvariable ParametricPriv(t0)
    ttk::label $w.frmParams.lt1 -text t1
    ttk::entry $w.frmParams.et1 -width 6 -textvariable ParametricPriv(t1)

    ttk::frame $w.frmDivisions
    ttk::label $w.frmDivisions.lnpt -text [_ "Number of points"]
    UpDownEntry $w.frmDivisions.udnpt -variable ParametricPriv(NumberPointsT)\
        -entry-options "-width 4" \
        -up-command "IncrementNPT" -down-command "DecrementNPT"
    ttk::label $w.frmDivisions.lOnlyPoints -text [_ "Create only points"]
    if { ![info exists ParametricPriv(OnlyPoints)] } { set ParametricPriv(OnlyPoints) 0 }
    ttk::checkbutton $w.frmDivisions.chkOnlyPoints -variable ParametricPriv(OnlyPoints)

    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.btnApply -text [_ "Apply"] \
        -command "CreateParametricLine $w" \
        -underline 0 -style BottomFrame.TButton
    ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
        -command "destroy $w" \
        -underline 0 -style BottomFrame.TButton

    #empaquetamiento de los widgets
    grid $w.frmEquations -padx 5 -pady 5 -sticky ew
    grid $w.frmEquations.lx $w.frmEquations.ex -sticky e
    grid $w.frmEquations.ly $w.frmEquations.ey -sticky e
    grid $w.frmEquations.lz $w.frmEquations.ez -sticky e
    grid configure $w.frmEquations.ex $w.frmEquations.ey $w.frmEquations.ez -sticky ew
    grid columnconf $w.frmEquations 1 -weight 1

    grid $w.frmParams -padx 5 -pady 5 -sticky ew
    grid $w.frmParams.lt0 $w.frmParams.et0 $w.frmParams.lt1 $w.frmParams.et1 -sticky e
    grid configure $w.frmParams.et0  $w.frmParams.et1 -sticky ew
    grid columnconf $w.frmParams "1 3" -minsize 6 -weight 1

    grid $w.frmDivisions -padx 5 -pady 5 -sticky w
    grid $w.frmDivisions.lnpt $w.frmDivisions.udnpt -sticky w
    grid $w.frmDivisions.lOnlyPoints $w.frmDivisions.chkOnlyPoints -sticky w
    grid columnconf $w.frmDivisions 0 -weight 1

    grid $w.frmButtons -sticky ews -columnspan 7
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnApply $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconf $w "0" -weight 1
    grid rowconfigure $w "3" -weight 1

    focus $w.frmButtons.btnApply
    bind $w <Return> "$w.frmButtons.btnApply invoke"

    wm minsize $w 140 175
}

proc IncrementNPT { } {
    global ParametricPriv
    set ParametricPriv(NumberPointsT) [expr $ParametricPriv(NumberPointsT)+1]
}

proc DecrementNPT { } {
    global ParametricPriv
    if { $ParametricPriv(NumberPointsT) > 2} {
        set ParametricPriv(NumberPointsT) [expr $ParametricPriv(NumberPointsT)-1]
    } else {
        bell
    }
}

proc CreateParametricLine { w } {
    global ParametricPriv

    set fx $ParametricPriv(xt)
    set fy $ParametricPriv(yt)
    set fz $ParametricPriv(zt)

    if { ![string is double -strict $ParametricPriv(t0)] } {
        GID_tk_messageBox -parent $w -message [_ "Error, t0 must be a real number"] -type ok
        return
    }
    if { ![string is double -strict $ParametricPriv(t1)] } {
        GID_tk_messageBox -parent $w -message [_ "Error, t1 must be a real number"] -type ok
        return
    }
    if { ![string is integer -strict $ParametricPriv(NumberPointsT)] } {
        GID_tk_messageBox -parent $w -message [_ "Error, Number of points must be a positive integer >= 2"] -type ok
        return
    }
    if { $ParametricPriv(NumberPointsT) < 2 } {
        GID_tk_messageBox -parent $w -message [_ "Error, Number of points must be a positive integer >= 2"] -type ok
        return
    }
    # substitution t to $t in the formulas
    foreach {f} {fx fy fz} {
        regsub -all -nocase {\mt\M} [set $f] {$t} $f
    }

    GidUtils::DisableGraphics
    GidUtils::WaitState $w

    if { [ catch {
        set a $ParametricPriv(t0)
        set b [expr  ($ParametricPriv(t1)-$ParametricPriv(t0))/($ParametricPriv(NumberPointsT)-1.0)]
        set oldvalue [GiD_Set CreateAlwaysNewPoint]
        GiD_Process Mescape Utilities Variables CreateAlwaysNewPoint  1
        if { $ParametricPriv(OnlyPoints) } {
            GiD_Process Mescape Geometry Create Point
        } else {
            GiD_Process Mescape Geometry Create NurbsLine
        }
        for { set i 0 } { $i < $ParametricPriv(NumberPointsT) } { incr i} {
            set t [expr $a+$i*$b]
            set x [expr $fx]
            set y [expr $fy]
            set z [expr $fz]
            GiD_Process $x $y $z
        }
        GiD_Process escape
        GiD_Process MEscape Utilities Variables CreateAlwaysNewPoint $oldvalue
        GiD_Process MEscape
    } failstring ] } {
        GID_tk_messageBox -parent $w -message \
            [_ "Error, there is an error in the mathematical expression '%s'" $failstring] \
            -type ok
    }

    GidUtils::EnableGraphics
    GidUtils::EndWaitState $w
    GiD_Redraw
}

proc ParametricSurface { } {
    global ParametricPriv
    set w .gid.parametricsurface
    set ParametricPriv(x) "" ;#"cos(u)*(4+cos(v))"
    set ParametricPriv(y) "" ;#"sin(u)*(4+cos(v))"
    set ParametricPriv(z) "" ;#"4*sin(2*u)+sin(v)*(1.2-sin(v))"
    set ParametricPriv(NumberPointsU) 10
    set ParametricPriv(NumberPointsV) 15
    set ParametricPriv(u0) "0.0"
    set ParametricPriv(u1) "1.0" ;#"2.0*pi"
    set ParametricPriv(v0) "0.0"
    set ParametricPriv(v1) "1.0" ;#"2.0*pi"
    set ParametricPriv(a) ""
    set ParametricPriv(b) ""
    set ParametricPriv(c) ""
    set example ""
    set ParametricPriv(VisualOption) oneSurface
    set VisualOptionsNames [list [_ "Points"] [_ "Lines"] [_ "One Surface"] [_ "Multiple Surfaces"]]
    set VisualOptionsVars [list points lines oneSurface multSurface]

    #creating the main window
    InitWindow2 $w -title [_ "Create Parametric Surface"] \
        -geometryvariable PreParametricSurfaceWindowGeom \
        -initcommand ParametricSurface -ontop
    ttk::frame $w.examples
    ttk::label $w.examples.label -text [_ "Examples: "] -justify left
    #     ComboBox $w.examples.combo \
    #         -values [list [_ "Band Example"] [_ "Helicoid"] [_ "Catenoid"] [_ "Dinni"]] \
    #         -textvariable example -modifycmd {SampleParametricSurface $example} -editable 0

    set labels [list [_ "Band Example"] [_ "Helicoid"] [_ "Catenoid"] [_ "Dinni"]]
    set values {bandExample helicoid catenoid dinni}
    ComboBox $w.examples.combo \
        -values $labels -editable 0 \
        -modifycmd "SampleParametricSurface \[lindex [list $values] \[$w.examples.combo getvalue\]\]"

    #creating the widgets
    ttk::frame $w.frmEquations
    ttk::label $w.frmEquations.lx -text "X(u,v)"
    ttk::entry $w.frmEquations.ex -textvariable ParametricPriv(x)
    ttk::label $w.frmEquations.ly -text "Y(u,v)"
    ttk::entry $w.frmEquations.ey -textvariable ParametricPriv(y)
    ttk::label $w.frmEquations.lz -text "Z(u,v)"
    ttk::entry $w.frmEquations.ez -textvariable ParametricPriv(z)
    GidHelp "$w.frmEquations " \
        [_ "Parametric equations, valid all tcl funcions:\
        + - * / %%\
        abs cosh log sqrt acos double log10 srand asin exp pow\
        tan atan floor rand tanh atan2 fmod round ceil hypot sin\
        cos int sinh."]
    ttk::frame $w.frmParams
    ttk::label $w.frmParams.lu0 -text [_ "u in \["]
    ttk::entry $w.frmParams.eu0 -width 6 -textvariable ParametricPriv(u0)
    ttk::label $w.frmParams.lcomau -text ","
    ttk::entry $w.frmParams.eu1 -width 6 -textvariable ParametricPriv(u1)
    ttk::label $w.frmParams.lu1 -text "\]"
    ttk::label $w.frmParams.lv0 -text [_ "v in \["]
    ttk::entry $w.frmParams.ev0 -width 6 -textvariable ParametricPriv(v0)
    ttk::label $w.frmParams.lcomav -text ","
    ttk::entry $w.frmParams.ev1 -width 6 -textvariable ParametricPriv(v1)
    ttk::label $w.frmParams.lv1 -text "\]"

    ttk::frame $w.frmDivisions
    ttk::label $w.frmDivisions.lu -text [_ "Number of points U"]
    UpDownEntry $w.frmDivisions.numU -variable ParametricPriv(NumberPointsU)\
        -entry-options "-width 5" \
        -up-command "IncrementNPU" -down-command "DecrementNPU"
    ttk::label $w.frmDivisions.lv -text [_ "Number of points V"]
    UpDownEntry $w.frmDivisions.numV -variable ParametricPriv(NumberPointsV)\
        -entry-options "-width 5" \
        -up-command "IncrementNPV" -down-command "DecrementNPV"

    ttk::frame $w.frmOptions  -style sunken.TFrame
    for { set i 0 } { $i < [llength $VisualOptionsVars] } { incr i} {
        ttk::radiobutton $w.frmOptions.b$i -text [lindex $VisualOptionsNames $i] \
            -variable ParametricPriv(VisualOption) -value [lindex $VisualOptionsVars $i]
        pack $w.frmOptions.b$i -side left
    }

    set def_back [$w cget -background]
    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.btnApply -text [_ "Apply"] \
        -command "CreateParametricSurface $w" \
        -underline 0 -style BottomFrame.TButton
    ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
        -command "destroy $w" \
        -underline 0 -style BottomFrame.TButton
    #gridding the widgets
    grid $w.examples -padx 5 -pady 5
    grid $w.examples.label $w.examples.combo -sticky ews
    grid columnconfigure $w.examples 1 -weight 1
    grid rowconfigure $w.examples 1 -weight 1

    grid $w.frmEquations -padx 5 -pady 5 -sticky ew
    grid $w.frmEquations.lx $w.frmEquations.ex -sticky e
    grid $w.frmEquations.ly $w.frmEquations.ey -sticky e
    grid $w.frmEquations.lz $w.frmEquations.ez -sticky e
    grid configure $w.frmEquations.ex $w.frmEquations.ey $w.frmEquations.ez -sticky ew
    grid columnconfigure $w.frmEquations 1 -weight 1
    grid rowconfigure $w.frmEquations 1 -weight 1

    grid $w.frmParams
    grid $w.frmParams.lu0 $w.frmParams.eu0 $w.frmParams.lcomau $w.frmParams.eu1 $w.frmParams.lu1 -padx 5 -pady 6 ;#-row 2
    grid $w.frmParams.lv0 $w.frmParams.ev0 $w.frmParams.lcomav $w.frmParams.ev1 $w.frmParams.lv1 -padx 5 -pady 6 ;#-row 3
    grid columnconfigure $w.frmParams 1 -weight 1
    grid rowconfigure $w.frmParams 1 -weight 1

    grid $w.frmDivisions
    grid $w.frmDivisions.lu $w.frmDivisions.numU $w.frmDivisions.lv $w.frmDivisions.numV -padx 5 -pady 6 ;#-row 2;#-sticky w
    grid columnconfigure $w.frmDivisions 1 -weight 1
    grid rowconfigure $w.examples 1 -weight 1

    grid $w.frmOptions
    grid columnconfigure $w.frmOptions 1 -weight 1
    grid rowconfigure $w.frmOptions 1 -weight 1

    grid $w.frmButtons -sticky ews
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnApply $w.frmButtons.btnclose -padx 5 -pady 6

    grid columnconf $w 0 -weight 1
    grid rowconfigure $w 5 -weight 1
    focus $w.frmButtons.btnApply
    bind $w <Return> "$w.frmButtons.btnApply invoke"

    wm minsize $w 140 175
}

proc SampleParametricSurface { type } {
    global SampleParametricPriv

    set SampleParametricPriv(a1) ""
    set SampleParametricPriv(a2) ""
    if { $type == "helicoid" } {
        set title [_ "Helicoid Surface"]
        set image "helicoid2.png"
        set SampleParametricPriv(x) "u*cos(v)"
        set SampleParametricPriv(y) "u*sin(v)"
        set SampleParametricPriv(z) "a1*v"
        set SampleParametricPriv(u0) "0.0"
        set SampleParametricPriv(u1) "2*pi"
        set SampleParametricPriv(v0) "0.0"
        set SampleParametricPriv(v1) "2*pi"
        set SampleParametricPriv(a1) "2.0"
    } elseif { $type == "catenoid" } {
        set title [_ "Catenoid Surface"]
        set image "catenoid2.png"
        set SampleParametricPriv(x) "a1*cos(u)*cosh(v/a1)"
        set SampleParametricPriv(y) "v"
        set SampleParametricPriv(z) "a1*sin(u)*cosh(v/a1)"
        set SampleParametricPriv(u0) "0.0"
        set SampleParametricPriv(u1) "pi"
        set SampleParametricPriv(v0) "-2.0"
        set SampleParametricPriv(v1) "2.0"
        set SampleParametricPriv(a1) "2.0"
    } elseif { $type == "dinni" } {
        set title [_ "Dinni's Surface"]
        set image "dinni.png"
        set SampleParametricPriv(x) "a1*cos(u)*sin(v)"
        set SampleParametricPriv(y) "a1*sin(u)*sin(v)"
        set SampleParametricPriv(z) "a1*(cos(v)+log(tan((v/2))))+a2*u"
        set SampleParametricPriv(u0) "0.0"
        set SampleParametricPriv(u1) "4*pi"
        set SampleParametricPriv(v0) "0.001"
        set SampleParametricPriv(v1) "1.0"
        set SampleParametricPriv(a1) "1.0"
        set SampleParametricPriv(a2) "0.2"
    } elseif { $type == "bandExample" } {
        set title [_ "Band Example"]
        set image "bandExample.png"
        set SampleParametricPriv(x) "cos(u)*(4+cos(v))"
        set SampleParametricPriv(y) "sin(u)*(4+cos(v))"
        set SampleParametricPriv(z) "4*sin(2*u)+sin(v)*(1.2-sin(v))"
        set SampleParametricPriv(u0) "0"
        set SampleParametricPriv(u1) "2*pi"
        set SampleParametricPriv(v0) "0"
        set SampleParametricPriv(v1) "2*pi"
    }

    set w .gid.sampleparam
    InitWindow2 $w -title $title -geometryvariable PreSampleParametricSurfaceWindowGeom \
        -initcommand SampleParametricSurface -ontop
    ttk::frame $w.frmMain
    ttk::frame $w.frmMain.equ
    ttk::label $w.frmMain.equ.l1 \
        -text [concat [_ "Parametric equations"] \
        ":\nX(u,v)=$SampleParametricPriv(x)\nY(u,v)=$SampleParametricPriv(y)\nZ(u,v)=$SampleParametricPriv(z)"] \
        -justify left

    ttk::label $w.im -image [gid_themes::GetImage $image]
    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.btnApply -text [_ "Apply"] \
        -command "ApplyEquations ; destroy $w" -underline 0 \
        -style BottomFrame.TButton
    ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
        -command [list destroy $w] \
        -underline 0 -style BottomFrame.TButton

    grid $w.frmMain.equ.l1 -sticky ne -columnspan 2
    if { $SampleParametricPriv(a1) != "" } {
        label $w.frmMain.equ.la1 -text "a1="
        ttk::entry $w.frmMain.equ.ea1 -width 6 -textvariable SampleParametricPriv(a1)
        grid $w.frmMain.equ.la1 $w.frmMain.equ.ea1 -sticky w
        grid configure $w.frmMain.equ.ea1 -sticky ew
    }
    if { $SampleParametricPriv(a2) != "" } {
        label $w.frmMain.equ.la2 -text "a2="
        ttk::entry $w.frmMain.equ.ea2 -width 6 -textvariable SampleParametricPriv(a2)
        grid $w.frmMain.equ.la2 $w.frmMain.equ.ea2 -sticky w
        grid configure $w.frmMain.equ.ea2 -sticky ew
    }
    grid $w.frmMain.equ -sticky nsew
    grid $w.frmMain $w.im -sticky nsew
    grid rowconfigure $w.frmMain 0 -weight 1
    grid columnconfigure $w.frmMain 0 -weight 1

    grid $w.frmButtons -sticky ews -columnspan 2
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnApply $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 1 -weight 1
    focus $w.frmButtons.btnApply

    bind $w <Return> "$w.frmButtons.btnApply invoke"
    bind $w <Alt-c> "$w.frmButtons.btnclose invoke"
    bind $w <Escape> "$w.frmButtons.btnclose invoke"
    wm minsize $w 140 100
}

proc ApplyEquations { } {
    global SampleParametricPriv
    global ParametricPriv
    foreach i {x y z u0 u1 v0 v1} {
        #sustitution of a1,a2 by $SampleParametricPriv(a1),$SampleParametricPriv(a1)
        if { $SampleParametricPriv(a2)!= "" } {
            regsub -all -nocase {\ma1\M} $SampleParametricPriv($i) $SampleParametricPriv(a1) aux
            regsub -all -nocase {\ma2\M} $aux $SampleParametricPriv(a2) ParametricPriv($i)
        } elseif { $SampleParametricPriv(a1)!= ""} {
            regsub -all -nocase {\ma1\M} $SampleParametricPriv($i) $SampleParametricPriv(a1) ParametricPriv($i)
        } else {
            set ParametricPriv($i) $SampleParametricPriv($i)
        }
    }
}

proc IncrementNPU { } {
    global ParametricPriv
    set ParametricPriv(NumberPointsU) [expr $ParametricPriv(NumberPointsU)+1]
}

proc DecrementNPU { } {
    global ParametricPriv
    if { $ParametricPriv(NumberPointsU) > 3} {
        set ParametricPriv(NumberPointsU) [expr $ParametricPriv(NumberPointsU)-1]
    } else {
        bell
    }
}
proc IncrementNPV { } {
    global ParametricPriv
    set ParametricPriv(NumberPointsV) [expr $ParametricPriv(NumberPointsV)+1]
}

proc DecrementNPV { } {
    global ParametricPriv
    if { $ParametricPriv(NumberPointsV) > 3} {
        set ParametricPriv(NumberPointsV) [expr $ParametricPriv(NumberPointsV)-1]
    } else {
        bell
    }
}

proc CreateParametricSurface { w } {
    global ParametricPriv
    set fx $ParametricPriv(x)
    set fy $ParametricPriv(y)
    set fz $ParametricPriv(z)
    set u0 $ParametricPriv(u0)
    set u1 $ParametricPriv(u1)
    set v0 $ParametricPriv(v0)
    set v1 $ParametricPriv(v1)
    set numU $ParametricPriv(NumberPointsU)
    set numV $ParametricPriv(NumberPointsV)
    set option $ParametricPriv(VisualOption)
    set LayerNames [GiD_Layers list]
    if { ![string is double -strict $numU] } {
        WarnWin [_ "Error, U must be a real number"]
        return
    }
    if { ![string is double -strict $numV] } {
        WarnWin [_ "Error, V must be a real number"]
        return
    }
    # substitution of v,u,pi by $v,$u,$pi in the formulas
    set pi [expr 2*asin(1.0)]
    foreach {f} {fx fy fz u0 u1 v0 v1} {
        regsub -all -nocase {\mv\M} [set $f] {$v} $f
        regsub -all -nocase {\mu\M} [set $f] {$u} $f
        regsub -all -nocase {\mpi\M} [set $f] {$pi} $f
    }

    GidUtils::DisableGraphics
    GidUtils::WaitState $w

    if { [ catch {
        #save actual layer and generate a name for a auxiliar layer(name)
        set layerAct [GiD_Info Project LayerToUse]
        set n -1
        set ipos 0
        while { $ipos !=-1 } {
            set n [expr $n+1]
            set name aux$n
            set ipos [lsearch -exact [string tolower $LayerNames] [string tolower $name]]
        }
        #create auxiliar layer ($name)
        GiD_Process 'Layers New $name escape
        #create the surface
        set v [expr double($v0)]
        set u [expr double($u0)]
        set du [expr double(($u1-$u)/($numU-1))]
        set dv [expr double(($v1-$v)/($numV-1))]
        set dk [expr double($dv/8)]
        set firstPoint [expr [GiD_Info Geometry MaxNumPoints]+1]
        set firstLine [expr [GiD_Info Geometry MaxNumLines]+1]
        for { set i 0 } { $i < $numU } { incr i} {
            if { $option == "points" || $option == "multSurface"} {
                GiD_Process escape escape escape escape Geometry Create Point
            } elseif { $option == "lines" || $option == "oneSurface" } {
                GiD_Process escape escape escape escape Geometry Create NurbsLine
            }
            for { set j 0 } { $j < $numV } { incr j} {
                set x [expr double($fx)]
                set y [expr double($fy)]
                set z [expr double($fz)]
                GiD_Process $x $y $z
                if { ($option == "multSurface" || $option == "lines") && $j != [expr $numV-1] } {
                    GiD_Process escape escape escape escape Geometry Create NurbsLine join
                    set auxPoint [expr $firstPoint+$i*$numV+$j]
                    GiD_Process $auxPoint
                    GiD_Process noJoin
                    for {set k 0} { $k<7 } {incr k} {
                        set v [expr $v+$dk]
                        set x [expr double($fx)]
                        set y [expr double($fy)]
                        set z [expr double($fz)]
                        GiD_Process $x $y $z
                    }
                    set v [expr $v+$dk]
                } else {
                    set v [expr $v+$dv]
                }
            }
            set u [expr $u+$du]
            set v [expr double($v0)]
        }
        GiD_Process escape escape escape escape
        if { $option == "oneSurface" } {
            set lines_near_parallel [GiD_Geometry list -layer $name line]
            set surface_id [GiD_Geometry -v2 create surface append nurbssurface $name -interpolate $lines_near_parallel]
            if { !$surface_id  } {
                WarnWin [_ "Sorry, but a single surface can not be created. Try multiple surfaces"]
            }
            GiD_Process escape escape escape Geometry Delete Line layer:$name escape escape
            GiD_Process Geometry Delete Point layer:$name escape escape
        } elseif { $option == "multSurface" || $option == "lines"} {
            set v [expr double($v0)]
            set u [expr double($u0)]
            set dk [expr double($du/8)]
            for { set j 0 } { $j < $numV } { incr j} {
                for { set i 0 } { $i < ($numU-1) } { incr i} {
                    GiD_Process escape Geometry Create NurbsLine Join
                    GiD_Process [expr $firstPoint+$j+$i*$numV]
                    GiD_Process noJoin
                    for {set k 0} { $k<7 } {incr k} {
                        set u [expr $u+$dk]
                        set x [expr double($fx)]
                        set y [expr double($fy)]
                        set z [expr double($fz)]
                        GiD_Process $x $y $z
                    }
                    set u [expr $u+$dk]
                    set aux [expr $j+$firstPoint+($i+1)*$numV]
                    GiD_Process Join $aux
                }
                set u [expr double($u0)]
                set v [expr $v+$dv]
                GiD_Process escape escape escape
            }
            GiD_Process [expr $j+$firstPoint]
            if { $option == "multSurface" } {
                set lBottomAux [expr $firstLine+($numV-1)*$numU]
                for { set i 0 } { $i < $numU } { incr i} {
                    set lBottom [expr $lBottomAux+$i]
                    set lRight [expr $firstLine+$i*($numV-1)]
                    for { set j 0 } { $j < $numV } { incr j} {
                        set lLeft [expr $lRight+$numV-1]
                        set lTop [expr $lBottom+($numU-1)]
                        GiD_Process escape escape Geometry Create NurbsSurface $lRight $lLeft $lBottom $lTop escape escape
                        incr lRight
                        set lBottom $lTop
                    }
                }
            }
        }
        #move surface to actual layer
        if { $option == "points" } {
            GiD_Process 'Layers Entities $layerAct points layer:$name
        } elseif { $option == "multSurface" || $option == "oneSurface" } {
            GiD_Process 'Layers Entities $layerAct LowerEntities Surfaces layer:$name
        } elseif { $option == "lines" } {
            GiD_Process 'Layers Entities $layerAct LowerEntities lines layer:$name
        }
        GiD_Process escape
        GiD_Process escape Geometry Delete Line layer:$name escape escape
        GiD_Process Geometry Delete Point layer:$name escape escape

        #delete auxiliar layer
        GiD_Process 'Layers Delete $name
    } failstring ] } {
        GiD_Process escape escape escape
        GiD_Process escape Geometry Delete AllTypes layer:$name escape escape
        GiD_Process 'Layers Delete $name
        WarnWin [_ "Error, there is an error in the mathematical expression ($failstring)"]
    }

    GidUtils::EnableGraphics
    GidUtils::EndWaitState $w
    GiD_Redraw
}
