
proc PageitemStartDrag {c x y tag} {
    global PageSetup
    set PageSetup(lastX) $x
    set PageSetup(lastY) $y
    #$c dtag $tag
    #$c addtag $tag withtag current
    #$c raise current
}

proc PageitemDrag {c x y} {
    global PageSetup
#     set x [$c canvasx $x]
#     set y [$c canvasy $y]
    set taglist [ $c gettags current]
    set PageSetup(ChangingMarginEntries) 2
    set factor $PageSetup(CurrentFactorCanvas)
    if { $PageSetup(PageUnits) == "In"} {
	set factor [ expr $PageSetup(CurrentFactorCanvas)*$PageSetup(In2mm)]
    }
    if { [ lsearch $taglist left] != -1} {
	$c move current [expr $x-$PageSetup(lastX)] 0
	set PageSetup(EntryLeft) [ expr $PageSetup(EntryLeft) + \
		( $x - $PageSetup(lastX)) / $factor]
    } elseif { [ lsearch $taglist right] != -1} {
	$c move current [expr $x-$PageSetup(lastX)] 0
	set PageSetup(EntryRight) [ expr $PageSetup(EntryRight) - \
		( $x - $PageSetup(lastX)) / $factor]
    } elseif { [ lsearch $taglist top] != -1} {
	$c move current 0 [expr $y-$PageSetup(lastY)]
	set PageSetup(EntryTop) [ expr $PageSetup(EntryTop) + \
		( $y - $PageSetup(lastY)) / $factor]
    } elseif { [ lsearch $taglist bottom] != -1} {
	$c move current 0 [expr $y-$PageSetup(lastY)]
	set PageSetup(EntryBottom) [ expr $PageSetup(EntryBottom) - \
		( $y - $PageSetup(lastY)) / $factor]
    }
    set PageSetup(ChangingMarginEntries) 0
    set PageSetup(lastX) $x
    set PageSetup(lastY) $y
}

proc PageFillDefaults {} {
    global PageSetup

    if { ![ info exists PageSetup(In2mm)]} {
	set PageSetup(In2mm)  25.4 ;#25.3955838340800426
    }

    set page_dim [GiD_Info postprocess get pagedimensions]
    # en pulgadas: PS_PAGE_X, PS_PAGE_Y, PS_TAM_X, PS_TAM_Y, PS_TAM_W, PS_TAM_H, landscape/portrait
    #puts $page_dim

    set pagewidth [ lindex $page_dim 0]
    set pageheight [ lindex $page_dim 1]
    set leftmargin [ lindex $page_dim 2]
    set topmargin [ lindex $page_dim 3]
    set imgwidth [ lindex $page_dim 4]
    set imgheight [ lindex $page_dim 5]
    set resol [ lindex $page_dim 7]

    if { [ lindex $page_dim 6] == "landscape"} {
	set PageSetup(PageOrientation) "Landscape"
	set maxwidth $pageheight
	set maxheight $pagewidth
    } else {
	set PageSetup(PageOrientation) "Portrait"
	set maxwidth $pagewidth
	set maxheight $pageheight
    }

    if { ( [ expr $leftmargin + $imgwidth] > $maxwidth) || \
	    ( [ expr $topmargin + $imgheight] > $maxheight)} {
	set pp $imgwidth
	set imgwidth $imgheight
	set imgheight $pp
    }

    set PageSetup(DefaultMarginTop) [ expr $topmargin * $PageSetup(In2mm)]
    set PageSetup(DefaultMarginLeft)  [ expr $leftmargin * $PageSetup(In2mm)]
    if { [ lindex $page_dim 6] == "landscape"} {
	set PageSetup(DefaultMarginBottom) [ expr ( $pagewidth - $topmargin - $imgheight) \
		* $PageSetup(In2mm)]
	set PageSetup(DefaultMarginRight) [ expr ( $pageheight - $leftmargin - $imgwidth) \
		* $PageSetup(In2mm)]
    } else {
	set PageSetup(DefaultMarginBottom) [ expr ( $pageheight - $topmargin - $imgheight) \
		* $PageSetup(In2mm)]
	set PageSetup(DefaultMarginRight) [ expr ( $pagewidth - $leftmargin - $imgwidth) \
		* $PageSetup(In2mm)]
    }
    set PageSetup(DefaultPageWidth) [ expr $pagewidth * $PageSetup(In2mm)]
    set PageSetup(DefaultPageHeight) [ expr $pageheight * $PageSetup(In2mm)]
    set PageSetup(DefaultWidth) 20
    set PageSetup(DefaultHeight) 20

    set PageSetup(DefaultMarginTop) [ format %.4g $PageSetup(DefaultMarginTop)]
    set PageSetup(DefaultMarginBottom) [ format %.4g $PageSetup(DefaultMarginBottom)]
    set PageSetup(DefaultMarginLeft) [ format %.4g $PageSetup(DefaultMarginLeft)]
    set PageSetup(DefaultMarginRight) [ format %.4g $PageSetup(DefaultMarginRight)]
    set PageSetup(DefaultPageWidth) [ format %.3g $PageSetup(DefaultPageWidth)]
    set PageSetup(DefaultPageHeight) [ format %.3g $PageSetup(DefaultPageHeight)]

    set HardcopyOptions [ GiD_Info postprocess get HardcopyOptions]

    set ::PageSetup(AutoCrop) [ lindex $HardcopyOptions 1]
    set ::PageSetup(WhiteBGOnImages) [ lindex $HardcopyOptions 2]
    set ::PageSetup(WhiteBGOnAnimations) [ lindex $HardcopyOptions 3]
    set ::PageSetup(TranspBGOnImages) [ lindex $HardcopyOptions 4]
    set ::PageSetup(TranspBGOnAnimations) [ lindex $HardcopyOptions 5]
    set ::PageSetup(DrawBGImagesOnImages) [ lindex $HardcopyOptions 6]
    set ::PageSetup(DrawBGImagesOnAnimations) [ lindex $HardcopyOptions 7]

    set ::PageSetup(DontSaveTransparencyLayerInImages) [ GiD_Set DontSaveTransparencyLayerInImages]
    set ::PageSetup(DontSaveTransparencyLayerInAnimations) [ GiD_Set DontSaveTransparencyLayerInAnimations]

    set ::PageSetup(PageResolution) $resol
}

proc PageAcceptEntry { cual } {
    global PageSetup

    #set PageSetup(Entry$cual) $PageSetup(Entry$cual)
    PageChangeEntry$cual "" "" ""
}

proc ChangeCenteredPage { cv width height} {
    global PageSetup

    set min $PageSetup(PageCanvasWidth)
    if { $PageSetup(PageCanvasHeight) < $min} {
	set min $PageSetup(PageCanvasHeight)
    }

    set factor [ expr $min * $PageSetup(FactorCanvas) ]
    
    set x1 -1
    set y1 -1
    for {} { ( $x1 < 0.0) || ( $y1 < 0.0)} {} {
	set w [ expr $width * $factor]
	set h [ expr $height * $factor]
	set x1 [ expr ( $PageSetup(PageCanvasWidth) - $w ) / 2 ]
	set y1 [ expr ( $PageSetup(PageCanvasHeight) - $h ) / 2 ]
	set factor [ expr $factor * 0.5]
    }
    set factor [ expr $factor * 2.0]

    set PageSetup(CurrentFactorCanvas) $factor

    #$cv create rectangle 1 1 $PageSetup(PageCanvasWidth) $PageSetup(PageCanvasHeight) -outline red

    # la sombra
    if { [ info exists PageSetup(PageViewSombra) ] } {
	$cv delete $PageSetup(PageViewSombra)
    }
    set PageSetup(PageViewSombra) [ $cv create rectangle [ expr $x1 + 6] [ expr $y1 + 4]  \
	    [ expr $x1 + $w + 6] [ expr $y1 + $h + 4] \
	    -fill grey60 -outline grey60]

    if { [ info exists PageSetup(PageView) ] } {
	$cv delete $PageSetup(PageView)
    }
    set PageSetup(PageView) [ $cv create rectangle $x1 $y1 [ expr $x1 + $w] [ expr $y1 + $h] \
	    -fill white -outline black]

    if { [ info exists PageSetup(ImageView) ] } {
	$cv delete $PageSetup(ImageView)
    }
    set ml [ expr $PageSetup(MarginLeft) * $factor]
    set mr [ expr $PageSetup(MarginRight) * $factor]
    set mt [ expr $PageSetup(MarginTop) * $factor]
    set mb [ expr $PageSetup(MarginBottom) * $factor]
    set PageSetup(ImageView) [ $cv create rectangle [ expr $x1 + $ml] [ expr $y1 + $mt] \
	    [ expr $x1 + $w - $mr] [ expr $y1 + $h - $mb] \
	    -fill black -outline black]

    if { [ info exists PageSetup(PageViewImagen) ] } {
	$cv delete $PageSetup(PageViewImagen)
    }
    set midx [ expr ( $x1 + $ml + $x1 + $w - $mr) / 2.0]
    set midy [ expr ( $y1 + $mt + $y1 + $h - $mb) / 2.0]

    set PageSetup(GiDImage) \
	 [ image create photo -data \
	       [ GiD_Thumbnail get -width [ expr int( $w - $mr - $ml)] -height [ expr int( $h - $mb - $mt)]]]

    set PageSetup(PageViewImagen) [ $cv create image $midx $midy \
	    -image $PageSetup(GiDImage) -anchor center]

    # Margenes
    if { [ info exists PageSetup(PageViewLeftMargin)] } {
	$cv delete $PageSetup(PageViewLeftMargin)
	$cv dtag left
    }
    set PageSetup(PageViewLeftMargin) [ $cv create line [ expr $x1 + $ml] 0 \
	    [ expr $x1 + $ml] $PageSetup(PageCanvasHeight) -fill grey60]
    $cv addtag left withtag $PageSetup(PageViewLeftMargin)
    $cv bind left <1> "PageitemStartDrag $cv %x %y left"
    $cv bind left <Any-Enter> "$cv itemconfig current -fill red"
    $cv bind left <Any-Leave> "$cv itemconfig current -fill grey60"
    $cv bind left <ButtonRelease-1> "PageAcceptEntry Left"

    if { [ info exists PageSetup(PageViewRightMargin)] } {
	$cv delete $PageSetup(PageViewRightMargin)
	$cv dtag right
    }
    set PageSetup(PageViewRightMargin) [ $cv create line [ expr $x1 + $w - $mr] 0 \
	    [ expr $x1 + $w - $mr] $PageSetup(PageCanvasHeight) -fill grey60]
    $cv addtag right withtag $PageSetup(PageViewRightMargin)
    $cv bind right <1> "PageitemStartDrag $cv %x %y right"
    $cv bind right <Any-Enter> "$cv itemconfig current -fill red"
    $cv bind right <Any-Leave> "$cv itemconfig current -fill grey60"
    $cv bind right <ButtonRelease-1> "PageAcceptEntry Right"

    if { [ info exists PageSetup(PageViewTopMargin)] } {
	$cv delete $PageSetup(PageViewTopMargin)
	$cv dtag top
    }
    set PageSetup(PageViewTopMargin) [ $cv create line 0 [ expr $y1 + $mt]\
	    $PageSetup(PageCanvasWidth) [ expr $y1 + $mt] -fill grey60]
    $cv addtag top withtag $PageSetup(PageViewTopMargin)
    $cv bind top <1> "PageitemStartDrag $cv %x %y top"
    $cv bind top <Any-Enter> "$cv itemconfig current -fill red"
    $cv bind top <Any-Leave> "$cv itemconfig current -fill grey60"
    $cv bind top <ButtonRelease-1> "PageAcceptEntry Top"

    if { [ info exists PageSetup(PageViewBottomMargin)] } {
	$cv delete $PageSetup(PageViewBottomMargin)
	$cv dtag bottom
    }
    set PageSetup(PageViewBottomMargin) [ $cv create line 0  [ expr $y1 + $h - $mb] \
	    $PageSetup(PageCanvasWidth) [ expr $y1 + $h - $mb] -fill grey60]
    $cv addtag bottom withtag $PageSetup(PageViewBottomMargin)
    $cv bind bottom <1> "PageitemStartDrag $cv %x %y bottom"
    $cv bind bottom <Any-Enter> "$cv itemconfig current -fill red"
    $cv bind bottom <Any-Leave> "$cv itemconfig current -fill grey60"
    $cv bind bottom <ButtonRelease-1> "PageAcceptEntry Bottom"
    PageSetupActualizeImageInfo
}

proc PageDefaultMargins {} {
    global PageSetup

    if { $PageSetup(PageUnits) == "In"} {
	set PageSetup(EntryTop) [ expr $PageSetup(DefaultMarginTop) / $PageSetup(In2mm)]
	set PageSetup(EntryBottom) [ expr $PageSetup(DefaultMarginBottom) / $PageSetup(In2mm)]
	set PageSetup(EntryLeft) [ expr $PageSetup(DefaultMarginLeft) / $PageSetup(In2mm)]
	set PageSetup(EntryRight) [ expr $PageSetup(DefaultMarginRight) / $PageSetup(In2mm)]
    } else {
	set PageSetup(EntryTop) $PageSetup(DefaultMarginTop)
	set PageSetup(EntryBottom) $PageSetup(DefaultMarginBottom)
	set PageSetup(EntryLeft) $PageSetup(DefaultMarginLeft)
	set PageSetup(EntryRight) $PageSetup(DefaultMarginRight)
    }
    PageSetupActualizeImageInfo
}

proc PageChangeOrientation { name1 name2 op} {
    global PageSetup

    if { $PageSetup(PageOrientation) == "Landscape" } {
	# Landscape
	ChangeCenteredPage $PageSetup(PageCanvas) $PageSetup(PageHeightMM) $PageSetup(PageWidthMM)
	if { $PageSetup(PageUnits) == "In"} {
	    set PageSetup(EntryWidth) $PageSetup(PageHeightP)
	    set PageSetup(EntryHeight) $PageSetup(PageWidthP)
	} else {
	    set PageSetup(EntryWidth) $PageSetup(PageHeightMM)
	    set PageSetup(EntryHeight) $PageSetup(PageWidthMM)
	}
    } else {
	# Portrait
	ChangeCenteredPage $PageSetup(PageCanvas) $PageSetup(PageWidthMM) $PageSetup(PageHeightMM)
	if { $PageSetup(PageUnits) == "In"} {
	    set PageSetup(EntryWidth) $PageSetup(PageWidthP)
	    set PageSetup(EntryHeight) $PageSetup(PageHeightP)
	} else {
	    set PageSetup(EntryWidth) $PageSetup(PageWidthMM)
	    set PageSetup(EntryHeight) $PageSetup(PageHeightMM)
	}
    }

    if { $name1 != ""} {
	PageAcceptEntry Top
	PageAcceptEntry Bottom
	PageAcceptEntry Left
	PageAcceptEntry Right
    }

    PageSetupActualizeImageInfo
}

proc PageChangePulgadas { } {
    global PageSetup

    set PageSetup(ChangingMarginEntries) 1
    if { $PageSetup(PageUnits) == "In"} {
	set PageSetup(EntryTop) [ expr $PageSetup(MarginTop) / $PageSetup(In2mm)]
	set PageSetup(EntryBottom) [ expr $PageSetup(MarginBottom) / $PageSetup(In2mm)]
	set PageSetup(EntryLeft) [ expr $PageSetup(MarginLeft) / $PageSetup(In2mm)]
	set PageSetup(EntryRight) [ expr $PageSetup(MarginRight) / $PageSetup(In2mm)]
	if { $PageSetup(PageOrientation) == "Landscape" } {
	    set PageSetup(EntryWidth) $PageSetup(PageHeightP)
	    set PageSetup(EntryHeight) $PageSetup(PageWidthP)
	} else {
	    set PageSetup(EntryWidth) $PageSetup(PageWidthP)
	    set PageSetup(EntryHeight) $PageSetup(PageHeightP)
	}
    } else {
	if { $PageSetup(PageOrientation) == "Landscape" } {
	    set PageSetup(EntryWidth) $PageSetup(PageHeightMM)
	    set PageSetup(EntryHeight) $PageSetup(PageWidthMM)
	} else {
	    set PageSetup(EntryWidth) $PageSetup(PageWidthMM)
	    set PageSetup(EntryHeight) $PageSetup(PageHeightMM)
	}
	set PageSetup(EntryTop) $PageSetup(MarginTop)
	set PageSetup(EntryBottom) $PageSetup(MarginBottom)
	set PageSetup(EntryLeft) $PageSetup(MarginLeft)
	set PageSetup(EntryRight) $PageSetup(MarginRight)
    }

    set PageSetup(ChangingMarginEntries) 0

    PageSetupActualizeImageInfo
}

proc PageSetupActualizeImageInfo {} {
    set RealResolutionFactor 1.0

    if { $::PageSetup(PageUnits) == "In"} {
	if { $::PageSetup(PageOrientation) == "Landscape" } {
	    set Wimage [ expr $::PageSetup(PageHeightP) - \
		             ( $::PageSetup(MarginLeft) + $::PageSetup(MarginRight))]
	    set Himage [ expr $::PageSetup(PageWidthP) - \
		             ( $::PageSetup(MarginTop) + $::PageSetup(MarginBottom))]
	} else {
	    set Wimage [ expr $::PageSetup(PageWidthP) - \
		             ( $::PageSetup(MarginLeft) + $::PageSetup(MarginRight))]
	    set Himage [ expr $::PageSetup(PageHeightP) - \
		             ( $::PageSetup(MarginTop) + $::PageSetup(MarginBottom))]
	}
    } else {
	if { $::PageSetup(PageOrientation) == "Landscape" } {
	    set Wimage [ expr $::PageSetup(PageHeightMM) - \
		             ( $::PageSetup(MarginLeft) + $::PageSetup(MarginRight))]
	    set Himage [ expr $::PageSetup(PageWidthMM) - \
		             ( $::PageSetup(MarginTop) + $::PageSetup(MarginBottom))]
	} else {
	    set Wimage [ expr $::PageSetup(PageWidthMM) - \
		             ( $::PageSetup(MarginLeft) + $::PageSetup(MarginRight))]
	    set Himage [ expr $::PageSetup(PageHeightMM) - \
		             ( $::PageSetup(MarginTop) + $::PageSetup(MarginBottom))]
	}
	set RealResolutionFactor [ expr 1.0 / $::PageSetup(In2mm)]
    }

    # ::PageSetup(PageResolution) Screen
    set img_width [ lindex [ .central.s configure -width] 4]
    set img_height [ lindex [ .central.s configure -height] 4]
    set img_aspec [ expr double( $img_width) / double( $img_height)]

    # two digits
    # set ::PageSetup(Image,DimWidth) [ format "%.7g" [ expr 0.01 * int( 100.0 * $Wimage)]]
    # set ::PageSetup(Image,DimHeight) [ format "%.7g" [ expr 0.01 * int( 100.0 * $Himage)]]
    set paper_aspec [ expr double( $Wimage) / double( $Himage)]

    set factor_w [ expr $Wimage / $img_width]
    set factor_h [ expr $Himage / $img_height]
    set factor_min $factor_w
    if { $factor_h < $factor_min} {
	set factor_min $factor_h
    }

    set RealWidth [ expr 0.01 * int( 100.0 * $img_width * $factor_min)]
    set RealHeight [ expr 0.01 * int( 100.0 * $img_height * $factor_min)]

    set ::PageSetup(Image,DimWidth) [ format "%.7g" $RealWidth]
    set ::PageSetup(Image,DimHeight) [ format "%.7g" $RealHeight]

    if { "$::PageSetup(PageResolution)" == "Screen"} {
	set ::PageSetup(Image,PixWidth) $img_width
	set ::PageSetup(Image,PixHeight) $img_height
    } else {
	set actual_res $::PageSetup(PageResolution)
	if { $actual_res == "other"} {
	    set actual_res $::PageSetup(PageUserResolution)
	}
	if { "$actual_res" != ""} {
	    set actual_res [ expr $actual_res * $RealResolutionFactor]
	    set ::PageSetup(Image,PixWidth) [ expr int( $actual_res * $RealWidth)]
	    set ::PageSetup(Image,PixHeight) [ expr int( $actual_res * $RealHeight)]
	}
    }
}

proc PageSetupAccept { w} {
    global PageSetup

    set line "'Hardcopy Options Orientation"
    if { $PageSetup(PageOrientation) == "Landscape" } {
	lappend line Landscape
    } else {
	lappend line Portrait
    }

    lappend line Resolution
    if { $PageSetup(PageResolution) != [_ "other"] } {
	lappend line $PageSetup(PageResolution)
    } else {
	if { $PageSetup(PageUserResolution) != "" } {
	    lappend line $PageSetup(PageUserResolution)
	} else {
	    lappend line Screen
	}
    }

    GiD_Process {*}$line escape
    set line "'Hardcopy Options"

    set Wpage $PageSetup(PageWidthP)
    set Hpage $PageSetup(PageHeightP)
    if { $PageSetup(PageOrientation) == "Landscape" } {
	set Wimage [ expr $PageSetup(PageHeightP) - \
		( $PageSetup(MarginLeft) + $PageSetup(MarginRight)) / $PageSetup(In2mm)]
	set Himage [ expr $PageSetup(PageWidthP) - \
		( $PageSetup(MarginTop) + $PageSetup(MarginBottom)) / $PageSetup(In2mm)]
    } else {
	set Wimage [ expr $PageSetup(PageWidthP) - \
		( $PageSetup(MarginLeft) + $PageSetup(MarginRight)) / $PageSetup(In2mm)]
	set Himage [ expr $PageSetup(PageHeightP) - \
		( $PageSetup(MarginTop) + $PageSetup(MarginBottom)) / $PageSetup(In2mm)]
    }
    set Wmargin [ expr $PageSetup(MarginLeft) / $PageSetup(In2mm)]
    set Hmargin [ expr $PageSetup(MarginTop) / $PageSetup(In2mm)]

    lappend line Width $Wpage Height $Hpage WImage $Wimage HImage $Himage \
	    WMargin $Wmargin HMargin $Hmargin escape

    GiD_Process {*}$line
    foreach opt [ list AutoCrop WhiteBGOnImages WhiteBGOnAnimations TranspBGOnImages TranspBGOnAnimations \
		      DrawBGImagesOnImages DrawBGImagesOnAnimations] {
	if { $PageSetup($opt)} {
	    GiD_Process 'Hardcopy Options $opt Yes escape
	} else {
	    GiD_Process 'Hardcopy Options $opt No escape
	}
    }
    if { [ GiD_Set DontSaveTransparencyLayerInImages] != $::PageSetup(DontSaveTransparencyLayerInImages)} {
	GiD_Set DontSaveTransparencyLayerInImages $::PageSetup(DontSaveTransparencyLayerInImages)
    }
    if { [ GiD_Set DontSaveTransparencyLayerInAnimations] != $::PageSetup(DontSaveTransparencyLayerInAnimations)} {
	GiD_Set DontSaveTransparencyLayerInAnimations $::PageSetup(DontSaveTransparencyLayerInAnimations)
    }
    # actualizamos el canvas con el preview
    PageChangeOrientation "" "" ""
}

proc PageResizeCanvas { width height} {
    global PageSetup

    if { [ info exists ::PageSetup(busy)] && $::PageSetup(busy)} {
	return
    }	
    set ::PageSetup(busy) 1
    
    set PageSetup(PageCanvasWidth) [ expr $width - 10]
    set PageSetup(PageCanvasHeight) [ expr $height - 10]

    if { $PageSetup(PageCanvasWidth) < 150} {
	set PageSetup(PageCanvasWidth) 150
    }
    if { $PageSetup(PageCanvasHeight) < 150} {
	set PageSetup(PageCanvasHeight) 150
    }

    $PageSetup(PageCanvas) configure -width $PageSetup(PageCanvasWidth)
    $PageSetup(PageCanvas) configure -height $PageSetup(PageCanvasHeight)

    PageChangeOrientation "" "" ""

    update
    
    set ::PageSetup(busy) 0
}

proc PageChangeSize { } {
    global PageSetup
    set i $PageSetup(PageSize)
    set PageSetup(PageWidthMM) $PageSetup(PageSizeList,$i,WidthMM)
    set PageSetup(PageHeightMM) $PageSetup(PageSizeList,$i,HeightMM)
    set PageSetup(PageWidthP) $PageSetup(PageSizeList,$i,WidthP)
    set PageSetup(PageHeightP) $PageSetup(PageSizeList,$i,HeightP)

    PageChangeOrientation "" "" ""
}

proc PageReadSizes { file} {
    global PageSetup

    set PageSetup(NumPageSizes) 0
    set PageSetup(MinFactorCanvas) 200
    set PageSetup(FactorCanvas) 200
    set res [ catch { set fi [ open $file]} ]
    if { !$res} {
	while { ![ eof $fi] } {
	    gets $fi line
	    if { ( [ string index $line 0] != "#") && ( [ llength $line] >= 3)} {
		if { [ regexp ^(\[0-9\]*.?\[0-9\]+)x(\[0-9\]*.?\[0-9\]+)$ [ lindex $line 1] \
		        sizeP wP hP] && \
		        [ regexp ^(\[0-9\]*.?\[0-9\]+)x(\[0-9\]*.?\[0-9\]+)$ [ lindex $line 2] \
		        sizeMM wMM hMM] } {
		    # primer campo: nombre
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),Name) [ lindex $line 0]
		    # segundo campo: tamanyo en pulgadas
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),WidthP) $wP
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),HeightP) $hP
		    # tercer campo: tamanyo en milimetros
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),WidthMM) $wMM
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),HeightMM) $hMM
		    incr PageSetup(NumPageSizes)
		
		    if { $wMM > $PageSetup(FactorCanvas) } {
		        set PageSetup(FactorCanvas) $wMM
		    }
		    if { $hMM > $PageSetup(FactorCanvas) } {
		        set PageSetup(FactorCanvas) $hMM
		    }
		}
	    }
	}
	close $fi
    } else {
	# Tambien se puede tener esta informacion en el archivo $GIDDEFAULT/scripts/PageSizes.txt
	# 1 inch = 25.3955838340800426
	set pagelist { \
		"A4      8.27x11.69  210x297" "A3      11.69x16.54 297x420" \
		"A5      5.83x8.27   148x210" "B4      9.84x13.9   250x353" \
		"B5      6.93x9.84   176x250" "Letter  8.5x11      216x280" \
		"Legal   8.5x14      216x356" "Tabloid 11.01x16.98 280x431"  }
	#B6      4.92x6.93   125x176
	#C4      9.02x12.76  229x324
	#C5      6.38x9.02   162x229
	#C6      4.49x6.38   114x162
	#C65     4.49x8.94   114x227
	#DL      4.33x8.66   110x220
	foreach line $pagelist {
	    if { ( [ string index $line 0] != "#") && ( [ llength $line] >= 3)} {
		if { [ regexp ^(\[0-9\]*.?\[0-9\]+)x(\[0-9\]*.?\[0-9\]+)$ [ lindex $line 1] \
		        sizeP wP hP] && \
		        [ regexp ^(\[0-9\]*.?\[0-9\]+)x(\[0-9\]*.?\[0-9\]+)$ [ lindex $line 2] \
		        sizeMM wMM hMM] } {
		    # primer campo: nombre
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),Name) [ lindex $line 0]
		    # segundo campo: tamanyo en pulgadas
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),WidthP) $wP
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),HeightP) $hP
		    # tercer campo: tamanyo en milimetros
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),WidthMM) $wMM
		    set PageSetup(PageSizeList,$PageSetup(NumPageSizes),HeightMM) $hMM
		    incr PageSetup(NumPageSizes)
		
		    if { $wMM > $PageSetup(FactorCanvas) } {
		        set PageSetup(FactorCanvas) $wMM
		    }
		    if { $hMM > $PageSetup(FactorCanvas) } {
		        set PageSetup(FactorCanvas) $hMM
		    }
		}
	    }
	}
    }

    if { $PageSetup(FactorCanvas) > $PageSetup(MinFactorCanvas)} {
	set PageSetup(FactorCanvas) $PageSetup(MinFactorCanvas)
    }
    set PageSetup(FactorCanvas) [ expr 1.0 / ( $PageSetup(FactorCanvas) + 16)]
}


proc PageChangeEntryTop { name1 name2 op} {
    global PageSetup

    if { $PageSetup(ChangingMarginEntries) == 2} { return}

    set cual Top

    set nada 0
    if { $PageSetup(Entry$cual) == ""} {
	set nada 1
	set PageSetup(Entry$cual) 0
    }

    if { !$PageSetup(ChangingMarginEntries) } {

	if { $PageSetup(Entry$cual) < 0} {	   
	    bell
	    set PageSetup(Entry$cual) 0
	}

	if { $PageSetup(PageUnits) == "In"} {
	    set min [ expr $PageSetup(DefaultHeight) / $PageSetup(In2mm)]
	} else {
	    set min $PageSetup(DefaultHeight)
	}
	set queda [ expr $PageSetup(EntryHeight) - $PageSetup(EntryBottom) - $min]
	if { $queda < 0} {
	    set queda 0
	}
	if { $PageSetup(Entry$cual) > $queda} {	  
	    bell
	    set PageSetup(Entry$cual) $queda
	}
    }

    if { $PageSetup(PageUnits) == "In"} {
	set PageSetup(Margin$cual) [ expr $PageSetup(Entry$cual) * $PageSetup(In2mm)]
    } else {
	set PageSetup(Margin$cual) $PageSetup(Entry$cual)
    }

    if { [ string length $PageSetup(Margin$cual)] >= 6 } {
	set PageSetup(Margin$cual) [ format %.4g $PageSetup(Margin$cual)]
    }
    if { [ string length $PageSetup(Entry$cual)] >= 6 } {
	set PageSetup(Entry$cual) [ format %.4g $PageSetup(Entry$cual)]
    }

    PageChangeOrientation "" "" ""

    if { $nada} {
	set PageSetup(Entry$cual) ""
    }

    PageSetupActualizeImageInfo
}

proc PageChangeEntryBottom { name1 name2 op} {
    global PageSetup

    if { $PageSetup(ChangingMarginEntries) == 2} { return}

    set cual Bottom

    set nada 0
    if { $PageSetup(Entry$cual) == ""} {
	set nada 1
	set PageSetup(Entry$cual) 0
    }

    if { !$PageSetup(ChangingMarginEntries) } {

	if { $PageSetup(Entry$cual) < 0} {
	    bell
	    set PageSetup(Entry$cual) 0
	}

	if { $PageSetup(PageUnits) == "In"} {
	    set min [ expr $PageSetup(DefaultHeight) / $PageSetup(In2mm)]
	} else {
	    set min $PageSetup(DefaultHeight)
	}
	set queda [ expr $PageSetup(EntryHeight) - $PageSetup(EntryTop) - $min]
	if { $queda < 0} {
	    set queda 0
	}

	if { $PageSetup(Entry$cual) > $queda} {
	    bell
	    set PageSetup(Entry$cual) $queda
	}
    }

    if { $PageSetup(PageUnits) == "In"} {
	set PageSetup(Margin$cual) [ expr $PageSetup(Entry$cual) * $PageSetup(In2mm)]
    } else {
	set PageSetup(Margin$cual) $PageSetup(Entry$cual)
    }

    if { [ string length $PageSetup(Margin$cual)] >= 6 } {
	set PageSetup(Margin$cual) [ format %.4g $PageSetup(Margin$cual)]
    }
    if { [ string length $PageSetup(Entry$cual)] >= 6 } {
	set PageSetup(Entry$cual) [ format %.4g $PageSetup(Entry$cual)]
    }

    PageChangeOrientation "" "" ""

    if { $nada} {
	set PageSetup(Entry$cual) ""
    }
    PageSetupActualizeImageInfo
}

proc PageChangeEntryLeft { name1 name2 op} {
    global PageSetup
    if { $PageSetup(ChangingMarginEntries) == 2} { return}
    set cual Left

    set nada 0
    if { $PageSetup(Entry$cual) == ""} {
	set nada 1
	set PageSetup(Entry$cual) 0
    }

    if { !$PageSetup(ChangingMarginEntries) } {

	if { $PageSetup(Entry$cual) < 0} {
	    bell
	    set PageSetup(Entry$cual) 0
	}

	if { $PageSetup(PageUnits) == "In"} {
	    set min [ expr $PageSetup(DefaultWidth) / $PageSetup(In2mm)]
	} else {
	    set min $PageSetup(DefaultWidth)
	}
	set queda [ expr $PageSetup(EntryWidth) - $PageSetup(EntryRight) - $min]
	if { $queda < 0} {
	    set queda 0
	}
	
	if { $PageSetup(Entry$cual) > $queda} {
	    bell
	    set PageSetup(Entry$cual) $queda
	}
    }

    if { $PageSetup(PageUnits) == "In"} {
	set PageSetup(Margin$cual) [ expr $PageSetup(Entry$cual) * $PageSetup(In2mm)]
    } else {
	set PageSetup(Margin$cual) $PageSetup(Entry$cual)
    }

    if { [ string length $PageSetup(Margin$cual)] >= 6 } {
	set PageSetup(Margin$cual) [ format %.4g $PageSetup(Margin$cual)]
    }
    if { [ string length $PageSetup(Entry$cual)] >= 6 } {
	set PageSetup(Entry$cual) [ format %.4g $PageSetup(Entry$cual)]
    }

    PageChangeOrientation "" "" ""

    if { $nada} {
	set PageSetup(Entry$cual) ""
    }
}

proc PageChangeEntryRight { name1 name2 op} {
    global PageSetup

    if { $PageSetup(ChangingMarginEntries) == 2} { return}

    set cual Right

    set nada 0
    if { $PageSetup(Entry$cual) == ""} {
	set nada 1
	set PageSetup(Entry$cual) 0
    }

    if { !$PageSetup(ChangingMarginEntries) } {

	if { $PageSetup(Entry$cual) < 0} {
	    bell
	    set PageSetup(Entry$cual) 0
	}

	if { $PageSetup(PageUnits) == "In"} {
	    set min [ expr $PageSetup(DefaultWidth) / $PageSetup(In2mm)]
	} else {
	    set min $PageSetup(DefaultWidth)
	}
	set queda [ expr $PageSetup(EntryWidth) - $PageSetup(EntryLeft) - $min]
	if { $queda < 0} {
	    set queda 0
	}

	if { $PageSetup(Entry$cual) > $queda} {
	    bell
	    set PageSetup(Entry$cual) $queda
	}
    }

    if { $PageSetup(PageUnits) == "In"} {
	set PageSetup(Margin$cual) [ expr $PageSetup(Entry$cual) * $PageSetup(In2mm)]
    } else {
	set PageSetup(Margin$cual) $PageSetup(Entry$cual)
    }

    if { [ string length $PageSetup(Margin$cual)] >= 6 } {
	set PageSetup(Margin$cual) [ format %.4g $PageSetup(Margin$cual)]
    }
    if { [ string length $PageSetup(Entry$cual)] >= 6 } {
	set PageSetup(Entry$cual) [ format %.4g $PageSetup(Entry$cual)]
    }

    PageChangeOrientation "" "" ""

    if { $nada} {
	set PageSetup(Entry$cual) ""
    }
    PageSetupActualizeImageInfo
}

proc PageChangeResolution { name1 name2 op} {
    global PageSetup

    set w $PageSetup(DestinationFrame)
    if { $PageSetup(PageResolution) == [_ "other"]} {
	$w.f2.e1 configure -state normal
	focus $w.f2.e1
    } else {
	$w.f2.e1 configure -state disabled
    }
    PageSetupActualizeImageInfo
}

proc PageVerifyInteger { name1 name2 op} {
    global PageSetup

    if { ![ regexp {^[0-9]*$} $PageSetup(PageUserResolution)] } {
	regexp {[0-9]*} $PageSetup(PageUserResolution) dummy
	bell
	set w $PageSetup(DestinationFrame)
	$w.f2.e1 delete 0 end
	$w.f2.e1 insert end $dummy
	set PageSetup(PageUserResolution) $dummy
    } else {
	PageSetupActualizeImageInfo
    }
}

proc PageVerifyTransparencyImageSettings { name1 name2 op} {

    set whole_name ${name1}($name2)
    if { $name2 == "TranspBGOnImages"} {
	if { [ subst $$whole_name] } {
	    set ::PageSetup(DontSaveTransparencyLayerInImages) 0
	}
    } elseif { $name2 == "DontSaveTransparencyLayerInImages"} {
	if { [ subst $$whole_name]} {
	    set ::PageSetup(TranspBGOnImages) 0
	}
    }
    # set ::PageSetup(TranspBGOnImages) [ lindex $HardcopyOptions 4]
    # set ::PageSetup(DontSaveTransparencyLayerInImages) [ GiD_Set DontSaveTransparencyLayerInImages]
}

proc PageVerifyTransparencyAnimationSettings { name1 name2 op} {

    set whole_name ${name1}($name2)
    if { $name2 == "TranspBGOnAnimations"} {
	if { [ subst $$whole_name] } {
	    set ::PageSetup(DontSaveTransparencyLayerInAnimations) 0
	}
    } elseif { $name2 == "DontSaveTransparencyLayerInAnimations"} {
	if { [ subst $$whole_name]} {
	    set ::PageSetup(TranspBGOnAnimations) 0
	}
    }
    # set ::PageSetup(TranspBGOnAnimations) [ lindex $HardcopyOptions 4]
    # set ::PageSetup(DontSaveTransparencyLayerInAnimations) [ GiD_Set DontSaveTransparencyLayerInAnimations]
}

proc PageLookForPrinters {} {
    global tcl_platform

    if { $::tcl_platform(platform) == "windows" } {
	return "default"
    }

    set fi [ open /etc/printcap]

    set lst ""

    gets $fi line
    while { "[ string index $line [ expr [ string length $line] - 1]]" == "\\"} {
	gets $fi line_cont
	set dum [ string range $line 0 [ expr [ string length $line] - 2]]$line_cont
	set line $dum
    }

    while { ![ eof $fi]} {
	set line [ string trim $line]
	if { ( $line != "") && ( [ string first "#" $line] != 0)} {
	    set pos [ string first "|" $line]
	    if { $pos != -1} {
		set line [ string range $line 0 [ expr $pos - 1]]
	    } else {
		set pos [ string first ":" $line]
		if { $pos != -1} {
		    set line [ string range $line 0 [ expr $pos - 1]]
		}
	    }
	    if { $line != ""} {
		lappend lst $line
	    }
	}
	gets $fi line
	while { "[ string index $line [ expr [ string length $line] - 1]]" == "\\"} {
	    gets $fi line_cont
	    set dum [ string range $line 0 [ expr [ string length $line] - 2]]$line_cont
	    set line $dum
	}
    }

    lappend lst User

    return $lst
}


proc PageSetup { { w .gid.wPageSetup}} {
    global PageSetup    
    PageFillDefaults
    PageReadSizes [file join [gid_filesystem::get_folder_standard scripts] PageSizes.txt]
    set PageSetup(GiDImage) [ image create photo -data [ GiD_Thumbnail get -width 128 -height 96]]

    if { ![info exists PageSetup(PageUnits)] } {
	set PageSetup(PageUnits) mm
    }
    if { ![info exists PageSetup(MarginTop)] } {
	set PageSetup(MarginTop) $PageSetup(DefaultMarginTop)
    }
    if { ![info exists PageSetup(MarginBottom)] } {
	set PageSetup(MarginBottom) $PageSetup(DefaultMarginBottom)
    }
    if { ![info exists PageSetup(MarginLeft)] } {
	set PageSetup(MarginLeft) $PageSetup(DefaultMarginLeft)
    }
    if { ![info exists PageSetup(MarginRight)] } {
	set PageSetup(MarginRight) $PageSetup(DefaultMarginRight)
    }

    
    InitWindow2 $w -title [_ "Page and capture settings"] \
        -geometryvariable PrePostPageSetupWindowGeom \
        -initcommand PageSetup -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::frame $w.f -borderwidth 1  -style sunken.TFrame

    ttk::frame $w.f.ft -borderwidth 0
    ttk::label $w.f.ft.l -text [_ "Top"]:
    ttk::entry $w.f.ft.e -textvariable PageSetup(EntryTop) -width 6
    grid $w.f.ft.l $w.f.ft.e -padx 1 -pady 1 -sticky new

    ttk::frame $w.f.fl -borderwidth 0
    ttk::label $w.f.fl.l -text [_ "Left"]:
    ttk::entry $w.f.fl.e -textvariable PageSetup(EntryLeft) -width 6
    grid $w.f.fl.l -padx 1 -pady 1 -sticky ws
    grid $w.f.fl.e -padx 1 -pady 1 -sticky nw

    ttk::frame $w.f.fc -style groove.TFrame -borderwidth 2
    set PageSetup(PageCanvas) $w.f.fc.cv
    set PageSetup(PageCanvasWidth) 300
    set PageSetup(PageCanvasHeight) 300

    canvas $w.f.fc.cv -width $PageSetup(PageCanvasWidth) -height $PageSetup(PageCanvasHeight) -borderwidth 0
    grid $w.f.fc.cv -sticky news

    if { ![info exists PageSetup(PageSize)] } {
	set PageSetup(PageSize) 0
    }
    PageChangeSize
    PageChangePulgadas
    set PageSetup(ChangingMarginEntries) 0
    if { ![info exists PageSetup(PageUserResolution)] } {
	set PageSetup(PageUserResolution) ""
    }   

    ttk::frame $w.f.fr -borderwidth 0
    ttk::label $w.f.fr.l -text [_ "Right"]:
    ttk::entry $w.f.fr.e -textvariable PageSetup(EntryRight) -width 6
    grid $w.f.fr.l -padx 1 -pady 1 -sticky ws
    grid $w.f.fr.e -padx 1 -pady 1 -sticky ne

    ttk::frame $w.f.fb -borderwidth 0
    ttk::label $w.f.fb.l -text [_ "Bottom"]:
    ttk::entry $w.f.fb.e -textvariable PageSetup(EntryBottom) -width 6
    grid $w.f.fb.l $w.f.fb.e -padx 1 -pady 1 -sticky ens

    ttk::button $w.f.bdef -text [_ "Reset"] -command "PageDefaultMargins" 

    grid $w.f.ft -row 0 -column 0 -columnspan 3 -sticky wen
    grid $w.f.fl -row 1 -column 0 -sticky nsw
    grid $w.f.fc -row 1 -column 1 -sticky news
    grid $w.f.fr -row 1 -column 2 -sticky nse
    grid $w.f.fb -row 2 -column 0 -columnspan 2 -sticky wes

    grid $w.f.bdef -row 2 -column 2 -sticky es

    ttk::frame $w.f.fImgInfo -borderwidth 0
    ttk::label $w.f.fImgInfo.lbl1 -text [_ "Image size ( width x height):"]
    ttk::entry $w.f.fImgInfo.eImgDimWidth -textvariable ::PageSetup(Image,DimWidth) \
	-width 6 -justify center -state disabled
    ttk::label $w.f.fImgInfo.lbl2 -text "x"
    ttk::entry $w.f.fImgInfo.eImgDimHeight -textvariable ::PageSetup(Image,DimHeight) \
	-width 6 -justify center -state disabled
    ttk::label $w.f.fImgInfo.lbl3 -textvariable ::PageSetup(PageUnits)

    ttk::label $w.f.fImgInfo.lbl4 -text "  ~"
    ttk::entry $w.f.fImgInfo.eImgPixWidth -textvariable ::PageSetup(Image,PixWidth) \
	-width 5 -justify center -state disabled
    ttk::label $w.f.fImgInfo.lbl5 -text "x"
    ttk::entry $w.f.fImgInfo.eImgPixHeight -textvariable ::PageSetup(Image,PixHeight) \
	-width 5 -justify center -state disabled
    ttk::label $w.f.fImgInfo.lbl6 -text [_ "pixels"]

    grid  $w.f.fImgInfo.lbl1 \
	$w.f.fImgInfo.eImgDimWidth $w.f.fImgInfo.lbl2 $w.f.fImgInfo.eImgDimHeight $w.f.fImgInfo.lbl3 \
	$w.f.fImgInfo.lbl4 \
	$w.f.fImgInfo.eImgPixWidth $w.f.fImgInfo.lbl5 $w.f.fImgInfo.eImgPixHeight $w.f.fImgInfo.lbl6 \
	-padx 1 -pady 1 -sticky wns
    grid configure $w.f.fImgInfo.lbl1 -sticky ens

    grid $w.f.fImgInfo -row 3 -column 0 -columnspan 3 -sticky wes
   
    grid columnconfigure $w.f 1 -weight 1  
    grid rowconfigure $w.f 0 -weight 0
    grid rowconfigure $w.f 1 -weight 1
    grid rowconfigure $w.f 2 -weight 0

    bind $w.f.fc <Configure> "PageResizeCanvas %w %h"
   
    bind $w.f.fc.cv <B1-Motion> "PageitemDrag $w.f.fc.cv %x %y"
    set PageSetup(lastX) 0
    set PageSetup(lastY) 0

    ttk::frame $w.fsize -borderwidth 1  -style sunken.TFrame

    ttk::frame $w.fsize.f1 -borderwidth 0

    set labels {}
    set values {}
    set found 0
    for { set i 0} { $i < $PageSetup(NumPageSizes)} { incr i} {
	lappend labels $PageSetup(PageSizeList,$i,Name)
	lappend values $i
	if { ( ( $PageSetup(PageSizeList,$i,WidthMM) == $PageSetup(DefaultPageWidth)) && \
		( $PageSetup(PageSizeList,$i,HeightMM) == $PageSetup(DefaultPageHeight))) || \
		( ( $PageSetup(PageSizeList,$i,WidthMM) == $PageSetup(DefaultPageHeight)) && \
		( $PageSetup(PageSizeList,$i,HeightMM) == $PageSetup(DefaultPageWidth)))  } {
	    set found $i
	}
    }

    TTKComboBox $w.fsize.f1.mb -textvariable ::PageSetup(PageSize) \
	-labels $labels -values $values \
	-state readonly

    if { $PageSetup(NumPageSizes) > 0} {
	set PageSetup(PageSize) $found
	PageChangeSize
    }

    TTKComboBox $w.fsize.f1.mbo -textvariable ::PageSetup(PageOrientation) \
	-labels [ list [_ "Portrait"] [_ "Landscape"]] \
	-values [ list Portrait Landscape] \
	-state readonly

    ttk::entry $w.fsize.f1.e1 -textvariable PageSetup(EntryWidth) -state disabled
    ttk::label $w.fsize.f1.l -text x
    ttk::entry $w.fsize.f1.e2 -textvariable PageSetup(EntryHeight) -state disabled

    TTKComboBox $w.fsize.f1.mb1 -textvariable ::PageSetup(PageUnits)\
	-labels [ list mm [_ "Inch"]] \
	-values [ list mm In] \
	-state readonly

    grid $w.fsize.f1.mb $w.fsize.f1.mbo $w.fsize.f1.e1 $w.fsize.f1.l $w.fsize.f1.e2 \
	    $w.fsize.f1.mb1 -padx 2 -pady 1 -sticky ew
   
    ttk::frame $w.fsize.f2 -borderwidth 0
    ttk::label $w.fsize.f2.l0 -text [_ "Resolution"]
    TTKComboBox $w.fsize.f2.mres -textvariable ::PageSetup(PageResolution) \
	-labels [ list [_ "Screen"] "150" "300" "600" [_ "other"]] \
	-values [ list Screen 150 300 600 other] \
	-state readonly

    ttk::entry $w.fsize.f2.e1 -width 4 -textvariable PageSetup(PageUserResolution) \
	    -state disabled
    ttk::label $w.fsize.f2.l -text [_ "dpi"]

	if { ![info exists PageSetup(AutoCrop)] } { set PageSetup(AutoCrop) 0 }
    ttk::checkbutton $w.fsize.f2.cb -text [_ "Auto crop image"] -variable PageSetup(AutoCrop)

    grid $w.fsize.f2.l0 $w.fsize.f2.mres $w.fsize.f2.e1 $w.fsize.f2.l \
	    $w.fsize.f2.cb -padx 2 -pady 1 -sticky ew
    grid configure $w.fsize.f2.l -sticky w
    grid configure $w.fsize.f2.l0 -sticky e
    
    ttk::frame $w.fsize.f3 -borderwidth 0
    
    if { ![info exists ::PageSetup(WhiteBGOnImages)] } { set ::PageSetup(WhiteBGOnImages) 0 }
    ttk::checkbutton $w.fsize.f3.cbwi -text [_ "White background on images"] -variable ::PageSetup(WhiteBGOnImages)
    
    if { ![info exists ::PageSetup(WhiteBGOnAnimations)] } { set ::PageSetup(WhiteBGOnAnimations) 0 }
    ttk::checkbutton $w.fsize.f3.cbwa -text [_ "White background on animations"] -variable ::PageSetup(WhiteBGOnAnimations)
    
    if { ![info exists ::PageSetup(TranspBGOnImages)] } { set ::PageSetup(TranspBGOnImages) 0 }
    ttk::checkbutton $w.fsize.f3.cbti -text [_ "Transparent background on images"] -variable ::PageSetup(TranspBGOnImages)
    
    if { ![info exists ::PageSetup(DontSaveTransparencyLayerInImages)] } { set ::PageSetup(DontSaveTransparencyLayerInImages) 0 }
    ttk::checkbutton $w.fsize.f3.cbtli -text [_ "Don't save transparency layer on images"] -variable ::PageSetup(DontSaveTransparencyLayerInImages)
    # setTooltip $w.fsize.f3.cbtli [_ "Transparency information of the image will not be saved on PNG nor TIFF images"]

    if { ![info exists ::PageSetup(TranspBGOnAnimations)] } { set ::PageSetup(TranspBGOnAnimations) 0 }
    ttk::checkbutton $w.fsize.f3.cbta -text [_ "Transparent background on animations"] -variable ::PageSetup(TranspBGOnAnimations)
    
    if { ![info exists ::PageSetup(DontSaveTransparencyLayerInAnimations)] } { set ::PageSetup(DontSaveTransparencyLayerInAnimations) 0 }
    ttk::checkbutton $w.fsize.f3.cbtla -text [_ "Don't save transparency layer on animations"] -variable ::PageSetup(DontSaveTransparencyLayerInAnimations)
    # setTooltip $w.fsize.f3.cbtli [_ "Transparency information of the image will not be saved on PNG nor TIFF images"]

    if { ![info exists ::PageSetup(DrawBGImagesOnImages)] } { set ::PageSetup(DrawBGImagesOnImages) 0 }
    ttk::checkbutton $w.fsize.f3.cbdi -text [_ "Draw background images on images"] -variable ::PageSetup(DrawBGImagesOnImages)
    
    if { ![info exists ::PageSetup(DrawBGImagesOnAnimations)] } { set ::PageSetup(DrawBGImagesOnAnimations) 0 }
    ttk::checkbutton $w.fsize.f3.cbda -text [_ "Draw background images on animations"] -variable ::PageSetup(DrawBGImagesOnAnimations)
    
    grid $w.fsize.f3.cbwi $w.fsize.f3.cbwa -padx 2 -pady 1 -sticky ew
    grid $w.fsize.f3.cbti $w.fsize.f3.cbta -padx 2 -pady 1 -sticky ew
    grid $w.fsize.f3.cbtli $w.fsize.f3.cbtla -padx 2 -pady 1 -sticky ew
    grid $w.fsize.f3.cbdi $w.fsize.f3.cbda -padx 2 -pady 1 -sticky ew

    grid $w.fsize.f1 -sticky we
    grid $w.fsize.f2 -sticky we
    grid $w.fsize.f3 -sticky we
    grid columnconfigure $w.fsize.f1 "0 1 5" -weight 1
    grid columnconfigure $w.fsize.f2 "1" -weight 1
    grid columnconfigure $w.fsize.f2 "0 1" -weight 1   
    set PageSetup(DestinationFrame) $w.fsize    
    ttk::frame $w.fb -style BottomFrame.TFrame
    ttk::button $w.fb.ba -text [_ "Set Page"] -command [list PageSetupAccept $w] -style BottomFrame.TButton    
    ttk::button $w.fb.bi -image [ gid_themes::GetImage camera.png medium_icons] -style BottomFrame.TButton \
	-command "PageSetupAccept $w; TakeSnapshot"
    ttk::button $w.fb.bp -image [ gid_themes::GetImage print.png medium_icons] -style BottomFrame.TButton \
	-command "PageSetupAccept $w; HardcopyToPrint {'Hardcopy PS}"
    ttk::button $w.fb.bc -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton  
    grid $w.fb.ba $w.fb.bi $w.fb.bp $w.fb.bc -sticky ew -padx 5 -pady 6    

    grid $w.f -pady 2 -ipady 2 -sticky wens -padx 2 -pady 2 -columnspan 2
    grid $w.fsize -sticky sew
    grid columnconfigure $w.fsize 0 -weight 1
    grid $w.fb -sticky sew
    grid anchor $w.fb center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    
    bind $w <Destroy> [list +DestroyPageSetup %W $w]

    PageSetupActualizeImageInfo

    trace add variable PageSetup(PageSize) write "PageChangeSize ;#"
    trace add variable PageSetup(PageOrientation) write PageChangeOrientation
    trace add variable PageSetup(PageUnits) write "PageChangePulgadas ;#"
    trace add variable PageSetup(EntryTop) write PageChangeEntryTop
    trace add variable PageSetup(EntryBottom) write PageChangeEntryBottom
    trace add variable PageSetup(EntryLeft) write PageChangeEntryLeft
    trace add variable PageSetup(EntryRight) write PageChangeEntryRight   
    trace add variable PageSetup(PageResolution) write PageChangeResolution
    trace add variable PageSetup(PageUserResolution) write PageVerifyInteger

    # trace add variable ::PageSetup(TranspBGOnImages) write PageVerifyTransparencyImageSettings
    # trace add variable ::PageSetup(DontSaveTransparencyLayerInImages) write PageVerifyTransparencyImageSettings
    # trace add variable ::PageSetup(DontSaveTransparencyLayerInAnimations) write PageVerifyTransparencyAnimationSettings
}

proc DestroyPageSetup { W w } {
    if { $W != $w } return
    global PageSetup
    trace remove variable PageSetup(PageSize) write "PageChangeSize ;#"
    trace remove variable PageSetup(PageOrientation) write PageChangeOrientation
    trace remove variable PageSetup(PageUnits) write "PageChangePulgadas ;#"
    trace remove variable PageSetup(EntryTop) write PageChangeEntryTop
    trace remove variable PageSetup(EntryBottom) write PageChangeEntryBottom
    trace remove variable PageSetup(EntryLeft) write PageChangeEntryLeft
    trace remove variable PageSetup(EntryRight) write PageChangeEntryRight    
    trace remove variable PageSetup(PageResolution) write PageChangeResolution
    trace remove variable PageSetup(PageUserResolution) write PageVerifyInteger

    # trace remove variable ::PageSetup(TranspBGOnImages) write PageVerifyTransparencyImageSettings
    # trace remove variable ::PageSetup(DontSaveTransparencyLayerInImages) write PageVerifyTransparencyImageSettings
    # trace remove variable ::PageSetup(DontSaveTransparencyLayerInAnimations) write PageVerifyTransparencyAnimationSettings
}
