proc RedrawDivisions { type } {
    global ConcentrateElemPriv
    global CenterStructPriv
    set canvas $ConcentrateElemPriv(canvas)

    if { ![winfo exists $canvas] } { return }

    set width [winfo width $canvas]
    if { $width < 10 } { set width [winfo reqwidth $canvas] }
    set height [winfo height $canvas]
    if { $height < 10 } { set height [winfo reqheight $canvas] }

    set w0 $ConcentrateElemPriv(weight,0)
    set w1 $ConcentrateElemPriv(weight,1)
    if { ![string is double -strict $w0] || ![string is double -strict $w1] } {
        return
    }

    $canvas delete temp

    set margenx 20
    if { $type == "CENTERED" } {
        #set aux [expr $width- $margenx - $margenx ]
        set aux [expr $width / 2 ]
        set angle 10
        set margeny [expr 50 + $aux * [expr sin($angle*3.1415/180)] ]
    } else {
        set margeny 80
    }

    $canvas create line $margenx $margeny [expr $width-$margenx] $margeny \
            -fill red -width 2  -tags temp

    $canvas create oval [expr $margenx-1] [expr $margeny-1] \
            [expr $margenx+1] [expr $margeny+1] -fill black -tags temp

    $canvas create oval [expr $width-$margenx-1] [expr $margeny-1] \
        [expr $width-$margenx+1] [expr $margeny+1] -fill black -tags temp

    if { $type == "CENTERED" } {
        $canvas create arc $margenx [expr $margeny+$aux] [expr $width-$margenx] [expr $margeny-$aux] \
            -style arc -start [expr -$angle] -extent [expr 2*$angle] -tags temp
    }

    set incre 1
    set factor 1
    #set NE 20
    if { $type == "CENTERED" } {
        set NE $CenterStructPriv(sizes,0)
    } else {
        set NE 20
    }
    list params 0
    set ti 0
    for { set i 1 } { $i <= $NE } { incr i } {
        set t [expr double($i)/$NE]
        set w [expr $t*$w1-(1.0-$t)*$w0]
        if { $w > 1e-10 } {
            set factor [expr 1.0/(1.0+$w)]
        } elseif { $w < 1e-10 } {
            set  factor [expr 1.0-$w]
        } else {
            set factor 1.0
        }
        #if { $sense !=1 } set factor [expr 1.0/$factor]
        set ti [expr $ti+$incre]
        lappend params $ti
        set incre [expr $incre*$factor]
    }

    #for {set i 0} {$i < [llength $params]} {incr i 1} {
    #    lreplace params $i [expr [lindex $params $i]/$ti]
    #}

    set ti [lindex $params [expr [llength $params]-1]]
    set y $margeny
    foreach t $params {
        set x [expr $t/$ti*($width-2*$margenx)+$margenx]
        $canvas create line $x [expr $y-3]  $x [expr $y+3] -fill black -tags temp
    }
}

proc ConcentrateElements { } {
   global ConcentrateElemPriv

    if { ![info exists ConcentrateElemPriv(weight,0)] } {
        set ConcentrateElemPriv(weight,0) 0.0
    }
    if { ![info exists ConcentrateElemPriv(weight,1)] } {
        set ConcentrateElemPriv(weight,1) 0.0
    }

    set w .gid.concentrateelem
    if { [winfo exists $w] } return

    InitWindow2 $w -title [_ "Concentrate elements "] \
        -geometryvariable PreConcentrateElementsWindowGeom \
        -initcommand ConcentrateElements \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::frame $w.frmPropagate
    if { ![info exists ConcentrateElemPriv(Propagate)] } { set ConcentrateElemPriv(Propagate) 0 }
    ttk::checkbutton $w.frmPropagate.chk -variable ConcentrateElemPriv(Propagate) \
        -text [_ "Propagate selection"]
    GidHelp "$w.frmPropagate" \
        [_ "Automatically select the affected lines to assign weights"]

    set c [canvas $w.cWeights -borderwidth 2 -relief groove -height 50 ]
    set ConcentrateElemPriv(canvas) $c

    ttk::frame $w.cWeights.frmWeight0
    ttk::label $w.cWeights.frmWeight0.lweight0 -text [_ "Start Weight"]
    UpDownEntry $w.cWeights.frmWeight0.udweight0 -variable ConcentrateElemPriv(weight,0)\
            -entry-options "-width 6" \
            -up-command "IncrementW 0" -down-command "DecrementW 0"
    GidHelp "$w.cWeights.frmWeight0" \
        [_ "Element concentration at start:\nPositive value to concentrate\n\
            Negative to separate"]

    ttk::frame $w.cWeights.frmWeight1
    ttk::label $w.cWeights.frmWeight1.lweight1 -text [_ "End Weight"]
    UpDownEntry $w.cWeights.frmWeight1.udweight1 -variable ConcentrateElemPriv(weight,1)\
            -entry-options "-width 6" \
            -up-command "IncrementW 1" -down-command "DecrementW 1"

    GidHelp "$w.cWeights.frmWeight1" \
        [_ "Element concentration at End:\nPositive value to concentrate\n\
            Negative to separate"]
   
    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.btnApply -text [_ "Ok"] \
       -command [list ApplyConcentrateElementsCmd $w] \
       -style BottomFrame.TButton

    ttk::button $w.frmButtons.btnclose -text [_ "Cancel"] \
            -command "GiD_Process escape ;  grab release $w ; destroy $w" \
            -style BottomFrame.TButton

    grid $w.frmPropagate -padx 5 -pady 5 -sticky new
    #grid $w.frmPropagate.chk -sticky w
    grid columnconf $w.frmPropagate 0 -weight 1

    grid $w.cWeights -sticky ewns
    grid columnconf $w.cWeights 0 -weight 1
    grid rowconf $w.cWeights 1 -weight 1
    grid columnconf $w.frmPropagate 0 -weight 1

    pack $w.cWeights.frmWeight0.lweight0 $w.cWeights.frmWeight0.udweight0 -side top
    pack $w.cWeights.frmWeight1.lweight1 $w.cWeights.frmWeight1.udweight1 -side top
    grid $w.cWeights.frmWeight0 $w.cWeights.frmWeight1  -padx 5 -pady 5 -sticky w
    grid configure $w.cWeights.frmWeight1 -sticky e

    grid $w.frmButtons -sticky ews -columnspan 7
    grid anchor $w.frmButtons center

    grid $w.frmButtons.btnApply $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconf $w "0" -weight 1
    grid rowconfigure $w "1" -weight 1

    focus $w.frmButtons.btnApply

    trace add variable ConcentrateElemPriv(weight,0) write "RedrawDivisions CONCENTRATEELEMS;#"
    trace add variable ConcentrateElemPriv(weight,1) write "RedrawDivisions CONCENTRATEELEMS;#"

    RedrawDivisions CONCENTRATEELEMS

    bind $w.cWeights <Configure> "RedrawDivisions CONCENTRATEELEMS"  
    bind $w <Return> "$w.frmButtons.btnApply invoke"
    bind $w <Destroy> [list +DestroyConcentrateElements %W $w] ;# + to add to previous script

    wm minsize $w 140 140

    if { $::tcl_platform(os) != "Darwin"} {
        catch { tkwait visibility $w }
    } else {
        update
    }
    grab set $w
}

proc ApplyConcentrateElementsCmd { w } {
    global ConcentrateElemPriv
    set ConcentrateElemPriv(weight,0) [string trim $ConcentrateElemPriv(weight,0)]
    set ConcentrateElemPriv(weight,1) [string trim $ConcentrateElemPriv(weight,1)]
    GiD_Process $ConcentrateElemPriv(weight,0) $ConcentrateElemPriv(weight,1)
    grab release $w
    destroy $w
}

proc IncrementW { i } {
    global ConcentrateElemPriv
    set ConcentrateElemPriv(weight,$i) [format "%.1f" [expr $ConcentrateElemPriv(weight,$i)+0.1]]
}
proc DecrementW { i } {
    global ConcentrateElemPriv
    set ConcentrateElemPriv(weight,$i) [format "%.1f" [expr $ConcentrateElemPriv(weight,$i)-0.1]]
}

proc IncrementInt { i canvas } {
    global CenterStructPriv
    if { $CenterStructPriv(sizes,$i) > 0} {
        set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,1) / $CenterStructPriv(sizes,0)]
        incr CenterStructPriv(sizes,$i)
        set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,1) * $CenterStructPriv(sizes,0)]
    } else {
        incr CenterStructPriv(sizes,$i)
        set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,0) * 3]
    }
    RedrawDivisions CENTERED
}
proc DecrementInt { i canvas } {
    global CenterStructPriv
    if { $CenterStructPriv(sizes,$i) > 1} {
        set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,1) / $CenterStructPriv(sizes,0)]
        incr CenterStructPriv(sizes,$i) -1
        set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,1) * $CenterStructPriv(sizes,0)]
    }
    RedrawDivisions CENTERED
}
proc IncrementP { i } {
    global CenterStructPriv
    incr CenterStructPriv(sizes,$i) [expr $CenterStructPriv(sizes,0)]
}
proc DecrementP { i } {
    global CenterStructPriv
    if { $CenterStructPriv(sizes,$i) > $CenterStructPriv(sizes,0)} {
        incr CenterStructPriv(sizes,$i) -[expr $CenterStructPriv(sizes,0)]
    }
}

proc AssignCenterStructuredCmd { w mode } {
    global ConcentrateElemPriv
    global CenterStructPriv
    set ConcentrateElemPriv(weight,0) [string trim $ConcentrateElemPriv(weight,0)]
    set ConcentrateElemPriv(weight,1) [string trim $ConcentrateElemPriv(weight,1)]
    set CenterStructPriv(sizes,0) [string trim $CenterStructPriv(sizes,0)]
    set CenterStructPriv(sizes,1) [string trim $CenterStructPriv(sizes,1)]

    if { $mode=="Modal" } {
        #GiD_Process MEscape Meshing Structured $ConcentrateElemPriv(weight,0) \
        #   $ConcentrateElemPriv(weight,1) $CenterStructPriv(sizes,0) $CenterStructPriv(sizes,1)
        GiD_Process $ConcentrateElemPriv(weight,0) \
            $ConcentrateElemPriv(weight,1) $CenterStructPriv(sizes,0) $CenterStructPriv(sizes,1)
        grab release $w
        destroy $w
    } else {
        GiD_Process MEscape Meshing CenterStruct Assign $ConcentrateElemPriv(weight,0) \
        $ConcentrateElemPriv(weight,1) $CenterStructPriv(sizes,0) $CenterStructPriv(sizes,1)
        set SmallWinSelecting [GiD_Set SmallWinSelecting]
        FinishButton $w $w.frmButtons \
            [_ "Press 'Finish' to end selection"] \
            "" disableall $SmallWinSelecting
    }

}

proc CenterStructured { mode } {
    global ConcentrateElemPriv
    global CenterStructPriv

    if { ![info exists ConcentrateElemPriv(weight,0)] } {
        set ConcentrateElemPriv(weight,0) 0.0
    }
    if { ![info exists ConcentrateElemPriv(weight,1)] } {
        set ConcentrateElemPriv(weight,1) 0.0
    }
    if { ![info exists CenterStructPriv(sizes,0)] } {
        set CenterStructPriv(sizes,0) 2
    }
    if { ![info exists CenterStructPriv(sizes,1)] } {
        set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,0) * 3]
    }
    #if { [expr $CenterStructPriv(sizes,1)] < [expr $CenterStructPriv(sizes,0) * 3] } {
    #    set CenterStructPriv(sizes,1) [expr $CenterStructPriv(sizes,0) * 3]
    #}

    set w .gid.centerstruct
    if { [winfo exists $w] } return

    InitWindow2 $w -title [_ "Centered Structured Mesh"] \
        -geometryvariable PreCenteredStructMeshWindowGeom \
        -initcommand CenterStructured \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0


    ttk::frame $w.frmPropagate
    if { ![info exists ConcentrateElemPriv(Propagate)] } { set ConcentrateElemPriv(Propagate) 0 }
    ttk::checkbutton $w.frmPropagate.chk -variable ConcentrateElemPriv(Propagate) \
        -text [_ "Propagate selection"]
    GidHelp "$w.frmPropagate" \
        [_ "Automatically select the affected lines to assign weights"]

    set frm [ttk::labelframe $w.frmWeights -text [_ "Concentric element distribution"] ]
    set c [canvas $frm.cWeights -borderwidth 0 -relief groove -height 150 ]

    set ConcentrateElemPriv(canvas) $c

    ttk::frame $c.frmWeight0
    ttk::label $c.frmWeight0.lweight0 -text [_ "Center Weight"]
    UpDownEntry $c.frmWeight0.udweight0 -variable ConcentrateElemPriv(weight,0)\
            -entry-options "-width 6" \
            -up-command "IncrementW 0" -down-command "DecrementW 0"
    GidHelp "$c.frmWeight0" \
        [_ "Element concentration at center:\nPositive value to concentrate\n\
            Negative to separate"]

    ttk::frame $c.frmWeight1
    ttk::label $c.frmWeight1.lweight1 -text [_ "Boundary Weight"]
    UpDownEntry $c.frmWeight1.udweight1 -variable ConcentrateElemPriv(weight,1)\
        -entry-options "-width 6" \
        -up-command "IncrementW 1" -down-command "DecrementW 1"
    GidHelp "$c.frmWeight1" \
        [_ "Element concentration at boundary:\nPositive value to concentrate\n\
            Negative to separate"]
  
    ttk::frame $w.cSizes -style groove.TFrame

    ttk::frame $w.cSizes.frmSize0
    ttk::label $w.cSizes.frmSize0.lsize0 -text [_ "Concentric divisions"]
    UpDownEntry $w.cSizes.frmSize0.udsize0 -variable CenterStructPriv(sizes,0)\
        -entry-options "-width 6" \
        -up-command "IncrementInt 0 $c" \
        -down-command "DecrementInt 0 $c"
    GidHelp "$w.cSizes.frmSize0" \
        [_ "Number of divisions in \nradial direction"]

    ttk::frame $w.cSizes.frmSize1
    ttk::label $w.cSizes.frmSize1.lsize1 -text [_ "Perimetral divisions"]
    UpDownEntry $w.cSizes.frmSize1.udsize1 -variable CenterStructPriv(sizes,1)\
        -entry-options "-width 6" \
        -up-command "IncrementP 1"  -down-command "DecrementP 1"
    GidHelp "$w.cSizes.frmSize1" \
        [_ "Number of divisions in \nperimetral direction"]


    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    if { $mode == "Modal" } {
	ttk::button $w.frmButtons.btnApply -text [_ "Accept"] \
            -command [list AssignCenterStructuredCmd $w $mode] \
            -underline 0 -style BottomFrame.TButton
    } else {
	ttk::button $w.frmButtons.btnApply -text [_ "Assign"] \
            -command [list AssignCenterStructuredCmd $w $mode] \
            -underline 0 -style BottomFrame.TButton
    }
    
    ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
            -command "GiD_Process escape ;  grab release $w ; destroy $w" \
            -underline 0 -style BottomFrame.TButton


    #grid $w.frmPropagate -padx 5 -pady 5 -sticky new
    #grid columnconf $w.frmPropagate 0 -weight 1

    pack $w.cSizes.frmSize0.lsize0 $w.cSizes.frmSize0.udsize0
    pack $w.cSizes.frmSize1.lsize1 $w.cSizes.frmSize1.udsize1
    grid $w.cSizes.frmSize0 $w.cSizes.frmSize1  -padx 5 -pady 5 -sticky w
    grid configure $w.cSizes.frmSize1 -sticky e
    #grid $w.cSizes -sticky ewns
    grid $w.cSizes -sticky ewn



    pack $c.frmWeight0.lweight0 $c.frmWeight0.udweight0 -side top
    pack $c.frmWeight1.lweight1 $c.frmWeight1.udweight1 -side top
    grid $c.frmWeight0 $c.frmWeight1  -padx 25 -pady 5 -sticky wn
    grid $c -sticky ewns
    grid configure $c.frmWeight1 -padx 25 -sticky en
    grid $frm -sticky wnes
    grid columnconfigure $c "0" -weight 1
    grid columnconfigure $c "1" -weight 1
    grid rowconfigure $c "1" -weight 1
    grid columnconf $frm "0" -weight 1
    grid rowconfigure $frm "0" -weight 1

    grid $w.frmButtons -sticky ews -columnspan 7
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnApply $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconfigure $w.frmButtons "0" -weight 1
    grid columnconfigure $w.frmButtons "1" -weight 1
    grid rowconfigure $w.frmButtons "1" -weight 1
    grid columnconf $w "0" -weight 1
    grid rowconfigure $w "1" -weight 1

    focus $w.frmButtons.btnApply
    trace add variable ConcentrateElemPriv(weight,0) write "RedrawDivisions CENTERED;#"
    trace add variable ConcentrateElemPriv(weight,1) write "RedrawDivisions CENTERED;#"

    RedrawDivisions CENTERED

    bind $c <Configure> "RedrawDivisions CENTERED"
    bind $w <Alt-c> "$w.frmButtons.btnclose invoke"
    bind $w <Escape> "$w.frmButtons.btnclose invoke"
    bind $w <Return> "$w.frmButtons.btnApply invoke"
    bind $w <Destroy> [list +DestroyCenterStructured %W $w] ;# + to add to previous script

    wm minsize $w 290 220

    if { $::tcl_platform(os) != "Darwin"} {
        catch { tkwait visibility $w }
    } else {
        update
    }

    if { $mode=="Modal" } {
        grab set $w
    }
}

proc DestroyConcentrateElements { W w } {
    if { $W != $w } return
    global ConcentrateElemPriv
    #avoid reenter multiple times, one by child
    trace remove variable ConcentrateElemPriv(weight,0) write "RedrawDivisions CONCENTRATEELEMS;#"
    trace remove variable ConcentrateElemPriv(weight,1) write "RedrawDivisions CONCENTRATEELEMS;#"
}

proc DestroyCenterStructured { W w } {
    if { $W != $w } return
    global ConcentrateElemPriv
    #avoid reenter multiple times, one by child
    trace remove variable ConcentrateElemPriv(weight,0) write "RedrawDivisions CENTERED;#"
    trace remove variable ConcentrateElemPriv(weight,1) write "RedrawDivisions CENTERED;#"
}
