proc rotateAround { axis} {
    package require gid_quaternion
    set initView [ GiD_Info view]
    foreach pair $initView {
        set k [ lindex $pair 0]
        set v [ lrange $pair 1 end]
        set view($k) $v
    }
    set from_quaternion [Quaternion::FromRotationMatrix4 $view(m)]
    # WV from_quaternion
    set pi2 [ expr 2.0 * acos( -1.0)]
    set angle [ expr $pi2 / 20.0]
    for { set iangle 0} { $iangle <= $pi2} { set iangle [ expr $iangle + $angle]} {
        set yy [ expr sin( $iangle / 2.0)]
        set ww [ expr cos( $iangle / 2.0)]
        # WV [ list yy ww]
        switch $axis {
            "x" {
                set quat_rot [ list $yy 0.0 0.0 $ww]
            }
            "y" {
                set quat_rot [ list 0.0 $yy 0.0 $ww]
            }
            "z" {
                set quat_rot [ list 0.0 0.0 $yy $ww]
            }
            default {
                # using the z axis
                set quat_rot [ list 0.0 0.0 $yy $ww]
            }
        }
        set quat_view [ Quaternion::Multiply $quat_rot $from_quaternion]
        # set quat_view $quat_rot
        # set quat_view [ Quaternion::Add $quat_rot $from_quaternion]
        # WV quat_rot
        # WV quat_view
        # Wmatrix view(m)
        set view(m) [ Quaternion::ToRotationMatrix4 $quat_view]
        # Wmatrix view(m)
        # return
        # W ---
        # GiD_Process Mescape View SetView $newiew escape
        # set new_view [ list]
        # foreach {k v} [ array get view] {
        #     lappend new_view [ concat $k $v]
        # }
        # GiD_Process Mescape View SetView $new_view escape
        GiD_Process Mescape View SetViewParameter [ concat m $view(m)] escape
        GiD_Process 'redraw
        after [ expr int( 0.5 + $::AutoAnimate_Delay)]
        # WarnWin next .gid 99999
        # break
    }
}

proc travelIn { } {
    set initView [ GiD_Info view]
    foreach pair $initView {
        set k [ lindex $pair 0]
        set v [ lrange $pair 1 end]
        set view($k) $v
    }

    set model_diagonal $view(e)
    for { set far_away [ expr $model_diagonal * 10]} { $far_away >= $model_diagonal} { set far_away [ expr $far_away - 0.5 * $model_diagonal]} {
        # GiD internally will respect the aspect ratio and adjust x and y properly
        GiD_Process Mescape View SetViewParameter \
            [ concat x -$far_away $far_away] \
            [ concat y -$far_away $far_away] \
            escape
        GiD_Process 'redraw
        after [ expr int( 0.5 + $::AutoAnimate_Delay)]
    }
}

proc travelOut { } {
    set initView [ GiD_Info view]
    foreach pair $initView {
        set k [ lindex $pair 0]
        set v [ lrange $pair 1 end]
        set view($k) $v
    }

    set model_diagonal $view(e)
    set far_away [ expr $model_diagonal * 10]
    for { set away $model_diagonal} { $away <= $far_away} { set away [ expr $away + 0.5 * $model_diagonal]} {
        # GiD internally will respect the aspect ratio and adjust x and y properly
        GiD_Process Mescape View SetViewParameter \
            [ concat x -$away $away] \
            [ concat y -$away $away] \
            escape
        GiD_Process 'redraw
        after [ expr int( 0.5 + $::AutoAnimate_Delay)]
    }
}

proc animateComposition { { axis z} } {
    travelIn
    rotateAround $axis
    travelOut                 
}

set ::AutoAnimate_debug 0
# frames per second for doing the animation
# set ::AutoAnimate_FPS   25.0
# screen fps set to 60
set ::AutoAnimate_FPS   60.0
# at leas 1ms. of delay
set ::AutoAnimate_Delay [ expr 1000.0 / double( $::AutoAnimate_FPS)]

namespace eval AutoAnimate {
    variable _w
    variable _w_list
    variable _escenas
    variable _datos_escenas
    variable _auto_id
    variable _color_fondo
    variable _color_sel
    #variable _escena_sel
    variable _menu_b_derecho_nombres
    variable _menu_b_derecho_comandos
    variable _inicializado
    variable _hay_cambios
    variable _after_focus
    variable _batch_out
    variable _prev_destroy_bind
    variable _animate_results
    variable _animate_results_data
    variable _old_AutomaticRotationCenter [ GiD_Set AutomaticRotationCenter]


    proc DebugWarnWinText { txt} {
        if { $::AutoAnimate_debug } {
            WarnWinText $txt
        }
    }

    proc IniVariables { wlist } {
        variable _auto_id        
        #variable _escena_sel
        variable _menu_b_derecho_nombres
        variable _menu_b_derecho_comandos
        variable _inicializado
        variable _hay_cambios
        variable _escenas
        variable _datos_escenas
        variable _after_focus
        variable _prev_destroy_bind
        variable _batch_out
        variable _animate_results
        variable _animate_results_data

#WarnWinText "Inicializado? [ info exists _inicializado]"        
        if { ![ info exists _inicializado]} {
            set _auto_id 1
            #set _escena_sel ""
            set _menu_b_derecho_nombres(0)    [ list [_ "Enable"] [_ "Disable"] [_ "Delete"] [_ "Animate scene"]]
            set _menu_b_derecho_comandos(0)   { {HabilitaEscena} {DesHabilitaEscena} {BorraEscena} {AnimaEscena}}
            set _inicializado 1
            set _hay_cambios 0
            set _after_focus ""
            set _batch_out ""
            set _prev_destroy_bind ""
            set _animate_results 0
            set _animate_results_data(idx) 0
            set _animate_results_data(repeted_script_redraws) 1
            set _animate_results_data(repeted_results_redraws) 1
            set _animate_results_data(repetitions) 1
        } else {
#WarnWinText "reconstruyendo? [ info exists _datos_escenas]"
            if { [ info exists _datos_escenas]} {
                foreach esc $_datos_escenas(lista) {
                    set que $_datos_escenas($esc,tipo)
                    set datos $_datos_escenas($esc,datos)
                    set nombre [ AnyadeEscena $que $wlist $esc]
                    $nombre setdatos $datos
                    $nombre haycambios 0
#WarnWinText "reconstruyendo($nombre) $que $wlist $esc"
                }
                array unset _datos_escenas
                set _hay_cambios 0
            }
        }
        set _batch_out ""
    }

    proc DisableGUIUpdates { } {
        variable _old_AutomaticRotationCenter

        GiD_Project set disable_windows 1
        GiD_Project set disable_warnline 1
        set _old_AutomaticRotationCenter [ GiD_Set AutomaticRotationCenter]
        GiD_Set AutomaticRotationCenter 0

    }
    
    proc EnableGUIUpdates { } {
        variable _old_AutomaticRotationCenter
        GiD_Project set disable_windows 0
        GiD_Project set disable_warnline 0
        GiD_Set AutomaticRotationCenter $_old_AutomaticRotationCenter
    }

    proc StopAnimacion { wbot cmd} {
        variable _escenas
        if { [info exists _escenas] } {
            foreach esc $_escenas {
                $esc stop
            }
        }
        if { [ winfo exists $wbot]} {
            $wbot configure -text [_ "Animate"] -command $cmd
        }
    }

    proc DoStopAnimation { wbot old_cmd } {
        ::AutoAnimate::StopAnimacion $wbot $old_cmd
        EnableGUIUpdates
    }

    proc Animar { wbot { meter_comentarios_batch 0} } {
        variable _escenas
        variable _w_list
        variable _batch_out
        variable _animate_results

        if { ![ info exists _escenas]} {
            WarnWin [_ "You have to define at least one scene."]
            return
        }

        if { $_animate_results} {
            if { ![ DefineAnimateResultData]} {
                WarnWin [_ "Please, define the results animation."] $wbot
                # may be it's not open, so let's open the window
                PostAnimateWindowCheckingModel
                return
            }

            # disable simple model animations in the Post Animate Results Window
            ModelSimpleAnimations::Disable            
        }

        # set delay time for animation controls window
        PostAnimateControlsCheckDelayTime $::AutoAnimate_Delay

        set cmd GiD_Process
        if { $_batch_out != ""} {
            set cmd ::AutoAnimate::WriteBatchFile
        }

        DisableGUIUpdates

        set old_cmd [$wbot cget -command]
        $wbot configure -text [_ "Stop"] \
            -command "[list AutoAnimate::DoStopAnimation $wbot $old_cmd]"
        update

        if { $meter_comentarios_batch} {
            set tt [ CalcTiempoTotal]
            $cmd *****COMMENTS Batch AutoAnimate script, duration $tt seconds, created on [ clock format [ clock seconds]]
            set tp 0.0
        }

        foreach esc $_escenas {
#WarnWinText "            [ winfo parent $_w_list] see [ $esc widget]"
            #[ winfo parent $_w_list] see [ $esc widget]
            focus [ $esc widget]
            if { $meter_comentarios_batch} {
                $cmd *****COMMENTS ${tp}/$tt s. Now [ $esc quesoy]( [ $esc comoestoy]) [$esc gettime]s.
                set tp [ expr $tp + [ $esc gettime]]
            }
            if { ![ $esc animar $cmd $_animate_results]} {
                break
            }
        }
        EnableGUIUpdates
        if { [ winfo exists $wbot] } {
            $wbot configure -text [_ "Animate"] -command $old_cmd
        }
    }

    proc PopUpMenuBotonDerecho { m w x y} {
        #$w gidmakecurrent
        set xx [expr [ winfo rootx $w] + $x + 2]
        set yy [expr [ winfo rooty $w] + $y]
        catch {
            tk_popup $m $xx $yy 0
        }
    }

    proc BorraEscena { nombre } {
        variable _escenas

        if { ![ info exists _escenas]} { return}
        set idx [ lsearch $_escenas $nombre]
        if { $idx != -1} {
            set _escenas [lreplace $_escenas $idx $idx]
        }
        $nombre borrar

        MuestraTiempoTotal "" "" ""
    }

    proc HabilitaEscena { nombre } {
        $nombre habilitar
    }

    proc DesHabilitaEscena { nombre } {
        $nombre deshabilitar
    }

    proc AnimaEscena { nombre} {
        $nombre animar
    }

    proc MenuBotonDerecho { nombre w} {
        variable _menu_b_derecho_nombres
        variable _menu_b_derecho_comandos

        set old_cmds $_menu_b_derecho_comandos(0)
        set _menu_b_derecho_comandos(0) {}
        foreach cmd $old_cmds {
            lappend _menu_b_derecho_comandos(0) [ list -np- ::AutoAnimate::$cmd $nombre]
        }

        menu $w.m3d -tearoff no
        CreateCascadedMenu $w.m3d \
                ::AutoAnimate::_menu_b_derecho_nombres \
                ::AutoAnimate::_menu_b_derecho_comandos \
                "" 0 ""
        
        bind $w <$::gid_right_button> "::AutoAnimate::PopUpMenuBotonDerecho $w.m3d %W %x %y"
        
        set _menu_b_derecho_comandos(0) $old_cmds
    }

    proc CalcTiempoTotal { } {
        variable _escenas

        set tt 0.0
        if { [ info exists _escenas]} {
            foreach esc $_escenas {
                set ti [$esc gettime]
                if { [string is double -strict $ti] } {
                    set tt [expr {$tt+$ti}]
                }
            }
        }
        return $tt
    }

    proc MuestraTiempoTotal { n1 n2 op} {
        variable _w
        variable _hay_cambios

        set tt [ CalcTiempoTotal]

        $_w.f.fstate.l2 configure -text $tt -width [ string length $tt]
        set _hay_cambios 1

        # actualize Animation Results Window time-length too
        ConfigureAnimateResultsWindow
    }

    proc EnfocaEscena { w} {
        variable _after_focus

        set ultf [ focus -lastfor $w]
        if { ( "$ultf" == "") || \
                ![ string match [ winfo class $ultf] Entry] } {
            focus $w
        } else {
            #$ultf selection clear
            #focus $w
            if { "$_after_focus" == ""} {
                set _after_focus [ after 2000 "$ultf selection clear; focus $w; set ::AutoAnimate::_after_focus \"\""]
            }
        }
    }

    proc AnyadeEscena { que w { nombre_dado ""}} {
        variable _escenas
        variable _auto_id
        variable _color_fondo
        variable _color_sel
        variable _hay_cambios
        variable _w_sc
        variable _debug

        if { "$nombre_dado" == ""} {
            set nombre Scene_$_auto_id
        } else {
            set nombre $nombre_dado
            if { [ regexp {.*_Scene_([0-9]+)$} $nombre_dado dum aa]} {
                set _auto_id $aa
            }
        }
        if { "$que" == "ZoomPan"} {
            #DefineEscenaZoomPan $nombre
            set nombre [ ::ZoomPan::ZoomPan $nombre $w.sc_$_auto_id]
        } elseif { "$que" == "Rotacion"} {
            set nombre [ ::Rotacion::Rotacion $nombre $w.sc_$_auto_id]
            #DefineEscenaRotacion $nombre
        } elseif { "$que" == "RenderState"} {
            set nombre [ ::RenderState::RenderState $nombre $w.sc_$_auto_id]
        }
        ::AutoAnimate::DebugWarnWinText "defining $nombre as $_auto_id"
        ttk::frame $w.sc_$_auto_id -takefocus 1
        
        #grid $w.sc_$_auto_id.f
        grid $w.sc_$_auto_id
        #bind $w.sc_$_auto_id <FocusIn> "[ winfo parent $w] see $w.sc_$_auto_id"
        bind $w.sc_$_auto_id <Enter> "::AutoAnimate::EnfocaEscena $w.sc_$_auto_id"
        # bind $w.sc_$_auto_id <Enter> "
        # set ::AutoAnimate::_escena_sel [ focus -lastfor $w.sc_$_auto_id] ;
        # focus $w.sc_$_auto_id"
        # bind $w.sc_$_auto_id <Leave> "
        # if { \"::AutoAnimate::_escena_sel\" != \"\"} {
        #     focus $::AutoAnimate::_escena_sel;
        # }"

        # creamos el menu para que despues lo propage
        MenuBotonDerecho $nombre $w.sc_$_auto_id

        # al create ya nos propaga el bind <$::gid_right_button> para todos los subwidgets
        $nombre create

        lappend _escenas $nombre
        $nombre timetrace ::AutoAnimate::MuestraTiempoTotal
        
        incr _auto_id
        set _hay_cambios 1
        
        ResizeScrolledCanvas $_w_sc
        
        return $nombre
    }

    proc BorraTodo { verifica_cambios w { w_event ""}} {
        variable _escenas
        variable _datos_escenas
        variable _hay_cambios
        ::AutoAnimate::DebugWarnWinText "BorraTodo $verifica_cambios $w -$w_event-"
        if { ( $w_event != "") && ( $w_event != $w)} {
            # borratodo is also called by the bind $w <Destroy>, $w = toplevel window
            # so delete everything only for the toplevel window
            return 0
        }
        # stop current animation
        DoStopAnimation "" ""
        if { [ info exists _escenas]} {
            ##WarnWinText "guion $_hay_cambios"
            if { $verifica_cambios} {
                foreach esc $_escenas {
                    if { [ $esc haycambios]} {
                        set _hay_cambios 1
                        break
                    }
                }
                if { $_hay_cambios} {
                    set retval [MessageBoxOptionsButtons [_ "Warning"] \
                            [_ "The last changes have not been saved. Do you want to save them?"] \
                            {0 1 2} [list [_ "Yes"] [_ "No"] [_ "Cancel"]] warning ""]
                    # cancel, volvemos a la ventana principal sin hacer nada
                    if { $retval == 2 } { return 0 }
                    # no, los guardamos
                    # unset de _escenas if { $retval == 1 } { return 1 }
                    # yes, los guardamos
                    if { $retval == 0 } { GuardarGuion $w }
                }
            }
            # al pasar de pre a post, se cierra y abre la ventana, mejor no borramos los datos...
            if { [ info exists _escenas]} {
                set _datos_escenas(lista) $_escenas
                unset _escenas
                foreach esc $_datos_escenas(lista) {
                    set _datos_escenas($esc,tipo) [ $esc quesoy]
                    set _datos_escenas($esc,datos) [ $esc getdatos]
                    $esc borrar
#WarnWinText "   BorraTodo-> borrando $esc"
                }                
##WarnWinText "escenas? [ info exists _escenas]"
            }
        }
        return 1
    }

    proc Fin { w} {
        variable _prev_destroy_bind
        ::AutoAnimate::DebugWarnWinText Fin
        if { [BorraTodo 1 $w] != 0 } {
            bind $w <Destroy> $_prev_destroy_bind
            destroy $w
        }
    }

    proc LeerGuion { wparent wlist} {
        variable _hay_cambios
        variable _datos_escenas
        variable _w_list
#WarnWinText LeerGuion
        set types [ list \
                [ list [_ "Animation script file"] [ list .asr]] \
                [ list [_ "All files"] .*]]
        
        set fname [MessageBoxGetFilename file read [_ "Load animation script"] \
                "" $types .asr 0] 
        ::AutoAnimate::DebugWarnWinText "LeerGuin $fname"       
        if { "$fname" == ""} { return 0}

        if { ![ BorraTodo 1 $wparent ]} { return 0}
        ::AutoAnimate::DebugWarnWinText "datosescenas? [ info exists _datos_escenas]"
        if { [ info exists _datos_escenas]} { array unset _datos_escenas}

        set fi [ open $fname]
        set err 0
        set hay 0
        set nombre_escena ""
        while { ![eof $fi]} {
            gets $fi linea
            if { [ regexp {^Animation script: (.*)$} $linea dum nombre_tmp]} {
                set nombre_escena $nombre_tmp
                set hay 1
                break
            }
        }
        if { $hay} { # a leer escena del script $nombre
            while { ![eof $fi]} {
                gets $fi linea
                # la 'nombre_escena tipo_escena \{' inicial
                if { [ regexp {^([^ ]+) ([^ ]+) \{$} $linea dum escena que]} {
                    # a leer la escena
                    set err_txt ""
                    set no_existe [ catch {
                        set nombre [ AnyadeEscena $que $_w_list $escena]
                        gets $fi linea
                        $nombre setdatos $linea
                        $nombre haycambios 0
                    } err_txt ]
                    if { $no_existe} {
                        ::AutoAnimate::DebugWarnWinText "Unknow scene '$que': $err_txt"
                    }
                    # la '\}' final
                    gets $fi linea
                } elseif { [ regexp {^Animation script: (.*)$} $linea dum nombre_tmp]} {
                    # otro guion, de momento no implementado, break
                    break
                }
            }
        } else {
            WarnWin [_ "Nothing read."]
            set err 1
        }
        close $fi
        if { !$err} {
            #WarnWin "Animation script $fname read." $wparent
        }
        set _hay_cambios 0
    }

    proc GuardarGuion { wparent} {
        variable _escenas
        variable _hay_cambios

        if { ![ info exists _escenas] || ( [ llength $_escenas] == 0)} {
            WarnWin [_ "Nothing to do."]
        }
        set types [list \
            [list [_ "Animation script file"] [list .asr]] \
            [list [_ "All files"] .*]]
        set fname [MessageBoxGetFilename file write [_ "Save animation script"] \
                    "" $types .asr 0]
        if { "$fname" == ""} { return 0}
        
        set fo [ open $fname w]
        puts $fo "# Animation script '$fname' created on [ clock format [ clock seconds]]"
        puts $fo "Animation script: [ file tail $fname]"
        set err 0
        foreach esc $_escenas {
            puts $fo "$esc [ $esc quesoy] {"
            puts $fo [ $esc getdatos]
            $esc haycambios 0
            puts $fo "}"
        }
        if { !$err} {
            puts $fo "End animation script\n"
        }
        close $fo

        if { !$err} {
            GidUtils::SetWarnLine [_ "Animation script '%s' saved." $fname]
            set _hay_cambios 0
        }
    }

    proc WriteBatchFile { args} {
        if { [ llength $args] == 1} {
            puts $::AutoAnimate::_batch_out $args
        } else {
            set n [ llength $args]
            set i 0
            for { set i 0} { $i < [ expr $n - 1]} { incr i} {
                set cmd [ lindex $args $i]
                puts -nonewline $::AutoAnimate::_batch_out "$cmd "
            }
            if { $n} {
                puts $::AutoAnimate::_batch_out [ lindex $args [ expr $n - 1]]
            }
        }
        if { [ lindex $args 0] != "*****COMMENTS"} {            
            # needs to be done for the zoom factors
            GiD_Process {*}$args
        }
    }

    proc GuardarGuionBatch { wparent wbot} {
        variable _escenas
        variable _hay_cambios
        variable _batch_out

        if { ![ info exists _escenas] || ( [ llength $_escenas] == 0)} {
            WarnWin [_ "Nothing to do."]
        }

        set types [list \
            [list [_ "Batch file"] [list .bch]] \
            [list [_ "All files"] .*]]
        set fname [MessageBoxGetFilename file write [_ "Save batch file"] \
                    "" $types .bch 0]
        if { "$fname" == ""} { return 0}

        set err 0
        set fo [ open $fname w]
        set _batch_out $fo

        set errorInfo ""
        set err [ catch {
            # lo queremos con comentarios en batch
            ::AutoAnimate::Animar $wbot 1
        } errorInfo ]

        close $fo
        set _batch_out ""

        if { !$err} {
            GidUtils::SetWarnLine [_ "Batch file %s saved." $fname]
            set _hay_cambios 0
        } else {
            WarnWin [_ "Couldn't create the animation batch file. Reason:\n%s - %s" $err $errorInfo]
        }
    }

    proc ConfigureAnimateResultsWindow { } {
        variable _animate_results
        if { $::AutoAnimate::_animate_results} {
            set anim_scrip_length [ CalcTiempoTotal]
            set res_anim_length [ expr $anim_scrip_length / double( $::AutoAnimate::_animate_results_data(repetitions))]
            set ::GidPriv(PostAnimateDurationType) TotalTime
            set ::GidPriv(PostAnimateDurationTime) $res_anim_length
        }
    }

    proc OpenAndConfigureAnimateResultsWindow { } {
        variable _animate_results
        if { $::AutoAnimate::_animate_results} {
            PostAnimateWindowCheckingModel
            ConfigureAnimateResultsWindow
        }
    }

    proc Create { { w .gid.wAutoAnimate} } {
        variable _w
        variable _w_list
        variable _w_sc
        variable _escenas
        variable _color_fondo
        variable _color_sel
        variable _prev_destroy_bind
        variable _animate_results
        variable _animate_results_data        
        InitWindow2 $w -title [_ "Automatic animation"] \
            -geometryvariable PrePostAutoAnimateWindowGeom \
            -initcommand ::AutoAnimate::Create \
            -ontop
        if { ![winfo exists $w] } return

        set _w $w
               
        ttk::frame $w.fviews

        #set sw [ScrolledWindow $w.fviews.sc -relief groove -borderwidth 2]
        #set sf [ScrollableFrame $sw.f]
        #$sw setwidget $sf
        set c [CreateScrolledCanvas $w.fviews.sc]        
        set _w_sc $w.fviews.sc
        set sf [ttk::frame $c.f]
        AddToScrolledCanvas $w.fviews.sc $sf
        
        #set wlist [ $sf getframe]
        set wlist $sf
        set _w_list $wlist

        grid $w.fviews.sc -sticky news
        grid rowconfigure $w.fviews 0 -weight 1
        grid columnconfigure $w.fviews 0 -weight 1

        ttk::frame $w.f

        ttk::frame $w.f.fadd
        ttk::button $w.f.fadd.anyadeZoom -text [_ "+ zoom/pan"] \
                -command "::AutoAnimate::AnyadeEscena ZoomPan $_w_list"
        ttk::button $w.f.fadd.anyadeRot -text [_ "+ rotation"] \
                -command "::AutoAnimate::AnyadeEscena Rotacion $_w_list"
        ttk::button $w.f.fadd.anyadeRender -text [_ "+ render"] \
                -command "::AutoAnimate::AnyadeEscena RenderState $_w_list"        
        grid $w.f.fadd.anyadeZoom $w.f.fadd.anyadeRot $w.f.fadd.anyadeRender -padx 2 -pady 4 -sticky w      

        ttk::frame $w.farch
        ttk::button $w.farch.leer -text [_ "Load script"] \
                 -command "::AutoAnimate::LeerGuion $w $wlist"
        ttk::button $w.farch.guardar -text [_ "Save script"] \
                 -command "::AutoAnimate::GuardarGuion $w"
        ttk::button $w.farch.guardarbatch -text [_ "Export as batch"] \
                 -command "::AutoAnimate::GuardarGuionBatch $w  $w.botones.animar"

        grid $w.farch.leer $w.farch.guardar $w.farch.guardarbatch -pady 4 -padx 2 -sticky w

        ttk::frame $w.f.fstate
        ttk::label $w.f.fstate.l1 -text [_ "Total time"]:
        ttk::label $w.f.fstate.l2 -text 0
        ttk::label $w.f.fstate.l3 -text [_ "sec."]
        grid $w.f.fstate.l1 $w.f.fstate.l2 $w.f.fstate.l3 -pady 4 -sticky e

        grid $w.f.fadd -sticky w
        grid $w.f.fstate -row 0 -column 1 -sticky e

        grid rowconfigure $w.f 0 -weight 1
        grid columnconfigure $w.f 0 -weight 1
        grid columnconfigure $w.f 1 -weight 1

        # link to results animation
        ttk::frame $w.fRes
        ttk::checkbutton $w.fRes.cbResAnim -text [_ "Do result animation too."] \
            -variable ::AutoAnimate::_animate_results \
            -command ::AutoAnimate::OpenAndConfigureAnimateResultsWindow
        ttk::button $w.fRes.bResAnimWindow -text [_ "Animate results"]... -command PostAnimateWindowCheckingModel
        ttk::label $w.fRes.lRepeat -text [_ "Repetitions"]:
        # ttk::spinbox $w.fRes.sbRepeat -from 1 -to 1000 -increment 1 \
        #     -command [ subst -nocommands { set ::AutoAnimate::_animate_results_data(repetitions) [ $w.fRes.sbRepeat get]}]
        UpDownEntry $w.fRes.sbRepeat -variable ::AutoAnimate::_animate_results_data(repetitions) \
            -entry-options "-width 3" -from 1 -to 1000 -increment 1

        grid $w.fRes.cbResAnim $w.fRes.bResAnimWindow $w.fRes.lRepeat $w.fRes.sbRepeat -pady 4 -padx 2 -sticky w
        grid configure $w.fRes.bResAnimWindow -sticky e
        grid configure $w.fRes.lRepeat -sticky e

        ttk::frame $w.botones -style BottomFrame.TFrame

        ttk::button $w.botones.animar -text [_ "Animate"] \
                -command "::AutoAnimate::Animar $w.botones.animar" \
                -style BottomFrame.TButton
        ttk::button $w.botones.animctrl -text [_ "Animation controls"]... \
                -command PostAnimateControlsWindow -style BottomFrame.TButton
        ttk::button $w.botones.close -text [_ "Close"] \
                -command "::AutoAnimate::Fin $w" -style BottomFrame.TButton
      
        grid $w.botones.animar $w.botones.animctrl $w.botones.close -pady 10 -padx 4 -sticky ews
        
        grid $w.farch -sticky nwe -pady 4 -padx 4
        grid $w.fviews -sticky wens -pady 4 -padx 4
        grid $w.f -sticky swe
            grid $w.fRes -sticky we
        grid $w.botones -sticky sew
        grid anchor $w.botones center

        #grid rowconfigure $w 0 -weight 1
        grid rowconfigure $w 1 -weight 1
        #grid rowconfigure $w 2 -weight 1
        #grid rowconfigure $w 3 -weight 1
        grid columnconfigure $w 0 -weight 1

        IniVariables $_w_list

        # delay 8 in animatecontrols because are generated enough images (120 fps)
        if {  ![ info exists ::GidPriv(PostAnimateControlsSavingAnimation) ] || \
                !$::GidPriv(PostAnimateControlsSavingAnimation) } {
            PostAnimateControlsCheckDelayTime $::AutoAnimate_Delay
            set ::GidPriv(PostAnimateControlsSaveRedraws) 1
        }
        
        # para que guarde el guion al pasar de pre a post
        set _prev_destroy_bind [ bind $w <Destroy>]
        bind $w <Destroy> "+::AutoAnimate::BorraTodo 0 $w %W"
    }

    proc DefineAnimateResultData {} {
        variable _animate_results_data

        set tt [ CalcTiempoTotal]
        set my_num_steps [ expr int( $tt * $::AutoAnimate_FPS)]
        set num_res_steps [ PostAnimateGetNumberOfSteps]
        if { !$num_res_steps} {
            return 0
        }
        # mey be the results animation loop should be repeated
        set num_res_steps [ expr $num_res_steps * $_animate_results_data(repetitions)]
        
        set _animate_results_data(idx) 0
        set _animate_results_data(repeted_script_redraws) 1
        set _animate_results_data(repeted_results_redraws) 1
        if { $my_num_steps > $num_res_steps} {
            # calculate number of ScriptAnimate step for each result step
            set my_num_repeated_redraws [ expr int( 0.5 + double( $my_num_steps) / double( $num_res_steps))]
            if { $my_num_repeated_redraws <= 0} {
                set my_num_repeated_redraws 1
            }
            set _animate_results_data(repeted_script_redraws) $my_num_repeated_redraws
        } else {
            # calculate number of result step for each ScriptAnimate step
            set my_num_repeated_redraws [ expr int( 0.5 + double( $num_res_steps) / double( $my_num_steps))]
            if { $my_num_repeated_redraws <= 0} {
                set my_num_repeated_redraws 1
            }
            set _animate_results_data(repeted_results_redraws) $my_num_repeated_redraws
        }
        return 1
    }

    proc AnimateResultStep {} {
        variable _animate_results_data
        incr _animate_results_data(idx)
        # check if current script animation step should update result step
        if { $_animate_results_data(idx) == $_animate_results_data(repeted_script_redraws)} {
                # may be for a single script animation step, several results animations steps should be done
            for { set i 0} { $i < $_animate_results_data(repeted_results_redraws)} { incr i} {
                PostAnimateDoStep 0 0
                update
            }
            set _animate_results_data(idx) 0
        } else {
        }
    }
}


namespace eval ::ZoomPan:: {
    variable _datos
    variable _hay_cambios

    namespace export ZoomPan

    proc ZoomPan { nombre w } {
        variable _datos

        # globalizamos el nombre
        if { ![ string match "::*" $nombre]} {
            set ns [ uplevel 1 namespace current]
            if { "::" != $ns} {
                append ns "::"
            }
            set nombre "$ns$nombre"
        }

        # miramos si ya existe
        if { [ info commands $nombre] != ""} {
            ::AutoAnimate::DebugWarnWinText " ZP --> command name \"$nombre\" already exists."
            return -code error [_ "command name '%s' already exists." $nombre]
        }

        # guardamos datos
        set _datos($nombre,_w) $w
        set _hay_cambios($nombre) 0
        set _datos($nombre,animando) 0
        set _datos($nombre,stop) 0

        # creamos los metodos
        proc $nombre {que args} "::ZoomPan::procesa $nombre \$que \$args"

        return $nombre
    }

    proc procesa { nombre que args} {
        variable _datos
        variable _hay_cambios

        switch -exact -- $que {
            create {
                ::ZoomPan::Create $nombre
            }
            animar {
                eval ::ZoomPan::Animar $nombre {*}$args
            }
            deshabilitar {
                ::ZoomPan::DesHabilitar $nombre
            }
            habilitar {
                ::ZoomPan::Habilitar $nombre
            }
            borrar {
                ::ZoomPan::Borrar $nombre
            }
            gettime {
                if { $::ZoomPan::_datos($nombre,_habilitado)} {
                    return $::ZoomPan::_datos($nombre,_time)
                } else {
                    return 0
                }
            }
            timetrace {
                ::ZoomPan::TimeTraceProc $nombre $args
            }
            quesoy {
                return ZoomPan
            }
            comoestoy {
                if { $_datos($nombre,_habilitado)} {
                    return [_ "Enabled"]
                } else {
                    return [_ "Disabled"]
                }
            }
            getdatos {
                return [ ::ZoomPan::GetDatos $nombre ]
            }
            setdatos {
                return [ ::ZoomPan::SetDatos $nombre $args ]
            }
            haycambios {
                ##WarnWinText "ZoomPan [ llength [ lindex $args 0]] -[ lindex $args 0]- /$_hay_cambios($nombre)/"
                if { [ llength [ lindex $args 0]] == 0} {
                    return $_hay_cambios($nombre)
                } else {
                    set _hay_cambios($nombre) [ lindex $args 0]
                }
            }
            widget {
                return $_datos($nombre,_w)
            }
            stop {
                if { $_datos($nombre,animando)} {
                    set _datos($nombre,stop) 1
                }
            }
        }
    }

    #proc implemented twice, one for namespace ::ZoomPan:: and another for ::Rotacion:: !!
    proc get_rid_of_problematic_settings_in_view { view} {
        set tmp {}
        set items_to_skip [ list nowuse drawingtype]
        foreach item $view {
            set key [ string tolower [ lindex $item 0]]
            if { [ lsearch $items_to_skip $key] == -1} {
                lappend tmp $item
            }
        }
        return $tmp
    }

    proc GetGiDView { var nombre} {
        variable _hay_cambios
        
        set $var [ get_rid_of_problematic_settings_in_view [ GiD_Info view]]
        set _hay_cambios($nombre) 1
    }

    proc Create { nombre} {
        variable _datos
        variable _hay_cambios
        
        set w $_datos($nombre,_w)
        ttk::label $w.l1 -text [_ "Zoom/Pan"]:
        ttk::button $w.bf -text [_ "Start view"] \
                -command "::ZoomPan::GetGiDView ::ZoomPan::_datos($nombre,_old) $nombre"
                       
        ttk::button $w.bt -text [_ "End view"] \
                -command "::ZoomPan::GetGiDView ::ZoomPan::_datos($nombre,_new) $nombre"
                       
        ttk::label $w.l2 -text [_ "Duration"]:
        if { [info exists ::ZoomPan::_datos($nombre,_time)]} {
            set ::ZoomPan::_datos($nombre,_time) 5
        }
        ttk::entry $w.e -width 3 -textvariable ::ZoomPan::_datos($nombre,_time) -justify right
        ttk::label $w.l3 -text [_ "s."]

        grid $w.l1 $w.bf $w.bt $w.l2 $w.e $w.l3
        
        # activar el menu del 3r boton
        set scr [ bind $w <$::gid_right_button>]
        foreach s "$w.l1 $w.bf $w.bt $w.l2 $w.e $w.l3" {
            bind $s <$::gid_right_button> $scr
        }
        
        set _datos($nombre,_time) 5
        set _datos($nombre,_habilitado) 1
        set _datos($nombre,_trace) ""
        set _hay_cambios($nombre) 1

        # para seleccionar la vista incicial... mientras no se deciden
        if { ![ info exists ::ZoomPan::_datos($nombre,_old)]} {
            ::ZoomPan::GetGiDView ::ZoomPan::_datos($nombre,_old) $nombre
        }
        if { ![ info exists ::ZoomPan::_datos($nombre,_new)]} {           
            ::ZoomPan::GetGiDView ::ZoomPan::_datos($nombre,_new) $nombre
        }

        return $w
    }

    proc Animar { nombre args} {
        variable _datos
        set cmd GiD_Process
        set animate_results 0
        foreach [ list cmd animate_results] $args {}

        if { !$_datos($nombre,_habilitado)} {
            return 1
        }
        
        if { ![ info exists _datos($nombre,_old)]} {
            WarnWin [_ "select the %s 'from' view" $nombre]
            return 0
        }
        if { ![ info exists _datos($nombre,_new)]} {
            WarnWin [_ "select the %s 'to' view" $nombre]
            return 0
        }
        if { ( $_datos($nombre,_time) < 0.0) || ( $_datos($nombre,_time) > 1000)} {
            WarnWin [_ "The Time for the %s Zoom/Pan is too little (<0) or too big (>1000): %s" \
                    $nombre $_datos($nombre,_time)]
            return 0
        }
        
        for { set i 0} { $i < [ llength $_datos($nombre,_old)]} { incr i} {
            set oldcomp [ lindex $_datos($nombre,_old) $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "x"} {
                set zp_old(left) [ lindex $oldcomp 1]
                set zp_old(right) [ lindex $oldcomp 2]
            } elseif { "$key" == "y"} {
                set zp_old(top) [ lindex $oldcomp 1]
                set zp_old(bottom) [ lindex $oldcomp 2]
            }
        }
        for { set i 0} { $i < [ llength $_datos($nombre,_new)]} { incr i} {
            set newcomp [ lindex $_datos($nombre,_new) $i]
            set key [ string tolower [ lindex $newcomp 0]]
            if { "$key" == "x"} {
                set zp_new(left) [ lindex $newcomp 1]
                set zp_new(right) [ lindex $newcomp 2]
            } elseif { "$key" == "y"} {
                set zp_new(top) [ lindex $newcomp 1]
                set zp_new(bottom) [ lindex $newcomp 2]
            }
        }
        
        set zp_old(width) [ expr $zp_old(right) - $zp_old(left)]
        set zp_old(height) [ expr $zp_old(top) - $zp_old(bottom)]
        set zp_new(width) [ expr $zp_new(right) - $zp_new(left)]
        set zp_new(height) [ expr $zp_new(top) - $zp_new(bottom)]
        
        set num_steps [ expr $_datos($nombre,_time) * $::AutoAnimate_FPS]
        if { !$num_steps} { # hacemos el zoom/pan directamente
            $cmd Mescape View SetView $_datos($nombre,_old) escape
            $cmd Mescape View SetView $_datos($nombre,_new) escape
            if { $animate_results} {
                ::AutoAnimate::AnimateResultStep
            }
            return 1
        }
        set es_cero 1
        foreach t "left right top bottom" {
            set inc($t) [ expr ( $zp_new($t) - $zp_old($t)) / $num_steps]
            set step($t) $zp_old($t)
            if { $inc($t) != 0.0} {
                set es_cero 0
            }
        }
        
        #if { $es_cero} {
        #    WarnWin [_ "No Zoom/Pan is done."]
        #    return 0
        #}
        
        set que_zoom in
        if { $zp_new(width) > $zp_old(width)} {
            set que_zoom out
        }
        
        proc get_zoom_from_view { que_zoom t_step t_zoom} {
            upvar $t_step new
            upvar $t_zoom zoom
        
            set old(view) [ get_rid_of_problematic_settings_in_view [ GiD_Info view]]
            for { set i 0} { $i < [ llength $old(view)]} { incr i} {
                set oldcomp [ lindex $old(view) $i]
                set key [ string tolower [ lindex $oldcomp 0]]
                if { "$key" == "x"} {
                    set old(left) [ lindex $oldcomp 1]
                    set old(right) [ lindex $oldcomp 2]
                } elseif { "$key" == "y"} {
                    set old(top) [ lindex $oldcomp 1]
                    set old(bottom) [ lindex $oldcomp 2]
                }
            }
            set old(width) [ expr $old(right) - $old(left)]
            set old(height) [ expr $old(top) - $old(bottom)]
        
            if { "$que_zoom" == "in"} {
                set zoom(left) [ expr 2.0 * ( $new(left) - $old(left)) / $old(width) - 1.0]
                set zoom(right) [ expr 2.0 * ( $new(right) - $old(left)) / $old(width) - 1.0]
                set zoom(bottom) [ expr 2.0 * ( $new(bottom) - $old(bottom)) / $old(height) - 1.0]
                set zoom(top) [ expr 2.0 * ( $new(top) - $old(bottom)) / $old(height) - 1.0]
            } else {
                set zoom(left) [ expr 2.0 * ( $old(left) - $new(left)) / $new(width) - 1.0]
                set zoom(right) [ expr 2.0 * ( $old(right) - $new(left)) / $new(width) - 1.0]
                set zoom(bottom) [ expr 2.0 * ( $old(bottom) - $new(bottom)) / $new(height) - 1.0]
                set zoom(top) [ expr 2.0 * ( $old(top) - $new(bottom)) / $new(height) - 1.0]
            }
        }

        set _datos($nombre,animando) 1
        # nos aseguramos el primer estado
        $cmd Mescape View SetView $_datos($nombre,_old) escape
        
        for { set i 0} { $i < $num_steps} { incr i} {
            foreach t "left right top bottom" {
                set step($t) [ expr $step($t) + $inc($t)]
            }
            set step(width) [ expr $step(right) - $step(left)]
            set step(height) [ expr $step(top) - $step(bottom)]
            get_zoom_from_view $que_zoom step zoom_step
            ##WarnWinText "$zoom_step(left) $zoom_step(right) --- $zoom_step(top) $zoom_step(bottom)"
            $cmd 'Zoom $que_zoom LeftMouse $zoom_step(left) $zoom_step(bottom) LeftMouse $zoom_step(right) $zoom_step(top)
            if { $animate_results} {
                ::AutoAnimate::AnimateResultStep
            }
        
            # after 40
            after [ expr int( 0.5 + $::AutoAnimate_Delay)]
            update
            # update idletasks
            if { $_datos($nombre,stop)} {
                set _datos($nombre,animando) 0
                set _datos($nombre,stop) 0
                return 0
                #break
            }
        }
        set _datos($nombre,animando) 0
        set _datos($nombre,stop) 0

        return 1
    }

    proc Habilitar { nombre} {
        variable _datos

        if { !$_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 1

            set w $_datos($nombre,_w)
            $w.l1 state !disabled
            $w.bf state !disabled
            $w.bt state !disabled
            $w.l2 state !disabled
            $w.e state !disabled
            $w.l3 state !disabled
        
        }
    }

    proc DesHabilitar { nombre} {
        variable _datos

        if { $_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 0

            set w $_datos($nombre,_w)
            $w.l1 state disabled
            $w.bf state disabled
            $w.bt state disabled
            $w.l2 state disabled
            $w.e state disabled
            $w.l3 state disabled
        }
    }

    proc Borrar { nombre} {
        variable _datos
        ::AutoAnimate::DebugWarnWinText "   ZP Borrar $nombre"
        destroy $_datos($nombre,_w)
        if { [ info exists _datos($nombre,_trace)] && ( "$_datos($nombre,_trace)" != "")} {
            trace vdelete ::ZoomPan::_datos($nombre,_time) w $_datos($nombre,_trace)
            trace vdelete ::ZoomPan::_datos($nombre,_habilitado) w $_datos($nombre,_trace)
        }
        foreach idx "_w _time _habilitado _trace _old _new" {
            if { [ info exists _datos($nombre,$idx)]} {
                unset _datos($nombre,$idx)
            }
        }
        #unset _datos($nombre,_w)
        #unset _datos($nombre,_time)
        #unset _datos($nombre,_habilitado)
        #unset _datos($nombre,_trace)
        #if { [ info exists _datos($nombre,_old)]} { unset _datos($nombre,_old)}
        #if { [ info exists _datos($nombre,_new)]} { unset _datos($nombre,_new)}
        if { [ info procs $nombre] != ""} {
            rename $nombre ""
        }
    }

    proc TimeTraceProc { nombre fn} {
        variable _datos
        trace variable ::ZoomPan::_datos($nombre,_time) w $fn
        trace variable ::ZoomPan::_datos($nombre,_habilitado) w $fn
        set _datos($nombre,_trace) $fn
        set ::ZoomPan::_datos($nombre,_time) $::ZoomPan::_datos($nombre,_time)
    }

    proc GetDatos { nombre} {
        variable _datos
        
        if { ![ info exists _datos($nombre,_old)]} {
            WarnWin [_ "Select the %s 'from' view" $nombre]
            return 0
        }
        if { ![ info exists _datos($nombre,_new)]} {
            WarnWin [_ "Select the %s 'to' view" $nombre]
            return 0
        }
        if { ( $_datos($nombre,_time) < 0.0) || ( $_datos($nombre,_time) > 1000)} {
            WarnWin [_ "The Time for the %d Zoom/Pan is too little (<0) or too big (>1000): %s" $nombre $_datos($nombre,_time)]
            return 0
        }

        return [ array get _datos $nombre*]
    }

    proc SetDatos { nombre datos} {
        variable _datos
        
        set seg_w $_datos($nombre,_w)
        set seg_trace $_datos($nombre,_trace)
        array set _datos [ lindex [ lindex $datos 0] 0]
        set _datos($nombre,_w) $seg_w
        set _datos($nombre,_trace) $seg_trace
        if { $_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 0
            Habilitar $nombre
        } else {
            set _datos($nombre,_habilitado) 1
            DesHabilitar $nombre
        }

        # get rid of problematic view settings:
        if { [ info exists _datos($nombre,_old)]} {
            set _datos($nombre,_old) [ get_rid_of_problematic_settings_in_view $_datos($nombre,_old)]
        }
        if { [ info exists _datos($nombre,_new)]} {
            set _datos($nombre,_new) [ get_rid_of_problematic_settings_in_view $_datos($nombre,_new)]
        }
        return 1
    }
}
# end ::ZoomPan


namespace eval ::Rotacion:: {
    variable _datos
    variable _hay_cambios

    namespace export Rotacion

    proc Rotacion { nombre w } {
        variable _datos
        variable _hay_cambios
        
        # globalizamos el nombre
        if { ![ string match "::*" $nombre]} {
            set ns [ uplevel 1 namespace current]
            if { "::" != $ns} {
                append ns "::"
            }
            set nombre "$ns$nombre"
        }
        
        # miramos si ya existe
        if { [ info commands $nombre] != ""} {
            return -code error [_ "command name '%s' already exists." $nombre]
        }

        # guardamos datos
        set _datos($nombre,_w) $w
        set _hay_cambios($nombre) 0
        set _datos($nombre,animando) 0
        set _datos($nombre,stop) 0

        # creamos los metodos
        proc $nombre {que args} "::Rotacion::procesa $nombre \$que \$args"

        return $nombre
    }

    proc procesa { nombre que args} {
        variable _datos
        variable _hay_cambios
        
        switch -exact -- $que {
            create {
                ::Rotacion::Create $nombre
            }
            animar {
                eval ::Rotacion::Animar $nombre {*}$args
            }
            deshabilitar {
                ::Rotacion::DesHabilitar $nombre
            }
            habilitar {
                ::Rotacion::Habilitar $nombre
            }
            borrar {
                ::Rotacion::Borrar $nombre
            }
            gettime {
                if { $::Rotacion::_datos($nombre,_habilitado)} {
                    return $::Rotacion::_datos($nombre,_time)
                } else {
                    return 0
                }
            }
            timetrace {
                ::Rotacion::TimeTraceProc $nombre $args
            }
            quesoy {
                return Rotacion
            }
            comoestoy {
                if { $_datos($nombre,_habilitado)} {
                    return [_ "Enabled"]
                } else {
                    return [_ "Disabled"]
                }
            }
            getdatos {
                return [ ::Rotacion::GetDatos $nombre ]
            }
            setdatos {
                return [ ::Rotacion::SetDatos $nombre $args ]
            }
            haycambios {
                ##WarnWinText "Rotacion [ llength [ lindex $args 0]] -[ lindex $args 0]- /$_hay_cambios($nombre)/"
                if { [ llength [ lindex $args 0]] == 0} {
                    return $_hay_cambios($nombre)
                } else {
                    set _hay_cambios($nombre) [ lindex $args 0]
                }
            }
            widget {
                return $_datos($nombre,_w)
            }
            stop {
                if { $_datos($nombre,animando)} {
                    set _datos($nombre,stop) 1
                }
            }
        }
    }

    #proc implemented twice, one for namespace ::ZoomPan:: and another for ::Rotacion:: !!
    proc get_rid_of_problematic_settings_in_view { view} {
        set tmp {}
        set items_to_skip [ list nowuse drawingtype]
        foreach item $view {
            set key [ string tolower [ lindex $item 0]]
            if { [ lsearch $items_to_skip $key] == -1} {
                lappend tmp $item
            }
        }
        return $tmp
    }

    proc GetGiDPoint { var var_old nombre} {
        variable _hay_cambios

        set old_view [ get_rid_of_problematic_settings_in_view [ GiD_Info view]]
        for { set i 0} { $i < [ llength $old_view]} { incr i} {
            set oldcomp [ lindex $old_view $i]
            set key [ string tolower [ lindex $oldcomp 0]]
            if { "$key" == "c"} {
                set $var_old [ lrange $oldcomp 1 end]
            }
        }
        
        set xyz [ GidUtils::GetCoordinates [_ "Enter rotation center for Rotation (ESC to leave)"]]
        if { $::GidPriv(selcoord,id) == -1} {
            set $var ""
        } elseif { $::GidPriv(selcoord,id) == 0} {
            set $var $xyz
        } else {
            set $var $::GidPriv(selcoord,id)
        }
        set _hay_cambios($nombre) 1
    }

    proc Create { nombre} {
        variable _datos
        variable _hay_cambios

        set w $_datos($nombre,_w)
               
        ttk::frame $w.t      
        ttk::label $w.t.l1 -text [_ "Rotation"]:
        ttk::button $w.t.rc -text [_ "Center"] \
                -command "::Rotacion::GetGiDPoint ::Rotacion::_datos($nombre,_centro) ::Rotacion::_datos($nombre,_centro_anterior) $nombre"              
        if { [info exists ::Rotacion::_datos($nombre,_modo)]} {
            set ::Rotacion::_datos($nombre,_modo) ObjAxes
        }
        TTKComboBox $w.t.cb1 -textvariable ::Rotacion::_datos($nombre,_modo) \
            -values "ObjAxes ScrAxes" -width 5 -state readonly
        ttk::label $w.t.ld -text [_ "Duration"]:
        if { [info exists ::Rotacion::_datos($nombre,_time)]} {
            set ::Rotacion::_datos($nombre,_time) 5
        }
        ttk::entry $w.t.ed -width 3 -textvariable ::Rotacion::_datos($nombre,_time) -justify right
        ttk::label $w.t.ls -text [_ "sec."]

        ttk::frame $w.b      
        ttk::label $w.b.lx -text [_ "X angle"]:
        if { [info exists ::Rotacion::_datos($nombre,_angulo_x)]} {
            set ::Rotacion::_datos($nombre,_angulo_x) 0
        }
        ttk::entry $w.b.ex -width 4 -textvariable ::Rotacion::_datos($nombre,_angulo_x)
        ttk::label $w.b.ly -text [_ "Y angle"]:
        if { [info exists ::Rotacion::_datos($nombre,_angulo_y)]} {
            set ::Rotacion::_datos($nombre,_angulo_y) 0
        }
        ttk::entry $w.b.ey -width 4 -textvariable ::Rotacion::_datos($nombre,_angulo_y)
        ttk::label $w.b.lz -text [_ "Z angle"]:
        if { [info exists ::Rotacion::_datos($nombre,_angulo_z)]} {
            set ::Rotacion::_datos($nombre,_angulo_z) 360
        }
        ttk::entry $w.b.ez -width 4 -textvariable ::Rotacion::_datos($nombre,_angulo_z)

        grid $w.t.l1 $w.t.rc $w.t.cb1 $w.t.ld $w.t.ed $w.t.ls
        grid $w.b.lx $w.b.ex $w.b.ly $w.b.ey $w.b.lz $w.b.ez

        grid $w.t -sticky w
        grid $w.b -sticky e

        set _datos($nombre,_modo) ObjAxes
        set _datos($nombre,_angulo_x) 0
        set _datos($nombre,_angulo_y) 0
        set _datos($nombre,_angulo_z) 360
        set _datos($nombre,_time) 5
        set _datos($nombre,_centro) ""
        set _datos($nombre,_centro_anterior) ""
        set _datos($nombre,_habilitado) 1
        set _datos($nombre,_trace) ""
        set _hay_cambios($nombre) 1

        # activar el menu del 3r boton
        set scr [ bind $w <$::gid_right_button>]
        foreach s "$w.t.l1 $w.t.rc $w.t.cb1 $w.t.ld $w.t.ed $w.t.ls
        $w.b.lx $w.b.ex $w.b.ly $w.b.ey $w.b.lz $w.b.ez" {
            bind $s <$::gid_right_button> $scr
        }

        return $w
    }

    proc Animar { nombre args} {
        variable _datos
        set cmd GiD_Process
        set animate_results 0
        foreach [ list cmd animate_results] $args {}

        if { !$_datos($nombre,_habilitado)} {
            return 1
        }
        if { ( $_datos($nombre,_angulo_x) < -36000.0) || ( $_datos($nombre,_angulo_x) > 36000.0)} {
            WarnWin [_ "The angle for the %s Rotation X is too little (<-36000) or too big (>36000): %s" \
                    $nombre $_datos($nombre,_angulo_x)]
            return 0
        }
        if { ( $_datos($nombre,_angulo_y) < -36000.0) || ( $_datos($nombre,_angulo_y) > 36000.0)} {
            WarnWin [_ "The angle for the %s Rotation Y is too little (<-36000) or too big (>36000): %s" \
                    $nombre $_datos($nombre,_angulo_y)]
            return 0
        }
        if { ( $_datos($nombre,_angulo_z) < -36000.0) || ( $_datos($nombre,_angulo_z) > 36000.0)} {
            WarnWin [_ "The angle for the %s Rotation Z is too little (<-36000) or too big (>36000): %s" \
                    $nombre $_datos($nombre,_angulo_z)]
            return 0
        }
        if { ( $_datos($nombre,_time) < 0.0) || ( $_datos($nombre,_time) > 1000)} {
            WarnWin [_ "The Time for the %s Rotation is too little (<0) or too big (>1000): %s" \
                    $nombre $_datos($nombre,_time)]
            return 0
        }
        
        set num_steps [ expr int( $_datos($nombre,_time) * $::AutoAnimate_FPS)]
        set result_steps [ expr $_datos($nombre,_time) * $::AutoAnimate_FPS]
        if { !$num_steps} { # lo rotamos y ya esta
            if { [ llength $_datos($nombre,_centro)] == 1} {
                $cmd 'Rotate Center Join $_datos($nombre,_centro) escape
            } elseif { [ llength $_datos($nombre,_centro)] == 3} {
                $cmd 'Rotate Center $_datos($nombre,_centro) escape
            }
            set old_redraw [GiD_Set AutomaticRedraw]
            $cmd Mescape Utilities Variables AutomaticRedraw -1 escape escape
            $cmd 'Rotate $_datos($nombre,_modo) x $_datos($nombre,_angulo_x) escape
            $cmd 'Rotate $_datos($nombre,_modo) y $_datos($nombre,_angulo_y) escape
            $cmd 'Rotate $_datos($nombre,_modo) z $_datos($nombre,_angulo_z) escape
            $cmd Mescape Utilities Variables AutomaticRedraw $old_redraw escape escape
            if { $animate_results} {
                ::AutoAnimate::AnimateResultStep
            }
            $cmd 'redraw
            # devolvemos el anterior centro
            if { [ llength $_datos($nombre,_centro_anterior)] == 1} {
                $cmd 'Rotate Center join $_datos($nombre,_centro_anterior) escape
            } elseif { [ llength $_datos($nombre,_centro_anterior)] == 3} {
                $cmd 'Rotate Center $_datos($nombre,_centro_anterior) escape
            }
            return 1
        }
        set es_cero 1
        set max [ expr abs( $_datos($nombre,_angulo_x))]
        if { [ expr abs( $_datos($nombre,_angulo_y))] > $max} {
            set max [ expr abs( $_datos($nombre,_angulo_y))]
        }
        if { [ expr abs( $_datos($nombre,_angulo_z))] > $max} {
            set max [ expr abs( $_datos($nombre,_angulo_z))]
        }
        set epsilon [ expr $max * 1e-6]
        set inc_x [ expr ( $_datos($nombre,_angulo_x)) / $result_steps]
        set inc_y [ expr ( $_datos($nombre,_angulo_y)) / $result_steps]
        set inc_z [ expr ( $_datos($nombre,_angulo_z)) / $result_steps]
        set step_x 0.0
        set step_y 0.0
        set step_z 0.0
        if { $inc_x != 0.0} {
            set es_cero 0
        }
        if { $inc_y != 0.0} {
            set es_cero 0
        }
        if { $inc_z != 0.0} {
            set es_cero 0
        }

        #if { $es_cero} {
        #    WarnWin [_ "No Rotation is done."]
        #    return 0
        #}

        set _datos($nombre,animando) 1
        # # nos aseguramos el primer estado
        # $cmd Mescape View SetView $_old(view) escape
        if { [ llength $_datos($nombre,_centro)] == 1} {
            $cmd 'Rotate Center join $_datos($nombre,_centro) escape
        } elseif { [ llength $_datos($nombre,_centro)] == 3} {
            $cmd 'Rotate Center $_datos($nombre,_centro) escape
        }
        for { set i 0} { $i < $num_steps} { incr i} {
            set old_redraw [GiD_Set AutomaticRedraw]
            $cmd Mescape Utilities Variables AutomaticRedraw -1 escape escape
            $cmd 'Rotate $_datos($nombre,_modo) z [ expr -$step_z] escape
            $cmd 'Rotate $_datos($nombre,_modo) y [ expr -$step_y] escape
            $cmd 'Rotate $_datos($nombre,_modo) x [ expr -$step_x] escape
            set step_x [ expr $step_x + $inc_x]
            set step_y [ expr $step_y + $inc_y]
            set step_z [ expr $step_z + $inc_z]
            $cmd 'Rotate $_datos($nombre,_modo) x $step_x escape
            $cmd 'Rotate $_datos($nombre,_modo) y $step_y escape
            $cmd 'Rotate $_datos($nombre,_modo) z $step_z escape
            # $cmd 'Rotate $_datos($nombre,_modo) x $inc_x escape
            # $cmd 'Rotate $_datos($nombre,_modo) y $inc_y escape
            # $cmd 'Rotate $_datos($nombre,_modo) z $inc_z escape
            $cmd Mescape Utilities Variables AutomaticRedraw $old_redraw escape escape
            if { $animate_results} {
                ::AutoAnimate::AnimateResultStep
            }
            $cmd 'redraw
            after [ expr int( 0.5 + $::AutoAnimate_Delay)]
            update
            update idletasks
            ##WarnWinText "$i $num_steps ( $step_x, $step_y, $step_z)"
            if { $_datos($nombre,stop)} {
                set _datos($nombre,animando) 0
                set _datos($nombre,stop) 0
                return 0
                #break
            }
        }

        set resto_x [ expr $_datos($nombre,_angulo_x) - $step_x]
        set resto_y [ expr $_datos($nombre,_angulo_y) - $step_y]
        set resto_z [ expr $_datos($nombre,_angulo_z) - $step_z]
        if { [ expr abs( $resto_x)] < $epsilon} {
            set resto_x 0.0
        }
        if { [ expr abs( $resto_y)] < $epsilon} {
            set resto_y 0.0
        }
        if { [ expr abs( $resto_z)] < $epsilon} {
            set resto_z 0.0
        }
        if { ( $resto_x != 0.0) || ( $resto_y != 0.0) || ( $resto_z != 0.0)} {
            set old_redraw [GiD_Set AutomaticRedraw]
            $cmd Mescape Utilities Variables AutomaticRedraw -1 escape escape
            $cmd 'rotate $_datos($nombre,_modo) z [ expr -$step_z] escape
            $cmd 'rotate $_datos($nombre,_modo) y [ expr -$step_y] escape
            $cmd 'rotate $_datos($nombre,_modo) x [ expr -$step_x] escape
            $cmd 'rotate $_datos($nombre,_modo) x $_datos($nombre,_angulo_x) escape
            $cmd 'rotate $_datos($nombre,_modo) y $_datos($nombre,_angulo_y) escape
            $cmd 'rotate $_datos($nombre,_modo) z $_datos($nombre,_angulo_z) escape
            $cmd Mescape Utilities Variables  AutomaticRedraw $old_redraw escape escape
            if { $animate_results} {
                ::AutoAnimate::AnimateResultStep
            }
            $cmd 'redraw
            ##WarnWinText "resto ( $_datos($nombre,_angulo_x), $_datos($nombre,_angulo_y), $_datos($nombre,_angulo_z))"
        }
        
        # devolvemos el anterior centro
        if { [ llength $_datos($nombre,_centro_anterior)] == 1} {
            $cmd 'Rotate Center join $_datos($nombre,_centro_anterior) escape
        } elseif { [ llength $_datos($nombre,_centro_anterior)] == 3} {
            $cmd 'Rotate Center $_datos($nombre,_centro_anterior) escape
        }
        set _datos($nombre,animando) 0
        set _datos($nombre,stop) 0

        return 1
    }

    proc Habilitar { nombre} {
        variable _datos

        if { !$_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 1

            set w $_datos($nombre,_w)
            $w.t.l1 state !disabled
            $w.t.rc state !disabled
            $w.t.cb1 state !disabled
            $w.t.ld state !disabled
            $w.t.ed state !disabled
            $w.t.ls state !disabled
            $w.b.lx state !disabled
            $w.b.ex state !disabled
            $w.b.ly state !disabled
            $w.b.ey state !disabled
            $w.b.lz state !disabled
            $w.b.ez state !disabled
        }
    }

    proc DesHabilitar { nombre} {
        variable _datos

        if { $_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 0

            set w $_datos($nombre,_w)
            $w.t.l1 state disabled
            $w.t.rc state disabled
            $w.t.cb1 state disabled
            $w.t.ld state disabled
            $w.t.ed state disabled
            $w.t.ls state disabled
            $w.b.lx state disabled
            $w.b.ex state disabled
            $w.b.ly state disabled
            $w.b.ey state disabled
            $w.b.lz state disabled
            $w.b.ez state disabled
        }
    }

    proc Borrar { nombre} {
        variable _datos

        ::AutoAnimate::DebugWarnWinText "   Rt Borrar $nombre"
        destroy $_datos($nombre,_w)
        if { [ info exists _datos($nombre,_trace)] && ( "$_datos($nombre,_trace)" != "")} {
            trace vdelete ::Rotacion::_datos($nombre,_time) w $_datos($nombre,_trace)
            trace vdelete ::Rotacion::_datos($nombre,_habilitado) w $_datos($nombre,_trace)
        }
        foreach idx "_w _time _habilitado _trace _old _new" {
            if { [ info exists _datos($nombre,$idx)]} {
                unset _datos($nombre,$idx)
            }
        }
        # unset _datos($nombre,_w)
        # unset _datos($nombre,_time)
        # unset _datos($nombre,_habilitado)
        # unset _datos($nombre,_trace)
        # if { [ info exists _datos($nombre,_old)]} { unset _datos($nombre,_old)}
        # if { [ info exists _datos($nombre,_new)]} { unset _datos($nombre,_new)}
        if { [ info procs $nombre] != ""} {
            rename $nombre ""
        }
    }

    proc TimeTraceProc { nombre fn} {
        variable _datos
        trace variable ::Rotacion::_datos($nombre,_time) w $fn
        trace variable ::Rotacion::_datos($nombre,_habilitado) w $fn
        set _datos($nombre,_trace) $fn
        set ::Rotacion::_datos($nombre,_time) $::Rotacion::_datos($nombre,_time)
    }

    proc GetDatos { nombre} {
        variable _datos

        if { ( $_datos($nombre,_angulo_x) < -36000.0) || ( $_datos($nombre,_angulo_x) > 36000.0)} {
            WarnWin [_ "The angle for the %s Rotation X is too little (<-36000) or too big (>36000): %s" \
                    $nombre $_datos($nombre,_angulo_x)]
            return 0
        }
        if { ( $_datos($nombre,_angulo_y) < -36000.0) || ( $_datos($nombre,_angulo_y) > 36000.0)} {
            WarnWin [_ "The angle for the %s Rotation Y is too little (<-36000) or too big (>36000): %s" \
                    $nombre $_datos($nombre,_angulo_y)]
            return 0
        }
        if { ( $_datos($nombre,_angulo_z) < -36000.0) || ( $_datos($nombre,_angulo_z) > 36000.0)} {
            WarnWin [_ "The angle for the %s Rotation Z is too little (<-36000) or too big (>36000): %s" \
                    $nombre $_datos($nombre,_angulo_z)]
            return 0
        }
        if { ( $_datos($nombre,_time) < 0.0) || ( $_datos($nombre,_time) > 1000)} {
            WarnWin [_ "The Time for the %s Rotation is too little (<0) or too big (>1000): %s" \
                    $nombre $_datos($nombre,_time)]
            return 0
        }
        
        return [ array get _datos $nombre*]
    }

    proc SetDatos { nombre datos} {
        variable _datos

        set seg_w $_datos($nombre,_w)
        set seg_trace $_datos($nombre,_trace)
        array set _datos [ lindex [ lindex $datos 0] 0]
        set _datos($nombre,_w) $seg_w
        set _datos($nombre,_trace) $seg_trace
        # upgrade old commands obj --> objaxes, scr --> scraxes
        if { [ string tolower $_datos($nombre,_modo)] == "obj"} {
            set _datos($nombre,_modo) ObjAxes
        }
        if { [ string tolower $_datos($nombre,_modo)] == "scr"} {
            set _datos($nombre,_modo) ScrAxes
        }
        if { $_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 0
            Habilitar $nombre
        } else {
            set _datos($nombre,_habilitado) 1
            DesHabilitar $nombre
        }
        return 1
    }
}
# end ::Rotacion

namespace eval ::RenderState:: {
    variable _datos
    variable _hay_cambios

    namespace export RenderState

    proc RenderState { nombre w } {
        variable _datos
        variable _hay_cambios
        
        # globalizamos el nombre
        if { ![ string match "::*" $nombre]} {
            set ns [ uplevel 1 namespace current]
            if { "::" != $ns} {
                append ns "::"
            }
            set nombre "$ns$nombre"
        }
        
        # miramos si ya existe
        if { [ info commands $nombre] != ""} {
            return -code error [_ "command name '%s' already exists." $nombre]
        }

        # guardamos datos
        set _datos($nombre,_w) $w
        set _hay_cambios($nombre) 0
        set _datos($nombre,animando) 0
        set _datos($nombre,stop) 0

        # creamos los metodos
        proc $nombre {que args} "::RenderState::procesa $nombre \$que \$args"

        return $nombre
    }

    proc procesa { nombre que args} {
        variable _datos
        variable _hay_cambios
        
        switch -exact -- $que {
            create {
                ::RenderState::Create $nombre
            }
            animar {
                eval ::RenderState::Animar $nombre {*}$args
            }
            deshabilitar {
                ::RenderState::DesHabilitar $nombre
            }
            habilitar {
                ::RenderState::Habilitar $nombre
            }
            borrar {
                ::RenderState::Borrar $nombre
            }
            gettime {
                if { $::RenderState::_datos($nombre,_habilitado)} {
                    return $::RenderState::_datos($nombre,_time)
                } else {
                    return 0
                }
            }
            timetrace {
                ::RenderState::TimeTraceProc $nombre $args
            }
            quesoy {
                return RenderState
            }
            comoestoy {
                if { $_datos($nombre,_habilitado)} {
                    return [_ "Enabled"]
                } else {
                    return [_ "Disabled"]
                }
            }
            getdatos {
                return [ ::RenderState::GetDatos $nombre ]
            }
            setdatos {
                return [ ::RenderState::SetDatos $nombre $args ]
            }
            haycambios {
                ##WarnWinText "RenderState [ llength [ lindex $args 0]] -[ lindex $args 0]- /$_hay_cambios($nombre)/"
                if { [ llength [ lindex $args 0]] == 0} {
                    return $_hay_cambios($nombre)
                } else {
                    set _hay_cambios($nombre) [ lindex $args 0]
                }
            }
            widget {
                return $_datos($nombre,_w)
            }
            stop {
                if { $_datos($nombre,animando)} {
                    set _datos($nombre,stop) 1
                }
            }
        }
    }

    proc GetRenderMode { } {
        set que_render Normal
        set whatuse [GiD_Info Project ViewMode]
        switch $whatuse {
            GEOMETRYUSE - MESHUSE {
                set que_render [GiD_Info Project RenderMode]
                switch $que_render {
                    normal {
                        set que_render Normal
                    }
                    polygons {
                        set que_render Flat
                    }
                    render {
                        set que_render Smooth
                    }
                    custom {
                        set que_render Normal
                    }
                }
            }
            POSTUSE - GRAPHUSE {
                set que_render [GiD_Info postprocess get cur_display_render]
                switch $que_render {
                    normal {
                        set que_render Normal
                    }
                    Flat {
                        set que_render Flat
                    }
                    Smooth {
                        set que_render Smooth
                    }
                }
            }
        }
        return $que_render
    }

    proc Create { nombre} {
        variable _datos
        variable _hay_cambios

        set w $_datos($nombre,_w)        
        ttk::frame $w.t
        ttk::label $w.t.l1 -text [_ "Render state"]:
        if { [info exists ::RenderState::_datos($nombre,_modo)]} {
            set ::RenderState::_datos($nombre,_modo) Normal
        }
        TTKComboBox $w.t.cb1 -textvariable ::RenderState::_datos($nombre,_modo) \
            -values "Normal Flat Smooth" -width 7 -state readonly

        grid $w.t.l1 $w.t.cb1
        grid $w.t -sticky w

        set _datos($nombre,_modo) [ GetRenderMode]
        set _datos($nombre,_time) 0
        set _datos($nombre,_habilitado) 1
        set _datos($nombre,_trace) ""
        set _hay_cambios($nombre) 1

        # activar el menu del 3r boton
        set scr [ bind $w <$::gid_right_button>]
        foreach s "$w.t.l1 $w.t.cb1" {
            bind $s <$::gid_right_button> $scr
        }
        return $w
    }

    proc Animar { nombre args} {
        variable _datos
        set cmd GiD_Process
        set animate_results 0
        foreach [ list cmd animate_results] $args {}

        if { !$_datos($nombre,_habilitado)} {
            return 1
        }

        set _datos($nombre,animando) 1

        $cmd 'Render $_datos($nombre,_modo)
        if { $animate_results} {
            ::AutoAnimate::AnimateResultStep
        }

        set _datos($nombre,animando) 0
        set _datos($nombre,stop) 0

        return 1
    }

    proc Habilitar { nombre} {
        variable _datos

        if { !$_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 1

            set w $_datos($nombre,_w)
            $w.t.l1 state !disabled
            $w.t.cb1 state !disabled
        }
    }

    proc DesHabilitar { nombre} {
        variable _datos

        if { $_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 0

            set w $_datos($nombre,_w)
            $w.t.l1 state disabled
            $w.t.cb1 state disabled
        }
    }

    proc Borrar { nombre} {
        variable _datos

        ::AutoAnimate::DebugWarnWinText "   RS Borrar $nombre"
        destroy $_datos($nombre,_w)
        if { [ info exists _datos($nombre,_trace)] && ( "$_datos($nombre,_trace)" != "")} {
            trace vdelete ::RenderState::_datos($nombre,_time) w $_datos($nombre,_trace)
            trace vdelete ::RenderState::_datos($nombre,_habilitado) w $_datos($nombre,_trace)
        }
        foreach idx "_w _time _habilitado _trace _old _new" {
            if { [ info exists _datos($nombre,$idx)]} {
                unset _datos($nombre,$idx)
            }
        }
        # unset _datos($nombre,_w)
        # unset _datos($nombre,_time)
        # unset _datos($nombre,_habilitado)
        # unset _datos($nombre,_trace)
        # if { [ info exists _datos($nombre,_old)]} { unset _datos($nombre,_old)}
        # if { [ info exists _datos($nombre,_new)]} { unset _datos($nombre,_new)}
        if { [ info procs $nombre] != ""} {
            rename $nombre ""
        }
    }

    proc TimeTraceProc { nombre fn} {
        variable _datos
        trace variable ::RenderState::_datos($nombre,_time) w $fn
        trace variable ::RenderState::_datos($nombre,_habilitado) w $fn
        set _datos($nombre,_trace) $fn
        set ::RenderState::_datos($nombre,_time) $::RenderState::_datos($nombre,_time)
    }

    proc GetDatos { nombre} {
        variable _datos
        
        return [ array get _datos $nombre*]
    }

    proc SetDatos { nombre datos} {
        variable _datos

        set seg_w $_datos($nombre,_w)
        set seg_trace $_datos($nombre,_trace)
        array set _datos [ lindex [ lindex $datos 0] 0]
        set _datos($nombre,_w) $seg_w
        set _datos($nombre,_trace) $seg_trace
        if { $_datos($nombre,_habilitado)} {
            set _datos($nombre,_habilitado) 0
            Habilitar $nombre
        } else {
            set _datos($nombre,_habilitado) 1
            DesHabilitar $nombre
        }
        return 1
    }
}
# end ::RenderState

