
######################################################################################################
#        Este fichero implementa el codigo Tcl que muestra la informacion de las unidades
#        de trabajo para un modelo.

namespace eval ModUnitWin {
    namespace export Clear Init Show IsOpen Raise InitInfoUnits

    variable win             ""
    variable cb_sys          ""
    variable f_udef          ""
    variable Systems         ""
    variable IdxSys          -1
    variable _IdxSys         -1
    variable CurSysName      ""
    variable LengthInfo      ""
    variable _LengthInfo     ""
    variable bUserDef        0
    variable _bUserDef       0
    variable UserDefSysList  ""
    variable _UserDefSysList
    variable UserDefSysArray
    variable UniSysArray
    variable SystemsList     ""
    variable EnableUserDef   1
}


proc ModUnitWin::Clear {} {
    variable win        ""
    variable cb_sys     ""
    variable f_udef     ""
    variable Systems    ""
    variable IdxSys     -1
    variable CurSysName ""
    variable LengthInfo ""
    variable bUserDef   0
    variable UserDefSysList ""
    variable UserDefSysArray
    variable SystemsList ""

    unset -nocomplain UserDefSysArray
    unset -nocomplain UniSysArray
}

proc ModUnitWin::BuildSysArray {} {
    variable UserDefSysList
    variable UserDefSysArray
    variable UniSysArray
    variable bUserDef
    variable CurSysName
    variable SystemsList
    variable IdxSys

    if $bUserDef {
        upvar \#0 ::ModUnitWin::UserDefSysList  theList
        upvar \#0 ::ModUnitWin::UserDefSysArray theArray
    } else {
        set CurSysName [lindex $SystemsList $IdxSys]
        set theList [Units::GetSystem $CurSysName]
        upvar \#0 ::ModUnitWin::UniSysArray theArray
    }

    unset -nocomplain theArray    

    if { $bUserDef && ![string length $CurSysName] } {
        set ApplyFilter 0
    } else {
        set ApplyFilter 1
    }

    set MagsFilter [GiD_Info unitssystems magused]

    foreach u [GiD_Info unitssystems $CurSysName prj] {
        if { [lsearch $MagsFilter [set mag [lindex $u 0]]] == -1 } {
            lappend MagsFilter $mag
        }
    }

    set i 0
    foreach u $theList {
        set mag [lindex $u 0]
        if $ApplyFilter {
            if { $mag == "LENGTH" || [lsearch $MagsFilter $mag] != -1 } {
                set theArray($i) $u
                incr i
            }
        } else {
            set theArray($i) $u
            incr i
        }
    }
}

proc ModUnitWin::InitInfoUnits {} {
    variable LengthInfo
    variable _LengthInfo
    variable bUserDef
    variable _bUserDef
    variable UserDefSysList
    variable _UserDefSysList
    variable UserDefSysArray
    variable SystemsList
    variable CurSysName
    variable IdxSys
    variable _IdxSys
    variable EnableUserDef

    unset -nocomplain UserDefSysArray
    
    set LengthInfo [GiD_Info unitssystems modunit]
    set UserDefSysList [GiD_Info unitssystems usersys]
    set SystemsList [Units::GetUnitsSystems]
    set CurSysName [GiD_Info unitssystems prbsys]
    set EnableUserDef [GiD_Info unitssystems udstate]

    if [llength $UserDefSysList] {
        set bUserDef 1
        BuildSysArray
    }

    if { $CurSysName == "" } {
        set bUserDef 1
        set IdxSys 0
        BuildSysArray
    } else {
        set bUserDef 0
        set IdxSys [lsearch $SystemsList $CurSysName]
    }

    set _UserDefSysList $UserDefSysList
    set _LengthInfo $LengthInfo
    set _bUserDef   $bUserDef
    set _IdxSys     $IdxSys

    if { ![llength $LengthInfo] } {
        if ![llength $SystemsList] {
            return 0
        }
        set IdxSys 0
        set bUserDef 0
        set sname [lindex $SystemsList 0]
        set CurSysName $sname
        set lm [::Units::GetSystem $sname]        
        set il [::Units::FindMagnitud $lm LENGTH]
        set LengthInfo [lindex $lm $il]
    }

    return 1
}

proc ModUnitWin::IsOpen {} {
    variable win

    return [winfo exists $win]
}

proc ModUnitWin::Raise {} {
    variable win

    raise $win
}

proc ModUnitWin::Init { w } {
    if [IsOpen] Raise

    variable win $w

    return [InitInfoUnits]
}

proc ModUnitWin::Show {} {
    variable win
    variable cb_sys
    variable f_udef
    variable LengthInfo
    variable SystemsList
    variable IdxSys
    variable EnableUserDef

    if [IsOpen] Raise

    GidUtils::WaitState .gid
    ::GiDTeXSymbols::ForceLoadFont
    GidUtils::EndWaitState .gid

    if { [info procs ::InitWindow] == "" } {
        if { [winfo exists $win] } {
            destroy $win
        }
        toplevel $win
        set w $win
        if { $::tcl_platform(platform) == "windows" } {            
            wm attributes $w -toolwindow 1
        }
    } else {
        InitWindow2 $win -title [_ "Problem units"] \
            -geometryvariable PreUnitsWindowGeom \
            -ontop
        if { ![winfo exists $win] } return ;# windows disabled || UseMoreWindows == 0
    }

    set frame1 [ttk::frame $win.frame1]

    ttk::label $frame1.l_munit -text [_ "Model Unit: "]
    set mu [MenuUnits::CreateInstance]
    $mu\::Create $frame1.b_munit [lindex $LengthInfo 2] LENGTH [lindex $LengthInfo 1] \
        ::ModUnitWin::LengthInfo

    grid $frame1.l_munit $frame1.b_munit -sticky "w"   

    ttk::labelframe $win.f_system -text [_ "Units System"]
    
    set f $win.f_system
    if { $EnableUserDef } {
        if { ![info exists ::ModUnitWin::bUserDef] } { set ::ModUnitWin::bUserDef 0 }
        ttk::checkbutton $f.chk_userdef -text [_ "User defined"] -variable ::ModUnitWin::bUserDef \
            -command [namespace code CheckUserDef]
    }
    set frame2 [ttk::frame $f.frame2]
    ttk::label $frame2.l_usys  -text [_ "Base System: "]

    set cb_sys $frame2.c_usys
    ComboBox $cb_sys -editable 0 -values $::ModUnitWin::SystemsList -modifycmd [namespace code OnChangeSystem] -width 30
    #TTKComboBox $cb_sys -labels $::ModUnitWin::SystemsList -values $::ModUnitWin::SystemsList -modifycmd [namespace code OnChangeSystem] -width 30 -state readonly] 
    #better avoid use of BWidget ComboBox and use TTKComboBox,but other changes must be done, like $cb_sys setvalue @$IdxSys,...

    set f_udef [ttk::frame $f.f_system -borderwidth 1  -style sunken.TFrame]   

    grid $frame2.l_usys $cb_sys -sticky "w"
    $cb_sys setvalue @$IdxSys

    ttk::frame $win.fbut -style BottomFrame.TFrame
    ttk::button $win.fbut.b_accept -text [_ "Accept"] -command [namespace code OnAccept] -style BottomFrame.TButton
    ttk::button $win.fbut.b_cancel -text [_ "Cancel"] -command [namespace code OnCancel] -style BottomFrame.TButton
    
    grid $frame1 -sticky "new"   
    if $EnableUserDef {
        grid $f.chk_userdef -sticky "w"        
    }  
    grid $frame2 -sticky "ew"    
    grid $f_udef -sticky "nswe" -pady 2
    grid rowconfigure $f $f_udef -weight 1
    grid columnconfigure $f 0 -weight 1

    grid $win.f_system -sticky "snwe"

    grid $win.fbut.b_accept $win.fbut.b_cancel -padx 5 -pady 5   
    grid $win.fbut -sticky snew
    grid anchor $win.fbut center

    grid rowconfigure $win 1 -weight 1
    grid columnconfigure $win 0 -weight 1

    CheckUserDef
}

proc ModUnitWin::FillFrameSystem {} {
    variable f_udef
    variable UserDefSysArray
    variable UniSysArray
    variable bUserDef

    if $bUserDef {
        upvar \#0 ::ModUnitWin::UserDefSysArray theArray
    } else {
        upvar \#0 ::ModUnitWin::UniSysArray theArray
    }

    foreach i [winfo children $f_udef] {
        grid forget $i
        destroy $i
    }
    set cols 2
    set ccol 0
    set crow 0

    grid rowconfigure $f_udef 0 -weight 0
    foreach i [array names theArray] {
        set uinfo $theArray($i)
        set mag [lindex $uinfo 0]
      if { [lsearch $::Units::MagHidden $mag] != -1 } continue
        set idx [lindex $uinfo 1]
        set tab [lindex $uinfo 2]
        set l [label $f_udef.l_mag$i -text $mag:]
        set b $f_udef.b_mag$i
        if $bUserDef {
            set mu [MenuUnits::CreateInstance]
            $mu\::Create $b $tab $mag $idx ::ModUnitWin::UserDefSysArray($i)
        } else {
            canvas $b
            set lunit [::Units::GetUnit $uinfo]
            set cgeo [GidUnit::DrawUnit [lindex $lunit 3] [lindex $lunit 4] black $b]
            $b configure -width [lindex $cgeo 0] -height [lindex $cgeo 1]
        }
        grid config $l -row $crow -column [expr $ccol*2]   -sticky "e"
        grid config $b -row $crow -column [expr $ccol*2+1] -sticky "w"

        incr ccol
        if { $ccol == 2 } {
            set ccol 0
            incr crow
            grid rowconfigure $f_udef $crow -weight 0
        }
    }
    incr crow
    grid rowconfigure    $f_udef $crow -weight 1
    grid columnconfigure $f_udef 4     -weight 1
    grid columnconfigure $f_udef  0     -pad    4
    grid columnconfigure $f_udef  2     -pad    4
}

proc ModUnitWin::CheckUserDef {} {
    variable IdxSys
    variable bUserDef
    variable UserDefSysList
    variable UserDefSysArray
    variable SystemsList
    variable f_udef
    variable cb_sys

    if { $bUserDef } {

        if { ![llength $UserDefSysList] } {
            if { $IdxSys != -1 } {
                set UserDefSysList [::Units::GetSystem [lindex $SystemsList $IdxSys]]
                BuildSysArray
            } else {
                set bUserDef 1
                return
            }
        }
        #FillFrameSystem
        if { $IdxSys != -1 } {
            $cb_sys configure -state disabled
        }
    } else {
        #grid remove $f_udef
        set UserDefSysList {}

        unset -nocomplain UserDefSysArray

        if ![info exists UniSysArray] {
            BuildSysArray
        }
        $cb_sys configure -state normal
    }
    FillFrameSystem
}

proc ModUnitWin::OnChangeSystem {} {
    variable f_udef
    variable IdxSys
    variable cb_sys
    variable SystemsList

    set newidx [$cb_sys getvalue]
    if { $newidx == -1 || $newidx == $IdxSys } {
        return
    }
    set IdxSys $newidx
    BuildSysArray
    FillFrameSystem
}

proc ModUnitWin::BuildUserDefSystem {} {
    variable UserDefSysArray
    variable UserDefSysList {}

    foreach i [array names UserDefSysArray] {
        lappend UserDefSysList $UserDefSysArray($i)
    }
}

proc DumpUserDef {} {
    WarnWin $::ModUnitWin::UserDefSysList
}

proc ModUnitWin::GetSysName {} {
    variable bUserDef
    variable SystemsList
    variable IdxSys

    if { !$bUserDef && $IdxSys != -1 } {
        return [lindex $SystemsList $IdxSys]
    }
    return ""
}

proc ModUnitWin::HasChanged {} {
    variable LengthInfo
    variable _LengthInfo
    variable bUserDef
    variable _bUserDef
    variable UserDefSysList
    variable _UserDefSysList
    variable IdxSys
    variable _IdxSys
    variable CurSysName
    variable SystemsList

    BuildUserDefSystem

    if { $IdxSys != -1 } {
        set CurSysName [lindex $SystemsList $IdxSys]
    }

    if { $bUserDef != $_bUserDef } {
        return 1
    }

    if { $LengthInfo != $_LengthInfo } {
        return 1
    }

    if $bUserDef {
        
        if { $_UserDefSysList != $UserDefSysList } {
            return 1
        }
    } elseif { $IdxSys != $_IdxSys } {
        return 1
    }

    return 0
 }

proc ModUnitWin::OnAccept {} {
    variable win

    if { [ModUnitWin::HasChanged] } {
        updmdlunits
    }
    destroy $win
}

proc ModUnitWin::OnCancel {} {
    variable win

    destroy $win
}
