#        Este fichero implementa el codigo Tcl de un control unidad
#        utilizado en GID. Muestra un menu de unidades usando un menucanvas para dibujarlas
#
#
# Copyright (c) 2000 CIMNE
#



namespace eval MenuUnits {
    namespace export CreateInstance

    variable LastInstance -1
}

#proc separated to be used also in 'GiD_Units edit model_unit_length mm' with exactly the same list as the units menu
#MagTable and IdxUnit doesn't matter for GiD_Units, and also the retured IdxUnit value
proc MenuUnits::GetListsUnitsDataFromMenu { MagName {MagTable 0} {IdxUnit -1}} {     
    set magnitudes_table_index 1
    set UnitsList [list]
    set UInfoList [list]
    set local_idx 0
    foreach unitinfo [GiD_Info magnitudes $magnitudes_table_index $MagName units] {
        if { ![Units::IsUnitDisallowed $unitinfo] } {
            lappend UnitsList $unitinfo
            lappend UInfoList [list $MagName $local_idx $magnitudes_table_index]
            incr local_idx
        }
    }
    if { $MagTable } {
        set IdxNeedUpdate 0
        set global_idx 0
    } else {
        set IdxNeedUpdate 1
        set global_idx [expr [llength $UnitsList]-1]               
    }
    set magnitudes_table_index 0
    set local_idx 0
    foreach unitinfo [GiD_Info magnitudes $magnitudes_table_index $MagName units] {
        if { ![Units::IsUnitDisallowed $unitinfo] } {
            set Numerator [lindex $unitinfo 1]
            set Denominator [lindex $unitinfo 2]
            if { [FindUnitInList $Numerator $Denominator $UnitsList] == {} } {
                lappend UnitsList $unitinfo            
                lappend UInfoList [list $MagName $local_idx $magnitudes_table_index]
                incr global_idx
            }
            if { $IdxNeedUpdate && $local_idx == $IdxUnit } {
                set IdxUnit $global_idx
                set IdxNeedUpdate 0
            }
            incr local_idx
        }
    }
    return [list $UnitsList $UInfoList $IdxUnit]
}

#extract only the last item of the sublist, that is the unit name
proc MenuUnits::GetListUnits { UnitsList } {
    set units [list]
    foreach item $UnitsList { 
        lappend units [lindex $item 5]
    }  
    return $units
}

proc MenuUnits::CreateInstance {} {
    variable LastInstance

    incr LastInstance

    set _MenuUnits ::MenuUnits$LastInstance
    namespace eval $_MenuUnits {
        namespace export Create GetStrUnit
        
        variable  VarInfo      ""
        variable  UInfoList    ""
        variable  MagTable     ""
        variable  MagName      ""
        variable  UnitsList    ""
        variable  IdxUnit      -1
        variable  MCanvas      ""
        variable  MaxWidth     0
    }

    proc $_MenuUnits\::InitUnitsList {} {
        variable UnitsList
        variable UInfoList
        variable MagTable
        variable MagName
        variable IdxUnit        
        #proc separated to be used also in 'GiD_Units edit model_unit_length mm' with exactly the same list as the units menu
        lassign [MenuUnits::GetListsUnitsDataFromMenu $MagName $MagTable $IdxUnit] UnitsList UInfoList IdxUnit        
    }

    proc $_MenuUnits\::Create { w _table _mag _idx _varinfo } {
        variable VarInfo      $_varinfo
        variable MagTable     $_table
        variable MagName      $_mag
        variable IdxUnit      $_idx
        variable MCanvas

        InitUnitsList
        package require gid_menu_canvas
        set MCanvas [MenuCanvas::CreateInstance]
        $MCanvas\::Create $w [namespace code OnChangeUnit] [namespace code FillMenuUnit] [namespace code PopupEntry]
        InitMenu

        bind $w <Destroy> +[namespace code "Destroy %W"]
    }

    proc $_MenuUnits\::Destroy { W } {
        
        #incr MenuUnits::LastInstance -1
        namespace delete [namespace current]
    }

    proc $_MenuUnits\::GetStrUnit {} {
        variable MagName
        variable UnitsList
        variable IdxUnit

        return [lindex [lindex $UnitsList $IdxUnit] end]
    }

    proc $_MenuUnits\::InitMenu {} {
        variable UnitsList
        variable IdxUnit
        variable MCanvas

        # button size calculation to avoid a selection jump
        # una opcion de mayor geometria
        set xmax 0
        set ymax 0
        set c [canvas .__tmpcanvas__ -width 0 -height 0]
        foreach ui $UnitsList {
            set cgeo [GidUnit::DrawUnit [lindex $ui 3] [lindex $ui 4] black $c]
            foreach {x y} $cgeo {}
            if { $x > $xmax } {
                set xmax $x
            }
            if { $y > $ymax } {
                set ymax $y
            }
        }
        destroy $c

        set Button [$MCanvas\::GetButton]
        set unitinfo [lindex $UnitsList $IdxUnit]
        set cgeo [GidUnit::DrawUnit [lindex $unitinfo 3] [lindex $unitinfo 4] black $Button]
#         $Button configure -width [lindex $cgeo 0] -height [lindex $cgeo 1]
         $Button configure -width $xmax -height $ymax
    }

    proc $_MenuUnits\::OnChangeUnit { menu idx } {
        variable UInfoList
        variable UnitsList
        variable IdxUnit
        variable VarInfo

        if { $idx == $IdxUnit } {
            return
        }
        set IdxUnit $idx
        set ucambio [lindex $UnitsList $idx]
        set Button [$menu\::GetButton]
        $Button delete all
        set cgeo [GidUnit::DrawUnit [lindex $ucambio 3] [lindex $ucambio 4] black $Button]
        #$Button configure -width [lindex $cgeo 0] -height [lindex $cgeo 1]

        upvar \#0 $VarInfo var
        set var [lindex $UInfoList $IdxUnit]
    }

    proc $_MenuUnits\::FillMenuUnit { bmenu } {
        variable MagName
        variable UnitsList
        variable IdxUnit

        set i 0
        foreach unitinfo $UnitsList {
            if { ![Units::IsUnitDisallowed $unitinfo] } {      
                set numerator [lindex $unitinfo 3]
                set denominator [lindex $unitinfo 4]      
                if { $i == $IdxUnit } {
                    set color red
                } else {
                    set color black
                }
                set c [$bmenu\::AddEntry $numerator $denominator $color]
                lassign [GidUnit::DrawUnit $numerator $denominator $color $c] xmax ymax
                $bmenu\::SetSelWithIfSmaller $xmax
                $c configure -height $ymax
            }
            incr i
        }
    }

    proc $_MenuUnits\::PopupEntry { c i } {
        variable IdxUnit

        if { $i == $IdxUnit } {
            $c itemconfigure todo -fill red
        } else {
            $c itemconfigure todo -fill black
        }
    }

    return $_MenuUnits
}
