
proc test_Undo { } {
    set fail 0
    
    GiD_Process Mescape Files Read [file join $::GIDDEFAULT Examples motor.gid] escape
    set num_volumes_before [GiD_Info Geometry NumVolumes]
    Undo::DoUndoN 1
    if { [GiD_Info Geometry NumVolumes] != $num_volumes_before } {
        incr fail
    }

    DoFilesNew
    GiD_Process Mescape Files Read [file join $::GIDDEFAULT Examples motor.gid] escape
    set num_volumes_before [GiD_Info Geometry NumVolumes]
    GiD_Process MEscape Geometry Delete Volumes LowerEntities 2 escape
    Undo::DoUndoN 1
    if { [GiD_Info Geometry NumVolumes] != $num_volumes_before } {
        incr fail
    }

    DoFilesNew
    GiD_Process Mescape Geometry Create Line -7.77935,2.56011,0 -3.73409,3.55021,0 escape
    set model_name [gid_cross_platform::get_unused_tmp_filename test_undo .gid]
    GiD_Process Mescape Files Save $model_name escape
    GiD_Process Mescape Geometry Create Arc -6.02546,-0.29703,0 -4.35644,0.919378,0 -0.565771,0.947666,0 escape
    Undo::DoUndoN 1
    Undo::DoRedoN 1
    Undo::DoUndoN 1
    Undo::DoUndoN 1
    file delete -force $model_name
    if { [GiD_Info Geometry NumLines] != 0 } {
        incr fail
    }

    return $fail
}
