
proc test_GiD_MeshPre { } {
    set fail 0
    #test create a mesh with all (36) nodes and 4 hexahedra
    set node_ids {1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36}
    set node_coordinates {0.0 0.0 1100.0 100.0 0.0 1100.0 100.0 100.0 1100.0 0.0 100.0 1100.0 0.0 0.0 1150.0 100.0 0.0 1150.0 100.0 100.0 1150.0 0.0 100.0 1150.0 200.0 0.0 1100.0 200.0 100.0 1100.0 200.0 0.0 1150.0 200.0 100.0 1150.0 100.0 200.0 1100.0 0.0 200.0 1100.0 100.0 200.0 1150.0 0.0 200.0 1150.0 200.0 200.0 1100.0 200.0 200.0 1150.0 0.0 0.0 1200.0 100.0 0.0 1200.0 100.0 100.0 1200.0 0.0 100.0 1200.0 200.0 0.0 1200.0 200.0 100.0 1200.0 100.0 200.0 1200.0 0.0 200.0 1200.0 200.0 200.0 1200.0 0.0 0.0 1250.0 100.0 0.0 1250.0 100.0 100.0 1250.0 0.0 100.0 1250.0 200.0 0.0 1250.0 200.0 100.0 1250.0 100.0 200.0 1250.0 0.0 200.0 1250.0 200.0 200.0 1250.0}
    GiD_MeshPre create Layer0 Hexahedra 8 $node_ids $node_coordinates {} {1 2 3 4 5 6 7 8 2 9 10 3 6 11 12 7 4 3 13 14 8 7 15 16 3 10 17 13 7 12 18 15}
    if { [GiD_Info Mesh -pre NumNodes] != 36 || [GiD_Info Mesh -pre NumElements Hexahedra] != 4 } {
            incr fail
    }
    #create 3 hexas more in other layer
    #and redefine again the same nodes, must not create more nodes
    GiD_Layers create Layer1
    GiD_MeshPre create Layer1 Hexahedra 8 $node_ids $node_coordinates {} {5 6 7 8 19 20 21 22 6 11 12 7 20 23 24 21 8 7 15 16 22 21 25 26}
    if { [GiD_Info Mesh -pre NumNodes] != 36 || [GiD_Info Mesh -pre NumElements Hexahedra] != 7 } {
            incr fail
    }
    #create 2 hexas more in other layer, do not define nodes, are defined previously
    GiD_Layers create Layer2
    GiD_MeshPre create Layer2 Hexahedra 8 {} {} {} {22 21 25 26 31 30 34 35 21 24 27 25 30 33 36 34}
    if { [GiD_Info Mesh -pre NumNodes] != 36 || [GiD_Info Mesh -pre NumElements Hexahedra] != 9 } {
            incr fail
    }
    #create 3 hexas more in other layer
    GiD_Layers create Layer3
    GiD_MeshPre create Layer3 Hexahedra 8 {} {} {} {7 12 18 15 21 24 27 25 19 20 21 22 28 29 30 31 20 23 24 21 29 32 33 30}
    if { [GiD_Info Mesh -pre NumNodes] != 36 || [GiD_Info Mesh -pre NumElements Hexahedra] != 12 } {
            incr fail
    }
    if { [llength [GiD_Layers list]] != 4 } {
        incr fail
    }
    return $fail
}
