
proc test_GiD_Dimension { } {
    set fail 0
    #test create points
    set p1 {-3.07042 1.78873 0.0}
    set p2 {-1.49296 0.535211 0.0}
    GiD_Geometry create point append Layer0 {*}$p1
    GiD_Geometry create point append Layer0 {*}$p2
    GiD_Geometry create line append stline Layer0 1 2
    
    #test create dimension
    set data {Layer0 text {first text} 1 {0.0 1.0}}
    set new_id [GiD_Dimension create append $data]
    if { [llength [GiD_Dimension list]] != 1 } {
        incr fail
    }
    if { [llength [GiD_Dimension list 1:1end]] != 1 } {
        incr fail
    }
    if { [llength [GiD_Dimension list -layer Layer0]] != 1 } {
        incr fail
    }
    #test create with forced num=5
    set data {Layer0 text {second text} 1 {0.0 0.0}}
    set new_id [GiD_Dimension create 5 $data]
    if { $new_id != 5 } {
        incr fail
    }
    if { [GiD_Dimension list 5] != 5 } {
        incr fail
    }
    
    #test get data
    set data_out [GiD_Dimension get 5]
    if { $data_out != $data } {
        incr fail
    }

    set data [list Layer0 distance 1.234 1 $p1 $p2 [MathUtils::VectorMean $p1 $p2]]
    set new_id [GiD_Dimension create append $data]
    if { [llength [GiD_Dimension list]] != 3 } {
        incr fail
    }
   
    #test delete
    GiD_Dimension delete 5
    if { [llength [GiD_Dimension list]] != 2 } {
        incr fail
    }
    
    #test get 
    set data_out [GiD_Dimension get $new_id]
    
    #test delete all
    GiD_Dimension delete 1:end
    if { [llength [GiD_Dimension list]] != 0 } {
        incr fail
    }

    #re-create 
    GiD_Dimension create $new_id $data_out
    if { [llength [GiD_Dimension list]] != 1 } {
        incr fail
    }
    
    #edit text
    set new_text {D = 2.015 m}
    GiD_Dimension edit $new_id text $new_text
    set text [GiD_Dimension get $new_id text]
    if { [GiD_Dimension get $new_id text] != $new_text } {
        incr fail
    }
    
    return $fail
}
