namespace eval LeastCommonPath {

  proc _pop { varname } {
    upvar 1 $varname var
    set var [lassign $var head]
    return $head
  }
 
  proc compute { dirs } {
    set parts [ file split [ _pop dirs ] ]
    while { [ llength $dirs ] } {
      set r {}
      foreach cmp $parts elt [ file split [ _pop dirs ] ] {
        if { $cmp ne $elt } break
        lappend r $cmp
      }
      set parts $r
    }
    return [ file join {*}$parts ]
  }

  proc lcp_split { p1 p2 } {
    set result {}
    foreach e1 $p1 e2 $p2 {
      if { ![string length $e1] || ![string length $e2] ||
         $e1 ne $e2 } {
        break
      }
      lappend result $e1
    }
    if { [llength $result] <= 1 } {
      return {}
    }
    return $result
  }

  proc cmpLCP { data x y } {

    return [ expr { [ dict get $data $x counter] - [ dict get $data $y counter] } ]
  }
 
  proc computeMultiple { dirs k } {
    set l [llength $dirs]
    if { $k <= 0 || $l == 0 } {
      return {}
    }
    foreach d $dirs {
      lappend splitted_dirs [ file split $d ]
    }
    
    set found [ dict create ]
    for {set i 0} {$i < $l} {incr i} {
      set pi [ lindex $splitted_dirs $i ]
      set dir_i [ lindex $dirs $i ]
      if { ![ dict exists $found $dir_i counter ] } {
          dict lappend found LCP $dir_i
          dict set found $dir_i index $i
          dict set found $dir_i counter 0
      }
      for { set j [expr { $i + 1 } ] } { $j < $l } { incr j } {
        set pj [ lindex $splitted_dirs $j ]
        set lcp [ lcp_split $pi $pj ]
        if { [ llength $lcp ] == 0 } {
          continue
        }
        set path_lcp [ file join {*}$lcp ]
        if { [ dict exists $found $path_lcp counter ] } {
          if { [dict get $found $path_lcp index] == $i } {
            dict set found $path_lcp counter \
                [ expr { [ dict get $found $path_lcp counter ] + 1 } ]
          }
        } else {
          dict lappend found LCP $path_lcp
          dict set found $path_lcp index $i
          dict set found $path_lcp counter 1
        }
      }
    }
    set lcp_k [ lrange \
                    [ lsort -command [namespace code [list cmpLCP $found ] ] \
                          -decreasing [ dict get $found LCP ] ] 0 [ incr k -1 ] ]
    return $lcp_k
  }

  proc runTests { } {
    package require tcltest
    package require struct
    set it 0
    set data_0 {/home/user1/tmp/coverage/test /home/user1/tmp/covert/operator /home/user1/tmp/coven/members}
    ::struct::list foreachperm var $data_0 {
      ::tcltest::test test-$it {test path in unix form} {
        compute $var
      } /home/user1/tmp
      incr it
    }

    ::tcltest::test test-$it {test lcp_split} {
      set p1 [file split [lindex $data_0 0] ]
      set p2 [file split [lindex $data_0 2] ]
      file join {*}[ lcp_split $p1 $p2 ]
    } /home/user1/tmp

    incr it
    ::tcltest::test test-$it {test computeMultiple 1} {
      computeMultiple { /home/user1/tmp/coverage/test /home/user1/tmp/covert/operator /home/user1/tmp/coven/members /home/user1/tmp/coven/members1} 1
    } /home/user1/tmp

    incr it
    ::tcltest::test test-$it {test computeMultiple 2} {
      computeMultiple { /home/user1/tmp/coverage/test /home/user1/tmp/covert/operator /home/user1/tmp/coven/members /home/user1/tmp/coven/members1} 2
    } /home/user1/tmp /home/user1/tmp/coven

    incr it
    ::tcltest::test test-$it {test computeMultiple with spaces 1} {
      computeMultiple [list {C:/gid_project} C:/Users/zero/Desktop {C:/Program Files/GiD/GiD 12.0} ] 2
    } [list {C:/gid_project} C:/Users/zero/Desktop ]

    incr it
    ::tcltest::test test-$it {test computeMultiple with spaces 2} {
      computeMultiple [ list  {C:/gid_project} C:/Users/zero/Desktop C:/Users/zero/Desktop/Other {C:/Program Files/GiD/GiD 12.0} {C:/Program Files/GiD/GiD 12.0/Other} ] 2
    } [list C:/Users/zero/Desktop {C:/Program Files/GiD/GiD 12.0} ]

    incr it
    ::tcltest::test test-$it {test computeMultiple with spaces 2} {
      computeMultiple [ list  {C:/gid_project} C:/Users/zero/Desktop C:/Users/zero/Desktop/Other {C:/Program Files/GiD/GiD 12.0} {C:/Program Files/GiD/GiD 12.0/Other} ] 3
    } [list C:/Users/zero/Desktop {C:/Program Files/GiD/GiD 12.0} {C:/gid_project} ]
  }
}

if { $argv0 eq [info script] } {
  LeastCommonPath::runTests
}
