#this tcl code must not use any GiD command, because it run outside the GiD interpreter. 
#It store the selections in gid.ini and then start GiD

proc safe_mode_WarnWin { message { w_parent .}} {
    tk_messageBox -type ok -title Warning -message $message -icon warning -parent $w_parent
}

proc safe_mode_getScreenDPI {} {
    set retDPI 75
    set max_dpi 75
    if { $::tcl_platform(os) == "Linux"} {
        # using xrandr or xdpyinfo
        set err_tool [ catch { exec xrandr } tool_output]
        if { $err_tool} {
            safe_mode_WarnWin "Found problems with xrandr:\n$tool_output\nTrying xdpyinfo (less acurate screen dpi info)."
            # Using xdpyinfo instead ...
            set err_tool [ catch { exec xdpyinfo } tool_output]
            if { $err_tool} {
                safe_mode_WarnWin "Found problems with xdpyinfo:\n$tool_output"
            }
        }
        
        if { !$err_tool} {
            # process output
            set lines [ split $tool_output \n]
            # if we have several monitors connected, we get the highest dpi
            foreach ln $lines {
                # first try xrandr output
                if { [ regexp {.+ connected.+ ([0-9]+)x([0-9]+)[+-][0-9]+[+-][0-9]+ .+ ([0-9]+)mm x ([0-9]+)mm.*$} $ln all pix_w pix_h pix_w_mm pix_h_mm] == 1} {
                    set my_dpi 75
                    if { $pix_w_mm != 0} {
                        set my_dpi [ expr ( 25.4 * $pix_w) / $pix_w_mm]
                    }
                    if { $my_dpi > $max_dpi} { set max_dpi $my_dpi}
                    
                    # try xdpyinfo output
                } elseif { [ regexp {.+resolution: +([0-9]+)x([0-9]+) .+} $ln all dpi_w dpi_h] == 1} {
                    if { $dpi_w > $max_dpi} { set max_dpi $dpi_w}
                }
            }
        }
        set retDPI $max_dpi
    }
    if { $::tcl_platform(os) == "Darwin" } {
        # using https://stackoverflow.com/questions/20099333/terminal-command-to-show-connected-displays-monitors-resolutions
        # system_profiler SPDisplaysDataType
        # defaults read /Library/Preferences/com.apple.windowserver.plist
        set err_tool [ catch { exec defaults read /Library/Preferences/com.apple.windowserver.plist } tool_output]
        if { $err_tool} {
            safe_mode_WarnWin "Found problems with 'defaults read /Library/Preferences/com.apple.windowserver.plist':\n$tool_output"
        }
        
        if { !$err_tool} {
            # process output
            set lines [ split $tool_output \n]
            # if we have several monitors connected, we get the highest dpi
            foreach ln $lines {
                # first try xrandr output
                if { [ regexp {.+ kCGDisplayHorizontalResolution = ([0-9]+);} $ln all my_dpi] == 1} {
                    if { $my_dpi > $max_dpi} { set max_dpi $my_dpi}
                }
            }
        }
        set retDPI $max_dpi
    }
    return $retDPI
}

proc safe_mode_GetDefaultHighResolutionScaleFactor {} {
    set my_dpi [ safe_mode_getScreenDPI]
    # GiD is still readable at a FullHD 14" laptop: 1920x1080 on 309mm x 174mm = 158dpi
    set still_readable_dpi 140
    # set factor [ expr round( $my_dpi / $still_readable_dpi)]
    set factor [ expr int( ( $my_dpi + $still_readable_dpi - 1.0) / $still_readable_dpi)]
    if { $factor > 3} { set factor 3}
    if { $factor < 1} { set factor 1}
    return $factor
}

proc safe_mode_checkOrCreateFixedFont {} {
    if { ![ GidUtils::IsTkDisabled]} {
        if { [ lsearch [ font names] FixedFont] == -1} {
            font create FixedFont -size 9 -family Courier
        }
    }
}

# same as gid_themes::_linux_GetTextScaleFactor
proc safe_mode_linux_GetTextScaleFactor {} {
    set ret_text_factor 1.0
    if { ( $::tcl_platform(os) == "Linux") && ![ GidUtils::IsTkDisabled]} {
        safe_mode_checkOrCreateFixedFont
        set fnt_size [ font configure FixedFont -size]
        if { $fnt_size > 0} {
            # using size = 9, font measure FixedFont GiD-TheUniversalPreAndPostprocessor = 245
            set str_measure [ font measure FixedFont GiD-TheUniversalPreAndPostprocessor]
            set str_measure_9 [ expr double( $str_measure) * 9.0 / double( $fnt_size)]
            set ret_text_factor [ expr $str_measure_9 / 245.0]
            if { $ret_text_factor < 1.0} {
                set ret_text_factor 1.0
            }
        }
    }
    return $ret_text_factor
}

proc safe_mode_scaleHighResolutionFonts {} {
    if { $::tcl_platform(os) eq "Darwin" } {
        return
    }
    set scale_factor [ safe_mode_GetDefaultHighResolutionScaleFactor]
    if { $scale_factor == 1} {
        # may be only the text is scaled
        set scale_factor [ safe_mode_linux_GetTextScaleFactor]
    }
    if { $scale_factor == 1} { return}
    foreach fnt [ font names] {
        set fnt_size [ font configure $fnt -size]
        set new_size [ expr int( 0.5 + $fnt_size * $scale_factor)]
        font configure $fnt -size $new_size
    }
}

proc safe_mode_ShowGraphicsInformation { w_parent } {
    package require gid_cross_platform
    set lst_txt [gid_cross_platform::getGraphicsInformation]
    lappend lst_txt ""
    safe_mode_WarnWin [join $lst_txt "\n"] $w_parent
}

proc safe_mode_window { } {
    set ::GIDDEFAULTTCL [file dirname [info script]]
    set ::GIDDEFAULT [file dirname $::GIDDEFAULTTCL]
    set ::env(TK_LIBRARY) [file join $::GIDDEFAULTTCL tk]
    lappend ::auto_path $::GIDDEFAULTTCL $::GIDDEFAULTTCL/tcl $::GIDDEFAULTTCL/tk
    # in linux & co. we'll use gidx, to ensure gid.exe will launch due to library dependencies
    if { $::tcl_platform(platform) eq "windows" } {
        set gidexe [file join $::GIDDEFAULTTCL .. gid.exe]
    } else {
        if { $::tcl_platform(os) eq "Darwin" } {
            set gidexe [file join $::GIDDEFAULTTCL .. .. MacOS gid]
        } else {
            set gidexe [file join $::GIDDEFAULTTCL .. gidx]
        }
    }
    
    if { ![ file exists $gidexe]} {
        # to run with development layout
        if { $::tcl_platform(platform) eq "windows" } {
            set gidexe [file join $::GIDDEFAULTTCL .. gid_64.bat]
        } else {
            set gidexe [file join $::GIDDEFAULTTCL .. run_gid.sh]
        }
    }
    
    #use gid instead of gid.exe
    #  for Windows gid.exe will be used
    #  but for Linux must use gid to set before environment variables
    
    package require dialogwin
    package require msgcat
    
    set ::InitialWindow(SoftwareOpenGL) 0
    set ::InitialWindow(Language) en
    
    set ret [exec "$gidexe" -outputinfo defaults]
    regexp -line {GidDefaults=(.*)} $ret {} inifile
    # set inifile $::env(HOME)/.gidDefaults
    set inifile0 [file join $::GIDDEFAULTTCL gidDefaults]
    set filename_argv [file join $::GIDDEFAULT argv.txt]
    if { [file exists $filename_argv] } {
        #check if overwrite the default ini file            
        set fin [open $filename_argv r]
        set data [read $fin]
        close $fin
        #e.g.
        #-c2 IBER.ini -p IBER        
        set pos [lsearch $data -c2]
        if { $pos != -1 } {
            set alternative_ini [lindex $data $pos+1]
            if { [file pathtype $alternative_ini] == "relative" } {
                set inifile [file join [file dirname $inifile] $alternative_ini]
            } elseif { [file pathtype $alternative_ini] == "absolute" } {
                set inifile $alternative_ini                
            } else {
                #???
            }
        }
        
    }
    
    foreach file [list $inifile0 $inifile] {
        if { [file exists $file] } {
            set fin [open $file r]
            set data [read $fin]
            close $fin
            regexp -line {^SoftwareOpenGL\s+(\d+)} $data {} ::InitialWindow(SoftwareOpenGL)
            regexp -line {^Language\s+(\S+)} $data {} ::InitialWindow(Language)
        }
    }
    
    msgcat::mclocale $::InitialWindow(Language)
    msgcat::mcload [file join $::GIDDEFAULT resources msgs]
    interp alias "" _ "" msgcat::mc
    
    set Languages [list en]
    foreach file [glob -nocomplain -dir [file join $::GIDDEFAULT resources msgs] *.msg] {
        lappend Languages [file root [file tail $file]]
    }
    set Languages [lsort -dictionary -unique $Languages]
    
    wm withdraw .
    
    if { $::tcl_platform(os) == "Linux"} {
        catch {
            set fnt_lst [ font families]
            set def_fnt FreeSans
            foreach ff [ list FreeSans "Open Sans" "Liberation Sans" "DejaVu Sans" Roboto] {
                if { [ lsearch $ff $fnt_lst] != -1} {
                    set def_fnt $ff
                    break
                }
            }
            font configure TkDefaultFont -family $def_fnt
            option add *font TkDefaultFont
        }
    }
    
    # for High Resolution displays, scale fonts
    safe_mode_scaleHighResolutionFonts
    set scale_factor [ safe_mode_GetDefaultHighResolutionScaleFactor]
    
    # sizes, pads & co.
    set wraplength [ expr 250 * $scale_factor]
    set padx3 [ expr 3 * $scale_factor]
    set pady3 [ expr 3 * $scale_factor]
    
    set w [dialogwin_snit ._ask -title [_ "Repair %s" GiD] -cancelname [_ Exit]]
    set f [$w giveframe]
    
    set f1 [ttk::labelframe $f.f1 -text OpenGL]
    
    if { ![info exists ::InitialWindow(SoftwareOpenGL)] } { 
        set ::InitialWindow(SoftwareOpenGL) 0 
    }
    ttk::checkbutton $f1.cb -text [_ "Activate Software OpenGL"] -variable ::InitialWindow(SoftwareOpenGL)
    
    label $f1.l1 -text [_ "Note: If OpenGL by software is activated, graphics will be slower.\
            Only activate it if you are experiencing problems with graphics visualization."] \
        -wraplength $wraplength -justify left

    grid $f1.cb -sticky w -padx $padx3 -pady $pady3
    grid $f1.l1 -sticky w -padx $padx3 -pady $pady3

    # if { $::tcl_platform(platform) != "windows"} {
        ttk::button $f1.b_graphics -text [_ "Check graphics"] \
            -command [ list safe_mode_ShowGraphicsInformation $w]
        grid $f1.b_graphics -padx $padx3 -pady $pady3
    # }
    
    set f2 [ttk::labelframe $f.f2 -text [_ "Preferences"]]
    
    set ::InitialWindow(ResetPreferences) 0
    ttk::checkbutton $f2.cb -text [_ "Reset preferences"] -variable ::InitialWindow(ResetPreferences)
    
    
    label $f2.l1 -text [_ "Note: If preferences are reset. Program will start as if it was\
            installed for the first time. All preferences data will be lost."] \
        -wraplength $wraplength -justify left
    
    grid $f2.cb -sticky w -padx $padx3 -pady $pady3
    grid $f2.l1 -sticky w -padx $padx3 -pady $pady3
    
    set f3 [ttk::labelframe $f.f3 -text [_ "Languages"]]
    
    ttk::label $f3.l1 -text [_ "Language"]:
    
    array set lans [list en English es Spanish ja Japanese fr French ca Catalan \
            de German ko Korean ru Russian zh Chinese]
    set ::Language_p $::InitialWindow(Language)
    set Languages_p ""
    foreach i $Languages {
        if { [info exists lans($i)] } {
            set i_p $lans($i)
        } else {
            set i_p $i
        }
        lappend Languages_p $i_p
        if { $i eq $::InitialWindow(Language) } {
            set ::Language_p $i_p
        }
    }
    
    ttk::combobox $f3.cb -textvariable ::Language_p -state readonly -values $Languages_p
    
    grid $f3.l1 $f3.cb -padx $padx3 -pady $pady3
    
    set f4 [ttk::labelframe $f.f4 -text [_ "GiD Theme"]]
    ttk::label $f4.l1 -text [_ "Theme"]:    
    # available themes:
    set lst_themes(label) [ list [_ "White GiD Theme"] [_ "Dark GiD Theme"] [_ "Classic GiD Theme"] [_ "GiD Light+"]]
    # set lst_themes(key) [ list GiD_white_vectorial GiD_black GiD_classic GiD_classic_renewed ]
    set lst_themes(key) [ list GiD_white_vectorial GiD_black GiD_classic GiD_light_plus]
    if { $::tcl_platform(platform) == "windows"} {
        set default_theme_index 0
    } else {
        set default_theme_index 3
    }
    set ::Theme_p [ lindex $lst_themes(label) $default_theme_index]
    ttk::combobox $f4.cb -textvariable ::Theme_p -state readonly -values $lst_themes(label)    
    
    grid $f4.l1 $f4.cb -padx $padx3 -pady $pady3
    
    if { $::tcl_platform(os) == "Darwin"} {
        ttk::label $f4.mt_lbl -text [_ "GiD menu bar configuration"]:
        ttk::radiobutton $f4.mt_rd1 -text [_ "Embedded in graphical window"] -value generic -variable ::InitialWindow(MenuType)
        ttk::radiobutton $f4.mt_rd2 -text [_ "Mac OS X top menu bar"] -value native -variable ::InitialWindow(MenuType)    
        if { ( $::tcl_platform(platform) == "windows") || ( $::tcl_platform(os) == "Darwin") } {
            set ::InitialWindow(MenuType) "native"
        } else {
            set ::InitialWindow(MenuType) "generic"
        }
        foreach ww [ list mt_lbl mt_rd1 mt_rd2] {
            grid $f4.$ww -columnspan 2 -padx $padx3 -pady $pady3 -sticky new
        }
    }
    
    grid $f1 -sticky nwe
    grid $f2 -sticky nwe
    grid $f3 -sticky nwe
    grid $f4 -sticky nwe
    
    set action [$w createwindow]    
    
    if { $action == 1 } { 
        set ::InitialWindow(Language) $::Language_p
        foreach "n v" [array get lans] {
            if { $::Language_p eq $v } {
                set ::InitialWindow(Language) $n
                break
            }
        }        

        set idx_theme [ lsearch $lst_themes(label) $::Theme_p]
        if { $idx_theme == -1} {
            set idx_theme $default_theme_index
        }
        set theme_key [ lindex $lst_themes(key) $idx_theme]
        set ::InitialWindow(Theme) $theme_key
        
        if { $::InitialWindow(ResetPreferences) } {
            if { $::tcl_platform(platform) eq "windows" } {
                # WARNING: all problemtype init files are deleted
                set inidir [file dirname $inifile]
                if { [file exists $inidir~] } {
                    file delete -force $inidir~
                    update idletasks
                }
                if { [file exists $inidir] } {
                    file rename $inidir $inidir~
                }
                file mkdir $inidir
            } else {        
                file delete $inifile        
                set postfile [file join [file dirname $inifile] .GiDPostPreferences.ini]
                file delete $postfile
            }

            if { 0 } {
                #most procs were not loaded at this point...
                set file_key gid.ini
                if { $::GID_ENABLE_DATAMANAGER == 1 } {
                    set folder_defaults [file normalize [gid_filesystem::get_folder_nextcloud .]]
                    if { $folder_defaults != "" } {
                        #set gid_defaults [file join "R:" $file_key] ;#test with a local disk
                        set gid_defaults [file join $folder_defaults $file_key]
                        if { [file exists $gid_defaults] } {
                            file delete $gid_defaults
                        }
                    }
                } elseif { $::GID_ENABLE_DATAMANAGER == 2 } {
                    set data ""
                    set gid_defaults [file join gid [GiD_Info GiDVersion] $file_key]
                    catch { set ok [GidDataManager::directUploadData $gid_defaults $data] } err options
                }
            }
        }
        
        set fout [open $inifile a]
        # the first empty line is to forca an endline 
        # to avoid problems with wrong gid.ini file that has 
        # ProgressInMeshingMore 1SoftwareOpenGLSoftwareOpenGLSoftwareOpenGLSoftwar
        # it happened in some Linux, and e.g. gid 17.0.2
        # maybe written multiple threads of process in same gid.ini ??
        puts $fout ""
        puts $fout "SoftwareOpenGL $::InitialWindow(SoftwareOpenGL)"
        puts $fout "OpenGL(Configured) 1"
        puts $fout "Theme_configured 1"
        puts $fout "Theme(Current) $::InitialWindow(Theme)"
        puts $fout "Language $::InitialWindow(Language)"
        if { [info exists ::InitialWindow(MenuType)] } {
            puts $fout "Theme(MenuType) $::InitialWindow(MenuType)"
        }
        close $fout
        
        eval [list exec $gidexe] [lrange $::argv 2 end] &                
    } else {
        #press Exit
    }
    exit
}

package require Tk

if { ![ winfo exist .gid]} {
    safe_mode_window
} else {
    safe_mode_WarnWin "gid_safe_mode : GiD is already running.\nPlease close it before running this script."
}
