
package require uri
package require html
package require percentencoding

namespace eval ::gid_rest::server {
}
namespace eval ::gid_rest::service {
}
namespace eval ::gid_rest::application {
}

# start with
# ::gid_rest::server::start

proc HTTPD {port certfile keyfile userpwds realm handler} {
    if {![llength [info commands Log]]} { proc Log {args} { W $args } }

    namespace eval httpd [list set handlers $handler]
    namespace eval httpd [list set realm $realm]

    foreach up $userpwds { namespace eval httpd [list lappend auths [binary encode base64 $up]] }
    namespace eval httpd {
	proc respond {sock code body {head ""}} {
	    puts -nonewline $sock "HTTP/1.0 $code ???\r\nContent-Type: text/html; charset=ISO-8859-1\r\nConnection: close\r\nContent-length: [string length $body]\r\n$head\r\n$body"
	}
	proc respond_text {sock code body sub_type {head ""}} {
	    puts -nonewline $sock "HTTP/1.0 $code ???\r\nContent-Type: text/$sub_type; charset=ISO-8859-1\r\nConnection: close\r\nContent-length: [string length $body]\r\n$head\r\n$body"
	}
	proc respond_png { sock code body {head ""}} {
	    puts -nonewline $sock "HTTP/1.0 $code ???\r\nContent-Type: image/png\r\n\r\n"
	    puts -nonewline $sock $body
	}
	proc respond_img { sock code body sub_type {head ""}} {
	    puts -nonewline $sock "HTTP/1.0 $code ???\r\nContent-Type: image/$sub_type\r\n\r\n"
	    puts -nonewline $sock $body
	}
	proc respond_raw { sock code body {head ""}} {
	    # puts -nonewline $sock "HTTP/1.0 $code ???\r\nContent-Type: image/png\r\n\r\n"
	    puts -nonewline $sock $body
	}
	proc respond_json {sock code body {head ""}} {
	    puts -nonewline $sock "HTTP/1.0 $code ???\r\nContent-Type: application/json\r\n$head\r\n$body"
	}
	proc checkauth {sock ip auth} {
	    variable auths
	    variable realm
	    if {[info exist auths] && [lsearch -exact $auths $auth]==-1} {
		respond $sock 401 Unauthorized "WWW-Authenticate: Basic realm=\"$realm\"\r\n"
		error "Unauthorized from $ip"
	    }
	}
	proc handler {sock ip reqstring auth} {
	    variable auths
	    variable handlers

	    # checkauth $sock $ip $auth
	    array set req $reqstring
	    switch -glob $req(path) [concat $handlers [list default { respond $sock 404 "Error: unknown path '$req(path)'" }]]
	}
	proc accept {sock ip port} {
	    if {[catch {
		fconfigure $sock -translation {binary binary}
		gets $sock line
		set auth ""
		for {set c 0} {[gets $sock temp]>=0 && $temp ne "\r" && $temp ne ""} {incr c} {
		    regexp {Authorization: Basic ([^\r\n]+)} $temp -- auth
		    if {$c == 30} { error "Too many lines from $ip" }
		}
		if {[eof $sock]} { error "Connection closed from $ip" }
		foreach {method url version} $line { break }

		set pp [uri::split $url]
		array set req $pp

		switch -exact $method {
		    GET { handler $sock $ip [uri::split $url] $auth }
		    default {
			respond_text $sock 400 "Error: Unsupported method '$method' from $ip , url = $url" plain
			error "Unsupported method '$method' from $ip , url = $url" 
			# GidUtils::SetWarnLine "redirection to http://jedi-card-api.herokuapp.com/$req(path)"
			# respond_raw $sock 307 "HTTP/1.1 307 ????\nLocation: http://jedi-card-api.herokuapp.com/$req(path)"
		    }
		}
	    } msg]} {
		Log "Error: $msg"
	    }
	    close $sock
	}

	# should be here but at the moment for the shake of experimentation
	proc serve_scripts_js { sock path} {
	    set js_home [ file join $::GIDDEFAULT resources js]
	    set abs_filename [ file join $js_home $path]
	    if { ![ file exists $abs_filename] || ![ file isfile $abs_filename]} {
		set abs_filename [ file join $js_home index.html]
	    }
	    set fi [ open $abs_filename]
	    set content [ read $fi]
	    close $fi
	    set cmd respond
	    set subtype ""
	    switch [ string tolower [ file extension $abs_filename]] {
		".htm" -
		".html" {
		    set cmd respond_text
		    set subtype html
		}
		".css" {
		    set cmd respond_text
		    set subtype css
		}
		".txt" -
		".js" {
		    set cmd respond_text
		    set subtype plain
		}
		".ico" {
		    set cmd respond_img
		    set subtype x-icon
		}
		default {
		    set cmd respond_text
		    set subtype plain
		}
	    }
	    $cmd $sock 200 $content $subtype
	    # GidUtils::SetWarnLine "Looking for '$path': returning $cmd $subtype [ string range $content 0 100]"
	}
	# above should be here but at the moment for the shake of experimentation

    }    
    if {$certfile ne ""} {
        package require tls
        ::tls::init \
            -certfile $certfile \
            -keyfile  $keyfile \
            -ssl2 1 \
            -ssl3 1 \
            -tls1 0 \
            -require 0 \
            -request 0
        set sock [ ::tls::socket -server httpd::accept $port]
    } else {
	    set sock [ socket -server httpd::accept $port]
    }
}

proc ::gid_rest::server::start { } {
    # Generating SSL key is very easy, just use these two commands:
    #  openssl genrsa -out server-private.pem 1024
    #  openssl req -new -x509 -key server-private.pem -out server-public.pem -days 365 
    # Or just don't specify the key files to use HTTP instead of HTTPS
	# HTTPD 9005 "" "" {mike:pwd you:yourpwd} {AuthRealm} {...}
    set port 9999
    set port 15818

    # "api/*" {
    #     GidUtils::SetWarnLine "redirection to http://jedi-card-api.herokuapp.com/$req(path)"
    #     respond_raw $sock 301 "HTTP/1.1 301 ????\nLocation: http://jedi-card-api.herokuapp.com/$req(path)"
    # }
    HTTPD $port "" "" {} {AuthRealm} {
        "" {
	    respond $sock 200 "Want to know the <a href=\"/time\">time</a>? or <a href=\"/image_page\">image</a> or <a href=\"/mesh\">STL mesh</a>?<br>Try PINGU <a href=\"/api/v0/help\">api v0 help</a> :<br>[ ::gid_rest::service::get_api_v0_html_help]"
# Try some angular 5 JS <a href="/login">login</a> or <a href="/sign-in">sign-in</a> or <a href="/about">about</a>
        }
        "time" {
	    respond $sock 200 "Time: [clock format [clock seconds]]<br>pwd = [ pwd]" "Refresh: 6;URL=/\n"
        }
	"image_page" {
	    respond $sock 200 {Current image:<br><img src="/image">} "Refresh: 3;URL=/image_page\n"
	}
	"image" {
	    respond_png $sock 200 [ lindex [ GiD_Thumbnail get_pixels -components rgb -format png] 2]
	}
	"mesh" {
	    respond_raw $sock 200 [ GiD_Thumbnail get_vectorial stl]
	}
	"mesh_vrml" {
	    respond_raw $sock 200 [ GiD_Thumbnail get_vectorial vrml]
	}
        "api/v0/*" {
            set answer [ ::gid_rest::service::process_api_call $req(path)]
            set http_code [ lindex $answer 0]
            set json_response [ lindex $answer 1]
            respond_json $sock $http_code $json_response
        }
        # disable serving js application
	# "*" {
	#     serve_scripts_js $sock $req(path)
	# }
    }

    GidUtils::SetWarnLine "rest server started at port $port"

	# "image/*" {
	#     respond $sock 200 "Loading ... $req(path)"
	# }
}

# img_server_start

proc ::gid_rest::service::build_json_success { key value } {
    # following https://github.com/omniti-labs/jsend
    # as suggested in https://stackoverflow.com/questions/477816/what-is-the-correct-json-content-type
    # Type	Required Keys		Optional Keys	Description
    # success	status, data				All went well, and (usually) some data was returned.
    # fail	status, data				There was a problem with the data submitted, or some pre-condition of the API call wasn't satisfied
    # error	status, message		code, data	An error occurred in processing the request, i.e. an exception was thrown
    if { ( [ string index $value 0] != "{") || ( [ string index $value end] != "}") } {
        set value \"$value\"
    }
    return "{ \"status\" : \"success\", \"data\" : { \"$key\" : $value } }"
}
proc ::gid_rest::service::build_json_fail { key value } {
    # following https://github.com/omniti-labs/jsend
    # as suggested in https://stackoverflow.com/questions/477816/what-is-the-correct-json-content-type
    # Type	Required Keys		Optional Keys	Description
    # success	status, data				All went well, and (usually) some data was returned.
    # fail	status, data				There was a problem with the data submitted, or some pre-condition of the API call wasn't satisfied
    # error	status, message		code, data	An error occurred in processing the request, i.e. an exception was thrown
    if { [ llength $value] <= 1} {
        set value \"$value\"
    }
    return "{ \"status\" : \"fail\", \"data\" : { \"$key\" : $value } }"
}
proc ::gid_rest::service::build_json_error { message} {
    # following https://github.com/omniti-labs/jsend
    # as suggested in https://stackoverflow.com/questions/477816/what-is-the-correct-json-content-type
    # Type	Required Keys		Optional Keys	Description
    # success	status, data				All went well, and (usually) some data was returned.
    # fail	status, data				There was a problem with the data submitted, or some pre-condition of the API call wasn't satisfied
    # error	status, message		code, data	An error occurred in processing the request, i.e. an exception was thrown
    return "{ \"status\" : \"error\", \"message\" : \"$message\"}"
}

proc ::gid_rest::service::get_api_v0_html_help { } {
    set current_api api/v0
    set help_html "<ul>\n"
    foreach line [ ::gid_rest::service::GetApiHelp $current_api] {
        append help_html "<li><pre>$line</pre></li>\n"
    }
    append help_html "</ul>\n"
    append help_html "Each command returns a json following the convention specified in <br>"
    append help_html "<a href=\"https://github.com/omniti-labs/jsend\">https://github.com/omniti-labs/jsend</a>\n"
    return $help_html
}

proc ::gid_rest::service::process_api_call { req_path } {
    # current api:
    set current_api api/v0
    if { [ regexp "${current_api}/(.+)" $req_path dumm api_v0_call] == 1} {
        # return [ list 200 [ ::gid_rest::service::build_json_success path $api_v0_call]]
    } else {
        return [ list 404 [ ::gid_rest::service::build_json_fail path $req_path]]
    }

    set return_http_code 404
    set return_json_response [ ::gid_rest::service::build_json_fail path ---$api_v0_call]
    switch -glob $api_v0_call {
        "project/read/*" {
            # files read $req(path)
            # $req(path) == project/read/xxxx
            if { [ regexp {project/read/(.*)} $api_v0_call dumm project2load] == 1} {
                set status [ ::gid_rest::application::DoProjectRead $project2load]
                set ok [ lindex $status 0]
                set reason [ lindex $status 1]
                if { $ok } {
                    set return_http_code 200
                    set return_json_response [ ::gid_rest::service::build_json_success details \
                                               [ ::gid_rest::application::GetCurrentProjectDetailsAsJSON]
                                              ]
                } else {
                    set return_http_code
                    set return_json_response [ ::gid_rest::service::build_json_error "Unable to load project: $reason"]
                }
            } else {
                set return_http_code 404
                set return_json_response [ ::gid_rest::service::build_json_fail path $api_v0_call]
            }
        }
        "project/save" {
            # files save
            # $req(path) == project/save
            set status [ ::gid_rest::application::DoProjectSave]
            set ok [ lindex $status 0]
            set reason [ lindex $status 1]
            if { $ok } {
                set return_http_code 200
                set return_json_response [ ::gid_rest::service::build_json_success details \
                                           [ ::gid_rest::application::GetCurrentProjectDetailsAsJSON]
                                          ]
            } else {
                set return_http_code 500
                set return_json_response [ ::gid_rest::service::build_json_error "Unable to save project: $reason"]
            }
        }
        "project/saveas/*" {
            # files saveas $req(path)
            # $req(path) == project/saveas/xxxx
            if { [ regexp {project/saveas/(.*)} $api_v0_call dumm project2load] == 1} {
                set status [ ::gid_rest::application::DoProjectSaveAs $project2load]
                set ok [ lindex $status 0]
                set reason [ lindex $status 1]
                if { $ok } {
                    set return_http_code 200
                    set return_json_response [ ::gid_rest::service::build_json_success details \
                                               [ ::gid_rest::application::GetCurrentProjectDetailsAsJSON]
                                              ]
                } else {
                    set return_http_code 500
                    set return_json_response [ ::gid_rest::service::build_json_error "Unable to save project: $reason"]
                }
            } else {
                set return_http_code 404
                set return_json_response [ ::gid_rest::service::build_json_fail path $api_v0_call]
            }
        }
        "project/new" {
            # files new $req(path)
            # $req(path) == project/new
            set status [ ::gid_rest::application::DoProjectNew]
            set ok [ lindex $status 0]
            set reason [ lindex $status 1]
            if { $ok } {
                set return_http_code 200
                set return_json_response [ ::gid_rest::service::build_json_success details \
                                           [ ::gid_rest::application::GetCurrentProjectDetailsAsJSON]
                                          ]
            } else {
                set return_http_code 500
                set return_json_response [ ::gid_rest::service::build_json_error "Unable to create new project: $reason"]
            }
        }
        "project/details" {
            # files new $req(path)
            # $req(path) == project/new
            set return_http_code 200
            set return_json_response [ ::gid_rest::service::build_json_success details \
                                       [ ::gid_rest::application::GetCurrentProjectDetailsAsJSON]
                                      ]
        }
        "help" {
            set return_http_code 200
            set return_json_response [ ::gid_rest::service::build_json_success help \
                                       [ ::gid_rest::service::GetApiHelp $current_api]
                                      ]
        }
        "*" {
            set return_http_code 404
            set return_json_response [ ::gid_rest::service::build_json_fail path $api_v0_call]
        }
    }
    return [ list $return_http_code $return_json_response]
}

proc ::gid_rest::service::GetApiHelp { api_version } {
    return "${api_version}/project/read/path%2fto%2fprojectname.gid   \
${api_version}/project/save   \
${api_version}/project/saveas/path%2fto%2fprojectname.gid   \
${api_version}/project/details   \
${api_version}/project/new   \
${api_version}/help   "
}

proc ::gid_rest::application::DoProjectRead { coded_project2load} {
    set project2load [ percentencoding::decode $coded_project2load]
    set ok 0
    set txt ""
    if { $project2load != ""} {
        # LoadFileInGid $project2load
        # Quit current model withou asking
        DoFilesNew AUTO
        # Files read, if it does not exists it creates the model
        # so checking if it exists
        if { [ file exists $project2load] && [ file isdirectory $project2load]} {
            GiD_Process Mescape Files Read "$project2load"
            set ok 1
            set txt "$project2load loaded"
        } else {
            set ok 0
            set txt "Project $project2load not found."
        }
    } else {
        set ok 0
        if { $coded_project2load == ""} {
            set txt "empty project name: '$coded_project2load'"
        } else {
            set txt "invalid percent code: '$coded_project2load'"
        }
    }
    return [ list $ok $txt]
}

proc ::gid_rest::application::DoProjectSaveAs { coded_project2saveas} {
    set project2saveas [ percentencoding::decode $coded_project2saveas]
    set ok 0
    set txt ""
    if { $project2saveas != ""} {
        GiD_Process Mescape Files SaveAs "$project2saveas" yes
        set ok 1
        set txt "Project saved as $project2saveas"
    } else {
        set ok 0
        if { $coded_project2saveas == ""} {
            set txt "empty project name: '$coded_project2saveas'"
        } else {
            set txt "invalid percent code: '$coded_project2saveas'"
        }
    }
    return [ list $ok $txt]
}

proc ::gid_rest::application::DoProjectSave { } {
    set ok 0
    set txt ""    
    if { [GidUtils::ModelHasName] } {
        GiD_Process Mescape Files Save
        set ok 1
        set txt "Project [GiD_Info project ModelName] saved"
    } else {
        set ok 0
        set txt "Project has no name, use saveas"
    }
    return [ list $ok $txt]
}

proc ::gid_rest::application::DoProjectNew { } {
    DoFilesNew AUTO
    set ok 1
    set txt "New project"
    return [ list $ok $txt]
}

proc ::gid_rest::application::GetCurrentProjectDetailsAsJSON { } {
    set json_details "{ \n"
    append json_details "  \"details_project\" : { \n"
    set is_first 1
    foreach item [ list ProblemType ModelName AreChanges LayerToUse \
                       ViewMode Quadratic RenderMode MustReMesh LastElementSize \
                       RequireMeshSize RecommendedMeshSize] {
        if { !$is_first} {
            append json_details ",\n"
        }
        append json_details "    \"$item\" : \"[ GiD_Info project $item]\""
        set is_first 0
    }
    append json_details "\n  }"
    
    append json_details ",\n  \"details_geometry\" : { \n"
    set is_first 1
    foreach item [ list NumPoints NumLines NumSurfaces NumVolumes NumDimensions] {
        if { !$is_first} {
            append json_details ",\n"
        }
        append json_details "    \"$item\" : \"[ GiD_Info geometry $item]\""
        set is_first 0
    }
    append json_details "\n  }"

    # add current image
    set image_png [ lindex [ GiD_Thumbnail get_pixels -components rgb -format png] 2]
    append json_details ",\n  \"image_png\" : \"[binary encode base64 $image_png]\""
    
    append json_details "\n}"
    # later on we will add more information, like mesh details, post details, etc...    
    return $json_details
}

# start with
# ::gid_rest::server::start
