
# test to try to convert a classic problemtype into a customLib one

#wrongly docummented, (ask to Rosa Compass)
# que hace default="Yes"? (en classic una value=#DEFAULT# era como decir que salta cuando value es uno de los no dichos en dependencies value)
# por ejemplo que hace esto?:
# se dice que salte la dependencia con value==Yes y ademas con cualquier otro valor que no sea No ni Yes?
#  <value n="Output_1" pn="Output 1" v="No" values="Yes,No" state="normal" help="Check the box to activate out 1 variable.">
#      <dependencies node="../value[@n='Out_1']" att1="state" v1="normal" value="Yes" default="Yes" actualize="1"/>
#      <dependencies node="../value[@n='Out_1']" att1="state" v1="hidden" value="No" actualize="1"/>
# mi impresion es que es un error de uso y sobra default="Yes", ya que solo hay posibles valores Yes o No, ademas seria default="1"

#Code_bright_v_9_3 decirles que corrijan algunas cosas, les paso los ficheros cambiados y los originales

#to do here:
#  -implement DEPENDENCIES . now only HIDE and RESTORE, and find an existen xpath node instead //value[@n='$question_to_change']
#             IMAGE
#  -consider sim to draw conditions?
#  -Iber trick to avoid decoration fields -- or IberPlus#CB#(_)
#  -Code_bright trick to avoid decoration fields with a combo with 1 option, like QUESTION: Forces#CB#(Nodal_forces_[MN])
#  -Iber and Code_bright trick to extract units from questions and use as true units
#  -customLib materials are not related with material index of each GiD entity
#   to use customLib materials the material name must be used in some other field with values_tree=[GetMaterialsList]
#   where GetMaterialsList is a proc (its name is arbitrary) defined in
#   <procs>
#     <proc n="GetMaterialsList" args="args">return [MyGetMaterialslist $domNode]</proc>
#   </procs>
#   and proc MyGetMaterialslist { domNode} { ... } could be defined in a tcl file, to allow debug
#
#to do at customLIb:
#  -scroll if data window is small for the amount of questions
#  -ademas customLib deja mas espacio entre questions, con lo que con pocas ya no cabe en mi pantalla de portatil (1366x768)
#  -implement table item or modify function to allow multiple ys of same x
#  -link GiD entity material id with customLib materials, and allow assign to geometry/mesh
#   e.g. and attribute assign='point line surface volume element' (a list of allowed entities)
#   that allow assign, unsassign, draw in GiD
#   -customLib salta alguna dependencia menos que con classic, por ejemplo Code_bright
#    si no cambio Stress_equilibrium_(unknow_displacement_u) y despliego Solution strategy muchos campos no se han ocultado
#    o por ejemplo Iber <value n="IberDefault" pn="IberDefault" v="Enabled" values="Enabled,Disabled">
#    no saltan al cargar el arbol las dependencias <dependencies value="Enabled" node="//container[@n='Wood']" att1="state" v1="hidden" actualize="1"/>
#    con lo que no salen ocultos los ultimos containers Wood, Habitat, Non_Newtonian_Fluid, HiddenTitle

namespace eval ProblemtpeConvert {
    variable use_units 1
    variable showed_message_unit_magnitude
    variable ovm
    array set ovm {
        {over nodes} node
        {over body elements} element
        {over body elems} element
        {over face elements} face_element
        {over face elements multiple} face_element
        {unknown} element
    }
    #unknown really is ambiguous, could be considered sometimes as element and sometimes as face_element
    
    #map some known wrong expressed units of Iber and code_bright
    variable map_wrong_unit
    array set map_wrong_unit {
        m2/s m^2/s
        m/s2 m/s^2
        N/m2 N/m^2
        kg/m3 kg/m^3
        W/m2 W/m^2
        m3/s m^3/s
        m2/s2 m^2/s^2
        m2/s3 m^2/s^3
        g/m2/day g/m^2/day        
        kg_m^-2_s^-1_MPa^-1 J*m^-2*s^-1
        Kg_m^-2_s^-1_MPa^-1 J*m^-2*s^-1
        J_m^-2_s^-1 J*m^-2*s^-1
    }
}

proc ProblemtpeConvert::XmlCreateTextNode { xml_parent txt} {
    set newNode [[$xml_parent ownerDocument] createTextNode $txt]
    $xml_parent appendChild $newNode
    return $newNode
}

proc ProblemtpeConvert::XmlCreateElement { xml_parent name {attributes ""} } {
    set newNode [[$xml_parent ownerDocument] createElement $name]
    if { $attributes != "" } {
        $newNode setAttribute {*}$attributes
    }
    $xml_parent appendChild $newNode
    return $newNode
}

proc ProblemtpeConvert::XmlCreateElementInsertAfter { xml_parent xml_before name {attributes ""} } {
    set newNode [[$xml_parent ownerDocument] createElement $name]
    if { $attributes != "" } {
        $newNode setAttribute {*}$attributes
    }
    $xml_parent insertBefore $newNode [$xml_before nextSibling]
    return $newNode
}

proc ProblemtpeConvert::XmlSetAttributes { xml_node attributes } {
    $xml_node setAttribute {*}$attributes
}

proc ProblemtpeConvert::WriteDocAsXml { doc filename } {
    set fout [open $filename w]
    fconfigure $fout -encoding utf-8
    puts $fout {<?xml version="1.0" encoding="utf-8"?>}
    puts $fout [$doc asXML -indent 2]
    close $fout
    return 0
}

proc ProblemtpeConvert::TrimUnderline { question } {
    return [string trim $question _] ;#trick to remove extra _ of Code_bright)
}

proc ProblemtpeConvert::DecoratePn { question } {
    set question [ProblemtpeConvert::TrimUnderline $question ]
    return [string map {_ { }} $question]
}

#trick to extract from decorated questions possible units, like Constant_Pg[MPa] -> Constant_Pg MPa
#units="m/s^2" unit_magnitude="L/T^2"
#units="MPa" unit_magnitude="P"
#[gid_groups_conds::give_unit_magnitude_and_factor MPa] -> P 1000000.0 {}
#[gid_groups_conds::give_unit_magnitude_and_factor m/s^2] -> Acceleration 1.0 {}
proc ProblemtpeConvert::ParseCodedUnits { question } {
    variable use_units
    variable showed_message_unit_magnitude
    variable map_wrong_unit
    if { $use_units } {
        if { [regexp {(.+)\[(.+)\]$} $question dummy question_base units] } {
            set question_base [ProblemtpeConvert::TrimUnderline $question_base]
            set units [string trim $units]
            if { $units == "C" || $units == "Celsius" || $units == "degrees" || $units == "deg_C" } {
                set degree \u00B0
                set units "${degree}C"
            } elseif { $units == "-" || $units == "" } {
                return [list $question_base]
            }            
            set unit_magnitude [ProblemtpeConvert::GetUnitMagnitude $units]
            if { $unit_magnitude ==  "" } {
                if { [info exists map_wrong_unit($units)] } {
                    set units_fixed $map_wrong_unit($units)
                    set unit_magnitude [ProblemtpeConvert::GetUnitMagnitude $units_fixed]
                    if { $unit_magnitude !=  "" } {
                        set units $units_fixed                        
                    }                    
                }
            }
            if { $unit_magnitude ==  "" } {                              
                if { ![info exists showed_message_unit_magnitude($units)] } {
                    set showed_message_unit_magnitude($units) 1
                    W "unit_magnitude not found for units $units, ignore this unit $question"
                }
            } else {
                return [list $question_base $units $unit_magnitude]
            }
        }
    }
    return [list $question]
}

proc ProblemtpeConvert::GetUnitMagnitude { units } {
    package require customLib
    gid_groups_conds::init_package
    set unit_magnitude ""
    if { [catch { gid_groups_conds::give_unit_magnitude_and_factor $units } ret] } {
        set unit_magnitude ""
    } else {
        lassign $ret unit_magnitude unit_factor addend
    }
    return $unit_magnitude
}

#auxiliary proc, to not repeat code
proc ProblemtpeConvert::CreateFunctionItems { titles data xml_node_parent } {
    set fail 1
    set num_columns [llength $titles]
    set num_data [llength $data]
    if { [expr $num_data%$num_columns] != 0 } {
        set fail 1
        W "Error GRID with bad amount of data. $values $value"
    } else {
        set num_rows [expr $num_data/$num_columns] ;#must be multiple, but maybe is wrong...
        set xml_node_function [ProblemtpeConvert::XmlCreateElement $xml_node_parent function]
        set attributes [list n interpolator_func pn [join $titles ,] variable my_var units s]
        set xml_node_functionVariable [ProblemtpeConvert::XmlCreateElement $xml_node_function functionVariable $attributes]
        for {set i_row 0} {$i_row<$num_rows} {incr i_row} {
            set pos [expr $i_row*$num_columns]
            set point [lrange $data $pos [expr $pos+$num_columns-1]]
            set attributes [list n point pn Point v [join $point ,]]
            set xml_node_value [ProblemtpeConvert::XmlCreateElement $xml_node_functionVariable value $attributes]            
        }
    }
    return $fail
}

proc ProblemtpeConvert::CreateDependenciesItems { dependencies xml_node_parent } {
    if { [[$xml_node_parent parentNode] nodeName] == "condition" } {
        #find nodes to change by dependency only on this condition
        set find_path ..
    } else {
        #find everywhere
        set find_path /
    }
    foreach item $dependencies {
        set dependency [split [string range $item 1 end-1] ,]
        set value_original [lindex $dependency 0]
        set value [ProblemtpeConvert::DecoratePn $value_original]
        if { $value == "#DEFAULT#" } {
            #this mean a different value not listed in other dependencies
            set attributes [list default 1]
        } else {
            set attributes [list value $value]
        }
        foreach { do question_to_change_original value_to_set} [lrange $dependency 1 end] {
            set question [ProblemtpeConvert::TrimUnderline $question_to_change_original]
            lassign [ProblemtpeConvert::ParseCodedUnits $question] question units unit_magnitude
            if { $do == "TITLESTATE" } {
                lappend attributes node $find_path/container\[@n='$question'\]

            } else {
                lappend attributes node $find_path/value\[@n='$question'\]
            }
            set do [string toupper $do]
            if { $do == "HIDE" } {
                set state hidden
                lappend attributes att1 state v1 $state actualize_tree 1
            } elseif { $do == "RESTORE" } {
                set state normal
                lappend attributes att1 state v1 $state actualize_tree 1
            } elseif { $do == "SET" } {
                lappend attributes att1 v v1 $value_to_set actualize_tree 1
            } elseif { $do == "TITLESTATE" } {
                set title $question
                set state [string tolower $value_to_set]
                lappend attributes att1 state v1 $state actualize_tree 1
            } else {
                W "ignoring dependencies $do"
                continue
            }
            set xml_node_value [ProblemtpeConvert::XmlCreateElement $xml_node_parent dependencies $attributes]
        }
    }
    return 0
}

#auxiliary proc, to not repeat code
proc ProblemtpeConvert::CreateQuestionValueItems { new_problemtype_folder question_values other_fields xml_node_parent } {
    #fill arrays of other_fields
    array unset question_field_by_pos
    foreach {ftype fval fpos} $other_fields {
        set ftype [string toupper $ftype]
        if { [lsearch {BOOK DEPENDENCIES HELP IMAGE STATE TITLE TKWIDGET} $ftype] == -1 } {
            W "Unexpected ftype $ftype"
        }
        #lappend because could be more than one DEPENDENCIES with same pos
        lappend question_field_by_pos($fpos,$ftype) $fval
    }

    set index 0
    set xml_node_container_current $xml_node_parent
    foreach {question_full value} $question_values {        
        if { [info exists question_field_by_pos($index,TITLE)] } {
            set title [lindex $question_field_by_pos($index,TITLE) 0]
            set title [ProblemtpeConvert::TrimUnderline $title]
            set attributes [list n $title pn [ProblemtpeConvert::DecoratePn $title]]
            set xml_node_container_current [ProblemtpeConvert::XmlCreateElement $xml_node_parent container $attributes]
        }
        incr index
        #to decode from question_full the short name and other data like #CB#
        lassign [ParserType $question_full] type question_original values_original
        set question [ProblemtpeConvert::TrimUnderline $question_original]
        lassign [ProblemtpeConvert::ParseCodedUnits $question] question units unit_magnitude
        set values [list ]
        foreach item $values_original {
            lappend values [ProblemtpeConvert::DecoratePn $item]
        }
        set value [ProblemtpeConvert::DecoratePn $value]
        if { $type == "GRID" } {
            if { [lindex $value 0] != "#N#" } {
                set type "ENTRY"
            }
        }
        set attributes [list n $question pn [ProblemtpeConvert::DecoratePn $question]]
        if { $type == "GRID" } {
            set value [lrange $value 2 end]
        } else {
            lappend attributes v $value
        }
        if { $type == "ENTRY" } {
            #standart type
        } elseif { $type == "CB" } {
            if { [llength $values] == 0 } {
                #Iber trick to avoid decoration fields -- or IberPlus#CB#(_)
                continue
            }
            if { [llength $values] == 1 } {
                # Code_bright trick to avoid decoration fields with a combo with 1 option, like QUESTION: Forces#CB#(Nodal_forces_[MN])
                if { [lindex $values 0] == "" } {
                    continue
                }
            }
            lappend attributes values [join $values ,]
        } elseif { $type == "LA" } {
            W "Ignored question type=$type modifier ($question_full)"
        } elseif { $type == "MAT" } {
            W "Ignored question type=$type modifier ($question_full)"
        } elseif { $type == "FUNC" } {
            W "Ignored question type=$type modifier ($question_full)"
        } elseif { $type == "UNITS" } {
            W "Ignored question type=$type modifier ($question_full)"
        } elseif { $type == "GRID" } {
            if { [llength $values] > 0 } {
                lappend attributes function [list interpolator_func my_var [lindex $values 0] T] pn_function [join [lrange $values 1 end] ,]
            } else {
                W "WARNING question=$question has [llength $values] columns."
                lappend attributes v $value
            }
        } else {
            W "Unexpected question type=$type ($question_full)"
        }
        if { [info exists question_field_by_pos($index,HELP)] } {
            set help [lindex $question_field_by_pos($index,HELP) 0]
            lappend attributes help $help
        }
        if { [info exists question_field_by_pos($index,TKWIDGET)] } {
            set tkwidet_command [lindex $question_field_by_pos($index,TKWIDGET) 0]
            set command "GetCommaSepared[string totitle $question]"
            lappend attributes values "\[$command\]"
            W "proc $command {} { body... } must be implemented, returning a list of comma separed values (related to original proc $tkwidet_command)"
        }
        if { [info exists question_field_by_pos($index,IMAGE)] } {
            set image_original [lindex $question_field_by_pos($index,IMAGE) 0]
            #ignore image, has only sense if has small size (16x16) to be used as tree icon
            if { 0 } {
                lappend attributes icon [string tolower [file rootname [file tail $image_original]]]
                set source_folder [GidUtils::GiveProblemTypeFullname [GiD_Info project problemtype]].gid
                set source_filename [file join $source_folder $image_original]
                if { [file exists $source_filename] } {
                    if { [string tolower [file extension $source_filename]] != ".png" } {
                        #better if images are converted to 16x16 png
                        W "Better convert to 16x16 png image $source_filename"
                    }
                    set dest_folder [file join $new_problemtype_folder images]
                    if { ![file exists $dest_folder] } {
                        file mkdir $dest_folder
                    }
                    set dest_filename [file join $dest_folder [string tolower [file tail $image_original]]]
                    if { ![file exists $dest_filename] } {
                        file copy $source_filename $dest_filename
                    }
                }
            }
        }
        if { [info exists question_field_by_pos($index,STATE)] } {
            set state [string toupper [lindex $question_field_by_pos($index,STATE) 0]]
            if { $state == "HIDDEN" } {
                lappend attributes state hidden
            } elseif { $state == "DISABLED" } {
                W "Ignored state $state"
            } elseif { $state == "ENABLED" || $state == "NORMAL" } {
                #do nothing, it is the normal state
                #W "Ignored state $state"
            } else {
                W "Unexpected state $state"
            }
        }
        if { $units != "" } {
            lappend attributes units $units unit_magnitude $unit_magnitude
        }
        set xml_node_value [ProblemtpeConvert::XmlCreateElement $xml_node_container_current value $attributes]
        if { $type == "GRID" } {
            ProblemtpeConvert::CreateFunctionItems $values $value $xml_node_value
        }
        if { [info exists question_field_by_pos($index,DEPENDENCIES)] } {
            ProblemtpeConvert::CreateDependenciesItems $question_field_by_pos($index,DEPENDENCIES) $xml_node_value
        }
    }
    return 0
}

proc ProblemtpeConvert::WriteSpd { new_problemtype_folder filename_spd } {
    variable showed_message_unit_magnitude
    variable ovm
    set fail 0
    array unset showed_message_unit_magnitude
    set doc [dom parse "<cmas2d_customlib_data version='1.0'/>"]
    set root [$doc documentElement]
    set xml_node_style [ProblemtpeConvert::XmlCreateElement $root style [list show_menubutton_about 0 show_menubutton_search 1]]
    set xml_node_display_options [ProblemtpeConvert::XmlCreateElement $root display_options [list frame_width 151 is_frame_open 1]]
    set xml_node_display_units [ProblemtpeConvert::XmlCreateElement $root units]

    if { [lindex [GiD_Info gendata] 0] > 0 } {
        set books [list]
        foreach {book id} [GiD_Info gendata books] {
            lappend books $book
        }
        if { ![llength $books] } {
            #witout book are considered in book Default
            lappend books Default
        }
        if { [llength $books] > 1 } {
            #wiht only 1 book don't add an extra container
            set xml_node_container_general_data [ProblemtpeConvert::XmlCreateElement $root container [list n general_data pn "general data" icon general_data]]
        }
        foreach book_original $books {
            set book [ProblemtpeConvert::TrimUnderline $book_original]
            if { [llength $books] > 1 } {
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $xml_node_container_general_data container [list n $book pn [ProblemtpeConvert::DecoratePn $book]]]
            } else {
                if { $book == "Default" } {
                    set pn "general data"
                } else {
                    set pn $book
                }
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $root container [list n general_data pn [ProblemtpeConvert::DecoratePn $pn] icon general_data]]
            }
            set other_fields [lrange [GiD_Info gendata otherfields] 1 end]
            set question_values [lrange [GiD_Info gendata] 1 end]
            ProblemtpeConvert::CreateQuestionValueItems $new_problemtype_folder $question_values $other_fields $xml_node_container
        }
    }

    if { [lindex [GiD_Info intvdata] 0] > 0 } {
        set books [list]
        foreach {book id} [GiD_Info intvdata books] {
            lappend books $book
        }
        if { ![llength $books] } {
            #witout book are considered in book Default
            lappend books Default
        }
        if { [llength $books] > 1 } {
            #wiht only 1 book don't add an extra container
            set xml_node_container_interval_data [ProblemtpeConvert::XmlCreateElement $root container [list n interval_data pn "interval data" icon interval_data]]
        }
        foreach book_original $books {
            set book [ProblemtpeConvert::TrimUnderline $book_original]
            if { [llength $books] > 1 } {
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $xml_node_container_interval_data container [list n $book pn [ProblemtpeConvert::DecoratePn $book]]]
            } else {
                if { $book == "Default" } {
                    set pn "interval data"
                } else {
                    set pn $book
                }
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $root container [list n interval_data pn [ProblemtpeConvert::DecoratePn $pn] icon interval_data]]
            }
            set xml_node_interval_data_1 [ProblemtpeConvert::XmlCreateElement $xml_node_container blockdata [list n interval_data pn "interval data" name "interval data 1" sequence 1 editable_name unique]]
            set other_fields [lrange [GiD_Info intvdata otherfields] 1 end]
            set question_values [lrange [GiD_Info intvdata] 1 end]
            ProblemtpeConvert::CreateQuestionValueItems $new_problemtype_folder $question_values $other_fields $xml_node_interval_data_1
        }
    }

    set num_conditions 0
    foreach type {point line surface volume layer group} {
        set over over_$type
        incr num_conditions [llength [GiD_Info conditions $over]]
    }
    if { $num_conditions } {
        set books [list]
        foreach {book id} [GiD_Info conditions books] {
            lappend books $book
        }
        if { ![llength $books] } {
            #witout book are considered in book Default
            lappend books Default
        }
        if { [llength $books] > 1 } {
            #wiht only 1 book don't add an extra container
            set xml_node_container_conditions [ProblemtpeConvert::XmlCreateElement $root container [list n conditions pn conditions icon condition]]
        }
        foreach book_original $books {
            set book [ProblemtpeConvert::TrimUnderline $book_original]
            if { [llength $books] > 1 } {
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $xml_node_container_conditions container [list n $book pn $book]]
            } else {
                if { $book == "Default" } {
                    set pn conditions
                } else {
                    set pn $book
                }
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $root container [list n conditions pn [ProblemtpeConvert::DecoratePn $pn] icon condition]]
            }
            foreach type {point line surface volume layer group} {
                set over over_$type
                foreach condition [GiD_Info conditions $over] {
                    if { [GiD_Info conditions $condition book] == $book_original } {
                        set other_fields [lrange [GiD_Info conditions $condition otherfields] 1 end]
                        set condmeshtype [lindex [GiD_Info conditions $condition condmeshtype] 0]
                        if { ![info exists ovm($condmeshtype)] } {
                            set condmeshtype element
                            W "unexpected condmeshtype $condmeshtype for condition $condition. Considered over element"
                            continue
                        }
                        set attributes [list n $condition pn [ProblemtpeConvert::DecoratePn $condition] ov $type ovm $ovm($condmeshtype)]
                        #icon="boundary"
                        set xml_node_condition [ProblemtpeConvert::XmlCreateElement $xml_node_container condition $attributes]
                        set question_values [lrange [GiD_Info conditions $condition] 2 end]
                        ProblemtpeConvert::CreateQuestionValueItems $new_problemtype_folder $question_values $other_fields $xml_node_condition
                    }
                }
            }
        }
    }

    if { [llength [GiD_Info materials]] } {
        set books [list]
        foreach {book id} [GiD_Info materials books] {
            lappend books $book
        }
        if { ![llength $books] } {
            #witout book are considered in book Default
            lappend books Default
        }
        if { [llength $books] > 1 } {
            #wiht only 1 book don't add an extra container
            set xml_node_container_materials [ProblemtpeConvert::XmlCreateElement $root container [list n materials pn materials icon material]]
        }
        foreach book_original $books {
            set book [string trim $book_original _]
            if { [llength $books] > 1 } {
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $xml_node_container_materials container [list n $book pn [ProblemtpeConvert::DecoratePn $book]]]
            } else {
                if { $book == "Default" } {
                    set pn materials
                } else {
                    set pn $book
                }
                set xml_node_container [ProblemtpeConvert::XmlCreateElement $root container [list n materials pn [ProblemtpeConvert::DecoratePn $pn] icon material]]
            }
            foreach material [GiD_Info materials] {
                if { [GiD_Info materials $material book] == $book_original } {
                    set other_fields [lrange [GiD_Info materials $material otherfields] 1 end]
                    set attributes [list n material name $material sequence 1 editable_name unique allow_import 1]
                    #icon="boundary"
                    set xml_node_material [ProblemtpeConvert::XmlCreateElement $xml_node_container blockdata $attributes]
                    set question_values [lrange [GiD_Info materials $material] 1 end]
                    ProblemtpeConvert::CreateQuestionValueItems $new_problemtype_folder $question_values $other_fields $xml_node_material
                }
            }
        }
    }

    ProblemtpeConvert::WriteDocAsXml $doc $filename_spd

    return $fail
}

proc ProblemtpeConvert::CopyIconsToImagesFolder { new_problemtype_folder } {
    set source_folder [file join [ gid_themes::GetThemesBaseFolder] GiD_classic images small_size(16andmore)]
    set dest_folder [file join $new_problemtype_folder images]
    if { ![file exists $dest_folder] } {
        file mkdir $dest_folder
    }
    foreach filename {condition.png general_data.png material.png} {
        set dest_filename [file join $dest_folder $filename]
        if { ![file exists $dest_filename] } {
            set source_filename [file join $source_folder $filename]
            file copy $source_filename $dest_filename
        }
    }
    return 0
}

proc ProblemtpeConvert::ReadAndWriteXmlInfoproblemtype { new_problemtype_folder } {
    package require tdom
    set problemtype_name [file rootname [file tail $new_problemtype_folder]]
    set xmlfile [GidUtils::GiveFileInsideProblemType [GiD_Info project problemtype] .xml 1]
    if { $xmlfile != ""} {
        set xml [tDOM::xmlReadFile $xmlfile]
    } else {
        set xml "<Infoproblemtype version='1.0'><Program><Name>$problemtype_name</Name><Version>0.1</Version><MinimumGiDVersion>14.1.8d</MinimumGiDVersion></Program></Infoproblemtype>"
    }
    set doc [dom parse $xml]
    set root [$doc documentElement]
    if { [$root nodeName] == "Infoproblemtype" } {
        set xml_node_program [$root selectNodes Program]
        set xml_node_minimumgidversion [$root selectNodes Program/MinimumGiDVersion]
        set text_node [$xml_node_minimumgidversion childNodes]
        set current_value [$text_node nodeValue]
        if { [GidUtils::TwoVersionsCmp $current_value 14.1.8d] < 0 } {
            $text_node nodeValue 14.1.8d
        }
        foreach {key value} {CustomLibAutomatic 1 CustomLibNativeGroups 1} {
            set xml_node [$root selectNodes Program/$key]
            if { [llength $xml_node] } {
                set text_node [$xml_node childNodes]
                $text_node nodeValue 1
            } else {
                set xml_node [ProblemtpeConvert::XmlCreateElementInsertAfter $xml_node_program $xml_node_minimumgidversion $key]
                ProblemtpeConvert::XmlCreateTextNode $xml_node 1
            }
        }

        set file_out [file join $new_problemtype_folder $problemtype_name.xml]
        ProblemtpeConvert::WriteDocAsXml $doc $file_out
    } else {
        error "'$xmlfile' is not a Infoproblemtype valid file"
    }
    return 0
}

proc ProblemtpeConvert::Write { new_problemtype_folder } {
    if { ![file exists $new_problemtype_folder] || ![file isdirectory $new_problemtype_folder] } {
        file mkdir $new_problemtype_folder
    }
    set problemtype_name [file rootname [file tail $new_problemtype_folder]]
    set file_spd [file join $new_problemtype_folder $problemtype_name.spd]
    ProblemtpeConvert::WriteSpd $new_problemtype_folder $file_spd
    ProblemtpeConvert::CopyIconsToImagesFolder $new_problemtype_folder
    ProblemtpeConvert::ReadAndWriteXmlInfoproblemtype $new_problemtype_folder
}

#-np- SRC gid_problemtype_convert
#-np- ProblemtpeConvert::Write {C:\gid_project\problemtypes\kk_iber.gid}
#-np- ProblemtpeConvert::Write {C:\gid_project\problemtypes\kk_cb.gid}
