
namespace eval GidNotifications {
    set _service      https
    set _host         notifications.gidsimulation.com
    variable _timeout 10000 ;#milliseconds
}

proc GidNotifications::getHostUrl { } {
    variable _service
    variable _host
    return "${_service}://${_host}"
}

proc GidNotifications::package_require_http {} {
    package require http
    package require tls
    if { [info exists ::env(http_proxy)] || [info exists ::env(https_proxy)] } {
        package require autoproxy
        autoproxy::init
        # it seems that here -autoservername 1 option is not valid
        http::register https 443 [list autoproxy::tls_socket]
    } else {
        http::register https 443 [list ::tls::socket -autoservername 1]
    }
}

#http::geturl trick, -query == POST , otherwise is GET
#type could be application/json
proc GidNotifications::http_post { cgi query headers {type ""} } {
    variable _timeout
    if { $query == "" } {
        #force non-empty query to do a post
        set query "dummy=dummy"
    }
    if { $type != "" } {
        set token [http::geturl $cgi -query $query -headers $headers -type $type -timeout $_timeout]
    } else {
        set token [http::geturl $cgi -query $query -headers $headers -timeout $_timeout]
    }
    set data [http::data $token]
    http::cleanup $token
    return $data
}

#http::geturl trick, -query == POST , otherwise is GET
proc GidNotifications::http_get { cgi query headers } {
    variable _timeout
    set token [http::geturl $cgi?$query -headers $headers -timeout $_timeout]
    set data [http::data $token]
    http::cleanup $token    
    return $data
}

proc GidNotifications::http_get_async { cgi query headers callback } {
    variable _timeout
    set token [http::geturl $cgi?$query -headers $headers -timeout $_timeout -command $callback ]
    return $token
}

#admin_token must be? it is not a login token or a user token.
#params is a JSON string with the parameters that expects class_id that is one of the predefined (Test, DataManagerShareModel, DataManagerUserOverQuota)
proc GidNotifications::sendNotificationPredefined { admin_token user_id class_id params } {
    GidNotifications::package_require_http
    set cgi [GidNotifications::getHostUrl]/v1/automatic_notifications
    dict set headers Authorization "Bearer $admin_token"
    set query [eval http::formatQuery [list account_id $user_id  class_id $class_id params $params]]    
    set type application/x-www-form-urlencoded    
    return [GidNotifications::http_post $cgi $query $headers $type]
}

proc GidNotifications::sendNotificationPredefined_Test { admin_token user_id params_username } {
    set class_id Test
    set params [GidNotifications::format_query_json [list username $params_username]]
    return [GidNotifications::sendNotificationPredefined $admin_token $user_id $class_id $params]
}

proc GidNotifications::sendNotificationPredefined_MesherError { admin_token user_id params_model_name params_mesher_error_text} {
    set class_id MesherError
    set params [GidNotifications::format_query_json [list model_name $params_model_name mesher_error_text $params_mesher_error_text]]
    return [GidNotifications::sendNotificationPredefined $admin_token $user_id $class_id $params]
}

proc GidNotifications::sendNotificationPredefined_CalculationError { admin_token user_id params_model_name params_calculation_error_text} {
    set class_id CalculationError
    set params [GidNotifications::format_query_json [list model_name $params_model_name calculation_error_text $params_calculation_error_text]]
    return [GidNotifications::sendNotificationPredefined $admin_token $user_id $class_id $params]
}

proc GidNotifications::format_query_json { list_key_values } {
    package require json::write
    set list_key_values_quoted [list]
    foreach {key value} $list_key_values {
        lappend list_key_values_quoted $key \"$value\"
    }
    return [json::write object {*}$list_key_values_quoted]
}

proc GidNotifications::base64_url_decode { input } {
    set input [string map {- + _ /} $input]
    set x [expr [string length $input]%4]
    if { $x == 2 } {
        append input ==
    } elseif { $x == 3 } {
        append input =
    }
    return [binary decode base64 $input]
}

proc GidNotifications::getUserIdFromUserToken { json_token } {
    set user_id ""
    set token_list [split $json_token .]
    if { [llength $token_list] == 3 } {
        package require json
        lassign $token_list header payload signature
        set payload_decoded [GidNotifications::base64_url_decode $payload]
        set payload_dict [::json::json2dict $payload_decoded]
        set user_id [dict get $payload_dict user id]
    }
    return $user_id
}

proc GidNotifications::getCurrentUserId { } {
    set user_id ""
    if { [GiD_Login is_logged] } {
        set json_token [GiD_Login logged_user_token]
        set user_id [GidNotifications::getUserIdFromUserToken $json_token]
    }
    return $user_id
}

#this is hardcoded for test only, must be deleted...
proc GidNotifications::getCurrentAdminToken { } {
    set admin_token {eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzZXNzaW9uX2lkIjoiNTA2YjJjNWQtNGE5OS00MmQyLThkZjctMjFiMThjNWUxMGE0IiwidXNlciI6eyJpZCI6Ijg3NzAwMzQwLWUzNjktNDQ1Yi1iOThiLWI1MmVkZDU2ZTY4NCIsImVtYWlsIjoibm9yZXBseUBnaWRzaW11bGF0aW9uLmNvbSJ9LCJkYW1hX2p3dCI6ImV5SmhiR2NpT2lKRlV6STFOaUlzSW5SNWNDSTZJa3BYVkNKOS5leUoxYVdRaU9pSm9NMEZFVVU5T2NGSkdkVFZwTjFWMU0xWmliV2hCUFQwNmJtOXlaWEJzZVVCbmFXUnphVzExYkdGMGFXOXVMbU52YlNJc0ltVjRjQ0k2TVRZMk1Ea3lOalV3TkgwLjd4YVZmbzQwX2ViR1hLRmlhQVd4VkxvUVZ4Qi1ubFRKX1E2NmtwUjRUZnBTbTdYLWpSOGlaTUZPdGl6cTZSeXVfbzVNVDdOeUlFX2Zjb3ptVkJTVURnIiwidmVyc2lvbiI6MSwibWFjaGluZV9pZCI6IjFhZWNiMTE2LTNmY2EtNDE0Ni04MWIwLTJlZTVlMzY2M2QxZCIsIm1hY2hpbmVfbmFtZSI6Im1lZGlhZG9yIiwiaXAiOiIxNDcuODMuMTQzLjI0OCIsImZpbmdlcnByaW50IjoiNTVhMGEwMjYwZjA2MjE1YiIsImV4cCI6MTY1ODQyMDkwNCwic2VydmVyX2N1cnJlbnRfdGltZSI6MTY1ODMzNDUwNH0.C8zaBO9q06Ybonq2LvmiTDSyC4bU2Gv-_oXdwQJWdXMQp7CeQpjplvZ5L6TOIde2cEfQLKi8bxA5qH426Q9FNcMEFrqrVz7eTJHH2vKz70WDYNXsMZMbvc_ZRHI386wsIomxfCzf2W_s_LcVDekTIYhxqvAKKjW8wu84zHx13ylmeC522556C-QkS5Qe7fnpAiB-T1fuZfJW04MHG4IsK1A3r6_DTn3vv2xrGdtlLg4WdpXoesT3KyBtyjwN3MO2CzlxCD5dAYE1331F8csNkYXsepCHQcEBTs0SRrwuwa3ukn8abHgPls_9fJQo_4mjarNCYJJRGNch5oP4Yirmtw}
    return $admin_token
}

proc GidNotifications::getCurrentAdminTokenFromEnv { } {
    set admin_token ""
    if { [info exists ::env(GID_NOTIFICATION_TOKEN)] } {
        set admin_token $::env(GID_NOTIFICATION_TOKEN)
    }
    return $admin_token
}

proc GidNotifications::doTest { } {
    set user_id [GidNotifications::getCurrentUserId]
    if { $user_id != "" } {
        set admin_token [GidNotifications::getCurrentAdminToken]
        if { $admin_token != "" } {
            #GidNotifications::sendNotificationPredefined_Test $admin_token $user_id hola@cimne.upc.edu
            GidNotifications::sendNotificationPredefined_MesherError $admin_token $user_id "my GiD model" "error meshing volume 45 near coordinate 0.5,0,0"
            #GidNotifications::sendNotificationPredefined_CalculationError $admin_token $user_id "my other model" "error calculating"
        }
    }
    return 0
}
