namespace eval GidMeshCloudClient {
    #variable _service      http
    #variable _host         localhost:3000
    #variable _host         localhost:3100 ;#to try to connec to my C:\gid_project\scripts\test_port_forwarding.tcl and see the traffic
    variable _service      https
    #variable _host         mesh.gidsimulation.com
    variable _host         mesh.gidsimulation.com
    variable _timeout 600000 ;#milliseconds -> 10 minutes for big files
    #set _bound "----WebKitFormBoundary7MA4YWxkTrZu0gW"
    variable _bound "--------------------------303482403838279099613722"

    # check env
    set _host_env ""
    if { [ info exists ::env(GID_MESHER_HOSTNAME)]} {
        set _host_env $::env(GID_MESHER_HOSTNAME)
    } 
    if { $_host_env != ""} {
        set _host $_host_env
    }
}

proc GidMeshCloudClient::getHostUrl { } {
    variable _service
    variable _host
    return "${_service}://${_host}"
}

proc GidMeshCloudClient::package_require_http {} {
    package require http
    package require tls
    package require promise
    if { [info exists ::env(http_proxy)] || [info exists ::env(https_proxy)] } {
        package require autoproxy
        autoproxy::init
        # it seems that here -autoservername 1 option is not valid
        http::register https 443 [list autoproxy::tls_socket]
    } else {
        http::register https 443 [list ::tls::socket -autoservername 1]
    }
}

#http::geturl trick, -query == POST , otherwise is GET
#type could be application/json
proc GidMeshCloudClient::http_post { url query headers {type "application/x-www-form-urlencoded"} } {
    variable _timeout
    set err 0
    set err_txt ""
    if { $query == "" } {
        #force non-empty query to do a post
        set query "dummy=dummy"
    }
    set err [catch {
        set token [http::geturl $url -query $query -headers $headers -type $type -timeout $_timeout -binary 1]
    } err_txt ]
    if { $err } {
        set body ""
        GidUtils::SetWarnLine "Debug: error http_post, url: $url. $err_txt"
    } else {
        upvar #0 $token state
        set http_code [lindex $state(http) 1]
        set body $state(body)
        http::cleanup $token
        if { $http_code != 200 } {
            #error [list http_code $http_code body $body]
            set body ""
            GidUtils::SetWarnLine "Debug: error http_post, url: $url. http_code $http_code body $body"
        }
    }
    return $body
}

#http::geturl trick, -query == POST , otherwise is GET
proc GidMeshCloudClient::http_get { url query headers } {
    variable _timeout
    set err 0
    set err_txt ""
    set err [catch {
        set token [http::geturl $url?$query -headers $headers -timeout $_timeout]
    } err_txt ]
    if { $err } {
        set body ""
        GidUtils::SetWarnLine "Debug: error http_get, url: $url. $err_txt"
    } else {
        upvar #0 $token state
        set http_code [lindex $state(http) 1]
        set body $state(body)
        http::cleanup $token
        if { $http_code != 200 } {
            #error [list http_code $http_code body $body]
            set body ""
            GidUtils::SetWarnLine "Debug: error http_get, url: $url. http_code $http_code body $body"
        }
    }
    return $body
}

proc GidMeshCloudClient::http_get_async { url query headers callback } {
    variable _timeout
    set token ""
    set err 0
    set err_txt ""
    set err [catch {
        set token [http::geturl $url?$query -headers $headers -timeout $_timeout -command $callback ]
    } err_txt ]
    if { $err } {
        set token ""
        GidUtils::SetWarnLine "Debug: error http_get_async, url: $url. http_code $http_code body $body"
    }
    return $token
}

# see https://code.activestate.com/recipes/109363-http-posting-w-file-upload/

#Content-Type: application/octet-stream${endln}
proc GidMeshCloudClient::http_fill_body_form-data { form_elems_and_values file_form_elem_and_filenames} {
    variable _bound
    set body {}
    if { $::tcl_platform(platform) == "windows" } {
        set endln "\r\n"
    } else {
        #maybe must use \n only, I have tested only in Windows by now?
        set endln "\r\n"
    }
    foreach {key value} $form_elems_and_values {
        append body "--${_bound}${endln}Content-Disposition: form-data;\
            name=\"$key\"${endln}${endln}$value${endln}"
    }
    lassign $file_form_elem_and_filenames file_form_elem filenames
    foreach filename $filenames {
        set ext [string tolower [file extension $filename]]
        if { $ext == ".zip" } {
            #it seems that otherwise complain trying to upload a zip file!!
            set content_type application/zip
        } else {
            set content_type application/octet-stream
        }
        set file_data [GidUtils::ReadFile $filename "" 1]
        append body "--${_bound}${endln}Content-Disposition: form-data;\
            name=\"$file_form_elem\"; filename=\"[file tail $filename]\"${endln}Content-Type: ${content_type}${endln}${endln}$file_data${endln}"
    }
    append body "--${_bound}--"
    return $body
}

#do a zip and upload a single file (upload by now at neco.gidsimulation.com of the logged user)
proc GidMeshCloudClient::UploadFolderZippedNextcloud { dirname } {
    package require gid_cross_platform    
    set tmp_folder tmp_remote_mesh
    GidDataManager::directCheckAndCreateFolderPath $tmp_folder
    set tmp_zipname [gid_cross_platform::get_unused_tmp_filename remote_mesh .zip]
    gid_cross_platform::gid_zip $tmp_zipname $dirname 0
    #really instead provide this remote_path filename an automatic non-existent name must be used
    set remote_filename [file join $tmp_folder [file tail $tmp_zipname]]
    GidDataManager::directUploadData $remote_filename [GidUtils::ReadFile $tmp_zipname "" 1]
    file delete $tmp_zipname
    return $remote_filename
}

proc GidMeshCloudClient::UploadFolderNextcloud { dirname } {
    package require gid_cross_platform
    set tmp_folder tmp_remote_mesh
    GidDataManager::directCheckAndCreateFolderPath $tmp_folder
    #really instead provide this destination filename an automatic non-existent name must be used
    set remote_path [file join $tmp_folder [file tail $dirname]]
    GidDataManager::directCheckAndCreateFolderPath $remote_path
    #copy only files on this directory, not its folders
    set promises [list]
    foreach filename_tail [glob -tails -nocomplain -directory $dirname -types f *] {
        set filename [file join $dirname $filename_tail]
        set remote_filename [file join $remote_path $filename_tail]
        #GidDataManager::directUploadData $remote_path [GidUtils::ReadFile $filename "" 1]
        lappend promises [GidDataManager::pUploadData $remote_filename [GidUtils::ReadFile $filename "" 1]]
    }
    set p [promise::all $promises]
    $p done
    return $remote_path
}

proc GidMeshCloudClient::UploadFilesS3 { user_token filenames model_name } {
    variable _bound
    set json_res ""
    set url [GidMeshCloudClient::getHostUrl]/v1/model_push/files
    dict set headers Authorization "Bearer $user_token"
    set form_elems_and_values [list model_name $model_name]
    set file_form_elem_and_filenames [list model_files $filenames]
    set body [GidMeshCloudClient::http_fill_body_form-data $form_elems_and_values $file_form_elem_and_filenames]
    set type "multipart/form-data; boundary=$_bound"
    set json_res [GidMeshCloudClient::http_post $url $body $headers $type]
    return $json_res
}

#by now not recursive, only the files on this dirname
proc GidMeshCloudClient::UploadFolderS3 { user_token dirname } {
    set json_res ""
    set filenames [glob -nocomplain -directory $dirname -types f *]
    if { [llength $filenames] } {
        set model_name [file tail $dirname]
        set json_res [GidMeshCloudClient::UploadFilesS3 $user_token $filenames $model_name]
    }
    return $json_res
}

proc GidMeshCloudClient::UploadZipS3 { user_token zipfile model_name } {
    variable _bound
    set json_res ""    
    set url [GidMeshCloudClient::getHostUrl]/v1/model_push/zip
    dict set headers Authorization "Bearer $user_token"
    set form_elems_and_values [list model_name $model_name]
    set filenames [list $zipfile]
    set file_form_elem_and_filenames [list zip_file $filenames]
    set body [GidMeshCloudClient::http_fill_body_form-data $form_elems_and_values $file_form_elem_and_filenames]
    set type "multipart/form-data; boundary=$_bound"
    set json_res [GidMeshCloudClient::http_post $url $body $headers $type]
    return $json_res
}

proc GidMeshCloudClient::UploadFolderZippedS3 { user_token dirname } {
    package require gid_cross_platform    
    set tmp_zipname [gid_cross_platform::get_unused_tmp_filename remote_mesh .zip]
    gid_cross_platform::gid_zip $tmp_zipname $dirname 0    
    set model_name [file tail $dirname]
    set json_res [GidMeshCloudClient::UploadZipS3 $user_token $tmp_zipname $model_name]    
    file delete $tmp_zipname
    return $json_res
}

#expect the model to be meshed located at NextCloud account of the user
#admin_token must be? it is not a login token or a user token.
#params is a JSON string with the parameters that expects class_id that is one of the predefined (Test, DataManagerShareModel, DataManagerUserOverQuota)
proc GidMeshCloudClient::GenerateMeshNextCloud { user_token model_name result_location mesh_size preferences_from meshing_parameters } {
    set url [GidMeshCloudClient::getHostUrl]/v1/mesh_model/cloud
    dict set headers Authorization "Bearer $user_token"
    set query_items [list model_name $model_name  result_location $result_location mesh_size $mesh_size preferences_from $preferences_from]
    if { [llength $meshing_parameters] } {
        package require json::write
        lappend query_items meshing_parameters [json::write object {*}$meshing_parameters]
    }
    set query [eval http::formatQuery $query_items]
    set type application/x-www-form-urlencoded
    return [GidMeshCloudClient::http_post $url $query $headers $type]
}


#expect the model to be meshed uploaded to S3 with GidMeshCloudClient::UploadFolderS3 that return <push_id>
proc GidMeshCloudClient::GenerateMeshS3 { user_token push_id result_location mesh_size preferences_from meshing_parameters } {
    set url [GidMeshCloudClient::getHostUrl]/v1/mesh_model/uploaded
    dict set headers Authorization "Bearer $user_token"   
    set query_items [list push_id $push_id result_location $result_location mesh_size $mesh_size preferences_from $preferences_from]
    if { [llength $meshing_parameters] } {
        package require json::write
        lappend query_items meshing_parameters [json::write object {*}$meshing_parameters]
    }
    set query [eval http::formatQuery $query_items]
    set type application/x-www-form-urlencoded
    return [GidMeshCloudClient::http_post $url $query $headers $type]
}

proc GidMeshCloudClient::GetStatus { user_token task_id } {
    set url [GidMeshCloudClient::getHostUrl]/v1/status/$task_id
    dict set headers Authorization "Bearer $user_token"
    set query [eval http::formatQuery [list ]]
    return [GidMeshCloudClient::http_get $url $query $headers]
}

#return the content of a zip file with the results of the mesher
proc GidMeshCloudClient::GetResult { user_token task_id } {
    set url [GidMeshCloudClient::getHostUrl]/v1/mesh_model/result/$task_id
    dict set headers Authorization "Bearer $user_token"
    set query [eval http::formatQuery [list ]]
    return [GidMeshCloudClient::http_get $url $query $headers]
}

#get result and save as file
proc GidMeshCloudClient::GetResultFile { user_token task_id local_filename } {
    set fail 1
    set err [ catch {
        set data [GidMeshCloudClient::GetResult $user_token $task_id ]
    } err_txt]
    if { $err} {
        # return error code message
        set data $err_txt
    } else {
        set err [ catch {
            set fp [open $local_filename "wb"]
        } err_txt]
        if { $err} {
          # return error code message
        } else {
            puts -nonewline $fp $data
            close $fp
            set fail 0
        }
    }
    return $fail
}

proc GidMeshCloudClient::DeleteFolderNextcloud { remote_path } {
    #GidDataManager::directDeletePath -force $remote_path
    #do it asynchronous, return a promise
    set p [GidDataManager::pDeletePath $remote_path]
    $p done
    return 0
}

#in case of delete uploaded files id is push_id, in case of delete results files is task_id
proc GidMeshCloudClient::DeleteFolderS3 { user_token id is_result } {
    if { $is_result } {
        set url [GidMeshCloudClient::getHostUrl]/v1/model_push/delete_result/$id
    } else {
        set url [GidMeshCloudClient::getHostUrl]/v1/model_push/delete/$id
    }
    dict set headers Authorization "Bearer $user_token"
    set type application/x-www-form-urlencoded
    set p [promise::pgeturl $url -headers $headers -type $type -method POST]
    $p done
}

proc GidMeshCloudClient::FileExistsNextcloud { remote_result_filename } {
    return [GidDataManager::directFileExists $remote_result_filename]
}

proc GidMeshCloudClient::DownloadFileNextcloud { remote_filename local_filename } {
    return [GidDataManager::directDownloadFile $remote_filename local_filename]
}

#can try to implement to download files asynchronous and in parallel with promises, but is a difficult syntax by now...
proc GidMeshCloudClient::DownloadExistentFilesNextcloud { remote_results tmp_folder_out } {
    set fail 0
    set local_filename_without_ext [file join $tmp_folder_out [file rootname [file tail $tmp_folder_out]]]
    set list_remote_and_local_filenames [list]
    #to read the files if exists in this order
    set types {mesh_local_axes mesh mesh_groups mesh_conditions}
    set extensions {.lax .msh .prj .lin}
    foreach type $types ext $extensions {
        set remote_result_filename ${remote_results}$ext
        set local_filename ${local_filename_without_ext}$ext
        lappend list_remote_and_local_filenames [list $remote_result_filename $local_filename]
    }
    foreach item $list_remote_and_local_filenames {
        lassign $item remote_result_filename local_filename
        if { [GidMeshCloudClient::FileExistsNextcloud $remote_result_filename] } {
            GidDataManager::directDownloadFile $remote_result_filename $local_filename
        }
    }
    return $fail
}

proc GidMeshCloudClient::DownloadExistentFilesS3 { user_token task_id tmp_folder_out } {
    set fail 0
    package require gid_cross_platform
    package require zipfile::decode
    set tmp_filename_zip [gid_cross_platform::get_unused_tmp_filename remote_mesh .zip]
    set fail [GidMeshCloudClient::GetResultFile $user_token $task_id $tmp_filename_zip]
    if { $fail } {
        
    } else {
        if { [file exists $tmp_filename_zip] } {
            gid_cross_platform::gid_unzip $tmp_filename_zip $tmp_folder_out 0
            file delete $tmp_filename_zip
        } else {
            set fail 1
        }
    }
    return $fail
}

proc GidMeshCloudClient::UserStop { user_token task_id } {
    set url [GidMeshCloudClient::getHostUrl]/v1/mesh_model/stop/$task_id
    dict set headers Authorization "Bearer $user_token"
    set type application/x-www-form-urlencoded
    set p [promise::pgeturl $url -headers $headers -type $type -method POST]
    $p done
}


#the saved files with be named with the same name as the folder_gid
proc GidMeshCloudClient::SaveInputFiles { folder_gid } {
    set fail 0
    set local_filename_without_ext [file join $folder_gid [file rootname [file tail $folder_gid]]]
    set types {geometry_local_axes geometry geometry_groups geometry_conditions materials conditions units}
    set extensions {.lax .geo .prj .lin .mat .cnd .uni}
    foreach type $types ext $extensions {
        set local_filename ${local_filename_without_ext}$ext
        GiD_Project db save $type $local_filename
    }
    return $fail
}

#to import in GiD the files with data affected by the generated mesh, the files must be returned by the mesher service
proc GidMeshCloudClient::ReadOutputFiles { folder_files } {
    set fail 0
    set local_filename_msh [glob -nocomplain -directory $folder_files -types f *.msh]
    if { [llength $local_filename_msh] == 1 } {
        set local_filename_without_ext [file rootname [lindex $local_filename_msh 0]]
    } else {
        set fail 1
    }
    #to read the files if exists in this order
    set types {mesh_local_axes mesh mesh_groups mesh_conditions}
    set extensions {.lax .msh .prj .lin}
    set datasets {LOCAL_AXES_DATASET MESH_DATASET GROUP_ENTITIES_DATASET CONDITION_ENTITIES_DATASET}
    set num_files_read 0
    foreach type $types ext $extensions dataset $datasets {
        set local_filename ${local_filename_without_ext}$ext
        if { [file exists $local_filename] } {
            set err [catch {
                GiD_Project db read $type $local_filename
            } err_msg]
            if { $err } {
                set fail 1
                W "GidMeshCloudClient::ReadOutputFiles. Error GiD_Project db read $type '$local_filename'. $err_msg"
            } else {
                GiD_Project set changes_dataset $dataset 1
                incr num_files_read
            }
        }
    }
    if { !$num_files_read } {
        set fail 1
    }
    return $fail
}

# this proc must be called by the GiD of the mesher service when the mesh is generated, to export the files to be sent to client
# <folder_gid> must exists and be emtpy, the filenames will inherit the folder name
proc GidMeshCloudClient::SaveOutputFiles { folder_gid } {
    set fail 0
    set local_filename_without_ext [file join $folder_gid [file rootname [file tail $folder_gid]]]
    #to write the files if will have some information, unneeded empty files won't be created
    set types {mesh_local_axes mesh mesh_groups mesh_conditions}
    set extensions {.lax .msh .prj .lin}
    set num_files 0
    foreach type $types ext $extensions {
        set local_filename ${local_filename_without_ext}$ext
        GiD_Project db save $type $local_filename
        if { [file exists $local_filename] } {
            incr num_files
        }
    }
    if { !$num_files } {
        #consider as fail save an empty model
        set fail 1
    }
    return $fail
}
