#auxiliary procs to rewrite sorted the code of procs _event_args_init and _event_deprecated_args_init (to facilitate human search)
proc _events_print_sorted { } {
    foreach event_name [GiD_Info events] {
        W "set ::_event_args($event_name) [list $::_event_args($event_name)]"
    }
}

proc _events_deprecated_print_sorted { } {
    foreach event_name [GiD_Info events -deprecated] {
        W "set ::_event_deprecated_map_to($event_name) [list $::_event_deprecated_map_to($event_name)]"
    }
}

proc _events_check_consistency { } {
    foreach event_name [GiD_Info events -deprecated] {
        set new_name $::_event_deprecated_map_to($event_name)
        if { ![info exists ::_event_args($new_name)] } {
            if { $event_name == "LoadFileInGidUnknowExtension" && $new_name == ""} {
                #there is not new event name, must use GiD_RegisterExtensionProc instead
            } else {
                W "error, ::_event_args($new_name) doesn't exists"
            }
        }
    }
}

#part of GiD_Info implemented at tcl level instead of C++ level: 
#invoked by: "GiD_Info events -args $event_name"
#necessary to know the prototype, because probably the proc already doesn't exists to allow use standard "info args $proc_name"
#and necessary also to use GiD_RegisterEvent to register procs to be called by events

proc _event_args_init {} {
    array unset ::_event_args
    set ::_event_args(GiD_Event_AfterAssignMaterial) {name level_type}
    set ::_event_args(GiD_Event_AfterChangeBackground) {}
    set ::_event_args(GiD_Event_AfterChangeCondition) {name changed_fields}
    set ::_event_args(GiD_Event_AfterChangeCoordinates) coordinates
    set ::_event_args(GiD_Event_AfterChangeGraph) {name property}
    set ::_event_args(GiD_Event_AfterChangeGraphSet) {name property}
    set ::_event_args(GiD_Event_AfterChangeGroup) {name property}
    set ::_event_args(GiD_Event_AfterChangeLayer) {name property}
    set ::_event_args(GiD_Event_AfterChangeLayersOrSets) {num_sets num_off num_back num_transparent}
    set ::_event_args(GiD_Event_AfterChangeLicence) {password_mode password_type password_expiration}    
    set ::_event_args(GiD_Event_AfterChangeLicenceStatus) status
    set ::_event_args(GiD_Event_AfterChangeMaterial) {name changed_fields}
    set ::_event_args(GiD_Event_AfterChangeMesh) {num_nodes num_elements}
    set ::_event_args(GiD_Event_AfterChangeModelUnitSystem) {old_unit_system new_unit_system}
    set ::_event_args(GiD_Event_AfterChangeParentGroup) {old_name new_name}
    set ::_event_args(GiD_Event_AfterChangeParentLayer) {old_name new_name}
    set ::_event_args(GiD_Event_AfterChangeProblemtype) {old_problemtype new_problemtype}
    set ::_event_args(GiD_Event_AfterChangeRenderMode) render_mode
    set ::_event_args(GiD_Event_AfterChangeViewMode) use_of
    set ::_event_args(GiD_Event_AfterChangeZoomFactor) zoom_factor
    set ::_event_args(GiD_Event_AfterCopy) {use_of transformation error}
    set ::_event_args(GiD_Event_AfterCreateCondition) name
    set ::_event_args(GiD_Event_AfterCreateCutSet) name
    set ::_event_args(GiD_Event_AfterCreateDimension) num
    set ::_event_args(GiD_Event_AfterCreateGraph) name
    set ::_event_args(GiD_Event_AfterCreateGraphSet) name
    set ::_event_args(GiD_Event_AfterCreateGroup) name
    set ::_event_args(GiD_Event_AfterCreateInterval) num
    set ::_event_args(GiD_Event_AfterCreateLayer) name
    set ::_event_args(GiD_Event_AfterCreateLine) num
    set ::_event_args(GiD_Event_AfterCreateMaterial) name
    set ::_event_args(GiD_Event_AfterCreatePoint) num
    set ::_event_args(GiD_Event_AfterCreateSurface) num
    set ::_event_args(GiD_Event_AfterCreateSurfaceSet) name
    set ::_event_args(GiD_Event_AfterCreateTopMenus) {}
    set ::_event_args(GiD_Event_AfterCreateVolume) num
    set ::_event_args(GiD_Event_AfterCreateVolumeSet) name
    set ::_event_args(GiD_Event_AfterDataManagerConnect) path
    set ::_event_args(GiD_Event_AfterDataManagerDisconnect) {}
    set ::_event_args(GiD_Event_AfterDataManagerSetCloudFolder) path
    set ::_event_args(GiD_Event_AfterDeleteGraph) name
    set ::_event_args(GiD_Event_AfterDeleteGraphSet) name
    set ::_event_args(GiD_Event_AfterDeleteGroup) name
    set ::_event_args(GiD_Event_AfterDeleteInterval) num
    set ::_event_args(GiD_Event_AfterDeleteLayer) name
    set ::_event_args(GiD_Event_AfterDrawModel) {}
    set ::_event_args(GiD_Event_AfterDrawPointsPost) {}
    set ::_event_args(GiD_Event_AfterEndCommand) {is_view}
    set ::_event_args(GiD_Event_AfterInsertGIDProject) filename
    set ::_event_args(GiD_Event_AfterLoadResults) filename
    set ::_event_args(GiD_Event_AfterLogin) username
    set ::_event_args(GiD_Event_AfterLogout) {}
    set ::_event_args(GiD_Event_AfterMeshGeneration) fail
    set ::_event_args(GiD_Event_WindowCancelMeshSize) {}
    set ::_event_args(GiD_Event_AfterMeshProgress) {}
    set ::_event_args(GiD_Event_AfterMove) {use_of transformation error}
    set ::_event_args(GiD_Event_AfterNewGIDProject) {}
    set ::_event_args(GiD_Event_AfterOpenFile) {filename format error}
    set ::_event_args(GiD_Event_AfterProcess) {words is_rotation}
    set ::_event_args(GiD_Event_AfterReadGIDProject) filename
    set ::_event_args(GiD_Event_AfterReadGIDProjectWithError) {filename error_string}
    set ::_event_args(GiD_Event_AfterReadPreferences) filename
    set ::_event_args(GiD_Event_AfterRedraw) {}
    set ::_event_args(GiD_Event_AfterRenameCutSet) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameGraph) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameGraphSet) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameGroup) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameLayer) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameMaterial) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameSurfaceSet) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenameVolumeSet) {old_name new_name}
    set ::_event_args(GiD_Event_AfterRenderProgress) {}
    set ::_event_args(GiD_Event_AfterRenumber) {use_of level_type renumeration}
    set ::_event_args(GiD_Event_AfterRepair) {}
    set ::_event_args(GiD_Event_AfterRunCalculation) {base_name dir problemtype_dir where error error_filename}
    set ::_event_args(GiD_Event_AfterSaveAsGIDProject) {old_modelname new_modelname}
    set ::_event_args(GiD_Event_AfterSaveBackup) dirname
    set ::_event_args(GiD_Event_AfterSaveFile) {filename format error}
    set ::_event_args(GiD_Event_AfterSaveGIDProject) modelname
    set ::_event_args(GiD_Event_AfterSaveImage) {filename format}
    set ::_event_args(GiD_Event_AfterSavePreferences) filename
    set ::_event_args(GiD_Event_AfterSetAnalysis) analysis_name
    set ::_event_args(GiD_Event_AfterSetGraphSetToUse) name
    set ::_event_args(GiD_Event_AfterSetIntervalToUse) num
    set ::_event_args(GiD_Event_AfterSetLayerToUse) name
    set ::_event_args(GiD_Event_AfterSetPostModelName) name
    set ::_event_args(GiD_Event_AfterSetProblemtypeName) name
    set ::_event_args(GiD_Event_AfterSetProjectName) name
    set ::_event_args(GiD_Event_AfterSetResult) {analysis_name step_index result_name}
    set ::_event_args(GiD_Event_AfterSetResultComponent) {analysis_name step_index result_name result_component}
    set ::_event_args(GiD_Event_AfterSetTimeStep) {analysis_name i_time_step}
    set ::_event_args(GiD_Event_AfterSetVariable) {name value}
    set ::_event_args(GiD_Event_AfterStartSession) {program main_version session_token}
    set ::_event_args(GiD_Event_AfterStopSession) {program main_version}
    set ::_event_args(GiD_Event_AfterTransformProblemType) {filename old_problemtype new_problemtype messages}
    set ::_event_args(GiD_Event_AfterWriteCalculationFile) {filename error}
    set ::_event_args(GiD_Event_BeforeCopy) {use_of transformation error}
    set ::_event_args(GiD_Event_BeforeDeleteCondition) name
    set ::_event_args(GiD_Event_BeforeDeleteCutSet) name
    set ::_event_args(GiD_Event_BeforeDeleteDimension) num
    set ::_event_args(GiD_Event_BeforeDeleteGraph) name
    set ::_event_args(GiD_Event_BeforeDeleteGraphSet) name
    set ::_event_args(GiD_Event_BeforeDeleteGroup) name
    set ::_event_args(GiD_Event_BeforeDeleteInterval) num
    set ::_event_args(GiD_Event_BeforeDeleteLayer) name
    set ::_event_args(GiD_Event_BeforeDeleteLine) num
    set ::_event_args(GiD_Event_BeforeDeleteMaterial) name
    set ::_event_args(GiD_Event_BeforeDeletePoint) num
    set ::_event_args(GiD_Event_BeforeDeleteSurface) num
    set ::_event_args(GiD_Event_BeforeDeleteSurfaceSet) name
    set ::_event_args(GiD_Event_BeforeDeleteVolume) num
    set ::_event_args(GiD_Event_BeforeDeleteVolumeSet) name
    set ::_event_args(GiD_Event_BeforeDrawPointPost) { node_id x y z }
    set ::_event_args(GiD_Event_BeforeDrawPointsPost) {}
    set ::_event_args(GiD_Event_BeforeEndGIDPostProcess) {}
    set ::_event_args(GiD_Event_BeforeExit) {}
    set ::_event_args(GiD_Event_BeforeInitGIDPostProcess) {}
    set ::_event_args(GiD_Event_BeforeInitProblemtype) dir
    set ::_event_args(GiD_Event_BeforeLogin) { username user_token}
    set ::_event_args(GiD_Event_BeforeMainLoop) args
    set ::_event_args(GiD_Event_BeforeMeshErrors) filename
    set ::_event_args(GiD_Event_BeforeMeshGeneration) element_size
    set ::_event_args(GiD_Event_BeforeMeshProgress) { num_other num_lines num_surfaces num_volumes }
    set ::_event_args(GiD_Event_BeforeMove) {use_of transformation error}
    set ::_event_args(GiD_Event_BeforeOpenFile) {filename format}
    set ::_event_args(GiD_Event_BeforeRenderProgress) num_surfaces
    set ::_event_args(GiD_Event_BeforeReadGIDProject) filename
    set ::_event_args(GiD_Event_BeforeResultReadErrors) {filename msg format}
    set ::_event_args(GiD_Event_BeforeRunCalculation) {bat_filename base_name dir problemtype_dir gid_exe args}    
    set ::_event_args(GiD_Event_BeforeSaveAsGIDProject) {old_modelname new_modelname}
    set ::_event_args(GiD_Event_BeforeSaveBackup) dirname
    set ::_event_args(GiD_Event_BeforeSaveGIDProject) modelname
    set ::_event_args(GiD_Event_BeforeSetCursor) {name togl}
    set ::_event_args(GiD_Event_BeforeSetMenu) {menu_data menu}
    set ::_event_args(GiD_Event_BeforeSetVariable) {variable value}
    set ::_event_args(GiD_Event_BeforeSetWarnLine) message
    set ::_event_args(GiD_Event_BeforeTransformProblemType) {filename old_problemtype new_problemtype}
    set ::_event_args(GiD_Event_BeforeUpdateWindow) window
    set ::_event_args(GiD_Event_BeforeWriteCalculationFile) filename
    set ::_event_args(GiD_Event_ChangedLanguage) language
    set ::_event_args(GiD_Event_ChangeMainWindowTitle) {project_name problemtype_name}    
    set ::_event_args(GiD_Event_DiskFull) message
    set ::_event_args(GiD_Event_DynamicBox) {w x y type}
    set ::_event_args(GiD_Event_DynamicFigure) {w level id type}
    set ::_event_args(GiD_Event_DynamicLine) {w x y type}
    set ::_event_args(GiD_Event_EndGIDPostProcess) {}
    set ::_event_args(GiD_Event_EndProblemtype) {}
    set ::_event_args(GiD_Event_GetBoundingBox) use_of
    set ::_event_args(GiD_Event_GetRecommendedMeshSize) recommended_mesh_size
    set ::_event_args(GiD_Event_InitGIDPostProcess) {}
    set ::_event_args(GiD_Event_InitProblemtype) dir
    set ::_event_args(GiD_Event_LoadModelSPD) filename_spd
    set ::_event_args(GiD_Event_MeshProgress) {percent_total percent_other percent_lines percent_surfaces percent_volumes num_nodes num_elements }
    set ::_event_args(GiD_Event_MessageBoxCombobox) {title question options state image}
    set ::_event_args(GiD_Event_MessageBoxEntry) {title question entry_win_type default_answer button_assign image}
    set ::_event_args(GiD_Event_MessageBoxGetFilename) {category mode title initial_filename file_types default_extension multiple more_options}
    set ::_event_args(GiD_Event_MessageBoxGetGeneralMeshSize) {last_generation_size recommended_size get_meshing_parameters_from_model}
    set ::_event_args(GiD_Event_MessageBoxGetNormal) title
    set ::_event_args(GiD_Event_MessageBoxModeless) {title message}
    set ::_event_args(GiD_Event_MessageBoxOk) {title question image}
    set ::_event_args(GiD_Event_MessageBoxOptionsButtons) {title question options labels image option_do_it_for_all_text}
    set ::_event_args(GiD_Event_MessageBoxOptionsButtonsModeless) {title question options labels image button_callback cancel_callback}
    set ::_event_args(GiD_Event_MessageBoxZmesherAskPassword) {id_machinename id_operating_system id_sysinfo}
    set ::_event_args(GiD_Event_RenderProgress) {total_percent n_nodes n_elems}
    set ::_event_args(GiD_Event_ResizeTogl) {W width height x y}
    set ::_event_args(GiD_Event_SaveModelSPD) filename_spd
    set ::_event_args(GiD_Event_SelectGIDBatFile) {dir base_name}
    set ::_event_args(GiD_Event_SelectOutputFilenames) filenames
    set ::_event_args(GiD_Event_WarnWinText) {message title}
}

proc _event_deprecated_args_init {} {
    array unset ::_event_deprecated_map_to
    set ::_event_deprecated_map_to(AfterAssignMaterial) GiD_Event_AfterAssignMaterial
    set ::_event_deprecated_map_to(AfterChangeBackground) GiD_Event_AfterChangeBackground
    set ::_event_deprecated_map_to(AfterChangeCondition) GiD_Event_AfterChangeCondition
    set ::_event_deprecated_map_to(AfterChangeGraph) GiD_Event_AfterChangeGraph
    set ::_event_deprecated_map_to(AfterChangeGraphSet) GiD_Event_AfterChangeGraphSet
    set ::_event_deprecated_map_to(AfterChangeGroup) GiD_Event_AfterChangeGroup
    set ::_event_deprecated_map_to(AfterChangeLayer) GiD_Event_AfterChangeLayer
    set ::_event_deprecated_map_to(AfterChangeParentGroup) GiD_Event_AfterChangeParentGroup
    set ::_event_deprecated_map_to(AfterChangeParentLayer) GiD_Event_AfterChangeParentLayer
    set ::_event_deprecated_map_to(AfterChangeViewMode) GiD_Event_AfterChangeViewMode
    set ::_event_deprecated_map_to(AfterCopy) GiD_Event_AfterCopy
    set ::_event_deprecated_map_to(AfterCreateCondition) GiD_Event_AfterCreateCondition
    set ::_event_deprecated_map_to(AfterCreateCutSet) GiD_Event_AfterCreateCutSet
    set ::_event_deprecated_map_to(AfterCreateDimension) GiD_Event_AfterCreateDimension
    set ::_event_deprecated_map_to(AfterCreateGraph) GiD_Event_AfterCreateGraph
    set ::_event_deprecated_map_to(AfterCreateGraphSet) GiD_Event_AfterCreateGraphSet
    set ::_event_deprecated_map_to(AfterCreateGroup) GiD_Event_AfterCreateGroup
    set ::_event_deprecated_map_to(AfterCreateLayer) GiD_Event_AfterCreateLayer
    set ::_event_deprecated_map_to(AfterCreateLine) GiD_Event_AfterCreateLine
    set ::_event_deprecated_map_to(AfterCreateMaterial) GiD_Event_AfterCreateMaterial
    set ::_event_deprecated_map_to(AfterCreatePoint) GiD_Event_AfterCreatePoint
    set ::_event_deprecated_map_to(AfterCreateSurface) GiD_Event_AfterCreateSurface
    set ::_event_deprecated_map_to(AfterCreateSurfaceSet) GiD_Event_AfterCreateSurfaceSet
    set ::_event_deprecated_map_to(AfterCreateVolume) GiD_Event_AfterCreateVolume
    set ::_event_deprecated_map_to(AfterCreateVolumeSet) GiD_Event_AfterCreateVolumeSet
    set ::_event_deprecated_map_to(AfterDeleteGraph) GiD_Event_AfterDeleteGraph
    set ::_event_deprecated_map_to(AfterDeleteGraphSet) GiD_Event_AfterDeleteGraphSet
    set ::_event_deprecated_map_to(AfterDeleteGroup) GiD_Event_AfterDeleteGroup
    set ::_event_deprecated_map_to(AfterDrawModel) GiD_Event_AfterDrawModel
    set ::_event_deprecated_map_to(AfterLoadGIDProject) GiD_Event_AfterReadGIDProject
    set ::_event_deprecated_map_to(GiD_Event_AfterLoadGIDProject) GiD_Event_AfterReadGIDProject
    set ::_event_deprecated_map_to(AfterMeshGeneration) GiD_Event_AfterMeshGeneration
    set ::_event_deprecated_map_to(AfterMeshProgress) GiD_Event_AfterMeshProgress
    set ::_event_deprecated_map_to(AfterMove) GiD_Event_AfterMove
    set ::_event_deprecated_map_to(AfterOpenFile) GiD_Event_AfterOpenFile
    set ::_event_deprecated_map_to(AfterReadGIDProject) GiD_Event_AfterReadGIDProject
    set ::_event_deprecated_map_to(AfterRedraw) GiD_Event_AfterRedraw
    set ::_event_deprecated_map_to(AfterRenameCutSet) GiD_Event_AfterRenameCutSet
    set ::_event_deprecated_map_to(AfterRenameGraph) GiD_Event_AfterRenameGraph
    set ::_event_deprecated_map_to(AfterRenameGraphSet) GiD_Event_AfterRenameGraphSet
    set ::_event_deprecated_map_to(AfterRenameGroup) GiD_Event_AfterRenameGroup
    set ::_event_deprecated_map_to(AfterRenameLayer) GiD_Event_AfterRenameLayer
    set ::_event_deprecated_map_to(AfterRenameMaterial) GiD_Event_AfterRenameMaterial
    set ::_event_deprecated_map_to(AfterRenameSurfaceSet) GiD_Event_AfterRenameSurfaceSet
    set ::_event_deprecated_map_to(AfterRenameVolumeSet) GiD_Event_AfterRenameVolumeSet
    set ::_event_deprecated_map_to(AfterRenumber) GiD_Event_AfterRenumber
    set ::_event_deprecated_map_to(AfterRunCalculation) GiD_Event_AfterRunCalculation
    set ::_event_deprecated_map_to(AfterSaveAs) GiD_Event_AfterSaveAsGIDProject
    set ::_event_deprecated_map_to(AfterSaveFile) GiD_Event_AfterSaveFile
    set ::_event_deprecated_map_to(AfterSaveImage) GiD_Event_AfterSaveImage
    set ::_event_deprecated_map_to(AfterSetGraphSetToUse) GiD_Event_AfterSetGraphSetToUse
    set ::_event_deprecated_map_to(AfterSetLayerToUse) GiD_Event_AfterSetLayerToUse
    set ::_event_deprecated_map_to(AfterTransformProblemType) GiD_Event_AfterTransformProblemType
    set ::_event_deprecated_map_to(AfterWriteCalcFileGIDProject) GiD_Event_AfterWriteCalculationFile
    set ::_event_deprecated_map_to(BeforeCopy) GiD_Event_BeforeCopy
    set ::_event_deprecated_map_to(BeforeDeleteCondition) GiD_Event_BeforeDeleteCondition
    set ::_event_deprecated_map_to(BeforeDeleteCutSet) GiD_Event_BeforeDeleteCutSet
    set ::_event_deprecated_map_to(BeforeDeleteDimension) GiD_Event_BeforeDeleteDimension
    set ::_event_deprecated_map_to(BeforeDeleteGraph) GiD_Event_BeforeDeleteGraph
    set ::_event_deprecated_map_to(BeforeDeleteGraphSet) GiD_Event_BeforeDeleteGraphSet
    set ::_event_deprecated_map_to(BeforeDeleteGroup) GiD_Event_BeforeDeleteGroup
    set ::_event_deprecated_map_to(BeforeDeleteLayer) GiD_Event_BeforeDeleteLayer
    set ::_event_deprecated_map_to(BeforeDeleteMaterial) GiD_Event_BeforeDeleteMaterial
    set ::_event_deprecated_map_to(BeforeDeletePoint) GiD_Event_BeforeDeletePoint
    set ::_event_deprecated_map_to(BeforeDeleteSurface) GiD_Event_BeforeDeleteSurface
    set ::_event_deprecated_map_to(BeforeDeleteSurfaceSet) GiD_Event_BeforeDeleteSurfaceSet
    set ::_event_deprecated_map_to(BeforeDeleteVolume) GiD_Event_BeforeDeleteVolume
    set ::_event_deprecated_map_to(BeforeInitGIDPostProcess) GiD_Event_BeforeInitGIDPostProcess
    set ::_event_deprecated_map_to(BeforeMeshErrors) GiD_Event_BeforeMeshErrors
    set ::_event_deprecated_map_to(BeforeMeshGeneration) GiD_Event_BeforeMeshGeneration
    set ::_event_deprecated_map_to(BeforeMeshProgress) GiD_Event_BeforeMeshProgress
    set ::_event_deprecated_map_to(BeforeMove) GiD_Event_BeforeMove
    set ::_event_deprecated_map_to(BeforeReadGIDProject) GiD_Event_BeforeReadGIDProject
    set ::_event_deprecated_map_to(BeforeResultReadErrors) GiD_Event_BeforeResultReadErrors
    set ::_event_deprecated_map_to(BeforeRunCalculation) GiD_Event_BeforeRunCalculation
    set ::_event_deprecated_map_to(BeforeTransformProblemType) GiD_Event_BeforeTransformProblemType
    set ::_event_deprecated_map_to(BeforeWriteCalcFileGIDProject) GiD_Event_BeforeWriteCalculationFile
    set ::_event_deprecated_map_to(ChangedLanguage) GiD_Event_ChangedLanguage
    set ::_event_deprecated_map_to(ChangeMainWindowTitle) GiD_Event_ChangeMainWindowTitle    
    set ::_event_deprecated_map_to(EndGIDPostProcess) GiD_Event_EndGIDPostProcess
    set ::_event_deprecated_map_to(EndGIDProject) GiD_Event_EndProblemtype
    set ::_event_deprecated_map_to(InitGIDPostProcess) GiD_Event_InitGIDPostProcess
    set ::_event_deprecated_map_to(InitGIDProject) GiD_Event_InitProblemtype
    set ::_event_deprecated_map_to(LoadFileInGidUnknowExtension) {}
    set ::_event_deprecated_map_to(LoadGIDProject) GiD_Event_LoadModelSPD
    set ::_event_deprecated_map_to(LoadResultsGIDPostProcess) GiD_Event_AfterLoadResults
    set ::_event_deprecated_map_to(MeshProgress) GiD_Event_MeshProgress
    set ::_event_deprecated_map_to(SaveGIDProject) GiD_Event_SaveModelSPD
    set ::_event_deprecated_map_to(SelectGIDBatFile) GiD_Event_SelectGIDBatFile
    set ::_event_deprecated_map_to(TclCalcModelBoundaries) GiD_Event_GetBoundingBox
    set ::_event_deprecated_map_to(_AfterChangeMaterial) GiD_Event_AfterChangeMaterial
    set ::_event_deprecated_map_to(_BeforeDeleteLine) GiD_Event_BeforeDeleteLine
    set ::_event_deprecated_map_to(_BeforeDeleteVolumeSet) GiD_Event_BeforeDeleteVolumeSet
}

proc GiD_Info_events { } {
    return [lsort -dictionary [array names ::_event_args]]
}

proc GiD_Info_events_deprecated { } {
    return [lsort -dictionary [array names ::_event_deprecated_map_to]]
    return $event_names
}

proc GiD_Info_events_args { event_name } {
    set args {}
    if { [info exists ::_event_args($event_name)] } {
      set args $::_event_args($event_name)
    } else {
        if { [info exists ::_event_deprecated_map_to($event_name)] } {
            set updated_event_name $::_event_deprecated_map_to($event_name)
            if { $updated_event_name != "" } {
                set args [GiD_Info_events_args $updated_event_name]
            } else {
                set args {}
            }
        } else {
            error "event $event_name not found"
        }
    }
    return $args
}

proc GiD_Info_events_add { event_name event_args} {
    if { [lsearch -sorted -dictionary [GiD_Info events] $event_name] == -1 } {
        set ::_event_args($event_name) $event_args
    } else {
        return -error "Event $event_name already defined."
    }
}

proc GiD_Info_events_remove { event_name} {
    if { [lsearch -sorted -dictionary [GiD_Info events] $event_name] == -1 } {
        return -error "Event $event_name not defined."
    } else {
        unset ::_event_args($event_name)
    }
}

proc get_implemented_events_deprecated { } {
    set events_deprecated [list ]
    foreach event_name [GiD_Info events -deprecated] {
        if { [info procs $event_name] != "" } {
            lappend events_deprecated $event_name
        }
    }
    return $events_deprecated
}

proc get_implemented_events { } {
    set events [list ]
    foreach event_name [GiD_Info events] {
        if { [info procs $event_name] != "" } {
            lappend events $event_name
        }
    }
    return $events
}

proc check_implemented_events { } {
    set events [get_implemented_events]
    set warnings 0
    #W "Implemented [llength $events] events: [join $events]"
    foreach event_name $events {
        if { [llength [info args $event_name]] != [llength [GiD_Info events -args $event_name]] } {
            if { [GiD_Info events -args $event_name] != "args" } {
                W "* Error: wrong arguments of $event_name, event must be [GiD_Info events -args $event_name]"
                incr warnings
            }
        }
    }
    set events_deprecated [get_implemented_events_deprecated]
    if {  [llength $events_deprecated] } {
        W "Implemented [llength $events_deprecated] events deprecated:"
        foreach event_name $events_deprecated {
            set new_event_name $::_event_deprecated_map_to($event_name)
            W "$event_name -> $new_event_name"
            incr warnings
            if { [llength [info args $event_name]] != [llength [GiD_Info events -args $new_event_name]] } {
                if { $event_name == "AfterTransformProblemType" && [llength [info args $event_name]] } {
                    #this event is allowed also with 3 arguments instead of current 4, for back compatibility
                } else {
                    if { [GiD_Info events -args $new_event_name] != "args" } {
                        W "* Error: wrong arguments of $event_name, must be [GiD_Info events -args $new_event_name]"
                        incr warnings
                    }
                }
            }
        }
    }
    if { [llength $events] } {
        W ""
        W "Instead of define a proc with the name of the event now must define another proc and register it with GiD_RegisterEvent, like this:"
        foreach event_name $events {
            W ""
            W "proc $event_name { [GiD_Info events -args $event_name] } { ... }"
            W "->"
            W "proc your_prefix_$event_name { [GiD_Info events -args $event_name] } { ... }"
            W "and register it once"
            W "GiD_RegisterEvent $event_name your_prefix_$event_name PROBLEMTYPE your_problemtype"
        }
    }
    if { $warnings } {
      W ""
      W "Note: to avoid this check and its messages add to the xml of the problemtype: <EnableDeprecated>1</EnableDeprecated>"
    }
}

_event_args_init
_event_deprecated_args_init
