#this file implements GiD events to do special things
#a GiD-event is a collection of Tcl procedures with a predefined prototype invoked from GiD

#$::gid_start_mode == "server"
#dark trick: do not remove this if, it prevent that the procs appear in tclIndex when using auto_mkindex and sourced by error
if { $::gid_start_mode == "server" } {
   
    #gid_server_init

    proc GiD_Implement_Event_BeforeMainLoop { args } {
        GiD_BeforeMainLoopDo {*}$args    
        gid_server_init
        #wm withdraw .gid     
    }

    proc GiD_Implement_Event_AfterRedraw { } {
        gid_server_clients_update_image_screen 
    }

    ##########################################
    ####### SINCHRONOUS CALLS (modal) #########
    ##########################################
    #all these GiD_Implement_Event_ that use gid_server_clients_eval (modal) are in case
    #that the question is started from gid.exe, what is a bad design
    #(e.g. is a filename is not provided a priory GiD C+ ask from them)!!
    #the good design is all the data is collected by the GUI client, and then sent to server
    
    ##########################################
    ##### ASINCRONOUS BUT WITH CALLBACK ######
    ##########################################

    
    ##########################################
    ##### ASINCRONOUS CALLS (modeless) #######
    ##########################################


    proc GiD_Implement_Event_AfterMeshGeneration { fail } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterMeshGeneration $fail]
    }

    proc GiD_Implement_Event_AfterMeshProgress { } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterMeshProgress]
    }

    proc GiD_Implement_Event_AfterSetProjectName { projectname } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterSetProjectName $projectname]
    }

    proc GiD_Implement_Event_AfterSetProblemtypeName { name } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterSetProblemtypeName name]
    }

    proc GiD_Implement_Event_AfterSetPostModelName { name } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterSetPostModelName $name]
    } 

    proc GiD_Implement_Event_AfterChangeRenderMode { render_mode } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeRenderMode $render_mode]
    }

    proc GiD_Implement_Event_AfterChangeZoomFactor { zoom_factor } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeZoomFactor $zoom_factor]
    }

    proc GiD_Implement_Event_AfterChangeMesh { num_nodes num_elements } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeMesh $num_nodes $num_elements]
    }

    proc GiD_Implement_Event_AfterChangeLayersOrSets { num_layers num_off num_withback num_transparent } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeLayersOrSets $num_layers $num_off $num_withback $num_transparent]
    }

    proc GiD_Implement_Event_AfterChangeCoordinates { coordinates } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeCoordinates $coordinates]
    }

    proc GiD_Implement_Event_AfterChangeLicence { password_mode password_type password_expiration } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeLicence $password_mode $password_type $password_expiration]        
    }

    proc GiD_Implement_Event_AfterChangeProblemtype { old_problemtype new_problemtype } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeProblemtype $old_problemtype $new_problemtype]
    }
    
    proc GiD_Implement_Event_AfterChangeViewMode { view_mode } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterChangeViewMode $view_mode]
    }

    proc GiD_Implement_Event_AfterCreateTopMenus { } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterCreateTopMenus]
    }

    proc GiD_Implement_Event_AfterRenderProgress { } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterRenderProgress]
    }

    proc GiD_Implement_Event_AfterRunCalculation  { name directory problemtype uid error filenameerror } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterRunCalculation $name $directory $problemtype $uid $error $filenameerror]
    }

    proc GiD_Implement_Event_AfterSetGraphSetToUse { name } {
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterSetGraphSetToUse $name]        
    }

    proc GiD_Implement_Event_AfterSetVariable { variable value } { 
        gid_server_clients_eval_async [list GiD_Implement_Event_AfterSetVariable $variable $value]
    }


    #if server exit must its clients exit? 
    #maybe the server could be restarted and the connection recovered!!
    #then must implement a mechanism to reconnect (automatic or manually)
    proc GiD_Implement_Event_BeforeExit {} {
        gid_server_clients_eval_async [list gid_client_exit]
    }

    proc GiD_Implement_Event_BeforeInitProblemtype { dir } {
        gid_common_problemtype_init_message_catalogs $dir
        #gid_common_problemtype_init_themes $dir
        gid_common_problemtype_init_read_xml $dir
        gid_common_problemtype_init_customlib_automatic $dir
        gid_common_problemtype_init_tcl_source $dir
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeInitProblemtype $dir]
    }

    proc GiD_Implement_Event_BeforeMeshProgress { n0 n1 n2 n3 } {
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeMeshProgress $n0 $n1 $n2 $n3]
    }

    proc GiD_Implement_Event_BeforeRenderProgress { num_surfaces } {
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeRenderProgress $num_surfaces]
    }

    proc GiD_Implement_Event_BeforeSetCursor { name togl } {
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeSetCursor $name $togl]
    }

    proc GiD_Implement_Event_BeforeSetMenu { menu_data menu } {
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeSetMenu $menu_data $menu]
        # show by now also in the server:
        #gid_client_update_menu $menu_data $menu
    }

    proc GiD_Implement_Event_BeforeSetWarnLine { message } {
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeSetWarnLine $message]
        # show by now also in the server:
        #GidUtils::SetWarnLine $message
    }

    proc GiD_Implement_Event_BeforeUpdateWindow { window } {
        gid_server_clients_eval_async [list GiD_Implement_Event_BeforeUpdateWindow $window]
    }

    proc GiD_Implement_Event_ChangedLanguage { language } {
        gid_server_clients_eval_async [list GiD_Implement_Event_ChangedLanguage $language]
    }

    proc GiD_Implement_Event_DynamicBox { w x y type } {
        gid_server_clients_eval_async [list GiD_Implement_Event_DynamicBox $w $x $y $type]
    }
    
    #proc GiD_Implement_Event_DynamicLine { w x y type } {   
    #   gid_server_clients_update_image_screen        
    #}

    #proc GiD_Implement_Event_DynamicFigure { w figure_level_type figure_id type } {
    #   gid_server_clients_update_image_screen        
    #}

    proc GiD_Implement_Event_EndGIDPostProcess {} { 
        gid_server_clients_eval_async [list GiD_Implement_Event_EndGIDPostProcess]
    }

    proc GiD_Implement_Event_EndProblemtype { } {
        gid_common_problemtype_end_customlib_automatic
        gid_server_clients_eval_async [list GiD_Implement_Event_EndProblemtype]
    }

    proc GiD_Implement_Event_InitGIDPostProcess {} {  
        gid_server_clients_eval_async [list GiD_Implement_Event_InitGIDPostProcess]
    }

    #warning, all these events returning a value like -cancel- must be rewritten asyncronous with a callback!!!
    proc GiD_Implement_Event_MeshProgress { total_percent partial_percents_0 partial_percents_1 partial_percents_2 partial_percents_3 n_nodes n_elems } {
        #do not use async to get the result (that could be -cancel- to cancel meshing)
        set result [gid_server_clients_eval_async [list GiD_Implement_Event_MeshProgress $total_percent $partial_percents_0 $partial_percents_1 \
                    $partial_percents_2 $partial_percents_3 $n_nodes $n_elems]]
        return $result
    }

    proc GiD_Implement_Event_MessageBoxCombobox { title question options state image } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxCombobox $title $question $options $state $image]
    }

    proc GiD_Implement_Event_MessageBoxEntry { title question entry_win_type default_answer button_assign image } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxEntry $title $question $entry_win_type $default_answer $button_assign $image]
    }

    proc GiD_Implement_Event_MessageBoxGetGeneralMeshSize { last_generation_size recommended_size get_meshing_parameters_from_model } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxGetGeneralMeshSize $last_generation_size $recommended_size $get_meshing_parameters_from_model]
    }

    proc GiD_Implement_Event_MessageBoxGetFilename { cathegory mode title initial_filename file_types default_extension multiple extra_options } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxGetFilename $cathegory $mode $title $initial_filename $file_types $default_extension $multiple $extra_options]
    }

    proc GiD_Implement_Event_MessageBoxGetNormal { title } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxGetNormal $title]
    }  

    proc GiD_Implement_Event_MessageBoxModeless { title message } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxModeless $title $message]
    }

    proc GiD_Implement_Event_MessageBoxOk { title question image } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxOk $title $question $image]
    }

    proc GiD_Implement_Event_MessageBoxOptionsButtons { title question options labels image option_do_it_for_all_text } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxOptionsButtons $title $question $options $labels $image $option_do_it_for_all_text]
    }

    proc GiD_Implement_Event_MessageBoxOptionsButtonsModeless { title question options labels image button_callback cancel_callback } {
        gid_server_clients_eval_async [list GiD_Implement_Event_MessageBoxOptionsButtonsModeless $title $question $options $labels $image $button_callback $cancel_callback]
    }

    proc GiD_Implement_Event_RenderProgress { total_percent n_nodes n_elems } {
        gid_server_clients_eval_async [list GiD_Implement_Event_RenderProgress $total_percent $n_nodes $n_elems]
    }

    proc GiD_Implement_Event_WarnWinText { message { title "" } } {
        gid_server_clients_eval_async [list GiD_Implement_Event_WarnWinText $message $title]
    }
 

    proc OnSetTclArrayItem { array_name array_item operation } {
        gid_server_clients_eval_async [list set ::${array_name}($array_item) [set ::${array_name}($array_item)]]
    }

    proc OnSetTclVariable { variable_name array_item operation } {
        gid_server_clients_eval_async [list set ${variable_name} [set ${variable_name}]]
    }

    #variables that must be automatically send to clients
    foreach item { selection selcoord,id selcoord,x selcoord,y selcoord,z} {
        trace add variable ::GidPriv($item) write [list OnSetTclArrayItem]
    }    
    foreach variable_name { ActionsMenuVarType ActionsMenuVar ActionsMenuLabels EntryVar EntryVarHilit } {
        trace add variable ::$variable_name write [list OnSetTclVariable]
    }

    #all public events [GiD_Info events] (not starting with GiD_Implement_Event_) must be re-sent to the clients
    #the problem is that I don't know its arguments to do it in a loop   
    proc GiD_Event_BeforeRunCalculation { filename basename directory problem_dir gidexecutable args } {
        gid_server_clients_eval_async [list GiD_Event_BeforeRunCalculation $filename $basename $directory $problem_dir $gidexecutable $args]
    }

    #deprecated event name [GiD_Info events -deprecated] raised for back compatibility    
    proc BeforeRunCalculation { filename basename directory problem_dir gidexecutable args } {
        gid_server_clients_eval_async [list BeforeRunCalculation $filename $basename $directory $problem_dir $gidexecutable $args]
    }

} else {
    error "this file must not be sourced with ::gid_start_mode=$::gid_start_mode"
}
