#old events raised by the gid_groups_conds of Compass were renamed to
#proc GiD_Event_AfterCreateCondGroup name
#proc GiD_Event_BeforeDeleteCondGroup name
#proc GiD_Event_AfterRenameCondGroup oldname newname 

#Cond_Groups create|delete|edit|get|list|window
#  Cond_Groups create <name>
#  Cond_Groups delete <name>
#  Cond_Groups edit name <oldname> <newname>
#  Cond_Groups edit color <group> <newcolor>
#  Cond_Groups edit visible <group> 0|1
#  Cond_Groups get color <group>
#  Cond_Groups get visible <group>
#  Cond_Groups list
#  Cond_Groups window open|close

package require customLib

proc Cond_Groups { mode args } {    
    set res ""
    if { $mode == "create" } {
	if { [llength $args] == 1 } {
	    set name [lindex $args 0]
	    set res [gid_groups_conds::add_new_group -exactname $name]
	} else {
	    error "usage: Cond_Groups create <name>"
	}
    } elseif { $mode == "delete" } {
	if { [llength $args] == 1 } {
	    set name [lindex $args 0]
	    set res [gid_groups_conds::delete_group $name]	    
	} else {
	    error "usage: Cond_Groups delete <name>"
	}
    } elseif { $mode == "edit" } {
	if { [llength $args] > 0 } {
	    set operation [lindex $args 0]
	    if { $operation == "name" || $operation == "rename" } {
		if { [llength $args] == 3 } {
		    set oldname [lindex $args 1]
		    set newname [lindex $args 2]		   
		    set res [gid_groups_conds::rename_group $oldname $newname]
		} else {
		    error "usage: Cond_Groups edit name <oldname> <newname>"
		}
	    } elseif { $operation == "color" } {
		if { [llength $args] == 3 } {
		    set name [lindex $args 1]
		    set color [lindex $args 2]
		    set res [gid_groups_conds::change_group_att $name color $color]
		} else {
		    error "usage: Cond_Groups edit color <group> <newcolor>"
		}
	    } elseif { $operation == "visible" } {
		if { [llength $args] == 3 } {
		    set name [lindex $args 1]
		    set visible [lindex $args 2]
		    set res [gid_groups_conds::change_group_att $name onoff $visible]
		} else {
		    error "usage: Cond_Groups edit visible <group> 0|1"
		}
	    } else {
		error "usage: Cond_Groups edit name|color|visible"
	    }
	} else {
	    error "usage: Cond_Groups edit name|color|visible"
	}
    } elseif { $mode == "get" } {
	if { [llength $args] > 0 } {
	    set operation [lindex $args 0]
	    if { $operation == "color" } {
		if { [llength $args] == 2 } {
		    set name [lindex $args 1]    
		    set res [gid_groups_conds::get_group_att $name color]
		} else {
		    error "usage: Cond_Groups get color <group>"
		}
	    } elseif { $operation == "visible" } {
		if { [llength $args] == 2 } {
		    set name [lindex $args 1]		   
		    set res [gid_groups_conds::get_group_att $name onoff]
		} else {
		    error "usage: Cond_Groups get visible <group>"
		}
	    } else {
		error "usage: Cond_Groups get color|visible"
	    }
	} else {
	    error "usage: Cond_Groups get color|visible"
	}

    } elseif { $mode == "list" } {
	    set res [gid_groups_conds::give_groups normal "" ""]
    } elseif { $mode == "window" } {
	if { [llength $args] == 1 } {
	    set operation [lindex $args 0]
	    if { $operation == "open" } {
	    	set res [gid_groups_conds::open_groups .gid window]
	    } elseif { $operation == "close" } {
		set w .gid.groups
		if { [winfo exists $w] } {
		    destroy $w
		}
	    	set res ""
	    } else {
		error "usage: Cond_Groups window open|close"
	    }
	} else {
	    error "usage: Cond_Groups window open|close"
	}
    } else {
	error "usage: Cond_Groups create|delete|edit|get|list|window"	
    }
    return $res
}




