namespace eval ExternalActions {
    variable login_request_send
    variable is_debug
}

set ExternalActions::is_debug 0

proc ExternalActions::PrintToLogfile {txt} {
    if {![info exists ExternalActions::is_debug] || $ExternalActions::is_debug == 0} {
        return
    }
    
    if { $::tcl_platform(platform) == "windows" } {
	set log_file [file join "E:/tmp" "gid_external_actions.log"]
    } else {
	set log_file [file join "/tmp" "gid_external_actions.log"]
    }
    set log_file_id [open $log_file a]
    puts $log_file_id $txt
    close $log_file_id
}

proc ExternalActions::PrintTimeToLogfile { { txt ""} } {
    ExternalActions::PrintToLogfile "[ clock format [ clock seconds]] - $txt"
}

proc ExternalActions::_showWarning { txt} {
    if { [GidUtils::IsTkDisabled] } {
        catch {
            package require Tk
            wm withdraw .
            set answer [ tk_messageBox -type ok -icon warning -title "Warning" -message $txt ]
        } err_txt
    } else {
        W $txt
    }
}

proc ExternalActions::ExternalConnect {opening_url} {
    variable login_request_send
    set login_request_send 0

    #W $opening_url
    set opening_url [string trim $opening_url "'"]
    ExternalActions::PrintTimeToLogfile "got petition"
    ExternalActions::PrintToLogfile "ExternalConnect $opening_url"

    # Get the action (word before ?)
    set action [lindex [split $opening_url ?] 0]
    set action [string trim $action "/"]
    switch -- $action {
        "gid://open" {
            ExternalActions::OpenCloudModel $opening_url
        }
        "gid://login" {
            ExternalActions::ExternalLogin $opening_url
        }
        default {
            ExternalActions::_showWarning "Unknown action $action"
        }
    }

}

proc ExternalActions::ExternalLogin {opening_url} {
    ExternalActions::PrintToLogfile "ExternalLogin $opening_url"
    # gid://login?user_token=eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9&model_id=370291&close_after=0

    # extract user_token from opening_url. user token consists on 3 parts separated by dots
    # set user_token [lindex [split [lindex [regexp -all -inline {user_token=\w+} $opening_url] 0] =] 1] -> this only extracts the first part of the token
    # set user_token [lindex [split [lindex [regexp -all -inline {user_token=\w+\.\w+\.\w+} $opening_url] 0] =] 1]
    set user_token [lindex [split [lindex [regexp -all -inline {user_token=([^&]+)} $opening_url] 0] =] 1]

    # extract model_id from opening_url (is optional)
    set model_id [lindex [split [lindex [regexp -all -inline {model_id=\d+} $opening_url] 0] =] 1]
    # extract close_after from opening_url (is optional)
    set close_after [lindex [split [lindex [regexp -all -inline {close_after=\d+} $opening_url] 0] =] 1]

    # W "Model id optional: $model_id"

    if {[GiD_Login is_logged]} {
        # already logged
        # W "Already logged"
    } else {
        # W "Login with token $user_token"
        GiD_Login login_with_token $user_token
    }
    ExternalActions::OpenCloudModel_do $model_id
}


proc ExternalActions::OpenCloudModel {opening_url} {
    # gid://open?model_id=370291&user_token=s12sdfs34
    # extract model_id from opening_url
    set model_id [lindex [split [lindex [regexp -all -inline {model_id=\d+} $opening_url] 0] =] 1]
    ExternalActions::OpenCloudModel_do $model_id
}

proc ExternalActions::OpenCloudModel_do {model_id} {
    ExternalActions::PrintToLogfile "OpenCloudModel_do $model_id"
    if {[GiD_Login is_logged]} {
        ExternalActions::PrintToLogfile "OpenCloudModel_do is_logged"
        # find  the local path of the model
        set model_path [GidDataManager::GetLocalPathFromModelId $model_id]
        ExternalActions::PrintToLogfile "OpenCloudModel_do model_path $model_path"
        if {$model_path != "-1"} {
            # after 2000 ms open the model if is connected
            # after 2000 [list ExternalActions::OpenCloudModelPath $model_path]
            ExternalActions::OpenCloudModelPath $model_path
        } else {
            ExternalActions::PrintToLogfile "OpenCloudModel_do model_path not found"
            ExternalActions::_showWarning "Model $model_id not found"
        }
    } else {
        ExternalActions::PrintToLogfile "OpenCloudModel_do is NOT logged"

        variable login_request_send

        if {$login_request_send} {
            # after 2000 [list ExternalActions::OpenCloudModel_do $model_id]
            ExternalActions::OpenCloudModel_do $model_id
        } else {
            set login_request_send 1

            # set machine_name [base64::encode [info hostname]]
	    set err [ catch {
		package require verifp
	    } err_txt]
	    ExternalActions::PrintToLogfile "package require verifp"
	    ExternalActions::PrintToLogfile "    err = $err"
	    ExternalActions::PrintToLogfile "    err_txt = $err_txt"
            lassign [lindex [vp_getsysinfo] 0] machine_name os fingerprint
            set machine_name [binary encode base64 $machine_name]

	    ExternalActions::PrintToLogfile "visiting https://licence.gidsimulation.com/View/SignIn?partner=gid_local&set_machinename=${machine_name}&next=gid://login%3Fuser_token%3Dhere%26model_id%3D$model_id"
	    set err [ catch {
		VisitWeb "https://licence.gidsimulation.com/View/SignIn?partner=gid_local&set_machinename=${machine_name}&next=gid://login%3Fuser_token%3Dhere%26model_id%3D$model_id"
	    } err_txt]
	    ExternalActions::PrintToLogfile "VisitWeb result:"
	    ExternalActions::PrintToLogfile "    err = $err"
	    ExternalActions::PrintToLogfile "    err_txt = $err_txt"
        }

    }
}

proc ExternalActions::OpenCloudModelPath {model_path} {
    ExternalActions::PrintToLogfile "OpenCloudModelPath $model_path"
    if {[GidDataManager::isConnected]} {
        ExternalActions::PrintToLogfile "OpenCloudModelPath isConnected"
        # open the model
        set file_path [file join [GidDataManager::getConnectedPath] $model_path]
        # start a new gid
        set gid_exec [GidUtils::GetFullPathGiDExe]
        ExternalActions::PrintToLogfile "OpenCloudModelPath gid_exec $gid_exec"
        exec $gid_exec $file_path &
        # GiD_Process Mescape Files Read $file_path
        after 2000 [list exit]
    } else {
        GidDataManager::connect
        # try again after 2000 ms
        # after 2000 [list ExternalActions::OpenCloudModelPath $model_path]
        ExternalActions::OpenCloudModelPath $model_path
    }
}
