proc CurvatureInitVariables {} {
    global GidPriv
    if { ![info exists GidPriv(CurvatureType)] } {
        set GidPriv(CurvatureType) CurvatureMax
    }
    set GidPriv(CurvatureShowMainDir) 0
    set GidPriv(CurvatureOutMaxColor) [GiD_Set OutMaxColor]
    set GidPriv(CurvatureOutMinColor) [GiD_Set OutMinColor]

    set GidPriv(CurvatureOriginalLimits) [list -0.5 0.5] ;#ideally must ask it, but could be expensive
    set GidPriv(CurvatureMaxValue) [format "%g" [lindex $GidPriv(CurvatureOriginalLimits) 1]]
    set GidPriv(CurvatureMinValue) [format "%g" [lindex $GidPriv(CurvatureOriginalLimits) 0]]
    set GidPriv(CurvatureUseMax) 0
    set GidPriv(CurvatureUseMin) 0

    set GidPriv(CurvatureType,prev) ""
    set GidPriv(CurvatureUseMax,prev) ""
    set GidPriv(CurvatureUseMin,prev) ""
    set GidPriv(CurvatureMaxValue,prev) ""
    set GidPriv(CurvatureMinValue,prev) ""
    set GidPriv(CurvatureShowMainDir,prev) ""
    
    if { ![info exists GidPriv(CurvatureHistoryMax)] } {
        set GidPriv(CurvatureHistoryMax) ""
    }
    if { ![info exists GidPriv(CurvatureHistoryMin)] } {
        set GidPriv(CurvatureHistoryMin) ""
    }
}

proc CurvatureSetCurvatureUseMax { value } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        if { $value != $GidPriv(CurvatureUseMax,prev) } {
            if { $value } {
                GiD_Process ForceMax
            } else {
                GiD_Process ReleaseMax
            }
            set GidPriv(CurvatureUseMax,prev) $value
        }
    }
}

proc CurvatureUpdateDraw { } {
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        GiD_Process UpdateDraw
    }
}

proc CurvatureSetCurvatureMaxValue { value } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        if { $value != $GidPriv(CurvatureMaxValue,prev) } {
            GiD_Process SetForceMaxValue $GidPriv(CurvatureMaxValue)
            set GidPriv(CurvatureMaxValue,prev) $value
        }
    }
}

proc CurvatureSetCurvatureMinValue { value } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        if { $value != $GidPriv(CurvatureMinValue,prev) } {
            GiD_Process SetForceMinValue $GidPriv(CurvatureMinValue)
            set GidPriv(CurvatureMinValue,prev) $value
        }
    }
}

proc CurvatureSetCurvatureUseMin { value } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        if { $value != $GidPriv(CurvatureUseMin,prev) } {
            if { $value } {
                GiD_Process ForceMin
            } else {
                GiD_Process ReleaseMin
            }
            set GidPriv(CurvatureUseMin,prev) $value
        }
    }
}

proc CurvatureFinish { } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        GiD_Process MEscape
    }
}

proc CurvatureSetCurvatureShowMainDir { value } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        if { $value != $GidPriv(CurvatureShowMainDir,prev) } {
            if { $value } {
                GiD_Process ShowMainDir
            } else {
                GiD_Process NoShowMainDir
            }
            set GidPriv(CurvatureShowMainDir,prev) $value
        }
    }
}


proc CurvatureApply {} {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        CurvatureSetCurvatureMaxValue $GidPriv(CurvatureMaxValue)
        CurvatureSetCurvatureUseMax $GidPriv(CurvatureUseMax)
        CurvatureSetCurvatureMinValue $GidPriv(CurvatureMinValue)
        CurvatureSetCurvatureUseMin $GidPriv(CurvatureUseMin)
    } else {
        #RecursiveChangeState $GidPriv(CurvatureWindow) disabled
        #CurvatureCloseWin $GidPriv(CurvatureWindow) ;#better only disable the window
    }
}

proc CurvatureCloseWin { w } {
    global GidPriv
    set GidPriv(CurvatureHistoryMin) [[$w.f.emin cget list] get 0 end]
    set GidPriv(CurvatureHistoryMax) [[$w.f.emax cget list] get 0 end]
    destroy $w
    CurvatureFinish
}

proc CurvatureSetCurvatureType { type } {
    global GidPriv
    if { $type != $GidPriv(CurvatureType,prev) } {
        set command [list Mescape Utilities DrawCurvature Surfaces]
        if { $GidPriv(CurvatureShowMainDir) } {
            lappend command ShowMainDir
        }
        if { $GidPriv(CurvatureUseMax) } {
            lappend command SetForceMaxValue $GidPriv(CurvatureMaxValue) ForceMax
        }
        if { $GidPriv(CurvatureUseMin) } {
            lappend command SetForceMinValue $GidPriv(CurvatureMinValue) ForceMin
        }
        lappend command $type
        GiD_Process {*}$command
        set GidPriv(CurvatureType,prev) $type
    }
}

proc OnSelectCurvatureType { } {
    global GidPriv
    CurvatureSetCurvatureType $GidPriv(CurvatureType)
}

proc CurvatureForceMaxSetState { f } {
    global GidPriv
    if { $GidPriv(CurvatureUseMax)} {
        $f.emax configure -state normal
        $f.cb_out_max configure -state normal
    } else {
        $f.emax configure -state disabled
        $f.cb_out_max configure -state disabled
    }
}

proc OnSelectCurvatureForceMax { f } {
    CurvatureForceMaxSetState $f
    CurvatureApply
}

proc CurvatureForceMinSetState { f } {
    global GidPriv
    if { $GidPriv(CurvatureUseMin)} {
        $f.emin configure -state normal
        $f.cb_out_min configure -state normal
    } else {
        $f.emin configure -state disabled
        $f.cb_out_min configure -state disabled
    }
}

proc OnSelectCurvatureForceMin { f } {
    CurvatureForceMinSetState $f
    CurvatureApply
}

proc OnSelectCurvatureOutMaxColor { } {
    global GidPriv
    if { [GiD_Set OutMaxColor] != $GidPriv(CurvatureOutMaxColor) } {
        GiD_Set OutMaxColor $GidPriv(CurvatureOutMaxColor)
        CurvatureUpdateDraw
    }
}

proc OnSelectCurvatureOutMinColor { } {
    global GidPriv
    if { [GiD_Set OutMinColor] != $GidPriv(CurvatureOutMinColor) } {
        GiD_Set OutMinColor $GidPriv(CurvatureOutMinColor)
        CurvatureUpdateDraw
    }
}

proc OnSelectCurvatureShowMainDir { } {
    global GidPriv
    if { $::ActionsMenuFunction == "Utilities FillMenuDrawCurvature" } {
        if { $GidPriv(CurvatureShowMainDir) } {
            GiD_Process ShowMainDir
        } else {
            GiD_Process NoShowMainDir
        }
    } else {
        #RecursiveChangeState $GidPriv(CurvatureWindow) disabled
        #CurvatureCloseWin $GidPriv(CurvatureWindow) ;#better only disable the window
    }
}

proc CurvatureWindow { {w .gid.curvature} } {
    global GidPriv
    InitWindow2 $w -title [_ "Curvature surfaces"] \
        -geometryvariable CurvatureWindowGeom \
        -initcommand CurvatureWindow -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    CurvatureInitVariables

    set GidPriv(CurvatureWindow) $w

    TTKComboBox $w.type -textvariable ::GidPriv(CurvatureType) \
            -labels [ list [_ "Curvature max"] [_ "Curvature min"] [_ "Curvature mean"] [_ "Curvature gauss"]] \
        -values [list CurvatureMax CurvatureMin CurvatureMean CurvatureGaussian] \
        -state readonly -modifycmd [list OnSelectCurvatureType]

    ttk::labelframe $w.f -text [_ "Interval"]

    ttk::label $w.f.c0 -text [_ ""]
    ttk::label $w.f.c1 -text [_ "Forced value"]
    ttk::label $w.f.c2 -text [_ "Out colours"]
 
    ttk::checkbutton $w.f.lmax -text [_ "Max"]: -variable GidPriv(CurvatureUseMax) -command [list OnSelectCurvatureForceMax $w.f]
    combobox $w.f.emax -borderwidth 1 -textvariable GidPriv(CurvatureMaxValue) \
        -editable 1 -keephistory 1 -history $GidPriv(CurvatureHistoryMax)

    TTKComboBox $w.f.cb_out_max -textvariable ::GidPriv(CurvatureOutMaxColor) \
            -labels [ list [_ "Black"] [_ "White"] [_ "Maximum colour"] [_ "Transparent"]] \
        -values [list Black White MaxColor Transparent] \
        -state readonly -modifycmd [list OnSelectCurvatureOutMaxColor]
    GidHelp $w.f.cb_out_max "Specify how the outlying values from maximum should be drawn"

    
    ttk::checkbutton $w.f.lmin -text [_ "Min"]: -variable GidPriv(CurvatureUseMin) -command [list OnSelectCurvatureForceMin $w.f]
    combobox $w.f.emin -borderwidth 1 -textvariable GidPriv(CurvatureMinValue) \
        -editable 1 -keephistory 1 -history $GidPriv(CurvatureHistoryMin)
    
    TTKComboBox $w.f.cb_out_min -textvariable ::GidPriv(CurvatureOutMinColor) \
            -labels [ list [_ "Black"] [_ "White"] [_ "Minimum colour"] [_ "Transparent"]] \
        -values [list Black White MaxColor Transparent] \
        -state readonly -modifycmd [list OnSelectCurvatureOutMinColor]
    GidHelp [list $w.f.cb_out_max $w.f.cb_out_min] "Specify how the outlying values from maximum and minimum should be drawn"


    ttk::checkbutton $w.main_dir -text [_ "Main directions"]: -variable GidPriv(CurvatureShowMainDir) -command [list OnSelectCurvatureShowMainDir]
    

    grid $w.type

    ttk::frame $w.but -style BottomFrame.TFrame
    ttk::button $w.but.accept -text [_ "Apply"] -style BottomFrame.TButton -command [list CurvatureApply]
    ttk::button $w.but.close -text [_ "Close"] -style BottomFrame.TButton -command [list CurvatureCloseWin $w]

    grid $w.f.c0 $w.f.c1 $w.f.c2
    grid $w.f.lmax $w.f.emax $w.f.cb_out_max
    grid configure $w.f.emax -sticky ew
    grid $w.f.lmin $w.f.emin $w.f.cb_out_min
    grid configure $w.f.emin -sticky ew
    grid columnconfigure $w.f 1 -weight 1
    grid $w.f -sticky ew -padx 2

    grid $w.main_dir -sticky w
    
    grid $w.but.accept $w.but.close -padx 4 -pady 2
    grid $w.but -sticky sew -row 4
    grid anchor $w.but center
    
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 3 -weight 1

    OnSelectCurvatureType
    CurvatureForceMaxSetState $w.f
    CurvatureForceMinSetState $w.f
    
    bind $w <Return> CurvatureApply
    bind $w <Destroy> [list +DestroyCurvatureWindow %W $w] ;# + to add to previous script
    # GidUtils::WindowAboveGid $w
    raise $w
}

proc DestroyCurvatureWindow { W w } {
    if { $W != $w } return
    global SelectionPriv
    #avoid reenter multiple times, one by child    
    CurvatureFinish
}
