
proc gid_common_problemtype_init_tcl_source { dir } {
    set problemtype_name [file rootname [GidUtils::MakeRelativePath [gid_filesystem::get_folder_standard problemtypes] $dir]]
    set filename_tcl [GidUtils::GiveFileInsideProblemType $problemtype_name .tcl]
    set filename_tbe [GidUtils::GiveFileInsideProblemType $problemtype_name .tbe]
    if { [file exists $filename_tcl] || [file exists $filename_tbe] } {
        source $filename_tcl
    }
}

proc gid_common_problemtype_init_message_catalogs { dir } {
    #set problemtype_name [file rootname [GidUtils::MakeRelativePath [gid_filesystem::get_folder_standard problemtypes] $dir]]      
    #::GIDi18nProblemType::load $problemtype_name
    ::GIDi18nProblemType::load $dir
}

proc gid_common_problemtype_init_themes { dir } {
    package require gid_themes
    gid_themes::ReadModuleThemes $dir
}

proc gid_common_problemtype_init_read_xml { dir } {
    set problemtype_name [file rootname [GidUtils::MakeRelativePath [gid_filesystem::get_folder_standard problemtypes] $dir]]    
    array unset ::problemtype_current        
    set filename_xml [GidUtils::GiveFileInsideProblemType $problemtype_name .xml]
    if { [file exists $filename_xml] } {
        array set ::problemtype_current [GidUtils::ReadProblemtypeXml $filename_xml Infoproblemtype ""]
        #check GiD version
        if { [info exists ::problemtype_current(MinimumGiDVersion)] && [GidUtils::VersionCmp $::problemtype_current(MinimumGiDVersion)] < 0 } {
            W [_ "%s requires GiD %s or later" $::problemtype_current(Name) $::problemtype_current(MinimumGiDVersion)]
        }
        if { [info exists ::problemtype_current(MaximumGiDVersion)] && [GidUtils::VersionCmp $::problemtype_current(MaximumGiDVersion)] > 0 } {
            W [_ "%s requires GiD %s or previous" $::problemtype_current(Name) $::problemtype_current(MaximumGiDVersion)]
        }
    }
}
    
proc gid_common_problemtype_init_customlib_automatic { dir } {        
    #do automatic operations if allowed
    if { [info exists ::problemtype_current(CustomLibAutomatic)] && $::problemtype_current(CustomLibAutomatic) } {  
        package require customLib               
        package require customlib_extras
        if { [info exists ::problemtype_current(CustomLibNativeGroups)] && $::problemtype_current(CustomLibNativeGroups) } {  
            package require customlib_native_groups
            #package require customlib_groups_window_use_native_groups ;#to use old window but working internally with native groups
        }            
        gid_groups_conds::SetProgramName $::problemtype_current(Name)
        set problemtype_name [file rootname [GidUtils::MakeRelativePath [gid_filesystem::get_folder_standard problemtypes] $dir]]
        #allow _default for back compatibility
        #trick adding '_default' to the extension argument, not to problemtype_name, to avoid add _default.gid to the name of the parent folder
        set filename_spd [GidUtils::GiveFileInsideProblemType $problemtype_name _default.spd 0]
        if { ![file exists $filename_spd] } {
            set filename_spd [GidUtils::GiveFileInsideProblemType $problemtype_name .spd 0]
        }        
        if { ![file exists $filename_spd] } {
            W [_ "CustomLib file '%s' not found" $filename_spd]
        } else {
            set gid_defaults [GiD_GetUserSettingsFilename]
            set filename_user_defaults [file join [file dirname $gid_defaults] $::problemtype_current(Name)$::problemtype_current(Version).ini]
            if { ![file exists $filename_user_defaults] } {
                set similar_gid_defaults [GetSimilarDefaultsFile [file tail $filename_user_defaults]]
                if { [file exists $similar_gid_defaults] } {
                    set filename_user_defaults $similar_gid_defaults
                }
            }
            gid_groups_conds::begin_problemtype $filename_spd $filename_user_defaults "" 0           
            # Temporary
            customlib::UpdateDocument            
        }
    }    
}

proc gid_common_problemtype_end_customlib_automatic { } {
    if { [info exists ::problemtype_current(CustomLibAutomatic)] && $::problemtype_current(CustomLibAutomatic) } {  
        set filename_user_defaults "" ;#empty to no save .ini
        if { [GiD_Set SaveGidDefaults] } {
            set gid_defaults [GiD_GetUserSettingsFilename ]
            set filename_user_defaults [file join [file dirname $gid_defaults] $::problemtype_current(Name)$::problemtype_current(Version).ini]
        }
        gid_groups_conds::end_problemtype $filename_user_defaults
    }
    array unset ::problemtype_current
}

proc gid_common_problemtype_after_change_problemtype { old_problemtype new_problemtype } {
    SubstDataBooks
    CacheReset menu_data    
    if { $new_problemtype == "UNKNOWN" } {
        #unload problemtype. after idle to avoid crash
        if { $old_problemtype != "UNKNOWN" } {
          after idle [list GidUtils::SetWarnLine [_ "Problem type unloaded"]]
        }
    }
}
