#test to try to allow use the same GiD_Info, GiD_AccessValue, etc functions for both cases with same syntax: classic and also customLib
#to start at least match the structure of names used created by 'gid_problemtype_convert.tcl' from a classic problemtype loaded and exported as a customlib problemtype
#probably will move this file to customLib or customlib_extras packages...
namespace eval customlib {
}

proc customlib::GetQuestionValues { dom_parent {x_path "./value"} } {
    set question_values [list]
    foreach dom_node [$dom_parent selectNodes $x_path] {
        set name [$dom_node @n]
        set value [$dom_node @v]
        lappend question_values $name $value
    }
    return $question_values
}

#GiD_Info gendata
#GiD_AccessValue set gendata Solver Direct
#set value [GiD_AccessValue get gendata Solver]

package require gid_groups_conds

proc customlib::GiD_Info-gendata { } {
    set xpath "//container\[@n='general_data'\]"
    set dom_general_data [gid_groups_conds::GetDomNodes $xpath]
    if { [llength $dom_general_data] != 1 } {
        error "GiD_Info-gendata: 'general_data' not found"
    }
    set dom_general_data [lindex $general_data 0]
    set question_values [customlib::GetQuestionValues $dom_general_data ".//value"]
    set n [expr {[llength $question_values]/2}]
    return [list $n {*}$question_values]
}

proc customlib::GiD_AccessValue-get-gendata { question } {
    set xpath "//container\[@n='general_data'\]//value\[@n='$question'\]"
    set dom_node [gid_groups_conds::GetDomNodes $xpath]
    if { [llength $dom_node] != 1 } {
        error "GiD_AccessValue: property $question not found in  gendata"
    }
    set value [$dom_node getAttribute v ""]
    return $value
}

proc customlib::GiD_AccessValue-set-gendata { question value } {
    set xpath "//container\[@n='general_data'\]//value\[@n='$question'\]"
    set dom_node [gid_groups_conds::GetDomNodes $xpath]
    if { [llength $dom_node] != 1 } {
        error "GiD_AccessValue: property $question not found in  gendata"
    }
    $dom_node setAttribute v $value
    return $value
}

#used by bas parser *GenData command, do not change this proc name or update it also in OutCalc.cc
proc customlib::GenData { question } {
    set question_trim [ProblemtpeConvert::TrimUnderline $question]
    lassign [ProblemtpeConvert::ParseCodedUnits $question_trim] question_decorated units unit_magnitude
    set value [GiD_AccessValue-get-gendata $question_decorated]
    #in fact, in case of have units must do conversion of values to reference unit of curren unit system...
    return $value
}

#GiD_Info materials ?<matname>?
#GiD_AccessValue ?-index? set|get ?-default? material|condition|intvdata|gendata ?<name>? <question> ?<attribute>? <value>
#GiD_AccessValue set material <name> <question> <value>
# set value [GiD_AccessValue get material <name> <question>]

proc customlib::GiD_Info-materials { {material ""} } {
    set result ""
    set x_path {//container[@n="materials"]}
    set dom_materials [gid_groups_conds::GetDomNodes $x_path]
    if { [llength $dom_materials] == 1 } {
        if { $material == "" } {
            set materials [list]
            foreach dom_material [$dom_materials childNodes] {
                set name [$dom_material @name]
                lappend materials $name
            }
            set result $materials
        } elseif { $material == "books" } {

        } else {
            set x_path_2 "./blockdata\[@n='material' and @name='$material'\]"
            set dom_material [$dom_materials selectNodes $x_path_2]
            if { [llength $dom_material] != 1 } {
                error "Error: unknown material. Usage: info materials books|'Material name' ..."
            } else {
                set dom_material [lindex $dom_material 0]
                set question_values [customlib::GetQuestionValues $dom_material ".//value"]
                set n [expr {[llength $question_values]/2}]
                set result [list $n {*}$question_values]
            }
        }
    }
    return $result
}

proc customlib::GiD_AccessValue-get-material { material question } {
    set value ""
    set x_path "//container\[@n='materials'\]/blockdata\[@n='material' and @name='$material'\]"
    set dom_material [gid_groups_conds::GetDomNodes $x_path]
    if { [llength $dom_material] != 1 } {
        error "Error: material '$material' not found"
    } else {
        set x_path_3 ".//value\[@n='$question'\]"
        set dom_node [lindex [$dom_material selectNodes $x_path_3] 0]
        if { $dom_node == "" } {
            error "GiD_AccessValue: property $question not found in material $material"
        }
        set value [$dom_node getAttribute v ""]
    }
    return $value
}

proc customlib::GiD_AccessValue-set-material { material question value } {
    set x_path "//container\[@n='materials'\]/blockdata\[@n='material' and @name='$material'\]"
    set dom_material [gid_groups_conds::GetDomNodes $x_path]
    if { [llength $dom_material] != 1 } {
        error "Error: material '$material' not found"
    } else {
        set x_path_3 ".//value\[@n='$question'\]"
        set dom_node [lindex [$dom_material selectNodes $x_path_3] 0]
        if { $dom_node == "" } {
            error "GiD_AccessValue: property $question not found in material $material"
        }
        $dom_node setAttribute v $value
    }
    return $value
}

#GiD_Info conditions <condition>|over_point|over_line|over_surfacr|over_volume|over_layer|over_group|books?
#GiD_AccessValue ?-index? set|get ?-default? material|condition|intvdata|gendata ?<name>? <question> ?<attribute>? <value>
#GiD_AccessValue set condition <name> <question> <value>
# set value [GiD_AccessValue get condition <name> <question>]

proc customlib::GiD_Info-conditions { condition {geometry_or_mesh ""} {entity_id_or_count ""}} {
    set result ""
    set over ""
    if { $condition == "over_point" } {
        set condition ""
        set over point
    } elseif { $condition == "over_line" } {
        set condition ""
        set over line
    } elseif { $condition == "over_surface" } {
        set condition ""
        set over surface
    } elseif { $condition == "over_volume" } {
        set condition ""
        set over volume
    } elseif { $condition == "over_node" } {
        set condition ""
        set over node
    } elseif { $condition == "over_element" } {
        set condition ""
        set over element
    } elseif { $condition == "over_face" } {
        set condition ""
        set over face
    } else {
        set over ""
    }
    if { $condition != "" } {
        set x_path "//condition\[@n='$condition'\]"
        set dom_conditions [gid_groups_conds::GetDomNodes $x_path]
        if { [llength $dom_conditions] == 1 } {
            set dom_condition [lindex $dom_conditions 0]
            if { $geometry_or_mesh == "" } {
                set question_values [customlib::GetQuestionValues $dom_condition "./value"]
                set n [expr {[llength $question_values]/2}]
                set result [list $n {*}$question_values]
            } elseif { $geometry_or_mesh == "geometry" } {
                set over [lindex [split [$dom_condition @ov] ,] 0]
                set group_over ${over}s
                if { $entity_id_or_count == "" } {
                    set result [list]
                    set type_letter [string toupper [string index $group_over 0]]
                    set x_path_2 "./group"
                    foreach dom_group [$dom_condition selectNodes $x_path_2] {
                        set question_values [customlib::GetQuestionValues $dom_group "./value"]
                        set group [$dom_group @n]
                        set ids [GiD_EntitiesGroups get $group $group_over]
                        foreach id $ids {
                            lappend result [list $type_letter $id - {*}$question_values]
                        }
                    }
                } elseif { $entity_id_or_count == "-count" } {
                    set result 0
                    set x_path_2 "./group"
                    foreach dom_group [$dom_condition selectNodes $x_path_2] {
                        set group [$dom_group @n]
                        incr result [GiD_EntitiesGroups get $group $group_over -count]
                    }
                } else {
                    set result [list]
                    set id_min 0
                    set id_max 0
                    if { [llength [split $entity_id_or_count :]] == 2 } {
                        lassign [split $entity_id_or_count :] id_min id_max
                        if { ![string is integer -strict $id_min] || ![string is integer -strict $id_max] } {
                            error "customlib::GiD_Info-conditions wrong argument $entity_id_or_count"
                        }
                    } else {
                        if { [string is integer -strict $entity_id_or_count] } {
                            set id_min $entity_id_or_count
                            set id_max $entity_id_or_count
                        } else {
                            error "customlib::GiD_Info-conditions wrong argument $entity_id_or_count"
                        }
                    }
                    set type_letter [string toupper [string index $group_over 0]]
                    set x_path_2 "./group"
                    foreach dom_group [$dom_condition selectNodes $x_path_2] {
                        set question_values [customlib::GetQuestionValues $dom_group "./value"]
                        set group [$dom_group @n]
                        set ids [GiD_EntitiesGroups get $group $group_over]
                        foreach id $ids {
                            if { $id>=$id_min && $id<=$id_max } {
                                lappend result [list $type_letter $id - {*}$question_values]
                            }
                        }
                    }
                }
            } elseif { $geometry_or_mesh == "mesh" } {
                #set group_over nodes or elements or faces
                if { $entity_id_or_count == "" } {
                    set result [list]
                    set x_path_2 "./group"
                    foreach dom_group [$dom_condition selectNodes $x_path_2] {
                        set question_values [customlib::GetQuestionValues $dom_group "./value"]
                        set group [$dom_group @n]
                        set allowed_types [GiD_Groups get allowed_types $group]
                        foreach group_over $allowed_types {
                            if { $group_over != "nodes" && $group_over != "elements" && $group_over != "faces" } {
                                continue
                            }
                            set type_letter [string toupper [string index $group_over 0]]
                            set ids [GiD_EntitiesGroups get $group $group_over]
                            if { $group_over == "faces" } {
                                lassign $ids element_ids face_ids
                                foreach element_id $element_ids face_id $face_ids {
                                    lappend result [list $element_id $face_id - {*}$question_values]
                                }
                            } else {
                                foreach id $ids {
                                    lappend result [list $type_letter $id - {*}$question_values]
                                }
                            }
                            break ;#consider than only 1 type is allowed ?
                        }
                    }
                } elseif { $entity_id_or_count == "-count" } {
                    set result 0
                    set x_path_2 "./group"
                    foreach dom_group [$dom_condition selectNodes $x_path_2] {
                        set group [$dom_group @n]
                        set allowed_types [GiD_Groups get allowed_types $group]
                        foreach group_over $allowed_types {
                            if { $group_over != "nodes" && $group_over != "elements" && $group_over != "faces" } {
                                continue
                            }
                            incr result [GiD_EntitiesGroups get $group $group_over -count]
                            break ;#consider than only 1 type is allowed ?
                        }
                    }
                } else {
                    set result [list]
                    set id_min 0
                    set id_max 0
                    if { [llength [split $entity_id_or_count :]] == 2 } {
                        lassign [split $entity_id_or_count :] id_min id_max
                        if { ![string is integer -strict $id_min] || ![string is integer -strict $id_max] } {
                            error "customlib::GiD_Info-conditions wrong argument $entity_id_or_count"
                        }
                    } else {
                        if { [string is integer -strict $entity_id_or_count] } {
                            set id_min $entity_id_or_count
                            set id_max $entity_id_or_count
                        } else {
                            error "customlib::GiD_Info-conditions wrong argument $entity_id_or_count"
                        }
                    }
                    set x_path_2 "./group"
                    foreach dom_group [$dom_condition selectNodes $x_path_2] {
                        set question_values [customlib::GetQuestionValues $dom_group "./value"]
                        set group [$dom_group @n]
                        set allowed_types [GiD_Groups get allowed_types $group]
                        foreach group_over $allowed_types {
                            if { $group_over != "nodes" && $group_over != "elements" && $group_over != "faces" } {
                                continue
                            }
                            set type_letter [string toupper [string index $group_over 0]]
                            set ids [GiD_EntitiesGroups get $group $group_over]
                            if { $group_over == "faces" } {
                                lassign $ids element_ids face_ids
                                if { [lsearch -integer -sorted $element_ids $entity_id_or_count] != -1 } {
                                    set result $question_values
                                    break
                                }
                                foreach element_id $element_ids face_id $face_ids {
                                    if { $element_id>=$id_min && $element_id<=$id_max } {
                                        lappend result [list $element_id $face_id - {*}$question_values]
                                    }
                                }
                            } else {
                                foreach id $ids {
                                    if { $id>=$id_min && $id<=$id_max } {
                                        lappend result [list $type_letter $id - {*}$question_values]
                                    }
                                }
                            }
                            break ;#consider than only 1 type is allowed ?
                        }
                    }
                }
            } else {

            }
        } else {
            if { [llength $dom_conditions] > 1 } {
                error "Condition '$condition' repeated [llength $dom_conditions] times"
            } else {
                error "Unknown Condition '$condition'"
            }
            set result ""
        }
    } else {
        set conditions [list]
        set x_path {//condition}
        foreach dom_node [gid_groups_conds::GetDomNodes $x_path] {
            if { $over=="node" || $over=="element" || $over=="face" } {
                set ov [split [$dom_node @ovm] ,]
            } else {
                set ov [split [$dom_node @ov] ,]
            }
            if { [lsearch $ov $over] != -1 } {
                lappend conditions [$dom_node @n]
            }
        }
        set result $conditions
    }
    return $result
}
