#
# Truco para que se actualizen los menus de cascada que se actualizan con el -postcommmand:
# solo pasa con los submenus de la barra de menus
#
# no se puede usar el -postcommand, pues no permite construir/visualizar los submenus
#
# primero se registran las variables ( w_id, argumentos)
#
# para que se registren al iniciar el post, hay un nuevo prefijo: -npm-
# que lo que hace es, ademas de registrar el -postcommand de los menus
# llamarlo una vez para que se registren las variables y se pueda hacer el doUpdate...
#
# al cambiar alguna cosa hay que hacer un doUpdatePostResultsMenu / doUpdate...
#    que actualmente se hace en UpdatePostProcessInformation (tclfileP.tcl), despues
#    de cargar archivo.
#    doUpdatePostResultsMenus y doUpdatePostGraphsResultsMenus are also called
#    when changing step from menus
# para que rehaga los menus
# para que se actualizen se hace la chapuza de abrir una toplevel momentaneamente
# pasarle el foco y destruila despues
# de esta manera se actualizan los menus en cascada del menubar.
# no hay que olvidarse de proc UpdatePostProcessInformation (tclfileP.tcl)

set ::updateMacTopMenusTrickAdterID 0

proc updateMacTopMenusTrick {} {
    if { "$::updateMacTopMenusTrickAdterID" == ""} {
        # to do it only once
        return
    }
    set ::updateMacTopMenusTrickAdterID ""
    set oldFocus [ focus]
    if { [ winfo exists .pp] } { return}
    toplevel .pp
    wm geometry .pp 0x0+0+0
    focus .pp
    update
    destroy .pp
    focus $oldFocus
}

proc doUpdateMacTopMenusTrick {} {
return
    if { ![ info exists ::updateMacTopMenusTrickAdterID]} {
        set ::updateMacTopMenusTrickAdterID ""
    }
    if { "$::updateMacTopMenusTrickAdterID" != ""} {
        after cancel $::updateMacTopMenusTrickAdterID
    }
    set ::updateMacTopMenusTrickAdterID [ after idle updateMacTopMenusTrick]
}

proc doUpdatePostAnalysisStepsMenu { { doTrick 1}} {
    if { ![ info exists ::PostAnalysisStepsMenuToUpdate]} { return}
    foreach menuData $::PostAnalysisStepsMenuToUpdate {
        AddAnalysisStepsToMenu $menuData
    }

    if { $doTrick && [ esMac]} {
        doUpdateMacTopMenusTrick
    }
}

proc registerPostAnalysisStepMenu { w} {
    if { ![ info exists ::PostAnalysisStepsMenuToUpdate]} {
            set ::PostAnalysisStepsMenuToUpdate $w
    } else {
        if { [ lsearch $::PostAnalysisStepsMenuToUpdate $w] == -1} {
                lappend ::PostAnalysisStepsMenuToUpdate $w
            }
    }
}

proc doUpdatePostResultsMenus { { doTrick 1}} {
    if { ![ info exists ::PostResultsMenusToUpdate]} { return}
    foreach resType [ array names ::PostResultsMenusToUpdate] {
        foreach menuData $::PostResultsMenusToUpdate($resType) {
            AddResultsToMenu {*}$menuData
        }
    }

    if { $doTrick && [ esMac]} {
        doUpdateMacTopMenusTrick
    }
}

proc registerPostResultsMenu { w basecommand que_res sub} {
    if { ![ info exists ::PostResultsMenusToUpdate($que_res)]} {
            set ::PostResultsMenusToUpdate($que_res) {}
            lappend ::PostResultsMenusToUpdate($que_res) [ list $w "$basecommand" $que_res $sub]
    } else {
            set found 0
            foreach menuData $::PostResultsMenusToUpdate($que_res) {
                set w_id [ lindex $menuData 0]
                if { $w_id == $w} {
                    set found 1
                    break
                }
            }
            if { !$found} {
                lappend ::PostResultsMenusToUpdate($que_res) [ list $w "$basecommand" $que_res $sub]
            }
    }
}

proc defineDummyResults { w} {
    $w delete 0 end
    array set infoRes [ list displacements [ list x y z] stress [ list sxx syy sxy szz]]
    set metodoPost 0
    foreach res [ array names infoRes] {
            if { [ winfo exists $w.menu$res ]} {
                destroy $w.menu$res
            }
            if { $metodoPost} {
                proc postMenu { menu lstOpc} {
                    #WarnWinText "postted-postted $menu $lstOpc"
                    foreach comp $lstOpc {
                        $menu add command -label $comp -command "WarnWin $comp"
                        update idletasks
                    }
                    update idletasks
                    #$menu post
                }
                menu $w.menu$res -postcommand "postMenu $w.menu$res [ list $infoRes($res)]"
            } else {
                menu $w.menu$res 
                foreach comp $infoRes($res) {
                    $w.menu$res add command -label $comp -command "WarnWin $comp"
                    update idletasks
                }
                update idletasks
            }
            $w add cascade -label $res -menu $w.menu$res
    }
    #update idletasks
    return
}

proc doUpdatePostGraphsResultsMenus { { doTrick 1}} {
    if { ![ info exists ::PostGraphsResultsMenusToUpdate]} { return}
    foreach resType [ array names ::PostGraphsResultsMenusToUpdate] {
        foreach menuData $::PostGraphsResultsMenusToUpdate($resType) {
            AddGraphsResultsToMenu {*}$menuData
        }
    }

    if { $doTrick && [ esMac]} {
        doUpdateMacTopMenusTrick
    }
}

proc registerPostGraphsResultsMenu { w basecommand que_res} {
    if { ![ info exists ::PostGraphsResultsMenusToUpdate($que_res)]} {
            set ::PostGraphsResultsMenusToUpdate($que_res) {}
            lappend ::PostGraphsResultsMenusToUpdate($que_res) [ list $w $basecommand $que_res]
    } else {
            set found 0
            foreach menuData $::PostGraphsResultsMenusToUpdate($que_res) {
                set w_id [ lindex $menuData]
                if { $w_id == $w} {
                    set found 1
                    break
                }
            }
            if { !$found} {
                lappend ::PostGraphsResultsMenusToUpdate($que_res) [ list $w $basecommand $que_res]
            }
    }
}

proc doUpdatePostGraphsXYResultsMenus { { doTrick 1}} {
    if { ![ info exists ::PostGraphsXYResultsMenusToUpdate]} { return}
    foreach resType [ array names ::PostGraphsXYResultsMenusToUpdate] {
        foreach menuData $::PostGraphsXYResultsMenusToUpdate($resType) {
            AddGraphsXYResultsToMenu {*}$menuData
        }
    }

    if { $doTrick && [ esMac]} {
        doUpdateMacTopMenusTrick
    }
}

proc registerPostGraphsXYResultsMenu { w basecommand que_res} {
    if { ![ info exists ::PostGraphsXYResultsMenusToUpdate($que_res)]} {
            set ::PostGraphsXYResultsMenusToUpdate($que_res) {}
            lappend ::PostGraphsXYResultsMenusToUpdate($que_res) [ list $w "$basecommand" $que_res]
    } else {
            set found 0
            foreach menuData $::PostGraphsXYResultsMenusToUpdate($que_res) {
                set w_id [ lindex $menuData]
                if { $w_id == $w} {
                    set found 1
                    break
                }
            }
            if { !$found} {
                lappend ::PostGraphsXYResultsMenusToUpdate($que_res) [ list $w "$basecommand" $que_res]
            }
    }
}

proc doUpdateMenusMac {} {
    # doUpdatePostAnalysisStepsMenu 0
    # doUpdatePostResultsMenus 0
    # doUpdatePostGraphsResultsMenus 0
    # doUpdatePostGraphsXYResultsMenus 0
    # update 
    update idletasks
return
    doUpdateMacTopMenusTrick
}
