
proc TOExecuteSelection { w } {
    global ToolbarsPriv

    if { $ToolbarsPriv(inout) == "" } { return }

    set aa [$w.bars.t curselection]
    if { $aa == "" } {
        return
    }

    set traslatedname [$w.bars.t get $aa]
    set found 0
    foreach i $ToolbarsPriv(toolbars) {
        if { [llength $i] == "2" } {
            #old compatibility, previous versions do not exist field 3 title, used field 0 name
            set title [lindex $i 0]
        } else {
            set title [lindex $i 3]
        }
        if { $traslatedname == $title } {
            set found 1
            break
        }
    }
    if { !$found } {
        WarnWinText [_ "Toolbar %s not found" $traslatedname]
        return
    }

    switch $ToolbarsPriv(inout) {
        inside {
            if { $ToolbarsPriv(lrtb) == "" } {
                set type INSIDE
            } else {
                switch $ToolbarsPriv(lrtb) {
                    l {
                        set type INSIDELEFT
                    }
                    r {
                        set type INSIDERIGHT
                    }
                    t {
                        set type INSIDETOP
                    }
                    b {
                        set type INSIDEBOTTOM
                    }
                }
            }
        }
        outside {
            set type OPEN
        }
        none {
            set type NONE
        }
    }
    set proc_and_arguments [lindex $i 2]
    set proc_name [lindex $proc_and_arguments 0]
    if { [info procs $proc_name] == "" } {
        W "TOExecuteSelection: proc $proc_name doesn't exists"
    } else {
        {*}$proc_and_arguments $type
    }
}

proc TOConnectPosButtonsCB { w } {
    global ToolbarsPriv GiDPrivToolBar

    trace remove variable ToolbarsPriv(inout) write "TOConnectPosButtonsCB $w ;#"
    trace remove variable ToolbarsPriv(lrtb) write "TOExecuteSelection $w ;#"
    if { $ToolbarsPriv(inout) == "inside" } {
    
    
    
        set aa [$w.bars.t curselection]
        if { $aa == "" } {
            trace add variable ToolbarsPriv(inout) write "TOConnectPosButtonsCB $w ;#"
            trace add variable ToolbarsPriv(lrtb) write "TOExecuteSelection $w ;#"
            return
        }
    
    
    set traslatedname [$w.bars.t get $aa]
    set found 0
    set count 0
    foreach i $ToolbarsPriv(toolbars) {      
          if { [llength $i] == "2" } {
            #old compatibility, previous versions do not exist field 3 title, used field 0 name
            set title [lindex $i 0]
          } else {
            set title [lindex $i 3]
          }
          if { $traslatedname == $title } {
            set found 1
        set name [lindex $i 0]
            break
          }
    }
    if { !$found } {
        WarnWinText [_ "Toolbar %s not found" $traslatedname]
        return
    }
       
        if { [string match *bar $name] } {
            TOConnectPosButtons $w normal
            if { $ToolbarsPriv(lrtb) == "" } {
                set ToolbarsPriv(lrtb) t
            }
        } else {
            set ToolbarsPriv(lrtb) ""
            TOConnectPosButtons $w disabled
        }
    } else {
        set ToolbarsPriv(lrtb) ""
        TOConnectPosButtons $w disabled
    }
    TOExecuteSelection $w
    trace add variable ToolbarsPriv(inout) write "TOConnectPosButtonsCB $w ;#"
    trace add variable ToolbarsPriv(lrtb) write "TOExecuteSelection $w ;#"
}

proc TOConnectPosButtons { w state} {
    global ToolbarsPriv

    foreach i [winfo children $w.middle.f2] {
        $i configure -state $state
    }
}

proc TOCheckCurrentBar { w } {
    global ToolbarsPriv GiDPrivToolBar GidPriv

    trace remove variable ToolbarsPriv(inout) write "TOConnectPosButtonsCB $w ;#"
    trace remove variable ToolbarsPriv(lrtb) write "TOExecuteSelection $w ;#"

    set aa [$w.bars.t curselection]
    if { $aa == "" } {
        $w.middle.f2.l configure -state disabled
        set ToolbarsPriv(inout) none
        TOConnectPosButtons $w disabled
        trace add variable ToolbarsPriv(inout) write "TOConnectPosButtonsCB $w ;#"
        trace add variable ToolbarsPriv(lrtb) write "TOExecuteSelection $w ;#"
        return
    }
    set traslatedname [$w.bars.t get $aa]
    set found 0
    foreach i $ToolbarsPriv(toolbars) {
        if { [llength $i] == "2" } {
            #old compatibility, previous versions do not exist field 3 title, used field 0 name
            set title [lindex $i 0]
        } else {
            set title [lindex $i 3]
        }
        if { $traslatedname == $title } {
            set found 1
            break
        }
    }
    if { !$found } {
        WarnWinText [_ "Toolbar %s not found" $traslatedname]
        return
    }

    set name [lindex $i 0]
    set geomname [lindex $i 1]
    if { [info exists GidPriv($geomname)] } {
        set type [lindex $GidPriv($geomname) 0]
    } elseif { [string match *bar $name] } {
        set type INSIDELEFT
    } else {
        set type INSIDE
    }

    switch -glob $type {
        INSIDE {
            set ToolbarsPriv(inout) inside
            set ToolbarsPriv(lrtb) ""
            TOConnectPosButtons $w disabled
        }
        NONE {
            set ToolbarsPriv(inout) none
            set ToolbarsPriv(lrtb) ""
            TOConnectPosButtons $w disabled
        }
        OPEN {
            set ToolbarsPriv(inout) outside
            set ToolbarsPriv(lrtb) ""
            TOConnectPosButtons $w disabled
        }
        INSIDETOP* {
            set ToolbarsPriv(inout) inside
            set ToolbarsPriv(lrtb) t
            TOConnectPosButtons $w normal
        }
        INSIDELEFT* {
            set ToolbarsPriv(inout) inside
            set ToolbarsPriv(lrtb) l
            TOConnectPosButtons $w normal
        }
        INSIDEBOTTOM* {
            set ToolbarsPriv(inout) inside
            set ToolbarsPriv(lrtb) b
            TOConnectPosButtons $w normal
        }
        INSIDERIGHT* {
            set ToolbarsPriv(inout) inside
            set ToolbarsPriv(lrtb) r
            TOConnectPosButtons $w normal
        }
        default {
            WarnWin [_ "Unknown position: --%s--" $type]
        }
    }
    trace add variable ToolbarsPriv(inout) write "TOConnectPosButtonsCB $w ;#"
    trace add variable ToolbarsPriv(lrtb) write "TOExecuteSelection $w ;#"
}


proc TOInitializeToolbars {} {
    global ToolbarsPriv
    if { ![info exists ToolbarsPriv(toolbars)] } {
	#fill in to show also non-existent toolbars to be changed to visible in the toolbars position window
	set ToolbarsPriv(toolbars) [list \
					[list {Right buttons} PrePostRightButWindowGeom RightButtons [_ "Right buttons"]] \
					[list {Command line} PrePostEntryWindowGeom BottomEntryFrame [_ "Command line"]] \
					[list {Up menu} PrePostTopMenuWindowGeom TopMenuFrame [_ "Up menu"]] \
					[list {Geometry & View bar} PrePostBitmapsWindowGeom CreateBitmaps [_ "Geometry & View bar"]] \
					[list {Standard bar} PrePostStdBarWindowGeom StdBitmaps [_ "Standard bar"]] \
					[list {View results bar} PostViewResultsBarWindowGeom ViewResultsBarBitmaps [_ "View results bar"]] \
					[list MacrosToolbar PrePostMacrosToolbarWindowGeom toolbarmacros::Create [_ "Macros toolbar"]] \
					[list {Status & Information} PrePostStatusWindowGeom BottomStatusFrame [_ "Status & Information"]] ]
    }
}

#Register a window created with InitWindow to be managed as a toolbar
#name: internal toolbar name "<name> bar" (must finish with 'bar', and a unique name)
#      this name must be the same used by ReleaseToolbar
#geomvarname: Pre|Post|PrePost<id>WindowGeom , e.g. PrePostExample1WindowGeom
#      this varname must be the same used with InitWindow to create the toolbar window
#command: the command to create the toolbar
#      this command must be the same used with InitWindow to create the toolbar window
#title: an optional text (marked for translation), if not exist the name will be used

proc AddNewToolbar { name geomvarname command {title ""} } {
    #W [GidUtils::GetStackTrace]
    global ToolbarsPriv
    if { ![info exists ::ToolbarsPriv(toolbars)] } {
	TOInitializeToolbars
    }
    set index [lsearch -index 0 $ToolbarsPriv(toolbars) $name]
    if { $index !=-1 } {
        #already exists
        return 1
    }    
    if { ![string match *bar $name] } {
        WarnWin [_ "Names of the toolbars must end with 'bar'"]
    }    
    if { $title == "" } {
        set title $name
    }
    lappend ToolbarsPriv(toolbars) [list $name $geomvarname $command $title]
    return 0
}

#Unregister a window created with InitWindow to not be managed as a toolbar
#name: internal toolbar name "<name> bar" (must finish with 'bar', and a unique name)
#      this name must be the same used by AddNewToolbar
proc ReleaseToolbar { name } {
    global ToolbarsPriv
    if { ![info exists ::ToolbarsPriv(toolbars)] } {
        TOInitializeToolbars
    }
    set index [lsearch -index 0 $ToolbarsPriv(toolbars) $name]
    if { $index != -1 } {              
        set ToolbarsPriv(toolbars) [lreplace $ToolbarsPriv(toolbars) $index $index]
    } else {
        #doesn't exists
    }
}


proc TOBegin { {w .gid.toolbars } } {
    global ToolbarsPriv GIDDEFAULT

    InitWindow2 $w -title [_ "Toolbars position"] \
        -geometryvariable PrePostToolbarsPositionWindowGeom \
        -initcommand TOBegin -onlygeometry -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::frame $w.bars

    #pseudottk
    tk::listbox $w.bars.t -relief sunken \
            -yscroll "$w.bars.yscroll set" -width 35 -height 5 -exportselection 0
    $w.bars.t delete 0 end
    ttk::scrollbar $w.bars.yscroll \
            -orient vertical -command "$w.bars.t yview"

    GidHelp "$w.bars.t $w.bars.yscroll" [_ "Select here the toolbar that you want \
            to activate or deactivate"]

    grid $w.bars.t  -row 1 -column 2 -sticky nsew
    grid $w.bars.yscroll  -row 1 -column 3 -sticky ns
    grid rowconf $w.bars 1 -weight 1
    grid columnconf $w.bars 2 -weight 1

    ttk::frame $w.middle
    ttk::frame $w.middle.f1 -style groove.TFrame -borderwidth 2

    ttk::radiobutton $w.middle.f1.b1 -text [_ "Inside"] -variable ToolbarsPriv(inout) -value inside
    ttk::radiobutton $w.middle.f1.b2 -text [_ "Outside"] -variable ToolbarsPriv(inout) -value outside
    ttk::radiobutton $w.middle.f1.b3 -text [_ "None"] -variable ToolbarsPriv(inout) -value none

    GidHelp "$w.middle.f1.b1 $w.middle.f1.b2 $w.middle.f1.b3" \
            [_ "Selects the status of the toolbar. Options are:\n\
            inside: Toolbar will be inside the main program window\n\
            outside: Toolbar will become an independent window\n\
            none: Toolbar will be deactivated"]


    grid $w.middle.f1.b1 -sticky w
    grid $w.middle.f1.b2 -sticky w
    grid $w.middle.f1.b3 -sticky w

    ttk::frame $w.middle.f2 -style groove.TFrame -borderwidth 2
    set im [gid_themes::GetImage point.png medium_icons]
        ttk::radiobutton $w.middle.f2.l -style Toolbutton\
            -image $im -variable ToolbarsPriv(lrtb) -value l
    ttk::radiobutton $w.middle.f2.r -style Toolbutton\
            -image $im -variable ToolbarsPriv(lrtb) -value r
    ttk::radiobutton $w.middle.f2.b -style Toolbutton\
            -image $im -variable ToolbarsPriv(lrtb) -value b
    ttk::radiobutton $w.middle.f2.t -style Toolbutton\
            -image $im -variable ToolbarsPriv(lrtb) -value t


    GidHelp $w.middle.f2 [_ "If 'inside' is selected and the toolbar can adopt\
            different positions inside the main window, these buttons choose\
            if the window is up, left, right or bottom of the main window."]

    grid $w.middle.f2.t -row 1 -column 2
    grid $w.middle.f2.l -row 2 -column 1
    grid $w.middle.f2.r -row 2 -column 3
    grid $w.middle.f2.b -row 3 -column 2

    grid $w.middle.f1 -row 1 -column 1 -sticky wns
    grid $w.middle.f2 -row 1 -column 2 -sticky wns
    grid columnconf $w.middle 1 -weight 2
    grid columnconf $w.middle 2 -weight 1

    #ttk::frame $w.but -style groove.TFrame -borderwidth 2
    ttk::frame $w.but -style BottomFrame.TFrame
    ttk::button $w.but.close -style BottomFrame.TButton -text [_ "Close"] -command [list destroy $w] -underline 0      
    grid $w.but.close -padx 5 -pady 5

    grid $w.bars -row 1 -column 1 -sticky nsew
    grid $w.middle -row 2 -column 1 -sticky ew
    grid $w.but -row 3 -column 1 -sticky sew
    grid anchor $w.but center

    grid rowconf $w 1 -weight 1
    grid columnconf $w 1 -weight 1

    if { ![info exists ::ToolbarsPriv(toolbars)] } {
	    TOInitializeToolbars
    }

    foreach i $ToolbarsPriv(toolbars) {
        set name [lindex $i 0]
        if { [info exists ToolbarsPriv(Hide,$name)] && $ToolbarsPriv(Hide,$name) == "1" } {
            continue
        }
        if { [GetCurrentPrePostMode] == "PRE" } {
            #preprocess
            if { ![string match -nocase Pre* [lindex $i 1]] } {
                continue
            }
        } else {
            #postprocess
            if { ![string match -nocase *Post* [string range [lindex $i 1] 0 6]] } {
                continue
            }
        }
        if { [llength $i] < 4 } {
            #old compatibility, previous versions do not exist field 3 title, used field 0 name
            set title [lindex $i 0]
        } else {
            set title [lindex $i 3]
        }
        $w.bars.t insert end $title
    }
    $w.bars.t selection set 0

    TOCheckCurrentBar $w
    bind $w.bars.t <ButtonRelease-1> "TOCheckCurrentBar $w"
    bind $w.bars.t <KeyRelease> "TOCheckCurrentBar $w"  
    focus $w.bars.t
}
