#
# RunWin
#

proc RunWin { { w .gid.wrun  }  } {
    OpenProcWin $w    
}

proc GiveProcessPids { name } {
    set aa ""
    catch { set aa [exec ps -f | grep $name | grep -v /bin/time | grep -v grep] }
    set retnums ""
    while 1 {
	set newpos [expr [string first \n $aa]-1]
	if { ![catch { [expr [lindex $aa 0] > 0] } ] } {
	    lappend retnums [lindex $aa 0]
	} else { lappend retnums [lindex $aa 1] }
	if { $newpos < 0 } { break }
	set aa [string range $aa [expr $newpos+2] end]
    }
    return $retnums
}

proc TestIfExists { name window { DoIfFinished ""} } {
    set aa [GiveProcessPids $name]
    if { ![winfo exists $window] } { return }
    if { [lindex $aa 0] == "" } {
	destroy $window
	if { $DoIfFinished != "" } { eval $DoIfFinished }
	return
    }
    after 3000 TestIfExists $name $window
}

proc FillResultsWindow { w file LastSize } {
    if { ![winfo exists $w] } { return }
    if { [catch { set newsize [file size $file] }] } { $w.f.t delete 0.0 end ; return }
    if { $newsize > $LastSize } {
	$w.f.t insert end [exec tail [join "+ $LastSize c" ""] $file]
	$w.f.t yview end
	set LastSize $newsize
    }
    after 3000 FillResultsWindow $w $file $LastSize
}

proc ResultsWindow { w file } {

    catch { destroy $w }
    toplevel $w
    if { $::tcl_platform(platform) == "windows" } {
        wm attributes $w -toolwindow 1
    }
    wm title $w [_ "Results"]
    wm geometry $w -250+200

    ttk::frame $w.f
    text $w.f.t -width 80 -height 40 -xscroll "$w.f.xscroll set" \
	    -yscroll "$w.f.yscroll set" -wrap none
    ttk::scrollbar $w.f.yscroll -command "$w.f.t yview" \
		-orient vertical
    ttk::scrollbar $w.f.xscroll -command "$w.f.t xview" \
	    -orient horizontal
    pack $w.f.yscroll -side right -fill y
    pack $w.f.xscroll -fill x -side bottom
    pack $w.f.t -expand yes -fill y -anchor nw

    ttk::button $w.b -text [_ "Close"] -command "destroy $w" -style BottomFrame.TButton   

    pack $w.b -side bottom
    pack $w.f -side top

    FillResultsWindow $w $file 0
}
