
proc PTWClose { w} {
    catch {
        unset ::PostTree
    }
    destroy $w
}

proc PTWApply { w } {  
    W "PTWApply $w, to be implemented"
}

package require posttree
package require postattachablewindow

proc PostTreeCheckPath { lst_folders} {
    global PostTree
    set cur_path [ join $lst_folders //]
    set ret ""
    if { [ info exists PostTree(tree_items,$cur_path)]} {
        set ret $PostTree(tree_items,$cur_path)
    }
    return $ret
}

proc PostTreeSavePath { lst_folders item} {
    global PostTree
    set cur_path [ join $lst_folders //]
    set PostTree(tree_items,$cur_path) $item
}

proc LaunchAction { T name} {
    WarnWinDirect $name 
    raise [ winfo toplevel $T]
}

proc PostTreeCreatePath { T path} {
    global PostTree
    set lst_folders [GidUtils::Split $path //]
    set last_parent root
    set state_img(0) on
    set state_img(1) off
    set state_img2(0) [ posttree::GetImage post-on]
    set state_img2(1) [ posttree::GetImage post-off]
    set lst_colors [ list red green yellow orange cyan grey blue black orange]
    set n_colors [ llength $lst_colors]
    set n_folders [ llength $lst_folders]
    set i_folder 0
    set cur_path {}
    set idx 0
    set idx_c 0

    # temporary solution
    if { ![ info exists _images(post-blank-color-button-14)]} {
        # set act_theme [ gid_themes::GetCurrentTheme]
        # if { $act_theme == ""} {
        #     set act_theme GiD_classic
        # }
        # set folder [ file join [ gid_themes::GetThemesBaseFolder] $act_theme images PostTree]
        set folder [ file join  $::GIDDEFAULTTCL posttree images]
        set img post-blank-color-button-14
        set _images($img) [ image create photo -file [ file join $folder ${img}.gif]]
    }

    foreach folder $lst_folders {

        # create dict info
        lappend cur_path $folder
        
        set item [ PostTreeCheckPath $cur_path]
        incr i_folder
        if { $item == ""} {
            set item [ $T item create -open no -button auto]
            set bg [ $T cget -background]
            
            # parent
            $T item lastchild $last_parent $item
            
            # configuration
            set idx [ expr int( 0.5 + rand() * 1317 + $idx) % 2]
            set idx_c [ expr int( 0.5 + rand() * 1317 + $idx_c) % $n_colors]
            set col [ lindex $lst_colors $idx_c]
            if { $i_folder < $n_folders} {
                $T item style set $item postItem styFolder 
                $T item element configure $item \
                    postItem elemTxtName -text "$folder"
                #  + elemTxtCount -text "(-1-)"
            } else {
                set f [ frame $T.f$item -borderwidth 0 -width 16 -height 16 \
                            -border 1 -relief flat -background $bg]
                button $f.bColor -image $_images(post-blank-color-button-14) -borderwidth 0 \
                    -background $col \
                    -relief flat -command [ list LaunchAction $T SelectColor]
                grid $f.bColor -row 0 -column $idx -padx 0 -pady 0
                $T item style set $item postItem styOnOffColor
                $T item element configure $item \
                    postItem elemImgOnOff -image $state_img2($idx) + \
                        elemFrame -window $f + elemTxtName -text "$folder"
            }
            PostTreeSavePath $cur_path $item
        } else {
            if { $i_folder == $n_folders} {
                # WarnWinDirect "Path '$path' already exists: $item"
                    set last_parent ""
                break
            }
        }
        set last_parent $item
    }
    return $last_parent
}


proc PostTreeCreateInfoLeaf { T parent txt} {
    set item [ $T item create -open no]
    $T item lastchild $parent $item
    
    $T item style set $item postItem styInfo
    $T item element configure $item \
        postItem elemTxtName -text "$txt"
    return $item
}

proc PostTreeCreateTextLeaf { T parent txt} {
    set item [ $T item create -open no]
    $T item lastchild $parent $item
    
    $T item style set $item postItem styAny
    $T item element configure $item \
        postItem elemTxtAny -text "$txt"
    return $item
}

proc PostTreeCreateStyleLeaf { T parent txt} {
    set item [ $T item create -open no]
    $T item lastchild $parent $item

    $T item style set $item postItem styClosedActionFrame
    set bg [ $T cget -background]
    set f [ frame $T.f$item -borderwidth 0 -background $bg]
    set idx 0
    foreach img [ list bodylines transparent interior cullfrontfaces send_to_back] {
        button $f.b$img -image [ posttree::GetImage post-style-$img] -borderwidth 0 \
            -relief flat -background $bg \
            -width 16 -height 16 -command [ list LaunchAction $T $img]
        grid $f.b$img -row 0 -column $idx -padx 2
        incr idx
    }

    $T item element configure $item postItem elemFrame -window $f
#        $T item element configure $item \
#            postItem elemTxtName -text "$txt"
    return $item
}

proc PostTreeCreateEdgeWidthLeaf { T parent} {
    set item [ $T item create -open no]
    $T item lastchild $parent $item

    $T item style set $item postItem styClosedActionFrame
    set bg [ $T cget -background]
    set f [ frame $T.f$item -borderwidth 0 -background $bg]

    set ::pp($item,ew) 3
    label $f.lEdgeWidth -text "Edge width:" -background $bg
    entry $f.eEdgeWidth -textvariable ::pp($item,ew) -width 5 -relief sunken -borderwidth 1 \
        -background [ CCColorSombra $bg]
    grid $f.lEdgeWidth $f.eEdgeWidth -padx 2
    $T item element configure $item postItem elemFrame -window $f
    return $item
}

proc PostTreeCreateLeafs { T parent lst_leafs} {
    set last_parent $parent
    set state_img(0) on
    set state_img(1) off
    set idx 0
    PostTreeCreateStyleLeaf $T $last_parent "Define style & co."
    PostTreeCreateEdgeWidthLeaf $T $last_parent

    if { [ llength $lst_leafs] > 1} {
        set num_elems [ expr int( 1.5 + rand() * 100000)]
        set last_parent [ PostTreeCreateInfoLeaf $T $last_parent "Elements $num_elems"]
        foreach leaf $lst_leafs {
            # set item [ $T item create -open no]
            # 
            # # parent
            # $T item lastchild $last_parent $item
            # set last_parent $item
            
            # configuration
            # set idx_on_off [ expr $idx % 2]
            # incr idx
            # $T item style set $item postItem styFile colParent styAny colDepth styAny colOnOff styAny
            # $T item element configure $item \
            #     postItem elemTxtName -text "$leaf" , \
            #     colParent elemTxtAny -text "[$T item parent $item]" , \
            #     colDepth elemTxtAny -text "[$T depth $item]"
            # , \        # 
            #        #     colOnOff elemImgAny -image $state_img($idx_on_off)
            # 
            # # create two leafs: 
            # # 1. frame with icons for displaystyle transparency interior ...
            # # 2. info of number of elements...
            set num_elems [ expr int( 1.5 + rand() * 100000)]
            set dimension [ expr int( 1.5 + rand() * 100)]
            set txt "${leaf}: ${num_elems}, dimension = ${dimension}"
            PostTreeCreateTextLeaf $T $last_parent $txt
        }
    } else {
        set num_elems [ expr int( 1.5 + rand() * 100000)]
        set dimension [ expr int( 1.5 + rand() * 100)]
        set leaf [ lindex $lst_leafs 0]
        set txt "${leaf}: ${num_elems}, dimension = ${dimension}"
        PostTreeCreateInfoLeaf $T $last_parent $txt
    }
}

proc PostTreeCreatePreprocessSubtree { T parent } {
    set last_parent $parent

    set state_img2(0) [ posttree::GetImage post-on]
    set state_img2(1) [ posttree::GetImage post-off]
    set idx 0
    
    set item [ $T item create -open no -button yes]    
    # parent
    $T item lastchild $last_parent $item
    $T item style set $item postItem styFolder
    $T item element configure $item postItem elemTxtName -text "Preprocess"

    set idx [ expr int( 0.5 + rand() * 1317 + $idx) % 2]
    set last_parent $item
    set item [ $T item create -open no -button no]    
    $T item lastchild $last_parent $item
    $T item style set $item postItem styOnOffColor
    $T item element configure $item postItem elemImgOnOff -image $state_img2($idx) + \
        elemTxtName -text "Geometry"

    set idx [ expr int( 0.5 + rand() * 1317 + $idx) % 2]
    set item [ $T item create -open no -button no]    
    $T item lastchild $last_parent $item
    $T item style set $item postItem styOnOffColor
    $T item element configure $item postItem elemImgOnOff -image $state_img2($idx) + \
        elemTxtName -text "Mesh"

    set idx [ expr int( 0.5 + rand() * 1317 + $idx) % 2]
    set item [ $T item create -open no -button yes]    
    $T item lastchild $last_parent $item
    $T item style set $item postItem styActionFolder
    $T item element configure $item postItem elemTxtName -text "Conditions"

    set idx [ expr int( 0.5 + rand() * 1317 + $idx) % 2]
    set cond_parent $item
    set item [ $T item create -open no -button no]    
    $T item lastchild $cond_parent $item
    $T item style set $item postItem styOnOffColor
    $T item element configure $item postItem elemImgOnOff -image $state_img2($idx) + \
        elemTxtName -text "on Geometry"

    set idx [ expr int( 0.5 + rand() * 1317 + $idx) % 2]
    set item [ $T item create -open no -button no]    
    $T item lastchild $cond_parent $item
    $T item style set $item postItem styOnOffColor
    $T item element configure $item postItem elemImgOnOff -image $state_img2($idx) + \
        elemTxtName -text "on Mesh"

    # try two: ttk button
    set item [ $T item create -open no -button no]    
    $T item lastchild $last_parent $item
    $T item style set $item postItem styClosedActionFrame
    set bg [ $T cget -background]
    set f [ frame $T.f$item -borderwidth 0 -background $bg]
    ttk::button $f.bColor -text "Layers window" \
            -command [ list LaunchAction $T "Open layers window"]
    grid $f.bColor -row 0 -column 0 -padx 0 -pady 0
    $T item element configure $item postItem elemFrame -window $f

}


proc PostTreeWidget { w} {
    if { [ info exists ::PostTree]} {
        # in fact, should be ::PostTree($w,....) because we're called with different $w
            unset ::PostTree
    }
    # set T [ posttree::create $w]
    # frame $w -width 200 -height 300 -border 1 -relief flat
    # frame $w -border 1 -relief flat
    # ttk::label $w.l -text "hello world:"
    # ttk::button $w.b -text algo -command [ list WarnWinDirect hola]
    # grid $w.l -sticky e
    # grid $w.b -sticky e

    # set T [ PostTreeCreateRawTree $w]
    set T [ posttree::create $w]
    
    $T item configure root -button auto
    
    set path [ PostTreeCreatePath $T MyMesh]
    
    PostTreeCreateLeafs $T $path [ list Lines Triangles Tetrahedra]
    set path [ PostTreeCreatePath $T MyExample//Mesh]
    PostTreeCreateLeafs $T $path [ list Spheres Hexahedra Points]
    set path [ PostTreeCreatePath $T "MyExample//Mesh 2"]
    PostTreeCreateLeafs $T $path [ list Spheres Hexahedra Points]
    set path [ PostTreeCreatePath $T "MyExample//Mesh 2"]
    if { $path != ""} {
            PostTreeCreateLeafs $T $path [ list Spheres Hexahedra Points]
    }
    set path [ PostTreeCreatePath $T "Body 1"]
    PostTreeCreateLeafs $T $path [ list Tetrahedra]
    set path [ PostTreeCreatePath $T "Body 2"]
    PostTreeCreateLeafs $T $path [ list Tetrahedra]
    set path [ PostTreeCreatePath $T "Boundary"]
    PostTreeCreateLeafs $T $path [ list Triangles]
    set path [ PostTreeCreatePath $T "Shell"]
    PostTreeCreateLeafs $T $path [ list Triangles]
    
    PostTreeCreatePreprocessSubtree $T root

    return $w
}

proc PostTreeWindow { { w .wPostTreeMesh}} {

    # WarnWinText starting

    InitWindow2 $w -title [_ "Post tree"] \
        -geometryvariable PostTreeWindowGeom -initcommand PostTreeWindow
    if { ![ winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set top $w.top
    set but $w.but
    CreateApplyCloseDecorationWindow $w $top $but "PTWApply $w" "PTWClose $w"
    $w.top configure -relief flat -borderwidth 0

    set T [ PostTreeWidget $top.t]

    grid $T -sticky news
    grid rowconfigure $top 0 -weight 1
    grid columnconfigure $top 0 -weight 1

    postattachablewindow::transform $w PostTreeWidget .gid.central.s
    raise $w
}
