

namespace eval PostRangesTable {
    variable values
    variable combo
    variable PanedWindow
	
    variable resultsnames
    variable allsteps
}

proc PostRangesTable::Create { { w .gid.postrangestable } } {
    variable combo
    variable PanedWindow

    variable values
    variable resultsnames
    variable allsteps

    InitWindow2 $w -title [_ "Results ranges table"] \
        -geometryvariable PostRangesTableWindowGeom \
        -initcommand PostRangesTable::Create -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    #label $w.l1 -text [_ "Table will be applied to current result"]
    ttk::label $w.l1 -text [_ "Result"]:
    set results [GiD_Info postprocess get cur_results_list Contour_Fill]
    lappend results [_ "Current result"]
    set combo2($w) [TTKComboBox $w.cb2 -state readonly -textvariable PostRangesTable::resultsnames -values $results]
    
    if { ![info exists PostRangesTable::allsteps] } { 
	set PostRangesTable::allsteps 0 
    }
    ttk::checkbutton $w.cb -text [_ "Apply in all steps"] -variable PostRangesTable::allsteps
    set PostRangesTable::allsteps 0

    ttk::label $w.l2 -text [_ "Name"]:
    set combo($w) [TTKComboBox $w.cb1 -textvariable PostRangesTable::values($w,name) -values \
	    [GiD_Result result_ranges_table names] -modifycmd [list PostRangesTable::FillTable $w]]

    focus $w.cb1

    set bbox [ButtonBox $w.bbox -spacing 0 -padx 1 -pady 1 -homogeneous 0]
    $bbox add -image [gid_themes::GetImage check.png medium_icons] -width 20 \
	-takefocus 0 -relief link \
	-helptext [_ "Clean values fields"] -command "PostRangesTable::ButtonAction $w clean"
    $bbox add -image [gid_themes::GetImage delete.png medium_icons] -width 20 \
	-takefocus 0 -relief link \
	-helptext [_ "Delete table from window"] -command "PostRangesTable::ButtonAction $w delete"
    $bbox add -image [gid_themes::GetImage save.png medium_icons] -width 20 \
	 -takefocus 0 -relief link \
	-helptext [_ "Export tables to a file"] -command "PostRangesTable::ButtonAction $w export"
    $bbox add -image [gid_themes::GetImage open.png medium_icons] -width 20 \
	-takefocus 0 -relief link \
	-helptext [_ "Import previously exported tables"] -command \
	"PostRangesTable::ButtonAction $w import"

    set sw [ScrolledWindow $w.sw]
    set sf [ScrollableFrame $sw.sf -constrainedwidth 1]
    $sw setwidget $sf
    set f [$sf getframe]

    set pw [PanedWindow $f.pw -side top -pad 0]
    set PanedWindow($w) $pw

    set labels [list [_ "Minimum"] [_ "Maximum"] [_ "Name"]]

    for { set j 0 } { $j < 3 } { incr j } {
	set pane [$pw add -weight 1]
	label $pane.l -text [lindex $labels $j] -relief raised -borderwidth 1
	grid $pane.l -sticky ew
	grid columnconf $pane 0 -weight 1
    }

    set i 0
    while 1 {
	if { ![info exists PostRangesTable::values($w,$i,0)] && $i >= 7 } { break }
	for { set j 0 } { $j < 3 } { incr j } {
	    set pane [$pw getframe $j]
	    ttk::entry $pane.e$i -textvariable PostRangesTable::values($w,$i,$j)
	    grid $pane.e$i -sticky ewn
	    grid rowconf $pane $i -weight 0
	}
	incr i
    }
    SetTabBindings $w $pw

    for { set j 0 } { $j < 3 } { incr j } {
	set pane [$pw getframe $j]
	grid rowconf $pane $i -weight 1
    }

    ttk::button $f.b1 -image [gid_themes::GetImage ArrowDown.png small_icons] \
	-command [list PostRangesTable::IncreaseDecreaseItems $w $pw increase]
    ttk::button $f.b2 -image [gid_themes::GetImage ArrowUp.png small_icons] \
	-command [list PostRangesTable::IncreaseDecreaseItems $w $pw decrease]
    grid $pw -sticky nsew -columnspan 2
    grid $f.b1 $f.b2 -sticky w -padx 3 -pady 3
    grid columnconf $f 1 -weight 1
    grid rowconf $f 0 -weight 1
  
    ttk::frame $w.buts -style BottomFrame.TFrame

    ttk::button $w.buts.apply -text [_ "Apply"] -style BottomFrame.TButton -command "PostRangesTable::ApplyTable $w"
    ttk::button $w.buts.close -text [_ "Close"] -style BottomFrame.TButton -command "destroy $w"   

    grid $w.buts.apply -padx 3 -pady 3 -row 0 -column 0
    grid $w.buts.close -padx 3 -pady 3 -row 0 -column 1

    grid $w.l1 $w.cb2 $w.cb -sticky w
    grid $w.l2 $w.cb1 $bbox -sticky w -pady 3
    grid $sw      -     -   -sticky nsew -padx 3 -pady 3
    grid $w.buts  -     -   -sticky nsew
    grid anchor $w.buts center
    grid configure $w.cb2    -sticky ew
    grid configure $w.cb1    -sticky ew
    grid columnconf $w 1 -weight 1
    grid rowconf $w 2 -weight 1
    focus $w.buts.apply   
}

proc PostRangesTable::ButtonAction { w what } {
    variable values
    variable combo

    switch $what {
	clean {
	    foreach i [array names values $w,*] {
		set values($i) ""
		unset values($i)
	    }
	}
	delete {
	    set name $values($w,name)
	    if { [lsearch [GiD_Result result_ranges_table names] $name] == -1 } {
		WarnWin [_ "Select first a an already defined table"] $w
		return
	    }
	    set retval [MessageBoxOptionsButtons [_ "Dialog window"] \
		            [_ "Are you sure to delete table '%s' from window?" $name] \
		            {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
	    if { $retval == 1 } { return }    
	    GiD_Result result_ranges_table unassign $name        
	    GiD_Result result_ranges_table delete $name
	    $combo($w) configure -values [GiD_Result result_ranges_table names]
	    ButtonAction $w clean
	}
	import {
	    set types [list [list [_ "All files"] "*"]]
	    set file [MessageBoxGetFilename file read [_ "Import results table"] "" $types "" 0]
	    if { $file == "" } { return }
	    if { [catch { set fileid [open $file r] }] } {
		WarnWin [_ "Could not open file '%s' to read" $file] $w
		return
	    }
	    PostRangesTable::ImportTables $fileid
	    close $fileid
	    
	    $combo($w) configure -values [GiD_Result result_ranges_table names]
 
	    if { [llength [GiD_Result result_ranges_table names]] > 0 } {
		$combo($w) set [lindex [GiD_Result result_ranges_table names] end]
		FillTable $w
	    }
	}
	export {
	    set err [catch [list CheckTable $w] table]

	    if { $err } {
		WarnWin $table $w
		return
	    }
  
	    if { [GiD_Result result_ranges_table names] == "" } {
		WarnWin [_ "There are no tables to export. Use button 'Apply' before exporting"] $w
		return
	    }
	    set types [list [list [_ "All files"] "*"]]
	    set file [MessageBoxGetFilename file write [_ "Export results table"] "" $types "" 0]
	    if { $file == "" } { return }
	
	    if { [catch { set fileid [open $file w] }] } {
		WarnWin [_ "Could not open file '%s' to write" $file] $w
		return
	    }
	    foreach i [GiD_Result result_ranges_table names] {
		WriteTable $fileid $i [GiD_Result result_ranges_table get $i]
	    }
	    close $fileid
	}
    }
}

proc PostRangesTable::SetTabBindings { w pw } {

    set i 0
    while 1 {
	for { set j 0 } { $j < 3 } { incr j } {
	    set pane [$pw getframe $j]
	    if { ![winfo exists $pane.e$i] } { return }
	    if { $j == 0 } {
		set prevpane [$pw getframe 2]
		set previ [expr $i-1]
	    } else {
		set prevpane [$pw getframe [expr $j-1]]
		set previ $i
	    }
	    if { [winfo exists $prevpane.e$previ] } {
		bind $pane.e$i <<PrevWindow>> "[list tkTabToWindow $prevpane.e$previ] ;break"
	    }
	    if { $j == 2 } {
		set nextpane [$pw getframe 0]
		set nexti [expr $i+1]
	    } else {
		set nextpane [$pw getframe [expr $j+1]]
		set nexti $i
	    }
	    if { [winfo exists $nextpane.e$nexti] } {
		bind $pane.e$i <Tab> "[list tkTabToWindow $nextpane.e$nexti] ;break"
	    }
	    if { $i > 0 && $j == 0 } {
		set paneMax [$pw getframe 1]
		set prevmaxentry $paneMax.e[expr $i-1]
		bind $pane.e$i <FocusIn> [join [list [list if { [%W get] == "" } \
		    "%W insert end \[$prevmaxentry get]"] [list %W selection range 0 end]] ";"]
	    }
	}
	incr i
    }
}

proc PostRangesTable::IncreaseDecreaseItems { w pw what } {
    variable values

    set i 0
    set pane [$pw getframe 0]
    while { [winfo exists $pane.e$i] } { incr i }
    if { $what == "increase" } {
	for { set j 0 } { $j < 3 } { incr j } {
	    set pane [$pw getframe $j]
	    ttk::entry $pane.e$i -textvariable PostRangesTable::values($w,$i,$j)
	    grid $pane.e$i -sticky ewn
	    grid rowconf $pane $i -weight 0
	}
	incr i
	for { set j 0 } { $j < 3 } { incr j } {
	    set pane [$pw getframe $j]
	    grid rowconf $pane $i -weight 1
	}
    } else {
	incr i -1
	for { set j 0 } { $j < 3 } { incr j } {
	    set pane [$pw getframe $j]
	    destroy $pane.e$i
	    unset -nocomplain values($w,$i,$j)
	}
    }
    SetTabBindings $w $pw
    after idle PanedWindow::_realize $pw \[winfo width $pw] \[winfo height $pw]
}

proc PostRangesTable::FillTable { w } {
    variable values
    variable PanedWindow

    set name $values($w,name)
    
    if { [lsearch [GiD_Result result_ranges_table names] $name] != -1 } {
	set table [GiD_Result result_ranges_table get $name]
	set i 0
	foreach "min max name" $table {
	    if { ![info exists values($w,$i,0)] } {
		IncreaseDecreaseItems $w $PanedWindow($w) increase
	    }
	    set values($w,$i,0) $min
	    set values($w,$i,1) $max
	    set values($w,$i,2) $name
	    incr i
	}
	while { [info exists values($w,$i,0)] } {
	    IncreaseDecreaseItems $w $PanedWindow($w) decrease
	}
    } else {
	return   
    }
}

proc PostRangesTable::CheckTable { w } {
    variable values

    if { [string trim $values($w,name)] == "" } {
	error  [_ "Error: it is necessary to enter a table name"]
    }
    set table [list [string trim $values($w,name)]]

    set NumCols 0
    set i 0
    while { [info exists PostRangesTable::values($w,$i,0)] } {
	if { [string trim $PostRangesTable::values($w,$i,0)] == "" && \
		 [string trim $PostRangesTable::values($w,$i,1)] == "" && \
		 [string trim $PostRangesTable::values($w,$i,2)] == "" } {
	    incr i
	    continue
	}
	if { [string trim $PostRangesTable::values($w,$i,0)] == "" } {
	    lappend table ""
	} elseif { [string is double -strict $PostRangesTable::values($w,$i,0)] } {
	    lappend table $PostRangesTable::values($w,$i,0)
	} else {
	    error [_ "Error in row %s: Minimum must be a number or void" [expr $i+1]]
	}
	if { [string trim $PostRangesTable::values($w,$i,1)] == "" } {
	    if { [lindex $table end] == "" } {
		error [_ "Error in row %s: Both Minimum and Maximum cannot be void" [expr $i+1]]
	    }
	    lappend table ""
	} elseif { [string is double -strict $PostRangesTable::values($w,$i,1)] } {
	    lappend table $PostRangesTable::values($w,$i,1)
	} else {
	    error [_ "Error in row %s: Maximum must be a number or -" [expr $i+1]]
	}
	if { [string trim $PostRangesTable::values($w,$i,2)] == "" } {
	    error [_ "Error in row %s: it is necessary to enter a name" [expr $i+1]]
	}
	lappend table [string trim $PostRangesTable::values($w,$i,2)]
	incr NumCols
	incr i
    }
    if { $NumCols == 0 } {
	error [_ "Error: table is void"]
    }
    return $table
}

proc PostRangesTable::ApplyTable { w } {
    variable values
    variable combo

    set err [catch [list CheckTable $w] table]

    if { $err } {
	WarnWin $table $w
	return
    }
    set name [lindex $table 0]
    set v [lrange $table 1 end]
    if { 1 } {
	#now exists a Tcl command to create it without the auxiliary file
	if { [lsearch [GiD_Result result_ranges_table names] $name] == -1 } {
	    GiD_Result result_ranges_table create $name $v
	} else {
	    GiD_Result result_ranges_table delete $name
	    GiD_Result result_ranges_table create $name $v
	}
	if { $PostRangesTable::resultsnames != ""} {
	    if { $PostRangesTable::allsteps } {
		GiD_Result result_ranges_table assign -all $name $PostRangesTable::resultsnames
	    } else {
		GiD_Result result_ranges_table assign $name $PostRangesTable::resultsnames
	    }
	}
	#in fact the array DefinedTables must be replaced by calls to the internal 
	#data like [GiD_Result result_ranges_table names] ...
    } else {
	set dir [GiD_Info Project TmpDirectory]
	set file [file join $dir table]
	set fout [open $file w]        
	WriteTable $fout $name $v
	close $fout        
	GiD_Process Mescape Results ContOptions AddRangeTable $file 
    }
    
    #set DefinedTables($name) $v
    #$combo($w) configure -values [array names DefinedTables]
    $combo($w) configure -values [GiD_Result result_ranges_table names]
}

proc PostRangesTable::WriteTable { fout name contents } {

    puts $fout "ResultRangesTable \"$name\""
    foreach "min max name" $contents {
	puts $fout "$min - $max : \"$name\""
    }
    puts $fout "End ResultRangesTable"
}

proc PostRangesTable::ImportTables { fin } {

    set rex {ResultRangesTable\s+\"([^\"]+)\"(.*)End\s+ResultRangesTable}
    set rex2 {(\S*)\s+-\s+(\S*)\s+:\s+\"([^\"]+)\"}
    foreach "- name rest" [regexp -all -inline $rex [read $fin]] {
	set contents ""
	foreach "- min max namein" [regexp -all -inline $rex2 $rest] {
	    lappend contents $min $max $namein
	}
	if { [lsearch [GiD_Result result_ranges_table names] $name] == -1 } {
	    GiD_Result result_ranges_table create $name $contents
	} else {
	    WarnWin [_ "A table with the same name already exists"]
	    return
	}
    }
}
