
proc TkFontPreferences { cmd name {value ""}} {
    #name is of the form tk_NormalFont_family tk_NormalFont_size tk_NormalFont_weight
    set pref_name_list [ split $name _]
    set tkfont_name [ lindex $pref_name_list 1]
    set tkfont_option [ lindex $pref_name_list 2]
    set ret ""
    switch $cmd {
	"GetValue" {
	    switch $tkfont_option {
		"family" {
		    set ret [ font actual $tkfont_name -family]
		}
		"size" {
		    set ret [ font actual $tkfont_name -size]
		}
		"weight" {
		    set ret ""
		    set w [ font actual $tkfont_name -weight]
		    set s [ font actual $tkfont_name -slant]
		    if { $w == "normal" } {
			if { $s == "roman"} {
			    set ret normal
			} else {
			    set ret italic
			}
		    } else {
			if { $s == "roman"} {
			    set ret bold
			} else {
			    set ret "bold italic"
			}
		    }
		}
	    }
	}
	"SetValue" {
	    set err [ catch {
		switch $tkfont_option {
		    "family" {
			    set ret [ font configure $tkfont_name -family $value]
		    }
		    "size" {
			    set ret [ font configure $tkfont_name -size $value]
		    }
		    "weight" {
			switch $value {
			    "normal" {
				set ret [ font configure $tkfont_name -weight normal -slant roman]
			    }
			    "bold" {
				set ret [ font configure $tkfont_name -weight bold -slant roman]
			    }
			    "italic" {
				set ret [ font configure $tkfont_name -weight normal -slant italic]
			    }
			    "bold italic" {
				set ret [ font configure $tkfont_name -weight bold -slant italic]
			    }
			}
		    }
		}
	    } err_txt ]
	    if { $err} {
		ErrorWin $err_txt
	    }
	}
	"GetDefaultValue" {
	    # same as GetValue
	    switch $tkfont_option {
		"family" {
		    set ret [ gid_themes::GetDefaultFontValue $tkfont_name $tkfont_option]
		}
		"size" {
		    set ret [ gid_themes::GetDefaultFontValue $tkfont_name $tkfont_option]
		}
		"weight" {
		    set ret ""
		    set w [ gid_themes::GetDefaultFontValue $tkfont_name weight]
		    set s [ gid_themes::GetDefaultFontValue $tkfont_name slant]
		    if { $w == "normal" } {
			if { $s == "roman"} {
			    set ret normal
			} else {
			    set ret italic
			}
		    } else {
			if { $s == "roman"} {
			    set ret bold
			} else {
			    set ret "bold italic"
			}
		    }
		}
	    }
	}
    }
    return $ret
}

proc GetProjectInfoPreferences { cmd name {value ""}} {
    # just returns Project info
    set ret ""
    switch $cmd {
	"GetValue" {
            if { $name == "Quadratic"} {
                set q_type [GiD_Set Model(QuadraticType)]
                set ret $q_type
            }
        }
        "SetValue" {
        }
        "GetDefaultValue" {
            # return current values....
            set ret [ GetProjectInfoPreferences GetValue $name $value]
        }
    }
    return $ret
}

proc ChangeProjectInfoPreferences { args} {
    W "args = $args"
}
