
proc PostRegisterPlugins { dir gid_cmd { lazy 0}} {
    if { [ GetCurrentPrePostMode] != "POST"} {
	return {}
    }
    set filetail [ file tail $dir]
    set shared_ext [ info sharedlibextension]
    set files [ glob -nocomplain -tails -directory $dir -types f $filetail$shared_ext]
    # WarnWinText "glob -nocomplain -tails -directory \"$dir\" -types f \"$filetail$shared_ext\""
    # WarnWinText "        --> $files"
    set lst_lib_txt {}
    foreach lib [ lsort -unique -dictionary $files] {
	set err 0
	# WarnWinText "Files $gid_cmd LoadDynamicLib [ file join $dir $lib]"
	# set err [
	# 	 catch { GiD_Process escape escape escape escape escape \
	# 		     Files $gid_cmd LoadDynamicLib [ file join $dir $lib]} err_txt
	# 	]
	set lib_txt {}
	if { !$lazy} {
	    set err [
		     catch { set lib_txt [ GiD_PostImportDynLib load [ file join $dir $lib]]} err_txt
		    ]
	} else {
	    # the load of the library is defered: when the users explicitly selects de menu option
	    set lib_txt [ file join $dir $lib]
	}
	if { [ llength $lib_txt] > 0} {
	    lappend lst_lib_txt $lib_txt
	}
	# if { $err} {
	#     WarnWin $err_txt
	# } else {
	#     WarnWinText "        $lib --> $lib_txt"
	# }
    }
    set subdirs [ glob -nocomplain -tails -directory $dir -types d *]
    foreach link [ glob -nocomplain -tails -directory $dir -types f *.lnk] {
	if { [gid_filesystem::is_link [file join $dir $link]] == 2 } {
	    lappend subdirs $link
	}
    }
    foreach subdir [ lsort -dictionary $subdirs] {
	set ifull [ file join $dir $subdir]
	if { [ file extension $subdir] == ".lnk" && [gid_filesystem::is_link $ifull] == 2 } {
	    set subdir [file root $subdir] ;#to remove .lnk
	    set ifull [gid_filesystem::read_link $ifull 1]
	}
	set ret_lst [ PostRegisterPlugins $ifull $gid_cmd $lazy]
	if { [ llength $ret_lst] > 0} {
	    set lst_lib_txt [ concat $lst_lib_txt $ret_lst]
	}
    }
    return $lst_lib_txt
}


proc PostRegisterImportPlugins { plugins_dir category { lazy 0}} {
    if { [ GetCurrentPrePostMode] != "POST"} {
	return {}
    }
    if { ![ info exists ::PostImportPlugins]} {
	set ::PostImportPlugins [ PostRegisterPlugins [ file join $plugins_dir $category] ${category}DynamicLib $lazy]
    }
    return $::PostImportPlugins
}

proc AddPostImportPluginsToMenu { w} {
    set dir_plugins [ file join $::GIDDEFAULT plugins]
    PostRegisterImportPlugins $dir_plugins Import
    set lst_plugins [ lsort -index 1 [ GiD_PostImportDynLib list]]

    # after idle [ list foreach ln $lst_plugins { WarnWinText $ln}]

    $w delete 0 end

    if { [ llength $lst_plugins] == 0} {
	$w add command -label [ format [_ "No Import plugins could be found at %s"] \
				    $dir_plugins] -state disabled
    }

    set UnderLineList {}

    set menuIdx 0
    # definimos una variable que se actualizara con el contenido de la ayuda
    set ::txtAyuda$w ""

    # package require BWidget
    DynamicHelp::register $w menu ::txtAyuda$w

    foreach lib_info $lst_plugins {
	# lib_info = [ list lib_file_name lib_name handled_extensions lib_description]
	set text [ lindex $lib_info 1]
	set desc [ lindex $lib_info 3]
	set under [ FindUnderChar text UnderLineList]
	regsub -all { } $text {} cmd
	$w add command -label ${text}... -underline $under -command \
	    "GiD_Process escape escape escape escape escape Files ImportDynamicLib CallDynamicLib $cmd"

	DynamicHelp::register $w menuentry $menuIdx $desc
	incr menuIdx
    }
    # el balon de ayuda:
    setTooltip $w -textvariable ::txtAyuda$w
}

proc RegisterAndCall { file_name} {
    set lib_txt ""
    set err [
	     catch { set lib_txt [ GiD_PostImportDynLib load $file_name]} err_txt
	    ]
    if { $err} {
	WarnWin $err_txt
    } else {
	# foreach item $lib_txt {
	#     WarnWinText $item
	# }
	# lappend registered_lib_files [ lindex $lib_txt 0]
	set text [ lindex $lib_txt 1]
	set desc [ lindex $lib_txt 3]
	regsub -all { } $text {} cmd
	GiD_Process escape escape escape escape escape Files ImportDynamicLib CallDynamicLib $cmd
	# tcl command is call lib_name input_file_name
	# GiD_PostImportDynLib call $text $cmd
    }
}

proc AddPostImportPluginsToMenuLazy { w} {
    set dir_plugins [ file join $::GIDDEFAULT plugins]

    set lazy_list [ PostRegisterImportPlugins $dir_plugins Import 1]
    # after idle [ list WarnWinText "[ llength $lazy_list]"]
    set lst_plugins [ lsort -index 1 [ GiD_PostImportDynLib list]]

    $w delete 0 end

    if { ( [ llength $lazy_list] + [ llength $lst_plugins]) == 0} {
	$w add command -label [ format [_ "No Import plugins could be found at %s"] \
				    $dir_plugins] -state disabled
    }

    set UnderLineList {}

    set menuIdx 0
    # definimos una variable que se actualizara con el contenido de la ayuda
    set ::txtAyuda$w ""

    # package require BWidget
    DynamicHelp::register $w menu ::txtAyuda$w

    # primero las registradas:
    set registered_lib_files {}
    foreach lib_info $lst_plugins {
	# lib_info = [ list lib_file_name lib_name handled_extensions lib_description]
	lappend registered_lib_files [ lindex $lib_info 0]
	set text [ lindex $lib_info 1]
	set desc [ lindex $lib_info 3]
	set under [ FindUnderChar text UnderLineList]
	regsub -all { } $text {} cmd
	$w add command -label ${text}... -underline $under -command \
	    "GiD_Process escape escape escape escape escape Files ImportDynamicLib CallDynamicLib $cmd"
	    # "GiD_PostImportDynLib call $lib_info $cmd"

	DynamicHelp::register $w menuentry $menuIdx $desc
	incr menuIdx
    }

    # ahora las que aun no estan registradas:
    foreach lib_file $lazy_list {
	if { [ lsearch $registered_lib_files $lib_file] == -1} {
	    # no esta registrada, primero hay que registrarla
	    set text [ file root [ file tail $lib_file]]
	    set desc [_ "load %s import plug-in" $text]
	    set under [ FindUnderChar text UnderLineList]
	    regsub -all { } $text {} cmd
	    $w add command -label ${text}... -underline $under -command \
		[ list RegisterAndCall $lib_file]
	}
    }

    # el balon de ayuda:
    setTooltip $w -textvariable ::txtAyuda$w
}
