
proc FillPVariosResultsInfo {} {
    global PVariosResultsPriv GidPriv

    if { ![info exists GidPriv(PostMultipleResultsWindow)] || \
	    ![winfo exists $GidPriv(PostMultipleResultsWindow)] } { return }


    set w $GidPriv(PostMultipleResultsWindow)

    set PVariosResultsPriv(varios_resultados) [string tolower [GiD_Set PostResOverRes]]
    #WarnWinText "varios_resultados = $PVariosResultsPriv(varios_resultados)"
    set res_lst [ GiD_Info postprocess get results_view_list]
    if { [ llength $res_lst] != 0} {
	$w.ll.list delete 0 end
	foreach res $res_lst {
	    #WarnWinText "[ llength $res] -$res-"
	    set lst_ins ""
	    foreach res_txt $res {
		if { "$res_txt" != ""} {
		    if { "$lst_ins" != ""} {
		        set lst_ins "$lst_ins * $res_txt"
		    } else {
		        set lst_ins $res_txt
		    }
		}
	    }
	    $w.ll.list insert end $lst_ins
	}
	#WarnWinText "-----------------"
    }
}

proc PostMultipleResultsDelete { w} {
    global PVariosResultsPriv

    if { [ $w.ll.list size] == 1} {
	$w.ll.list selection set 0
    }

    set haysel [ catch { set setsel [ $w.ll.list curselection]}]

    if { ( $haysel != 0) || ( $setsel == {} )} {
	    WarnWin [_ "Sorry, no result selected."]
	    return error
    } else {
	set del_lst ""
	foreach idx $setsel {
	    if { [ regexp {^([^\*]*) \*.*} [ $w.ll.list get $idx] dum id_res]} {
		lappend del_lst $id_res
	    }
	}
	foreach res $del_lst {
	    regsub -all { } $res {_} id
	    GiD_Process Mescape results options DelResOverRes $id
	}
	GiD_Process Mescape
    }

}

proc PostMultipleResultsDeleteAll { w} {
    global PVariosResultsPriv
    
    $w.ll.list selection set 0 end

    set haysel [ catch { set setsel [ $w.ll.list curselection]}]

    if { ( $haysel != 0) || ( $setsel == {} )} {
	    return
    } else {
        set del_lst ""
        foreach idx $setsel {
            if { [ regexp {^([^\*]*) \*.*} [ $w.ll.list get $idx] dum id_res]} {
            lappend del_lst $id_res
            }
        }
        foreach res $del_lst {
            regsub -all { } $res {_} id
            GiD_Process Mescape results options DelResOverRes $id
        }
        GiD_Process Mescape
    }

}

proc PostMultipleResultsAccept {} {
    global PVariosResultsPriv
    GiD_Process Mescape Utilities Variables PostResOverRes $PVariosResultsPriv(varios_resultados)
    GiD_Process Mescape Results Geometry NoResults Geometry Original
}

proc PostMultipleResults { { w .gid.wMultipleResults } } {
    global PVariosResultsPriv GidPriv

    InitWindow2 $w -title [_ "Several Results"] \
        -geometryvariable PostMultipleResultsWindowGeom \
        -initcommand PostMultipleResults -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0   

    ttk::frame $w.f0

    ttk::label $w.f0.l1 -text [_ "Results view"]:
    ttk::radiobutton $w.f0.rd1 -text [_ "one by one"] \
	    -value no -variable PVariosResultsPriv(varios_resultados) \
	    -command "PostMultipleResultsAccept"
    ttk::radiobutton $w.f0.rd2 -text [_ "one over another"] \
	    -value yes -variable PVariosResultsPriv(varios_resultados) \
	    -command "PostMultipleResultsAccept"

    grid $w.f0.l1 -sticky w
    grid $w.f0.rd1 $w.f0.rd2 -sticky we

    ttk::frame $w.f1
    ttk::label $w.f1.l1 -text [_ "Current list of results"]:
    ttk::button $w.f1.del -text [_ "Delete"]  -command "PostMultipleResultsDelete $w"
    ttk::button $w.f1.del2 -text [_ "Delete all"] -command "PostMultipleResultsDeleteAll $w"

    grid $w.f1.l1 -sticky w
    grid $w.f1.del -row 0 -column 1 -sticky e
    grid $w.f1.del2 -row 0 -column 2 -sticky w
    grid columnconfigure $w.f1 0 -weight 1
    grid columnconfigure $w.f1 1 -weight 1
    grid columnconfigure $w.f1 2 -weight 1
    grid rowconfigure $w.f1 0 -weight 1

    ttk::frame $w.ll
    ttk::scrollbar $w.ll.xscroll -orient horizontal -command "$w.ll.list xview"
    #pseudottk::
    tk::listbox $w.ll.list -height 4 -xscroll "$w.ll.xscroll set" -relief sunken \
	    -selectmode browse -borderwidth 1 -font SmallFont
    #bind $w.ll.list <ButtonRelease-1> PRListboxToEntry
    ttk::scrollbar $w.ll.yscroll -command "$w.ll.list yview"    
    $w.ll.list configure -yscroll "$w.ll.yscroll set"
    pack $w.ll.yscroll -side right -fill y
    pack $w.ll.xscroll -side bottom -fill x
    pack $w.ll.list -fill both -side top -expand yes


    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame   
    #ttk::button $w.but.accept -text [_ "Apply"] -command "PostMultipleResultsAccept"
    #ttk::button $w.but.original -text [_ "Original"] -command ""
    ttk::button $w.but.close -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w]

    #grid $w.but.accept -row 0 -column 0 -padx 4 -pady 6 -sticky ew
    #grid $w.but.original -row 0 -column 1 -padx 4 -pady 10 -sticky ew
    #grid $w.but.close -row 0 -column 2 -padx 4 -pady 6 -sticky ew
    grid $w.but.close -row 0 -column 0 -padx 4 -pady 6 -sticky ew

    grid $w.f0 -sticky new -padx 3 -pady 3
    grid $w.f1 -sticky new -padx 3 -pady 3
    grid $w.ll -sticky news -padx 3 -pady 3
    grid $w.but -sticky sew
    grid anchor $w.but center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 2 -weight 1
    
    FillPVariosResultsInfo

    focus $w.but.close    
}
