
set PGDebug 0

namespace eval PostGeom {
    variable _w_id
    # pagina_malla_principal
    variable _p_mp
    # pagina__malla_copia
    variable _p_mc

    variable _MallaPrincipal
    variable _MallaCopia
    variable _DoingApply       0
}

proc FillPGInfo {} {
    global GidPriv

    if { ![info exists GidPriv(PostResultsDeformationWindow)] || \
            ![winfo exists $GidPriv(PostResultsDeformationWindow)] } { return }

    PostGeom::ActualizaVariables
}

# Rutinas pagina PRINCIPAL

#visualization: Deformation 
#property: FactorType
proc PostGeom::GetResultsPreference { result visualization property } {
    set value [GiD_Info postprocess get results_preference $result $visualization $property]
    return $value
}

proc PostGeom::SetResultsPreference { result visualization property value } {
    GiD_Process Mescape Results ResultsPreferences $result $visualization $property $value escape
}

proc PostGeom::CambioAnalisisPrincipal { } {
    variable _MallaPrincipal
    
    if { $::PGDebug } {
        WarnWinText "PostGeom::CambioAnalisisPrincipal $_MallaPrincipal(analisis)"
    }

    # all analysis steps
    if { $_MallaPrincipal(analisis) != "" } {
        if { [ catch { set list_steps [ GiD_Info postprocess get all_steps $_MallaPrincipal(analisis)]}]} {
            set list_steps {}
        }
        set step [ GiD_Info postprocess get cur_step $_MallaPrincipal(analisis)]
        if { $step == "" || [lsearch $list_steps $step] == -1 } {
            set step [lindex $list_steps 0]
        }
    } else {
        set list_steps ""
        set step ""
    }
    if { [$_MallaPrincipal(step,wid) cget -values] != $list_steps } {
        $_MallaPrincipal(step,wid) configure -values $list_steps         
    }
    set _MallaPrincipal(step) $step
    if { $::PGDebug} {
        WarnWinText "setting '$_MallaPrincipal(step)' from '$list_steps'"
    }
    #PostGeom::OnChangeStepMain
}

proc PostGeom::OnChangeStepMain { } {
    variable _MallaPrincipal
      if { $_MallaPrincipal(step) == ""} {
        set _MallaPrincipal(resultado) ""
        PostGeom::OnChangeResultMain
        return
    }

    set prev_analysis [GiD_Info postprocess get cur_analysis]
    set prev_step [GiD_Info postprocess get cur_step $prev_analysis]
    
    set changed 0
    if { $prev_analysis != $_MallaPrincipal(analisis) || $prev_step != $_MallaPrincipal(step) } {
        set changed 1        
    }
    if { $changed } {
        GiD_Process Mescape Results AnalysisSel $_MallaPrincipal(analisis) $_MallaPrincipal(step) escape
    }   
    set all_values [GiD_Info postprocess get main_geom_all_deform]
    set all_labels {}
    foreach j $all_values {
        lappend all_labels [TranslateResultName $j]
    }
    $_MallaPrincipal(resultado,wid) configure -labels $all_labels -values $all_values
    set _MallaPrincipal(resultado) [lindex $all_values 0]
    
    PostGeom::OnChangeResultMain
    if { $changed } {    
        GiD_Process Mescape Results AnalysisSel $prev_analysis $prev_step escape
    }
}

proc PostGeom::OnChangeResultMain { } {
    variable _MallaPrincipal

    if { $::PGDebug} {
        WarnWinText "PostGeom::OnChangeResultMain $_MallaPrincipal(resultado)"
    }

    if { $_MallaPrincipal(resultado) == ""} {
        set _MallaPrincipal(factor) 1
        set _MallaPrincipal(FactorFijo) 0
        return
    }

    if { $_MallaPrincipal(analisis) != "" && $_MallaPrincipal(step) != "" && $_MallaPrincipal(resultado) != "" } {
        #set old_deformation_type [GiD_Info postprocess get main_geom_deformation_type]
        GiD_Process Mescape Results Options DeformationType $_MallaPrincipal(TipoDeformacion) escape
        set _MallaPrincipal(factor) [GiD_Info postprocess get main_geom_factor $_MallaPrincipal(analisis) $_MallaPrincipal(step) $_MallaPrincipal(resultado)]
        set tipo_factor [PostGeom::GetResultsPreference $_MallaPrincipal(resultado) Deformation FactorType]
        if { [ string equal -nocase $tipo_factor "Fixed"] } {
            set _MallaPrincipal(FactorFijo) 1
        } else {
            set _MallaPrincipal(FactorFijo) 0
        }
        GiD_Process Mescape Results Options DeformationType Relative escape
    } else {
        set _MallaPrincipal(factor) 1
        set _MallaPrincipal(FactorFijo) 0
    }
}

proc PostGeom::GetGiDResultsInfoPrincipal { estado} {
    variable _MallaPrincipal

    # todos los analisis
    set all_analysis_values [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    if { $::PGDebug} {
        WarnWinText "adding pseudo trace"
    }
    set all_analysis_labels {}
    foreach j $all_analysis_values {
        lappend all_analysis_labels [TranslateResultName $j]
    }  

    $_MallaPrincipal(analisis,wid) configure -values $all_analysis_values \
        -labels $all_analysis_labels

    # analisis actual
    set cur [ GiD_Info postprocess get cur_analysis]
    if { $cur == "" } {
        set cur [ lindex $all_analysis_values 0]
    }
    set _MallaPrincipal(analisis) $cur
    PostGeom::CambioAnalisisPrincipal
}


#rutina pagina COPIA

proc PostGeom::CambioAnalisisCopia { } {
    variable _MallaCopia    
    # all analysis steps
    if { $_MallaCopia(analisis) != "" } {
        if { [ catch { set list_steps [ GiD_Info postprocess get all_steps $_MallaCopia(analisis)]}]} {
            set list_steps {}
        }
        set step [ GiD_Info postprocess get cur_step $_MallaCopia(analisis)]
    } else {
        set list_steps ""
        set step ""
    }
    if { [$_MallaCopia(step,wid) cget -values] != $list_steps } {
        $_MallaCopia(step,wid) configure -values $list_steps
        set _MallaCopia(step) $step
    }
}

proc PostGeom::OnChangeStepCopy { } {
    variable _MallaCopia

    if { ![ info exists _MallaCopia(step)] || ( "$_MallaCopia(step)" == "")} {
        set _MallaCopia(resultado) ""
        PostGeom::OnChangeResultCopy
        return
    }

    if { [ info exists _MallaCopia(analisis)] && ( $_MallaCopia(analisis) != "") } {
        set analisis $_MallaCopia(analisis)
        if { [ catch { set list_steps [ GiD_Info postprocess get all_steps $analisis]}]} {
            set list_steps {}
        }
        if { [ lsearch $list_steps $_MallaCopia(step)] == -1} {
            set _MallaCopia(resultado) ""
            PostGeom::OnChangeResultCopy
            return
        }
    } else {
        set _MallaCopia(resultado) ""
        PostGeom::OnChangeResultCopy
        return
    }

    set str_analisis $_MallaCopia(analisis)    
    set all_values [ GiD_Info postprocess get show_geom_all_deform \
            $str_analisis $_MallaCopia(step)]
    set all_labels {}
    foreach j $all_values {
        lappend all_labels [TranslateResultName $j]        
    }
    $_MallaCopia(resultado,wid) configure -labels $all_labels -values $all_values
    set _MallaPrincipal(resultado) [lindex $all_values 0]
    

    PostGeom::OnChangeResultCopy
}

proc PostGeom::OnChangeResultCopy { } {
    variable _MallaCopia

    if { $_MallaCopia(resultado) == ""} {
        set _MallaCopia(factor) 1
        set _MallaCopia(FactorFijo) 0
        return
    }

    if { $_MallaCopia(analisis) != "" && $_MallaCopia(step) != "" && $_MallaCopia(resultado) != "" } {
        set def_vec $_MallaCopia(resultado)
        set res_anal $_MallaCopia(analisis)
        GiD_Process Mescape Results Options DeformationType $_MallaCopia(TipoDeformacion)
        set _MallaCopia(factor) [GiD_Info postprocess get main_geom_factor $res_anal $_MallaCopia(step) $def_vec]
        set tipo_factor [PostGeom::GetResultsPreference $def_vec Deformation FactorType]
        if { [ string equal -nocase $tipo_factor "Fixed"] } {
            set _MallaCopia(FactorFijo) 1
        } else {
            set _MallaCopia(FactorFijo) 0
        }
        GiD_Process Mescape Results Options DeformationType Relative
    } else {
        set _MallaCopia(factor) 1
        set _MallaCopia(FactorFijo) 0
    }
}

proc PostGeom::GetGiDResultsInfoCopia { estado} {
    variable _MallaCopia
    # todos los analisis
    set all_analysis_values [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    set all_analysis_labels {}
    foreach j $all_analysis_values {
        lappend all_analysis_labels [TranslateResultName $j]
    }
    $_MallaCopia(analisis,wid) configure -values $all_analysis_values -labels $all_analysis_labels

    # analisis actual
    set cur [ GiD_Info postprocess get cur_analysis]
    if { $cur == "" } {
        set cur [lindex $all_analysis_values 0]
    }
    set _MallaCopia(analisis) $cur
    PostGeom::CambioAnalisisCopia   
}

proc PostGeom::ActualizaVariables { } {
    variable _w_id

    variable _MallaPrincipal
    variable _MallaCopia
    variable _DoingApply

    if { $_DoingApply} { 
        return
    }
    
    DeleteTraceVariables $_w_id $_w_id

    # averiguar estado malla principal

    set mainst [ GiD_Info postprocess get main_geom_state]
    set _MallaPrincipal(estado) $mainst
    set maindeftyp [ GiD_Info postprocess get main_geom_deformation_type]
    set _MallaPrincipal(TipoDeformacion) $maindeftyp


    GetGiDResultsInfoPrincipal $mainst

    if { "$mainst" == "Original"} {
        $_MallaPrincipal(wid_pagina).frd.rd1 invoke
        #DisableResultFactorWidget $_MallaPrincipal(wid_pagina).rs
    } else {
        $_MallaPrincipal(wid_pagina).frd.rd2 invoke
        #DisableResultFactorWidget $_MallaPrincipal(wid_pagina).rs
    }

#     if { "$maindeftyp" == "relative"} {
#         $_MallaPrincipal(wid_pagina).rs.fs.cb1 deselect
#     } else { # == "absolute"
#         $_MallaPrincipal(wid_pagina).rs.fs.cb1 select
#     }
    set ::[$_MallaPrincipal(wid_pagina).rs.fa.cb1 cget -variable] $maindeftyp

    foreach i "estado analisis step resultado factor FactorFijo TipoDeformacion" {
        set _MallaPrincipal(antes,$i) $_MallaPrincipal($i)
    }

    # mejor hacerlo antes que buscar los valores de la malla de copia
    # pues igual me deshabilita el radio button y no puedo activarlos
    # el color de la copia
    set res [ GiD_Info postprocess get show_geom_color]

    set _MallaCopia(TipoColor) [ lindex $res 0]
    $_MallaCopia(Color,wid) configure -background [ lindex $res 1]
    set _MallaCopia(Color) [ lindex $res 1]
    if { $_MallaCopia(TipoColor) == "UserColor"} {
        #$_MallaCopia(wid_pagina).fcol.rd2 invoke
        set ::[$_MallaCopia(wid_pagina).rs.fa.cb1 cget -variable] "absolute"
        $_MallaCopia(Color,wid) configure -state normal
    } else {
        #$_MallaCopia(wid_pagina).fcol.rd1 invoke
        set ::[$_MallaCopia(wid_pagina).rs.fa.cb1 cget -variable] "relative"
        $_MallaCopia(Color,wid) configure -state disabled
    }

    foreach i "TipoColor Color" {
        set _MallaCopia(antes,$i) $_MallaCopia($i)
    }

    # ahora la copia
    set copiast [ GiD_Info postprocess get show_geom_state]
    set _MallaCopia(estado) $copiast
    set showdeftyp [ GiD_Info postprocess get show_geom_deformation_type]
    set _MallaCopia(TipoDeformacion) $showdeftyp

    GetGiDResultsInfoCopia $copiast
    if { $copiast == "Off"} {
        $_MallaCopia(wid_pagina).frd.rd1 invoke
    } elseif { $copiast == "Original"} {
        $_MallaCopia(wid_pagina).frd.rd2 invoke
    } else {
        $_MallaCopia(wid_pagina).frd.rd3 invoke
    }

#     if { "$showdeftyp" == "relative"} {
#         $_MallaCopia(wid_pagina).rs.fs.cb1 deselect
#     } else { # == "absolute"
#         $_MallaCopia(wid_pagina).rs.fs.cb1 select
#     }
    set ::[$_MallaCopia(wid_pagina).rs.fa.cb1 cget -variable] $showdeftyp

    foreach i "estado analisis step resultado factor FactorFijo TipoDeformacion" {
        set _MallaCopia(antes,$i) $_MallaCopia($i)
    }

    SetTraceVariables
}

proc DisableResultFactorEntry { w } {
    $w.fa.e configure -foreground grey60
    $w.fa.e configure -state disabled
}

proc EnableResultFactorEntry { w } {
    $w.fa.e configure -foreground black
    $w.fa.e configure -state normal
}

proc DisableResultFactorWidget { w } {
    $w.fa.la configure -foreground grey60
    $w.fa.ma configure -state disabled
    $w.fa.ls configure -foreground grey60
    $w.fa.cb configure -state disabled
    $w.fa.cb1 configure -state disabled


    $w.fa.lr configure -foreground grey60
    $w.fa.lb configure -state disabled
    $w.fa.l configure -foreground grey60
    DisableResultFactorEntry $w
    $w.fa.c configure -state disabled
}

proc EnableResultFactorWidget { w } {
    $w.fa.la configure -foreground black
    $w.fa.ma configure -state normal

    $w.fa.ls configure -foreground black
    $w.fa.cb configure -state normal
    $w.fa.cb1 configure -state normal

    $w.fa.lr configure -foreground black
    $w.fa.lb configure -state normal
    $w.fa.l configure -foreground black
    EnableResultFactorEntry $w
    $w.fa.c configure -state normal
}

proc DisableColorCopiaWidgets { w} {
    $w.cb1 configure -state disabled
    $w.b configure -state disabled
}

proc EnableColorCopiaWidgets { w} {
    $w.cb1 configure -state normal
    $w.b configure -state normal
}

proc PostGeom::CambiaMalla { cual que w_id} {
    variable $cual

    set PostGeom::${cual}(estado) $que
    if { $que == "Deformed"} {
        EnableResultFactorWidget $w_id.rs
    } else {
        DisableResultFactorWidget $w_id.rs
    }

    if { $cual == "_MallaCopia"} {
        if { "$que" == "Off"} {
            DisableColorCopiaWidgets $w_id.fcol
        } else {
            EnableColorCopiaWidgets $w_id.fcol
        }
    }

    PostGeom::CambiaFactorFijo $cual $w_id.rs
}

proc PostGeom::CambiaFactorFijo { cual w_id} {
    variable $cual

    if { [ subst $[ subst PostGeom::${cual}(FactorFijo)]]} {
        DisableResultFactorEntry $w_id
    } else {
        EnableResultFactorEntry $w_id
    }
}

proc PostGeom::ChangeTypeColorCopy { tipo} {
    variable _MallaCopia

    set _MallaCopia(TipoColor) $tipo
    if { $_MallaCopia(TipoColor) == "UserColor"} {
        $_MallaCopia(Color,wid) configure -state normal
    } else {
        $_MallaCopia(Color,wid) configure -state disabled
    }
}

proc PostGeom::ChangeTypeColorCopy2 { } {
    global PG_MallaColorCopia

    ChangeTypeColorCopy $PG_MallaColorCopia
}



proc PostGeom::CambiaColorCopia { wb} {
    variable _MallaCopia
    set nuevo [ GIDChooseColor $wb.selcolor -title [_ "Select color"] -color [$wb cget -background]]
    if { [ string length $nuevo]} {
        $wb configure -background $nuevo
        set _MallaCopia(Color) $nuevo
    }
}

proc PostGeom::TipoDeformacion { cual} {
    variable $cual
    global PG_tipo_defor

    set PostGeom::${cual}(TipoDeformacion) $PG_tipo_defor($cual)
    if { $cual == "_MallaPrincipal"} {
        PostGeom::OnChangeResultMain
    } else {
        PostGeom::OnChangeResultCopy
    }
}


proc PostGeom::CreateResultFactorSelectionWidget { w storevar} {
    global PG_tipo_defor

    ttk::frame $w -borderwidth 0

    ttk::frame $w.fa -borderwidth 0
    ttk::label $w.fa.la -text [_ "Analysis"]:
    #labels can be translated
    set values [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    set labels {}
    foreach i $values {
        lappend labels [TranslateResultName $i]
    }
    TTKComboBox $w.fa.ma -textvariable PostGeom::${storevar}(analisis) -state readonly
    if { $storevar == "_MallaPrincipal" } {
        $w.fa.ma configure -modifycmd PostGeom::CambioAnalisisPrincipal
    } elseif {$storevar == "_MallaCopia"} {
        $w.fa.ma configure -modifycmd PostGeom::CambioAnalisisCopia
    }
    
    grid $w.fa.la -column 0 -row 0 -sticky w
    grid $w.fa.ma -column 1 -row 0 -sticky w

    
    set PostGeom::${storevar}(analisis,wid) $w.fa.ma

    ttk::label $w.fa.ls -text [_ "Step"]:
    TTKComboBox $w.fa.cb -textvariable PostGeom::${storevar}(step) -state readonly 

    if { ![info exists PG_tipo_defor($storevar)] } { set PG_tipo_defor($storevar) relative }
    ttk::checkbutton $w.fa.cb1 -text [_ "Position vector"] -variable PG_tipo_defor($storevar) -onvalue absolute -offvalue relative  -command [list PostGeom::TipoDeformacion $storevar]    
   
    grid $w.fa.ls -column 0 -row 1 -sticky w
    grid $w.fa.cb -column 1 -row 1 -sticky w
    grid $w.fa.cb1 -column 2 -row 1 -padx 5 -sticky w
    
    set PostGeom::${storevar}(step,wid) $w.fa.cb

    ttk::label $w.fa.lr -text [_ "Result"]:
    TTKComboBox $w.fa.lb -textvariable PostGeom::${storevar}(resultado) -state readonly
    
    
    grid $w.fa.lr -column 0 -row 2 -sticky w
    grid $w.fa.lb -column 1 -row 2 -sticky w
    
    set PostGeom::${storevar}(resultado,wid) $w.fa.lb

    ttk::label $w.fa.l -text [_ "Factor"]:
    
    if { ![info exists PostGeom::${storevar}(factor)] } { set PostGeom::${storevar}(factor) "" }

    ttk::entry $w.fa.e -textvariable PostGeom::${storevar}(factor)  
    if { ![info exists PostGeom::${storevar}(FactorFijo)] } { set PostGeom::${storevar}(FactorFijo) 0 }
    ttk::checkbutton $w.fa.c -variable PostGeom::${storevar}(FactorFijo) -text [_ "fixed deformation"] -command [list PostGeom::CambiaFactorFijo $storevar $w]

    grid $w.fa.l -column 0 -row 3 -sticky w
    grid $w.fa.e -column 1 -row 3 -sticky w
    grid $w.fa.c -column 2 -row 3 -padx 5 -sticky w
    
    set PostGeom::${storevar}(factor,wid) $w.fa.l

    grid $w.fa -sticky we -padx 2 -pady 0
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    grid rowconfigure $w 1 -weight 1
    grid rowconfigure $w 2 -weight 1

}

proc PostGeom::Apply {  w_ntb } {
    variable _w_id
    variable _MallaPrincipal
    variable _MallaCopia
    variable _DoingApply

    set current_tab [$w_ntb raise]
    if { $current_tab == "ViewResults"} {
        PRAccept
        return
    }

    # as VerificaReal has been changed, we need to do extra verifying !!!
    if { $_MallaPrincipal(estado) == "Deformed"} {
        if { ![ VerificaReal [_ "Main mesh deformation factor"]: $_MallaPrincipal(factor) $_w_id]} {
            set def_vec $_MallaPrincipal(resultado)
            set res_anal $_MallaPrincipal(analisis)
            set _MallaPrincipal(factor) [ GiD_Info postprocess \
                                              get main_geom_factor $res_anal $_MallaPrincipal(step) $def_vec]
            return            
        }
    }
    
    # as VerificaReal has been changed, we need to do extra verifying !!!
    if { $_MallaCopia(estado) == "Original"} {
        if { ![ VerificaReal [_ "Reference mesh deformation factor"]: $_MallaCopia(factor)  $_w_id]} {
            set def_vec $_MallaCopia(resultado)
            set res_anal $_MallaCopia(analisis)
            set _MallaCopia(factor) [ GiD_Info postprocess \
                                          get main_geom_factor $res_anal $_MallaCopia(step) $def_vec]
            return
        }
    }

    set _DoingApply 1

    set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    set redibujar 0

    # la malla PRINCIPAL
    set change_main_mesh 0
    set main_mesh_items [list estado analisis step resultado factor FactorFijo TipoDeformacion]
    foreach i $main_mesh_items {
        if { $_MallaPrincipal(antes,$i) != $_MallaPrincipal($i)} {
            set change_main_mesh 1
            break
        }
    }

    if { $change_main_mesh} {
        set result $_MallaPrincipal(resultado)
        if { $_MallaPrincipal(estado) == "Deformed"} {
            if { $_MallaPrincipal(FactorFijo)} {
                set tipo_factor Fixed
            } else {
                set tipo_factor Dynamic
            }
            PostGeom::SetResultsPreference $result Deformation FactorType $tipo_factor
            PostGeom::SetResultsPreference $result Deformation Factor $_MallaPrincipal(factor)
            if { $result != "" && $_MallaPrincipal(analisis) != "" && $_MallaPrincipal(step) != ""} {
                GiD_Process Mescape Results Options DeformationType $_MallaPrincipal(TipoDeformacion) escape
                GiD_Process Mescape Results AnalysisSel $_MallaPrincipal(analisis) $_MallaPrincipal(step) Geometry Deformation $result $_MallaPrincipal(factor) escape
                #GiD_Process Mescape Results Options DeformationType Relative escape
            }
        } else {
            GiD_Process Mescape Results Geometry Original escape
        }
        set redibujar 1
        
        # ahora el nuevo estado es este
        foreach i $main_mesh_items {
            set _MallaPrincipal(antes,$i) $_MallaPrincipal($i)
        }
    }

    # el color de la COPIA
    set change_reference_mesh_color 0
    set reference_mesh_color_items [list TipoColor Color]
    foreach i $reference_mesh_color_items {
        if { $_MallaCopia(antes,$i) != $_MallaCopia($i)} {
            set change_reference_mesh_color 1
            break
        }
    }

    if { $change_reference_mesh_color} {
        if { $_MallaCopia(TipoColor) == "UserColor"} {
            GiD_Process Mescape Results Geometry ChangeShowCol DefineColor $_MallaCopia(Color) escape
        } else {
            GiD_Process Mescape Results Geometry ChangeShowCol MeshColor escape
        }
        set redibujar 1
        # ahora el nuevo estado es este
        foreach i $reference_mesh_color_items {
            set _MallaCopia(antes,$i) $_MallaCopia($i)
        }
    }

    # la malla COPIA
    set change_reference_mesh 0
    set reference_mesh_items [list estado analisis step resultado factor FactorFijo TipoDeformacion]
    foreach i $reference_mesh_items {
        if { $_MallaCopia(antes,$i) != $_MallaCopia($i)} {
            set change_reference_mesh 1
            break
        }
    }

    if { !$change_reference_mesh } {
        if { $change_reference_mesh_color && ($_MallaCopia(estado) == "Original" || $_MallaCopia(estado) == "Deformed")} {
            #to force rebuild the opengl list inner representation
            set change_reference_mesh 1
        }
    }
    
    if { $change_reference_mesh} {      
        if { $_MallaCopia(estado) == "Original"} {
            GiD_Process Mescape Results Geometry ShowOriginal escape
        } elseif { $_MallaCopia(estado) == "Deformed"} {
            set result $_MallaCopia(resultado)
            set res_anal $_MallaCopia(analisis)
            set tipo_factor Dynamic
            if { $_MallaCopia(FactorFijo)} {
                set tipo_factor Fixed
            }
            PostGeom::SetResultsPreference $result Deformation FactorType $tipo_factor
            PostGeom::SetResultsPreference $result Deformation Factor $_MallaCopia(factor)
            if { ( $result != "") && ( $res_anal != "") && ( $_MallaCopia(step) != "")} {
                GiD_Process Mescape Results Options DeformationType $_MallaCopia(TipoDeformacion)
                GiD_Process Mescape Results Geometry ShowDeformed $res_anal $_MallaCopia(step) $result $_MallaCopia(factor) escape
                #GiD_Process Mescape Results Options DeformationType Relative escape
            }
        } elseif { $_MallaCopia(estado) == "Off"} {
            GiD_Process Mescape Results Geometry HideTheShow escape
        } else {
            #unexpected
            GiD_Process Mescape Results Geometry HideTheShow escape
        }
        set redibujar 1

        # ahora el nuevo estado es este
        foreach i $reference_mesh_items {
            set _MallaCopia(antes,$i) $_MallaCopia($i)
        }
    }


    # lo separamos por si lo de arriba da un error
    GiD_Set AutomaticRedraw $oldAutomaticRedraw

    if { $redibujar} {
        GiD_Redraw
    }
    set _DoingApply 0
}

proc PostGeom::SetTraceVariables { } {
    variable _MallaPrincipal
    variable _MallaCopia
    trace variable _MallaPrincipal(step) w "PostGeom::OnChangeStepMain;#"
    trace variable _MallaPrincipal(resultado) w "PostGeom::OnChangeResultMain;#"
    trace variable _MallaCopia(step) w "PostGeom::OnChangeStepCopy;#"
    trace variable _MallaCopia(resultado) w "PostGeom::OnChangeResultCopy;#"
}

proc PostGeom::DeleteTraceVariables { w_evento w_padre} {
    variable _MallaPrincipal
    variable _MallaCopia
    if { $w_evento == $w_padre} {
        trace vdelete _MallaPrincipal(step) w "PostGeom::OnChangeStepMain;#"
        trace vdelete _MallaPrincipal(resultado) w "PostGeom::OnChangeResultMain;#"
        trace vdelete _MallaCopia(step) w "PostGeom::OnChangeStepCopy;#"
        trace vdelete _MallaCopia(resultado) w "PostGeom::OnChangeResultCopy;#"
    }
}

proc PostGeom::Create { { w .gid.wPostGeom } } {
    variable _w_id
    variable _p_mp
    variable _p_mc
    variable _MallaPrincipal
    variable _MallaCopia
    variable _DoingApply
    global PG_MallaColorCopia

    set _w_id $w
    set _DoingApply 0

    InitWindow2 $w -title [_ "View Results & Deformation"] \
        -geometryvariable PostResultsDeformationWindowGeom \
        -initcommand PostGeom::Create \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    DeleteTraceVariables $w $w

    set def_back [ $w cget -background]
    set realzado [ CCColorActivo $def_back]

    # marco de las cosas:
    ttk::frame $w.f -borderwidth 0

    NoteBook $w.f.nb -internalborderwidth 0 -activebackground $realzado

    # page to visualize results
    set _p_vr [ $w.f.nb insert end ViewResults -text [_ "View results"]]
    PostResults $_p_vr 1

    # pagina de la geometria principal
    set _p_mp [ $w.f.nb insert end MainMesh -text [_ "Main Mesh"]]

    text $_p_mp.t -borderwidth 4 -relief flat -width 20 -height 2 -wrap word -background $realzado
    $_p_mp.t insert end [_ "Results will be drawn on this deformed model."]
    $_p_mp.t configure -state disabled

    ttk::labelframe $_p_mp.f -text [_ "Deform main mesh"]

    ttk::frame $_p_mp.f.frd -borderwidth 0

    if { ![info exists _MallaPrincipal(estado)] } { set _MallaPrincipal(estado) [GiD_Info postprocess get main_geom_state] }
    ttk::radiobutton $_p_mp.f.frd.rd1 -text [_ "Original"] -value Original -variable _MallaPrincipal(estado) \
            -command "PostGeom::CambiaMalla _MallaPrincipal Original $_p_mp.f"
    ttk::radiobutton $_p_mp.f.frd.rd2 -text [_ "Deformed"] -value Deformed -variable _MallaPrincipal(estado) \
            -command "PostGeom::CambiaMalla _MallaPrincipal Deformed $_p_mp.f"
    grid $_p_mp.f.frd.rd1 $_p_mp.f.frd.rd2 -sticky ew -padx 4 -pady 2

    set _MallaPrincipal(wid_pagina) $_p_mp.f
    PostGeom::CreateResultFactorSelectionWidget $_p_mp.f.rs _MallaPrincipal

    grid $_p_mp.f.frd -sticky new -padx 4 -pady 0
    grid $_p_mp.f.rs -sticky enws -padx 4 -pady 3
    grid $_p_mp.f -sticky nwes -padx 4 -pady 8
    grid $_p_mp.t -sticky nwes -padx 4 -pady 8
    grid columnconfigure $_p_mp.f 0 -weight 1
    grid rowconfigure $_p_mp.f 2 -weight 1
    grid columnconfigure $_p_mp 0 -weight 1
    grid rowconfigure $_p_mp "0 1" -weight 1


    ##############################
    # pagina de la geometria de referencia ( copia del modelo)
    set _p_mc [ $w.f.nb insert end CopyMesh -text [_ "Reference mesh"]]

    text $_p_mc.t -borderwidth 4 -relief flat -width 20 -height 3 -wrap word -background $realzado
    $_p_mc.t insert end [_ "This is a snapshot of the model. Results will NOT be drawn over this representation."]
    $_p_mc.t configure -state disabled

    ttk::labelframe $_p_mc.f -text [_ "Deform reference mesh"]
    ttk::frame $_p_mc.f.frd -borderwidth 0
    if { ![info exists _MallaCopia(estado)] } { set _MallaCopia(estado) [GiD_Info postprocess get show_geom_state] }
    ttk::radiobutton $_p_mc.f.frd.rd1 -text [_ "Off"] -value Off -variable _MallaCopia(estado) \
            -command "PostGeom::CambiaMalla _MallaCopia Off $_p_mc.f"
    ttk::radiobutton $_p_mc.f.frd.rd2 -text [_ "Original"] -value Original -variable _MallaCopia(estado) \
            -command "PostGeom::CambiaMalla _MallaCopia Original $_p_mc.f"
    ttk::radiobutton $_p_mc.f.frd.rd3 -text [_ "Deformed"] -value Deformed -variable _MallaCopia(estado) \
            -command "PostGeom::CambiaMalla _MallaCopia Deformed $_p_mc.f"
    grid $_p_mc.f.frd.rd1 $_p_mc.f.frd.rd2 $_p_mc.f.frd.rd3 -sticky wns -padx 4 -pady 2

    ttk::frame $_p_mc.f.fcol -borderwidth 0
    if { ![info exists PG_MallaColorCopia] } { set PG_MallaColorCopia MeshColor }
    ttk::checkbutton $_p_mc.f.fcol.cb1 -text [_ "Use this color: "] -variable PG_MallaColorCopia \
            -offvalue MeshColor -onvalue UserColor -command "PostGeom::ChangeTypeColorCopy2"
    #button $_p_mc.f.fcol.b -width 3 -background $realzado -command "PostGeom::CambiaColorCopia $_p_mc.f.fcol.b"
    LabelButton $_p_mc.f.fcol.b -width 3 -background $realzado -command "PostGeom::CambiaColorCopia $_p_mc.f.fcol.b"
    set _MallaCopia(Color,wid) $_p_mc.f.fcol.b
    grid $_p_mc.f.fcol.cb1 $_p_mc.f.fcol.b -sticky wns -padx 0 -pady 0 -ipadx 0


    set _MallaCopia(wid_pagina) $_p_mc.f
    PostGeom::CreateResultFactorSelectionWidget $_p_mc.f.rs _MallaCopia

    grid $_p_mc.f.frd -sticky wns -padx 4 -pady 0
    grid $_p_mc.f.fcol -sticky wns -padx 4 -pady 0
    grid $_p_mc.f.rs -sticky enws -padx 4 -pady 3
    grid $_p_mc.f -sticky nwes -padx 4 -pady 8
    grid $_p_mc.t -sticky nwes -padx 4 -pady 8
    grid columnconfigure $_p_mc.f 0 -weight 1
    grid rowconfigure $_p_mc.f 3 -weight 1
    grid columnconfigure $_p_mc 0 -weight 1
    grid rowconfigure $_p_mc "0 1" -weight 1

    $w.f.nb compute_size
    $w.f.nb raise [ $w.f.nb page 0]
    grid $w.f.nb -sticky news -padx 4 -pady 2
    grid columnconfigure $w.f 0 -weight 1
    grid rowconfigure $w.f 0 -weight 1


    # marco de los botones
    ttk::frame $w.but -style BottomFrame.TFrame    
    ttk::button $w.but.apply -text [_ "Apply"] -command "PostGeom::Apply $w.f.nb" -takefocus 0 -style BottomFrame.TButton 
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -takefocus 0 -style BottomFrame.TButton

    grid $w.but.apply -sticky ews -padx 6 -pady 12
    grid $w.but.close -sticky ews -padx 6 -pady 12 -row 0 -column 1



    #enpaquetamos marcos
    grid $w.f -sticky news -padx 0 -pady 0
    grid $w.but -sticky wes
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    focus $w.but.apply
    bind $w <Return> "$w.but.apply invoke"
   
    update idletasks

    SetTraceVariables
    ActualizaVariables

    bind $w <Destroy> "+PostGeom::DeleteTraceVariables %W $w"
}

