#Creates a table with the results of the selected graph

namespace eval GraphResults {

}

#Fill the variable used to store the table values
proc GraphResults::SetTableFromGraphName { graph_name table } {
    if { ![winfo exists $table] } {
        return 1
    }
    set varname [$table cget -variable]
    upvar #0 $varname data

    array unset data
    if { [lsearch [GiD_Graph list] $graph_name] == -1 } {
        return 1
    }
    set graph [GiD_Graph get $graph_name]
    set data(0,1) $graph_name
    #Labels
    set data(1,1) [lindex $graph 0]
    set data(1,2) [lindex $graph 1]
    #Units
    set data(2,1) [lindex $graph 4]
    set data(2,2) [lindex $graph 5]
    #Values
    set i 3
    foreach x [lindex $graph 2] y [lindex $graph 3] {
        set data($i,0) [expr {$i-2}]
        set data($i,1) [format %g $x]
        set data($i,2) [format %g $y]
        incr i
    }
    $table configure -rows $i
    return 0
}


proc GraphResults::GetGraphDataFromTable { table } {
    if { ![winfo exists $table] } {
        return 1
    }

    set varname [$table cget -variable]
    upvar #0 $varname data

    set title $data(0,1)
    set xlabel $data(1,1)
    set ylabel $data(1,2)
    set xunits $data(2,1)
    set yunits $data(2,2)
    set xlist ""
    set ylist ""
    set i 3
    while { [info exists data($i,1)] && [string is double -strict $data($i,1)] && [string is double -strict $data($i,2)]} {
        lappend xlist $data($i,1)
        lappend ylist $data($i,2)
        incr i
    }
    if { $xlist == "" } {
        #fail
        return 1
    } else {
        return [list $title $xlabel $ylabel $xlist $ylist $xunits $yunits]
    }
}

#apply changes in values
proc GraphResults::OnApply { table } {
    set fail 0
    set graphdata [GraphResults::GetGraphDataFromTable $table]
    if { $graphdata != 1 } {
        set title [lindex $graphdata 0]
        if {[lsearch [GiD_Graph list] $title] != -1} {
            GiD_Graph edit {*}$graphdata ;#now delete and create instead of edit until this new command is finished in GiD
            if { $::plot_graph } {
                #GiD_Graph show ;#commented to avoid to be drawn the graph in the main window instead of graph window
            } else {
                GiD_Graph show
            }
        }
    } else {
        set fail 1
    }
    return $fail
}

proc GraphResults::IncreaseRows { table } {
    set varname [$table cget -variable]
    upvar #0 $varname data
    set nrows [$table cget -rows]
    set i $nrows
    incr nrows
    set data($i,0) [expr $nrows-3]
    set data($i,1) 0
    set data($i,2) 0
    $table configure -rows $nrows
}

proc GraphResults::DecreaseRows { table } {
    set varname [$table cget -variable]
    upvar #0 $varname data
    set nrows [$table cget -rows]
    incr nrows -1
    $table configure -rows $nrows
}

proc GraphResults::Create { graph_name w} {
    package require fulltktable

    InitWindow2 $w -title [_ "Graph values"] \
        -geometryvariable PostGraphResultsWindowGeom \
        -ontop
    # -initcommand {GraphResults::Create ""}

    if { ![winfo exists $w] } return
    #find a unused global variable, to allow multiple windows with different graphs
    set i 0
    set varname GraphResults::tab-$i
    while { [info exists $varname] } {
        incr i
        set varname GraphResults::tab-$i
    }

    #Create the tables
    ttk::frame $w.fr

    fulltktable::table $w.fr.tab -rows 3 -cols 3 -variable $varname \
        -colstretchmode unset -selectmode extended \
        -titlerows 3 -titlecols 1 -selecttitle 1 -resizeborders col \
        -rowseparator \n -colseparator \t -multiline 0 -createline 1

    $w.fr.tab width 0 8
    $w.fr.tab spans 0,0 2,0
    $w.fr.tab spans 0,1 0,2

    SetTableFromGraphName $graph_name $w.fr.tab

    #Increase/Decrease rows
    ttk::frame $w.id
    ttk::button $w.id.b1 -image [gid_themes::GetImage ArrowDown.png small_icons] -command [list GraphResults::IncreaseRows $w.fr.tab]
    ttk::button $w.id.b2 -image [gid_themes::GetImage ArrowUp.png small_icons] -command [list GraphResults::DecreaseRows $w.fr.tab]

    #Buttons
    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.apply -text [_ "Apply"] -underline 0 \
        -command [list GraphResults::OnApply $w.fr.tab] -takefocus 0 -style BottomFrame.TButton
    ttk::button $w.frmButtons.close -text [_ "Close"] -underline 0 \
        -command [list destroy $w] -takefocus 0 -style BottomFrame.TButton

    grid $w.fr.tab -sticky nsew
    grid rowconfigure $w.fr 0 -weight 1
    grid columnconfigure $w.fr 0 -weight 1

    grid $w.id.b1 $w.id.b2 -padx 2 -pady 2

    grid $w.frmButtons.apply $w.frmButtons.close -padx 2 -pady 2

    grid $w.fr -sticky nsew
    grid $w.id -sticky new
    grid anchor $w.id center
    grid $w.frmButtons -sticky sew
    grid anchor $w.frmButtons center
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1


    bind $w <Destroy> [list +GraphResults::OnDestroy %W $w $varname] ;# + to add to previous script

    focus $w
}

proc GraphResults::OnDestroy { W w varname } {
    if { $W != $w } return
    #reenter multiple times, one by toplevel child, only interest w
    array unset $varname
}
