#old deprecated commands

#deprecated
proc RaiseEvent_GenericProc { event args } {
    return [GiD_RaiseEvent $event {*}$args]
}

namespace eval GidUtils {
}

# waits for the user to pick a world point, it returns a list of 6 values a point on the visual and its direction.
# this procedure is unneeded !!! can get basically the same with GidUtils::GetCoordinates $WarnLineMsg NoJoin
proc GidUtils::PickWorldPoint { { WarnLineMsg ""}} {
    if { $WarnLineMsg  == "" } { set WarnLineMsg [_ "Click a point (ESC to leave)"] }
    #gidmakecurrent
    GidUtils::SetWarnLine $WarnLineMsg

    set w .gid.central.s
    set ::GidUtils(WorldCoord) {}
    set ::GidUtils(B1_script) [ bind $w <1>]
    $w configure -cursor cross
    bind $w <1> "GidUtils::TransformScreenToWorld %x %y"
    tkwait variable ::GidUtils(WorldCoord)
    $w configure -cursor ""
    bind $w <1> $::GidUtils(B1_script)
    return $::GidUtils(WorldCoord)
}

# auxiliary proc used by GidUtils::PickWorldPoint
# given a pair of screen coordinates
# returns a list of coord_x coord_y coord_z norm_x norm_y norm_z
# of the intersecion of the plane paralel to screen through rotation centre
# and the perpendicular line defined by the mouse cursor
proc GidUtils::TransformScreenToWorld { scr_x scr_y} {
    set ::GidUtils(WorldCoord) [ GiD_GetWorldCoord $scr_x $scr_y]
    return $::GidUtils(WorldCoord)
}

#get the list of entities of a postprocess set, now is replaced by GiD_EntitiesSets
proc GidUtils::GiD_EntitiesSets { operation set_name entity_type {flag_count ""} } {
    set res ""
    if { $flag_count == "-count" } {            
        set res [::GiD_EntitiesSets $operation $set_name $entity_type -count]
    } else {
        set res [::GiD_EntitiesSets $operation $set_name $entity_type]
    }            
    return $res
}

#old name, back compatibility
proc GiveGidDefaultsFile { } {
    return [GiD_GetUserSettingsFilename -create_folders]   
}

proc ReadProblemtypeXml { xmlfile root_name fields } {
    return [GidUtils::ReadProblemtypeXml $xmlfile $root_name $fields]
}

proc SetWidgetsWidthFromText { args } {
    #do nothing, the old command doesn't work with ttk widgets, now use style
}

#moved to gid_cross_platform package
proc GidUtils::Img2Clipboard { phImg } {
    package require gid_cross_platform
    return [gid_cross_platform::image_to_clipboard $phImg] 
}
proc GidUtils::Clipboard2Img {} {
    package require gid_cross_platform
    return [gid_cross_platform::clipboard_to_image]   
}

#added GidUtils:: namespace
proc GiveFileInsideProblemType { ptname ext {checkifexists 0} } {
    return [GidUtils::GiveFileInsideProblemType $ptname $ext $checkifexists]
}

proc GiveRealFilenameDereferencingLinks { filename {checkifexists 0} } {
    return [GidUtils::GiveRealFilenameDereferencingLinks $filename $checkifexists]
}

proc GiveProblemTypeFullname { ptname } {
    return [GidUtils::GiveProblemTypeFullname $ptname]
}

#used by nastran, ramseries,tdyn ,compassfem problemtypes
proc DWSpace2Under { str } {
    regsub -all { } $str {_} str
    return $str
}

proc DWUnder2Space { str } {
    regsub -all {_} $str { } str
    return $str
}

#used by ...
proc GidShowBook { class {book ""} {show 1} } {
    return [GiD_ShowBook $class $book  $show]
}

#compatibility with old versions without namespace

proc GiDVersionNumber { VersionString } {
    return [GidUtils::VersionNumber $VersionString]
}

proc GiDVersionSubchar { VersionString } {
    return [GidUtils::VersionSubchar $VersionString]
}

proc GiDVersionBetaNumber { VersionString } {
    return [GidUtils::VersionBetaNumber $VersionString]
}

proc GiDVersionCmp { Version } {
    return [GidUtils::VersionCmp $Version]
}

proc CorrectExp { realnum  } {
    return [MathUtils::CorrectExp $realnum]
}


#NOTE:It exist from GiD7.4.7b a new GiD-tcl command, more powerful than CorrectExp
#     this command is:
#     GiD_FormatReal <format> <realnum> ?forcewidth|forcewidthnastran?
#     <format> is a 'C' style format, and if set "forcewidth" the minimum size of this format is considered
#     also as the final size (this is not the 'C' default).
#     An special option is "forcewidthnastran", to allow to remove the 'e' character,
#     sample: format="%8.3e" realnum=-2.345e-13
#             without width option    return -2.345e-13 (10 digits, not 8)
#             with forcewidth         return -2.3e-13 (8 digits, but only 2 significant digits)
#             with forcewidthnastran  return -2.34-13 (8 digits, without 'e', but with 3 significant digits)
#
# CorrectExp return two digits exponent: e.g 1.5e+045 return 1.5e+45
namespace eval MathUtils {
}

proc MathUtils::CorrectExp { realnum  } {
    set prev ""
    set expsgn ""
    set a [regexp "(.*)?(\[eE\])(\[\+\-\])?(\[0-9\]+)" $realnum match prev expchar expsgn expnum ]
    if { $a } {
        if { [string length $expnum] ==3 && [string index $expnum 0] == 0 } {
            set expnum [string range $expnum 1 2]
        }
        return "$prev$expchar$expsgn$expnum"
    } else {
        return $realnum
    }
}

#old manage menus commands

# to try to get the current translated menu name of an old translated menu name
# because menus are renamed, and old problemtypes can use the old name
proc ConvertDeprecatedTranslatedMenuNameToCurrent { menu_name_translated {prepost PREPOST} } {
    if { $prepost=="PRE" || $prepost=="PREPOST" } {
        #back compatibility: Meshing menu renamed to Mesh in 7.5.9b
        if { $menu_name_translated == [_ "Meshing"] } {
            return [_ "Mesh#C#menu"]
        }
        #back compatibility: menus renamed from oldname to oldname#C#menu
        set oldmenunames [list [_ "Files"] [_ "View#C#Verb"] [_ "Geometry"] [_ "Utilities"] [_ "Data"] [_ "Mesh"] \
                [_ "Calculate"] [_ "Help"] ]
        set i [lsearch $oldmenunames $menu_name_translated]
        if { $i != -1 } {
            set newmenunames [list [_ "Files#C#menu"] [_ "View#C#menu,Verb"] [_ "Geometry#C#menu"] \
                    [_ "Utilities#C#menu"] [_ "Data#C#menu"] [_ "Mesh#C#menu"] \
                    [_ "Calculate#C#menu"] [_ "Help#C#menu"] ]
            return [lindex $newmenunames $i]
        }
    }
    if { $prepost=="POST" || $prepost=="PREPOST" } {
        #back compatibility: menus renamed from oldname to oldname#C#menu
        set oldmenunames [list [_ "Files"] [_ "View#C#Verb"] [_ "Utilities"] \
                [_ "Do cuts"] [_ "View results"] [_ "Options"] \
                [_ "Window"] [_ "Help"]]
        set i [lsearch $oldmenunames $menu_name_translated]
        if { $i != -1 } {
            set newmenunames [list [_ "Files#C#menu"] [_ "View#C#menu,Verb"] [_ "Utilities#C#menu"] \
                    [_ "Do cuts#C#menu"] [_ "View results#C#menu"] [_ "Options#C#menu"] \
                    [_ "Window#C#menu"] [_ "Help#C#menu"]]
            return [lindex $newmenunames $i]
        }
    }
    return $menu_name_translated
}

# Creates a new menu. New menus are inserted between the 'Calculate' and 'Help' menu
# Arg 'prepost' can have these values:
# "PRE" to create the menu only in the preprocess
# "POST" to create the menu only in the postprocess
# or "PREPOST" to create the menu in the pre and postprocess
proc CreateMenu {new_menu_name prepost} {

  if {$prepost!="PRE" && $prepost!="POST" && $prepost!="PREPOST"} {
    return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]}


  if {$prepost eq "PRE"} {
    set where [list ""]
  } elseif {$prepost eq "POST"} {
    set where [list "P"]
  } else {
    set where [list "" "P"]
  }

  foreach c $where {
    upvar \#0 MenuNames$c MenuNames
    upvar \#0 MenuEntries$c MenuEntries
    upvar \#0 MenuCommands$c MenuCommands
    upvar \#0 MenuAcceler$c MenuAcceler
    upvar \#0 MenuIcons$c MenuIcons

    set length   [llength $MenuNames]
    set pos   [expr [llength $MenuNames]-1]

    set MenuNames [linsert $MenuNames $pos $new_menu_name]
    set MenuEntries($length)  $MenuEntries($pos)
    set MenuCommands($length) $MenuCommands($pos)
    set MenuAcceler($length)  $MenuAcceler($pos)
    set MenuIcons($length)  $MenuIcons($pos)

    set MenuEntries($pos)  [list ""]
    set MenuCommands($pos) [list ""]
    set MenuAcceler($pos)  [list ""]
    set MenuIcons($pos)  [list ""]
  }
}


# -----------------------------------------------------------------------------
# DeleteMenu --
#
#  Delete a toplevel menu
#  menu_name must be [_ "gid_englishmenuname" ]  or [= "problemtype_englishmenuname"]
#  prepost must be  PRE , POST or PREPOST
#  for example:
#    DeleteMenu [_ "Mesh"] PRE
#
#  Remember call UpdateMenus.
# -----------------------------------------------------------------------------
proc DeleteMenu {menu_name prepost} {
  global MenuNames MenuEntries MenuCommands MenuAcceler
  global MenuNamesP MenuEntriesP MenuCommandsP MenuAccelerP

  if {$prepost!="PRE" && $prepost!="POST" && $prepost!="PREPOST"} {
    return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]
  }
  #back compatibility: menus were renamed
  set menu_name [ConvertDeprecatedTranslatedMenuNameToCurrent $menu_name $prepost]

  if {$prepost eq "PRE"} {
    set where [list "" "PRE"]
  } elseif {$prepost eq "POST"} {
    set where [list "P" "POST"]
  } else {
    set where [list "" "PRE" "P" "POST"]
  }
  foreach {c desc} $where {
    upvar \#0 MenuNames$c MenuNames
    upvar \#0 MenuEntries$c MenuEntries
    upvar \#0 MenuCommands$c MenuCommands
    upvar \#0 MenuAcceler$c MenuAcceler
    upvar \#0 MenuIcons$c MenuIcons

    set i [lsearch $MenuNames $menu_name]
    if { $i == "-1" } {
        #try to search the translated word, for old problemtypes not updated to translation
        #set i [GiD_FindMenuIndex $menu_name $desc _]
        set i [ GiDMenu::_FindIndex $menu_name $desc _]
        if { $i == "-1" } {
            WarnWin [_ "ERROR: Menu %s doesn't exist in $desc." $menu_name]
            return
        } else {
            #::GidUtils::SetWarnLine [_ "Warning: This problemtype must be updated for translation"]
        }
    }
    set MenuNames [lreplace $MenuNames $i $i]
    array unset MenuEntries $i,*
    array unset MenuCommands $i,*
    array unset MenuAcceler $i,*
    array unset MenuIcons $i,*

    set l [llength $MenuNames]
    for {incr i} {$i <= $l} {incr i} {
      foreach item [array names MenuEntries ${i}*] {
        set new_item [regsub ${i}* $item [expr $i-1]]
        set MenuEntries($new_item) $MenuEntries($item)
        unset MenuEntries($item)
      }
      foreach item [array names MenuCommands ${i}*] {
        set new_item [regsub ${i}* $item [expr $i-1]]
        set MenuCommands($new_item) $MenuCommands($item)
        unset MenuCommands($item)
      }
      foreach item [array names MenuAcceler ${i}*] {
        set new_item [regsub ${i}* $item [expr $i-1]]
        set MenuAcceler($new_item) $MenuAcceler($item)
        unset MenuAcceler($item)
      }
      foreach item [array names MenuIcons ${i}*] {
          set new_item [regsub ${i}* $item [expr $i-1]]
          set MenuIcons($new_item) $MenuIcons($item)
          unset MenuIcons($item)
      }
    }
    array unset MenuEntries $l,*
    array unset MenuCommands $l,*
    array unset MenuAcceler $l,*
    array unset MenuIcons $l,*
    array unset MenuEntries $l
    array unset MenuCommands $l
    array unset MenuAcceler $l
    array unset MenuIcons $l
  }
}

# Creates a new option for a given menu in a given
# position. (positions start at 0), "end" can be  used
# By default, if it already exists an option in the given position,
# that option is substitued by the new one.
# if Arg ins_repl is "insert" the new menu option is inserted
# Arg 'command' is the command called when the menu option
# is selected.
# Arg 'prepost' can have these values:
# "PRE" to insert the option in the preprocess menus
# "POST" to insert the option in the postprocess menus
# or "PREPOST" to insert the option in the pre and postprocess menus
# Arg acceler is an optional key accelerator, like "Control-s"
# Arg icon is the name of an small icon (16x16 pixels)

proc InsertMenuOption {menu_name option_name position command prepost {ins_repl "replace"} \
        {acceler ""} {icon ""} } {

    if {$prepost!="PRE" && $prepost!="POST" && $prepost!="PREPOST"} {
        return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]
    }

    set $ins_repl [string tolower $ins_repl]
    if {$ins_repl != "replace" && $ins_repl != "insert"} {
        return -code error [_ "Wrong arg. Must be replace or insert."]
    }
    #back compatibility: menus were renamed
    set menu_name [ConvertDeprecatedTranslatedMenuNameToCurrent $menu_name $prepost]

    if {$prepost eq "PRE"} {
        set where [list "" "PRE"]
    } elseif {$prepost eq "POST"} {
        set where [list "P" "POST"]
    } else {
        set where [list "" "PRE" "P" "POST"]
    }
    foreach {c desc} $where {
        upvar \#0 MenuNames$c MenuNames
        upvar \#0 MenuEntries$c MenuEntries
        upvar \#0 MenuCommands$c MenuCommands
        upvar \#0 MenuAcceler$c MenuAcceler
        upvar \#0 MenuIcons$c MenuIcons

        set i [lsearch $MenuNames $menu_name]
        if { $i == "-1" } {
            #try to search the translated word, for old problemtypes not updated to translation
            #set i [GiD_FindMenuIndex $menu_name $desc _]
            set i [ GiDMenu::_FindIndex $menu_name $desc _]
            if { $i == "-1" } {
                WarnWin [_ "ERROR: Menu %s doesn't exist in $desc." $menu_name]
                return
            } else {
                #::GidUtils::SetWarnLine [_ "Warning: This problemtype must be updated for translation"]
            }
        }

        set tail_opt_name [find_option i $option_name $desc 1]
        if {$tail_opt_name== ""} {return}
        if { $position == "end" } {
            set position [expr {[llength $MenuEntries($i)]-1}]
        }
        if {[llength $MenuEntries($i)]<= $position} {
            lappend MenuEntries($i) $tail_opt_name
            lappend MenuCommands($i) "-np- $command"
            if {[info exists MenuAcceler($i)]} {
                lappend MenuAcceler($i) $acceler
            }
            if {[info exists MenuIcons($i)]} {
                lappend MenuIcons($i) $icon
            }
        } else {
            if {$ins_repl=="replace"} {
                del_submenus $i $position $desc
                set MenuEntries($i) [lreplace $MenuEntries($i) $position $position $tail_opt_name]
                set MenuCommands($i) [lreplace $MenuCommands($i) $position $position "-np- $command"]
                if {[info exists MenuAcceler($i)] && [llength $MenuAcceler($i)] > $position} {
                    set MenuAcceler($i) [lreplace $MenuAcceler($i) $position $position $acceler]
                }
                if {[info exists MenuIcons($i)] && [llength $MenuIcons($i)] > $position } {
                    set MenuIcons($i) [lreplace $MenuIcons($i) $position $position $icon]
                }
            } elseif {$ins_repl=="insert"} {
                set MenuEntries($i) [linsert $MenuEntries($i) $position  $tail_opt_name]
                set MenuCommands($i) [linsert $MenuCommands($i) $position  "-np- $command"]
                if {[info exists MenuAcceler($i)]} {
                    set MenuAcceler($i) [linsert $MenuAcceler($i) $position $acceler]
                }
                if {[info exists MenuIcons($i)]} {
                    set MenuIcons($i) [linsert $MenuIcons($i) $position $icon]
                }
                move_submenus $i $position $desc "down"
            }
        }
    }
}

# Removes an option of a given menu.
# Arg 'prepost' can have these values:
# "PRE" to remove an option of the preprocess menus
# "POST" to remove an option of the postprocess menus
# or "PREPOST" to remove an option of the pre and the postprocess menus

proc RemoveMenuOption {menu_name option_name prepost} {
  if {$prepost!="PRE" && $prepost!="POST" && $prepost!="PREPOST"} {
    return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]
  }
  #back compatibility: menus were renamed
  set menu_name [ConvertDeprecatedTranslatedMenuNameToCurrent $menu_name $prepost]

  if {$prepost eq "PRE"} {
    set where [list "" "PRE"]
  } elseif {$prepost eq "POST"} {
    set where [list "P" "POST"]
  } else {
    set where [list "" "PRE" "P" "POST"]
  }
  foreach {c desc} $where {
    upvar \#0 MenuNames$c MenuNames
    upvar \#0 MenuEntries$c MenuEntries
    upvar \#0 MenuCommands$c MenuCommands
    upvar \#0 MenuAcceler$c MenuAcceler
    upvar \#0 MenuIcons$c MenuIcons

    set i [lsearch $MenuNames $menu_name]
    if { $i == "-1" } {
      #try to search the translated word, for old problemtypes not updated to translation
      #set i [GiD_FindMenuIndex $menu_name $desc _]
        set i [ GiDMenu::_FindIndex $menu_name $desc _]
      if { $i == "-1" } {
        WarnWin [_ "ERROR: Menu %s doesn't exist in $desc." $menu_name]
        return
      } else {
        #::GidUtils::SetWarnLine [_ "Warning: This problemtype must be updated for translation"]
      }
    }
    set position [find_option i $option_name $desc]
    if {$position == ""} {return}

    del_submenus $i $position $desc
    move_submenus $i $position $desc "up"
    set MenuEntries($i)  [lreplace $MenuEntries($i) $position $position ]
    set MenuCommands($i) [lreplace $MenuCommands($i) $position $position]
    if {[info exists MenuAcceler($i)] && [llength $MenuAcceler($i)] > $position} {
      set MenuAcceler($i) [lreplace $MenuAcceler($i) $position $position ]
    }
    if {[info exists MenuIcons($i)] && [llength $MenuIcons($i)] > $position} {
        set MenuIcons($i) [lreplace $MenuIcons($i) $position $position]
    }
  }
}

# Modify a previous menu identified by menu_name option_name and prepost
# Arg 'new_command' is the command called when the menu option
# is selected.
# Arg 'prepost' can have these values:
# "PRE" to insert the option in the preprocess menus
# "POST" to insert the option in the postprocess menus
# or "PREPOST" to insert the option in the pre and postprocess menus
# Arg new_option_name can be the same as option_name or a new one
# Arg new_command is an optional new command (-keep- to keep the current)
# Arg new_acceler is an optional key accelerator, like "Control-s" (-maintain- to keep the current)
# Arg new_icon is the name of an small icon (16x16 pixels) (-default- to keep the current)
proc ModifyMenuOption {menu_name option_name prepost new_option_name {new_command -default-} \
        {new_acceler -default-} {new_icon -default-} } {

    if {$prepost!="PRE" && $prepost!="POST" && $prepost!="PREPOST"} {
        return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]
    }

    #back compatibility: menus were renamed
    set menu_name [ConvertDeprecatedTranslatedMenuNameToCurrent $menu_name $prepost]

    if {$prepost eq "PRE"} {
        set where [list "" "PRE"]
    } elseif {$prepost eq "POST"} {
        set where [list "P" "POST"]
    } else {
        set where [list "" "PRE" "P" "POST"]
    }
    foreach {c desc} $where {
        upvar \#0 MenuNames$c MenuNames
        upvar \#0 MenuEntries$c MenuEntries
        upvar \#0 MenuCommands$c MenuCommands
        upvar \#0 MenuAcceler$c MenuAcceler
        upvar \#0 MenuIcons$c MenuIcons

        set i [lsearch $MenuNames $menu_name]
        if { $i == "-1" } {
            #try to search the translated word, for old problemtypes not updated to translation
            #set i [GiD_FindMenuIndex $menu_name $desc _]
            set i [ GiDMenu::_FindIndex $menu_name $desc _]
            if { $i == "-1" } {
                ::GidUtils::SetWarnLine [_ "ERROR: Menu %s doesn't exist in $desc." $menu_name]
                return 1
            } else {
                #::GidUtils::SetWarnLine [_ "Warning: This problemtype must be updated for translation"]
            }
        }

        set tail_opt_name [find_option i $option_name $desc 1]
        if {$tail_opt_name== ""} { return 1 }

        set position [lsearch $MenuEntries($i) $option_name]
        if {$position == -1 } { return 1 }

        if { $new_option_name != "-default-" } {
            set MenuEntries($i) [lreplace $MenuEntries($i) $position $position $new_option_name]
        }
        if { $new_command != "-default-" } {
            set MenuCommands($i) [lreplace $MenuCommands($i) $position $position "-np- $new_command"]
        }
        if {[info exists MenuAcceler($i)] && [llength $MenuAcceler($i)] > $position} {
            if { $new_acceler != "-default-" } {
                set MenuAcceler($i) [lreplace $MenuAcceler($i) $position $position $new_acceler]
            }
        }
        if {[info exists MenuIcons($i)] && [llength $MenuIcons($i)] > $position } {
            if { $new_icon != "-default-" } {
                set MenuIcons($i) [lreplace $MenuIcons($i) $position $position $new_icon]
            }
        }
    }
    return 0
}

proc find_option {i option_name prepost {insert 0}} {
    global MenuNames MenuEntries MenuCommands MenuAcceler MenuIcons
    global MenuNamesP MenuEntriesP MenuCommandsP MenuAccelerP MenuIconsP

    upvar $i path_menu
    set p 0

    set prepost [string toupper $prepost]

    while {$p<[string length $option_name]} {
        set option ""
        set char [string index $option_name $p]
        if {$char == ">"} {
            set p [expr $p +1]
            set char [string index $option_name $p]
        }
        while {$char != ">" && $p < [string length $option_name]} {
            append option $char
            set p [expr $p +1]
            set char [string index $option_name $p]
        }
        
        set position 0
        set end 0
        if {$prepost == "PRE"} {
            if {![info exists MenuEntries($path_menu)]} {
                set MenuEntries($path_menu)  ""
                set MenuCommands($path_menu) ""
                set MenuAcceler($path_menu)  ""
                set MenuIcons($path_menu)  ""
                
                regexp {(.*),([0-9]+)} $path_menu b previous_menu previous_position
                set MenuCommands($previous_menu) [lreplace $MenuCommands($previous_menu) $previous_position $previous_position ""]
                if {[info exists MenuAcceler($previous_menu)] && [llength $MenuAcceler($previous_menu)] > $previous_position} {
                    set MenuAcceler($previous_menu)  [lreplace $MenuAcceler($previous_menu) $previous_position $previous_position ""]
                }
                if {[info exists MenuIcons($previous_menu)] && [llength $MenuIcons($previous_menu)] > $previous_position} {
                    set MenuIcons($previous_menu)  [lreplace $MenuIcons($previous_menu) $previous_position $previous_position ""]
                }
            }
        
            while { [cmpoption [lindex $MenuEntries($path_menu) $position] $option] != 0 && $end==0} {
                set position [expr $position +1]
                if {$position >= [llength $MenuEntries($path_menu)]} {
                    if {$insert==0 || $p < [string length $option_name]} {
                        return ""
                    }
                    set end 1
                }
            }
        }
        
        set end 0
        if {$prepost == "POST"} {
            if {![info exists MenuEntriesP($path_menu)]} {
                set MenuEntriesP($path_menu)  ""
                set MenuCommandsP($path_menu) ""
                set MenuAccelerP($path_menu)  ""
                set MenuIconsP($path_menu)  ""
                
                regexp {(.*),([0-9]+)} $path_menu b previous_menu previous_position
                set MenuCommandsP($previous_menu) [lreplace $MenuCommandsP($previous_menu) $previous_position $previous_position ""]
                if {[info exists MenuAccelerP($previous_menu)] && [llength $MenuAccelerP($previous_menu)] > $previous_position} {
                    set MenuAccelerP($previous_menu)  [lreplace $MenuAccelerP($previous_menu) $previous_position $previous_position ""]
                }
                if {[info exists MenuIconsP($previous_menu)] && [llength $MenuIconsP($previous_menu)] > $previous_position} {
                    set MenuIconsP($previous_menu)  [lreplace $MenuIconsP($previous_menu) $previous_position $previous_position ""]
                }
            }
            while {[lindex $MenuEntriesP($path_menu) $position] != $option && $end==0} {
                set position [expr $position +1]
                if {$position >= [llength $MenuEntriesP($path_menu)]} {
                    if {$insert==0 || $p < [string length $option_name]} {
                        return ""
                    }
                    set end 1
                }
            }
        }
        if {$p<[string length $option_name]} {set path_menu "$path_menu,$position"}
    }

    if {$insert==1} {
        return $option
    } else {
        return $position
    }
}

#compare two words removing the last "..."
proc cmpoption { a b } {
    return [GiDMenu::cmpoption $a $b]
}

proc del_submenus {i position pre} {
    return [GiDMenu::del_submenus $i $position $pre]
}

proc rec_del_menu {param ent com acc icons} {
    return [GiDMenu::rec_del_menu $param $ent $com $acc $icons]
}

proc move_submenus {i position pre inc} {
    return [GiDMenu::move_submenus $i $position $pre $inc]
}

proc dec_inc_menu {param last_menu inc} {
    return [GiDMenu::dec_inc_menu $param $last_menu $inc]
}

proc rec_move_menu {param last_menu ent com acc icons inc} {
    return [GiDMenu::rec_move_menu $param $last_menu $ent $com $acc $icons $inc]
}


# this command SelectButton (and its dependencies EnableOrDisableWindow and EndSelectButton)
# were inapropiatedly used by stampack55, but it will disappear.

# what can be normal or disabled
proc EnableOrDisableWindow { w what } {
    catch { $w configure -state $what }
    foreach i [winfo children $w] {
        EnableOrDisableWindow $i $what
    }
}

proc SelectButton { w wplace text disable comm } {
    if { $disable == "disableall" } {
        EnableOrDisableWindow $w disabled
    }
    ttk::frame $w.finf -style ridge.TFrame -borderwidth 4
    ttk::button $w.finf.f -text Finish -command "EndSelectButton $w $comm"
    ttk::label $w.finf.l -text $text
    pack $w.finf.f $w.finf.l -side left
    place $w.finf -in $w -x 0 -rely 1 -anchor sw
    delayedop changefunc "$w.finf.f invoke"
}

# only called internally
proc EndSelectButton { w comm } {
    delayedop -cancel changefunc "$w.finf.f invoke"
    destroy $w.finf
    GiD_Process Mescape
    EnableOrDisableWindow $w normal
    eval $comm
}

#to be used by TKWIDGET of LAMMPS 0.2 problemtype, 
#now replaced by GidUtils::TkwidgetEntryConfigure with an extra parameter before 'events'
#e.g. 
#TKWIDGET: GidUtils::TkwidgetEntry CONFIGURE {-width 20}
proc GidUtils::TkwidgetEntry { event args } {    
    if { $event == "CONFIGURE" } {
        #trick: two extra arguments before the standard ones (even args)
        set options [lindex $args 0]
        set event [lindex $args 1]
        set args [lrange $args 2 end]
    }
    switch $event {
        INIT {            
            lassign $args PARENT current_row_variable GDN STRUCT QUESTION    
            upvar $current_row_variable ROW      
            #initialize variable to current field value
            #set value [DWLocalGetValue $GDN $STRUCT $QUESTION]            
            set entry ""
            foreach item [grid slaves $PARENT -row [expr $ROW-1]] {
                if { [winfo class $item] == "Entry"  || [winfo class $item] == "TEntry" } {
                    #assumed that it is the only entry of this row
                    set entry $item
                    break
                }
            }             
            if { $entry != "" && [winfo exists $entry] && [info exists options] } {
                $entry configure {*}$options
            }
        }
        SYNC {            
        }
        DEPEND {
        }
        CLOSE {
        }
        default {
            return [list ERROR [_ "Unexpected tkwidget event"]]
        }
    }
    #a tkwidget procedure must return "" if Ok or [list ERROR $description] or [list WARNING $description] 
    return ""
}

#this proc is documented, and used for example by SAP2000
proc GiDCustomHelp { args } {
    package require gid_helpviewer
    array set options [list -start "" -dir [file join [GetDirectoryProblemType] html] -title [_ "Help on %s" [GiD_Info Project Problemtype]]]
    array set options $args
    set lan [GiD_Set Language]
    if { [file exists $options(-dir)] && [file isdirectory $options(-dir)] } {
        set dirhelp [file join $options(-dir) $lan]
        if { ![file exists $dirhelp] && $lan != "en" } {
            set lan en
            set dirhelp [file join $options(-dir) $lan]
        }
        if { [file exists $dirhelp] && [file isdirectory $dirhelp] } {
            set $options(-dir) $dirhelp
        }
    }
    set used_options [list -title $options(-title)]
    set filename [file join $options(-dir) $options(-start)]

    #modification when options(-start) contains a tag
    set filetag [split $options(-start) "#"]
    if { [llength $filetag] == 2 } {
      set filename [file join $options(-dir) [lindex $filetag 0]]
      lappend used_options -try $options(-start)      
    }
    
    if { [info exists options(-report)] } {
        lappend used_options -report $options(-report)
    }
    GiDHelpViewer::Show $filename {*}$used_options
}

#this proc was documented in the past, and used for example by ATENA
proc HelpWindow { help_type dir { intro_file "" } } {
    package require gid_helpviewer
    set filename $dir
    if { ![file exists $filename] } {
        set default_filename [file join $dir hmtl index.html]
        if { [file exists $default_filename] } {
            set filename $default_filename
        }
    }   
    GiDHelpViewer::Show $filename
}

#to avoid problems if an old problemtype using tile invoke the old style command
interp alias "" style "" ttk::style

#old procedures of file PostWidgets.tcl
proc BWChooseColor { w args} {
    WarnWin Deprecated
    set nuevo [ eval SelectColor::dialog $w $args]
    if { [ string length $nuevo] == 13} {
        # es de la forma #rrrrggggbbbb -> cada componente 0..65535
        scan $nuevo #%4x%4x%4x r g b
        set r [ expr int( 0.5 + $r * 255.0 / 65535.0)]
        set g [ expr int( 0.5 + $g * 255.0 / 65535.0)]
        set b [ expr int( 0.5 + $b * 255.0 / 65535.0)]
        set nuevo [ format #%02x%02x%02x $r $g $b]
    }
    return $nuevo
}

proc BWChooseColorMenu { w where args} {
    WarnWin Deprecated
    # where puede ser: [ list { "at" "center" "left" "right" "above" "below"} $widget]

    set nuevo [ eval SelectColor::menu $w [ list $where] $args]
    if { [ string length $nuevo] == 13} {
        # es de la forma #rrrrggggbbbb -> cada componente 0..65535
        scan $nuevo #%4x%4x%4x r g b
        set r [ expr int( 0.5 + $r * 255.0 / 65535.0)]
        set g [ expr int( 0.5 + $g * 255.0 / 65535.0)]
        set b [ expr int( 0.5 + $b * 255.0 / 65535.0)]
        set nuevo [ format #%02x%02x%02x $r $g $b]
    }
    return $nuevo
}

#deprecated old name, already used by SAFIR2016/Safir_Structural_2d.tcl v 2.5
proc gidadduserdataoptions { L {A ""} {W end} {Acc ""} } {
    return [GidAddUserDataOptions $L $A $W $Acc]
}

#deprecated old name, already used by xfinas
proc ChangeVariables { {groupname ""} } {
    return [PreferencesWindow $groupname]
}

proc GetChildLayerNames {  {parent ""} } {
    return [Layers::ListChildLayers $parent]
}

proc HasChilds { {parent ""} } {
    return [llength [Layers::ListChildLayers $parent]]
}

#tk_dialogRAMFull prototype only for back compatibility, bitmap is now an ignored dummy field
#was invoked for example by nastran 3.2.4 or tdyn5.4
proc tk_dialogRAMFull {w title text textsmall dummy image default args} {
    tk_dialogRAM2 $w $title $text $textsmall $image $default {*}$args
}

#
# tk_dialog:
#
# This procedure displays a dialog box, waits for a button in the dialog
# to be invoked, then returns the index of the selected button.
#
# Arguments:
# w -                Window to use for dialog top-level.
# title -        Title to display in dialog's decorative frame.
# text -        Message to display in dialog.
# image -       Image to display in dialog (empty string means none).
# default -        Index of button that is to display the default ring
#                (-1 means none). (-2 means 0 and button 2 returns -2)
# args -        One or more strings to display in buttons across the
#                bottom of the dialog box.

proc tk_dialogRAM {w title text image default args} {
    tk_dialogRAM2 $w $title $text "" $image $default {*}$args
}


proc tk_dialogRAM2 {w title text textsmall image default args} {    
    global tkPriv tcl_platform GidPriv           
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    if { [winfo exists .gid.central.s] && ( [GiD_Project set disable_windows] || [GiD_Set UseMoreWindows] == 0 ) } {
        return
    }
    set option_do_it_for_all 0
    set option_do_it_for_all_text ""
    if { [llength [lindex $args 0]] == 2 && [lindex [lindex $args 0] 0] == "-option_do_it_for_all" } {
        set option_do_it_for_all 1
        set option_do_it_for_all_text [lindex [lindex $args 0] 1]
        set args [lrange $args 1 end]
    }
    set image [ReplaceImageName $image]
    if { $w == "" } {
        if { [winfo exists .gid] } {
            set w .gid.__dialogram
        } else {
            set w .__dialogram
        }
    }
    
    # 1. Create the top-level window and divide it into top
    # and bottom parts.
    
    while { [winfo exists $w] } { append w a }
    
    toplevel $w
    wm transient $w [winfo toplevel [winfo parent $w]]
    if { $::tcl_platform(platform) == "windows" } {
        wm attributes $w -toolwindow 1
    }
    wm title $w $title
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW [list event generate $w <Escape>]
    
    if { $default == -2 } {
        set default 0
        bind $w <$::gid_central_button> "set tkPriv(button) -2"
        bind $w <${::acceleratorKey}-x><${::acceleratorKey}-l> "set tkPriv(button) -2"
    }    
    if { [llength $args] > 6 } {
        ttk::frame $w.bot3 -style BottomFrame.TFrame 
        pack $w.bot3 -side bottom -fill both
    }
    if { [llength $args] > 3 } {
        ttk::frame $w.bot2 -style BottomFrame.TFrame
        pack $w.bot2 -side bottom -fill both
    }   
    ttk::frame $w.bot -style BottomFrame.TFrame
    pack $w.bot -side bottom -fill both
    if { $option_do_it_for_all } {
        set ::do_it_for_all 0
        ttk::frame $w.bot0 -style BottomFrame.TFrame
        pack $w.bot0 -side bottom -fill both
        ttk::checkbutton $w.bot0.chk -text $option_do_it_for_all_text -variable ::do_it_for_all -style BottomFrame.TCheckbutton
        pack $w.bot0.chk -side left -padx 3 -pady 2 -fill both -expand 1
    }
    
    if { $textsmall != "" } {
        ttk::label $w.ts -text $textsmall -font SmallFont
        pack $w.ts -side bottom -anchor w
    }
    
    #ttk::frame $w.top -style raised.TFrame -borderwidth 0
    ttk::frame $w.top
    
    pack $w.top -side top -fill both -expand 1
    
    # 2. Fill the top part with image and message (use the option
    # database for -wraplength so that it can be overridden by
    # the caller).
    
    #    option add *Dialog.msg.wrapLength 3i widgetDefault
    ttk::label $w.msg -justify left -text $text -wraplength 75m -font BigFont
    
    pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 12 -pady 12
    if {$image != ""} {
        ttk::label $w.bitmap -image [gid_themes::GetImage $image large_icons]
        pack $w.bitmap -in $w.top -side left -padx 12 -pady 12
    }    
    
    # 3. Create a row of buttons at the bottom of the dialog.
    
    set buttonslist ""
    set UnderLineList ""
    set i 0
    foreach but $args {
        regsub -all {([a-z0-9])([A-Z])} $but {\1 \2} but
    }
    foreach but $args {
        regsub -all {([a-z0-9])([A-Z])} $but {\1 \2} but
        ttk::button $w.button$i -text $but -command [list set tkPriv(button) $i] \
            -style BottomFrame.TButton 
        lappend buttonslist $w.button$i
        if { $i < 3 } {
            pack $w.button$i -in $w.bot -side left -expand 1 -padx 3 -pady 2
        } elseif { $i < 6 }  {
            pack $w.button$i -in $w.bot2 -side left -expand 1 -padx 3 -pady 2
        } else {
            pack $w.button$i -in $w.bot3 -side left -expand 1 -padx 3 -pady 2
        }
        
        bind $w.button$i <Return> "
            update idletasks
            after 100
            set tkPriv(button) $i
            "
        set lsize [string length $but]
        for {set j 0} {$j < $lsize} {incr j} {
            set ichar [string tolower [string index $but $j]]
            if { [lsearch -exact $UnderLineList $ichar] == -1 } {
                lappend UnderLineList $ichar
                $w.button$i configure -underline $j
                # this catch is to deal with extrange language, like korean
                catch {
                    bind $w <KeyPress-[string toupper $ichar]> "
                        update idletasks
                        after 100
                        set tkPriv(button) $i
                        "
                    bind $w <KeyPress-[string tolower $ichar]> "
                        update idletasks
                        after 100
                        set tkPriv(button) $i
                        "
                }
                
                break
            }
        }
        
        incr i
    }
    
    if { [llength $buttonslist] > 0 } {
        #set escape binding to right button
        bind $w <Escape> "
            update idletasks
            after 100
            set tkPriv(button) [expr [llength $buttonslist]-1]
            "
        
        #set buttons size acordind to current text       
    }
    
    # 4. Create a binding for <Return> on the dialog if there is a
    # default button.
    
    # 5. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.
    
    if { [winfo parent $w] == ".gid" } {
        bind $w <Destroy> [list +DestroyWinInDialogs $w GeomDialog]
    }
    if { [info exists GidPriv(GeomDialog)] && [winfo parent $w] == ".gid" } {
        WmGidGeom $w $GidPriv(GeomDialog)
    } else {
        wm withdraw $w
        update idletasks
        
        # extrange errors with updates
        if { ![winfo exists $w] } { return 0}
        if { $w != ".gid.__dialogram" } {
            set pare [winfo toplevel [winfo parent $w]]
            set x [expr [winfo x $pare]+[winfo width $pare ]/2- [winfo reqwidth $w]/2]
            set y [expr [winfo y $pare]+[winfo height $pare ]/2- [winfo reqheight $w]]
        } else {
            set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
                    - [winfo vrootx [winfo parent $w]]]
            set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
                    - [winfo vrooty [winfo parent $w]]]
        }
        if { $x < 0 } { set x 0 }
        if { $y < 0 } { set y 0 }
        WmGidGeom $w +$x+$y
        update
	# extrange errors with updates
        if { ![winfo exists $w] } { return 0}
        wm deiconify $w
    }
    
    # 6. Set a grab and claim the focus too.
    
    set oldFocus [focus]
    if { $::tcl_platform(os) != "Darwin"} {
        tkwait visibility $w
    } else {
        update
    }
    set oldGrab ""
    # if { [ winfo exists $w] } {
    #     set oldGrab [grab current $w]
    #     if {$oldGrab != ""} {
    #         set grabStatus [grab status $oldGrab]
    #     }
    # }

    # Make it topmost to avoid putting the window behind gid's.
    # topmost forbidden
    # wm attributes $w -topmost 1
    # GidUtils::WindowAboveGid $w
    
    raise $w
    # grab $w

    if {$default >= 0} {
        focus $w.button$default
        # after 100 catch [list "focus -force $w.button$default"]
        after 100 catch [list "focus $w.button$default"]
        
    } else {
        focus $w
    }
    
    # 7. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.
    
    tkwait variable tkPriv(button)
    
    if { $oldFocus == "" || [catch {focus $oldFocus}] } {
        if { [winfo exists .gid] } {
            focus [focus -lastfor .gid]
        }
    }
    
    destroy $w
    # if {$oldGrab != ""} {
    #     if {$grabStatus == "global"} {
    #         catch { grab -global $oldGrab }
    #     } else {
    #         catch { grab $oldGrab }
    #     }
    # }   
    if { $option_do_it_for_all } {
        set result [list $tkPriv(button) $::do_it_for_all] 
    } else {
        set result $tkPriv(button)
    }
    return $result
}

#do not delete, used sometimes from C++ in Linux/macOs to try to save password in file (try as administrator if normal open fail)
proc runAsAdministrator { args } {
    package require gid_cross_platform
    gid_cross_platform::run_as_administrator {*}$args
}

#create a raster image from a widget c with Img (image create photo -format window -data $c)
#limitation: to capture the image the whole window must be visible in screen
proc GidUtils::CaptureWindow { win } {
    package require gid_cross_platform
    return [gid_cross_platform::capture_window $win]
}

#return the temporary folder
proc GidUtils::GetTmp { } {
    package require gid_cross_platform
    return [gid_cross_platform::get_tmp]
}

#returns a new folder inside the temporary directory
proc GidUtils::CreateTmpFolderName { } {
    package require gid_cross_platform
    return [gid_cross_platform::create_folder_tmp]
}

#returns a non existent filename inside the temporary directory
proc GidUtils::GetTmpFilename { {extension .tmp} } {
    package require gid_cross_platform
    return [gid_cross_platform::get_unused_tmp_filename gid $extension]
}

#similar to GiD_MeshPost create, maybe to be implemented at c++ level...
proc GiD_MeshPre_Create { element_type element_nnodes node_ids node_coordinates element_ids element_connectivities {zero_based_array 0} {layer_name ""} {radius_and_normals ""}} {
    set res ""
    if { $zero_based_array } {
        # $radius_and_normals
        set res [GiD_MeshPre create $layer_name $element_type $element_nnodes -zero_based_array \
          $node_ids $node_coordinates $element_ids $element_connectivities $radius_and_normals]
    } else {
        set res [GiD_MeshPre create $layer_name $element_type $element_nnodes \
          $node_ids $node_coordinates $element_ids $element_connectivities $radius_and_normals]
    }
    return $res
}

proc GiD_Mesh_exists_node { num_node } {
    return [GiD_Mesh exists node $num_node]
}

#already used by tester, because GiD_Mesh or GiD_Geometry in GiD 16 official already doesn't has higherentity option
#return the amount of higher entities
#entity_type: point line surface or node (a volume doesn't has higher entities)
#entity_id: integer that identify the entity
proc GidUtils::GetEntityNumHigherEntities { entity_type entity_id } {
    set num_higher_entities 0
    if { $entity_type == "node" } {
        set num_higher_entities [GiD_Mesh get node $entity_id higherentity]
    } else {
        set num_higher_entities [GiD_Geometry get $entity_type $entity_id higherentity]
    }
    return $num_higher_entities
}


namespace eval GidGraph { }
#back compatibility
proc GidGraph::Window { points title x_text y_text {series_options {}} {type "xy"} } {
    return [GidGraph::Window2 -points $points -title $title -x_text $x_text -y_text $y_text -series_options $series_options -type $type]
}

#back compatibility
proc GidGraph::InFrame { f points title x_text y_text {series_options {}} {type "normal"}} {
    return [GidGraph::InFrame2 -points $points -title $title -x_text $x_text -y_text $y_text -series_options $series_options -type $type $f]
}

#back compatibility, renamed to get_folder_gid
namespace eval gid_filesystem {
}

proc gid_filesystem::get_folder_application { } {
    return [gid_filesystem::get_folder_gid]
}


# now is better to use the BoundingBox object of the package gid_bounding_box

proc GidUtils::BoundingBoxJoinPoint { p bbox } {
    lassign $p v(x) v(y) v(z)
    if { $bbox == "" } {
        set bbox [list $v(x) $v(y) $v(z) $v(x) $v(y) $v(z)]
    }  else {
        lassign $bbox pmin(x) pmin(y) pmin(z) pmax(x) pmax(y) pmax(z)
        foreach dim {x y z} {
            if { $pmin($dim)>$v($dim) } {
                set pmin($dim) $v($dim)
            }
            if { $pmax($dim)<$v($dim) } {
                set pmax($dim) $v($dim)
            }
        }
        set bbox [list $pmin(x) $pmin(y) $pmin(z) $pmax(x) $pmax(y) $pmax(z)]
    }
    return $bbox
}

proc GidUtils::BoundingBoxJoinBoundingBox { bbox_to_join bbox } {
    lassign $bbox_to_join pmin_1(x) pmin_1(y) pmin_1(z) pmax_1(x) pmax_1(y) pmax_1(z)
    if { $bbox == "" } {
        set bbox $bbox_to_join
    } else {
        lassign $bbox pmin(x) pmin(y) pmin(z) pmax(x) pmax(y) pmax(z)
        foreach dim {x y z} {
            if { $pmin($dim)>$pmin_1($dim) } {
                set pmin($dim) $pmin_1($dim)
            }
            if { $pmax($dim)<$pmax_1($dim) } {
                set pmax($dim) $pmax_1($dim)
            }
        }
        set bbox [list $pmin(x) $pmin(y) $pmin(z) $pmax(x) $pmax(y) $pmax(z)]
    }
    return $bbox
}


#return true if bbox_2 is inside bbox_1 with a tolerance
proc GidUtils::BoundingBoxIsInside { bbox_1 bbox_2 tolerance } {
    lassign $bbox_1 pmin_1(x) pmin_1(y) pmin_1(z) pmax_1(x) pmax_1(y) pmax_1(z)
    lassign $bbox_2 pmin_2(x) pmin_2(y) pmin_2(z) pmax_2(x) pmax_2(y) pmax_2(z)
    foreach dim {x y z} {
        if { $pmin_1($dim)-$tolerance>$pmin_2($dim) } {
            return 0
        }
        if { $pmax_1($dim)+$tolerance<$pmax_2($dim) } {
            return 0
        }
    }
    return 1
}

proc PostPreferences_PostLine_SetValue { key value } {
    if { $key== Quality } {
        GiD_Set PostLine(Quality) $value
    } elseif { $key== NiceDetail } {
        if { $value == 4 } {
            set value GID_LINE_DETAIL_4
        } else {
            set value GID_LINE_DETAIL_8
        }
        GiD_Set PostLine(NiceDetail) $value
    } elseif { $key== Size } {
        GiD_Set PostLine(Size) $value
    } else {
        error "Unknown key $key, and PostPreferences_PostLine_SetValue is deprecated. use GiD_Set PostLine($key) $value"
    }
}