proc DebugMesher { NumNodes NumElems { close 0 } } {
    global DebugMPriv

    set w .gid.wdebugmesher

    if { ![winfo exists $w] } {

        if { $close == 1 } { 
            return -1
        }

        GidUtils::CloseWindow MESHPROGRESS

        if { 0 } {
            toplevel $w
            if { $::tcl_platform(platform) == "windows" } {
                wm attributes $w -toolwindow 1
            }
            wm title $w [_ "Debug mesher"]
            set pare .gid
            # set x [expr [winfo x $pare]+[winfo width $pare ]/2- [winfo reqwidth $w]/2]
            set x 0
            set y [expr [winfo y $pare]+[winfo height $pare ]/2-[winfo reqheight $w]]
            wm geometry $w +$x+$y
        } else {
            InitWindow2 $w -title [_ "Debug mesher"] -geometryvariable PreDebugMesherWindowGeom -onlygeometry -ontop
        }

        set DebugMPriv(inival) 1
        set DebugMPriv(endval) 1
        set DebugMPriv(drawlabels) 0
        set DebugMPriv(drawfull) 0
        set DebugMPriv(nostop) 0
        set DebugMPriv(AddFrame) 0
        

        ttk::label $w.label#1 -text NumElems:
        ttk::label $w.label#2 -text 0
        ttk::label $w.label#3 -text NumNodes:
        ttk::label $w.label#4 -text 0
        ttk::label $w.label#5 -text {Stop after:}
        ttk::entry $w.entry#1 -textvariable DebugMPriv(endval) -width 6

        bind $w.entry#1 <Return> "$w.button#1 invoke"
        focus $w.entry#1

        bind .gid.comm.e <Tab> " \
                if  !\[winfo exists $w.entry#1] {
            bind .gid.comm.e <Tab> {}
            break
        } ; \
        focus $w.entry#1 ; break"


        
        $w.entry#1 sel range 0 end

        ttk::button $w.button#1 -text Go -command {
            set DebugMPriv(inival) 1
            if { [catch {
                set DebugMPriv(endval) [expr int($DebugMPriv(endval))]
            } ] } {
                set DebugMPriv(endval) 0
            }
        }

        ttk::button $w.button#2 -text Finish -command {
            set DebugMPriv(inival) 0
            set DebugMPriv(endval) -1
        }

        ttk::button $w.button#3 -text Stop -command {
            set DebugMPriv(inival) 1
            set DebugMPriv(endval) 1
        }

        ttk::checkbutton $w.button#4 -text [_ "Draw labels"] -variable DebugMPriv(drawlabels)

        ttk::frame $w.dump
        ttk::checkbutton $w.dump.button#5 -text [_ "Draw full"] -variable DebugMPriv(drawfull)

        ttk::label $w.dump.l -text [concat [_ "Dump to"]: "Front-NUM.mesh"]
        ttk::button $w.dump.b -text Dump -command {
            set DebugMPriv(inival) 1
            set DebugMPriv(endval) -2
        }
        grid $w.dump.l $w.dump.b $w.dump.button#5 -sticky w


        # Geometry management

        grid $w.label#1 -in $w        -row 1 -column 1
        grid $w.label#2 -in $w        -row 1 -column 2
        grid $w.label#3 -in $w        -row 2 -column 1
        grid $w.label#4 -in $w        -row 2 -column 2
        grid $w.label#5 -in $w        -row 3 -column 1
        grid $w.entry#1 -in $w        -row 3 -column 2
        grid $w.button#1 -in $w        -row 3 -column 3
        grid $w.button#2 -in $w        -row 4 -column 1
        grid $w.button#3 -in $w        -row 4 -column 2
        grid $w.button#4 -in $w        -row 4 -column 3
        grid $w.dump -in $w        -row 5 -column 1 -columnspan 3

        # Resize behavior management

        grid rowconfigure $w 1 -weight 0 -minsize 30
        grid rowconfigure $w 2 -weight 0 -minsize 30
        grid rowconfigure $w 3 -weight 0 -minsize 30
        grid rowconfigure $w 4 -weight 0 -minsize 30
        grid columnconfigure $w 1 -weight 0 -minsize 30
        grid columnconfigure $w 2 -weight 0 -minsize 30
        grid columnconfigure $w 3 -weight 0 -minsize 30

        ttk::label $w.l01 -text VeryHardTolerance
        ttk::entry $w.e01 -textvariable DebugMPriv(VeryHardTolerance)

        ttk::label $w.l1 -text HardTolerance
        ttk::entry $w.e1 -textvariable DebugMPriv(HardTolerance)

        ttk::label $w.l2 -text SoftTolerance
        ttk::entry $w.e2 -textvariable DebugMPriv(SoftTolerance)

        ttk::label $w.l3 -text NumUsedClosePoints
        ttk::entry $w.e3 -textvariable DebugMPriv(NumUsedClosePoints)

        ttk::label $w.l4 -text ClosePointFactor2
        ttk::entry $w.e4 -textvariable DebugMPriv(ClosePointFactor2)

        ttk::label $w.l5 -text VeryHardDebugging
        ttk::entry $w.e5 -textvariable DebugMPriv(VeryHardDebugging)

        
        ttk::checkbutton $w.donotstop -text [_ "Not stop until end"] -variable DebugMPriv(nostop)

        
        ttk::checkbutton $w.l6 -text [_ "Add animation frame"] -variable DebugMPriv(AddFrame)
        ttk::button $w.br -text debuggidfile -command {
            set file [file join [lindex [GiD_Info Project ] 9] debuggidfile]
            exec gnuclient $file &
        }
        grid $w.l01  -in $w        -row 6 -column 1
        grid $w.e01  -in $w        -row 6 -column 2 -columnspan 2

        grid $w.l1  -in $w        -row 7 -column 1
        grid $w.e1  -in $w        -row 7 -column 2 -columnspan 2

        grid $w.l2  -in $w        -row 8 -column 1
        grid $w.e2  -in $w        -row 8 -column 2 -columnspan 2


        grid $w.l3  -in $w        -row 9 -column 1
        grid $w.e3  -in $w        -row 9 -column 2 -columnspan 2

        grid $w.l4  -in $w        -row 10 -column 1
        grid $w.e4  -in $w        -row 10 -column 2 -columnspan 2

        grid $w.l5  -in $w        -row 11 -column 1
        grid $w.e5  -in $w        -row 11 -column 2 -columnspan 2

        grid $w.donotstop -in $w        -row 12 -column 1
        grid $w.l6 -in $w        -row 13 -column 1  -columnspan 2
        grid $w.br -in $w -row 14 -column 1 -columnspan 2
    }

    $w.label#2 configure -text $NumElems
    $w.label#4 configure -text $NumNodes


    update

    if { $DebugMPriv(AddFrame) } {
        GiD_Redraw
        GiD_Process 'AnimationFile AddStep
    }

    if { $close == 1 || $DebugMPriv(endval) == -1 } {
        destroy $w
        return -1
    } elseif { $close == -1 } {
        set DebugMPriv(inival) 1
        set DebugMPriv(endval) 1
        $w.entry#1 sel range 0 end
        $w.entry#1 icursor end
    }

    if { $DebugMPriv(endval) > 0 && $DebugMPriv(inival) >= $DebugMPriv(endval) && !$DebugMPriv(nostop) } {
        vwait DebugMPriv(inival)
    } else {
        incr DebugMPriv(inival)
    }

    if { $DebugMPriv(endval) == -2 } {
        set DebugMPriv(inival) 1
        set DebugMPriv(endval) 1
        return 2
    } elseif { $DebugMPriv(endval) == -1 } {
        destroy $w
        return -1
    }

    if { $DebugMPriv(drawlabels) } {
        if { $DebugMPriv(drawfull) } {
            return -6
        } else {
            return -4
        }
    } else {
        if { $DebugMPriv(drawfull) } {
            return -5
        } else {
            return -3
        }
    }
}

proc debugmesher2_ui {root} {
    global DebugMPriv


    # this treats "." as a special case

    if {$root == "."} {
        set base ""
    } else {
        set base $root
    }

    ttk::frame $base.frame#1

    scale $base.scale#1 \
            -label {Element number:} \
            -orient h \
            -variable DebugMPriv(elmnumber) \
            -bigincrement 100

    focus $base.scale#1

    bind .gid.comm.e <Tab> " \
        if  !\[winfo exists $base.scale#1] {
          bind .gid.comm.e <Tab> {}
          break
        } ; \
        focus $base.scale#1 ; break"
        
    label $base.label#1 \
            -text {Element number:}
        
        
    entry $base.entry#1
    set DebugMPriv(elmnumberentry) $base.entry#1

    bind $base.entry#1 <Return> "set DebugMPriv(elmnumber) \[$base.entry#1 get]"
    bind $base.entry#1 <Up> "set DebugMPriv(elmnumber) \
            \[expr \[$base.entry#1 get]+1]"
    bind $base.entry#1 <Down> "set DebugMPriv(elmnumber) \
            \[expr \[$base.entry#1 get]-1]"
    bind $base.entry#1 <Alt-Up> "set DebugMPriv(elmnumber) \
            \[expr \[$base.entry#1 get]+10] ; break"
    bind $base.entry#1 <Alt-Down> "set DebugMPriv(elmnumber) \
            \[expr \[$base.entry#1 get]-10] ; break"

    button $base.button#2 \
            -text Update -command { GiD_Redraw }
    #-text Update -command DebugMesherPostUpdate2

    checkbutton $base.checkbutton#1 \
            -text {Update dinamically} \
            -variable DebugMPriv(Updatedinamically)

    tk::listbox $base.text#1 \
            -height 1 \
            -width 1 \
            -xscrollcommand "$base.scrollbar#2 set" \
            -yscrollcommand "$base.scrollbar#1 set" \
            -selectmode single \
            -exportselection 0

    scrollbar $base.scrollbar#1 \
            -command "$base.text#1 yview" \
            -orient v


    scrollbar $base.scrollbar#2 \
            -command "$base.text#1 xview" \
            -orient h

    label $base.label#2 \
            -text Search:


    entry $base.entry#2 \
            -textvariable DebugMPriv(search)

    button $base.button#1 \
            -text Close -command "destroy $base"


    ttk::frame $base.frame#3

    tk::listbox $base.listbox#1 \
            -height 1 \
            -width 1 \
            -xscrollcommand "$base.scrollbar#4 set" \
            -yscrollcommand "$base.scrollbar#3 set" \
            -selectmode single

    scrollbar $base.scrollbar#3 \
            -command "$base.listbox#1 yview" \
            -orient v


    scrollbar $base.scrollbar#4 \
            -command "$base.listbox#1 xview" \
            -orient h


    # Geometry management

    grid $base.frame#1 -in $root        -row 4 -column 1  \
            -columnspan 2 -sticky nesw
    grid $base.scale#1 -in $root        -row 1 -column 1  \
            -columnspan 2 \
            -sticky ew
    grid $base.label#1 -in $root        -row 2 -column 1  \
            -sticky e
    grid $base.entry#1 -in $root        -row 2 -column 2  \
            -sticky nesw
    grid $base.button#2 -in $root        -row 3 -column 1
    grid $base.checkbutton#1 -in $root        -row 3 -column 2  \
            -sticky e
    grid $base.text#1 -in $base.frame#1        -row 1 -column 1  \
            -sticky nesw
    grid $base.scrollbar#1 -in $base.frame#1        -row 1 -column 2  \
            -sticky ns
    grid $base.scrollbar#2 -in $base.frame#1        -row 2 -column 1  \
            -sticky ew
    grid $base.label#2 -in $root        -row 5 -column 1  \
            -sticky e
    grid $base.entry#2 -in $root        -row 5 -column 2  \
            -sticky nesw
    grid $base.button#1 -in $root        -row 7 -column 1  \
            -columnspan 2


    grid $base.frame#3 -in $root        -row 6 -column 1  \
            -columnspan 2 -sticky nesw
    grid $base.listbox#1 -in $base.frame#3        -row 1 -column 1  \
            -sticky nesw
    grid $base.scrollbar#3 -in $base.frame#3        -row 1 -column 2  \
            -sticky ns
    grid $base.scrollbar#4 -in $base.frame#3        -row 2 -column 1  \
            -sticky ew


    # Resize behavior management

    grid rowconfigure $root 1 -weight 0 -minsize 30
    grid rowconfigure $root 2 -weight 0 -minsize 30
    grid rowconfigure $root 3 -weight 0 -minsize 30
    grid rowconfigure $root 6 -weight 1 -minsize 122
    grid rowconfigure $root 5 -weight 0 -minsize 30
    grid rowconfigure $root 4 -weight 1 -minsize 122
    grid columnconfigure $root 1 -weight 0 -minsize 30
    grid columnconfigure $root 2 -weight 1 -minsize 2

    grid rowconfigure $base.frame#1 1 -weight 1
    grid rowconfigure $base.frame#1 2 -weight 0
    grid columnconfigure $base.frame#1 1 -weight 1
    grid columnconfigure $base.frame#1 2 -weight 0

    grid rowconfigure $base.frame#3 1 -weight 1
    grid rowconfigure $base.frame#3 2 -weight 0
    grid columnconfigure $base.frame#3 1 -weight 1
    grid columnconfigure $base.frame#3 2 -weight 0
}


proc DebugMesherPostUpdateT { name1 name2 op } {
    global DebugMPriv
    if { ! $DebugMPriv(Updatedinamically) } return
        
    #DebugMesherPostUpdate2
    GiD_Redraw

    $DebugMPriv(elmnumberentry) delete 0 end
    $DebugMPriv(elmnumberentry) insert end $DebugMPriv(elmnumber)

}

proc DebugMesherPostUpdate {} {
    global DebugMPriv
   set DebugMPriv(lastelmnumber) $DebugMPriv(elmnumber)
   set fastselection [GiD_Set FastSelection]
    GiD_Process MEscape Utilities Variables FastSelection 1
    GiD_Process 'Layers Entities ElementsHide Element 1: escape material ElementsShow trick:$DebugMPriv(elmnumber) escape
    GiD_Process 'Layers Material ElementsShow trick:$DebugMPriv(elmnumber)
    GiD_Process 'Layers Entities ElementsShow LowerEntities Elements layer:ElementsShow escape
    GiD_Process MEscape Utilities Variables FastSelection $fastselection escape
}

proc DebugMesherPostUpdate2 {} {
    global DebugMPriv
    ::GidUtils::DisableGraphics
    set fastselection [GiD_Set FastSelection]
     GiD_Process MEscape Utilities Variables FastSelection 1
    #GiD_Process escape escape view layers SendToBack LowerEntities Elements Layer:Layer0
    #no uso back y front porque no puedo enviar al front una seleccion de entidades
    GiD_Process MEscape View Layers Entities ElementsHide Elements Layer:ElementsShow escape
    #si no pongo un maximo colapso el buffer de process
    #set maxbuf 500
    set elemsfront ""
    for { set i 1 } { $i <= $DebugMPriv(NumElems) } { incr i } {
        if { ![info exists DebugMPriv($ElemStart,$i)] } {
            if { $i > $DebugMPriv(elmnumber) } break
        } else {
            if { $DebugMPriv(ElemStart,$i) > $DebugMPriv(elmnumber) } continue
            if { $DebugMPriv(ElemEnd,$i) < $DebugMPriv(elmnumber) } continue
        }

        #GiD_Process escape escape view layers entities ElementsShow Elements $i escape
        lappend elemsfront $i
        #if { [llength $elemsfront] > $maxbuf } {
        #    GiD_Process escape escape view layers entities ElementsShow Elements $elemsfront escape
        #    set elemsfront ""
        #}
    }
    #if { [llength $elemsfront] } {
        GiD_Process Mescape View Layers Entities ElementsShow Elements $elemsfront escape
    #}
    GiD_Process MEscape Utilities Variables FastSelection $fastselection escape

    ::GidUtils::EnableGraphics
    GiD_Redraw
}


proc DebugMesherPostUpdate3 {} {
    global DebugMPriv
    #WarnWinText "DebugMesherPostUpdate3"
    #return

    if { ![info exists DebugMPriv(elmnumberprev)] || $DebugMPriv(elmnumber) != $DebugMPriv(elmnumberprev) } {
        if { [info exists DebugMPriv(drawlist)] && $DebugMPriv(drawlist) != "" } {
            GiD_OpenGL draw -deletelists "$DebugMPriv(drawlist) 1"
            set DebugMPriv(drawlist) ""
        }
        set DebugMPriv(drawlist) [GiD_OpenGL draw -genlists 1]
        GiD_OpenGL draw -newlist $DebugMPriv(drawlist) compile

        set elemstoremovenext ""
        for { set i 1 } { $i <= $DebugMPriv(NumElems) } { incr i } {
            if { ![info exists DebugMPriv(ElemStart,$i)] } {
                if { $i > $DebugMPriv(elmnumber) } break
            } else {
                if { $DebugMPriv(ElemStart,$i) > $DebugMPriv(elmnumber) } continue
                if { $DebugMPriv(ElemEnd,$i) < $DebugMPriv(elmnumber) } continue
            }
            if { [info exists DebugMPriv(ElemEnd,$i)] && $DebugMPriv(elmnumber) == [expr $DebugMPriv(ElemEnd,$i)-1] }  {
                lappend elemstoremovenext $i
                continue
            }
            if { [string equal -nocase [GiD_Info Project RenderMode] "normal"] } {
                DrawElem $i
            } elseif { [string equal -nocase [GiD_Info Project RenderMode] "postprocess"] } {
                DrawRenderElem $i
                DrawElem $i
            } elseif { [string equal -nocase [GiD_Info Project RenderMode] "polygons"] } {
                DrawRenderElem $i
                DrawElem $i
            } else {
                DrawRenderElem $i
                #DrawElem $i
            }
        }
        #to draw specially the front elements to disappear in the next step
        foreach i $elemstoremovenext {
            DrawElem $i {1 0 0}
            DrawRenderElem $i {0.7 0.7 1.0}
        }
        
        GiD_OpenGL draw -endlist
        set DebugMPriv(elmnumberprev) $DebugMPriv(elmnumber)
    }
    GiD_OpenGL draw  -call $DebugMPriv(drawlist)
}

proc DrawElem { num { color "0 0 0" } } {
    global DebugMPriv

    GiD_OpenGL draw -color $color -begin lineloop
    foreach inode $DebugMPriv(FrontElem,$num) {
        GiD_OpenGL draw -vertex $DebugMPriv(Node,$inode)
    }
    GiD_OpenGL draw -end
}

proc DrawRenderElem { num { color "0.8 1.0 1.0" } } {
    global DebugMPriv
    GiD_OpenGL draw -polygonmode frontandback fill -color $color  -begin triangles
    foreach inode $DebugMPriv(FrontElem,$num) {
        GiD_OpenGL draw -vertex $DebugMPriv(Node,$inode)
    }
    GiD_OpenGL draw -end
}

proc DebugMesherPostSearch { w { forward 1 } } {
    global DebugMPriv
    if { $forward == 1 } {
        set forflag -forwards
    } else { set forflag -backwards }

    set ret [$w.text#1 search $forflag -nocase -- $DebugMPriv(search) insert]
    if { $ret == "" } {
        bell
    } else {
        $w.text#1 mark set insert $ret
        $w.text#1 see insert
    }
}

proc DebugL2FillPost { dir } {
    global DebugMPriv
    $DebugMPriv(w).listbox#1 delete 0 end
    set files [lsort -dictionary [glob -nocomplain [file join $dir "Front-*.mesh"]]]
    if { $files != "" } {
        foreach i $files {
            set fileid [open $i r]
            set NumElems [lindex [gets $fileid] 2]
            close $fileid
            $DebugMPriv(w).listbox#1 insert end "$NumElems [file tail $i]"
        }
    }
}

proc DebugDirSelectPost {} {
    global DebugMPriv
    for { set i 0 } { $i < [$DebugMPriv(w).text#1 size] } { incr i } {
        if { [$DebugMPriv(w).text#1 sel includes $i] } {
            DebugL2FillPost [$DebugMPriv(w).text#1 get $i]
            set DebugMPriv(TemporalDir) [$DebugMPriv(w).text#1 get $i]
        }
    }
}

proc DebugMeshReadPost {} {
    global DebugMPriv

    set NumElems [lindex [$DebugMPriv(w).listbox#1 get active] 0]
    set DebugMPriv(NumElems) $NumElems
    set DebugMPriv(NumSteps) $NumElems
    $DebugMPriv(w).scale#1 configure -to $DebugMPriv(NumSteps)

    set filename [file join $DebugMPriv(TemporalDir) \
                [lindex [$DebugMPriv(w).listbox#1 get active] 1]]
#    if { [GidUtils::ExistsMesh] } {
#        GiD_Process MEscape files meshread Erase $filename
#    } else {
#        GiD_Process MEscape files meshread $filename
#    }
    DebugMeshReadMeshFile $filename

    set DebugMPriv(elmnumber) 1
}

proc DebugMeshReadMeshFile { filename } {
    global DebugMPriv

    if [catch {set archivo [open $filename r]} f] {
        WarnWinText "Error: Cannot open '$filename': $f"
        return
    }
    #WarnWinText "Reading '$filename'..."
    ::GidUtils::SetWarnLine [_ "Reading '%s" $filename']...
    set nend 0
    set NumNodes 0
    set NumElems 0
    set NumLine 0
    set ToRead "BeginNodes"
    while { ![ eof $archivo ] } {
        gets $archivo aa
        incr NumLine
        switch $ToRead {
            "Mesh" {
                # MESH    dimension 3 ElemType Triangle Nnode 3
            }
            "BeginNodes" {
                if { [string equal -nocase $aa "Coordinates"] } { set ToRead "Nodes" }
            }
            "Nodes" {
                if { [string equal -nocase $aa "End Coordinates"] } {
                    set ToRead "BeginElems"
                } else {
                    set nitem [scan $aa  " %i %lf %lf %lf" num x y z]
                    if { $nitem < 3 } {
                        WarnWinText "Error reading node in line $NumLine ='$aa'"
                        break
                    } elseif { $nitem == 3 } {
                        set z 0
                    }
                    set DebugMPriv(Node,$num) "$x $y $z"
                    incr NumNodes
                }
            }
            "BeginElems" {
                if { [string equal -nocase $aa "Elements"] } { set ToRead "Elements" }
            }
            "Elements" {
                if { [string equal -nocase $aa "End Elements"] } {
                    set ToRead "EOF"
                    break
                } else {
                    set nitem [scan $aa  " %i %i %i %i %i # ini=%i end=%i " num n1 n2 n3 nmat nini nend]
                    if { $nitem != 7 } {
                        WarnWinText "Error reading element in line $NumLine ='$aa'"
                        break
                    }
                    set DebugMPriv(FrontElem,$num) "$n1 $n2 $n3"
                    set DebugMPriv(ElemStart,$num) $nini
                    set DebugMPriv(ElemEnd,$num) $nend
                    incr NumElems
                }
            }
        }

    }
    close $archivo

    set DebugMPriv(NumNodes) $NumNodes
    set DebugMPriv(NumElems) $NumElems
    set DebugMPriv(NumSteps) $nend
    $DebugMPriv(w).scale#1 configure -to $DebugMPriv(NumSteps)

    #WarnWinText "Read $DebugMPriv(NumNodes) nodes, $DebugMPriv(NumElems) elements, num steps=$DebugMPriv(NumSteps)"
    ::GidUtils::SetWarnLine [_ "Debug Mesh: Read %s nodes, %s elements" $DebugMPriv(NumNodes) $DebugMPriv(NumElems)]

    catch {
        set DebugMPriv(elmnumber) 1
    }

    #only is released if DebugMPriv(GiD_OpenGL) exists
    ReleaseCallbackRedraw
    set DebugMPriv(GiD_OpenGL) [GiD_OpenGL register DebugMesherPostUpdate3]
}

proc DebugSendMesherPost {} {
    global DebugMPriv



    if { [GiD_Info Mesh] == 0 } {
         GiD_Process MEscape *****MESHVOL \
             [file join $DebugMPriv(TemporalDir) [lindex [$DebugMPriv(w).listbox#1 get active] 1]]
    } else {
        GiD_Process MEscape *****MESHVOL yes \
            [file join $DebugMPriv(TemporalDir) [lindex [$DebugMPriv(w).listbox#1 get active] 1]]
    }
}

proc DebugSendDebuggidfilePost {} {
    global DebugMPriv

    set pid [exec emacsclient [file join $DebugMPriv(TemporalDir) debuggidfile] > /dev/null &]
    exec kill $pid
}


proc DebugMesherPost { { w .gid.wdevm } } {
    global DebugMPriv tcl_platform env

    set NumElems [GiD_Info Mesh MaxNumElements]
    set DebugMPriv(NumSteps) $NumElems
    set DebugMPriv(NumElems) $NumElems
    catch { destroy $w }

    if { 0 } {
        toplevel $w
        if { $::tcl_platform(platform) == "windows" } {
            wm attributes $w -toolwindow 1
        }
        wm title $w [_ "Debug mesher post"]
        set pare .gid
        #         set x [expr [winfo x $pare]+[winfo width $pare ]/2- \
                #                    [winfo reqwidth $w]/2]
        set x 0
        set y [expr [winfo y $pare]+[winfo height $pare ]/2- \
                    [winfo reqheight $w]]
        wm geometry $w +$x+$y
    } else {
        InitWindow2 $w -title [_ "Debug mesher post"] -geometryvariable PostDebugMesherPostWindowGeom -onlygeometry -ontop
    }
    debugmesher2_ui $w

    $w.scale#1 configure -from 1
    $w.scale#1 configure -to $DebugMPriv(NumSteps)

    set DebugMPriv(w) $w

#    set layerslist [GiD_Layers list]
#    if { [lsearch $layerslist ElementsHide] == -1 } {
#        GiD_Process 'Layers New ElementsHide escape
#    }
#    if { [lsearch $layerslist ElementsShow] == -1 } {
#        GiD_Process 'Layers New ElementsShow escape
#    }
#   GiD_Process 'Layers Off ElementsHide ToUse ElementsHide escape escape

    set DebugMPriv(lastelmnumber) $NumElems
    trace variable DebugMPriv(elmnumber) w DebugMesherPostUpdateT

    if {$tcl_platform(platform) == "windows"} {
      set dirs [glob -nocomplain [file join $env(TEMP) gid*]]
    } else {
      set dirs [eval exec [concat ls -1dt [glob /tmp/gid*]]]
    }

    foreach i $dirs {
        $w.text#1 insert end $i
    }

    set DebugMPriv(TemporalDir) [GiD_Info Project TmpDirectory]
    DebugL2FillPost $DebugMPriv(TemporalDir)

    bind $w.listbox#1 <1> " focus $w.listbox#1"
    bind $w.listbox#1 <g> DebugSendMesherPost
    bind $w.listbox#1 <m> DebugMeshReadPost
    bind $w <e> DebugSendDebuggidfilePost

    menu $w.debugmenu

    $w.debugmenu add command -label [_ "Mesh read"] -command DebugMeshReadPost
    $w.debugmenu add command -label [_ "Generate mesh"] -command DebugSendMesherPost
    $w.debugmenu add command -label [concat [_ "Send file to"] "emacs"] -command DebugSendDebuggidfilePost


    bind $w.listbox#1 <$::gid_right_button> "tk_popup $w.debugmenu %X %Y"

    bind $w.listbox#1 <Double-1> {
        catch {
            foreach i [split [selection get] \n] {
                if { $i == "" } { continue }
                #GiD_Process Mescape *****MESHVOL [file join $DebugMPriv(TemporalDir)        [lindex $i 1]]
                #DebugSendMesherPost
                DebugMeshReadPost
            }
        }
   }

   #GiD_Process Mescape escape view entities elements escape
   bind $w.text#1 <Double-1> DebugDirSelectPost



   bind $w <Destroy> "+ReleaseCallbackRedraw"
}

proc ReleaseCallbackRedraw { } {
    global DebugMPriv
    #WarnWinText "unregister"

    #GiD_Process Mescape view entities elements escape
    if { [info exists DebugMPriv(GiD_OpenGL)] && $DebugMPriv(GiD_OpenGL) != "" } {
        GiD_OpenGL unregister $DebugMPriv(GiD_OpenGL)
        catch { unset DebugMPriv }
    }
}
