namespace eval DebugBoolean {
    variable idx 0
    variable jdx 0
    variable stop_each 1
    variable counter 0
    variable to_do WAIT
    variable w .gid.debugboolean
    variable stop_condition ""
    variable redraw_id 0
    variable must_draw 1
}

proc DebugBoolean::OpenWindow { } {
    variable idx
    variable jdx
    variable stop_each
    variable to_do
    variable w
    variable stop_condition
    variable redraw_id
    variable must_draw
    toplevel $w
    if { $::tcl_platform(platform) == "windows" } {
        wm attributes $w -toolwindow 1
    }
    wm title $w "Debug boolean operation"
    ttk::frame $w.f_1
    ttk::label $w.f_1.l_surfaces -text "Surfaces"
    ttk::label $w.f_1.l_idx -textvariable ::DebugBoolean::idx
    ttk::label $w.f_1.l_jdx -textvariable ::DebugBoolean::jdx
    ttk::label $w.f_1.l_stop_each -text "Stop each"
    ttk::entry $w.f_1.e_stop_each -textvariable ::DebugBoolean::stop_each
    ttk::label $w.f_1.l_stop_condition -text "Stop condition"
    ttk::entry $w.f_1.e_stop_condition -textvariable ::DebugBoolean::stop_condition
    if { ![info exists ::DebugBoolean::must_draw] } { set ::DebugBoolean::must_draw 0 }
    ttk::checkbutton $w.f_1.ch_draw -text "Draw surfaces" -variable ::DebugBoolean::must_draw \
          -command DebugBoolean::DrawOnOff
          
    ttk::frame $w.f_buttons -style BottomFrame.TFrame
    ttk::button $w.f_buttons.b_continue        -text "Continue" \
      -style BottomFrame.TButton -command {set ::DebugBoolean::to_do CONTINUE}
    ttk::button $w.f_buttons.b_break -text "Break" \
      -style BottomFrame.TButton -command {set ::DebugBoolean::to_do BREAK}
    
    

    grid $w.f_1.l_surfaces $w.f_1.l_idx $w.f_1.l_jdx -sticky ew
    grid $w.f_1.l_stop_each $w.f_1.e_stop_each -sticky ew
    grid configure $w.f_1.e_stop_each -columnspan 2
    grid $w.f_1.l_stop_condition $w.f_1.e_stop_condition -sticky ew
    grid configure $w.f_1.e_stop_condition -columnspan 2
    grid $w.f_1.ch_draw
    grid $w.f_buttons.b_continue $w.f_buttons.b_break -sticky ew

    grid $w.f_1 -sticky nsew
    grid $w.f_buttons -sticky sew
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1

    bind $w <Destroy> [list +DebugBoolean::Destroy %W $w]
    bind $w <Return> "$w.f_buttons.b_continue invoke"

    if { $must_draw == 1 } {
        DebugBoolean::DrawOn
    }
}

proc DebugBoolean::DrawOnOff { } {
    variable must_draw
    if { $must_draw == 1 } {
        DebugBoolean::DrawOn
    } else {
        DebugBoolean::DrawOff
    }
    GiD_Redraw
}

proc DebugBoolean::DrawOn { } {
    variable redraw_id
    if { $redraw_id == 0 } {
        set redraw_id [GiD_OpenGL register DebugBoolean::RedrawProcedure]
    }
}

proc DebugBoolean::DrawOff { } {
    variable redraw_id
    if { $redraw_id != 0 } {
        GiD_OpenGL unregister $redraw_id
        set redraw_id 0
    }
}

proc DebugBoolean::Destroy { W w } {
    variable to_do
    variable redraw_id
    if { $W != $w } return
    DebugBoolean::DrawOff
    set ::DebugBoolean::to_do BREAK
}

proc DebugBoolean::Do { i j } {
    variable idx
    variable jdx
    variable stop_each
    variable counter
    variable to_do
    variable w
    variable stop_condition


    if { ![winfo exists $w] } {
        DebugBoolean::OpenWindow
    }

    set idx $i
    set jdx $j

    if { $stop_condition != "" } {
        set must_stop 0
        catch { set must_stop [expr $stop_condition] }
        if { $must_stop } {
            set ::DebugBoolean::to_do WAIT
        }
    }
    if { $to_do != "CONTINUE" } {
        GiD_Redraw        
        vwait DebugBoolean::to_do
    }

    if { $to_do == "CONTINUE" } {
        incr counter
        if { $counter >= $stop_each } {
            set to_do WAIT
            set  counter 0
        }
        return 1
    } elseif { $to_do == "BREAK" } {
        set to_do WAIT
        set counter 0
        if { [winfo exists $w] } {
            destroy $w
        }
        return 2
    } else { #WAIT
        return 0
    }
}

proc DebugBoolean::RedrawProcedure { } {
    variable idx
    variable jdx
    GiD_OpenGL draw -clear depthbuffer
    GiD_OpenGL draw -enable depthtest
    GiD_OpenGL draw -color {0.0 1.0 0.0 1.0}
    GiD_OpenGL drawentity -mode filled surface $idx
    GiD_OpenGL draw -color {0.0 0.0 1.0 1.0}
    GiD_OpenGL drawentity -mode filled surface $jdx
}












