#---------start problemtypetest-------------------

proc TestCreateWidgetsFromXml { testnum } {

    set xmlfile "mytest.xml"
    set contentxml {
        <xml_to_tcl version="1.0">
        <window name="nosegid_preferences" label="Test Preferences Window" dynamicupdate="no">
        <group name="general" label="General">
        <labelframe name="entitiescolour" label="Entities colour" help="This option set the default colour of the geometrical and mesh entities.">
        <colorbutton variable="Color(Points)" needsredraw="1" label="Points"/>
        <colorbutton variable="Color(Lines)" needsredraw="1" label="Lines"/>
        <colorbutton variable="Color(PolyLines)" needsredraw="1" label="PolyLines"/>
        <colorbutton variable="Color(Surfaces)" needsredraw="1" label="Surfaces"/>
        <colorbutton variable="Color(SurfsIsoparametric)" needsredraw="1" label="Surfaces Iso"/>
        <colorbutton variable="Color(Volumes)" needsredraw="1" label="Volumes"/>
        <colorbutton variable="Color(Nodes)" needsredraw="1" label="Nodes"/>
        <colorbutton variable="Color(Elements)" needsredraw="1" label="Elements"/>
        </labelframe>
        </group>
        </window>
        </xml_to_tcl>
    }


    switch $testnum {
        1 {
            # 1) Modify preferences window
            set root [CreateWidgetsFromXml::GetPreferencesXml]
            set checkbuttontoadd {
                <checkbutton variable="My_ProgressBarInMainWindow" variablemanager="Mitestproc" label="My_Embedded mi_progress mi_bar" help="hi!!"/>
            }

            set labelframetoadd {
                <labelframe name="pp" label="TestAddAfter">
                <combobox variable="My_Language" variablemanager="Mitestproc" label="My_Language" help="hi world">
                <option value="en" nottransalatelabel="English"></option>
                <option value="es" nottransalatelabel="Spanish"></option>
                <option value="ru" nottransalatelabel="Russian"></option>
                </combobox>
                </labelframe>
            }
            CreateWidgetsFromXml::AddAfterVariable $root "CreateAlwaysNewPoint" $checkbuttontoadd
            CreateWidgetsFromXml::AddBeforeName $root "interface" $labelframetoadd
            CreateWidgetsFromXml::TakeOutVariable $root "BackColor(Top)"
            CreateWidgetsFromXml::TakeOutName $root "general_other"
            #CreateWidgetsFromXml::SetPreferencesXml $root
            CreateWidgetsFromXml::UpdatePreferencesWindow
        }
        2 {
            #--- aux usually file already on disk
            set chan [open $xmlfile w]
            puts $chan $contentxml
            close $chan
            #----

            #create preference window from zero
            set xml [tDOM::xmlReadFile $xmlfile]
            set document [dom parse $xml]
            set rootnode [$document documentElement]
            CreateWidgetsFromXml::SetPreferencesXml $rootnode

            #----
            file delete $xmlfile
        }
        3 {
            #--- aux usually file already on disk
            set chan [open $xmlfile w]
            puts $chan $contentxml
            close $chan
            #----

            #Use CreateWidgetsFromXml for your own windows
            #always file references from scripts folder
            CreateWidgetsFromXml::ReadXmlFile "../$xmlfile" "" "" 0

            #----
            file delete $xmlfile
        }
        4 {
            #open the window
            #always file references from scripts folder
            CreateWidgetsFromXml::IniWin $CreateWidgetsFromXml::fileread(../$xmlfile) ""
        }
        5 {
            #or
            #always file references from scripts folder
            CreateWidgetsFromXml::ReadXmlFile "../$xmlfile" "" "" 1
        }
        6 {
            #only show a subgroup of a xml
            CreateWidgetsFromXml::ReadXmlFile preferences.xml "" "" 1 {meshing fonts}
        }
    }




}

#---------end problemtypetest-------------------

proc EvalVarManager { res_dst varmanager args} {
    upvar $res_dst result
    set err 0
    if { [ info procs $varmanager] != ""} {
        set result [ $varmanager {*}$args]
    } else {
        # give a chance to Tcl to look for varmanager in tclIndex:
        set err [ catch {
            set result [ $varmanager {*}$args]
        } err_txt ]
    }
    return $err
}

#auxiliar functions out of namespace
proc CalculateMaxLength { list } {
    set maxlength 0
    foreach item $list {
        set length [string length $item]
        if {$length>$maxlength} {
            set maxlength $length
        }
    }
    return $maxlength
}

proc SetValue { varname varvalue varmanager} {
    if { $varmanager=="" || $varmanager=="gid" } {
        #GiD_Set $varname $varvalue
        GiD_Process Mescape Utilities Variables $varname $varvalue escape escape
    } else {
        set result 0
        set err [ EvalVarManager result $varmanager SetValue $varname $varvalue]
        if { $err} {
            WarnWinText "MUST IMPLEMENT $varmanager SetValue $varname $varvalue"
        }
    }
}

proc GetValue { varname varmanager} {
    if { $varmanager=="" || $varmanager=="gid" } {
        set result [GiD_Set $varname]
    } else {
        set result 0
        set err [ EvalVarManager result $varmanager GetValue $varname]
        if { $err} {
            set result 0
            WarnWinText "MUST IMPLEMENT $varmanager GetValue $varname"
        }
    }
    return $result
}

proc GetDefaultValue { varname varmanager} {
    if { $varmanager=="" || $varmanager=="gid" } {
        set result [GiD_Set -default $varname]
    } else {
        set result 0
        set err [ EvalVarManager result $varmanager GetDefaultValue $varname]
        if { $err} {
            set result 0
            WarnWinText "MUST IMPLEMENT $varmanager GetDefaultValue $varname"
        }
    }
    return $result
}


set ::printactualvaluesasdefault 0

namespace eval CreateWidgetsFromXml {
    variable fileread
    variable properties ;#array to store properties for each name like
    #count, changedvariables, allvariables, listfunctions_tocall, content_frame, dynamicupdate, current_group
    #There are other variables on namespace, created dinamically when reading xml (more than 1 xml readed)
    variable aux ;#array for auxiliary variables for name and dom node (tmp or local)
    variable AlsoChildren 1;
    variable must_save_preferences_on_destroy 0
    variable preferences_wid  ""
}

#---- modules utilities --------

proc CreateWidgetsFromXml::ClearCachePreferences { } {
    set xmlfile Preferences.xml
    if { [info exists ::CreateWidgetsFromXml::fileread($xmlfile)] } {
        unset ::CreateWidgetsFromXml::fileread($xmlfile)
        unset ::CreateWidgetsFromXml::fileread($xmlfile,name)
        unset ::CreateWidgetsFromXml::fileread($xmlfile,initfunction_on_gid_ini)
    }
}

proc CreateWidgetsFromXml::GetXml { xmlfile } {
    variable fileread
    if { ![info exists fileread($xmlfile)] } {
        CreateWidgetsFromXml::ReadXmlFile $xmlfile "" "" 0
    }
    return $fileread($xmlfile)
}

proc CreateWidgetsFromXml::GetCurrentGroup { xmlfile } {
    variable fileread
    variable properties
    if { [info exists fileread($xmlfile)] } {
        set name $fileread($xmlfile,name)
        if { [info exists properties($name,current_group)] } {
            return $properties($name,current_group)
        }
    }
    return ""
}

proc CreateWidgetsFromXml::SetXml { xmlfile rootnode } {
    variable fileread
    set itsopen 0
    if { [info exists fileread($xmlfile)] } {
        set name $fileread($xmlfile,name)
        set w .gid.$name
        if { ![GidUtils::IsTkDisabled] &&[winfo exists $w] } {
            set itsopen 1
            set currentgroup [CreateWidgetsFromXml::GetCurrentGroup $xmlfile]
            destroy $w
        }
    }
    set fileread($xmlfile) $rootnode
    #and reopen
    if { $itsopen } {
        CreateWidgetsFromXml::IniWin $fileread($xmlfile) $currentgroup $fileread($xmlfile,initfunction_on_gid_ini)
    }
}

proc CreateWidgetsFromXml::AddBeforeUniqueAttribute { uniqueattribute rootnode ref_attribbutevalue contenttoadd } {
    set findnode [$rootnode find $uniqueattribute $ref_attribbutevalue]
    set parentnode [$findnode parentNode]
    if { [info exists $parentnode] } {
        WarnWinText "Not possible to find $uniqueattribute = $ref_attribbutevalue from $rootnode"
    } else {
        $parentnode appendXML $contenttoadd
        set childadded [$parentnode lastChild]
        $parentnode removeChild $childadded
        $parentnode insertBefore $childadded $findnode
    }
}

proc CreateWidgetsFromXml::AddAfterUniqueAttribute {  uniqueattribute rootnode ref_attribbutevalue contenttoadd } {
    set findnode [$rootnode find $uniqueattribute $ref_attribbutevalue]
    if { $findnode == "" } {
        WarnWinText "Not possible to find $uniqueattribute = $ref_attribbutevalue from $rootnode"
    } else {
        set parentnode [$findnode parentNode]
        if { [info exists $parentnode] } {
            WarnWinText "Not possible to find $uniqueattribute = $ref_attribbutevalue from $rootnode"
        } else {
            $parentnode appendXML $contenttoadd
            set childadded [$parentnode lastChild]
            set prevchild [$childadded previousSibling]
            if { $prevchild != $findnode } {
                set nextfind [$findnode nextSibling]
                $parentnode removeChild $childadded
                $parentnode insertBefore $childadded $nextfind
            }
        }
    }
}

proc CreateWidgetsFromXml::TakeOutUniqueAttribute { uniqueattribute rootnode ref_attribbutevalue } {
    set findnode [$rootnode find $uniqueattribute $ref_attribbutevalue]
    if { $findnode != "" } {
        set parentnode [$findnode parentNode]
        $findnode delete
        while { ![$parentnode hasChildNodes] } {
            set findnode $parentnode
            set parentnode [$findnode parentNode]
            $findnode delete
        }
    } else {
        error "Not possible to take out $uniqueattribute = $ref_attribbutevalue from $rootnode"
    }
}

proc CreateWidgetsFromXml::FindUniqueAttribute {  uniqueattribute rootnode ref_attribbutevalue} {
    #returns a list containing information of {{window name} {groups path} {labelframe path} {label of ref_attribbutevalue} {command to access}}
    #each element (except command) its ready to show to final user, you can show all or just some of theme

    set findnode [$rootnode find $uniqueattribute $ref_attribbutevalue]

    set label ""
    if { $uniqueattribute == "variable" } {
        append label [_ "Modify"]
        append label ": "
    } else {
        # $uniqueattribute == "name"
        append label [_ "Is"]
        append label ": "
    }
    append label [CreateWidgetsFromXml::GetLabelTag $findnode]
    set findnode [$findnode parentNode]

    set labelframe ""
    set group ""
    set window ""
    while { [$findnode nodeName] != "xml_to_tcl"  } {
        switch [$findnode nodeName] {
            window {
                append window [_ "Inside window"]
                append window ": [CreateWidgetsFromXml::GetLabelTag $findnode]"
                set findnode [$findnode parentNode]
            }
            group {
                set currentgroup [$findnode getAttribute name]
                append group [_ "At leave"]
                append group ": "
                set path ""
                while { [$findnode nodeName] == "group" } {
                    set path [linsert $path 0 [CreateWidgetsFromXml::GetLabelTag $findnode]]
                    set findnode [$findnode parentNode]
                }
                append group [join $path "->"]
            }
            default {
                append labelframe [_ "Inside"]
                append labelframe ": "
                set path ""
                while { [$findnode nodeName] != "xml_to_tcl" &&  [$findnode nodeName] != "window" &&  [$findnode nodeName] != "group"} {
                    set path [linsert $path 0 [CreateWidgetsFromXml::GetLabelTag $findnode]]
                    set findnode [$findnode parentNode]
                }
                append labelframe [join $path "->"]
            }
        }
    }
    set command "CreateWidgetsFromXml::IniWin $rootnode $currentgroup"

    return [list $window $group $labelframe $label $command]
}

#----- generic use -----

proc CreateWidgetsFromXml::AddBeforeName { rootnode refname contenttoadd } {
    CreateWidgetsFromXml::AddBeforeUniqueAttribute "name" $rootnode $refname $contenttoadd
}

proc CreateWidgetsFromXml::AddAfterName { rootnode refname contenttoadd } {
    CreateWidgetsFromXml::AddAfterUniqueAttribute "name" $rootnode $refname $contenttoadd
}

proc CreateWidgetsFromXml::AddBeforeVariable { rootnode refvar contenttoadd } {
    CreateWidgetsFromXml::AddBeforeUniqueAttribute "variable" $rootnode $refvar $contenttoadd
}

proc CreateWidgetsFromXml::AddAfterVariable { rootnode refvar contenttoadd } {
    CreateWidgetsFromXml::AddAfterUniqueAttribute "variable" $rootnode $refvar $contenttoadd
}

proc CreateWidgetsFromXml::TakeOutVariable { rootnode refvar } {
    CreateWidgetsFromXml::TakeOutUniqueAttribute "variable" $rootnode $refvar
}

proc CreateWidgetsFromXml::TakeOutName { rootnode refname } {
    CreateWidgetsFromXml::TakeOutUniqueAttribute "name" $rootnode $refname
}

#must do a similar procedure SetState to set the state to normal or disabled (of the frame and all child widgets)
#RecursiveChangeState $f $value
#with value: normal disabled or restore to set again its previous state

proc CreateWidgetsFromXml::SetVisible { refname value {rootnode ""} } {
    if { [catch {
        if { $rootnode == "" } {
            set rootnode [CreateWidgetsFromXml::GetPreferencesXml]
        }
        set findnode [$rootnode find name $refname]
        if { $findnode != "" } {
            $findnode setAttribute visible $value
            if { [$findnode hasAttribute frame] } {
                set f [$findnode getAttribute frame]
                if { $value } {
                    grid $f
                } else {
                    grid remove $f
                }
            } else {

            }
        } else {
            WarnWinText "CreateWidgetsFromXml::SetVisible. Item name $refname not found"
        }
    } msg ] } {
        WarnWinText "Error SetVisible: $msg"
    }
}

proc CreateWidgetsFromXml::SetActivate { refname value {rootnode ""} } {
    if { [catch {
        if { $rootnode == "" } {
            set rootnode [CreateWidgetsFromXml::GetPreferencesXml]
        }
        set findnode [$rootnode find name $refname]
        if { $findnode != "" } {
            $findnode setAttribute activate $value
            if { [$findnode hasAttribute frame] } {
                set f [$findnode getAttribute frame]
                set listitems [list {*}[grid slaves $f] $f]
                if { [$findnode hasAttribute labelwidget] } {
                    set g [$findnode getAttribute labelwidget]
                    set listitems [list {*}[grid slaves $g] $g {*}$listitems]
                    if { $value != 0} {
                        # we must activate the inside activation
                        set pp [$g.combobox cget -textvariable]
                        set [set pp] [$g.combobox current]
                    }
                }
                foreach item $listitems {
                    set classbutton [winfo class $item]
                    if { $classbutton != "Frame" } {
                        if { $classbutton == "Button" || $classbutton == "Tablelist"} {
                            if { $value==0 } {
                                $item configure -state disabled
                            } else {
                                $item configure -state normal
                            }
                        } elseif { $classbutton == "TCombobox" } {
                            if { $value==0 } {
                                # $item configure -state disabled
                                $item state disabled
                            } else {
                                #$item configure -state readonly
                                $item state !disabled
                            }
                        } else {
                            if { $value==0 } {
                                $item state disabled
                            } else {
                                $item state !disabled
                            }
                        }
                    }
                }
            }
        } else {
            WarnWinText "CreateWidgetsFromXml::SetActive. Item name $refname not found"
        }
    } msg ] } {
        WarnWinText "Error SetActivate: $msg"
    }
}

#---- for preference window

proc CreateWidgetsFromXml::EvaluateSwitchConditions { rootnode } {
    set switchnodes [$rootnode getElementsByTagName "switch"]
    foreach switchnode $switchnodes {
        if { [info commands $switchnode] == "" } {
            #nested switchs can fail depending on some match values
            continue
        }
        set parentnode [$switchnode parentNode]
        if { ![$switchnode hasAttribute condition] } {
            error "switch node must have condition attribute"
        }
        set data [$switchnode getAttribute condition]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        set valuecond [$procname {*}$arguments]
        set default_node ""
        set any_case_node_selected 0
        foreach case [$switchnode childNodes] {
            if { [$case nodeName] != "case" || ![$case hasAttribute value] } {
                if { [ $case nodeName] == "default"} {
                    set default_node $case
                } else {
                    error "Only case tags or default tag inside switch with value tag"
                }
            } elseif { [$case getAttribute value] == $valuecond } {
                foreach child [$case childNodes] {
                    $case removeChild $child
                    $parentnode insertBefore $child $switchnode
                    set any_case_node_selected 1
                }
            } else {
                # value of case does not match with result of condition
            }
        }
        # no case selected from the switch block
        # if there is a default node, then add it !
        if { !$any_case_node_selected && ( $default_node != "")} {
            foreach child [$default_node childNodes] {
                $default_node removeChild $child
                $parentnode insertBefore $child $switchnode
            }
        }
        $switchnode delete
    }
}

proc CreateWidgetsFromXml::EvaluateIfCondition { rootnode } {
    set ifnodes [$rootnode getElementsByTagName "if"]
    foreach ifnode $ifnodes {
        if { [info commands $ifnode] == "" } {
            #nested ifs can fail depending on some match values
            continue
        }
        set parentnode [$ifnode parentNode]
        if { ![$ifnode hasAttribute condition] } {
            error "if node must have condition attribute"
        }
        set data [$ifnode getAttribute condition]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        set valuecond [$procname {*}$arguments]
        if { $valuecond} {
            foreach child [$ifnode childNodes] {
                $ifnode removeChild $child
                $parentnode insertBefore $child $ifnode
            }
        }
        $ifnode delete
    }
}


proc CreateWidgetsFromXml::GetPreferencesXml {} {
    return [CreateWidgetsFromXml::GetXml Preferences.xml]
}

proc CreateWidgetsFromXml::SetPreferencesXml { rootnode } {
    CreateWidgetsFromXml::SetXml Preferences.xml $rootnode
}


proc CreateWidgetsFromXml::UpdatePreferencesWindow { } {
    CreateWidgetsFromXml::SetPreferencesXml [CreateWidgetsFromXml::GetPreferencesXml]
}

#---- end modules utilities ------



if { $::printactualvaluesasdefault == "1" } {
    proc CreateWidgetsFromXml::PrintActualValuesAsDefault { name} {
        variable properties
        WarnWinText $name
        set listvarvalue ""
        set pos [string length $name,allvariables,]
        foreach {item varvalue} [array get properties $name,allvariables,*] {
            set varname [string range $item $pos end]
            if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
                set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
                set gidvarname [$nodename getAttribute variable]
                #valor actual set $varname [GetValue $gidvarname $varmanager]
                if { [$nodename hasAttribute whenwritevar] } {
                    set data [$nodename getAttribute whenwritevar]
                    set procname ::xmlprograms::[lindex $data 0]
                    set arguments [lrange $data 1 end]
                    set varvalue [$procname {*}$arguments [list $varvalue]]
                }
                set varmanager ""
                if { [$nodename hasAttribute variablemanager] } {
                    set varmanager [$nodename getAttribute variablemanager]
                }
                #Sometimes you set something on GiD and Gid modify value before to set
                # its diferent what you set that what you get, we want "get values"
                SeValue $gidvarname $varvalue $varmanager
                set varvalue [GetValue $gidvarname $varmanager]
                #must be without process whenreadvar!!

                lappend listvarvalue [list $gidvarname $varvalue]
            }
        }
        set listvarvalue [lsort -ascii -index 0 $listvarvalue]
        foreach item $listvarvalue {
            set text ""
            set varname [lindex $item 0]
            set varvalue [lindex $item 1]
            append text "  if(GIDstrncasecmp(variable,\"$varname\", len_variable)==0)\{\n"
            append text "    strcpy(retvalue,\"$varvalue\");\n"
            append text "    strcat(Match,\"$varname \");\n"
            append text "    NumMatch++;\n"
            append text "  \}"
            WarnWinText $text
        }
    }
}

proc CreateWidgetsFromXml::ReadXml {} {
    #back compatibility
}

proc CreateWidgetsFromXml::ReadXmlFile { xmlfile {groupname ""} {initfunction_on_gid_ini "PreferencesWindow"} \
        { initwindow 1} {hide_groups ""} } {
    variable fileread
    if { ![info exists fileread($xmlfile)] } {
        package require tdom
        if { [file pathtype $xmlfile] != "absolute" } {
            set xmlfile_absolute [file join $::GIDDEFAULTTCL $xmlfile]
        } else {
            set xmlfile_absolute $xmlfile
            set pathlength [string length $::GIDDEFAULTTCL]
            if { ![string compare -length $pathlength $xmlfile $::GIDDEFAULTTCL] } {
                set xmlfile [string replace $xmlfile 0 $pathlength]
                if { [info exists fileread($xmlfile)] } {
                    if { $initwindow } {
                        CreateWidgetsFromXml::IniWin $fileread($xmlfile) $groupname $initfunction_on_gid_ini
                    }
                    return
                }
            }
        }
        if { [file pathtype $xmlfile_absolute] != "absolute" || ![file exists $xmlfile_absolute] } {
            error "file $xmlfile_absolute doesn't exists"
        }
        set xml [tDOM::xmlReadFile $xmlfile_absolute]
        set document [dom parse $xml]
        set root [$document documentElement]

        if { [$root nodeName] != "xml_to_tcl" } {
            $document delete
        }

        set domWindowNode [$root selectNodes window]
        set name [$domWindowNode getAttribute name]

        CreateWidgetsFromXml::ReadPrograms

        set CreateWidgetsFromXml::fileread($xmlfile) $root
        set CreateWidgetsFromXml::fileread($xmlfile,name) $name
        set CreateWidgetsFromXml::fileread($xmlfile,initfunction_on_gid_ini) $initfunction_on_gid_ini

        CreateWidgetsFromXml::EvaluateIfCondition $root
        CreateWidgetsFromXml::EvaluateSwitchConditions $root
        #raise this GiD-Tcl event to allow plugins modify the preferences window
        PluginPreferencesProcs_Eval $root
    }
    if { $initwindow } {
        CreateWidgetsFromXml::IniWin $CreateWidgetsFromXml::fileread($xmlfile) $groupname $initfunction_on_gid_ini $hide_groups
    }
}

proc CreateWidgetsFromXml::ReadPrograms { } {
    #infoexist namespace xmlprograms
    source [file join $::GIDDEFAULTTCL xmlprocs.tcl]
    #set domProgramNode [$root selectNodes programs]
    #namespace eval ::xmlprograms [$domProgramNode text]
}

proc CreateWidgetsFromXml::DestroyWindow {} {
    variable preferences_wid
    if { ( $preferences_wid != "") && [winfo exists $preferences_wid] } {
        destroy $preferences_wid
    }
    set preferences_wid ""
}

proc CreateWidgetsFromXml::GetWindow {} {
    variable preferences_wid
    return $preferences_wid
}

proc CreateWidgetsFromXml::IniWin { root {groupname ""} {initfunction_on_gid_ini "PreferencesWindow"} {hide_groups ""} } {
    variable properties
    variable preferences_wid

    set domWindowNode [$root selectNodes window]
    set name [$domWindowNode getAttribute name]

    set w .gid.$name
    if { [winfo exists $w] } {
        # CreateWidgetsFromXml::DestroyWindow  ;# eventually destroy othre preferences window with another name
        destroy $w
        set preferences_wid ""
        #destroy will destroy variables, be careful, don't put down
        update idletasks
    }

    #do someghing with name to create a namespace or similar!!

    set properties($name,rootnode) $root
    set properties($name,count) 0
    #array containing leaveoftree listofvariables changed
    set properties($name,changedvariables) {}
    #array containing varname currentgidvalue
    set properties($name,allvariables) {}
    set properties($name,listfunctions_tocall) {}


    set geomname PrePostCreateWidgetsFromXml${name}WindowGeom
    if { ![info exists ::GidPriv($geomname)] } {
        set assign_default_size 1
    } else {
        set assign_default_size 0
    }
    ::InitWindow2 $w -title [GetLabelTag $domWindowNode] \
        -geometryvariable $geomname \
        -initcommand $initfunction_on_gid_ini \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set preferences_wid $w

    if { $assign_default_size } {
        set default_size [GetDefaultSizeTag $domWindowNode]
        if { $default_size != "" } {
            #$default_size in the form widthxheight+x+y
            wm geometry $w $default_size
        }
    }


    set SepFrame [ttk::frame $w.sepframe]
    set BottomFrame [ttk::frame $w.bottomframe -style BottomFrame.TFrame]

    set Apply [ttk::button $w.bottomframe.apply -text [_ "Apply"]  -style BottomFrame.TButton]
    #configuration command below
    set Close [ttk::button $w.bottomframe.close -text [_ "Close"] -command CreateWidgetsFromXml::DestroyWindow \
            -style BottomFrame.TButton]


    set dynupdate [$domWindowNode getAttribute dynamicupdate]
    set properties($name,dynamicupdate) 0
    if { $dynupdate == "show_on" || $dynupdate == "show_off" } {
        if { $dynupdate == "show_on" } {
            set properties($name,dynamicupdate) 1
        }
        set cb [ttk::checkbutton $w.bottomframe.checkbutton -variable CreateWidgetsFromXml::properties($name,dynamicupdate) -text [_ "Dynamic update"]: -style BottomFrame.TCheckbutton ]
        #every time user click checkbox we must activate-desactivate apply and we invoke the button to update variables
        set function [list CreateWidgetsFromXml::ActivateDeactivate CreateWidgetsFromXml::properties($name,dynamicupdate) $Apply 0]
        trace add variable properties($name,dynamicupdate) write $function
        #execute 1 time
        eval $function "args_not_used"
        bind $w <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $w CreateWidgetsFromXml::properties($name,dynamicupdate) $function]

        trace add variable CreateWidgetsFromXml::properties($name,dynamicupdate) write [list CreateWidgetsFromXml::ApplyInvoke $Apply]
        bind $w <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $w CreateWidgetsFromXml::properties($name,dynamicupdate) [list CreateWidgetsFromXml::ApplyInvoke $Apply]]

        grid $cb -column 0 -row 0 -sticky w -padx {5 0} -pady 6
        grid $Apply -column 1 -row 0 -sticky e -padx {0 5} -pady 6
        grid $Close -column 2 -row 0 -sticky w -padx 5 -pady 6
        grid columnconfigure $w.bottomframe 0 -weight 0
        grid columnconfigure $w.bottomframe 1 -weight 1 -minsize 80
        grid columnconfigure $w.bottomframe 2 -weight 1 -minsize 80
    } else {
        grid $Apply $Close -sticky {} -padx 5 -pady 6
        grid anchor $w.bottomframe center
    }

    set listchildnodes [$domWindowNode childNodes]
    if { [llength $listchildnodes]==1 } {
        #if all your childs are groups, we forget the parent (usefull when only showing subtree)
        set allchildsgroups 1
        foreach childNode [$listchildnodes childNodes] {
            if { [$childNode nodeName] != "group" } {
                set allchildsgroups 0
                break;
            }
        }
        if { $allchildsgroups==1 } {
            set listchildnodes [$listchildnodes childNodes]
        }
    }
    if { [llength $listchildnodes]==1 } {
        #there is no tree, only 1 leave
        set f [ttk::frame $w.contentf]
        set properties($name,content_frame)  $f
        #grid $::MainL -sticky nsew -column 0 -row 0
        #grid $::ContentL -sticky nsew -column 0 -row 1
        grid $f -sticky nsew -column 0 -row 2
        grid $SepFrame -sticky nsew -column 0 -row 4 -columnspan 2 -pady 1
        grid $BottomFrame -sticky nsew -column 0 -row 5 -columnspan 2
        grid columnconfigure $w 0 -weight 1
        grid rowconfigure $w 2 -weight 1

        $Apply configure -command [list CreateWidgetsFromXml::ApplyChanges "" $name "args_not_used"]
        bind $w <Destroy> [list +CreateWidgetsFromXml::DestroyingCheckChanges %W $w "" $name]
        update idletasks

        CreateWidgetsFromXml::CreateAndVisualizeTreeLeave [lindex $listchildnodes 0] $f "" "" $name
    } else {

        set panedwin [ttk::panedwindow $w.p -orient horizontal]
        set f [ttk::frame $panedwin.contentf]
        set properties($name,content_frame) $f

        package require fulltktree

        # width name justify type is_editable
        set cols {
            { 50 Categories left item 1 }
            { 3 "" right image 1 }
            { 0 domdata left text 0 }
        }
        ttk::frame $panedwin.frame
        set T [fulltktree $panedwin.frame.t -columns $cols -width 180]
        $T configure \
            -selecthandler "CreateWidgetsFromXml::LogData $name select" \
            -selecthandler2 "CreateWidgetsFromXml::LogData $name select" \
            -item_image "" \
            -folder_image "" \
            -arrow_image_expand 0 \
            -showlines 1 -indent 15 -showheader 0

        #set bulkactions [ttk::menubutton $panedwin.frame.menubutton -text [_ "Bulk actions"]... -direction "above" -menu $panedwin.frame.menubutton.m]

        # menu $panedwin.frame.menubutton.m -tearoff 0
        # $panedwin.frame.menubutton.m add command -label [_ "Default values on selection"] -command [list CreateWidgetsFromXml::ContextualDefaultValues $name $T.t]
        # $panedwin.frame.menubutton.m add command -label [_ "Undo changes on selection"] -command [list CreateWidgetsFromXml::ContextualUndoChanges $name $T.t]
        # $panedwin.frame.menubutton.m add checkbutton -label [_ "Also selected children"] -variable ::CreateWidgetsFromXml::AlsoChildren

        #            -button1handler "CreateWidgetsFromXml::LogData $name button1handler"\
        #-button1presshandler "CreateWidgetsFromXml::LogData $name button1presshandler"\
        #-returnhandler "CreateWidgetsFromXml::LogData $name returnhandler"\
        #-contextualhandler "CreateWidgetsFromXml::LogData $name contextualhandler"\
        #-contextualhandler_menu "CreateWidgetsFromXml::LogData $name contextualhandler_menu"\
        #-contextualhandler_fmenu "CreateWidgetsFromXml::LogData $name contextualhandler_fmenu"\
        #-editbeginhandler "CreateWidgetsFromXml::LogData $name editbeginhandler"\
        #-editaccepthandler "CreateWidgetsFromXml::LogData $name editaccepthandler"\
        #-deletehandler "CreateWidgetsFromXml::LogData $name deletehandler"\
        #-draghandler "CreateWidgetsFromXml::LogData $name draghandler"


        $T element create eWindow window
        $T element create eRect rect -fill ""
        #$T element create eText1 text -width 300
        $T element create eText2 text -wrap none

        set S [$T style create s2 -orient vertical]
        $T style elements $S {eText2 eRect eWindow}
        $T style layout $S eRect -union {eText2 eWindow} -ipadx 8 -ipady 8 -padx 4 -pady {0 4}
        $T style layout $S eText2 -pady {0 6} -squeeze x
        $T style layout $S eWindow -iexpand x -squeeze x


        $T notify bind MyTag <Expand-before> {
            %T item image %I 1 [gid_themes::GetImage blank.png small_icons]
            %T item element configure %I 0 e_text_sel -fill ""
            #e_rect e_text_sel e_selmarker_up e_selmarker_down
        }
        $T notify bind MyTag <Collapse-before> {
            %T item image %I 1 [gid_themes::GetImage blank.png small_icons]
            %T item element configure %I 0 e_text_sel -fill ""
            set listchilds [%T item children %I]
            foreach itemid $listchilds {
                if { [%T item image $itemid 1] == [gid_themes::GetImage ArrowLeft.png small_icons] } {
                    %T item image %I 1 [gid_themes::GetImage ArrowLeft.png small_icons]
                    %T item element configure %I 0 e_text_sel -fill {red {focus} red {!focus} red {selected} red {!selected} red {active} red {!active} red {}}
                    break;
                }
            }
        }
        $T dragimage configure -visible 0
        #------------------test cabeceras treectrl------------
        #No headers!!
        #gid_themes::ConfigureHeaders $T
        #-----------------part 1 fin----------------------

        bind $T <Button-$::gid_right_button> "[list CreateWidgetsFromXml::MenuContextual $name %W %x %y] ; break"


        #grid $T -sticky nsew -column 0 -row 0 -rowspan 3
        #grid $::MainL -sticky nsew -column 1 -row 0
        #grid $::ContentL -sticky nsew -column 1 -row 1
        #grid $f -sticky nsew -column 2 -row 2

        grid $panedwin -sticky nsew -column 0 -row 0

        grid $SepFrame -sticky nsew -column 0 -row 1 -pady 1

        # first pane, which would get widgets gridded into it:
        #ttk::labelframe .p.f1 -text Pane1 -width 100 -height 100
        #ttk::labelframe .p.f2 -text Pane2 -width 100 -height 100; # second pane

        grid $T -sticky nsew -column 0 -row 0
        # grid $bulkactions -sticky nsew -column 0 -row 1
        grid columnconfigure $panedwin.frame 0 -weight 1
        grid rowconfigure $panedwin.frame 0 -weight 1

        $panedwin add $panedwin.frame

        $panedwin add $f

        grid $BottomFrame -sticky nsew -column 0 -row 2

        grid columnconfigure $w 0 -weight 1
        grid rowconfigure $w 0 -weight 1
        grid rowconfigure $w 2 -weight 0

        #maximum number of levels 3
        #as we show it expanded group that have groups inside implies no image
        set selection ""
        foreach childNode $listchildnodes {
            if { [lsearch $hide_groups [$childNode getAttribute name]]!=-1} {
                continue
            }
            if { [$childNode nodeName] == "group" } {
                set item [$T insert end [list [GetLabelTag $childNode] [gid_themes::GetImage blank.png small_icons] $childNode] root]
                if { [$childNode getAttribute name] == $groupname  } {
                    set selection $item
                }

                $childNode setAttribute id $childNode
                set numgroupsinitem 0
                foreach childNode_2 [$childNode childNodes] {
                    if {  [$childNode_2 nodeName] == "#comment" } {
                        continue
                    } elseif { [$childNode_2 nodeName] == "group" } {
                        if { [lsearch $hide_groups [$childNode_2 getAttribute name]]!=-1} {
                            continue
                        }
                        incr numgroupsinitem
                        set item_2 [$T insert end [list [GetLabelTag $childNode_2] [gid_themes::GetImage blank.png small_icons] $childNode_2] $item]
                        if { [$childNode_2 getAttribute name] == $groupname  } {
                            set selection $item_2
                        }
                        $childNode_2 setAttribute id $childNode_2
                        set numgroupsinitem_2 0
                        foreach childNode_3 [$childNode_2 childNodes] {
                            if {  [$childNode_3 nodeName] == "#comment" } {
                                continue
                            } elseif { [$childNode_3 nodeName] == "group" } {
                                if { [lsearch $hide_groups [$childNode_3 getAttribute name]]!=-1} {
                                    continue
                                }
                                incr numgroupsinitem_2
                                set item_3 [$T insert end [list [GetLabelTag $childNode_3] [gid_themes::GetImage blank.png small_icons] $childNode_3] $item_2]
                                if { [$childNode_3 getAttribute name] == $groupname  } {
                                    set selection $item_3
                                }
                                $childNode_3 setAttribute id $childNode_3
                            }
                            if { $numgroupsinitem_2 != 0 } {
                                $T item image $item_2 1 [gid_themes::GetImage blank.png small_icons]
                                $T item element configure $item_2 0 e_text_sel -fill ""
                            }
                        }
                    }
                    if { $numgroupsinitem != 0 } {
                        $T item image $item 1 [gid_themes::GetImage blank.png small_icons]
                        $T item element configure $item 0 e_text_sel -fill ""
                    }
                }
            } elseif  { [$childNode nodeName] != "#comment" } {
                #unexpected tag
                error "Unexpected tag, expected group and is [$childNode nodeName]"
            }
        }
        #------------------part 2 test cabeceras treectrl------------
        #  gid_themes::ApplyHeadersConfig $T
        #-----------------fin test----------------------

        #If deleted we can no acces to create the content
        #$document delete
        $Apply configure -command [list CreateWidgetsFromXml::ApplyChanges $T $name "args_not_used"]

        bind $w <Destroy> [list +CreateWidgetsFromXml::DestroyingCheckChanges %W $w $T $name]
        #bind $w <Return>  [list event generate $Apply <<Invoke>>]

        update idletasks

        if { $::printactualvaluesasdefault == "1" } {
            GidUtils::SetWarnLine "Developer variable printactualvaluesasdefault=1 press p to print"
            bind $w <p> [list CreateWidgetsFromXml::PrintActualValuesAsDefault [set name] ]
        }
        if { $selection != "" } {
            CreateWidgetsFromXml::LogData $name select $T.t $selection
        } else {
            set domWindowNode [$root selectNodes selected]

            if { $domWindowNode != "" } {
                set selection [$domWindowNode getAttribute selection]

                CreateWidgetsFromXml::LogData $name select $T.t $selection
            } else {
                CreateWidgetsFromXml::LogData $name select $T.t 1
            }
        }

    }
    focus $w
}

proc CreateWidgetsFromXml::ApplyInvoke { apply_button args } {
    #invoke only works when button its !disabled
    # and we want to force invoke
    set command [$apply_button cget -command]
    eval $command
}


#--------------utilities functions-------------------

proc CreateWidgetsFromXml::CalculateWidthSpinbox { from to increment } {
    set lengthunits 1
    set lengthdecimals 0
    foreach item {from to increment} {
        set list [split [set $item] .]
        switch [llength $list] {
            1 {
                set lengthunits [::tcl::mathfunc::max $lengthunits [string length [lindex $list 0]]]
            }
            2 {
                set lengthunits [::tcl::mathfunc::max $lengthunits [string length [lindex $list 0]]]
                set lengthdecimals [::tcl::mathfunc::max $lengthdecimals [string length [lindex $list 1]]]
            }
        }
    }
    if { $lengthdecimals != 0 } {
        #+1 for the point
        return [expr $lengthunits + $lengthdecimals + 1]
    } else {
        return $lengthunits
    }
}

#return the list of options and values defined in the xml node that are widget options
proc CreateWidgetsFromXml::GetWidgetOptions { node widget } {
    set ignored_options {image label variable} ;#sorted list. ignore because are considered in a special way
    set options [list]
    foreach item [$widget configure] {
        set option [string range [lindex $item 0] 1 end]
        if { [lsearch -sorted -dictionary $ignored_options $option] == -1 } {
            if { [$node hasAttribute $option] } {
                lappend options -$option [$node getAttribute $option]
            }
        }
    }
    return $options
}

proc CreateWidgetsFromXml::GetLabelTag { node } {
    #if no label tag, returns ""
    #also performs translation on label tag
    set text_return ""
    if { [$node hasAttribute label] } {
        set label [$node getAttribute label]
        set label_subst [subst -nocommands -novariables $label]
        set text_return [_ $label_subst]
    } elseif { [$node hasAttribute nottransalatelabel] } {
        set text_return [$node getAttribute nottransalatelabel]
    }
    # performing a wrap length automatic on translated text if its too long
    set max_length 50
    if { [string length $text_return]>$max_length } {
        set text_before $text_return
        set text_return ""
        set line_letters 0
        # we don't cut words, each line will be $max_length+some letters (more robust than $max_length-some letters)
        foreach word [lrange $text_before 0 end-1] {
            set text_return "$text_return$word"
            incr line_letters [string length $word]
            if { $line_letters < $max_length } {
                set text_return "$text_return "
                incr line_letters 1
            } else {
                set text_return "$text_return\n"
                set line_letters 0
            }
        }
        set text_return "$text_return[lindex $text_before end]"
    }
    return $text_return
}

#if no help tag, returns ""
#also performs translation on help tag
proc CreateWidgetsFromXml::GetHelpTag { node } {
    if { [$node hasAttribute help] } {
        set label [$node getAttribute help]
        set label_subst [subst -nocommands -novariables $label]
        return [_ $label_subst]
    } else {
        return ""
    }
}

#if no state tag, returns ""
proc CreateWidgetsFromXml::GetStateTag { node } {
    if { [$node hasAttribute state] } {
        return [subst -nocommands -novariables [$node getAttribute state]]
    } else {
        return ""
    }
}

proc CreateWidgetsFromXml::GetPackingTag { node } {
    if { [$node hasAttribute packing] } {
        return [subst -nocommands -novariables [$node getAttribute packing]]
    } else {
        return ""
    }
}

#if no defaultsize tag, returns ""
proc CreateWidgetsFromXml::GetDefaultSizeTag { node } {
    if { [$node hasAttribute defaultsize] } {
        return [subst -nocommands -novariables [$node getAttribute defaultsize]]
    } else {
        return ""
    }
}

#it can put one or more of this tags: -text -image -compound -style Toolbutton
proc CreateWidgetsFromXml::GetVisualTags { node type_entity} {
    set label [GetLabelTag $node]
    set ret [list]
    if { $label != "" } {
        lappend ret -text $label
    }
    if { [$node hasAttribute image] } {
        lappend ret -image [gid_themes::GetImage [$node getAttribute image] small_icons]
        if { $label != "" } {
            lappend ret -compound left
        }
        #if { $type_entity != "label" && $type_entity != "frame" && $type_entity != "labelframe" && $type_entity != "button" } {
        #    lappend ret -style Toolbutton
        #}
    }
    return $ret
}

proc CreateWidgetsFromXml::Add2PointsOnTextLabel { string } {
    set index [lsearch -exact $string "-text"]
    if { $index != -1 } {
        incr index
        lset string $index [lindex $string $index]:
    }
    return $string
}
#proc CreateWidgetsFromXml::AddEndPointOnTextLabel { string } {
#    set index [lsearch -exact $string "-text"]
#    if { $index != -1 } {
#        incr index
#        lset string $index [lindex $string $index]
#    } else {
#    }
#    return $string
#}


proc CreateWidgetsFromXml::GetValidVariable { name node } {
    variable aux
    if { [$node hasAttribute variable] } {
        return CreateWidgetsFromXml::aux(tmp,$name,$node)
    } else {
        return CreateWidgetsFromXml::aux(local,$name,$node)
    }
}

proc CreateWidgetsFromXml::IsVariableTmp { varname } {
    if { [string range $varname 0 29] == "CreateWidgetsFromXml::aux(tmp," } {
        return 1
    } else {
        return 0
    }
}

proc CreateWidgetsFromXml::GetNodenameFromVariableTmp { varname name } {
    return [string range $varname [string length "CreateWidgetsFromXml::aux(tmp,$name,"] end-1]
}

proc CreateWidgetsFromXml::GetTmpVariableFromVariable { name var } {
    variable properties
    set pos [string length $name,allvariables,]
    foreach {item varvalue} [array get properties $name,allvariables,*] {
        set varname [string range $item $pos end]
        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            set gidvarname [$nodename getAttribute variable]
            if { $var == $gidvarname } {
                return $varname
            }
        }
    }
    return "Variable not found"
}

proc CreateWidgetsFromXml::InitialitateAllVariablesOfChildNode { node name } {
    variable properties
    variable aux
    array set managedvariables {}
    foreach childnode [$node childNodes] {
        set nodeType [$childnode nodeName]
        if { $nodeType == "checkbutton"
            || $nodeType == "checkbuttonframe"
            || $nodeType == "comboboxframe"
            || $nodeType == "radiobuttonframe"
            || $nodeType == "combobox"
            || $nodeType == "entry"
            || $nodeType == "entrywithbutton"
            || $nodeType == "radiobutton"
            || $nodeType == "spinbox"
            || $nodeType == "scale"
            || $nodeType == "tablelist"
            || $nodeType == "colorbutton"
            || $nodeType == "fontselection"} {
            #-------------------------------------------------------------------------------------------------------------------------
            #se lee de gid todas las que en en xml tienen "variable" , las q empiezan por tmp
            set varname [GetValidVariable $name $childnode]
            if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
                set varmanager ""
                if { [$childnode hasAttribute variablemanager] } {
                    set varmanager [$childnode getAttribute variablemanager]
                }
                if { [$childnode hasAttribute whenreadvar] } {
                    set data [$childnode getAttribute whenreadvar]
                    set procname ::xmlprograms::[lindex $data 0]
                    set arguments [lrange $data 1 end]
                    set $varname [$procname {*}$arguments [list [GetValue [$childnode getAttribute variable] $varmanager]]]
                } else {
                    set $varname [GetValue [$childnode getAttribute variable] $varmanager]
                }
            } elseif {[$childnode hasAttribute onwhen] } {
                set $varname 0
                lappend properties($name,listfunctions_tocall) "set $varname \[expr [$childnode getAttribute onwhen]\]"
            } else {
                set $varname 0
            }
            #-------------------------------------------------------------------------------------------------------------------------
            array set managedvariables [list $varname [set $varname]]
        }
        if { [$childnode hasChildNodes] } {
            array set local_managedvariables [InitialitateAllVariablesOfChildNode $childnode $name]
            array set managedvariables [array get local_managedvariables]
        }
    }
    return [array get managedvariables]
}

proc CreateWidgetsFromXml::GetDefaultValues { variables name } {
    variable properties
    foreach {varname varvalue} $variables {
        #-------------------------------------------------------------------------------------------------------------------------
        #se tendria que leer el valor por defecto de GiD=varmanager
        #set x [GetDefaultValue $varname $varmanager]
        #varname = CreateWidgetsFromXml::tmp_[set name]_gidvarname
        #set varname [lindex $varname_varvalue 0]
        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            set gidvarname [$nodename getAttribute variable]
            set varmanager ""
            if { [$nodename hasAttribute variablemanager] } {
                set varmanager [$nodename getAttribute variablemanager]
            }
            if { [$nodename hasAttribute whenreadvar] } {
                set data [$nodename getAttribute whenreadvar]
                set procname ::xmlprograms::[lindex $data 0]
                set arguments [lrange $data 1 end]
                set $varname [$procname {*}$arguments [list [GetDefaultValue $gidvarname $varmanager]]]
            } else {
                set $varname [GetDefaultValue $gidvarname $varmanager]
            }
        }
        #-------------------------------------------------------------------------------------------------------------------------
    }
    foreach item $properties($name,listfunctions_tocall) {
        eval [subst -nocommands $item]
    }
}

proc CreateWidgetsFromXml::GetReferenceValues { variables name } {
    variable properties
    namespace eval CreateWidgetsFromXml {}
    foreach {varname varvalue} $variables {
        #-------------------------------------------------------------------------------------------------------------------------
        #se tendria que leer el valor por defecto de GiD=varmanager
        #set x [GetDefaultValue $varname $varmanager]
        #varname = CreateWidgetsFromXml::tmp_[set name]_gidvarname
        #set varname [lindex $varname_varvalue 0]
        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            set gidvarname [$nodename getAttribute variable]
            set varmanager ""
            if { [$nodename hasAttribute variablemanager] } {
                set varmanager [$nodename getAttribute variablemanager]
            }
            if { [$nodename hasAttribute whenreadvar] } {
                set data [$nodename getAttribute whenreadvar]
                set procname ::xmlprograms::[lindex $data 0]
                set arguments [lrange $data 1 end]
                set ${varname}_referencevariable [$procname {*}$arguments [list [GetDefaultValue $gidvarname $varmanager]]]
            } else {
                set ${varname}_referencevariable [GetDefaultValue $gidvarname $varmanager]
            }
            #to activate trace functions:
            set $varname [set $varname]
        }
        #-------------------------------------------------------------------------------------------------------------------------
    }
    #foreach item $properties($name,listfunctions_tocall) {
    #    eval [subst -nocommands $item]
    #}
}



proc CreateWidgetsFromXml::ApplyChanges { fulltree name args} {
    variable properties
    variable must_save_preferences_on_destroy

    set CommandsToSend ""

    set listofleaves ""
    set needsredraw 0
    set pos [string length $name,changedvariables,]
    set allvariablesexterntogid 1
    foreach {item listvariables} [array get properties $name,changedvariables,*] {
        set leaveid [string range $item $pos end]
        foreach varname $listvariables {
            #-------------------------------------------------------------------------------------------------------------------------
            #send to GiD or to variablemanager
            #-------------------------------------------------------------------------------------------------------------------------
            if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
                set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
                set gidvarname [$nodename getAttribute variable]
                set varmanager ""
                if { [$nodename hasAttribute variablemanager] } {
                    set varmanager [$nodename getAttribute variablemanager]
                } else {
                    set allvariablesexterntogid 0
                }
                if { [$nodename hasAttribute whenwritevar] } {
                    set data [$nodename getAttribute whenwritevar]
                    set procname ::xmlprograms::[lindex $data 0]
                    set arguments [lrange $data 1 end]
                    lappend CommandsToSend [list SetValue $gidvarname [$procname {*}$arguments [list [set $varname]]] $varmanager]
                } else {
                    lappend CommandsToSend [list SetValue $gidvarname [set $varname] $varmanager]
                }
                if { [$nodename hasAttribute needsredraw] } {
                    if { [$nodename getAttribute needsredraw] == "1" } {
                        set needsredraw 1
                    }
                }
            }
            #update values of variables
            set properties($name,allvariables,$varname) [set $varname]
        }
        if { $needsredraw == "1" } {
            lappend CommandsToSend [list GiD_Process MEscape 'Redraw]
        }
        if { $fulltree != "" } {
            $fulltree item image $leaveid 1 [gid_themes::GetImage blank.png small_icons]
            $fulltree item element configure $leaveid 0 e_text_sel -fill ""
            set parentid [$fulltree item parent $leaveid]
            if { ![$fulltree item state get $parentid open] } {
                while { $parentid != "0" } {
                    set listchilds [$fulltree item children $parentid]
                    set change_on_one_child "0"
                    foreach itemid $listchilds {
                        if { [$fulltree item image $itemid 1] == [gid_themes::GetImage ArrowLeft.png small_icons] } {
                            set change_on_one_child "1"
                            break;
                        }
                    }
                    if { $change_on_one_child == "0" } {
                        $fulltree item image $parentid 1 [gid_themes::GetImage blank.png small_icons]
                        $fulltree item element configure $parentid 0 e_text_sel -fill ""
                        set parentid [$fulltree item parent $parentid]
                    } else {
                        break;
                    }
                }
            }
        }
    }
    #be careful variable has traces associated
    array unset properties $name,changedvariables,*

    set WarnLineMsg ""
    if { $properties($name,dynamicupdate) != "1" } {
        set WarnLineMsg [_ "Accepted new preferences"].
    }
    foreach command $CommandsToSend {
        eval $command
    }
    # before it was $name!="gidPreferences"
    #  may be there has been some remaning and this place was missing
    # name is the tDom Window node attribute 'name'
    if { ([llength $CommandsToSend] && $allvariablesexterntogid) || $name!="gid_preferences" } {
        CreateWidgetsFromXml::ChangeAllVariablesValues $name
    }
    if { $name == "gid_preferences" } {
        set must_save_preferences_on_destroy 1
    }
    if { $WarnLineMsg != "" } {
        GidUtils::SetWarnLine $WarnLineMsg
    }
}

proc CreateWidgetsFromXml::DestroyingCheckChanges { W w fulltree name } {
    variable properties
    variable must_save_preferences_on_destroy
    if { $W != $w } return
    set ThereAreChanges 0
    foreach {item listvariables} [array get properties $name,changedvariables,*] {
        foreach varname $listvariables {
            if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
                set ThereAreChanges 1
                break
            }
        }
        if { $ThereAreChanges==1 } {
            break;
        }
    }
    if { $ThereAreChanges==1 } {

        set text [_ "Do you want to save the changes you've made in the preferences' window?"]
        if { ![ winfo exists $w]} {
            set w .gid
        }
        set retval [GID_tk_messageBox -default no -icon question -message $text -type yesno -parent $w]
        if { $retval=="yes" } {
            CreateWidgetsFromXml::ApplyChanges "" $name "args_not_used"
        }
    }
    array unset properties $name,*
    if { $must_save_preferences_on_destroy } {
        set must_save_preferences_on_destroy 0
        # Check if we're allowed, i.e. gid has not been called with gid -c filename.ini
        if { [GiD_Set SaveGidDefaults] } {
            set raise_events 1
            SavePreferences [GiD_GetUserSettingsFilename -create_folders] 0 $raise_events
            GidUtils::SetWarnLine [_ "Preferences file saved"]
        } else {
            GidUtils::SetWarnLine [_ "Using alternative preferences file, which can not be overwritten"]
        }
    }
}

proc SetBoldStyle { item bool } {
    if { $bool == 1 } {
        set actualstyle [$item cget -style]
        if { $actualstyle == "" } {
            set actualstyle [winfo class $item]
        }
        if { [lindex [split $actualstyle .] 0] != "Bold" } {
            ttk::style configure Bold.$actualstyle -font BoldDefault
            $item configure -style Bold.$actualstyle
            if { [winfo class $item] == "TLabel" } {
                $item configure -font BoldDefault
            }
        }
    } else {
        set actualstyle [$item cget -style]
        if { [lindex [split $actualstyle .] 0] == "Bold" } {
            $item configure -style [join [lrange [split $actualstyle .] 1 end] .]
            if { [winfo class $item] == "TLabel" } {
                $item configure -font TkDefaultFont
            }
        }
    }
}



proc CreateWidgetsFromXml::AuxTraceFunc { fulltree leaveid name name1 name2 op } {
    variable properties
    set varname ${name1}($name2)
    #if actual value is different from gid_actual value
    if { [set $varname] != $properties($name,allvariables,$varname) } {
        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set findnode [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            if { $findnode != "" } {
                if { [$findnode hasAttribute frame] } {
                    set f [$findnode getAttribute frame]
                    if { [winfo exists $f.upf] } {
                        #for fontselection it's a Tk::label
                        $f.upf.sample configure -foreground #ff0000
                    } else {
                        if { [winfo exists $f.framewidget] } {
                            #for checkbuttonframe, comboboxframe and radiobuttonframe
                            set f $f.framewidget
                        }

                        foreach item [grid slaves $f] {
                            set classbutton [winfo class $item]
                            if { $classbutton == "TLabel" || $classbutton == "TCheckbutton" || $classbutton == "TRadiobutton"} {
                                $item state invalid
                            }
                        }
                    }
                }
            }
        }


        if { $fulltree != "" } {
            $fulltree item image $leaveid 1 [gid_themes::GetImage ArrowLeft.png small_icons]
            $fulltree item element configure $leaveid 0 e_text_sel -fill {red {focus} red {!focus} red {selected} red {!selected} red {active} red {!active} red {}}
            set itemid [$fulltree item parent $leaveid]
            if { ![$fulltree item state get $itemid open] } {
                while { $itemid } {
                    $fulltree item image $itemid 1 [gid_themes::GetImage ArrowLeft.png small_icons]
                    $fulltree item element configure $itemid 0 e_text_sel -fill {red {focus} red {!focus} red {selected} red {!selected} red {active} red {!active} red {}}
                    set itemid [$fulltree item parent $itemid]
                }
            }
        }

        if { ![info exists properties($name,changedvariables,$leaveid)] || $properties($name,changedvariables,$leaveid) == ""} {
            set properties($name,changedvariables,$leaveid) $varname
        } elseif { [lsearch -exact $properties($name,changedvariables,$leaveid) $varname] == -1 } {
            lappend properties($name,changedvariables,$leaveid) $varname
        }
        #else already inside
    } else {
        #we must extract variable from changed variables if it was

        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set findnode [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            if { $findnode != "" } {
                if { [$findnode hasAttribute frame] } {
                    set f [$findnode getAttribute frame]
                    if { [winfo exists $f.upf] } {
                        #for fontselection it's a Tk::label
                        $f.upf.sample configure -foreground [set ::ttk::theme::[gid_themes::GetTtkTheme]::colors(-colortext_fg)]
                    } else {
                        if { [winfo exists $f.framewidget] } {
                            #for checkbuttonframe, comboboxframe and radiobuttonframe
                            set f $f.framewidget
                        }
                        foreach item [grid slaves $f] {
                            set classbutton [winfo class $item]
                            if { $classbutton == "TLabel" || $classbutton == "TCheckbutton" || $classbutton == "TRadiobutton"} {
                                $item state !invalid
                            }
                        }
                    }
                }
            }
        }

        #if there any variable has changed in this leave
        if { ![info exists properties($name,changedvariables,$leaveid)] || $properties($name,changedvariables,$leaveid) == "" } {
            #it must say already "no changes"
            #$fulltree item text $leaveid 1 "no changes"
        } else {
            set varlist $properties($name,changedvariables,$leaveid)
            set searchresult [lsearch -exact $varlist $varname]
            if { $searchresult == -1} {
                #it must say already "has changes"
                #$fulltree item text $leaveid 1 "has changes"
            } else {
                #takeout variable from list
                set varlist [lreplace $varlist $searchresult $searchresult]
                if { [llength $varlist] == 0 } {
                    unset properties($name,changedvariables,$leaveid)
                    if { $fulltree != "" } {
                        $fulltree item image $leaveid 1 [gid_themes::GetImage blank.png small_icons]
                        $fulltree item element configure $leaveid 0 e_text_sel -fill ""
                        set parentid [$fulltree item parent $leaveid]
                        if { ![$fulltree item state get $parentid open] } {
                            while { $parentid != "0" } {
                                set listchilds [$fulltree item children $parentid]
                                set change_on_one_child "0"
                                foreach itemid $listchilds {
                                    if { [$fulltree item image $itemid 1] == [gid_themes::GetImage ArrowLeft.png small_icons] } {
                                        set change_on_one_child "1"
                                        break;
                                    }
                                }
                                if { $change_on_one_child == "0" } {
                                    $fulltree item image $parentid 1 [gid_themes::GetImage blank.png small_icons]
                                    $fulltree item element configure $parentid 0 e_text_sel -fill ""
                                    set parentid [$fulltree item parent $parentid]
                                } else {
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    set properties($name,changedvariables,$leaveid) $varlist
                    #it must say already "has changes"
                    #$fulltree item text $leaveid 1 "has changes"
                }
            }
        }
    }
    if { [info exists ${varname}_referencevariable] } {
        #compara con el valor inicial de la ventana, esto hace que el bold no se desactive hasta que no se haga un apply (works as visual studio)
        if { [set ${varname}_referencevariable] != $properties($name,allvariables,$varname) } {
            #if { [set ${varname}_referencevariable] != [set $varname] } #compara con el valor actual, esto hace que se active i desactive el bold
            if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
                set findnode [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
                if { $findnode != "" } {
                    if { [$findnode hasAttribute frame] } {
                        set f [$findnode getAttribute frame]
                        if { [winfo exists $f.framewidget] } {
                            #for checkbuttonframe, comboboxframe and radiobuttonframe
                            set f $f.framewidget
                        }
                        foreach item [grid slaves $f] {
                            set classbutton [winfo class $item]
                            if { $classbutton == "TLabel" || $classbutton == "TCheckbutton" || $classbutton == "TRadiobutton"} {
                                SetBoldStyle $item 1
                            }
                        }
                    }
                }
            }
        } else {
            if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
                set findnode [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
                if { $findnode != "" } {
                    if { [$findnode hasAttribute frame] } {
                        set f [$findnode getAttribute frame]
                        if { [winfo exists $f.framewidget] } {
                            #for checkbuttonframe, comboboxframe and radiobuttonframe
                            set f $f.framewidget
                        }
                        foreach item [grid slaves $f] {
                            set classbutton [winfo class $item]
                            if { $classbutton == "TLabel" || $classbutton == "TCheckbutton" || $classbutton == "TRadiobutton"} {
                                SetBoldStyle $item 0
                            }
                        }
                    }
                }
            }
        }
    }
    if { $properties($name,dynamicupdate) == 1 } {
        ApplyChanges $fulltree $name "args_not_used"
    }
}

proc CreateWidgetsFromXml::AuxDestroyTraceFunc { var fulltree leaveid name } {
    trace remove variable $var write [list CreateWidgetsFromXml::AuxTraceFunc $fulltree $leaveid $name]
}

proc CreateWidgetsFromXml::CreateTracesAssociatedToALeave { f variables fulltree leaveid name } {
    #variables is an array
    foreach var $variables {
        trace add variable $var write [list CreateWidgetsFromXml::AuxTraceFunc $fulltree $leaveid $name]
        bind $f <Destroy> [list +CreateWidgetsFromXml::AuxDestroyTraceFunc $var $fulltree $leaveid $name]
    }
}

proc CreateWidgetsFromXml::ActivateDeactivate { var list onvalue args } {
    variable properties
    if { [lsearch $onvalue [set $var]] != -1 } {
        foreach item $list {
            if { ![winfo exists $item] } {
                WarnWinText "CreateWidgetsFromXml::ActivateDeactivate. $item not exists"
            } else {
                set classbutton [winfo class $item]
                if { ( $classbutton != "Frame") && ( $classbutton != "Label") } {
                    if { $classbutton == "Button"} {
                        $item configure -state normal
                    } elseif { $classbutton == "TCombobox" } {
                        #$item configure -state readonly
                        $item state !disabled
                    } else {
                        $item state !disabled
                    }
                }
            }
        }
    } else {
        foreach item $list {
            if { ![winfo exists $item] } {
                WarnWinText "CreateWidgetsFromXml::ActivateDeactivate. $item not exists"
            } else {
                set classbutton [winfo class $item]
                if { ( $classbutton != "Frame") && ( $classbutton != "Label") } {
                    if { $classbutton == "Button"} {
                        $item configure -state disabled
                    } elseif { $classbutton == "TCombobox" } {
                        # $item configure -state disabled
                        $item state disabled
                    } else {
                        $item state disabled
                    }
                }
            }
        }
    }
}
proc CreateWidgetsFromXml::ActivateDeactivateCombobox { root var listvalues listnames listsetactivate args } {
    if { [catch {
        variable properties
        set numvalue [lsearch $listvalues [set $var]]
        if { $numvalue != -1 } {
            set setactivateforthisvaluevar [lindex $listsetactivate $numvalue]
            # we must firt desactivate all
            foreach name $listnames {
                if { [lsearch $setactivateforthisvaluevar $name]!=-1 } {

                } else {
                    CreateWidgetsFromXml::SetActivate $name 0 $root
                }
            }
            # and then activate, some activation can activate also some of previous desactivate
            foreach name $listnames {
                if { [lsearch $setactivateforthisvaluevar $name]!=-1 } {
                    CreateWidgetsFromXml::SetActivate $name 1 $root
                } else {

                }
            }
        }
    } msg ] } {
        WarnWinText "Error ActivateDeactivateCombobox: $msg"
    }
}


proc CreateWidgetsFromXml::DestroyTraceArray { W w var function} {
    if { $W != $w } return
    trace remove variable $var array $function
}

proc CreateWidgetsFromXml::DestroyTraceVar { W w var function} {
    if { $W != $w } return
    trace remove variable $var write $function
}

proc CreateWidgetsFromXml::ValidateCommand { P V W validatefunction varname name} {
    variable properties

    set procname ::xmlprograms::[lindex $validatefunction 0]
    set arguments [lrange $validatefunction 1 end]

    switch $V {
        "key" {
            #precaucion puede ser 1 tecla o 1 texto introducido con ctrl+v
            if { [eval [list $procname {*}$arguments $P]] } {
                $W state !invalid
            } else {
                $W state invalid
            }
        }
        "focusout" - "forced" {
            if { [eval [list $procname {*}$arguments $P]] } {
                $W state !invalid
            } else {
                set $varname $properties($name,allvariables,$varname)
                #without after idle it remains red...
                after idle [list $W state !invalid]
            }
        }
        default {
        }
    }
    return true
}

proc ApplyGidHelpToNoneHelpWidgets { listwidgets text } {
    foreach widget $listwidgets {
        if { ![HasGidHelp $widget] } {
            GidHelp $widget $text
        }
    }
}

#--------------end:utilities functions-------------------
#--------------widget functions-------------------
proc CreateWidgetsFromXml::ReadInsideLabelFrame { node lf name} {
    set listcreated ""
    foreach childnode [$node childNodes] {
        set nodeType [$childnode nodeName]
        if { $nodeType == "checkbutton" } {
            lappend listcreated {*}[CreateCheckbutton $childnode $lf $name]
        } elseif { $nodeType == "checkbuttonframe" } {
            lappend listcreated {*}[CreateCheckbuttonFrame $childnode $lf $name]
        } elseif { $nodeType == "comboboxframe" } {
            lappend listcreated {*}[CreateComboboxFrame $childnode $lf $name]
        } elseif { $nodeType == "radiobuttonframe" } {
            lappend listcreated {*}[CreateRadiobuttonFrame $childnode $lf $name]
        } elseif { $nodeType == "combobox" } {
            lappend listcreated {*}[CreateCombobox $childnode $lf $name]
        } elseif { $nodeType == "entry" } {
            lappend listcreated {*}[CreateEntry $childnode $lf $name]
        } elseif { $nodeType == "entrywithbutton" } {
            lappend listcreated {*}[CreateEntryWithButton $childnode $lf $name]
        } elseif { $nodeType == "radiobutton" } {
            lappend listcreated {*}[CreateRadiobutton $childnode $lf $name]
        } elseif { $nodeType == "spinbox" } {
            lappend listcreated {*}[CreateSpinbox $childnode $lf $name]
        } elseif { $nodeType == "label" } {
            lappend listcreated {*}[CreateLabel $childnode $lf $name]
        } elseif { $nodeType == "button" } {
            lappend listcreated {*}[CreateButton $childnode $lf $name]
        } elseif { $nodeType == "scale" } {
            lappend listcreated {*}[CreateScale $childnode $lf $name]
        } elseif { $nodeType == "tablelist" } {
            lappend listcreated {*}[CreateTableList $childnode $lf $name]
        } elseif { $nodeType == "colorbutton" } {
            lappend listcreated {*}[CreateColorButton $childnode $lf $name]
        } elseif { $nodeType == "fontselection" } {
            lappend listcreated {*}[CreateFontSelection $childnode $lf $name]
        } elseif { $nodeType == "tcldraw" } {
            lappend listcreated {*}[CreateTclDraw $childnode $lf $name]
        } elseif { $nodeType == "labelframe" } {
            lappend listcreated {*}[CreateLabelFrame $childnode $lf $name]
        } elseif { $nodeType == "option" } {
            #its a option of comboboxframe don't do anything
        } elseif { $nodeType == "checkbuttonentry" } {
            lappend listcreated {*}[CreateEntry $childnode $lf $name]
            W "preference.xml comment, better use: entry with offvalue instate of checkbuttonentry"
        } elseif { $nodeType == "checkbuttonentrywithbutton" } {
            lappend listcreated {*}[CreateEntryWithButton $childnode $lf $name]
            W "preference.xml comment, better use: entrywithbutton with offvalue instate of checkbuttonentrywithbutton"
        } elseif {  $nodeType != "#comment" } {
            #unexpected tag
            WarnWinText "Unexpected tag, expected checkbutton,combobox,entry, label, ... and is $nodeType"
        }
    }
    return $listcreated
}

proc CreateWidgetsFromXml::IsOnBackUp { args } {
    WarnWinText $args
}

proc CreateWidgetsFromXml::CreateCheckbutton { node lf name} {
    variable properties
    variable aux
    #as item can have childs we must create a frame to work as a unique widget
    set f [ttk::frame $lf.$properties($name,count)]
    set varname [GetValidVariable $name $node]
    #set cb [ttk::checkbutton $f.checkbutton -variable $varname {*}[AddEndPointOnTextLabel [GetVisualTags $node checkbutton]]]
    set cb [ttk::checkbutton $f.checkbutton -variable $varname {*}[GetVisualTags $node checkbutton]]

    if { [$node hasAttribute offvalue] } {
        if { [$cb cget -onvalue] == [$node getAttribute offvalue] } {
            $cb configure -onvalue [$cb cget -offvalue]
        }
        $cb configure -offvalue [$node getAttribute offvalue]
    }
    if { [$node hasAttribute onvalue] } {
        if { [$cb cget -offvalue] == [$node getAttribute onvalue] } {
            $cb configure -offvalue [$cb cget -onvalue]
        }
        $cb configure -onvalue [$node getAttribute onvalue]
    }


    if { [$node hasAttribute associatedto] } {
        set varnameassociated CreateWidgetsFromXml::tmp_[set name]_[$node getAttribute associatedto]
        set onwhen [$node getAttribute onwhen]
        lappend properties($name,listfunctions_tocall) \
            [list $lf.$properties($name,count).colorbutton configure -background [ getButtonBackgroundColor [ set $varname]]]
        #trace add variable $varnameassociated write $onwhen
        #bind $w <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $w $varnameassociated $onwhen]
        lappend properties($name,listfunctions_tocall)l [list $cb configure \
            -background [ getButtonBackgroundColor [ set $varname]]]
    }

    set listcreated [list $f $cb]
    #it could have childs that only will be activate if checkbutton it's on
    if { [$node hasChildNodes] } {
        #add 2 points to label
        $cb configure {*}[Add2PointsOnTextLabel [GetVisualTags $node checkbutton]]
        #end
        set child_f [ttk::frame $f.frame]
        lappend listcreated $child_f
        set f_listcreated [ReadInsideLabelFrame $node $child_f $name]

        grid $cb $child_f -sticky we
        grid columnconfigure $f 0 -weight 0
        grid columnconfigure $f 1 -weight 1
        if { $f_listcreated != "" } {
            #usually the grid is vertical, so that its done by default
            #but in this case we want a horizontal grid

            #we use grid slaves because only want 1st level childs

            foreach item [grid slaves $child_f] {
                array set info [grid info $item]
                grid configure $item -row $info(-column) -column $info(-row)
            }
            grid columnconfigure $child_f 0 -weight 1
            for { set i 1} { $i < [ llength [grid slaves $child_f]]} { incr i} {
                grid columnconfigure $child_f $i -weight 0
            }


            lappend listcreated {*}$f_listcreated

            set function [list CreateWidgetsFromXml::ActivateDeactivate $varname $f_listcreated [$cb cget -onvalue]]
            trace add variable $varname write $function
            #execute 1 time
            eval $function "args_not_used"

            bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]
        }

    } else {
        grid $cb -sticky w
    }
    incr properties($name,count)

    grid $f -sticky we
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    # add help GidHelp
    ApplyGidHelpToNoneHelpWidgets $listcreated [GetHelpTag $node]
    return $listcreated
}

proc CreateWidgetsFromXml::TakeOutFocus { widget args } {
    $widget state !focus
}

proc CreateWidgetsFromXml::CreateCheckbuttonFrame { node lf name} {
    variable properties
    variable aux
    #as item can have childs we must create a frame to work as a unique widget
    set f [ttk::labelframe $lf.$properties($name,count)]

    set framewidget [ttk::frame $f.framewidget]
    set lb [ttk::label $framewidget.label -style TLabelframe.Label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
    set varname [GetValidVariable $name $node]
    set cb [ttk::checkbutton $framewidget.checkbutton -variable $varname]
    grid $lb $cb
    $f configure -labelwidget $framewidget

    set function [list CreateWidgetsFromXml::TakeOutFocus $framewidget.checkbutton]
    trace add variable $varname write $function
    bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]

    set listcreated [list $f $framewidget $lb $cb]

    #it have childs that only will be activate if checkbutton it's on
    if { [$node hasChildNodes] } {
        set f_listcreated [ReadInsideLabelFrame $node $f $name]
        if { $f_listcreated != "" } {
            lappend listcreated {*}$f_listcreated
            set onvalue 1
            if { [$node hasAttribute offvalue] } {
                if { [$cb cget -onvalue] == [$node getAttribute offvalue] } {
                    $cb configure -onvalue [$cb cget -offvalue]
                }
                $cb configure -offvalue [$node getAttribute offvalue]
            }
            if { [$node hasAttribute onvalue] } {
                if { [$cb cget -offvalue] == [$node getAttribute onvalue] } {
                    $cb configure -offvalue [$cb cget -onvalue]
                }
                $cb configure -onvalue [$node getAttribute onvalue]
            }
            set onvalue [$cb cget -onvalue]

            set function [list CreateWidgetsFromXml::ActivateDeactivate $varname $f_listcreated $onvalue]
            trace add variable $varname write $function
            #execute 1 time
            eval $function "args_not_used"

            bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]
        }


    } else {
        WarnWinText "error checkbuttonframe without childs"
    }
    incr properties($name,count)


    grid $f -sticky ew
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 0 -weight 1

    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    $node setAttribute labelwidget $framewidget ;#e.g. to allow change visibility of the label
    # add help GidHelp
    ApplyGidHelpToNoneHelpWidgets $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}


proc CreateWidgetsFromXml::CreateComboboxFrame { node lf name} {
    if { [catch {
        variable properties
        variable aux
        #as item can have childs we must create a frame to work as a unique widget
        set f [ttk::labelframe $lf.$properties($name,count)]

        set framewidget [ttk::frame $f.framewidget]
        set lb [ttk::label $framewidget.label -style TLabelframe.Label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
        set varname [GetValidVariable $name $node]

        #---
        set listvalues ""
        set listlabels ""
        set listsetactivate ""
        set listnames ""
        #---
        set firstchildnode [lindex [$node childNodes] 0]
        if { [$firstchildnode nodeName] == "option" && [$firstchildnode hasAttribute fillfunction]} {
            set data [$firstchildnode getAttribute fillfunction]
            set procname ::xmlprograms::[lindex $data 0]
            set arguments [lrange $data 1 end]
            set lists [$procname {*}$arguments]
            set listvalues [lindex $lists 0]
            set listlabels [lindex $lists 1]
            set listsetactivate [lindex $list 2]
        } else {
            foreach childnode [$node childNodes] {
                if { [$childnode nodeName] == "option" } {
                    lappend listvalues [$childnode getAttribute value]
                    lappend listlabels [GetLabelTag $childnode]
                    if {[$childnode hasAttribute setactivate]} {
                        lappend listsetactivate [$childnode getAttribute setactivate]
                    } else {
                        lappend listsetactivate {}
                    }
                } elseif  { [$childnode nodeName] != "#comment" } {
                    #register all names
                    if { ![$childnode hasAttribute name] } {
                        WarnWinText "Error: Inside comboboxframe, widget [$childnode nodeName] without name"
                    } else {
                        lappend listnames [$childnode getAttribute name]
                        set listofchildstocheck [$childnode childNodes]
                        while { [llength $listofchildstocheck]!=0  } {
                            set childchildnode [lindex $listofchildstocheck 0]
                            set listofchildstocheck [lreplace $listofchildstocheck 0 0]
                            if { [$childchildnode nodeName]=="labelframe" || [$childchildnode nodeName]=="checkbuttonframe" || [$childchildnode nodeName]=="comboboxframe" } {
                                lappend listofchildstocheck [$childchildnode childNodes]
                            }
                            if { [$childchildnode nodeName] != "option" && [$childchildnode nodeName] != "#comment" } {
                                if { ![$childchildnode hasAttribute name] } {
                                    WarnWinText "Error: Inside comboboxframe, widget [$childchildnode nodeName] without name"
                                } else {
                                    lappend listnames [$childchildnode getAttribute name]
                                }

                            }
                        }
                    }
                }
            }
        }
        set cbstate [ GetStateTag $node]
        if { $cbstate == ""} {
            set cbstate readonly
        }

        set maxlength [expr {2+[CalculateMaxLength $listlabels]}]
        set varname [GetValidVariable $name $node]
        set cb [TTKComboBox $framewidget.combobox -labels $listlabels -values $listvalues \
            -width $maxlength -textvariable $varname -state $cbstate]

        grid $lb $cb
        $f configure -labelwidget $framewidget


        set function [list CreateWidgetsFromXml::TakeOutFocus $framewidget.combobox]
        trace add variable $varname write $function
        bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]

        set listcreated [list $f $framewidget $lb $cb]

        #it have childs that only will be activate with some options
        if { [$node hasChildNodes] } {
            set f_listcreated [ReadInsideLabelFrame $node $f $name]


            if { $f_listcreated != "" } {
                lappend listcreated {*}$f_listcreated
                set function [list CreateWidgetsFromXml::ActivateDeactivateCombobox $node $varname $listvalues $listnames $listsetactivate]
                trace add variable $varname write $function
                #execute 1 time
                eval $function "args_not_used"

                bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]
            }
        } else {
            WarnWinText "error comboboxframe without childs"
        }
        incr properties($name,count)

        grid $f -sticky ew
        grid columnconfigure $f 0 -weight 1
        grid rowconfigure $f 0 -weight 1

        if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
            grid remove $f
        }
        $node setAttribute frame $f ;#e.g. to allow change visibility
        $node setAttribute labelwidget $framewidget ;#e.g. to allow change visibility of the label
        # add help GidHelp
        ApplyGidHelpToNoneHelpWidgets $listcreated [GetHelpTag $node]
        #return created widgets
    } msg ] } {
        WarnWinText "Error CreateComboboxFrame: $msg"
    }
    return $listcreated
}

proc CreateWidgetsFromXml::ValidateCombobox { validatefunction varname varname_prev name1 name2 op } {
    set value [ set $varname]

    set procname ::xmlprograms::[lindex $validatefunction 0]
    set arguments [lrange $validatefunction 1 end]

    if { [eval [list $procname {*}$arguments $value]] || ( $value == "")} {
        # save last valid value
        if { $value != ""} {
            set $varname_prev $value
        }
    } else {
        # restore last valid value
        if { [ info exists $varname_prev]} {
            set $varname [set $varname_prev]
        }
    }
}

proc CreateWidgetsFromXml::CreateCombobox { node lf name } {
    variable properties
    variable aux
    #as item don't accept label we must create a frame to work as a unique widget
    set f [ttk::frame $lf.$properties($name,count)]
    set l [ttk::label $f.label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]

    set listvalues ""
    set listlabels ""
    set firstchildnode [lindex [$node childNodes] 0]
    if { [$firstchildnode nodeName] == "option" && [$firstchildnode hasAttribute fillfunction]} {
        set data [$firstchildnode getAttribute fillfunction]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        set lists [$procname {*}$arguments]
        set listvalues [lindex $lists 0]
        set listlabels [lindex $lists 1]
    } else {
        foreach childnode [$node childNodes] {
            if { [$childnode nodeName] == "option" } {
                lappend listvalues [$childnode getAttribute value]
                lappend listlabels [GetLabelTag $childnode]
            } elseif {  [$childnode nodeName] != "#comment" } {
                #unexpected tag
                WarnWinText "Unexpected tag, expected option and is [$childnode nodeName]"
            }
        }
    }
    set cbstate [ GetStateTag $node]
    if { $cbstate == ""} {
        set cbstate readonly
    }

    set maxlength [expr {2+[CalculateMaxLength $listlabels]}]
    set varname [GetValidVariable $name $node]
    set cbox [TTKComboBox $f.cbox -labels $listlabels -values $listvalues \
        -width $maxlength -textvariable $varname -state $cbstate]

    if { [ $node hasAttribute validation] } {
        set validatefunction [$node getAttribute validation]
        set varname_prev [GetValidVariable ${name}_prev $node]
        set function [list CreateWidgetsFromXml::ValidateCombobox $validatefunction $varname $varname_prev]
        trace add variable $varname write $function
        bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]
    }

    incr properties($name,count)
    grid $l $cbox -sticky we
    grid columnconfigure $f 0 -weight 0
    grid columnconfigure $f 1 -weight 1
    grid $f -sticky we
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    set listcreated [list $f $l $cbox]
    GidHelp $listcreated [GetHelpTag $node]
    return $listcreated
}

proc CreateWidgetsFromXml::OffValueWidget { checkbutton widget } {
    if { [set [$checkbutton cget -variable]] == [$checkbutton cget -onvalue] } {
        set [$widget cget -textvariable] [$checkbutton cget -onvalue]
    } else {
        set [$widget cget -textvariable] [$checkbutton cget -offvalue]
    }
}

proc CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton { checkbutton name1 name2 op } {
    set varname ${name1}($name2)
    if { [set $varname] == [$checkbutton cget -offvalue] } {
        #disabled only when variable == offvalue
        set [$checkbutton cget -variable] [$checkbutton cget -offvalue]
    } else {
        set [$checkbutton cget -variable] [$checkbutton cget -onvalue]
    }
}

proc CreateWidgetsFromXml::CreateEntry { node lf name} {
    variable properties
    variable aux
    #as item don't accept label we must create a frame to work as a unique widget
    set f [ttk::frame $lf.$properties($name,count)]

    set varname [GetValidVariable $name $node]
    set e [ttk::entry $f.entry -textvariable $varname]
    if { [$node hasAttribute width] } {
        $e configure -width [$node getAttribute width]
    }
    if { [ $node hasAttribute validation] } {
        set validatefunction [$node getAttribute validation]
        $e configure -validate all -validatecommand [list CreateWidgetsFromXml::ValidateCommand %P %V %W $validatefunction $varname $name]
    }
    if { [$node hasAttribute offvalue] } {
        set ch_varname "[string range $varname 0 end-1],ch)"
        #save in the checkbutton the "offvalue" as offvalue and "ondefaultvalue" as onvalue
        set ch [ttk::checkbutton $f.ch {*}[Add2PointsOnTextLabel [GetVisualTags $node label]] \
            -variable $ch_varname \
            -offvalue [$node getAttribute offvalue] -onvalue [$node getAttribute ondefaultvalue]]


        $ch configure -command [list CreateWidgetsFromXml::OffValueWidget $ch $e]

        set [$ch cget -variable] [$ch cget -onvalue]
        if { [set $varname] == [$ch cget -offvalue] } {
            set [$ch cget -variable] [$ch cget -offvalue]
        }
        trace add variable $varname write [list CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton $ch]
        bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname [list CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton $ch]]
    } else {
        set l [ttk::label $f.label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
    }


    incr properties($name,count)

    if { [$node hasAttribute offvalue] } {
        grid $ch $e -sticky we
        set listcreated [list $f $ch $e]
    } else {
        grid $l $e -sticky we
        set listcreated [list $f $l $e]
    }
    grid $f -sticky we
    grid columnconfigure $f 0 -weight 0
    grid columnconfigure $f 1 -weight 1
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

proc CreateWidgetsFromXml::CreateEntryWithButton { node lf name} {
    variable properties
    variable aux
    #as item don't accept label we must create a frame to work as a unique widget
    set f [ttk::frame $lf.$properties($name,count)]

    set varname [GetValidVariable $name $node]
    set e [ttk::entry $f.entry -textvariable $varname]
    if { [$node hasAttribute width] } {
        $e configure -width [$node getAttribute width]
    }
    if { [ $node hasAttribute validation] } {
        set validatefunction [$node getAttribute validation]
        $e configure -validate all -validatecommand [list CreateWidgetsFromXml::ValidateCommand %P %V %W $validatefunction $varname $name]
    }
    if { [$node hasAttribute offvalue] } {
        set ch_varname "[string range $varname 0 end-1],ch)"
        #save in the checkbutton the "offvalue" as offvalue and "ondefaultvalue" as onvalue
        set ch [ttk::checkbutton $f.ch {*}[Add2PointsOnTextLabel [GetVisualTags $node label]] \
            -variable $ch_varname \
            -offvalue [$node getAttribute offvalue] -onvalue [$node getAttribute ondefaultvalue]]

        $ch configure -command [list CreateWidgetsFromXml::OffValueWidget $ch $e]

        set [$ch cget -variable] [$ch cget -onvalue]
        if { [set $varname] == [$ch cget -offvalue] } {
            set [$ch cget -variable] [$ch cget -offvalue]
        }
        trace add variable $varname write [list CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton $ch]
        bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname [list CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton $ch]]
    } else {
        set l [ttk::label $f.label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
    }
    if { [$node hasAttribute buttonfunction] } {
        set data [$node getAttribute buttonfunction]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        #-------- copy of GetLabelTag with: buttonlabel buttonnottransalatelabel
        set text_return ""
        if { [$node hasAttribute buttonlabel] } {
            set label [$node getAttribute buttonlabel]
            set label_subst [subst -nocommands -novariables $label]
            set text_return [_ $label_subst]
        } elseif { [$node hasAttribute buttonnottransalatelabel] } {
            set text_return [$node getAttribute buttonnottransalatelabel]
        }
        # performing a wrap length automatic on translated text if its too long
        set max_length 50
        if { [string length $text_return]>$max_length } {
            set text_before $text_return
            set text_return ""
            set line_letters 0
            # we don't cut words, each line will be $max_length+some letters (more robust than $max_length-some letters)
            foreach word [lrange $text_before 0 end-1] {
                set text_return "$text_return$word"
                incr line_letters [string length $word]
                if { $line_letters < $max_length } {
                    set text_return "$text_return "
                    incr line_letters 1
                } else {
                    set text_return "$text_return\n"
                    set line_letters 0
                }
            }
            set text_return "$text_return[lindex $text_before end]"
        }
        #here copy of GetVisualTag with buttonimage
        set label $text_return
        set ret [list]
        if { $label != "" } {
            lappend ret -text $label
        }
        if { [$node hasAttribute buttonimage] } {
            lappend ret -image [gid_themes::GetImage [$node getAttribute buttonimage] small_icons]
            if { $label != "" } {
                lappend ret -compound left
            }
        }
        #-----------
        set b [ttk::button $f.button {*}$ret -command [list $procname {*}$arguments $lf $varname]]
    } else {
        WarnWinText "buttonfunction needed in entrywithbutton"
    }

    incr properties($name,count)
    if { [$node hasAttribute offvalue] } {
        grid $ch $e $b -sticky we
        set listcreated [list $f $ch $e $b]

        set function [list CreateWidgetsFromXml::ActivateDeactivate $ch_varname [list $e $b] [$node getAttribute ondefaultvalue]]
        trace add variable $ch_varname write $function
        #execute 1 time
        eval $function "args_not_used"

        bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $ch_varname $function]
    } else {
        grid $l $e $b -sticky we
        set listcreated [list $f $l $e $b]
    }


    grid $f -sticky we
    grid columnconfigure $f 1 -weight 1
    $node setAttribute frame $f ;#e.g. to allow change visibility
    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

proc CreateWidgetsFromXml::CreateRadiobuttonFrame { node lf name } {
    #the function is the same as radiobutton with an extra parameter
    return [CreateRadiobutton $node $lf $name 1]
}

proc CreateWidgetsFromXml::CreateRadiobutton { node lf name {converttolabelframe 0} } {
    variable properties
    variable aux
    set listcreated ""
    if { $converttolabelframe==1 } {
        set f [ttk::labelframe $lf.$properties($name,count) {*}[GetVisualTags $node labelframe]]
        lappend listcreated $f
    } else {
        set f [ttk::frame $lf.$properties($name,count)]
        set l [ttk::label $f.label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
        grid $l -sticky w
        lappend listcreated $f $l
    }
    incr properties($name,count)

    set numradiobutton 0
    set subwidgets 0
    array set rb {}
    set varname [GetValidVariable $name $node]

    foreach childnode [$node childNodes] {
        if { [$childnode nodeName] == "option" } {
            set rb($numradiobutton) [ttk::radiobutton $f.$numradiobutton \
                -value [$childnode getAttribute value] {*}[GetVisualTags $childnode radiobutton] \
                -variable $varname]
            if { [$childnode hasChildNodes] } {
                set subwidgets 1
                #add 2 points to label
                $f.$numradiobutton configure {*}[Add2PointsOnTextLabel [GetVisualTags $childnode radiobutton]]
                #end
                set child_f [ttk::frame $f.frame$numradiobutton]
                lappend listcreated $child_f
                set f_listcreated [ReadInsideLabelFrame $childnode $child_f $name]

                grid $rb($numradiobutton) $child_f -row [expr $numradiobutton+1] -sticky we
                grid columnconfigure $f 0 -weight 0
                grid columnconfigure $f 1 -weight 1
                if { $f_listcreated != "" } {
                    #usually the grid is vertical, so that its done by default
                    #but in this case we want a horizontal grid

                    #we use grid slaves because only want 1st level childs

                    foreach item [grid slaves $child_f] {
                        array set info [grid info $item]
                        grid configure $item -row $info(-column) -column $info(-row)
                    }
                    grid columnconfigure $child_f 0 -weight 1
                    for { set i 1} { $i < [ llength [grid slaves $child_f]]} { incr i} {
                        grid columnconfigure $child_f $i -weight 0
                    }

                    lappend listcreated {*}$f_listcreated

                    set function [list CreateWidgetsFromXml::ActivateDeactivate $varname $f_listcreated [$childnode getAttribute value]]
                    trace add variable $varname write $function
                    #execute 1 time
                    eval $function "args_not_used"

                    bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]
                }
            } else {
                grid $rb($numradiobutton) -row 0 -column [expr $numradiobutton+1] -sticky w
            }
            lappend listcreated $rb($numradiobutton)
            set numradiobutton [expr $numradiobutton+1]
        } elseif { [$childnode nodeName] != "#comment" } {
            #unexpected tag
            WarnWinText "Unexpected tag, expected option and is [$childnode nodeName]"
        }
    }
    if { $subwidgets == 1 } {
        for { set i 0 } { $i<$numradiobutton} { incr i } {
            grid configure $rb($i) -row [expr $i+1] -column 0
        }
    }
    grid $f -sticky ew
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

proc CreateWidgetsFromXml::CreateSpinbox { node lf name} {
    variable properties
    variable aux
    #as item don't accept label we must create a frame to work as a unique widget
    set f [ttk::frame $lf.$properties($name,count)]
    set varname [GetValidVariable $name $node]

    set from [$node getAttribute from]
    if { [ info command $from] != ""} {
        set from [ eval $from]
    }
    set to [$node getAttribute to]
    if { [ info command $to] != ""} {
        set to [ eval $to]
    }
    set increment [$node getAttribute increment]
    if { [ info command $increment] != ""} {
        set increment [ eval $increment]
    }
    set maxlength [expr {1+[CalculateWidthSpinbox $from $to $increment]}]
    set sp [ttk::spinbox $f.spinbox -textvariable $varname -from $from -to $to -increment $increment -width $maxlength]
    if { [ $node hasAttribute validation] } {
        set validatefunction [$node getAttribute validation]
        $sp configure -validate all -validatecommand [list CreateWidgetsFromXml::ValidateCommand %P %V %W $validatefunction $varname $name]
    }


    #---
    if { [$node hasAttribute offvalue] } {
        set ch_varname "[string range $varname 0 end-1],ch)"
        #save in the checkbutton the "offvalue" as offvalue and "ondefaultvalue" as onvalue
        set ch [ttk::checkbutton $f.ch {*}[Add2PointsOnTextLabel [GetVisualTags $node label]] \
            -variable $ch_varname \
            -offvalue [$node getAttribute offvalue] -onvalue [$node getAttribute ondefaultvalue]]


        $ch configure -command [list CreateWidgetsFromXml::OffValueWidget $ch $sp]

        set [$ch cget -variable] [$ch cget -onvalue]
        if { [set $varname] == [$ch cget -offvalue] } {
            set [$ch cget -variable] [$ch cget -offvalue]
        }
        trace add variable $varname write [list CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton $ch]
        bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname [list CreateWidgetsFromXml::OffValueWidgetAutoCheckbutton $ch]]
    } else {
        set l [ttk::label $f.label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
    }
    #---
    #set l [ttk::label $f.label {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]


    incr properties($name,count)

    if { [$node hasAttribute offvalue] } {
        grid $ch $sp -sticky we
        set listcreated [list $f $ch $sp]
    } else {
        grid $l $sp -sticky we
        set listcreated [list $f $l $sp]
    }
    #set listcreated [list $f $l $sp]
    #grid $l $sp -sticky we
    grid columnconfigure $f 0 -weight 0
    grid columnconfigure $f 1 -weight 1
    grid $f -sticky we
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility

    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

proc CreateWidgetsFromXml::CreateLabel { node lf name} {
    variable properties
    set l [ttk::label $lf.$properties($name,count) {*}[Add2PointsOnTextLabel [GetVisualTags $node label]]]
    incr properties($name,count)
    grid $l -sticky w
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $l
    }
    $node setAttribute frame $l ;#e.g. to allow change visibility
    GidHelp $l [GetHelpTag $node]
    #return created widgets
    return $l
}

proc CreateWidgetsFromXml::CreateButton { node lf name} {
    variable properties
    if { [$node hasAttribute buttonfunction] } {
        set data [$node getAttribute buttonfunction]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        set b [ttk::button $lf.$properties($name,count) -command [list $procname {*}$arguments $lf ] {*}[GetVisualTags $node button]]
    } else {
        WarnWinText "buttonfunction needed in button"
    }
    incr properties($name,count)
    grid $b -sticky w
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $b
    }
    $node setAttribute frame $b ;#e.g. to allow change visibility
    GidHelp $b [GetHelpTag $node]
    #return created widgets
    return $b
}

proc CreateWidgetsFromXml::CreateScale { node lf name} {
    variable properties
    variable aux
    set f [ttk::frame $lf.$properties($name,count)]
    grid $f -sticky we

    set scaletext [GetVisualTags $node label]
    set numcolumns 0
    set listcreated $f
    if { $scaletext!= "" } {
        set l [ttk::label $f.label {*}[Add2PointsOnTextLabel $scaletext]]
        grid $l -column $numcolumns -row 0 -sticky we
        incr numcolumns
        lappend listcreated $l
    }
    set varname [GetValidVariable $name $node]

    set childnodes [$node childNodes]
    if { [llength $childnodes] == 1} {
        if  { [$childnodes nodeName] == "entry" } {
            if { [$childnodes hasAttribute state] && [$childnodes getAttribute state]=="readonly" } {
                set e [ttk::label $f.entry -textvariable $varname]
                if { [$childnodes hasAttribute width] } {
                    $e configure -width [$childnodes getAttribute width]
                }
                grid $e -column $numcolumns -row 0 -sticky we
            } else {
                set validatefunction [$childnodes getAttribute validation]
                set e [ttk::entry $f.entry -textvariable $varname -validate all \
                    -validatecommand [list CreateWidgetsFromXml::ValidateCommand %P %V %W $validatefunction $varname $name]]
                foreach attribute {width state} {
                    if { [$childnodes hasAttribute $attribute] } {
                        $e configure -$attribute [$childnodes getAttribute $attribute]
                    }
                }
            }
            grid $e -column $numcolumns -row 0 -sticky we
            incr numcolumns
            lappend listcreated $e
        } else {
            #unexpected tag
            WarnWinText "Unexpected tag, expected only 1 entry and is [$childnodes nodeName]"

        }
    }

    set sc [gidscale $f.scale -from [$node getAttribute from] \
        -to [$node getAttribute to] -orient horizontal -resolution [$node getAttribute resolution] \
        -showvalue [$node getAttribute showvalue] -showbuttons [$node getAttribute showbuttons] \
        -variable $varname]

    incr properties($name,count)

    grid $sc -column $numcolumns  -row 0 -sticky we
    grid columnconfigure $f $numcolumns -weight 1
    incr numcolumns
    lappend listcreated $sc


    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

#dark trick syncronizing with an auxiliary variables to not use use directly $varname as -listvariable for tablelist
proc CreateWidgetsFromXml::SetLinkedVariable { auxiliary_varname varname name1 name2 op } {
    if { [set $varname] != [set $auxiliary_varname] } {
        #without the if will be an infinite closed loop set a -> set b -> set a ...
        set $varname [set $auxiliary_varname]
    }
}

proc CreateWidgetsFromXml::CreateTableList { node lf name} {
    package require tablelist_tile
    variable properties
    variable aux
    #as item don't accept label we must create a frame to work as a unique widget
    set f [ttk::frame $lf.$properties($name,count)]

    set varname [GetValidVariable $name $node]
    #not use directly $varname as -listvariable because tablelist to dark tricks
    #like upvar #0 $data(-listvariable) var (and maybe change other traces?)
    #then CreateWidgetsFromXml::AuxTraceFunc fail because it uses this name
    set auxiliary_varname "CreateWidgetsFromXml::aux(tmp,$name,$node,auxiliary)"
    if {[info exists $varname]} {
        set $auxiliary_varname [set $varname]
    }

    #MUST try first a remove operation to delete this trace if previously was set to avoid repeated traces!!
    trace add variable $auxiliary_varname write [list CreateWidgetsFromXml::SetLinkedVariable $auxiliary_varname $varname]
    trace add variable $varname write [list CreateWidgetsFromXml::SetLinkedVariable $varname $auxiliary_varname]

    set tl [tablelist::tablelist $f.tablelist -listvariable $auxiliary_varname]
    set options [CreateWidgetsFromXml::GetWidgetOptions $node $tl]
    if { [llength $options] } {
        $tl configure {*}$options
    }
    foreach childnode [$node childNodes] {
        set valid_commands {cellconfigure columnconfigure rowconfigure} ;#sorted list
        set command [$childnode nodeName]
        if { [lsearch -sorted -dictionary $valid_commands $command] == -1 } {
            W "Unexpected tag [$childnode nodeName], expected $valid_commands"
        } else {
            if { [$childnode hasAttribute index] } {
                set index [$childnode getAttribute index]
            } else {
                set index -1
            }
            if { $index < 0 } {
                W "$command require an attribute 'index' of the column"
            } else {
                set ignored_options {index} ;#sorted list. ignore because are considered in a special way
                set options [list]
                foreach item [$tl $command $index] {
                    set option [string range [lindex $item 0] 1 end]
                    if { [lsearch -sorted -dictionary $ignored_options $option] == -1 } {
                        if { [$childnode hasAttribute $option] } {
                            lappend options -$option [$childnode getAttribute $option]
                        }
                    }
                }
                if { [llength $options] } {
                    $tl $command $index {*}$options
                }
            }
        }
    }

    incr properties($name,count)

    grid $tl -sticky we
    grid columnconfigure $f 0 -weight 1
    grid $f -sticky we
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    set listcreated [list $f $tl]
    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

proc CreateWidgetsFromXml::getButtonBackgroundColor { color} {
    set bg_color $color
    if  { [string index $color 0] == "#" } {
        set length [string length $color]
        if { $length == 9 } {
            #maybe is a gid trick, with an extra alpha value with syntax #RRGGBBAA, allow it
            set bg_color [ string range $color 0 6]
        }
    }
    return $bg_color
}

proc CreateWidgetsFromXml::selectEntityColor { place var } {
    set color [set $var]
    if { ![GidUtils::IsValidTkColor $color] } {
        W "color $color not valid, set to black #000000"
        set color #000000
    }
    set retcol [GIDChooseColor $place.selectcolor -title [_ "Select color"] -color $color]
    # Set preference
    if { $retcol != "" } {
        set  $var $retcol
        # may be color is #rrggbbaa so
        set but_color $retcol
        if { [ string length $but_color] > 7} {
            set but_color [ string range $but_color 0 6]
        }
        $place configure -background [ getButtonBackgroundColor $but_color]
        set res 1
    } else {
        set res 0
    }
    return $res
}

proc CreateWidgetsFromXml::CreateColorButton { node lf name} {
    variable properties
    variable aux

    set f [ttk::frame $lf.$properties($name,count)]
    #set l [ttk::label $f.label {*}[AddEndPointOnTextLabel [GetVisualTags $node label]]]
    set l [ttk::label $f.label {*}[GetVisualTags $node label]]
    set varname [GetValidVariable $name $node]
    set color [set $varname]
    if { ![GidUtils::IsValidTkColor $color] } {
        W "color $color not valid, set to black #000000"
        set color #000000
    }
    if { $::tcl_platform(os) != "Darwin"} {
        set b [tk::button $f.colorbutton -image [gid_themes::GetImage blank.png small_icons] \
            -width 20 -height 8 -background [ getButtonBackgroundColor $color] \
            -command [list CreateWidgetsFromXml::selectEntityColor $f.colorbutton $varname]]
    } else {
        set b [LabelButton $f.colorbutton -width 3 -borderwidth 1 -background [ getButtonBackgroundColor $color] \
            -command [ list CreateWidgetsFromXml::selectEntityColor $f.colorbutton $varname]]
    }

    lappend properties($name,listfunctions_tocall) \
        [list $f.colorbutton configure -background [ getButtonBackgroundColor [ set $varname]]]
    incr properties($name,count)
    grid $b $l -sticky w -pady 1 -padx {2 0}
    grid $f -sticky w
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    set listcreated [list $f $l $b]
    GidHelp $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}
proc CreateWidgetsFromXml::ShowChooseFontTrace { node name samplewidget name1 name2 op} {
    CreateWidgetsFromXml::ShowChooseFont $node $name $samplewidget
}

proc CreateWidgetsFromXml::ShowChooseFont { node name samplewidget {recalculatetype 0} } {

    variable aux
    set varname [GetValidVariable $name $node]
    set $varname [list [set ::$node.font] [set ::$node.type] [set ::$node.size]]
    if { [string is integer -strict [set ::$node.size] ]} {
        set valid_size [set ::$node.size]
    } elseif { [string is integer -strict [lindex [$samplewidget cget -font] 1]]} {
        set valid_size [lindex [$samplewidget cget -font] 1]
    } else {
        set valid_size 14
    }


    if { $recalculatetype } {
        set lst_ttf_fonts [ GiD_PGF_Fonts get]
        set types [ list ]
        set searching_font [set ::$node.font]
        # fixed width fonts have the suffix " (Fixed width)" that we need to remove
        regsub { \(Fixed width\)} $searching_font {} searching_font
        foreach ifont $lst_ttf_fonts {
            if { [lindex [ lindex $ifont 2] 0] == $searching_font} {
                lappend types [lindex [ lindex $ifont 2] 1]
            }
        }
        if { $types == "" } {
            # Misleading type_face and provoques Error in Preferences Window and in GiD as it doesn't exists !!!
            # set types {Regular}
            WarnWinText [_ "Couldn't find any type_faces (italic, regular, etc.) for font '%s'. \nTry Utilities-->Preferences-->Fonts \n and click on 'Rebuild font list'." $searching_font]
            set types {-- not found --}
        }
        set maxlength [expr {2+[CalculateMaxLength $types]}]
        [set ::$node.typewidget] configure -labels $types -width $maxlength
        if { [lsearch -exact $types [set ::$node.type]]==-1 } {
            [set ::$node.typewidget] current 0
            set $varname [list [set ::$node.font] [set ::$node.type] [set ::$node.size]]
        }
    }

    set result [list [set ::$node.font] $valid_size]
    if { [set ::$node.type] != "Regular" } {
        set typefont [set ::$node.type]
        set addons ""
        set boldindex [lsearch $typefont Bold]
        if { $boldindex != -1 } {
            lappend addons "bold"
            set typefont [lreplace $typefont $boldindex $boldindex]
        }
        set italicindex [lsearch $typefont Italic]
        if { $italicindex != -1 } {
            lappend addons "italic"
            set typefont [lreplace $typefont $italicindex $italicindex]
        }
        if { $typefont != "" } {
            set index [lsearch $typefont Regular]
            set typefont [lreplace $typefont $index $index]
            set result [list [list [set ::$node.font] $typefont] $valid_size $addons]
        } else {
            lappend result $addons
        }
    }

    $samplewidget config -font $result

    #set $varname [list $result]

    #Exemple 'PGF(DefaultFont)'=({C:\Windows\Fonts\cour.ttf} 0 14 {{Courier New} {Regular} {Fixed width}})
    #set $varname [list {} 0 [set ::$node.size] [list [set ::$node.font] $name {}]]
}

proc CreateWidgetsFromXml::FromGiDVarFontToThreeCombo { var node args } {
    if { [info exists $var] } {
        #each parameter its an index
        set ::$node.font [lindex [set $var] 0]
        set ::$node.type [lindex [set $var] 1]
        set ::$node.size [lindex [set $var] 2]
    }
}
proc CreateWidgetsFromXml::CreateFontSelection { node lf name} {
    variable properties
    variable aux
    # GiD give 'PGF(DefaultFont)'=({C:\Windows\Fonts\cour.ttf} 0 14 {{Courier New} {Regular} {Fixed width}})
    # On preprocess variable its transform to:
    # Input format {{Courier New} {Regular} 14}
    set varname [GetValidVariable $name $node]

    set function "CreateWidgetsFromXml::FromGiDVarFontToThreeCombo $varname $node"
    trace add variable $varname write $function
    #execute 1 time
    eval $function "args_not_used"

    bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf $varname $function]

    # Output format {{Courier New} {Regular} 14}
    #'On postrocess variable its transform to: {C:\Windows\Fonts\cour.ttf} 0 14 (that its GiD input)

    set f [ttk::frame $lf.$properties($name,count)]
    set upf [ttk::frame $f.upf]
    set downf [ttk::frame $f.downf]

    set samplewidget [tk::label $upf.sample {*}[GetVisualTags $node label] -anchor center]

    set firstchildnode [lindex [$node childNodes] 0]
    if { [$firstchildnode nodeName] == "option" && [$firstchildnode hasAttribute fillfunction]} {
        set data [$firstchildnode getAttribute fillfunction]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        set lists [$procname {*}$arguments]
        set listvalues [lindex $lists 0]
        set listlabels [lindex $lists 1]
    } else {
        foreach childnode [$node childNodes] {
            if { [$childnode nodeName] == "option" } {
                lappend listvalues [$childnode getAttribute value]
                lappend listlabels [GetLabelTag $childnode]
            } elseif { [$childnode nodeName] != "#comment" } {
                #unexpected tag
                WarnWinText "Unexpected tag, expected option and is [$childnode nodeName]"
            }
        }
    }
    set maxlength [expr {2+[CalculateMaxLength $listlabels]}]

    set cbfonts [TTKComboBox $downf.cbfonts -labels $listlabels -values $listvalues \
        -width $maxlength -textvariable ::$node.font -state readonly]

    #set sizes {6 7 8 9 10 11 12 14 16 18 20 22 24 26 28 36 48 72}
    #  -labels $sizes
    #  -textvariable  ::$node.size
    #  -width 2
    #  -state readonly

    set cbsizes [ttk::spinbox $downf.cbsizes \
        -textvariable ::$node.size \
        -from 6 -to 72 -increment 1 -width 3 \
        -validate all \
        -validatecommand [list CreateWidgetsFromXml::ValidateCommand %P %V %W IsNotEmpty ::$node.size $name]]

    # not evaluated on variable write -command [list CreateWidgetsFromXml::ShowChooseFont $node $name $samplewidget]
    trace add variable ::$node.size write [list CreateWidgetsFromXml::ShowChooseFontTrace $node $name $samplewidget]
    bind $lf <Destroy> [list +CreateWidgetsFromXml::DestroyTraceVar %W $lf ::$node.size [list CreateWidgetsFromXml::ShowChooseFontTrace $node $name $samplewidget]]

    set maxlength 7
    set cbtype [TTKComboBox $downf.cbtype -labels "" -textvariable ::$node.type -width $maxlength -state readonly]
    set ::$node.typewidget $cbtype

    CreateWidgetsFromXml::ShowChooseFont $node $name $samplewidget 1
    bind $cbfonts <<ComboboxSelected>> [list CreateWidgetsFromXml::ShowChooseFont $node $name $samplewidget 1]
    bind $cbtype <<ComboboxSelected>> [list CreateWidgetsFromXml::ShowChooseFont $node $name $samplewidget]

    incr properties($name,count)
    grid $samplewidget -column 0 -row 0 -sticky wens -padx {10 10} -pady {0 0}
    grid columnconfigure $upf 0 -weight 1
    grid rowconfigure $upf 0 -minsize 40 -weight 1
    grid propagate $upf 0
    grid $cbfonts $cbtype $cbsizes -sticky we
    grid columnconfigure $downf 0 -weight 1
    grid $upf -sticky wens
    grid $downf -sticky we
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 0 -minsize 40 -weight 1
    grid $f -sticky we
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility

    set listcreated [list $f $upf $downf $cbfonts $cbtype $cbsizes $samplewidget]
    GidHelp $listcreated [GetHelpTag $node]
    return $listcreated
}

proc CreateWidgetsFromXml::AuxTclDrawTrace {a b c d args} {
    $a $b $c {*}[subst $d]
}

proc CreateWidgetsFromXml::CreateTclDraw { node lf name} {
    variable properties
    set f [ttk::frame $lf.$properties($name,count)]
    set data [$node getAttribute function]
    set procname ::xmlprograms::[lindex $data 0]
    set arguments [lrange $data 1 end]
    $procname {*}$arguments $f $f
    if { [$node hasAttribute updatefunction] } {
        set listtoevaluate ""
        set listvariables ""
        foreach var [$node getAttribute updatevariables] {
            #add trace to the variable
            set var [GetTmpVariableFromVariable $name $var]
            lappend listtoevaluate "$$var"
            lappend listvariables $var
        }
        set data [$node getAttribute updatefunction]
        set procname ::xmlprograms::[lindex $data 0]
        set arguments [lrange $data 1 end]
        $procname {*}$arguments $f $f {*}[subst $listtoevaluate]
        foreach var $listvariables {
            trace add variable $var write [list CreateWidgetsFromXml::AuxTclDrawTrace $procname {*}$arguments $f $f $listtoevaluate]
            bind $lf <Destroy> [list +CreateWidgetsFromXml::AuxTclDrawTrace $procname {*}$arguments $f $f $listtoevaluate]
        }
    }

    incr properties($name,count)

    grid $f -sticky w
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    return $f
}

proc CreateWidgetsFromXml::CreateLabelFrame { node lf name} {
    variable properties
    #as item can have childs we must create a frame to work as a unique widget
    set f [ttk::labelframe $lf.$properties($name,count) {*}[GetVisualTags $node labelframe]]
    set listcreated $f

    #it have childs that only will be activate if checkbutton it's on
    if { [$node hasChildNodes] } {
        set f_listcreated [ReadInsideLabelFrame $node $f $name]
        if { $f_listcreated != "" } {
            lappend listcreated {*}$f_listcreated
        }
    } else {
        WarnWinText "error labelframe without childs"
    }
    incr properties($name,count)

    # How to pack the widgets inside the LabelFrame:
    set pack_orientation [ GetPackingTag $node]
    # by default it's vertical
    if { [ string tolower $pack_orientation] == "horizontal"} {
        set list_childs [ winfo children $f]
        # grids each frame of listcreated size by side
        foreach child $list_childs {
            grid forget $child
        }
        set idx_col 0
        foreach child $list_childs {
            grid $child -row 0 -column $idx_col -in $f
            grid columnconfigure $f $idx_col -weight 1
            incr idx_col
        }
    }

    grid $f -sticky ew
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 0 -weight 1
    if { [$node hasAttribute visible] && ![$node getAttribute visible] } {
        grid remove $f
    }
    $node setAttribute frame $f ;#e.g. to allow change visibility
    # add help GidHelp
    ApplyGidHelpToNoneHelpWidgets $listcreated [GetHelpTag $node]
    #return created widgets
    return $listcreated
}

#--------------end:widget functions-------------------
#utils
# proc CreateWidgetsFromXml::ShowAndSelectWidget { name } {
#     variable properties
#     set pos [string length $name,allvariables,]
#     foreach {item varvalue} [array get properties $name,allvariables,*] {
#         set varname [string range $item $pos end]
#         if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
#             set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
#             set xmlalias [$nodename getAttribute variable]
#         }
#     }
# }

#proc CreateWidgetsFromXml::Rebuild {} {
# redoo tcldraw or update combobox list
#}

proc CreateWidgetsFromXml::ChangeAllVariablesValues { {name "gid_preferences"} } {
    variable properties
    set pos [string length $name,allvariables,]
    foreach {item varvalue} [array get properties $name,allvariables,*] {
        set varname [string range $item $pos end]
        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            set gidvarname [$nodename getAttribute variable]
            set uservalue [set $varname]
            set varmanager ""
            if { [$nodename hasAttribute variablemanager] } {
                set varmanager [$nodename getAttribute variablemanager]
            }
            set value [GetValue $gidvarname $varmanager]

            if { [$nodename hasAttribute whenreadvar] } {
                set data [$nodename getAttribute whenreadvar]
                set procname ::xmlprograms::[lindex $data 0]
                set arguments [lrange $data 1 end]
                set inputvalue [$procname {*}$arguments [list $value]]
            } else {
                set inputvalue $value
            }
            #varvalue its the value read from GiD when open the window (reference value to calculate it have changes)
            #uservalue its the user decision, if uservalue!=varvalue the there are changes without apply
            #inputvalue its the actual value of GiD (input value of this function)
            if { $varvalue != $uservalue } {
                #there are user changes
                set properties($name,allvariables,$varname) $inputvalue
                #its needed to recalculate if there are changes
                set $varname [set $varname]
            } else {
                set properties($name,allvariables,$varname) $inputvalue
                set $varname $inputvalue
            }

        }
    }

}

proc CreateWidgetsFromXml::ChangeVariableValue { {name "gid_preferences"} {var 0} {value 0} } {
    variable properties
    set pos [string length $name,allvariables,]
    foreach {item varvalue} [array get properties $name,allvariables,*] {
        set varname [string range $item $pos end]
        if { [CreateWidgetsFromXml::IsVariableTmp $varname] } {
            set nodename [CreateWidgetsFromXml::GetNodenameFromVariableTmp $varname $name]
            set gidvarname [$nodename getAttribute variable]
            if { $gidvarname == $var } {
                #variable found
                set uservalue [set $varname]
                if { [$nodename hasAttribute whenreadvar] } {
                    set data [$nodename getAttribute whenreadvar]
                    set procname ::xmlprograms::[lindex $data 0]
                    set arguments [lrange $data 1 end]
                    set inputvalue [$procname {*}$arguments [list $value]]
                } else {
                    set inputvalue $value
                }
                #varvalue its the value read from GiD when open the window (reference value to calculate it have changes)
                #uservalue its the user decision, if uservalue!=varvalue the there are changes without apply
                #inputvalue its the actual value of GiD (input value of this function)
                if { $varvalue != $uservalue } {
                    #there are user changes
                    set properties($name,allvariables,$varname) $inputvalue
                    #its needed to recalculate if there are changes
                    set $varname [set $varname]
                } else {
                    set properties($name,allvariables,$varname) $inputvalue
                    set $varname $inputvalue
                }
                return
            }
        }
    }
}


proc CreateWidgetsFromXml::CreateAndVisualizeTreeLeave { node w fulltree leaveid name} {
    variable properties
    variable aux
    set properties($name,current_group) [$node getAttribute name]

    #set f [ttk::frame $w.[$node getAttribute name]]
    
    set listslaves [grid slaves $w]
    if { $listslaves != "" } {
        grid forget $listslaves
    }
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    if { [winfo exists $w.[$node getAttribute name]] } {
        grid $w.[$node getAttribute name] -sticky news
    } else {
        set l [ttk::label $w.l_[$node getAttribute name] -text [_ "Loading"]...]
        grid $l -sticky news
        update idletasks

        #set f [frame $w.[$node getAttribute name] -bg blue]
        set c [ CreateScrolledCanvas $w.[$node getAttribute name]]
        $w.[$node getAttribute name] configure -relief flat
        set f [ ttk::frame $c.f]

        #grid $f -sticky news

        array set managedvariables [InitialitateAllVariablesOfChildNode $node $name]

        foreach item $properties($name,listfunctions_tocall) {
            eval [subst $item]
        }

        foreach {item value} [array get managedvariables] {
            set properties($name,allvariables,$item) $value
        }

        foreach childnode [$node childNodes] {
            if { [$childnode nodeName] != "group" } {
                if { [$childnode nodeName] == "labelframe" } {
                    CreateWidgetsFromXml::CreateLabelFrame $childnode $f $name
                } elseif { [$childnode nodeName] == "checkbuttonframe" } {
                    CreateWidgetsFromXml::CreateCheckbuttonFrame $childnode $f $name
                } elseif { [$childnode nodeName] == "comboboxframe" } {
                    CreateWidgetsFromXml::CreateComboboxFrame $childnode $f $name
                } elseif { [$childnode nodeName] == "radiobuttonframe" } {
                    CreateWidgetsFromXml::CreateRadioButtonFrame $childnode $f $name
                } elseif { [$childnode nodeName] != "#comment" } {
                    #unexpected tag
                    WarnWinText "Unexpected tag, expected labelframe and is [$childnode nodeName]"
                }
                if { [$childnode nodeName] != "#comment" } {
                    grid configure [$childnode getAttribute frame] -padx {0 0}
                }
            }
        }

        set defaultvalues [ttk::button $f.setdefaultvalues -text [_ "Default values"] \
            -command [list CreateWidgetsFromXml::GetDefaultValues [array get managedvariables] $name ]]

        set referencevalues [ttk::button $f.setreferencevalues -text [_ "Reference values"] \
            -command [list CreateWidgetsFromXml::GetReferenceValues [array get managedvariables] $name ]]

        if { $fulltree != "" } {
            CreateTracesAssociatedToALeave $f [array names managedvariables] $fulltree $leaveid $name
        }

        grid $defaultvalues -sticky s
        #grid $referencevalues -sticky s

        #NO - Test activate to gid developers see the result:
        #$referencevalues invoke
        #End Test

        grid columnconfigure $f 0 -weight 1
        grid rowconfigure $f [expr [lindex [grid size $f] 1] -1] -weight 1
        AddToScrolledCanvas $w.[$node getAttribute name] $f
        grid forget $l
        grid $w.[$node getAttribute name] -sticky news
    }
}

proc CreateWidgetsFromXml::ContextualDefaultValues { name T } {
    variable properties
    #execute w.[$node getAttribute name].f.setdefaultvalues

    set tree $T

    set listids [CreateWidgetsFromXml::GetChildrenToApply $T]

    foreach id $listids {

        set item [$tree item id $id]
        set mb [$tree item text $id]
        set domchild [lindex $mb 2]
        #$::ContentL configure -text "Namebytree:[lindex $mb 0], name tag xml:[$domchild getAttribute name]"
        set root [$domchild root]

        CreateWidgetsFromXml::CreateAndVisualizeTreeLeave $domchild $properties($name,content_frame) [winfo parent $tree] $id $name
        $properties($name,content_frame).[$domchild getAttribute name].c.f.setdefaultvalues invoke

    }
}
proc CreateWidgetsFromXml::ContextualReferenceValues { name T } {
    variable properties
    
    set tree $T
    foreach id $listids {

        set item [$tree item id $id]
        set mb [$tree item text $id]
        set domchild [lindex $mb 2]
        #$::ContentL configure -text "Namebytree:[lindex $mb 0], name tag xml:[$domchild getAttribute name]"
        set root [$domchild root]


        while { [[winfo parent $tree] is_folder $id] } {
            set id [expr $id+1]
            set item [$tree item id $id]
            set mb [$tree item text $id]
            set domchild [lindex $mb 2]
        }

        CreateWidgetsFromXml::CreateAndVisualizeTreeLeave $domchild $properties($name,content_frame) [winfo parent $tree] $id $name
        $properties($name,content_frame).[$domchild getAttribute name].c.f.setreferencevalues invoke

    }
}
proc CreateWidgetsFromXml::GetChildrenToApply { T } {
    set tree $T
    set listids [$tree selection get]
    set workingids ""
    if { $::CreateWidgetsFromXml::AlsoChildren } {
        set thereisfolder 1
        while { $thereisfolder } {
            set thereisfolder 0
            foreach id $listids {
                if { [[winfo parent $tree] is_folder $id] } {
                    set thereisfolder 1
                    lappend workingids {*}[$tree item children $id]
                } else {
                    lappend workingids $id
                }
            }
            set listids $workingids
            set workingids ""
        }
        set workingids $listids
    } else {
        foreach id $listids {
            while { [[winfo parent $tree] is_folder $id] } {
                set id [expr $id+1]
            }
            lappend workingids $id
        }
    }
    set workingids [lsort -increasing -unique $workingids]
    return $workingids
}

proc CreateWidgetsFromXml::ContextualUndoChanges { name T } {
    variable properties
    set workingids [CreateWidgetsFromXml::GetChildrenToApply $T]

    set pos [string length $name,changedvariables,]
    foreach {item listvariables} [array get properties $name,changedvariables,*] {
        set leaveid [string range $item $pos end]
        if { [lsearch $workingids $leaveid] != -1 } {
            foreach varname $listvariables {
                set $varname $properties($name,allvariables,$varname)
            }
        }
    }
}


proc CreateWidgetsFromXml::MenuContextual { name T x y } {
    set w $T.menucontextual
    if { [winfo exists $w] } {
        destroy $w
    }

    menu $w

    $w add command -label [_ "Default values on selection"] -command [list CreateWidgetsFromXml::ContextualDefaultValues $name $T]
    $w add command -label [_ "Undo changes on selection"] -command [list CreateWidgetsFromXml::ContextualUndoChanges $name $T]
    $w add checkbutton -label [_ "Also selection children"] -variable ::CreateWidgetsFromXml::AlsoChildren
    #$w add command -label [_ "Mark with bold diferences with default on selection"] -command [list CreateWidgetsFromXml::ContextualReferenceValues $name $T]


    set x [expr [winfo rootx $T]+$x+2]
    set y [expr [winfo rooty $T]+$y]
    GiD_PopupMenu $w $x $y
}

proc CreateWidgetsFromXml::LogData { name args } {
    variable properties
    #$::MainL configure -text "logdata: $args"
    if { [lindex $args 0] == "select" } {
        set tree [lindex $args 1]
        set id [lindex $args 2]
        if { $id == "" } {
            return
        } elseif { [llength $id] > 1 } {
            set item ""
            set sortids [lsort -integer $id]
            for {set index 0} {$item == "" && $index < [llength $sortids]} {incr index } {
                set id [lindex $sortids $index]
                set item [$tree item id $id]
            }
        } else {
            set item [$tree item id $id]
        }
        if { $item == "" } {
            return
        }
        #$tree selection clear
        $tree selection modify $id {}

        #$tree activate $id

        set mb [$tree item text $id]
        set domchild [lindex $mb 2]
        #$::ContentL configure -text "Namebytree:[lindex $mb 0], name tag xml:[$domchild getAttribute name]"
        set root [$domchild root]
        #set rootnext [$root parentNode]
        #while { $rootnext != "" } {
        #  set root $rootnext
        #  set rootnext [$root parentNode]
        #}


        while { [[winfo parent $tree] is_folder $id] } {
            set id [expr $id+1]
            set item [$tree item id $id]
            set mb [$tree item text $id]
            set domchild [lindex $mb 2]
        }
        #we need name!!!

        CreateWidgetsFromXml::CreateAndVisualizeTreeLeave $domchild $properties($name,content_frame) [winfo parent $tree] $id $name

        set tree [lindex $args 1]
        set sel [$root selectNodes selected]
        if { $sel == "" } {
            $root appendXML {<selected></selected>}
            set sel [$root selectNodes selected]
        }
        $sel setAttribute selection [$tree selection get]
    }
}
