
                
proc ChangeTransfInCopy  { } {
    global CopyMoveInfo GidPriv

    set f $CopyMoveInfo(canvas).frame

    if { $CopyMoveInfo(Transformation) == "Sweep" && $CopyMoveInfo(EntitiesType) == "AllTypes" } {
        if { [catch { set whatuse [GiD_Info Project ViewMode] }] } {
            set whatuse GEOMETRYUSE
        }
        if { $whatuse == "GEOMETRYUSE" } {
            #::GidUtils::SetWarnLine [_ "Sweep cannot be used with all types selection"]
            set win [winfo toplevel $f].err
            WarnWin [_ "Sweep cannot be used with all types selection"]
            after idle [list set CopyMoveInfo(Transformation) $CopyMoveInfo(Transformation_old)]
            return
        }
    }

    if { $CopyMoveInfo(Transformation) == "Offset" &&
    $CopyMoveInfo(EntitiesType) != "Elements" &&
    $CopyMoveInfo(EntitiesType) != "Lines" &&
    $CopyMoveInfo(EntitiesType) != "Surfaces" } {
        set win [winfo toplevel $f].err
        WarnWin [_ "Offset can only be used for lines, surfaces or mesh elements"]
        after idle [list set CopyMoveInfo(Transformation) $CopyMoveInfo(Transformation_old)]
        return
    }
    foreach i [winfo children $f] {
        destroy $i
    }
    for {set i 1} {$i <= 6} {incr i} {
        if { ![info exists CopyMoveInfo(Num,$i)] } {
            set CopyMoveInfo(Num,$i) ""
        }
        foreach axe "x y z" {
            if { ![info exists CopyMoveInfo($axe,$i)] } {
                set CopyMoveInfo($axe,$i) 0.0
            }
        }
    }
    if { $CopyMoveInfo(what) == "Copy" } {
        switch $CopyMoveInfo(Transformation) \
                Translation { CopyTrans_ui $f } \
                Rotation { CopyRot_ui $f } \
                Mirror { CopyMirror_ui $f } \
                Scale { CopyScale_ui $f } \
                Offset { CopyOffset_ui $f } \
                Sweep { CopySweep_ui $f } \
                Align { CopyAlign_ui $f }
    } else {
        switch $CopyMoveInfo(Transformation) \
                Translation { CopyTrans_ui $f } \
                Rotation { CopyRot_ui $f } \
                Mirror { CopyMirror_ui $f } \
                Scale { CopyScale_ui $f } \
                Offset { CopyOffset_ui $f } \
                Align { CopyAlign_ui $f }
    }

    update idletasks
    $CopyMoveInfo(canvas) configure -scrollregion "0 0 \
            [winfo width $f] \
            [winfo height $f]"
    ResizeScrolledCanvas $CopyMoveInfo(scrolledcanvas) 

    foreach i [winfo children $f] {
        bind $i <Tab> {+focus [tk_focusNext %W] ; EnteringFocusInCopy \
                [tk_focusNext %W] ; break}
        bind $i <Shift-Tab> {+focus [tk_focusPrev %W] ; \
                EnteringFocusInCopy [tk_focusPrev %W] ; break}
    }
    SetDisabledInCopy
    set CopyMoveInfo(Transformation_old) $CopyMoveInfo(Transformation)
}

proc EnteringFocusInCopy { w } {
    global CopyMoveInfo
    set c $CopyMoveInfo(canvas)

    set sr [$c cget -scrollregion]

    set val [expr double([winfo y $w])/[lindex $sr 3]-0.1]
    if { [expr abs([lindex [$c yview] 0] - $val)] > 0.05 } {
        $c yview moveto $val
    }
    catch {
        $w sel range 0 end
    }

}

proc SetFocusTo { varname } {
    global CopyMoveInfo
    foreach i [winfo children $CopyMoveInfo(canvas).frame] {
        catch {
            if { [$i cget -textvariable] == $varname } {
                focus $i
                EnteringFocusInCopy $i
                break
            }
        }
    }
}

proc SetDisabledInCopy {} {
    global CopyMoveInfo GidPriv

    set w $CopyMoveInfo(mainframe)

    if { [catch { set whatuse [GiD_Info Project ViewMode] }] } {
        set whatuse GEOMETRYUSE
    }

    if { ( $whatuse != "GEOMETRYUSE") && ( $whatuse != "MESHUSE") } {
        $w.mcopy configure -state normal
        $w.mcopy configure -foreground black
        
        # $w.doextrude configure -state normal
        TTKMenubuttonConfigure $w.doextrude -state normal
        return
    }

    if { $CopyMoveInfo(Transformation) == "Offset" && \
                 $CopyMoveInfo(EntitiesType) != "Elements" && \
         $CopyMoveInfo(EntitiesType) != "Lines" && \
                 $CopyMoveInfo(EntitiesType) != "Surfaces" } {
        set CopyMoveInfo(EntitiesType) $CopyMoveInfo(EntitiesType_old)
        set win [winfo toplevel $w].err
        WarnWin [_ "Offset can only be used for lines, surfaces or mesh elements"]
        return
    }

    $w.checkbutton#1 configure -state normal
    $w.mcopy configure -state normal
    $w.createcontact configure -state normal
    [winfo parent $w].select configure -command [list AcceptInCopy [winfo parent $w]]


    if { $CopyMoveInfo(what) == "Move" } {
        # $w.doextrude configure -state disabled
        TTKMenubuttonConfigure $w.doextrude -state disabled
        $w.createcontact configure -state disabled
        set GidPriv(CopyMoveMCopies) 1
        $w.mcopy configure -state disabled
        $w.mcopy configure -foreground grey60
    } else {
        if { $CopyMoveInfo(EntitiesType) == "Points" ||
        $CopyMoveInfo(EntitiesType) == "Lines" ||
        $CopyMoveInfo(EntitiesType) == "Surfaces" ||
        $CopyMoveInfo(EntitiesType) == "Nodes" ||
        $CopyMoveInfo(EntitiesType) == "Elements" } {
            # $w.doextrude configure -state normal
            TTKMenubuttonConfigure $w.doextrude -state normal
        } else {
            # $w.doextrude configure -state disabled
            TTKMenubuttonConfigure $w.doextrude -state disabled
            set GidPriv(CopyMoveDoExtrude) No
        }

        if { $CopyMoveInfo(EntitiesType) == "Surfaces" } {
            if { $CopyMoveInfo(Transformation) != "Sweep" && $CopyMoveInfo(Transformation) != "Offset"} {
                $w.createcontact configure -state normal
            } else {
                $w.createcontact configure -state disabled
            }
        } else {
            $w.createcontact configure -state disabled
            set GidPriv(CopyMoveCreateContacts) 0
        }
        if { $CopyMoveInfo(Transformation) == "Mirror" } {
            set GidPriv(CopyMoveMCopies) 1
            $w.mcopy configure -state disabled
            $w.mcopy configure -foreground grey60
        }
        if { $CopyMoveInfo(Transformation) == "Align" } {
            set GidPriv(CopyMoveMCopies) 1
            $w.mcopy configure -state disabled
            $w.mcopy configure -foreground grey60
            $w.createcontact configure -state disabled
            set GidPriv(CopyMoveCreateContacts) 0
        }
    }
    set CopyMoveInfo(EntitiesType_old) $CopyMoveInfo(EntitiesType)
}

proc EnterNumInCopy { num } {
    global CopyMoveInfo
    set inum $CopyMoveInfo(Num,$num)
    set w [winfo parent $CopyMoveInfo(mainframe)].err
    set test_exp {^[ \t]*$}
    if { [regexp $test_exp $inum] } { return void}

    set test_exp_2 {^[ \t]*[0-9]+[ \t]*$}
    if { ![regexp $test_exp_2 $inum] } {
        WarnWin [_ "Number not valid"]
        SetFocusTo CopyMoveInfo(Num,$num)
        set CopyMoveInfo(Num,$num) ""
        return error
    }
    set test_exp_3 {^[ \t]*0+[ \t]*$}
    if { [regexp $test_exp_3 $inum] } {
        WarnWin [_ "Number 0 not valid"]
        SetFocusTo CopyMoveInfo(Num,$num)
        set CopyMoveInfo(Num,$num) ""
        return error
    }
    set res [GiD_Info Coordinates $inum]

    if { $res == "" } {
        WarnWin [_ "Point number %d doesn't exist" $inum]
        SetFocusTo CopyMoveInfo(Num,$num)
        set CopyMoveInfo(Num,$num) ""
        return error
    }

    set res [lindex $res 0]
    set CopyMoveInfo(x,$num) [lindex $res 0]
    set CopyMoveInfo(y,$num) [lindex $res 1]
    set CopyMoveInfo(z,$num) [lindex $res 2]

    UpdateCopyMoveEntrySizes
    return ""
}

proc EnterCoordInCopy { num } {
    global CopyMoveInfo
    if { [info exists CopyMoveInfo(Num,$num)] } {
        set inum $CopyMoveInfo(Num,$num)
        if { $inum != "" } {
            set diff 0
            set res [GiD_Info Coordinates $inum]
            if { $res != "" } {
                set res [lindex $res 0]
                foreach coord {x y z} pos {0 1 2} {
                    if { [string is double $CopyMoveInfo($coord,$num)] } {
                        if { [expr abs($CopyMoveInfo($coord,$num)-[lindex $res $pos])] > 0 } {
                            set diff 1
                            break
                        }
                    } else {
                        set diff 1
                        break
                    }
                }
            } else {
                set diff 1
            }
            if { $diff } {
                set CopyMoveInfo(Num,$num) ""
            }
        }
    }
    return ""
}

proc UpdateCopyMoveEntrySizes {  } {
    global CopyMoveInfo
    set w $CopyMoveInfo(canvas).frame
    set coordw 10
    set idw 8
    set numentries ""
    set coordentries ""
    foreach i [winfo children $w] {
        if { [winfo class $i] == "Entry" } {
            set varname [$i cget -textvariable]
            if { [string match {CopyMoveInfo(Num,[1-6])} $varname ] } {
                lappend numentries $i
            } elseif { [string match {CopyMoveInfo([xyz],[1-6])} $varname ] } {
                lappend coordentries $i
            }
        } elseif { [winfo class $i] == "Labelframe" } {
            foreach ii [winfo children $i] {
                if { [winfo class $ii] == "Entry" } {
                    set varname [$ii cget -textvariable]
                    if { [string match {CopyMoveInfo(Num,[1-6])} $varname ] } {
                        lappend numentries $ii
                    } elseif { [string match {CopyMoveInfo([xyz],[1-6])} $varname ] } {
                        lappend coordentries $ii
                    }
                }
            }
        }
    }    
    ResizeScrolledCanvas $CopyMoveInfo(scrolledcanvas)
}

proc PickPointInMove { num } {
    global CopyMoveInfo
    if { $num == 1 } {
        set msg [_ "Enter first point (ESC to leave)"]
    } elseif { $num == 2 } {
        set msg [_ "Enter second point (ESC to leave)"]
    } elseif { $num == 3 } {
        set msg [_ "Enter third point (ESC to leave)"]
    } else {
        set msg [_ "Enter point (ESC to leave)"]
    }
    set p1 [::GidUtils::GetCoordinates $msg]
    if { $p1 != "" } {
        if { $::GidPriv(selcoord,id) > 0 } {
            set CopyMoveInfo(Num,$num) $::GidPriv(selcoord,id)
        } else {
            set CopyMoveInfo(Num,$num) ""
        }
        lassign $p1 CopyMoveInfo(x,$num) CopyMoveInfo(y,$num) CopyMoveInfo(z,$num)
        UpdateCopyMoveEntrySizes
    } else {
        GidUtils::SetWarnLine [_ "Leaving"]
    }
}

proc AcceptInCopy { w } {
    global CopyMoveInfo GidPriv
    focus $w.select ;#to force invoke bindings calling to EnterCoordInCopy
    update ;#to force invoke bindings calling to EnterCoordInCopy

    for {set i 1} {$i <= 6} {incr i} {
        if { $CopyMoveInfo(Transformation) == "Translation" } {
            if { $i == 3 } break
        } elseif { $CopyMoveInfo(Transformation) == "Rotation" } {
            if { $i == 3 || ( $i == 2 && [lindex $CopyMoveInfo(TwoDim) 0] == 1 ) } break
        } elseif { $CopyMoveInfo(Transformation) == "Mirror" } {
            if { $i == 4 || ( $i == 3 && [lindex $CopyMoveInfo(TwoDim) 0] == 1 ) } break
        } elseif { $CopyMoveInfo(Transformation) == "Scale" } {
            if { $i == 3 } break
        } elseif { $CopyMoveInfo(Transformation) == "Offset" } {
            break
        } elseif { $CopyMoveInfo(Transformation) == "Sweep" } {
            break
        } elseif { $CopyMoveInfo(Transformation) == "Align" } {
            if { $i==7 || ( $i == 5 && [lindex $CopyMoveInfo(TwoDim) 0] == 1 ) } break
        }

        if { $i == 2 && $CopyMoveInfo(Transformation) == "Scale" } {
            set ret void
        } else {
            set ret [EnterNumInCopy $i]
        }
        if { $ret == "error" } { return }
        if { $ret == "void" } {
            set Number($i) ""
            foreach axe "x y z" {
                if { ![info exists CopyMoveInfo($axe,$i)] || ![string is double $CopyMoveInfo($axe,$i)] } {
                    WarnWin [_ "Number not valid"]
                    SetFocusTo CopyMoveInfo($axe,$i)
                    return
                }
                append Number($i) [string trim $CopyMoveInfo($axe,$i)]
                if { $axe != "z" } { append Number($i) , }
            }
        } else {
            unset -nocomplain Number($i)
        }
    }

    if { ![info exists GidPriv(CopyMoveMCopies)] || ![string is integer $GidPriv(CopyMoveMCopies)] } {
        WarnWin  [_ "Wrong number of copies"]
        return
    }
    if { $CopyMoveInfo(Transformation) == "Rotation" && (![info exists CopyMoveInfo(Degree)] || ![string is double -strict $CopyMoveInfo(Degree)]) } {
        WarnWin [_ "Angle not valid"]
        SetFocusTo CopyMoveInfo(Degree)
        return
    } elseif { $CopyMoveInfo(Transformation) == "Offset" && (![info exists CopyMoveInfo(OffsetFactor)] || ![string is double -strict $CopyMoveInfo(OffsetFactor)]) } {
        WarnWin [_ "Offset factor not valid"]
        SetFocusTo CopyMoveInfo(OffsetFactor)
        return
    } elseif { $CopyMoveInfo(Transformation) == "Sweep" } {
        set msgerr ""
        if { ![info exists CopyMoveInfo(path)] || $CopyMoveInfo(path) == "" } {
            set msgerr [_ "No path line entered"]
            WarnWin $msgerr
            return
        }
        if { ![info exists CopyMoveInfo(EndScale)] || $CopyMoveInfo(EndScale) == "" } {
            set CopyMoveInfo(EndScale) 1.0
        } else {
            if { $CopyMoveInfo(EndScale) <= 0 } {
                WarnWin [_ "Sweep end scale not valid, must be greater than zero"]
                return
            }
        }
        if { ![info exists CopyMoveInfo(TwistAngle)] || $CopyMoveInfo(TwistAngle) == "" } {
            set CopyMoveInfo(TwistAnge) 0.0
        }
        if { ($CopyMoveInfo(x,1) == "") || ($CopyMoveInfo(z,1) == "") || ($CopyMoveInfo(y,1) == "") } {
            if { $CopyMoveInfo(EnabledCurveTwist) == 1 } {
                set msgerr [_ "Bad direction in twist mode."]
                WarnWin $msgerr
                return
            }
        }
        if { $CopyMoveInfo(EntitiesType) == "Points" } {
            if { $GidPriv(CopyMoveDoExtrude) == "Surfaces" || $GidPriv(CopyMoveDoExtrude) == "Volumes" } {
               set msgerr [_ "Sorry, cannot extrude to %s." $GidPriv(CopyMoveDoExtrude)]
                WarnWin $msgerr
                return
            }
        } elseif { $CopyMoveInfo(EntitiesType) == "Lines" } {
            if { $GidPriv(CopyMoveDoExtrude) == "Volumes" } {
                set msgerr [_ "Sorry, cannot extrude to %s." $GidPriv(CopyMoveDoExtrude)]
                WarnWin $msgerr
                return
            }
        }
    }

    if { [catch { set whatuse [GiD_Info Project ViewMode] }] } {
        set whatuse GEOMETRYUSE
    }

    set res {}

    if { $whatuse == "GEOMETRYUSE" || $whatuse == "MESHUSE" } {
        lappend res $CopyMoveInfo(what)
        lappend res $CopyMoveInfo(EntitiesType)
        if { $GidPriv(DuplicateEntities) != 0 } {
            lappend res Duplicate
        }
        if { $CopyMoveInfo(what) == "Copy" } {
            if { $GidPriv(CopyMoveDoExtrude) == "Lines" } {
                lappend res DoExtrude Lines
            } elseif { $GidPriv(CopyMoveDoExtrude) == "Surfaces" } {
                lappend res DoExtrude Surfaces
            } elseif { $GidPriv(CopyMoveDoExtrude) == "Volumes" } {
                lappend res DoExtrude Volumes
            }
            if { $GidPriv(CopyMoveCreateContacts) == 1 } {
                lappend res Contacts
            }
        }
        if { $GidPriv(CopyMoveMaintainLayers)  == 1 } {
            lappend res MaintainLayers
        }
        if { $GidPriv(CopyMoveMCopies) != 1 } {
            lappend res MCopy
            lappend res $GidPriv(CopyMoveMCopies)
        }
    } else {
        # Postprocess
        lappend res transformation
        if { $GidPriv(CopyMoveMCopies) != 1 } {
            lappend res RepeatTransf
            lappend res $GidPriv(CopyMoveMCopies)
        }
        #lappend res transformation
        if { $GidPriv(PostDuplicateEntities)} {
            if { $CopyMoveInfo(PostDuplicateWhat) == "Create volume/surface" } {
                lappend res create yes
            } else {
                # $GidPriv(PostDuplicateWhat) == "Extrude sets"
                lappend res create extrude
            }
        }
    }

    lappend res $CopyMoveInfo(Transformation)


    for {set i 1} {$i <= 6} {incr i} {
        if { $CopyMoveInfo(Transformation) == "Translation" } {
            if { ![info exists Number($i)] } {
                lappend res FJoin $CopyMoveInfo(Num,$i)
            } else {
                lappend res FNoJoin $Number($i)
            }
            if { $i == 2 } break
        } elseif { $CopyMoveInfo(Transformation) == "Rotation" } {
            if { $i == 2 && [lindex $CopyMoveInfo(TwoDim) 0] == 1 } {
                lappend res TwoDim
                lappend res $CopyMoveInfo(Degree)
                break
            } elseif { ![info exists Number($i)] } {
                lappend res FJoin $CopyMoveInfo(Num,$i)
            } else {
                lappend res FNoJoin $Number($i)
            }
            if { $i == 2 } {
                lappend res $CopyMoveInfo(Degree)
                break
            }
        } elseif { $CopyMoveInfo(Transformation) == "Mirror" } {
            if { $i == 3 && [lindex $CopyMoveInfo(TwoDim) 0] == 1 } {
                lappend res TwoDim
                break
            } elseif { ![info exists Number($i)] } {
                lappend res FJoin $CopyMoveInfo(Num,$i)
            } else {
                lappend res FNoJoin $Number($i)
            }
            if { $i == 3 } break
        } elseif { $CopyMoveInfo(Transformation) == "Scale" } {
            if { ![info exists Number($i)] } {
                lappend res FJoin $CopyMoveInfo(Num,$i)
            } else {
                lappend res FNoJoin $Number($i)
            }
            foreach axe {x y z} {
                set CopyMoveInfo($axe,scale) [string trim $CopyMoveInfo($axe,scale)]
                if { ![string is double -strict $CopyMoveInfo($axe,scale)] } {
                    WarnWin [_ "Number not valid"]
                    SetFocusTo CopyMoveInfo($axe,scale)
                    return
                }
            }
            lappend res FNoJoin "$CopyMoveInfo(x,scale),$CopyMoveInfo(y,scale),$CopyMoveInfo(z,scale)"
            break
        } elseif { $CopyMoveInfo(Transformation) == "Offset" } {
            lappend res $CopyMoveInfo(OffsetFactor)
            if { $i == 1 } break
        } elseif { $CopyMoveInfo(Transformation) == "Sweep" } {
            lappend res $CopyMoveInfo(path)
            lappend res $CopyMoveInfo(TwistAngle)
            lappend res $CopyMoveInfo(TwistMode)
            if { $GidPriv(CopyMoveDoExtrude) == "No" } {
                if { $CopyMoveInfo(EnabledCurveTwist) == 0 } {
                    lappend res 2
                } else {
                    lappend res 3
                }
            } else {
                if { $CopyMoveInfo(EnabledCurveTwist) == 0 } {
                    lappend res 0
                } else {
                    lappend res 1
                }
            }
            lappend res $CopyMoveInfo(x,1) $CopyMoveInfo(y,1) $CopyMoveInfo(z,1)
            lappend res $CopyMoveInfo(EndScale)
            if { $i == 1 } break
        } elseif { $CopyMoveInfo(Transformation) == "Align" } {
            if { ($i == 5 && [lindex $CopyMoveInfo(TwoDim) 0] == 1) } {
                lappend res TwoDim
                break
            } elseif { ![info exists Number($i)] } {
                lappend res FJoin $CopyMoveInfo(Num,$i)
            } else {
                lappend res FNoJoin $Number($i)
            }
            if { $i == 6 } break
        }
    }

    # That's for Windows
    #focus .central.s
    #gidmakecurrent
    GiD_Process Mescape Utilities {*}$res

    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        set SmallWinSelecting [GiD_Set SmallWinSelecting]
        FinishButton $w $w.buts [_ "Press 'Finish' to end selection"] \
                SetDisabledInCopy disableall $SmallWinSelecting
    }
}

proc PostTransformations { { w .gid.wtransformation } } {
    if { [catch { set whatuse [GiD_Info Project ViewMode] }] } {
        set whatuse GEOMETRYUSE
    }
    if { ( $whatuse != "GEOMETRYUSE") && ( $whatuse != "MESHUSE") } {
        CopyMove Copy $w
    }
}

proc PostChangedShowTransf { } {
    global CopyMoveInfo GidPriv

    if { $GidPriv(CopyMoveDoExtrude) == "Show" } {
        GiD_Process Utilities Transformation UseTransfs Yes
    } else {
        GiD_Process Utilities Transformation UseTransfs No
    }
}

proc PostChangedShowTransfOriginal { } {
    global CopyMoveInfo GidPriv

    GiD_Process Utilities Transformation ShowOriginal $::GidPriv(CopyMoveShowOriginal)
}

proc PostChangedDuplicate { name1 name2 op} {
    global CopyMoveInfo GidPriv    

    if { $GidPriv(PostDuplicateEntities) } {        
        $CopyMoveInfo(mainframe).fopt.bdellast configure -state disabled
        $CopyMoveInfo(mainframe).fopt.bclearall configure -state disabled        
        [TTKMB_CreateOrConfigure $CopyMoveInfo(mainframe).doextrude] \
            $CopyMoveInfo(mainframe).doextrude \
            -textvariable ::CopyMoveInfo(PostDuplicateWhat) \
            -labels [list [_ "Create volume/surface"] [_ "Extrude surface"]] \
            -values {"Create volume/surface" "Extrude surface"} \
            -width [ expr [ string length [_ "Create volume/surface"]] + 5]
        set ::CopyMoveInfo(PostDuplicateWhat) "Create volume/surface"
        
        grid forget $CopyMoveInfo(mainframe).doextrudel
        grid $CopyMoveInfo(mainframe).doextrude -in $CopyMoveInfo(mainframe).fopt -row 0 -column 0 \
                -sticky we -pady 1 -padx 0 -ipady 1 -columnspan 2

    } else {        
        $CopyMoveInfo(mainframe).fopt.bdellast configure -state normal
        $CopyMoveInfo(mainframe).fopt.bclearall configure -state normal
        $CopyMoveInfo(mainframe).doextrudel configure -variable ::GidPriv(CopyMoveDoExtrude) \
            -text [_ "Show transformations"] \
            -onvalue Show \
            -offvalue Hide \
            -command PostChangedShowTransf        
        grid forget $CopyMoveInfo(mainframe).doextrude
        grid $CopyMoveInfo(mainframe).doextrudel -in $CopyMoveInfo(mainframe).fopt -row 0 -column 0 \
                -sticky we -pady 1 -padx 0 -ipady 1 -columnspan 2
        set ::GidPriv(CopyMoveDoExtrude) "Show"

        $CopyMoveInfo(mainframe).doshoworiginal configure -variable ::GidPriv(CopyMoveShowOriginal) \
            -text [_ "Show original"] \
            -onvalue Yes \
            -offvalue No \
            -command PostChangedShowTransfOriginal        
        grid $CopyMoveInfo(mainframe).doshoworiginal -in $CopyMoveInfo(mainframe).fopt -row 0 -column 1 \
                -sticky we -pady 1 -padx 0 -ipady 1 -columnspan 2
        set ::GidPriv(CopyMoveShowOriginal) "Yes"

        

    }
}

proc UpdateCopyMove { { w .gid.wcopymove } } {
    global CopyMoveInfo
    if {![winfo exists $w]} return
    CopyMove $CopyMoveInfo(what)
}

proc CopyMove { what { w .gid.wcopymove } } {    
    global busy
    if { [info exists busy] && $busy } {
        #avoid Tcl error when pressing continuously a key that invoke a procedure
        return
    }
    set busy 1
    if { [catch { CopyMove_Do $what $w } err] } {
        WarnWinText $err
    }
    set busy 0
}

proc CopyMove_Do { what { w .gid.wcopymove } } {
    global CopyMoveInfo GidPriv

    set whatuse [GiD_Info Project ViewMode]        
    if { $what == "Transform" } {
        set whatuse POSTUSE
    }

    if { $whatuse == "GEOMETRYUSE" || $whatuse == "MESHUSE" } {
        #preprocess
        if { $what != "Copy" && $what != "Move" } {
            W "CopyMove: unexpected mode $what"
        }
        if { ![info exists GidPriv(DuplicateEntities)] } {
            set GidPriv(DuplicateEntities) 0
        }
        if { ![info exists GidPriv(CopyMoveDoExtrude)] } {
            set GidPriv(CopyMoveDoExtrude) No
        }
        if { ![info exists GidPriv(CopyMoveMaintainLayers)] } {
            set GidPriv(CopyMoveMaintainLayers) 1
        }
    } else {
        #postprocess
        if { ![info exists GidPriv(CopyMoveDoExtrude)] } {
            set GidPriv(CopyMoveDoExtrude) Show
        }
        if { ![info exists GidPriv(PostDuplicateEntities)] } {
            set GidPriv(PostDuplicateEntities) 0
        }
    }
    if { ![info exists GidPriv(CopyMoveCreateContacts)] } {
        set GidPriv(CopyMoveCreateContacts) 0
    }
    
    #reset number of copies to 1 each time that the window is opened, do not remember his value
    set GidPriv(CopyMoveMCopies) 1
    
    if { ![info exists GidPriv(CopyMoveSameFactors)] } {
        set GidPriv(CopyMoveSameFactors) 1
    }

    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        if { $what == "Copy" } {
            set title [_ "Copy"]
        } elseif { $what == "Move" } {
            set title [_ "Move"]
        } else {
            set title [_ $what]
        }
        InitWindow2 $w -title $title -geometryvariable PreCopyMoveWindowGeom \
            -initcommand [list CopyMove $what] \
            -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    } else {
        if { $w == ".gid.wcopymove"} {
            set w .gid.wtransformation
        }
        InitWindow2 $w -title [_ "Transformations"] -geometryvariable PostTransformWindowGeom \
            -initcommand [list CopyMove Transform] \
            -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        #PostTransformations
        trace remove variable ::GidPriv(PostDuplicateEntities) write PostChangedDuplicate
    }

    #set CopyMoveInfo after InitWindow, else if the window exists CopyMoveInfo are unset
    catch { array unset CopyMoveInfo }

    set CopyMoveInfo(what) $what
    set CopyMoveInfo(x,scale) 1.0
    set CopyMoveInfo(y,scale) 1.0
    set CopyMoveInfo(z,scale) 1.0

    set CopyMoveInfo(Transformation) "Translation"
    set CopyMoveInfo(Transformation_old) $CopyMoveInfo(Transformation)
    if { $whatuse == "MESHUSE" } {
        set CopyMoveInfo(EntitiesType) Nodes
    } else {
        set CopyMoveInfo(EntitiesType) Points
    }
    set CopyMoveInfo(EntitiesType_old) $CopyMoveInfo(EntitiesType)
    
    ttk::frame $w.f -style ridge.TFrame -borderwidth 2
    #----vars -----
    set root $w.f
    set sc $w.f.sc
    #---- end vars ---
    set CopyMoveInfo(canvas) [CopyMain_ui $root $sc] ;#create window contents
    set CopyMoveInfo(scrolledcanvas) $sc
    set CopyMoveInfo(mainframe) $root


    ttk::frame $w.buts -style BottomFrame.TFrame

    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
        set textselect [_ "Select"]
        # set textcancel [_ "Cancel"]
        set textcancel [_ "Close"]
    } else {
        set textselect [_ "Apply"]
        set textcancel [_ "Close"]
    }
    ttk::button $w.select -text $textselect -command "AcceptInCopy $w" -style BottomFrame.TButton
    ttk::button $w.cancel -text $textcancel -command "destroy $w" -style BottomFrame.TButton

    grid $root -ipadx 0 -pady 2 -sticky nswe
    grid $w.buts -sticky ew
    grid anchor $w.buts center
    grid $w.select $w.cancel -in $w.buts -pady 12 -ipady 0 -padx 8 -ipadx 0
    grid columnconfigure $w 0 -weight 1
    #grid columnconfigure $w 1 -weight 1
    grid rowconfigure $w 0 -weight 1

    ttk::frame $CopyMoveInfo(canvas).frame  
    $CopyMoveInfo(canvas) create window 0 0 -anchor nw -window $CopyMoveInfo(canvas).frame

    if { ( $whatuse == "GEOMETRYUSE") || ( $whatuse == "MESHUSE") } {
    } else {
        # trace add variable ::GidPriv(CopyMoveDoExtrude) write PostChangedShowTransf
        trace add variable ::GidPriv(PostDuplicateEntities) write PostChangedDuplicate

        PostChangedDuplicate a b c
    }

    #set initial mode
    SetDisabledInCopy
    ChangeTransfInCopy
   
    bind $w <${::acceleratorKey}-a> [bind .gid <${::acceleratorKey}-a>]
    bind $w <Destroy> [list +DestroyCopyMove %W $w] ;# + to add to previous script

    # topmost FORBIDDEN
    # wm attributes $w -topmost 1
    # GidUtils::WindowAboveGid $w
    
    trace add variable ::CopyMoveInfo(Transformation) write "ChangeTransfInCopy ;#"
    trace add variable ::CopyMoveInfo(EntitiesType) write "SetDisabledInCopy ;#"
}

proc DestroyCopyMove { W w } {
    if { $W != $w } return
    #reenter multiple times, one by toplevel child, only interest w
    global CopyMoveInfo GidPriv
    catch { array unset CopyMoveInfo } ;#remove also CopyMoveInfo traces
    # trace remove variable ::GidPriv(CopyMoveDoExtrude) write PostChangedShowTransf
    trace remove variable ::GidPriv(PostDuplicateEntities) write PostChangedDuplicate

    # trace remove variable ::GidPriv(CopyMoveDoExtrude) write PostChangedShowTransf
    trace remove variable ::GidPriv(PostDuplicateEntities) write PostChangedDuplicate
}



