#   root     is the parent window for this user interface

proc CopyAlign_ui {root args} {
    global CopyMoveInfo
    # this treats "." as a special case

    if {$root == "."} {
	set base ""
    } else {
	set base $root
    }

    set coordw 8
    set idw 6

    set contsrc 0
    set contdst 0
    for {set i 1} { $i <= 6 } {incr i } {
	set frm "$base.frm$i"
	ttk::labelframe $frm
	if { $i == 1 || $i == 3 || $i == 5 } {
	    incr contsrc
	    $frm configure -text [concat [_ "Source Point"] $contsrc]
	} else {
	    incr contdst
	    $frm configure -text [concat [_ "Destination Point"] $contdst]
	}
	ttk::label $frm.lblnum$i -text [_ "Num"]:
	ttk::entry $frm.entnum$i -textvariable CopyMoveInfo(Num,$i) -width $idw
	ttk::button $frm.btnpick$i -command "PickPointInMove $i" -image [gid_themes::GetImage "point.png" small_icons]
	foreach x {x y z} {
	    ttk::label $frm.lbl$x$i -text $x:
	    ttk::entry $frm.ent$x$i -textvariable CopyMoveInfo($x,$i) -width $coordw
	}
    }

    if { ![info exists CopyMoveInfo(TwoDim)] } { set CopyMoveInfo(TwoDim) 0 }
    ttk::checkbutton $base.chk1 -takefocus 0 -text [_ "Two dimensions"] -variable CopyMoveInfo(TwoDim)

    # Geometry management
    grid $base.chk1 -padx 2 -ipadx 1 -pady 0 -ipady 0 -columnspan 2
    grid $base.frm1 $base.frm2 -padx 2 -ipadx 1 -pady 0 -ipady 0
    grid $base.frm3 $base.frm4 -padx 2 -ipadx 1 -pady 0 -ipady 0
    grid $base.frm5 $base.frm6 -padx 2 -ipadx 1 -pady 0 -ipady 0

    for {set i 1} { $i <= 6 } {incr i } {
	set frm "$base.frm$i"
	#grid $frm.lblpoint$i -row 1 -column 1 -sticky we -padx 2 -pady 0 -ipady 0 -columnspan 3
	grid $frm.lblnum$i -row 2 -column 1 -sticky w -padx 2 -pady 0 -ipady 0
	grid $frm.entnum$i -row 3 -column 1 -sticky w -padx 2 -pady 0 -ipady 0
	grid $frm.btnpick$i -row 4 -column 1 -sticky e -padx 2 -pady 0 -ipady 0
	foreach row {2 3 4 } x {x y z} {
	    grid $frm.lbl$x$i -row $row -column 2 -sticky w -padx 2 -pady 0 -ipady 0
	    grid $frm.ent$x$i -row $row -column 3 -sticky w -padx 2 -pady 0 -ipady 0
	}
    }

    # Resize behavior management
    for {set i 1} { $i <= 6 } {incr i } {
	set frm "$base.frm$i"
	grid rowconfigure $frm "1 2 3 4 5" -weight 0 -minsize 1
	grid columnconfigure $frm "1" -weight 0 -minsize 1
	grid columnconfigure $frm "2 3" -weight 1 -minsize 1
    }

    # Resize behavior management
    grid rowconfigure $root "1 2 3 4 5" -weight 0 -minsize 1
    grid columnconfigure $root 1 -weight 0 -minsize 1


    # additional interface code
    for {set i 1} { $i <= 6 } {incr i } {
	set frm "$base.frm$i"
	bind $frm.entnum$i <Return> "EnterNumInCopy $i"
	bind $frm.entnum$i <FocusOut> "EnterNumInCopy $i"
	foreach x {x y z} {
	    bind $frm.ent$x$i <Return> "EnterCoordInCopy $i"
	    bind $frm.ent$x$i <FocusOut> "EnterCoordInCopy $i"
	}
    }



    $base.chk1 configure -offvalue "0 $base.frm5 $base.frm6"
    $base.chk1 configure -onvalue "1 $base.frm5 $base.frm6"

    $base.chk1 configure -command {
	if { [lindex $CopyMoveInfo(TwoDim) 0] != 0 } {
	    set stt disabled
	    set fgc grey60
	} else {
	    set stt normal
	    set fgc black
	}
	set slaves [grid slaves [lindex $CopyMoveInfo(TwoDim) 1]]
	append slaves " [grid slaves [lindex $CopyMoveInfo(TwoDim) 2]]"
	foreach i $slaves {
	    catch { $i configure -state $stt }
	    if { [winfo class $i] != "Button" } {
		catch { $i configure -foreground $fgc }
	    }
	}
    }
	
    # end additional interface code
}
