set ::orthonear_orig "none"
set ::bboxnear -10
set ::bboxfar 10
set ::orthofar_orig "none"
set ::CliPPriv(DynamicUpdate) 0
set ::timelastcall 0
set ::CliPPriv(format) %.5f

proc FormatSpinBox { value } {
    return [format $::CliPPriv(format) $value]
}

#el scalefar scalenear van de 0.1 a 1.9
#en el dibujo se aprecia la interseccion de 0.7 a 1.3 (van 0.6)
#quedan 3 tramos de 0.6
#el medio esta en el 1.0

#quiero si los clipplanes son los originales:
#0.1 equivale a near [lindex $ortholimits 4]
#1.9 equivale a far [lindex $ortholimits 5]
#la bounding box del modelo va de 0.70-margen a 1.30+margen


#en otros casos
#asegurarse que [lindex $ortholimits 4] y [lindex $ortholimits 5] son algun punto del dibujo
#la bounding box del modelo va de 0.7-margen a 1.3+margen

proc SetToGid {} {
    if { $::scalenear < 0.7 } {
        set divisor [expr $::bboxnear-$::intervalini]
        if { $divisor != "Inf" } {
            set ::NOrtho [FormatSpinBox [expr $::intervalini+(($::scalenear-0.1)/0.6)*$divisor]]
            set ::FOrtho [FormatSpinBox [expr $::intervalini+(($::scalefar-0.1)/0.6)*$divisor]]
        } else {
            set ::NOrtho [FormatSpinBox $::intervalini]
            set ::FOrtho [FormatSpinBox $::intervalini]
        }
    } elseif { $::scalenear < 1.3 } {
        set divisor [expr $::bboxfar-$::bboxnear]
        if { $divisor != "Inf" } {
            set ::NOrtho [FormatSpinBox [expr $::bboxnear+(($::scalenear-0.7)/0.6)*$divisor]]
            set ::FOrtho [FormatSpinBox [expr $::bboxnear+(($::scalefar-0.7)/0.6)*$divisor]]
        } else {
            set ::NOrtho [FormatSpinBox $::bboxnear]
            set ::FOrtho [FormatSpinBox $::bboxnear]
        }

    } else {
        #$::scalenear < 1.9
        set divisor [expr $::intervalend-$::bboxfar]
        if { $divisor != "Inf" } {
            set ::NOrtho [FormatSpinBox [expr $::bboxfar+(($::scalenear - 1.3)/0.6)*$divisor]]
            set ::FOrtho [FormatSpinBox [expr $::bboxfar+(($::scalefar - 1.3)/0.6)*$divisor]]
        } else {
            set ::NOrtho [FormatSpinBox $::bboxfar]
            set ::FOrtho [FormatSpinBox $::bboxfar]
        }
    }
    GiD_Process 'ClipPlanes $::NOrtho $::FOrtho
}


proc ClipPlanes_Scale { center point factor } {
    return [expr $center+$factor*($point-$center)]
}

proc FillColorSphere { inix iniy centerx centery radius can} {
    $can delete filloval
    $can delete fillovalcut

    for {set factorini $::scalenear} {$factorini<$::scalefar} {set factorini [expr $factorini+0.01]} {
        set c_ovalx [ClipPlanes_Scale $inix $centerx $factorini]
        if { $c_ovalx < [expr $centerx-$radius] || $c_ovalx > [expr $centerx+$radius] } {

        } else {
            set c_ovaly [ClipPlanes_Scale $iniy $centery $factorini]
            set c_ovaly $centery
            set r_oval [expr sqrt([expr pow($radius,2.0) - pow([expr $centerx - $c_ovalx],2.0)])]
            if { $c_ovalx < $centerx } {
                set x1 [expr $c_ovalx-pow($factorini,3.0)*$r_oval/2.0]
                set y1 [expr $c_ovaly-$r_oval]
                set x2 [expr $c_ovalx+pow($factorini,3.0)*$r_oval/2.0]
                set y2 [expr $c_ovaly+$r_oval]
            } else {
                set x1 [expr $c_ovalx-pow([expr 2.0-$factorini],3.0)*$r_oval/2.0]
                set y1 [expr $c_ovaly-$r_oval]
                set x2 [expr $c_ovalx+pow([expr 2.0-$factorini],3.0)*$r_oval/2.0]
                set y2 [expr $c_ovaly+$r_oval]
            }
            if { $factorini == $::scalenear } {
                $can create oval $x1 $y1 $x2 $y2 -width 0 -fill #bbbbe5 -tag fillovalcut
            } else {
                $can create oval $x1 $y1 $x2 $y2 -width 0 -fill #cccccc -tag filloval
            }
        }
    }
    $can lower fillovalcut
    $can lower filloval
}

proc ModifyBothPlanes { initime factornear factorfar inix iniy centerx centery radius can } {
    global CliPPriv
    global canvas
    if { $initime < [set ::timelastcall] } { return }
    if { $::CliPPriv(DynamicUpdate) == 0 } {
        set ::CliPPriv(DynamicUpdate) 1
        if { $factornear != "-1" } { ModifyPlane $canvas(near,obj) $canvas(near,tagcut) $canvas(near,varscale) $canvas(near,color) $canvas(near,dash) $factornear $inix $iniy $centerx $centery $radius $can}
        if { $factorfar != "-1" } { ModifyPlane $canvas(far,obj) $canvas(far,tagcut) $canvas(far,varscale) $canvas(far,color) $canvas(far,dash) $factorfar $inix $iniy $centerx $centery $radius $can}
        $can raise farcut
        $can raise nearcut
        FillColorSphere $inix $iniy $centerx $centery $radius $can
        SetToGid
        set ::CliPPriv(DynamicUpdate) 0
    }
}

proc ModifyPlane { obj tagcut varscale color dash factorini inix iniy centerx centery radius can { other0 0} { other1 0} {other3 0}} {
    set factortoplane [expr $factorini/[set $varscale]]
    $can scale $obj $inix $iniy $factortoplane $factortoplane
    set $varscale $factorini
    $can delete $tagcut
    set c_ovalx [ClipPlanes_Scale $inix $centerx $factorini]
    if { $c_ovalx < [expr $centerx-$radius] || $c_ovalx > [expr $centerx+$radius] } {
    } else {
        set c_ovaly $centery
        set r_oval [expr sqrt([expr pow($radius,2.0) - pow([expr $centerx - $c_ovalx],2.0)])-abs($centery-$c_ovaly)]

        if { $c_ovalx < $centerx } {
            set x1 [expr $c_ovalx-pow($factorini,3.0)*$r_oval/2.0]
            set y1 [expr $c_ovaly-$r_oval]
            set x2 [expr $c_ovalx+pow($factorini,3.0)*$r_oval/2.0]
            set y2 [expr $c_ovaly+$r_oval]
        } else {
            set x1 [expr $c_ovalx-pow([expr 2.0-$factorini],3.0)*$r_oval/2.0]
            set y1 [expr $c_ovaly-$r_oval]
            set x2 [expr $c_ovalx+pow([expr 2.0-$factorini],3.0)*$r_oval/2.0]
            set y2 [expr $c_ovaly+$r_oval]
        }
        if { $dash == yes } {
            $can create arc $x1 $y1 $x2 $y2 -width 2 -outline $color -start 90 -extent 180 -dash . -style arc -tag $tagcut
            $can create arc $x1 $y1 $x2 $y2 -width 2 -outline $color -start 270 -extent 180 -style arc -tag $tagcut
        } else {
            $can create oval $x1 $y1 $x2 $y2 -width 2 -outline $color -tag $tagcut
        }
    }
}

proc ClipPlanesOriginal { inix iniy centerx centery radius can } {
    GiD_Process 'ClipPlanes original
    after idle [list OpenfromEmptyWindow $inix $iniy $centerx $centery $radius $can]
}

proc OpenfromEmptyWindow { inix iniy centerx centery radius can } {
    if { $::scalenear != 1.0 } {
        ModifyPlane  $::nearplane "nearcut" "::scalenear" "#0000aa" "no" 1.0 $inix $iniy $centerx $centery $radius $can
    }
    if { $::scalefar != 1.0 } {
        ModifyPlane  $::farplane "farcut" "::scalefar" "#aa0000" "yes" 1.0 $inix $iniy $centerx $centery $radius $can
    }
    set factors [ComputeValuesDraw]
    ModifyPlane  $::nearplane "nearcut" "::scalenear" "#0000aa" "no" [FromRealToScale [lindex $factors 0]] $inix $iniy $centerx $centery $radius $can
    ModifyPlane  $::farplane "farcut" "::scalefar" "#aa0000" "yes" [FromRealToScale [lindex $factors 1]] $inix $iniy $centerx $centery $radius $can
    FillColorSphere $inix $iniy $centerx $centery $radius $can
}

proc ChangeSpinboxBound { actobj inix iniy centerx centery radius can } {
    #::NOrtho and ::FOrtho are correct (until bound touch clipplane)
    #so distance between them is correct, independely, if fixeddistance is on or off
    set initime [clock milliseconds]
    if { $actobj == "near" } {
        if { $::intervalini>$::NOrtho } {
            #set near clip plane to min
            set ::NOrtho $::intervalini
            if { $::fixeddistance != "no" } {
                set ::FOrtho [expr $::NOrtho+$::fixeddistance]
                if { $::FOrtho > $::intervalend } {
                    set ::fixeddistance "no"
                    set ::FOrtho $::intervalend
                }
            } elseif { $::NOrtho>$::FOrtho} {
                set ::FOrtho $::NOrtho
            }
        }
    } else {
        if { $::intervalend<$::FOrtho } {
            #set far clip plane to max
            set ::FOrtho $::intervalend
            if { $::fixeddistance != "no" } {
                set ::NOrtho [expr $::FOrtho-$::fixeddistance]
                if { $::NOrtho < $::intervalini } {
                    set ::fixeddistance "no"
                    set ::NOrtho $::intervalini
                }
            } elseif { $::NOrtho>$::FOrtho} {
                set ::NOrtho $::FOrtho
            }
        }
    }
    after idle [list ModifyBothPlanes $initime [FromRealToScale $::NOrtho] [FromRealToScale $::FOrtho] $inix $iniy $centerx $centery $radius $can]
    return true
}

proc ChangeSpinboxCurrent { actobj inix iniy centerx centery radius can } {
    set initime [clock milliseconds]
    if { $actobj == "near" } {
        set factors [CalculateFactorsFromObjAndFactorIni [FromRealToScale $::NOrtho] "near"]
    } else {
        set factors [CalculateFactorsFromObjAndFactorIni [FromRealToScale $::FOrtho] "far"]
    }
    after idle [list ModifyBothPlanes $initime [lindex $factors 0] [lindex $factors 1] $inix $iniy $centerx $centery $radius $can]
    return true
}

proc CalculateDistancePlanes { w } {
    if { $::fixeddistance != "no" } {
        set ::fixeddistance [FormatSpinBox [expr $::FOrtho - $::NOrtho]]
        $w configure -onvalue $::fixeddistance
    }
}

proc ComputeValuesDraw {} {
    set ortholimits [GiD_Info ortholimits]
    set near [lindex $ortholimits 4]
    set far [lindex $ortholimits 5]

    if { $far < $near } {
        set aux $near
        set near $far
        set far $aux
    }

    lassign [GiD_Info graphcenter] x_graphcenter y_graphcenter z_graphcenter
    lassign [GiD_Info bounding_box -pmin_pmax] x_min y_min z_min x_max y_max z_max
    #set diagonal_bbox [MathUtils::VectorDistance [list $x_min $y_min $z_min] [list $x_max $y_max $z_max]]
    #to do: can try to calculate a ::CliPPriv(format) based on $diagonal_bbox...    
    set distcenter [expr max( abs($x_min-$x_graphcenter) , abs($x_max-$x_graphcenter), \
        abs($y_min-$y_graphcenter) , abs($y_max-$y_graphcenter), \
        abs($z_min-$z_graphcenter) , abs($z_max-$z_graphcenter) ) ]
    if { $distcenter == 0 } {
        set distcenter [expr ($far-$near)/4]
    }

    #medium distance
    set ::bboxnear [expr -1*($z_graphcenter+$distcenter)]
    set ::bboxfar  [expr -1*($z_graphcenter-$distcenter)]

    if { $::orthonear_orig=="none" || $::orthonear_orig > $::bboxnear } {
        set ::orthonear_orig [expr $::bboxnear - ($::bboxfar-$::bboxnear)]
    }
    if { $::orthofar_orig=="none" || $::orthofar_orig < $::bboxfar } {
        set ::orthofar_orig [expr $::bboxfar + ($::bboxfar-$::bboxnear)]
    }

    if { $near < $::orthonear_orig } {
        #0.1 go to $near
        set ::intervalini [FormatSpinBox $near]
    } else {
        set ::intervalini [FormatSpinBox $::orthonear_orig]
    }
    if { $far > $::orthofar_orig } {
        #1.9 go to $far
        set ::intervalend [FormatSpinBox $far]
    } else {
        set ::intervalend [FormatSpinBox $::orthofar_orig]
    }
    return [list $near $far]
}

proc ClipPlanes { { w .gid.wClipPlanes } } {
    global canvas
    
    InitWindow2 $w -title [_ "Clip planes"] \
        -geometryvariable PrePostClipPlanesWindowGeom \
        -ontop
    # not using -initcommand as it causes GiD to crash when starting gid, if window remains open when quitting gid.
    # it is because it calls GiD_Process ... and gid is still not ready and 
    # GetCommandInterpreter() == NULL and GetCommandInterpreterTransparent() == NULL
    # -initcommand ClipPlanes
    if { ![winfo exists $w] } return ;

    canvas $w.dib -width 500 -height 350 -bg white -relief groove -borderwidth 4
    ttk::label $w.dibcaption -state disabled -anchor center -text [_ "Interactive draw (Stop over here for more information)"]
    GidHelp "$w.dibcaption" [_ "Drag planes to move them (Blue near, Red far)"]

    set inix 5
    set iniy 200

    set backx 137
    set backupy 102
    set backdowny 216

    set frontx 266
    set frontupy 106
    set frontdowny 281

    set radius 60

    set centerx [expr ($backx+$frontx)/2]
    set centery [expr ($backupy+$backdowny+$frontupy+$frontdowny)/4]

    $w.dib create text $inix $iniy -text "O" -anchor w

    #draw back lines
    $w.dib create line $inix $iniy [ClipPlanes_Scale $inix $backx 2.0] [ClipPlanes_Scale $iniy $backupy 2.0] -dash .
    $w.dib create line $inix $iniy [ClipPlanes_Scale $inix $backx 2.0] [ClipPlanes_Scale $iniy $backdowny 2.0] -dash .

    #draw far plane
    set ::farplane [$w.dib create polygon $backx $backupy $backx $backdowny $frontx $frontdowny $frontx $frontupy -width 2 -outline #aa0000 -fill {} -tag farplane]
    set ::scalefar 1.0

    #draw near plane
    set ::nearplane [$w.dib create polygon $backx $backupy $backx $backdowny $frontx $frontdowny $frontx $frontupy -width 2 -outline #0000aa -fill {} -tag nearplane]
    set ::scalenear 1.0

    #last thing draw front lines:
    $w.dib create line $inix $iniy [ClipPlanes_Scale $inix $frontx 2.0] [ClipPlanes_Scale $iniy $frontupy 2.0] -dash .
    $w.dib create line $inix $iniy [ClipPlanes_Scale $inix $frontx 2.0] [ClipPlanes_Scale $iniy $frontdowny 2.0] -dash .

    #sphere

    $w.dib create oval [expr $centerx-$radius] [expr $centery-$radius] [expr $centerx+$radius] [expr $centery+$radius] -fill {} -tag sphere
    $w.dib create arc [expr $centerx-$radius] [expr $centery-$radius/3] [expr $centerx+$radius] [expr $centery+$radius/3] -start 0 -extent 180 -style arc -dash . -tag sphere
    $w.dib create arc [expr $centerx-$radius] [expr $centery-$radius/3] [expr $centerx+$radius] [expr $centery+$radius/3] -start 180 -extent 180 -style arc -tag sphere
    $w.dib create arc [expr $centerx-$radius/2] [expr $centery-$radius] [expr $centerx+$radius/2] [expr $centery+$radius] -start 90 -extent 180 -style arc -dash . -tag sphere
    $w.dib create arc [expr $centerx-$radius/2] [expr $centery-$radius] [expr $centerx+$radius/2] [expr $centery+$radius] -start 270 -extent 180 -style arc -tag sphere
    #$w.dib create text $centerx $centery -anchor center -text "Model"

    #auxiliar lines
    #$w.dib create line [ClipPlanes_Scale $inix $centerx 0.1] [ClipPlanes_Scale $iniy $centery 0.1] [ClipPlanes_Scale $inix $centerx 0.1] 350 -fill #0000aa -dash .
    #$w.dib create line [ClipPlanes_Scale $inix $centerx 0.7] [ClipPlanes_Scale $iniy $centery 0.7] [ClipPlanes_Scale $inix $centerx 0.7] 350 -dash .
    #$w.dib create line [ClipPlanes_Scale $inix $centerx 1.3] [ClipPlanes_Scale $iniy $centery 1.3] [ClipPlanes_Scale $inix $centerx 1.3] 350 -dash .
    #$w.dib create line [ClipPlanes_Scale $inix $centerx 1.9] [ClipPlanes_Scale $iniy $centery 1.9] [ClipPlanes_Scale $inix $centerx 1.9] 350 -fill #aa0000 -dash .


    #-----------computing initial position------------

    OpenfromEmptyWindow $inix $iniy $centerx $centery $radius $w.dib

    #-------------------------

    grid $w.dib -row 0 -column 0 -sticky ns
    grid $w.dibcaption -row 1 -column 0 -sticky news

    ttk::labelframe $w.current -text [_ "Current clip planes"]
    ttk::label $w.current.bboxnearlabel -text [_ "Near"]:
    set ::NOrtho 0
    ttk::spinbox $w.current.bboxnear  -textvariable ::NOrtho -from $::intervalini -to $::intervalend -incr [expr ($::intervalend-$::intervalini)/100] \
        -command [list ChangeSpinboxCurrent "near" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.current.bboxnear <Return> [list ChangeSpinboxCurrent "near" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.current.bboxnear <FocusOut> [list ChangeSpinboxCurrent "near" $inix $iniy $centerx $centery $radius $w.dib]

    ttk::label $w.current.bboxfarlabel -text [_ "Far"]:

    set ::FOrtho 0
    ttk::spinbox $w.current.bboxfar  -textvariable ::FOrtho -from $::intervalini -to $::intervalend -incr [expr ($::intervalend-$::intervalini)/100] \
        -command [list ChangeSpinboxCurrent "far" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.current.bboxfar <Return> [list ChangeSpinboxCurrent "far" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.current.bboxfar <FocusOut> [list ChangeSpinboxCurrent "far" $inix $iniy $centerx $centery $radius $w.dib]

    set ::fixeddistance "no"
    ttk::checkbutton $w.current.fixed -text [_ "Move planes together"] -offvalue "no" -onvalue 100 -variable ::fixeddistance -command [list  CalculateDistancePlanes $w.current.fixed ]

    grid $w.current.bboxnearlabel -row 0 -column 0 -sticky e
    grid $w.current.bboxnear -row 0 -column 1 -sticky we
    grid $w.current.bboxfarlabel -row 0 -column 2 -sticky e
    grid $w.current.bboxfar -row 0 -column 3 -sticky we
    grid $w.current.fixed -row 0 -column 5 -sticky e
    grid columnconfigure $w.current 4 -weight 1


    grid $w.current -row 2 -column 0 -sticky news

    ttk::labelframe $w.bounds -text [_ "Clip planes bounds"]
    ttk::label $w.bounds.intervalinilabel -text [_ "Minimum near"]:
    ttk::spinbox $w.bounds.intervalini  -textvariable ::intervalini -from -999999999999 -to [expr $::bboxnear - ($::bboxfar-$::bboxnear)] -incr 100 \
        -command [list ChangeSpinboxBound "near" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.bounds.intervalini <Return> [list ChangeSpinboxBound "near" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.bounds.intervalini <FocusOut> [list ChangeSpinboxBound "near" $inix $iniy $centerx $centery $radius $w.dib]

    ttk::label $w.bounds.intervalendlabel -text [_ "Maximum far"]:
    ttk::spinbox $w.bounds.intervalend  -textvariable ::intervalend -from [expr $::bboxfar + ($::bboxfar-$::bboxnear)] -to 999999999999 -incr 100 \
        -command [list ChangeSpinboxBound "far" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.bounds.intervalend <Return> [list ChangeSpinboxBound "far" $inix $iniy $centerx $centery $radius $w.dib]
    bind $w.bounds.intervalend <FocusOut> [list ChangeSpinboxBound "far" $inix $iniy $centerx $centery $radius $w.dib]



    grid $w.bounds.intervalinilabel -row 0 -column 0 -sticky e
    grid $w.bounds.intervalini -row 0 -column 1 -sticky we
    grid $w.bounds.intervalendlabel -row 0 -column 3 -sticky e
    grid $w.bounds.intervalend -row 0 -column 4 -sticky we
    grid columnconfigure $w.bounds 2 -weight 1


    grid $w.bounds -row 3 -column 0 -sticky news

    ttk::frame $w.but -style BottomFrame.TFrame
    #ttk::button $w.but.accept -text [_ "Accept"] -command "SendClipPlaneInfo yes no" -style BottomFrame.TButton
    ttk::button $w.but.original -text [_ "Original"] -command [list ClipPlanesOriginal $inix $iniy $centerx $centery $radius $w.dib] -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command "destroy $w" -underline 0 -style BottomFrame.TButton


    #grid $w.but.accept -row 0 -column 0 -padx 5 -pady 5 -sticky e
    grid $w.but.original -row 0 -column 1 -padx 5 -pady 5 -sticky we
    grid $w.but.close -row 0 -column 2 -padx 5 -pady 5 -sticky w

    grid columnconfigure $w.but 0 -weight 1
    grid columnconfigure $w.but 2 -weight 1
    grid $w.but -row 5 -column 0 -sticky news

    grid rowconfigure $w 4 -weight 1
    grid columnconfigure $w 0 -weight 1

    set canvas(actobj) ""

    set canvas(near,obj) $::nearplane
    set canvas(far,obj) $::farplane
    set canvas(near,tagcut) "nearcut"
    set canvas(far,tagcut) "farcut"
    set canvas(near,varscale) "::scalenear"
    set canvas(far,varscale) "::scalefar"
    set canvas(near,color) "#0000aa"
    set canvas(far,color) "#aa0000"
    set canvas(near,dash) "no"
    set canvas(far,dash) "yes"


    #bind $w.dib <Button-1>  {CanvasMarkIt %x %y %W}
    bind $w.dib <Motion> [list CanvasMarkIt $inix $iniy $backx $backupy $frontx $frontdowny %x %y %W]
    bind $w.dib <Leave> {CanvasUnMarkIt %W}
    bind $w.dib <B1-Motion> [list CanvasDragIt $inix $iniy $centerx $centery $radius %x %y %W ]

    #trace add variable ::intervalini
    #::intervalend
    #::FOrtho
    SetToGid
    focus $w
}

proc FromRealToScale { var } {
    if { $var < $::bboxnear } {
        set divisor [expr $::bboxnear-$::intervalini]
        if { $divisor != "Inf" } {
            set auxvar [expr 0.1 + ($var-$::intervalini)/$divisor*0.6]
        } else {
            set auxvar 0.1
        }
    } elseif { $var < $::bboxfar } {
        set divisor [expr $::bboxfar-$::bboxnear]
        if { $divisor != "Inf" } {
            set auxvar [expr 0.7 + ($var-$::bboxnear)/$divisor*0.6]
        } else {
            set auxvar 0.7
        }
    } else {
        #$var < $::intervalend
        set divisor [expr $::intervalend-$::bboxfar]
        if { $divisor != "Inf" } {
            set auxvar [expr 1.3 + ($var-$::bboxfar)/$divisor*0.6]
        } else {
            set auxvar 1.3
        }
    }
    return $auxvar
}

proc FromScaleToReal { var } {
    if { $var < 0.7 } {
        set divisor [expr $::bboxnear-$::intervalini]
        if { $divisor != "Inf" } {
            set auxvar [expr $::intervalini+(($var-0.1)/0.6)*$divisor]
        } else {
            set auxvar $::intervalini
        }
    } elseif { $var < 1.3 } {
        set divisor [expr $::bboxfar-$::bboxnear]
        if { $divisor != "Inf" } {
            set auxvar [expr $::bboxnear+(($var-0.7)/0.6)*$divisor]
        } else {
            set auxvar $::bboxnear
        }
    } else {
        #$var < 1.9
        set divisor [expr $::bboxfar-$::bboxnear]
        if { $divisor != "Inf" } {
            set auxvar [expr $::bboxfar+(($var-1.3)/0.6)*$divisor]
        } else {
            set auxvar $::bboxfar
        }
    }
    return $auxvar
}

proc CalculateFactorsFromObjAndFactorIni { factorini obj {scalefar ""} {scalenear ""} } {
    if { $factorini < 0.1 } {
        set factorini 0.1
    } elseif { $factorini > 1.9 } {
        set factorini 1.9
    }
    if { $::fixeddistance != "no" } {
        if {  $obj == "near" } {
            set factorfar [FromRealToScale [expr [FromScaleToReal $factorini] + $::fixeddistance]]
            if { $factorfar > 1.9 } {
                set factorfar 1.9
                set factornear [FromRealToScale [expr [FromScaleToReal $factorfar] - $::fixeddistance]]
            } else {
                set factornear $factorini
            }
        } else {
            set factornear [FromRealToScale [expr [FromScaleToReal $factorini] - $::fixeddistance]]
            if { $factornear < 0.1 } {
                set factornear 0.1
                set factorfar [FromRealToScale [expr [FromScaleToReal $factornear] + $::fixeddistance]]
            } else {
                set factorfar $factorini
            }
        }
    } else {
        if {  $obj == "near" } {
            set factornear $factorini
            if { $scalefar == "" } {
                #use global value
                set scalefar $::scalefar
            }
            if { $factornear>$scalefar } {
                set factorfar $factornear
            } else {
                set factorfar "-1"
            }
        } else {
            set factorfar $factorini
            if { $scalenear == "" } {
                #use global value
                set scalenear $::scalenear
            }
            if { $scalenear>$factorfar } {
                set factornear $factorfar
            } else {
                set factornear "-1"
            }
        }
    }
    return [list $factornear $factorfar]
}

proc CanvasUnMarkIt { can } {
    $can itemconfigure $::farplane -fill {}
    $can itemconfigure $::nearplane -fill {}
    #WarnWinText "NOrtho:$::NOrtho scale:$::scalenear FOrtho:$::FOrtho scale:$::scalefar"
}

proc CanvasMarkIt { inix iniy backx backupy frontx frontdowny x y can } {
    global canvas
    #$can raise current
    set x [$can canvasx $x]
    set y [$can canvasy $y]

    if { ( $y < [expr $iniy + $x * ( $backupy - $iniy ) / ($backx - $inix ) ] ) ||
        ( $y > [expr $iniy + $x * ( $frontdowny - $iniy ) / ($frontx - $inix ) ] )  } {
        CanvasUnMarkIt $can
        set canvas(actobj) ""
        return
    }

    set bbox [$can bbox $::nearplane $::farplane]
    set middlex [expr ([lindex $bbox 0]+[lindex $bbox 2])/2]
    if { $x < $middlex } {
        $can itemconfigure $::farplane -fill {}
        $can itemconfigure $::nearplane -fill #aaaaff
        set canvas(actobj) "near"
    } else {
        $can itemconfigure $::nearplane -fill {}
        $can itemconfigure $::farplane -fill #ffaaaa
        set canvas(actobj) "far"
    }

    #set canvas($can,obj) [ $can find closest $x $y ]
    set canvas($can,x) $x
    set canvas($can,y) $y
}

proc CanvasDragIt { inix iniy centerx centery radius x y can } {
    global canvas
    # this trick is done to only execute last call of function (for each plane)
    set ::timelastcall [clock milliseconds]
    set initime $::timelastcall

    if { $initime < [set ::timelastcall] } { return }

    if { $canvas(actobj) == "" } {
        return
    }

    if { $initime < [set ::timelastcall] } { return }

    set x [$can canvasx $x]
    set y [$can canvasy $y]
    set dx [expr $x - $canvas($can,x)]
    set dy [expr $y - $canvas($can,y)]
    #$can move $canvas($can,obj) $dx $dy

    set factorini [expr  ($x-$inix)/($centerx-$inix)]
    if { $initime < [set ::timelastcall] } { return }
    set factors [CalculateFactorsFromObjAndFactorIni $factorini $canvas(actobj)]
    if { $initime < [set ::timelastcall] } { return }
    after idle [list ModifyBothPlanes $initime [lindex $factors 0] [lindex $factors 1] $inix $iniy $centerx $centery $radius $can]
}
