proc GiD_Event_InitProblemtype { dir } {
    global ProblemTypePriv
    set ::ProblemTypePriv(dir) $dir    
    Ansys::RegisterGiDEvents
    
    array set problemtype_local [GidUtils::ReadProblemtypeXml [file join $dir ansys55_plane.xml] Infoproblemtype {Name Version MinimumGiDVersion}]
    if { [GidUtils::VersionCmp $problemtype_local(MinimumGiDVersion)] < 0 } {  
        W [= "This problemtype requires GiD %s or later" $problemtype_local(MinimumGiDVersion)]
    }
    set ::ProblemTypePriv(name) $problemtype_local(Name)
    set ::ProblemTypePriv(version) $problemtype_local(Version)    
    Ansys::ChangeMenus   
}

proc GiD_Event_EndProblemtype {} {
    global ProblemTypePriv
    GiD_UnRegisterPluginAddedMenuProc Ansys::ChangeMenus
    array unset ::ProblemTypePriv
}

proc GiD_Event_EndProblemtype {} {
    global ProblemTypePriv
    GiD_UnRegisterPluginAddedMenuProc Ansys::ChangeMenus
    array unset ::ProblemTypePriv
}

proc GiD_Event_LoadModelSPD { filespd } {
    global ProblemTypePriv
    set problemtype_current [GiD_Info project ProblemType]
    if { [file tail $problemtype_current] == $::ProblemTypePriv(name) } {
        set model_problemtype_version_number [GidUtils::ReadXmlWithNameAndVersion [file rootname $filespd].xml $::ProblemTypePriv(name)]
        if { $model_problemtype_version_number != $::ProblemTypePriv(version) } {
            set must_transform 1
        } else {
            set must_transform 0
        }
        if { $must_transform } {
            GiD_Project transform_problemtype $problemtype_current
        }
    }
}

namespace eval Ansys {
}

proc Ansys::RegisterGiDEvents {} {
    GiD_RegisterPluginAddedMenuProc Ansys::ChangeMenus
}

proc Ansys::ChangeMenus {} {
    if { [GidUtils::IsTkDisabled] } {    
        return
    }
    ::GiDMenu::Create  "ANSYS" PRE -1
    ::GiDMenu::InsertOption "ANSYS" [list [= "Info"]] 0 PRE [list Ansys::Help] "" "" replace = 
    ::GiDMenu::InsertOption "ANSYS" [list [= "Read postprocess ANSYS file"]] 1 PRE [list Ansys::ConvertResultsToGiD] "" "" replace = 
    ::GiDMenu::UpdateMenus
}

proc Ansys::Help {} {
    WarnWin [join [list "The two files needed, are an output from ANSYS using commands:    "\
                "ANSYS MAIN MENU->GENERAL POSTPROC->LIST RESULT->NODAL SOLUTION    and    "\
                "ANSYS MAIN MENU->GENERAL POSTPROC->LIST RESULT->ELEMENT SOLUTION  "]]
}

#the same proc is repeated in ansys55_3d !!
proc Ansys::ConvertResultsToGiD {} {
    set fileName [Browser-ramR file read .gid {Read ANSYS}]    
    if { $fileName == "" } { return }
    
    set aa [GiD_Info Project]
    set ProjectName [lindex $aa 1]
    if { [file extension $ProjectName] == ".gid" } {
        set ProjectName [file root $ProjectName]
    }
    
    set basename [file tail $ProjectName]
    
    if { $ProjectName == "UNNAMED" } {
        tk_dialogRAM .gid.tmpwin error "Before Reading ANSYS, a project title is needed. Save project to get it" \
            error 0 OK
        return
    }
    
    set directory $ProjectName.gid
    if { [file pathtype $directory] == "relative" } {
        set directory [file join [pwd] $directory]
    }
    
    set postfile [file join $directory $basename.flavia.res]
    
    set fin [open $fileName r]
    set fout [open $postfile w]
    
    ::GidUtils::WaitState .gid
    
    while { ![eof $fin] } {
        gets $fin aa
        if { [regexp {[ ]*NODE[ ]*UX.*} $aa] } {
            while 1 {
                gets $fin aa
                if { [regexp {^[ ]*1[ ].*} $aa] } {
                    puts $fout "DISPLACEMENT      2 1 2  1  1"
                    puts $fout "X-DISP\nY-DISP\nZ-DISP"
                    
                }
                if { ![regexp {[ ]*[0-9].*} $aa] } { break }
                puts $fout $aa
            }
        } elseif { [regexp {[ ]*NODE[ ]*SX.*} $aa] } {
            while 1 {
                gets $fin aa
                if { [regexp {^[ ]*1[ ].*} $aa] } {
                    puts $fout "NODAL STRESS      2  1 3 1  1"
                    puts $fout "Sx\nSy\nSz\nSxy\nSxz\nSyz"
                }
                if { ![regexp {[ ]*[0-9].*} $aa] } { break }
                puts $fout $aa
            }
        }
    }
    
    close $fin
    close $fout
    ::GidUtils::EndWaitState .gid
    WarnWin "ANSYS file read"
}
