#################################################
#      GiD-Tcl procedures invoked by GiD        #
#################################################
proc GiD_Event_InitProblemtype { dir } {
    package require gid_draw_opengl
    GidUtils::OpenWindow CUSTOMLIB
}

proc GiD_Event_EndProblemtype {} {
    GidUtils::CloseWindow CUSTOMLIB
}

namespace eval ConditionSymbols {

}

proc ConditionSymbols::draw_selfweight { values_list } {
    foreach item $values_list {
        lassign $item key value unit
        set data($key) $value
        #set unit($key) $unit
    }
    set modulus $data(modulus)
    set direction [split $data(direction) ,]
    set opposite_direction [math::linearalgebra::scale_vect -1.0 $direction]
    set full_filename [file join [gid_filesystem::get_folder_standard scripts] gid_draw_opengl symbols selfweight.msh]
    set color_lines black
    set color_surfaces blue
    set list_id [gid_draw_opengl::create_opengl_list_from_file_mesh_oriented_z_direction $full_filename $color_lines $color_surfaces $opposite_direction]
    return $list_id
}

# in this case the XML declare orientation="loads" and then the proc must return a dictionary with keys load_type and load_vector
# the real draw will be  made native inside GiD based on this dict values
# but to work well by now it is necessary to assign to surfaces the surface_Local_axes, else is drawn with wrong direction (eulerangles==NULL)
proc ConditionSymbols::draw_loads_surface_pressure { values_list } {
    foreach item $values_list {
        lassign $item key value unit
        set data($key) $value
        #set unit($key) $unit
    }
    set modulus $data(value)    
    if { $modulus > 0 } {
        set load_local_direction [list 0 0 -1] ;#considered positive pointing oposite to local normal
    } elseif { $modulus < 0 } {
        set load_local_direction [list 0 0 1] ;#considered positive pointing oposite to local normal
    } else {
        #the value could be set by other function field, intead as modulus, consider like positive modulus
        set load_local_direction [list 0 0 -1]
    }
    set dictionary [dict create load_type local load_vector $load_local_direction]    
    return $dictionary
}

#procedure that draw a square to represent the Weight condition
proc ConditionSymbols::DrawSymbolWeigth { values_list } {
    variable _opengl_draw_list
    if { ![info exists _opengl_draw_list(weight)] } {
        set _opengl_draw_list(weight) [GiD_OpenGL draw -genlists 1]
        GiD_OpenGL draw -newlist $_opengl_draw_list(weight) compile
        set filename_mesh [file join [Cmas2d::GetDir] symbols weight_2d.msh]
        gid_groups_conds::import_gid_mesh_as_openGL $filename_mesh black blue
        GiD_OpenGL draw -endlist
    }
    set weigth_and_unit [lrange [lindex $values_list [lsearch -index 0 $values_list Weight]] 1 2]
    set weigth [lindex $weigth_and_unit 0]
    set scale [expr {$weigth*0.1}]
    set transform_matrix [list $scale 0 0 0 0 $scale 0 0 0 0 $scale 0 0 0 0 1]
    set list_id [GiD_OpenGL draw -genlists 1]
    GiD_OpenGL draw -newlist $list_id compile
    GiD_OpenGL draw -pushmatrix -multmatrix $transform_matrix
    GiD_OpenGL draw -call $_opengl_draw_list(weight)
    GiD_OpenGL draw -popmatrix
    GiD_OpenGL draw -endlist
    return $list_id
}
