# unitcheker.tcl --
#
#        Este fichero implementa el codigo Tcl para controlar el
#        conjunto de unidades referenciados en el ProblemType.
#
#
# Copyright (c) 2000 CIMNE
#

namespace eval UnitChecker {
    namespace export Start CheckField Done GetMagsUsed GetUnitsUndefined
    
    variable MagsUsed       {}
    variable UnitsUndefined {}
}

proc UnitChecker::Start {} {
    variable MagsUsed       {}
    variable UnitsUndefined {}
}

proc UnitChecker::CheckField { field } {
    variable MagsUsed
    variable UnitsUndefined
    
    ParserNumberUnit $field Value Unit
    if { $Unit != "" } {
        ParserUnit::Init $Unit
        ParserUnit::Start
        if { $ParserUnit::Status == "END" } {
            set MagInfo [FindUnitGidAndPrj $ParserUnit::Numerator $ParserUnit::Denominator]
            if ![llength $MagInfo] {
                set N [lsort $ParserUnit::Numerator]
                set D [lsort $ParserUnit::Denominator]
                foreach e $UnitsUndefined {
                    if { ![string compare $N [lindex $e 1]] && ![string compare $D [lindex $e 2]] } {
                        return
                    }
                }
                lappend UnitsUndefined [list $Unit $N $D]
                return
            }
            set m [lindex $MagInfo 0]
            set mfound 0
            foreach e $MagsUsed {
                if ![string compare $e $m] {
                    set mfound 1
                    break
                }
            }
            if !$mfound {
                lappend MagsUsed $m
            }
        }
    }
}

proc UnitChecker::Done { } {
    global GidData
    
    variable MagsUsed       {}
    variable UnitsUndefined
    
    if [llength $UnitsUndefined] {
        set str ""
        foreach e $UnitsUndefined {
            append str "[lindex $e 0] "
        }
        GidUtils::SetWarnLine [_ "The following units are not defined: %s and will not be converted during calculation. You should define it inside the problem type" $str]
    }
    set UnitsUndefined {}
}

proc UnitChecker::GetMagsUsed {} {
    variable MagsUsed
    
    return $MagsUsed
}

proc UnitChecker::GetUnitsUndefined {} {
    variable UnitsUndefined
    
    return $UnitsUndefined
}
