

proc test_GiD_MeshData { } {
    set fail 0
    #create a cylinder
    DoFilesNew
    GiD_Process Mescape Geometry Create Object Cylinder 0.0,0.0,0.0 0.0,0.0,1.0 0.5 3 escape

    #test assign mesh to the whole model by chordal error
    set num_assigned [GiD_MeshData size_by_chordal_error 0.001 10.0 0.05]
    if { $num_assigned != 12 || [expr abs([GidUtils::GetMeshData line 5 size]-0.423622)] > 1e-7 } {
        incr fail
    }

    #test assign mesh size to lines
    set num_assigned [GiD_MeshData size lines 0.1 {3 4 5 6}]
    if { $num_assigned != 4 || [GidUtils::GetMeshData line 3 size] !=0.1 } {
        incr fail
    }


    #test assign an specific mesher to some entities
    set num_assigned [GiD_MeshData mesher surfaces rsurf {1 2}]
    if { $num_assigned != 2 || [GidUtils::GetMeshData surface 1 Mesher] != 2 } {
        #2==rsurf
        incr fail
    }
    #test reset default mesher to some entities
    set num_assigned [GiD_MeshData mesher surfaces default {1 2}]
    if { $num_assigned != 2 || [GidUtils::GetMeshData surface 1 Mesher] != "" } {
        #""==default
        incr fail
    }

    #test set tops as quadrilateral
    set num_assigned [GiD_MeshData element_type surfaces quadrilateral {3 4}]
    if { $num_assigned != 2 || [GidUtils::GetMeshData surface 3 Elemtype] != 3 } {
        #3==quadrilateral
        incr fail
    }

    #test set volume as hexahedra
    set num_assigned [GiD_MeshData element_type volumes hexahedra {1}]
    if { $num_assigned != 1 || [GidUtils::GetMeshData volume 1 Elemtype] != 5 } {
        #5==hexahedra
        incr fail
    }

    #to mesh the cylinder with hexahedra, must be set as semi-structured
    set num_assigned [GiD_MeshData semi_structured 3 {1}]
    if { $num_assigned != 1 || [GidUtils::GetMeshData volume 1 IsStructured] != 1 || [GidUtils::GetMeshData volume 1 num_divisions] !=3} {
        #IsStructured==1, size==num divisions
        incr fail
    }

    #test set semi-structured direction (it is not compulsory in the cylinder, because only a direction is possible)
    set num_assigned [GiD_MeshData semi_structured structured_directions {1}]
    lassign [split [string range [GidUtils::GetMeshData volume 1 tops] 1 end-1] ,] s1 s2
    if { $num_assigned != 1 || [expr $s1+$s2] != 7 } {
        #(4,3) -> tops are surfaces 4 and 3
        incr fail
    }

    #test set master surface (again is not compulsory)
    set num_assigned [GiD_MeshData semi_structured master_surfaces {3}]
    lassign [split [string range [GidUtils::GetMeshData volume 1 tops] 1 end-1] ,] s1 s2
    if { $num_assigned != 1 || ($s1 != -3 && $s2 != -3) } {
        #(-3,4) -> tops are surfaces 3 and 4, and 3 is the master
        incr fail
    }

    #do a test of generate a mesh
    GiD_Process Mescape Meshing Generate DefaultSize escape
    if { [llength [GiD_Mesh list -element_type {hexahedra} element]] < 100 } {
        incr fail
    }

    #to test resent all mesh data
    GiD_MeshData reset
    #do a test of generate a mesh
    GiD_Process Mescape Meshing Generate Yes DefaultSize escape
    if { [llength [GiD_Mesh list -element_type {tetrahedra} element]] < 100 } {
        incr fail
    }

    #test set mesh/no mesh
    set num_assigned [GiD_MeshData mesh_criteria to_be_meshed 1 volumes {1}] ;#1==no
    set num_assigned [GiD_MeshData mesh_criteria to_be_meshed 2 surfaces {1 2}] ;#2==YES
    #do a test of generate a mesh
    GiD_Process Mescape Meshing Generate Yes DefaultSize escape
    if { [llength [GiD_Mesh list -element_type {tetrahedra} element]] != 0 || [llength [GiD_Mesh list -element_type {triangle} element]]  < 10 } {
        incr fail
    }

    #test set strucutured surfaces
    set num_assigned [GiD_MeshData structured surfaces {1 2} num_divisions 3 {3 5}]
    set num_assigned [GiD_MeshData structured surfaces {1 2} num_divisions 2 {1 2}]
    #do a test of generate a mesh
    GiD_Process Mescape Meshing Generate Yes DefaultSize escape
    if { [llength [GiD_Mesh list -element_type {triangle} element]] != 24 } {
        incr fail
    }

    #test boundary layer
    GiD_MeshData reset
    set num_assigned [GiD_MeshData boundary_layer assign surfaces {1} {3 0.01} {1 2}]
    #do a test of generate a mesh
    GiD_Process Mescape Meshing Generate Yes DefaultSize escape
    if { [llength [GiD_Mesh list -element_type {tetrahedra} element]] < 10000 } {
        incr fail
    }

    #test force point
    GiD_Geometry create point append Layer0 0 0 3.0
    GiD_MeshData reset
    set num_assigned [GiD_MeshData mesh_criteria force_points {surfaces {4}} points {5}]
    #do a test of generate a mesh
    GiD_Process Mescape Meshing Generate Yes DefaultSize escape
    if { [llength [GiD_Mesh list -higherentity 0 node]] != 0 } {
        incr fail
    }

    return $fail
}
