#-*- mode: Tcl; tcl-indent-level :  4 -*-

set ::CUSTOM_LIB_USE_NATIVE_GROUPS 1
set ::CUSTOM_LIB_USE_NATIVE_GROUPS_DRAW_NATIVE 1
set ::CUSTOM_LIB_WINDOW_VALUES_SCROLLED 0 ; # 1 to add automatically scrolling, but secondary effects can appear 
set ::CUSTOM_LIB_WINDOW_TOPLEVEL 0 ; # 1 to open in external window
set ::CUSTOMLIB_USE_GRAPHS_PLOTCHART 1
set ::CUSTOM_LIB_FORBID_CONDITION_GROUPNAME_REPEATED 0
set ::MENUS_DYNAMIC_ENABLE_CACHE 1
set ::MSGCAT_GID 1
set ::GidPriv(VerticalRoundBars) 1
set ::GidPriv(GiDRuedas) 1 ;#deprecated, but not remove it because some old problemtype ask for this variable!

#what: all menus menu_data procs
proc CacheReset { what } {    
    global GidPriv
    global MenuPrevState
    global GidCache
    if { $what== "menus" || $what== "all" } {
        #to clear cache that prevent re-create some menus
        array unset ::MenuPrevState
        #to clear cache different trick for this menu
        set ::GidPriv(POSTDATA) 1 
    }
    if { $what== "menu_data" || $what== "all" } {
        #to clear cache different trick for this menu
        set ::GidPriv(POSTDATA) 1 
    }
    if { $what== "procs" || $what== "all" } {
        #to clear cache of some slow procs
        array unset ::GidCache
    }
    return 0
}

proc GetDisplayStyleImagesAndCommands { } { 
    set display_style_images "boundaries.png hiddenbound.png alllines.png hiddenlines.png body.png bodybound.png bodylines.png point.png pointsbound.png"
    set display_style_commands "Boundaries Hidden_Bound All_Lines Hidden_Lines Body Body_Bound Body_Lines Points Points_Bound"
    return [list $display_style_images $display_style_commands]
}

proc GetToolbarWidgetName { x } {
    #ugly do it hardcoded, but...
    set w ""
    if { $x == "DisplayStyle" } {
      set w .gid.bitmaps.5
    } elseif { $x == "Culling" } {
      set w .gid.bitmaps.6
    }
    return $w
}

#OnSetXXX invoked from C++ when GiD_Set

proc OnSetBarButtonLook { value } {
    ChangeTopMenusAndWindows
}

proc OnSetCulling { index } {
    set button [GetToolbarWidgetName Culling]
    if { ![GidUtils::IsTkDisabled] && [GetCurrentPrePostMode] == "POST" } {
        if { [winfo exists $button] } {
            set cullstylelist [list none frontfaces backfaces]
            set image_name cull[lindex $cullstylelist $index].png
            $button configure -image [gid_themes::GetImage $image_name medium_icons]
        }
        GidUtils::UpdateWindow SETS
    }
}

#invoked from C++ when GiD_Set and from tclfile-opengl
proc OnSetCurrentTheme { theme_name } {
    set update_gui 1

    if { [ GiD_Set Theme(UseOSStyle)]} {
        if { [ esMac ] } {
            set mac_theme [ getMacOSInterfaceStyle]
            # if mac theme is dark, use gid dark theme
            # use light otherwise
            if { $mac_theme == "Dark"} {
                set theme_name GiD_black
            } else {
                set theme_name GiD_light_plus           ;# vectorial
                # set theme_name GiD_classic_renewed    ;# "GiD Light" (bitmap)
                # set theme_name GiD_white_vectorial
            }
        }
    }
    catch {
        gid_themes::SetCurrentTheme $theme_name $update_gui
    }
}

proc OnSetDisplayStyle { style } {
    set button [GetToolbarWidgetName DisplayStyle]
    if { ![GidUtils::IsTkDisabled] && [GetCurrentPrePostMode] == "POST" } {
        if { [winfo exists $button] } {
            lassign [GetDisplayStyleImagesAndCommands] display_style_images display_style_commands
            set index [lsearch $display_style_commands $style]
            if { $index != -1 } {
                set image_name [lindex $display_style_images $index]
                $button configure -image [gid_themes::GetImage $image_name medium_icons]
            }
        }
        GidUtils::UpdateWindow SETS
    }
}


proc OnSetMainDeformationFactor { factor } {
    if { ![info exists ::GidPriv(PostAnimateDoing)] || $::GidPriv(PostAnimateDoing) == "Nothing"} {
        set ::SingleStepAnimation(deformation_factor) $factor
    }
    namespace eval PostGeom {
    }
    set PostGeom::_MallaPrincipal(factor) $factor
    # this is unneded because the scale of the toolbar is opened and closed in each use
    #set w_scale .wPostDefScale.f.defScale
    #if { [winfo exists $w_scale] } {
    #    $w_scale set $factor
    #}
}


proc OnSetOutMaxColor { value } {

}


proc OnSetOutMinColor { value } {
    
}

proc OnSetPostResOverRes { value } {
   FillPVariosResultsInfo
}

proc OnSetSoftwareOpenGL { value } {
    UpdateOpenGLIcons
}


proc OnSetThemeSize { ThemeSize } {
    GUI_Update
}

proc OnSetThemeHighResolutionScaleFactor { factor } {
    GUI_Update
}

proc OnSetThemeHighResolutionFontScaleFactor { factor } {
    GUI_Update
}

proc OnSetThemeMenuType { type } {
    GUI_UpdateMenus
}

proc OnSetTooltipPopup { value } {
    ChangeTopMenusAndWindows
}

proc IconTextConfigureLook { w img text } {
    #w its a ttk button or ttk menubutton   
    if { [GiD_Set BarButtonLook] == "Icon" } {
        $w configure -image $img -compound none       
    } elseif { [GiD_Set BarButtonLook] == "Text" } {
        $w configure -text " $text " -image "" -compound top      
    } elseif { [GiD_Set BarButtonLook] == "IconText" } {
        $w configure -image $img -text " $text " -compound top
    }
}

proc IconTextAdjustText { w } {
    set comp_mode ""
    catch { 
        set comp_mode [ $w cget -compound]
    }
    if { $comp_mode == "top" || $comp_mode == "left" } {
        $w configure -compound left
        if { [GiD_Set BarButtonLook] == "Text" } {
            $w configure -height 1 -width [ string length [ $w cget -text]]
        }
    }
}

proc IconTextOrTextGetWidth { w } {    
    set comp_mode ""
    catch { set comp_mode [ $w cget -compound] }
    set width 0
    if { ( $comp_mode == "top") || ( $comp_mode == "left")} {
        if { [GiD_Set BarButtonLook] == "IconText" } {
            #in ttk width=number of characters
            set width [string length [ $w cget -text]]
        } elseif { [GiD_Set BarButtonLook] == "Text" } {
            set width [string length [ $w cget -text]]
        }
    }
    return $width
}

proc IconTextAdjustPads { w } {    
    set comp_mode ""
    catch { set comp_mode [ $w cget -compound] }   
    if { ( $comp_mode == "top") || ( $comp_mode == "left")} {
        if { [GiD_Set BarButtonLook] == "Text" } {
            grid configure $w -padx 4 -pady 2           
        }
    }
}

if { $::MSGCAT_GID } {
    # forzamos el autoload de msgcat
    msgcat::mc ""

    # ahora sobreescribimos el procedimiento mcunknown
    proc msgcat::mcunknown {locale src args} {
        # para encontrar en la fase de desarrollo cadenas por traducir
        # Retornamos el string con la primera letra en minuscula y el resto en mayusculas
        # Evitamos modificar los argumentos al printf para evitar errores
        if {[llength $args]} {
            set src [eval [ list format $src] $args]
        }
        return $src        
    }
}

proc GidTkBackCompatibility {} {
    #tcl/tk 8.4 hide private tk[a-Z]* procedures
    set comms { tkSaveGrabInfo tkButtonInvoke tkTextSelectTo tkEntryInsert tkEntryBackspace \
                    tk_textCut tk_textCopy tk_textPaste tk_focusNext tk_focusPrev tkTextClosestGap \
                    tkTextAutoScan tkCancelRepeat tkTextInsert tkTabToWindow \
                    tkGenerateMenuSelect tk_popup tk_menuSetFocus tkMbPost }
    set hay_expose [ info commands tk::unsupported::ExposePrivateCommand]
    foreach i $comms {
        auto_load $i
        if { ![llength [info commands $i]] && $hay_expose != "" } {
            tk::unsupported::ExposePrivateCommand $i
        }
    }
    set vars { tkPriv }
    foreach i $vars {
        ::tk::unsupported::ExposePrivateVariable $i
    }
}

set err [catch { package present Tk }]
if { !$err } {
    GidTkBackCompatibility
}

#avoid wrong menu images with Windows animation effects
if { $::tcl_platform(platform) == "windows" } {
    proc GiD_PopupMenu {menu x y} {
        # temporarily disable menu animations because they trigger a bug in
        # Tk causing menu images to be incorrectly displayed
        set enabled [ GiD_SetMenuAnimation]
        if {$enabled} {
            GiD_SetMenuAnimation 0
        }
        tk_popup $menu $x $y
        if {$enabled} {
            GiD_SetMenuAnimation $enabled
        }
    }
} else {
    proc GiD_PopupMenu {menu x y} {
        tk_popup $menu $x $y
    }
}

# redefine ttk::menubutton::PostPosition from package ttk 0.8.6 
# to support multiple monitors 
# so that the menu's of the menubuttons are openned in the second screen
namespace eval ttk {
    namespace eval menubutton {
    }
}

proc ttk::menubutton::PostPosition {mb menu} {
    set x [winfo rootx $mb]
    set y [winfo rooty $mb]
    set dir [$mb cget -direction]
    set bw [winfo width $mb]
    set bh [winfo height $mb]
    set mw [winfo reqwidth $menu]
    set mh [winfo reqheight $menu]
    # set sw [expr {[winfo screenwidth  $menu] - $bw - $mw}]
    # set sh [expr {[winfo screenheight $menu] - $bh - $mh}]    
    # when working with multiple monitors, we need to use vrootwidth and vroot height
    set sw [expr {[winfo vrootwidth  $menu] - $bw - $mw}]
    set sh [expr {[winfo vrootheight $menu] - $bh - $mh}]
    switch -- $dir {
        above { if {$y >= $mh} { incr y -$mh } { incr y  $bh } }
        below { if {$y <= $sh} { incr y  $bh } { incr y -$mh } }
        left  { if {$x >= $mw} { incr x -$mw } { incr x  $bw } }
        right { if {$x <= $sw} { incr x  $bw } { incr x -$mw } }
        flush { 
            # post menu atop menubutton.
            # If there's a menu entry whose label matches the
            # menubutton -text, assume this is an optionmenu
            # and place that entry over the menubutton.
            set index [FindMenuEntry $menu [$mb cget -text]]
            if {$index ne ""} {
                incr y -[$menu yposition $index]
            }
        }
    }
    return [list $x $y]
}

# ( may be ) redefining buttonpress-1 and buttonrelease-1
if { 0 } {
    # kike: 0 para anularlo porque la prueba no mola nada, molesta mucho para crear rectangulo, borrar, etc. pulsas el boton y no hace nada
    # de hecho pensaba al principio que era un error, hay que pulsar 3 segundos cada vez
    if { ![GidUtils::IsTkDisabled] } {
        if {[tk windowingsystem] eq "x11"} {
            ## original values:
            ## bind TMenubutton <ButtonPress-1>          { ttk::menubutton::Pulldown %W }
            ## bind TMenubutton <ButtonRelease-1>        { ttk::menubutton::TransferGrab %W }
            ## bind TMenubutton <B1-Leave>         { ttk::menubutton::TransferGrab %W }
            bind TMenubutton <ButtonPress-1>  \
            { ttk::menubutton::ButtonPress-1 %W }
            bind TMenubutton <ButtonRelease-1>  \
            { ttk::menubutton::ButtonRelease-1 %W }
            bind TMenubutton <B1-Leave>           \
            { ttk::menubutton::ButtonRelease-1 %W }
        } else {
            ## original values:
            ## bind TMenubutton <ButtonPress-1>  \
            ##     { %W state pressed ; ttk::menubutton::Popdown %W }
            ## bind TMenubutton <ButtonRelease-1>  \
            ##     { %W state !pressed}
            bind TMenubutton <ButtonPress-1>  \
            { ttk::menubutton::ButtonPress-1 %W }
            bind TMenubutton <ButtonRelease-1>  \
            { ttk::menubutton::ButtonRelease-1 %W }
        }
    }

    proc ttk::menubutton::DoButtonPress-1 { mb } {
        if { [ info exists ::TMenubutton($mb,afterId)]} {
            unset ::TMenubutton($mb,afterId)
        }
        if {[tk windowingsystem] eq "x11"} {
            ttk::menubutton::Pulldown $mb
        } else {
            $mb state pressed
            ttk::menubutton::Popdown $mb
        }
    }

    proc ttk::menubutton::ButtonPress-1 { mb } {
        # only if menu has an associated command do (and only has icons):
        # invoke command on index 0 
        # and delay menu post
        if {[$mb instate disabled] || [set menu [$mb cget -menu]] eq ""} {
        return
        }
        set def_entry_index 0
        if { [ $menu entrycget $def_entry_index -command] != ""} {
            # do delay post only on icon menubuttons (without text)
            if { ( [ $mb cget -text] == "" ) && ( [ $mb cget -textvariable] == "" )} {
                set ::TMenubutton($mb,afterId) [ after 200 "ttk::menubutton::DoButtonPress-1 $mb"] 
                $menu invoke $def_entry_index
            } else {
                ttk::menubutton::DoButtonPress-1 $mb
            }
        } else {
            ttk::menubutton::DoButtonPress-1 $mb
        }
    }

    proc ttk::menubutton::ButtonRelease-1 { mb } {
        if { [ info exists ::TMenubutton($mb,afterId)]} {
            catch { after cancel $::TMenubutton($mb,afterId)}
        } else {
            if {[tk windowingsystem] eq "x11"} {
                ttk::menubutton::TransferGrab $mb
            } else {
                $mb state !pressed
            }
        } 
    }

}



proc .central.s { args } {
    return [eval .gid.central.s $args]
}

proc IsValidWmGeometry { newgeometry } {
    return [regexp {^([0-9]+x[0-9]+)?([+-][0-9]+[+-][0-9]+)?$} $newgeometry]
}


proc GetGidMacrosFilename { create_folders } {  
    set alternative_macros_filename [GiD_GetFlag "-m"]
    if { $alternative_macros_filename != "" } {
        if { [file pathtype alternative_macros_filename] == "absolute" } {
            set macros_filename $alternative_macros_filename
        } else {
            set macros_filename [file join [file dirname [GiD_GetUserSettingsFilename]] $alternative_macros_filename]
        }
    } else {
        set macros_filename [file join [file dirname [GiD_GetUserSettingsFilename]] gid_macros.tcl]
    }
    if { $create_folders } {
        set dir_name [file dirname $macros_filename]
        if { ![file exists $dir_name] || ![file isdirectory $dir_name] } {
            file mkdir $dir_name
        }
    }
    return $macros_filename
}

proc GetGidMacrosDefaultsFilename { } {
    return [file join $::GIDDEFAULT scripts toolbarmacros_defaults.tcl]
}

# instead of doing when the file is sourced, now these 2 images are created at the end of tclfil-opengl.tcl
proc LoadMenuVerifImages { } {
    global GidPriv
    
    set err [catch { package present Tk }]
    if { !$err } {
        package require Img
        
        if { ![ info exists GidPriv(VerifImage)]} {
            #set GidPriv(VerifImage) [ gid_themes::GetImage oK.png small_icons]
            set GidPriv(VerifImage) [ image create photo -data {
                iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABGdBTUEAAYagMeiWXwAAAmpJ
                REFUOI1jYEAGEXVrPjAwMDAwaAZOaGDACkzip99lYGBgYLArWvNXPXjKJQwVigFTguEcj7wl
                1xkYGBiYxPW6FRgY/jPff/GOkYGBgYFBzHmi3bSN5/9htwYKRO2nKLUtPfhXwrbTAkNS3KrP
                unzOnn9SzpNNGRgYGBgZ7Ot5Il1M3r57+WHb1Rtvdzh5qM3YuP+B4cetWRdQdAq7TnY3SZn/
                UdiqUxWv/RA/TBS1SZ6xi4EhlJMFm7yXuvDGX3/+SDIwrP7OhC7Jbz9f19pc1uLajc9hWE0P
                KF3+VD962i0Yn4mBoZ6HwXgmPwMDA4OM50xfAQk+ybevv0fCdSj5TGzuWXnqF7/3NIPIxvXf
                VEMmX0U2keXelnfNszlO+cR5ap599eU306vXfyKQFUAigKGeTStM4vjf3/9e3Fyf7Y1FATGg
                ns0oVjrCTEd8wvvv39jPnn5ec2erzAyMYMAOVnGaRMjmu1rJzfrN8I/39Nk3M+/c/7iQgSHs
                O2EXGM/kN1L9U+tgp5z/7M1nhpPHX/Tff8XWynA2/SMDAwMD1piCA4+JokYC/3rdnTWiT157
                +vf+jbfd919xdcE0Qw0I5VRwsw9SUObL5WZjPn/qwvvu1wdzHkoa10uJC7LPcnfRdN989Oaf
                D0+/tj55wzUBWTMDAyQQmfmsJuob6PLNEpMWM1AS4/5/7frTs+8/fxe2tlZX3nXs1u+3z740
                P/72bgLDwcYv6I5ECoN6NmFrLgcxaZ4+WRVpLX1VScb9x67/fP34fc3D7x9mYNOMZgDCIEFn
                VjU+Ng7Zb1+Zb78+VHCfgYHxL65gAgAfTeU4YgmgfwAAAABJRU5ErkJggg==
            } -format png]
        }
        if { $::tcl_platform(os) == "Darwin" } {
            #Some MACs suport transparency so beter disabled
            #Mac do not support parcial tranparency, not optimal solution, but better than nothing
            set bg_color "#f0f0f0"
            if { [ info exists ::ttk::theme::[::gid_themes::GetTtkTheme]::colors(-toolbars_bg)]} {
                set bg_color [ set ::ttk::theme::[::gid_themes::GetTtkTheme]::colors(-toolbars_bg) ]
            }
            SetBackgroundToAlphaPixels $GidPriv(VerifImage) $bg_color
        }
        
        if { ![ info exists GidPriv(VerifNoImage)]} {
            #set GidPriv(VerifNoImage) [ gid_themes::GetImage blank.png small_icons]
            set GidPriv(VerifNoImage) [ image create photo -data {
                iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABGdBTUEAAYagMeiWXwAAADhJ
                REFUOI1j/P//PwMDAwMDEwMUMOIWgQEmBjRAWAVhAQwzCOqgvoLB4IbBoIBgOFBsw6gBQ8EA
                ABlgFSH9bX7LAAAAAElFTkSuQmCC
            } -format png]
        }
        if { $::tcl_platform(os) == "Darwin" } {
            #Some MACs suport transparency so beter disabled
            #Mac do not support parcial tranparency, not optimal solution, but better than nothing
            set bg_color "#f0f0f0"
            if { [ info exists ::ttk::theme::[::gid_themes::GetTtkTheme]::colors(-toolbars_bg)]} {
                set bg_color [ set ::ttk::theme::[::gid_themes::GetTtkTheme]::colors(-toolbars_bg) ]
            }
            SetBackgroundToAlphaPixels $GidPriv(VerifNoImage) $bg_color
        }
    }
}


# GiDTBLayout -- Data Structure
#  INSIDE,CURRENT : PRE | POST | {}
#  INSIDE,INI : names from ini file
#  INSIDE,PRE : last order of toolbars in PRE, initially it's empty
#  INSISE,POST : last order of toolbars in POST, initially it's empty
#  .gid.$frame : the list of toolbars gridded in order
#
# where must be PRE or POST
proc SetGiDTBLayout { where } {
    set current $::GiDTBLayout(INSIDE,CURRENT)
    if {$current eq ""} {
        set ::GiDTBLayout(INSIDE,PRE) $::GiDTBLayout(INSIDE,INI)
        set ::GiDTBLayout(INSIDE,POST) $::GiDTBLayout(INSIDE,INI)
    } else {
        # save current status
        set ::GiDTBLayout(INSIDE,$current) {}
        foreach f {top left right bottom} {
            foreach tb $::GiDTBLayout(.gid.$f) {
                lappend ::GiDTBLayout(INSIDE,$current) $::GiDTBLayout(tb,$tb)
                destroy $tb
            }
            set ::GiDTBLayout(.gid.$f) {}
            grid remove .gid.$f
        }
    }
    set ::GiDTBLayout(INSIDE,CURRENT) $where
}

#
# what can be: PRE or POST
#

proc OpenOutsideWindows { what } {
    global GidPriv
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    if { [winfo exists .gid.central.s] && ([GiD_Project set disable_windows] || [GiD_Set UseMoreWindows] == 0) } {
        return
    }
    
    set visited {}

    SetGiDTBLayout $what

    # create the INSIDE windows just in the order they where read from ini or saved   
    set tb_errors {}
    foreach geomname $::GiDTBLayout(INSIDE,$what) {
        lappend visited $geomname
        if { [info exists ::GidPriv($geomname)] } {
            set command [lindex $::GidPriv($geomname) 3]
            if {[catch { {*}$command } msg]} {
                lappend ::tb_errors $msg
                # remove that entry GidPriv and ::GiDTBLayout
                set ::GidPriv($geomname) [lindex $::GidPriv($geomname) 0]
            }
        }
    }
    
    foreach {geomname val} [array get GidPriv PrePost*WindowGeom] {
        if { $geomname == "PrePostTopMenuWindowGeom" } continue
        if {[lsearch $visited $geomname] != -1} continue
        lappend visited $geomname
        if { [lindex $val 0] == "OPEN" || [string match INSIDE* [lindex $val 0]] } {
            #check if the widget exists and then not re-create it when swapping pre <-> post
            regsub {Geom$} $geomname {} geomwinname
            if { [info exists GidPriv($geomwinname)] && [winfo exists $GidPriv($geomwinname)] } {
                set recreate 0
            } else {
                set recreate 1
            }
            if { $recreate } {
                set command [lindex $val 3]
                if { [lindex $command 0] == "GiDHelpViewer::Show" } {
                    #dark trick, otherwise the proc GiDHelpViewer::Show won't be sourced
                    package require gid_helpviewer
                }
                if {[catch { {*}$command } msg]} {
                    lappend tb_errors "$geomname \n\t $msg"
                }
            }
        }
    }
    
    if { $what == "PRE" } {
        # first close all POST windows
        foreach {geomname val} [array get GidPriv *WindowGeom] {
            if { $geomname == "PrePostTopMenuWindowGeom" } continue
            if {[lsearch $visited $geomname] != -1} continue
            if { [string match PrePost* $geomname] } {
                continue
            } elseif { [string match Post* $geomname] } {
                set aa [lindex $val 0]
                if { $geomname == "PostDisplayWindowGeom" } {
                    if { $aa == "OPEN" } {
                        set prev $GidPriv($geomname)
                        GidUtils::CloseWindow SETS
                        set GidPriv($geomname) $prev ;#to restore when changing to pre
                    }
                } else {
                    set wname [string range $geomname 0 end-4] ;#named removing last "Geom"
                    if { [info exists GidPriv($wname)] && [winfo exists $GidPriv($wname)] } {
                        destroy $GidPriv($wname)
                    }
                }
                set GidPriv($geomname) [list $aa {*}[lrange $val 1 end]]
            }
        }
        
        # then open PRE windows
        foreach {geomname val} [array get GidPriv *WindowGeom] {
            if { $geomname == "PrePostTopMenuWindowGeom" } continue
            if {[lsearch $visited $geomname] != -1} continue            
            if { [string match PrePost* $geomname] } {
                continue
            }  elseif { [string match Pre* $geomname] && ([lindex $val 0] == "OPEN" || [string match INSIDE* [lindex $val 0]])} {
                set command [lindex $val 3]
                if {[catch { {*}$command } msg]} {
                    lappend tb_errors "$geomname \n\t $msg"
                }
            }
        }
    } elseif { $what == "POST" } {
        # first close all PRE windows
        foreach {geomname val} [array get GidPriv *WindowGeom] {
            if { $geomname == "PrePostTopMenuWindowGeom" } continue
            if {[lsearch $visited $geomname] != -1} continue            
            if { [string match PrePost* $geomname] } {
                continue
            } elseif { [string match Pre* $geomname] } {
                set aa [lindex $val 0]
                if { $geomname == "PreLayersWindowGeom" } {
                    if { $aa == "OPEN" } {
                        set prev $GidPriv($geomname)
                        GidUtils::CloseWindow LAYER
                        set GidPriv($geomname) $prev ;#to restore when changing to pre
                    }
                } else {
                    set wname [string range $geomname 0 end-4] ;#named removing last "Geom"
                    if { [info exists GidPriv($wname)] && [winfo exists $GidPriv($wname)] } {
                        destroy $GidPriv($wname)
                    }
                }
                set GidPriv($geomname) [list $aa {*}[lrange $val 1 end]]
            }
        }
        
        # then open POST windows
        foreach {geomname val} [array get GidPriv *WindowGeom] {
            if { $geomname == "PrePostTopMenuWindowGeom" } continue
            if {[lsearch $visited $geomname] != -1} continue            
            if { [string match PrePost* $geomname] } {
                continue
            }  elseif { [string match Post* $geomname] && [lindex $val 0] == "OPEN"  || [string match INSIDE* [lindex $val 0]]} { 
                set command [lindex $val 3]
                if {[catch { {*}$command } msg]} {
                    lappend tb_errors "$geomname \n\t $msg"
                }
            } 
        }
    }
     
    if {[info exists GidPriv(ToglWinMode)]} {       
        GiD_Project set windows_layout $GidPriv(ToglWinMode)
    }
    #if { [llength $tb_errors] } {
    #    W "OpenOutsideWindows $tb_errors"
    #}
}



proc MakeAlwaysOnTop { w } {
    set ::GidPriv(Transient,$w) 1
    ToggleTransientWin $w
}

proc ToggleTransientWin { w } {
    global GidPriv

    # don't set transient property as it causes major problems with gnome in ubuntu 18.04
    # major problems = gnome shell restart, too many delay when realizing/raising windows, etc...
    package require gid_cross_platform
    
    set can_use_transient [ gid_cross_platform::all_monitors_use_same_scaling_factor]
    # macOS does not like transient windows on separated monitors
    if {  $::tcl_platform(os) == "Darwin"} {
        if { [ gid_cross_platform::get_number_of_monitors_connected] > 1} {
            set can_use_transient  0
        }
    }
    if { $can_use_transient} {
        set top [winfo parent [winfo toplevel $w]]
        if { [info exists GidPriv(Transient,$w)] && $GidPriv(Transient,$w) == 1 && $top != "." } {
            #wm transient $w .gid
            wm transient $w $top
        } else {
            # TODO ?eventually if $top == "." manke it transient to ".gid"?
            wm transient $w ""
        }
    }
    
    # if { ( $::tcl_platform(platform) == "windows") || ( $::tcl_platform(os) == "Darwin") } {
    #     AddAlwaysOnTopFlag $w
    # }
}

#to centralize this useful, return PRE or POST
proc GetCurrentPrePostMode { } {
    set ViewMode [GiD_Info Project ViewMode]
    if { $ViewMode == "GEOMETRYUSE" || $ViewMode == "MESHUSE" }  {
        return PRE
    } else { 
        #ViewMode == "POSTUSE" || #ViewMode == "GRAPHUSE"
        return POST
    }
}

proc AddAlwaysOnTopFlag { w } {
    global GidPriv
    if { [winfo exists $w._topmenu] } {
        destroy $w._topmenu
    }
    menu $w._topmenu -tearoff 0
    $w configure -menu $w._topmenu
    menu $w._topmenu.system -tearoff 0
    $w._topmenu add cascade -menu $w._topmenu.system
    $w._topmenu.system add checkbutton -label [_ "Always on top"] -variable \
        GidPriv(Transient,$w) -command [list  ToggleTransientWin $w]
}

proc ConfigureWinIdle { w prev_bind } {
    if { [winfo exists $w] } {
        bind $w <Configure> $prev_bind
    }
}

proc ConfigureWin { W w geomname {InitComm ""} } {
    if { $W == $w } {
        set prev_bind [bind $w <Configure>]
        bind $w <Configure> ""
        WriteYourGeomToVar $w OPEN $geomname $InitComm
        after idle [list ConfigureWinIdle $w $prev_bind]
    }
}

proc DestroyWin { W w geomname {InitComm ""}} {
    if { $W == $w } {
        WriteYourGeomToVar $w NONE $geomname $InitComm
    }
}

proc WriteYourGeomToVar { w what geomname {InitComm ""}} {
    global GidPriv
    if { [winfo class $w] != "Toplevel" } {
        return
    }
    if { [wm transient $w] != "" } {
        set trans 1
    } else {
        set trans 0
    }
    set geom [wm geometry $w]

    if { $::tcl_platform(platform) == "windows" } {
        # only if there is a menu attached to the toplevel
        if { [ winfo exists $w] && ( [ $w cget -menu] != "")} {
            regexp {([^x]*)x([^+-]*)([+-]*[0-9]*)([+-]*[0-9]*)} $geom trash width height x y
            if { $width == "" } { set width 1 }
            if { $height == "" } { set height 1 }
            set menuheight [GiD_Info menuheight]
            if { [catch { incr height [expr $menuheight*-1] }] } {
                set height 0
            }
            if { $height < 1 } { set height 20 }
            set geom ${width}x${height}${x}${y}
        }
    }
    set GidPriv($geomname) [list $what $geom $trans $InitComm]
}

proc InitWindow2 { w args} {
    package require parse_args
    # -geometryvariable name    used to store window geometry ( WidthxHeight+PosX+PosY ), also in file gid.ini
    #     geometryvariable  must be of the form  <prefix><name>WindowGeom
    #         with <prefix> Pre Post or PrePost to allow open the window only in pre, post or both
    # -initcommand cmd          Command called when starting gid if window was open when exiting
    # -onlyposition             to use only the position ( +PosX+PosY) stored in variable
    # -onlygeometry             to use/save only the geometry but not the open/close state
    parse_args::parse_args $args {
        -title        {-required}
        -geometryvariable   {-required -name geomname}
        -initcommand  {-name InitComm -default ""}
        -class        {-default ""}
        -onlygeometry {-boolean}
        -onlyposition {-boolean -name OnlyPos}
        -ontop        {-boolean}
        -nodestroy    {-boolean}
        -topmost      {-boolean}
    }
    # -ontop        {-boolean -default 1 -# "TODO this is always true, it should be changed"}

    if { [ string index $w 0] == "-"} {
        GID_tk_messageBox -icon error -message [_ "InitWindow2 error. 'w' can not start with '-'"] \
            {*}[ GidUtils::GiDDefaultParentIfPresent ]
            toplevel $w
            wm title $w $title
            return $w
    }

    return [ InitWindow $w $title $geomname $InitComm $class $OnlyPos $ontop $nodestroy $topmost $onlygeometry]
}

#w: toplevel name
#title: window title (marked to translation)
#geomname: must be <prefix><name>WindowGeom, 
#with <prefix> Pre Post or PrePost to allow open the window only in pre, post or both
#and geomname must be unique
#InitComm: the Tcl procedure to be called to reopen the window
proc InitWindow { w title geomname {InitComm ""} { class ""} { OnlyPos 0 } {ontop 1} {nodestroy 0} {topmost 0} {onlygeometry 0}} {
    global GidPriv

    if { [GidUtils::AreWindowsDisabled] } {
        return close
    }

    # set topmost 0
    set transient 0
    set toolwindow 0   ;# only used in windows
    set abovegid 0
    if { $ontop} {
        # GID-2764 two monitors with different scaling on windows: topmost and transient are the flags that makes contextual menu kapput
        package require gid_cross_platform
        set can_use_transient [ gid_cross_platform::all_monitors_use_same_scaling_factor]
        # macOS and several monitors, only if mirroed, transient can be used
        #      it does not matter the scaling factor on the monitors
        if {  $::tcl_platform(os) == "Darwin"} {
            if { [ gid_cross_platform::get_number_of_monitors_connected] > 1} {
                set can_use_transient  0
            }
        }
        if { $can_use_transient} {
            if { $::tcl_platform(platform) == "windows"} {
                set toolwindow 0
                # set topmost 1
                # testing this:
                set transient 1
            } else {
                # not sure about this
                set transient 1
            }
        } else {
            # if not topmost nor transient, at least make it appear above gid
            set abovegid 1
        }
    }

    #if { [string range $geomname 0 2] != "Pre" && [string range $geomname 0 3] != "Post" || [string range $geomname end-9 end] !=  "WindowGeom" } {
    #    W "InitWindow expect pattern Pre|Post|PrePost<name>WindowGeom, wrong $geomname"
    #}

    if { ![info exists GidPriv(TopLevelsList)] } {
        set GidPriv(TopLevelsList) ""
    }
    if { [lsearch $GidPriv(TopLevelsList) $w] == -1 } {
        lappend GidPriv(TopLevelsList) $w
    }

    if { [winfo exists $w] } {
        destroy $w
    }
    if { $class == "" } {
        toplevel $w
    } else {
        toplevel $w -class $class
    }

    # GID-2764 two monitors with different scaling on windows
    # if GiD's main window is in one monitor and another window on the other
    # GiD's main window's contextual menu does not appear, or it appears misplaced and with the wrong size
    # this is because InitWindow by default creates 'transient' windows which share context 
    #    with the 'container' window, i.e. with GiD's main window, so that the
    #    scaling factor of the 'transient' window affects the 'container's main window
    # --> disabling transient windows by default
    #
    # uncomment this code again, otherwise is worst: the windows are not re-opened with its exact size (mesh size, copy,... become smaller)!!
    # W "InitWindow -$title- $w"
    # WV [ list topmost transient abovegid]
    if { $::tcl_platform(platform) == "windows" || $::tcl_platform(platform) == "unix" } {
        # if { [info exists GidPriv($geomname)] } {
        #     set GidPriv(Transient,$w) [lindex $GidPriv($geomname) 2]
        # } else {
        #     # set GidPriv(Transient,$w) $ontop
        #     set GidPriv(Transient,$w) $transient
        # }
        set GidPriv(Transient,$w) $transient
        if { $transient} {
            ToggleTransientWin $w
        }
    }

    wm title $w $title
    if { ( $::tcl_platform(platform) == "windows") && $toolwindow } {
        wm attributes $w -toolwindow 1
    }
    if { $topmost } {
        if { $::tcl_platform(platform) == "windows"} {
            # try that appear over other windows without grab, like copy....
            wm attributes $w -topmost 1
        }
        # as in dialogwin.tcl
        # set parent [winfo parent $win]
        # if { [wm state $top] ne "withdrawn" } {
        #     wm transient $win $parent
        # }
    }

    if { [info exists GidPriv($geomname)] } {
        # verificamos que la window tenga un tamanno aceptable
        # si no lo tiene, mantenemos solo la posicion
        if { [ regexp {([0-9]+)x([0-9]+)(\+.*)} $GidPriv($geomname) dummy ancho alto posicion]} {
            if { ( $ancho < 20) || ($alto < 20)} {
                unset GidPriv($geomname)
            }
        }
    }
    if { [info exists GidPriv($geomname)] } {
        if { $OnlyPos == 0 } {
            set posgeom [lindex $GidPriv($geomname) 1]
        } else {
            regexp {[+-].*} [lindex $GidPriv($geomname) 1] posgeom
        }
        WmGidGeom $w $posgeom
    } else {
        WmGidGeom $w ""
    }
    if { !$nodestroy } {
        bind $w <Destroy> [list DestroyWin %W $w $geomname $InitComm]
    }
    bind $w <Configure> [list ConfigureWin %W $w $geomname $InitComm]

    # Alt-c is not working
    # bind $w <Alt-c> [list destroy $w]   
    bind $w <${::acceleratorKey}-w> [list destroy $w]
    if { $::tcl_platform(platform) == "windows" } {
        bind $w <${::acceleratorKey}-F4> [list destroy $w]
    }
    bind $w <Escape> [list destroy $w]

    regsub {Geom$} $geomname {} geomwinname
    set GidPriv($geomwinname) $w
    set GidPriv($geomwinname,InitComm) $InitComm
    # if onlygeometry == 1 then we want to save only geometry of window
    # to avoid opening windows when gid starts, which need some model information, etc.
    set ::GidPriv($geomwinname,onlygeometry) $onlygeometry
    if { ![info exists GidPriv(InitWindowList)] } {
        set GidPriv(InitWindowList) ""
    }
    if { [lsearch $GidPriv(InitWindowList) $geomwinname] == "-1" } {
        lappend GidPriv(InitWindowList) $geomwinname
    }   
      
    if { $abovegid} {
        GidUtils::WindowAboveGid $w
    }

    #wm minsize $w 28 0
    #kike: commented. Avoid set a generic minimum size, or at least not set minimum 
    #greater than 28 (for toolbars that have this width using normal icons 24x24)
    return $w
}

proc InitWindow_ModifyInitComm { w geomname InitComm } {
    global GidPriv    
    bind $w <Destroy> [ list DestroyWin %W $w $geomname $InitComm]
    bind $w <Configure> [ list ConfigureWin %W $w $geomname $InitComm]

    regsub {Geom$} $geomname {} geomwinname
    set GidPriv($geomwinname) $w
    set GidPriv($geomwinname,InitComm) $InitComm
}

proc GetModelQuadraticTypeNextDesiredValid { } {
    set quadratic_type [GiD_Set Model(QuadraticType)]
    if { $quadratic_type == -1 } {
        set quadratic_type [GiD_Set Preferences(QuadraticType)]
    }
    return $quadratic_type    
}

proc GetMenuDataQuadratic  { } {
    set menu_data [list]
    set current_value [GetModelQuadraticTypeNextDesiredValid]
    if { $::GidPriv(HideSurfaceLevel) == 1 } {
        set labels [list [_ "Normal"] [_ "Quadratic"]]
        set values {0 1} 
    } else {
        set labels [list [_ "Normal"] [_ "Quadratic"] [_ "Quadratic9"]]
        set values {0 1 2}
    }
    foreach label $labels value $values {
        if { [expr {$::GidPriv(HideQuadraticTypeLevel) & (2**$value)}] } {
            continue
        }
        set active 0
        if { $value == $current_value } {
            set active 1
        }
        set command [list GiD_Process MEscape Utilities Variables Model(QuadraticType) $value escape escape]        
        lappend menu_data [list i $label $command "" "" 0 $active]
    }
    return $menu_data
}

proc AddEntitiesToMenuQuadratic { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {        
        set newstate [GetModelQuadraticTypeNextDesiredValid]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && $w != "" && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataQuadratic]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataViewMode { } {
    set menu_data [list]
    set what [GetCurrentPrePostMode]
    set view_mode [GiD_Info Project ViewMode]
    if { $what == "PRE" } {
        set nnodes [GiD_Info Mesh NumNodes]
        set labels [ list [_ "Geometry"] [_ "Mesh"] [_ "Toggle"]]
        set commands { GeometryView {MeshView 1} ToggleGeomMesh}
        set accelerators [list "" "" [list ${::acceleratorText}-m ${::acceleratorKey}-m]]
        set images [list "" "" "view_geom_mesh.png"]
        set disableds [list 0 [IsFalse $nnodes] [IsFalse $nnodes]]
        if { $view_mode == "GEOMETRYUSE" } {
            set actives [list 1 0 0]
        } elseif { $view_mode == "MESHUSE" } {
            set actives [list 0 1 0]
        } else {
            set actives [list 0 0 0]
        }
    } else {        
        set ngraph [llength [GiD_Graph list]]
        set labels [ list [_ "Mesh"] [_ "Graphs"] [_ "Toggle"] ]
        set commands { {GiD_Process MEscape Results Graphs OptionsGraph ShowGraphs No} \
                           {GiD_Process MEscape Results Graphs OptionsGraph ShowGraphs Yes} \
                           TogglePostGraph }
        set accelerators [list "" "" ""]
        set images [list "" "" "postgraf.png"]
        set disableds [list 0 [IsFalse $ngraph] [IsFalse $ngraph]]
        if { $view_mode == "POSTUSE" } {             
            set actives [list 1 0 0]
        } elseif { $view_mode == "GRAPHUSE" } {
            set actives [list 0 1 0]
        } else {
            set actives [list 0 0 0]
        }     
    }
    foreach label $labels command $commands accelerator $accelerators image $images disabled $disableds active $actives {
        if { $label=="---" } {
            lappend menu_data [list i --- "" "" "" 0 0]
        } else {
            lappend menu_data [list i $label $command $accelerator $image $disabled $active]
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuViewMode { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {    
        set newstate [GiD_Info Project ViewMode]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && $w != "" && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataViewMode]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetGeometryLabels { {alltypes 0} } {
    if { $::GidPriv(HideSurfaceLevel) == 1 } {
        set res [list [_ "Points"] [_ "Lines"]]
    } else {
        if { $::GidPriv(HideVolumeLevel) == 1 } {
            set res [list [_ "Points"] [_ "Lines"] [_ "Surfaces"]]            
        } else {
            set res [list [_ "Points"] [_ "Lines"] [_ "Surfaces"] [_ "Volumes"]]
        }
    }
    if { $alltypes } {
        lappend res --- [_ "All types"]
    }
    return $res
}

proc GetGeometryLabelsSingular { } {
    if { $::GidPriv(HideSurfaceLevel) == 1 } {
        set res [list [_ "Point"] [_ "Line"]]
    } else {
        if { $::GidPriv(HideVolumeLevel) == 1 } {
            set res [list [_ "Point"] [_ "Line"] [_ "Surface"]]            
        } else {
            set res [list [_ "Point"] [_ "Line"] [_ "Surface"] [_ "Volume"]]
        }
    }
    return $res
}

proc GetGeometryCommands { {alltypes 0} } { 
    if { $::GidPriv(HideSurfaceLevel) == 1 } {
        set res {Points Lines}
    } else {
        if { $::GidPriv(HideVolumeLevel) == 1 } {
            set res {Points Lines Surfaces}            
        } else {
            set res {Points Lines Surfaces Volumes}            
        }
    }
    if { $alltypes } {
        lappend res --- AllTypes
    }
    return $res
}

proc GetGeometryImageFiles { {alltypes 0} } {
    if { $::GidPriv(HideSurfaceLevel) == 1 } {
        set res {point.png line.png}
    } else {
        if { $::GidPriv(HideVolumeLevel) == 1 } {
            set res {point.png line.png surface.png}            
        } else {
            set res {point.png line.png surface.png volume.png}
        }
    }
    if { $alltypes } {
        lappend res sep_hori.png alltypes.png        
    }
    return $res
}

#to set menu colors disabled/enabled at runtime
proc GetGeometryStateColors { npoints nlines nsurfs nvols {alltypes 0} } {
    if { $::GidPriv(HideSurfaceLevel) == 1 } {
        set res [list [GetColorTrueFalse $npoints] [GetColorTrueFalse $nlines]]
    } else {
        if { $::GidPriv(HideVolumeLevel) == 1 } {
            set res [list [GetColorTrueFalse $npoints] [GetColorTrueFalse $nlines] [GetColorTrueFalse $nsurfs]]
        } else {
            set res [list [GetColorTrueFalse $npoints] [GetColorTrueFalse $nlines] [GetColorTrueFalse $nsurfs] [GetColorTrueFalse $nvols]]            
        }
    }
    if { $alltypes } {
        lappend res [GetColorTrueFalse $npoints] [GetColorTrueFalse $npoints]        
    }
    return $res
}

proc GetMeshLabels { {alltypes 0} } {
    set res  [list [_ "Nodes"] [_ "Elements"]]
    if { $alltypes } {
        lappend res --- [_ "All types"]        
    }
    return $res
}

proc GetMeshLabelsSingular { } {
    set res  [list [_ "Node"] [_ "Element"]]
    return $res
}

proc GetMeshCommands { {alltypes 0} } { 
    set res {Nodes Elements}
    if { $alltypes } {
        lappend res --- AllTypes
    }
    return $res
}

proc GetMeshImageFiles { {alltypes 0} } {
    set res {node.png element.png}
    if { $alltypes } {
        lappend res sep_hori.png alltypes_mesh.png
    }
    return $res
}

proc GetMeshStateColors { nnodes nelements {alltypes 0} } {
    set res [list [GetColorTrueFalse $nnodes] [GetColorTrueFalse $nelements]]        
    if { $alltypes } {
        lappend res [GetColorTrueFalse $nnodes] [GetColorTrueFalse $nnodes]
    }
    return $res
}

# m menu widget
proc gid_client_update_menu { menu_data m } {   
    $m delete 0 end
    set UnderLineList {}
    set inum 0
    foreach item $menu_data {        
        lassign $item type label command accelerator icon disabled active
        if { $type == "i" } {
            if { $label == "---" } {
                $m add separator
            } else {
                set under [FindUnderChar label UnderLineList]
                set options [list -label $label -underline $under -command $command]
                if { $accelerator != "" } {
                    lappend options -accelerator [lindex $accelerator 0]
                    bind .gid <[lindex $accelerator 1]> $command           
                }
                if { $icon != "" } {
                    lappend options -image [gid_themes::GetImage $icon menu] -compound left
                }
                if { $disabled == 1 } {
                    lappend options -foreground $::GidPriv(Color,DisabledForegroundMenu)
                }
                if { $active } {
                    $m add checkbutton {*}$options -variable ::GidMenuCheckbutton($m)
                    set ::GidMenuCheckbutton($m) 1
                } else {
                    $m add command {*}$options
                }
            }
        } elseif { $type == "m" } {
            set newmenu $m.$inum
            if { [winfo exists $newmenu] } {
                $newmenu delete 0 end
            } else {
                menu $newmenu
            }
            set options [list -label $label -menu $newmenu]
            if { $disabled == 1 } {
                lappend options -foreground $::GidPriv(Color,DisabledForegroundMenu)
            }
            $m add cascade {*}$options
            gid_client_update_menu $command $newmenu
            incr inum
        } else {
            error "unexpected type $type"
        }
    }
    return 0
}

proc GetMenuDataDrawSize { } {
    set menu_data [list]
    set backgroundfilename [GiD_Info Project BackgroundFilename]
    if { $backgroundfilename != "" } {
        set label [_ "Background mesh"]
        set command [list GiD_Process Mescape Meshing DrawSizes Background AsElems]
        set accelerator ""
        set icon ""
        lappend menu_data [list i $label $command $accelerator $icon 0 0]
    } else {
        set labels [GetGeometryLabels 1]      
        set commands [GetGeometryCommands 1]
        set images [GetGeometryImageFiles 1]        
        foreach label $labels i $commands icon $images {
            if { $label=="---" } {
                lappend menu_data [list i --- "" "" "" 0 0]
            } else {
                set command "GeometryView ; GiD_Process Mescape Meshing DrawSizes $i"
                set accelerator ""
                lappend menu_data [list i $label $command $accelerator $icon 0 0]
            }
        }        
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawSize { w } {
    # 0 to not cache this
    if { 0 && $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set backgroundfilename [GiD_Info Project BackgroundFilename]
        set newstate $backgroundfilename
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataDrawSize]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataDrawMeshNoMesh { } {
    set menu_data [list]
    set labels [GetGeometryLabels 1]
    set commands [GetGeometryCommands 1]
    set images [GetGeometryImageFiles 1]
    foreach label $labels i $commands image $images {
        if { $label=="---" } {
            lappend menu_data [list i --- "" "" "" 0 0]
        } else {
            set command "GeometryView ; GiD_Process Mescape Meshing DrawMeshNoMesh $i"
            set accelerator ""
            lappend menu_data [list i $label $command $accelerator $image 0 0]           
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawMeshNoMesh { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate CONSTANT
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataDrawMeshNoMesh]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataDrawForcePointsToMesh { } {
    set menu_data [list]
    set labels [list]
    set commands [list]
    if { $::GidPriv(HideSurfaceLevel)== 0 } {
        lappend labels [_ "Surface mesh"]
        lappend commands "Surface"
    }
    if { $::GidPriv(HideVolumeLevel) == 0 } {
        lappend labels [_ "Volume mesh"]
        lappend commands "Volume"
    }        
    foreach label $labels i $commands  {
        set command "GeometryView ; GiD_Process Mescape Meshing DrawForcedPointsToMesh $i"
        set accelerator ""
        set image ""
        lappend menu_data [list i $label $command $accelerator $image 0 0]        
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawForcePointsToMesh { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate CONSTANT
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataDrawForcePointsToMesh]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataDrawElementType { } {
    set menu_data [list]
    set labels [lrange [GetGeometryLabels 1] 1 end]
    set commands [lrange [GetGeometryCommands 1] 1 end]
    set images [lrange [GetGeometryImageFiles 1] 1 end]
    foreach label $labels i $commands image $images {
        if { $label=="---" } {
            lappend menu_data [list i --- "" "" "" 0 0]
        } else {
            set command "GeometryView ; GiD_Process Mescape Meshing DrawElementType $i"
            set accelerator ""
            lappend menu_data [list i $label $command $accelerator $image 0 0]           
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawElementType { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate CONSTANT
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataDrawElementType]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataDrawStructuredType { } {
    set menu_data [list]
    set labels [lrange [GetGeometryLabels 1] 1 end]
    set commands [lrange [GetGeometryCommands 1] 1 end]
    set images [ lrange [GetGeometryImageFiles 1] 1 end]
    foreach label $labels i $commands image $images {
        if { $label=="---" } {
            lappend menu_data [list i --- "" "" "" 0 0]
        } else {
            set command "GeometryView ; GiD_Process Mescape Meshing DrawStructuredType $i"
            set accelerator ""
            lappend menu_data [list i $label $command $accelerator $image 0 0]           
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawStructuredType { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate CONSTANT
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataDrawStructuredType]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc ChooseElemType { etype { ltype ""} } {
    set MoreWin [GiD_Set UseMoreWindows]
    set list1 "Default Linear Triangle Quadrilateral Tetrahedra Hexahedra Prism Points Sphere Circle"
    set list2 " -      -      surfaces surfaces      volumes    volumes   volumes volumes  -      -"
    set inum [lsearch -exact $list1 $etype]
    if { $inum == 0 ||  $inum == 1 } { 
        #Default or Linear
        GiD_Process Mescape Meshing ElemType $etype $ltype
        set word $ltype
    } elseif { $inum == 8 } { 
        #Sphere
        GiD_Process Mescape Meshing ElemType $etype $ltype
        set word $ltype
    } elseif { $inum == 9 } { 
        #Circle
        GiD_Process Mescape Meshing ElemType $etype $ltype
        set word $ltype
    } elseif { $inum != -1 } {
        GiD_Process Mescape Meshing ElemType $etype
        set word [lindex $list2 $inum]
    } else {
        WarnWinText [_ "Unknown element type %s" $etype]
        return
    }
    if { $MoreWin > 1 } {
        WarnWin [_ "Select %1\$s to assign elem type: %2\$s" $word $etype] 
    }
}

proc ParseCommandArguments { w command} {
    if { $command == "" } {
        return $command
    }
    switch -- [lindex $command 0] {
        "-np-" {
            set vareval "[lrange $command 1 end]"
        }
        "-npm-" {
            set vareval "[lrange $command 1 end]"
        }
        "-ne-" {
            set vareval "GiD_Process [lrange $command 1 end]"
        }
        default {
            set vareval "GiD_Process Mescape $command"
        }
    }
    regsub -all {%W} $vareval $w vareval2
    regsub -all {%X} $vareval2 {[ winfo pointerx .gid]} vareval2
    regsub -all {%Y} $vareval2 {[ winfo pointery .gid]} vareval2
    return $vareval2
}

#if entry!=-1 => uses entryconfigure
proc EnterCommand { w command { entry -1 } } {    
    switch -- $entry {
        -1 {
            set lstWidgetsSinCommand [list Label TLabel Frame]
            if { [lsearch $lstWidgetsSinCommand [winfo class $w]] == -1} {
                set comm "$w configure -command "
            } else {
                set comm "bind $w <1> "
            }
        }
        -2 {
            set comm "$w configure -postcommand "
        }
        default {
            set comm "$w entryconfigure $entry -command "
        }
    }
    if { $command == "" } {
        lappend comm ""
        eval $comm
    } else {
        set finalCommand [ParseCommandArguments $w $command]
        set vareval2 "$comm{$finalCommand}"
        eval $vareval2
    }
}

proc AddAccelerator { key menu index } {

    regsub -all ${::acceleratorKey} $key ${::acceleratorText} keyname
    $menu entryconfigure $index -accelerator $keyname

    set cmd "$menu invoke $index ; break"
    if { $::tcl_platform(os) == "Darwin" && [GiD_Set Theme(MenuType)] == "native" } {
        set cmd "after 100 [ list $menu invoke $index]"
    }

    if { [llength $key] == 1 } {
        bind .gid <$key> $cmd
        lappend ::GidPriv(bindings_add_accelerator) $key
    } elseif { [llength $key] == 2 } {
        bind .gid <[lindex $key 0]><[lindex $key 1]> $cmd
        lappend ::GidPriv(bindings_add_accelerator) $key
    }
}

proc AddAcceleratorCommand { key menu index command} {
    set finalCommand [ParseCommandArguments $menu $command]
    regsub -all ${::acceleratorKey} $key ${::acceleratorText} keyname
    # on macOS Catalina accelerator key F11 is displayed as F1, ?may be due to accelerator restrictions?
    # in macOS Catalina F11 is used to clear/show the desktop
    # on macOS Catalina full screen accelerator usually is Shift+Command+F
    set os_version [ split $::tcl_platform(osVersion) .]
    if { ( $::tcl_platform(os) == "Darwin") && ( [ lindex $os_version 0] >= 19) && \
             ( ( $key == "F11") || ( $key == "F10") ) } {
        set txt [ $menu entrycget $index -label ]
        $menu entryconfigure $index -label "$txt     $key"
    } else {
        $menu entryconfigure $index -accelerator $keyname
    }
    set cmd "$finalCommand ; break"
    if { $::tcl_platform(os) == "Darwin" && [GiD_Set Theme(MenuType)] == "native" } {
        set cmd "after 100 [list $menu invoke $index]"
    }
    if { [llength $key] == 1 } {
        bind .gid <$key> $cmd
        lappend ::GidPriv(bindings_add_accelerator) $key
    } elseif { [llength $key] == 2 } {
        bind .gid <[lindex $key 0]><[lindex $key 1]> $cmd
        lappend ::GidPriv(bindings_add_accelerator) $key
    }
}

proc AddLittleIcon { icon menu index } {
    set es_imagen_tk 0
    if { [llength $icon] > 1 && [lindex $icon 0] == "-np-" } {
        set icon [ eval [ lrange $icon 1 end]]
        # pueden devolvernos la imagen en si, en vez del archivo
        set err [ catch {
            set pp [ image type $icon]
        }]
        if { !$err} {
            set es_imagen_tk 1
        }
    }
    if { !$es_imagen_tk} {
        if { $icon != "" } {
            $menu entryconfigure $index -image [ gid_themes::GetImage $icon menu] -compound left
        } else {
            #add a dummy image to left align all rows
            $menu entryconfigure $index -image [ gid_themes::GetImage blank.png menu] -compound left
        }
    } else {
        $menu entryconfigure $index -image $icon -compound left
    }
}

proc AppleAbout { } {
    startGiDMenuOption About
}

if { ( $::tcl_platform(os) == "Darwin") } {
    # check if already exists ( scripts reloaded)
    if { "[ info commands tkAboutDialog*]" == ""} {
        rename AppleAbout tkAboutDialog
    }

    namespace eval ::tk::mac {
    }

    # Needs to be defined outside as it is called before proc Create...Menubar is called
    proc ::tk::mac::OpenDocument { args } {
        # Allow everything to be set up
        after 1000 [ list LoadFileInGid $args]
    }

    proc ::tk::mac::PrintDocument { args } {
        # Just to mention that this event can be triggered by macOS
        # W "PrintDocument event received: $args"
    }

    proc ::tk::mac::ReopenApplication { args } {
        # Just to mention that this event can be triggered by macOS
        # W "It seems that GiD has been restarted after a crash..."
    }

    # These are usefull for MacAutomationScripting (AutomatetheUserInterface ...) with AppleScript like:
    #     tell application "GiD"
    #         tell process "GiD"
    #             -- preform user interface scripting tasks
    #             name of every menu of menu bar 1
    #         end tell
    #     end tell

    proc ::tk::mac::DoScriptFile { args } {
        # Just to mention that this event can be triggered by macOS
        # W "DoScriptFile $args"
    }

    proc ::tk::mac::DoScriptText { args } {
        # Just to mention that this event can be triggered by macOS
        # W "DoScriptText $args"
    }

    proc ::tk::mac::ShowHelp { args } {
        # Just to mention that this event can be triggered by macOS
        # W "ShowHelp $args"
    }

    proc ::tk::mac::PerformService { args } {
        # Just to mention that this event can be triggered by macOS
        # W "ShowHelp $args"
    }

    proc ::tk::mac::LaunchURL { args } {
        # Just to mention that this event can be triggered by macOS
        # OpenUrl  open url handler like     open gid://open?model_id=8310   # @ apptesting.gidsimulation.com
        # or  gid://open?model_id=109090    # @ app.gidsimulation.com
        # W "LaunchURL $args"
        ExternalActions::ExternalConnect $args
    }
}

proc CreateBasicMacMenubar { w} {
    set top [winfo toplevel $w]
    if { $top != ".gid" } {
        set t $top
        if { [.gid cget -menu] != "" } {
            .gid configure -menu ""
            destroy .mm1
        }
    } else {
        set t ""
    }
    
    if { ![winfo exists $t.mm1] } {
        menu $t.mm1 -type menubar
        #        $top configure -menu $t.mm1
    } else {
        $t.mm1 delete 0 end
    }
    $top configure -menu $t.mm1

    foreach i [winfo children $t.mm1] {
        destroy $i
    }

    # from  https://www.tcl.tk/man/tcl8.6/TkCmd/tk_mac.htm

    if { [tk windowingsystem] eq "aqua"} {

        proc startGiDMenuOption { menu_name } {
            global MenuEntries MenuCommands
            
            foreach "n v" [array get MenuEntries] {
                set ipos 0
                foreach i $v {
                    if { $i in [list [_ $menu_name] [_ $menu_name#C#menu] [_ $menu_name]... [_ $menu_name#C#menu]...] } {
                        set cmd [lindex $MenuCommands($n) $ipos]
                        if { [lindex $cmd 0] eq "-np-" } {
                            uplevel #0 [lrange $cmd 1 end]
                        } else {
                            GiD_Process Mescape {*}$cmd
                        }
                        return
                    }
                    incr ipos
                }
            }
        }
        
        proc ::tk::mac::ShowPreferences {} [list startGiDMenuOption Preferences]
        
        # $t.mm1 add cascade -label GiD -menu $t.mm1.apple
        # menu $t.mm1.apple
        # $t.mm1.apple add command -label [_ "About"]... -command [ list startGiDMenuOption About]
        # shoule be renamed  tkAboutDialog because of Tk 8.6.1 internals ....
        # for first menu after apple gid_debug.exe-->About which is always created !!!
        # rename AppleAbout tkAboutDialog
        # # proc ::tk::mac::standardAboutPanel {} {
        # #     startGiDMenuOption About
        # # }
    }
    proc ::tk::mac::Quit {}  [ list QuitFullScreen]
    # $t.mm1 add command -label [_ "Quit"] -command [ list startGiDMenuOption Quit]
}

#Warning, the name is confusing: this proc is now also used in Windows with themes!!
proc CreateTopMenusUnix { w } {
    global MenuNames MenuNamesP ViewMenuPriv

    if { ![winfo exists $w] } { return }

    #$w configure -style Horizontal.IconButton  

    set wtop [ winfo toplevel $w]
  
    if {[winfo class $w] != "Toplevel"} {
        $w configure -style ForcedFrame
        #-style Horizontal.TFrame.IconButton
    }

    if { [ esMac]} {
        # deshabilitar o poner casi nada en el MenuBar de Mac
        CreateBasicMacMenubar $w
    }

    if { [ GetCurrentPrePostMode] == "PRE" } {
        set MenuNamesInto $MenuNames
        set MenuEntriesName MenuEntries
        set MenuCommandsName MenuCommands
        set MenuAccelerName MenuAcceler
        set MenuLittleIcons MenuIcons
    } else {
        set MenuNamesInto $MenuNamesP
        set MenuEntriesName MenuEntriesP
        set MenuCommandsName MenuCommandsP
        set MenuAccelerName MenuAccelerP
        set MenuLittleIcons MenuIconsP
        #delete array that cache some menus like View results->Integrate ... 
        #to avoid rebuild them, but it the result change become invalid
        array unset ::ViewMenuPriv       
    }
    upvar #0 $MenuEntriesName ME
    upvar #0 $MenuCommandsName MC
    upvar #0 $MenuLittleIcons MI

    set NumMenus [llength $MenuNamesInto]

    set UnderLineList ""

    for {set i 0} { $i< 15 } { incr i } {
        if { [winfo exists $w.button$i] } {
            destroy $w.button$i
        }
    }

    proc PostTopMenuBarMenu { w m x y} {
        $m post $x [ expr $y + [ winfo height $w]]
    }

    for {set i 0 } { $i< $NumMenus } { incr i } {
        set text [lindex $MenuNamesInto $i]
        set under [FindUnderChar text UnderLineList]
        if { ![winfo exists $w.button$i] } {
            ttk::menubutton $w.button$i -text $text -menu $w.button$i.m.m -style TopMenu.IconButton   
            #-style TopMenu.Horizontal.IconButton          
            SetStyleHorizontalVertical $w.button$i horizontal
            if { $under != -1 } {            
                $w.button$i configure -underline $under            
                set letter [string tolower [string index $text $under]]
                #tk::MbPost assume a -relief option that is missing in ttk::menubutton
                #bind all <Alt-$letter> "set ::tk::Priv(postedMb) {} ; ::tk::MbPost $w.button$i %X %Y"        
                #bind all <Alt-$letter> [list ttk::menubutton::Pulldown $w.button$i]     
                if {[tk windowingsystem] eq "x11"} {
                    bind all <Alt-$letter> "ttk::menubutton::Pulldown $w.button$i;$w.button$i state {!pressed !active}"
                } else {
                    bind all <Alt-$letter>  [list  ttk::menubutton::Popdown $w.button$i ]                   
                }    
            }
            ttk::frame $w.button$i.m
            wm colormapwindows .gid $w.button$i.m
            menu $w.button$i.m.m -tearoff no           
        } else {
            $w.button$i configure -text $text
            if { $under != -1 } { 
            $w.button$i configure -underline $under
            }
            if { [$w.button$i.m.m index end] != "none" } {
                ClearMenu $w.button$i.m.m
            }
            $w.button$i.m.m configure -postcommand ""
        }
        
        if { $ME($i) == "" } {
            if { [lindex $MC($i) 0] != "-np-" } {
                
                WarnWin [_ "Error creating menu '%s'. Needed -np-" $text]
            }
            set comm [lrange $MC($i) 1 end]
            regsub -all {%W} $comm $w.button$i.m.m comm
            regsub -all {%I} $comm $i comm
            regsub -all {%X} $comm [ winfo pointerx .gid] comm
            regsub -all {%Y} $comm [ winfo pointery .gid] comm
            
            $w.button$i.m.m configure -postcommand $comm
        }
        CreateCascadedMenu $w.button$i.m.m $MenuEntriesName $MenuCommandsName \
            $MenuAccelerName $i $MenuLittleIcons
    }

    for {set i 0 } { $i< [expr $NumMenus-1] } { incr i } {
        #pack $w.button$i -side left
        grid $w.button$i -row 0 -column $i -sticky w
        grid columnconfigure $w $i -weight 0
    }
    #pack $w.button$i -side right ;#help button to the right side
    grid $w.button$i -row 0 -column $i -sticky w
    grid columnconfigure $w $i -weight 1

    GidHelpT $w [_ "Menu with the main commands."]
    SetMenusStatesPostCommands $w ;#configure -postcommand of buttons
}

proc macOSConfigureWhiteForegroundForDarkTheme { m } {
    # for Mac OS X, using the 'native' MenuType' and if it's set to black ( from Yosemite upwards)
    if { $::tcl_platform(os) == "Darwin" && [GiD_Set Theme(MenuType)] == "native" } {
        # check for the Mac OS X theme used:
        set mac_theme [ getMacOSInterfaceStyle]
        set mac_theme [ string tolower $mac_theme]
        if { $mac_theme == "dark"} {
            $m configure -foreground white
        }
    }
}

proc CreateTopMenusWin { w } {
    global MenuNames MenuNamesP ViewMenuPriv

    if { ![winfo exists $w] } { return }

    set top [winfo toplevel $w]
    if { $top != ".gid" } {
        set t $top
        if { [.gid cget -menu] != "" } {
            .gid configure -menu ""
            destroy .mm1
        }
    } else {
        set t ""
    }

    if { [ GetCurrentPrePostMode] == "PRE" } {
        set MenuNamesInto $MenuNames
        set MenuEntriesName MenuEntries
        set MenuCommandsName MenuCommands
        set MenuAccelerName MenuAcceler
        set MenuLittleIcons MenuIcons
    } else {
        set MenuNamesInto $MenuNamesP
        set MenuEntriesName MenuEntriesP
        set MenuCommandsName MenuCommandsP
        set MenuAccelerName MenuAccelerP
        set MenuLittleIcons MenuIconsP
       
        #delete array that cache some menus like View results->Integrate ... 
        #to avoid rebuild them, but it the result change become invalid
        array unset ::ViewMenuPriv
    }

    upvar #0 $MenuEntriesName ME
    upvar #0 $MenuCommandsName MC
    upvar #0 $MenuLittleIcons MI

    set NumMenus [llength $MenuNamesInto]

    set UnderLineList ""

    if { ![winfo exists $t.mm1] } {
        menu $t.mm1 -type menubar
        #        $top configure -menu $t.mm1
    } else {
        $t.mm1 delete 0 end
    }
    $top configure -menu $t.mm1

    foreach i [winfo children $t.mm1] {
        destroy $i
    }
    
    if { [tk windowingsystem] eq "aqua"} {
        
        proc startGiDMenuOption { menu_name } {
            global MenuEntries MenuCommands
            
            foreach "n v" [array get MenuEntries] {
                set ipos 0
                foreach i $v {
                    if { $i in [list [_ $menu_name] [_ $menu_name#C#menu] [_ $menu_name]... [_ $menu_name#C#menu]...] } {
                        set cmd [lindex $MenuCommands($n) $ipos]
                        if { [lindex $cmd 0] eq "-np-" } {
                            uplevel #0 [lrange $cmd 1 end]
                        } else {
                            GiD_Process Mescape {*}$cmd
                        }
                        return
                    }
                    incr ipos
                }
            }
        }
        
        proc ::tk::mac::ShowPreferences {} [list startGiDMenuOption Preferences]
        #proc ::tkAboutDialog {} [list lognoter About]
        
        # $t.mm1 add cascade -label GiD -menu $t.mm1.apple
        # menu $t.mm1.apple
        # $t.mm1.apple add command -label [_ "About"]... -command [list startGiDMenuOption About]
        # for first menu after apple gid_debug.exe-->About which is always created !!!
        # rename AppleAbout tkAboutDialog
    }
    proc ::tk::mac::Quit {}  [ list QuitFullScreen]
    # $t.mm1 add command -label [_ "Quit"] -command [ list startGiDMenuOption Quit]

    for {set i 0 } { $i< $NumMenus } { incr i } {

        set text [lindex $MenuNamesInto $i]
        set under [FindUnderChar text UnderLineList]
        set namemenu $t.mm1.button$i
        if { ![winfo exists $namemenu] } {
            menu $namemenu
        } else {
            ClearMenu $namemenu
            $namemenu configure -postcommand ""
            #$namemenu delete 0 end
        }
        $t.mm1 add cascade -label $text -underline $under -menu $namemenu
        
        
        if { $ME($i) == "" } {
            if { [lindex $MC($i) 0] != "-np-" } {
                WarnWin [_ "Error creating menu '%s'. Needed -np-" $text]
            }
            set comm [lrange $MC($i) 1 end]
            regsub -all {%W} $comm $namemenu comm
            regsub -all {%I} $comm $i comm
            regsub -all {%X} $comm [ winfo pointerx .gid] comm
            regsub -all {%Y} $comm [ winfo pointery .gid] comm
            $namemenu configure -postcommand $comm
        }
        
        macOSConfigureWhiteForegroundForDarkTheme $namemenu
        
        CreateCascadedMenu $namemenu $MenuEntriesName $MenuCommandsName \
            $MenuAccelerName $i $MenuLittleIcons
    }

    # for debugging
    #InstrumentMenu $t.mm1

    if { [ GetCurrentPrePostMode]  == "PRE" } {
        set idata [ GiDMenu::_FindIndex "Data" PRE]
        if { $idata != -1 } {
            #force create Data menu (else first user click will be slow)
            #create FastCacheFromProblemtypeMenu, read customized problemtype images for the
            #file browser (specified in .xml file), and create the menus
            set ::GidPriv(menu,data) $t.mm1.button$idata
            set ::GidPriv(menu,problemtype) $t.mm1.button$idata
            after idle "FillMenuData $::GidPriv(menu,data) ; FillMenuProblemtype $::GidPriv(menu,problemtype)"
        }
    }

    $t.mm1 configure -postcommand SetMenusStates
}

proc CreateTopMenus { { w .gid.menu } } {
    global GidPriv
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    if { [info exists ::GidPriv(Quit)] && $::GidPriv(Quit) } {
        #try accelerate end
        return
    }
    if { [info exists ::GidPriv(bindings_add_accelerator)] } {
        foreach key $::GidPriv(bindings_add_accelerator) {
            if { [llength $key] == 1 } {
                bind .gid <$key> {}
            } elseif { [llength $key] == 2 } {
                bind .gid <[lindex $key 0]><[lindex $key 1]> {}
            } else {
                #unexpected
            }
        }
        set ::GidPriv(bindings_add_accelerator) [list]
    }
    CacheReset menus    
    if { [GiD_Set Theme(MenuType)] == "native" } {
        CreateTopMenusWin $w
    } else {
        #use "generic" menus
        CreateTopMenusUnix $w
    }
    GiD_RaiseEvent GiD_Event_AfterCreateTopMenus
}

#command_tricky is the old style stored in global variables
#by default was assumed as a process command adding multiple escapes at the begining, 
#other cases have special -np- -ne-
proc GetTclMenuCommand { command_tricky } {
    set tcl_command ""
    if { $command_tricky != "" } {    
        switch -- [lindex $command_tricky 0] {
            "-np-" {
                set tcl_command [lrange $command_tricky 1 end]
            }
            "-npm-" {
                set tcl_command [lrange $command_tricky 1 end]
            }
            "-ne-" {
                set tcl_command [list GiD_Process {*}[lrange $command_tricky 1 end]]
            }
            default {
                set tcl_command [list GiD_Process Mescape {*}$command_tricky]
            }
        }
    }
    return $tcl_command
}

proc GetRecursiveMenuData { i varlabelname varcommandname varacceleratorname variconname} {
    upvar #0 $varlabelname varlabel 
    upvar #0 $varcommandname varcommand
    upvar #0 $varacceleratorname varaccelerator
    upvar #0 $variconname varicon
    
    set menu_data [list]
    set j 0
    if { [llength $varlabel($i)] == 0 } {
        #dark trick, the menu will be filled when posted, invoking a tcl proc to fill in
        set i_split [split $i ,]
        set i_parent [join [lrange $i_split 0 end-1] ,]
        set i_last [lindex $i_split end]
        if { [info exists varcommand($i_parent)] } {
            set command [lindex $varcommand($i_parent) $i_last]
            set command [GetTclMenuCommand $command]
            if { $command != "" } {
                #in post the command has prefix -npm- 
                #in pre he command has prefix -np- and it is assumed like -npm- if menu is empty??
                #must store this information somehow in menu_data...
                
                # e.g $command  == "-np- AddEntitiesToMenuRender %W"
                #test by now only with this case, 
                #the proc AddEntitiesToMenuRender must be modified to return its menu_data,
                #must not create directly its tk menu to %W !!
                #or maybe must fill this menu_data and then raise a event to built the menu

                #mp mean menu post, a -postcommand evaluation will fill the menu
                lappend menu_data [list mp "" $command "" "" 0 0]                               
            }
        }
        
    } else {
        foreach label $varlabel($i) {
            if { [info exists varcommand($i)] } {
                set command [lindex $varcommand($i) $j]
                set command [GetTclMenuCommand $command]              
            } else {
                set command ""
            }
            if { [info exists varaccelerator($i)] } {
                set accelerator [lindex $varaccelerator($i) $j]
            } else {
                set accelerator ""
            }
            if { [info exists varicon($i)] } {
                set icon [lindex $varicon($i) $j]
            } else {
                set icon ""
            }
            if { [string match ---* $label] } {
                lappend menu_data [list i --- "" "" "" 0 0]
            } elseif { [lindex $label 0] == "-CB-" } {
                #it is a checkbox, but require the associated global variable name...
                set label [lrange $label 1 end]            
                lappend menu_data [list i $label $command $accelerator $icon 0 0]
            } elseif { ![info exists varlabel($i,$j)] } {
                lappend menu_data [list i $label $command $accelerator $icon 0 0]      
            } else {
                set submenu_data [GetRecursiveMenuData $i,$j $varlabelname $varcommandname $varacceleratorname $variconname]
                lappend menu_data [list m $label $submenu_data "" "" 0 0]
            }
            incr j
        }
    }
    return $menu_data
}

proc GiD_Info_menu_data { {pre_post ""} } {
    set menu_data [list]
    if { $pre_post == "" } {
        set pre_post [GetCurrentPrePostMode]
    }
    if { $pre_post == "PRE" } {     
        set i 0
        foreach label $::MenuNames {
            set submenu_data [GetRecursiveMenuData $i MenuEntries MenuCommands MenuAcceler MenuIcons]
            lappend menu_data [list m $label $submenu_data "" "" 0 0] 
            incr i
        }
    } else {
        set i 0
        foreach label $::MenuNamesP {
            set submenu_data [GetRecursiveMenuData $i MenuEntriesP MenuCommandsP MenuAccelerP MenuIconsP]
            lappend menu_data [list m $label $submenu_data "" "" 0 0]
            incr i
        }
    }
    return $menu_data
}

proc GiD_Info_contextual_menu_data { } {
    set i 0
    set menu_data [GetRecursiveMenuData $i 3dButtonNames 3dButtonCommands 3dButtonAcceler 3dButtonIcons]
    return $menu_data
}


# for debugging
proc InstrumentCommand { label script } {
    set time [time {uplevel \#0 $script}]
    WarnWinText "$label $script $time"
}
proc InstrumentMenu { menu {label "" } } {

    set comm [$menu cget -postcommand]
    if { $comm != "" } {
        set comm [ list InstrumentCommand $label $comm]
        $menu configure -postcommand $comm
    }
    set ni [$menu index end]
    if { $ni == "none" } { set ni -1 }
    for { set i 0 } { $i <= $ni } { incr i } {
        if { [$menu type $i] == "cascade" } {
            InstrumentMenu [$menu entrycget $i -menu] [$menu entrycget $i -label]
        }
    }
}

proc UpdateMouseMenu {} {
    Set3dButtonVariables
    set m .gid.display3dbutton
    #$m delete 0 end
    if { [winfo exists $m] } {
        destroy $m
    }
    menu $m -tearoff no
    Create3rdButtonMenu $m        
}

proc UpdateMouseMenuGraph {} {
    Set3dButtonVariablesGraph
    set m .gid.display3dbutton_graph
    #$m delete 0 end
    if { [winfo exists $m] } {
        destroy $m
    }
    menu $m -tearoff no
    Create3rdButtonMenuGraph $m        
}

proc ChangeTopMenusAndWindows {} {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    if { ![winfo exists .gid.central]} {
        return
    }
    update idletasks ; # otherwise starting with 'copy window' open, and theme 'GiD_classic' the StdBar buttons are not shown
    OpenOutsideWindows [GetCurrentPrePostMode]
    UpdateTopMenus
    UpdateMouseMenu
    UpdateMouseMenuGraph
    update idletasks    
    #GiD_Redraw ;#try to avoid this redraw to avoid double redraw changing to post
}

proc UpdateTopMenus {} {
    global GidPriv
    set geomname PrePostTopMenuWindowGeom
    if { [info exists ::GidPriv($geomname)] } {
        set val $::GidPriv($geomname)    
        #check if the widget exists and then not re-create it when swapping pre <-> post
        regsub {Geom$} $geomname {} geomwinname
        if { [info exists ::GidPriv($geomwinname)] && [winfo exists $::GidPriv($geomwinname)] } {               
            set recreate 0
        } else {
            set recreate 1
        }                        
        if { $recreate } {
            set command [lindex $val 3]
            if {[catch { {*}$command } msg]} {
                lappend tb_errors "$geomname \n\t $msg"
            }
        }
    }
    return 0    
} 

set DelayedConfigureButsVar 0
set DelayedConfigureSize "0 0"

proc DelayedConfigureButsFunc {} {
    global DelayedConfigureButsVar DelayedConfigureSize GidPriv

    incr DelayedConfigureButsVar -1
    if { $DelayedConfigureButsVar > 0 } {  return }
    if { ![winfo exists .gid.buts] } {
        set GidPriv(PrePostRightButWindowGeom) [list NONE {} 1 RightButtons]
    } elseif { [winfo class .gid.buts] == "Toplevel" } {
        set GidPriv(PrePostRightButWindowGeom) [list OPEN [wm geometry .gid.buts] 1 RightButtons]
    } else {
        set GidPriv(PrePostRightButWindowGeom) [list INSIDE {} 1 RightButtons]
    }
    if { [winfo exists .gid.buts] } {
        set w [winfo width .gid.buts]
        set h [winfo height .gid.buts]
        if { $w != [lindex $DelayedConfigureSize 0] || $h != [lindex $DelayedConfigureSize 1] } {
            SetButtons
            set DelayedConfigureButsVar 0
            set DelayedConfigureSize "$w $h"
        }
    }
}

proc SetButtons { { first 0 } } {
    global ActionsMenuVar ActionsMenuLabels ActionsMenuVarType PostButStack
    
    set w .gid.buts.f
    if { ![info exists ::ActionsMenuVarType] || ![winfo exists $w] } {
        return
    }

    set labels_and_commands ""
    if { $::ActionsMenuVarType == "TMP" && $::ActionsMenuFunction == "Utilities Variables" } {
        set labels_and_commands [GetLabelsAndCommandsFromActionsMenuVar]                  
    } else {
        foreach command $::ActionsMenuVar label $::ActionsMenuLabels {            
            #lappend labels_and_commands [list $label [list GiD_Process $command]]
            #to not show translated right button commands
            lappend labels_and_commands [list $command [list GiD_Process $command]]
        }
    }

    set packLeft 0
    set packRight 0

    if { $first == 0 || ![info exists PostButStack]} { set PostButStack "" }
    if { [ winfo exists $w.al ] } {
        if { $PostButStack != "" } {
            set num [lindex $PostButStack [expr [llength $PostButStack]-1]]       
            set packLeft 1
            $w.al configure -command "set PostButStack \"[lrange $PostButStack 0 [expr [llength $PostButStack]-2]]\" ; SetButtons $num"
        } else {       
            place forget $w.al 
        }
    }

    if { [ winfo exists $w.ar ] } {
        place forget $w.ar
    }
    set xpos 0 ; set ypos 0
    set butpady 2
    #if { [winfo width $w] == 1 } {
    #sobra?# update idletasks
    #}

    # set tothei [expr [winfo height $w]-20]
    set tothei [expr [winfo height $w]-50]
    # W "arrow = [ winfo reqheight $w.al] x [ winfo reqwidth $w.al]"
    # == 30 x 30
    # W "button = [ winfo reqheight $w.b0] x [ winfo reqwidth $w.b0]"
    # == 25 x 104
    # --> tothei = height - 50
    set totwid [winfo width $w]
    set overflow 0
    set last [llength $labels_and_commands]

    set arrowYpos $ypos
    set k 0
    foreach item $labels_and_commands {
        lassign $item label command
        if { ![winfo exists $w.b$k] } {
            # en macOsX los botoncitos tienen los extremos redondos: necesitan un poco mas de espacio
            #create initially only GidPriv(MaxRightButtons)=300 buttons, but more could be required
            ttk::button $w.b$k -width 20 -takefocus 0 -style RightButtons.IconButton
            #in ttk width is number os characters: -width $rightButtonWidth 
            if { $::GidPriv(MaxRightButtons) < $k } {
                set ::GidPriv(MaxRightButtons) $k
            }
        }
        if {$k < $first || $k>=$last || $overflow } {
            place forget $w.b$k
        } else {
            $w.b$k configure -text $label -command $command
            place $w.b$k -x $xpos -y $ypos
            set reqh [ winfo reqheight $w.b$k]
            set ypos [ expr $ypos + $reqh + $butpady]
            set arrowYpos $ypos
            set arrowXpos $xpos
            #incr ypos 31
            if { $ypos > $tothei && $k < [expr $last-1] } {
                incr xpos 130
                if { [expr $xpos+80] > $totwid } {
                    set packRight 1

                    set err [ catch {
                        $w.ar configure -command "lappend PostButStack $first ; SetButtons [expr $k+1]"
                    }]
                    if { $err} {
                        #W "err $err\n [GidUtils::GetStackTrace]"
                        # image error because of changing theme and after...
                        set img_ar [ gid_themes::GetImage ArrowRight.png medium_icons]
                        # set img_al [ gid_themes::GetImage ArrowLeft.png medium_icons]
                        $w.ar configure -image $img_ar
                        $w.ar configure -command "lappend PostButStack $first ; SetButtons [expr $k+1]"
                    }
                    set overflow 1
                }
                set ypos 5
            }
        }
        incr k
    }

    set arrowYpos [ expr $arrowYpos - $butpady]
    if { $packLeft} {
        place $w.al -x 0 -y $arrowYpos
    }    
    if { $packRight} {
        place $w.ar -x [ expr $totwid - [ winfo reqwidth $w.ar]] -y $arrowYpos
    }    

    #hide the rest of buttons, assumed that 300 is a maximum of visible buttons of the right buttons
    for {set k $last } { $k< $::GidPriv(MaxRightButtons) } { incr k } {
        if { ![winfo exists $w.b$k] } {
            break
        }
        place forget $w.b$k        
    }
}

proc MenuInCommandButton { e x y } {
    global ActionsMenuVar

    set w .gid.menuincommandwindow
    catch { destroy $w }
    menu $w
    set words ""
    foreach i $::ActionsMenuVar {
        regsub -all {([a-z])([A-Z])} $i "\\1 \[string tolower \\2]" name
        set name [subst $name]
        set name [string toupper [string index $name 0]][string range $name 1 end]
        if { $i == "Join" || $i == "NoJoin" } { append name " ${::acceleratorText}-a" }
        lappend words [ list $name "$e insert end \" $i\""]
    }
    rmenuconf $w $words

    $w add separator
    set UnderLineList {}
    set j [_ "Previous"]
    set under [FindUnderChar j UnderLineList]
    $w add command -label $j -underline $under -command [bind $e <Up>]
    set j [_ "Next"]
    $w add command -label $j -underline $under -command [bind $e <Down>]

    GiD_PopupMenu $w $x $y
}


proc AutoCompleteGiDEntry { e } {
    global ActionsMenuVar

    if { [string trim [$e get]] == "" } {
        if { [winfo exists .gid.wSetCoord.xe] } {
            focus .gid.wSetCoord.xe
        }
        return
    }
    if { [catch {
        set beginwords [lrange [$e get] 0 end-1]
        set lastword [lindex [$e get] end]
    }] } { return }

    if { $beginwords != "" } {
        $e delete 0 end
        $e insert end $beginwords
        uplevel #0 [bind $e <Return>]
        $e insert end $lastword
        after idle AutoCompleteGiDEntry $e
        return
    }

    set idx [lsearch -glob [string tolower $::ActionsMenuVar] [string tolower ${lastword}*]]
    set word [lindex $::ActionsMenuVar $idx]
    set wordoptions $word
    set isfull 1
    if { $idx != -1 } {
        set idx2 $idx
        while 1 {
            set idx2new [lsearch -glob [string tolower [lrange $::ActionsMenuVar [expr $idx2+1] end]] \
                             [string tolower ${lastword}*]]
            if { $idx2new == -1 } { break }
            set idx2 [expr $idx2+1+$idx2new]
            set newword [lindex $::ActionsMenuVar $idx2]
            lappend wordoptions $newword
            for { set i [string length $lastword] } { $i < [string length $word] } { incr i } {
                set l1 [string tolower [string index $word $i]]
                set l2 [string tolower [string index $newword $i]]
                if {  $l1 != $l2 } { break }
            }
            if { $i < [string length $word] } { set isfull 0 }
            set word [string range $word 0 [expr $i-1]]
        }
        set text [lrange [$e get] 0 end-1]
        $e delete 0 end
        if { $isfull } {
            $e insert end "$word "
        } else {
            $e insert end "$word"
            GidUtils::SetWarnLine [_ "Options: %s" $wordoptions]
        }
        $e icursor end
        $e xview moveto 1
    }
}

#prefix: Pre Post or PrePost
proc ReGridChildrenBitmapsGeom { toolbar_name bw StartFunc prefix } {
    #W [list ReGridChildrenBitmapsGeom $toolbar_name $bw $StartFunc $prefix]
    #temporary remove binding to avoid reentering
    set previous_binding [bind $bw <Configure>]
    bind $bw <Configure> ""

    global GidPriv
    set start_proc_name [lindex $StartFunc 0] ;#avoiding arguments
    
    regexp {[0-9]+x[0-9]+(.*)} [winfo geom $bw] trash rest

    set NumBitmaps 0
    while { [winfo exists $bw.$NumBitmaps] } {
        incr NumBitmaps
    }

    set w [winfo width $bw]
    set h [winfo height $bw]

    if { ![ info exists toolbarmacros::preferences(toolbar_one_col)]} {
        #toolbarmacros::ReadMacros
        # ramsan: init is used here to also load the macros accelerators for the case that the toolbar is not active
        toolbarmacros::Init
    }   

   
    set term Separadores
    
    set orientation ""
    if { [info exists ::ToolbarsPriv(toolbars)] } {
        foreach item $::ToolbarsPriv(toolbars) {
            set start_proc_name_item [lindex [lindex $item 2] 0]
            if { $start_proc_name_item == $start_proc_name } {
                set geomname [lindex $item 1]
                if { [info exists GidPriv($geomname)] } {
                    set position [lindex $GidPriv($geomname) 0]
                    if { $position == "INSIDELEFT" } {
                        set orientation vertical
                    } elseif { $position == "INSIDERIGHT" } {
                        set orientation vertical
                    } elseif { $position == "INSIDETOP" } {
                        set orientation horizontal
                    } elseif { $position == "INSIDEBOTTOM" } {
                        set orientation horizontal
                    } else {
                        set orientation ""
                    }
                }
                break
            }
        }
    }
    if { $orientation == "" } {
        if { $w > $h} {
            set orientation horizontal
        } else {
            set orientation vertical
        }
    }

    if { $orientation == "horizontal" } {
        # barra horizontal
        foreach icn $GidPriv($toolbar_name$term) {
            $bw.$icn configure -image [ gid_themes::GetImage sep_vert.png toolbar]
        }

        set nrow 1
        #enpaquetamos
        set children [winfo children $bw]

        if { $children != "" } {
            grid forget {*}$children
        }

        set ult 1
        set idx_layer_combo 14
        
        if { [info exists ::GID_LOGIN] && !$::GID_LOGIN_HIDE } {
            set idx_prepost [expr $NumBitmaps-4]
            set idx_password [expr $NumBitmaps-2]
            set idx_modelmanager [expr $NumBitmaps-1]
            set idx_login $NumBitmaps
        } else {
            set idx_prepost [expr $NumBitmaps-2]
            set idx_password $NumBitmaps
            set idx_modelmanager ""
            set idx_login ""
        }

        for { set ir 0} { $ir < $nrow} { incr ir} {
            set ic 0          
            for { set icn 0} { $icn < $NumBitmaps} { incr icn} { 
                if { $toolbar_name == "StdBar" } {
                    #special tricks
                    if { $ult == $idx_layer_combo } {
                        grid $bw.$icn  -in $bw.f$ir -row 0 -column $ic -sticky wns
                        #truco combobox layers
                        if { [ GetCurrentPrePostMode] == "PRE" } {
                            if { ![winfo exists $bw.flayer] } {
                                ttk::frame $bw.flayer -style Horizontal.ForcedFrame
                                CreateLayerCombo $bw.flayer
                            }
                            incr ic
                            grid $bw.flayer -in $bw.f$ir -row 0 -column $ic -padx 10 -sticky news
                        }
                    } elseif { $ult == $idx_prepost} {
                        # truco boton pre- post-
                        grid $bw.$icn -in $bw.f$ir -row 0 -column $ic -sticky ens
                        grid columnconfig $bw.f$ir $ic -weight 1
                        set GidPriv(PrePostButtonName) $bw.$icn
                    } elseif { $ult == $idx_password } {
                        # truco boton gid version academica / profesional
                        grid $bw.$icn -in $bw.f$ir -row 0 -column $ic -sticky ens
                        grid columnconfig $bw.f$ir $ic -weight 0
                        set GidPriv(InfoGiDButtonName) $bw.$icn
                        ShowGiDVersionType
                    } elseif { $ult == $idx_modelmanager } {
                        grid $bw.$icn -in $bw.f$ir -row 0 -column $ic -sticky ens
                        grid columnconfig $bw.f$ir $ic -weight 0
                    } elseif { $ult == $idx_login } {
                        grid $bw.$icn -in $bw.f$ir -row 0 -column $ic -sticky ens
                        grid columnconfig $bw.f$ir $ic -weight 0
                        set GidPriv(LoginGiDButtonName) $bw.$icn
                        if { [GiD_Login is_logged] } {
                            Login::UpdateLoginButton login [GiD_Login logged_username]
                        } else {
                            Login::UpdateLoginButton logout ""
                        }
                    } else {
                        grid $bw.$icn -in $bw.f$ir -row 0 -column $ic -sticky wns
                    }
                } else {
                    grid $bw.$icn -in $bw.f$ir -row 0 -column $ic -sticky wns
                }
                incr ic
                if { [ winfo class $bw.$icn] == "TLabel"} {
                    grid configure $bw.$icn -pady 0 -sticky wns
                }
                incr ult
            }
            grid rowconfig $bw.f$ir 0 -weight 1
            if { ( $toolbar_name != "StdBar") || ( [ expr $ir + 1] != $nrow)} {
                grid $bw.f$ir -sticky new
            } else {
                grid $bw.f$ir -sticky new
            }
            if {![winfo exists $bw.separator$ir]} {
              ttk::frame $bw.separator$ir -style SeparatorToolbar.TFrame
            }
            grid $bw.separator$ir -sticky new -ipadx 0 -ipady 0
            grid rowconfig $bw [expr $ir*2] -weight 1
            grid rowconfig $bw [expr $ir*2+1] -weight 1
            if { ( $toolbar_name == "StdBar") && ( $ult >= $NumBitmaps)} {
            }
        }
        grid columnconfig $bw 0 -weight 1

        set changed 0
        foreach ch [ winfo children $bw] {
            set changed [SetStyleHorizontalVertical $ch horizontal]
        }
        if { $changed } {
            if { [winfo class $bw] != "Toplevel" } { 
                SetStyleHorizontalVertical $ch horizontal
                #$bw configure -style Horizontal.IconButton
            }
        }

    } else {
        # barra vertical
        if { $toolbar_name == "StdBar"} {
            set NumBitmaps [ expr $NumBitmaps - 1]
        }
        # es mas vertical que horizontal ( enpaquetmos de arriba a abajo)
        set term Separadores
        foreach icn $GidPriv($toolbar_name$term) {
            $bw.$icn configure -image [ gid_themes::GetImage sep_hori.png toolbar]
        }
        set ncol 1

        #enpaquetamos
        set children [winfo children $bw]
        if { $children != "" } {
            grid forget {*}$children
        }

        for { set ic 0} { $ic < $ncol} { incr ic} {
            set ir 0
            for { set icn 0} { $icn < $NumBitmaps} { incr icn} {
                grid $bw.$icn -in $bw.f$ic -column 0 -row $ir -sticky nwe
                incr ir
                grid rowconfig $bw.f$ic $ir -weight 0
            }
            grid columnconfig $bw.f$ic 0 -weight 1
            grid $bw.f$ic -sticky nwes -column [expr $ic*2] -row 0
            grid columnconfig $bw $ic -weight 0
            if {![winfo exists $bw.separator$ic]} {
              ttk::frame $bw.separator$ic -style SeparatorToolbar.TFrame
            }
            grid $bw.separator$ic -sticky news -ipadx 0 -ipady 0 -column [expr $ic*2+1] -row 0
        }
        grid rowconfig $bw 0 -weight 1

        set changed 0
        foreach ch [ winfo children $bw] {
            set changed [SetStyleHorizontalVertical $ch vertical]
        }

        if { $changed && $::GidPriv(VerticalRoundBars) } {
            if { [winfo class $bw] != "Toplevel" } { 
                SetStyleHorizontalVertical $bw vertical
                #$bw configure -style Vertical.IconButton
            }
        }

    }

    if { [winfo class $bw] == "Toplevel" } {

        if { $toolbar_name == "StdBar" && [info exists GidPriv(ComboLayers,entry)] && [winfo exists $GidPriv(ComboLayers,entry)] } {
            incr w_width [winfo width $GidPriv(ComboLayers,entry)]
        }

        wm geometry $bw 
        #${w_width}x${w_height}$rest
        # OJO!!!!!  a nadie se le ocurra quitar este 'update', sin el
        # un segfault es generado en Tk_MapWindow mientras se hace un
        # resize de la window.
        update
        if { [winfo exists $bw] } {
            set trans 0
            if { [winfo class $bw] == "Toplevel" } {
                if { [wm transient $bw] != "" } {
                    set trans 1
                } else {
                    set trans 0
                }
            }
            set term WindowGeom
            set geomvarname $prefix$toolbar_name$term
            set GidPriv($geomvarname) [list OPEN [wm geometry $bw] $trans $StartFunc]
        }
    }
    if { [winfo exists $bw] } {
        #restore its binding
        bind $bw <Configure> $previous_binding
    }
    return 0
}

#
# Destroy a given widget. If the parent container remains empty it is
# also "grid_removed". Later on the parent container could be
# remembered if needed.
#
proc DestroySlave { w } {
    catch {array set grid_info [grid info $w]}
    destroy $w
    if {[info exists grid_info(-in)]} {
        # if w is gridded its parent must be a member of GiDTBLayout
        set parent $grid_info(-in)
        set idx [lsearch $::GiDTBLayout($parent) $w]
        if {![llength [set ::GiDTBLayout($parent) [lreplace $::GiDTBLayout($parent) $idx $idx]]]} {
            grid remove $parent
        }
    }
}

# GridInside --
#
# grid a widget w inside a master, making sure master is remembered in
# case it was previouly removed. master must be previously gridded with
# initial options.
#
proc GridInside { name w master sticky } {
    grid $master
    set slaves $::GiDTBLayout($master)
    if {$sticky eq "ns" || $sticky eq "sn"} {
        set c 0
        foreach s $slaves {
            if {[winfo exists $s]} {
                grid $s -in $master -row 0 -column $c -sticky $sticky
                incr c                
            }
        }
        grid $w -in $master -row 0 -column $c -sticky $sticky
    } else {
        set r 0
        foreach s $slaves {
            if {[winfo exists $s]} {
                grid $s -in $master -row $r -column 0 -sticky $sticky
                incr r                
            }
        }
        grid $w -in $master -row $r -column 0 -sticky $sticky
    }
    if { [lsearch ::GiDTBLayout($master) $w] == -1 } {
        lappend ::GiDTBLayout($master) $w
    }
    set ::GiDTBLayout(tb,$w) $name
}

proc esMac { } {
    if { $::tcl_platform(os) == "Darwin"} {
        return 1
    } else {
        return 0
    }
}

proc isMacOSVersionEqualOrGreater { name_or_number} {
    set it_is 0
    
    set lst_macos_versions [ list 10.14 10.15 11 12]
    set lst_macos_names [ list Mojave Catalina BigSur Monterey]
    set lst_darwin_versions [ list 18 19 20 21]

    if { ( $::tcl_platform(os) == "Darwin")} {
        lassign [ split $::tcl_platform(osVersion) .] major minor patch

        # 1st look for provided version
        set selected_idx [ lsearch $lst_macos_names $name_or_number]
        if { $selected_idx == -1} {
            set selected_idx [ lsearch $lst_macos_version $name_or_number]
        }
        if { $selected_idx == -1} {
            W "isMacOSVersionEqualOrGreater: provided '$name_or_number' can not be found"
            return $it_is
        }

        set selected_version [ lindex $lst_darwin_versions $selected_idx]

        if { $major >= $selected_version} {
            set it_is 1
        }
    }
    return $it_is
}

proc getMacOSInterfaceStyle {} {
    set macos_theme ""
    set err [ catch {
        # https://stackoverflow.com/questions/25207077/how-to-detect-if-os-x-is-in-dark-mode
        # defaults read NSGlobalDomain AppleInterfaceStyle
        # defaults read -g AppleInterfaceStyle
        # or
        # NSString *osxMode = [[NSUserDefaults standardUserDefaults] stringForKey:@"AppleInterfaceStyle"];
        # will return 'Dark' (@"Dark") if in Dark mode ( from Mojave on)
        # or nothing (nil) if in Light mode
        # to check if mac style is set to auto (from Catalina on):
        # https://developer.apple.com/forums/thread/118974
        # defaults read NSGlobalDomain AppleInterfaceStyleSwitchesAutomatically
        set macos_theme [ exec defaults read -g AppleInterfaceStyle]
    } err_txt ]
    return $macos_theme
}

proc SetStyleHorizontalVertical { w direction} { 

    if { [winfo class $w] == "Toplevel" || [winfo class $w] == "Menu" || [winfo class $w] == "Frame" } { return 0 }
    
    set ret 0
    set old_direction [$w cget -style]
    set old_direction [split $old_direction .]
    set horit [lsearch $old_direction Horizontal]
    set vert [lsearch $old_direction Vertical]
    if { $horit != -1 } {
        if { $direction eq "vertical"} {
            $w configure -style [join [lreplace $old_direction $horit $horit Vertical] .]
            set ret 1
        }    
    } elseif { $vert != -1 } {
        if { $direction eq "horizontal"} {
            $w configure -style [join [lreplace $old_direction $vert $vert Horizontal] .]
            set ret 1
        }
    } else {
        #WarnWinText "Some widget without horizontal or vertical defined"
    }   
    return $ret
}

# queda feo pero de momento es lo que hay,
# en mac no se admiten (menu)botones con iconos, gid pone labels y hace un bind
# para que aparezca el menu
# los menus se llaman igual que antes: name de icono + .m

proc CreateBitmaps { { what "DEFAULT" } } {
    global GidPriv GiDPrivToolBar
    
    set w .gid.bitmaps
    set title [_ "Geometry & View bar"]
    AddNewToolbar "Geometry & View bar" PrePostBitmapsWindowGeom CreateBitmaps $title
    
    if { ![info exists GidPriv(PrePostBitmapsWindowGeom)] && $what == "NONE" } {
        set GidPriv(PrePostBitmapsWindowGeom) NONE
    }
    set vv $GidPriv(PrePostBitmapsWindowGeom)
    # esta parte intenta corregir algunos gidDefaults corruptos
    if {[lindex $vv end] ne "CreateBitmaps"} {
        set ll [llength $vv]
        set vv [concat $vv  [lrange {INSIDELEFT 1 1 CreateBitmaps} $ll end]]
        set GidPriv(PrePostBitmapsWindowGeom) $vv
    }
    if { $what != "DEFAULT" } {
        set GidPriv(PrePostBitmapsWindowGeom) "$what [lrange $vv 1 end]"
    }
    DestroySlave $w
    if { [lindex $GidPriv(PrePostBitmapsWindowGeom) 0] == "NONE" } {
        return
    }
    
    if { ![string match INSIDE* [lindex $GidPriv(PrePostBitmapsWindowGeom) 0]] } {
        InitWindow2 $w -title [_ "Geom & view operations"] \
            -geometryvariable PrePostBitmapsWindowGeom \
            -initcommand CreateBitmaps -ontop -nodestroy
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        
        wm transient $w .gid
        catch { wm attributes $w -toolwindow 1 }
        $w config -background $GidPriv(Color,ToolbarBg)
        
        set bitmap_geom "[winfo width $w]x[winfo height $w]"
    } else {
        set vv $GidPriv(PrePostBitmapsWindowGeom)
        set GidPriv(PrePostBitmapsWindowGeom) $vv
        set GiDPrivToolBar(PrePostBitmapsWindowGeom) $w
        
        ttk::frame $w -style Horizontal.ForcedFrame
        bind $w <Destroy> "+ unset GiDPrivToolBar(PrePostBitmapsWindowGeom)"
        
        regexp {([a-zA-Z]*)([0-9]*)} [lindex $GidPriv(PrePostBitmapsWindowGeom) 0] {} where pos
        set icon_size 29 ;#try to set the final size to avoid an extra resize -> ReGridChildrenBitmapsGeom
        set widget ""
        switch $where {
            INSIDETOP {
                GridInside PrePostBitmapsWindowGeom $w .gid.top "we"
                $w configure -height $icon_size
            }
            INSIDELEFT {
                GridInside PrePostBitmapsWindowGeom $w .gid.left "ns"
                $w configure -width $icon_size
            }
            INSIDEBOTTOM {
                GridInside PrePostBitmapsWindowGeom $w .gid.bottom "we" 
                $w configure -height $icon_size   
            }
            INSIDERIGHT {
                GridInside PrePostBitmapsWindowGeom $w .gid.right "ns"
                $w configure -width $icon_size
            }
        }
    }
    
    UpdateToolbarGeometryAndView
    if { [winfo class $w] == "Toplevel" } {
        bind $w <Leave> [ list wm title $w $title]
        foreach i [bind .gid] {
            bind $w $i [bind .gid $i]
        }
    }
    #W  "CreateBitmaps bind $w <Configure> ReGridChildrenBitmapsGeom Bitmaps $w CreateBitmaps PrePost"
    bind $w <Configure> [list ReGridChildrenBitmapsGeom Bitmaps $w CreateBitmaps PrePost]
    return $w
}

#update the "Geometry & View bar" toolbar from the BitMapsNames, etc contents
proc UpdateToolbarGeometryAndView { } {
    global BitMapsNames BitMapsCommands BitmapsHelp
    global BitMapsNamesP BitMapsCommandsP BitmapsHelpP
    global BitMapsShortNames BitMapsShortNamesP
    global GidPriv

    set w .gid.bitmaps
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    if { ![winfo exists $w] } {
        return
    }
    foreach item [winfo children $w] {
        destroy $item
    }
    set separadores ""
    set num_separadores  0
    set round_bar 0
    set round_bar_v 0
    if { [winfo width $w] >= [winfo height $w]} {
        set separadores V
        set round_bar 1
    } else {
        set separadores H
        set round_bar_v $::GidPriv(VerticalRoundBars)
    }

    if { [ GetCurrentPrePostMode] == "PRE" } {
        upvar #0 BitMapsNames names
        upvar #0 BitMapsCommands commands
        upvar #0 BitmapsHelp thehelp
        if { [ info exists BitMapsShortNames]} {
            upvar \#0 BitMapsShortNames shortnames
        } else {
            set shortnames(0) ""
        }
    } else {
        upvar #0 BitMapsNamesP names
        upvar #0 BitMapsCommandsP commands
        upvar #0 BitmapsHelpP thehelp
        if { [ info exists BitMapsShortNamesP]} {
            upvar \#0 BitMapsShortNamesP shortnames
        } else {
            set shortnames(0) ""
        }
    }

    set i 0
    set GidPriv(BitmapMenus) 0
    set GidPriv(BitmapsSeparadores) ""
    set GidPriv(BitmapsMenusList) ""
    set reqmbw 0
    set reqmbh 0
    set reqmbbw 0
    set reqbw 0
    set reqbh 0
    set lst_botones ""    
    foreach j $names(0) {
        # para rehacer los bitmaps con separadores
        ttk::frame $w.f$i -style ForcedFrame
        if { $round_bar} {
            $w.f$i configure -style Horizontal.ForcedFrame
        } elseif { $round_bar_v} {
            $w.f$i configure -style Vertical.ForcedFrame
        }

        if { $j != "---" } {
            if { ![info exists names(0,$i)] } {
                ttk::button $w.$i -image [ gid_themes::GetImage $j toolbar] -style Horizontal.IconButton
                set icon_text [ file root $j]
                if { $shortnames(0) != ""} {
                    set icon_text [ lindex $shortnames(0) $i]
                }
                IconTextConfigureLook $w.$i [ gid_themes::GetImage $j toolbar] $icon_text
                
                if { $::tcl_platform(platform) == "windows" } {
                    bind $w.$i <ButtonRelease-1> "catch \"focus .gid.comm.e\" "
                }
                set comm [lindex $commands(0) $i]
                regsub -all {%I} $comm $i comm
                EnterCommand $w.$i $comm
                set reqbw [ winfo reqwidth $w.$i]
                set reqbh [ winfo reqheight $w.$i]
                lappend lst_botones $w.$i
                
            } else {
                ttk::menubutton $w.$i \
                    -image [ gid_themes::GetImage $j toolbar] \
                    -style Horizontal.IconButtonWithMenu \
                    -menu $w.$i.m -direction right
                if { $shortnames(0) != ""} {
                    set icon_text [ lindex $shortnames(0) $i]
                }
                IconTextConfigureLook $w.$i [ gid_themes::GetImage $j toolbar] $icon_text
                #$w.$i configure -style Horizontal.IconButtonWithMenu
                
                menu $w.$i.m -tearoff no
                
                set comm [lindex $commands(0) $i]
                regsub -all {%I} $comm $i comm
                if { $comm != "" } {
                    EnterCommand $w.$i.m $comm -2
                }
                set ii 0
                foreach jj $names(0,$i) {
                    $w.$i.m add command -image [ gid_themes::GetImage $jj toolbar] -hidemargin 1                   
                    set comm [lindex $commands(0,$i) $ii]
                    regsub -all {%I} $comm $ii comm
                    EnterCommand $w.$i.m $comm $ii
                    incr ii
                }
                incr GidPriv(BitmapMenus)
                set reqmbw [winfo reqwidth $w.$i]
                set reqmbh [winfo reqheight $w.$i]
                #ttk no borderwidth option set reqmbbw [$w.$i cget -borderwidth]
                set reqmbbw 0
            }
            #nos pone un borde uno en los menubuttons que queda feo
            lappend GidPriv(BitmapsMenusList) $i
            
            set help [lindex $thehelp(0) $i]
            
            if { "$help" != ""} {
                GidHelpT $w.$i $help
            }

        } else {
            if { $separadores != "" } {
                if { $separadores == "H" } {
                    set archivo sep_hori.png
                } else {
                    set archivo sep_vert.png
                }
                ttk::label $w.$i -image [ gid_themes::GetImage $archivo toolbar] -style Horizontal.ForcedLabel
                #-style ForcedLabel
                incr num_separadores
                lappend GidPriv(BitmapsSeparadores) $i
            } else {
                ttk::label $w.$i -style Horizontal.ForcedLabel
                #-style ForcedLabel
            }
        }
        if { $round_bar} {
            #$w.$i could be TButton, TMenuButton or TLabel
            SetStyleHorizontalVertical $w.$i horizontal
        } elseif { $round_bar_v} {
            #$w.$i could be TButton, TMenuButton or TLabel
            SetStyleHorizontalVertical $w.$i vertical
        }
        incr i
    }

    if { [GetCurrentPrePostMode] == "POST" } {
        # to update the toobar and window sets image
        OnSetDisplayStyle [GiD_Set DisplayStyle]
    }

    ReGridChildrenBitmapsGeom Bitmaps $w CreateBitmaps PrePost
    return 0
}

#Procedure to create an additional toolbar
#toolbar_name: internal toolbar name "<name> bar" (must finish with 'bar', and a unique name)
#      this name must be the same used by AddNewToolbar and ReleaseToolbar
#title: a text (marked for translation)
#BitMapsNames: name of a global variable that store a list of filenames with the button images (.png)
#BitMapsCommands: name of a global variable that store a list of button commands
#BitmapsHelp: name of a global variable that store a list of button commands help strings (translated)
#BitmapsPath: the full path to the images
#StartFunc: the proc name the create the bar calling CreateOtherBitmaps and AddToolbar
#type: bar location: "DEFAULT|INSIDELEFT|INSIDERIGHT|INSIDETOP|INSIDEBOTTOM|OUTSIDE?"
#      e.g. "INSIDELEFT"
#prefix: where to show bar: Pre|Post|PrePost

proc CreateOtherBitmaps { toolbar_name title BitMapsNames BitMapsCommands BitmapsHelp \
                              BitmapsPath StartFunc type prefix { BitMapsShortNames ""}} {
    if { [GidUtils::IsTkDisabled] } {
        return 0
    }                                  
    global GidPriv GiDPrivToolBar   
    if { [llength $type]==2 && [lindex $type 0] == "DEFAULT" } {
        #compatibilyty with old problemtypes that use "DEFAULT INSIDELEFT" 
        set type [lindex $type 1]
    }
    if { $type == "" } {
        set type "DEFAULT"
    } elseif { [llength $type] != 1 } {
        W "CreateOtherBitmaps: unexpected type=$type"
        set type "DEFAULT"
    }
    set term WindowGeom
    set w .gid.bitmaps
    DestroySlave $w$toolbar_name
    set geomvarname $prefix$toolbar_name$term
    if { [info exists GidPriv($geomvarname)] } {
        set vv $GidPriv($geomvarname)
        set _head_ [lrange $vv 0 2]
        set _ll_ [llength $vv]
        if {$_ll_ == 1} {
            lappend _head_ {} 1
        } elseif {$_ll_ == 2} {
            lappend _head_ 1
        }
        if { [llength $_head_] != 3 } {
            W "CreateOtherBitmaps: unexpected _head_=$_head_"
        }
        if { $type == "DEFAULT" } {
            set GidPriv($geomvarname) [list {*}$_head_ $StartFunc]
        } else {
            set GidPriv($geomvarname) [list $type {*}[lrange $_head_ 1 2] $StartFunc]
        }
        if { [lindex $GidPriv($geomvarname) 0] == "NONE" } {
            return ""
        }  
    } elseif { $type != "" } {
        set GidPriv($geomvarname) [list $type {} 1 $StartFunc]
    } else {
         W "CreateOtherBitmaps: unexpected case"
    }
    # y en este else que puede pasar ?

    
    set mode [GetCurrentPrePostMode]

    # busco si hay otra TB previa con este proc asociado, si existe le
    # dejo solo la posicion.
    set _this_ $geomvarname
    set _this_cmd_ [lindex $StartFunc 0]
    foreach _tb_ "$::GiDTBLayout(INSIDE,PRE) $::GiDTBLayout(INSIDE,POST)" {
        if {$_tb_ eq $_this_} continue
        set _cmd_ [lindex [lindex $GidPriv($_tb_) 3] 0]
        if {$_cmd_ eq $_this_cmd_} {
            # esta es una TB que se crea con mi mismo proc, por tanto
            # solo le dejo la posicion para que no me moleste.
            set GidPriv($_tb_) [lindex $GidPriv($_tb_) 0]
        }
    }

    if { $prefix != "PrePost" } {
        if { ($mode == "POST" && ![string match *Post* $prefix]) || \
            ($mode == "PRE" && [string match *Post* $prefix]) } {
            if { [info exists GidPriv($geomvarname)] } {
                set aa [lindex $GidPriv($geomvarname) 0]
            }
            #             catch {
            #                 DestroySlave $w$toolbar_name
            #             }
            if { [info exists GidPriv($geomvarname)] } {
                set GidPriv($geomvarname) \
                    "$aa [lrange $GidPriv($geomvarname) 1 end]"
            }
            return ""
        }
    }


    set separadores ""
    set num_separadores  0
    set round_bar 0
    set round_bar_v 0

    if { ![info exists GidPriv($geomvarname)] || \
             ![string match INSIDE* [lindex $GidPriv($geomvarname) 0]] } {
        InitWindow2 $w$toolbar_name -title $title -geometryvariable $geomvarname \
            -initcommand $StartFunc -ontop -nodestroy
        if { ![winfo exists $w$toolbar_name] } {
            # windows disabled || UseMoreWindows == 0
            return ""
        }

        wm transient $w$toolbar_name .gid
        catch { wm attributes $w$toolbar_name -toolwindow 1 }
        $w$toolbar_name config -background $GidPriv(Color,ToolbarBg)
        set bitmap_geom "[ winfo width $w$toolbar_name]x[ winfo height $w$toolbar_name]"     
        if { [ winfo width $w$toolbar_name] >= [ winfo height $w$toolbar_name]} {
            set separadores V
            set round_bar 1            
        } else {
            set separadores H
            set round_bar_v $::GidPriv(VerticalRoundBars)            
        }        
    } else {
        set vv $GidPriv($geomvarname)
        set GidPriv($geomvarname) $vv
        set GiDPrivToolBar($geomvarname) $w$toolbar_name

        set GidPriv($prefix${toolbar_name}Window) $w$toolbar_name

        ttk::frame $w$toolbar_name -style Horizontal.ForcedFrame       

        bind $w$toolbar_name <Destroy> "+ unset GiDPrivToolBar($geomvarname)"

        regexp {([a-zA-Z]*)([0-9]*)} [lindex $GidPriv($geomvarname) 0] {} where pos
        set icon_size 29 ;#try to set the final size to avoid an extra resize -> ReGridChildrenBitmapsGeom
        set widget ""
        switch $where {
            INSIDETOP {
                GridInside $geomvarname $w$toolbar_name .gid.top "we"
                set separadores V        
                set round_bar 1
                $w$toolbar_name configure -height $icon_size   
            }
            INSIDELEFT {
                GridInside $geomvarname $w$toolbar_name .gid.left "ns"
                set separadores H
                set round_bar_v $::GidPriv(VerticalRoundBars)                
                $w$toolbar_name configure -width $icon_size
            }
            INSIDEBOTTOM {
                GridInside $geomvarname $w$toolbar_name .gid.bottom "we"
                set separadores V
                set round_bar $::GidPriv(VerticalRoundBars)
                $w$toolbar_name configure -height $icon_size
            }
            INSIDERIGHT {
                GridInside $geomvarname $w$toolbar_name .gid.right "ns"
                set separadores H
                set round_bar_v $::GidPriv(VerticalRoundBars) 
                $w$toolbar_name configure -width $icon_size      
            }

        }
    }

    upvar #0 $BitMapsNames names
    upvar #0 $BitMapsCommands commands
    upvar #0 $BitmapsHelp thehelp
    if { $BitMapsShortNames != ""} {
        upvar \#0 $BitMapsShortNames shortnames
    } else {
        set shortnames(0) ""
    }
    if { [winfo class $w$toolbar_name] == "Toplevel" } {
        $w$toolbar_name configure -background $::GidPriv(CustomColor,ToolbarBg)
    } else {
        if { $round_bar} {
            SetStyleHorizontalVertical $w$toolbar_name horizontal           
        } elseif { $round_bar_v} {
            SetStyleHorizontalVertical $w$toolbar_name vertical            
        }
    }


    #already not set problemtype to use: [ GiD_Info Project ProblemType]
    if { $BitmapsPath == "GiD_image_folder" } {
        set ptpref ""
    } elseif { [regexp {problemtypes[/|\\](.*)} $BitmapsPath dummy problemtype] } {
        set ptpref "$problemtype/"
    } else {
        set ptpref "$BitmapsPath/"
    }
   
    set term_sep Separadores
    set term_ml  MenusList
    set GidPriv($toolbar_name$term_sep) ""
    set GidPriv($toolbar_name$term_ml) ""   
    set i 0
    foreach j $names(0) {
        # para rehacer los bitmaps con separadores
        ttk::frame $w$toolbar_name.f$i -style Horizontal.ForcedFrame
        if { $round_bar} {
            SetStyleHorizontalVertical $w$toolbar_name.f$i horizontal
        } elseif { $round_bar_v} {
            SetStyleHorizontalVertical $w$toolbar_name.f$i vertical
        }

        if { $j == ""} {
            if { $separadores == "H" } {
                set j blank_vertical.png
            } else {
                set j blank_horizontal.png
            }
        }

        if { $j != "---" } {
            #warning: not use gid_themes::GetImage because image must be outside /bitmaps
            #GetImageGiDorProblemtype solve this problem
            
            if { ![info exists names(0,$i)] } {
                set pref [ lindex $j 0]
                if { ( [ llength $j] != 1) && ( $pref == "-np-")} {
                    # set cmd_widget [ regsub -all {%W} [ lrange $j 1 end] $w$toolbar_name.$i]
                    regsub -all {%W} [ lrange $j 1 end] $w$toolbar_name.$i cmd_widget
                    regsub -all {%I} $cmd_widget $i cmd_widget
                    regsub -all {%X} $cmd_widget [ winfo pointerx .gid] cmd_widget
                    regsub -all {%Y} $cmd_widget [ winfo pointery .gid] cmd_widget
                    eval $cmd_widget
                } else {
                    ttk::button $w$toolbar_name.$i -image [GetImageGiDorProblemtype $BitmapsPath $j] -style Horizontal.IconButton
                    set icon_text [ file root $j]
                    if { $shortnames(0) != ""} {
                        set icon_text [ lindex $shortnames(0) $i]
                    }
                    IconTextConfigureLook $w$toolbar_name.$i [ GetImageGiDorProblemtype $BitmapsPath $j ] $icon_text                    
                }               
                if { $::tcl_platform(platform) == "windows" } {
                    bind $w$toolbar_name.$i <ButtonRelease-1> "catch \"focus .gid.comm.e\" "
                }
                set comm [lindex $commands(0) $i]
                regsub -all {%I} $comm $i comm
                EnterCommand $w$toolbar_name.$i $comm
                
            } else {
                ttk::menubutton $w$toolbar_name.$i \
                    -image [ GetImageGiDorProblemtype $BitmapsPath $j ] \
                    -style Horizontal.IconButtonWithMenu \
                    -menu $w$toolbar_name.$i.m -direction right
                set icon_text [ file root $j]
                if { $shortnames(0) != ""} {
                    set icon_text [ lindex $shortnames(0) $i]
                }
                IconTextConfigureLook $w$toolbar_name.$i [ GetImageGiDorProblemtype $BitmapsPath $j ] $icon_text               
                #$w$toolbar_name.$i configure -style Horizontal.IconButtonWithMenu

                menu $w$toolbar_name.$i.m -tearoff no               
                set comm [lindex $commands(0) $i]
                regsub -all {%I} $comm $i comm
                if { $comm != "" } { EnterCommand $w$toolbar_name.$i.m $comm -2}
                set ii 0
                foreach jj $names(0,$i) {
                    if { $jj == ""} {
                        if { $separadores == "H" } {
                            set jj blank_vertical.png
                        } else {
                            set jj blank_horizontal.png
                        }
                    }
                    $w$toolbar_name.$i.m add command -image [ GetImageGiDorProblemtype $BitmapsPath $jj ] -hidemargin 1                   
                    set comm [lindex $commands(0,$i) $ii]
                    regsub -all {%I} $comm $ii comm
                    EnterCommand $w$toolbar_name.$i.m $comm $i
                    incr ii
                }
            }
            #nos pone un borde uno en los menubuttons que queda feo
            lappend GidPriv($toolbar_name$term_ml) $i
            
            set help [lindex $thehelp(0) $i]
                      
            set cls [ winfo class $w$toolbar_name.$i]
            if { $cls  != "Label"} {
                if { $round_bar} {                       
                    bind $w$toolbar_name.$i <Enter> "+catch { wm title $w$toolbar_name \"$help\" }"                       
                } elseif { $round_bar_v} {                       
                    bind $w$toolbar_name.$i <Enter> "+catch { wm title $w$toolbar_name \"$help\" }"                       
                } else {                     
                    bind $w$toolbar_name.$i <Enter> "+catch { wm title $w$toolbar_name \"$help\" }"                        
                }                
            }           
            
            if { "$help" != ""} {
                GidHelpT $w$toolbar_name.$i $help          
            }
            
        } else {
            if { $separadores != "" } {
                if { $separadores == "H" } {
                    set archivo sep_hori.png
                } else {
                    set archivo sep_vert.png
                }
                
                ttk::label $w$toolbar_name.$i -image [ gid_themes::GetImage $archivo toolbar] -style Horizontal.ForcedLabel               
                incr num_separadores
                lappend GidPriv($toolbar_name$term_sep) $i
            } else {
                ttk::label $w$toolbar_name.$i -style Horizontal.ForcedLabel               
            }
        }
        if { $round_bar} {           
            SetStyleHorizontalVertical $w$toolbar_name.$i horizontal           
        } elseif { $round_bar_v} {            
            SetStyleHorizontalVertical $w$toolbar_name.$i vertical           
        }       
        incr i
    }
    
    if { [winfo class $w$toolbar_name] == "Toplevel" } {
        bind $w$toolbar_name <Leave> [ list wm title $w$toolbar_name $title]
        
        foreach i [bind .gid] {
            bind $w$toolbar_name $i [bind .gid $i]
        }
    }   
    #update -> this update is problematic -> toolbar become not packed
    bind $w$toolbar_name <Configure> [list ReGridChildrenBitmapsGeom $toolbar_name $w$toolbar_name $StartFunc $prefix]
    #update
    return $w$toolbar_name
}

proc SetAllLatersTo { onoff } {
    GiD_Process 'Layers
    if { $onoff == "ON" } {
        foreach i [ GiD_Info layers -off] {
            GiD_Process On $i
        }
    } else {
        foreach i [ GiD_Info layers -on] {
            GiD_Process Off $i
        }
    }
    GiD_Process escape
    Layers::FillInfo
}

proc AddLayerOnOff { onoff w basecommand } {
    global GidPriv
    $w delete 0 end
    if { $onoff == "ON" } {
        set words [list [list [_ "-All-"] "SetAllLatersTo $onoff"]]
        set LayerNames [ GiD_Info layers -off]
        if { [info exists GidPriv(LayersAlphabetic)] && $GidPriv(LayersAlphabetic) } {
            set LayerNames [lsort -dictionary $LayerNames]
        }

        set ic 0
        foreach i $LayerNames {
            lappend words [list $i "$basecommand [list $i] escape ; Layers::FillInfo"]
            incr ic
            if { $ic > 6 } {
                lappend words [list "..." Layers::ChangeLayers]
                break
            }
        }
        rmenuconf $w $words
    } elseif { $onoff == "OFF" } {
        set words [list [list [_ "-All-"] "SetAllLatersTo $onoff"]]
        set LayerNames [ GiD_Info layers -on]
        if { [info exists GidPriv(LayersAlphabetic)] && $GidPriv(LayersAlphabetic) } {
            set LayerNames [lsort -dictionary $LayerNames]
        }
        set ic 0
        foreach i $LayerNames {
            lappend words [list $i "$basecommand [list $i] escape ; Layers::FillInfo"]
            incr ic
            if { $ic > 6 } {
                lappend words [list "..." Layers::ChangeLayers]
                break
            }
        }
        rmenuconf $w $words
    } else {
        set layertouse [ GiD_Info Project LayerToUse]
        set LayerNames [GiD_Layers list]
        if { [info exists GidPriv(LayersAlphabetic)] && $GidPriv(LayersAlphabetic) } {
            set LayerNames [lsort -dictionary $LayerNames]
        }
        set words ""
        set ic 0
        foreach i $LayerNames {
            if { $i != $layertouse } {
                lappend words [list $i "$basecommand [list $i] escape ; Layers::FillInfo"]
            } else {
                lappend words [list $i "$basecommand [list $i] escape ; Layers::FillInfo" check]
            }
            incr ic
            if { $ic > 6 } {
                lappend words [list "..." Layers::ChangeLayers]
                break
            }
        }
        rmenuconf $w $words
    }
}

proc LayerEntitiesSub { w entity } {
    global GidPriv
    set LayerNames [GiD_Layers list]
    if { [info exists GidPriv(LayersAlphabetic)] && $GidPriv(LayersAlphabetic) } {
        set LayerNames [lsort -dictionary $LayerNames]
    }
    set words ""
    set ic 0
    foreach i $LayerNames {
        set command [list GiD_Process 'Layers Entities $i LowerEntities]
        if { [GiD_Set LayersAlsoLower] } {
            lappend command LowerEntities
        }
        if { $GidPriv(LayersAlsoHigher) } {
            lappend command HigherEntities
        }
        lappend command $entity
        lappend words [list $i $command]
        incr ic
        if { $ic > 6 } {
            lappend words [ list "..." Layers::ChangeLayers]
            break
        }
    }    
    rmenuconf $w $words
}

proc LayerEntities { w } {
    global GidPriv

    set geom_labels [GetGeometryLabels 1]   
    set geom_commands [GetGeometryCommands 1]  
    set mesh_labels [GetMeshLabels 1]   
    set mesh_commands [GetMeshCommands 1]   

    $w delete 0 end

    set ::GidPriv(LayersAlsoLower) [GiD_Set LayersAlsoLower]
    set ::GidPriv(LayersAlsoHigher) [GiD_Set LayersAlsoHigher]
    $w add checkbutton -label [_ "Also lower entities"]  -variable ::GidPriv(LayersAlsoLower) -command {GiD_Set LayersAlsoLower $::GidPriv(LayersAlsoLower)}
    $w add checkbutton -label [_ "Also higher entities"] -variable GidPriv(LayersAlsoHigher) -command {GiD_Set LayersAlsoHigher $::GidPriv(LayersAlsoHigher)}    

    switch [ GiD_Info Project ViewMode] {
        GEOMETRYUSE {
            foreach i $geom_commands j $geom_labels {
                if { $j eq "---" } {
                    $w add separator
                    continue
                }
                set menuname [join "$w . [string tolower $i]" ""]
                $w add cascade -label $j -menu $menuname
                if { ![winfo exists $menuname] } {
                    menu $menuname -postcommand [list LayerEntitiesSub $menuname $i]
                } else {
                    $menuname configure -postcommand [list LayerEntitiesSub $menuname $i]
                }
            }
        }
        MESHUSE {
            foreach i $mesh_commands j $mesh_labels {
                if { $j eq "---" } {
                    $w add separator
                    continue
                }
                set menuname [join "$w . [string tolower $i]" ""]
                $w add cascade -label $j -menu $menuname
                if { ![winfo exists $menuname] } {
                    menu $menuname -postcommand [list LayerEntitiesSub $menuname $i]
                } else {
                    $menuname configure -postcommand [list LayerEntitiesSub $menuname $i]
                }
            }
        }
    }
}

proc PostActualizeStateLightsSubMenu { w} {
    set num_lights [ GiD_Info postprocess get num_lights]
    # 1 - one light
    # 2 - two lights
    # 3 - three lights
    # 4 - blue light
    # 5 - orange light
    set lst_idx [ list 0 3 4 1 2]
    $w entryconfigure 0 -state normal
    $w entryconfigure 1 -state normal
    $w entryconfigure 2 -state normal
    $w entryconfigure 3 -state normal
    $w entryconfigure 4 -state normal
    $w entryconfigure [ lindex $lst_idx [ expr $num_lights - 1]] -state disable
}

proc PostProcessLights { w which } {
    GiD_Process 'Render $which
    PostActualizeStateLightsSubMenu $w
}

proc PostCreateLightsSubMenu { w} {
    if { ![ winfo exists $w]} {
        menu $w -tearoff 0
    }
    $w delete 0 end
    $w add command -label [_ "One light ( dynamic)"] -command [ list PostProcessLights $w OneLight]
    $w add command -label [_ "Blue light ( fixed)"] -command [ list PostProcessLights $w BlueLight]
    $w add command -label [_ "Orange light ( fixed)"] -command [ list PostProcessLights $w OrangeLight]
    $w add command -label [_ "Two lights ( blue & orange)"] -command [ list PostProcessLights $w TwoLights]
    $w add command -label [_ "Three lights"] -command [ list PostProcessLights $w ThreeLights]
    return $w
}

proc ChangeReflectionState { } {
    set reflejo [ GiD_Reflection get state]
    set ::VREPriv(HayReflejoEntorno) [ lindex $reflejo 0]
    set cmd "On"
    if { [ string equal -nocase $::VREPriv(HayReflejoEntorno) "on"]} {
        set cmd "Off"
    }
    GiD_Process 'Render ReflectEnvironment $cmd
    set reflejo [ GiD_Reflection get state]
    set ::VREPriv(HayReflejoEntorno) [ lindex $reflejo 0]
}

proc GetMenuDataRender { } {
    set menu_data [list]
    set whatuse [GiD_Info Project ViewMode]
    if { $whatuse == "GEOMETRYUSE" || $whatuse == "MESHUSE" } {
        set labels [list [_ "Normal"] [_ "Flat#C#render"] [_ "Smooth#C#render"]]
        set commands  {Normal Flat Smooth}
        set render_mode [GiD_Info Project RenderMode]
        if { $render_mode == "normal" } {
            set render_mode Normal
        } elseif { $render_mode == "polygons" } {
           set render_mode Flat
        } elseif { $render_mode == "render" } {
           set render_mode Smooth
        } elseif { $render_mode == "custom" } {
            set render_mode [GiD_Info customrenders current]
        } 
        foreach label $labels i $commands {
            set command [list GiD_Process 'Render $i]   
            if { $render_mode == $i } {
                set active 1
            } else {
                set active 0
            }        
            lappend menu_data [list i $label $command "" "" 0 $active]
        }
        foreach i [GiD_Info customrenders] {
            set label $i
            set command [list GiD_Process 'Render Customized ChangeCustom $i]
            if { $render_mode == $i } {
                set active 1
            } else {
                set active 0
            }
            lappend menu_data [list i $label $command "" "" 0 $active]
        }
        set label [_ "Customize"]...
        set command CustomizeRender
        set active 0
        lappend menu_data [list i $label $command "" "" 0 $active]

        lappend menu_data [list i --- "" "" "" 0 0]
        
        set label [_ "Change light dir"]
        set command {GiD_Process 'ChangeLightVec}
        if { $render_mode == "Normal" } {
            set active 1
        } else {
            set active 0
        }
        lappend menu_data [list i $label $command "" "" 0 $active]

    } elseif { $whatuse == "POSTUSE" } {
        set render_mode [GiD_Info postprocess get cur_display_render]
        foreach label [list [_ "Normal"] [_ "Flat#C#render"] [_ "Smooth#C#render"]] i { Normal Flat Smooth } {
            set command [list GiD_Process 'Render $i]
            if { $render_mode == $i } {
                set active 1
            } else {
                set active 0
            }
            lappend menu_data [list i $label $command "" ""  0 $active]               
        }
        lappend menu_data [list i --- "" "" "" 0 0]

        set label [_ "Change light dir"]
        set command {GiD_Process Mescape view render ChangeLightVec}
        if { $render_mode == "Normal" } {
            set disabled 1
        } else {
            set disabled 0
        }
        set active 0
        lappend menu_data [list i $label $command "" "" $disabled $active]        
        set label [_ "Lights"]

        set submenu_data [list]
        set labels [list [_ "One light (dynamic)"] [_ "Blue light (fixed)"] [_ "Orange light (fixed)"] [_ "Two lights (blue & orange)"] [_ "Three lights"]]
        set commands {OneLight BlueLight OrangeLight TwoLights ThreeLights}
        foreach label $labels i $commands {
            set command [list GiD_Process 'Render $i]            
            lappend submenu_data [list i $label $command "" "" $disabled $active]
        }
        lappend menu_data [list m $label $submenu_data "" "" $disabled 0]
    } elseif { $whatuse == "GRAPHUSE" } {
        #rare case
        set render_mode Normal
    } else {
        #unexpected case
        set render_mode Normal
    }
    
    lappend menu_data [list i --- "" "" "" 0 0]
    
    set label [_ "Reflection#C#render"]
    set command ChangeReflectionState
    if { $render_mode == "Normal" &&  $whatuse != "POSTUSE" } {
        set disabled 1
    } else {
        set disabled 0
    }
    set active 0
    #set ::VREPriv(HayReflejoEntorno) [lindex [GiD_Reflection get state] 0]
    #$w add checkbutton -label $label -command $command -variable ::VREPriv(HayReflejoEntorno) -onvalue On -offvalue Off
    #it is a checkbox, but require the associated global variable name...    
    #or allow store in menu_data an extra boolean checked like the disabled
    lappend menu_data [list i $label $command "" "" $disabled $active]
    
    set label [_ "Define reflection#C#render"]...
    set command EnvironmentReflectionWindow
    lappend menu_data [list i $label $command "" "" $disabled $active]
    
    return $menu_data
}

proc AddEntitiesToMenuRender { w } {
    #0 to refresh and show disable the current render mode
    if { 0 && $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate [GiD_Info Project ViewMode]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataRender]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w    
    return $menu_data
}

proc GiD_BackgroundImageSetOnMesh_Create {} {
    global GidPriv
    if { ![info exists ::GidPriv(GiD_BackgroundImage,OpenglLists)] } {
        package require gid_draw_opengl
        set my_opengl_lists [gid_draw_opengl::create_opengl_lists_mesh_textured_from_background_image]
        if { [llength $my_opengl_lists] } {
            gid_draw_opengl::draw_lists_append $my_opengl_lists
            set ::GidPriv(GiD_BackgroundImage,OpenglLists) $my_opengl_lists
        }
    }
}

proc GiD_BackgroundImageSetOnMesh_Delete {} {
    global GidPriv
    if { [info exists ::GidPriv(GiD_BackgroundImage,OpenglLists)] } {
        gid_draw_opengl::draw_list_delete $::GidPriv(GiD_BackgroundImage,OpenglLists)
        unset ::GidPriv(GiD_BackgroundImage,OpenglLists)
    }
}

proc GiD_BackgroundImageSetOnMesh { value } {
    if { $value } {
        GiD_BackgroundImageSetOnMesh_Create
    } else {
        GiD_BackgroundImageSetOnMesh_Delete
    }
    GiD_Redraw
}

proc GiD_BackgroundImageGetOnMesh { } {
    global GidPriv
    set value 0
    if { [info exists GidPriv(GiD_BackgroundImage,OpenglLists)] } {
        set value 1
    }
    return $value
}

proc GetMenuDataBackgroundImage { } {
    set menu_data [list]
    if { [GiD_BackgroundImage get filename] == "" } {
        set have_bg_img 0
    } else {
        set have_bg_img 1
    }
    set disabled [IsFalse $have_bg_img]
    set disableds [list 0 0 $disabled]
    set active 0
    set labels [list [_ "Fit screen#C#menu"]... [_ "Real size#C#menu"]...  [_ "Default#C#menu"]]
    set commands {BackgroundImg RealSizeImg Default}
    foreach label $labels i $commands disabled $disableds {
        set command [list GiD_Process Mescape Utilities BackgroundImg $i]
        lappend menu_data [list i $label $command "" "" $disabled $active]
    }
    if { [GiD_BackgroundImage get show] } {
        set opposite 0
        set label [_ "Hide#C#menu"]
    } else {
        set opposite 1
        set label [_ "Show#C#menu"]
    }
    set command [list GiD_BackgroundImage set show $opposite]
    set active 0
    lappend menu_data [list i $label $command "" "" $disabled $active]

    if { [GiD_BackgroundImageGetOnMesh] } {
        set opposite 0
        set label [_ "Delete projected on mesh"]
    } else {
        set opposite 1
        set label [_ "Create projected on mesh"]
    }
    set command [list GiD_BackgroundImageSetOnMesh $opposite]
    set disabled_projected_on_mesh $disabled
    if { !$disabled_projected_on_mesh } {
        set pre_post [string tolower [GetCurrentPrePostMode]]
        if { ![GiD_Info mesh -$pre_post NumNodes] } {
            set disabled_projected_on_mesh 1 
        }
    }
    set disabled [IsFalse $have_bg_img]
    set active 0
    lappend menu_data [list i $label $command "" "" $disabled_projected_on_mesh $active]
    return $menu_data
}

proc AddEntitiesToMenuBackgroundImage { w } {
    set menu_data [GetMenuDataBackgroundImage]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w    
    return $menu_data
}

proc CreateCascadedMenu { menu varname varcommandname acceleratorname \
                              currentindex {littleiconname ""} } {
    upvar #0 $varname var $varcommandname varcomm
    if { $acceleratorname != ""} {
        upvar #0 $acceleratorname varaccelerator
    }
    if {$littleiconname != "" } {
        upvar #0 $littleiconname varicons
    }
    global GidPriv
    set UnderLineList ""
    set j 0

    # propagate fg and bg colours in the new subcreated menus
    set menu_bg [ $menu cget -background]
    set menu_fg [ $menu cget -foreground]

    foreach i $var($currentindex) {
        set comm [lindex $varcomm($currentindex) $j]
        if { [string match ---* $i] } {
            $menu add separator
        } elseif { [lindex $i 0] == "-CB-" } {
            set text [lrange $i 1 end]
            set under [FindUnderChar text UnderLineList]
            $menu add checkbutton -label $text -underline $under -variable GidPriv([lindex $i 1])
            EnterCommand $menu $comm $j
            if { [info exists varaccelerator($currentindex)] } {
                # AddAccelerator [lindex $varaccelerator($currentindex) $j] $menu $j
                AddAcceleratorCommand [lindex $varaccelerator($currentindex) $j] $menu $j $comm
            } else { 
                AddAccelerator "" $menu $j 
            }
            if { [info exists varicons($currentindex)] } {
                AddLittleIcon [lindex $varicons($currentindex) $j] $menu $j
            } else {
                AddLittleIcon "" $menu $j
            }
        } elseif { [lindex $i 0] == "-CB2-" } { 
            # -CB2- for compatibility reasons
            set text {*}[lrange $i 2 end]
            set under [FindUnderChar text UnderLineList]
            $menu add checkbutton -label $text -underline $under -variable GidPriv([lindex $i 1])
            EnterCommand $menu $comm $j
            if { [info exists varaccelerator($currentindex)] } {
                # AddAccelerator [lindex $varaccelerator($currentindex) $j] $menu $j
                AddAcceleratorCommand [lindex $varaccelerator($currentindex) $j] $menu $j $comm
            } else { 
                AddAccelerator "" $menu $j 
            }
            if { [info exists varicons($currentindex)] } {
                AddLittleIcon [lindex $varicons($currentindex) $j] $menu $j
            } else {
                AddLittleIcon "" $menu $j
            }
        } elseif { ![info exists var($currentindex,$j)] } {
            set text $i
            set under [FindUnderChar text UnderLineList]
            $menu add command -label $text -underline $under
            EnterCommand $menu $comm $j
            if { [info exists varaccelerator($currentindex)] } {
                # AddAccelerator [lindex $varaccelerator($currentindex) $j] $menu $j
                AddAcceleratorCommand [lindex $varaccelerator($currentindex) $j] $menu $j $comm
            } else { 
                AddAccelerator "" $menu $j 
            }
            if { [info exists varicons($currentindex)] } {
                AddLittleIcon [lindex $varicons($currentindex) $j] $menu $j
            } else {
                AddLittleIcon "" $menu $j
            }
        } else {
            set text $i
            set under [FindUnderChar text UnderLineList]
            $menu add cascade -label $text -underline $under -menu $menu.$j
            if { [winfo exists $menu.$j] } {
                #$menu.$j delete 0 end
                destroy $menu.$j
                menu $menu.$j -tearoff no -background $menu_bg -foreground $menu_fg
            } else {
                menu $menu.$j -tearoff no -background $menu_bg -foreground $menu_fg
            }
            EnterCommand $menu.$j $comm -2
            CreateCascadedMenu $menu.$j $varname $varcommandname $acceleratorname \
                "$currentindex,$j" $littleiconname
            
            if { [info exists varicons($currentindex)] } {
                AddLittleIcon [lindex $varicons($currentindex) $j] $menu $j
            } else {
                AddLittleIcon "" $menu $j
            }
        }
        incr j
    }

}

proc Create3rdButtonMenu { w } {    
    if { [$w index end] == "none" } {
        global 3dButtonNames 3dButtonCommands 3dButtonAcceler 3dButtonIcons
        CreateCascadedMenu $w 3dButtonNames 3dButtonCommands 3dButtonAcceler 0 3dButtonIcons
    }   
}

proc Create3rdButtonMenuGraph { w } {   
    if { [$w index end] == "none" } {
        global 3dButtonNamesGraph 3dButtonCommandsGraph 3dButtonAccelerGraph 3dButtonIconsGraph        
        CreateCascadedMenu $w 3dButtonNamesGraph 3dButtonCommandsGraph 3dButtonAccelerGraph 0 3dButtonIconsGraph
    }   
}

proc TryToFindVector { vec } {

    set num {([+-]?[0-9]*\.?[0-9]*([eE][+-]?[0-9]+)?)}
    set sep [join {[ " " , \n ] +} ""]
    set sepv [join {[ " " , \n
                     ] *} ""]

    set res [regexp ^$sepv$num$sep$num$sep$num$sepv$ $vec trash v1 trash2 v2 trash3 v3]

    if { $res && $v1 != "" && $v2 != "" && $v3 != ""} { return $v1,$v2,$v3 }
    return $vec
}


proc MakeBottomEntryBindings {} {
    global uparrow

    focus .gid.comm.e

    bind .gid.comm.e <Shift-Return> {
        set aa [TryToFindVector [.gid.comm.e get]]
        .gid.comm.e delete 0 end
        .gid.comm.fwarn.list insert end "->$aa"
        set uparrow [.gid.comm.fwarn.list size]
        .gid.comm.fwarn.list yview [expr $uparrow-2]
        GiD_Process {*}$aa
        break
    }


    bind .gid.comm.e <Return> {
        set aa [.gid.comm.e get]
        .gid.comm.e delete 0 end
        .gid.comm.fwarn.list insert end "->$aa"
        set uparrow [.gid.comm.fwarn.list size]
        .gid.comm.fwarn.list yview [expr $uparrow-2]
        
        if { [string match -np-* $aa] } {
            regsub -- {-np-} $aa {} aa
            eval $aa
        } elseif { [llength $aa] } {
            GiD_Process {*}$aa
        }
    }
   
    set uparrow 0
    bind .gid.comm.e <Up> {
        .gid.comm.e delete 0 end
        while 1 {
            incr uparrow -1
            if { $uparrow < 0 } {
                set uparrow -1
                break
            } else {
                # this is to avoid bad coloring in VSCode from 'proc IsFalse' on
                set bbbb [.gid.comm.fwarn.list get $uparrow ]
                set ret_regexp [regexp {^->.*[^ ]+.*$} $bbbb]
                if { $ret_regexp } {
                    .gid.comm.e insert 0 [string range [.gid.comm.fwarn.list get $uparrow] 2 end]
                    break
                }
            }
        }
    }
    bind .gid.comm.e <Down> {
        .gid.comm.e delete 0 end
        while 1 {
            incr uparrow 1
            if { $uparrow >= [.gid.comm.fwarn.list size] } {
                set uparrow [.gid.comm.fwarn.list size]
                break
            } else {
                # this is to avoid bad coloring in VSCode from 'proc IsFalse' on
                set bbbb [.gid.comm.fwarn.list get $uparrow]
                set ret_regexp [regexp {^->.*[^ ]+.*$} $bbbb]
                if { $ret_regexp } {
                    .gid.comm.e insert 0 [string range [.gid.comm.fwarn.list get $uparrow] 2 end]
                    break
                }
            }
        }
    }
    bind .gid.comm.e <Alt-KeyPress-3> {
        set x [expr [winfo rootx %W]+%x+2]
        set y [expr [winfo rooty %W]+%y]
        GiDShowContextualMenu $x $y        
    }
    bind .gid.comm.e <Tab> "AutoCompleteGiDEntry %W; break"

    #para dejar el 'pegar' con el boton del medio del raton
    bind .gid.comm.e <ButtonPress-$::gid_central_button> ""
    #.gid.comm.e insert insert \"[selection get]\"; break;"
    #bind .gid.comm.e <ButtonRelease-$::gid_central_button> ""
}

proc IsFalse { cond } {
    if { $cond } {
        return 0
    } else {
        return 1
    }
}

proc GetMenuDataSwapNormals { } {
    set menu_data [list]
    set basecommand "GiD_Process Mescape utilities SwapNormals"
    set whatuse [GiD_Info Project ViewMode]
    switch $whatuse {
        GEOMETRYUSE {    
            set nlines [GiD_Info Geometry NumLines]
            set nsurfs [GiD_Info Geometry NumSurfaces]
            if { $::GidPriv(HideSurfaceLevel) == 1 } {
                set commands [list Lines]
                set labels [list [_ "Lines"]]
                set disableds [list [IsFalse $nlines]]
            } else {
                set commands [list Lines Surfaces]
                set labels [list [_ "Lines"] [_ "Surfaces"]]
                set disableds [list [IsFalse $nlines] [IsFalse $nsurfs]]
            }            
            foreach name $labels i $commands disabled $disableds {                
                if { $i == "Lines" } {
                    set submenu_data [list]
                    set label [_ "Select"]
                    set command [list {*}$basecommand $i Select]
                    lappend submenu_data [list i $label $command "" "" $disabled 0]
                    set label [_ "Pointing inside surfaces"]
                    set command [list {*}$basecommand PointingInside Surfaces]
                    lappend submenu_data [list i $label $command "" "" $disabled 0]
                    set label $name
                    lappend menu_data [list m $label $submenu_data "" "" $disabled 0]
                } elseif { $i == "Surfaces" } {
                    set submenu_data [list]
                    set label [_ "Select"]
                    set command [list {*}$basecommand $i Select]
                    lappend submenu_data [list i $label $command "" "" $disabled 0]
                    set label [_ "Make coherent"]
                    set command [list {*}$basecommand $i MakeGroupCoherent]
                    lappend submenu_data [list i $label $command "" "" $disabled 0]
                    set label [_ "Select by normal"]
                    set command [list {*}$basecommand $i SelByNormal]
                    lappend submenu_data [list i $label $command "" "" $disabled 0]
                    set label [_ "Pointing inside volumes"]
                    set command [list {*}$basecommand PointingInside Volumes]
                    lappend submenu_data [list i $label $command "" "" 0 0]
                    set label $name
                    lappend menu_data [list m $label $submenu_data "" "" $disabled 0]
                }
            }
        }
        MESHUSE {    
            set nelems [GiD_Info Mesh NumElements]       
            set commands [list "Select" "MakeGroupCoherent" "SelByNormal"]
            set labels [list [_ "Select"] [_ "Make coherent"] [_ "Select by normal"]]            
            set disableds [list [IsFalse $nelems] [IsFalse $nelems] [IsFalse $nelems]]
            foreach label $labels i $commands disabled $disableds {
                set command [list {*}$basecommand $i]
                lappend menu_data [list i $label $command "" "" $disabled 0]
            }
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuSwapNormals { w } {    
    set menu_data [GetMenuDataSwapNormals]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataDrawNormals { } {
    set menu_data [list]
    set basecommand {GiD_Process Mescape Utilities DrawNormals}
    set whatuse [GiD_Info Project ViewMode]
    switch $whatuse {
        GEOMETRYUSE {
            set nlines [GiD_Info Geometry NumLines]
            set nsurfs [GiD_Info Geometry NumSurfaces]
            if { $::GidPriv(HideSurfaceLevel) == 1 } {
                set commands [list Lines]
                set labels [list [_ "Lines"]]
                set disableds [list [IsFalse $nlines]]
            } else {
                set commands [list Lines Surfaces]
                set labels [list [_ "Lines"] [_ "Surfaces"]]
                set disableds [list [IsFalse $nlines] [IsFalse $nsurfs]]
            }        
            foreach label $labels i $commands disabled $disableds {   
                if { $i == "Lines" } {
                    set command [list {*}$basecommand $i]
                    lappend menu_data [list i $label $command "" "" $disabled 0]                    
                } elseif { $i == "Surfaces" } {                   
                    set submenu_data [list]  
                    set command [list {*}$basecommand $i]   
                    lappend submenu_data [list i [_ "Normal"] $command "" "" $disabled 0]
                    set command [list {*}$basecommand $i Color]
                    lappend submenu_data [list i [_ "Colored#C#Surfaces"] $command "" "" $disabled 0]
                    lappend menu_data [list m $label $submenu_data "" "" $disabled 0]                    
                }
            }
        }
        MESHUSE {
            set nelems [GiD_Info Mesh NumElements]
            set commands [list $basecommand "$basecommand Color"]
            set labels [list [_ "Elements"] [_ "Colored elements"]]            
            set disableds [list [IsFalse $nelems] [IsFalse $nelems]]
            foreach label $labels i $commands disabled $disableds {
                set command $i
                lappend menu_data [list i $label $command "" "" $disabled 0]
            }
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawNormals { w } {
   if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate [GiD_Info Project ViewMode]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
    }
    set menu_data [GetMenuDataDrawNormals]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataDrawHigherentities { } {
    set menu_data [list]
    set basecommand {GiD_Process Mescape Utilities DrawHigher}   
    set whatuse [GiD_Info Project ViewMode]
    switch $whatuse {
        GEOMETRYUSE {
            set npoints [GiD_Info Geometry NumPoints]
            set nlines [GiD_Info Geometry NumLines]
            set nsurfs [GiD_Info Geometry NumSurfaces]
            if { $::GidPriv(HideSurfaceLevel) == 1 } {
                set commands {Points Lines "" All}
                set labels [list [_ "Points"] [_ "Lines"] --- [_ "All"]]
                set disableds [list [IsFalse $npoints] [IsFalse $nlines] 0 [IsFalse $npoints]]
            } else {
                set commands {Points Lines Surfaces "" All}
                set labels [list [_ "Points"] [_ "Lines"] [_ "Surfaces"] --- [_ "All"]]
                set disableds [list [IsFalse $npoints] [IsFalse $nlines] [IsFalse $nsurfs] 0 [IsFalse $npoints]]    
            }         
            foreach label $labels i $commands disabled $disableds {
                if { $label=="---" } {
                    lappend menu_data [list i --- "" "" "" 0 0]
                } else {
                    set command [list {*}$basecommand $i]
                    lappend menu_data [list i $label $command "" "" $disabled 0]
                }
            }
        }
        MESHUSE {
            set nnodes [GiD_Info Mesh NumNodes]
            set nelems [GiD_Info Mesh NumElements]
            set commands {Nodes Edges}
            set labels [list [_ "Nodes"] [_ "Edges"]]
            set disableds [list [IsFalse $nnodes] [IsFalse $nelems]]           
            foreach label $labels i $commands disabled $disableds {
                set command [list {*}$basecommand $i]
                lappend menu_data [list i $label $command "" "" $disabled 0]               
            }
        }
    }
    return $menu_data
}

proc AddEntitiesToMenuDrawHigherentities { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate [GiD_Info Project ViewMode]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataDrawHigherentities]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc GetMenuDataCreateElement { } {
    set menu_data [list]
    set element_types ""    
    set mesh_type [GiD_Set MeshType]  ;#expected values 0, 1, 2    
    if { $mesh_type == 1} {
        set is_cartesian 1
    } else {
        set is_cartesian 0
    }
    if { $is_cartesian } {
        if { [GiD_Cartesian get dimension] == 2 } {
            set is_2d 1
        } else {
            set is_2d 0
        }
    } else {
        set is_2d 0
    }
    if { $::GidPriv(HideSurfaceLevel)==1 } {
        set is_1d 1
    } else {
        set is_1d 0
    }
    if { $::GidPriv(HideVolumeLevel)==1 } {
        set is_2d 1
    }
    if { $is_cartesian } {
        if { $is_1d } {
            set labels [list [_ "Linear"]]
            set commands [list Linear]            
        } elseif { $is_2d } {
            set labels [list [_ "Linear"] [_ "Quadrilateral"]]   
            set commands [list Linear Quadrilateral]
        } else {
            set labels [list [_ "Linear"] [_ "Quadrilateral"] [_ "Hexahedra"]]
            set commands [list Linear Quadrilateral Hexahedra]            
        }
    } else {
        if { $is_1d } {
            set labels [list [_ "Point"] --- [_ "Linear"]]
            set commands [list Point "" Linear]            
        } elseif { $is_2d } {
            set labels [list [_ "Point"] --- [_ "Linear"] [_ "Triangle"] [_ "Quadrilateral"] [_ "Circle"]]       
            set commands [list Point "" Linear Triangle Quadrilateral Circle]            
        } else {
            set labels [list [_ "Point"] --- [_ "Linear"] [_ "Triangle"] [_ "Quadrilateral"] [_ "Circle"] \
                --- [_ "Tetrahedra"] [_ "Hexahedra"] [_ "Prism"] [_ "Pyramid"] [_ "Sphere"]]
            set commands [list Point "" Linear Triangle Quadrilateral Circle "" Tetrahedra Hexahedra Prism Pyramid Sphere]
        }  
    }           
    foreach label $labels i $commands {
        if { $label=="---" } {
            lappend menu_data [list i --- "" "" "" 0 0]
        } else {
            set command [list GiD_Process Mescape Meshing EditMesh CreateElement $i]
            set accelerator ""
            set image ""
            lappend menu_data [list i $label $command $accelerator $image 0 0]           
        }
    }   
    return $menu_data
}

proc AddEntitiesToMenuCreateElement { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate [GiD_Set MeshType]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataCreateElement]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

#create a name to show abreviated the full path of a file, for example:  "d:\Documents\...\myfile"
proc ShortFilenameToShowMenu { filename {maxlength 40} } {
    if { [string length $filename] > $maxlength } {
        set splitname [file split $filename]
        set l [llength $splitname]
        set availablelength $maxlength
        set shortname [lindex $splitname 0]
        incr availablelength [expr -[string length $shortname]-[string length [lindex $splitname [expr $l-1]]-5]]
        for {set i 1 } { $i < [expr $l-1] } {incr i} {
            incr availablelength [expr -[string length [lindex $splitname $i]]-1]
            if { $availablelength >=0 } {
                set shortname [file join $shortname [lindex $splitname $i]]
            } else {
                break
            }
        }
        set shortname [file join $shortname {...} [lindex $splitname [expr $l-1]]]
        set shortname [file nativename $shortname]
    } else {
        set shortname [file nativename $filename]
    }
    return $shortname
}

proc GetLastTwoNamesFilename { filename } {
    set tail_name [file tail $filename]
    set tail_dir [file tail [file dirname $filename]]
    if { $tail_dir != ""} {
        set tail_name [file join $tail_dir $tail_name]
    }
    return $tail_name
}

proc GetMenuDataRecentProjects { } {
    set menu_data [list]
    set names [GiD_Info RecentProjects]
    foreach i $names {
        set label [ShortFilenameToShowMenu $i]
        set command [list LoadFileInGid $i.gid]
        lappend menu_data [list i $label $command "" "" 0 0]        
    }
    return $menu_data
}

proc AddEntitiesToMenuRecentProjects { w } {
    set menu_data [GetMenuDataRecentProjects]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w    
    return $menu_data
}

proc GetMenuDataRecentPostFiles { } {
    set menu_data [list]
    foreach i [GiD_Info RecentPostFiles] {        
        # es multiple si hay varios .msh y .res o .bin
        set varias_msh [ regexp {^.*\.msh.*\.msh\}?$} $i]
        set varios_res [ regexp {^.*\.res.*\.res\}?$} $i]
        set varios_bin [ regexp {^.*\.bin.*\.bin\}?$} $i]
        set varios_h5 [ regexp {^.*\.h5.*\.h5\}?$} $i]
        if { !$varias_msh && !$varios_res && !$varios_bin && !$varios_h5} {
            set label [ShortFilenameToShowMenu $i]
            set command [ list LoadFileInGidPost $i]            
        } else {
            # es un open multiple
            set a1 [lindex $i 0]
            set a2 [lindex $i end]
            set label [format "%s: %s, ..., %s ( %s)" [_ "Multiple"] \
                            [GetLastTwoNamesFilename $a1] [GetLastTwoNamesFilename $a2] [llength $i]]
            set command [list ExecuteFileCommand ReadMultiple POST "" $i]
        }
        lappend menu_data [list i $label $command "" "" 0 0]
    }
    return $menu_data
}

proc AddEntitiesToMenuRecentPostFiles { w } {
    set menu_data [GetMenuDataRecentPostFiles]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w 
    return $menu_data
}

proc GetMenuDataRecentViewFiles { } {
    set menu_data [list] 
    foreach i [GiD_Info RecentViewFiles] {
        set label [ShortFilenameToShowMenu $i]        
        set command [list LoadFileInGidPost $i]
        lappend menu_data [list i $label $command "" "" 0 0]
    }
    return $menu_data
}

proc AddEntitiesToMenuRecentViewFiles { w } {
    if { $::MENUS_DYNAMIC_ENABLE_CACHE } {
        set newstate [GiD_Info RecentViewFiles]
        set thisproc $w
        if { [info exists ::MenuPrevState($thisproc)] } {
            if { $::MenuPrevState($thisproc) == $newstate && [$w index end] != "none" } {
                return
            }
        }
        set ::MenuPrevState($thisproc) $newstate
    }
    set menu_data [GetMenuDataRecentViewFiles]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w 
    return $menu_data
}

proc AddRecentViewFiles2IconBar { w } {
    $w delete 0 end
    set UnderLineList {}
    # Vistas predefinidas:
    set img [ list zframe.png \
                  view_rotate_xy.png view_rotate_xz.png view_rotate_yz.png \
                  view_rotate_-xy.png view_rotate_-xz.png view_rotate_-yz.png \
                  isometric.png "" ""]
    set txt [ list [_ "Zoom frame"] \
                  [_ "View XY plane (original)"] [_ "View XZ plane"] [_ "View YZ plane"] \
                  [_ "View -XY plane"] [_ "View -XZ plane"] [_ "View -YZ plane"] \
                  [_ "Isometric X"] [_ "Isometric Y"] [_ "Isometric Z"]]
    set cmd [ list "GiD_Process 'Zoom Frame" \
                  GidRotateView::PlaneXY \
                  GidRotateView::PlaneXZ \
                  GidRotateView::PlaneYZ \
                  GidRotateView::PlaneMinusXY \
                  GidRotateView::PlaneMinusXZ \
                  GidRotateView::PlaneMinusYZ \
                  GidRotateView::IsometricX \
                  GidRotateView::IsometricY \
                  GidRotateView::IsometricZ \
                 ]

    foreach i $img t $txt c $cmd {
        set under [FindUnderChar t UnderLineList]
        if { $i != ""} {
            $w add command -image [ gid_themes::GetImage $i menu] -label $t -underline $under -command $c -compound left
        } else {
            $w add command -label $t -underline $under -command $c
        }
    }
    $w add separator

    set names [ GiD_Info RecentViewFiles]

    # ya se han anyadido algunas entradas
    set menuIdx [ $w index last]
    incr menuIdx
    # definimos una variable que se actualizara con el contenido de la ayuda
    set ::txtAyuda$w ""

    # package require BWidget
    DynamicHelp::register $w menu ::txtAyuda$w
    if { [llength $names] } {
        foreach i $names {
            if { ![ regexp {^\{([^\}]*).*\{([^\}]*)\}$} $i tonto a1 a2]} {
                set text [ShortFilenameToShowMenu $i]
                set under [FindUnderChar text UnderLineList]
                $w add command -label $text -underline $under -command [list LoadFileInGidPost $i]

                DynamicHelp::register $w menuentry $menuIdx $i
            } else {
                # es un open multiple
                set text [_ "Multiple: %s, ..., %s" [GetLastTwoNamesFilename $a1] [GetLastTwoNamesFilename $a2]]
                set under [FindUnderChar text UnderLineList]
                $w add command -label $text -underline $under \
                    -command [list ExecuteFileCommand ReadMultiple POST "" $i]

                DynamicHelp::register $w menuentry $menuIdx $i
            }
            incr menuIdx
        }
        $w add separator
    }
    foreach t [ list [_ "Read#C#menu"]... [_ "Save#C#menu"]...] c { {Mescape View ReadView} {Mescape View SaveView}} {
        set under [ FindUnderChar t UnderLineList]
        $w add command -label $t -underline $under -command [ list GiD_Process {*}$c]
    }

    # el balon de ayuda:
    if { [GiD_Set TooltipPopup] != "bottom" } {
        setTooltip $w -textvariable ::txtAyuda$w
    } else {
        setTooltip $w -textvariable ::txtAyuda$w -delay 0 -bottom .gid
    }
}

#num: num to append after (to preserve previous menu items).  -1 to delete all menu
#w: menu name 
#basecommand: Tcl command to append $i entity type
#args: alternative list of entities names and labels, then expected 2 or 3 sublists
proc AddEntitiesToMenuAfter { num w basecommand geom_data mesh_data} {
    set whatuse [GiD_Info Project ViewMode]        
    set UnderLineList {}
    switch $whatuse {
        GEOMETRYUSE {
            lassign $geom_data geom_commands geom_labels geom_images 
            foreach i {Points Lines Surfaces Volumes} {
                set num_entities($i) [GiD_Info Geometry Num$i]
            }
            foreach label $geom_labels i $geom_commands image $geom_images {
                if { $label eq "---" } {
                    $w add separator
                    continue
                }
                set color black
                if { [info exists num_entities($i)] && !$num_entities($i) } {
                    set color $::GidPriv(Color,DisabledForegroundMenu)
                }
                set under [FindUnderChar label UnderLineList]
                $w add command -label $label -underline $under -command [list {*}$basecommand $i] -foreground $color \
                    -image [gid_themes::GetImage $image menu] -compound left
            }
        }
        MESHUSE {
            lassign $mesh_data mesh_commands mesh_labels mesh_images
            foreach i {Nodes Elements} {
                set num_entities($i) [GiD_Info Mesh Num$i]
            }            
            set i [lindex [split $w .] end]
            set parent [winfo parent $w]
            if { [string is integer $i] && $i >=0 && $i < [$parent index end] } {
                $parent entryconfigure $i -foreground black
            }            
            foreach label $mesh_labels i $mesh_commands image $mesh_images {
                if { $label eq "---" } {
                    $w add separator
                    continue
                }
                set color black
                if { [info exists num_entities($i)] && !$num_entities($i) } {
                    set color $::GidPriv(Color,DisabledForegroundMenu)
                }
                set under [FindUnderChar label UnderLineList]
                $w add command -label $label -underline $under -command [list {*}$basecommand $i] -foreground $color \
                    -image [gid_themes::GetImage $image menu] -compound left
            }
        }
        POSTUSE {
            lassign $mesh_data mesh_commands mesh_labels mesh_images
            foreach label $mesh_labels i $mesh_commands image $mesh_images {
                if { $label eq "---" } {
                    $w add separator
                    continue
                }
                set under [FindUnderChar label UnderLineList]
                $w add command -label $label -underline $under -command [list {*}$basecommand $i] \
                    -image [ gid_themes::GetImage $image menu] -compound left
            }
        }
        GRAPHUSE {
            lassign [list {Nodes} [list [_ "Nodes"]] {""}] graph_commands graph_labels graph_images            
            foreach label $graph_labels i $graph_commands image $graph_images  {
                if { $label eq "---" } {
                    $w add separator
                    continue
                }
                set under [FindUnderChar label UnderLineList]
                $w add command -label $label -underline $under -command [list {*}$basecommand $i] \
                    -image [ gid_themes::GetImage $image menu] -compound left
            }            
        }
    }
}

proc GetMenuDataXXX { basecommand geometry_data mesh_data } {    
    set menu_data [list]
    set whatuse [GiD_Info Project ViewMode] 
    switch $whatuse {
        GEOMETRYUSE {
            lassign $geometry_data commands labels images          
        }
        MESHUSE {
            lassign $mesh_data commands labels images         
        }
        POSTUSE {
            lassign $mesh_data commands labels images
        }
        GRAPHUSE {
            lassign [list {Nodes} [list [_ "Nodes"]] {""}] commands labels images
        }
    }
    foreach label $labels i $commands image $images {
        set command [list {*}$basecommand $i]
        set accelerator ""
        set disabled 0
        lappend menu_data [list i $label $command $accelerator $image $disabled 0]
    }
    return $menu_data
}

proc AddEntitiesToMenuXXX { w basecommand geometry_data mesh_data } {
    set menu_data [GetMenuDataXXX $basecommand $geometry_data $mesh_data]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w
    return $menu_data
}

proc AddCutsToMenu { w basecommand} {
    #     global ViewMenuPriv

    #if { ![ GiD_Info postprocess get changed_geom_list]} { return}

    set cutlist [ GiD_Info postprocess get all_cutsets]
    #    set what cuts2

    #    if { [ info exists ViewMenuPriv($what)]} {
    #        if { ![ string compare $ViewMenuPriv($what) $cutlist ]} {
    #            return
    #        }
    #    }

    #    set ViewMenuPriv($what) $cutlist

    $w delete 0 end
    set UnderLineList {}
    foreach i $cutlist {        
        regsub -all {_} $i { } text
        set under [FindUnderChar text UnderLineList]
        $w add command -label $text -underline $under -command [list {*}$basecommand $i]
    }
    if { [ llength $cutlist] > 1} {
        set text [_ "All cuts"]
        set under [FindUnderChar text UnderLineList]
        $w add command -label $text -underline $under -command [list {*}$basecommand ALL_CUTS]
    }
    if { $cutlist == ""} {
        $w add command -label [_ "There are no Cuts"] -state disabled
    }
}

proc AddGraphSetsToMenu { w basecommand all } {
    #    global ViewMenuPriv
    set graphsetlist [GiD_GraphSet list]   
    set exists_graphs 0
    foreach i $graphsetlist {
        if { [llength [GiD_Graph list $i]] } {
            set exists_graphs 1   
            break
        }
    }
    $w delete 0 end
    if { !$exists_graphs } {    
        $w add command -label [_ "There are no Graphs"] -state disabled
    } else {
        set UnderLineList {}
        set id_menu 0
        foreach i $graphsetlist {
            set graphlist [GiD_Graph list $i]
            if { [llength $graphlist] } {                                
                set m $w.m$id_menu
                set text $i
                set under [FindUnderChar text UnderLineList]                            
                $w add cascade -label $text -underline $under -menu $m
                if { [ winfo exists $m ]} {
                    $m delete 0 end
                } else {
                    menu $m
                }
                set UnderLineList2 {}
                foreach j $graphlist {
                    set text $j
                    set under [FindUnderChar text UnderLineList2]
                    $m add command -label $text -underline $under -command [list {*}$basecommand OneGraph $i $j]
                }
                if { $all } {
                    set text [_ "All graphs of %s" $i]
                    set under [FindUnderChar text UnderLineList]
                    $m add command -label $text -underline $under -command [list {*}$basecommand OneGraphSet $i ""]
                }
            }
            incr id_menu
        }
        if { $all } {
            set text [_ "All graphsets"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command [list {*}$basecommand AllGraphSets "" ""]
        }
    }
}

#what should be: AllGraphSets OneGraphSet OneGraph
proc ExportGraphSet { what graphset_name graph_name } {
    set lst_ext [ list [ list [_ "ASCII file"] ".grf"]]
    if { [ info proc Amelet::WritePostGraphToFile] != ""} {
        lappend lst_ext [ list "Amelet hdf5" ".h5"]
    }   
    lappend lst_ext [ list [_ "All files"] "*"]
    
    set filename [ MessageBoxGetFilename graphfile write [_ "Save Graph on"]... {} $lst_ext ".grf" ]
    if { $filename != ""} {
        set ext [ file extension $filename]
        switch $ext {
            .grf -
            .txt {
                if { $what == "AllGraphSets" } {
                    GiD_Process Mescape Results Graphs WriteGraphSet $what $filename
                } elseif { $what == "OneGraphSet" } {
                    GiD_Process Mescape Results Graphs WriteGraphSet $what $graphset_name $filename
                } elseif { $what == "OneGraph" } {
                    GiD_Process Mescape Results Graphs WriteGraphSet $what $graphset_name $graph_name $filename    
                } else {
                    error [_ "Unexpected case %s" $what]
                }                       
            }
            .h5 {                               
                Amelet::WritePostGraphToFile $filename $graph_name             
            }
            default {
                WarnWin [_ "Unknown extension %s" $ext]
            }
        }
    }
}

proc GetGraphDataClipboardFormat { graphset_name graph_name } {
    lassign [GiD_Graph get $graph_name $graphset_name] label_x label_y values_x values_y
    set data "Graph\t$graph_name\n"
    append data "$label_x\tlabel_y\n"
    foreach value_x $values_x value_y $values_y {
        append data "$value_x\t$value_y\n"
    }
    return $data
}

proc GetGraphSetDataClipboardFormat { graphset_name } {
    set data "GraphSet\t$graphset_name\n"
    foreach graph_name [GiD_Graph list $graphset_name] {
        append data [GetGraphDataClipboardFormat $graphset_name $graph_name]                
    } 
    return $data
}

#what should be: AllGraphSets OneGraphSet OneGraph
proc ClipboardCopyGraphSet { what graphset_name graph_name } {
    set data ""
    if { $what == "AllGraphSets" } {
        foreach graphset_name [GiD_GraphSet list] {
            append data [GetGraphSetDataClipboardFormat $graphset_name]
        }
    } elseif { $what == "OneGraphSet" } {
        append data [GetGraphSetDataClipboardFormat $graphset_name]
    } elseif { $what == "OneGraph" } {
        append data [GetGraphDataClipboardFormat $graphset_name $graph_name]
    } else {
        error [_ "Unexpected case %s" $what]
    }                               
    clipboard clear
    clipboard append $data
    GidUtils::SetWarnLine [_ "Graph data copied to clipboard"]
}

proc AddGraphsToMenu { w basecommand all } {
    #    global ViewMenuPriv
    set graphlist [GiD_Graph list]   

    $w delete 0 end    
    if { ![llength $graphlist] } {
        $w add command -label [_ "There are no Graphs"] -state disabled
    } else {
        set UnderLineList {}
        foreach i $graphlist {
            set text $i
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command [list {*}$basecommand $i]
        }
        if { $all } {
            set text [_ "All"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command [list {*}$basecommand -All-]
        }
    }
}

proc AddLineGraphsToMenu { w basecommand { todos 0}} {
    set graphlist [ GiD_Info postprocess get all_line_graphs]

    $w delete 0 end
    set UnderLineList {}
    foreach i $graphlist {
        set text $i        
        set under [FindUnderChar text UnderLineList]
        $w add command -label $text -underline $under -command [list {*}$basecommand $i]
    }
    if { $todos && ( [ llength $graphlist] > 1) } {
        set text [_ "All"]
        set under [FindUnderChar text UnderLineList]
        $w add command -label $text -underline $under -command [list {*}$basecommand all]
    }
    if { $graphlist == ""} {
        $w add command -label [_ "There are no Graphs"] -state disabled
    }
}

proc AddPostGeomToMenu { w basecommand what color_opt color_labels} {
    global ViewMenuPriv

    set geom_commands [ GiD_Info postprocess get all_$what]

    if { [ info exists ViewMenuPriv($w,$what)]} {
        if { ![ string compare $ViewMenuPriv($w,$what) $geom_commands ]} {
            return
        }
    }

    $w delete 0 end

    if { $geom_commands == ""} {
        $w add command -label [_ "There are no %s" $what] -state disabled
        return
    }

    set ViewMenuPriv($w,$what) $geom_commands

    set id_menu 0
    set UnderLineList {}
    foreach i $geom_commands {
        regsub -all {_} $i { } geomlabel
        if { $color_opt == ""} {
            set under [FindUnderChar geomlabel UnderLineList]
            $w add command -label $geomlabel -underline $under -command [list {*}$basecommand $i]
        } else {
            set under [FindUnderChar geomlabel UnderLineList]
            $w add cascade -label $geomlabel -underline $under -menu $w.m$id_menu
            if { [ winfo exists $w.m$id_menu ]} {
                $w.m$id_menu delete 0 end
            } else {
                menu $w.m$id_menu
            }
            set UnderLineList2 {}
            foreach j $color_opt k $color_labels {
                set under [FindUnderChar k UnderLineList2]
                $w.m$id_menu add command -label $k -underline $under -command "[list {*}$basecommand $i $j] ; GiD_Redraw"
            }
        }
        incr id_menu
    }
}

proc GiDLinuxPrint { filename {parent .}} {
    if { ! [ info exists ::GidPriv(PrinterCommand)] } {
        set ::GidPriv(PrinterCommand) "lpr"
    }    
    set ret [MessageBoxEntry [_ "Enter value window"] [_ "Which command do you use to print files?"] any $::GidPriv(PrinterCommand) 0 question.png]
    # nos devuelve x entre comillas si hay mas de una palabra
    if { $ret != ""} {
        set ::GidPriv(PrinterCommand) $ret
        if { [ file exists $filename] } {
            #para quitar las comillas de x si hay mas de una palabra,
            # pues exec toma x como name de programa ( con espacios y todo)
            set res [ eval [ join "exec $::GidPriv(PrinterCommand) $filename"]]
            if { $res != ""} {
                WarnWin $res $parent
            } else {
                WarnWin [_ "Job succesfully printed or queued."] $parent
            }
            file delete -force $filename
        }
    }
}

proc HardcopyToPrint { {parent .gid}} {
    if { $::tcl_platform(platform) == "windows" } {
        GiD_Process 'Hardcopy Print
    } elseif { $::tcl_platform(os) == "Darwin"} {
        if { [ package require cocoaprint]} {
            set tmp_dir [GiD_Info project TmpDirectory]
            set filename [ file join $tmp_dir __mypdf_pdf.pdf]
            PrintToPdfScreen $filename
            # redraw to get rid off the GiD logo on the screen
            GiD_Redraw
            # cocoaprint::print $filename .gid
            # creates  child sliding window inside parent
            # but it's not modal, and cocoaprint des not return its name
            # but cocoaprint::print $filename {} IS modal
            # so using it !
            if { [ file exists $tmp_filename] } {
                cocoaprint::print $filename {}
                file delete $filename
            }
        }
    } else {
        # create temporary file
        set tmp_filename [ file join [ GiD_Info Project TmpDirectory] \
                               print_[ clock format [clock seconds] -format "%Y-%m-%d-%H:%M:%S"].ps]          
        eval GiD_Process 'Hardcopy PS $tmp_filename
        if { [ file exists $tmp_filename] } {
            GiDLinuxPrint $tmp_filename $parent
            file delete -force $tmp_filename
        }
    }
}

proc AddImageCommandToMenu { menu img cmd {state normal}} {
    if { $cmd != ""} {
        $menu add command -image $img -hidemargin 1 -state $state -command $cmd
    } else {
        $menu add command -image $img -hidemargin 1 -state $state
    }
}

proc GetMenuDataCommonEntities { basecommand {append_result 1} } {
    set menu_data [list]
    set whatuse [GiD_Info Project ViewMode]
    switch $whatuse {
        GEOMETRYUSE {
            set labels [GetGeometryLabels]
            set images [GetGeometryImageFiles]
            set commands [GetGeometryCommands]               
        }
        MESHUSE {
            set labels [GetMeshLabels]
            set images [GetMeshImageFiles]
            set commands [GetMeshCommands]            
        }
        POSTUSE {
            set labels [GetMeshLabels]
            set images [GetMeshImageFiles]
            set commands [GetMeshCommands]
            if { $append_result } {
                lappend labels GaussPoints ResultOnView
                lappend images gauss_point.png resultonview.png
                lappend commands GaussPoints ResultOnView
            }                    
        }
        GRAPHUSE {
            set labels [list Nodes ResultOnView]
            set images {node.png resultonview.png}
            set commands [list Nodes ResultOnView]
        }
    }
    set accelerator ""
    foreach label $labels icon $images i $commands {
        set command [list {*}$basecommand $i]
        lappend menu_data [list i $label $command $accelerator $icon 0 0]
    }
    return $menu_data
}

proc AddEntitiesToMenuCommonEntities { w basecommand {append_result 1} } {
    set menu_data [GetMenuDataCommonEntities $basecommand $append_result]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w    
    return $menu_data
}

proc GetMenuDataSignalEntities { } {
    set menu_data [list]
    set labels [list [_ "Coordinates#C#menu"] ---]
    set commands {{GiD_Process Mescape Utilities SignalEntities Points FNoJoin} ""}
    set accelerator ""
    set image ""
    set disabled 0
    foreach label $labels command $commands {
        if { $label=="---" } {
            lappend menu_data [list i --- "" "" "" 0 0]
        } else {
            lappend menu_data [list i $label $command $accelerator $image $disabled 0]
        }
    }
    lappend menu_data {*}[GetMenuDataCommonEntities {GiD_Process Mescape Utilities SignalEntities} 0]
    return $menu_data
}

proc AddEntitiesToMenuSignalEntities { w } {    
    set menu_data [GetMenuDataSignalEntities]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w    
    return $menu_data
}

#icon_size: small_icons or toolbar
proc AddBitmapsDeleteMenu { w icon_size {whatuse ""} } {
    if { $whatuse == "" } {
        set whatuse [GiD_Info Project ViewMode]
    }
    $w delete 0 end
    set ::GidPriv(DeleteAlsoLower) [GiD_Set DeleteAlsoLower]
    $w add checkbutton -label [_ "Also lower entities"] -variable ::GidPriv(DeleteAlsoLower) -command {GiD_Set DeleteAlsoLower $::GidPriv(DeleteAlsoLower)}
    if { $whatuse == "GEOMETRYUSE" } {
        set points_to_volumes [GetGeometryCommands 0]
        foreach image [GetGeometryImageFiles 1] label [GetGeometryLabels 1] command [GetGeometryCommands 1] {
            set color black
            if { [lsearch $points_to_volumes $command] != -1 } {
                if { ![GiD_Info Geometry Num$command] } {
                    set color $::GidPriv(Color,DisabledForegroundMenu)
                }
            }
            #AddImageCommandToMenu $w [gid_themes::GetImage $image $icon_size] [list DoGeometryDelete $command]
            if { $label == "---"} {
                $w add separator
            } else {
                $w add command -image [gid_themes::GetImage $image $icon_size] -label $label -compound left -foreground $color -command [list DoGeometryDelete $command]
            }
        }
    } elseif { $whatuse == "MESHUSE" } {
        foreach image [GetMeshImageFiles 0] label [GetMeshLabels 0] command [GetMeshCommands 0] {
            set color black
            if { ![GiD_Info Mesh Num$command] } {
                set color $::GidPriv(Color,DisabledForegroundMenu)
            }
            #AddImageCommandToMenu $w [gid_themes::GetImage $image $icon_size] [list DoMeshDelete $command]
            $w add command -image [gid_themes::GetImage $image $icon_size] -label $label -compound left -foreground $color -command [list DoMeshDelete $command]
        }
    } else {
        #do nothing by now..
    }
}

proc AddBitmapsToCamera { w basecommand args} {
    $w delete 0 end
    set hardcopylist "eps.png ps.png bmp.png gif.png jpeg.png png.png tga.png tiff.png vrml.png pdf.png"
    foreach i $hardcopylist {
        set command [file rootname $i]
        #AddImageCommandToMenu $w [ gid_themes::GetImage $i menu] "$basecommand $command"   
        $w add command -label [_ "%s image" $command] -image [gid_themes::GetImage $i menu] -command [list {*}$basecommand $command] -compound left
    }
}

proc AddBitmapsToDisplayStyle { w basecommand args } {
    set display_style_current [GiD_Set DisplayStyle]
    lassign [GetDisplayStyleImagesAndCommands] display_style_images display_style_commands
    $w delete 0 end
    foreach display_style $display_style_commands image_name $display_style_images {
        set image [gid_themes::GetImage $image_name toolbar]
        if { $display_style != $display_style_current} {
            AddImageCommandToMenu $w $image [list {*}$basecommand $display_style]
        } else {
            AddImageCommandToMenu $w $image "" disabled
        }
    }
}

proc AddBitmapsToCullStyle { w basecommand args } {
    set cull_style_current [GiD_Set Culling]
    set cull_style_commands [list none frontfaces backfaces]
    $w delete 0 end
    foreach cull_style_command $cull_style_commands i {0 1 2} {
        set image [gid_themes::GetImage cull$cull_style_command.png toolbar]
        if { $i != $cull_style_current} {
            AddImageCommandToMenu $w $image [list {*}$basecommand $cull_style_command]
        } else {
            AddImageCommandToMenu $w $image "" disabled
        }
    }
}

proc AddBitmapsToCutDivide { w basecommand que args} {
    set displaystylelist "cut2p.png cut3p.png"
    $w delete 0 end
    AddImageCommandToMenu $w [ gid_themes::GetImage cut2p.png toolbar] [list {*}$basecommand $que]
    # $w add command -image [ gid_themes::GetImage cut2p.png toolbar] -command [list {*}$basecommand $que] -hidemargin 1
    AddImageCommandToMenu $w [ gid_themes::GetImage cut3p.png toolbar] [list {*}$basecommand $que ThreePoints]
    # $w add command -image [ gid_themes::GetImage cut3p.png toolbar] -command [list {*}$basecommand $que ThreePoints] -hidemargin 1
    if { $que == "CutPlane"} {
        AddImageCommandToMenu $w [ gid_themes::GetImage cut_succesion.png toolbar] [list {*}$basecommand Succesion]
        # $w add command -image [ gid_themes::GetImage cut_succesion.png toolbar] -command [list {*}$basecommand Succesion] -hidemargin 1
    }
}

proc AddBitmapsToMeshSetCut { w basecommand que args} {
    global GidPriv

    $w delete 0 end
    set UnderLineList {}
    set all_que [ GiD_Info postprocess get all_$que]
    if { $all_que == ""} {
        $w add command -label [_ "There are no %s" $que] -state disabled
        return
    }
    if { [ llength $all_que] < 17 } {
        set all_colors [ GiD_Info postprocess get all_$que\_colors]
        set que_on [ GiD_Info postprocess get cur_$que]
        set jc 0
        foreach j $all_que {
            regsub {_} $j { } lab
            set under [FindUnderChar lab UnderLineList]
            set col_set [ lindex $all_colors $jc]
            # es una list { ambient diffuse specular shininess}
            set col_diffuse [ lindex $col_set 1]
            if { [lsearch $que_on $j] != -1 } {
                $w add command -image [gid_themes::GetImage $que\_on_OneColor.png medium_icons] -background $col_diffuse \
                    -command [list {*}$basecommand $que $j escape] -label $lab -underline $under -hidemargin 1
            } else {
                $w add command -image [gid_themes::GetImage $que\_OneColor.png medium_icons] -background $col_diffuse \
                    -command [list {*}$basecommand $que $j escape] -label $lab -underline $under -hidemargin 1
            }
            incr jc            
        }
        if { [ llength $all_que] > 1} {
            set lab [_ "All On"]
            set under [FindUnderChar lab UnderLineList]
            $w add command -label $lab -underline $under -command [list {*}$basecommand $que all_$que escape] -hidemargin 1
            set lab [_ "All Off"]
            set under [FindUnderChar lab UnderLineList]
            $w add command -label $lab -underline $under -command [list {*}$basecommand $que no_$que escape] -hidemargin 1
        }
    } else {
        set lab [_ "Style Window"]
        set under [FindUnderChar lab UnderLineList]
        $w add command -label $lab -underline $under -command " \
            set GidPriv(WinList_volumes) 0; \
            set GidPriv(WinList_surfaces) 0; \
            set GidPriv(WinList_cuts) 0; \
            set GidPriv(WinList_$que) 1; \
            PostDisplay" \
            -hidemargin 1
    }
}

#set disable graphics, process args, and enable graphics again
proc GiD_ProcessDisablingEnabling { args } {
    GidUtils::DisableGraphics
    GiD_Process {*}$args
    GidUtils::EnableGraphics
    GiD_Process 'Redraw
    if { [ esMac]} {
        doUpdateMenusMac
    }
}

proc GetValidMenuNameFromName { name } {
    regsub -all {\.} $name {_} menu_name
    return $menu_name
}

proc AddAnalysisStepsToMenu { w args} {
    global ViewMenuPriv GidPriv RMenuRPriv

    # registramos los menus
    # if { [ esMac]} {
    #         registerPostAnalysisStepMenu $w
    #         $w configure -postcommand ""
    # }

    rmenuinit
    set all_anal [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    # set all_anal [ GiD_Info postprocess get all_analysis]

    #if { ![esMac]}  # en mac solo nos llaman cuando hay que rehacer los menus
    if { 1} { # en mac solo nos llaman cuando hay que rehacer los menus
        if { ![ GiD_Info postprocess get changed_analysis_step] && \
                 ![ GiD_Info postprocess get changed_results_view] && \
                 [ info exists ViewMenuPriv($w,all_anal)] && \
                 ( $ViewMenuPriv($w,all_anal) == $all_anal) } {
            set igual 1
            foreach i $all_anal {
                if { [ info exists ViewMenuPriv($w,$i)]} {
                    if { [ catch { set all_step [ GiD_Info postprocess get all_steps $i]}]} {
                        set all_step {}
                    }
                    if { $ViewMenuPriv($w,$i) != $all_step} {
                        set igual 0
                        break
                    }
                } else {
                    set igual 0
                    break
                }
            }
            if { $igual} {
                return
            }
        }
    }

    $w delete 0 end

    set ViewMenuPriv($w,all_anal) $all_anal

    # get current result visualization
    set cur_analysis [GiD_Info postprocess get cur_analysis]
    set cur_step [GiD_Info postprocess get cur_step $cur_analysis]
    set cur_res [GiD_Info postprocess get cur_result]
    set cur_res_view  [GiD_Info postprocess get cur_results_view]
    set cur_comp [GiD_Info postprocess get cur_component]

    regsub -all {_} $cur_res_view {} result_view
    set restcommand [list Mescape Results $result_view $cur_res $cur_comp]
    set no_res_command [list escape escape escape escape results Geometry NoResults]
    set no_def_command [list Geometry Original escape escape escape escape ]
    set no_labels_command [ list Mescape View Label Off escape escape escape escape ]
    set iso_hecho 0
    set check_comp 0

    switch $cur_res_view {
        "Iso_Surfaces" {
            set values [GiD_Info postprocess get iso_cur_result_values]
            set values [lindex $values 0]
            set lstVal [lindex $values 1]
            set restcommand [list $result_view exact $cur_res $cur_comp [lindex $values 0] {*}$lstVal]
            set iso_hecho 1
            set check_comp 1
        }
        "Stream_Lines" {
            set restcommand [list]
            set check_comp 0
        }
        "No_Result" {
            set restcommand [list]
            set check_comp 0
        }
        "Display_Vectors" {
            set check_comp 1
            set result_exists [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]]
            if { $result_exists } {
                set value [GiD_Info postprocess get cur_vector_factor $cur_res_view $cur_res $cur_analysis $cur_step]
            } else {
                set value 1.0
            }
            lappend restcommand $value escape
        }
        "Result_Surface" {
            set check_comp 1
            set result_exists [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]]
            if { $result_exists } {
                set value [GiD_Info postprocess get cur_result_surface_factor $cur_res_view $cur_res $cur_comp $cur_analysis $cur_step]
            } else {
                set value 1.0
            }
            lappend restcommand $value escape
        }
        "Line_Thickness" {
            set check_comp 1
            set result_exists [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]]
            if { $result_exists } {
                set value [GiD_Info postprocess get cur_result_surface_factor $cur_res_view $cur_res $cur_comp $cur_analysis $cur_step]
            } else {
                set value 1.0
            }
            lappend restcommand $value escape
        }
        "Contour_Fill" {
            set check_comp 1
            if { [string tolower [GiD_Set PostResOverRes]] == "yes"} {
                set restcommand [list {*}$no_res_command {*}$restcommand]
            }
        }
        default {
        }
    }

    # may be together with an iso-surface
    set iso_cmd ""
    set iso_res ""
    if { !$iso_hecho} {
        set iso_values [ lindex [ GiD_Info postprocess get iso_cur_result_values] 0]
        # set iso_values [ lindex $iso_values 0]
        if { [ llength $iso_values] != 0} {
            set iso_res [lindex $GidPriv(PostAnimateIsoSurfaces) 2]
            set lstVal [lindex $iso_values 1]
            set iso_cmd [list Mescape Results IsoSurfaces Exact [lindex $iso_res 0] [lindex $iso_res 1]]
            lappend iso_cmd [lindex $iso_values 0] {*}$lstVal
        }
    }

    # check for deformation ...
    set is_deformed 0
    set defor_command ""
    set cur_defor ""
    set mainst [GiD_Info postprocess get main_geom_state]
    if { $mainst == "Deformed" } {
        # if deformation analysis and step are the same as current ones, then
        # when the user changes analysis and step, we'll actualize deformation too
        set cur_defor_anal [ GiD_Info postprocess get main_geom_cur_analysis]
        set cur_defor_step [ GiD_Info postprocess get main_geom_cur_step]
        if { ( $cur_defor_anal == $cur_analysis) && ( $cur_defor_step == $cur_step)} {
            set is_deformed 1
            set cur_defor [ GiD_Info postprocess get main_geom_cur_deform]
            set cur_defor_factor [GiD_Info postprocess get main_geom_cur_factor]
            set defor_command [list Mescape results Geometry Original]
            lappend defor_command Geometry Deformation $cur_defor $cur_defor_factor escape
        }
    }

    if { $all_anal == ""} {
        $w add command -label [_ "Please load a MODEL first"] -state disabled
        return
    }

    set UnderLineList {}
    foreach i $all_anal {
        set menu_txt [TranslateResultName $i]        
        set under [FindUnderChar menu_txt UnderLineList]
        set menu_name [GetValidMenuNameFromName $i]
        set img $GidPriv(VerifNoImage)
        if { $cur_analysis == $i } {
            set img $GidPriv(VerifImage)
        }
        $w add cascade -label $menu_txt -underline $under -menu $w.m$menu_name  -image $img -compound left
        # set all_step [ GiD_Info postprocess get all_steps $i]
        if { [ catch { set all_step [ GiD_Info postprocess get all_steps $i]}]} {
            set all_step {}
        }
        set ViewMenuPriv($w,$i) $all_step
        set cur_step [ GiD_Info postprocess get cur_step $i]
        if { [ winfo exists $w.m$menu_name ]} {
            $w.m$menu_name delete 0 end
        } else {
            menu $w.m$menu_name
        }

        set words ""

        set entrada_window 0
        if { ( [ llength $all_step] > $RMenuRPriv(MaxAbsolute)) && ( $RMenuRPriv(MaxAbsolute) > 2)} {
            set all_step [ lrange $all_step 0 [ expr $RMenuRPriv(MaxAbsolute) - 2]]
            set entrada_window 1
        }

        foreach j $all_step {
            set all_res [ GiD_Info postprocess get results_list $cur_res_view $i $j]
            # set all_defor_res [ GiD_Info postprocess get main_geom_all_deform $i $j]
            # main_geom_all_deform works is for current analysis+step, i.e. without parameters
            set all_defor_res [ GiD_Info postprocess get show_geom_all_deform $i $j]
            if { [ lsearch $all_defor_res $cur_defor] == -1} {
                set cmds $no_def_command
            } else {
                set cmds $defor_command
            }
            if { [ lsearch $all_res $cur_res] == -1} {
                lappend cmds {*}$no_res_command
            } else {
                set all_comp [ GiD_Info postprocess get components_list $cur_res_view $cur_res $i $j]
                if { $check_comp && ( [ lsearch $all_comp $cur_comp] == -1)} {
                    lappend cmds {*}$no_res_command
                } else {
                    lappend cmds {*}$restcommand
                }
            }
            if { ( $iso_res != "") && ( [lsearch $all_res [lindex $iso_res 0]] != -1)} {
                set cmds [list {*}$iso_cmd {*}$cmds]
            }            
            set process_commands [list Mescape Results AnalysisSel $i $j {*}$cmds]
            if { ( $cur_analysis == $i) &&( $cur_step == $j) } {
                lappend words [list $j [list GiD_Process {*}$process_commands] check]
            } else {
                lappend words [list $j [list GiD_Process {*}$process_commands]]
            }
        }
        rmenuconf $w.m$menu_name $words

        if { $entrada_window} {
            $w.m$menu_name add separator
            $w.m$menu_name add command -label ...[_ "More"]... -command PostGeom::Create
        }
    }
}

proc ResultsNoStep { } {
    WarnWin [_ "Please select a Step first"]
}

#return a menu, creating if necessary intermediaty menus based on name,
#e.g. name== a//b//c
#create a->b submenus and return it
proc GetMenuCreatingCascadeMenuFromResultName { menu name img } {
    set name_split [GidUtils::Split $name //]
    if { [llength $name_split] == 1 } {    
        return $menu
    }
    set wm $menu
    set name_parents [lrange $name_split 0 end-1]
    # en windows parece haber un nivel de anidamiento maximo de 10 para el top menu bar
    # 8 del path del resultado + 1 del resultado + 1 del componente del resultado
    if { [ llength $name_parents] >= 7} {
        return ""
    }
    foreach subm $name_parents {
        if { $subm == ""} { 
            continue
        }        
        set txt [TranslateResultName $subm]
        set menu_name [GetValidMenuNameFromName $subm]
        if { [catch { $wm index $txt}] || [$wm index $txt] == "none" } {
            if { $img != ""} {
                $wm add cascade -label $txt -menu $wm.m$menu_name -image $img -compound left
            } else {
                $wm add cascade -label $txt -menu $wm.m$menu_name
            }
            if { [winfo exists $wm.m$menu_name] } {
                $wm.m$menu_name delete 0 end
            } else {
                menu $wm.m$menu_name
            }
        } else {
            #WarnWinText "[winfo class $wm] $wm index '$txt' [ $wm index [ list $txt]]"
        }
        set wm $wm.m$menu_name
    }
    return $wm
}

proc IsCurrentMainDeformatorComplex { } {
    set is_current_main_deformator_complex 0
    set current_deformator_result [GiD_Info postprocess get main_geom_cur_deform]
    set current_analysis [GiD_Info postprocess get main_geom_cur_anal]
    set current_step [GiD_Info postprocess get main_geom_cur_step]
    set result_id [list $current_deformator_result $current_analysis $current_step]
    if { [GiD_Result exists $result_id] } {
        set result_header [lindex [GiD_Result get -info $result_id] 0]
        if { [lindex $result_header 4] == "ComplexVector" } {
            set is_current_main_deformator_complex 1
        }   
    }    
    return $is_current_main_deformator_complex
}

proc CalculatePositionFromMenu { menu} {
    set x [winfo x $menu]
    set y [winfo y $menu]
    set width [winfo width $menu]
    set w [winfo parent $menu]
    set xo $x
    set yo $y
    while { $menu != "" } {
        set xp [winfo x $menu]
        set yp [winfo y $menu]
        set x [expr $x + $xp]
        set y [expr $y + $yp + 16]
        if { [winfo class $menu] == "Toplevel"} {
            break
        }
        set menu [winfo parent $menu]
    }
    if { $::tcl_platform(os) != "Linux" } {
        set x [expr $x + $width + 16]
        set y [expr $y]
    } else {
        set x [expr $xo + 16]
        set y [expr $yo]
    }
    if { $::tcl_platform(os) == "Darwin" } {
        # in macOS the the interactive toplevel window (deformation, isosurface, ...) appears somewhat below as it should be...
        set y [ expr $y - 78]
        if { $y < 0} {
            set y 0
        }
    }
    return [list $x $y]
}

proc DoDeformationUpdate { w_scale factor } {
    if { [ winfo exists $w_scale]} {
        # adjust from and to values of scale to show correctly the selected value
        set from [ $w_scale cget -from]
        set to [ $w_scale cget -to]
        set resol [ $w_scale cget -resolution]
        set idx_total [ expr int( ( $to - $from) / $resol)]
        # get if factor is a multiple of $resolution starting $from
        set idx_real [ expr ( $factor - $from) / $resol]
        set idx_int [ expr int( 0.5 + ( $factor - $from) / $resol)]
        set dif [ expr abs( $idx_real - $idx_int)]
        if { $idx_int >= $idx_total} {
            while { $idx_int >= $idx_total} {
                incr idx_total
            }
        }
        if { $dif > 1e-15} {
            set from [ expr $factor - ( $idx_int + 1) * $resol]
            set to [ expr $from + ( $idx_total + 1) * $resol]
            $w_scale configure -from $from -to $to
        }
        $w_scale set $factor
    }
    GiD_Process $factor
}

proc DoDeformationUpdateFactorValue { w_scale w_button } {
    set factor [MessageBoxEntry [_ "Enter value window"] [_ "Enter deformation factor"]: real $::GidPriv(UserDeformationFactorValue) 0 question.png]
    if { $factor != "" } {
        set ::GidPriv(UserDeformationFactorValue) $factor
        if { [ winfo exists $w_button]} {
            $w_button configure -text ${factor}x -width [ string length ${factor}x]
        }
        DoDeformationUpdate $w_scale $factor
    }
}

proc DoDeformationUpdateTheta { factor } {
    GiD_Process Theta $factor
}

proc DoDeformationWithScale { menu basecommand args } {
    set resName [lindex $args 0]    
    # get previous deformation scale for the result...
    # check if user want only change factor of actual deformation:
    set previousFactor ""
    if { [GiD_Info postprocess get main_geom_state] == "Deformed" } {
        set current_deformation_result [GiD_Info postprocess get main_geom_cur_deform]
        if { $current_deformation_result == $resName } {
            set previousFactor [GiD_Info postprocess get main_geom_cur_factor]
        }
    }
    if { $previousFactor != "" } {
        {*}$basecommand $resName $previousFactor
    } else {
        {*}$basecommand $resName
    }
    set an [GiD_Info postprocess get main_geom_cur_analysis]
    set st [GiD_Info postprocess get main_geom_cur_step]
    set suggestedFactor [GiD_Info postprocess get main_geom_factor $an $st $resName]
    if { $suggestedFactor <= 0 } {
        set suggestedFactor 1
    }
    
    lassign [CalculatePositionFromMenu $menu] x y

    set w_top .wPostDefScale
    if { [ winfo exists $w_top]} {
        destroy $w_top
    }
    
    toplevel $w_top
    
    wm geometry $w_top +$x+$y
    wm title $w_top [_ "Deformation scale"]
    wm minsize $w_top 1 1
    wm overrideredirect $w_top 1

    ttk::labelframe $w_top.f -style ridge.TFrame -borderwidth 1 -text [_ "Deformation factor"]
    set from_val 0
    set to_val [expr $suggestedFactor*3.0]
    set resol_val [expr $suggestedFactor*0.05]
    set w_scale $w_top.f.defScale
    gidscale $w_scale -orient horizontal -from $from_val -to $to_val -resolution $resol_val \
        -showbuttons 1 -symbolbuttons "< >" -command [list DoDeformationUpdate $w_scale]
                
    $w_scale set $suggestedFactor        
    if { ![ info exists ::GidPriv(UserDeformationFactorValue)]} {
        set ::GidPriv(UserDeformationFactorValue) 1
    }    
    ttk::button $w_top.f.b1 -text ${::GidPriv(UserDeformationFactorValue)}x \
        -width [string length ${::GidPriv(UserDeformationFactorValue)}x] \
        -command [list DoDeformationUpdateFactorValue $w_scale $w_top.f.b1]
    ttk::button $w_top.f.b2 -image [gid_themes::GetImage close.png] -command [list destroy $w_top]

    set is_current_main_deformator_complex [IsCurrentMainDeformatorComplex]
    if { $is_current_main_deformator_complex } {        
        set f_theta [ttk::labelframe $w_top.ftheta -style ridge.TFrame -borderwidth 1 -text [_ "Phase shift (degrees)"]]
        set scale_theta [gidscale $f_theta.scale -orient horizontal -from 0.0 -to 360.0 -resolution [expr 360.0/15.0] \
            -showbuttons 1 -symbolbuttons "< >" -command [list DoDeformationUpdateTheta]]
    }

    bind $w_top <Return> "destroy $w_top"
    bind $w_top <Escape> "destroy $w_top"
    bind $w_top <1> "+PostCloseFLoatingWindow %W %x %y"

    grid $w_scale -padx 2 -pady 1 -sticky ew
    grid $w_top.f.b1 -column 1 -row 0 -padx 1 -pady 1
    grid $w_top.f.b2 -column 2 -row 0 -padx 1 -pady 1
    grid rowconfigure $w_top.f 0 -weight 1
    grid columnconfigure $w_top.f 0 -weight 1

    grid $w_top.f -sticky ew
    if { $is_current_main_deformator_complex } {
        grid $scale_theta -padx 2 -pady 1 -sticky ew
        grid $f_theta -sticky ew -columnspan 3
    }
    grid rowconfigure $w_top {0 1} -weight 1
    grid columnconfigure $w_top 0 -weight 1
    focus -force $w_scale
    update
    # make slider a bit bigger
    set reqh [winfo reqheight $w_top]
    #wm geometry $w_top 250x$reqh
    if { $::tcl_platform(os) == "Darwin" } {
        # give macOs a bit time to prepare the window and then move it to where it should be
        after 100 [ list wm geometry $w_top +$x+$y ]
    } else {
        wm geometry $w_top +$x+$y
    }
    grab $w_top    
}

proc DoIsosurfaceUpdate { w_scale comm after res comp fact} {
    if { $::updateIsosurfaceBusy} { return}
    set ::updateIsosurfaceBusy 1
    GidUtils::WaitState
    set old_wl [GiD_Project set disable_warnline]
    set old_win [GiD_Project set disable_windows]
    GiD_Project set disable_warnline 1
    GiD_Project set disable_windows 1
    GidUtils::DisableGraphics
    {*}$comm $res $comp 1 $fact 
    if { $::updateIsosurfaceWithCFill} {
        GiD_Process {*}$after
    }
    GidUtils::EnableGraphics
    GiD_Process 'Redraw
    # ensure correct position, if the user has changed in the meantime...
    if { [ winfo exists $w_scale]} {
        $w_scale set $fact
    }
    GiD_Project set disable_warnline $old_wl
    GiD_Project set disable_windows $old_win
    GidUtils::EndWaitState
    
    # adjust from and to values of scale to show correctly the selected value
    set from [ $w_scale cget -from]
    set to [ $w_scale cget -to]
    set resol [ $w_scale cget -resolution]
    set idx_total [ expr int( ( $to - $from) / $resol)]
    # get if fact is a multiple of $resolution starting $from
    set idx_real [ expr ( $fact - $from) / $resol]
    set idx_int [ expr int( 0.5 + ( $fact - $from) / $resol)]
    set dif [ expr abs( $idx_real - $idx_int)]
    
    if { $idx_int >= $idx_total} {
        while { $idx_int >= $idx_total} {
            incr idx_total
        }
    }
    if { $dif > 1e-15} {
        set from [ expr $fact - ( $idx_int + 1) * $resol]
        set to [ expr $from + ( $idx_total + 1) * $resol]
        $w_scale configure -from $from -to $to
    }
    $w_scale set $fact
    
    set ::updateIsosurfaceBusy 0
}

proc DoIsosurfaceUpdateValue { w_scale w_button comm after res comp } {
    set retval [MessageBoxEntry [_ "Enter value window"] [_ "Enter value for iso-surface"]: real $::updateIsosurfaceButtonValue 0 question.png]
    if { $retval != "" } {
        set ::updateIsosurfaceButtonValue $retval
        $w_button configure -text $retval -width [ string length $retval]
        DoIsosurfaceUpdate $w_scale $comm $after $res $comp $retval        
    }    
}

proc DoIsosurfaceWithScale { menu basecommand args} {
    set resName [ lindex $args 0]
    set compName [ lindex $args 1]
    if { $compName == "" } {        
        set compName [lindex [GidUtils::Split $resName //] end]
    }

    # get previous deformation scale for the result...
    # check if user want only change factor of actual deformation:
    set previousValue ""
    set cur_analysis [GiD_Info postprocess get cur_analysis]
    set cur_step [GiD_Info postprocess get cur_step $cur_analysis]
    set cur_res_view [GiD_Info postprocess get cur_results_view]
    set cur_res [GiD_Info postprocess get cur_result]
    set cur_comp [GiD_Info postprocess get cur_component]
    set restcommand [list escape]
    if { $cur_res_view == "Iso_Surfaces" && $cur_res == $resName && $cur_comp == $compName } {
        set lst_iso_vales [ lindex [ lindex [ GiD_Info post get iso_cur_result_values] 0] 1]
        set previousValue [ lindex $lst_iso_vales 0]
    } else {
        # may be it's together with something else
        set lst_iso_vales [ lindex [ lindex [ GiD_Info post get iso_cur_result_values] 0] 1]
        set previousValue [ lindex $lst_iso_vales 0]
        # add current result visualization
        regsub -all {_} $cur_res_view {} result_view
        set restcommand [list Mescape Results $result_view $cur_res $cur_comp escape]
        set no_res_command [list Mescape Results Geometry NoResults]
        set no_def_command [list Geometry Original escape escape escape escape]
        set no_labels_command [ list Mescape View Label Off escape escape escape escape]
        switch $cur_res_view {
            "Stream_Lines" {
                # do not redo
                set restcommand [list escape]
            }
            "No_Result" {
                # do not redo
                set restcommand [list escape]
            }
            "Display_Vectors" {
                set result_exists [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]]
                if { $result_exists } {
                    set value [GiD_Info postprocess get cur_vector_factor $cur_res_view $cur_res $cur_analysis $cur_step]
                } else {
                    set value 1.0
                }
                lappend restcommand $value escape
            }
            "Result_Surface" {
                set result_exists [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]]
                if { $result_exists } {
                    set value [GiD_Info postprocess get cur_result_surface_factor $cur_res_view $cur_res $cur_comp $cur_analysis $cur_step]
                } else {
                set value 1.0
                }
                lappend restcommand $value escape
            }
            "Line_Thickness" {
                set result_exists [GiD_Result exists [list $::GidPriv(PostAnimate_cur_res) $::GidPriv(PostAnimate_cur_analysis) $::GidPriv(PostAnimate_cur_step)]]
                if { $result_exists } {
                    set value [GiD_Info postprocess get cur_result_surface_factor $cur_res_view $cur_res $cur_comp $cur_analysis $cur_step]
                } else {
                    set value 1.0
                }
                lappend restcommand $value escape
            }
            "Contour_Fill" {
                if { [string tolower [GiD_Set PostResOverRes]] == "yes"} {
                    set restcommand [list {*}$no_res_command {*}$restcommand]
                }
            }
            default {
            }
        }
    }

    # if no other result view is present, then add also contour fill to show color of isosurface according to the result
    if { $restcommand == "escape"} {
        set restcommand [list Mescape results ContourFill $resName $compName escape]
        # show a combined iso-surface + c.fill with same result to show the legend.
        GiD_Process Mescape Results isosurfaces DisplayStyle ContourFillColor
    }

    if { ![ info exist ::updateIsosurfaceWithCFill]} {
        set ::updateIsosurfaceWithCFill 0
    }

    set comp_min [ GiD_Result get -componentmin [ list $resName $cur_analysis $cur_step $compName]]
    set comp_max [ GiD_Result get -componentmax [ list $resName $cur_analysis $cur_step $compName]]
    set suggestedValue [ expr 0.5 * ( $comp_max + $comp_min)]
    GidUtils::DisableGraphics
    # do the iso-surface
    if { "$previousValue" != "" } {
        # isosurfaces exact
        {*}$basecommand $resName $compName 1 $previousValue Mescape 
        if { $::updateIsosurfaceWithCFill} {
            GiD_Process {*}$restcommand
        }
        set suggestedValue $previousValue
    } else {
        {*}$basecommand $resName $compName 1 $suggestedValue Mescape 
        if { $::updateIsosurfaceWithCFill} {
            GiD_Process {*}$restcommand
        }
    }
    GidUtils::EnableGraphics
    GiD_Process 'Redraw

    lassign [CalculatePositionFromMenu $menu] x y
        
    if { [ winfo exists .wPostDefScale]} {
        destroy .wPostDefScale
    }
    toplevel .wPostDefScale
    wm geometry .wPostDefScale +$x+$y
    wm title .wPostDefScale [_ "Deformation scale"]
    wm minsize .wPostDefScale 1 1
    wm overrideredirect .wPostDefScale 1

    ttk::frame .wPostDefScale.f -style ridge.TFrame -borderwidth 2

    set ::updateIsosurfaceBusy 0


    set from_val $comp_min
    set to_val $comp_max
    set resol_val [ expr 0.01 * ( $comp_max - $comp_min)]
    set w_scale .wPostDefScale.f.defScale
    gidscale .wPostDefScale.f.defScale -orient horizontal \
        -from $from_val -to $to_val -resolution $resol_val \
        -showbuttons 1 -symbolbuttons "< >" \
        -command [ list after idle [list DoIsosurfaceUpdate $w_scale $basecommand $restcommand "$resName" "$compName"]]
        
    .wPostDefScale.f.defScale set $suggestedValue
    
    if { ![ info exists ::updateIsosurfaceButtonValue]} {
        set ::updateIsosurfaceButtonValue 0.0
    }
  

    ttk::button .wPostDefScale.f.b1 -text $::updateIsosurfaceButtonValue -width 3 -command \
        [list DoIsosurfaceUpdateValue $w_scale .wPostDefScale.f.b1 $basecommand $restcommand $resName $compName]
    ttk::button .wPostDefScale.f.b2 -image [gid_themes::GetImage close.png] -command [list destroy .wPostDefScale]
    bind .wPostDefScale <Return> "destroy .wPostDefScale"
    bind .wPostDefScale <Escape> "destroy .wPostDefScale"
    bind .wPostDefScale <1> "+PostCloseFLoatingWindow %W %x %y"

    ttk::checkbutton .wPostDefScale.f.cb -text [_ "Draw iso-surface's value colour"] \
        -variable ::updateIsosurfaceWithCFill \
        -command [ list after idle [list DoIsosurfaceUpdate $w_scale $basecommand $restcommand "$resName" "$compName" [$w_scale get]]]

    grid .wPostDefScale.f.defScale -padx 2 -pady 1 -sticky news
    grid .wPostDefScale.f.b1 -column 1 -row 0 -padx 1 -pady 1
    grid .wPostDefScale.f.b2 -column 2 -row 0 -padx 1 -pady 1
    grid .wPostDefScale.f.cb -columnspan 3 -padx 1 -pady 1 -sticky ew

    grid rowconfigure .wPostDefScale.f 0 -weight 1
    grid columnconfigure .wPostDefScale.f 0 -weight 1
    grid .wPostDefScale.f -sticky news
    grid rowconfigure .wPostDefScale 0 -weight 1
    grid columnconfigure .wPostDefScale 0 -weight 1
    focus -force .wPostDefScale.f.defScale
    update
    # make slider a bit bigger
    set reqh [ winfo reqheight .wPostDefScale]
    # wm geometry .wPostDefScale 250x$reqh+$x+$y
    if { $::tcl_platform(os) == "Darwin" } {
        # give macOs a bit time to prepare the window and then move it to where it should be
        after 100 [ list wm geometry .wPostDefScale 250x$reqh+$x+$y]
    } else {
        wm geometry .wPostDefScale 250x$reqh+$x+$y
    }
    grab .wPostDefScale
    
}

proc DoVolumeRenderUpdateThreshold { fact} {
    if { $::PostVolRenderScaleAfterId != ""} {
        after cancel $::PostVolRenderScaleAfterId
        set ::PostVolRenderScaleAfterId ""
    }
    set old [GiD_Project set disable_warnline]
    GiD_Project set disable_warnline 1
    GiD_Set VolumeRendering(Threshold) $fact
    set ::PostVolRenderScaleAfterId [ after 500 {GiD_Redraw ; set ::PostVolRenderScaleAfterId ""}]
    GiD_Project set disable_warnline $old
    DoVolumeRenderUpdateCanvas
}

proc DoVolumeRenderUpdateInvertAlpha {} {
    if { $::PostVolRenderScaleAfterId != ""} {
        after cancel $::PostVolRenderScaleAfterId
        set ::PostVolRenderScaleAfterId ""
    }
    set old [GiD_Project set disable_warnline]
    GiD_Project set disable_warnline 1
    GiD_Set VolumeRendering(InvertAlphaScale) $::PostVolRenderScaleInvertAlpha
    set ::PostVolRenderScaleAfterId [ after 500 {GiD_Redraw ; set ::PostVolRenderScaleAfterId ""}]
    GiD_Project set disable_warnline $old
    DoVolumeRenderUpdateCanvas
}

proc DoVolumeRenderUpdateMaximumAlpha {} {
    if { $::PostVolRenderScaleAfterId != ""} {
        after cancel $::PostVolRenderScaleAfterId
        set ::PostVolRenderScaleAfterId ""
    }
    set err [ catch {
            set val [ expr $::PostVolRenderScaleMaximumAlpha]
        } ]
    if { !$err && ( $val >= 0.0) && ( $val <= 1.0)} {
        set old [GiD_Project set disable_warnline]
        GiD_Project set disable_warnline 1
        GiD_Set VolumeRendering(MaximumAlpha) $val
        set ::PostVolRenderScaleAfterId [ after 500 {GiD_Redraw ; set ::PostVolRenderScaleAfterId ""}]
        GiD_Project set disable_warnline $old
    }
}

proc DoVolumeRenderUpdateMinimumAlpha {} {
    if { $::PostVolRenderScaleAfterId != ""} {
        after cancel $::PostVolRenderScaleAfterId
        set ::PostVolRenderScaleAfterId ""
    }
    set err [ catch {
            set val [ expr $::PostVolRenderScaleMinimumAlpha]
        } ]
    if { !$err && ( $val >= 0.0) && ( $val <= 1.0)} {
        set old [GiD_Project set disable_warnline]
        GiD_Project set disable_warnline 1
        GiD_Set VolumeRendering(MinimumAlpha) $val
        set ::PostVolRenderScaleAfterId [ after 500 {GiD_Redraw ; set ::PostVolRenderScaleAfterId ""}]
        GiD_Project set disable_warnline $old
    }
}

proc DoVolumeRenderUpdateAlphaCurve {} {
    if { $::PostVolRenderScaleAfterId != ""} {
        after cancel $::PostVolRenderScaleAfterId
        set ::PostVolRenderScaleAfterId ""
    }
    set old [GiD_Project set disable_warnline]
    GiD_Project set disable_warnline 1
    GiD_Set VolumeRendering(AlphaCurveType) $::PostVolRenderScaleAlphaCurve
    set ::PostVolRenderScaleAfterId [ after 500 {GiD_Redraw ; set ::PostVolRenderScaleAfterId ""}]
    GiD_Project set disable_warnline $old
    DoVolumeRenderUpdateCanvas
}

# x = 0.0 .. 1.0
proc DoVolumeRenderGetAtanValue { x threshold} {
    set atan_param 0.0
    if { $threshold < 0.5} {
        set atan_param [ expr -20.0 * ( 1.0 - $x) * $threshold + 10.0 * $x]
    } else {
        set atan_param [ expr -20.0 * $x * $threshold + 30.0 * $x - 10.0]
    }
    set w [ expr ( 1.5 + atan( $atan_param)) / 3.0]
    return $w
}
proc DoVolumeRenderGetLinearValue { x threshold} {
    # from 0.0 to 0.5 if ( x < threshold )
    # from 0.5 to 1.0 if ( x >= threshold )
    set linear_param 0.0
    if { $x < $threshold} {
        set linear_param [ expr 0.5 * $x / $threshold]
    } else {
        set linear_param [ expr 0.5 + 0.5 * ( $x - $threshold) / ( 1.0 - $threshold)]
    }
    return $linear_param
}

proc DoVolumeRenderUpdateCanvas { } {
    set c $::GidPriv(DoVolumeRenderWithScaleCanvas)
    $c delete all

    set xmargin 8
    set ymargin 4
    set canvasWidth 300
    # set canvasWidth [ winfo width [ winfo toplevel $c] ]
    # WV canvasWidth
    set canvasHeight 100
    set xmax [ expr $canvasWidth - 2 * $xmargin]
    set ymax [ expr $canvasHeight - 2 * $ymargin]
    
    set curveType [ GiD_Set VolumeRendering(AlphaCurveType) ]
    # Atan = atan, Step = step
    set threshold [ GiD_Set VolumeRendering(Threshold)]
    # invert alpha value
    set invert [ GiD_Set VolumeRendering(InvertAlphaScale)]
    
    set lst_pnts [ list]
    for { set x 0.0} { $x < 1.0} { set x [ expr $x + 0.01]} {
        set y 0.0
        set line_options ""
        if { $curveType == "Atan"} {
            # atan
            set y [ DoVolumeRenderGetAtanValue $x $threshold]
            set line_options "-smooth bezier"
        } elseif { $curveType == "Step"} {
            # step
            set y [ expr ( $x < $threshold) ? 0.0 : 1.0]
            set line_options ""
        } elseif { $curveType == "Linear"} {
            # linear
            set y [ DoVolumeRenderGetLinearValue $x $threshold]
            set line_options ""
        }
        # invert if needed
        if { $invert} {
            set y [ expr 1.0 - $y]
        }
        # scale to canvas size:
        set xc [ expr int( 0.5 + $x * $xmax) + $xmargin]
        # y's coords are from top to bottom:
        set yc [ expr int( 0.5 + ( 1.0 - $y) * $ymax) + $ymargin]
        lappend lst_pnts $xc $yc
    }
    $c create line {*}$lst_pnts {*}$line_options
}

proc DoVolumeRenderWithScale { w basecommand args} {
    # set basecommand [ lrange $basecommand 1 end]
    set resName [ lindex $args 0]
    set compName [ lindex $args 1]

    if { $compName != ""} {
        {*}$basecommand $resName $compName escape escape escape escape
    } else {
        {*}$basecommand $resName escape escape escape escape
    }

    set suggestedThreshold [ GiD_Set VolumeRendering(Threshold)]

    # WarnWinText $suggestedFactor
    # set w .gid
    set x [ winfo x $w]
    set y [ winfo y $w]
    set wi [ winfo width $w]
    set w [ winfo parent $w]
    set xo $x
    set yo $y
    while { $w != "" } {
        set xp [ winfo x $w]
        set yp [ winfo y $w]
        set x [ expr $x + $xp]
        set y [ expr $y + $yp + 16]
        if { "[ winfo class $w]" == "Toplevel"} {
            break
        }
        set w [ winfo parent $w]
    }
    if { $::tcl_platform(os) != "Linux" } {
        set x [expr $x + $wi + 16]
        set y [expr $y]
    } else {
        set x [ expr $xo + 16]
        set y [ expr $yo]
    }

    #WarnWin "$w = +$x+$y"

    if { [ winfo exists .wPostVolRenderScale]} {
        destroy .wPostVolRenderScale
    }
    toplevel .wPostVolRenderScale
    wm geometry .wPostVolRenderScale +$x+$y
    wm title .wPostVolRenderScale [_ "Threshold value"]
    wm minsize .wPostVolRenderScale 1 1
    wm overrideredirect .wPostVolRenderScale 1

    ttk::frame .wPostVolRenderScale.f -style ridge.TFrame -borderwidth 2

    set ::PostVolRenderScaleAfterId ""

    set from_val 0.0
    set to_val 1.0
    set resol_val 0.05
    gidscale .wPostVolRenderScale.f.thresholdScale -orient horizontal \
        -from $from_val -to $to_val -resolution $resol_val \
        -showbuttons 1 -symbolbuttons "< >" \
        -command DoVolumeRenderUpdateThreshold
        
    .wPostVolRenderScale.f.thresholdScale set $suggestedThreshold
    
    ttk::button .wPostVolRenderScale.f.b1 -image [gid_themes::GetImage close.png] \
        -command [list destroy .wPostVolRenderScale]

    ttk::frame .wPostVolRenderScale.f_opt -style ridge.TFrame -borderwidth 2
    set ::PostVolRenderScaleInvertAlpha [ GiD_Set VolumeRendering(InvertAlphaScale)]
    ttk::checkbutton .wPostVolRenderScale.f_opt.cb_inv -text [_ "Invert alpha"] \
        -variable ::PostVolRenderScaleInvertAlpha -command DoVolumeRenderUpdateInvertAlpha
    ttk::label .wPostVolRenderScale.f_opt.l1 -text [_ "Alpha range:"]
    set ::PostVolRenderScaleMinimumAlpha [ GiD_Set VolumeRendering(MinimumAlpha)]
    set ::PostVolRenderScaleMaximumAlpha [ GiD_Set VolumeRendering(MaximumAlpha)]
    entry .wPostVolRenderScale.f_opt.e1 -width 4 \
        -textvariable ::PostVolRenderScaleMinimumAlpha
    bind .wPostVolRenderScale.f_opt.e1 <Return> DoVolumeRenderUpdateMinimumAlpha
    entry .wPostVolRenderScale.f_opt.e2 -width 4 \
        -textvariable ::PostVolRenderScaleMaximumAlpha
    bind .wPostVolRenderScale.f_opt.e2 <Return> DoVolumeRenderUpdateMaximumAlpha

    ttk::frame .wPostVolRenderScale.f_opt2 -style ridge.TFrame -borderwidth 2
    ttk::label .wPostVolRenderScale.f_opt2.l1 -text [_ "Alpha curve type:"]
    set ::PostVolRenderScaleAlphaCurve [ GiD_Set VolumeRendering(AlphaCurveType)]
    ttk::radiobutton .wPostVolRenderScale.f_opt2.rd1 -text [_ "Arc tangent"] \
        -variable ::PostVolRenderScaleAlphaCurve -value "Atan" -command DoVolumeRenderUpdateAlphaCurve
    ttk::radiobutton .wPostVolRenderScale.f_opt2.rd2 -text [_ "Step"] \
        -variable ::PostVolRenderScaleAlphaCurve -value "Step" -command DoVolumeRenderUpdateAlphaCurve
    ttk::radiobutton .wPostVolRenderScale.f_opt2.rd3 -text [_ "Linear"] \
        -variable ::PostVolRenderScaleAlphaCurve -value "Linear" -command DoVolumeRenderUpdateAlphaCurve

    canvas .wPostVolRenderScale.cVRcanvas -height 100
    set ::GidPriv(DoVolumeRenderWithScaleCanvas) .wPostVolRenderScale.cVRcanvas

    # bind .wPostVolRenderScale <Return> "destroy .wPostVolRenderScale"
    bind .wPostVolRenderScale <Escape> "destroy .wPostVolRenderScale"
    bind .wPostVolRenderScale <1> "+PostCloseFLoatingWindow %W %x %y"

    grid .wPostVolRenderScale.cVRcanvas -sticky news

    grid .wPostVolRenderScale.f.thresholdScale -padx 2 -pady 1 -sticky news
    grid .wPostVolRenderScale.f.b1 -column 1 -row 0 -padx 1 -pady 1
    grid rowconfigure .wPostVolRenderScale.f 0 -weight 1
    grid columnconfigure .wPostVolRenderScale.f 0 -weight 1
    grid .wPostVolRenderScale.f -sticky news

    grid .wPostVolRenderScale.f_opt.cb_inv .wPostVolRenderScale.f_opt.l1 \
        .wPostVolRenderScale.f_opt.e1 .wPostVolRenderScale.f_opt.e2 -padx 1 -pady 1 -sticky e
    grid configure .wPostVolRenderScale.f_opt.cb_inv -sticky w
    grid .wPostVolRenderScale.f_opt -sticky news
    # grid configure .wPostVolRenderScale.f_opt
    grid rowconfigure .wPostVolRenderScale.f_opt 0 -weight 1
    grid columnconfigure .wPostVolRenderScale.f_opt 0 -weight 1

    grid .wPostVolRenderScale.f_opt2.l1 \
        .wPostVolRenderScale.f_opt2.rd1 .wPostVolRenderScale.f_opt2.rd2 .wPostVolRenderScale.f_opt2.rd3 \
        -padx 1 -pady 1 -sticky w
    grid .wPostVolRenderScale.f_opt2 -sticky news
    # grid configure .wPostVolRenderScale.f_opt2
    grid rowconfigure .wPostVolRenderScale.f_opt2 0 -weight 1
    grid columnconfigure .wPostVolRenderScale.f_opt2 0 -weight 1

    grid rowconfigure .wPostVolRenderScale 0 -weight 1
    grid rowconfigure .wPostVolRenderScale 1 -weight 1
    grid columnconfigure .wPostVolRenderScale 0 -weight 1

    focus -force .wPostVolRenderScale.f.thresholdScale
    update
    # make slider a bit bigger
    set reqh [ winfo reqheight .wPostVolRenderScale]
    wm geometry .wPostVolRenderScale 300x$reqh
    grab .wPostVolRenderScale

    DoVolumeRenderUpdateCanvas
}

proc AddResultsToMenu { w basecommand que_res { sub 0}} {
    global ViewMenuPriv GidPriv RMenuRPriv
    rmenuinit
    set UnderLineList {}
    set all_anal [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    if { $all_anal == ""} {
        set msg [_ "Please load a MODEL first"]
    } else {
        set msg [_ "Please select a STEP first"]
    }
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    if { $cur_analysis == ""} {
        $w delete 0 end
        $w add command -label $msg -state disabled
        return
    }

    set cur_step [GiD_Info postprocess get cur_step $cur_analysis]
    if { $cur_step == ""} {
        $w add command -label [_ "Please select a STEP first"] -state disabled
        $w delete 0 end
        return
    }

    set all_res {}
    set all_smooth_res {}
    if { $que_res == "Deformation" } {
        # set all_res [lsort -dictionary [GiD_Info postprocess get show_geom_all_deform $cur_analysis $cur_step]]
        # main_geom_all_deform returns vectors and complex vectors
        # show_geom_all_deform returns only vectors
        set all_res [lsort -dictionary [GiD_Info postprocess get main_geom_all_deform $cur_analysis $cur_step]]
    } else {
        # at the moment only Smooth Contour Fill and Smooth Contour Lines
        set add_smooth 0
        if { $que_res == "Contour_Fill" || $que_res == "Contour_Lines" || $que_res == "Iso_Surfaces" ||
         $que_res == "Result_Surface" || $que_res == "Line_Thickness"} {
            set add_smooth 1
        }
        if { $add_smooth && ( [ string first Smooth_ $que_res] != 0)} {
            # $que_res does not begin with "Smooth_XXX"
            set all_smooth_res [lsort -dictionary [GiD_Info postprocess get cur_results_list Smooth_$que_res]]
        }
        set all_res [lsort -dictionary [GiD_Info postprocess get cur_results_list $que_res]]
    }
    if { $all_res == "" } {
        $w delete 0 end
        $w add command -label [_ "No useful results found"] -state disabled
        return
    }

    set cur_res_view [ GiD_Info postprocess get cur_results_view]
    if { $que_res == "Deformation" } {
        # to create menus
        if { [ GiD_Info postprocess get main_geom_state] == "Deformed"} {
            set cur_res_view $que_res
        }
    }

    set add_smooth_submenu 0
    if { [ llength $all_smooth_res] > 0} {
        set add_smooth_submenu 1
    }

    # check if menu needs to be rebuild:
    # if variable exists and is != rebuild, then return ( no need to rebuild)
    if { [ info exists ::GiDPostResultsMenu(Menu,$que_res,$w)] && ( [ string equal $::GiDPostResultsMenu(Menu,$que_res,$w) "rebuild"] == 0)} {
        return
    }
    set UnderLineList {}
    if { $que_res == "Deformation" } {
        set cur_res [ GiD_Info postprocess get main_geom_cur_deform]
        set cur_comp ""
        if { [ string first bitmaps $w] != -1} {
            # from icons bar do interactive deformation
            set basecommand "DoDeformationWithScale $w [ list $basecommand]"
        }
    } elseif { $que_res == "Iso_Surfaces"} {
        set cur_res [ GiD_Info postprocess get main_geom_cur_deform]
        set cur_comp [ GiD_Info postprocess get cur_component]
        if { [ string first bitmaps $w] != -1} {
            # from icons bar do interactive deformation
            set basecommand "DoIsosurfaceWithScale $w [ list $basecommand]"
        }
    } elseif { $que_res == "Volume_Render"} {
        set cur_res [ GiD_Info postprocess get cur_result]
        set cur_comp [ GiD_Info postprocess get cur_component]
        if { [ string first bitmaps $w] != -1} {
            # from icons bar do interactive deformation
            set basecommand "DoVolumeRenderWithScale $w [ list $basecommand]"
        }
    } else {
        set cur_res [ GiD_Info postprocess get cur_result]
        set cur_comp [ GiD_Info postprocess get cur_component]
    }

    set entrada_window 0
    set names_level_0_list [list]
    foreach i $all_res {        
         lappend names_level_0_list [lindex [GidUtils::Split $i //] 0]
    }
    set names_level_0_list [lsort -unique $names_level_0_list]
    set num_items_level_0 [llength $names_level_0_list]    
    if { $num_items_level_0 > $RMenuRPriv(MaxNumCol)} {       
        set all_res [ lrange $all_res 0 [ expr $RMenuRPriv(MaxNumCol) - 2]]
        set entrada_window 1
    }
    if { [ info exists entrara_ya_anyadida]} {
        unset entrara_ya_anyadida
    }    
    $w delete 0 end
    if { $que_res == "Node_Trace"} {
        # add followNodes entry
        set txt "Follow nodes"
        set under [ FindUnderChar txt UnderLineList]
        $w add command -label $txt -underline $under -command [list {*}$basecommand followNodes]
    }
    foreach i $all_res {        
        set img ""
        if { ( $cur_res != $i) || ( $cur_res_view != $que_res) } {
            set img $GidPriv(VerifNoImage)
        } else {
            set img $GidPriv(VerifImage)
        }
        set txt [TranslateResultName $i]    
        set name_split [GidUtils::Split $i //]
        if { [llength $name_split] > 1 } {                
            set txt [TranslateResultComponentName [lindex $name_split end]]
        }
        if { $que_res == "Deformation" } {
            #dark trick to no how a submenu with 1 item and also do not change the syntax of process commands for back compatibility            
            set wm $w
        } else {
            set wm [GetMenuCreatingCascadeMenuFromResultName $w $i $img]
        }      
        if { $wm == ""} {       
            #e.g. empty because GetMenuCreatingCascadeMenuFromResultName has reached the maximum of menu levels
            set name_split [GidUtils::Split $i //]
            if { [llength $name_split] >= 1 } {
                set path_tmp [lindex $name_split 0]
                if { ![ info exists entrara_ya_anyadida($path_tmp)]} {                    
                    set trad [_ "More"]...
                    $wm add command -label "${path_tmp}/... $trad" -command "PostGeom::Create; PostResultsSetResultsView [list $que_res]"
                    set entrara_ya_anyadida($path_tmp) 1
                }
                continue
            } else {
                set entrada_window 1
                break
            }
        }        
        set all_comp [GiD_Info postprocess get components_list $que_res $i $cur_analysis $cur_step ]       
        set create_submenu 0
        if { [llength $all_comp] > 1 && $que_res != "Deformation" && $que_res != "Node_Trace" } {
            set create_submenu 1
        }
        # check if althought it's a scalar there are some created components elsewhere
        if { [ llength $all_comp] == 1} {
            set root_res ${i}//
            if { [string first $root_res $all_res] != -1} {
                # may be of the form t//something           
                set create_submenu 1
                set txt [TranslateResultName $txt]
            }
        }
        if { $create_submenu } {            
            # add menu of components
            set menu_name [GetValidMenuNameFromName $i]
            set under [FindUnderChar txt UnderLineList]
            $wm add cascade -label $txt -underline $under -menu $wm.m$menu_name -image $img -compound left            
            if { [winfo exists $wm.m$menu_name] } {
                $wm.m$menu_name delete 0 end
            } else {
                menu $wm.m$menu_name
            }
            set UnderLineList2 {}
            foreach j $all_comp {
                set txt_comp [TranslateResultComponentName $j]
                set under [FindUnderChar txt_comp UnderLineList2]
                set img ""
                if { $cur_res != $i || $cur_res_view != $que_res || $cur_comp != $j } {
                    set img $GidPriv(VerifNoImage)
                } else {
                    set img $GidPriv(VerifImage)
                }
                # $wm.m$menu_name add command -label $txt_comp -underline $under -command [list {*}$basecommand $i $j] -image $img -compound left
                set wmc [GetMenuCreatingCascadeMenuFromResultName $wm.m$menu_name $j $img]
                if { $wmc != ""} {
                    set name_split [GidUtils::Split $j //]
                    if { [llength $name_split] > 1 } {
                        set txt_comp [TranslateResultComponentName [lindex $name_split end]]
                    }                
                    $wmc add command -label $txt_comp -underline $under -command [list {*}$basecommand $i $j] -image $img -compound left  
                }
            }            
        } else {
            # add the command
            set img ""
            if { ( $cur_res != $i) || ( $cur_res_view != $que_res) } {
                set img $GidPriv(VerifNoImage)
            } else {
                set img $GidPriv(VerifImage)
            }
            set under [FindUnderChar txt UnderLineList]
            if { $que_res == "Display_Vectors" } {
                #dark trick to no how a submenu with 1 item and also do not change the syntax of process commands for back compatibility
                #if |$i| is missing will ask for the desired component
                set j [lindex $all_comp 0]
                set txt_comp [TranslateResultComponentName $j]
                $wm add command -label $txt_comp -underline $under -command [list {*}$basecommand $i $j] -image $img -compound left
            } else {
                $wm add command -label $txt -underline $under -command [list {*}$basecommand $i] -image $img -compound left
            }
        }
    }
    if { $add_smooth_submenu} {
        if { $que_res != "Iso_Surfaces"} {
            regsub -all {_} $que_res {} subst_cmd
            set smooth_cmd Smooth$subst_cmd
        } else {
            # iso_surface commands are of the style: IsoSurfaces Exact/Automatic/AutomaticWidth 
            # which should be changed to: IsoSurfaces SmoothExact/SmoothAutomatic/SmoothAutomaticWidth 
            if { [ string first "Automatic" $basecommand ] != -1} {
                # this will also include AutomaticWidth
                set subst_cmd Automatic
                set smooth_cmd SmoothAutomatic
            } elseif { [ string first "Exact" $basecommand ] != -1} {
                set subst_cmd Exact
                set smooth_cmd SmoothExact
            } 
        }
        if { [ regsub $subst_cmd $basecommand $smooth_cmd smoothbasecommand]} {
            set menu_name "__smoothed_results"
            if { [ winfo exists $w.m$menu_name ]} {
                $w.m$menu_name delete 0 end
            } else {
                menu $w.m$menu_name
            }
            set txt [_ "Smoothed#C#MenuEntryForSmoothedGaussPointsResults"]
            set under [FindUnderChar txt UnderLineList]            
            if { ( $cur_res_view != "Smooth_$que_res") } {
                set img $GidPriv(VerifNoImage)
            } else {
                set img $GidPriv(VerifImage)
            }
            $w add cascade -label $txt -underline $under -menu $w.m$menu_name -image $img -compound left                       
            AddResultsToMenu $w.m$menu_name $smoothbasecommand Smooth_$que_res $sub
        }
    }
    if { [ info exists entrara_ya_anyadida]} {
        unset entrara_ya_anyadida
    }
    if { $entrada_window} {
        $w add separator
        $w add command -label ...[_ "More"]... -command "PostGeom::Create; PostResultsSetResultsView [list $que_res]"
    }
    set ::GiDPostResultsMenu(Menu,$que_res,$w) done
}

proc DoLineGraph { w basecmd res { comp ""}} {
    if { $comp == ""} {
        set comp [lindex [GiD_Info postprocess get cur_components_list $res] 0]
    }
    set command [list {*}$basecmd $res $comp $::ViewMenuPriv(LineGraphXAxis)]
    {*}$command
}

proc AddGraphsResultsToMenu { w basecommand que_res } {
    global ViewMenuPriv
 
    # register the menus
    # if { [ esMac]} {
    #         registerPostGraphsResultsMenu $w $basecommand $que_res
    #         $w configure -postcommand ""
    # }

    set all_anal [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    # set all_anal [ GiD_Info postprocess get all_analysis]
    if { $all_anal == ""} {
        set msg [_ "Please load a MODEL first"]
    } else {
        set msg [_ "Please select a STEP first"]
    }
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    if { $cur_analysis == "" } {
        $w delete 0 end
        $w add command -label $msg -state disabled
        return
    }

    set cur_step [ GiD_Info postprocess get cur_step $cur_analysis]
    if { $cur_step == ""} {
        $w delete 0 end
        $w add command -label [_ "Please select a STEP first"] -state disabled
        return
    }

    set all_res [ lsort -dictionary [ GiD_Info postprocess get cur_results_list $que_res]]
    if { $all_res == ""} {
        $w delete 0 end
        $w add command -label [_ "No useful results found"] -state disabled
        return
    }
    
    if { $que_res == "Integrate_Vector_Normal" || $que_res == "Integrate_Vector_Tangential" } {
        set also_components 0
    } else {
        set also_components 1
    }

    ## check if current menu continue valid
    # if { ![esMac]}  # mac only called when rebuilding menus
    if { 1} { # en mac solo nos llaman cuando hay que rehacer los menus
        if { ( $cur_analysis != "") && ( $cur_step != "") && ( $all_res != "") } {
            if { [ info exists ViewMenuPriv($w,$que_res//analstep)] && \
                     [ info exists ViewMenuPriv($w,$que_res//allres)] } {
                if { ![ string compare $ViewMenuPriv($w,$que_res//analstep) "$cur_analysis $cur_step" ] || \
                         ![ string compare $ViewMenuPriv($w,$que_res//allres) $all_res] } {
                    # see components
                    set igual 1
                    foreach i $all_res {
                        if { $also_components } {
                            set all_comp [ GiD_Info postprocess get cur_components_list $i ]
                        } else {
                            set all_comp ""
                        }
                        regsub -all { } $i {_} idx
                        if { [ info exists ViewMenuPriv($w,$que_res//$idx)] } {
                            if { [ string compare $ViewMenuPriv($w,$que_res//$idx) $all_comp]} {
                                # are different
                                set igual 0
                                break
                            }
                        } else {
                            # are different
                            set igual 0
                            break
                        }
                    }
                    if { $igual} {
                        return
                    }
                }
            }
        }
    }
   
    # to avoid some buildings
    set ViewMenuPriv($w,$que_res//analstep) "$cur_analysis $cur_step"
    set ViewMenuPriv($w,$que_res//allres) $all_res
    foreach i $all_res {
        if { $also_components } {
            set all_comp [ GiD_Info postprocess get cur_components_list $i ]
        } else {
            set all_comp ""
        }
        regsub -all { } $i {_} idx
        set ViewMenuPriv($w,$que_res//$idx) $all_comp
    }

    $w delete 0 end

    if { $que_res == "Line_Graph"} {
        set axis X
        # build X axis menu
        if { [ winfo exists $w.m$axis ]} {
            $w.m$axis delete 0 end
        } else {
            menu $w.m$axis
        }
        set cmds {X_Variation Y_Variation Z_Variation LineVariation LineProjection}
        set labels [ list [_ "X Variation"] [_ "Y Variation"] [_ "Z Variation"] [_ "Line Variation"] [_ "Line Projection"]]
        set values [ list "X_Variation" "Y_Variation" "Z_Variation" "LineVariation" "LineProjection"]
        set UnderLineList {}
        if { ![ info exists ::ViewMenuPriv(LineGraphXAxis) ]} {
            set ::ViewMenuPriv(LineGraphXAxis) "LineVariation"
        }
        foreach i $cmds l $labels v $values {
            set under [FindUnderChar l UnderLineList]
            $w.m$axis add checkbutton -label $l -underline $under \
                -onvalue $v -variable ::ViewMenuPriv(LineGraphXAxis)
        }
        $w add cascade -label [_ "Set X axis"] -menu $w.m$axis
    }

    set entrada_window 0
    if { $all_res != ""} {
        foreach i $all_res {
            if { $also_components } {
                if { $que_res != "Point_Complex_Evolution"} {
                    set all_comp [ GiD_Info postprocess get cur_components_list $i ]
                } else {
                    set all_comp [ GiD_Info postprocess get cur_complex_components_list $i ]
                }
            } else {
                set all_comp ""
            }
            
            set wm [GetMenuCreatingCascadeMenuFromResultName $w $i ""]
            if { $wm == ""} {
                set entrada_window 1
                break
            }

            set txt $i
            if { $wm != $w} {
                set name_split [GidUtils::Split $i //]
                if { [llength $name_split] > 1 } {                
                    set txt [TranslateResultComponentName [lindex $name_split end]]
                }                
            }
            set txt_res [TranslateResultName $txt]

            set create_submenu 0
            if { [ llength $all_comp] > 1 } {
                set create_submenu 1
            }
            
            # check if althought it's a scalar there are some created components elsewhere
            if { [ llength $all_comp] == 1} {
                set root_res ${i}//
                # all_comp is a list of component names, i.e. {{Only component}}
                # so get rid of the first level
                set all_comp [ lindex $all_comp 0]
                if { [ string first $root_res $all_res] != -1} {
                    # may be of the form t//something
                    # if { [ lsearch $all_res $root_res] != -1} 
                    set create_submenu 1
                    set txt_res [TranslateResultName $txt]
                }
               # WarnWinText "looking for '$root_res' in '$all_res' = [ string first $root_res $all_res]"
            }

            if { $create_submenu } {
                # add component's menu
                set menu_name [GetValidMenuNameFromName $i]
                $wm add cascade -label $txt_res -menu $wm.m$menu_name
                if { [ winfo exists $wm.m$menu_name ]} {
                    $wm.m$menu_name delete 0 end
                } else {
                    menu $wm.m$menu_name
                }
                foreach j $all_comp {
                    set txt_comp [TranslateResultName $j]                   
                    set do_graph_cmd [list {*}$basecommand $i $j]                    
                    if { $que_res == "Line_Graph"} {
                        # set do_graph_cmd [list DoLineGraph $w {*}$basecommand $i $j]
                        set do_graph_cmd [list DoLineGraph $w $basecommand $i $j]
                    }
                    
                    # $wm.m$menu_name add command -label $txt_comp -command $do_graph_cmd
                
                    set wmc [GetMenuCreatingCascadeMenuFromResultName $wm.m$menu_name $j ""]
                    if { $wmc != ""} {
                        set name_split [GidUtils::Split $j //]
                        if { [llength $name_split] > 1 } {                
                            set txt_comp [TranslateResultComponentName [lindex $name_split end]]
                        }
                        $wmc add command -label $txt_comp -command $do_graph_cmd
                    }
                }
            } else {
                # add the command
                set do_graph_cmd [list {*}$basecommand $i]
                if { $que_res == "Line_Graph"} {
                    # set do_graph_cmd [list DoLineGraph $w {*}$basecommand $i]
                    set do_graph_cmd [list DoLineGraph $w $basecommand $i]
                }
                $wm add command -label $txt_res -command $do_graph_cmd
            }
        }
    }

    if { $entrada_window} {
        $w add separator
        $w add command -label ...[_ "More"]... -command PostGraphs::Create
    }

    if { $que_res == "Point_Evolution"} {
        # Add the point complex evolution if there are complex results
        set new_que_res Point_Complex_Evolution
        set all_complex_res [ lsort -dictionary [ GiD_Info postprocess get cur_results_list $new_que_res]]
        if { $all_complex_res != ""} {
            $w add cascade -label [_ "Point complex evolution#C#menu"] \
                -menu $w.m_pce_menu \
                -image [ GetImage PostBarGraphPointComplexEvolution.png] -compound left
            if { ![ winfo exists $w.m_pce_menu]} {
                menu $w.m_pce_menu
            }
            AddGraphsResultsToMenu $w.m_pce_menu {GiD_Process Mescape Results Graphs PointComplexEvolution} $new_que_res
        }
    }

}

proc AddIntegrateResultsGraphOptions { w which_step} {
    $w delete 0 end

    if { ![info exists ::GidPriv(PostSpaceDimension)] } {
        set ::GidPriv(PostSpaceDimension) "3D"
        #used for example if 2D do to integrals on lines in  the XY space 
        #e.g for triangle meshes with z but results XY only like IBER, to do
        #  -integral along cutting line 
        #  -streamlines in z=0 (else the streamline go outside the triangle/quads 3D domain)
    }

    set r_menu $w.mScalarResult
    $w add cascade -label [_ "Scalar result"] -menu $r_menu
    if { ![ winfo exists $r_menu]} {
        menu $r_menu
    }
    AddGraphsResultsToMenu $r_menu \
        [ list GiD_Process Mescape Results Graphs Integrate $::GidPriv(PostSpaceDimension) $which_step ScalarResult] Integrate_Scalar
    set r_menu $w.mVectorResult
    $w add cascade -label [_ "Vector result (normal)"] -menu $r_menu
    if { ![ winfo exists $r_menu]} {
        menu $r_menu
    }
    AddGraphsResultsToMenu $r_menu [ list GiD_Process Mescape Results Graphs Integrate $::GidPriv(PostSpaceDimension) $which_step NormalIntegration VectorResult] \
        Integrate_Vector_Normal
    
    set r_menu $w.mVectorResult2
    $w add cascade -label [_ "Vector result (tangential)"] -menu $r_menu
    if { ![ winfo exists $r_menu]} {
        menu $r_menu
    }
    AddGraphsResultsToMenu $r_menu [ list GiD_Process Mescape Results Graphs Integrate $::GidPriv(PostSpaceDimension) $which_step TangentialIntegration VectorResult] \
        Integrate_Vector_Tangential
    
}

proc AddIntegrateGraphOptions { w} {
    $w delete 0 end

    set r_menu $w.mThisStep
    $w add cascade -label [_ "This step"] -menu $r_menu
    if { ![ winfo exists $r_menu]} {
        menu $r_menu
    }
    AddIntegrateResultsGraphOptions $r_menu ThisStep

    set r_menu $w.mAllSteps
    $w add cascade -label [_ "All steps"] -menu $r_menu
    if { ![ winfo exists $r_menu]} {
        menu $r_menu
    }
    AddIntegrateResultsGraphOptions $r_menu AllSteps
}

proc PointEvolutionSetAxisTo { que_axis res res_comp} {
    global ViewMenuPriv

    if { [ info exists ViewMenuPriv(point_evolution_ax$que_axis)]} {
        set old_res [ lindex $ViewMenuPriv(point_evolution_ax$que_axis) 0]
        set old_res_comp [ lindex $ViewMenuPriv(point_evolution_ax$que_axis) 1]                
        set ViewMenuPriv(point_evolution_ax$que_axis//$old_res//$old_res_comp) 0
    }
    set ViewMenuPriv(point_evolution_ax$que_axis) [list $res $res_comp]
    set ViewMenuPriv(point_evolution_ax$que_axis//$res//$res_comp) 1

}

proc PointEvolutionDoIt { basecommand } {
    global ViewMenuPriv

    if { ![ info exists ViewMenuPriv(point_evolution_axX)]} {
        WarnWin [_ "Please set X axis first"]
        return
    }
    if { ![ info exists ViewMenuPriv(point_evolution_axY)]} {
        WarnWin [_ "Please set Y axis first"]
        return
    }


    set comm [list {*}$basecommand {*}$ViewMenuPriv(point_evolution_axX) {*}$ViewMenuPriv(point_evolution_axY)]
    if { $::ViewMenuPriv(pointgraphallsteps) } {
        lappend comm AllSteps
    }
    {*}$comm
}

proc BorderGraphSetAxisTo { w que_axis res { res_comp ""}} {
    global ViewMenuPriv

    if { [ info exists ViewMenuPriv(border_graph_ax$que_axis)]} {
        set old_res [ lindex $ViewMenuPriv(border_graph_ax$que_axis) 0]
        set old_res_comp [ lindex $ViewMenuPriv(border_graph_ax$que_axis) 1]
        set ViewMenuPriv(border_graph_ax$que_axis//$old_res//$old_res_comp) 0
    }
    if { $que_axis == "Y"} {
        set ViewMenuPriv(border_graph_ax$que_axis) [ list $res $res_comp]
        set ViewMenuPriv(border_graph_ax$que_axis//$res//$res_comp) 1
    }
    if { $que_axis == "X"} {
        set ViewMenuPriv(border_graph_ax$que_axis) "$res"
        foreach i "X_Variation Y_Variation Z_Variation LineVariation" {
            set ViewMenuPriv(border_graph_ax$que_axis//$i) 0
        }
        set ViewMenuPriv(border_graph_ax$que_axis//$res) 1
    }

    set opt [ list X_Variation Y_Variation Z_Variation LineVariation]
    if { "$res_comp" == ""} {
        foreach o $opt {
            set ::ViewMenuPriv(border_graph_ax$que_axis//$o) 0
        }
        set ::ViewMenuPriv(border_graph_ax$que_axis//$res) 1
    } else {
        foreach o $opt {
            set ::ViewMenuPriv(border_graph_ax$que_axis//$o//$res_comp) 0
        }
        set ::ViewMenuPriv(border_graph_ax$que_axis//$res//$res_comp) 1
    }
}

proc BorderGraphDoIt { basecommand} {
    global ViewMenuPriv
    if { ![ info exists ViewMenuPriv(border_graph_axX)]} {
        WarnWin [_ "Please set X axis first"]
        return
    }
    if { ![ info exists ViewMenuPriv(border_graph_axY)]} {
        WarnWin [_ "Please set Y axis first"]
        return
    }
    {*}$basecommand $ViewMenuPriv(border_graph_axX) {*}$ViewMenuPriv(border_graph_axY)
}

proc AddGraphsXYResultsToMenu { w basecommand que_res args} {
    global ViewMenuPriv

    # registramos los menus
    # if { [ esMac]} {
    #         registerPostGraphsXYResultsMenu $w $basecommand $que_res
    #         $w configure -postcommand ""
    # }

    if { ![info exists ::ViewMenuPriv(pointgraphallsteps)] } {
        set ::ViewMenuPriv(pointgraphallsteps) 1
    }
    set all_anal [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    # set all_anal [ GiD_Info postprocess get all_analysis]
    if { $all_anal == ""} {
        set msg [_ "Please load a MODEL first"]
    } else {
        set msg [_ "Please select a STEP first"]
    }
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    if { $cur_analysis == ""} {
        $w delete 0 end
        set UnderLineList {}
        foreach axis "X Y" {
            set text [_ "Set %s axis" $axis]
            set under [FindUnderChar text UnderLineList]
            $w add cascade -label $text -underline $under -menu $w.m$axis
            if { [ winfo exists $w.m$axis ]} {
                $w.m$axis delete 0 end
                $w.m$axis add command -label $msg -state disabled
            } else {
                menu $w.m$axis
                $w.m$axis add command -label $msg -state disabled
            }
        }
        if { $que_res == "Point_Graph"} {
            set text [_ "Select Points"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command ResultsNoStep
            set text [_ "All steps"]
            set under [FindUnderChar text UnderLineList]
            $w add checkbutton -label $text -underline $under -variable ::ViewMenuPriv(pointgraphallsteps) -indicatoron 1
        }
        if { $que_res == "Border_Graph"} {
            set text [_ "Select Border"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command ResultsNoStep
        }
        return
    }
    set cur_step [ GiD_Info postprocess get cur_step $cur_analysis]
    if { $cur_step == ""} {
        $w delete 0 end
        set UnderLineList {}
        foreach axis "X Y" {
            set text [_ "Set %s axis" $axis]
            set under [FindUnderChar text UnderLineList]
            $w add cascade -label $text -underline $under -menu $w.m$axis
            if { [ winfo exists $w.m$axis ]} {
                $w.m$axis delete 0 end
                $w.m$axis add command -label [_ "Please select a STEP first"] -state disabled
            } else {
                menu $w.m$axis
                $w.m$axis add command -label [_ "Please select a STEP first"] -state disabled
            }
        }
        if { $que_res == "Point_Graph"} {
            set text [_ "Select Points"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command ResultsNoStep
            set text [_ "All steps"]
            set under [FindUnderChar text UnderLineList]
            $w add checkbutton -label $text -underline $under -variable ::ViewMenuPriv(pointgraphallsteps) -indicatoron 1
        }
        if { $que_res == "Border_Graph"} {
            set text [_ "Select Border"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command ResultsNoStep
        }
        return
    }
    set all_res [ lsort -dictionary [ GiD_Info postprocess get cur_results_list $que_res]]
    if { $all_res == ""} {
        $w delete 0 end
        set UnderLineList {}
        foreach axis "X Y" {
            set text [_ "Set %s axis" $axis]
            set under [FindUnderChar text UnderLineList]
            $w add cascade -label $text -underline $under -menu $w.m$axis
            if { [ winfo exists $w.m$axis ]} {
                $w.m$axis delete 0 end
            } else {
                menu $w.m$axis
            }
        }
        if { $que_res == "Point_Graph"} {
            set text [_ "Select Points"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command ResultsNoStep
            set text [_ "All steps"]
            set under [FindUnderChar text UnderLineList]
            $w add checkbutton -label $text -underline $under -variable ::ViewMenuPriv(pointgraphallsteps) -indicatoron 1
        }
        if { $que_res == "Border_Graph"} {
            set text [_ "Select Border"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label  $text -underline $under -command ResultsNoStep
        }
        return
    }
    ## miramos si el menu que ya tenemos aun es valido
    # if { ![esMac]} # en mac solo nos llaman cuando hay que rehacer los menus
    if { 1} { # en mac solo nos llaman cuando hay que rehacer los menus
        # para el conyazo de windows, que es mas lento que una tortuga con reuma
        if { ( $cur_analysis != "") && ( $cur_step != "") && ( $all_res != "") } {
            if { [ info exists ViewMenuPriv($w,$que_res//analstep)] && \
                     [ info exists ViewMenuPriv($w,$que_res//allres)] } {
                if { ![ string compare $ViewMenuPriv($w,$que_res//analstep) "$cur_analysis $cur_step" ] || \
                         ![ string compare $ViewMenuPriv($w,$que_res//allres) $all_res] } {
                    # ahora a mirar los componentes
                    set igual 1
                    foreach i $all_res {
                        set all_comp [ GiD_Info postprocess get cur_components_list $i ]
                        regsub -all { } $i {_} idx
                        if { [ info exists ViewMenuPriv($w,$que_res//$idx)] } {
                            if { [ string compare $ViewMenuPriv($w,$que_res//$idx) $all_comp]} {
                                # no son iguales
                                set igual 0
                                break
                            }
                        } else {
                            # no son iguales
                            set igual 0
                            break
                        }
                    }
                    if { $igual} {
                        return
                    }
                }
            }
        }
    }
    # para ahorrarnos construir cosas
    set ViewMenuPriv($w,$que_res//analstep) "$cur_analysis $cur_step"
    set ViewMenuPriv($w,$que_res//allres) $all_res
    foreach i $all_res {
        set all_comp [ GiD_Info postprocess get cur_components_list $i ]
        regsub -all { } $i {_} idx
        set ViewMenuPriv($w,$que_res//$idx) $all_comp
    }
    if { ( [ $w type 0] != "cascade") || ( [ $w type 1] != "cascade") } {
        $w delete 0 end
        set UnderLineList {}
        foreach axis "X Y" {
            set text [_ "Set %s axis" $axis]
            set under [FindUnderChar text UnderLineList]
            $w add cascade -label $text -underline $under -menu $w.m$axis
            if { [ winfo exists $w.m$axis ]} {
                $w.m$axis delete 0 end
            } else {
                menu $w.m$axis
            }
        }
        if { $que_res == "Point_Graph"} {
            set text [_ "Select Points"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under -command ResultsNoStep
            set text [_ "All steps"]
            set under [FindUnderChar text UnderLineList]
            $w add checkbutton -label $text -underline $under -variable ::ViewMenuPriv(pointgraphallsteps) -indicatoron 1
        }
        if { $que_res == "Border_Graph"} {
            set text [_ "Select Border"]
            set under [FindUnderChar text UnderLineList]
            $w add command -label $text -underline $under  -command ResultsNoStep
        }
    }
    set list_axis "X Y"
    if { $que_res == "Border_Graph"} {
        set list_axis "Y"
        set axis X
        # construyamos el menu del axis X
        if { [ winfo exists $w.m$axis ]} {
            $w.m$axis delete 0 end
        }
        set cmds {X_Variation Y_Variation Z_Variation LineVariation}
        set labels [list [_ "X Variation"] [_ "Y Variation"] [_ "Z Variation"] [_ "Line Variation"]]
        set UnderLineList {}
        foreach i $cmds l $labels {
            set under [FindUnderChar l UnderLineList]
            $w.m$axis add checkbutton -label $l -underline $under -command [list BorderGraphSetAxisTo $w $axis $i] \
                -onvalue 1 -variable ::ViewMenuPriv(border_graph_ax$axis//$i)
                        if { ![ info exists ViewMenuPriv(border_graph_ax$axis//$i)]} {
                                set ViewMenuPriv(border_graph_ax$axis//$i) 0
                        }
        }
    }
    set entrada_window 0
    foreach axis $list_axis {
        if { [ winfo exists $w.m$axis ]} {
            $w.m$axis delete 0 end
        }
        foreach i $all_res {
            set all_comp [ GiD_Info postprocess get cur_components_list $i ]
            set wm [GetMenuCreatingCascadeMenuFromResultName $w.m$axis $i ""]
            if { $wm == ""} {
                set entrada_window 1
                break
            }
            set txt $i
            if { $wm != "$w.m$axis" } {
                set name_split [GidUtils::Split $i //]
                if { [llength $name_split] > 1 } {                
                    set txt [TranslateResultComponentName [lindex $name_split end]]
                }
            }
            set txt_res [TranslateResultName $txt]
            set create_submenu 0
            if { [ llength $all_comp] > 1} {
                set create_submenu 1
            }            
            # check if althought it's a scalar there are some created components elsewhere
            if { [ llength $all_comp] == 1} {
                set root_res ${i}//
                # all_comp is a list of component names, i.e. {{Only component}}
                # so get rid of the first level
                set all_comp [ lindex $all_comp 0]
                if { [ string first $root_res $all_res] != -1} {
                    # may be of the form t//something
                    # if { [ lsearch $all_res $root_res] != -1} 
                    set create_submenu 1
                    set txt_res [TranslateResultName $txt]
                }
                # WarnWinText "looking for '$root_res' in '$all_res' = [ lsearch $all_res $root_res]"
            }

            if { $create_submenu } {
                # anyadimos el menu de las componentes
                set menu_name [GetValidMenuNameFromName $i]
                $wm add cascade -label $txt_res -menu $wm.m$menu_name
                if { [ winfo exists $wm.m$menu_name ]} {
                    $wm.m$menu_name delete 0 end
                } else {
                    menu $wm.m$menu_name
                }
                foreach j $all_comp {
                    set txt_comp [TranslateResultComponentName $j]
                    # set wmc $wm.m$menu_name
                    set wmc [GetMenuCreatingCascadeMenuFromResultName $wm.m$menu_name $j ""]
                    if { $wmc != ""} {
                        set name_split [GidUtils::Split $j //]
                        if { [llength $name_split] > 1 } {                
                            set txt_comp [TranslateResultComponentName [lindex $name_split end]]
                        }
                        if { $que_res == "Point_Graph"} {
                            $wmc add checkbutton -label $txt_comp -command [list PointEvolutionSetAxisTo $axis $i $j] \
                                -onvalue 1 -offvalue 0 -variable ::ViewMenuPriv(point_evolution_ax$axis//$i//$j)
                            if { ![ info exists ViewMenuPriv(point_evolution_ax$axis//$i//$j)]} {
                                set ViewMenuPriv(point_evolution_ax$axis//$i//$j) 0
                            }
                        } elseif { $que_res == "Border_Graph"} {
                            $wmc add checkbutton -label $txt_comp -command [list BorderGraphSetAxisTo $w $axis $i $j] \
                                -onvalue 1 -variable ::ViewMenuPriv(border_graph_ax$axis//$i//$j)
                            if { ![ info exists ViewMenuPriv(border_graph_ax$axis//$i//$j)]} {
                                set ViewMenuPriv(border_graph_ax$axis//$i//$j) 0
                            }
                        }
                    }
                }
            } else {                
                #component name of single component results ( scalar) may be different from result name
                set j $all_comp
                set txt_comp [TranslateResultName $j]   
                
                if { $que_res == "Point_Graph"} {
                    $wm add checkbutton -label $txt_res \
                        -command [list PointEvolutionSetAxisTo $axis $i $j] \
                        -onvalue 1 -offvalue 0 -variable ::ViewMenuPriv(point_evolution_ax$axis//$i//$j)
                            if { ![ info exists ViewMenuPriv(point_evolution_ax$axis//$i//$j)]} {
                                                        set ViewMenuPriv(point_evolution_ax$axis//$i//$j) 0
                                                }
                }
                if { $que_res == "Border_Graph"} {
                    $wm add checkbutton -label $txt_res \
                        -command [list BorderGraphSetAxisTo $w $axis $i $j] \
                        -onvalue 1 -variable ::ViewMenuPriv(border_graph_ax$axis//$i//$j)
                                        if { ![ info exists ViewMenuPriv(border_graph_ax$axis//$i//$j)]} {
                                                set ViewMenuPriv(border_graph_ax$axis//$i//$j) 0
                                        }
                }
            }
        }
    }

    if { $que_res == "Point_Graph"} {
        $w entryconfigure 2 -command [list PointEvolutionDoIt $basecommand]
    }
    if { $que_res == "Border_Graph"} {
        $w entryconfigure 2 -command [list BorderGraphDoIt $basecommand]
    }

    if { $entrada_window} {
        $w add separator
        $w add command -label ...[_ "More"]... -command PostGraphs::Create
    }
}


# Position a dialog box at a reasonable place on the screen.

proc dpos { w } {
    set hh [expr [winfo screenheight .gid]*.55]
    set hh [string range $hh 0 [expr [string first . $hh]-1]]
    wm geometry $w -0+400
}

proc GiveDpos {} {
    return "-0+400"
}


proc ReduceImage { img factor } {
    set img_w [ image width $img]
    set img_h [ image height $img]
    set new_h [ expr int( 0.5 + $factor * $img_h)]
    set new_w [ expr int( 0.5 + $factor * $img_w)]    
    set new_img [GidUtils::ResizeImage $img $new_w $new_h]
    image delete $img        
    return $new_img    
}

proc AddMoreWelcome { moreSize lessSize} {
    global GidPriv
    set base .gid.welcome
 
    wm geometry $base $moreSize
    text $base.text -height 3 -width 1 -yscroll "$base.scrollbar set"

    ttk::scrollbar $base.scrollbar -orient vertical -command [list $base.text yview]

    $base.text insert end [_ "%s internal version: %s ( %s bits)" $GidPriv(ProgName) [ GiD_Info GiDVersion] [ GiD_Info GiDbits]]\n    
    $base.text insert end [_ "Operating system"]:
    foreach i "machine platform os osVersion" {
        $base.text insert end " '$::tcl_platform($i)'"
    }
    $base.text insert end \n
    $base.text insert end "GiD mesh library\n"
    foreach library [GiD_Info library names] {
        $base.text insert end "  $library: [GiD_Info library version $library] (format [GiD_Info library format_version $library])\n"
    }

    catch { $base.text insert end [ GiD_Info internalstate] }

    if { ![ catch { set fcomp [ open [ file join $::GIDDEFAULT scripts Compiled-more]]}] } {
        while { ![ eof $fcomp] } {
            $base.text insert end [ gets $fcomp]
            $base.text insert end \n
        }
        close $fcomp
    }

    grid $base.text -in $base -row 3 -column 1 -sticky nesw -padx 2 -pady 2        
    grid $base.scrollbar -in $base -row 3 -column 2 -sticky nse
    grid rowconfigure $base 3 -weight 1

    proc lessAbout { moreSize lessSize} {
        destroy .gid.welcome.text
        destroy .gid.welcome.scrollbar
        # WarnWin "less: wm geometry .gid.welcome $lessSize"
        wm geometry .gid.welcome $lessSize
        
        .gid.welcome.bottomframe.button_more configure -text [_ "More"] -command [list AddMoreWelcome $moreSize $lessSize]
    }

    $base.bottomframe.button_more configure -text [_ "Less"] -command [list lessAbout $moreSize $lessSize]
}

proc CreateWelcomeWin { { overw .gid } } {
    global GidPriv
    # set factor [GiD_Set Theme(HighResolutionScaleFactor)]
    set factor [ gid_themes::_linux_GetImageScaleFactor ]
    set w .gid.welcome
    toplevel $w
    wm title $w $GidPriv(ProgName)
    #wm attributes $w -alpha 0.8
    set base $w
    set winWidth [expr int($factor*650)]
    set winHeight [expr int($factor*385)]
    set winMoreHeight [ expr ${winHeight} + 150]
    wm minsize $base $winWidth $winHeight
    wm maxsize $base ${winWidth} 10000
    set moreSize ${winWidth}x${winMoreHeight}
    set lessSize ${winWidth}x${winHeight}

    set yTapa [expr int($factor*330)]
    set xTapa 0   

    set yVersionLabel [expr int($factor*94)]
    # set xVersionLabel 494
    # set widthVersionLabel 140
    # set heightVersionLabel 34
    set xVersionLabel [expr int($factor*474)]
    set widthVersionLabel [expr int($factor*160)]
    set heightVersionLabel [expr int($factor*26)]
    set sizeVersionLabel [expr int($factor*12)]
    set wm_offset [expr int($factor*315)]
    
    wm geometry $w +[expr [winfo x $overw]+[winfo width $overw]/2-$wm_offset]+[ expr [winfo y $overw]+[winfo height $overw]/2-$wm_offset]

    set imatge_about [image create photo]
    $imatge_about copy [gid_themes::GetImageCommon $::GidPriv(AboutWindow) 1.0]
    #WARNING: ReduceImage can delete the image, avoid ::GidPrivImagesCommon($filename) pointing it
    unset -nocomplain ::GidPrivImagesCommon($::GidPriv(AboutWindow))

    set base_name [file rootname $::GidPriv(AboutWindow)]
    set extension [file extension $::GidPriv(AboutWindow)]
    set imatge_tapa [image create photo]
    $imatge_tapa copy [gid_themes::GetImageCommon ${base_name}_grey${extension} 1.0]
    #WARNING: ReduceImage can delete the image, avoid ::GidPrivImagesCommon($filename) pointing it
    unset -nocomplain ::GidPrivImagesCommon(${base_name}_grey${extension})

    if { [ winfo screenheight .gid] < 768 } {    
        # reducir la imagen para que tambien quepa la window, por ejemplo
        # en los netbooks, pues su resolucion es 1024x600
        # a 4/5
        set diffMore [ expr $winMoreHeight - $winHeight]
        set diffVersionLabel [ expr $winHeight - $yVersionLabel]
        set factor 0.8
        set winWidth [ expr int( 0.5 + $factor * $winWidth)]
        set winHeight [ expr int( 0.5 + $factor * $winHeight + 10)]
        # set winMoreHeight [ expr $winHeight + $diffMore]
        set winMoreHeight [ expr int( 0.5 + $factor * $winMoreHeight)]
        wm minsize $base $winWidth $winHeight
        set lessSize ${winWidth}x$winHeight
        set moreSize ${winWidth}x$winMoreHeight
        set yTapa [ expr int( 0.5 + $factor * $yTapa)]
        set xTapa [ expr int( 0.5 + $factor * $xTapa)]
        # set yVersionLabel [ expr $winHeight - $diffVersionLabel]
        set yVersionLabel [ expr int( 0.5 + $factor * $yVersionLabel)]
        set xVersionLabel [ expr int( 0.5 + $factor * $xVersionLabel)]        
        set widthVersionLabel [ expr int( 0.5 + $factor * $widthVersionLabel)]
        set heightVersionLabel [ expr int( 0.5 + $factor * $heightVersionLabel)]
        set sizeVersionLabel 9

        # WarnWin "$moreSize - $lessSize - $yVersionLabel"
        set imatge_about [ReduceImage $imatge_about $factor]
        set imatge_tapa [ReduceImage $imatge_tapa $factor]
        
    }
    set height_tapa [image height $imatge_tapa]
    
    if { $GidPriv(TextOfVersion) != "" } {
        set GidVersion $GidPriv(TextOfVersion)
    } else {
        set GidVersion [ GiD_Info GiDVersion]
    }

    tk::label $base.label_img -image $imatge_about
    tk::label $base.label_tapa -image $imatge_tapa -borderwidth 0 -background #010101 -anchor sw
    place $base.label_tapa -x $xTapa -y $yTapa -in $base -anchor sw
    ttk::frame $base.bottomframe -style BottomFrame.TFrame
    ttk::button $base.bottomframe.button_ok \
        -text [_ "OK"] -style BottomFrame.TButton  -command [list destroy $w]        
    ttk::button $base.bottomframe.button_more \
        -text [_ "More"] -style BottomFrame.TButton  -command [list AddMoreWelcome $moreSize $lessSize]      

    global credits_about
    set credits_about 0

    ttk::button $base.bottomframe.button_credits \
        -text [_ "Credits"] -style BottomFrame.TButton -command [list start_credits $base 0 $height_tapa]
    
    # Geometry management
    grid $base.label_img -in $base -row 1 -column 1 -columnspan 2
    grid $base.bottomframe -in $base -row 2 -column 1 -sticky news -columnspan 2
    grid $base.bottomframe.button_ok -in $base.bottomframe -row 1 -column 1 -sticky e -padx 8 -pady 8
    grid $base.bottomframe.button_credits -in $base.bottomframe -row 1 -column 2 -padx 8 -pady 8
    grid $base.bottomframe.button_more -in $base.bottomframe -row 1 -column 3 -sticky w -padx 8 -pady 8


    # ponemos el numero de version encima de la imagen
    canvas $base.c -borderwidth 0 -highlightthickness 0 -width $widthVersionLabel -height $heightVersionLabel -background #010101

    place $base.c -x $xVersionLabel -y $yVersionLabel -in $base
    

    # ttk::frame $base.fv -borderwidth 0
    # label $base.fv.label_version -text $GidVersion -font BigFont -foreground #cccccc -background black
    # grid $base.fv.label_version -sticky we

    #set rw [ winfo reqwidth $base.fv.label_version]
    #place $base.label_version -x [ expr [ winfo reqwidth $base.label_img] - $rw - 16] -y 420 -in $base

    # Resize behavior management

    grid rowconfigure $base 1 -weight 0 -minsize 30
    grid rowconfigure $base 2 -weight 0 -minsize 30
    grid rowconfigure $base 3 -weight 1

    grid columnconfigure $base 1 -weight 1
    
    grid columnconfigure $base.bottomframe 1 -weight 1 -minsize 30
    grid columnconfigure $base.bottomframe 2 -weight 1 -minsize 30
    grid columnconfigure $base.bottomframe 3 -weight 1 -minsize 30
    

    bind $base <Return> [list destroy $w]
    bind $base <Escape> [list destroy $w]

    if { $::tcl_platform(os) != "Darwin"} {
        if { [winfo exists $w] } {
            tkwait visibility $w
        }
    } else {
        update
    }

    grab $w

    # a mover las letras
    update idletasks
    if { ![ winfo exists $base.c ]} {
        break
    }
    set txt [_ "Version %s" $GidVersion]
    set len_txt [ string length $txt]
    # set dest_x [ expr [ $base.c cget -width] - 36]
    set dest_x [ expr [ $base.c cget -width] - $heightVersionLabel]
    set dest_x $widthVersionLabel
    set font_face "Helvetica $sizeVersionLabel bold"
    if { $::tcl_platform(os) == "Darwin"} {
        # in Mac OS X it look better without the bold face
        set font_face "Helvetica [ expr $sizeVersionLabel + 2]"
    }

    if { $::tcl_platform(os) == "Darwin"} {
        # 1st just measure text width
        set is 0
        frame $base.fv$is
        label $base.fv$is.l -text $txt \
            -font $font_face  \
            -foreground #010101 -background #010101 -borderwidth 0 -highlightthickness 0
        grid $base.fv$is.l -sticky e -padx 0 -pady 0
        set rw [ winfo reqwidth $base.fv$is.l]
        set dest_x [ expr $dest_x - $rw]
        set ini_x 0
        set c_id [ $base.c create window $ini_x 0 -anchor nw -window $base.fv$is]
        $base.c coords $c_id $dest_x 0
        
        $base.fv$is.l configure -text "" \
            -foreground #9d9d9d -background #010101   

        for { set idx 0} { $idx < $len_txt} { incr idx} {
            set chars2display [ string range $txt [ expr $len_txt - $idx - 1] end]
            $base.fv$is.l configure -text $chars2display
            after 50
            update
            update idletasks
        }
    } else {
        for { set is 0} { $is < $len_txt} { incr is} {
            ttk::frame $base.fv$is
            set chars2display [ string index $txt [ expr $len_txt - $is - 1]]
            label $base.fv$is.l -text $chars2display \
                -font $font_face  \
                -foreground #9d9d9d -background #010101 -borderwidth 0 -highlightthickness 0
            grid $base.fv$is.l -sticky we -padx 0 -pady 0
            
            # set rw [ winfo reqwidth $base.fv$is.l]
            set rw [ font measure $font_face $chars2display]
            set dest_x [ expr $dest_x - $rw]
            set ini_x 0
            set c_id [ $base.c create window $ini_x 0 -anchor nw -window $base.fv$is]
            set dif_x [ expr $dest_x - $ini_x]
            update
            update idletasks
            for { set ix $ini_x} { $ix < $dest_x} { set ix [ expr $ix + 5]} {
                # por si han cerrado la window antes de acabar con las letritas
                if { ![ winfo exists $base.c ]} {
                    break
                }
                $base.c coords $c_id $ix 0
                update
                update idletasks
            }
            # por si han cerrado la window antes de acabar con las letritas
            if { ![ winfo exists $base.c ]} {
                break
            }
            $base.c coords $c_id $dest_x 0
        }
    }

    set tip_base_widget $base.label_img
    if { $::tcl_platform(platform) != "windows" } {
        set tip_base_widget $w
    }
    
    if { [GiD_Set ShowCheckNewVersion] } {
        after 1000 [list ShowCheckNewVersion 1 $tip_base_widget]
    }
    
    # por si han cerrado la window antes de acabar con las letritas
    if { [ winfo exists $w]} {
        tkwait window $w
    }
}

proc start_credits { base i height_tapa } {
    global credits_about
    if { $credits_about == 0} {
        show_credits $base $i $height_tapa
    }
}

proc show_credits {w i height_tapa} {
    #credits
    global credits_about

    set credits_about 1
    if { [winfo exists $w.label_tapa] } {
        $w.label_tapa configure -height [expr {$height_tapa-$i}]
    } else {
        set i 9998
    }
    incr i 2
    if { [expr {$height_tapa-$i}] >= 0 } {after 50 "show_credits $w $i $height_tapa"}
}

proc ChangeWindowTitle { { projectname "" } { problemType ""}} {
    global GidPriv
    if { [GidUtils::IsTkDisabled] } {
        return 1
    }    
    if { ![winfo exists .gid] } {
        return 1
    }
    if { $projectname == "" } {
        set projectname [GiD_Info Project ModelName]
    }
    if { $problemType == "" } {
        set problemType [GiD_Info Project ProblemType]
    }
    if { $problemType == "UNKNOWN" } {
        set problemType ""
    }
    set que64 ""
    if { $::tcl_platform(pointerSize) == 8} {
        set que64 x64
    }
    set only_project_name [ file tail $projectname]
    set compoundName [_ "Project: %s" $only_project_name]
    if { ( $only_project_name != "UNNAMED") && [GidLock::GetReadOnly] } {
        append compoundName " " [_ "(read-only)"]
    }
    if { [ string tolower $::GidPriv(ProgName,Default)] == "gid"} {
        if { $problemType != ""} {
            append compoundName " ($problemType)"
        }
    }
    #set gid_version [ GiD_Info gidversion]
    set gid_version $::GidPriv(ProgVersion)
    set title [join [list "$::GidPriv(ProgName) $que64 $gid_version"  [string repeat " " 24] $compoundName]]
    wm title .gid $title
    # wm iconname .gid [file tail $projectname]
    wm iconname .gid $compoundName
}

#do not delete these procs SaveAsOtherKnownFiles, SaveAsResults, SaveAsGallery ... because are used from C++
proc SaveAsOtherKnownFiles { path_old path_new } {
    set fail 0
    #depending on the order invoking commands the destination folder already not exists and must be created 
    set folder_src $path_old.gid
    set folder_dst $path_new.gid
    if { ![file isdirectory $folder_dst] } {
        file mkdir $folder_dst
    }
    set name_new [file tail $path_new]

    if { 0 } {
        #other files that are not written from the internal save
        #.bgi - background image
        #.spd - specific problemtype data
        #set known_extensions ".bgi .spd" 
        #avoid copy the .spd, else with 'save as' could overwrite the memory file with old file
        #and now the .bgi is saved from GiD without need to do this file copy
        #then this procedure do nothing
        set known_extensions "" ;
        set name_old [file tail $path_old]
        set src_pref [file join $folder_src $name_old]
        set post_list {}
        foreach ext $known_extensions {
            lappend post_list {*}[glob -nocomplain -path $src_pref *$ext]
        }
        foreach src $post_list {
            set file_tail [file tail $src]
            set file_extension [file extension $file_tail]
            set dest [file join $folder_dst $name_new]$file_extension
            set fail [GidUtils::CatchFileCopyForce $src $dest]
            if { $fail } {
                break
            }
        }
    }

    if { !$fail } {
        set temporary_model_folder [file join [GiD_Info project TmpDirectory] "UNNAMED.gid"]
        if { [file exists $temporary_model_folder] && [file isdirectory $temporary_model_folder] } {
            set name_old_length [string length UNNAMED]
            foreach src [glob -nocomplain -directory $temporary_model_folder UNNAMED.*] {
                set file_tail [file tail $src]
                #don't use set file_extension [file extension $file_tail] because these  files use double extension!!
                set file_extension [string range $file_tail $name_old_length end]
                set dest [file join $folder_dst $name_new]$file_extension
                set fail [GidUtils::CatchFileCopyForce $src $dest]
                if { $fail } {
                    break
                }
                file delete -force $src
            }
            if { !$fail } {
                foreach src [glob -nocomplain -directory $temporary_model_folder *] {
                    set file_tail [file tail $src]
                    if { $file_tail != "UNNAMED" } {
                        set dest [file join $folder_dst $file_tail]
                        set fail [GidUtils::CatchFileCopyForce $src $dest]
                        if { $fail } {
                            break
                        }
                        file delete -force $src
                    }
                }
                file delete -force $temporary_model_folder
            }
        }
    }
    return $fail
}

proc SaveAsResults { path_old path_new } {
    set fail 0
    #other posprocess results files that are not written from the internal save
    #.post.res 
    #.post.msh
    #.post.lst
    #.flavia.res
    #.flavia.msh
    set name_old [file tail $path_old]
    append path_old .gid
    set src_pref [file join $path_old $name_old]
    set post_list [gid_filesystem::glob -nocomplain -path $src_pref *.post.*]
    set flavia_list [gid_filesystem::glob -nocomplain -path $src_pref *.flavia.*]
    if { [llength $flavia_list] } {
        set post_list [concat $post_list $flavia_list]
    }
    set name_new [file tail $path_new]
    append path_new .gid
    set name_old_length [string length $name_old]
    foreach src $post_list {
        set file_tail [file tail $src]
        #don't use set file_extension [file extension $file_tail] because these  files use double extension!!
        set file_extension [string range $file_tail $name_old_length end]
        set dest [file join $path_new $name_new]$file_extension
        set fail [GidUtils::CatchFileCopyForce $src $dest]
        if { $fail } {
            break
        }
    }
    return $fail
}

proc SaveAsGallery { path_old path_new } {
    set fail 0
    # copy only files in project_name.gid/gallery/*  i.e. not subdirs of gallery/
    set name_old [file tail $path_old]
    append path_old .gid
    set src_gallery [ file join $path_old [ GidUtils::GetGalleryDirectoryBaseName]]
    if { [ file exists $src_gallery]} {
        set src_pref ${src_gallery}/
        set file_list [ gid_filesystem::glob -nocomplain -path $src_pref -type f *]
        if { [ llength $file_list] > 0 } {
            set name_new [file tail $path_new]
            append path_new .gid
            # create destination gallery folder
            set dst_gallery [ file join $path_new [ GidUtils::GetGalleryDirectoryBaseName]]
            if { ![file exists $dst_gallery] && [ gid_filesystem::file_writable $path_new]} {
                file mkdir $dst_gallery
            }
            set name_old_length [string length $src_gallery]
            foreach src $file_list {
                set file_tail [file tail $src]
                set dest [file join $dst_gallery $file_tail]
                set fail [GidUtils::CatchFileCopyForce $src $dest]
                if { $fail } {
                    break
                }
            }
        }
    }
    return $fail
}

#auxiliary text (notepad-like tool)
proc SaveText { } {
    set fail 0
    if { [info procs TextEditor::SaveFromVariableToFile] != "" } {
        #if proc doesn't exists is because the package texteditor was not loaded, 
        #then we are sure that there is not any value stored in its memory to be saved to file
        TextEditor::SaveFromVariableToFile
    }
    return $fail
}

proc GetPrjThumbnail { gidprj }  {
    set name [file root [file tail $gidprj]]
    return [file join $gidprj $name].png
}

proc GetImagePath { img_path }  {
    return $img_path
}

proc GetPostThumbnail { post_file } {
    return [file root $post_file].png
}

proc GetThumbnailCmd { filetypes } {
    if {[lindex [lindex $filetypes 0] 0] eq "GiD postprocess"} {
        return GetPostThumbnail
    }
    foreach {ft ext} $filetypes {
        if {[lsearch {GIF JPEG PNG TGA TIFF Image} [lindex $ft 0]]!=-1} {
            return GetImagePath
        }
    }
    return ""
}

#category == "project" , "file" or "directory" (other are considered as file, project is for a GiD model)
#             or "postfile" or "imagefile" or "..."
#    ( each different type will have a DefaultDirectory storing the last accessed folder for that type)
#NOTE: if category == "project" then filetypes and defaultextension are set automatically for GiD
#OpenMode == "read" or "write"
#w == parent
#title == "title of window"
#DefaultFile == "Name of file"
#filetypes == list of names and extensions, e.g: {{"Jpeg Image" ".jpg .jpeg"} {"All files" ".*"} }
#defaultextension == extension to automatically ( and always) append to name, e.g: ".jpg, *.gif.jpg (although user wrote .gif!)
#defaultextension == does not select the extension from the filetypes to display
#Multiple == 1 can return multiple filenames , Multiple == 0 only one
#MoreOpts: to add to the window more settings. Must provide a list with "subtitle proc1 ?proc2?"
#  where subtitle: is a "subtitle for this frame"
#  proc1 is a procedure with prototype proc procname { frame }  with frame a parent frame already existint where pack our widgets
#                                      and can return "" or "open" to show or not this frame
#  proc2 is an optional procedure without arguments, that will be invoked to get the selected options
#  e.g. set MoreOpts [list [_ "Import options"] BrowserExtraCreateOptionsImportGeom ProcessImportGeomOptsProcessImportGeomOpts]

proc Browser-ramR { category OpenMode {w .gid}  {title ""} {DefaultFile {}} {filetypes {}} {defaultextension {}} {Multiple 0} {MoreOpts {}} } {
    global DefaultSearchDirectoryP
    global BrowserDirectoryInitialDirectory

    #ignore w input parameter, use .gid to avoid Tcl error using other parents, because it seems that gidtk::dialog::file 
    #store this value in some cache variable (to not rebuild the full dialog) and will fail after when the parent is deleted

    set w .gid 
    if { $title == "" } {
        set title [_ "Browser"]
    }

    set category [ string tolower $category]
    if { $category == "project" } {
        if { ![info exists DefaultSearchDirectoryP] || ![gid_filesystem::file isdirectory $DefaultSearchDirectoryP]} {
            set DefaultSearchDirectoryP [gid_filesystem::pwd]
        }
        set initial_dir $DefaultSearchDirectoryP
        if { $DefaultFile != "" } {
            set _dir_ [file dirname $DefaultFile]
            if { $_dir_ != "." && $_dir_ != "" } {
                set initial_dir $_dir_
            }
        }
    } elseif { $category == "directory" } {
        if { ![info exists ::BrowserDirectoryInitialDirectory] || ![gid_filesystem::file isdirectory $::BrowserDirectoryInitialDirectory]} {
            set BrowserDirectoryInitialDirectory [gid_filesystem::pwd]
        }
        set initial_dir $::BrowserDirectoryInitialDirectory        
        if { $DefaultFile != "" } {
            set _dir_ ""
            if { [file isdirectory $DefaultFile] } {
                set _dir_ $DefaultFile
            } else {
                set _dir_ [file dirname $DefaultFile]
            }
            if { $_dir_ != "." && $_dir_ != "" } {
                set initial_dir $_dir_
            }
        }
    } else {
        # $category == "file"
        if { ![ info exists ::DefaultDirectories($category)] || ![gid_filesystem::file isdirectory $::DefaultDirectories($category)] } {
            # old compatibility, if !exists $category & exist (file) use it
            if { [ info exists ::DefaultDirectories(file)] && [gid_filesystem::file isdirectory $::DefaultDirectories(file)] } {
                set ::DefaultDirectories($category) $::DefaultDirectories(file)
            } else {
                set ::DefaultDirectories($category) [gid_filesystem::pwd]
            }
        }
        set initial_dir $::DefaultDirectories($category)
        if { $DefaultFile != "" } {
            set _dir_ [file dirname $DefaultFile]
            if { $_dir_ != "." && $_dir_ != "" } {
                set initial_dir $_dir_
            }
        }

        if { $category == "imagefile" } {
            # check if $initial_dir is inside another project or is empty
            # use current_project.gid/gallery/ as initial_dir
        }
    }

    # for the Standard Tk file box tk_getOpenFile or tk_getSaveFile
    set std_tk_fb_initial_flags "" ;#-initialfile -initialdir -defaultextension separed from std_tk_fb_opt for special tricks in macOs
    set std_tk_fb_opt ""
    if { $category == "directory" } {
        if { $OpenMode == "read" } {
            lappend std_tk_fb_opt -mustexist 1
        } else {
            lappend std_tk_fb_opt -mustexist 0
        }
    } else {
        # file or project
        if { $OpenMode == "read" } {
            set comm open
        } else {
            set comm save
        }
        lappend comm -title $title -initialdir $initial_dir -parent $w
    }

    
    lappend std_tk_fb_initial_flags -initialdir $initial_dir
    lappend std_tk_fb_opt -title $title -parent $w
    

    if { $category == "directory" } {
        #-multiple not allowed
    } else {
        # file or project
        if { $Multiple } {
            lappend comm          -multiple 1
            lappend std_tk_fb_opt -multiple 1
        }
    }
    

    if { $category == "project" } {
        lappend comm -previewcmd GetPrjThumbnail
        foreach recent_project [GiD_Info RecentProjects] {
            lappend recent_dirs [file dirname $recent_project]
        }
        # REVIEW: remove catch after validate on windows
        if { [ catch { set most_recent_dirs [ ::LeastCommonPath::computeMultiple $recent_dirs 3 ] } ] } {
            #WarnWinText "Unable to compute LCP for input $recent_dirs"
            set most_recent_dirs {}
        }
        lappend comm -recentfolders $most_recent_dirs
        set types [list [list [_ "%s project" $::GidPriv(ProgName)] {.gid}]]
        lappend comm          -filetypes $types -defaultextension .gid -dirprojectext .gid
        lappend std_tk_fb_opt -filetypes $types -defaultextension .gid
    } elseif { $category == "directory" } {
        #no extra options
    } else {
        #filename, not GiD project
        if { $filetypes != "" } {
            lappend comm -filetypes $filetypes -previewcmd [GetThumbnailCmd $filetypes]
            # build a nice looking message
            set idx_ext 0
            set filetypes_msg ""
            set last_ext ""
            foreach ext [ lsort $filetypes] {
                set type_name [ lindex $ext 0]
                if { $type_name == [_ "All files"]} {
                    set last_ext $ext
                    continue
                }
                set nl ""
                if { $idx_ext == 4 } {
                    set nl "\n"
                    set idx_ext 0
                }
                append filetypes_msg "$nl$ext "
                incr idx_ext
            }
            # eventually:
            lappend std_tk_fb_opt -message "Supported file extensions: \n$filetypes_msg" -filetypes $filetypes
        }
        if { $defaultextension != "" } {
            lappend comm -defaultextension $defaultextension
            # ignored on macOS
            lappend std_tk_fb_opt -defaultextension $defaultextension
        }
    }

    
    # Launch File browser

    # macOS check if initial directory is first time protected (desktop, download, documents, ....)
    set use_gid_file_browser 1
    if { $::tcl_platform(os) == "Darwin"} {
        if { $initial_dir != ""} {
            set err [ catch {
                set directories [ gid_filesystem::glob -directory $initial_dir -nocomplain -type d *]
            } err_txt]
            if { $err} {
                # need to use macOS native file browser, check GID-1696 and comments below
                set use_gid_file_browser 0
            }
        }
    }

    if { $use_gid_file_browser} {
        if { $category == "directory" } {         
            set fileName [gidtk::dialog::file::chooseDir:: {*}$std_tk_fb_initial_flags {*}$std_tk_fb_opt]
        } else {
            # file or project
            if { $DefaultFile != "" } {
                set _file_ [file tail $DefaultFile]
                lappend comm -initialfile $_file_
                lappend std_tk_fb_initial_flags -initialfile $_file_
            }
            
            if {$MoreOpts ne ""} {
                lappend comm -moreopt $MoreOpts
            }
            lappend comm -category $category
            set fileName [::gidtk::dialog::file:: {*}$comm]
        }
    } else {
        # just set this filename to enter in next "if" without additional conditions.
        set fileName [list ____TCL_ERROR____ $initial_dir]
    }
    
    # GID-1696 this is a trick to solve the problem that gid issues an tcl error when accessing
    # $HOME/Desktop Downloads Documents RemovableMedia ... on macOS Catalina
    # we return as filename [ list ____TCL_ERROR____ $err_txt]
    # so that afterwards (in tclfileP.tcl proc Browser-ramR) allows us to open ( grant us access to)
    # open a standard Tk dialog into these folders. Onlly once is needed for each folder / removable/network media
    if { $::tcl_platform(os) == "Darwin"} {
        set may_be_error [lindex $fileName 0]
        if { $may_be_error == "____TCL_ERROR____"} {
            # parse the error
            set restricted_folder [ lindex $fileName 1]
            # on macOS -initialdir and -initialfile should be at the begining,
            # otherwise they will not be taken into account
            set idx [lsearch -exact $std_tk_fb_initial_flags -initialdir]
            if { $idx != -1} {
                set std_tk_fb_initial_flags [lreplace $std_tk_fb_initial_flags $idx [ expr $idx + 1]]
            }
            # macOS native dialog boxes does not care about -initialfile
            # but it has precedence over -initialdir
            # i.e. if -initialfile is provided, -initialdir is not used
            # but -defaultextension
            set idx [ lsearch -exact $std_tk_fb_initial_flags -initialfile]
            if { $idx != -1} {
                set initial_file [ lindex $std_tk_fb_initial_flags [ expr $idx + 1]]
                set std_tk_fb_initial_flags [ lreplace $std_tk_fb_initial_flags $idx [ expr $idx + 1]]
                # check if it has -defaultextension, if not, add it
                set idx [ lsearch -exact $std_tk_fb_initial_flags -defaultextension]
                if { $idx == -1} {
                    set ext [ file extension $initial_file]
                    if { $ext != ""} {
                        lappend std_tk_fb_initial_flags -defaultextension $ext
                    }
                }
            }
            lappend std_tk_fb_initial_flags -initialdir $restricted_folder
            # if category == file --> allow entering inside GiD projects
            set packageasdirectory 1
            if { $category == "project" || $category == "directory" } {
                set packageasdirectory 0
            }
            if { $category == "directory" } {
                set fileName [tk_chooseDirectory -packageasdirectory $packageasdirectory \
                        {*}$std_tk_fb_initial_flags {*}$std_tk_fb_opt]

            } else {
                # file or project
                if { $OpenMode == "read" } {
                    set fileName [tk_getOpenFile -packageasdirectory $packageasdirectory \
                            {*}$std_tk_fb_initial_flags {*}$std_tk_fb_opt]
                } else {
                    set fileName [tk_getSaveFile -packageasdirectory $packageasdirectory \
                            {*}$std_tk_fb_initial_flags {*}$std_tk_fb_opt]
                }
            }
        }
    }

    if { $fileName != "" } {
        if { $category == "project" } {
            set DefaultSearchDirectoryP [file dirname $fileName]
        } elseif { $category == "directory" } {
            set ::BrowserDirectoryInitialDirectory $fileName
        } else {
            set file1 $fileName
            if { $Multiple} {
                set file1 [lindex $fileName 0]
            }
            set ::DefaultDirectories($category) [file dirname $file1]
        }
    }
    update
    return $fileName
}

proc TopMenuFrame { {action ""} { w .gid.menu } } {
    global GidPriv
    if { $action == "" } {
        if { ![info exists GidPriv(PrePostTopMenuWindowGeom)] } {
            set action INSIDE
        } else {
            set action [lindex $GidPriv(PrePostTopMenuWindowGeom) 0]
        }
    }

    if { $action == "NONE" } {
        set GidPriv(PrePostTopMenuWindowGeom) [list NONE {} 1 TopMenuFrame]
        if { [winfo exists $w] } {
            destroy $w
        }
        if { [winfo exists .gid.topm] } {
            # TFrame in case of [GiD_Set Theme(MenuType)] == "generic"
            destroy .gid.topm
        }
        .gid configure -menu ""
        return        
    } elseif { $action == "INSIDE" } {
        #atencion, No mover la creacion del frame .gid.topm mas abajo (dentro del siguiente if por ejemplo)
        # sino no va bien algo como esto, no se ven los botones del menu:        
        # TopMenuFrame
        # (al llamar por segunda vez a TopMenuFrame ya se verian los botones)
        if { [GiD_Set Theme(MenuType)] == "generic" } {
            if { ![winfo exists .gid.topm] } {
                #create a frame with the menu buttons
                ttk::frame .gid.topm
                set ::GiDTBLayout(.gid.topm) {}
            }
        }
        
        if { [winfo exists $w] } {
            destroy $w
        }

        ttk::frame $w
        

        set GidPriv(PrePostTopMenuWindowGeom) "INSIDE {} 1 TopMenuFrame"
        
        if { [GiD_Set Theme(MenuType)] == "generic" } {
            #grid the frame with the menu buttons
            if { [grid info .gid.topm] == "" } {
                grid .gid.topm -row 0 -column 0 -columnspan 4 -sticky "snew"
                grid columnconfigure .gid.topm 0 -weight 1
            }
            if { [grid info $w] == "" } {
                GridInside PrePostTopMenuWindowGeom $w .gid.topm "we"
            }
            #remove the windows menu if exist
            if { [[winfo toplevel $w] cget -menu] != "" } {
                [winfo toplevel $w] configure -menu ""
            }
        } else {
            #use "native" menus
            #remove the unix frame with the menu buttons
            if { [winfo exists .gid.topm] } {
                destroy .gid.topm
            }
        }
    } else {
        if { ![info exists GidPriv(PrePostTopMenuWindowGeom)] || [lindex $GidPriv(PrePostTopMenuWindowGeom) 1] == "" } {
            set hh [winfo x .gid]
            set vv [expr [winfo y .gid]+25]
            set GidPriv(PrePostTopMenuWindowGeom) [list OPEN [winfo width .gid]x25+$hh+$vv 1 TopMenuFrame]
        }
        catch {DestroySlave $w}
        InitWindow2 $w -title $GidPriv(ProgName) -geometryvariable PrePostTopMenuWindowGeom \
            -initcommand TopMenuFrame -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        wm transient $w .gid
    }
    GiDMenu::UpdateMenus
    if { [winfo class $w] == "Toplevel" } {
        foreach i [bind .gid] {
            bind $w $i [bind .gid $i]
        }
    }
}

proc UpdateCoordFrameView { show } {
    if { $show } {
        pack forget .gid.comm.fle
        pack forget .gid.comm.fwarn
        pack .gid.comm.fcoord -fill y -side right
        pack .gid.comm.fle -fill x -side bottom -expand yes -pady 2 -padx 2
        pack .gid.comm.fwarn -fill both -side top -expand yes        
    } else {
        pack forget .gid.comm.fcoord        
    }
}

proc UpdateOpenGLIcons { } {
    if { [GidUtils::IsTkDisabled] } {
        return 1
    }
    set w .gid.comm
    if { ![ info exists ::OpenGLIconInfo]} {
        set tmp [ GiD_Info opengl]
        set ::OpenGLIconInfo ""
        foreach {k v} $tmp {
            append ::OpenGLIconInfo "$k: $v\n"
        }
    }
    # Now with the new preferences structure, this function is called when no graphical GUI is present or ready !!!
    if { ![ winfo exists $w.openGLstate1]} {
        return
    }
    if { [GiD_Set SoftwareOpenGL] } {
        $w.openGLstate1 configure -image [ gid_themes::GetImage acc1dis.png small_icons]
        setTooltip $w.openGLstate1 [_ "%sSafe visualization - click to change mode" $::OpenGLIconInfo]        
    } else {
        $w.openGLstate1 configure -image [ gid_themes::GetImage acc1.png small_icons]
        setTooltip $w.openGLstate1 [_ "%sFast visualization - click to change mode" $::OpenGLIconInfo]        
    }
}

proc GetAllViewableToplevels { {w .gid} } {
    if { ( [ winfo toplevel $w ] eq $w) && [ winfo viewable $w ]} {
        set res [ list $w]
    } else {
        set res {}
    }
    foreach ww [winfo children $w] {
        lappend res {*}[ GetAllViewableToplevels $ww]
    }
    return $res
}

proc BringUpAllGiDWindows { } {
    set gid_toplevel .gid
    foreach tl [ GetAllViewableToplevels $gid_toplevel] {
        if { $tl != $gid_toplevel} {
            raise $tl $gid_toplevel
        }
    }
}

proc BottomEntryFrame { {action ""} { w .gid.comm } } {
    global GidPriv

    if { [winfo exists $w.fwarn.list] } {
        set ListboxContents [$w.fwarn.list get 0 end]
    }

    if { $action == "" } {
        if { [winfo exists $w] } { return }
        if { ![info exists GidPriv(PrePostEntryWindowGeom)] } {
            set action INSIDE
        } else {
            set action [lindex $GidPriv(PrePostEntryWindowGeom) 0]
        }
    }

    if { $action == "NONE" } {
        catch {DestroySlave $w}
        set GidPriv(PrePostEntryWindowGeom) [list NONE {} 1 BottomEntryFrame]
        grid remove .gid.bottomc
        return
    } elseif { $action == "INSIDE" } {
        if { [winfo exists $w] } {
            if { [winfo class $w] != "frame" && [winfo class $w] != "Frame" } {
                destroy $w
            } else {
                return
            }
        }
        ttk::frame $w -style ForcedFrame
        set GidPriv(PrePostEntryWindowGeom) [list INSIDE {} 1 BottomEntryFrame]
        GridInside PrePostEntryWindowGeom $w .gid.bottomc "we"
    } else {
        if { ![info exists GidPriv(PrePostEntryWindowGeom)] || [lindex $GidPriv(PrePostEntryWindowGeom) 1] == "" } {
            set hh [winfo x .gid]
            set vv [expr [winfo y .gid]+[winfo height .gid]+25]
            set GidPriv(PrePostEntryWindowGeom) [list OPEN [winfo width .gid]x100+$hh+$vv 1 BottomEntryFrame]
        }
        catch {DestroySlave $w}
        InitWindow2 $w -title [_ "Enter commands"] -geometryvariable PrePostEntryWindowGeom \
            -initcommand BottomEntryFrame -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

        foreach i [bind .gid] {
            bind $w $i [bind .gid $i]
        }
        if { $::tcl_platform(platform) != "windows" } {
            bind .gid <FocusIn> "catch \"focus $w.e\" "
            bind $w <Destroy> "+ bind .gid <FocusIn> {}"
        }
    }

    
    # Command line of main window
    ttk::frame $w.fle -style ForcedFrame
    ttk::label $w.l -text [_ "Command"]: -style ForcedLabel
    bind $w.l <1> "MenuInCommandButton $w.e %X %Y"
    ttk::entry $w.e -style ForcedEntry    
    ttk::checkbutton $w.grid -image [gid_themes::GetImage grid.png small_icons] -style IconButton -command [list UpdateGiDVariableFromCheckButton $w.grid Grid(Show) 1]
    set grid_show [GiD_Set Grid(Show)]
    if { $grid_show } {
         $w.grid state selected 
    } else {
         $w.grid state !selected 
    }    
    
    proc UpdateGiDVariableFromCheckButton { w variable redraw } {
        set checkbox_selected [$w instate selected]
        if { [GiD_Set $variable] != $checkbox_selected } {
            GiD_Set $variable $checkbox_selected
        }
        if { $redraw } {
          GiD_Redraw
        }
    }
        
    ttk::button $w.openGLstate1 -command [list InitialConfiguration 0 1 0] -style IconButton
    UpdateOpenGLIcons
       
    ttk::frame $w.fwarn  -style ForcedFrame -borderwidth 0
    # this does not work: -style WarnLine.TFrame 
    # -style ForcedFrame
    # trick to add a darker border surrounding the listbox, like the entries have
    frame $w.fwarn.ff -background [ttk::style configure ForcedFrame -bordercolor] -borderwidth 0
    ttk::scrollbar $w.fwarn.yscroll  -takefocus 0 \
        -command [list $w.fwarn.list yview] -style TScrollbar
    #pseudottk::
    tk::listbox $w.fwarn.list -yscroll "$w.fwarn.yscroll set" -takefocus 0 -relief flat -borderwidth 1
    if { [info exists ListboxContents] } {
        foreach i $ListboxContents {
            $w.fwarn.list insert end $i
        }
        $w.fwarn.list see end
    }

    if {[winfo class $w] != "Toplevel" } {
        set height [GiD_Set WarnLineHeight]
        $w.fwarn.list configure -width 20 -height $height
    }

    #coordenadas en posicion vertical
    ttk::frame $w.fcoord  -style ForcedFrame -borderwidth 2
    set GidPriv(CoordFrame) $w.fcoord
    
    $w.fwarn.list configure -selectmode single
    pack $w.fwarn.yscroll -side right -fill y -in $w.fwarn.ff   
    pack $w.fwarn.list -expand yes -fill both -side left -padx {1 1} -pady {1 1} -in $w.fwarn.ff
    pack $w.fwarn.ff -in $w.fwarn -expand yes -fill both -side left -padx {3 3} -pady 0
   
    pack $w.fle -fill x -side bottom -expand yes -pady {0 0} -padx 0
    pack $w.fwarn -fill both -side top -expand yes
   
    grid $w.l $w.e $w.openGLstate1 $w.grid -in $w.fle -pady 0 -padx 5 -sticky ewns
    grid configure $w.l -sticky w
    grid configure $w.openGLstate1 -sticky e -padx 2   
    grid configure $w.grid -sticky e -padx 2

    proc ShowMenuGrid { x y preffocus } {
        set w .gid.__gridmenu
        if { [winfo exists $w] } { destroy $w }
        menu $w
        set UnderLineList {}
        set text [_ "Auxiliar grid to aid in points definition"]
        set msg [_ "Help"]
        set under [FindUnderChar msg UnderLineList]
        $w add command -label $msg -underline $under -command [list DisplayGidHelp $w $text menu $x $y]

        if { [ GiD_Set Grid(Show)] } {
            set msg [_ "Hide grid"]
            set under [FindUnderChar msg UnderLineList]
            $w add command -label $msg -underline $under -command {GiD_Set Grid(Show) 0 ; GiD_Redraw}
        } else {
            set msg [_ "Show grid"]
            set under [FindUnderChar msg UnderLineList]
            $w add command -label $msg -underline $under -command {GiD_Set Grid(Show) 1 ; GiD_Redraw}
        }
        if { [ GiD_Set Grid(Active)] } {
            set msg [_ "Disable snap"]
            set under [FindUnderChar msg UnderLineList]
            $w add command -label $msg -underline $under -command {GiD_Set Grid(Active) 0}
        } else {
            set msg [_ "Enable snap"]
            set under [FindUnderChar msg UnderLineList]
            $w add command -label $msg -underline $under -command {GiD_Set Grid(Active) 1}
        }
        if { [ GiD_Set Grid(DrawAxis)] } {
            set msg [_ "Hide axis"]
            set under [FindUnderChar msg UnderLineList]
            $w add command -label $msg -underline $under -command {GiD_Set Grid(DrawAxis) 0 ; GiD_Redraw}
        } else {
            set msg [_ "Show axis"]
            set under [FindUnderChar msg UnderLineList]
            $w add command -label $msg -underline $under -command {GiD_Set Grid(DrawAxis) 1 ; GiD_Redraw}            
        }
        $w add separator
        set msg [_ "Settings"]...
        set under [FindUnderChar msg UnderLineList]
        if { $preffocus == "grid" } {
            $w add command -label $msg -underline $under -command {PreferencesWindow grid}              
        } else {
            $w add command -label $msg -underline $under -command {PreferencesWindow grid}      
        }
        GiD_PopupMenu $w $x $y
    }

    bind $w.grid <$::gid_right_button> [list ShowMenuGrid %X %Y grid]

    grid columnconf $w.fle 1 -weight 1


    set helptxt [_ "Here are output the process messages. At the same time, it is\
            possible to enter written commands or point coordinates or entities\
            labels. Use <Tab> to expand commands."]
    

    proc WarnMessagesContextualMenu { helptxt listbox w idx0 x y } {

        $listbox selection clear 0 end
        $listbox selection set $idx0
        set idx [$listbox curselection]
        if { [llength $idx] == 1 } {
            set txt [$listbox get $idx]
            if { [regexp {x=(\S+)\s*,\s*y=(\S+)\s*,\s*z=(\S+)} $txt {} xc yc zc] } {
                set txtpoint "$xc $yc $zc"
            }
        }
        catch { destroy .gid.__helpmenu }
        menu .gid.__helpmenu
        set UnderLineList {}
        if { [info exists txt] } {
            set msg [_ "Copy"]
            set under [FindUnderChar msg UnderLineList]
            .gid.__helpmenu add command -label $msg -underline $under -command \
                "clipboard clear ; [list clipboard append $txt]"
        }
        if { [info exists txtpoint] } {
            set msg [_ "Copy point coords"]
            set under [FindUnderChar msg UnderLineList]
            .gid.__helpmenu add command -label $msg -underline $under -command \
                "clipboard clear ; [list clipboard append $txtpoint]"
        }
        .gid.__helpmenu add separator
        set msg [_ "Help"]
        set under [FindUnderChar msg UnderLineList]
        .gid.__helpmenu add command -label $msg -underline $under -command \
            "DisplayGidHelp $w [list $helptxt] menu $x $y"
        set msg [_ "Configure toolbars"]
        set under [FindUnderChar msg UnderLineList]
        .gid.__helpmenu add command -label $msg -underline $under -command \
            TOBegin
        set msg [_ "Change appearance"]
        set under [FindUnderChar msg UnderLineList]
        .gid.__helpmenu add command -label $msg -underline $under -command \
            [ list PreferencesWindow graphical]

        set msg [_ "Bring up all windows"]
        set under [ FindUnderChar msg UnderLineList]
        .gid.__helpmenu add command -label $msg -underline $under -command \
            BringUpAllGiDWindows

        GiD_PopupMenu .gid.__helpmenu $x $y
    }

    foreach i [concat $w.fwarn [winfo children $w.fwarn]] {
        bind $i <ButtonPress-$::gid_right_button> [list WarnMessagesContextualMenu $helptxt $w.fwarn.list \
                                     %W @%x,%y %X %Y]
    }   

    GidHelpT $w.l [_ "Press mouse button 1 over it to get a commands menu."]

    MakeBottomEntryBindings

    # para dejar que el boton del medio mueva la barra de scroll
    bind $w.fwarn.yscroll <ButtonPress-$::gid_central_button> ""
}
    
proc BottomStatusFrame { {action ""} { w .gid.bottominfo } } {
    global GidPriv

    if { $action == ""} {
        if { ![info exists GidPriv(PrePostStatusWindowGeom)] } {
            set action INSIDE
        } else {
            set action [lindex $GidPriv(PrePostStatusWindowGeom) 0]
        }
    }
    if { $action == "NONE" } {
        set GidPriv(PrePostStatusWindowGeom) [list NONE {} 1 BottomStatusFrame]
        if { [winfo exists $w] } { 
            destroy $w 
        }
    } elseif { [string range $action 0 5] == "INSIDE" } {
        if { [winfo exists $w] } { 
            destroy $w 
        }
        set GidPriv(PrePostStatusWindowGeom) [list INSIDE {} 1 BottomStatusFrame]
        ttk::frame $w -style ForcedFrame
        ttk::separator $w.separator -orient horizontal -style ForcedSeparator
        grid $w.separator -in $w -columnspan 100 -sticky "news" -pady {0 0}        
        grid columnconfigure $w 0 -weight 1 
        grid $w -in .gid -row 50 -column 0 -columnspan 4 -sticky "snew"
        } else {
        set GidPriv(PrePostStatusWindowGeom) "$action {} 1 BottomStatusFrame"
        InitWindow2 $w -title [_ "Status & Information"] -geometryvariable PrePostStatusWindowGeom \
            -initcommand BottomStatusFrame -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        wm transient $w .gid
    }   
    if { $action == "NONE" } { return }
   
    if { [GidUtils::AreWindowsDisabled] } {
        return
    }
    if { [GetCurrentPrePostMode] == "PRE" } {
        StatusBarToPre
    } else {
        StatusBarToPost    
    }
}

proc UpdateRightButtons { } {
    set state ""
    if { [ info exists GidPriv(PrePostRightButWindowGeom)]} {
        set state [lindex $GidPriv(PrePostRightButWindowGeom) 0]
    }
    if { $state != ""} {
        RightButtons NONE
        RightButtons $state
    }
}

proc RightButtons { {action ""} { w .gid.buts } } {   
    global GidPriv ActionsMenuVar   
    if { $action == "" && [winfo exists $w] } { return }
    if { $action == "INSIDE" || ($action == "" && \
                                     (![info exists GidPriv(PrePostRightButWindowGeom)] || \
                                          [lindex $GidPriv(PrePostRightButWindowGeom) 0] == "INSIDE")) } {
        if { [winfo exists $w] } {
            if { [winfo class $w] != "frame" && [winfo class $w] != "Frame" } {
                destroy $w
            } else { return }
        }
        ttk::frame $w -style flat.TFrame
       
        #         pack forget .gid.central.s
        #         pack $w -side right -fill y -in .gid.central
        #         catch { pack .gid.central.s -fill both -expand yes -side left}
        set GidPriv(PrePostRightButWindowGeom) "INSIDE {} 1 RightButtons"
        GridInside PrePostRightButWindowGeom $w .gid.rightb "ns"
    } elseif { $action == "OPEN" || ($action == "" && [lindex $GidPriv(PrePostRightButWindowGeom) 0] == "OPEN") } {
        if { ![info exists GidPriv(PrePostRightButWindowGeom)] || [lindex $GidPriv(PrePostRightButWindowGeom) 1] == "" } {
            set GidPriv(PrePostRightButWindowGeom) [list OPEN 130x300+[expr [winfo x .gid]+[winfo width .gid] +10]+[expr [winfo y .gid]+25] RightButtons]
        }
        catch {DestroySlave $w}
        InitWindow2 $w -title [_ "Command buttons"] \
            -geometryvariable PrePostRightButWindowGeom \
            -initcommand RightButtons -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        wm transient $w .gid
    } else {
        catch { DestroySlave $w }
        set GidPriv(PrePostRightButWindowGeom) [list NONE {} 1 RightButtons]
        return
    }    
    ttk::frame .gid.buts.f -style ForcedFrame -borderwidth 1    
    pack propagate .gid.buts.f no
    pack .gid.buts.f -side top -fill both -expand yes -padx 0 -pady 0
    bind .gid.buts <Configure> {
        incr DelayedConfigureButsVar
        after idle DelayedConfigureButsFunc
    }

    # en macOsX los botoncitos tienen los extremos redondos: necesitan un poco mas de espacio

    #create initially only GidPriv(MaxRightButtons)=300 buttons, but more could be required
    #create more in SetButtons when needed 
    if { ![info exists ::GidPriv(MaxRightButtons)] } {
        # Utilities Menu Variables now are 142
        # this limit causes that newly created buttons ( > MaxRightButtons)
        # are mapped over the left and right arrows, hidding these 2 buttons
        set ::GidPriv(MaxRightButtons) 300
    }
    for {set i 0 } { $i<$::GidPriv(MaxRightButtons) } { incr i } {
        ttk::button $w.f.b$i -width 15 -takefocus 0  -style RightButtons.IconButton
    }
    set reqwidth [ winfo reqwidth $w.f.b0]   
    .gid.buts.f configure -width [ expr $reqwidth + 3]
    set img_ar [ gid_themes::GetImage ArrowRight.png medium_icons]
    set img_al [ gid_themes::GetImage ArrowLeft.png medium_icons]
    ttk::button $w.f.ar -image $img_ar -style IconButton
    ttk::button $w.f.al -image $img_al -style IconButton
    foreach i [bind .gid] {
        bind $w $i [bind .gid $i]
    }
    

    set ::gid_central_button 2
    set ::gid_right_button 3
    
    if { $::tcl_platform(os) == "Darwin" } {
        # http://wiki.tcl.tk/12987 FAQ 7.7:
        # For historical reasons, MacMice buttons 2 and 3 refer to the right and middle buttons
        # respectively, which is indeed the opposite way round from Windows and *nix systems.
        set ::gid_central_button 3
        set ::gid_right_button 2
    }

    bind $w <$::gid_central_button> { .gid.central.s button 2 %x %y }

    bind $w <Right> "if \[winfo ismapped $w.f.ar] \"$w.f.ar invoke\""
    bind $w <Left> "if \[winfo ismapped $w.f.al] \"$w.f.al invoke\""
   
    update idletasks
    if { [info exists ::ActionsMenuVar] } {       
        SetButtons
    }   
}

proc UnMapAllWindows { w } {
    global GidPriv
    if { $w != ".gid" } {
        return
    }
    # why not make something similar to BringUpAllGiDWindows, instead of an extra variable?
    if { [info exists GidPriv(TopLevelsList)] } {
        foreach i $GidPriv(TopLevelsList) {
            if { [winfo exists $i] && [winfo ismapped $i] && [winfo class $i]== "Toplevel" } {
                wm withdraw $i
            }
        }
    }
}

proc MapAllWindows { w } {
    global GidPriv
    if { $w != ".gid" } { 
        return
    }
    # why not use: BringUpAllGiDWindows
    if { [info exists GidPriv(TopLevelsList)] } {
        foreach i $GidPriv(TopLevelsList) {
            if { [winfo exists $i] && ![winfo ismapped $i] && [winfo class $i]== "Toplevel" } {
                wm deiconify $i
            }
            # put them above gid so the user can see them
            after 100 "GidUtils::WindowAboveGid $i"
        }
    }
}
    
proc OpenTextFromFile { title filenames offset_0 { offset_1 -1} { quit no } } {    
    if { [GidUtils::IsTkDisabled] } {
        return 1
    }
    if { $offset_1 != -1 } {
        lassign $filenames filename(0) filename(1)
    } else {
        #filenames is not a list but a single filename
        set filename(0) $filenames
        set filename(1) ""
    }
    set offset(0) $offset_0
    set offset(1) $offset_1
    set fp(0) ""
    set fp(1) ""
    for {set i_file 0} {$i_file < 2} {incr i_file } {  
        if  { $offset($i_file) == -1 } {
            continue
        }
        if { ![file exists $filename($i_file)] } {
            continue
        } 
        if { $offset($i_file) >= [file size $filename($i_file)] } {
            continue
        }
        set fp($i_file) [open $filename($i_file) r]
        seek $fp($i_file) $offset($i_file)
        if { [eof $fp($i_file)] } {
            close $fp($i_file)
            set fp($i_file) ""             
        }
    }

    if { $fp(0)== "" && $fp(1)== "" } { 
        return 0
    }

    set created_window 0
    if { [winfo exists .gid] } {
        if { [winfo exists .textwin] } {
            destroy .textwin
        }
        set w .gid.textwin
    } else {
        set w .textwin
    }
    if { ![winfo exists $w] || $title != [wm title $w] } {

        set created_window 1

        set ontop 1
        InitWindow2 $w -title $title -geometryvariable PrePostTextWindowGeom
        if { ![winfo exists $w] } {
            for {set i_file 0} {$i_file < 2} {incr i_file } {  
                if { $fp($i_file)== ""  } {
                    continue
                }
                close $fp($i_file)
            }
            return 0;# windows disabled || UseMoreWindows == 0
        }
        
        # wm attributes $w -topmost 1
        # GidUtils::WindowAboveGid $w
        ttk::frame $w.f
        text $w.f.t -width 50 -borderwidth 1
        ttk::scrollbar $w.f.yscroll -command [list $w.f.t yview]
        $w.f.t configure -yscroll "$w.f.yscroll set"
        pack $w.f.yscroll -side right -fill y -pady 5
        pack $w.f.t  -expand yes -fill both -anchor nw -padx 5 -pady 5
        ttk::button $w.b -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton       
        focus $w.b
        pack $w.b -side bottom -pady 2
        pack $w.f -side top -fill both -expand yes -side top
        update

        scan [ winfo geometry $w] %dx%d ww hh
        if { ( $ww < 200) || ( $hh < 200)} {
            wm geometry $w 200x200
        }             
    }

    $w.f.t configure -state normal
    
    for {set i_file 0} {$i_file < 2} {incr i_file } {
        if { $fp($i_file)== ""  } {
            continue
        }
        while { ![eof $fp($i_file)] } {
            $w.f.t insert end [gets $fp($i_file)]\n
        }
        close $fp($i_file)
    }
    
    $w.f.t see [$w.f.t index "end-2l"]

    regsub {\..*} [$w.f.t index end] {} num_lines
    incr num_lines -1
    if { $num_lines > 20 } { set num_lines 20 }

    if { $::tcl_platform(platform) != "windows" } {
        $w.f.t configure -state disabled
    }

    if { $created_window } {
        set hei $num_lines
        if { $hei < 6 } { set hei 6 }
        $w.f.t configure -height $hei
    }

    if { $quit != "no" } {
        $w.b configure -text [_ "Quit"]
        if { $::tcl_platform(os) != "Darwin"} {
            if { [winfo exists $w] } {
                tkwait visibility $w
            }
        } else {
            update
        }
        raise $w
        grab $w
        tkwait window $w
    }   
    return 0
}

proc CorrectWmGidGeom { geom} {
    set x 5
    set y 20
    set yeswh 1

    set dumWin .
    set maxW_maxH [ wm maxsize $dumWin]
    set screenwidth [ lindex $maxW_maxH 0]
    set screenheight [ lindex $maxW_maxH 1]
    # multi-monitors if main monitor is on the right and the secondary on the left
    # then offsets may have negative values as vrootx is negative
    set vrootx [ winfo vrootx $dumWin]
    set min_x_off $vrootx
    set max_x_off [ expr $screenwidth + $vrootx]
    set vrooty [ winfo vrooty $dumWin]
    set min_y_off $vrooty
    set max_y_off [ expr $screenheight + $vrooty]

    if { ![regexp {^([0-9]*)x([0-9]*)([-+]*[0-9]*)([-+]*[0-9]*)$} $geom trash width height x y] } {
        if { ![regexp {([-+]*[0-9]*)([-+]+[0-9]*)$} $geom trash x y] } {
            set x +32
            set y +32
        }
        # set width [winfo reqwidth $w]
        # set height [winfo reqheight $w]
        set width [expr [ winfo screenwidth $dumWin]/3]
        set height [expr [ winfo screenheight $dumWin]/3]
        set yeswh 0
    }

    if { ![regsub {[+]-} $x {-} x] } {
        if { $x < $min_x_off } { set x [expr $max_x_off+$x-$width] }
    }

    if { ![regsub {[+]-} $y {-} y] } {
        if { $y <  $min_y_off } { set y [expr $max_y_off+$y-$height] }
    }

    if { $x < [ expr $min_x_off -15] } { set x [ expr $min_x_off + 5] }
    if { $y < [ expr $min_y_off -15] } { set y [ expr $min_y_off + 20] }

    if { [expr $x+$width] > [expr $max_x_off+15] } {
        set x [expr $max_x_off-$width]
    }
    if { [expr $y+$height] > [expr $max_y_off+15] } {
        set y [expr $max_y_off-$height]
    }


    if { $x < [ expr $min_x_off -15] } { set width [expr $width+$x+5] }
    if { $y < [ expr $min_y_off -15] } { set height [expr $height+$y+5] }

    if { $::tcl_platform(os) == "Darwin" } {
        if { $y < 32 } { set y 32 }
    }

    if { ![regexp {[+]} $x] } { set x +$x}
    if { ![regexp {[+]} $y] } { set y +$y}

    if { $yeswh } {
        set geom2 ${width}x$height$x$y
    } else {
        set geom2 $x$y
    }
    return $geom2
}

proc WmGidGeom { w geom } {
    if { [info exists ::GidPriv(OffScreen)] && $::GidPriv(OffScreen)} {
        wm withdraw $w
        return
    }

    set iszoomed 0
    if { [lindex $geom 0] == "ZOOMED" } {
        set geom [lindex $geom 1]
        set iszoomed 1
    }

    if { [ llength $geom ] > 1} {
        set geom [lindex $geom 1]
    }

    set x 5
    set y 20
    set yeswh 1

    if { $geom ==  "" } {
        set dumWin .
        set maxW_maxH [ wm maxsize $dumWin]
        set screenwidth [ lindex $maxW_maxH 0]
        set screenheight [ lindex $maxW_maxH 1]
        set x [expr $screenwidth/3]
        set y [expr $screenheight/3]
        # set width [winfo reqwidth $w]
        # set height [winfo reqheight $w]
        # set geom ${width}x${height}+${x}+$y
        set geom +${x}+$y
        set ::GidPriv($w,has,geom) 0
    } else {
        set ::GidPriv($w,has,geom) 1
        set geom [ CorrectWmGidGeom $geom]
    }
    wm geometry $w $geom

    ## # begin old code
    ## set dumWin .
    ## set maxW_maxH [ wm maxsize $dumWin]
    ## set screenwidth [ lindex $maxW_maxH 0]
    ## set screenheight [ lindex $maxW_maxH 1]
    ## # multi-monitors if main monitor is on the right and the secondary on the left
    ## # then offsets may have negative values as vrootx is negative
    ## set vrootx [ winfo vrootx $dumWin]
    ## set min_x_off $vrootx
    ## set max_x_off [ expr $screenwidth + $vrootx]
    ## set vrooty [ winfo vrooty $dumWin]
    ## set min_y_off $vrooty
    ## set max_y_off [ expr $screenheight + $vrooty]
    ## 
    ## if { $geom ==  "" } {
    ##     set x [expr $screenwidth/3]
    ##     set y [expr $screenheight/3]
    ##     set geom +${x}+$y
    ##     set ::GidPriv($w,has,geom) 0
    ## } else {
    ##     set ::GidPriv($w,has,geom) 1
    ## }
    ## 
    ## if { ![regexp {^([0-9]*)x([0-9]*)([-+]*[0-9]*)([-+]*[0-9]*)$} $geom trash width height x y] } {
    ##     if { ![regexp {([-+]*[0-9]*)([-+]+[0-9]*)$} $geom trash x y] } {
    ##         wm geom $w +32+32
    ##         W "wm geom $w +32+32"
    ##         return
    ##         error "couldn't compute geometry: $geom"
    ##     }
    ##     set width [winfo reqwidth $w]
    ##     set height [winfo reqheight $w]
    ##     set yeswh 0
    ## }
    ## 
    ## if { ![regsub {[+]-} $x {-} x] } {
    ##     if { $x < $min_x_off } { set x [expr $max_x_off+$x-$width] }
    ## }
    ## 
    ## if { ![regsub {[+]-} $y {-} y] } {
    ##     if { $y <  $min_y_off } { set y [expr $max_y_off+$y-$height] }
    ## }
    ## 
    ## if { $x < [ expr $min_x_off -15] } { set x [ expr $min_x_off + 5] }
    ## if { $y < [ expr $min_y_off -15] } { set y [ expr $min_y_off + 20] }
    ## 
    ## if { [expr $x+$width] > [expr $max_x_off+15] } {
    ##     set x [expr $max_x_off-$width]
    ## }
    ## if { [expr $y+$height] > [expr $max_y_off+15] } {
    ##     set y [expr $max_y_off-$height]
    ## }
    ## 
    ## 
    ## if { $x < [ expr $min_x_off -15] } { set width [expr $width+$x+5] }
    ## if { $y < [ expr $min_y_off -15] } { set height [expr $height+$y+5] }
    ## 
    ## if { $::tcl_platform(os) == "Darwin" } {
    ##     if { $y < 32 } { set y 32 }
    ## }
    ## 
    ## if { ![regexp {[+]} $x] } { set x +$x}
    ## if { ![regexp {[+]} $y] } { set y +$y}
    ## 
    ## if { $yeswh } {
    ##     wm geom $w ${width}x$height$x$y
    ## } else {
    ##     wm geom $w $x$y
    ## }
    ## 
    ## # end old code
    
    if { $iszoomed } {
        if { $::tcl_platform(platform) == "windows" } {
            wm state $w zoomed
        } else {
            catch { wm attributes $w -zoomed 1 }
        }
    }
}

# proc IsWord
#
# w: parent window
# type -        Can be:
#                        word:    word without spaces
#                        any:     anything
#                        real:    real
#                        real+:   positive real
#                        int:     int
#                        int+:    positive int

proc IsWord { type word { w .gid } { PrintError no } } {

    switch $type {
        word {
            if { ![regexp {^[  ]*[^ \t]+[  ]*$} $word] } {
                set errorRes [_ "A single word must be entered."]
            }
        }
        real {
            if { ![regexp \
                       {^[  ]*([+-]?([0-9]+\.?[0-9]*|[0-9]*\.?[0-9]+)([eE][+-]?[0-9]+)?)[  ]*$} \
                       $word] } {
                set errorRes [_ "One number must be entered"].
            }
        }
        real+ {
            if { ![regexp \
                       {^[  ]*([+]?([0-9]+\.?[0-9]*|[0-9]*\.?[0-9]+)([eE][+-]?[0-9]+)?)[  ]*$} \
                       $word] } {
                set errorRes [_ "One positive number must be entered."]
            }
        }
        int {
            if { ![regexp \
                       {^[  ]*[+-]?[0-9]+[  ]*$} \
                       $word] } {
                set errorRes [_ "One integer number must be entered."]
            }
        }
        int+ {
            if { ![regexp \
                       {^[  ]*[+]?[0-9]*[1-9]+[0-9]*[  ]*$} \
                       $word] } {
                set errorRes [_ "One positive integer number must be entered."]
            }
        }
    }
    if { [info exists errorRes] } {
        if { $PrintError != "no" } {
            WarnWin "$errorRes $PrintError"
        }
        return 0
    } else {
        return 1
    }
}

proc SetProblemTypeChoose { projecttype {compare_with_internet_retrieve 1} } {    

    if { $compare_with_internet_retrieve } {
        set fail [RetrievePT::SetProblemTypeIfNotExitsTryDownload $projecttype]
        #return if fail and also if not fail because
        #a callback will invoke again SetProblemTypeChoose when the problemtype will be complete
        return        
    }
    
    package require dialogwin

    set oldproblemtype [ GiD_Info Project ProblemType]    
    set changes [ GiD_Info Project AreChanges]

    if { $changes || [GidUtils::ModelHasName] } {
        set putyes yes
    } else {
        set putyes ""
    }

    if { $oldproblemtype != "UNKNOWN" && ($changes || [GidUtils::ModelHasName]) } {
        set f [DialogWin::Init .gid [_ "Select new problemtype"] separator]
        set w [winfo toplevel $f]
        label $f.l1 -text [_ "You are going to load problemtype '%s'.\nWhat do you want to do?" \
                               $projecttype] \
            -justify left
        label $f.l2 -text [_ "All data information (materials, conditions, data) will be lost"] \
            -justify left -wraplength 180
        if { $::tcl_platform(os) != "Darwin"} {
            ttk::radiobutton $f.r1 -text [_ "Reset to new problemtype"] -variable todo -value update
            ttk::radiobutton $f.r2 -text [_ "Transform to new problemtype"] -variable todo -value transform
        } else {
            radiobutton $f.r1 -text [_ "Reset to new problemtype"] -variable todo -value update
            radiobutton $f.r2 -text [_ "Transform to new problemtype"] -variable todo -value transform
        }
        label $f.l3 -text [_ "Data will be converted to new problemtype if possible. Some data may be lost"]\
            -justify left -wraplength 180

        grid $f.l1 -column 0
        grid $f.r1 -column 0 -sticky w -padx 10
        grid $f.l2 -column 0 -sticky w -padx 50
        grid $f.r2 -column 0 -sticky w -padx 10
        grid $f.l3 -column 0 -sticky w -padx 50

        if { $oldproblemtype == "UNKNOWN" } {
            $f.r2 configure -state disabled
            $f.l3 configure -foreground grey
            set ::todo update
        } elseif { ![info exists ::todo] || [lsearch [list update transform] $::todo] == -1 } {
            set ::todo update
        }       

        set action [DialogWin::CreateWindow]
        DialogWin::DestroyWindow
        switch $action {
            0 { return }
            1 {
                switch $::todo {
                    update {
                        if { $putyes != "" } {
                            GiD_Process Mescape Data Defaults ProblemType $putyes $projecttype escape
                        } else {
                            GiD_Process Mescape Defaults ProblemType $projecttype escape
                        }
                    }
                    transform {
                        # GiD_UnRegisterEvents PROBLEMTYPE
                        #
                        #I don't want to raise this event of the old problemtype, delete it if exists
                        foreach proc_name [GiD_GetRegisteredEventProcs GiD_Event_BeforeTransformProblemType PROBLEMTYPE] {
                            GiD_UnRegisterEvent GiD_Event_BeforeTransformProblemType $proc_name PROBLEMTYPE
                        }
                        set procs_to_delete [list ::BeforeTransformProblemType ::GiD_Event_BeforeTransformProblemType]
                        foreach proc_name $procs_to_delete {
                            if { [info procs $proc_name] != "" } {
                                rename $proc_name ""
                            }
                        }
                        #after idle [list GiD_Process Mescape Data Defaults TransfProblem $projecttype escape]
                        GiD_Project transform_problemtype $projecttype
                    }
                }
            }
        }
    } else {
        if { $putyes != "" } {
            GiD_Process Mescape Data Defaults ProblemType $putyes $projecttype escape
        } else {
            GiD_Process Mescape Data Defaults ProblemType $projecttype escape
        }
    }
}

proc ReadProblemtypeConfigFile { path name } {
    global GidPriv
    #package require tdom
    set dir_problemtypes [gid_filesystem::get_folder_standard problemtypes]
    if { [file extension $path] == ".lnk" && [gid_filesystem::is_link [file join $dir_problemtypes $path]] == 2 } {
        set fullrealpath [gid_filesystem::read_link [file join $dir_problemtypes $path] 1]
        set path [file rootname $path] ;#to remove .lnk
    } else  {
        set fullrealpath [file join $dir_problemtypes $path]
    }

    if { [file extension $name] == ".lnk" && [gid_filesystem::is_link [file join $fullrealpath $name]] == 2 } {
        set realdir [gid_filesystem::read_link [file join $fullrealpath $name] 1]
        set name [file rootname $name] ;#to remove .lnk
    } else {
        set realdir [file join $fullrealpath $name]
    }

    set pt [file join $path [file rootname $name]]
    
    set filename [file join $realdir [file rootname $name]].xml
    set data [ReadProblemtypeXml $filename Infoproblemtype {ImageFileBrowser Icon}]
    if { $data != "" } {
        foreach {key value} $data {
            if { $value != "" } {
                if { $key == "Icon" } {
                    if { [file pathtype $value] == "relative" } {
                        set value [file join $realdir $value]
                    }
                    if { [file exists $value] && [file isfile $value]} {
                        set ::GidPriv(problemtype,$key,$pt) $value
                    }
                } else {
                    set imagefilename [file join $realdir $value]
                    set ::GidPriv(problemtype,$key,$pt) [gid_themes::GetImage $imagefilename small_icons]
                    if { $::tcl_platform(os) == "Darwin" } {
                        #Some MACs suport transparency so beter disabled
                        #Mac do not support parcial tranparency, not optimal solution, but better than nothing
                        SetBackgroundToAlphaPixels $::GidPriv(problemtype,$key,$pt) [set ::ttk::theme::[::gid_themes::GetTtkTheme]::colors(-toolbars_bg)]
                    }
                }
            }
        }
    } else {
        set download_filename [file join $realdir download.xml]
        if { [file exists $download_filename] } {
            set projecttype $pt
            set data [ReadProblemtypeXml $download_filename DownloadProblemtype {Name Version ShortDescription}]
            if { $data != "" } {
                array set module_download $data
                set module_download(Platform) [RetrievePT::GetCurrentPlatform]
                set module_xml_file [GidUtils::GiveFileInsideProblemType $projecttype .xml 1]
                set problemtype_exists [RetrievePT::GetModuleExists $module_xml_file $module_download(Name) $module_download(Version) $module_download(Platform)]
                if { $problemtype_exists } {
                    #do not add the icon of download it
                } else {
                    set ::GidPriv(problemtype,ImageFileBrowser,$pt) [gid_themes::GetImage downloads.png small_icons]
                }
            }
        }
    }
}

proc CreateMenusProblemTypeRecursive { tree parent dir menu current } {
    global GidPriv
    set inum 0  
    foreach node [$tree children $parent] {
        if { [$tree isleaf $node] } {
            #W "LEAF: $node"
            set text [file tail $node]
            set fullrelativept $node
            if { $node != $current } {
                if { [info exists ::GidPriv(problemtype,ImageFileBrowser,$fullrelativept)] } {
                    $menu add command -label $text -command [list SetProblemTypeChoose $fullrelativept] \
                        -image $::GidPriv(problemtype,ImageFileBrowser,$fullrelativept) -compound left
                } else {
                    $menu add command -label $text -command [list SetProblemTypeChoose $fullrelativept]
                }
            } else {
                if { [info exists ::GidPriv(problemtype,ImageFileBrowser,$fullrelativept)] } {
                    $menu add checkbutton -label $text -command [list SetProblemTypeChoose $fullrelativept] \
                        -variable ::GidPriv(PTMFD) -onvalue 1 \
                        -image $::GidPriv(problemtype,ImageFileBrowser,$fullrelativept) -compound left
                } else {
                    $menu add checkbutton -label $text -command [list SetProblemTypeChoose $fullrelativept] \
                        -variable ::GidPriv(PTMFD) -onvalue 1
                }
                set ::GidPriv(PTMFD) 1
            }
        } else {
            #W "FOLDER: $node"
            set text [file tail $node]
            set newmenu $menu.m$inum
            while { [winfo exists $newmenu] } {
                #e.g. when in user_settings /problemtypes are subfolders
                incr inum
                set newmenu $menu.m$inum
            } 
            $menu add cascade -label $text -menu $newmenu
            menu $newmenu
            macOSConfigureWhiteForegroundForDarkTheme $newmenu
            CreateMenusProblemTypeRecursive $tree $node $dir $newmenu $current
            incr inum
        }
    }
    return 0
}

proc FillMenuProblemtypeForDir { list_problemtypes dir menu current} {
    global GidPriv    
    if { ![info exists ::GidPriv(dirfiles,$dir)] } {
        #set GidPriv(dirfiles,$dir) and subdirectories
        # WarnWinText "   FastCache... $dir"
        FastCacheFromProblemtypeMenuDir $dir
        #FastCacheFromProblemtypeMenuDir also call ReadProblemtypeConfigFile
    }
    
    package require struct::tree
    set tree [struct::tree]
    foreach relative_pt $list_problemtypes {
        set file_split [file split $relative_pt]
        set num_levels [llength $file_split]
        for {set i_level 0} {$i_level<$num_levels} {incr i_level} {
            if { $i_level==0 } {
                set parent root
            } else {
                set parent [file join {*}[lrange $file_split 0 $i_level-1]]
            }            
            set node [file join {*}[lrange $file_split 0 $i_level]]
            $tree insert $parent end $node
        }
    }

    CreateMenusProblemTypeRecursive $tree root $dir $menu $current
    rename $tree {}       
    return 0
}

proc FillMenuProblemtype { menu } {
    global GidPriv
    if { ![winfo exists $menu] } {
        # WarnWinText "$menu does not exist"
        return
    }    
    set location standard
    set dir_problemtypes [gid_filesystem::get_folder_$location problemtypes]
    if { [$menu index end] != "none" && [info exists GidPriv(dirfiles,$dir_problemtypes)] } {
        # WarnWinText "[$menu index end] && $dir_problemtypes - [info exists GidPriv(dirfiles,$dir_problemtypes)]"
        return
    }
    $menu delete 0 end
    foreach i [winfo children $menu] { destroy $i }

    set current_problemtype [GiD_Info Project ProblemType]
    FillMenuProblemtypeForDir [GidUtils::GetListProblemTypes $location] $dir_problemtypes $menu $current_problemtype

    $menu add separator
    set menu_index_end_0 [$menu index end]

    set locations [list user_settings nextcloud appstream]
    foreach location $locations {
        set dir_username_problemtypes [gid_filesystem::get_folder_$location problemtypes]    
        FillMenuProblemtypeForDir [GidUtils::GetListProblemTypes $location] $dir_username_problemtypes $menu $current_problemtype
    }
        
    if { $menu_index_end_0 != [$menu index end] } {
        #exists some <user>/problemtypes , add an extra separator
        $menu add separator
    }    

    if { [ GiD_Info Project ProblemType] == "UNKNOWN" } {
        set color $::GidPriv(Color,DisabledForegroundMenu)
    } else {
        set color black
    }

    set UnderLineList {}
    set text [_ "Transform"]...
    set under [FindUnderChar text UnderLineList]
    $menu add command -label $text -underline $under -command {GiD_Process MEscape Data Defaults TransfProblem}
    set text [_ "Internet retrieve"]...
    set under [FindUnderChar text UnderLineList]
    $menu add command -label $text -image [gid_themes::GetImage downloads.png small_icons] -compound left -underline $under -command RetrievePT::OpenGUI
    set text [_ "Load"]...
    set under [FindUnderChar text UnderLineList]
    $menu add command -label $text -underline $under -command {GiD_Process MEscape Data Defaults ProblemType}
    set text [_ "Unload"]
    set under [FindUnderChar text UnderLineList]
    $menu add command -label $text -underline $under -command UnloadProblemtype
   
    # WarnWinText "FillMenuProblemtype - done $menu"
    # These updates causes crash on Mac OS X 10.9 with TclTk 8.6.5 with the embedded in the window
    # are they needed ?
    # update idletasks
    # update
}

proc UnloadProblemtype { } {
    if { [ GiD_Info Project AreChanges] || [GidUtils::ModelHasName] } {
        set msg [_ "All data information (materials,conditions,data) will be lost."]
        set ret [MessageBoxOptionsButtons [_ "Unload"] $msg \
            {0 1} [list [_ "Ok"] [_ "Cancel"]] question ""]
        if { $ret == 0 } {
            GiD_Process MEscape Data Defaults ProblemType Yes UNKNOWN
        }
    } else {
        GiD_Process MEscape Data Defaults ProblemType UNKNOWN
    }
}


proc ClearCacheFormProblemtypeMenuDir {} {
    global GidPriv
    foreach i [array names GidPriv dirfiles,*] {
        unset GidPriv($i)
    }
}

#to get the real dir also if there are Windows links in the middle of the path
#like "C:/gid project/problemtypes/My Tests.lnk/AllCondTypes1.1"
proc GetRealDirDereferencingLinks { dir } {
    set realdir ""
    foreach part [file split $dir] {
        set realdir [file join $realdir $part]
        if { [file extension $realdir] == ".lnk" && [gid_filesystem::is_link $realdir] == 2 } {
            set realdir [gid_filesystem::read_link $realdir 1]
        }
    }    
    return $realdir
}

proc FastCacheFromProblemtypeMenuDir { dir } {
    global GidPriv
    if { $dir == "" } {
        return 1
    }
    #recreate this information also if exists GidPriv(dirfiles,$dir)
    #can be created or deleted files or directories    
    set dir_problemtypes [gid_filesystem::get_folder_standard problemtypes]
    set startrelpath [string length $dir_problemtypes]
    incr startrelpath
  
    set realdir [GetRealDirDereferencingLinks $dir]    
    set dirs [gid_filesystem::glob -nocomplain -tails -directory $realdir -types d *]
    foreach link [gid_filesystem::glob -nocomplain -tails -directory $realdir -types f *.lnk] {
        if { [gid_filesystem::is_link [file join $realdir $link]] == 2 } {
            lappend dirs $link
        }
    }
    set GidPriv(dirfiles,$dir) [lsort -dictionary $dirs]
    foreach i $GidPriv(dirfiles,$dir) {
        if { [file extension $i] == ".gid" } {
            set path [string range $dir $startrelpath end]
            ReadProblemtypeConfigFile $path $i
            continue
        } elseif { [file extension $i] == ".lnk" && [gid_filesystem::is_link [file join $realdir $i]] == 2 && [file extension [file rootname $i]] == ".gid" } {
            set path [string range $dir $startrelpath end]
            ReadProblemtypeConfigFile $path $i
            continue
        }
        FastCacheFromProblemtypeMenuDir [file join $dir $i]
    }
    return 0
}

proc FastCacheFromProblemtypeMenu {} {
    global GidPriv
    #recreate this information also if exists GidPriv(dirfiles,$dir)
    #can be created or deletes files or directrories
    set dir_application [gid_filesystem::get_folder_gid]
    set dirs [gid_filesystem::glob -nocomplain -tails -directory $dir_application -types d *.gid]
    foreach link [gid_filesystem::glob -nocomplain -tails -directory $dir_application -types f *.lnk] {
        if { [gid_filesystem::is_link [file join $dir_application $link]] == 2 } {
            lappend dirs $link
        }
    }
    set GidPriv(dirfiles,$dir_application) [lsort -dictionary $dirs]
    FastCacheFromProblemtypeMenuDir [gid_filesystem::get_folder_standard problemtypes]
}

proc GetProblemTypes { } {
    global GidPriv
    set current [GiD_Info Project ProblemType]
    set dir_application [gid_filesystem::get_folder_gid]
    set problemtypes ""
    foreach i [gid_filesystem::glob -nocomplain [file join $dir_application  *.gid]] {
        lappend problemtypes [file tail [file root $i]]
    }
    set problemtypes [lsort -dictionary $problemtypes]
    return $problemtypes
}


#use the same advance bar for pre and post

proc AdvanceBar { numerator divisor inum { title "" } { maintext ""} } {   
    if { [GidUtils::IsTkDisabled] } {
        return 1
    }    
    if { [GiD_Set ProgressBarInMainWindow] } {
        PostProgressBar $numerator $divisor $title $maintext
    } else {
        PostProgressBar $numerator $divisor $maintext $title
    }
}

#to show variables with () joined in a single menu entry item(...) that must offer its suboptions when clicking 
#assume that are ordered
proc GetLabelsAndCommandsFromActionsMenuVar { } {  
    global ActionsMenuVar ActionsMenuLabels
    set labels_and_commands ""
    set last_base_name ""
    foreach variable_name $::ActionsMenuVar label $::ActionsMenuLabels {
        if { $variable_name == "Escape" } {
            #ignore it
        } else {
            if { [regexp {(.+)\((.+)\)} $variable_name dummy base_name subitems] } {
                if { $base_name == $last_base_name } {
                    #only one entry by base_name
                } else {
                    set base_label $base_name
                    if { $label != $variable_name } {
                        regexp {(.+)\((.+)\)} $label dummy base_label sub_labels

                    }                                
                    lappend labels_and_commands [list ${base_label}(...) [list GiD_Process $base_name]]
                    set last_base_name $base_name
                }
            } else {
                #check -array_names for old-style remaining variables like BoundaryLayer that only print its base_name
                if { [catch { set array_names [GiD_Set -array_names $variable_name] } ] } {
                    set array_names ""
                }
                if { [llength $array_names] } {
                    lappend labels_and_commands [list ${label}(...) [list GiD_Process $variable_name]]
                } else {
                    lappend labels_and_commands [list $label [list GiD_Process $variable_name]]
                }
            }                        
        }
    }  
    return $labels_and_commands
}

proc ContextualSubMenu { w } {
    global ActionsMenuVar ActionsMenuLabels ActionsMenuVarType
    $w delete 0 end
    if { $::ActionsMenuVarType == "TMP" } {
        set labels_and_commands ""
        if { $::ActionsMenuFunction == "Utilities Variables" } {                                   
            set labels_and_commands [GetLabelsAndCommandsFromActionsMenuVar]                              
        } else {            
            foreach command $::ActionsMenuVar label $::ActionsMenuLabels {
                if { $command == "Join" || $command == "NoJoin" } {
                    append label " ${::acceleratorText}-a"
                }
                if { [lindex $command 0] == "-np-" } {
                    lappend labels_and_commands [list $label [lrange $command 1 end]]
                } else {
                    lappend labels_and_commands [list $label [list GiD_Process $command]]
                }
            }            
        }
        rmenuconf $w $labels_and_commands
    } else {
        rmenuconf $w  { { -NONE- "" } }        
        $w entryconfigure end -foreground $::GidPriv(Color,DisabledForegroundMenu)
    }
}

proc SelectJoinOrNoJoin {} {
    global ActionsMenuVar
    if { [lsearch -exact $::ActionsMenuVar Join] != -1 } {
        GiD_Process Join
    } elseif { [lsearch -exact $::ActionsMenuVar NoJoin] != -1 } {
        GiD_Process NoJoin
    }
}

proc SelectionOnlyVisibleOrAll {} {
    if { [ GiD_Set SelectionOnlyVisible] == 0 } {
        GiD_Set SelectionOnlyVisible 1
        ::GidUtils::SetWarnLine "Now only select visible entities"
    } else {
        GiD_Set SelectionOnlyVisible 0
        ::GidUtils::SetWarnLine "Now select visible and hidden entities"
    }
}

proc UpdateGraphFramesBegin { w HorV x y} {
    global GidPriv
    bind $w <ButtonRelease-1> "UpdateGraphFramesEnd %W $x $y %x %y $HorV"
}

proc UpdateGraphFramesEnd { w xold yold x y HorV } {

    set master [lindex [grid info $w] 1]

    regexp -- {-row[ ]*([0-9]+)} [grid info $w] {} irow
    regexp -- {-column[ ]*([0-9]+)} [grid info $w] {} icol

    if { $HorV == "v" || $HorV == "hv"} {
        set newwidth1 [expr [lindex [grid bbox $master 0 0] 2]+$x]
        set newwidth2 [expr [lindex [grid bbox $master 2 0] 2]-$x]  
        if { $newwidth1 < 0 } { set newwidth1 0 }
        if { $newwidth2 < 0 } { set newwidth2 0 }
        grid columnconf $master 0 -weight $newwidth1
        grid columnconf $master 2 -weight $newwidth2
    }
    if { $HorV == "h" || $HorV == "hv"} {
        set newheight1 [expr [lindex [grid bbox $master 0 0] 3]+$y]
        set newheight2 [expr [lindex [grid bbox $master 0 2] 3]-$y]
        if { $newheight1 < 0 } { set newheight1 0 }
        if { $newheight2 < 0 } { set newheight2 0 }
        grid rowconf $master 0 -weight $newheight1
        grid rowconf $master 2 -weight $newheight2
    }
}

proc PackToglSeparator { w row col type } {
    switch $type {
        h {
            $w configure -cursor sb_v_double_arrow
            bind $w <1> "UpdateGraphFramesBegin %W h %x %y"
            grid $w -in .gid.central.wins -row $row -column $col \
                -sticky nsew
        }
        v {
            $w configure -cursor sb_h_double_arrow
            bind $w <1> "UpdateGraphFramesBegin %W v %x %y"
            grid $w -in .gid.central.wins -row $row -column $col \
                -sticky nsew
        }
        hv {
            $w configure -cursor cross
            bind $w <1> "UpdateGraphFramesBegin %W hv %x %y"
            grid $w -in .gid.central.wins -row $row -column $col \
                -sticky nsew
        }
    }
}

proc PackToglWindows { type } {
    if { ![winfo exists .gid.central.wins] } {
        PrepareToglForSeveralWindows
    }
    set totalnum [string index $type 0]
    set i 2
    while { [winfo exists .gid.central.wins.graphwin$i] } {
        incr i
    }
    incr i -1
    if { $i < $totalnum } { 
        return
    }
    foreach i [grid slaves .gid.central.wins] { grid forget $i }
    for { set i 1 } { $i <= 5 } { incr i } {
        if { ![winfo exists .gid.central.wins.separator$i] } {
            ttk::frame .gid.central.wins.separator$i
        }
    }
    if { $type == "1" } {
        grid .gid.central.wins.graphwin1 -in .gid.central.wins \
            -row 0 -column 0 \
            -sticky nsew -columnspan 3  -rowspan 3
        .gid.central.s SetPosition 1
        #sobra?# puesto idletasks
        update idletasks
        .gid.central.wins.graphwin1 configure -borderwidth 0
    } elseif { $type == "2LR" || $type == "3L" } {
        grid .gid.central.wins.graphwin1 -rowspan 3 -row 0 -column 0 \
            -sticky nsew
        .gid.central.s SetPosition L
        PackToglSeparator .gid.central.wins.separator1 0 1 v
        if { $type == "2LR" } {
            PackToglSeparator .gid.central.wins.separator2 1 1 v
        } else {
            PackToglSeparator .gid.central.wins.separator2 1 1 hv
        }
        PackToglSeparator .gid.central.wins.separator3 2 1 v
    } elseif { $type == "2UD" || $type == "3U" } {
        grid .gid.central.wins.graphwin1 -columnspan 3 -row 0 -column 0 \
            -sticky nsew
        .gid.central.s SetPosition B
        PackToglSeparator .gid.central.wins.separator4 1 0 h
        if { $type == "2UD" } {
            PackToglSeparator .gid.central.wins.separator2 1 1 v
        } else {
            PackToglSeparator .gid.central.wins.separator2 1 1 hv
        }
        PackToglSeparator .gid.central.wins.separator5 1 2 h
    } else {
        grid .gid.central.wins.graphwin1 -row 0 -column 0 \
            -sticky nsew
        .gid.central.s SetPosition BL
        PackToglSeparator .gid.central.wins.separator1 0 1 v
        PackToglSeparator .gid.central.wins.separator2 1 1 hv
        PackToglSeparator .gid.central.wins.separator4 1 0 h
    }
    set icurr 2
    if { $type == "2UD" || $type == "3D" } {
        grid .gid.central.wins.graphwin$icurr -in .gid.central.wins \
            -columnspan 3 -row 2 -column 0 \
            -sticky nsew
        .gid.central.wins.graphwin${icurr}.s SetPosition T
        incr icurr
    } elseif { $type == "3R" || $type == "3U" || $type == "4" } {
        grid .gid.central.wins.graphwin$icurr -in .gid.central.wins -row 2 -column 0 \
            -sticky nsew
        .gid.central.wins.graphwin${icurr}.s SetPosition TL
        incr icurr
        PackToglSeparator .gid.central.wins.separator3 2 1 v
    }
    if { $type == "2LR" || $type == "3R" } {
        grid .gid.central.wins.graphwin$icurr -in .gid.central.wins -rowspan 3 -row 0 -column 2 \
            -sticky nsew
        .gid.central.wins.graphwin${icurr}.s SetPosition R
        incr icurr
    } elseif { $type == "3L" || $type == "3D" || $type == "4" } {
        grid .gid.central.wins.graphwin$icurr -in .gid.central.wins \
            -rowspan 1 -row 0 -column 2 \
            -sticky nsew
        .gid.central.wins.graphwin${icurr}.s SetPosition BR
        incr icurr
        PackToglSeparator .gid.central.wins.separator5 1 2 h

    }
    if { $type == "3L" || $type == "3U" || $type == "4" } {
        grid .gid.central.wins.graphwin$icurr -in .gid.central.wins -row 2 -column 2 \
            -sticky nsew
        .gid.central.wins.graphwin${icurr}.s SetPosition TR
        incr icurr
    }
    grid columnconfigure .gid.central.wins {0 2} -weight 1
    grid columnconfigure .gid.central.wins 1 -weight 0 -minsize 1
    grid rowconfigure .gid.central.wins {0 2} -weight 1
    grid rowconfigure .gid.central.wins 1 -weight 0 -minsize 1
}

proc GiveNumToglInteriorWins {} {
    set i 2
    while { [winfo exists .gid.central.wins.graphwin$i] } { incr i }
    incr i -1
    return $i
}

proc DestroyRemainingToglWindows { type } {

    if { [string tolower $type] == "ext" } { return }

    set totalnum [string index $type 0]   
    for { set i [expr $totalnum+1]} { $i <= 6} { incr i} {
        if { [ winfo exists .gid.central.wins.graphwin$i] } {
            destroy .gid.central.wins.graphwin$i
        }
    }
}

#find the panedwindow that is handling the pane
proc FindPanedWindowHandlingPane { pane } {
    set paned_window ""
    set ws "."
    set j ""
    for { set i 0 } { $i < [llength $ws] } { incr i } {
        foreach j [winfo children [lindex $ws $i]] {
            set class_j [winfo class $j]
            if { ( $class_j == "Panedwindow" || $class_j == "TPanedwindow") && [lsearch [$j panes] $pane] != -1 } {
                set paned_window $j
                set ws "" ;#to break also the for loop
                break
            }
            lappend ws $j
        }
    }
    return $paned_window
}

proc PrepareToglForSeveralWindows {} {
    ttk::frame .gid.central.wins
    set winfo_manager_togl [winfo manager .gid.central.s]
    switch $winfo_manager_togl {
        "" {
            grid .gid.central.wins -sticky nsew
        }
        grid {
            grid .gid.central.wins {*}[grid info .gid.central.s]
        }
        pack {
            pack .gid.central.wins -in .gid.central -before .gid.central.s -anchor center -expand 1 -fill both -side left
        }
        panedwindow {
            set paned_window [FindPanedWindowHandlingPane .gid.central.s]
            if { $paned_window != "" } {
                $paned_window add .gid.central.wins -before .gid.central.s -stretch always -minsize 60
                $paned_window forget .gid.central.s
            }
        }
    }


    ttk::frame .gid.central.wins.graphwin1 -style groove.TFrame -borderwidth 2
    grid .gid.central.s -in .gid.central.wins.graphwin1 -sticky nsew
    .gid.central.s configure -width 0 -height 0

    raise .gid.central.s

    grid .gid.central.wins.graphwin1 -sticky nsew
    grid rowconfigure .gid.central.wins.graphwin1 0 -weight 1
    grid columnconfigure .gid.central.wins.graphwin1 0 -weight 1

    grid rowconfigure .gid.central.wins 0 -weight 1
    grid columnconfigure .gid.central.wins 0 -weight 1
}

proc CreateNewToglWindow { type parent } {
    global GidPriv

    set type [string toupper $type]

    if { $parent != "" } {
        if { ![winfo exists $parent] } {
            WarnWinText "parent widget $parent not exists"
            return ""
        }
        set w $parent
    } else {
        if { ![winfo exists .gid.central.wins] } {
            PrepareToglForSeveralWindows
        }
        if { $type == "EXT" } {
            set i 6
        } else {
            set i 2
        }
        while { [winfo exists .gid.central.wins.graphwin$i] } { 
            incr i 
        }
        set w .gid.central.wins.graphwin$i
        if { $type == "EXT" } {
            # "" 0 0 <- para permitir que se ponga debajo ( y no la haga transient)
            set geomname NewWindow${i}WindowGeom
            #InitWindow $w [_ "View %s" $i] $geomname [list after idle GiD_Process 'NewWin EXT] "" 0 0
            # here should be ?-ontop 0?
            InitWindow2 $w -title [_ "View %s" $i] -geometryvariable $geomname \
                -initcommand [list GiD_Project set windows_layout EXT] -ontop
            
            if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
            if { ![info exists ::GidPriv($geomname)] } {
                wm geometry $w "320x240+100+100"
            }
            bind $w <Escape> "GiD_Process escape"       
            bind $w <${::acceleratorKey}-a> SelectJoinOrNoJoin
            #bind $w <${::acceleratorKey}-h> SelectionOnlyVisibleOrAll
            
            
            set w $w.f
            ttk::frame $w -style groove.TFrame -borderwidth 2
            pack $w -expand 1 -fill both
        } else {
            ttk::frame $w -style groove.TFrame -borderwidth 2
            #PackToglWindows $type
        }
    }

    set togl $w.s
    CreateNewToglGID $togl 1    
    $togl configure -width 0 -height 0 ;#if not set gid_togl some -width -height then grid or pack sizes are wrong with multiple windows   
   
    grid $togl -sticky nsew
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
         
    GiDSetBindingsTogl $togl

    bind $w <${::acceleratorKey}-a> SelectJoinOrNoJoin
    #bind $w <${::acceleratorKey}-h> SelectionOnlyVisibleOrAll
    foreach i [bind .gid] {
        bind $w $i [bind .gid $i]
    }
   
    if { $::tcl_platform(os) == "Darwin" } {
        # in Darwin ( Mac OS X) Drag and Drop events are not inherited and are assigned to final widget's
        register_dnd_event $togl
    }

    SetButtonMeaning $togl

    return $w
}


# to initialize
set GidHelp(HelpSystemActive) ""
set GidHelp(helpcanceller) ""
set GidPriv(JustHelpActived) 0
set GidHelp(HelpLeaveBefore) ""
set GidHelp(JustDeleted) ""
set GidPriv(HelpSystem) .gid.helpsystem
set GidPriv(HelpSystemmenu) 0


proc DisplayGidHelpMenu { w text type xbase ybase } {
    global GidHelp
    
    after cancel $GidHelp(helpcanceller)
    set GidHelp(helpcanceller) ""

    if { $GidHelp(HelpLeaveBefore) != "" } {
        bind $w <Leave> $GidHelp(HelpLeaveBefore)
    }
    set GidHelp(HelpLeaveBefore) ""

    set x $xbase ; set y $ybase

    catch { destroy .gid.__helpmenu }
    menu .gid.__helpmenu
    set UnderLineList {}
    set lbl [_ "Help"]
    set under [FindUnderChar lbl UnderLineList]
    .gid.__helpmenu add command -label $lbl -underline $under -command \
        [list PopupTransparentInfo $text $xbase $ybase $w 0 -1]
        #[list DisplayGidHelp $w $text menu $xbase $ybase]
    if { $type == "helpandtools" } {
        set lbl [_ "Configure toolbars"]
        set under [FindUnderChar lbl UnderLineList]
        .gid.__helpmenu add command -label $lbl -underline $under -command TOBegin
        set msg [_ "Change appearance"]
        set under [FindUnderChar msg UnderLineList]
        .gid.__helpmenu add command -label $msg -underline $under -command \
            [ list PreferencesWindow graphical]

        set msg [_ "Bring up all windows"]
        set under [ FindUnderChar msg UnderLineList]
        .gid.__helpmenu add command -label $msg -underline $under -command \
            BringUpAllGiDWindows
    }
    GiD_PopupMenu .gid.__helpmenu $x $y
}

proc DisplayGidHelpLeave { w x y { force no } } {
    global GidPriv GidHelp

    if ![winfo exists $w] {
        return
    }
    if { $force == "no" && $x >= [winfo rootx $w] && $y >= [winfo rooty $w] && \
             $x <= [expr [winfo rootx $w]+[winfo width $w]] && \
             $y <= [expr [winfo rooty $w]+[winfo height $w]] } {
        return
    }

    if { [winfo exists $GidPriv(HelpSystem)] } {
        if { $force == "no" && $x >= [winfo rootx $GidPriv(HelpSystem)] && $y >= \
                 [winfo rooty $GidPriv(HelpSystem)] && \
                 $x <= [expr [winfo rootx $GidPriv(HelpSystem)]+[winfo width $GidPriv(HelpSystem)]] && \
                 $y <= [expr [winfo rooty $GidPriv(HelpSystem)]+[winfo height $GidPriv(HelpSystem)]] } {
            return
        }
    }


    bind all <Motion> ""

    after cancel $GidHelp(helpcanceller)
    set GidHelp(helpcanceller) ""

    if { [winfo exists $GidPriv(HelpSystem)] } {
        set GidPriv(JustHelpActived) 1
        after 1000 set GidPriv(JustHelpActived) 0
    }

    if { !$GidPriv(HelpSystemmenu) } {
        catch { destroy $GidPriv(HelpSystem)}
    }
    if { $GidHelp(HelpLeaveBefore) != "" } {
        bind $w <Leave> $GidHelp(HelpLeaveBefore)
    }
    set GidHelp(HelpLeaveBefore) ""
    after cancel set GidHelp(JustDeleted) ""

    if { $force == "no" } {
        set GidHelp(JustDeleted) $w
    } else {
        set GidHelp(JustDeleted) all
    }
    after 3000 "set GidHelp(JustDeleted) {}"
}

proc DisplayGidHelpLauncher { w x y text } {
    global GidPriv GidHelp

    #if { $GidHelp(JustDeleted) == $w || $GidHelp(JustDeleted) == "all" } { return }

    if { $GidPriv(JustHelpActived) } {
        DisplayGidHelp $w $text enter $x $y
    }

    if { [winfo exists $GidPriv(HelpSystem)] } {
        DisplayGidHelp $w $text enter $x $y
    } else {
        after cancel $GidHelp(helpcanceller)
        set GidHelp(helpcanceller) [after 1500 DisplayGidHelp $w [ list $text] enter $x $y]
    }
    #set GidHelp(HelpLeaveBefore) [bind $w <Leave>]

    bind all <Motion> "DisplayGidHelpLeave $w %X %Y"
    #bind $w <Leave> "$GidHelp(HelpLeaveBefore) ; DisplayGidHelpLeave $w"
    bind $w <ButtonPress-1> "+DisplayGidHelpLeave $w %X %Y yes"
}

proc GidHelpL { wlist type args } {
    set text [join $args]

    foreach w $wlist {
        set tag ""
        if { [llength $w] == 2 } {
            set tag [lindex $w 1]
            set w [lindex $w 0]
        }
        if { ![winfo exists $w] } { continue }

        set haveimage 0
        catch {
            if { [$w cget -image] != "" } { set haveimage 1 }
        }
        catch {
            if { [$w cget -bitmap] != "" } { set haveimage 1 }
        }

        if { $haveimage } {
            if { $tag == "" } {        
                bind $w <Enter> "+DisplayGidHelpLauncher $w %X %Y [ list $text]"
                foreach i [winfo children $w] {
                    GidHelpL $i $type $text
                }
            } else {
                $w tag bind $tag <Enter> "+DisplayGidHelpLauncher $w %X %Y [ list $text]"
            }
        }

        if { $tag == "" } {
            # bind $w <ButtonPress-$::gid_central_button> \
                               #                   "[ list DisplayGidHelpMenu $w $text $type %X %Y]; break"
            bind $w <ButtonPress-$::gid_right_button> \
                "[ list DisplayGidHelpMenu $w $text $type %X %Y]; break"
            foreach i [winfo children $w] {
                GidHelpL $i $type $text
            }
        } else {
            # $w tag bind $tag <ButtonPress-$::gid_central_button> \
                    #                   "[ list DisplayGidHelpMenu $w $text $type %X %Y]; break"
            $w tag bind $tag <ButtonPress-$::gid_right_button> \
                "[ list DisplayGidHelpMenu $w $text $type %X %Y]; break"
        }
    }
}

#from GiD11.1.3d only mantained set dynamic_help_method bwidget (but in fact uses diferent helps)
#last version with dynamic_help_method gid_old and tooltip tclfileP.tcl 1.1346

#use always PopupTransparentInfo for rightbutton menu, option help (colors configuration on Postwidgets.tcl) 
#use showTooltip when [GiD_Set TooltipPopup]=="bottom" (colors configuration on Postwidgets.tcl)
#use DynamicHelp when [GiD_Set TooltipPopup]=="normal" (colors configuration on gid_themes.tcl DynamicHelp::configure)

package require textutil

proc GidHelp { wlist text { nottimepopup 0 } {type help}} {      
    if { $text == "" } {
        return
    }
    set tooltip_popup [GiD_Set TooltipPopup]
    foreach w $wlist {
        if { ![winfo exists $w] } {
            #WarnWinText "GidHelp $w not exists"
            continue
        }
        #preparing text to be displayed adjust each paragraph to line lenght 72
        set oldparagraphs [::textutil::splitx $text \n]
        set newparagraphs ""
        foreach para $oldparagraphs {
            lappend newparagraphs [::textutil::adjust $para -length 72]
        }
        set text [join $newparagraphs "\n"]
        #end preparing
            
        
        if { $tooltip_popup == "normal" && $nottimepopup == 0 } {
            DynamicHelp::add $w -type balloon -text $text               
        }
        if { $tooltip_popup == "bottom" && $nottimepopup == 0 } {
            setTooltip $w -text $text -delay 0 -bottom .gid
        }
                    
        #changed on GiD11.1.3d not working properlly
        bind $w <ButtonPress-$::gid_right_button> "[list DisplayGidHelpMenu $w $text $type %X %Y]; break"
        #set show_link 0
        #bind $w <ButtonPress-$::gid_right_button> [list PopupTransparentInfo $text %X %Y $w $show_link]
    }
}
proc HasGidHelp { w } {      
    set bindings [bind $w <ButtonPress-$::gid_right_button>]
    return [regexp DisplayGidHelpMenu* $bindings]
}

proc GidHelpT { wlist text } {
    GidHelp $wlist $text 0 helpandtools
}

#invoked by DisplayGidHelpMenu, that force show help with contextual Help menu
proc DisplayGidHelp { w text but x y } {
    #Warning could not have help!! 
    #    set oldtext [DynamicHelp::register $w -text]
    DynamicHelp::add $w -text $text        
    
    DynamicHelp::_show_help $w $w $x $y
    
    DynamicHelp::delete $w
    #DynamicHelp::add $w -text $oldtext
}


proc GidHelpRecursive { w args } {
    GidHelp $w [join $args]
    foreach i [winfo children $w] {
        GidHelpRecursive $i {*}$args
    }
}

# not used
proc NURBSSurfaceMove {} {
    global GidPriv
    set w .gid.nurbsurfmove

    InitWindow2 $w -title [_ "NURBS surface movement"] \
        -geometryvariable PreNURBSSurfaceMoveWindowGeom \
        -initcommand NURBSSurfaceMove
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0


    set GidPriv(NURBSsurfoldmove) 0
    gidscale $w.s -from -10 -to 10 -resolution 1 -showvalue 0 \
        -command NURBSSurfaceMoving -orient horizontal

    proc NURBSSurfaceMoving { val } {
        global GidPriv
        set incre [expr $val-$GidPriv(NURBSsurfoldmove)]
        GiD_Process normal=$incre
        set GidPriv(NURBSsurfoldmove) $val
    }
    
    ttk::button $w.b -text [_ "Reset slide"] -command "set GidPriv(NURBSsurfoldmove) 0 ; $w.s set 0" -style BottomFrame.TButton
    ttk::button $w.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton   

    grid $w.s -row 1 -column 1 -sticky ew
    grid $w.b -row 2 -column 1
    grid $w.close -row 2 -column 2
    grid columnconf $w 1 -weight 1


}
#NURBSSurfaceMove

proc PostGraphResultsFill { combo_anal combo_step combo_result frame_components type } {
    variable ViewMenuPriv

    if { ![winfo exists $combo_result] } { return }

    if { $type eq "anal" } {
        set all [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
        # set all [ GiD_Info postprocess get all_analysis]
        set curr [ GiD_Info postprocess get cur_analysis]
        
        set all_analysis {}
        set max_len 0
        set l 0
        foreach i $all {
            regsub -all {_} $i { } var
            lappend all_analysis $var
            set l [ string length $var]
            if { $l > $max_len} {
                set max_len $l
            }
        }
        $combo_anal configure -values $all_analysis
        if { $l > 20} {
            grid configure $combo_anal -sticky ew
        }
        if { $curr != "" } {
            regsub -all {_} $curr { } curr
        } else { regsub -all {_} [lindex $all 0] { } curr }
        set var [$combo_anal cget -textvariable]
        uplevel #0 [list set $var $curr]
        return
    } else {
        set var [$combo_anal cget -textvariable]
        set analisis [uplevel #0 [list set $var]]
        regsub -all { } $analisis {_} analisis
        if { [lsearch -exact [ GiD_Info postprocess get all_analysis] \
                  $analisis] == -1 } {
            set analisis [ GiD_Info postprocess get cur_analysis]
        }
    }

    if { $type eq "anal" || $type eq "step" } {
        if { $analisis ne ""} {
            # set all [ GiD_Info postprocess get all_steps $analisis]
            if { [ catch { set all [ GiD_Info postprocess get all_steps $analisis]}]} {
                set all {}
            }
            set current [ GiD_Info postprocess get cur_step $analisis]
            if { ( $current == "") || ( [ lsearch -exact $all $current] == -1) } {
                regsub -all {_} [lindex $all 0] { } current
            }
            $combo_step configure -values $all
            set var [$combo_step cget -textvariable]
            uplevel #0 [list set $var $current]
            $combo_step configure -state normal
            set step $current
        } else {
            $combo_step configure -values ""
            set var [$combo_step cget -textvariable]
            uplevel #0 [list set $var ""]
            $combo_step configure -state disabled
            set step ""
        }
        if { $type eq "step" } { return }
    } else {
        set var [$combo_step cget -textvariable]
        set step [uplevel \#0 [list set $var]]
        if { [ catch { set lst_step [ GiD_Info postprocess get all_steps $analisis]}]} {
            set lst_step {}
        }
        if { [lsearch -exact $lst_step $step] == -1 } {
            set step [ GiD_Info postprocess get cur_step $analisis]
        }
    }
    if { $analisis ne "" && $step ne "" } {
        set res [ lsort -dictionary [ GiD_Info postprocess get results_list Contour_Fill $analisis $step]]
        set var [$combo_result cget -textvariable]
        if { $res eq "" } {
            uplevel #0 [list set $var ""]
            $combo_result configure -values ""
            $combo_result configure -state disabled
            set result ""
        } else {
            set result [uplevel #0 [list set $var]]
            if { [lsearch -exact $res $result] == -1 } {
                set result [lindex $res 0]
                uplevel #0 [list set $var $result]
            }
            $combo_result configure -values $res
            $combo_result configure -state normal
        }
    } else {
        set result ""
        uplevel #0 [list set $var ""]
        $combo_result configure -values ""
        $combo_result configure -state disabled
    }
    foreach i [winfo children $frame_components] {
        catch { destroy $i }
    }
    if { $result eq "" } { return }
    set irow 1
    set componentes_txt [GiD_Info postprocess get components_list Contour_Fill $result $analisis $step]
    foreach i $componentes_txt {
        set ww [string tolower $i]$irow
        regsub -all {\.} $ww _ w
        regsub -all {_} $i { } comp
        ttk::radiobutton $frame_components.r$w -text $comp -value $i -variable ViewMenuPriv(border_comp)
        grid $frame_components.r$w -sticky nw -row $irow -column 1
        grid rowconf $frame_components $irow -weight 0
        incr irow
    }
    set ViewMenuPriv(border_comp) [lindex $componentes_txt 0]
    grid rowconf $frame_components $irow -weight 1
    grid columnconf $frame_components 1 -weight 1
    if { [ llength $componentes_txt] != 4} {
        set ViewMenuPriv(border_comp) [ lindex $componentes_txt 0]
    } else {
        set ViewMenuPriv(border_comp) [ lindex $componentes_txt 3]
    }
}

# Deprecated?
proc PostGraphResultsWindow { {w .gid.graph} } {
    global ViewMenuPriv

    InitWindow2 $w -title [_ "View graphs"] -geometryvariable PostGraphResultsWindowGeom \
        -initcommand PostGraphResultsWindow -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    #PostGraphResultsWindow
    #<- para abrir una window sin resultados?

    set cur_analysis [ GiD_Info postprocess get cur_analysis]

    ttk::labelframe $w.m1 -text [_ "graph type"]
    set m1 [ttk::frame $w.m1.m]
    pack $m1 -fill both -expand 1

    ttk::radiobutton $m1.r1 -text [_ "Line variation"] -variable ViewMenuPriv(border_graph_axX) \
        -value LineVariation
    ttk::radiobutton $m1.r2 -text [_ "X variation"] -variable ViewMenuPriv(border_graph_axX) \
        -value X_Variation
    ttk::radiobutton $m1.r3 -text [_ "Y variation"] -variable ViewMenuPriv(border_graph_axX) \
        -value Y_Variation
    ttk::radiobutton $m1.r4 -text [_ "Z variation"] -variable ViewMenuPriv(border_graph_axX) \
        -value Z_Variation

    set ViewMenuPriv(border_graph_axX) LineVariation

    grid $m1.r1 $m1.r2 -sticky w
    grid $m1.r3 $m1.r4 -sticky w

    ttk::labelframe $w.m2 -text [_ "result"]
    set m2 [ttk::frame $w.m2.m]
    pack $m2 -fill both -expand 1

    ttk::label $m2.l1 -text [_ "Analysis"]:
    if { ![info exists ViewMenuPriv(BG_PostResultsAnal)] } {
        set ViewMenuPriv(BG_PostResultsAnal) ""
    } 
    ComboBox $m2.am1 -textvariable ViewMenuPriv(BG_PostResultsAnal) -editable 0 -width 20 -borderwidth 1

    ttk::label $m2.lstep -text [_ "Step"]:
    if { ![info exists ViewMenuPriv(BG_PostResultsStep)] } {
        set ViewMenuPriv(BG_PostResultsStep) ""
    }
    ComboBox $m2.cbstep -textvariable ViewMenuPriv(BG_PostResultsStep) -editable 0 -width 8 -borderwidth 1

    ttk::label $m2.prr -text [_ "Result"]:
    if { ![info exists ViewMenuPriv(BG_PostResultsRes)] } {
        set ViewMenuPriv(BG_PostResultsRes) ""
    }
    ComboBox $m2.m2 -textvariable ViewMenuPriv(BG_PostResultsRes) -width 20 -editable 0

    grid $m2.l1 $m2.am1 $m2.lstep -sticky ew -pady 2
    grid $m2.prr $m2.m2 $m2.cbstep -sticky ew -pady 2
    grid columnconfigure $m2 1 -weight 1

    ttk::labelframe $w.fr -text [_ "components"] -height 100
    set fr [ttk::frame  $w.fr.m]
    pack $fr -fill both -expand 1

    #    ttk::frame $w.fr -borderwidth 2 -style ridge.TFrame -height 100

    set cmd [list PostGraphResultsFill $m2.am1 $m2.cbstep $m2.m2 $fr]
    foreach "n t" [list BG_PostResultsAnal step BG_PostResultsStep result \
                       BG_PostResultsRes components] {
        trace add variable ViewMenuPriv($n) write "$cmd $t;#"
        bind $fr <Destroy> [list trace remove variable \
                                ViewMenuPriv($n) write "$cmd $t;#"]
    }
    eval $cmd anal

    #     if { ( $res != "-No results-") && ( $res != "") } {
    #         set cmd "AddComponentsToMenu $m2 $fr ;#"
    #         trace add variable ViewMenuPriv(border_graph_axY) write $cmd
    #         set ViewMenuPriv(border_graph_axY) [lindex $res 0]
    #         bind $fr <Destroy> [list trace remove variable \
        #                 ViewMenuPriv(border_graph_axY) write $cmd]
    #     }
    ttk::frame $w.buts -style BottomFrame.TFrame   

    ttk::button $w.buts.b0 -text [_ "Select 2 points"] -style BottomFrame.TButton \
        -command [list ViewGraphs:BorderGraphTwoPointsInternal $w.buts]
    ttk::button $w.buts.b -text [_ "Select border"] -style BottomFrame.TButton -command [list ViewGraphs:SelectBorder $w.buts]
    focus $w.buts.b
    
    ttk::menubutton $w.buts.mopt -text [_ "Actions"] -width 10 -menu $w.buts.mopt.m \
        -image [gid_themes::GetImage ArrowDown.png small_icons] \
        -compound right
    menu $w.buts.mopt.m
    set UnderLineList {}
    set text [_ "Draw graphs"]
    set under [FindUnderChar text UnderLineList]
    $w.buts.mopt.m add command -label $text -underline $under -command {
        GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs yes
    }
    set text [_ "No draw graphs"]
    set under [FindUnderChar text UnderLineList]
    $w.buts.mopt.m add command -label $text -underline $under -command {
        GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs No
    }
    set text [_ "Clear graphs"]
    set under [FindUnderChar text UnderLineList]
    $w.buts.mopt.m add command -label $text -underline $under -command {
        GiD_Process Mescape Results Graphs OptionsGraph ClearGraphs
    }

    ttk::button $w.buts.close -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w]
    
    # necessary as it is a compound
    $w.buts.mopt configure -width 50

    grid $w.buts.b0 $w.buts.b $w.buts.mopt $w.buts.close -padx 3 -pady 3


    grid $w.m1 -sticky nwe -row 1 -column 1
    grid $w.m2 -sticky nwe -row 2 -column 1
    grid $w.fr -sticky nsew -row 3 -column 1
    grid $w.buts -sticky nwe -row 5 -column 1
    grid anchor $w.buts center
    grid rowconf $w 3 -weight 1
    grid columnconf $w 1 -weight 1
}

proc ViewGraphs:SelectBorder { frame } {
    global ViewMenuPriv

    if {[info exists ViewMenuPriv(border_comp)]} {
        regsub -all { } $ViewMenuPriv(BG_PostResultsAnal) {_} analysis
        GiD_Process escape escape escape escape Results AnalysisSel \
            $analysis $ViewMenuPriv(BG_PostResultsStep)

        GiD_Process escape escape escape escape results graphs \
            bordergraph $ViewMenuPriv(border_graph_axX) \
            $ViewMenuPriv(BG_PostResultsRes) $ViewMenuPriv(border_comp)
        set SmallWinSelecting [ GiD_Set SmallWinSelecting]
        FinishButton [winfo toplevel $frame] $frame \
            [_ "Press 'Finish' to end selection"] \
            "" disableall $SmallWinSelecting
    }
}

proc ViewGraphs:BorderGraphTwoPointsInternal { frame } {
    global ViewMenuPriv
    if {[info exists ViewMenuPriv(border_comp)]} {
        GiD_Process escape escape escape escape results graphs linegraph \
            $ViewMenuPriv(BG_PostResultsRes) $ViewMenuPriv(border_comp)
        
        set SmallWinSelecting [ GiD_Set SmallWinSelecting]
        FinishButton [winfo toplevel $frame] $frame \
            [_ "Press 'Finish' to end selection"] \
            "" disableall $SmallWinSelecting
    }
}

#obsolete proc using auxiliary tcl commands, best use BorderGraphTwoPointsInternal
proc ViewGraphs:BorderGraphTwoPoints {} {
    variable ViewMenuPriv

    if {![info exists ViewMenuPriv(border_comp)]} { return }

    if { [ GiD_Info project ViewMode] == "GRAPHUSE" } {
        GiD_Process escape escape Results Graphs OptionsGraph ShowGraphs No
    }
    set p1 [ GidUtils::GetCoordinates [_ "Enter first point (ESC to leave)"]]
    if { $p1=="" } return
    set p2 [ GidUtils::GetCoordinates [_ "Enter second point (ESC to leave)"]]
    if { $p2=="" } return

    if { [MathUtils::VectorDistance $p1 $p2] < $MathUtils::EPSILON } {
        WarnWin [_ "Points cannot be the same"]
        return
    }
    set v1 [MathUtils::VectorDiff $p1 $p2]
    if { [lindex $v1 0] != 0.0 || [lindex $v1 1] != 0.0 } {
        set p3 [MathUtils::VectorSum $p1 [list [expr {-1*[lindex $v1 1]}] \
                                              [lindex $v1 0] 0.0]]
    } else {
        set p3 [list [lindex $v1 2] 0 0]
    }
    set n [MathUtils::VectorVectorialProd [MathUtils::VectorDiff $p2 $p1] \
               [MathUtils::VectorDiff $p3 $p1]]
    set p4 [MathUtils::VectorSum $p1 $n]

    set old_cuts [ GiD_Info postprocess get all_cutsets]
    set old_surfacesets [ GiD_Info postprocess get all_surfacesets]
    set old_volumesets [ GiD_Info postprocess get all_volumesets]

    GidUtils::WaitState
    GidUtils::DisableGraphics

    if { $old_volumesets != "" } {
        ################################################################################
        #    First cut
        ################################################################################

        GiD_Process escape escape escape escape DoCut CutPlane ThreePoints $p1 $p2 $p3
        GiD_Process escape escape escape escape DoCut ConvertToSets ALL_CUTSETS

        set newsets ""
        foreach set [ GiD_Info postprocess get all_surfacesets] {
            if { [lsearch -exact $old_surfacesets $set] == -1 } {
                lappend newsets $set
            }
        }
        
        ################################################################################
        #    Delete 2nd cuts
        ################################################################################
        
        set cmd [list GiD_Process escape escape escape escape \
                     Utilities Delete CutSets]
        foreach cut [ GiD_Info postprocess get all_cutsets] {
            if { [lsearch -exact $old_cuts $cut] == -1 } {
                lappend cmd $cut yes
            }
        }
        lappend cmd escape
        eval $cmd
        
        ################################################################################
        #    Sets to off and on
        ################################################################################
        
        set active_vols [ GiD_Info postprocess get cur_volumesets]
        set active_surfs [ GiD_Info postprocess get cur_surfacesets]
        
        set cmd [list GiD_Process escape escape escape escape select \
                     VolumeSets]
        eval lappend cmd $active_vols
        lappend cmd escape
        eval $cmd
        
        set cmd [list GiD_Process escape escape escape escape select \
                     SurfaceSets]
        foreach surf $active_surfs {
            if { [lsearch -exact $newsets $surf] == -1 } {
                lappend cmd $surf
            }
        }
        foreach surf $newsets {
            if { [lsearch -exact $active_surfs $surf] == -1 } {
                lappend cmd $surf
            }
        }
        lappend cmd escape
        eval $cmd

        ################################################################################
        #    Second cut
        ################################################################################
        
        GiD_Process escape escape escape escape DoCut CutPlane ThreePoints $p1 $p2 $p4
        GiD_Process escape escape escape escape DoCut ConvertToSets ALL_CUTSETS
        
        ################################################################################
        #    Delete 2nd cuts
        ################################################################################
        
        set cmd [list GiD_Process escape escape escape escape \
                     Utilities Delete CutSets]
        foreach cut [ GiD_Info postprocess get all_cutsets] {
            if { [lsearch -exact $old_cuts $cut] == -1 } {
                lappend cmd $cut yes
            }
        }
        lappend cmd escape
        eval $cmd
        
        ################################################################################
        #    Delete surface sets
        ################################################################################
        
        set cmd [list GiD_Process escape escape escape escape \
                     Utilities Delete SurfaceSets]
        foreach set $newsets {
            lappend cmd $set yes
        }
        lappend cmd escape
        eval $cmd
        
        ################################################################################
        #    Activate created surface sets and rename
        ################################################################################
        
        set allsets [ GiD_Info postprocess get all_surfacesets]
        set newsets ""
        foreach set [ GiD_Info postprocess get all_surfacesets] {
            if { [lsearch -exact $old_surfacesets $set] == -1 } {
                set idx ""
                while { [lsearch -exact $allsets S_border_graph$idx] != -1 } {
                    if { $idx eq "" } { set idx 2 } else { incr idx }
                }
                set newname border_graph$idx
                GiD_Process escape escape escape escape Utilities ChangeName \
                    SurfaceSets $set $newname
                lappend newsets S_$newname
                lappend active_surfs S_$newname
            }
        }
        
        ################################################################################
        #    Leave activated sets as they were
        ################################################################################
        
        set active_vols_new [ GiD_Info postprocess get cur_volumesets]
        set active_surfs_new [ GiD_Info postprocess get cur_surfacesets]
        
        set cmd [list GiD_Process escape escape escape escape select \
                     VolumeSets]
        foreach vol [ GiD_Info postprocess get all_volumesets] {
            if { [lsearch -exact $active_vols_new $vol] == -1 && \
                     [lsearch -exact $active_vols $vol] != -1} {
                lappend cmd $vol
            }
        }
        eval $cmd
        
        set cmd [list GiD_Process escape escape escape escape select \
                     SurfaceSets]
        foreach surf [ GiD_Info postprocess get all_surfacesets] {
            if { [lsearch -exact $active_surfs_new $surf] == -1 && \
                     [lsearch -exact $active_surfs $surf] != -1} {
                lappend cmd $surf
            }
        }
        lappend cmd escape
        eval $cmd
    } elseif { $old_surfacesets != "" } {
        # create cut
        GiD_Process escape escape escape escape DoCut CutPlane $p1 $p2
        # convert to new set
        GiD_Process escape escape escape escape DoCut ConvertToSets ALL_CUTSETS
        set newsets ""
        foreach set [ GiD_Info postprocess get all_surfacesets] {
            if { [lsearch -exact $old_surfacesets $set] == -1 } {
                lappend newsets $set
            }
        }
        # delete cut
        set cmd ""
        foreach cut [ GiD_Info postprocess get all_cutsets] {
            if { [lsearch -exact $old_cuts $cut] == -1 } {
                lappend cmd $cut yes
            }
        }
        GiD_Process Mescape Utilities Delete CutSets {*}$cmd escape
        #set set to on (by default, when converting cut, are off!!)
        GiD_Process Mescape select SurfaceSets {*}$newsets escape
    } else {
        set newsets ""
    }
    ################################################################################
    #    bye bye
    ################################################################################
    GidUtils::EnableGraphics
    GidUtils::EndWaitState
    GiD_Redraw
    if { $newsets != "" } {
        regsub -all { } $ViewMenuPriv(BG_PostResultsAnal) {_} analysis
        GiD_Process escape escape escape escape Results AnalysisSel \
            $analysis $ViewMenuPriv(BG_PostResultsStep)
        eval [list GiD_Process escape escape escape escape results graphs \
                  bordergraph $ViewMenuPriv(border_graph_axX) \
                  $ViewMenuPriv(BG_PostResultsRes) $ViewMenuPriv(border_comp)] \
            $newsets escape

        #delete new sets
        GiD_Process Mescape Utilities Delete SurfaceSets {*}$newsets yes escape
    } else {
        GidUtils::SetWarnLine [_ "Any volume or surface set does exist to create the graph"]
    }
}


proc PostContLimitsIncr { } {
    global GidPriv

    set GidPriv(PostContLimitsUserMin) [ format "%g" [ expr $GidPriv(PostContLimitsUserMin) - $GidPriv(PostContLimitsUserDiv)]]
    set GidPriv(PostContLimitsUserMax) [ format "%g" [ expr $GidPriv(PostContLimitsUserMax) + $GidPriv(PostContLimitsUserDiv)]]
}

proc PostContLimitsDecr { } {
    global GidPriv

    if { [ expr $GidPriv(PostContLimitsUserMax) - $GidPriv(PostContLimitsUserMin)] > \
             [ expr 2.0 * $GidPriv(PostContLimitsUserDiv)] } {
        set GidPriv(PostContLimitsUserMin) [ format "%g" [ expr $GidPriv(PostContLimitsUserMin) + $GidPriv(PostContLimitsUserDiv)]]
        set GidPriv(PostContLimitsUserMax) [ format "%g" [ expr $GidPriv(PostContLimitsUserMax) - $GidPriv(PostContLimitsUserDiv)]]
    }
}

proc PostContLimitsReset { } {
    global GidPriv

    set GidPriv(PostContLimitsUserMin) [ format "%g" [ lindex $GidPriv(PostContLimitsOrgLimits) 0]]
    set GidPriv(PostContLimitsUserMax) [ format "%g" [ lindex $GidPriv(PostContLimitsOrgLimits) 1]]
}

proc PostContLimitsInitVariables {} {
    global GidPriv

    if { ![ info exists GidPriv(PostContLimitsApplying)]} {
        set GidPriv(PostContLimitsApplying) 0
    }

    if { !$GidPriv(PostContLimitsApplying)} {
        set GidPriv(PostContLimitsOrgLimits) [ GiD_Info postprocess get cur_contour_limits]
        set GidPriv(PostContLimitsUserMin) [ format "%g" [ lindex $GidPriv(PostContLimitsOrgLimits) 0]]
        set GidPriv(PostContLimitsUserMax) [ format "%g" [ lindex $GidPriv(PostContLimitsOrgLimits) 1]]
        set GidPriv(PostContLimitsUserDiv) [ expr ( $GidPriv(PostContLimitsUserMax) - \
                                                        $GidPriv(PostContLimitsUserMin)) * 0.05]

        set pp [ lindex [ GiD_Info postprocess get contour_limits] 0]
        set GidPriv(PostContLimitsUseMax) 0
        set GidPriv(PostContLimitsUseMin) 0
        if { [lindex $pp 0] == "USER" } {
            set GidPriv(PostContLimitsUseMin) 1
            if { [ info exists GidPriv(PostContLimitsWindow)] && \
                     [ winfo exists $GidPriv(PostContLimitsWindow).f.emin] } {
                $GidPriv(PostContLimitsWindow).f.emin configure -state normal -foreground black
            }
        }
        if { [lindex $pp 2] == "USER" } {
            set GidPriv(PostContLimitsUseMax) 1
            if { [ info exists GidPriv(PostContLimitsWindow)] && \
                     [ winfo exists $GidPriv(PostContLimitsWindow).f.emax] } {
                $GidPriv(PostContLimitsWindow).f.emax configure -state normal -foreground black
            }
        }
    }
}

proc PostContLimitsApply {} {
    global GidPriv

    set cur_res [ GiD_Info postprocess get cur_result]
    set cur_res_view  [ GiD_Info postprocess get cur_results_view]
    set cur_comp [ GiD_Info postprocess get cur_component]
    regsub -all {_} $cur_res_view {} tipo_contour

    if { ( $cur_res_view == "Contour_Fill") || ( $cur_res_view == "Smooth_Contour_Fill") || \
             ( $cur_res_view == "Contour_Lines") || ( $cur_res_view == "Smooth_Contour_Lines") || \
             ( $cur_res_view == "Display_Vectors") } {
        set GidPriv(PostContLimitsApplying) 1
        GiD_Process Mescape results contoptions
        if { $GidPriv(PostContLimitsUseMin) } {
            GiD_Process setminoptions setvalue $GidPriv(PostContLimitsUserMin)
        } else {
            GiD_Process setminoptions resetvalue escape
        }

        if { $GidPriv(PostContLimitsUseMax) } {
            GiD_Process setmaxoptions setvalue $GidPriv(PostContLimitsUserMax)
        } else {
            GiD_Process setmaxoptions resetvalue escape
        }
        GiD_Process escape $tipo_contour $cur_res $cur_comp
        set GidPriv(PostContLimitsApplying) 0
    }
}

proc PostContLimitsCloseWin { w } {
    global GidPriv
    set GidPriv(PostContLimitsHistoryMin) [ [ $w.f.emin cget list] get 0 end]
    set GidPriv(PostContLimitsHistoryMax) [ [ $w.f.emax cget list] get 0 end]
    destroy $w
}

proc PostContLimitsWin { { w .gid.wPostContLim} { solo 1}} {
    global GidPriv

    if { $solo} {
        InitWindow2 $w -title [_ "Contour Limits"] \
            -geometryvariable PostContLimitsWindowGeom \
            -initcommand PostContLimitsWin -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    }

    if { $solo} {
        set GidPriv(PostContLimitsWindow) $w
    }

    ttk::frame $w.f -style ridge.TFrame -borderwidth 2    
    if { ![info exists GidPriv(PostContLimitsUseMax)] } { set GidPriv(PostContLimitsUseMax) 0 }
    ttk::checkbutton $w.f.lmax -text [_ "Max"]: -variable GidPriv(PostContLimitsUseMax) -command {
        if { $GidPriv(PostContLimitsUseMax)} {
            $GidPriv(PostContLimitsWindow).f.emax configure -state normal -foreground black
        } else {
            $GidPriv(PostContLimitsWindow).f.emax configure -state disabled -foreground grey60
        }
    }    
    if { ![info exists GidPriv(PostContLimitsHistoryMax)] } {
        set GidPriv(PostContLimitsHistoryMax) ""
    }
    combobox $w.f.emax -width 11 -borderwidth 1 -textvariable GidPriv(PostContLimitsUserMax) \
        -editable 1 -keephistory 1 -history $GidPriv(PostContLimitsHistoryMax)  
    if { ![info exists GidPriv(PostContLimitsUseMin)] } { set GidPriv(PostContLimitsUseMin) 0 }
    ttk::checkbutton $w.f.lmin -text [_ "Min"]: -variable GidPriv(PostContLimitsUseMin) -command {
        if { $GidPriv(PostContLimitsUseMin)} {
            $GidPriv(PostContLimitsWindow).f.emin configure -state normal -foreground black
        } else {
            $GidPriv(PostContLimitsWindow).f.emin configure -state disabled -foreground grey60
        }
    }   
    if { ![info exists GidPriv(PostContLimitsHistoryMin)] } {
        set GidPriv(PostContLimitsHistoryMin) ""
    }
    combobox $w.f.emin -width 11 -borderwidth 1 -textvariable GidPriv(PostContLimitsUserMin) \
        -editable 1 -keephistory 1 -history $GidPriv(PostContLimitsHistoryMin)

    ttk::frame $w.f.fi
    ttk::button $w.f.fi.bmas -text + -command PostContLimitsIncr     
    ttk::button $w.f.fi.breset -text o -command PostContLimitsReset       
    ttk::button $w.f.fi.bmenos -text - -command PostContLimitsDecr       
    grid $w.f.fi.bmas -row 0 -column 0 -padx 3 -sticky news
    grid $w.f.fi.breset -row 1 -column 0 -padx 3 -sticky news
    grid $w.f.fi.bmenos -row 2 -column 0 -padx 3 -sticky news

    if { $solo} {
        ttk::frame $w.but -style BottomFrame.TFrame
        ttk::button $w.but.accept -text [_ "Apply"] -style BottomFrame.TButton -command PostContLimitsApply
        ttk::button $w.but.close -text [_ "Close"] -style BottomFrame.TButton -command [list PostContLimitsCloseWin $w]
    }

    grid $w.f.lmax $w.f.emax
    grid $w.f.lmin $w.f.emin
    grid $w.f.fi -row 0 -column 2 -rowspan 2
    grid $w.f
    
    
    if { $solo} {
        grid $w.but.accept $w.but.close -padx 4 -pady 2
        grid $w.but -sticky nsew -column 0 -row 2
        grid anchor $w.but center
        
        grid columnconfigure $w 0 -weight 1
        grid rowconfigure $w 1 -weight 1
    }

    set GidPriv(PostContLimitsApplying) 0
    PostContLimitsInitVariables
    $w.f.emax configure -state disabled -foreground grey60
    $w.f.emin configure -state disabled -foreground grey60

    if { $solo} {
        bind $w <Return> PostContLimitsApply
    }

}

proc PostContLimitsApplyMinEntry { w } {
    global GidPriv
    set err 0

    if { $GidPriv(PostContLimitsUserMin) != "" } {
        set err [ catch { format "%g" $GidPriv(PostContLimitsUserMin) } ]
        if { !$err} {
            set cur_res [ GiD_Info postprocess get cur_result]
            set cur_res_view  [ GiD_Info postprocess get cur_results_view]
            set cur_comp [ GiD_Info postprocess get cur_component]
            regsub -all {_} $cur_res_view {} tipo_contour
            
            if { ( $cur_res_view == "Contour_Fill") || ( $cur_res_view == "Smooth_Contour_Fill") || \
                     ( $cur_res_view == "Contour_Lines") || ( $cur_res_view == "Smooth_Contour_Lines") || \
                     ( $cur_res_view == "Display_Vectors") } {
                #set GidPriv(PostContLimitsApplying) 1
                GiD_Process Mescape results contoptions setminoptions setvalue $GidPriv(PostContLimitsUserMin)
                #        escape $tipo_contour $cur_res $cur_comp
                #GiD_Process Mescape results \
                    #         contoptions setminoptions resetvalue escape
                GiD_Process Mescape Utilities Redisplay escape escape
                #PostContLimitsInitVariables
                #set GidPriv(PostContLimitsApplying) 0
            }
        } else {
            WarnWin [_ "A Numerical value must be entered."]
        }
    }

    #WarnWin "$GidPriv(PostContLimitsUserMin) - $err"
    if { !$err} {
        set GidPriv(PostContLimitsHistoryMin) [ [ $w.f.emin cget list] get 0 end]
        destroy $w
        #focus .gid
    }
}

proc PostContLimitsMinEntry { w} {
    global GidPriv
    
    set x [ winfo x $w]
    set y [ winfo y $w]
    set wi [ winfo width $w]
    set w [ winfo parent $w]
    while { $w != "" } {
        set xp [ winfo x $w]
        set yp [ winfo y $w]
        set x [ expr $x + $xp]
        set y [ expr $y + $yp + 16]
        if { "[ winfo class $w]" == "Toplevel"} {
            break
        }
        set w [ winfo parent $w]
    }
    set x [expr $x + $wi+8]
    set y [expr $y + 16]   

    toplevel .wPostLimMin
    wm geometry .wPostLimMin +$x+$y
    wm title .wPostLimMin [_ "Minimum"]
    wm minsize .wPostLimMin 1 1
    wm overrideredirect .wPostLimMin 1

    ttk::frame .wPostLimMin.f -style ridge.TFrame -borderwidth 2
    if { ![info exists GidPriv(PostContLimitsHistoryMin)] } {
        set GidPriv(PostContLimitsHistoryMin) ""
    }
    combobox .wPostLimMin.f.emin -width 11 -borderwidth 1 -textvariable GidPriv(PostContLimitsUserMin) \
        -editable 1 -keephistory 1 -history $GidPriv(PostContLimitsHistoryMin)

    set limites_org [ GiD_Info postprocess get cur_contour_limits]
    set GidPriv(PostContLimitsUserMin) [ format "%g" [ lindex $limites_org 0]]
    .wPostLimMin.f.emin sel to end

    bind .wPostLimMin <Return> "PostContLimitsApplyMinEntry .wPostLimMin"
    bind .wPostLimMin <Escape> "destroy .wPostLimMin"
    bind .wPostLimMin <1> "+PostCloseFLoatingWindow %W %x %y"

    
    ttk::button .wPostLimMin.f.b  -image [gid_themes::GetImage close.png] -command [list destroy .wPostLimMin]

    #grid .wPostLimMin.f.emin .wPostLimMin.f.b
    grid .wPostLimMin.f.emin -padx 2 -pady 1
    grid .wPostLimMin.f.b -column 1 -row 0 -padx 1 -pady 1

    grid .wPostLimMin.f
    focus -force .wPostLimMin.f.emin
    #raise .wPostLimMin .gid
    update
    grab .wPostLimMin

}

proc PostContLimitsApplyMaxEntry { w }  {
    global GidPriv
    set err 0
    if { $GidPriv(PostContLimitsUserMax) != "" } {
        set err [ catch { format "%g" $GidPriv(PostContLimitsUserMax) } ]
        if { !$err} {
            set cur_res [ GiD_Info postprocess get cur_result]
            set cur_res_view  [ GiD_Info postprocess get cur_results_view]
            set cur_comp [ GiD_Info postprocess get cur_component]
            regsub -all {_} $cur_res_view {} tipo_contour
            if { ( $cur_res_view == "Contour_Fill") || ( $cur_res_view == "Smooth_Contour_Fill") || \
                     ( $cur_res_view == "Contour_Lines") || ( $cur_res_view == "Smooth_Contour_Lines") || \
                     ( $cur_res_view == "Display_Vectors") } {                
                GiD_Process Mescape results contoptions setmaxoptions setvalue $GidPriv(PostContLimitsUserMax)
                GiD_Process Mescape Utilities Redisplay escape escape
            }
        } else {
            WarnWin [_ "A Numerical value must be entered."]
        }
    }
    if { !$err} {
        set GidPriv(PostContLimitsHistoryMax) [ [ $w.f.emax cget list] get 0 end]
        destroy $w
    }
}

proc PostContLimitsMaxEntry { w } {
    global GidPriv
    set x [ winfo x $w]
    set y [ winfo y $w]
    set wi [ winfo width $w]
    set w [ winfo parent $w]
    while { $w != "" } {
        set xp [ winfo x $w]
        set yp [ winfo y $w]
        set x [ expr $x + $xp]
        set y [ expr $y + $yp + 16]
        if { "[ winfo class $w]" == "Toplevel"} {
            break
        }
        set w [ winfo parent $w]
    }
    set x [expr $x + $wi]
    set y [expr $y + 16]

    toplevel .wPostLimMax
    wm geometry .wPostLimMax +$x+$y
    wm title .wPostLimMax [_ "Maximum"]
    wm minsize .wPostLimMax 1 1
    wm overrideredirect .wPostLimMax 1

    ttk::frame .wPostLimMax.f -style ridge.TFrame -borderwidth 2
    if { ![info exists GidPriv(PostContLimitsHistoryMax)] } {
        set GidPriv(PostContLimitsHistoryMax) ""
    }
    combobox .wPostLimMax.f.emax -width 11 -borderwidth 1 -textvariable GidPriv(PostContLimitsUserMax) \
        -editable 1 -keephistory 1 -history $GidPriv(PostContLimitsHistoryMax)

    set limites_org [ GiD_Info postprocess get cur_contour_limits]
    set GidPriv(PostContLimitsUserMax) [ format "%g" [ lindex $limites_org 1]]
    .wPostLimMax.f.emax sel to end

    bind .wPostLimMax <Return> "PostContLimitsApplyMaxEntry .wPostLimMax"
    bind .wPostLimMax <Escape> "destroy .wPostLimMax"
    bind .wPostLimMax <1> "+PostCloseFLoatingWindow %W %x %y"

    ttk::button .wPostLimMax.f.b -image [gid_themes::GetImage close.png] -command [list destroy .wPostLimMax]

    grid .wPostLimMax.f.emax -padx 2 -pady 1
    grid .wPostLimMax.f.b -column 1 -row 0 -padx 1 -pady 1
    grid .wPostLimMax.f
    focus -force .wPostLimMax.f.emax
    #raise .wPostLimMax .gid
    update
    grab .wPostLimMax

}

proc PostCloseFLoatingWindow { w x y } {
    if { $x < 0 || $y < 0 || $x > [winfo width $w] || $y > [winfo height $w] } {
        destroy $w
    }
}

proc IconoBotonLogSwitch { } {
    array set options [ GiD_Info postprocess get scale_result_options]

    set img [ gid_themes::GetImage ContLog.png toolbar]
    if { $options(UseLogScale)} {
        set img [ gid_themes::GetImage ContNoLog.png toolbar]
    }
    return $img
}

proc PostContLogSwitch { w { idx 0}} {
    array set options [ GiD_Info postprocess get scale_result_options]

    set new_value Yes
    if { $options(UseLogScale)} {
        set new_value No
    }
    GiD_Process escape escape escape escape Results Options ScaleResult UseLogScale $new_value escape

    if { "[ winfo class $w]" == "Menu"} {
        $w entryconfigure $idx -image [ IconoBotonLogSwitch]
    } else {
        $w configure -image [ IconoBotonLogSwitch]
    }
}

proc PostContFactorEntryApply { w escala} {
    global GidPriv
    set err 0

    if { $::GidPriv(PostCont$escala) != "" } {
        set err [ catch { format "%g" $::GidPriv(PostCont$escala) } ]
        if { !$err} {
            set cur_res [ GiD_Info postprocess get cur_result]
            set cur_res_view [ GiD_Info postprocess get cur_results_view]
            set cur_comp [ GiD_Info postprocess get cur_component]
            regsub -all {_} $cur_res_view {} tipo_contour
            
            if { ( $cur_res_view == "Contour_Fill") || ( $cur_res_view == "Smooth_Contour_Fill") || \
                     ( $cur_res_view == "Contour_Lines") || ( $cur_res_view == "Smooth_Contour_Lines") } {
                GiD_Process escape escape escape escape Results Options ScaleResult $escala \
                    $::GidPriv(PostCont$escala) escape
                # GiD_Process Mescape Utilities Redisplay escape escape
            }
        } else {
            WarnWin [_ "A Numerical value must be entered."]
        }
    }

    if { !$err} {
        set GidPriv(PostContHistory$escala) [ [ $w.f.emin cget list] get 0 end]
        destroy $w
    }
}

proc PostContFactorEntry { w escala} {
    global GidPriv
    #w its a menu dosn't work well
    #parent of w its a menubutton, working better
    set w [ winfo parent $w]
    set x [ winfo x $w]
    set y [ winfo y $w]
    set wi [ winfo width $w]
    set w [ winfo parent $w]
    while { $w != "" } {
        set xp [ winfo x $w]
        set yp [ winfo y $w]
        set x [ expr $x + $xp]
        set y [ expr $y + $yp + 16]
        if { "[ winfo class $w]" == "Toplevel"} {
            break
        }
        set w [ winfo parent $w]
    }
    set x [expr $x + $wi]
    set y [expr $y + 16]
    
    toplevel .wPostContFactor
    wm geometry .wPostContFactor +$x+$y
    wm title .wPostContFactor [_ "Scale result"]
    wm minsize .wPostContFactor 1 1
    wm overrideredirect .wPostContFactor 1

    ttk::frame .wPostContFactor.f -style ridge.TFrame -borderwidth 2
    if { ![info exists ::GidPriv(PostContHistory$escala)] } {
        set ::GidPriv(PostContHistory$escala) ""
    }
    combobox .wPostContFactor.f.emin -width 11 -borderwidth 1 -textvariable ::GidPriv(PostCont$escala) \
        -editable 1 -keephistory 1 -history $::GidPriv(PostContHistory$escala)

    array set optionsScale [ GiD_Info postprocess get scale_result_options]
    set ::GidPriv(PostContScaleFactor) [ format "%g" $optionsScale($escala) ]
    .wPostContFactor.f.emin sel to end

    bind .wPostContFactor <Return> "PostContFactorEntryApply .wPostContFactor $escala"
    bind .wPostContFactor <Escape> "destroy .wPostContFactor"
    bind .wPostContFactor <1> "+PostCloseFLoatingWindow %W %x %y"
   
    ttk::button .wPostContFactor.f.b  -image [gid_themes::GetImage close.png] -command [list destroy .wPostContFactor]

    #grid .wPostContFactor.f.emin .wPostContFactor.f.b
    grid .wPostContFactor.f.emin -padx 2 -pady 1
    grid .wPostContFactor.f.b -column 1 -row 0 -padx 1 -pady 1

    grid .wPostContFactor.f
    focus -force .wPostContFactor.f.emin
    #raise .wPostContFactor .gid
    update
    grab .wPostContFactor

}

proc IconoScaleResultLogarithmic { } {
    array set options [ GiD_Info postprocess get scale_result_options]
    set img $::GidPriv(VerifNoImage)
    if { $options(UseLogScale)} {
        set img $::GidPriv(VerifImage)
    }
    return $img
}

proc PostScaleResultLogarithmic { w idx} {
    array set options [ GiD_Info postprocess get scale_result_options]
    set new_value Yes
    if { $options(UseLogScale)} {
        set new_value No
    }
    GiD_Process escape escape escape escape Results Options ScaleResult UseLogScale $new_value escape
    $w entryconfigure $idx -image [ IconoScaleResultLogarithmic] -compound left
}

proc PostScaleResultMenu { w } {
    set MenuEntriesP(3,12) [ list [_ "Multiplier factor"] [_ "Adder factor"] [_ "Use logarithmic scale"]]
    set MenuCommandsP(3,12) [ list \
                                    [ list GiD_Process escape escape escape escape Results Options ScaleResult ScaleMultiplier] \
                                    [ list GiD_Process escape escape escape escape Results Options ScaleResult ScaleAdder] \
                                    [ list PostScaleResultLogarithmic %W 2]]

    set lst_img [ list $::GidPriv(VerifNoImage) $::GidPriv(VerifNoImage) [ IconoScaleResultLogarithmic]]

    $w delete 0 end
    set idx 0
    set UnderLineList {}
    foreach label $MenuEntriesP(3,12) comando $MenuCommandsP(3,12) img $lst_img {
        set under [FindUnderChar label UnderLineList]
        if { [ info exists MenuEntriesP(3,12,$idx)]} {
            set m $w.mm$idx
            if { ![ winfo exists $w.mm$idx]} {
                menu $m
            }
            $w add cascade -label $label -underline $under -image $img -compound left -menu $m
            regsub -all {%W} $comando $m cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $m configure -postcommand $cmd
        } else {
            regsub -all {%W} $comando $w cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $w add command -label $label -underline $under -image $img -compound left -command $cmd
        }
        incr idx
    }
}

proc PostContourResetAll { } {
    GidUtils::DisableGraphics
    GiD_Process Mescape Results ContOptions \
        SetMaxOptions ResetValue escape \
        SetMinOptions ResetValue escape \
        NumberOfColors 50 \
        escape escape escape escape \
        Results ContOptions \
        LinesWidth 1.0 \
        SetMinOptions MinColor Standard escape \
        SetMaxOptions MaxColor Standard escape \
        ColorRamp Tangent escape \
        Options ScaleResult ScaleMultiplier 1.0 \
        Options ScaleResult ScaleAdder 0.0 \
        Options ScaleResult UseLogScale No \
        escape escape escape escape 
    GidUtils::EnableGraphics
    GiD_Process Mescape Utilities Redisplay \
        escape escape escape escape
}

proc ViewSeveralWindows {} {
    set w .gid.viewseveralwindows
    InitWindow2 $w -title [_ "Multiple windows"] \
        -geometryvariable PrePostViewMWindowsWindowGeom \
        -initcommand ViewSeveralWindows -onlyposition -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::label $w.l -text [_ "Select the desired window configuration"] -font BigFont
    ttk::label $w.i -image [ gid_themes::GetImage mwindows.png] -relief ridge -borderwidth 1
    $w.l configure -wraplength [image width [$w.i cget -image]]

    ttk::frame $w.but -style BottomFrame.TFrame  
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -underline 0 -style BottomFrame.TButton    

    grid $w.but.close -padx 5 -pady 5

    grid $w.l -sticky new
    grid $w.i -padx 3 -sticky nsew
    grid $w.but -sticky sew
    grid anchor $w.but center
    grid rowconfigure $w "1" -weight 1
    grid columnconfigure $w "0" -weight 1
    focus $w.but.close
    bind $w.i <1> [list ViewSeveralWindowsSelect $w %x %y]   
}


proc ViewSeveralWindowsSelect { w x y } {
    set type ""
    if { $x > 16 && $x < 77 } {
        if { $y > 21 && $y < 77 } {
            set type 1
        } elseif { $y > 102 && $y < 157 } {
            set type 3L
        } elseif { $y > 185 && $y < 236 } {
            set type 3D
        }
    } elseif { $x > 109 && $x < 169 } {
        if { $y > 21 && $y < 77 } {
            set type 2LR
        } elseif { $y > 102 && $y < 157 } {
            set type 3U
        } elseif { $y > 185 && $y < 236 } {
            set type 4
        }
    } elseif { $x > 200 && $x < 262 } {
        if { $y > 21 && $y < 77 } {
            set type 2UD
        } elseif { $y > 102 && $y < 157 } {
            set type 3R
        } elseif { $y > 185 && $y < 236 } {
            set type EXT
        }
    }
    if { $type != "" } {
        GiD_Project set windows_layout $type
        #after idle [list GiD_Process 'NewWin $type]
    }
}

#if modal blocks and return the keyword of the selected button, otherwise not blocks and send the selected value to GiD_Process
proc CreatePointNewOld { {modal 0} } {
    set result ""
    set w .gid.createpointnewold
    InitWindow2 $w -title [_ "Create point procedure"] \
        -geometryvariable PreCreatePointNewOldWindowGeom \
        -initcommand CreatePointNewOld -onlygeometry -ontop
    if { ![winfo exists $w] } {
        # windows disabled || UseMoreWindows == 0
        return
    }
    ttk::label $w.l -text [_ "Click the image to get the existing point or create a new one"]
    ttk::frame $w.centre -style ridge.TFrame -borderwidth 2
    ttk::label $w.centre.txt_NJ -text [_ "No join"] -font BigFont
    ttk::label $w.centre.txt_NJ2 -text [_ "New point is created"]
    ttk::label $w.centre.txt_J -text [_ "Join"] -font BigFont
    ttk::label $w.centre.txt_J2 -text [_ "Existing point is selected"]
    ttk::button $w.centre.nojoin -image [gid_themes::GetImage no_join.png] -cursor hand2
    ttk::button $w.centre.join -image [gid_themes::GetImage join.png] -cursor hand2
    ttk::label $w.note_text -text [_ "NOTE: %s toggles between Join and No join modes." ${::acceleratorText}-a]
    grid $w.centre.txt_NJ $w.centre.txt_J
    grid $w.centre.nojoin $w.centre.join -padx 3
    grid $w.centre.txt_NJ2 $w.centre.txt_J2
    grid $w.l -sticky new -columnspan 2 -padx 3 -pady 3
    grid $w.centre -sticky nsew -columnspan 2 -padx 3
    grid columnconfigure $w.centre "0 1" -weight 1
    grid $w.note_text -sticky sew -columnspan 2 -padx 3   
    grid columnconfigure $w "0" -weight 1
    grid rowconfigure $w "1" -weight 1
    
    #focus $w
    bind $w <Return> [list $w.centre.join invoke]
    #update idletasks
    set focus  $w.centre.join

    if { $modal } {
        wm protocol $w WM_DELETE_WINDOW [list $w.centre.nojoin invoke]
        bind $w <Escape> [list $w.centre.nojoin invoke]
        $w.centre.nojoin configure -command [list set ::GidPriv(messagebox,selected_option) New]
        $w.centre.join configure -command [list set ::GidPriv(messagebox,selected_option) Old]
        set is_iconic [GidUtils::IsStateIconic]
        if { $is_iconic } {
            focus $focus
            #grab $w ;#if grab when iconic then is not possible to deiconify GiD in Windows !!!
        } else {
            ::tk::SetFocusGrab $w $focus
        }
        vwait ::GidPriv(messagebox,selected_option)
        if { $is_iconic } {
            destroy $w
        } else {
            ::tk::RestoreFocusGrab $w $focus
        }
        set result $::GidPriv(messagebox,selected_option)        
    } else {
        wm protocol $w WM_DELETE_WINDOW [list CreatePointNewOldDo $w Escape]
        bind $w <Escape> [list CreatePointNewOldDo $w Escape]
        $w.centre.nojoin configure -command [list CreatePointNewOldDo $w New]
        $w.centre.join configure -command [list CreatePointNewOldDo $w Old]        
    }
    return $result
}

proc CreatePointNewOldDo { w process } {
    destroy $w
    GiD_Process $process    
}

proc GeometryView { } {
    set whatuse [GiD_Info Project ViewMode]
    if { $whatuse != "GEOMETRYUSE" } {
        GiD_Process 'SetViewMode Geometry
    }
}

proc MeshView { { showmessage 1 } } {
    set whatuse [GiD_Info Project ViewMode]
    if { $whatuse != "MESHUSE" } {
        if { $showmessage && ![GidUtils::ExistsMesh] } {
            set ::CurrentViewMode $whatuse ;#to avoid set the check mark as Mode->Mesh
            WarnWin [_ "Sorry. No mesh"]
        } else {
            GiD_Process 'SetViewMode Mesh
        }
    }
}

proc SetUse { use } {
    if { $use== "GEOMETRYUSE" } {
        GeometryView
    } elseif { $use== "MESHUSE" } {
        MeshView 1
    } elseif { $use== "POSTUSE" } {
        set whatuse [GiD_Info Project ViewMode]
        if { $whatuse != $use } {
            error "SetUse, can't set use $use. Current use $whatuse"
        }
    } else {
        error "unexpected use $use. Must be GEOMETRYUSE or MESHUSE"    
    }  
}

proc ToggleGeomMesh {} {
    set infoProj [GiD_Info Project ViewMode]
    if { $infoProj == "GEOMETRYUSE" } {
        if { [lindex [ GiD_Info mesh] 0] != "0" } {            
            GiD_Process 'SetViewMode Mesh
        } else {
            #WarnWin [_ "There is no mesh. Generate it?"]
            DoMeshingGenerate            
        }
    } elseif { $infoProj == "MESHUSE" } {
        GiD_Process 'SetViewMode Geometry
    }
}

proc TogglePrePost {} {
    if { [ GetCurrentPrePostMode] == "PRE" } {
        DoPostprocess
    } else {
        DoPreprocess
    }
}

proc TogglePostGraph {} {
    set viewmode [ GiD_Info Project ViewMode]
    if { $viewmode == "POSTUSE" } {
        GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs Yes
    } elseif { $viewmode == "GRAPHUSE" } {
        GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs No
    }
}

proc GGCompress {} {
    set w .wcomp
    if { [winfo exists $w] } {
        destroy $w
    }
    toplevel $w
    ttk::frame $w.f -style groove.TFrame -borderwidth 2
    ttk::label $w.f.l1 -text [_ "Flags"]:
    ttk::entry $w.f.e1
    ttk::label $w.f.l2 -text [_ "File In"]:
    ttk::entry $w.f.e2
    ttk::label $w.f.l3 -text [_ "File Out"]:
    ttk::entry $w.f.e3
    grid $w.f.l1 $w.f.e1
    grid $w.f.l2 $w.f.e2
    grid $w.f.l3 $w.f.e3

    proc GGCDoIt { w} {
        set fl [ $w.f.e1 get]
        set fi [ $w.f.e2 get]
        set fo [ $w.f.e3 get]
        if { $fl != ""} {
            gidcompress $fl $fi $fo
        } else {
            gidcompress $fl $fi $fo
        }
    }
    ttk::button $w.f.b1 -text [_ "Do"] -command [list GGCDoIt $w] -style BottomFrame.TButton
    ttk::button $w.f.b2 -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton
    grid $w.f.b1 $w.f.b2
    grid $w.f
}

proc framelabel { w text { rel groove}} {
    ttk::frame $w -relief $rel -borderwidth 2
    set i 0
    set parent [winfo parent $w]
    if { $parent == "." } { set parent "" }
    set label $parent.__label$i
    while { [winfo exists $label] } {
        incr i
        set label $parent.__label$i
    }
    ttk::label $label -text $text
    place $label -in $w -x 10 -y -1 -anchor w -bordermode outside
    after idle raise $label
    return $w
}

proc framelabelsep {} {
    set FontHeight [ font metrics NormalFont -linespace]
    return [expr $FontHeight/2+1]
}

proc AskForNormalFillLineTangent { w } {
    grab release $w    
    set direction [GidUtils::GetCoordinates "" TangentInLine GEOMETRYUSE]
    if { $direction != "" } {
        foreach i {1 2 3} component $direction {
            $w.f.e${i} delete 0 end
            $w.f.e${i} insert end $component
        }
    }    
    grab $w
}

proc AskForNormalFillSurfaceNormal { w } {
    grab release $w
    set direction [GidUtils::GetCoordinates "" NormalInSurface GEOMETRYUSE] 
    if { $direction != "" } {
        foreach i {1 2 3} component $direction {
            $w.f.e${i} delete 0 end
            $w.f.e${i} insert end $component
        }
    }
    grab $w
}

proc AskForNormal { w message {process 1}} {
    global tkPriv
    if { [winfo exists $w] } {
        destroy $w
    }
    toplevel $w
    wm title $w [_ "Enter normal"]
    if { $::tcl_platform(platform) == "windows" } {
        wm transient $w [winfo toplevel [winfo parent $w]]
    }    
    ttk::frame $w.f
    ttk::label $w.f.l -text $message
    ttk::radiobutton $w.f.r1 -text [_ "Positive Z"] -variable tkPriv(afw_check) -value z
    ttk::radiobutton $w.f.r2 -text [_ "Positive Y"] -variable tkPriv(afw_check) -value y
    ttk::radiobutton $w.f.r3 -text [_ "Positive X"] -variable tkPriv(afw_check) -value x
    ttk::radiobutton $w.f.r4 -text [_ "Components"]: -variable tkPriv(afw_check) -value coords

    ttk::entry $w.f.e1 -width 5
    ttk::entry $w.f.e2 -width 5
    ttk::entry $w.f.e3 -width 5
    ttk::button $w.f.bpointinline -image [gid_themes::GetImage line.png small_icons] -command [list AskForNormalFillLineTangent $w]
    ttk::button $w.f.bpointinsurface -image [gid_themes::GetImage surface.png small_icons] -command [list AskForNormalFillSurfaceNormal $w]
    
    $w.f.e1 insert end 0.0
    $w.f.e2 insert end 0.0
    $w.f.e3 insert end 1.0

    proc ChangeCoords { w } {
        global tkPriv
        if { $tkPriv(afw_check) == "coords" } {
            $w.f.e1 configure -state normal
            $w.f.e2 configure -state normal
            $w.f.e3 configure -state normal
            $w.f.bpointinline configure -state normal
            $w.f.bpointinsurface configure -state normal
        } else {
            $w.f.e1 configure -state disabled
            $w.f.e2 configure -state disabled
            $w.f.e3 configure -state disabled
            $w.f.bpointinline configure -state disabled
            $w.f.bpointinsurface configure -state disabled
        }
    }

    trace var tkPriv(afw_check) w "ChangeCoords $w ;#"
    set tkPriv(afw_check) z
    grid $w.f.l -columnspan 4 -sticky w -padx 2
    grid $w.f.r1 -columnspan 4 -sticky w -padx 2
    grid $w.f.r2 -columnspan 4 -sticky w
    grid $w.f.r3 -columnspan 4 -sticky w
    grid $w.f.r4 $w.f.e1 $w.f.e2 $w.f.e3 $w.f.bpointinline $w.f.bpointinsurface -sticky ew 
    grid columnconf $w.f {1 2 3} -weight 1    

    ttk::frame $w.bf -style BottomFrame.TFrame
    
    ttk::button $w.bf.ok -text [_ "OK"] -command [list set tkPriv(afw_button) ok] -underline 0 -style BottomFrame.TButton   
    ttk::button $w.bf.cancel -text [_ "Cancel"] -command [list set tkPriv(afw_button) cancel] -underline 0 -style BottomFrame.TButton

    wm protocol $w WM_DELETE_WINDOW "$w.bf.cancel invoke"
    bind $w.bf.ok <Return> "$w.bf.ok invoke"
    bind $w.f.e1 <Return> "$w.bf.ok invoke"
    bind $w.f.e2 <Return> "$w.bf.ok invoke"
    bind $w.f.e3 <Return> "$w.bf.ok invoke"
    bind $w <Escape> "$w.bf.cancel invoke"
    bind $w <Alt-o> "$w.bf.ok invoke"
    bind $w <Alt-c> "$w.bf.cancel invoke"   

    grid $w.f  -pady 6 -sticky ewns
    grid $w.bf -pady 0 -sticky ewns
    grid columnconf $w 0 -weight 1
    grid rowconf $w 0 -weight 1
    
    grid $w.bf.ok $w.bf.cancel -padx 5 -pady 3    
    grid columnconfigure $w.bf 0 -weight 1
    grid columnconfigure $w.bf 4 -weight 1    

    wm withdraw $w
    update idletasks

    set pare [winfo toplevel [winfo parent $w]]
    set x [expr [winfo x $pare]+[winfo width $pare ]/2- [winfo reqwidth $w]/2]
    set y [expr [winfo y $pare]+[winfo height $pare ]/2- [winfo reqheight $w]]
    if { $x < 0 } { set x 0 }
    if { $y < 0 } { set y 0 }
    WmGidGeom $w +$x+$y
    #wm geometry $w +$x+$y
    update
    wm deiconify $w

    set oldFocus [focus]
    if { $::tcl_platform(os) != "Darwin"} {
        if { [winfo exists $w] } {
            tkwait visibility $w
        }
    } else {
        update
    }
    grab $w
    focus $w.bf.ok
    after 100  [list catch [list focus -force $w.bf.ok]]

    while 1 {
        tkwait variable tkPriv(afw_button)
        if { $tkPriv(afw_button) != "ok" } { 
            break 
        }
        set value ""
        set isdiffzero 0
        if { $tkPriv(afw_check) == "coords" } {
            set isbad 0
            for { set i 1 } { $i <= 3 } { incr i } {
                if { [catch { set val [expr double([$w.f.e$i get])] }] } {
                    WarnWin [_ "Coordinate must be a real number"]                    
                    set isbad 1
                    break
                }
                if { $val != 0.0 } { set isdiffzero 1 }
                if { $value == "" } {
                    append value $val
                } else {
                    append value ",$val"
                }
            }
            if { $isbad } {
                focus -force $w                
                continue
            }
            if { !$isdiffzero } {
                WarnWin [_ "Normal must be different from zero"]
                focus -force $w                
                continue
            }
        } elseif { $tkPriv(afw_check) == "z" } {
            set value "0.0,0.0,1.0"
        } elseif { $tkPriv(afw_check) == "y" } {
            set value "0.0,1.0,0.0"
        } else {
            set value "1.0,0.0,0.0"
        }
        break
    }
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
        set grabStatus [grab status $oldGrab]
    }

    if { $oldFocus == "" || [catch {focus $oldFocus}] } {
        if { [winfo exists .gid] } {
            focus [focus -lastfor .gid]
        }
    }

    destroy $w
    if {$oldGrab != ""} {
        if {$grabStatus == "global"} {
            catch { grab -global $oldGrab }
        } else {
            catch { grab $oldGrab }
        }
    }

    if { $process } {
        switch $tkPriv(afw_button) {
            ok {
                GiD_Process $value
            }
            cancel {
                GiD_Process escape
            }
        }
        set result ""
    } else {
        if { $tkPriv(afw_button) == "ok" } {
            set result $value
        } else {
            set result ""
        }
    }
    return $result
}

proc ExecuteFileCommand { lst_comm PREPOST lastaction filename } {
    #file join $filename to have / separator also on Windows platfrom
    set filename [file join $filename]
    set what [ GetCurrentPrePostMode]
    if { $PREPOST == "PRE" && $what == "POST" } {
        if { $lastaction == "goingpre" } { return }
        GiD_Process Mescape Preprocess
        delayedop changefunc [ list LoadFileInGid $filename goingpre]
        return
    }
    if { $PREPOST == "POST" && $what == "PRE" } {
        DoPostprocess
        update idletasks
    }

    if { $PREPOST == "PREPOST"} {
        # comm is a 2 element list: one for pre if we are in pre and one for post if we are in post
        set idx_what 0 ;# PRE
        if { $what == "POST"} {
            set idx_what 1
        }
        set comm [ lindex $lst_comm $idx_what]
    } else {
        set comm $lst_comm
    }

    if { $comm == "GiDMLRead" } {
        if { [GidUtils::ExistsMesh] } {
            #to not ask. append to current mesh
            lappend comm Append
        }
    } elseif { $comm == "STLRead" || $comm == "MeshRead" } {
        if { [GidUtils::ExistsMesh] } {
            #to not ask. append to current mesh
            lappend comm AddNoShare
        }
    } elseif { $comm == "NASTRANRead" || $comm == "3DStudioRead" } {
        if { [GidUtils::ExistsMesh] } {
            #to not ask. append to current mesh
            lappend comm Append
        }
    } elseif { $comm == "VTKRead" } {
        # expects a list of multiple filenames
        set filename [list $filename]
    }
    #file join $filename to have / separator also on Windows platfrom
    GiD_Process Mescape Files {*}$comm $filename
}

proc SourceFile { filename } {
    source $filename
    GidUtils::SetWarnLine [_ "File '%s' sourced" $filename]
}

#user procedures to handle some file extension when dropping files on GiD 
#prepost could be: PRE POST or PREPOST
#procname is a procedure with an argument, the name of the dropped file that match the extension
#GiD_RegisterExtensionProc <list of extensions> <prepost> <procname>
#GiD_UnRegisterExtensionProc <list of extensions> <prepost>
#e.g.
#proc MyUnvRead { file } { ... }
#GiD_RegisterExtensionProc ".unv .uff" PRE MyUnvRead


proc GiD_RegisterExtensionProc { exts prepost procname  } {
    if { [info procs $procname] != "" } {
        set argc [llength [info args $procname]]
        if { $argc>1 } {
            set arg [lindex [info args $procname] 1]
            if { [info default $procname $arg defvalue] } {
                #more than 1 argument, but the rest have default values
                set argc 1
            }                                           
        }
        if { $argc != 1 } {
            return -code error [_ "Wrong procedure prototype, must be '%s'." "proc procname <filename> body"]
        }
    }
    if { $prepost == "PRE" } {
        set where PRE
    } elseif { $prepost == "POST" } {
        set where POST
    } elseif { $prepost == "PREPOST" } {  
        set where "PRE POST"
    } else {
        return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]
    }
    foreach i $where {
        foreach ext $exts {
            set ext [string tolower $ext]
            set ::GidPriv(RegisteredExtensionProcs,$ext,$i) $procname
        }
    }
}

proc GiD_UnRegisterExtensionProc { exts prepost } {
    if { $prepost == "PRE" } {
        set where PRE
    } elseif { $prepost == "POST" } {
        set where PRE
    } elseif { $prepost == "PREPOST" } {  
        set where "PRE POST"
    } else {
        return -code error [_ "Wrong arg. Must be PRE, POST or PREPOST."]
    }
    foreach i $where {
        foreach ext $exts {
            set ext [string tolower $ext]
            if { ![info exists ::GidPriv(RegisteredExtensionProcs,$ext,$i)] } {
                return 1
            }
            unset ::GidPriv(RegisteredExtensionProcs,$ext,$i)
        }
    }
}

proc IsPostFilename { file} {
    set is_post 0
    # really here some checks are unneded,
    # if .lst then also will match .post.lst,
    #    .res                      .post.res .flavia.res
    #    .bin                      .post.bin
    foreach ext {.post.lst .lst .res .bin .post.h5 .post.bin .post.msh .post.res .flavia.msh .flavia.res .bon .dat} {
        if { [string match *$ext $file] } {
            set is_post 1
            break
        }
    }
    if { !$is_post } {
        set ext [file extension $file]
        if { $ext == ".h5" } {
            if { [gid_filesystem::is_gid_post $file] } {
                set is_post 1
            }
        } elseif { $ext == ".msh" } { 
            if { [GetCurrentPrePostMode] == "POST" } {
                set is_post 1
            }
        }
    }
    return $is_post
}

# last action can be: saving; goingpre;
proc LoadFileInGid { file {lastaction ""} } {
    if { ![gid_filesystem::file exists $file] } {
        GidUtils::SetWarnLine [_ "File '%s' does not exist" $file]
        return 1
    }
    if {$::tcl_platform(platform) eq "windows"} {
        set file [file native [gid_filesystem::file attributes $file -longname]]
    } else {
        set file [file native $file]
    }
    if { [gid_filesystem::file isdirectory $file] && [string tolower [file extension $file]] == ".gid" } {
        if { [GetCurrentPrePostMode] == "POST" } {
            if { $lastaction == "goingpre" } { 
                return 0
            }
            DoPreprocess Yes
            set fail [LoadFileInGid $file]
            return $fail
        }
        if { [GiD_Info Project AreChanges] } {
            set fail [DoFilesNew ASK]
            if { $fail } {
                return 0
            }
            ExecuteFileCommand Read PRE $lastaction $file
        } else {
            ExecuteFileCommand Read PRE $lastaction $file
        }
    } elseif { [ IsPostFilename $file] } {
        ExecuteFileCommand Read POST $lastaction $file
    } else {
        set unknown_extension 0
        set ext [string tolower [file extension $file]]
        # iter 1 check extension, iter 2 check double extension, if any        
        foreach iter {1 2} {
            if { $iter == 2 } {
                set ext_2 [string tolower [file extension [file rootname $file]]]
                if { $ext_2 == "" } {
                    # has single extension
                    break
                }
                # e.g. double extension like *.gcode.gz
                set double_ext ${ext_2}${ext}
                set ext $double_ext
            }
            switch $ext {
                ".dxf" {ExecuteFileCommand DXFRead PRE $lastaction $file}
                ".msh" - ".mesh" {ExecuteFileCommand MeshRead PRE $lastaction $file}
                ".gidml" {ExecuteFileCommand GiDMLRead PRE $lastaction $file}
                ".igs" - ".iges" {ExecuteFileCommand IgesRead PRE $lastaction $file}
                ".ifc" {ExecuteFileCommand IfcRead PRE $lastaction $file}
                ".brep" {ExecuteFileCommand OpenCascadeRead PRE $lastaction $file}
                ".stp" - ".step" {ExecuteFileCommand STEPRead PRE $lastaction $file}
                ".nas" - ".bdf" {ExecuteFileCommand NASTRANRead ANY $lastaction $file}
                ".vtk" - ".vtu" - ".vtp" - ".vts" - ".vti" - ".pvd" - ".pvtu" {ExecuteFileCommand VTKRead PRE $lastaction $file}
                ".bch" {ExecuteFileCommand BatchFile ANY $lastaction $file}
                ".x_t" - ".x_b" {ExecuteFileCommand ParasolidRead PRE $lastaction $file}
                ".sat" - ".sab" {ExecuteFileCommand AcisRead PRE $lastaction $file}
                ".vda" {ExecuteFileCommand VDARead PRE $lastaction $file}
                ".stl" {ExecuteFileCommand STLRead PRE $lastaction $file}
                ".shp" {ExecuteFileCommand ShapefileRead PRE $lastaction $file}
                ".3dm" {ExecuteFileCommand RhinoRead PRE $lastaction $file}
                ".wrl" - ".vrml" {ExecuteFileCommand VrmlRead PRE $lastaction $file}
                ".3ds" {ExecuteFileCommand 3DStudioRead ANY $lastaction $file}
                ".cgns" {ExecuteFileCommand { CGNSRead readCGNS} PREPOST $lastaction $file}
                ".ply" {ExecuteFileCommand PlyRead PRE $lastaction $file}
                ".obj" {ExecuteFileCommand OBJRead PRE $lastaction $file}
                ".neu" - ".fno" {ExecuteFileCommand ReadFEMAP POST $lastaction $file}
                ".plt" {ExecuteFileCommand ReadTECPLOT POST $lastaction $file}            
                ".vv" {ExecuteFileCommand 'ReadView ANY $lastaction $file}
                ".tcl" {SourceFile $file}
                default {                
                    set mode [GetCurrentPrePostMode]
                    if { [info exists ::GidPriv(RegisteredExtensionProcs,$ext,$mode)] } {
                        set procname $::GidPriv(RegisteredExtensionProcs,$ext,$mode)
                        set argc [llength [info args $procname]]
                        if { $argc>1 } {
                            set arg [lindex [info args $procname] 1]
                            if { [info default $procname $arg defvalue] } {
                                #more than 1 argument, but the rest have default values
                                set argc 1
                            }                                           
                        }                    
                        if { $argc == 1 } {
                            $procname $file
                        }
                        set unknown_extension 0
                    } else {
                        set unknown_extension 1
                    }
                }
            }
            
        }
        if { $unknown_extension } {
            #deprecated LoadFileInGidUnknowExtension, better use GiD_RegisterExtensionProc
            GiD_RaiseEvent ::LoadFileInGidUnknowExtension $file
            if { [info procs LoadFileInGidUnknowExtension] != "" } {                    
                WarnWin [_ "Unknown file type for file '%s'" $file]
                return 1
            }
        }
    }
    return 0
}

proc LoadFileInGidPost { file {lastaction ""} } {
    if { ![gid_filesystem::file exists $file] } {
        GidUtils::SetWarnLine [_ "File '%s' does not exist" $file]
        return 1
    }

    if {$::tcl_platform(platform) eq "windows"} {
        set file [file native [gid_filesystem::file attributes $file -longname]]
    } else {
        set file [file native $file]
    }
    if { [gid_filesystem::file isdirectory $file] && [string tolower [file extension $file]] == ".gid" } {
        if { [GetCurrentPrePostMode] == "POST" } {
            if { $lastaction == "goingpre" } {
                return 0
            }
            GiD_Process Mescape Preprocess
            delayedop changefunc [list LoadFileInGid $file goingpre]
            return 0
        }
        if { [GiD_Info Project AreChanges] } {
            if { $lastaction == "saving" } {
                return 0
            }
            DoFilesNew ASK
            delayedop changefunc [list LoadFileInGid $file saving]
        } else {
            ExecuteFileCommand Read PRE $lastaction $file
        }
    } elseif { [IsPostFilename $file] } {
        ExecuteFileCommand Read POST $lastaction $file
    } else {
        set unknown_extension 0
        set ext [string tolower [file extension $file]]
        # iter 1 check extension, iter 2 check double extension, if any        
        foreach iter {1 2} {
            if { $iter == 2 } {
                set ext_2 [string tolower [file extension [file rootname $file]]]
                if { $ext_2 == "" } {
                    # has single extension
                    break
                }
                # e.g. double extension like *.gcode.gz
                set double_ext ${ext_2}${ext}
                set ext $double_ext
            }            
            switch $ext {
                ".nas" {ExecuteFileCommand NASTRANRead POST $lastaction $file}
                ".vtk" - ".vtu" - ".vtp" - ".vts" - ".vti" - ".pvd" - ".pvtu" {ExecuteFileCommand VTKRead POST $lastaction $file}
                ".bch" {ExecuteFileCommand BatchFile POST $lastaction $file}
                ".3ds" {ExecuteFileCommand 3DStudioRead POST $lastaction $file}
                ".cgns" {ExecuteFileCommand {CGNSRead readCGNS} PREPOST $lastaction $file}
                ".neu" - ".fno" {ExecuteFileCommand ReadFEMAP POST $lastaction $file}
                ".plt" {ExecuteFileCommand ReadTECPLOT POST $lastaction $file}
                ".vv" {ExecuteFileCommand 'ReadView ANY $lastaction $file}
                default {                
                    if { [info exists ::GidPriv(RegisteredExtensionProcs,$ext,POST)] } {
                        set procname $::GidPriv(RegisteredExtensionProcs,$ext,POST)
                        if { [llength [info args $procname]] == 1 } {                            
                            set argc [llength [info args $procname]]
                            if { $argc>1 } {
                                set arg [lindex [info args $procname] 1]
                                if { [info default $procname $arg defvalue] } {
                                    #more than 1 argument, but the rest have default values
                                    set argc 1
                                }
                            }
                            if { $argc == 1 } {
                                $procname $file
                            }
                            set unknown_extension 0
                        }
                    } else {
                        set unknown_extension 1
                    }
                }
            }
        }
        if { $unknown_extension } {
            #deprecated LoadFileInGidUnknowExtension, better use GiD_RegisterExtensionProc
            GiD_RaiseEvent ::LoadFileInGidUnknowExtension $file
            if { [info procs LoadFileInGidUnknowExtension] != "" } {
                WarnWin [_ "Unknown file type for file '%s'" $file]
                return 1
            }
        }
    }
    return 0
}

proc GetMenuDataTemplates { } {
    set menu_data [list]
    set dir_application [gid_filesystem::get_folder_gid]
    set dir [file join $dir_application templates]
    set files [gid_filesystem::glob -nocomplain -tails -directory $dir -types f *.bas]
    foreach i [lsort -dictionary $files] {
        set label [file root $i]
        set command [list GiD_Process Mescape Files WriteForBAS [file join $dir $i]]
        lappend menu_data [list i $label $command "" "" 0 0]
    }
    lappend menu_data [list i --- "" "" "" 0 0]
    set label [_ "Others"]...
    set command [list GiD_Process Mescape Files WriteForBAS]
    lappend menu_data [list i $label $command "" "" 0 0]
    return $menu_data
}

proc AddEntitiesToMenuTemplates { w } {
    set menu_data [GetMenuDataTemplates]
    GiD_RaiseEvent GiD_Event_BeforeSetMenu $menu_data $w    
    return $menu_data
}

# status = NONE | ACADEMIC | PROFESSIONAL | TEMPORALLYPROFESSIONAL
proc ShowGiDVersionType { { status ""}} {
    global GidPriv
    if { $status == "" } {
        set status none
        if { [info exists GidPriv(GiDVersionType)] } {
            set status $GidPriv(GiDVersionType)
        }
    }
    set GidPriv(GiDVersionType) $status
    if { ![GidUtils::IsTkDisabled] && [info procs gid_themes::GetImage]!= "" } {  
        set base_name [file rootname $GidPriv(InfoGiDBitmapName)]
        set extension [file extension $GidPriv(InfoGiDBitmapName)]
        set img ""
        if { [string match -nocase "none" $status] } {
            set img [gid_themes::GetImage $GidPriv(InfoGiDBitmapName) toolbar]
        } elseif { [string match -nocase "academic" $status] } {
            set img [gid_themes::GetImage ${base_name}_a${extension} toolbar]
        } elseif { [string match -nocase "professional" $status] } {
            set img [gid_themes::GetImage ${base_name}_p${extension} toolbar]
        } elseif { [string match -nocase "temporallyprofessional" $status] } {
            set img [gid_themes::GetImage ${base_name}_t${extension} toolbar]
        } else {
            set img ""
        }        
        if { [info exists GidPriv(InfoGiDButtonName)] && $GidPriv(InfoGiDButtonName) != "" } {
            if { [winfo exists $GidPriv(InfoGiDButtonName)] && $img != "" } {
                # not needed anymore
                #  if { $::tcl_platform(os) == "Darwin"} {
                #      # Mac os X does not support partial transparent images so
                #      # make this icon letters legible by applying the background colour ourselves
                #      set f_style  [ $GidPriv(InfoGiDButtonName) cget -style]
                #      set bg_color [ ttk::style lookup $f_style -background]
                #      $img put [ $img data -background $bg_color]
                #  }
                $GidPriv(InfoGiDButtonName) configure -image $img
            }
        }
    }
    GiD_RaiseEvent GiD_Event_AfterChangeLicenceStatus $status
    GiD_RaiseEvent ::AfterChangeLicenceStatus $status ;#deprecated, but raised for back compatibility
}

proc GetImageGiDorProblemtype { BitmapsPath filename } {
    if { $BitmapsPath == "GiD_image_folder" && [llength [file split $filename]] == 1 } {
        #using standard GiD image
        set img [gid_themes::GetImage $filename toolbar]
    } else {
        if { $BitmapsPath == "GiD_image_folder" } {
            set full_filename [file join $::GIDDEFAULT $filename]
            set img [gid_themes::GetImage $full_filename "toolbar" "gid"]
        } else {
            if { [file pathtype $filename] == "absolute" } {
                set full_filename $filename
            } else {
                set full_filename [file join $BitmapsPath $filename]
            }
            set img [gid_themes::GetImage $full_filename "toolbar" ""]
        }   
    }
    return $img
}


proc ReloadLastModel { {previousproblemtype ""} } {
    set reload [GiD_Set ReloadLastModel]
    if { $reload } {
        if { [GiD_Set LastModelSaved] == 0 } {
            set reload 0
        }
    }
    if {  $reload && [string range [lindex $::argv 0] 0 1] == "-b" } {
        #not reload the last model if a batch file was specified
        set reload 0
    }
    if { $reload && [GidUtils::ModelHasName] } {
        #already read a backup file after crash or load a model from the command line
        set reload 0
    }
    if { $reload } {
        set names [GiD_Info recentprojects]
        if { [llength $names] > 0 } {
            set modelname [lindex $names 0].gid
            if { $previousproblemtype != "" } {
                #only load last model if his probletype is also pt
                set filename_geo [file join $modelname [file rootname [file tail [lindex $names 0]]].geo]
                set pt [file join [lindex [gid_filesystem::read_info_geo_file $filename_geo] 2]]
                #file join to convert \ to /
                if { [file join $previousproblemtype] != $pt } {
                    set reload 0
                }
            }
            if { $reload } {
                set is_cloud_path [GidDataManager::isCloudPath $modelname]
                if { $is_cloud_path } {
                    #if it is not mounted can wait a little until unit is ready...
                    set reload 0
                    for {set i_try 0} {$i_try<10} {incr i_try } {
                        if { [GidDataManager::getConnectedPath] != "" } {
                            set reload 1
                            break
                        } elseif { ![GiD_Set Cloud(AutomaticConnect)] } {
                            set reload 0
                            break
                        }
                        after 100
                    }
                }
                if { $reload } {
                    LoadFileInGid $modelname
                }
            }
        }
    }
}

#will source only .tcl (or .tbe) file with the same name as the folder
proc SourcePlugins { dir } {      
    set filetail [file tail $dir]
    set files [glob -nocomplain -tails -directory $dir -types f $filetail.tcl]
    set filestbe [glob -nocomplain -tails -directory $dir -types f $filetail.tbe]
    foreach i $filestbe {
        lappend files [file rootname $i].tcl
    }
    foreach i [lsort -unique -dictionary $files] {
        set tcl_filename [file join $dir $i]
        set xml_filename [file rootname $tcl_filename].xml
        if { [llength [GidUtils::ReadProblemtypeXml $xml_filename InfoPlugin [list Name]]] == 2 } {
            #source the tcl file only if it has associated its xml file of type InfoPlugin, with at least the 'Name' field
            source $tcl_filename
        }
    }
    set subdirs [glob -nocomplain -tails -directory $dir -types d *]
    foreach link [glob -nocomplain -tails -directory $dir -types f *.lnk] {
        if { [GidUtils::IsLink [file join $dir $link]] == 2 } {
            lappend subdirs $link
        }
    }
    foreach i [lsort -dictionary $subdirs] {
        set ifull [file join $dir $i]
        if { [file extension $i] == ".lnk" && [GidUtils::IsLink $ifull] == 2 } {
            set i [file root $i] ;#to remove .lnk
            set ifull [GidUtils::ReadLink $ifull 1]
        }
        SourcePlugins $ifull
    }
}

#some procedures that are defined just when sourcing plugins must be evaluated after read its preferences
proc GiD_RegisterProcedureToInvokeAfterSourcePlugins { procedure } {
    global GidPriv
    lappend ::GidPriv(procedures_after_source_plugins) $procedure
}

proc AfterSourcePlugins { } {
    global GidPriv
    if { [info exists GidPriv(procedures_after_source_plugins)] } {
        foreach procedure $GidPriv(procedures_after_source_plugins) {
            {*}[subst $procedure]
        }
    }
}


#args are the command line arguments argv
proc GiD_BeforeMainLoopDo { args } {

    if { [info exists ::GID_LOGIN] && !$::GID_LOGIN_HIDE } {
        if { [GiD_Login is_logged] } {
            set program gid
            set main_version [GidUtils::GetGiDVersionMain]
            if { ![GiD_Login is_session $program $main_version] } {
                catch { GiD_Login start_session $program $main_version } error_code
            }
        }
    }

    if { [info exists ::GID_GROUPS] } {
        InitGroups
    }   
      
    # disable UpdateTopMenus
    GiDMenu::DisableUpdateMenus
    #recursivelly source all .tcl files inside the plugins folder

    source [file join $::GIDDEFAULT scripts gid_plugin_mesh.tcl] ;#to define class GiDMeshVariables before be used by plugins

    SourcePlugins [file join $::GIDDEFAULT plugins]
    #read additional preferences of possible mesher objects defined in plugins
    set filename_preferences [file rootname [GiD_GetUserSettingsFilename]].preferences
    GiD_RaiseEvent PluginMeshVariablesClass_ReadObjects $filename_preferences "PREFERENCES"
    
    #preferences dom was created before source plugins, and doesn't has its changes applied (e.g. add Granular as sphere mesher)
    #PluginPreferencesProcs_Eval [CreateWidgetsFromXml::GetPreferencesXml] ;#comment it because else now Granular appear twice

    AfterSourcePlugins

    #check if used -p problemtype <pt> or -e Data Defaults problemtype <pt>
    #to not reload the last model if it has a different problemtype
    set previousproblemtype ""
    if { [llength $args] > 0 } {
        #check if try to load a problemtype
        set pos [lsearch $args "-p"]
        if { $pos != -1 } {
            set previousproblemtype [lindex $args [expr $pos+1]]
        }
        set pos [lsearch $args "-e"]
        if { $pos != -1 } {
            set pos2 [lsearch [string tolower [lrange $args [expr $pos+1] end]] "problemtype"]
            if { $pos2 != -1 } {
                set previousproblemtype [lindex $args [expr $pos+$pos2+2]]
            }
        }
    }

    ReloadLastModel $previousproblemtype

    if { [info exists ::GID_LOGIN] && !$::GID_LOGIN_HIDE } {
        if { $::GID_ENABLE_DATAMANAGER != 0 } {
            GidDataManager::registerDataManagerEvents
        }
        Login::ReadTokenFromFile
    }
    
    if { [info commands configure_program_proc] ne "" } {
        uplevel #0 configure_program_proc
    }
    
    
    if { $::tcl_platform(platform) == "windows" } {
        #avoid wrong menu images with Windows animation effects
        GiD_SetMenuAnimation 0
    }
    #GidUtils::SetWarnLine [_ "Ready"]        

    # enable back UpdateTopMenus
    GiDMenu::EnableUpdateMenus
    GiDMenu::UpdateMenus

    if { [GiD_Set ShowCheckNewVersion] } {
        ShowCheckNewVersion
    }
}

proc getToplevelWindows {{w .}} {
    set res [list]
    if {[winfo toplevel $w] eq $w} {
        if { [ winfo viewable $w]} {
            lappend res $w
        }
    }
    foreach ww [winfo children $w] {
        lappend res {*}[getToplevelWindows $ww]
    }
    return $res
}

proc repositionWindowOverGiD { w } {
    if { ![ winfo exists $w]} {
        return
    }
    set wtop .gid
    if { ![ winfo exists $wtop]} {
        set top_lst [ getToplevelWindows]
        if { [ llength $top_lst] != 0} {
            set wtop [ lindex $top_lst 0]
        } else {
            return
        }
    }
    if { [ winfo exists $wtop] } {
        set gid_geom [ wm geometry $wtop]
        # to check if we could do the regexp's
        set gid_x -1
        if { ![regexp {^([0-9]*)x([0-9]*)([-+]*[0-9]*)([-+]*[0-9]*)$} $gid_geom dummy gid_width gid_height gid_x gid_y] } {
            if { [regexp {([-+]*[0-9]*)([-+]+[0-9]*)$} $gid_geom dummy gid_x gid_y] } {
                set gid_width 100
                set gid_height 100
            }
        }
        if { $gid_x != -1} {
            # set w_geom [ wm geometry $w]
            # if { ![regexp {^([0-9]*)x([0-9]*)([-+]*[0-9]*)([-+]*[0-9]*)$} $w_geom dummy w_width w_height w_x w_y] } {
            #     set w_width 100
            #     set w_height 100
            # }
            # we can not ask for bgerror geometry because it is still not realized, will provide a dummy width and height
            # set w_width 314
            # set w_height 122
            set w_width 300
            set w_height 85
            set new_x [ expr int( $gid_x + ( $gid_width - $w_width) * 0.5)]
            set new_y [ expr int( $gid_y + ( $gid_height - $w_height) * 0.5)]
            # wm withdraw $w
            wm geometry $w +${new_x}+${new_y}
            # wm deiconify $w
        }
    }
    raise $w
}

# the first time ::tk::dialog::error::bgerror is called it does 
# 'namespace import ::tk::dialog::error::bgerror'
# so that our bgerror is overwritten
# to avoid this, we define bgerror_gid to overwrite 
# the previous namespace import

# this way we avoid to modify standard script tk/bgerror.tcl

proc bgerror_gid { err {flag 1}} {
    #avoid disabled graphics    
    if { [info commands .gid.central.s] ne "" } {
        foreach i [list windows graphinput graphics warnline] {
            GiD_Project set disable_$i 0
        }
    }
    # scripts/tk/bgerror.tcl creates a toplevel window called .bgerrorDialog
    # after some delay, let's position it at the center of gid's main window
    after 100 [ list repositionWindowOverGiD .bgerrorDialog]
    ::tk::dialog::error::bgerror $err $flag
    if { [string trim [info body bgerror]] != {bgerror_gid $err $flag}} {
        # source of tk has redefined bgerror, define again as we want
        proc bgerror { err {flag 1} } {
            # to swallow the return -code break inside  ::tk::dialog::error::bgerror
            foreach txt [ list $err] {
                bgerror_gid $err $flag
            }
        }
    }
}

proc bgerror { err0 {flag0 1} } {
    ::tk::dialog::error::bgerror $err0 $flag0
    return [ bgerror_gid $err0 $flag0]
}

#unknown is a copy of init.tcl but including translation (maybe can be also be enhanced)

proc __unknown args {
    global auto_noexec auto_noload env unknown_pending tcl_interactive
    global errorCode errorInfo

    # If the command word has the form "namespace inscope ns cmd"
    # then concatenate its arguments onto the end and evaluate it.

    set cmd [lindex $args 0]
    if {[regexp "^:*namespace\[ \t\n\]+inscope" $cmd] && [llength $cmd] == 4} {
        set arglist [lrange $args 1 end]
        set ret [catch {uplevel 1 ::$cmd $arglist} result]
        if {$ret == 0} {
            return $result
        } else {
            return -code $ret -errorcode $errorCode $result
        }
    }

    # Save the values of errorCode and errorInfo variables, since they
    # may get modified if caught errors occur below.  The variables will
    # be restored just before re-executing the missing command.

    # Safety check in case something unsets the variables
    # ::errorInfo or ::errorCode.  [Bug 1063707]
    if {![info exists errorCode]} {
        set errorCode ""
    }
    if {![info exists errorInfo]} {
        set errorInfo ""
    }
    set savedErrorCode $errorCode
    set savedErrorInfo $errorInfo
    set name [lindex $args 0]
    if {![info exists auto_noload]} {
        #
        # Make sure we're not trying to load the same proc twice.
        #
        if {[info exists unknown_pending($name)]} {
            return -code error [_ "self-referential recursion in 'unknown' for command '%s'" $name];
        }
        set unknown_pending($name) pending;
        set ret [catch {auto_load $name [uplevel 1 {::namespace current}]} msg]
        unset unknown_pending($name);
        if {$ret != 0} {
            append errorInfo [concat "\n    (" [_ "autoloading"] "'$name')"]
            return -code $ret -errorcode $errorCode -errorinfo $errorInfo $msg
        }
        if {![array size unknown_pending]} {
            unset unknown_pending
        }
        if {$msg} {
            set errorCode $savedErrorCode
            set errorInfo $savedErrorInfo
            set code [catch {uplevel 1 $args} msg]
            if {$code ==  1} {
                #
                # Compute stack trace contribution from the [uplevel].
                # Note the dependence on how Tcl_AddErrorInfo, etc.
                # construct the stack trace.
                #
                set cinfo $args
                set ellipsis ""
                while {[string bytelength $cinfo] > 150} {
                    set cinfo [string range $cinfo 0 end-1]
                    set ellipsis "..."
                }
                append cinfo $ellipsis [concat "\"\n    (" [_ "'uplevel' body line 1"] ")"]
                append cinfo [concat "\n    " [_ "invoked from within"]]
                append cinfo [concat "\n\"" [_ "uplevel"] " 1 \$args\""]
                #
                # Try each possible form of the stack trace
                # and trim the extra contribution from the matching case
                #
                set expect [concat "$msg\n    " [_ "while executing"] "\n\"$cinfo"]
                if {$errorInfo eq $expect} {
                    #
                    # The stack has only the eval from the expanded command
                    # Do not generate any stack trace here.
                    #
                    return -code error -errorcode $errorCode $msg
                }
                #
                # Stack trace is nested, trim off just the contribution
                # from the extra "eval" of $args due to the "catch" above.
                #
                set expect [concat "\n    " [_ "invoked from within"] "\n\"$cinfo"]
                set exlen [string length $expect]
                set eilen [string length $errorInfo]
                set i [expr {$eilen - $exlen - 1}]
                set einfo [string range $errorInfo 0 $i]
                #
                # For now verify that $errorInfo consists of what we are about
                # to return plus what we expected to trim off.
                #
                if {$errorInfo ne "$einfo$expect"} {
                    error [_ "Tcl bug: unexpected stack trace in 'unknown'"] {} \
                        [list CORE UNKNOWN BADTRACE $expect $errorInfo]
                }
                return -code error -errorcode $errorCode \
                    -errorinfo $einfo $msg
            } else {
                return -code $code $msg
            }
        }
    }

    if {([info level] == 1) && [string equal [info script] ""] \
            && [info exists tcl_interactive] && $tcl_interactive} {
        if {![info exists auto_noexec]} {
            set new [auto_execok $name]
            if {$new != ""} {
                set errorCode $savedErrorCode
                set errorInfo $savedErrorInfo
                set redir ""
                if {[string equal [info commands console] ""]} {
                    set redir ">&@stdout <@stdin"
                }
                return [uplevel 1 exec $redir $new [lrange $args 1 end]]
            }
        }
        set errorCode $savedErrorCode
        set errorInfo $savedErrorInfo
        if {[string equal $name "!!"]} {
            set newcmd [history event]
        } elseif {[regexp {^!(.+)$} $name dummy event]} {
            set newcmd [history event $event]
        } elseif {[regexp {^\^([^^]*)\^([^^]*)\^?$} $name dummy old new]} {
            set newcmd [history event -1]
            catch {regsub -all -- $old $newcmd $new newcmd}
        }
        if {[info exists newcmd]} {
            tclLog $newcmd
            history change $newcmd 0
            return [uplevel 1 $newcmd]
        }

        set ret [catch {set candidates [info commands $name*]} msg]
        if {[string equal $name "::"]} {
            set name ""
        }
        if {$ret != 0} {
            return -code $ret -errorcode $errorCode \
                [concat [_ "error in unknown while checking if '%s' is a unique command abbreviation" $name] ":\n$msg"]
        }
        # Filter out bogus matches when $name contained
        # a glob-special char [Bug 946952]
        set cmds [list]
        foreach x $candidates {
            if {[string range $x 0 [expr [string length $name]-1]] eq $name} {
                lappend cmds $x
            }
        }
        if {[llength $cmds] == 1} {
            return [uplevel 1 [lreplace $args 0 0 $cmds]]
        }
        if {[llength $cmds]} {
            if {[string equal $name ""]} {
                return -code error [concat [_ "empty command name"] " ''"]
            } else {
                return -code error \
                    [concat [_ "ambiguous command name"] " '$name': [lsort $cmds]"]
            }
        }
    }
    return -code error [concat [_ "invalid command name"] " '$name'"]
}

proc OpenNotes { } {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    package require texteditor
    
    set filename ""
    if  { [GidUtils::ModelHasName] } {     
        set modelname [GiD_Info Project ModelName]         
        set filename [file join $modelname.gid [file tail $modelname].txt]
    }
    set w .gid.texteditor
    if { $filename != "" } {
        if { [gid_filesystem::file exists $filename] } {
            TextEditor::Create $filename "" "" 1 $w utf-8
        } else {
            TextEditor::Create "" "" "" 1 $w utf-8
            set TextEditor::currentfile $filename ;#to save with this name
            wm title $w $filename
        }
    } else {
        TextEditor::Create "" "" "" 1 $w utf-8
        TextEditor::ReadFromVariable
        set TextEditor::cansavetovariable 1 ;#to temporary store in a tcl variable
    }
}

proc CloseNotes { } {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    GidUtils::CloseWindow NOTES
}

proc GetNotes { } {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    set txt ""
    if { [info exists TextEditor::vartosave] && $TextEditor::vartosave != "" } {
        set txt $TextEditor::vartosave
    } else {        
        if  { [GidUtils::ModelHasName] } {
            set modelname [GiD_Info Project ModelName]           
            set filename [file join $modelname.gid [file tail $modelname].txt]
            if { [gid_filesystem::file exists $filename] } {
                set txt [gid_filesystem::read_file $filename "" 0]               
            }
        }
    }
    return $txt
}

proc SetNotes { txt } {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    package require texteditor
    set TextEditor::vartosave $txt
    GiD_ModifiedFileFlag set 1
}

proc AreNotesVisible { } {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    set w .gid.texteditor
    if { [winfo exists $w] } {
        return 1
    } else {
        return 0
    }
}

proc OpenConsole {} {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    package require tkcon
    tkcon show
}
proc CloseConsole {} {
    if { [GidUtils::IsTkDisabled] } {
        return
    }
    tkcon close
}

proc RecursiveChangeState {w {what "restore"}} {
    if { ![winfo exists $w] } return
    set class [winfo class $w]
    if { [lsearch -sorted {ComboBox} $class] != -1 } {
        #it is not necessary recurse its childs 
    } else {
        foreach i [winfo children $w] {
            RecursiveChangeState $i $what
        }    
    }
    if { [lsearch -sorted {Frame Gidscale Menu NoteBook Panedwindow Scrollbar TFrame TLabelframe TScale Toplevel Tree} $class] != -1 } {
        #Tree really has -state, but its child canvas has been changed just before, and implicilty changed Tree state also
        #then it is and error store its previous state, because was just changed
    } else {
        set fail [catch {
                if {$what eq "restore"} {
                    if { [info exists ::Gid_ChangeState($w)] } {
                        $w configure -state $::Gid_ChangeState($w)
                    }
                } else {
                    set ::Gid_ChangeState($w) [$w cget -state]
                    $w configure -state $what
                }
            } msg]
        if { $fail } {
            #WarnWinText "FAIL $w [winfo class $w] $msg"
        }
    }
}

proc FinishButton { w win text endaction disable {small 0} } {
    if { ![winfo exists $w] } {
        return
    }
    if { $small } {
        if { [winfo exists $w] && [winfo class $w] != "Toplevel" } {
            set small 0
        }
    }

    if { $small } {
        set w2 .gid.finish
        if { [winfo exists $w2] } {
            destroy $w2
        }
        toplevel $w2
        wm transient $w2 .gid
        # if { $::tcl_platform(platform) == "windows" } {
        #     AddAlwaysOnTopFlag $w2
        # }
        wm title $w2 [wm title $w]
        scan [wm geometry $w] "%dx%d+%d+%d" width height x y
        if { ![regexp {[+]} $x] } { set x +$x}
        if { ![regexp {[+]} $y] } { set y +$y}
        wm geometry $w2 $x$y
        wm protocol $w2 WM_DELETE_WINDOW [list EndFinishButton $w $endaction $small]
        wm minsize $w2 50 25
        if { [winfo exists $w2.finf] } {
            destroy $w2.finf
        }
        ttk::frame $w2.finf -style ridge.TFrame -borderwidth 2
        ttk::button $w2.finf.f -text [_ "Finish"] \
            -command [list EndFinishButton $w $endaction $small]
        ttk::label $w2.finf.l -text $text
        grid $w2.finf.f $w2.finf.l -sticky ew -padx 2
        #grid configure $w2.finf.f -sticky w
        grid columnconf $w2.finf 1 -weight 1
        grid $w2.finf -sticky nsew -columnspan 2
        grid columnconf $w2 0 -weight 1
        grid rowconfig $w2 0 -weight 1
        wm withdraw $w
    } else {
        set w2 $w
        if { [winfo exists $w2.finf] } {
            destroy $w2.finf
        }
        ttk::frame $w2.finf
        ttk::button $w2.finf.f -text [_ "Finish"] \
            -command [list EndFinishButton $w $endaction $small]
        ttk::label $w2.finf.l -text $text
        pack $w.finf.f $w.finf.l -side left -padx 16 -pady 4
        set rely 0.8
        # if { [ esMac]} {
            # set rely 1.0
        # }
        if { $win != ""} {
            # when layers window is inside gid, then win == "", no finishbutton
            place $w2.finf -in $win -x 0 -rely $rely -anchor sw -bordermode outside
        }
        if { $disable == "disableall" } {
            RecursiveChangeState $w disabled
        }
        $w2.finf.f configure -state normal
    }
    if { ![ esMac]} {
        focus $w2.finf.f
    } else {
        focus .gid
    }

    bind $w2 <Escape> [list EndFinishButton $w $endaction $small]
    bind $w2 <Return> [list EndFinishButton $w $endaction $small]
    delayedop changefunc [list EndFinishButton $w $endaction $small]
}

proc EndFinishButton { w endaction small } {
    set found [delayedop -cancel changefunc "$w.finf.f invoke"]
    GiD_Process Mescape

    if { $small } {
        set w2 .gid.finish
        if { [winfo exists $w2] } {
            scan [wm geometry $w2] "%dx%d+%d+%d" width height x y
            if { ![regexp {[+]} $x] } { set x +$x}
            if { ![regexp {[+]} $y] } { set y +$y}
            destroy $w2
            wm geometry $w $x$y
        }
        wm deiconify $w
    } else {
        destroy $w.finf
        RecursiveChangeState $w restore
        array unset ::Gid_ChangeState
    }
    if { $endaction != "" } { eval $endaction }
}


#to centralize this name, because change between platforms, and also if menu is outside
#i index 0 ... n
proc GetMenuName { i } {
    if { [GiD_Set Theme(MenuType)] == "native" } {
        if { [winfo toplevel .gid.menu] == ".gid" } {
            set menuname .mm1.button$i
        } else {
            set menuname .gid.menu.mm1.button$i
        }
    } else {
        # use "generic" menus
        set menuname .gid.menu.button$i.m.m
    }
    return $menuname
}

proc WatchBitmaps {name index op} {
    if {$index eq "PrePostBitmapsWindowGeom"}  {
        WarnWinText $::GidPriv($index)
    }
}

#define this functions here instead Layers.tcl because can be used before source Layers.tcl
proc CreateLayerCombo { w } {
    global GidPriv

    ttk::frame $w.f -borderwidth 0 -style ForcedFrame   
    ttk::entry $w.e -cursor arrow -style ForcedCombobox  
    
    bind $w.e <Enter> {
        %W state pressed 
    }
    bind $w.e <Leave> {
        %W state !pressed 
    }
        
    grid $w.f -sticky ew
    grid $w.e -in $w.f -sticky ew
    grid rowconfigure $w 0 -weight 1
    
    bind $w.e <ButtonPress-1> "[list open_layers_as_menu .gid $w.f]; break"
    bind $w.e <ButtonRelease-1> "break"
    bind $w.e <KeyPress> "break"
    bind $w.e <Key-Down> "[list open_layers_as_menu .gid $w.f]; break"

    set GidPriv(ComboLayers,entry) $w.e    
    $w.e insert end [ GiD_Info Project LayerToUse]
    return
}

proc set_layers_menu_size { tbl w {x ""} {y ""} } {
    set width 2
    foreach c [$tbl column list] {
        incr width [$tbl column neededwidth $c]
    }
    
    set nrows [$tbl item count]
    if { ![$tbl cget -showroot] } {
        incr nrows -1
    }
    if { $nrows > 25 } {
        set nrows 25
        incr width 17 ;#for vertical scrollbar, to avoid horizontal one
    }
    #-----
    #dangerous depends on ttk theme
    set headerheight 12
    #-----
    set itemheight [$tbl cget -itemheight]
    set height [expr {$headerheight+($nrows+1)*$itemheight+2}]
    
    if { $x != ""  && $y != "" } {
        wm geometry $w ${width}x${height}+${x}+$y
    } else {
        wm geometry $w ${width}x${height}
    }
}

proc open_layers_as_menu { parent open_over } {
    global GidPriv

    set w $parent.m
    if { [winfo exists $w] } {
        destroy $w
        return
    }
    set w [toplevel $parent.m -borderwidth 1 -relief raised]

    wm withdraw $w
    wm overrideredirect $w 1
    set orient "horizontal"
    if { $orient == "vertical" } {
        set x [expr {[winfo rootx $open_over]+[winfo width $open_over]}]
        set y [expr {[winfo rooty $open_over]}]
    } else {
        set x [expr {[winfo rootx $open_over]}]
        set y [expr {[winfo rooty $open_over]+[winfo height $open_over]}]
    }

    ttk::frame $w.gg
    set tbl [Layers::LayersCreateListWin $w.gg]
    set GidPriv(ComboLayers,table) $tbl

    Layers::FillTableInfoLayers $tbl
    
    set_layers_menu_size $tbl $w $x $y

    focus $tbl
    Layers::SetLayerAsSelection $tbl [ GiD_Info Project LayerToUse]

    bind $tbl <Double-Button-1> "+after idle destroy $w"

    bind $w <Destroy> [list +DestroyComboLayers %W $w]

    grid $w.gg - -sticky nsew -pady 0
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1   
    bind $w <Escape> [list destroy $w]
    bind $w <1> [list _layers_destroy_if_outside $w %X %Y]
    
    update idletasks
    wm deiconify $w
    # raise this is needed before grab otherwise in Mac OS X
    # toplevel will be deiconified behind gid and
    # grab will put it on front and in the centre of the screen
    raise $w
    update
    if { ![winfo exists $w] } { return }
    grab $w.gg
}

proc DestroyComboLayers { W w } {
    if { $W == $w } {
        unset -nocomplain ::GidPriv(ComboLayers,table)
    }
}

proc _layers_destroy_if_outside { w x y } {
    if { ![winfo exists $w] } { return }
    if { $x < [winfo rootx $w] || $x > [winfo rootx $w]+[winfo width $w] || \
             $y < [winfo rooty $w] || $y > [winfo rooty $w]+[winfo height $w] } {
        open_layers_as_menu [winfo parent $w] [winfo parent $w]
    }
}

proc PostGraphCoordinates { w } {
    set MenuEntriesP(5,10,0) [list [_ "Cartesian#C#menu"] [_ "Polar#C#menu"]]
    set MenuCommandsP(5,10,0) [list \
                                   [ list GiD_Process Mescape Results Graphs OptionsGraph CoordType Cartesian ] \
                                   [ list GiD_Process Mescape Results Graphs OptionsGraph CoordType Polar]]

    set lst_img [ list [ IconoCoordCart] [ IconoCoordPolar]]

    #set lst_img [ list  $::GidPriv(VerifNoImage) $::GidPriv(VerifNoImage)]

    $w delete 0 end
    set idx 0
    set UnderLineList {}
    foreach label $MenuEntriesP(5,10,0) comando $MenuCommandsP(5,10,0) img $lst_img {
        set under [FindUnderChar label UnderLineList]
        if { [ info exists MenuEntriesP(5,10,0,$idx)]} {
            set m $w.mm$idx
            if { ![ winfo exists $w.mm$idx]} {
                menu $m
            }
            $w add cascade -label $label -underline $under -image $img -compound left \
                -menu $m
            regsub -all {%W} $comando $m cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $m configure -postcommand $cmd
        } else {
            regsub -all {%W} $comando $w cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $w add command -label $label -underline $under -image $img -compound left \
                -command $cmd
        }
        incr idx
    }

}

proc PostGraphModelView { w } {
    set MenuEntriesP(5,10,0) [list [_ "Show#C#menu"] [_ "Size#C#menu"]]
    set MenuCommandsP(5,10,0) [list \
                                   [ list GiD_Process Mescape Results Graphs OptionsGraph ShowModelView Show ] \
                                   [ list GiD_Process Mescape Results Graphs OptionsGraph ShowModelView ModelViewSize ]]

    set lst_img [ list [ IconoModelView] $::GidPriv(VerifNoImage)]

    $w delete 0 end
    set idx 0
    set UnderLineList {}
    foreach label $MenuEntriesP(5,10,0) comando $MenuCommandsP(5,10,0) img $lst_img {
        set under [FindUnderChar label UnderLineList]
        if { [ info exists MenuEntriesP(5,10,0,$idx)]} {
            set m $w.mm$idx
            if { ![ winfo exists $w.mm$idx]} {
                menu $m
            }
            $w add cascade -label $label -underline $under -image $img -compound left \
                -menu $m
            regsub -all {%W} $comando $m cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $m configure -postcommand $cmd
        } else {
            regsub -all {%W} $comando $w cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $w add command -label $label -underline $under -image $img -compound left \
                -command $cmd
        }
        incr idx
    }

}

proc PostGraphXAxis { w } {
    set MenuEntriesP(5,10,15) [list [_ "Reset#C#menu"] [_ "Set min value#C#menu"] [_ "Set max value#C#menu"] [_ "Set divisions#C#menu"] [_ "Set label#C#menu"] [_ "Set Logarithmic Scale#C#menu"]]
    set MenuCommandsP(5,10,15) [list \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph X_Axis Reset ] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph X_Axis SetMin] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph X_Axis SetMax] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph X_Axis SetDivisions] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph X_Axis SetLabel] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph X_Axis SetLog]]


    set lst_img [ list $::GidPriv(VerifNoImage) $::GidPriv(VerifNoImage) \
                      $::GidPriv(VerifNoImage) $::GidPriv(VerifNoImage) \
                      $::GidPriv(VerifNoImage) \
                      [ IconoScaleResultLogarithmicGraphX]]

    $w delete 0 end
    set idx 0
    set UnderLineList {}
    foreach label $MenuEntriesP(5,10,15) comando $MenuCommandsP(5,10,15) img $lst_img {
        set under [FindUnderChar label UnderLineList]
        if { [ info exists MenuEntriesP(5,10,15,$idx)]} {
            set m $w.mm$idx
            if { ![ winfo exists $w.mm$idx]} {
                menu $m
            }
            $w add cascade -label $label -underline $under -image $img -compound left \
                -menu $m
            regsub -all {%W} $comando $m cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $m configure -postcommand $cmd
        } else {
            regsub -all {%W} $comando $w cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $w add command -label $label -underline $under -image $img -compound left \
                -command $cmd
        }
        incr idx
    }


}

proc PostGraphYAxis { w } {
    set MenuEntriesP(5,10,16) [list [_ "Reset#C#menu"] [_ "Set min value#C#menu"] [_ "Set max value#C#menu"] [_ "Set divisions#C#menu"] [_ "Set label#C#menu"] [_ "Set Logarithmic Scale#C#menu"]]
    set MenuCommandsP(5,10,16) [list \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph Y_Axis Reset ] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph Y_Axis SetMin] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph Y_Axis SetMax] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph Y_Axis SetDivisions] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph Y_Axis SetLabel] \
                                    [ list GiD_Process Mescape Results Graphs OptionsGraph Y_Axis SetLog]]

    set lst_img [ list $::GidPriv(VerifNoImage) $::GidPriv(VerifNoImage) \
                      $::GidPriv(VerifNoImage) $::GidPriv(VerifNoImage) \
                      $::GidPriv(VerifNoImage) \
                      [ IconoScaleResultLogarithmicGraphY]]

    $w delete 0 end
    set idx 0
    set UnderLineList {}
    foreach label $MenuEntriesP(5,10,16) comando $MenuCommandsP(5,10,16) img $lst_img {
        set under [FindUnderChar label UnderLineList]
        if { [ info exists MenuEntriesP(5,10,16,$idx)]} {
            set m $w.mm$idx
            if { ![ winfo exists $w.mm$idx]} {
                menu $m
            }
            $w add cascade -label $label -underline $under -image $img -compound left \
                -menu $m
            regsub -all {%W} $comando $m cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $m configure -postcommand $cmd
        } else {
            regsub -all {%W} $comando $w cmd
            regsub -all {%I} $cmd $idx cmd
            regsub -all {%X} $cmd [ winfo pointerx .gid] cmd
            regsub -all {%Y} $cmd [ winfo pointery .gid] cmd
            $w add command -label $label -underline $under -image $img -compound left \
                -command $cmd
        }
        incr idx
    }
}

proc UpdatePostProcessInformation { } {
    # set err 1
    # set err [ 
    #              catch { 
    #                  if { [ esMac]} {
    #                      doUpdateMenusMac
    #                  }
    #              }
    #             ]

    if { [ GidUtils::IsTkDisabled]} {
        return
    }

    FillPDInfo
    FillPRInfo
    FillPGInfo
    PostAnimateGetResultVisualizationState
    MeshGroupTBLFill
    
    #reset graph window if it's open
    set w .gid.graphs
    if { [winfo exists $w] } {
      destroy $w
      after idle [list PostGraphs::Create $w ]
    }

    # update
    # update idletasks
    # if { $err} {
    #         # como hay un after XXX por ahi para cambiar menus y windows de pre a post, 
    #         # toca tambien hacerlo aqui
    #         after 1000 doUpdateMenusMac
    # }
    if { [ esMac]} {
        after 500 doUpdateMenusMac
    }
}


proc IconoScaleResultLogarithmicGraphX { } {
    array set options [ GiD_Info postprocess get scale_result_options]

    set img $::GidPriv(VerifNoImage)
    if { $options(UseLogScaleGraphX)} {
        set img $::GidPriv(VerifImage)
    }
    return $img
}

proc IconoScaleResultLogarithmicGraphY { } {
    array set options [ GiD_Info postprocess get scale_result_options]

    set img $::GidPriv(VerifNoImage)
    if { $options(UseLogScaleGraphY)} {
        set img $::GidPriv(VerifImage)
    }
    return $img
}

proc IconoCoordCart { } {
    set options [ GiD_Info postprocess get graphs_option CoordType]
    set img $::GidPriv(VerifNoImage)
    if { $options eq "Cartesian"} {
        set img $::GidPriv(VerifImage)
    }
    return $img
}

proc IconoCoordPolar { } {
    set options [ GiD_Info postprocess get graphs_option CoordType]
    set img $::GidPriv(VerifNoImage)
    if { $options eq "Polar"} {
        set img $::GidPriv(VerifImage)
    }
    return $img
}

proc IconoModelView { } {
    set options [ GiD_Info postprocess get graphs_option ShowModelView]
    set img $::GidPriv(VerifNoImage)
    if { $options eq "Yes"} {
        set img $::GidPriv(VerifImage)
    }
    return $img
}

proc FilesOpenPostAllFormats { filename } { 
    if { ![gid_filesystem::file exists $filename] } {
        return
    }
    set ext [string tolower [file extension $filename]]
    if { $ext  == ".res" || $ext  == ".msh" || $ext  == ".bin" || $ext  == ".lst"} {
        set is_hdf5_gid_post 0
        if { $ext  == ".res" } {
            set is_hdf5_gid_post [gid_filesystem::is_gid_post $filename]
        } 
        # if { $is_hdf5_gid_post } {          
        #     set res [GiDPost::ReadPost $filename]
        #     lassign $res num_meshes num_results num_graphs
        #     GidUtils::SetWarnLine [concat [_ "Read %d meshes and %d results %d graphs" $num_meshes $num_results $num_graphs] " (HDF5 format)"]
        # } else {
        # now GiD handles HDF5 GiD Post files internaly
        GiD_Process Mescape Files Read {*}[BrowserExtraGetPostBinaryRead] $filename
        # }
    } elseif { $ext == ".h5" } {
        set num_results 0

        set is_hdf5_gid_post [gid_filesystem::is_gid_post $filename]
        if { $is_hdf5_gid_post } {
            # set res [gid_filesystem::read_gid_post $filename]
            # lassign $res num_meshes num_results num_graphs
            # GidUtils::SetWarnLine [concat [_ "Read %d meshes and %d results %d graphs" $num_meshes $num_results $num_graphs] " (HDF5 format)"]
            GiD_Process Mescape Files Read {*}[BrowserExtraGetPostBinaryRead] $filename
        } elseif { [info procs Amelet::IsAmelet] != "" && [Amelet::IsAmelet $filename] } {
            set res [Amelet::ReadPost $filename]
            lassign $res num_meshes num_results num_graphs
            GidUtils::SetWarnLine [concat [_ "Read %d meshes and %d results %d graphs" $num_meshes $num_results $num_graphs] " (Amelet format)"]
            # This code below is only needed with Amelet
            if { $num_results > 0 } {
                #set the first analysis and step to use
                set analysis_to_use [lindex [GiD_Info postprocess get all_analysis] 0]
                set step_to_use [lindex [GiD_Info postprocess get all_steps $analysis_to_use] 0]
                GiD_Process Mescape Results AnalysisSel $analysis_to_use $step_to_use escape
            } elseif { $num_graphs > 0 } {
                GiD_Graph show
            }
        }
    }   
}

proc FilesOpenPostAllFormatsWin { } {        
    set types [list \
                   [list [_ "GiD postprocess"] ".res .msh .bin .h5 .lst"] \
                   [list [_ "All files"] "*"] \
                  ]
    set filename [MessageBoxGetFilename postfile read [_ "Postprocess Read"] "" $types "" 0 \
                      [ list {Postprocess read options} BrowserExtraCreatePostBinaryRead BrowserExtraGetPostBinaryRead] ]
    if { $filename != "" } {
        FilesOpenPostAllFormats $filename        
    }
}

proc FilesOpenPostMultipleWin { } {    
    set types [list \
                   [list [_ "GiD postprocess"] ".res .msh .bin .h5 .lst"] \
                   [list [_ "All files"] "*"] \
                  ]    
    set filenames [MessageBoxGetFilename postfile read [_ "Postprocess read several files"] "" $types "" 1 \
                       [ list {Postprocess read options} BrowserExtraCreatePostBinaryRead BrowserExtraGetPostBinaryRead] ]
    if { $filenames != "" } {
        FilesOpenPostMultiple $filenames         
    }
}

proc FilesOpenPostMultiple { filenames } {
    if { [llength $filenames] == 1 } {
        FilesOpenPostAllFormats [lindex $filenames 0]
    } else {
        GiD_Process Mescape Files ReadMultiple [BrowserExtraGetPostBinaryRead] $filenames        
    }
}

proc ReadView { filename } {
    if { [file exists $filename] } {     
        after idle [list GiD_Process 'ReadView $filename]
    }
}

catch {
    GidTkBackCompatibility ;#repeat again, else "tkGenerateMenuSelect" dissapear!!
}


proc ShowMeshingParameters { w } {
    #first define variable manager:
    proc ::VariableManager_MeshingParametersModel { operation var {value ""} } {
        switch $operation {
            "GetValue" {
                return [GiD_Set -meshing_parameters_model $var]
            }
            "GetDefaultValue" {
                return [GiD_Set -meshing_parameters_model -default $var]
            }
            "SetValue" {
                return [GiD_Set -meshing_parameters_model $var $value]
            }
        }    
    }
    #create dinamically xml needed
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    dom createDocument rootmeshing
    set document [dom parse [$root asXML]]
    set rootmeshing [$document documentElement]
    set findnode [$rootmeshing find "name" "meshing"]
    if { $findnode != "" } {
        set parentnode [$findnode parentNode]
        foreach child [$parentnode  childNodes] {
            if { $child != $findnode } {
                $child delete
            }
        }
    } else {
        # WarnWinText "Not possible to find name meshing from $root"
    }
    
    if { [$findnode hasAttribute variable ] } {
        set var [$findnode getAttribute variable]
        $findnode setAttribute variablemanager VariableManager_MeshingParametersModel
    }
    while { $findnode != NULL } {
        if { [$findnode hasChildNodes] } {
            set findnode [$findnode firstChild ]
        } else {
            set aux [$findnode nextSibling ]  
            while { $aux == NULL } {
                set aux [$findnode parentNode]
                if { $aux == NULL } { break }        
                set aux [$aux nextSibling ]
            }
            set findnode $aux
        }
    }  
    foreach child [$findnode childNodes] {
        
    }
    CreateWidgetsFromXml::SetXml Meshing.xml $rootmeshing    
    #after openwindow: 
    CreateWidgetsFromXml::ReadXmlFile Meshing.xml
}



#commands to access to toolbars similar to the GiDMenu:: ones
#proc HideVolumeFromToolbars must use in the future this GiDToolbar:: procedures when available
#but are under construction...
namespace eval GiDToolbar {
}

#now asumed toolbar_name_untranslated the "Geometry & View bar", but in the future can handle more bars
proc GiDToolbar::RemoveOption {toolbar_name_untranslated option_name_untranslated prepost {translationfunc _}} {
    WarnWin "GiDToolbar::RemoveOption Under construction..."
    if {$prepost!="PRE" && $prepost!="POST" && $prepost!="PREPOST"} {
        WarnWin [_ "Wrong arg. Must be PRE, POST or PREPOST."]
        return 1
    }

    if {$prepost eq "PRE"} {
        set where [list "" "PRE"]
    } elseif {$prepost eq "POST"} {
        set where [list "P" "POST"]
    } else {
        set where [list "" "PRE" "P" "POST"]
    }
    foreach {c desc} $where {
        if { $toolbar_name_untranslate == "Geometry & View bar" } {
            upvar \#0 BitMapsNames$c BitMapsNames
            upvar \#0 BitMapsCommands$c BitMapsCommands
            upvar \#0 BitmapsHelp$c BitmapsHelp            
        } else {
            WarnWin [_ "ERROR: Toolbar %s doesn't exist in %s." $toolbar_name_untranslated $desc]
            return 1
        }
        set index [ GiDToolbar::_FindOptionIndex BitMapsNames $option_name_untranslated]
        if { $index == -1 } {
            return 1
        }
        set i [join [lrange [split $index ,] 0 end-1] ,]
        set position [lindex [split $index ,] end]
        
        #must rename index
        #GiDToolbar::del_submenus $i $position $desc
        #GiDToolbar::move_submenus $i $position $desc "up"
        set BitMapsNames($i)  [lreplace $BitMapsNames($i) $position $position ]
        set BitMapsCommands($i) [lreplace $BitMapsCommands($i) $position $position]
        set BitmapsHelp($i) [lreplace $BitmapsHelp($i) $position $position]        
    }
    return 0
}


proc GiDToolbar::_FindOptionIndex { BitMapsNames nameslist} {
    WarnWin "GiDToolbar::_FindOptionIndex Under construction..."
    upvar \#0 $BitMapsNames TranslatedEntries
    
    set index 0
    foreach suboption $nameslist {
        set found 0
        set cont 0
        if { ![info exists TranslatedEntries($index)] } {
            return -1
        }
        if { [string range $suboption 0 2] == "---" } {
            set nseparator [string range $suboption 3 end]
            set suboption "---"
            set iseparator 0
        }
        foreach item $TranslatedEntries($index) {
            if { $item == $suboption } {
                if { $suboption == "---" } {
                    if { $iseparator == $nseparator} {
                        append index ,$cont
                        set found 1
                        break
                    }
                    incr iseparator
                } else {
                    append index ,$cont
                    set found 1
                    break
                }
            }
            incr cont
        }
        if { !$found } {
            return -1
        }
    }
    return $index
}

proc SaveBottomEntryFrameContents {} {
    set bottom_entry_list .gid.comm.fwarn.list
    if { [ winfo exists $bottom_entry_list] } {
        set ::GidPriv(FullScreen,ListboxContents) [ $bottom_entry_list get 0 end]
    }
}

proc RestoreBottomEntryFrameContents {} {
    set bottom_entry_list .gid.comm.fwarn.list

    if { [ info exists ::GidPriv(FullScreen,ListboxContents)] && 
         [ winfo exists $bottom_entry_list]} {
        foreach line $::GidPriv(FullScreen,ListboxContents) {
            $bottom_entry_list insert end $line
        }
        $bottom_entry_list see end
        set ::uparrow [ $bottom_entry_list size]
    }
}

proc ShowFullScreenMenu { x y} {
    # removed ( $x < 16) &&
    # to show the menu if mouse nears the top 16 pixels margin
    if { ( $y < 16)} {
        GiDShowContextualMenu $x $y        
    } else {
        if { $::FullScreen(Old,MainWindowMotion) != ""} {
            regsub -all {%x} $::FullScreen(Old,MainWindowMotion) $x script
            regsub -all {%y} $scripts $y scripts
            eval $scripts
        }
    }
}

proc SwitchFullScreen { { right_button_menu_label ""}} {
    global ToolbarsPriv

    if { ![ info exists ::GidPriv(FullScreen)]} {
        set ::GidPriv(FullScreen) 0
    }
 
    if { ![info exists ::ToolbarsPriv(toolbars)] } {
        TOInitializeToolbars
    }
   
    update

    # save contents of bottom entry:
    SaveBottomEntryFrameContents

    if { !$::GidPriv(FullScreen)} {
        set ::FullScreen(Old,MainWindow) [ wm state .gid]
        set ::FullScreen(Old,MainWindowGeom) [ wm geometry .gid]
        set ::FullScreen(Old,MainWindowMotion) [ bind .gid <Motion>]
        set ::FullScreen(Old,MainWindowF11) [bind .gid <F11>] ;#e.g. contain .gid.menu.button1.m.m invoke 23 ; break

        # if { $::tcl_platform(os) != Linux} {
        #     wm state .gid zoomed
        #     wm overrideredirect .gid 1
        # } else {
        # }
        foreach tb $ToolbarsPriv(toolbars) {
            set geomname [lindex $tb 1]
            if { [info exists ::GidPriv($geomname)] } {
                set ::FullScreen(Old,$geomname) $::GidPriv($geomname)
            } else {                
                set ::FullScreen(Old,$geomname) ""
            }
        }       
        foreach tb $ToolbarsPriv(toolbars) {
            set proc_and_arguments [lindex $tb 2]
            set proc_name [lindex $proc_and_arguments 0]
            if { [info procs $proc_name] == "" } {
                W "SwitchFullScreen: proc $proc_name doesn't exists"
            } else {
                {*}$proc_and_arguments NONE
            }
        }       
        wm attributes .gid -fullscreen 1
        
        bind .gid <Motion> "ShowFullScreenMenu %x %y"
        bind .gid <F11> SwitchFullScreen ;#to avoid error calling .gid.menu.button1.m.m that doesn't exists, invoke directly its procedure!!

        set ::GidPriv(FullScreen) 1                
    } else {
        set new_st normal
        if { [ info exists ::FullScreen(Old,MainWindow)]} {
            set new_st $::FullScreen(Old,MainWindow)
        }
        # wm overrideredirect .gid 0 
        # wm state .gid $new_st       
        foreach tb $ToolbarsPriv(toolbars) {
            set geomname [lindex $tb 1]     
            set type [lindex $::FullScreen(Old,$geomname) 0]
            set proc_and_arguments [lindex $tb 2]
            set proc_name [lindex $proc_and_arguments 0]
            if { [info procs $proc_name] == "" } {
                W "SwitchFullScreen: proc $proc_name doesn't exists"
            } else {
              {*}$proc_and_arguments $type
            }
        }        
        wm attributes .gid -fullscreen 0
        bind .gid <Motion> $::FullScreen(Old,MainWindowMotion)
        bind .gid <F11> $::FullScreen(Old,MainWindowF11)
        set ::GidPriv(FullScreen) 0
    }
        
    update

    # save contents of bottom entry:
    RestoreBottomEntryFrameContents
}

proc SwitchFastDraw { w } {
    if { [GiD_Set FastRotation(Active)] } {
        set next_mode 0
        set next_icon "fastmode_on.png"
    } else { 
        set next_mode 1
        set next_icon "fastmode_off.png"
    }
    GiD_Set FastRotation(Active) $next_mode
    if { $w != "" } {
        $w configure -image [gid_themes::GetImage $next_icon toolbar]
    }
    GiD_Redraw
}

proc TranslateResultName { txt_in } {   
    set txt_out [list]
    foreach part_in [GidUtils::Split $txt_in //] {
        lappend txt_out [TranslateResultName_SinglePart $part_in]
    }
    set txt_out [join $txt_out //]
    return $txt_out
}


proc TranslateResultComponentName { txt_in } {  
    set txt_out [TranslateResultName_SinglePart $txt_in]
    if { $txt_in == $txt_out } {
        #try to translate mofidied versions
        set txt_in_prefix [string range $txt_in 0 1]
        foreach prefix {X- Y- Z-} {
            if { $txt_in_prefix == $prefix } {
                return $prefix[TranslateResultName_SinglePart [string range $txt_in 2 end]]
            }
        }
        if { [string index $txt_in 0] == "|" && [string index $txt_in end] == "|" } {
            return |[TranslateResultName_SinglePart [string range $txt_in 1 end-1]]|;
        }
    }
    return $txt_out
}


#translation of results is ambiguous, becase we don't know if the original name (with associated translation)
#has spaces or underlines, because both are converted to underlines for internal command use!! 
#if one does nothing try the other option
proc TranslateResultName_SinglePart { txt_in } {       
    set txt_out [TranslateResultName_OriginalWithSpaces $txt_in]
    if { $txt_in == $txt_out } {
        set txt_out [TranslateResultName_OriginalWithUnderlines $txt_in]
    }
    return $txt_out
}

#first replace underlines to recover the original and then translate
proc TranslateResultName_OriginalWithSpaces { txt_in } {   
    regsub -all {_} $txt_in { } txt_out
    return [= $txt_out]
}

#first translate and then replace underlines to be shown as spaces
proc TranslateResultName_OriginalWithUnderlines { txt_in } {      
    regsub -all {_} [= $txt_in] { } txt_out  
    return $txt_out
}

#to enable/disable groups: in C must #define GID_GROUPS, then ::GID_GROUPS is set to 1
if { [info exists ::GID_GROUPS] } {
    proc InitGroups  { } {
        package require customLib

        gid_groups_conds::init_package
        
        if { ![GidUtils::IsTkDisabled] } {
            AddGroupsToMenu
            GiDMenu::UpdateMenus
            GiD_RegisterPluginAddedMenuProc AddGroupsToMenu ;#to repeat when re-creating menus
        }
    }
        
    proc AddGroupsToMenu { } {
        set position [GiDMenu::GetOptionIndex Utilities [list "Layers"] PRE]
        if { $position == -1 } {
            set position end
        }      
        GiDMenu::InsertOption Utilities [list [_ "Groups"]...] $position PRE "gid_groups_conds::open_groups .gid window" "" "" insertafter _
        #remove from Data menu
        GidChangeDataLabel "Local axes" ""
        
        if { $position != "end" } {
            incr position
        }        
        #GiDMenu::InsertOption Utilities [list [_ "Local axes"]...] $position PRE "gid_groups_conds::local_axes_window" "" "" insertafter _
        GiDMenu::InsertOption Utilities [list [_ "Local axes"]] $position PRE [list -np- gid_groups_conds::local_axes_menu %W] "" "" insertafter _
    }
}

#this function is really now only used invoked from C for the gid logo variable...
namespace eval GidPrivVariables {
    variable single_names {LogosGiDBitmapName LogosGiDBitmapName32}   
    #single case like LogosGiDBitmapName stored as GidPriv(LogosGiDBitmapName)
    variable array_names {ColumnVisible}
    #array case like ColumnVisible(Layers,visible) stored as GidPriv(ColumnVisible,Layers,$item)
}

#get the internal key (key of GidPriv array) from the external name (printed in .ini and used with GiD_Set)
proc GidPrivVariables::GetInternalKey { name } {
    variable single_names
    variable array_names
    if { [lsearch $single_names $name] != -1 } {
        set internal_key $name
    } elseif { [string index $name end] == ")" } {
        set pos [string first "(" $name]
        if { $pos != -1 } {
            set array_name [string range $name 0 $pos-1]
            if { [lsearch $array_names $array_name] != -1 } {
                set array_subkey [string range $name $pos+1 end-1]
                set internal_key $array_name,$array_subkey
            }
        } else {
            set internal_key ""
        }
    } else {
        set internal_key ""
    }
    return $internal_key
}

proc GidPrivVariables::Get { name } {
    global GidPriv
    set internal_key [GidPrivVariables::GetInternalKey $name]
    if { $internal_key == "" } {
        error [_ "variable '%s' not found" $name]
    } else {
        if { [info exists ::GidPriv($internal_key)] } {
            set value $::GidPriv($internal_key)
        } else {
            set value [GidPrivVariables::GetDefault $name]
        }
        if { $name == "LogosGiDBitmapName" || $name == "LogosGiDBitmapName32"} {           
            if { [file pathtype $value] == "relative" } {
                set value [file join $::GIDDEFAULT resources textures $value]
            }
        }
    }
    return $value
}

proc GidPrivVariables::GetDefault { name } {
    global GidPriv
    set internal_key [GidPrivVariables::GetInternalKey $name]
    if { $internal_key == "" } {
        error [_ "variable '%s' not found" $name]
    } else {
        if { $name == "LogosGiDBitmapName" } {
            set value GiDlogo.png
        } elseif { $name == "LogosGiDBitmapName32"} {
            set value GiDlogo32.png 
        } elseif { [string match ColumnVisible(*) $name] } {
            set value 1
        } else {       
            error [_ "variable '%s' not found" $name]
        }
    }
    return $value
}

proc GidPrivVariables::Set  { name value } {
    global GidPriv
    set internal_key [GidPrivVariables::GetInternalKey $name]
    if { $internal_key == "" } {
        error [_ "variable '%s' not found" $name]
    } else {
        if { $name == "LogosGiDBitmapName" || $name == "LogosGiDBitmapName32" } {
            if { [file pathtype $value] == "relative" } {
                set full_filename [file join $::GIDDEFAULT resources textures $value]
            } else {
                set full_filename $value
            }
            if { [file exists $full_filename] } {
                set ::GidPriv($internal_key) $value
            } else {
                error [_ "File '%s' not found" $full_filename]
            }
        } else {
            set ::GidPriv($internal_key) $value
        }
    }
    return $value
}

proc GetPreferencesPath { variableorname value } {    
    #returns a list containing information of {{window name} {groups path} {labelframe path} {label of $value} {command to access}} 
    #each element (except command) its ready to show to final user, you can show all or just some of theme    
    set root [CreateWidgetsFromXml::GetPreferencesXml]
    return [CreateWidgetsFromXml::FindUniqueAttribute $variableorname $root $value]    
} 

proc TreeSelectColumnsVisibility { tree category column_items } {   
    if { ![winfo exists $tree] } {
        return
    }
    set i_column 0
    foreach item $column_items {        
        if { ![info exists ::GidPriv(ColumnVisible,$category,$item)] } {
            set ::GidPriv(ColumnVisible,$category,$item) 1
        }
        $tree column configure $i_column -visible $::GidPriv(ColumnVisible,$category,$item)
        incr i_column
    }
}

proc TableListSelectColumnsVisibility { tablelist category column_items } {
    if { ![winfo exists $tablelist] } {
        return
    }
    set i_column 0
    foreach item $column_items {        
        if { ![info exists ::GidPriv(ColumnVisible,$category,$item)] } {
            set ::GidPriv(ColumnVisible,$category,$item) 1
        }
        if { $::GidPriv(ColumnVisible,$category,$item) } {
            set hide 0
        } else {
            set hide 1
        }
        $tablelist columnconfigure $i_column -hide $hide
        incr i_column
    }
}

proc CreateLowerButtonsApplyClose { w apply_cmd } {
    #add lower buttons
    ttk::frame $w.buts -style BottomFrame.TFrame
    ttk::button $w.buts.apply -text [_ "Apply"] -command $apply_cmd -style BottomFrame.TButton
    ttk::button $w.buts.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton
    grid $w.buts.apply $w.buts.close -sticky ew -padx 5 -pady 6
    grid $w.buts -sticky ews -pady {2 0}
    grid anchor $w.buts center
    bind $w <Alt-c> [list $w.buts.close invoke]
    bind $w <Escape> [list $w.buts.close invoke]
    bind $w <Return> [list $w.buts.apply invoke]
}

proc CreateResultFromEmbeddedDistance { } {
    lassign [GiD_Info Mesh EmbeddedDistances] node_ids distances
    if { [objarray length $node_ids] } {
        # For the case of multiple meshes (i.e. meshes can change along analysis)
        # this result will be defined using the mesh of the last step of the analysis
        # until the final correction: define mesh from pre-process along with this new results
        # despite user providing mesh for post-process.
        # ? may be a preference to pass the embedded distance to post is needed ?
        set result_name Distance
        set analysis_name "Signed distance"
        set time_step 1
        set type Scalar
        set over OnNodes
        set result [list Result $result_name $analysis_name $time_step $type $over]        
        set values [list]
        lappend values $distances
        GiD_Result create -array $result [list $node_ids $values]

        # select analysis and step value, if not already selected (by a readed results file)
        GiD_Project set disable_warnline 1
        set cur_analysis [GiD_Info postprocess get cur_analysis]
        if { $cur_analysis == ""} {
            GiD_Process Mescape Results AnalysisSel $analysis_name $time_step
        }
        GiD_Project set disable_warnline 0
    }
}
