#to start gid_helpviewer to show a .hmtl file sourcing this file in tclsh
proc open_helpviewer { {filename {}} } {
    package require gid_helpviewer
    #wm withdraw .
    if { [file pathtype $filename] == "relative" } {
        if { [::msgcat::mclocale] != "" } {
            #instead for example "es_es_modern", return only "es"
            set lan [string range [::msgcat::mclocale] 0 1]
        } else {
            set lan en
        }
        set gid_dir [file dirname [file dirname $::argv0]]
        set full_filename [file join $gid_dir info $lan $filename]
        if { ![file exists $full_filename] } {
            set lan en
            set full_filename [file join $gid_dir info $lan $filename]
        }
    }
    GiDHelpViewer::Show $full_filename -title $filename -try "" -report 0 -base . -tab tree
}

open_helpviewer [lindex $::argv 0]
