package require snit
package require Tk

snit::widget gidscale {
    component scale -inherit 1
    component button0
    component button1
    component label
    component frame
    
    variable extVariable 0
    
    option -orient -configuremethod SetOrient -cgetmethod GetOrient -default h  
    option -variable -configuremethod SetVariable -cgetmethod GetVariable
    option -resolution -configuremethod SetResolution -cgetmethod GetResolution -default 1
    option -from -configuremethod SetFrom -cgetmethod GetFrom -default 0
    option -to -configuremethod SetTo -cgetmethod GetTo -default 1 
    option -showvalue -configuremethod SetShowValue -cgetmethod GetShowValue -default 1  
    option -command -configuremethod SetCommand -cgetmethod GetCommand  
    option -state -configuremethod SetState -cgetmethod GetState
    option -showbuttons -configuremethod SetShowButtons -cgetmethod GetShowButtons -default 1
    option -symbolbuttons -configuremethod SetSymbolButtons -cgetmethod GetSymbolButtons -default [ list - +]
    
    variable theVariable 0
    variable forcedWrite 0
    variable disablefixvariable 0
    constructor { args } {    
        
        #we don't send resolution
        #we redefine variable, from, to
        install scale using ttk::scale $win.scale -variable [ myvar theVariable ]
        
        set sym_0 [ lindex $options(-symbolbuttons) 0]
        set sym_1 [ lindex $options(-symbolbuttons) 1]
        
        install button0 using ttk::button $win.button0 -text $sym_0 \
            -width 1 -command [ mymethod OnMinus ]
        
        install button1 using ttk::button $win.button1 -text $sym_1 \
            -width 1 -command [ mymethod OnPlus ]
        
        install frame using ttk::frame $win.frame
        
        install label using ttk::label $win.label -text {} -anchor ne \
            -width 3
        
        #$self SetOrient orient h    
        $self SetResolution resolution 1
        $self SetVariable variable [myvar extVariable]
        #$self SetFrom {from 0.0}
        #$self SetTo {to 1.0}
        #$self SetShowValue {showvalue 1}
        
        set disablefixvariable 1 ;#trick to avoid invoke FixVariable before parse -from and -to
        #                          else a value outside [0,1] is forced to this interval!!
        $self configurelist $args
        set disablefixvariable 0
        $self FixVariable
        
        
        $self GridComponents    
        
        uplevel #0 trace add variable [ myvar theVariable ] write [ list [ mymethod OnInternalWrite ] ]
        
        #set all bindings of ttk::scale to the parent, but invoking scale
        #not binding <ButtonRelease-3> <B3-Motion> <Button-3> <ButtonRelease-2> <B2-Motion> <Button-2> <ButtonRelease-1> <B1-Motion> <Button-1> problems                
        foreach b { <Key-End> <Key-Home> \
            <Control-Key-Down> <Control-Key-Right> <Control-Key-Up> <Control-Key-Left> \
                <Key-Down> <Key-Right> <Key-Up> <Key-Left> } {
            bind $self $b [string map [list %W $scale] [bind TScale $b]]
            foreach child [winfo children $self] {
                bind $child $b [string map [list %W $scale] [bind TScale $b]]
            }
        }
        
        # Add missing bindings
        foreach key [ list <Left> <Down> <minus> ] {
            bind $self $key [ list $win.button0 invoke]
            foreach child [winfo children $self] {
                bind $child $key [ list $win.button0 invoke]
            }
        }
        foreach key [ list <Right> <Up> <plus> ] {
            bind $self $key [ list $win.button1 invoke]
            foreach child [winfo children $self] {
                bind $child $key [ list $win.button1 invoke]
            }
        }
    }
    
    destructor {
        $self ClearTrace
    }
    
    method get { args } {
        #if args empty return current value variable
        #if x,y is specify, return value of coords x,y 
        set returnvalue [ $self FromInternalToExternal [$scale get {*}$args] ]
        return [lindex $returnvalue 1]
    }
    
    method set { o } {
        uplevel #0 set $options(-variable) $o        
    }
    
    method SetVariable { o v } {
        # limpiar al trace previo antes
        $self ClearTrace
        set options(-variable) $v
        
        if { ![uplevel #0 info exists $v ] } {
            set theVariable 0
        } else {
            set x [uplevel #0 set $v ]
            if { $x=="" } {                
                set x $options(-from)
            }
            set theVariable [ expr { ( $x - $options(-from) ) / $options(-resolution) } ]
            $self FixVariable
        }
        
        #not use text variable  uplevel #0 $label configure -textvariable $v
        
        uplevel #0 trace add variable $options(-variable) write [ list [ mymethod OnExternalWrite ] ]
    }
    
    method ClearTrace { } {
        if { $options(-variable) ne "" } {
            uplevel #0 trace remove variable $options(-variable) write [ list [ mymethod OnExternalWrite ] ]
        }
    }
    
    method OnExternalWrite { args } {
        if { $forcedWrite == 0 } {            
            set forcedWrite 1
            set v [ uplevel #0 set $options(-variable) ]   
            if { $v=="" } {
                set forcedWrite 0
                return
            }
            set theVariable [ expr { ( $v - $options(-from) ) / $options(-resolution) } ]
            
            $self FixVariable      
            set forcedWrite 0
        }
        $self PlaceLabel 
    }
    
    method OnInternalWrite { args } {
        if { $forcedWrite == 0 } {
            set forcedWrite 1
            $self FixVariable      
            set forcedWrite 0
        }
    }
    
    method PlaceLabel { } {  
        if { $options(-showvalue) } {
            place forget $label
            set a [$scale coords $theVariable]        
            if { [string index [ $win cget -orient ] 0] eq "h" } {  
                #center label depending of lenght of label - [$label cget -width] * 4          
                place $label -in $frame -x [expr {[lindex $a 0] - [$label cget -width] * 4 } ] -y 0
            } else {
                #center label using aproximate height of label -10
                place $label -in $frame -x 0 -y [expr {[lindex $a 1] - 10} ]
            }
            set lbl_txt [ uplevel #0 set $options(-variable) ]
            # $label configure -text [ format %.3g $lbl_txt]
            $label configure -text $lbl_txt
        }    
    }
    
    method FixVariable { } {
        if { !$disablefixvariable } {        
            set returnvalue [ $self FromInternalToExternal $theVariable ]
            
            set theVariable [lindex $returnvalue 0]
            uplevel #0 set $options(-variable) [lindex $returnvalue 1]
        }
    }
    
    method GetPrintableString { value } {
        return [ format %.6g $value]
    }
    
    method FromInternalToExternal { v } {    
        set internalvalue [expr { round( $v ) } ]
        if { $internalvalue < 0 } {
            set internalvalue 0
        } elseif { $internalvalue > [ $scale cget -to ] } {
            set internalvalue [ $scale cget -to ]
        }
        set p [ $self GetRequiredPrecision ]
        if { $p < 0 } {
            set p 0
        }
        set externalvalue [ format "%.${p}f" [ expr { $options(-from) +  $options(-resolution) * $internalvalue } ] ]
        # Why not use a more human readable form like this:
        set externalvalue [ $self GetPrintableString [ expr { $options(-from) +  $options(-resolution) * $internalvalue } ] ]
        return [list $internalvalue $externalvalue]
    }
    
    method GetRequiredPrecision { } {
        # this seems to be the number of decimals for format %.Xf 
        set decimals [ expr { int(ceil( -log10( $options(-resolution) ) )) } ] 
        if { $decimals < 2} {
            set decimals 2
        }
        return $decimals
    }
    
    method GetVariable { o } {
        return $options(-variable)
    }
    
    method SetResolution { o v } {
        if { $v <= 0 } {
            #wrong resolution value
            return
        }
        set options(-resolution) $v
        $self UpdateScaleParameters
    }
    
    method GetResolution { o } {
        return $options(-resolution)
    }
    
    method OnMinus { } {
        set v [ $scale get ]
        $scale set [ expr { $v - 1 } ]
    }
    
    method OnPlus { } {
        set v [ $scale get ]
        $scale set [ expr { $v + 1 } ]
    }
    
    method SetFrom { o v } {  
        set options(-from) $v
        $self UpdateScaleParameters
    }
    method GetFrom { o } {
        return $options(-from)
    }
    
    method SetTo { o v } {
        set options(-to) $v    
        $self UpdateScaleParameters
    }
    
    method GetTo { o } {
        return $options(-to)
    }
    method SetShowValue { o v } {
        set options(-showvalue) $v        
    }
    method GetShowValue { o } {
        return $options(-showvalue)
    }
    method SetShowButtons { o v } {
        set options(-showbuttons) $v        
    }
    method GetShowButtons { o } {
        return $options(-showbuttons)
    }
    method SetSymbolButtons { o v } {
        if { [ llength $v] == 2} {
            set options(-symbolbuttons) $v        
        }
    }
    method GetSymbolButtons { o } {
        return $options(-symbolbuttons)
    }
    
    
    method SetOrient { o v } {
        set result [ $scale configure -orient $v ]
        if { $v ne "" && [ llength [ grid info $scale ] ] } {
            $self GridComponents
        }
        return $result
    }
    
    method GetOrient { o } {
        return [ $scale cget -orient ]
    }
    
    method SetCommand { o v } {
        $scale configure -command [mymethod TransformOutput $v]
    }
    method TransformOutput {v valor} {
        #not use valor, better use get of gidscale that update all variables automatically 
        uplevel #0 $v [ $win get ]
    }
    method GetCommand { o } {    
        return [lindex [$scale cget -command] 3]
    } 
    
    method SetState { o v } {
        #coments ttk::scale:
        #for disable use: $scale state disabled
        #for enable use:  $scale state !disabled
        if { $v == "normal" || $v == "enabled" } {
            set v !disabled
        }
        $scale state $v
        $button0 configure -state $v
        $button1 configure -state $v
        #don't have state $frame configure -state $v
        $label configure -state $v
    }
    method GetState { o } {    
        return [$scale cget -state]
    }
    
    
    method UpdateScaleParameters { } {
        set intervals [ expr { ( $options(-to) - $options(-from) ) / double( $options(-resolution) ) } ]
        #if { $intervals < 0 } {
            #    set aux $options(-to)
            #    set options(-to) $options(-from)
            #    set options(-from) $aux
            #    set intervals [ expr { ( $options(-to) - $options(-from) ) / double( $options(-resolution) ) } ]
            #    #error "from option smaller than to"
            #}
        if { $intervals < 0 } {         
            $scale configure -from $intervals -to 0                        
        } else {
            $scale configure -from 0 -to $intervals                        
        }
        # Wrong to use int() to get width of entry, for big from/to values, max 1e+9
        # set width [ expr { \
            #         max( [ string length [expr { int($options(-to)) }] ] \
                #         , [string length [expr { int($options(-from)) }] ] ) \
                #         + [$self GetRequiredPrecision] +1 \
                #     } ]
        set str_from [ $self GetPrintableString $options(-from)]
        set str_to [ $self GetPrintableString $options(-to)]
        set width [ expr \
                max( [ string length $str_from], \
                [ string length $str_to]) \
                + 2]
        $label configure -width $width
        $frame configure -width $width
    }
    
    method GridComponents { } {
        if { $options(-showbuttons) } {
            if { $options(-showvalue) } {
                if { [string index [ $win cget -orient ] 0] eq "h" } {
                    grid $frame -row 0 -column 1 -sticky ew -ipady 5
                    grid $button0 -row 1 -column 0 -sticky news
                    grid $scale   -row 1 -column 1 -sticky ew
                    grid $button1 -row 1 -column 2 -sticky news
                    grid columnconfigure $win 1 -weight 1
                    
                    #grid rowconfigure $win 0 -weight 1
                    #grid rowconfigure $win 3 -weight 1
                } else {
                    grid $button0 -row 0 -column 0 -sticky news
                    grid $scale   -row 1 -column 0 -sticky sn
                    grid $button1 -row 2 -column 0 -sticky news
                    grid $frame -row 1 -column 1 -sticky ns   
                    grid rowconfigure $win 1 -weight 1
                    
                    #grid columnconfigure $win 0 -weight 1 -minsize 0
                    #grid columnconfigure $win 3 -weight 1 -minsize 0       
                }                        
                bind $scale <Configure> "after idle [list $self PlaceLabel]"                                     
            } else {
                if { [string index [ $win cget -orient ] 0] eq "h" } {            
                    grid $button0 -row 0 -column 0 -sticky news
                    grid $scale   -row 0 -column 1 -sticky ew
                    grid $button1 -row 0 -column 2 -sticky news
                    grid columnconfigure $win 1 -weight 1
                    grid rowconfigure $win 1 -weight 1
                } else {
                    grid $button0 -row 0 -column 0 -sticky news
                    grid $scale   -row 1 -column 0 -sticky sn
                    grid $button1 -row 2 -column 0 -sticky news
                    grid rowconfigure $win 1 -weight 1
                    grid columnconfigure $win 1 -weight 1                
                }
            }
        } else {
            # !$options(-showbuttons)
            if { $options(-showvalue) } {
                if { [string index [ $win cget -orient ] 0] eq "h" } {
                    grid $frame -row 0 -column 0 -sticky ew -ipady 5
                    grid $scale   -row 1 -column 0 -sticky ew
                    grid columnconfigure $win 0 -weight 1
                    
                    #grid rowconfigure $win 0 -weight 1
                    #grid rowconfigure $win 3 -weight 1
                } else {
                    grid $scale   -row 0 -column 0 -sticky sn
                    grid $frame -row 0 -column 1 -sticky ns   
                    grid rowconfigure $win 0 -weight 1
                    
                    #grid columnconfigure $win 0 -weight 1 -minsize 0
                    #grid columnconfigure $win 3 -weight 1 -minsize 0       
                }                        
                bind $scale <Configure> "after idle [list $self PlaceLabel]"      
            } else {
                if { [string index [ $win cget -orient ] 0] eq "h" } {            
                    grid $scale   -row 0 -column 0 -sticky ew
                    grid columnconfigure $win 0 -weight 1
                    grid rowconfigure $win 1 -weight 1
                } else {
                    grid $scale   -row 0 -column 0 -sticky sn
                    grid rowconfigure $win 0 -weight 1
                    grid columnconfigure $win 1 -weight 1                
                }
            }
        }
        set sym_0 [ lindex $options(-symbolbuttons) 0]
        set sym_1 [ lindex $options(-symbolbuttons) 1]
        $button0 configure -text $sym_0
        $button1 configure -text $sym_1
    }  
}

# 1.0  initial version
# 1.01 added options:
#         -showbuttons display / hide the '-' and '+' buttons
#         -symbolbuttons to allow the user to change the '-' and '+' symbols, for instance to ++/--, </>, ^/v 
# 1.02 added bindings of Tscale to Gidscale (e.g. <Key-Left>)

package provide gidscale 1.02
