

proc RJSelByCriteria { mode } {
    global RJPriv

    switch $mode {
        MAKESELECTION {
            if { $RJPriv(SetTangency) } {
                set tan $RJPriv(tangencylimit)
            } else { set tan -1 }

            if { $RJPriv(SetLayers) } {
                if { $RJPriv(takecarelayers)== 0 } {
                    set layers "No"
                } else { set layers "Yes" }
                #set layers $RJPriv(takecarelayers)
            } else { set layers "No" }

            if { $RJPriv(SetCurvature) } {
                set curv $RJPriv(takecarecurvatures)
            } else {  set curv -1 }

            if { $RJPriv(SetSmaller) } {
                set small $RJPriv(smallsurfaces)
            } else {  set small -1  }
        
            GiD_Process Mescape Meshing AssignSkipByCriteria makeselection $tan $layers $curv $small
        }
        MODIFYSELECTION {
            GiD_Process Mescape Meshing AssignSkipByCriteria modselection
        }
        APPLYSKIPNOSKIPTOSELECTION {
            if { $RJPriv(skipnoskip)==-1 } {
                set sns "noskip"
            } elseif {$RJPriv(skipnoskip)==0} {
                set sns "autoskip"
            } elseif {$RJPriv(skipnoskip)==1} {
                set sns "skip"
            }
            GiD_Process Mescape Meshing AssignSkipByCriteria applyskipnoskip $sns
        }
        CLEARSELECTION {
            GiD_Process Mescape Meshing AssignSkipByCriteria clearselect
        }
    }

}

proc RJBegin { { w .gid.rjump_win } } {
    global RJPriv
    global GidPriv

    if { ![winfo exists $w] } {
        InitWindow2 $w -title [_ "Criteria to skip lines"] \
            -geometryvariable PreCriteriaSkipLinesWindowGeom \
            -initcommand RJBegin -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        
        if { ![info exists RJPriv(tangencylimit)] || $RJPriv(tangencylimit) == "" } {
            set RJPriv(tangencylimit) 10
        }
        if { ![info exists RJPriv(takecarelayers)] || $RJPriv(takecarelayers) == "" } {
            set RJPriv(takecarelayers) 0
        }
        if { ![info exists RJPriv(takecarecurvatures)] || $RJPriv(takecarecurvatures) == "" } {
            set RJPriv(takecarecurvatures) 100
        }
        if { ![info exists RJPriv(smallsurfaces)] || $RJPriv(smallsurfaces) == "" } {
            set RJPriv(smallsurfaces) 0
        }
        if { ![info exists RJPriv(skipnoskip)] || $RJPriv(skipnoskip) == "" } {
            set RJPriv(skipnoskip) 0
        }

        if { ![info exists RJPriv(SetTangency)] || $RJPriv(SetTangency) == "" } {
            set RJPriv(SetTangency) 0
        }
        if { ![info exists RJPriv(SetLayers)] || $RJPriv(SetLayers) == "" } {
            set RJPriv(SetLayers) 0
        }
        if { ![info exists RJPriv(SetCurvature)] || $RJPriv(SetCurvature) == "" } {
            set RJPriv(SetCurvature) 0
        }
        if { ![info exists RJPriv(SetSmaller)] || $RJPriv(SetSmaller) == "" } {
            set RJPriv(SetSmaller) 0
        }
        

        ttk::labelframe $w.frame#1 -text [_ "Selection criteria"]
                
        ttk::checkbutton $w.frame#1.checkbutton#1 \
            -text [_ "Tangency limit angle"] -variable RJPriv(SetTangency)
        ttk::entry $w.frame#1.ctangency -textvariable RJPriv(tangencylimit) -width 10
        GidHelp $w.frame#1.checkbutton#1 [_ "This value is the maximum angle between neighbour surfaces \
                normals (in contact line) to consider the shared line to be selected."]

        ttk::checkbutton $w.frame#1.checkbutton#2 \
            -text [_ "Take care layers"] -variable RJPriv(SetLayers)
        GidHelp $w.frame#1.checkbutton#2 [_ "Lines connected to surfaces which own to different layers are not \
                considered to be selected."]                
        
        ttk::labelframe $w.frame#1.curvatures -text [_ "Curvatures criteria"]
        ttk::checkbutton $w.frame#1.curvatures.checkbutton#3 \
            -text [_ "Take care curvatures"] -variable RJPriv(SetCurvature)
        
        ttk::label $w.frame#1.curvatures.label -text "[_ "Ratio"] :"
        
        if { ![info exists RJPriv(takecarecurvatures)] } {set RJPriv(takecarecurvatures) 0}
        
        ttk::label $w.frame#1.curvatures.value -textvariable RJPriv(takecarecurvatures)
        
        gidscale $w.frame#1.curvatures.scale#1 -showvalue 0\
           -orient horizontal -resolution 0.1 -from 0.0 -to 1.0 -variable RJPriv(takecarecurvatures)        
        
        GidHelp $w.frame#1.curvatures [_ "This ratio means the ratio between the curvatures of neighbour surfaces in \
                their contact line. If the ratio between their curvatures exceeds this value, the shared line is not \
                considered to be selected."]
        
        
        if { ![info exists RJPriv(SetSmaller)] } { set RJPriv(SetSmaller) 0 }
        ttk::checkbutton $w.frame#1.checkbutton#4 \
            -text [_ "Lines of surfaces smaller than"]: -variable RJPriv(SetSmaller)
        ttk::entry $w.frame#1.csmaller -textvariable RJPriv(smallsurfaces) -width 10
        GidHelp $w.frame#1.checkbutton#4 [_ "All the lines owning a surface that have some line smaller than this value \
                are considered to be selected."]

        ttk::frame $w.frame#1.selbuts
        ttk::button $w.frame#1.selbuts.select -text [_ "Select by criteria"] -command \
            "RJSelByCriteria MAKESELECTION ; $w.buts.apply configure -state normal" -underline 0          
        ttk::button $w.frame#1.selbuts.modifysel -text [_ "Modify selection"] -command \
            "RJSelByCriteria MODIFYSELECTION ; $w.buts.apply configure -state normal" -underline 0          
        
        
        ttk::frame $w.frame#2
        ttk::radiobutton $w.frame#2.radiobutton#1 \
            -text [_ "Skip"] \
            -variable RJPriv(skipnoskip) -value  1
        ttk::radiobutton $w.frame#2.radiobutton#2 \
            -text [_ "No skip"] \
            -variable RJPriv(skipnoskip) -value -1
        ttk::radiobutton $w.frame#2.radiobutton#3 \
            -text [_ "Automatic skip"] \
            -variable RJPriv(skipnoskip) -value 0
        
        ttk::frame $w.buts -style BottomFrame.TFrame
        ttk::button $w.buts.apply -text [_ "Apply"] -command \
            "RJSelByCriteria APPLYSKIPNOSKIPTOSELECTION " -underline 0 \
            -style BottomFrame.TButton \
            -state disabled           

        ttk::button $w.buts.cancel -text [_ "Cancel"] -command [list destroy $w] -style BottomFrame.TButton -underline 0
        

        bind $w.frame#1.ctangency <Return> "$w.frame#1.selbuts.select invoke"
        bind $w.frame#1.csmaller <Return> "$w.frame#1.selbuts.select invoke"
        
        grid $w.frame#1  -columnspan 3 -row 1 -column 1 -padx 2 -pady 2 -sticky nsew
        grid $w.frame#2 -row 2 -column 1 -padx 2 -pady 2 -sticky nsew
        grid $w.buts -row 3 -column 1 -columnspan 2 -sticky sew
        grid anchor $w.buts center
        grid $w.buts.apply -row 1 -column 1 -padx 5 -pady 5
        grid $w.buts.cancel -row 1 -column 2 -padx 5 -pady 5
        
        grid $w.frame#1.checkbutton#1 -row 1 -column 1 -padx 2 -pady 2 -sticky w
        grid $w.frame#1.ctangency -row 1 -column 2 -padx 2 -pady 2
        grid $w.frame#1.checkbutton#2 -row 2 -column 1 -padx 2 -pady 2 -sticky w

        grid columnconfigure $w.frame#1 1 -weight 1
        
        #grid $w.frame#1.checkbutton#3 -row 3 -column 1 -padx 2 -pady 2 -sticky w
        
        grid $w.frame#1.curvatures -columnspan 3 -padx 3 -pady 3 -row 4 -column 1 -sticky we
        
        grid $w.frame#1.curvatures.checkbutton#3 -column 1 -row 1 -columnspan 3 -padx 2 -pady 2 -sticky w
        grid $w.frame#1.curvatures.label -column 1 -row 2 -sticky nesw  -padx 2 -pady 2 
        grid $w.frame#1.curvatures.value -column 2 -row 2 -sticky nesw  -padx 2 -pady 2 
        grid $w.frame#1.curvatures.scale#1 -column 3 -row 2 -sticky nesw
        grid columnconfigure $w.frame#1.curvatures 3 -weight 1

        grid $w.frame#1.checkbutton#4  -row 5 -column 1 -padx 2 -pady 2  -sticky w
        grid $w.frame#1.csmaller -row 5 -column 2 -padx 2 -pady 2

        grid $w.frame#1.selbuts  -columnspan 2 -row 6 -column 1 -sticky nesw
        grid $w.frame#1.selbuts.select -row 1 -column 1 -padx 5 -pady 5
        grid $w.frame#1.selbuts.modifysel -row 1 -column 3 -padx 5 -pady 5
        grid columnconfigure $w.frame#1.selbuts 1 -weight 1
        
        grid $w.frame#2.radiobutton#1 -row 1 -column 1 -pady 2
        grid $w.frame#2.radiobutton#2 -row 1 -column 2 -pady 2
        grid $w.frame#2.radiobutton#3 -row 1 -column 3 -pady 2
        
        grid $w.buts.apply -row 1 -column 1
        grid $w.buts.cancel -row 1 -column 2
        
        grid rowconfigure $w 3 -weight 1 -minsize 40
        grid columnconfigure $w 1 -weight 1  -minsize 250

        bind $w <Alt-a> "$w.buts.apply invoke"               
	bind $w <Destroy> [list +DestroyRjumpWin %W $w] ;# + to add to previous script
    }
        
    focus $w.buts.apply
}


proc DestroyRjumpWin { W w } {
    if { $W != $w } return
    RJSelByCriteria CLEARSELECTION
}


